/******************************************************************************/
/* Device Description for SAMSON Positioner TROVIS SAFE 3793 HART capable     */
/******************************************************************************/
/* SAMSON AG - MESS- UND REGELTECHNIK                                         */
/* Weismllerstrae 3 - 60314 Frankfurt am Main - Germany                     */
/* Phone: +49 69 4009-0 - Fax: +49 69 4009-1507                               */
/* E-mail: samson@samson.de - Internet: www.samson.de                         */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2020). All Rights Reserved                       */
/* Device:        SAMSON Positioner TROVIS SAFE 3793 HART capable Dev Rev 1   */
/******************************************************************************/
/* Author: Thomas Kraemer / E36                                               */
/* File:   SAHA_TS3793_r1d1.ddl                                               */
/******************************************************************************/
/* Date:      Author: Comments:                                               */
/* -----      ------- ---------                                               */
/* 27.10.2016 kmr/E36 DD Version 1.1.001 erstellt                             */
/* 11.11.2019 kmr/E36 DD Rev 1.2.001 erstellt. nderungen:                    */
/*                    - Upload-/Downloadmen erstellt                         */
/*                    - Parameter log_all_classifications korrigiert          */
/*                      (Parameter, Lese-/Schreibbefehl)                      */
/*                    - einige Parameter Textnderungen (bersetzt)           */
/*                    - PST-/FST Grafiken implementiert                       */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

MANUFACTURER               66,   /* (66 = 42 hex) SAMSON AG, Frankfurt, Germany */
DEVICE_TYPE             17132,   /* Expanded device_type 0x42EC (0x42 = 66 + 0xEC = 236) Positioner TROVIS SAFE 3793 */
DEVICE_REVISION             1,   /* Device Revision 1 (FW 1.00) */
DD_REVISION                 2    /* Device Description Revision */

/* ------------------------------------------------------------------------ */
/* DD Versionsverwaltung:
   Hier die aktuelle DD Versionsnummer eintragen:
   Codierung:     [dev rev].[DD rev].[fortlaufende Versionsnummer]          */
/* ------------------------------------------------------------------------ */
#define DD_REVISION_TEXT	"|en|DD Revision: 1.2.001" "|de|DD Version: 1.2.001"
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Defines fr Auswahl TROVIS 3793 oder TROVIS SAFE 3793 */
/* ------------------------------------------------------------------------ */
#define FOR_TROVIS_SAFE_3793

#ifdef FOR_TROVIS_3793
  #undef FOR_TROVIS_3793
#endif
/* ------------------------------------------------------------------------ */

#include "macros.h"
#include "methods.h"

// PDM Diagnose:
#include "Diagnosis.inc"

/*****************************************
  Files to include:
*****************************************/
#include "42EC01_text_defines.dd"
#include "42EC01_defines.dd"
#include "42EC01_imports.dd"
#include "42EC01_dyn_var.dd"
#include "42EC01_methods.dd"

/* Parameter vom DD Generator: */
#include "42EC01_para_gen.dd"
/* Die DDGen Dateien mit den HART commands
   42EC01_cmd_read_gen.dd
   42EC01_cmd_write_gen.dd
   werden in 42EC01_hart_cmd.dd direkt in den commands includiert */

#include "42EC01_hart_cmd.dd"
#include "42EC01_graphs.dd"
#include "42EC01_pst.dd"
#include "42EC01_fst.dd"
#include "42EC01_histogram.dd"
#include "42EC01_logger.dd"
#include "42EC01_enh_menu.dd"
#include "42EC01_offline_menu.dd"

