/******************************************************************************/
/* Electronic Device Description EDD for SAMSON Positioner TROVIS 3730-3      */
/******************************************************************************/
/* SAMSON AG - MESS- UND REGELTECHNIK                                         */
/* Weismllerstrae 3 - 60314 Frankfurt am Main - Germany                     */
/* Phone: +49 69 4009-0 - Fax: +49 69 4009-1507                               */
/* E-mail: samson@samson.de - Internet: www.samson.de                         */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2018). All Rights Reserved                       */
/* Device:        SAMSON Positioner TROVIS 3730-3 Dev Rev 2 HART capable      */
/******************************************************************************/
/* Author: Thomas Krmer / E36                                                */
/* File:   SAHA_T3730_3_r2d1.ddl                                              */
/******************************************************************************/
/* Date:      Author: Comments:                                               */
/* -----      ------- ---------                                               */
/* 18.09.2018 kmr/E36 EDD Version 2.1.001 erstellt                            */
/* 28.03.2019 kmr/E36 EDD Version 2.1.002 erstellt                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/******************************************************************************/
/* Positioner TROVIS 3730-3 */
MANUFACTURER                    66,   /* (66 = 42 hex) SAMSON AG, Frankfurt, Germany */
DEVICE_TYPE                  17131,   /* Tok 8: _TROVIS_3730_3_EXP (0x42EB) / Tok 6: _TROVIS_3730_3 (0xEB) */
DEVICE_REVISION                  2,   /* Device Revision 1 (TROVIS 3730-3 FW 1.00) */
DD_REVISION                      1    /* Device Description Revision 1 */

/* ------------------------------------------------------------------------ */
/* DD Versionsverwaltung:
   Hier die aktuelle DD Versionsnummer eintragen:
   Codierung:     [dev rev].[DD rev].[fortlaufende Versionsnummer]          */
/* ------------------------------------------------------------------------ */
#define DD_REVISION_TEXT	"|en|DD Revision: 2.1.002" "|de|DD Version: 2.1.002"
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Defines fr Test im SDC, da sonst die Mens nicht angezeigt werden */
/* ------------------------------------------------------------------------ */
#define FOR_NORMAL_HOST
/* ------------------------------------------------------------------------ */

#include "macros.h"
#include "methods.h"

// PDM Diagnose:
#include "Diagnosis.inc"

/*****************************************
  Files to include:
*****************************************/
#include "42EB02_text_defines.dd"
#include "42EB02_defines.dd"
#include "42EB02_imports.dd"
#include "42EB02_dyn_var.dd"
#include "42EB02_methods.dd"

/* Parameter vom DD Generator: */
#include "42EB02_para_gen.dd"
/* Die DDGen Dateien mit den HART commands
   42EB02_cmd_read_gen.dd
   42EB02_cmd_write_gen.dd
   werden in 42EB02_hart_cmd.dd direkt in den commands includiert */

#include "42EB02_hart_cmd.dd"
#include "42EB02_graphs.dd"
#include "42EB02_pst.dd"
#include "42EB02_fst.dd"
#include "42EB02_histogram.dd"
#include "42EB02_logger.dd"
#include "42EB02_enh_menu.dd"

/* kmr: only for FDI and PDM: offline Menu / upload_from_device_root_menu / download_to_device_root_menu */
#include "42EB02_offline_menu.dd"

