/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2012). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 3730-4 Rev3      */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.02                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*              		Only for PDM 6 or higher                */
/*  $Revision:   	  1.0  $                                    */
/*  $Date:   		    06 January 2012 $        				*/
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 07.07.2011 Jung/E8 Erste Version für Rev3	          		*/
/* 06.01.2012 kmr/E82 Vervollständigung Rev3	          		*/
/* 23.03.2012 kmr/E82 3.1.001 erstellt                  		*/
/* 01.06.2012 kmr/E82 3.1.002 erstellt                  		*/
/*                    Aktuelle EBs implementiert                */
/* 07.01.2013 kmr/E86 3.1.003 erstellt                  		*/
/* 12.08.2013 kmr/E86 3.1.004/5 erstellt                 		*/
/*            Schreibreihenfolge in upload_variables geändert   */
/* 13.08.2013 kmr/E86 3.1.006 erstellt                 			*/
/*            Schreibreihenfolge in upload_variables geändert   */
/*            trans1_init_with_ref_test in upload_variables     */
/* 15.08.2013 kmr/E86 3.1.007 erstellt                 			*/
/*            Schreibreihenfolge in upload_variables optimiert  */
/*            Lesereihenfolge trans1_final_value_range_end geän.*/
/* xx.12.2016 kmr/E36 3.1.008 erstellt                 			*/
/*            read_phys_pb_view2 korrigiert                     */
/* 10.07.2018 kmr/E36 3.1.009 erstellt                 			*/
/*            read_phys_pb_view41 auskommentiert                */
/*            phys_diagnosis_ext_1_raw_0 ... 3 aus upload Liste */
/*            entfernt                                          */
/*            read_phys_cond_status_diag auskommentiert         */
/* 22.02.2021 kmr/E33 3.1.010-1 erstellt                 		*/
/*            COMMAND read_phys_pb_view2 auskommentiert         */
/*            COMMAND read_phys_cond_status_diag einkommentiert */
/* 03.03.2021 kmr/E33 3.1.010-2 erstellt                 		*/
/*            Reihenfolge in command read_phys_diagnosis_ext_1  */
/*            gedreht                                           */
/* 04.03.2021 kmr/E33 3.1.010-3 erstellt                 		*/
/*            alle Bits (0xF8) in phys_diag_ext_1_3 definiert   */
/* 04.03.2021 kmr/E33 3.1.010-4 erstellt                 		*/
/*            alle Bits (0xFF) in phys_diag_ext_1_3 definiert   */
/* 04.03.2021 kmr/E33 3.1.010 erstellt                          */
/* 07.12.2023 kmr/E33 3.1.011 erstellt                          */
/*            Para phys_pst_t_1_0 ff: no SCALING_FACTOR         */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/

/* ------------------------------------------------------------------------ */
MANUFACTURER         66,   /* SAMSON */
DEVICE_TYPE           4,   /* 3730-4 */
DEVICE_REVISION       3,   /* 1: 3730-4 bis K1.10, 2: 3730-4 ab K1.11 , 3: 3730-4 rev 3 ab K2.00 */
DD_REVISION           1
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* DD Versionsverwaltung */
/* ------------------------------------------------------------------------ */
/* hier die aktuelle DD Versionsnummer eintragen:
   ( Codierung: "[dev rev].[DD rev].[laufende Versionsnummer]" ) */

#define DD_REVISION_TEXT	"DD Revision: 3.1.011" "|de|DD Version: 3.1.011"

/* ------------------------------------------------------------------------ */


/********************************************************************************/
/* Includes                                                                     */
/********************************************************************************/

/********************************************************************************/
/* IdentCheck vor jeder Kommunikation:                                          */
/********************************************************************************/
// Identcheck will fail if the profile revision (phys_blk_profile_rev) is not identical to this value:
//#define 	CHECK_PROFILE_REV		   0x302
// Identcheck will fail if the manufacturer id (phys_man_id) is not identical to this value:
//#define 	DEFAULT_MANUFACTURER_ID	  66
// Identcheck will fail if the device type (phys_device_id) is not identical to this value:
//#define		CHECK_DEVICE_TYPE   "3730-4          "
// Identcheck will fail if the software revision (phys_software_rev) is not identical to this value:
// bei uns nicht verwendet, sonst nur eine FW möglich !
// #define   CHECK_SOFTWARE_VERSION "KT0.10  RT0.15  "

//#include "SIPAST.inc"
/********************************************************************************/

/* The color of bargraphs and gauges can be changed by setting the LINE_COLOR attribute of the SOURCE
(Possible values: BLACK, SILVER, GRAY, WHITE, MAROON, RED, ORANGE, PURPLE, FUCHSIA, GREEN, LIME, OLIVE, YELLOW, NAVY, BLUE, TEAL, AQUA).
The file "Macros.h" must be included because it contains the definition of the color names. */
#include "Macros.h"
	
#include "PA_Detect.inc"
#include "Diagnosis.inc"

#include "SAPA_ACEP_373X_4_Rev3_defines.dd"
#include "SAPA_ACEP_373X_4_Rev3_download_list.dd"
#include "SAPA_ACEP_373X_4_Rev3_upload_list.dd"
#include "SAPA_ACEP_373X_4_Rev3_AO.dd"
#include "SAPA_ACEP_373X_4_Rev3_PB.dd"
#include "SAPA_ACEP_373X_4_Rev3_DI1.dd"
#include "SAPA_ACEP_373X_4_Rev3_DI2.dd"
#include "SAPA_ACEP_373X_4_Rev3_DIAG.dd"
#include "SAPA_ACEP_373X_4_Rev3_dynamic_TEST.dd"
#include "SAPA_ACEP_373X_4_Rev3_MENU.dd"
#include "SAPA_ACEP_373X_4_Rev3_methods.dd"
#include "SAPA_ACEP_373X_4_Rev3_response_codes.dd"

VARIABLE    dummy_byte
{
    LABEL       "";
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

/******************************************************************************/
/*    Unit relations                                                          */
/******************************************************************************/
UNIT AO_PV_SCALE_UNIT
{
    func1_pv_unit:

    func1_pv_upper_range_value,
    func1_pv_lower_range_value,
    func1_readback_value,
    func1_rcas_in_value,
    func1_rcas_out_value,
    func1_fsafe_value,
    func1_simulate_value,
    func1_setpoint_value

}

UNIT AO_OUT_SCALE_UNIT
{
    func1_out_unit:

    trans1_feedback_value,
    func1_out_value,
    func1_out_upper_range_value,
    func1_out_lower_range_value,
    trans1_positioning_value
}

UNIT AO_FINAL_VALUE_RANGE_UNIT
{
   trans1_final_value_range_units:

   trans1_final_value_range_end,
   trans1_final_value_range_start,
   trans1_final_position_value__value,
   trans1_final_value__value
}


/******************************************************************************/
/*      Refresh relations                                                     */
/******************************************************************************/
/* nicht implementiert */



/*-- ENDE der DD -------------------------------------------------------------*/

