/*---------------------------------------------------------------*/
/*	Copyright (C)   SAMSON AG (1999-2003).                       */
/*                  All Rights Reserved	                         */
/*	Product:		SIEMENS SIMATIC PDM  					     */
/*	Device:			SAMSON Positioner 3780 HART capable          */
/*	Communication:	HART									     */
/*	Dictionary:		SIHADC01.dct							     */
/*															     */
/*	Description:	Device Description with     				 */
/*					- universal commands                         */
/*					- common practice commands                   */
/*					- manufacturer specific commands             */
/*					- methods for special functions          	 */
/*	Author:    		KMR - E42 - SAMSON AG	                     */
/*	Version:        1.0                                          */
/*	Date:           04.11.1999  						         */
/*---------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                               */
/* ------     ------  ------------                               */
/* 27.06.2000 Kmr/E42 Minimalwert fr Tote Zone auf 0.1 %        */
/*                     statt 0.01 % gesetzt.                     */
/*                    Unter 'Gert-Betrieb' Methode sie_set      */
/*                     (bertragen-Button) 2x entfernt.          */
/*                    In Methode abort_initialization statt      */
/*                     cmd 132 jetzt mit cmd 133 abbrechen       */
/* 21.09.2000 Kmr/E42 Fehler in Hilfe fuer kp_y2 korrigiert.     */
/*                    Warntexte fr Nullpunktabgleich,           */
/*                    Initialisierung u. Kaltstart gendert.     */
/*                    Wertebereiche gendert:                    */
/*                    Nennwinkelbereich = 0...120                */
/*                    Gew. Laufzeiten = 0...75                   */
/* 07.06.2002 Kmr/E42 Methoden fuer Nullpunktabgleich und        */
/*                    Initialisierung vereinfacht.               */
/* 24.10.2003 Kmr/E42 mit SIMATIC Manager 5.2 (V5.2.0.0) (OEM)   */
/*                    mit PDM Version 5.2 SP1 (K5.2.1.0))        */
/*                    Methode fr Gertezustand (z.B. LifeList)  */
/*                    (method_PDM_StandardDiagnosis) eingefgt.  */
/*                    EB-Aufruf eingefgt.                       */
/*                    DEVICE_REVISION auf 2 gestellt.            */
/*                                                               */
/*---------------------------------------------------------------*/
MANUFACTURER	  66,   /* SAMSON */
DEVICE_TYPE		 249,   /* 3780   */
DEVICE_REVISION    2,   /* Rev. 2 */
DD_REVISION		   1

/*****************************************************************************/
/* DEFINES                                                                   */
/*****************************************************************************/
/* Action Codes fuer HART-Command #132 */
#define NO_TEST              0
#define NULLP_CAL 		     1
#define INIT 			     2
#define TEST_STOERMELD 		 3
#define TEST_SWK_A 		     4
#define TEST_SWK_B 		     5
#define TEST_STELLMELD 		 6
#define WEGINT_RESET 		 7
#define MECH_NULLP		     8
#define M_NULLP_FORTSETZ	 9
#define RK_STOER_RESET		10
#define START_KENNLINIE		11
#define ENDE_KENNLINIE		12
#define INIT_ERW            20
#define INIT_IMP            21
#define ABGL_4mA		   250
#define ABGL_20mA		   251
#define ABGL_0mV		   252
#define ABGL_120mV		   253
#define KALTSTART 		   254
#define ABBRUCH 		   255
/* Antwortnummern der Konfifragen */
#define HUBANTRIEB 		     0
#define SCHWENKANTRIEB 		 1

#define INTEGRIERT		     0
#define NAMUR			     1

#define AUTOMATIK            0
#define HAND			     1
#define SICHER			     2

#define NICHT_VORHANDEN		 0
#define VORHANDEN		     1
#define INDUKTIV		     1
#define SOFTWARE		     2
/* Sonstiges */
#define PRIMARY		         0
#define SECONDARY		     1
#define TERTIARY		     2
#define FOURTH		         3

#define DEVICE_BUSY 		  32
#define DEV_STATUS_SIZE 	   4
#define STATUS_DEVICE_STATUS   2
#define STATUS_SIZE			   3
#define STATUS_RESPONSE_CODE   0
#define BI_SUCCESS             0
#define BI_ERROR			  -1

/*****************************************************************************/
/* fr Methode methodOpenDeviceManual: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME "e83801en.pdf"      \
                               "|de|e83801de.pdf"  \
                               "|fr|e83801fr.pdf"  \
                               "|it|e83801it.pdf"  \
                               "|it|e83801nl.pdf"  \
                               "|it|e83801br.pdf"  \
                               "|sp|e83801es.pdf"

/*****************************************************************************/
/* fr Methode method_PDM_StandardDiagnosis: */
#define PDM_DIAG_FAULT						0x0001
#define PDM_DIAG_MAINT_REQUIRED				0x0002
#define PDM_DIAG_MAINT_RECOMMENDED			0x0004
#define PDM_DIAG_PROCESS_ERROR				0x0010
#define PDM_DIAG_CONFIG_ERROR				0x0020
#define PDM_DIAG_SIMULATION					0x0040
#define PDM_DIAG_GOOD						0x0008
/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS   0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS                0xFFF7  /* Lsche GOOD */
/*****************************************************************************/

/*****************************************************************************/
/* Includes                                                                  */
/*****************************************************************************/
/* keine */

/*****************************************************************************/
/* VARIABLEN                                                                 */
/*****************************************************************************/
ARRAY OF VARIABLE static_param /* Dynamische Variablen */
{
  ELEMENTS
  {
	 6,     w_hand;      	  /* Sollwert Handverstellung [%] */
	10,     nennhub;          /* Nennhub in mm                */
	11,     hubanfang;        /* Hubbereich Anfang [mm]       */
	12,     hubende;          /* Hubbereich Ende   [mm]       */
	13,     fuehr_gr_u;       /* Fhrungsgroesse Anfang [mA]  */
	14,     fuehr_gr_o;       /* Fhrungsgroesse Ende   [mA]  */
	15,     vent_zu;          /* Ventil schliesst bei [%]     */
	16,     vent_auf;         /* Ventil ffnet bei    [%]     */
	17,     hubgr_u;          /* Hubbegrenzung unten  [%]     */
	18,     hubgr_o;          /* Hubbegrenzung oben   [%]     */
	19,     gew_lauf_zu;      /* gewnschte Laufzeit AUF [s]  */
	20,     kp_y1;            /* Proportionalbereich Zuluft   */
	21,     kd;               /* Verstrkungsfakt. D-Glied    */
	22,     xtot;             /* Xtot [%]                     */
	23,     kp_y2;            /* Proportionalbereich Abluft   */
	24,     x0;               /* x[0]  % */
	25,     x1;               /* x[1]  % */
	26,     x2;               /* x[2]  % */
	27,     x3;               /* x[3]  % */
	28,     x4;               /* x[4]  % */
	29,     x5;               /* x[5]  % */
	30,     x6;               /* x[6]  % */
	31,     x7;               /* x[7]  % */
	32,     x8;               /* x[8]  % */
	33,     x9;               /* x[9]  % */
	34,     x10;              /* x[10] % */
	35,     y0;               /* y[0]  % */
	36,     y1;               /* y[1]  % */
	37,     y2;               /* y[2]  % */
	38,     y3;               /* y[3]  % */
	39,     y4;               /* y[4]  % */
	40,     y5;               /* y[5]  % */
	41,     y6;               /* y[6]  % */
	42,     y7;               /* y[7]  % */
	43,     y8;               /* y[8]  % */
	44,     y9;               /* y[9]  % */
	45,     y10;              /* y[10] % */
	46,     h_laenge;         /* bersetzung Lnge [mm]              */
	47,     summ_beweg_value; /* absolutes Wegintegral               */
	48,     swk_a;            /* Softw.kont. A Grenzwert [%]         */
	49,     swk_b;            /* Softw.kont. B Grenzwert [%]         */
	50,	    regler_revision;  /* Regler Software Version             */
	51,	    x_test; 		  /* Wert fr Test Stellungsmelder       */
	52,     min_lauf_zu;      /* min. Laufzeit AUF [s]               */
	53,     mech_revision;    /* Mechanik Hardware Revision          */
	54,	    id_antrieb;	      /* Ident-Nr. Antrieb                   */
	55,     min_lauf_ab;	  /* min. Laufzeit ZU [s]                */
	56,     gew_lauf_ab;	  /* gew. Laufzeit ZU [s]                */
/*	57,     frei;		         zur Zeit nicht verwendet            */
	58,     toleranzband;	  /* Fehlerueberw. Toleranzband [%]      */
	59,     nachlaufzeit;	  /* Fehlerueberw. Nachlaufzeit [s]      */
	60,     grenz_beweg;	  /* Grenzwert abs. Wegintegral          */
	61,     nennwinkel;	      /* Nennwinkel [grad]                   */
	62,     drehw_anfang;	  /* Drehwinkelbereich Anfang [grad]     */
	63,     drehw_ende;	      /* Drehwinkelbereich Ende   [grad]     */
/*	64,	    min_imp_zu;	         Min. Impuls Zuluft                  */
/*	65,	    min_imp_ab;	         Min. Impuls Abluft                  */
	66,	    maxhub;		      /* Max. Hub bei Initialisierungsfehler */
	67,	    ueberschw_w;	  /* berschwingweite                    */
	68,     komm_revision;    /* Kommunikation Software Revision     */
	69,     electr_revision;  /* Elektronik Hardware Revision        */
  }
}
/*****************************************************************************/

ARRAY OF VARIABLE static_enums /* Statische Variablen */
{
  ELEMENTS
  {
	65,     betriebsart;      /* Betriebsart                             */
	66,     federwirkung;     /* Sicherheitsstellung                     */
	67,     anbau;            /* Anbauart                                */
	68,     wirkricht_regler; /* Wirkrichtung Regler / Bewegungsrichtung */
	69,     eing_kl;          /* Eingangskennlinie                       */
	70,     h_code;           /* bersetzung Code                        */
	71,     stoermeldung;     /* Strmeldung                             */
	72,     antrieb;          /* Antriebsart                             */
	73,     kenn_stm;         /* Kennung Option Stellungsmelder          */
	74,     kenn_shutd;       /* Kennung Option Zwangsentlftung         */
	75,     kenn_gr_kont;     /* Kennung Option Grenzkontakte            */
	76,     ind_gr_kont;      /* An-/Abwahl ind. Grenzkontakte           */
	77,     stm_sonder;       /* Strmeldeausgang bei Sonderfunktion     */
	78,     stm_com;          /* Strmeldeausgang bei Kommunik.ausfall   */
	79,     stm_w_int;        /* Strmeldeausgang bei Wegintegral        */
	80,     wirkricht_stell_m;/* Wirkrichtung Stellungsmelder            */
	81, 	swk_a_status;	  /* Status Softwaregrenzkontakt A           */
	82, 	swk_b_status;	  /* Status Softwaregrenzkontakt B           */
	83, 	zwangsentlueft;	  /* Status Zwangsentlueftung                */
	84, 	zuendschutzart;	  /* Ex-Zulassung                            */
	85, 	stiftposition;	  /* Stiftposition Uebersetzung              */
	86, 	bauart;		      /* Bauart                                  */
	87, 	swk_a_ein;	      /* Swk. A schaltet Ein bei                 */
	88, 	swk_b_ein;	      /* Swk. B schaltet Ein bei                 */
	89, 	adaption;	      /* Impulsanpassung aus / automatisch       */
	90, 	nr_kenn_err;	  /* Nr. fehlerhafter Kennlinienpunkt        */
	91, 	anbaulage;	      /* Anbaulage                               */
	92, 	init_art;	      /* Initialisierung bezogen auf             */
/*	93, 	hw_minor;*/	      /* Nachkommastelle HW Version Elektronik   */
/*	94, 	sw_minor;*/  	  /* Nachkommastelle FW Version Kommunikation*/
    95,     imp_1;            /* Anfangsimpulse Bereich 1                */
    96,     imp_2;            /* Anfangsimpulse Bereich 2                */
    97,     imp_3;            /* Anfangsimpulse Bereich 3                */
    98,     init_warn;        /* Warnmeldung Initialisierung             */
    99,     init_ext;         /* Kennung erweiterte Init. verfgbar      */
  }
}
/*****************************************************************************/

ARRAY OF VARIABLE user_text
{
  ELEMENTS
  {
	 0,     text_1;      	/* Textzeile 1 */
	 1,     text_2;      	/* Textzeile 2 */
	 2,     text_3;      	/* Textzeile 3 */
	 3,     text_4;      	/* Textzeile 4 */
	 4,     kennlinientyp; 	/* Textzeile fuer Kennlinientyp */
  }
}
/*****************************************************************************/

VARIABLE text_1
{
  CLASS     DEVICE;
  LABEL     "Text string 1"
            "|de|Textfeld 1";
  HANDLING  READ & WRITE;
  TYPE      PACKED_ASCII (32);
  HELP      "Text string 1: 32 digits of information text."
            "|de|Textfeld 1: 32 Zeichen Informationstext.";
}
/*****************************************************************************/

VARIABLE text_2
{
  CLASS     DEVICE;
  LABEL     "Text string 2"
            "|de|Textfeld 2";
  HANDLING  READ & WRITE;
  TYPE      PACKED_ASCII (32);
  HELP      "Text string 2: 32 digits of information text."
            "|de|Textfeld 2: 32 Zeichen Informationstext.";
}
/*****************************************************************************/

VARIABLE text_3
{
  CLASS     DEVICE;
  LABEL     "Text string 3"
            "|de|Textfeld 3";
  HANDLING  READ & WRITE;
  TYPE      PACKED_ASCII (32);
  HELP      "Text string 3: 32 digits of information text."
            "|de|Textfeld 3: 32 Zeichen Informationstext.";
}
/*****************************************************************************/

VARIABLE text_4
{
  CLASS     DEVICE;
  LABEL     "Text string 4"
            "|de|Textfeld 4";
  HANDLING  READ & WRITE;
  TYPE      PACKED_ASCII (32);
  HELP      "Text string 4: 32 digits of information text."
            "|de|Textfeld 4: 32 Zeichen Informationstext.";
}

/*****************************************************************************/
/* PV, SV, TV, QV                                                            */
/*****************************************************************************/
ARRAY OF COLLECTION dynamic_variables
{
    ELEMENTS
    {
    	PRIMARY,        sollwert,       [primary];	    /* Sollwert       */
	    SECONDARY,      istwert,        [secondary];	/* Istwert        */
        TERTIARY,       regeldiff,      [tertiary];	    /* Regeldifferenz */
	    FOURTH,         wegint,        	[fourth];	    /* Wegintegral    */
    }
}

/*****************************************************************************/
/* Primary Variable                                                          */
/*****************************************************************************/
COLLECTION OF VARIABLE sollwert
{
    MEMBERS
    {
	    DIGITAL_VALUE, sollwert_value;
	    DIGITAL_UNITS, dynamic_units;
	    ANALOG_VALUE, sollwert_analog_value;
	    PERCENT_RANGE, dummy_float;
	    MINIMUM_SPAN, dummy_float;
	    ALARM_CODE, dummy_enum;
	    TRANSFER_FUNCTION, dummy_enum;
	    SENSOR_SERIAL_NUMBER, serial_no;
	    SENSOR_UNITS, dynamic_units;
	    LOWER_SENSOR_LIMIT, dummy_float;
	    UPPER_SENSOR_LIMIT, dummy_float;
	    RANGE_UNITS, dynamic_units;
	    LOWER_RANGE_VALUE, lower_range_value;
	    UPPER_RANGE_VALUE, upper_range_value;
	    DAMPING_VALUE, dummy_float;
    }
}
/*****************************************************************************/
VARIABLE sollwert_value
{
  CLASS     DYNAMIC;
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "Reference variable W: Setpoint value in % with consideration"
	   " to reference variable range."
	   "|de|Fhrungsgre W: Fhrungsgre in % unter Bercksichtigung von "
	   "Fhrungsgre Anfang und Fhrungsgre Ende.";
}
/*****************************************************************************/
VARIABLE sollwert_analog_value
{
  CLASS     DYNAMIC;
  LABEL     "Reference value w_analog"
            "|de|Fhrungsgre w_analog";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      MIN_VALUE       3.00;
      MAX_VALUE      24.00;
  }
  CONSTANT_UNIT "mA";
  HELP "Reference value w_analog: Current input signal in mA. Used as"
       " reference variable W in 'Auto' mode."
  	   "|de|Fhrungsgre w_analog: Stromeingang in mA. Dient in Betriebsart"
  	   " 'Auto' als Fhrungsgre W.";
}
/*****************************************************************************/
VARIABLE dynamic_units
{
  CLASS     DYNAMIC;
  LABEL     [units];
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 57, " % "}
  }
}
/*****************************************************************************/
VARIABLE serial_no
{
  LABEL     "Serial number"
            "|de|Seriennummer";
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER (3)
  {
    DISPLAY_FORMAT  "7d";
    EDIT_FORMAT     "7d";
  }
  HELP "Serial number: Serial number of the positioner."
  	   "|de|Seriennummer: Seriennummer des Stellungsreglers.";
}
/*****************************************************************************/
VARIABLE upper_range_value
{
  LABEL     [urv];
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  HELP "Upper value"
       "|de|Endwert";
}
/*****************************************************************************/
VARIABLE lower_range_value
{
  LABEL     [lrv];
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  HELP "Lower value"
       "|de|Anfangswert";
}
/*****************************************************************************/
VARIABLE dummy_float
{
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
}
/*****************************************************************************/
VARIABLE dummy_enum
{
  TYPE      ENUMERATED
  {
      { 1, " "}
  }
}
/*****************************************************************************/

/*****************************************************************************/
/* Secondary Variable                                                        */
/*****************************************************************************/
COLLECTION OF VARIABLE istwert
{
    MEMBERS
    {
		DIGITAL_VALUE, istwert_value;
		DIGITAL_UNITS, dynamic_units;
		LOWER_RANGE_VALUE, lower_range_value;
		UPPER_RANGE_VALUE, upper_range_value;
    }
}
/*****************************************************************************/
VARIABLE istwert_value
{
  CLASS     DYNAMIC;
  LABEL     "Controlled variable X"
            "|de|Regelgre X";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "Controlled variable X: Actual value in % in reference to range"
       " of travel/opening angle."
       "|de|Regelgre X: Regelgre in % bezogen auf Hub-/Drehwinkelbereich.";
}

/*****************************************************************************/
/* Tertiary Variable                                                         */
/*****************************************************************************/
COLLECTION OF VARIABLE regeldiff
{
    MEMBERS
    {
    	DIGITAL_VALUE, regeldiff_value;
	    DIGITAL_UNITS, dynamic_units;
    }
}
/*****************************************************************************/
VARIABLE regeldiff_value
{
  CLASS     DYNAMIC;
  LABEL     "Control deviation"
            "|de|Regeldifferenz";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      MIN_VALUE    -120.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "Control deviation: Control deviation; corresponds to error e = w - x."
       "|de|Regeldifferenz: Regeldifferenz e = w - x.";
}

/*****************************************************************************/
/* Fourth Variable                                                           */
/*****************************************************************************/
COLLECTION OF VARIABLE wegint
{
    MEMBERS
    {
        DIGITAL_VALUE, summ_beweg_value;
        DIGITAL_UNITS, summ_beweg_units;
    }
}
/*****************************************************************************/
VARIABLE summ_beweg_value
{
  CLASS     DYNAMIC;
  LABEL     "Total valve travel"
            "|de|Absolutes Wegintegral";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT  "8.0f";
      MIN_VALUE        0.0;
      MAX_VALUE 16500000.0;
  }
  HELP "Total valve travel: Valve travel summation in cycles of the rated travel."
	   "|de|Absolutes Wegintegral: Summe der Nennlastspiele.";
}
/*****************************************************************************/
VARIABLE summ_beweg_units
{
  CLASS     DEVICE;
  LABEL     [units];
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      {251, " "}
  }
}

/*****************************************************************************/
/* Weitere Variablen                                                         */
/*****************************************************************************/
VARIABLE summ_beweg
{
  CLASS     DYNAMIC;
  LABEL     "Total valve travel"
            "|de|Absolutes Wegintegral";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "8.0f";
  }
  HELP "Total valve travel: Valve travel summation in cycles of the rated travel."
	   "|de|Absolutes Wegintegral: Summe der Nennlastspiele.";
}
/*****************************************************************************/
VARIABLE kennlinientyp
{
  CLASS     DEVICE;
  LABEL     "Characterization type"
            "|de|Kennlinientyp";
  HANDLING  READ & WRITE;
  TYPE      PACKED_ASCII (32);
  HELP "Characterization type: Free form description of the user defined"
       " characteristics (max. 32 characters)."
       "|de|Kennlinientyp: Freier Text zur Beschreibung der benutzerdefinierten"
       " Kennlinie (max. 32 Zeichen).";
}
/*****************************************************************************/
VARIABLE dev_ident_nr
{
  CLASS     DEVICE;
  LABEL     "Product number"
            "|de|Erzeugnis-Nummer";
  HANDLING  READ;
  TYPE      PACKED_ASCII (16);
  HELP "Product number: Manufacturer's product number of the positioner."
       "|de|Erzeugnis-Nummer: Hersteller-Erzeugnisnummer des Stellungsreglers.";
}
/*****************************************************************************/
VARIABLE regler_revision
{
  CLASS     DEVICE;
  LABEL     "Software revision control"
            "|de|Software Version Regelung";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      MIN_VALUE       0.00;
      MAX_VALUE      99.99;
  }
  HELP "Software revision control: revision number of the controller"
       " software implemented in the field device."
       "|de|Software Version Regelung: Revisionsstand der im Feldgert"
       " implementierten Regelungs-Software.";
}
/*****************************************************************************/
VARIABLE mech_revision
{
  CLASS     DEVICE;
  LABEL     "Hardware revision mechanics"
            "|de|Hardware Version Mechanik";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      MIN_VALUE       0.00;
       MAX_VALUE      99.99;
  }
  HELP "Hardware revision mechanics: Revision number of the mechanics"
       " implemented in the field device; refers to modification index."
       "|de|Hardware Version Mechanik: Revisionsstand der"
       " Mechanik des Feldgertes.";
}
/*****************************************************************************/
VARIABLE komm_revision
{
  CLASS     DEVICE;
  LABEL     "Software revision communication"
            "|de|Software Version Kommunikation";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      MIN_VALUE       0.00;
      MAX_VALUE      99.99;
  }
  HELP "Software revision communication: Revision number of the communication"
       " software implemented in the field device."
       "|de|Software Version Kommunikation: Revisionsstand der im Feldgert"
       " implementierten Kommunikations-Software.";
}
/*****************************************************************************/
VARIABLE electr_revision
{
  CLASS     DEVICE;
  LABEL     "Hardware revision electronics"
            "|de|Hardware Version Elektronik";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      MIN_VALUE       0.00;
      MAX_VALUE      99.99;
  }
  HELP "Hardware revision electronics: Revision number of the"
       " electronics implemented in the field device."
       "|de|Hardware Version Elektronik: Revisionsstand der"
       " Elektronik des Feldgerts.";
}
/*****************************************************************************/
VARIABLE id_antrieb /* Seriennummer Antrieb */
{
  CLASS     DEVICE;
  LABEL     "Serial number"
            "|de|Seriennummer";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "6.0f";
      EDIT_FORMAT    "6.0f";
      MIN_VALUE       0.0;
      MAX_VALUE  999999.0;
  }
  HELP "Serial number actuator: Manufacturer's identification number of the"
       " associated actuator."
       "|de|Seriennummer Antrieb: Hersteller-Identnummer des zum Stellungsregler"
       " zugehrigen Antriebs.";
}
/*****************************************************************************/
VARIABLE w_hand
{
  CLASS     DYNAMIC;
  LABEL     "Reference variable in mode manual"
            "|de|Fhrungsgre in Betriebsart Hand";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      EDIT_FORMAT    "2.2f";
      MIN_VALUE       3.80;
      MAX_VALUE      22.00;
  }
  CONSTANT_UNIT "mA";
  VALIDITY
    IF (betriebsart == HAND)
        { TRUE; }
    ELSE
        { FALSE; }
  HELP "Reference variable in mode manual: Reference variable w in mA; adjustable"
       " in mode 'Manual'."
  	   "|de|Fhrungsgre bei BA Hand: Fhrungsgre in mA, nderbar in der"
  	   " Betriebsart 'Hand'.";
}
/*****************************************************************************/
VARIABLE nennhub
{
  CLASS     DEVICE;
  LABEL     "Rated travel"
            "|de|Nennhub";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     255.9;
  }
  CONSTANT_UNIT "mm";
  VALIDITY
    IF (antrieb == HUBANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  POST_EDIT_ACTIONS
  {
    meld_hubbereich   /* Methode */
  }
  HELP "Rated travel: Nominal working range (travel) of the valve."
       "|de|Nennhub: Nennarbeitsbereich des Ventils.";
}
/*****************************************************************************/
VARIABLE nennwinkel
{
  CLASS     DEVICE;
  LABEL     "Rated angle"
            "|de|Nennwinkel";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "";
  VALIDITY
    IF (antrieb == SCHWENKANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  POST_EDIT_ACTIONS
  {
    meld_drehwbereich   /* Methode */
  }
  HELP "Rated angle: Nominal working range (opening angle) of the valve."
       "|de|Nennwinkel: Nennarbeitsbereich des Ventils.";
}
/*****************************************************************************/
VARIABLE maxhub
{
  CLASS     DEVICE;
  LABEL     "Maximum travel/angle"
            "|de|Maximaler Hub/Drehwinkel";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     255.9;
  }
  CONSTANT_UNIT "%";
  HELP "Maximum travel/angle: possible stroke/angle (% of nominal stroke/angle)."
       " Determined during initialization."
       "|de|Maximaler Hub/Drehwinkel: Maximal erreichter Hub/Drehwinkel"
       " (% von Nennhub/Drehwinkel). Ermittelt whrend der Initialisierung.";
}
/*****************************************************************************/
VARIABLE hubanfang
{
  CLASS     DEVICE;
  LABEL     "Travel range start"
            "|de|Hubbereich Anfang";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     255.9;
  }
  CONSTANT_UNIT "mm";
  VALIDITY
    IF (antrieb == HUBANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Travel range start: Lower limit of the actual working"
       " range (travel). For non linear"
       " characteristic, the characteristic is adapted to the reduced travel."
       " The selected working range shall not fall below 1/6 of the"
       " nominal range. To be observed, if the valve was initialized to"
       " 'maximum range': Travel range refers to the entered nominal travel."
       " If the actual detected stroke falls below or exceeds the nominal"
       " stroke, the selected range works only proportional, always related"
       " to the nominal stroke."
	   "|de|Hubbereich Anfang: Unterer Einstellwert des tatschlichen"
	   " Arbeitsbereiches, bei"
	   " nichtlinearer Kennlinie erfolgt Anpassung der Kennlinie auf den"
	   " reduzierten Hub. Der eingestellte Arbeitsbereich darf 1/6 Nennhub"
       " nicht unterschreiten."
       " Beachten wenn auf 'Maximalbereich' initialisiert wurde:"
	   " Hubbereich bezieht sich auf den eingegebenen Nennhub. Falls"
       " der tatschlich ermittelte Hub kleiner oder grer als der"
       " Nennhub ist, wirkt der eingegebene Bereich nur anteilsmssig,"
       " immer bezogen auf den Nennhub.";
}
/*****************************************************************************/
VARIABLE hubende
{
  CLASS     DEVICE;
  LABEL     "Travel range end"
            "|de|Hubbereich Ende";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     255.9;
  }
  CONSTANT_UNIT "mm";
  VALIDITY
    IF (antrieb == HUBANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Travel range end: Upper limit of the actual working range (travel)."
       " For non linear"
       " characteristic, the characteristic is adapted to the reduced travel"
       " (maximum value <= rated travel)"
       " The selected working range shall not fall below 1/6 of the"
       " nominal range. To be observed, if the valve was initialized to"
       " 'maximum range': Travel range refers to the entered nominal travel."
       " If the actual detected stroke falls below or exceeds the nominal"
       " stroke, the selected range works only proportional, always related"
       " to the nominal stroke."
	   "|de|Hubbereich Ende: Oberer Einstellwert des tatschlichen"
	   " Arbeitsbereiches, bei"
	   " nichtlinearer Kennlinie erfolgt Anpassung der Kennlinie auf den"
	   " reduzierten Hub. Maximaler Wert = Nennhub. Der eingestellte"
       " Arbeitsbereich darf 1/6 Nennhub nicht unterschreiten."
       " Beachten wenn auf 'Maximalbereich' initialisiert wurde:"
	   " Hubbereich bezieht sich auf den eingegebenen Nennhub. Falls"
       " der tatschlich ermittelte Hub kleiner oder grer als der"
       " Nennhub ist, wirkt der eingegebene Bereich nur anteilsmssig,"
       " immer bezogen auf den Nennhub.";
}
/*****************************************************************************/
VARIABLE drehw_anfang
{
  CLASS     DEVICE;
  LABEL     "Angle range start"
            "|de|Drehwinkelbereich Anfang";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "";
  VALIDITY
    IF (antrieb == SCHWENKANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Angle range start: Lower limit of the actual working range"
       " (opening angle). For non "
       " linear characteristic, the characteristic is adapted to the reduced"
       " opening angle."
       " The selected working range shall not fall below 1/6 of the"
       " nominal range. To be observed, if the valve was initialized to"
       " 'maximum range': Angle range refers to the entered nominal angle."
       " If the actual detected angle falls below or exceeds the nominal"
       " angle, the selected range works only proportional, always related"
       " to the nominal angle."
	   "|de|Drehwinkelbereich Anfang: Unterer Einstellwert des tatschlichen"
	   " Arbeitsbereiches, bei"
	   " nichtlinearer Kennlinie erfolgt Anpassung der Kennlinie auf den"
	   " reduzierten Drehwinkel. Der eingestellte Arbeitsbereich darf"
       " 1/6 Nennwinkel nicht unterschreiten."
       " Beachten wenn auf 'Maximalbereich' initialisiert wurde:"
	   " Drehwinkelbereich bezieht sich auf den eingegebenen Nennwinkel."
       " Falls der tatschlich ermittelte Winkel kleiner oder grer als der"
       " Nennwinkel ist, wirkt der eingegebene Bereich nur anteilsmssig,"
       " immer bezogen auf den Nennwinkel.";
}
/*****************************************************************************/
VARIABLE drehw_ende
{
  CLASS     DEVICE;
  LABEL     "Angle range end"
            "|de|Drehwinkelbereich Ende";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "";
  VALIDITY
    IF (antrieb == SCHWENKANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Angle range end: Upper limit of the actual working range"
       " (opening angle). For non "
       " linear characteristic, the characteristic is adapted to the reduced"
       " opening angle (maximum value = opening angle)."
       " The selected working range shall not fall below 1/6 of the"
       " nominal range. To be observed, if the valve was initialized to"
       " 'maximum range': Angle range refers to the entered nominal angle."
       " If the actual detected angle falls below or exceeds the nominal"
       " angle, the selected range works only proportional, always related"
       " to the nominal angle."
	   "|de|Drehwinkelbereich Ende: Oberer Einstellwert des tatschlichen"
	   " Arbeitsbereiches, bei"
	   " nichtlinearer Kennlinie erfolgt Anpassung der Kennlinie auf den"
	   " reduzierten Drehwinkel. Maximaler Wert = Nennwinkel. Der"
       " eingestellte Arbeitsbereich darf 1/6 Nennwinkel nicht unterschreiten."
       " Beachten wenn auf 'Maximalbereich' initialisiert wurde:"
	   " Drehwinkelbereich bezieht sich auf den eingegebenen Nennwinkel."
       " Falls der tatschlich ermittelte Winkel kleiner oder grer als der"
       " Nennwinkel ist, wirkt der eingegebene Bereich nur anteilsmssig,"
       " immer bezogen auf den Nennwinkel.";
}
/*****************************************************************************/
VARIABLE fuehr_gr_u
{
  CLASS     DEVICE;
  LABEL     "Scale W start"
            "|de|Skalierung W Anfang";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.1f";
      EDIT_FORMAT    "2.1f";
      MIN_VALUE       4.0;
      MAX_VALUE      20.0;
  }
  CONSTANT_UNIT "mA";
  HELP "Scale W start: Start of the valid reference variable range (resp. 0 % w)."
	   "|de|Skalierung W Anfang: Anfang des gltigen Fhrungsgrenbereichs"
	   " (entsprechend 0 % W).";
}
/*****************************************************************************/
VARIABLE fuehr_gr_o
{
  CLASS     DEVICE;
  LABEL     "Scale W end"
            "|de|Skalierung W Ende";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.1f";
      EDIT_FORMAT    "2.1f";
      MIN_VALUE       4.0;
      MAX_VALUE      20.0;
  }
  CONSTANT_UNIT "mA";
  HELP "Scale W end: End of the valid reference variable range (resp. 100 % W)."
	   "|de|Skalierung W Ende: Ende des gltigen Fhrungsgrenbereichs"
	   " (entsprechend 100 % W).";
}
/*****************************************************************************/
VARIABLE vent_zu
{
  CLASS     DEVICE;
  LABEL     "Setpoint cutoff dec."
            "|de|Endlage bei W kleiner";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE      -2.5;
      MAX_VALUE     100.0;
  }
  CONSTANT_UNIT "%";
  HELP "Setpoint cutoff dec.: In case the setpoint falls below the entered value,"
       " the valve will"
       " move to a position which corresponds to a setpoint value of 0 %."
       " A value of -2,5 % will deactivate the function. Hysteresis 1 %."
	   "|de|Endlage bei W kleiner: Unterschreitet die Fhrungsgre den"
	   " eingegebenen Wert, wird das Ventil in Richtung der Endlage, die 0 %"
       " der Fhrungsgre entspricht, gefahren. Hysterese 1 %."
       " Bei Wert = -2,5 % Funktion deaktiviert.";
}
/*****************************************************************************/
VARIABLE vent_auf
{
  CLASS     DEVICE;
  LABEL     "Setpoint cutoff inc."
            "|de|Endlage bei W grer";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     125.0;
  }
  CONSTANT_UNIT "%";
  HELP "Setpoint cutoff inc.: In case the setpoint exceeds the entered value,"
       " the valve will"
       " move to a position which corresponds to a setpoint value of 100 %."
       " A value of 125 % will deactivate the function. Hysteresis 1 %."
	   "|de|Endlage bei W grer: berschreitet die Fhrungsgre den eingegebenen"
	   " Wert, wird das Ventil in Richtung der Endlage, die 100 %"
       " der Fhrungsgre entspricht, gefahren. Hysterese 1 %."
       " Bei Wert = 125 % Funktion deaktiviert.";
}
/*****************************************************************************/
VARIABLE hubgr_u
{
  CLASS     DEVICE;
  LABEL
    SELECT (antrieb)
    {
      CASE HUBANTRIEB:
          "Travel lower limit"
          "|de|Untere Hubbegrenzung";
	  CASE SCHWENKANTRIEB:
          "Angle lower limit"
          "|de|Untere Drehwinkelbegrenzung";
	  DEFAULT:
          "Travel/Angle lower limit"
          "|de|Untere Hub-/Drehwinkelbegrenzung";
    }
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE     -20.0;
      MAX_VALUE      99.9;
  }
  CONSTANT_UNIT "%";
  HELP "Travel/Angle lower limit: Lower limitation of travel/opening angle to the"
       " entered value without adapting the characteristic."
	   "|de|Untere Hub-/Drehwinkelbegrenzung: Begrenzung des Hubs/Drehwinkels"
	   " nach unten auf den eingegebenen "
	   "Wert, die Kennlinie wird nicht angepasst.";
}
/*****************************************************************************/
VARIABLE hubgr_o
{
  CLASS     DEVICE;
  LABEL
    SELECT (antrieb)
    {
	  CASE HUBANTRIEB:
          "Travel upper limit"
          "|de|Obere Hubbegrenzung";
	  CASE SCHWENKANTRIEB:
          "Angle upper limit"
          "|de|Obere Drehwinkelbegrenzung";
	  DEFAULT:
          "Travel/Angle upper limit"
          "|de|Obere Hub-/Drehwinkelbegrenzung";
    }
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "Travel/Angle upper limit: Upper limitation of valve travel/opening angle"
       " to the entered value without adapting the characteristic."
	   "|de|Obere Hub-/Drehwinkelbegrenzung: Begrenzung des Hubs/Drehwinkels"
	   " nach oben auf den eingegebenen "
	   "Wert, die Kennlinie wird nicht angepasst.";
}
/*****************************************************************************/
VARIABLE min_lauf_zu
{
  CLASS     DEVICE;
  LABEL     "Transit time dec."
            "|de|Min. Laufzeit AUF";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     240.0;
  }
  CONSTANT_UNIT "s";
  HELP "Transit time dec.: The minimum filling time is measured during"
       " initialization. This"
       " filling time is the shortest stroking time for filling (inflating);"
       " i.e., the time which the system requires in order to move through"
       " the rated travel/opening angle."
	   "|de|Minimale Laufzeit AUF: Die minimale Laufzeit wird whrend der"
	   " Initialisierung gemessen. Die Laufzeit ist die Zeit, die das System "
	   "Stellungsregler, Antrieb und Ventil bentigt, um den Nennhub / "
	   "Nennwinkel zu durchfahren.";
}
/*****************************************************************************/
VARIABLE min_lauf_ab
{
  CLASS     DEVICE;
  LABEL     "Transit time inc."
            "|de|Min. Laufzeit ZU";
  HANDLING  READ;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     240.0;
  }
  CONSTANT_UNIT "s";
  HELP "Transit time inc.: The minimum venting time is measured during"
       " initialization. This"
       " venting time is the shortest stroking time for venting; i.e., the"
       " time which system requires in order to move through the rated"
       " travel/opening angle."
	   "|de|Minimale Laufzeit ZU: Die minimale Laufzeit wird whrend der"
	   " Initialisierung gemessen. Die Laufzeit ist die Zeit, die das System "
	   "Stellungsregler, Antrieb und Ventil bentigt, um den Nennhub / "
	   "Nennwinkel zu durchfahren.";
}
/*****************************************************************************/
VARIABLE gew_lauf_zu
{
  CLASS     DEVICE;
  LABEL     "Req. transit time inc."
            "|de|Laufzeit AUF";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE      75.0;
  }
  CONSTANT_UNIT "s";
  HELP "Req. transit time inc.: The requested filling time is the stroking"
       " time for filling"
       " (inflating) entered by the user; i.e., the time which the system"
       " requires in order to move through the rated travel/opening angle."
       " If the requested filling time is less than the minimum time"
       " determined during initialization, the latter is used."
	   "|de|Wahl Laufzeit AUF: Die Laufzeit ist die Zeit, die das System"
	   " Stellungsregler, "
	   "Antrieb und Ventil bentigt, um den Nennhub / Nennwinkel zu "
	   "durchfahren. Die tatschliche Laufzeit wird auf den eingegebenen "
	   "Wert verlngert. Ist die gewnschte Laufzeit kleiner als die "
	   "whrend der Initialisierung ermittelte minimale Laufzeit, wird mit "
	   "der minimalen Laufzeit gearbeitet.";
}
/*****************************************************************************/
VARIABLE gew_lauf_ab
{
  CLASS     DEVICE;
  LABEL     "Req. transit time dec."
            "|de|Laufzeit ZU";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE      75.0;
  }
  CONSTANT_UNIT "s";
  HELP "Req. transit time dec.: The requested venting time is the stroking"
       " time for venting entered"
       " by the user; the time which the system requires to move through the"
       " rated travel/opening angle. If the requested venting time is less"
       " than the minimum time determined during initialization, the latter"
       " is used."
   	   "|de|Wahl Laufzeit ZU: Die Laufzeit ist die Zeit, die das System"
   	   " Stellungsregler, "
   	   "Antrieb und Ventil bentigt, um den Nennhub / Nennwinkel zu "
   	   "durchfahren. Die tatschliche Laufzeit wird auf den eingegebenen "
   	   "Wert verlngert. Ist die gewnschte Laufzeit kleiner als die "
   	   "whrend der Initialisierung ermittelte minimale Laufzeit, wird mit "
   	   "der minimalen Laufzeit gearbeitet.";
}
/*****************************************************************************/
VARIABLE kp_y1
{
  CLASS     DEVICE;
  LABEL     "Proportional factor filling KP_Y1"
            "|de|Proportionalittsfaktor Zuluft KP_Y1";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      EDIT_FORMAT    "2.2f";
      MIN_VALUE       0.007; /* wegen Rundungsfehler */
      MAX_VALUE      10.00;
  }
  HELP "Proportional factor filling KP_Y1:"
       " Used to enter the proportional action coefficient (filling) for "
       " pressurizing (loading air to) the actuator. For optimizing steps of"
       " 0.1 are recommended."
       "|de|Proportionalittsfaktor Zuluft KP_Y1:"
       " Eingabe des Proportionalittsfaktors Zuluft. Bei Anpassung des"
       " Wertes werden 0,1- Schritte empfohlen.";
}
/*****************************************************************************/
VARIABLE kp_y2
{
  CLASS     DEVICE;
  LABEL     "Proportional factor venting KP_Y2"
            "|de|Proportionalittsfaktor Abluft KP_Y2";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      EDIT_FORMAT    "2.2f";
      MIN_VALUE       0.007; /* wegen Rundungsfehler */
      MAX_VALUE      10.00;
  }
  HELP "Proportional factor venting KP_Y2:"
       " Used to enter the proportional action coefficient (venting) for "
       " exhausting (dumping air from) the actuator. For optimizing steps of"
       " 0.1 are recommended."
       "|de|Proportionalittsfaktor Abluft KP_Y2:"
       " Eingabe des Proportionalittsfaktors Abluft. Bei Anpassung des"
       " Wertes werden 0,1- Schritte empfohlen.";
}
/*****************************************************************************/
VARIABLE kd
{
  CLASS     DEVICE;
  LABEL     "Servo rate KD"
            "|de|Verstrkungsfaktor KD";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      EDIT_FORMAT    "2.2f";
      MIN_VALUE       0.00;
      MAX_VALUE       1.00;
  }
  HELP "Servo rate KD: Derivative action coefficient of the differential element."
       " For optimizing steps of 0.02 are recommended."
       "|de|Verstrkungsfaktor KD: Verstrkungsfaktor des Differenziergliedes."
       " Bei Anpassung des Wertes werden 0,02- Schritte empfohlen.";
}
/*****************************************************************************/
VARIABLE xtot
{
  CLASS     DEVICE;
  LABEL     "Dead band"
            "|de|Tote Zone";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      EDIT_FORMAT    "2.2f";
      MIN_VALUE       0.1;
      MAX_VALUE      10.00;
  }
  CONSTANT_UNIT "%";
  HELP "Dead band: Dead band of the control characteristic."
       "|de|Tote Zone: Tote Zone der Ansteuerungskennlinie.";
}
/*****************************************************************************/
VARIABLE ueberschw_w
{
  CLASS     DEVICE;
  LABEL     "Tolerable overshoot"
            "|de|Tolerierte berschwingweite";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.2f";
      EDIT_FORMAT    "2.2f";
      MIN_VALUE       0.01;
      MAX_VALUE      10.00;
  }
  CONSTANT_UNIT "%";
  HELP "Tolerable overshoot: If the control difference e exceeds"
       " the tolerable overshoot, the pulse adaption will modify the"
       " minimum pulse adaption for the motion direction which caused the"
       " exceeding. If the control difference e exceeds the dead zone"
       " xtot but remains in between the maximum overshoot, the pulse"
       " adaption will reduce the minimum pulses in both motion directions"
       " after two complete cycles in between the maximum overshoot."
       "|de|Tolerierte berschwingweite: berschreitet die Regeldifferenz e"
       " die berschwingweite, so verringert die Impulsanpassung die"
       " minimalen Impulse in der Bewegungsrichtung, welche die berschreitung"
       " verursacht hat. berschreitet die Regeldifferenz e die tote Zone"
       " xtot, bleibt aber innerhalb der berschwingweite, verringert die"
       " Impulsanpassung die minimalen Impulse in beide Bewegungsrichtungen"
       " erst nach 2 vollstndigen Schwingungen innerhalb der"
       " berschwingweite.";
}
/*****************************************************************************/
VARIABLE toleranzband
{
  CLASS     DEVICE;
  LABEL     "Tolerance band"
            "|de|Toleranzband";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "2.1f";
      EDIT_FORMAT    "2.1f";
      MIN_VALUE       0.1;
      MAX_VALUE      10.0;
  }
  CONSTANT_UNIT "%";
  HELP "Tolerance band: Reset criteria for active control loop monitoring."
       " Entry of the specified maximum permissible control deviation."
       " See also delay time. Cold start value = Xtot."
       "|de|Toleranzband: Rcksetzkriterium fr laufende Regelkreisberwachung. "
	   "Eingabe der hierfr erlaubten Regelabweichung. Siehe auch "
 	   "Nachlaufzeit. Kaltstartwert = Xtot.";
}
/*****************************************************************************/
VARIABLE nachlaufzeit
{
  CLASS     DEVICE;
  LABEL     "Delay time"
            "|de|Nachlaufzeit";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";
      MIN_VALUE       0.0;
      MAX_VALUE     240.0;
  }
  CONSTANT_UNIT "s";
  HELP "Delay time: Reset criteria for active control loop monitoring."
       " If the entered"
       " delay time is exceeded and the control deviation does not lie within"
       " the tolerance band entered, a control loop fault is reported."
       "|de|Nachlaufzeit: Rcksetzkriterium fr laufende Regelkreisberwachung. "
	   "Wenn die eingegebene Nachlaufzeit berschritten ist und die "
	   "Regelabweichung nicht innerhalb des eingegebenen Toleranzbandes "
	   "liegt, wird Regelkreisstrung gemeldet.";
}
/*****************************************************************************/
VARIABLE h_laenge
{
  CLASS     DEVICE;
  LABEL     "Transmission length"
            "|de|bersetzung Lnge";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";
      MIN_VALUE       0.0;
      MAX_VALUE    1023.0;
  }
  CONSTANT_UNIT "mm";
  VALIDITY
    IF ( (antrieb == HUBANTRIEB) && (anbau == NAMUR) )
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Transmission length: Lever length."
       " Distance between travel pick up and pivot of the pick up lever."
	   "|de|bersetzung Lnge: Hebellnge, Abstand zwischen Hubabgriff"
	   " und Drehpunkt des Abgriffhebels.";
}
/*****************************************************************************/
VARIABLE x0
{
  CLASS     DEVICE;
  LABEL     "x[0]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "Coordinates for user defined control valve characteristic."
       " x[n] = reference variable in % of the respective range."
       " y[n] = travel/opening ! Angle in % of the respective range."
	   "|de|Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
	   "Fhrungsgre und Hub / Drehwinkel."
	   " x[n] = Fhrungsgre in % des Fhrungsgrenbereichs."
	   " y[n] = Hub / Drehwinkel in % des Hub- / Drehwinkelbereichs.";
}
/*****************************************************************************/
VARIABLE x1
{
  CLASS     DEVICE;
  LABEL     "x[1]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x2
{
  CLASS     DEVICE;
  LABEL     "x[2]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x3
{
  CLASS     DEVICE;
  LABEL     "x[3]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x4
{
  CLASS     DEVICE;
  LABEL     "x[4]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x5
{
  CLASS     DEVICE;
  LABEL     "x[5]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x6
{
  CLASS     DEVICE;
  LABEL     "x[6]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x7
{
  CLASS     DEVICE;
  LABEL     "x[7]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x8
{
  CLASS     DEVICE;
  LABEL     "x[8]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x9
{
  CLASS     DEVICE;
  LABEL     "x[9]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE x10
{
  CLASS     DEVICE;
  LABEL     "x[10]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y0
{
  CLASS     DEVICE;
  LABEL     "y[0]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|Siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y1
{
  CLASS     DEVICE;
  LABEL     "y[1]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y2
{
  CLASS     DEVICE;
  LABEL     "y[2]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y3
{
  CLASS     DEVICE;
  LABEL     "y[3]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y4
{
  CLASS     DEVICE;
  LABEL     "y[4]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y5
{
  CLASS     DEVICE;
  LABEL     "y[5]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y6
{
  CLASS     DEVICE;
  LABEL     "y[6]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y7
{
  CLASS     DEVICE;
  LABEL     "y[7]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y8
{
  CLASS     DEVICE;
  LABEL     "y[8]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y9
{
  CLASS     DEVICE;
  LABEL     "y[9]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE y10
{
  CLASS     DEVICE;
  LABEL     "y[10]";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "see help x[0]"
       "|de|siehe Hilfe x[0]";
}
/*****************************************************************************/
VARIABLE grenz_beweg
{
  CLASS     DEVICE;
  LABEL     "Limit value valve travel"
            "|de|Grenzwert Wegintegral";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT  "8.0f";
      EDIT_FORMAT     "8.0f";
      MIN_VALUE        0.0;
      MAX_VALUE 16500000.0;
  }
  HELP "Limit value valve travel: Limit value of the total valve travel;"
       " e.g., used for diagnostic purposes."
       "|de|Grenzwert Wegintegral: Grenzwert fr absolutes Wegintegral.";
}
/*****************************************************************************/
VARIABLE swk_a
{
  CLASS     DEVICE;
  LABEL     "Limit switch GW1 value"
            "|de|Grenzkontakt GW1 Wert";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE) /* wenn SW-Grenzkontakte eingebaut */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Limit switch GW1 value: Limit switch alarm in reference to the range of"
       " travel/opening angle;"
       " derived by the software form the signal of the displacement pick up."
       "|de|Grenzkontakt GW1 Wert: Grenzwertmeldung bezogen auf den"
       " Hub- / Drehwinkelbereich, "
	   "per Software aus dem Signal der Wegmessung abgeleitet.";
}
/*****************************************************************************/
VARIABLE swk_a_ein
{
  CLASS     DEVICE;
  LABEL     "Limit switch GW1 ON at"
            "|de|Grenzkontakt GW1 EIN bei";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Value fallen short of"
           "|de|Wert unterschritten"},
      { 1, "Value exceeded"
           "|de|Wert berschritten"}
  }
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE)  /* wenn SW-Grenzkontakte eingebaut */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Limit switch GW1 ON at: Defines the circuit state conductive."
	   "|de|Grenzontakt GW1 EIN bei: Definiert den Schaltzustand leitend.";
}
/*****************************************************************************/
VARIABLE swk_b
{
  CLASS     DEVICE;
  LABEL     "Limit switch GW2 value"
            "|de|Grenzkontakt GW2 Wert";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE)  /* wenn SW-Grenzkontakte eingebaut */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Limit switch GW2 value: Limit switch alarm in reference to range of"
       " travel/opening angle;"
       " derived by the software from the signal of the displacement pickup."
       "|de|Grenzkontakt GW2 Wert: Grenzwertmeldung bezogen auf den"
       " Hub- / Drehwinkelbereich, "
	   "per Software aus dem Signal der Wegmessung abgeleitet.";
}
/*****************************************************************************/
VARIABLE swk_b_ein
{
  CLASS     DEVICE;
  LABEL     "Limit switch GW2 ON at"
            "|de|Grenzkontakt GW2 EIN bei";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Value fallen short of"
           "|de|Wert unterschritten"},
      { 1, "Value exceeded"
           "|de|Wert berschritten"}
  }
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE)  /* wenn SW-Grenzkontakte eingebaut */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Limit switch GW2 ON at: Defines the circuit state conductive."
	   "|de|Grenzkontakt GW2 EIN bei: Definiert den Schaltzustand leitend.";
}
/*****************************************************************************/
VARIABLE zuendschutzart
{
  CLASS     DEVICE;
  LABEL     "Type of protection"
            "|de|Zndschutzart";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "not installed"
           "|de|nicht vorhanden"},
      { 1, "installed"
           "|de|vorhanden"}
  }
  HELP "Type of protection: Determines whether or not the positioner"
       " is suitable for hazardous areas."
       " Explosion proof type of protection installed."
	   "|de|Zndschutzart: Gibt an, ob der Stellungsregler in"
	   " explosionsgefhrdeten Bereichen eingesetzt werden kann.";
}
/*****************************************************************************/
VARIABLE betriebsart
{
  CLASS     DYNAMIC;
  LABEL     "Operating mode"
            "|de|Betriebsart" ;
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Automatic"
           "|de|Automatik",
           "Reference variable specified by the analog current signal."
           "|de|Fhrungsgre wird ber das analoge Stromsignal vorgegeben."},

      { 1, "Manual"
           "|de|Hand",
           "Reference variable specified by the digital communication."
           "|de|Fhrungsgre wird ber die digitale Kommunikation vorgegeben."},

      { 2, "Fail safe"
           "|de|Sicherheitsstellung",
           "Valve moves to the appropriate fail safe position"
           " (see fail safe action)."
           "|de|Ventil fhrt in Sicherheitsstellung."}
  }
  HELP "Operating mode: Determines whether the reference variable is specified"
       " via the analog current signal (automatic) or via the digital"
       " communication (manual)."
	   "|de|Betriebsart: Bestimmt, ob die Fhrungsgre ber das analoge"
	   " Stromsignal (Automatik) oder ber die digitale Kommunikation"
	   " (Hand) vorgegeben wird.";
}
/*****************************************************************************/
VARIABLE federwirkung
{
  CLASS     DEVICE;
  LABEL     "Actuator action"
            "|de|Sicherheitsstellung";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
       IF (antrieb == HUBANTRIEB)
       {
	      { 0, "Actuator stem retracts"
	           "|de|Stange einfahrend"},
	      { 1, "Actuator stem extends"
	           "|de|Stange ausfahrend"},
	      { 2, [unknown]},
	      { 3, "None"
	           "|de|Keine"}
       }
       ELSE
       {
          { 0, "Closing"
               "|de|Schliessend"},
    	  { 1, "Opening"
    	       "|de|ffnend"},
    	  { 2, [unknown]},
    	  { 3, "None"
    	       "|de|Keine"}
       }
  }
  HELP "Actuator action: Fail safe action of actuator in event of air/power loss."
  	   "|de|Sicherheitsstellung: Sicherheitsstellung des Antriebs bei Luft- / "
	   "Hilfsenergieausfall.";
}
/*****************************************************************************/
VARIABLE anbau
{
  CLASS     DEVICE;
  LABEL     "Attachment"
            "|de|Anbau";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Direct"
           "|de|Integriert"},
      { 1, "NAMUR"}
  }
  VALIDITY
    IF (antrieb == HUBANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Attachment: Defines positioner attachment to the control valve."
  	   "|de|Anbau: Definiert den Anbau des Stellungsreglers an das Stellgert.";
}
/*****************************************************************************/
VARIABLE wirkricht_regler
{
  CLASS     DEVICE;
  LABEL     "Moving direction"
            "|de|Bewegungsrichtung";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, ">> increasing / increasing"
           "|de|>> steigend / steigend"},
      { 1, "<> increasing / decreasing"
           "|de|<> steigend / fallend"}
  }
  HELP "Moving direction: Determines the moving direction of the positioner."
       "|de|Bewegungsrichtung: Bestimmt die Zuordnung von Fhrungsgre zum "
       "Hub/Drehwinkel."
       " >> Bei steigender Fhrungsgre ffnet das Ventil."
       " <> Bei steigender Fhrungsgre schliesst das Ventil.";
}
/*****************************************************************************/
VARIABLE wirkricht_stell_m
{
  CLASS     DEVICE;
  LABEL     "Operating direction position transmitter"
            "|de|Wirkrichtung Stellungsmelder";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, ">> increasing / increasing"
           "|de|>> steigend / steigend"},
      { 1, "<> increasing / decreasing"
           "|de|<> steigend / fallend"}
  }
  VALIDITY
    IF (kenn_stm == 1)  /* wenn 'Option Stellungsmelder' vorhanden */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Operating direction Position transmitter:"
       " Determines the operating direction of the optional position transmitter."
  	   "|de|Wirkrichtung Stellungsmelder:"
  	   " Bestimmt die Wirkrichtung der Option Stellungsmelder."
       " >> Bei steigender Regelgre steigendes Ausgangssignal."
       " <> Bei steigender Regelgre fallendes Ausgangssignal.";
}
/*****************************************************************************/
VARIABLE eing_kl
{
  CLASS     DEVICE;
  LABEL     "Characterization selection"
            "|de|Kennlinienauswahl";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "User defined"
           "|de|Benutzerdefiniert"},
      { 1, "Linear"
           "|de|Linear"},
      { 2, "Equal percentage"
           "|de|Gleichprozentig"},
      { 4, "Equal percentage inverse"
           "|de|Gleichprozentig invers"}
  }

  HELP "Characterization selection: Correlation between reference variable"
       " and range of travel/opening angle of the valve."
       "|de|Kennlinienauswahl: Zuordnung zwischen Fhrungsgre und Hub- / "
       "Drehwinkelbereich des Ventils.";
}
/*****************************************************************************/
VARIABLE h_code
{
  CLASS     DEVICE;
  LABEL     "Transmission code"
            "|de|bersetzung Code";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      DEFAULT_VALUE
          IF (antrieb == HUBANTRIEB)
              { 1; }  /* Default = D1  */
          ELSE
              { 3; }  /* Default = S90 */

      IF (antrieb == HUBANTRIEB)
      {
      	  { 1, "D1" },
  	      { 2, "D2" }
      }
      ELSE
      {
      	  { 3, "S90"  },
  	      { 4, "S120" }
      }
  }
  VALIDITY
    IF ( (antrieb == HUBANTRIEB) && (anbau == NAMUR) )
        { FALSE; }
    ELSE
        { TRUE; }

  HELP
    SELECT (antrieb)
    {
        CASE HUBANTRIEB:
    	"Transmission code: Selecting the lever type for direct attachment."
    	"|de|bersetzung Code: Festlegung der geometrischen Abmessungen des"
    	" Hubabgriffs bei integriertem Anbau.";

        CASE SCHWENKANTRIEB:
    	"Transmission code: Maximum angular travel (slewing angle)"
    	" of the mounted cam plate."
    	"|de|bersetzung Code: Maximaler Schwenkwinkel der"
    	" eingebauten Kurvenscheibe.";
    }
}
/*****************************************************************************/
VARIABLE stiftposition
{
  CLASS     DEVICE;
  LABEL     "Transmission pin position"
            "|de|bersetzung Stiftposition";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "A "},
      { 1, "B "}
  }
  VALIDITY
    IF ( (antrieb == HUBANTRIEB) && (anbau == NAMUR) )
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Transmission pin position: Transmitter pin in position A or B"
       " (see also Mounting Instructions)."
       " Only for linear actuator with NAMUR attachment."
       "|de|bersetzung Stiftposition: Position des Stiftes am Hebel des"
       " Stellungsreglers. Siehe Markierung am Hebel."
       " Nur bei Hubantrieb Anbauart NAMUR.";
}
/*****************************************************************************/
VARIABLE stoermeldung
{
  CLASS     DYNAMIC;
  LABEL     "Fault alarm"
            "|de|Strmeldung";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, [off]},
      { 1, [on] }
  }
  HELP "Fault alarm: Output state of the fault alarm."
       "|de|Strmeldung: Schaltzustand des Strmeldeausgangs.";
}
/*****************************************************************************/
VARIABLE imp_1
{
  CLASS     DYNAMIC;
  LABEL     "Min. pulses range 1"
            "|de|Min. Stellimp. Ber. 1";
  HANDLING   READ;
  TYPE      ENUMERATED
  {
      { 0, "None"
           "|de|Keine" },
      { 1, "Filling"
           "|de|Zuluft"},
      { 2, "Venting"
           "|de|Abluft"},
      { 3, "Valid"
           "|de|Gltig"}
  }
  HELP "Min. pulses range 1: Displays if in the positioning range"
       " 0% to 20% valid minimum pulses are already found."
       "|de|Min. Stellimpulse Bereich 1: Gibt an, ob fr den Stellbereich"
       " 0% bis 20% bereits gltige minimale Stellimpulse ermittelt wurden.";
}
/*****************************************************************************/
VARIABLE imp_2
{
  CLASS     DYNAMIC;
  LABEL     "Min. pulses range 2"
            "|de|Min. Stellimp. Ber. 2";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "None"
           "|de|Keine" },
      { 1, "Filling"
           "|de|Zuluft"},
      { 2, "Venting"
           "|de|Abluft"},
      { 3, "Valid"
           "|de|Gltig"}
  }
  HELP "Min. pulses range 2: Displays if in the positioning range"
       " 20% to 80% valid minimum pulses are already found."
       "|de|Min. Stellimpulse Bereich 2: Gibt an, ob fr den Stellbereich"
       " 20% bis 80% bereits gltige minimale Stellimpulse ermittelt wurden.";
}
/*****************************************************************************/
VARIABLE imp_3
{
  CLASS     DYNAMIC;
  LABEL     "Min. pulses range 3"
            "|de|Min. Stellimp. Ber. 3";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "None"
           "|de|Keine" },
      { 1, "Filling"
           "|de|Zuluft"},
      { 2, "Venting"
           "|de|Abluft"},
      { 3, "Valid"
           "|de|Gltig"}
  }
  HELP "Min. pulses range 3: Displays if in the positioning range"
       " 80% to 100% valid minimum pulses are already found."
       "|de|Min. Stellimpulse Bereich 3: Gibt an, ob fr den Stellbereich"
       " 80% bis 100% bereits gltige minimale Stellimpulse ermittelt wurden.";
}
/*****************************************************************************/
VARIABLE antrieb
{
  CLASS     DEVICE;
  LABEL     "Valve type"
            "|de|Ventilart";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Linear actuator"
           "|de|Hubantrieb"},
      { 1, "Rotary actuator"
           "|de|Schwenkantrieb"}
  }
  POST_EDIT_ACTIONS
  {
    support_antrieb /* Methode */
  }
  POST_WRITE_ACTIONS
  {
      WRITE_ALL_PARAMETERS /* Methode: Schreiben aller restlichen Parameter */
  }
  HELP "Valve type: Describes the construction of the valve."
	   "|de|Ventilart: Beschreibt die Ventilkonstruktion.";
}
/*****************************************************************************/
VARIABLE bauart
{
  CLASS     DEVICE;
  LABEL     "Model"
            "|de|Bauart";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Single acting"
           "|de|Einfach wirkend"},
      { 1, "Double acting"
           "|de|Doppelt wirkend"}
  }
  HELP "Model: Actuator with or without spring loading."
	   "|de|Bauart: Antrieb mit oder ohne Federrckstellung.";
}
/*****************************************************************************/
VARIABLE action_code
{
  CLASS     DEVICE;
  LABEL     "Calibration"
            "|de|Kalibrierung";
  HANDLING  WRITE;
  TYPE      ENUMERATED
  {
      { NO_TEST,            "No test"
                            "|de|Kein Test"},
      { INIT,               "Initialization"
                            "|de|Initialisierung"},
      { INIT_ERW,           "Extended initialization"
                            "|de|Erweiterte Initialisierung"},
      { INIT_IMP,           "Puls search"
                            "|de|Impulssuche"},
      { TEST_STOERMELD,     "Test fault alarm"
                            "|de|Test Strmeldung"},
      { TEST_SWK_A,         "Test SW Limit switch GW1"
                            "|de|Test Software-Grenzkontakt GW1"},
      { TEST_SWK_B,         "Test SW Limit switch GW2"
                            "|de|Test Software-Grenzkontakt GW2"},
      { TEST_STELLMELD,     "Test position transmitter"
                            "|de|Test Stellungsmelder"},
      { WEGINT_RESET,       "Reset total valve travel"
                            "|de|Wegintegral zurcksetzen"},
      {	MECH_NULLP,         "Start mech. zero point calibration"
                            "|de|Mech. Nullpunktabgleich starten"},
      { M_NULLP_FORTSETZ,   "Continue mech. zero point calibration"
                            "|de|Mech. Nullpunktabgleich fortsetzen"},
      { ABGL_4mA,           "Calibration 4mA"
                            "|de|Abgleich 4 mA"},
      { ABGL_20mA,          "Calibration 20 mA"
                            "|de|Abgleich 20 mA"},
      { ABGL_0mV,           "Calibration 0 mV"
                            "|de|Abgleich 0 mV"},
      { ABGL_120mV,         "Calibration 120 mV"
                            "|de|Abgleich 120 mV"},
      { KALTSTART,          "Cold start"
                            "|de|Kaltstart"}
  }
  HELP "Calibration: Command to start manufacturer specific calibration"
       " procedures in the field device."
	   "|de|Kalibrierung: Kommando zum Starten von herstellerspezifischen"
	   " Kalibrierungssequenzen im Feldgert.";
}
/*****************************************************************************/
VARIABLE action_status
{
  CLASS     DYNAMIC;
  LABEL     "Status calibration"
            "|de|Status Kalibrierung";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "Undefined"
           "|de|Unbestimmt"},
      { 1, "Running"
           "|de|Luft"},
      { 2, "Aborted"
           "|de|Abgebrochen"},
      { 3, "Range error"
           "|de|Bereich fehlerhaft"},
      { 4, "Defect in mechanics or pneumatic section"
	       "|de|Mechanik oder Pneumatik fehlerhaft"},
      { 5, "Gain error"
           "|de|Verstrkungsfehler"},
      { 6, "Offset error"
           "|de|Offsetfehler"},
      { 7, "Wrong selection"
           "|de|Reihenfolge vertauscht"},
      { 8, "Button test"
           "|de|Tastentest"},
      { 9, "Continue"
           "|de|Fortsetzen"},
      {10, "Default"
           "|de|Default"},
      {11, "Timeout"
           "|de|Zeitfehler"},
      {12, "Proportional action range to small"
           "|de|Proportionalbereich zu stark eingeschrnkt"},
      {13, "Wrong value for rated travel or transmission"
           "|de|Nennhub oder bersetzung falsch gewhlt"},
      {14, "Error when determining duty cycle"
           "|de|Mechanisches System klemmt"},
      {15, "Air leakage of pneumatic system"
           "|de|Pneumatisches System undicht"},
      {16, "Aborted due to no final test conducted"
           "|de|Abgebrochen, kein erfolgreicher Fertigungstest"},
      {17, "Determination of mechanical travel stops"
           "|de|Ermittlung der mechanischen Anschlge"},
      {18, "Determination of minimum pulses"
           "|de|Ermittlung der minimalen Stellimpulse"},
      {19, "Determination of minimum travel times"
           "|de|Ermittlung der minimalen Laufzeiten"},
      {20, "Aborted due to activated forced venting"
           "|de|Abgebrochen, Zwangsentlftung aktiv"},
      {30, "Zero point error"
           "|de|Nullpunktfehler"},
      {254,"Successful"
           "|de|Erfolgreich"},
      {255,"No current application data"
           "|de|Keine aktuellen Daten von der Applikation"}
  }
  HELP "Status calibration: manufacturer specific status of the calibration"
       " procedure."
	   "|de|Status Kalibrierung: Herstellerspezifischer Status der laufenden"
	   " Kalibrierungssequenz.";
}
/*****************************************************************************/
VARIABLE init_warn
{
  CLASS     DYNAMIC;
  LABEL     "Initialization warning"
            "|de|Initialisierung Warnung";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "Undefined"
           "|de|Unbestimmt"},
      {12, "Limits for proportional band too small"
           "|de|Proportionalbereich zu stark eingeschrnkt"},
      {13, "Wrong selection of rated travel or transmission"
           "|de|Nennhub oder bersetzung falsch gewhlt"},
      {15, "Air leakage of pmeumatic system"
           "|de|Pneumatisches System undicht"},
      {254,"No messages"
           "|de|Keine Meldungen"},
      {255,"No data available"
           "|de|Keine Daten verfgbar"}
  }
  HELP "Initialization warning: Warning message during initialization."
       "|de|Initialisierung Warnung: Warnmeldungen whrend der Initialisierung.";
}
/*****************************************************************************/
VARIABLE init_ext
{
  CLASS     USER_INTERFACE;
  LABEL     "Extended Initialization"
            "|de|Erweiterte Initialisierung";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "Not implemented"
           "|de|Nicht implementiert"},
      { 1, "Implemented"
           "|de|Implementiert"}
  }
  HELP "Extended Initialization: extended initialization is available or not."
       "|de|Erweiterte Initialisierung: Kennung ob erweiterte Initialisierung"
       " verfgbar ist.";
}
/*****************************************************************************/
VARIABLE kenn_stm
{
  CLASS     DEVICE;
  LABEL     "Position transmitter"
            "|de|Stellungsmelder";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "Not installed"
           "|de|Nicht vorhanden"},
      { 1, "Installed"
           "|de|Vorhanden"}
  }
  HELP "Position transmitter: Indicates whether or not the optional"
       " analog position transmitter is"
       " installed. The position transmitter indicates the travel in mA in"
       " reference to the range of travel / opening angle."
	   "|de|Stellungsmelder: Gibt an, ob die Option analoger Stellungsmelder"
	   " eingebaut ist. Der Stellungsmelder signalisiert den Hub in mA"
	   " bezogen auf den Hub- / Drehwinkelbereich.";
}
/*****************************************************************************/
VARIABLE kenn_shutd
{
  CLASS     DEVICE;
  LABEL     "Forced venting"
            "|de|Zwangsentlftung";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "Not installed"
           "|de|Nicht vorhanden"},
      { 1, "Installed"
           "|de|Vorhanden"}
  }
  HELP "Forced venting:"
       " Indicates whether or not the optional forced venting (forced fail safe"
       " action) is installed. If installed, the absence of the input signal"
       " forces the valve to move in the appropriate fail safe position."
	   "|de|Zwangsentlftung:"
	   " Gibt an, ob die Option Zwangsentlftung eingebaut ist. Wenn "
	   "Option vorhanden, fhrt Wegfall des Steuersignals zum Anfahren der "
	   "Sicherheitsstellung.";
}
/*****************************************************************************/
VARIABLE kenn_gr_kont
{
  CLASS     DEVICE;
  LABEL     "Limit switches"
            "|de|Grenzkontakte";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "None"
           "|de|Nicht vorhanden"},
      { 1, "Inductive"
           "|de|Induktiv"},
      { 2, "Software limit switches"
           "|de|Software Grenzkontakte"}
  }
  HELP "Limit switches: Indicates which type of limit switch is installed."
       "|de|Grenzkontakte: Gibt an, welche Grenzkontaktoption eingebaut ist.";
}
/*****************************************************************************/
VARIABLE ind_gr_kont
{
  CLASS     DEVICE;
  LABEL     "Inductive limit switches"
            "|de|Induktive Grenzkontakte";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Not installed"
           "|de|Nicht vorhanden"},
      { 1, "Installed"
           "|de|Vorhanden"}
  }
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE)  /* wenn SW-Grenzkontakte eingebaut */
        { FALSE; }
    ELSE
        { TRUE; }

  HELP "Inductive limit switches: Interrogation necessary to determine"
       " whether or not inductive limit"
       " switches are installed (no automatic recognition possible). Optional"
       " inductive limit switches only possible when no optional software"
       " limit switches are installed."
	   "|de|Induktive Grenzkontakte:"
	   " Notwendige Abfrage, ob induktive Grenzkontakte eingebaut "
	   "sind, keine automatische Erkennung mglich. Option induktive "
	   "Grenzkontakte nur mglich, wenn Option Softwaregrenzkontakte nicht"
	   "eingebaut ist.";
}
/*****************************************************************************/
VARIABLE stm_sonder
{
  CLASS     DEVICE;
  LABEL     "Alarm: special mode"
            "|de|Strmeldung: Sonderfunktion";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, [no] },
      { 1, [yes]}
  }
  HELP "Alarm: special mode: Fault alarm during special function"
       " (e.g. zero point adjustment or initialization)."
	   "|de|Strmeldung: Sonderfunktion: Strmeldung bei Regler in Sonderfunktion"
       " (z.B. Nullpunktabgleich oder Initialisierung).";
}
/*****************************************************************************/
VARIABLE stm_com
{
  CLASS     DEVICE;
  LABEL     "Alarm: communication error"
            "|de|Strmeldung: Kommunikationsausfall";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, [no] },
      { 1, [yes]}
  }
  HELP "Alarm: communication error: Fault alarm upon failure/fault"
       " of positioner communication hardware."
	   "|de|Strmeldung: Kommunikationsausfall: Strmeldung bei Ausfall / Strung"
	   " der Kommunikationshardware des Stellungsreglers.";
}
/*****************************************************************************/
VARIABLE stm_w_int
{
  CLASS     DEVICE;
  LABEL     "Alarm: total travel limit"
            "|de|Strmeldung: Absolutes Wegintegral";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, [no] },
      { 1, [yes]}
  }
  HELP "Alarm: total travel limit: Fault alarm whenever the limit value of total"
       " valve travel is exceeded."
	   "|de|Strmeldung: Absolutes Wegintegral: Strmeldung bei berschreiten des"
	   " Grenzwertes fr das absolute Wegintegral.";
}
/*****************************************************************************/
VARIABLE zwangsentlueft
{
  CLASS     DYNAMIC;
  LABEL     "Forced venting"
            "|de|Zwangsentlftung";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, [off]},
      { 1, [on] }
  }
  VALIDITY
    IF (kenn_shutd == VORHANDEN)  /* wenn 'Option Zwangsentlftung' vorhanden */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Forced venting: If this option is installed, the absence of the input"
       " signal forces the control valve to move in the appropriate fail safe"
       " position in the appropriate fail safe position."
       "|de|Zwangsentlftung: Wenn Option vorhanden, fhrt Wegfall des"
       " Steuersignals zum Anfahren der Sicherheitsstellung.";
}
/*****************************************************************************/
VARIABLE reglerstatus
{
  CLASS     DYNAMIC;
  LABEL     "Operating status"
            "|de|Betriebszustand";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, "See operating mode"
           "|de|Siehe Betriebsart"},
      { 1, "Forced venting active"
           "|de|Zwangsentlftung aktiv"},
      { 2, "Lower travel limit active"
           "|de|Hubbegrenzung unten aktiv"},
      { 3, "Upper travel limit active"
           "|de|Hubbegrenzung oben aktiv"},
      { 4, "End position < active"
           "|de|Endlage < aktiv"},
      { 5, "End position > active"
           "|de|Endlage > aktiv"}
  }

  HELP "Operating status: Shows the current operating status of the internal"
       " position control algorithm."
       "|de|Betriebszustand: Zeigt den aktuellen Betriebszustand der internen"
       " Stellungsregelung an.";
}
/*****************************************************************************/
VARIABLE swk_a_status
{
  CLASS     DYNAMIC;
  LABEL     "SW limit switch GW1"
            "|de|SW Grenzkontakt GW1";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, [off]},
      { 1, [on] }
  }
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE) /* wenn SW-Grenzkontakte eingebaut */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Software limit switch GW1: Output state of the software limit switch GW1."
       "|de|Softwaregrenzkontakt GW1: Zustand des Softwaregrenzkontaktes GW1.";
}
/*****************************************************************************/
VARIABLE swk_b_status
{
  CLASS     DYNAMIC;
  LABEL     "SW limit switch GW2"
            "|de|SW Grenzkontakt GW2";
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, [off]},
      { 1, [on] }
  }
  VALIDITY
    IF (kenn_gr_kont == SOFTWARE) /* wenn SW-Grenzkontakte eingebaut */
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Software limit switch GW2: Output state of the software limit switch GW2."
       "|de|Softwaregrenzkontakt GW2: Zustand des Softwaregrenzkontaktes GW2.";
}
/*****************************************************************************/
VARIABLE adaption
{
  CLASS     DEVICE;
  LABEL     "Pulse adaption"
            "|de|Impulsanpassung";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Switched off"
           "|de|Abgeschaltet"},
      { 1, "Automatic"
           "|de|Automatisch"}
  }
  HELP "Pulse adaption: Adaption of the min. pulses to optimize the"
       " controller algorithm for system positioner actuator valve."
       " For normal operation keep this parameter on 'automatic'. For adaption"
       " of the controller parameters this parameter has to be 'switched off'."
	   "|de|Impulsanpassung: Anpassung der min. Impulse zur Optimierung des "
	   "Regelalgorithmus fr das System Stellungsregler-Antrieb-Ventil. "
	   "Im normalen Regelbetrieb sollte der Parameter auf 'automatisch' "
	   "stehen. Bei Anpassung der Regelparameter ist dieser Parameter auf "
	   "'abgeschaltet' zu stellen.";
}
/*****************************************************************************/
VARIABLE nr_kenn_err
{
  CLASS     USER_INTERFACE;
  LABEL     "Characterization error number"
            "|de|Nr. Kennlinien-Fehler";
  TYPE      ENUMERATED
  {
      {  0,  "0 "},
      {  1,  "1 "},
      {  2,  "2 "},
      {  3,  "3 "},
      {  4,  "4 "},
      {  5,  "5 "},
      {  6,  "6 "},
      {  7,  "7 "},
      {  8,  "8 "},
      {  9,  "9 "},
      { 10, "10 "}
  }
  HELP "Characterization error number: error number of wrong point."
       "|de|Nr. Kennlinien-Fehler: Nummer des fehlerhaften Kennlinienpunktes.";
}
/*****************************************************************************/
VARIABLE anbaulage
{
  CLASS     DEVICE;
  LABEL     "Mounting position"
            "|de|Anbaulage";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Arrow pointing away from actuator"
           "|de|Pfeil zeigt vom Antrieb weg"},
      { 1, "Arrow pointing toward the actuator"
           "|de|Pfeil zeigt zum Antrieb hin"}
  }
  VALIDITY
    IF (antrieb == HUBANTRIEB)
        { TRUE; }
    ELSE
        { FALSE; }

  HELP "Mounting position: An arrow is located on the cover plate of the"
       " positioner which is used for alignment on the actuator. This arrow"
       " must either point toward the actuator (direct attachment) or away"
       " from the actuator (NAMUR attachment). (Exception: Control valves for"
       " which the seat is solely closed by a retracting actuator stem. In"
       " this case, the arrow must point either away from the actuator"
       " (direct attachment) or toward the actuator (NAMUR attachment)."
       " Omit this parameter for rotary type (part turn) actuators."
       "|de|Anbaulage: Auf der Abdeckplatte des Stellungsreglers befindet"
       " sich ein Pfeil, der zur Ausrichtung auf den Antrieb dient. Bei"
       " Direktanbau muss dieser Pfeil zum Antrieb hin und bei NAMUR-Anbau"
       " vom Antrieb weg zeigen. (Ausnahme: Stellgerte, bei denen der Sitz"
       " ausschliesslich durch eine einfahrende Antriebsstange geschlossen"
       " wird. Hier muss der Pfeil bei Direktanbau vom Antrieb weg und bei"
       " NAMUR-Anbau zum Antrieb hin zeigen.) Bei Schwenkantrieben entfllt"
       " dieser Parameter.";
}
/*****************************************************************************/
VARIABLE init_art
{
  CLASS     DEVICE;
  LABEL		"Initialization method"
            "|de|Initialisierungsart";
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED
  {
      { 0, "Maximum range"
           "|de|Maximalbereich",
           "Initialization related to the maximum range:"
	       " This method uses the maximum travel range of the valve. The"
	       " positioner will later control the complete detected travel range."
	       " The entered nominal travel / angle does not limitate the actual"
	       " stroke. Nevertheless, the value for the nominal travel / angle"
	       " should be entered as accurate as possible. This method should be"
	       " used for valves with two mechanical stops at both final positions"
	       " e.g. three way valves. In this case please set 'End position when"
	       " above' to 99.0 %."
           "|de|Initialisierung im Maximalbereich:"
	       " Bei der Initialisierung wird der maximal mgliche Stellbereich"
	       " durchfahren. Der Stellungsregler regelt anschliessend ber den"
	       " gesamten ermittelten Maximalbereich. Der eingegebene Nennhub /"
	       " -winkel bewirkt keine Einschrnkung. Trotzdem sollte der Wert fr"
	       " den Nennhub / -winkel so genau wie mglich eingegeben werden."
	       " Sinnvoll bei allen Ventilen, bei denen beide Endlagen mechanisch"
	       " begrenzt sind (z.B. 3Wege-Ventile). Hierbei bitte den Parameter"
	       " 'Endlage bei grer' auf 99.0 % setzen."
      },

      { 1, "Nominal range"
           "|de|Nennbereich",
           "Initialization related to the nominal range:"
           " This method is related to the travel range entered under nominal"
	       " stroke / angle. This method should be used for valves with only one"
           " mechanical stop e.g. globe valves."
	       "|de|Initialisierung im Nennbereich:"
	       " Bei der Initialisierung wird nur der unter Nennhub/Nennwinkel"
	       " eingegebene Stellbereich bercksichtigt. Sinnvoll bei allen"
	       " Ventilen mit nur einer mechanisch begrenzten Endlage."
      }
  }
  POST_EDIT_ACTIONS
  {
    meld_init_art   /* Methode */
  }
  HELP "Initialization related to: Initialization related to nominal or"
       " maximun range."
       "|de|Initialisierung bezogen auf: Initialisierung bezogen auf Nenn- oder"
       " Maximalbereich.";
}
/*****************************************************************************/
VARIABLE x_test
{
  CLASS     DEVICE;
  LABEL     "Test value for X"
            "|de|Testwert fr X";
  HANDLING  READ & WRITE;
  TYPE      FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE       0.0;
      MAX_VALUE     120.0;
  }
  CONSTANT_UNIT "%";
  HELP "Test value for X: Value to test the optional position transmitter."
       "|de|Testwert fr X: Wert zum Testen der Option Stellungsmelder.";
}
/*****************************************************************************/
VARIABLE response_code
{
  HELP [command_specific_response_code_help];
/*
  APPHELP "NOTE- HART Revisions < 5 had a different specification for this"
	  " variable."
	  " "
	  "The Following Applies to HART Revision >= 5"
	  " Command Specific Response Codes are encoded in bits #6 - #0 of the"
	  " first byte of the Response Codes. These codes are 7-bit unsigned"
	  " integers, have values ranging from 0 to 127, and are not bit-mapped."
	  " "
	  "The Command Specific Response Codes have symbolic meanings which"
	  " fall into the following basic types:"
	  " "
	  "Success- Command executed properly. All Data Bytes are"
	  "         included in the Slave response."
	  " "
	  "Warning- Command executed was completed with a deviation, and the"
	  "         is described in the Command Specific Response Code."
	  "         All Data Bytes are included in the Slave response."
	  " "
	  "    Warnings with singular definitions are assigned to Command"
	  "    Specific Response Codes: 24-27, 96-111."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "    Warnings with multiple definitions are assigned to Command"
	  "    Specific Response Codes: 8, 14, 30, 31, 112-127."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "Error- Command execution was not completed, as defined by the"
	  "       Command, and the Command Specific Response Code indicates the"
	  "       reason. Therefore the Host request caused no change to"
	  "       occur in the Slave."
	  "       No Data Bytes, other than the two Response Code"
	  "       Bytes, should be included in the Slave response."
	  " "
	  "These basic types are further broken down into specific"
	  " 'Response Code Types'. See the Device Description Language
	  " Specification for the definitions of these 'Response Code Types'."
	  " "
	  "    Errors with singular definitions are assigned to Command"
	  "    Specific  Response Codes: 0-7, 16-23, 32, 33-63, 64."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "        Response Codes #32 and #64 may be returned in response to"
	  "        any command. Their definitions follow:"
	  " "
	  "            Response Code #32"
	  "                Busy- The Field Device is performing a function that"
	  "                cannot be interrupted by this command. The Command"
	  "                was not accepted."
	  " "
	  "            Response Code #64"
	  "                Command Not Implemented- The Command was not"
	  "                defined for this device. The Command was not"
	  "                accepted."
	  " "
	  "    Errors with multiple definitions are assigned to Command"
	  "    Specific Response Codes: 9-13, 15, 28, 29, 65-95."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "NOTE- General definitions for Command Specific Response Codes"
	  "are located in the Document 'Appendix 1- Command Specific Response"
	  "Code Definitions'."
	  " "
	  "    NOTE- These assignments must be observed whenever new Command"
	  "    Specific Response Codes are defined and added to existing, or"
	  "    new, commands so that the Master can respond properly to the"
	  "    new code.";
	  " HART_VAR:Part of the Frame, RESP-CODE BYTE 1";
*/
  CLASS  LOCAL & DIAGNOSTIC;
  TYPE   ENUMERATED
    {
		{ 0,  [success] },
		{ 1,  [undefined] },
		{ 2,  [invalid_selection] },
		{ 3,  [passed_parameter_too_large] },
		{ 4,  [passed_parameter_too_small] },
		{ 5,  [too_few_data_bytes_recieved] },
		{ 6,  [xmtr_specific_command_error] },
		{ 7,  [in_write_protect_mode] },
		{ 8,  [xmtr_specific_command_error] },
		{ 9,  [xmtr_specific_command_error] },
		{ 10, [xmtr_specific_command_error] },
		{ 11, [xmtr_specific_command_error] },
		{ 12, [xmtr_specific_command_error] },
		{ 13, [xmtr_specific_command_error] },
		{ 14, [xmtr_specific_command_error] },
		{ 15, [xmtr_specific_command_error] },
		{ 16, [access_restricted] },
		{ 32, [busy] },
		{ 64, [command_not_implemented] }
	}
  HANDLING READ;  /*  ??? eingefgt, lt. Spez. READ/Write  */
}
/*****************************************************************************/
VARIABLE communication_status	  /*  ??? eingefgt */
{
	CLASS	LOCAL;
	TYPE	BIT_ENUMERATED
    {
		{ 0x01, [communication_error]		},
		{ 0x02, [buffer_overflow]			},
		{ 0x08, [longitudinal_parity_error] },
		{ 0x10, [framing_error]				},
		{ 0x20, [overrun_error]				},
		{ 0x40, [vertical_parity_error]		}
	}
  HANDLING READ;
}
/*****************************************************************************/
VARIABLE device_status
{
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    LABEL	[device_status] ;
	HELP	[field_device_status_help];
/*
    APPHELP "This condition does not affect the actions of the Command in the"
	        " Master request. Therefore, does not affect the number of Data Bytes"
	        " in the Slave response."
	        " The Communications Error Summary is a higher priority diagnostic."
	        " Therefore, the Field Device Status should not be evaluated by the"
	        " Host if a Communications Error Summary bit is set."
	        " These specific bits can be given attributes called 'Cause Status"
	        " Classes'. See the Device Description Language Specification for the"
	        " definitions of these 'Cause Status Classes'."
	        " HART_VAR:Part of the Frame, RESP-CODE BYTE 2";
*/
  TYPE BIT_ENUMERATED
    {
        { 0x00, [no_error],                    MISC },
    	{ 0x01, [PV_out_of_limits],	           DV1 (AUTO & BAD) },
    	{ 0x02, [Non_PV_out_of_limits],        DV2 (AUTO & BAD) },
    	{ 0x04, [PV_analog_output_saturated],  AO1 (AUTO & BAD) },
    	{ 0x08, [PV_analog_output_fixed],      AO1 (MANUAL & GOOD) },
    	{ 0x10, [more_status_available],       MORE },
    	{ 0x20, [cold_start],		           MISC },
    	{ 0x40, [configuration_changed],       MISC & IGNORE_IN_HANDHELD },
    	{ 0x80, [device_malfunction],	       MORE }
    }
  HANDLING READ;
#ifdef _V510_
    STYLE "MULTILINE 12 4"; /* 4 Zeilen hoch */
#endif
}
/*****************************************************************************/
VARIABLE manufacturer_id
{
  CLASS     DEVICE;
  HELP [manufacturer_id_code_help];
/*
  APPHELP "For HART Revision >= 5
	  "    The long address of the frame is composed of the three variables"
	  "    manufacturer_id, device_type, and the device_id. The Long"
	  "    address is composed of 38 bits. The most significant bit is"
	  "    closest to the Delimiter Byte. Thus the least significant"
	  "    bit is located closest to the Command Byte. The least"
	  "    significant 6 bits of the variable manufacturer_id are mapped"
	  "    into the 6 most significant 6 bits of the long address. Note"
	  "    that the 2 most significant bits of the variable manufacturer_id"
	  "    are thrown away. The variable manufacturer_id is mapped into the"
	  "    next 8 most significant bits of the long address, and the"
	  "    device_id is mapped into the next 24 most significant bits of"
	  "    the long address."
	  " "
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, will uniquely identify a type of Field Device. The"
	  "    combination of these two variables will have only one unique"
	  "    Device Description, though there may be revisions of the Device"
	  "    Description."
	  " "
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, combined with the variable transmitter_revision,"
	  "    will identify the exact revision of the Device Description for"
	  "    this type of Field Device."
	  " "
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, combined with the variable device_id, will"
	  "    uniquely identify a Field Device, such that there is only one"
	  "    such Field Device in the world."
	  " "
	  " NOTE- For HART Revision >= 5, the decimal numeric 254 that precedes"
	  " the manufacturer_id variable in Command #0 (i.e. one byte closer to"
	  " the Delimiter Byte), is part of an expansion mechanism that existed"
	  " for HART" Revisions < 5."
	  " NOTE- Rosemount Inc. subsidiaries should use their enumeration and"
	  " not 'Rosemount Inc.'.
	  " HART_VAR:MFR ID";
*/
  CLASS HART;
/*  LABEL [manufacturer_id]; */
  LABEL "Manufacturer" "|de|Hersteller";
  HANDLING READ;
  TYPE ENUMERATED
    {
      { 1,   [Acromag] },
      { 2,   [Allen_Bradley] },
      { 3,   [Ametek] },
      { 4,   [Analog_Devices] },
      { 5,   [Bailey] },
      { 6,   [Beckman] },
      { 7,   [Bell_Microsensor] },
      { 8,   [Bourns] },
      { 9,   [Bristol_Babcock] },
      { 10,  [Brooks_Instrument] },
      { 11,  [Chessell] },
      { 12,  [Combustion_Engineering] },
      { 13,  [Daniel_Industries] },
      { 14,  [Delta] },
      { 15,  [Dieterich_Standard] },
      { 16,  [Dohrmann] },
      { 17,  [Endress_and_Hauser] },
      { 18,  [Fischer_and_Porter] },
      { 19,  [Fisher_Controls] },
      { 20,  [Foxboro] },
      { 21,  [Fuji] },
      { 22,  [Hartmann_and_Braun] },
      { 23,  [Honeywell] },
      { 24,  [ITT_Barton] },
      { 25,  [KayRay_Sensall] },
      { 26,  [Kent] },
      { 27,  [Leeds_and_Northrup] },
      { 28,  [Leslie] },
      { 29,  [M_System_Co] },
      { 30,  [Measurex] },
      { 31,  [Micro_Motion] },
      { 32,  [Moore_Industries] },
      { 33,  [Moore_Products] },
      { 34,  [Ohkura_Electric] },
      { 35,  [Paine] },
      { 36,  [Rochester_Instrument_Systems] },
      { 37,  [Ronan] },
      { 38,  [Rosemount] },
      { 39,  [Peek_Measurement] },
      { 40,  [Schlumberger] },
      { 41,  [Sensall] },
      { 42,  [Siemens] },
      { 43,  [Camille_Bauer] },
      { 44,  [Toshiba] },
      { 45,  [Transmation] },
      { 46,  [Rosemount_Analytical] },
      { 47,  [Valmet] },
      { 48,  [Valtek] },
      { 49,  [Varec] },
      { 50,  [Viatran] },
      { 51,  [Weed] },
      { 52,  [Westinghouse] },
      { 53,  [Xomox] },
      { 54,  [Yamatake] },
      { 55,  [Yokogawa] },
      { 56,  [Nuovo_Pignone] },
      { 57,  [Promac] },
      { 58,  [Exac_Corporation] },
      { 59,  [KDG_Mobrey] },
      { 60,  [Acrom_Control_System] },
      { 61,  [Princo] },
      { 62,  [Smar] },
      { 63,  [Eckardt] },
      { 64,  [Measurement_Technology] },
      { 65,  [Applied_System_Technologies] },
      { 66,  [Samson] },
      { 67,  [Sparling_Instruments] },
      { 68,  [Fireye] },
      { 69,  [Krohne] },
      { 70,  [Betz_Equipment] },
      { 71,  [Druck] },
      { 72,  [SOR] },
      { 73,  [Elcon_Instruments] },
      { 74,  [EMCO] },
      { 75,  [Termiflex] },
      { 76,  [VAF_Instruments] },
      { 77,  [Westlock_Controls] },
      { 78,  [Drexelbrook] },
      { 80,  [K_TEK] },
      { 81,  [Flowdata] },
      { 82,  [Draeger] },
	  { 83,  [Raytek] },
	  { 84,  [Meridian_Instruments] },
	  { 85,  [BTG] },
	  { 86,  [Magnetrol] },
	  { 87,  [Neles_Jamesbury] },
	  { 88,  [Milltronics] },
	  { 89,  [HELIOS] },
      { 90,  [Anderson_Instrument_Company] },
      { 91,  [INOR] },
      { 92,  [ROBERTSHAW] },
      { 93,  [PEPPERL_FUCHS] },
      { 94,  [ACCUTECH] },
      { 95,  [Flow_Measurement] },
      { 96,  [KAMSTRUP] },
      { 97,  [Knick] },
      { 98,  [VEGA] },
      { 99,  [MTS_SYS_CORPS_SENSORS] },
      { 100, [Oval] },
      { 101, [Masoneilan_DRESSER] },
      { 102, [Besta] },
      { 103, [Ohmart] },

      { 250, [not_used] },
      { 251, [none] },
      { 252, [unknown] },
      { 253, [special] }
    }
}
/*****************************************************************************/
VARIABLE device_type
{
	CLASS		HART;
	LABEL		"Positioner type no."
	            "|de|Typ-Nr. Regler";
	HANDLING	READ;
	TYPE		ENUMERATED (1)
	{
        { 249, "3780"    },
		{ 252, [unknown] }
	}
    HELP "Positioner type no.: Type number of the positioner."
         "|de|Typ-Nr. Regler: Typnummer des Stellungsreglers.";
}
/*****************************************************************************/
VARIABLE request_preambles
{
  CLASS     HART;
  LABEL     [number_of_request_preambles];
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MIN_VALUE   2;
	MAX_VALUE  20;
  }
  HELP [number_of_request_preambles_help];
/*
  APPHELP "The valid range of values is dependant on the technology of"
	  " the Hardware of the Physical Layer. The magnitude of this number"
	  " includes the two preambles required by the Data Link Layer."
	  " NOTE- This variable can affect the Data Link Layer."
	  " HART_VAR:NUMBER RQUEST PREAM";
*/
}
/*****************************************************************************/
VARIABLE universal_revision
{
  CLASS     HART;
  LABEL     [universal_revision];
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MAX_VALUE  253;
  }
  HELP [universal_revision_help];
/*
  APPHELP "The variable universal_revision in effect defines for the"
	  " Master how to interpret the valid Universal Command set, and also"
	  " how to send and receive the Universal Commands. Therefore, this"
	  " variable must be obtained from a Command #0 response to be able to"
	  " interpret any Universal Command. Thus to properly interpret any"
	  " Burst Mode response, the Master should know the Universal Revision"
	  " of that Slave."
	  " "
	  " NOTE- The HART Revision is a variable that is not available via the"
	  " protocol. This Revision identifies the a point in time where all"
	  " HART Documents were recorded, and was made available to Field Device"
	  " Developers as a valid set of documents for which to design a Field"
	  " Device to. Field Device Developers then can not pick and choose a"
	  " HART Document set at random."

	  " NOTE- For HART Revision <= 5 the following HART Specification"
	  " Revisions are not available via the protocol for the Physical Layer:"
	  " 'HART Physical Layer Specification'."

	  " NOTE- For HART Revision <= 5 the following HART Specification"
	  " Revisions are not available via the protocol for the Data Link"
	  " Layer: 'HART Data Link Layer Specification'."

	  " NOTE- For HART Revision <= 5 the following HART Specification"
	  " Revisions are not available via the protocol for the Application"
	  " Layer: 'HART Command Summary Information', 'HART Common"
	  " Practice Command Specification', 'HART Common Tables', 'HART"
	  " Appendix 1- Command Specific Response Code Definitions'."

	  " NOTE- A Field Device Description implicitly encodes the required"
	  " Application Layer Revisions that are required to communicate with"
	  " that Field Device."

	  " NOTE- If the Master attempts to communicate with a Field Device"
	  " that it does not have a Field Device Description for, it technically"
	  " has no way to ascertain the exact Common Practice Revision of Common"
	  " Tables Revision to utilize. It is possible by the variable"
	  " universal_revision to ascertain a minimum Common Practice Revision"
	  " and Common Tables Revision."

	  " NOTE- Value 254 is 'Reserved'."
	  " HART_VAR:UNIV CMD REV";
*/
}
/*****************************************************************************/
VARIABLE transmitter_revision
{
  CLASS     HART;
/*  LABEL     [transmitter_revision]; */
  LABEL     "Device Revision"
            "|de|Feldgerte-Revision";
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MAX_VALUE  253;
  }
  HELP [field_device_revision_help];
/*
  APPHELP "This variable in effect defines aspects of the Application"
	  " Layer, Data Link Layer, and Physical Layer, in that a HART Revision"
	  " was implicitly conformed to in the design of this Field Device"
	  " NOTE- Value 254 is 'Reserved'."
	  " HART_VAR:TRANS SPEC REV";
*/
}
/*****************************************************************************/
VARIABLE software_revision
{
  CLASS     DEVICE;
  LABEL     [software_revision];
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MAX_VALUE  253;
  }
  HELP [field_device_software_revision_help];
/*
  APPHELP "For a specific value of the variable transmitter_revision the"
	  " variable software_revision be initiated at a value of '1'. This"
	  " count should be incremented for each released software modification."
	  " If the variable transmitter_revision is incremented the variable"
	  " software_revision be initiated once again to a value of '1', and so"
	  " forth. This variable could potentially be utilized as a handle for"
	  " recalling Field Devices with a software discrepancy."
	  " NOTE- Value 254 is 'Reserved'."
	  " HART_VAR:SOFT REV";
*/
}
/*****************************************************************************/
VARIABLE hardware_revision
{
  CLASS     DEVICE;
  LABEL     [hardware_revision];
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER;
  HELP      [hardware_revision_help];
/*
  APPHELP "The Field Device Hardware revision should be utilized"
	  " to track what ever level of modifications are desired. However,"
	  " please note the limited number of possible revisions. Also please"
	  " note that in many hardware / software configurations the software"
	  " can be removed from the hardware to be upgraded, moved, etc.. In"
	  " this situation the variable hardware_revision must not reside in the"
	  " software, but should be readable via from the actual hardware"
	  " itself."
	  " NOTE- Value 15 is Reserved for the Field Device Hardware Revision"
	  " component called the variable hardware_revision."
	  " HART_VAR:HARD REV";
*/
}
/*****************************************************************************/
VARIABLE physical_signaling_code
{
  CLASS     DEVICE;
  LABEL     [physical_signalling_code];
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, [bell_202_current] },
      { 1, [bell_202_voltage] },
      { 2, [rs_485] },
      { 3, [rs_232], [rs_232_help] },
      { 6, [special] }
  }
  HELP	[physical_signalling_code_help];
/*
  APPHELP "";
*/
}
/*****************************************************************************/
VARIABLE device_flags
{
  CLASS     HART;
  LABEL     [device_flags];
  HANDLING  READ;
  TYPE      BIT_ENUMERATED
  {
      { 0x01, [Multisens_Dev], [multi_sensor_fld_dev] },
      { 0x02, [EEPROM_Ctrl] },
      { 0x04, [protocol_bridge_device] }
  }
  HELP [field_device_flags_help];
/*
  APPHELP "NOTE- The enumeration '1' does not conform to the help description."
	  " HART_VAR:FLAGS";
*/
}
/*****************************************************************************/
VARIABLE device_id
{
  CLASS     HART;
  LABEL     "Serial number"
            "|de|Seriennummer";
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER (3);
  HELP "Serial number: Serial number of the positioner."
  	   "|de|Seriennummer: Seriennummer des Stellungsreglers.";
/*
  APPHELP "This variable should be written into the Field Device in the"
	  " manufacturing process. This variable should be initiated at value"
	  " '1' and incremented for each Field Device created that has the"
	  " same set of values for the variables manufacturer_id and"
	  " device_type."
	  " HART_VAR:DEVICE ID NUMBER";
*/
}
/*****************************************************************************/
VARIABLE polling_address
{
  CLASS     HART;
  LABEL     [polling_address];
  HANDLING  WRITE;
  TYPE      UNSIGNED_INTEGER
  {
        DISPLAY_FORMAT "2d";
        EDIT_FORMAT    "2d";
        MIN_VALUE       0;
        MAX_VALUE      15;
  }
  HELP [polling_address_help];
/*
  APPHELP "NOTE- This variable can affect the Data Link Layer."
	  " NOTE- This variable can affect the Multidrop Mode in the Field"
	  " Device. Value > 0 enables the Multidrop Mode for"
	  " Analog Output 1)."
	  " NOTE- This variable can affect the Analog Output Fixed Mode in the"
	  " Field Device." Value > 0 enables the Analog Output Fixed Mode for
	  " Analog Output 1)."
	  " HART_VAR:POLL ADDR";
*/
}
/*****************************************************************************/
VARIABLE tag
{
  CLASS     DEVICE;
  LABEL     [tag];
  TYPE      PACKED_ASCII (8);
  HANDLING  READ & WRITE;
  HELP      [tag_help];
/*
  APPHELP "HART_VAR:TAG";
*/
}
/*****************************************************************************/
VARIABLE message
{
  CLASS     DEVICE;
  LABEL     [message];
  TYPE      PACKED_ASCII (32);
  HANDLING  READ & WRITE;
  HELP      [message_help];
/*
  APPHELP "HART_VAR:MESSAGE";
*/
}
/*****************************************************************************/
VARIABLE descriptor
{
  CLASS     DEVICE;
  LABEL     [descriptor];
  TYPE      PACKED_ASCII (16);
  HANDLING  READ & WRITE;
  HELP      [discriptor_help];
/*
  APPHELP "HART_VAR:DESCR";
*/
}
/*****************************************************************************/
VARIABLE date
{
  CLASS     DEVICE;
  LABEL     [date];
  TYPE      DATE;
  HANDLING  READ & WRITE;
  HELP      [date_help];
/*
  APPHELP "Format: Byte closest to the delimiter: Day, Next Byte: Month,
	  " Byte durthest from the delimiter: Year-1900.
	  " HART_VAR:DATE";
*/
}
/*****************************************************************************/
VARIABLE write_protect
{
  CLASS     DEVICE;
  LABEL     [write_protect];
  HANDLING  READ;
  TYPE      ENUMERATED
  {
		{   0,	[not_write_protected] },
		{   1,	[write_protected] },
        { 250,  [not_used] },
        { 251,  [none] }
  }
  HELP [write_protect_mode_help];
/*
  APPHELP "Common uses for the write_protect variable are to limit user access"
	  " for Field Devices installed in custody transfer applications."
	  " HART_VAR:WRITE PROT CODE";
*/
}
/*****************************************************************************/
VARIABLE private_label_distributor
{
  CLASS     DEVICE;
  LABEL     [private_label_distributor];
  HANDLING  READ;
  TYPE      ENUMERATED
  {
		/* ???MANUFACTURER_CODES */
        { 42,  [Siemens]},
        { 66,  [Samson] }
  }
  HELP [private_label_distributor_help];
/*
  APPHELP "This variable may or may not be the same as the variable"
	  " manufacturer_id."
	  " NOTE- Rosemount Inc. subsidiaries should use their enumeration and"
	  " not 'Rosemount Inc.'.
	  " HART_VAR:PVT LABEL DIST CODE";
*/
}
/*****************************************************************************/
VARIABLE final_assembly_number   /* Ident.-Nr. Ventil */
{
  CLASS     DEVICE;
  LABEL     "Serial number"
            "|de|Seriennummer";
  HANDLING  READ & WRITE;
  TYPE      UNSIGNED_INTEGER (3)
  {
	MAX_VALUE   16777215;
	EDIT_FORMAT "8u" ;
  }
  HELP [final_assembly_number_help];
/*
  APPHELP "For Universal Revision < 5
	  "  If the decimal numeric 254 that precedes"
	  "  the manufacturer_id variable in Command #0 (i.e. one byte closer"
	  "  to the Delimiter Byte), that is part of an expansion mechanism"
	  "  is used."
	  ""
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, will uniquely identify a type of Field Device. The"
	  "    combination of these two variables will have only one unique "
	  "    Device Description, though there may be revisions of the Device"
	  "    Description."
	  ""
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, combined with the variable transmitter_revision,"
	  "    will identify the exact revision of the Device Description for"
	  "    this type of Field Device."
	  ""
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, combined with the variable final_assembly_number,"
	  "    will possibly uniquely identify a Field Device. The word"
	  "    'possibly' was used since the variable final_assembly_number is"
	  "    modifiable by the protocol."
	  ""
	  "  If the decimal numeric 254 that would precede"
	  "  the manufacturer_id variable in Command #0 (i.e. one byte closer"
	  "  to the Delimiter Byte), that is part of an expansion mechanism"
	  "  is not used."
	  ""
	  "    The variable manufacturer_id, is not present and is therefore"
	  "    assumed to be 'Rosemount Inc.'."
	  ""
	  "    The variable device_type, combined with the variable"
	  "    transmitter_revision, will identify the exact revision of the"
	  "    Device Description for this type of 'Rosemount Inc. Field"
	  "    Device."
	  ""
	  "    The variable device_type, combined with the variable"
	  "    transmitter_revision, combined with the variable"
	  "    final_assembly_number, will possibly uniquely identify a Field"
	  "    Device. The word" 'possibly' was used since the variable"
	  "    final_assembly_number is" modifiable by the protocol."
	  ""
	  "NOTE- The variable final_assembly_number in Command #0 of Universal"
	  "Revision < 5, was replaced by the variable device_type in Command #0"
	  "of Universal Revision > 5."
	  "HART_VAR:FINAL ASS'Y NUMBER";
*/
}
/*****************************************************************************/
VARIABLE xmtr_specific_status_0
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
	LABEL      [xmtr_specific_status_0];
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
		{ 0x01, "No current data available"
                "|de|Keine aktuellen Daten" },
		{ 0x02, "Control data memory error"
                "|de|Datenspeicher Regelung defekt" },
		{ 0x04, "Communication data memory error"
                "|de|Datenspeicher Kommunikation defekt" },
		{ 0x08, "Checksum error control data memory"
                "|de|Prfsummenfehler Datenspeicher Regelung" },
		{ 0x10, "Checksum error communication data memory"
                "|de|Prfsummenfehler Datenspeicher Kommunikation" },
		{ 0x20, "Internal control loop error"
                "|de|Interner Regelkreis gestrt" },
		{ 0x40, "Choose manual mode"
                "|de|Betriebsart Hand whlen" },
		{ 0x80, "Parameter not supported"
                "|de|Parameter nicht untersttzt" }

/*		{ 0x00, [no_error],MISC },
		{ 0x01, [fld_dev_stat1_1],MISC },
		{ 0x02, [fld_dev_stat1_2],MISC },
		{ 0x04, [fld_dev_stat1_3],MISC },
		{ 0x08, [fld_dev_stat1_4],MISC },
		{ 0x10, [fld_dev_stat1_5],MISC },
		{ 0x20, [fld_dev_stat1_6],MISC },
		{ 0x40, [fld_dev_stat1_7],MISC },
		{ 0x80, [fld_dev_stat1_8],MISC }  */
	}
	HELP [field_device_status_0_help];
/*
	APPHELP "HART_VAR:XMTR SPEC STATUS"
		" These specific bits can be given attributes called 'Cause Status"
		" Classes'. See the Device Description Language Specification for the"
		" definitions of these 'Cause Status Classes'.";
*/
#ifdef _V510_
    STYLE "MULTILINE 12 4"; /* 4 Zeilen hoch */
#endif
}
/*****************************************************************************/
VARIABLE xmtr_specific_status_1
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
	LABEL      [xmtr_specific_status_1];
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
		{ 0x01, "Device not initialized"
                "|de|Gert nicht initialisiert" },
		{ 0x02, "Initialization in process"
                "|de|Initialisierung in Bearbeitung" },
		{ 0x04, "Calibration failed"
                "|de|Initialisierung fehlerhaft" },
		{ 0x08, "Zero point adjustment in process"
                "|de|Nullpunktabgleich in Bearbeitung" },
		{ 0x10, "Zero point error"
                "|de|Nullpunktfehler" },
		{ 0x20, "Action aborted"
                "|de|Aktion abgebrochen" },
		{ 0x40, "Failure in measurement"
                "|de|Fehler in Messwerterfassung" }

/*		{ 0x00, [no_error],MISC },
		{ 0x01, [fld_dev_stat2_1],MISC },
		{ 0x02, [fld_dev_stat2_2],MISC },
		{ 0x04, [fld_dev_stat2_3],MISC },
		{ 0x08, [fld_dev_stat2_4],MISC },
		{ 0x10, [fld_dev_stat2_5],MISC },
		{ 0x20, [fld_dev_stat2_6],MISC },
		{ 0x40, [fld_dev_stat2_7],MISC },
		{ 0x80, [fld_dev_stat2_8],MISC }  */
	}
	HELP [field_device_status_1_help];
/*
	APPHELP "HART_VAR:XMTR SPEC STATUS"
		" These specific bits can be given attributes called 'Cause Status"
		" Classes'. See the Device Description Language Specification for the"
		" definitions of these 'Cause Status Classes'.";
*/
#ifdef _V510_
    STYLE "MULTILINE 12 4"; /* 4 Zeilen hoch */
#endif
}
/*****************************************************************************/
VARIABLE xmtr_specific_status_2
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
	LABEL      [xmtr_specific_status_2];
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
		{ 0x01, "Total valve travel exceeded"
                "|de|Grenzwert Wegintegral berschritten" },
		{ 0x02, "Parameter exceeds limits"
                "|de|Parameter ausserhalb Bereich" },
		{ 0x04, "Warm start executed"
                "|de|Warmstart ausgefhrt" },
		{ 0x08, "Controlled variable exceeds limits"
                "|de|Messwert Regelgre ausser Bereich" },
		{ 0x10, "Power supply too low"
                "|de|Hilfsenergie zu gering" },
		{ 0x20, "Defective mechanics / pneumatics"
                "|de|Fehler in Mechanik / Pneumatik" },
		{ 0x40, "Internal device error"
                "|de|Interner Gertefehler" },
		{ 0x80, "Characteristic not valid"
                "|de|Kennlinie ungltig" }

/*		{ 0x00, [no_error],MISC },
		{ 0x01, [fld_dev_stat3_1],MISC },
		{ 0x02, [fld_dev_stat3_2],MISC },
		{ 0x04, [fld_dev_stat3_3],MISC },
		{ 0x08, [fld_dev_stat3_4],MISC },
		{ 0x10, [fld_dev_stat3_5],MISC },
		{ 0x20, [fld_dev_stat3_6],MISC },
		{ 0x40, [fld_dev_stat3_7],MISC },
		{ 0x80, [fld_dev_stat3_8],MISC }  */
	}
	HELP [field_device_status_2_help];
/*
	APPHELP "HART_VAR:XMTR SPEC STATUS"
		" These specific bits can be given attributes called 'Cause Status"
		" Classes'. See the Device Description Language Specification for the"
		" definitions of these 'Cause Status Classes'.";
*/
#ifdef _V510_
    STYLE "MULTILINE 12 4"; /* 4 Zeilen hoch */
#endif
}
/*****************************************************************************/
VARIABLE xmtr_specific_status_3
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
	LABEL      [xmtr_specific_status_3];
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
		{ 0x01, "Error memory device information"
                "|de|Fehler Speicher Gerteinformation" },
		{ 0x02, "Characteristic monotony error"
                "|de|Kennlinie Monotoniefehler" },
		{ 0x04, "Characteristic gradient error"
                "|de|Kennlinie Steigungsfehler" },
		{ 0x08, "Error in option forced venting"
                "|de|Fehler in Option Zwangsentlftung" },
		{ 0x10, "Diagnosis in process"
                "|de|Diagnosefunktion aktiv" }

/*		{ 0x00, [no_error],MISC },
		{ 0x01, [fld_dev_stat4_1],MISC },
		{ 0x02, [fld_dev_stat4_2],MISC },
		{ 0x04, [fld_dev_stat4_3],MISC },
		{ 0x08, [fld_dev_stat4_4],MISC },
		{ 0x10, [fld_dev_stat4_5],MISC },
		{ 0x20, [fld_dev_stat4_6],MISC },
		{ 0x40, [fld_dev_stat4_7],MISC },
		{ 0x80, [fld_dev_stat4_8],MISC }  */
	}
	HELP [field_device_status_3_help];
/*
	APPHELP "HART_VAR:XMTR SPEC STATUS"
		" These specific bits can be given attributes called 'Cause Status"
		" Classes'. See the Device Description Language Specification for the"
		" definitions of these 'Cause Status Classes'.";
*/
#ifdef _V510_
    STYLE "MULTILINE 12 4"; /* 4 Zeilen hoch */
#endif
}
/*****************************************************************************/
VARIABLE transmitter_variable_code
{
    CLASS      LOCAL;
	LABEL	   [transmitter_variable_code];
    HANDLING   READ & WRITE;
	TYPE INDEX transmitter_variables;
	HELP       [index_into_dynamic_variables_array_help];
/*
	APPHELP "This variable can represent measured or calculated type variables."
		" The numeric assigned to a Field Device variable can never be"
		" changed. If it is changed this would be a violation of the Forward"
		" Compatibility rules."
		" HART_VAR:XMTR VAR CODE";
*/
}
/*****************************************************************************/
VARIABLE unit_tag
{
	CLASS      DEVICE;
	LABEL      [unit_tag];
    HANDLING   READ & WRITE;
	TYPE       PACKED_ASCII (8);
	HELP       [unit_tag_help];
/*
	APPHELP "A Field Device may have sub applications that require being"
		" addressed individually. For this addressing the Tag variable"
		" associated with Command #11 should be used. This Tag is used to"
		" identify the application that controls the sub applications. This"
		" Text can be used by the user in any way. A recommended use is as"
		" a unique label to a plant that correlates to a Field Device label:"
		" a plant drawing, or on a Control System."
		" NOTE- HART does not recommend using this variable. If you have an"
		" application that controls the sub applications, all of these"
		" applications should be addressed using the HART Frame itself."
		" HART_VAR:UNIT TAG";
*/
}
/*****************************************************************************/
VARIABLE unit_descriptor
{
	CLASS      DEVICE;
	LABEL      [unit_descriptor];
    HANDLING   READ & WRITE;
	TYPE       PACKED_ASCII (16);
	HELP       [unit_descriptor_help];
/*
	APPHELP "A Field Device may have sub applications that require being"
		" addressed individually. This Descriptor"
		" is used to identify the application that controls the sub"
		" applications. This text can be used by the user in any way. There is"
		" no recommended use.
		" NOTE- HART does not recommend using this variable. If you have an"
		" application that controls the sub applications, all of these"
		" applications should be addressed using the HART Frame itself."
		" HART_VAR:UNIT DESCR";
*/
}
/*****************************************************************************/
VARIABLE unit_date
{
	CLASS      DEVICE;
	LABEL      [unit_date];
    HANDLING   READ & WRITE;
	TYPE       DATE;
	HELP       [unit_date_help];
/*
	APPHELP "A Field Device may have sub applications that require being"
		" addressed individually. This Date is used to"
		" identify the application that controls the sub applications."
		" This text can be used by the user in any way. There is"
		" no recommended use.
		" Format: Byte Closest to the Delimiter: Day, Next Byte: Month,
		" Byte Furthest from the Delimiter: Year-1900.
		" NOTE- HART does not recommend using this variable. If you have an"
		" application that controls the sub applications, all of these"
		" applications should be addressed using the HART Frame itself."
		" HART_VAR:UNIT DATE";
*/
}
/*****************************************************************************/
VARIABLE response_preambles
{
	CLASS      HART;
	HELP	   [number_of_response_preambles_help];
	LABEL      [number_of_response_preambles];
	TYPE       UNSIGNED_INTEGER;
	HANDLING   WRITE;
}
/*****************************************************************************/
VARIABLE analog_output_code
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	LABEL	   [analog_output_number];
	HELP	   [analog_output_number_help];
	TYPE INDEX dynamic_variables;
}
/*****************************************************************************/
VARIABLE analog_output_code_1
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_one_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #0 ANALOG OUTPUT NUMBER CODE";
*/
}
/*****************************************************************************/
VARIABLE analog_output_code_2
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_two_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #1 ANALOG OUTPUT NUMBER CODE";
*/
}
/*****************************************************************************/
VARIABLE analog_output_code_3
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_two_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #2 ANALOG OUTPUT NUMBER CODE";
*/
}
/*****************************************************************************/
VARIABLE analog_output_code_4
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_four_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #3 ANALOG OUTPUT NUMBER CODE";
*/
}
/*****************************************************************************/
VARIABLE static_param_code
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_param_code1
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static1";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_param_code2
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static2";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_param_code3
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static3";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_param_code4
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static4";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_enums_code
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_enums_code1
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum1";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_enums_code2
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum2";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_enums_code3
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum3";
  HANDLING   READ & WRITE;
}
/*****************************************************************************/
VARIABLE static_enums_code4
{
  TYPE INDEX static_enums;
  LABEL      "enum4";
  HANDLING   READ & WRITE;
  CLASS      USER_INTERFACE;
}
/*****************************************************************************/
VARIABLE text_index
{
  TYPE INDEX user_text;
  LABEL      "texts";
  HANDLING   READ & WRITE;
  CLASS      USER_INTERFACE;
}

/*************************************************************************************/
VARIABLE primary_variable_code
{
	LABEL	[primary_variable_code];
	HELP	[primary_variable_code_help];
/*
	APPHELP "The Primary Variable has other related variables. The Primary"
		" Variable is represented in an approximate analog format on Analog"
		" Output #1, if such an Analog Output exists."
		" HART_VAR:PV XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 0 ;
	}

  HANDLING READ&WRITE;  /*  ??? eingefgt, lt. Spez. READ/Write  */
}

/*************************************************************************************/
VARIABLE secondary_variable_code
{
	LABEL	[secondary_variable_code];
	HELP	[secondary_variable_code_help];
/*
	APPHELP "The Secondary Variable has other related variables. The Secondary"
		" Variable is represented in an approximate analog format on Analog"
		" Output #2, if such an Analog Output exists."
		" HART_VAR:SV XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 1 ;
	}
  HANDLING READ&WRITE;  /*  ??? eingefgt, lt. Spez. READ/Write  */
}

/*************************************************************************************/
VARIABLE tertiary_variable_code
{
	LABEL	[tertiary_variable_code];
	HELP	[tertiary_variable_code_help];
/*
	APPHELP "The Tertiary Variable has other related variables. The Tertiary"
		" Variable is represented in an approximate analog format on Analog"
		" Output #3, if such an Analog Output exists."
		" HART_VAR:TV XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 2 ;
	}
  HANDLING READ&WRITE;  /*  ??? eingefgt, lt. Spez. READ/Write  */
}

/*************************************************************************************/
VARIABLE fourth_variable_code
{
	LABEL	[fourth_variable_code];
	HELP	[fourth_variable_code_help];
/*
	APPHELP "The Fourth Variable has other related variables. The Fourth"
		" Variable is represented in an approximate analog format on Analog"
		" Output #4, if such an Analog Output exists."
		" HART_VAR:4TH XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 3 ;
	}
  HANDLING READ&WRITE;  /*  ??? eingefgt, lt. Spez. READ/Write  */
}

/*************************************************************************************/
/* Relations                                                                         */
/*************************************************************************************/
/* REFRESH */
REFRESH antr
{
  antrieb : anbau, bauart, nennhub, nennwinkel, init_art
}
REFRESH anbau_geo
{
  anbau : stiftposition, h_laenge, h_code, anbaulage
}
REFRESH bau
{
  bauart : federwirkung
}
REFRESH initart
{
  init_art : vent_zu, vent_auf
}
REFRESH hub_1
{
  nennhub : hubanfang, hubende
}
REFRESH winkel_1
{
  nennwinkel : drehw_anfang, drehw_ende
}
REFRESH rfr_init
{
  xmtr_specific_status_1 : federwirkung, min_lauf_zu, min_lauf_ab, maxhub, init_warn
}
REFRESH hand_modus_2
{
  xmtr_specific_status_0, xmtr_specific_status_1,
  xmtr_specific_status_2, xmtr_specific_status_3	: betriebsart
}
REFRESH hand_modus_1
{
  betriebsart : w_hand
}
REFRESH grenz_kont
{
  ind_gr_kont : kenn_gr_kont
}
REFRESH kennlinientext
{
  eing_kl : kennlinientyp
}

/* UNIT RELATION */
/* (kmr: auskommentiert wegen Einheitenfehler)
UNIT pv_units_relation
{
  dynamic_variables[0].DIGITAL_UNITS:  dynamic_variables[0].DIGITAL_VALUE
}
UNIT sv_units_relation
{
  dynamic_variables[1].DIGITAL_UNITS:  dynamic_variables[1].DIGITAL_VALUE
}
UNIT tv_unit_relation
{
  dynamic_variables[2].DIGITAL_UNITS:  dynamic_variables[2].DIGITAL_VALUE
}
UNIT qv_unit_relation
{
  dynamic_variables[3].DIGITAL_UNITS:  dynamic_variables[3].DIGITAL_VALUE
}
*/
/*****************************************************************************/
/* COMMANDS                                                                  */
/*****************************************************************************/
/*****************************************************************************/
/*      UNIVERSAL COMMANDS                                                   */
/*****************************************************************************/
/* CMD #0 - READ UNIQUE IDENTIFIER  */
COMMAND read_unique_identifier
{
	NUMBER 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{	/* IDENTIFY_REPLY */
			response_code, device_status, 254, manufacturer_id, device_type,
			request_preambles, universal_revision, transmitter_revision,
			software_revision,hardware_revision <0xf8>, physical_signaling_code <0x07>,
			device_flags, device_id
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #1 - READ PRIMARY VARIABLE */
COMMAND read_pv
{
	NUMBER 1;
	OPERATION READ;
	TRANSACTION
    {
		REQUEST
		{}
		REPLY
		{
            response_code, device_status,
            dynamic_variables[0].DIGITAL_UNITS, dynamic_variables[0].DIGITAL_VALUE
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,		[no_command_specific_errors];
		6,	MISC_ERROR,		[xmtr_specific_command_error];
		8,	MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #2 - READ P.V. CURRENT AND PERCENT OF RANGE */
COMMAND read_pv_current_and_percent_range
{
	NUMBER 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
            response_code, device_status,
            dynamic_variables[0].ANALOG_VALUE, dynamic_variables[0].PERCENT_RANGE
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,		[no_command_specific_errors];
		6,	MISC_ERROR,		[xmtr_specific_command_error];
		8,	MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #3 - READ DYNAMIC VARIABLES AND P.V. CURRENT */
COMMAND read_dynamic_variables_and_pv_current
{
	NUMBER 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
    		response_code, device_status,
            dynamic_variables[0].ANALOG_VALUE,
            dynamic_variables[0].DIGITAL_UNITS, dynamic_variables[0].DIGITAL_VALUE,
            dynamic_variables[1].DIGITAL_UNITS, dynamic_variables[1].DIGITAL_VALUE,
            dynamic_variables[2].DIGITAL_UNITS, dynamic_variables[2].DIGITAL_VALUE,
            dynamic_variables[3].DIGITAL_UNITS, dynamic_variables[3].DIGITAL_VALUE
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,		[no_command_specific_errors];
		6,	MISC_ERROR,		[xmtr_specific_command_error];
		8,	MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #6 - WRITE POLLING ADDRESS */
COMMAND write_polling_address
{
	NUMBER 6;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			polling_address
		}
		REPLY
		{
			response_code, device_status, polling_address
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		6,	MISC_ERROR,			[xmtr_specific_command_error];
		7,	MODE_ERROR,			[in_write_protect_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #11 - READ UNIQUE IDENTIFIER ASSICIATED WITH TAG */
COMMAND read_unique_identifier_with_tag
{
	NUMBER 11;
	OPERATION COMMAND;
	TRANSACTION
	{
		REQUEST
		{
			tag
		}
		REPLY
		{	/* IDENTIFY_REPLY */
			response_code, device_status, 254, manufacturer_id, device_type,
			request_preambles, universal_revision, transmitter_revision,
			software_revision, hardware_revision <0xf8>, physical_signaling_code <0x07>,
			device_flags, device_id
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR,	[too_few_data_bytes_recieved];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #12 - READ MESSAGE */
COMMAND read_message
{
	NUMBER 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status, message
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #13 - READ TAG, DESCRIPTOR, DATE */
COMMAND read_tag_descriptor_date
{
	NUMBER 13;
	OPERATION READ;
	TRANSACTION
	{
    	REQUEST
		{}
		REPLY
		{
			response_code, device_status, tag, descriptor, date
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #14 - READ PRIMARY VARIABLE SENSOR INFORMATION */
COMMAND read_pv_sensor_info
{
	NUMBER 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
            dynamic_variables[0].SENSOR_SERIAL_NUMBER, dynamic_variables[0].SENSOR_UNITS,
            dynamic_variables[0].UPPER_SENSOR_LIMIT,   dynamic_variables[0].LOWER_SENSOR_LIMIT,
            dynamic_variables[0].MINIMUM_SPAN
		}
	}
	RESPONSE_CODES
	{
		0,  SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #15 - READ PRIMARY VARIABLE OUTPUT INFORMATION */
COMMAND read_pv_output_info
{
	NUMBER 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
            dynamic_variables[0].ALARM_CODE,     dynamic_variables[0].TRANSFER_FUNCTION,
            dynamic_variables[0].RANGE_UNITS,    dynamic_variables[0].UPPER_RANGE_VALUE,
            dynamic_variables[0].LOWER_RANGE_VALUE,
            dynamic_variables[0].DAMPING_VALUE, write_protect, private_label_distributor
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #16 - READ FINAL ASSEMBLY NUMBER */
COMMAND read_final_assembly_number
{
	NUMBER 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status, final_assembly_number
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #17 - WRITE MESSAGE */
COMMAND write_message
{
	NUMBER 17;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			message
		}
		REPLY
		{
			response_code, device_status, message
		}
    }
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR, [too_few_data_bytes_recieved];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #18 - WRITE TAG, DESCRIPTOR, DATE */
COMMAND write_tag_descriptor_date
{
	NUMBER 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			tag, descriptor, date
		}
		REPLY
		{
			response_code, device_status, tag, descriptor, date
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR, [too_few_data_bytes_recieved];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #19 - WRITE FINAL ASSEMBLY NUMBER */
COMMAND write_final_assembly_number
{
	NUMBER 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			final_assembly_number
		}
		REPLY
		{
			response_code, device_status, final_assembly_number
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR, [too_few_data_bytes_recieved];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/*      COMMON PRACTICE COMMANDS                                             */
/*****************************************************************************/
/* CMD #38 - RESET CONFIGURATION CHANGED FLAG */
COMMAND reset_configuration_change_flag
{
	NUMBER 38;
	OPERATION COMMAND;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #48 - READ ADDITIONAL TRANSMITTER STATUS */
COMMAND read_additional_transmitter_status
{
	NUMBER 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
			xmtr_specific_status_0,
			xmtr_specific_status_1,
			xmtr_specific_status_2,
			xmtr_specific_status_3
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,       [no_command_specific_errors];
		6,	MISC_ERROR,	   [xmtr_specific_command_error];
		8,	MISC_WARNING,  [update_in_progress];
		16,	MODE_ERROR,    [access_restricted];
	}
}
/*****************************************************************************/
/* CMD #50 - READ DYNAMIC VARIABLE ASSIGNMENTS */
COMMAND read_transmitter_variable_assignments
{
	NUMBER 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
			primary_variable_code, secondary_variable_code,
			tertiary_variable_code, fourth_variable_code
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #54 - READ TRANSMITTER VARIABLE INFORMATION */
COMMAND read_transmitter_variable_information
{
	NUMBER 54;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
			transmitter_variable_code (INFO,INDEX)
		}
		REPLY
		{
			response_code, device_status, transmitter_variable_code,
			transmitter_variables[transmitter_variable_code].SENSOR_SERIAL_NUMBER,
			transmitter_variables[transmitter_variable_code].SENSOR_UNITS,
			transmitter_variables[transmitter_variable_code].UPPER_SENSOR_LIMIT,
			transmitter_variables[transmitter_variable_code].LOWER_SENSOR_LIMIT,
			transmitter_variables[transmitter_variable_code].DAMPING_VALUE,
			transmitter_variables[transmitter_variable_code].MINIMUM_SPAN
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
		2,	MISC_ERROR,			[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		6,	MISC_ERROR,			[xmtr_specific_command_error];
		16,	MODE_ERROR,			[access_restricted];
	}
}
/*****************************************************************************/
/* CMD #59 - WRITE NUMBER OF RESPONSE PRAEMBELS */
COMMAND write_number_of_response_preambles
{
	NUMBER 59;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			response_preambles
		}
		REPLY
		{
			response_code, device_status, response_preambles
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
		3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		6,	MISC_ERROR,			[xmtr_specific_command_error];
		7,	MODE_ERROR,			[in_write_protect_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}

/*****************************************************************************/
/* MANUFACTURER SPECIFIC COMMANDS                                            */
/*****************************************************************************/

/*****************************************************************************/
/* Commands zum bertragen von floats                                        */
/*****************************************************************************/
/* ------------------------------------------------------------------------ */
/* Command 128 read_static_variables
   Command wird verwendet zum Lesen von vier float Variablen aus der Tabelle
   static_param.
   static_param_code1...4 dienen als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND read_static_variables
{
  NUMBER 128;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
    {
	  static_param_code1 (INFO, INDEX),
	  static_param_code2 (INFO, INDEX),
	  static_param_code3 (INFO, INDEX),
	  static_param_code4 (INFO, INDEX)
	}
      REPLY
	{
	  response_code, device_status,
	  static_param_code1,
	  static_param[static_param_code1],
	  static_param_code2,
      static_param[static_param_code2],
	  static_param_code3,
      static_param[static_param_code3],
	  static_param_code4,
      static_param[static_param_code4]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 129 write_static_variables
   Command wird verwendet zum Schreiben einer float Variablen aus der Tabelle
   static_param.
   static_param_code dient als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND write_static_variables
{
  NUMBER 129;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  static_param_code (INFO, INDEX),
	  static_param[static_param_code]
	}
    REPLY
	{
	  response_code, device_status,
	  static_param_code,
	  static_param[static_param_code]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Commands zum bertragen von enumerates                                    */
/*****************************************************************************/

/* ------------------------------------------------------------------------ */
/* Command 130 read_enums
   Command wird verwendet zum Lesen von vier enum. Variablen aus der Tabelle
   static_enums.
   static_enums_code1...4 dienen als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND read_enums
{
  NUMBER 130;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  static_enums_code1 (INFO, INDEX),
	  static_enums_code2 (INFO, INDEX),
	  static_enums_code3 (INFO, INDEX),
	  static_enums_code4 (INFO, INDEX)
	}
    REPLY
	{
	  response_code, device_status,
	  static_enums_code1,
	  static_enums[static_enums_code1],
	  static_enums_code2,
      static_enums[static_enums_code2],
	  static_enums_code3,
      static_enums[static_enums_code3],
	  static_enums_code4,
      static_enums[static_enums_code4]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 131 write_enums
   Command wird verwendet zum Schreiben einer enum. Variablen aus der Tabelle
   static_enums.
   static_enums_code1 dient als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND write_enums
{
  NUMBER 131;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  static_enums_code (INFO, INDEX),
	  static_enums[static_enums_code]
	}
    REPLY
	{
	  response_code, device_status,
	  static_enums_code,
	  static_enums[static_enums_code]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Commands fr Aktionen                                                     */
/*****************************************************************************/

/* ------------------------------------------------------------------------ */
/* Command 132 start_action
   Command wird verwendet zum Starten von Aktionen */
/* ------------------------------------------------------------------------ */
COMMAND start_action
{
  NUMBER 132;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  action_code
	}
    REPLY
	{
	  response_code, device_status,
	  action_code
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 133 abort_action
   Command wird verwendet zum Abbrechen von Aktionen */
/* ------------------------------------------------------------------------ */
COMMAND abort_action
{
  NUMBER 133;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  action_code
	}
    REPLY
	{
	  response_code, device_status,
	  action_code
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 134 read_action_status
   Command wird verwendet zum Abfragen des Status von Aktionen */
/* ------------------------------------------------------------------------ */
COMMAND read_action_status
{
  NUMBER 134;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  action_code
	}
    REPLY
	{
	  response_code, device_status,
	  action_status
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 135 read_dev_ident_nr
   Command wird verwendet zum Abfragen der Erzeugnisnummer des Reglers */
/* ------------------------------------------------------------------------ */
COMMAND read_dev_ident_nr
{
  NUMBER 135;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}
    REPLY
	{
	  response_code, device_status,
	  dev_ident_nr
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 136 read_all_dynamic
   Command wird verwendet zum Abfragen der dyn. Variablen des Reglers */
/* ------------------------------------------------------------------------ */
COMMAND read_all_dynamics
{
  NUMBER 136;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}
    REPLY
	{
	  response_code, device_status,
	  sollwert_analog_value,
	  betriebsart,
   	  sollwert.DIGITAL_VALUE,
	  w_hand,
	  regeldiff.DIGITAL_VALUE,
	  istwert.DIGITAL_VALUE,
      stoermeldung,
	  swk_a_status,
	  swk_b_status,
	  reglerstatus,
	  summ_beweg
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 138 read_text
   Command wird verwendet zum Abfragen der Textfelder
   Auswahl des Texts erfolgt ber text_index */
/* ------------------------------------------------------------------------ */
COMMAND read_text_inputs
{
  NUMBER 138;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  text_index (INFO, INDEX)
    }
    REPLY
	{
	  response_code, device_status,
	  text_index,
	  user_text[text_index]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 139 write_text
   Command wird verwendet zum Schreiben der Textfelder
   Auswahl des Texts erfolgt ber text_index */
/* ------------------------------------------------------------------------ */
COMMAND write_text_inputs
{
  NUMBER 139;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  text_index (INFO, INDEX),
	  user_text[text_index]
    }
    REPLY
	{
	  response_code, device_status,
	  text_index,
	  user_text[text_index]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Methods                                                                   */
/*****************************************************************************/
METHOD method_PDM_StandardDiagnosis
{
    LABEL       "method_PDM_StandardDiagnosis";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {
        int i_stat_0, i_stat_1, i_stat_2, i_stat_3;
        int dev_status, akt_BA;
        int i_no_good, i_no_recommended; /* Merker zum Lschen anderer Stati */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        send_command(48);     /* Status einlesen */
        /* Status zuweisen */
        i_stat_0 = int_value(xmtr_specific_status_0);
        i_stat_1 = int_value(xmtr_specific_status_1);
        i_stat_2 = int_value(xmtr_specific_status_2);
        i_stat_3 = int_value(xmtr_specific_status_3);

        /* Parameter vorbelegen: */
		PDM_Diag_Status_Diagnosis = 0;
		PDM_Diag_Rule_Message     = "";
		i_no_good = 0;
		i_no_recommended = 0;

        /* bei Hand PDM_DIAG_SIMULATION setzen */
	    iassign(static_enums_code1,  65);    /* akt. Betriebsart */
	    iassign(static_enums_code2,  66);    /* irgendwas */
	    iassign(static_enums_code3,  67);    /* irgendwas */
	    iassign(static_enums_code4,  68);    /* irgendwas */
        send_command(130); /* akt. Betriebsart auslesen */
        akt_BA = ivar_value (betriebsart);

        dev_status = ivar_value (device_status); /* Gertestatus kopieren */

        /*----------------------------------------------*/
        /* Auswertung der eingelesenen Statusparameter: */
        /*----------------------------------------------*/

        /* wenn Hand aktiv: */
        if( akt_BA == 1 )
        {
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Manual mode active;"
			                         "|de|Betriebsart Hand aktiv;";
            i_no_good += 1; /* Merker setzen */
        }

        /*---------------------------------------------*/
        /* device_status                               */
        /*---------------------------------------------*/
		if( dev_status & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += [PV_out_of_limits] + ";";
            i_no_good += 1;        /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}

		if( dev_status & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += [Non_PV_out_of_limits] + ";";
            i_no_good += 1; /* Merker setzen */
		}

		if( dev_status & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += [cold_start] + ";";
            i_no_good += 1;        /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}

		if( dev_status & 0x40 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message += [configuration_changed] + ";";
		}

		if( dev_status & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += [device_malfunction] + ";";
            i_no_good += 1; /* Merker setzen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_0 */
        /*---------------------------------------------*/
		if( i_stat_0 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Control data memory error;"
			                         "|de|Datenspeicher Regelung defekt;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_0 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Communication data memory error;"
			                         "|de|Datenspeicher Kommunikation defekt;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_0 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Checksum error control data memory;"
			                         "|de|Prfsummenfehler Datenspeicher Regelung;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_0 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Checksum error communication data memory;"
			                         "|de|Prfsummenfehler Datenspeicher Kommunikation;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_0 & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Internal control loop error;"
			                         "|de|Interner Regelkreis gestrt;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_0 & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_CONFIG_ERROR;
			PDM_Diag_Rule_Message += "Parameter not supported;"
			                         "|de|Parameter nicht untersttzt;";
            i_no_good += 1; /* Merker setzen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_1 */
        /*---------------------------------------------*/
		if( i_stat_1 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Device not initialized;"
			                         "|de|Gert nicht initialisiert;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_1 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Initialization in process;"
			                         "|de|Initialisierung in Bearbeitung;";
		}

		if( i_stat_1 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Calibration failed;"
			                         "|de|Initialisierung fehlerhaft;";
            i_no_good += 1;        /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}

		if( i_stat_1 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Zero point adjustment in process;"
			                         "|de|Nullpunktabgleich in Bearbeitung;";
		}

		if( i_stat_1 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Zero point error;"
			                         "|de|Nullpunktfehler;";
            i_no_good += 1;        /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}

		if( i_stat_1 & 0x40 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Failure in measurement;"
			                         "|de|Fehler in Messwerterfassung;";
            i_no_good += 1; /* Merker setzen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_2 */
        /*---------------------------------------------*/
		if( i_stat_2 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message += "Total valve travel exceeded;"
			                         "|de|Grenzwert Wegintegral berschritten;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_2 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_CONFIG_ERROR;
			PDM_Diag_Rule_Message += "Parameter exceeds limits;"
			                         "|de|Parameter ausserhalb Bereich;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_2 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message += "Warm start executed;"
			                         "|de|Warmstart ausgefhrt;";
		}

		if( i_stat_2 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Controlled variable exceeds limits;"
			                         "|de|Messwert Regelgre ausser Bereich;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_2 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Power supply too low;"
			                         "|de|Hilfsenergie zu gering;";
            i_no_good += 1;        /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}

		if( i_stat_2 & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Defective mechanics / pneumatics;"
			                         "|de|Fehler in Mechanik / Pneumatik;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_2 & 0x40 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Internal device error;"
			                         "|de|Interner Gertefehler;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_2 & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message += "Characteristic not valid;"
			                         "|de|Kennlinie ungltig;";
            i_no_good += 1; /* Merker setzen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_3 */
        /*---------------------------------------------*/
		if( i_stat_3 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Error memory device information;"
			                         "|de|Fehler Speicher Gerteinformation;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_3 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message += "Characteristic monotony error;"
			                         "|de|Kennlinie Monotoniefehler;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_3 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message += "Characteristic gradient error;"
			                         "|de|Kennlinie Steigungsfehler;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_3 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Error in option forced venting;"
			                         "|de|Fehler in Option Zwangsentlftung;";
            i_no_good += 1; /* Merker setzen */
		}

		if( i_stat_3 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Diagnosis in process;"
			                         "|de|Diagnosefunktion aktiv;";
		}

        /* wenn nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message = "Status OK"
			                        "|de|Zustand OK"
			                        "|fr|Etat OK"
			                        "|it|Stato OK"
			                        "|sp|Estado OK";
		}

        /* wenn Status PDM_DIAG_GOOD gelscht werden soll: */
		if( i_no_good != 0 )
		{    /* nur PDM_DIAG_GOOD lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_GOOD_INVERS;
		}

        /* wenn Status PDM_DIAG_MAINT_RECOMMENDED gelscht werden soll: */
		if( i_no_recommended != 0 )
		{    /* nur PDM_DIAG_MAINT_RECOMMENDED lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_MAINT_RECOMMENDED_INVERS;
		}

    }
}
/*****************************************************************************/

/* fr Aufruf von Manual: */
METHOD methodOpenDeviceManual
{
	LABEL "SAMSON 3780 " + [menu_DeviceManual];
	ACCESS OFFLINE ;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME) ;
	}
    HELP "Mounting and operating instructions of the positioner."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers.";
}
/*****************************************************************************/

METHOD sie_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	DEFINITION
	{
	}
}
/*****************************************************************************/

METHOD std_CommWay
{
	LABEL		[menu_Device_CommWay];
	DEFINITION
	{
	}
}
/*****************************************************************************/

METHOD support_antrieb  /* Aktionen fr Hub-/Schwenkantriebumschaltung */
{
	LABEL		"";
	DEFINITION
	{
        int antr;

        antr = ivar_value (antrieb);
        if (antr == HUBANTRIEB)
        {
    		iassign(h_code, 1); /* auf D1 setzen */
        }
        else
        {
    		iassign(h_code, 3); /* auf S90 setzen */
        }
	}
}
/*****************************************************************************/

METHOD configuration_flag_reset
{
	CLASS		INPUT;
	LABEL		[configuration_flag_reset];
	HELP		[configuration_flag_reset_help];
	DEFINITION
	{
		int		choice;
		char	disp_string1[60];
		char	disp_string2[60];
		int		slen1;
		int		slen2;

		slen1=60;
		slen2=60;
		get_dictionary_string(configuration_flag_reset_execute, disp_string1, slen1);
		get_dictionary_string(yes_no, disp_string2, slen2);
		choice= SELECT_FROM_LIST(disp_string1, disp_string2);
		if ( choice == 0 )
		{
    		DELAY(2,"Reset"
    		        "|de|Wird rckgesetzt");
			send_command(38);
		}
	}
}
/*****************************************************************************/

METHOD meld_hubbereich
{
    LABEL "Attention"
          "|de|Hinweis";
    DEFINITION
    {
	    float nennh;
        float hubberend;

        nennh = fvar_value(nennhub);
	    hubberend = fvar_value(hubende);

        if (nennh < hubberend)
        {
            ACKNOWLEDGE("Travel range will be adapted to rated travel."
                        "|de|Der Hubbereich wird an den Nennhub angepasst.");
        }
        if (nennh > hubberend)
        {
            ACKNOWLEDGE("Travel range should be adapted."
                        "|de|Der Hubbereich sollte angepasst werden.");
        }
    }
}
/*****************************************************************************/

METHOD meld_drehwbereich
{
    LABEL "Attention"
          "|de|Hinweis";
    DEFINITION
    {
	   float nennw;
       float drehwend;

	   nennw = fvar_value(nennwinkel);
	   drehwend = fvar_value(drehw_ende);

       if (nennw < drehwend)
       {
           ACKNOWLEDGE("Angle range will be adapted to nominal angle."
                       "|de|Der Drehwinkelbereich wird an den Nennwinkel angepasst.");
       }
       if (nennw > drehwend)
       {
           ACKNOWLEDGE("Angle range should be adapted."
                       "|de|Der Drehwinkelbereich sollte angepasst werden.");
       }
    }
}
/*****************************************************************************/

METHOD meld_init_art
{
    LABEL "Attention"
          "|de|Hinweis";
    DEFINITION
    {
        ACKNOWLEDGE("A change of the initialization method will"
                    " take effect only after a new initialization !"
                    "|de|Eine nderung der Initialisierungsart wird erst"
                    " nach einem erneuten Initialisierungslauf wirksam !");
    }
}
/*****************************************************************************/

METHOD abort_initialization
{
    LABEL "Abort process in action"
          "|de|Laufende Aktion abbrechen";
	DEFINITION
	{
        int  wrProt;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)  /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

        add_abort_method(action_abort);
		send_command(133);
        ACKNOWLEDGE("Action aborted"
                    "|de|Aktion wurde abgebrochen");
	}
    HELP "Abort process in action: Aborts running calibration sequence."
	     "|de|Laufende Aktion abbrechen: Bricht laufende Kalibrierungssequenz ab.";
}
/*****************************************************************************/

METHOD cal_zero_valve
{
    LABEL "Start zero adjustment"
          "|de|Nullpunktabgleich starten";
	DEFINITION
	{
        int  wrProt;

        ACKNOWLEDGE("WARNING: Never start zero adjustment during a running process !\n"
                    "During zero adjustment the control valve departs from its current "
                    "position at full travel !\n\n"
                    "Status of zero adjustment: \nsee parameter 'Status calibration' "
                    "and 'Initialization warning'.\n\n"
                    "Start zero adjustment ?"
                    "|de|WARNUNG: Der Nullpunktabgleich darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Nullpunktabgleich fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status des Nullpunktabgleichs: \nsiehe Parameter 'Status Kalibrierung' "
                    "und 'Initialisierung Warnung'.\n\n"
                    "Nullpunktabgleich starten ?");

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)  /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		add_abort_method(action_abort);
		iassign(action_code, NULLP_CAL);
		send_command(132);
   		DELAY(3,"Zero adjustment is running"
   		        "|de|Nullpunktabgleich luft");
	}
    HELP "Zero adjustment: Automatic zero point correction."
	     "|de|Nullpunkt abgleichen: Automatische Korrektur des Nullpunktes.";
}
/*****************************************************************************/

METHOD init_valve
{
    LABEL "Start initialization"
          "|de|Initialisierung starten";
    DEFINITION
    {
        int   result;
        int   wrProt;

	    XMTR_IGNORE_ALL_COMM_STATUS();
	    XMTR_IGNORE_ALL_DEVICE_STATUS();
	    XMTR_IGNORE_ALL_RESPONSE_CODES();
	    XMTR_IGNORE_COMM_ERROR();

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

	    iassign(static_enums_code1, 99); /* init_ext lesen */
	    iassign(static_enums_code2, 95);
	    iassign(static_enums_code3, 96);
	    iassign(static_enums_code4, 97);
	    send_command(130);
        result = ivar_value (init_ext);
        if (result == 1)
        {   /* wenn erweiterte Initialisierung untersttzt */
            result = SELECT_FROM_LIST("Initialization"
                                      "|de|Initialisierung",
                                      "Standard;Extended;Puls detection"
                                      "|de|Standard;Erweitert;Impulsermittlung");
            if (result == 0)
            {
    	        iassign(action_code, INIT);
            }
            if (result == 1)
            {
                iassign(action_code, INIT_ERW);
            }
            if (result == 2)
            {
                iassign(action_code, INIT_IMP);
            }
        }
        else
        {
    	    iassign(action_code, INIT);
        }

        ACKNOWLEDGE("WARNING: Never start initialization during a running process !\n"
                    "During initialization the control valve departs from its current"
                    "position at full travel !\n\n"
                    "Status of initialization: \nsee parameter 'Status calibration' "
                    "and 'Initialization warning'.\n\n"
                    "Start initialization ?"
                    "|de|WARNUNG: Die Initialisierung darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Initialisierung fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status der Initialisierung: \nsiehe Parameter 'Status Kalibrierung' "
                    "und 'Initialisierung Warnung'.\n\n"
                    "Initialisierung starten ?");

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)  /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

	    add_abort_method(action_abort);
	    send_command(132); /* start action */
	    DELAY(3,"Initialization is running"
	            "|de|Initialisierung luft");
    }
    HELP "Start initialization: Automatic start up."
         " Requires manual zero point adjustment and valid"
	     " initialization parameters."
	     "|de|Initialisierung starten: Automatische Inbetriebnahme."
	     " Voraussetzung: mechanische"
	     " Nullung muss einmal durchgefhrt worden sein. Gltige"
	     " Initialisierungswerte mssen eingegeben sein.";
}
/*****************************************************************************/

METHOD coldstart
{
    LABEL "Cold start"
          "|de|Kaltstart";
    DEFINITION
    {
	    char status[STATUS_SIZE];
	    char dev_status[DEV_STATUS_SIZE];
	    int  cnt;
	    int  stat;
        int  wrProt;
        int  answer;

	    XMTR_IGNORE_ALL_COMM_STATUS();
	    XMTR_IGNORE_ALL_DEVICE_STATUS();
	    XMTR_IGNORE_ALL_RESPONSE_CODES();
	    XMTR_IGNORE_COMM_ERROR();

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

        SET_NUMBER_OF_RETRIES(30);
        answer = ACKNOWLEDGE("WARNING: All device data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current "
                    "position at full travel !\nExecute ?"
                    "|de|WARNUNG: Alle Gertedaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden "
                    "Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");
        if (answer == -1) /* Methode abbrechen wenn <Abbrechen> gewhlt (OK = 0; Abbrechen = -1)*/
        {
    		process_abort();
        }

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }
        cnt = 60; /* nach 5min. beenden: 300s/5s=60 */
    	iassign(action_code, KALTSTART);
    	send_command(132);

    	DELAY(20,"Cold start is starting"
    	         "|de|Kaltstart wird gestartet");
    	do {
            XMTR_RETRY_ON_NO_DEVICE();
    	    get_more_status(status,dev_status);
            stat = status[STATUS_DEVICE_STATUS];
            if (stat & 0x20)
            {
                ACKNOWLEDGE("Cold start executed."
                            "|de|Kaltstart durchgefhrt.");
                ACKNOWLEDGE("New communication startup necessary to get"
                            " current device data."
                            "|de|Erneuter Verbindungsaufbau erforderlich,"
                            " um Gertedaten neu zu lesen.");
                break;
            }
            cnt--;
    	} while ( ( (stat != BI_SUCCESS                         ) ||
    	            (status[STATUS_RESPONSE_CODE] == DEVICE_BUSY)   ) && cnt );

    	if (cnt == 0)
    	{
    	    ACKNOWLEDGE("Timeout"
    	                "|de|Zeitfehler");
    	}
    }
    HELP "Cold start: Reset device to default (cold start) values."
         " NOTE: The field device"
	     " moves to the fail safe position. A new initialization will be"
         " necessary."
	     "|de|Kaltstart: Rcksetzen auf Kaltstartwerte."
	     " HINWEIS: Das Stellgert fhrt"
	     " in die Sicherheitsstellung. Eine erneute Initialisierung wird"
	     " erforderlich.";
}
/*****************************************************************************/

METHOD stoerm_test
{
	LABEL "Test fault alarm"
	      "|de|Test Strmeldung";
	DEFINITION
	{
		char status[STATUS_SIZE];
		char dev_status[DEV_STATUS_SIZE];
        int  wrProt;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		iassign(action_code, TEST_STOERMELD);
		send_command(132);
		DELAY(5,"Running"
		        "|de|Kontakt wird 3 mal geschaltet");
	}
    HELP "Test fault alarm: Functional test of the fault alarm output by"
         " switching three times."
	     "|de|Test Strmeldung: Funktionsberprfung des Strmeldeausganges durch "
	     "dreimaliges Schalten.";
}
/*****************************************************************************/
METHOD test_swk_a
{
	LABEL "Test software limit switch GW1"
	      "|de|Test Softwaregrenzkontakt GW1";
	DEFINITION
	{
		char status[STATUS_SIZE];
		char dev_status[DEV_STATUS_SIZE];
		int  merk;
        int  wrProt;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		merk = ivar_value(kenn_gr_kont);
		if (merk == 2)   /* wenn Option vorhanden */
		{
			iassign(action_code, TEST_SWK_A);
			send_command(132);
			DELAY(5,"Running"
			        "|de|Kontakt wird 3 mal geschaltet");
		}
		else
		{
			DELAY(5,"Not installed"
			        "|de|Option nicht vorhanden");
		}
	}
    HELP "Test software limit switch GW1: Functional test of software limit"
         " switch GW1 by switching three times."
	     "|de|Test Softwaregrenzkontakt GW1: Funktionsberprfung"
	     " Softwaregrenzkontakt GW1 durch dreimaliges Schalten.";
}
/*****************************************************************************/

METHOD test_swk_b
{
	LABEL "Test software limit switch GW2"
	      "|de|Test Softwaregrenzkontakt GW2";
	DEFINITION
	{
		char status[STATUS_SIZE];
		char dev_status[DEV_STATUS_SIZE];
		int  merk;
        int  wrProt;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		merk = ivar_value(kenn_gr_kont);
		if (merk == 2)   /* wenn Option vorhanden */
		{
			iassign(action_code, TEST_SWK_B);
			send_command(132);
			DELAY(5,"Running"
			        "|de|Kontakt wird 3 mal geschaltet");
		}
		else
		{
			DELAY(5,"Option is not installed."
			        "|de|Option ist nicht vorhanden.");
		}
	}
    HELP "Test software limit switch GW2: Functional test of software limit"
         " switch GW2 by switching three times."
	     "|de|Test Softwaregrenzkontakt GW2: Funktionsberprfung"
	     " Softwaregrenzkontakt GW2 durch dreimaliges Schalten.";
}
/*****************************************************************************/

METHOD test_stellungsmelder
{
    LABEL "Test position transmitter"
          "|de|Test Stellungsmelder";
    DEFINITION
    {
	    char status[STATUS_SIZE];
	    char dev_status[DEV_STATUS_SIZE];
	    int  merk;
        int  wrProt;
        int  answer;

	    XMTR_IGNORE_ALL_COMM_STATUS();
	    XMTR_IGNORE_ALL_DEVICE_STATUS();
	    XMTR_IGNORE_ALL_RESPONSE_CODES();
	    XMTR_IGNORE_COMM_ERROR();

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

	    merk = ivar_value(kenn_stm);
    	if (merk == 1)  /* Option Stellungsmelder vorhanden */
    	{
    	    add_abort_method(action_abort);  /* fuer ACKNOWLEDGE weiter unten */
  		    iassign(static_param_code1, 51); /* x_test einlesen */
   		    iassign(static_param_code2, 24);
   		    iassign(static_param_code3, 25);
   		    iassign(static_param_code4, 26);
   		    send_command(128);
      	    iassign(action_code, TEST_STELLMELD);
    	    answer = GET_DEV_VAR_VALUE("Value test parameter:"
    	                               "|de|Vorgabe eines Testwertes:", x_test);
            if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	    send_command(132);
    	    DELAY(2,"Starting test"
    	            "|de|Test wird gestartet");
            iassign(static_param_code, 51);	/* Wert x_test schreiben */
    	    send_command(129);
    	    DELAY(2,"Test is running"
    	            "|de|Test luft");
    	    merk = 1000;
    	    while (merk)
    	    {
        	    send_command(132);              /* Test triggern */
                iassign(static_param_code, 51);	/* Wert x_test schreiben */
  	            send_command(129);
    	   	    answer = ACKNOWLEDGE("Abort: press <ABORT>'"
    	   	                         "|de|Beenden: <ABBRECHEN> drcken");
                if (answer == -1) /* Methode abbrechen wenn <Abbrechen> gewhlt */
                {
            	   	process_abort();
                }
                merk--;
    	    }
    	}
    	else  /* Option Stellungsmelder nicht vorhanden */
    	{
    	    DELAY(5,"Option is not installed."
    	            "|de|Option ist nicht vorhanden.");
    	}
    }
    HELP "Test position transmitter: Enter value to test the optional"
         " position transmitter."
	     "|de|Test Stellungsmelder: Vorgabe eines Wertes zum Testen der"
	     " Option Stellungsmelder.";
}
/*****************************************************************************/

METHOD action_abort
{
	LABEL "Abort"
	      "|de|Abbrechen";
	DEFINITION
	{
		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

		send_command(133);
		ACKNOWLEDGE("Aborted"
		            "|de|Abgebrochen");
	}
}
/*****************************************************************************/

METHOD wegint_reset
{
	LABEL "Reset total valve travel"
	      "|de|Rcksetzen Wegintegral";
	DEFINITION
	{
        int  wrProt;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		iassign(action_code, WEGINT_RESET);
		send_command(132);
		DELAY(2,"Reset"
		        "|de|Wird rckgesetzt");
	}
    HELP "Reset total valve travel: reset total valve travel to zero."
         "|de|Rcksetzen Wegintegral: Rcksetzen des Wegintegrals auf Null.";
}
/*****************************************************************************/

METHOD rk_stoer_reset
{
	LABEL "Reset control loop error"
	      "|de|Rcksetzen Regelkreisstrung";
	DEFINITION
	{
        int  wrProt;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt");
            process_abort();
        }

		iassign(action_code, RK_STOER_RESET);
		send_command(132);
		DELAY(5,"Reset"
		        "|de|Wird rckgesetzt");
	}
    HELP "Reset control loop error"
         "|de|Rcksetzen der Regelkreisstrung";
}
/*****************************************************************************/
METHOD kennl_eingabe
{
    LABEL "User defined characteristics"
          "|de|Benutzerdefinierte Kennlinie";
    DEFINITION
    {
	    char status[STATUS_SIZE];
	    char dev_status[DEV_STATUS_SIZE];
	    int  param_nr;
	    int  cnt;
	    int  nr;
	    long ids[2];
        int  wrProt;
        int  answer;

	    XMTR_IGNORE_ALL_COMM_STATUS();
	    XMTR_IGNORE_ALL_DEVICE_STATUS();
	    XMTR_IGNORE_ALL_RESPONSE_CODES();
	    XMTR_IGNORE_COMM_ERROR();

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

	    answer = GET_DEV_VAR_VALUE("x[0]", x0);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
        answer = GET_DEV_VAR_VALUE("y[0]", y0);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

	    answer = GET_DEV_VAR_VALUE("x[1]", x1);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
	    answer = GET_DEV_VAR_VALUE("y[1]", y1);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

	    answer = GET_DEV_VAR_VALUE("x[2]", x2);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
	    answer = GET_DEV_VAR_VALUE("y[2]", y2);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

	    answer = GET_DEV_VAR_VALUE("x[3]", x3);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
	    answer = GET_DEV_VAR_VALUE("y[3]", y3);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[4]", x4);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[4]", y4);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[5]", x5);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[5]", y5);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[6]", x6);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[6]", y6);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[7]", x7);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[7]", y7);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[8]", x8);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[8]", y8);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[9]", x9);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[9]", y9);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

    	answer = GET_DEV_VAR_VALUE("x[10]", x10);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */
    	answer = GET_DEV_VAR_VALUE("y[10]", y10);
        if (answer == BI_ERROR) { process_abort(); } /* Methode abbrechen wenn <Abbrechen> gewhlt */

        send_command(15);
        wrProt = ivar_value (write_protect);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected"
                        "|de|Gert ist schreibgeschtzt");
            process_abort();
        }

        /* Start Kennlinienbertragung */
        DELAY(3,"Transmission of values"
    		    "|de|Werte werden bertragen");
    	iassign(action_code, START_KENNLINIE);
    	send_command(132);
    	for (param_nr=24; param_nr<46; param_nr++)  /* Werte bertragen */
    	{
    	    iassign(static_param_code, param_nr);
    	    send_command(129);
    	}
    	iassign(action_code, ENDE_KENNLINIE);    	/* Beenden Kennlinienbertragung */
    	send_command(132);
        ACKNOWLEDGE("Transmission of values finished"
    		        "|de|bertragen der Werte beendet");
    	cnt = 2000;
    	do {           	/* Status auslesen */
    	    get_more_status(status,dev_status);
    	    cnt--;
    	} while ((status[STATUS_RESPONSE_CODE]==DEVICE_BUSY) && cnt);

	    if (cnt == 0)
	    {
	        ACKNOWLEDGE("Timeout"
	                    "|de|Zeitfehler");
	    }
	    else
	    {
	        get_more_status(status,dev_status);
	        iassign(static_enums_code1, 90);	/* Nr. fehlerh. Kennl.pkt. */
	        iassign(static_enums_code2, 69);	/* Kennl.auswahl */
	        iassign(static_enums_code3, 90);
	        iassign(static_enums_code4, 90);
	        send_command(130);

	        if (dev_status[2] & 0x80)	/* Kennlinie allgemein */
	        {
    	    	nr = ivar_value(nr_kenn_err);
	           	acknowledge("Characteristic error point %{nr}"
	           		        "|de|Kennlinienfehler Punkt %{nr}", ids);
	        }

	        if (dev_status[3] & 0x02)	/* Kennlinie Monotonie */
	        {
    	    	nr = ivar_value(nr_kenn_err);
	           	acknowledge("Characteristic monotonie error point %{nr}"
	    	      	        "|de|Kennlinie Monotoniefehler Punkt %{nr}", ids);
	        }

	        if (dev_status[3] & 0x04)	/* Kennlinie Steigung */
	        {
            	nr = ivar_value(nr_kenn_err);
	           	acknowledge("Characteristic gradient error point %{nr}"
	    	      	        "|de|Kennlinie Steigungsfehler Punkt %{nr}", ids);
	        }
	    }
    }
    HELP "User defined characteristics: Coordinates for user defined"
         " control valve characteristic."
         " x[n] = reference variable in % of the respective range."
         " y[n] = travel / opening angle in % of the respective range."
	     "|de|Benutzerdefinierte Kennlinie: Sttzwerte fr benutzerdefinierte"
	     " Zuordnung zwischen "
	     "Fhrungsgre und Hub / Drehwinkel."
	     " x[n] = Fhrungsgre in % des Fhrungsgrenbereichs."
	     " y[n] = Hub / Drehwinkel in % des Hub- / Drehwinkelbereichs.";
}
/*****************************************************************************/
METHOD WRITE_ALL_PARAMETERS /* Schreiben aller Parameter nach Parameter Anbau ins Gert */
{
	LABEL "write all parameters"
	      "|de|write all parameters";
	DEFINITION
	{
	    int  iAntrieb;
	    int  iAnbau;
	    int  iKenn_gr_kont;

        iAntrieb = ivar_value (antrieb);
        iAnbau   = ivar_value (anbau);
        iKenn_gr_kont = ivar_value (kenn_gr_kont);

        DELAY(3,"Please wait. Transmission of parameters."
    		    "|de|Bitte warten. Parameter werden bertragen.");
        /**************************************************/
        /* Inbetriebnahme / Initialisierung               */
        /**************************************************/
    	/* antrieb (wurde schon geschrieben) */
    	/* anbau */
        iassign(static_enums_code, 67);	/* Enumerated-Variable schreiben */
  	    send_command(131);

	    if ( (iAntrieb == HUBANTRIEB) && (iAnbau == NAMUR) )
        {
        	/* h_laenge */
            iassign(static_param_code, 46);	/* Float-Wert schreiben */
      	    send_command(129);
           	/* stiftposition */
            iassign(static_enums_code, 85);	/* Enumerated-Variable schreiben */
  	        send_command(131);
        }
        else
        {
          	/* h_code */
            iassign(static_enums_code, 70);	/* Enumerated-Variable schreiben */
  	        send_command(131);
        }

	    if (iAntrieb == HUBANTRIEB)
        {
        	/* nennhub */
            iassign(static_param_code, 10);	/* Float-Wert schreiben */
      	    send_command(129);
        	/* anbaulage */
            iassign(static_enums_code, 91);	/* Enumerated-Variable schreiben */
      	    send_command(131);
        }
        else
        {
        	/* nennwinkel */
            iassign(static_param_code, 61);	/* Float-Wert schreiben */
      	    send_command(129);
        }
    	/* bauart */
        iassign(static_enums_code, 86);	/* Enumerated-Variable schreiben */
  	    send_command(131);
    	/* init_art */
        iassign(static_enums_code, 92);	/* Enumerated-Variable schreiben */
  	    send_command(131);
        /**************************************************/
        /* Regelparameter                                 */
        /**************************************************/
    	/* kp_y1 */
        iassign(static_param_code, 20);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* kp_y2 */
        iassign(static_param_code, 23);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* kd */
        iassign(static_param_code, 21);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* xtot */
        iassign(static_param_code, 22);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* ueberschw_w */
        iassign(static_param_code, 67);	/* Float-Wert schreiben */
  	    send_command(129);
        DELAY(2,"Please wait. Transmission of parameters."
    		    "|de|Bitte warten. Parameter werden bertragen.");
        /**************************************************/
        /* Konfiguration                                  */
        /**************************************************/
    	/* ind_gr_kont */
        iassign(static_enums_code, 76);	/* Enumerated-Variable schreiben */
  	    send_command(131);
    	/* toleranzband */
        iassign(static_param_code, 58);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* nachlaufzeit */
        iassign(static_param_code, 59);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* stm_com */
        iassign(static_enums_code, 78);	/* Enumerated-Variable schreiben */
  	    send_command(131);
    	/* stm_sonder */
        iassign(static_enums_code, 77);	/* Enumerated-Variable schreiben */
  	    send_command(131);
    	/* stm_w_int */
        iassign(static_enums_code, 79);	/* Enumerated-Variable schreiben */
  	    send_command(131);
    	/* grenz_beweg */
        iassign(static_param_code, 60);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* gew_lauf_zu */
        iassign(static_param_code, 19);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* gew_lauf_ab */
        iassign(static_param_code, 56);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* wirkricht_regler */
        iassign(static_enums_code, 68);	/* Enumerated-Variable schreiben */
  	    send_command(131);
    	/* fuehr_gr_u */
        iassign(static_param_code, 13);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* fuehr_gr_o */
        iassign(static_param_code, 14);	/* Float-Wert schreiben */
  	    send_command(129);

        DELAY(2,"Please wait. Transmission of parameters."
    		    "|de|Bitte warten. Parameter werden bertragen.");
	    if (iAntrieb == HUBANTRIEB)
        {
        	/* hubanfang */
            iassign(static_param_code, 11);	/* Float-Wert schreiben */
      	    send_command(129);
        	/* hubende */
            iassign(static_param_code, 12);	/* Float-Wert schreiben */
      	    send_command(129);
        }
        else
        {
        	/* drehw_anfang */
            iassign(static_param_code, 62);	/* Float-Wert schreiben */
      	    send_command(129);
        	/* drehw_ende */
            iassign(static_param_code, 63);	/* Float-Wert schreiben */
      	    send_command(129);
        }
    	/* hubgr_u */
        iassign(static_param_code, 17);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* hubgr_o */
        iassign(static_param_code, 18);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* vent_zu */
        iassign(static_param_code, 16);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* vent_auf */
        iassign(static_param_code, 15);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* eing_kl */
        iassign(static_enums_code, 69);	/* Enumerated-Variable schreiben */
  	    send_command(131);

        if (iKenn_gr_kont == SOFTWARE)  /* wenn SW-Grenzkontakte eingebaut */
        {
	       /* swk_a */
           iassign(static_param_code, 48);	/* Float-Wert schreiben */
      	   send_command(129);
	       /* swk_a_ein */
           iassign(static_enums_code, 87);	/* Enumerated-Variable schreiben */
      	   send_command(131);
	       /* swk_b */
           iassign(static_param_code, 49);	/* Float-Wert schreiben */
      	   send_command(129);
	       /* swk_b_ein */
           iassign(static_enums_code, 88);	/* Enumerated-Variable schreiben */
      	   send_command(131);
	    }
        DELAY(2,"Please wait. Transmission of parameters."
    		    "|de|Bitte warten. Parameter werden bertragen.");
		/* kennlinientyp */
        iassign(text_index, 4);	/* Text 5 auswhlen und schreiben */
  	    send_command(139);
		/* wirkricht_stell_m */
        iassign(static_enums_code, 80);	/* Enumerated-Variable schreiben */
  	    send_command(131);
        /**************************************************/
	    /* Gerteidentifikation                           */
        /**************************************************/
    	/* tag */
    	/* descriptor */
    	/* date */
  	    send_command(18);
    	/* message */
  	    send_command(17);
        /* text_1 */
        iassign(text_index, 0);	/* Text 1 auswhlen und schreiben */
  	    send_command(139);
        /* text_2 */
        iassign(text_index, 1);	/* Text 2 auswhlen und schreiben */
  	    send_command(139);
        /* text_3 */
        iassign(text_index, 2);	/* Text 3 auswhlen und schreiben */
  	    send_command(139);
        /* text_4 */
        iassign(text_index, 3);	/* Text 4 auswhlen und schreiben */
  	    send_command(139);
    	/* id_antrieb */
        iassign(static_param_code, 54);	/* Float-Wert schreiben */
  	    send_command(129);
    	/* final_assembly_number */
  	    send_command(19);
        ACKNOWLEDGE("Parameters have been sent to the device."
                    "|de|Parameter wurden zum Gert gesendet.");
	}
}
/*****************************************************************************/

/*****************************************************************************/
/* MENU Bar (Menleiste)                                                     */
/*****************************************************************************/
MENU Menu_Main_Specialist
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_S_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}

MENU Menu_Main_Maintenance
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_M_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}

/*****************************************************************************/
/*    Menu: File (Datei)					                                 */
/*****************************************************************************/
MENU Menu_File
{
	LABEL		[menu_File];
	ITEMS
	{
		std_Save,
		SEPARATOR,
		std_Eigenschaften,
		SEPARATOR,
		std_Print,
		std_PrintPreview,
		std_PrintSetup,
		std_PageSetup,
		std_Schriftfelder,
		SEPARATOR,
		std_Exit
	}
}

METHOD std_Save
{
	LABEL		[menu_File_Save];
	DEFINITION
	{
	}
}

METHOD SEPARATOR
{
	LABEL		[menu_Separator];
	DEFINITION
	{
	}
}

METHOD std_Eigenschaften
{
	LABEL		[menu_File_Properties];
	DEFINITION
	{
	}
}

METHOD std_Print
{
	LABEL		[menu_File_Print];
	DEFINITION
	{
	}
}

METHOD std_PrintPreview
{
	LABEL		[menu_File_PrintPreview];
	DEFINITION
	{
	}
}

METHOD std_PrintSetup
{
	LABEL		[menu_File_PrintSetup];
	DEFINITION
	{
	}
}

METHOD std_PageSetup
{
	LABEL		[menu_File_PageSetup];
	DEFINITION
	{
	}
}

METHOD std_Schriftfelder
{
	LABEL		[menu_File_Labels];
	DEFINITION
	{
	}
}

METHOD std_Exit
{
	LABEL		[menu_File_Exit];
	DEFINITION
	{
	}
}

METHOD polling_address_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	CLASS		INPUT;
	DEFINITION
	{
		ACKNOWLEDGE([message_polling_address]);
	}
}

/*****************************************************************************/
/*    Menu: Device (Gert)											         */
/*****************************************************************************/
MENU Menu_S_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_CommWay,                 /* Methode */
		SEPARATOR,
		OnlineDialog_Device_NodeAddress,
		SEPARATOR,
		std_LoadinDevice,
		std_LoadinPC,
		SEPARATOR,
		OnlineDialog_operation,
		OnlineDialog_reset,
		configuration_flag_reset,    /* Methode */
		SEPARATOR,
		OnlineDialog_self_calibration,
        kennl_eingabe,               /* Methode */
		OnlineDialog_request_response_preambles
	}
}

MENU OnlineDialog_Device_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	ITEMS
	{
			polling_address,
			polling_address_set
	}
}

MENU Menu_M_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_LoadinDevice,
		std_LoadinPC
	}
}

METHOD std_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	DEFINITION
	{
	}
}

METHOD std_LoadinDevice
{
	LABEL		[menu_Device_LoadinDevice];
	DEFINITION
	{
	}
}

METHOD std_LoadinPC
{
	LABEL		[menu_Device_LoadinPC];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: View (Ansicht)											         */
/*****************************************************************************/
MENU Menu_View
{
	LABEL		[menu_View];
	ITEMS
	{
		OnlineWindow_display,
		OnlineWindow_yt,
		OnlineWindow_diagnosis,
		SEPARATOR,
		std_Funktionsleiste,
		std_Statuszeile,
		SEPARATOR,
		std_Update
	}
}

METHOD std_Funktionsleiste
{
	LABEL		[menu_View_Toolbar];
	DEFINITION
	{
	}
}

METHOD std_Statuszeile
{
	LABEL		[menu_View_Statusbar];
	DEFINITION
	{
	}
}

METHOD std_Update
{
	LABEL		[menu_View_Update];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: Options (Extras)										         */
/*****************************************************************************/
MENU Menu_Options
{
	LABEL		[menu_Options];
	ITEMS
	{
		std_Einstellungen,
		std_Untereintraege
	}
}

METHOD std_Einstellungen
{
	LABEL		[menu_Options_Properties];
	DEFINITION
	{
	}
}

METHOD std_Untereintraege
{
	LABEL		[menu_Options_Subitems];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: Help (Hilfe)											         */
/*****************************************************************************/
MENU Menu_Help
{
	LABEL		[menu_Help];
	ITEMS
	{
		std_Hilfethemen,
		std_HilfeKontext,
		SEPARATOR,
		std_HilfeGeraet,
		SEPARATOR,
		methodOpenDeviceManual,
		SEPARATOR,
		std_HilfeEinfuehrung,
		std_HilfeErsteSchritte,
		SEPARATOR,
		std_Hilfebenutzen,
		std_Info
	}
}

METHOD std_Hilfethemen
{
	LABEL		[menu_Help_Topics];
	DEFINITION
	{
	}
}

METHOD std_HilfeKontext
{
	LABEL		[menu_Help_Context];
	DEFINITION
	{
	}
}

METHOD std_HilfeGeraet
{
	LABEL		[menu_Help_Device];
	DEFINITION
	{
	}
}

METHOD std_HilfeEinfuehrung
{
	LABEL		[menu_Help_Introduction];
	DEFINITION
	{
	}
}

METHOD std_HilfeErsteSchritte
{
	LABEL		[menu_Help_First_Steps];
	DEFINITION
	{
	}
}

METHOD std_Hilfebenutzen
{
	LABEL		[menu_Help_Using];
	DEFINITION
	{
	}
}

METHOD std_Info
{
	LABEL		[menu_Help_Info];
	DEFINITION
	{
	}
}

/*******************************************************************************/
/* Online Windows                                                              */
/*******************************************************************************/
/* Ansicht - Messwertanzeige **************************************************/
MENU OnlineWindow_display
{
	LABEL		[menu_dialog_display];
	ITEMS
	{
		Page_display_measure,
		Page_display_state,
		Page_display_statistic
	}
}

/* Ansicht - Messwertanzeige - Messwert ****************************************/
MENU Page_display_measure
{
	LABEL		[menu_dialog_display_measure];
	ITEMS
	{
        Page_group_display_measure_x
        Page_group_display_measure_w,
        Page_group_betriebsart
	}
}

MENU Page_group_display_measure_x
{
	LABEL		"";
	ITEMS
	{
    	Val_pv,
		Bar_pv_display,
		SEPARATOR,
		regeldiff_value
	}
}

MENU Page_group_display_measure_w
{
	LABEL		"";
	ITEMS
	{
    	Val_sp,
		Bar_sp_display,
		SEPARATOR,
		fuehr_gr_u		 (READ_ONLY),
		fuehr_gr_o		 (READ_ONLY)
	}
}

MENU Page_group_betriebsart
{
	LABEL		"";
	ITEMS
	{
        betriebsart	     (READ_ONLY),
 		reglerstatus
	}
}

MENU Bar_pv_display /* Istwert Bargraph */
{
	LABEL		"";
	ITEMS
	{
		istwert_value,
		hubgr_u	        (READ_ONLY),
		hubgr_o	        (READ_ONLY)
	}
}

MENU Bar_sp_display /* Sollwert Bargraph */
{
	LABEL		"";
	ITEMS
	{
		sollwert_value  (READ_ONLY),
		hubgr_u	        (READ_ONLY),
		hubgr_o	        (READ_ONLY)
	}
}

MENU Val_pv /* Grossanzeige */
{
    LABEL     "Controlled variable X"
              "|de|Regelgre X";
	ITEMS
	{
	    istwert_value
	}
}

MENU Val_sp /* Grossanzeige */
{
    LABEL     "Reference variable W"
              "|de|Fhrungsgre W";
	ITEMS
	{
	    sollwert_value  (READ_ONLY)
	}
}

/* Ansicht - Messwertanzeige - Status *****************************************/
MENU Page_display_state
{
	LABEL	  "Status"
	          "|de|Status";
	ITEMS
	{
	   Page_group_display_state
	}
}

MENU Page_group_display_state
{
	LABEL		"";
	ITEMS
	{
	   stoermeldung  (READ_ONLY),
       swk_a_status,
       swk_b_status,
       zwangsentlueft,
       xmtr_specific_status_0,
       xmtr_specific_status_1,
       xmtr_specific_status_2,
       xmtr_specific_status_3,
       device_status,
       SEPARATOR,
	   betriebsart   (READ_ONLY),
       reglerstatus,
       imp_1,
       imp_2,
       imp_3
	}
}

/* Ansicht - Messwertanzeige - Statistik **************************************/
MENU Page_display_statistic
{
	LABEL		"Statistics"
	            "|de|Statistik";
	ITEMS
	{
        Page_group_statistic
	}
}

MENU Page_group_statistic
{
	LABEL		"";
	ITEMS
	{
		summ_beweg_value,
		grenz_beweg	(READ_ONLY)
	}
}

/* Ansicht - Gertezustand ***************************************************/
MENU OnlineWindow_diagnosis
{
	LABEL		[menu_dialog_diagnosis];
	ITEMS
	{
		Page_display_state
	}
}

/* Ansicht - y-t Diagram *****************************************************/
MENU OnlineWindow_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
			Page_process_yt
	}
}

MENU Page_process_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Val_yt,
		Val_yt_2,
		OCX_out_display_yt
	}
}

MENU Val_yt
{
	LABEL   "Controlled variable X"
			"|de|Regelgre X";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
			istwert.DIGITAL_VALUE (READ_ONLY)
	}
}

MENU Val_yt_2
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
			sollwert.DIGITAL_VALUE (READ_ONLY)
	}
}

MENU OCX_out_display_yt								/* OCX-Control */
{
	LABEL		[menu_yt_diagram] ;
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		/* Name, unter dem das OCX in Windows registriert ist */
	ITEMS
	{
		OCX_ProfilNum_yt,							/* Profil-Nummer */
		OCX_out_display_1,							/* 1. Kurve */
		OCX_out_display_2,							/* 2. Kurve */
		OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
	}
}

MENU OCX_out_display_1								/* 1. Kurve im OCX-Control yt */
{
	LABEL   "Controlled variable X"
			"|de|Regelgre X";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		istwert.DIGITAL_VALUE       (READ_ONLY),
		istwert.LOWER_RANGE_VALUE	(READ_ONLY),
		istwert.UPPER_RANGE_VALUE	(READ_ONLY)
	}
}

MENU OCX_out_display_2								/* 1. Kurve im OCX-Control yt */
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		sollwert.DIGITAL_VALUE      (READ_ONLY),
		sollwert.LOWER_RANGE_VALUE	(READ_ONLY),
		sollwert.UPPER_RANGE_VALUE	(READ_ONLY)
	}
}

VARIABLE OCX_ProfilNum_yt							/* Profil-Variable fr OCX yt */
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	0;							/* Profil 0 fr normale y-t-Darstellung */
	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}

/*******************************************************************************/
/* Online Dialogs                                                              */
/*******************************************************************************/

/* Gert - Betrieb ***********************************************************/
MENU OnlineDialog_operation
{
	LABEL		"Operation"
	            "|de|Betrieb";
	ITEMS
	{
		Page_operation_AUTO,
		Page_operation_MANUAL,
		Page_operation_simulation
	}
}

/* Gert - Betrieb - Automatik ***********************************************/
MENU Page_operation_AUTO
{
	LABEL		"Automatic"
	            "|de|Automatik";
	ITEMS
	{
        Page_group_AUTO
	}
}

MENU Page_group_AUTO
{
	LABEL		"";
	ITEMS
	{
		betriebsart,
		sollwert_value,
		istwert_value,
		regeldiff_value
	}
}

/* Gert - Betrieb - Hand ****************************************************/
MENU Page_operation_MANUAL
{
	LABEL		"Manual"
	            "|de|Hand";
	ITEMS
	{
        Page_group_MANUAL
	}
}

MENU Page_group_MANUAL
{
	LABEL		"";
	ITEMS
	{
		betriebsart,
		sollwert_value,
		w_hand,
		istwert_value,
		regeldiff_value
	}
}

/* Gert - Betrieb - Simulation **********************************************/
MENU Page_operation_simulation
{
	LABEL		"Simulation"
	            "|de|Simulation";
	ITEMS
	{
        Page_group_simulation
	}
}

MENU Page_group_simulation
{
	LABEL		"";
	ITEMS
	{
        stoermeldung (READ_ONLY),
        x_test       (READ_ONLY),
        swk_a_status,
        swk_b_status,
		SEPARATOR,
        stoerm_test,            /* Methode */
        test_stellungsmelder,   /* Methode */
        test_swk_a,             /* Methode */
        test_swk_b              /* Methode */
	}
}

/* Gert - Rcksetzen ********************************************************/
MENU OnlineDialog_reset
{
	LABEL		[master_reset];
	HELP		[master_reset_help];
	ITEMS
	{
		Page_reset_misc,
		Page_reset_factory
	}
}

/* Gert - Rcksetzen - Verschiedenes ****************************************/
MENU Page_reset_misc
{
	LABEL		"Reset miscellaneous"
	            "|de|Rcksetzen Verschiedenes";
	ITEMS
	{
        Page_group_reset_maintenance_1,
        Page_group_reset_maintenance_2
	}
}

MENU Page_group_reset_maintenance_1
{
	LABEL		"";
	ITEMS
	{
        summ_beweg_value,
        wegint_reset      /* Methode */
	}
}

MENU Page_group_reset_maintenance_2
{
	LABEL		"";
	ITEMS
	{
        device_status,
        rk_stoer_reset    /* Methode */
	}
}

/* Gert - Rcksetzen - Rcksetzen in Auslieferzustand ***********************/
MENU Page_reset_factory
{
	LABEL		"Factory reset"
	            "|de|Rcksetzen in Auslieferzustand";
	ITEMS
    {
        Page_group_reset_factory
	}
}

MENU Page_group_reset_factory
{
	LABEL		"";
	ITEMS
	{
        device_status,
		coldstart   /* Methode */
	}
}

/* Gert - Selbstkalibrierung ************************************************/
MENU OnlineDialog_self_calibration
{
	LABEL		"Self calibration"
	            "|de|Selbstkalibrierung";
	HELP		[trans_act_self_calibration_cmd_help];
	ITEMS
	{
        Page_self_calibration
	}
}

MENU Page_self_calibration
{
	LABEL		"Self calibration"
	            "|de|Selbstkalibrierung";
	ITEMS
    {
        Page_group_self_calibration
	}
}

MENU Page_group_self_calibration
{
	LABEL		"";
	ITEMS
	{
        action_status,
        init_warn,
        abort_initialization, /* Methode */
        cal_zero_valve,       /* Methode */
        init_valve            /* Methode */
	}
}

/* Gert - Request-/Response Prambeln ***************************************/
MENU OnlineDialog_request_response_preambles
{
	LABEL		[menu_request_response_preambles];
	ITEMS
	{
        Page_request_response_preambles
	}
}

MENU Page_request_response_preambles
{
	LABEL		[menu_request_response_preambles];
	ITEMS
    {
        Page_group_request_response_preambles
	}
}

MENU Page_group_request_response_preambles
{
	LABEL		"";
	ITEMS
	{
		response_preambles,
		request_preambles
	}
}

/*******************************************************************************/
/* Table: Specialist  (Parametertabelle fr Spezialist)                        */
/*******************************************************************************/
MENU Table_Main_Specialist
{
	LABEL	"SAMSON Positioner Type 3780"
	        "|de|SAMSON Stellungsregler Typ 3780";
	ITEMS
	{
		Tab_s_ident,
		Tab_s_input,
		Tab_s_charact,
		Tab_s_adjustment,
		Tab_s_interface,
		Tab_s_certificates
	}
}

/* Identifikation ************************************************************/
MENU Tab_s_ident
{
	LABEL		[menu_ident];
	ITEMS
	{
		Tab_s_ident_opunit,
		Tab_s_ident_device
	}
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_s_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		tag,
		descriptor,
		message,
		text_1,
		text_2,
		text_3,
		text_4
	}
}

/* Identifikation - Gert ****************************************************/
MENU Tab_s_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		Tab_s_ident_device_positioner,
		Tab_s_ident_device_actuator,
		Tab_s_ident_device_valve,
		Tab_s_ident_device_gear
	}
}

/* Identifikation - Gert - Stellungsregler **********************************/
MENU Tab_s_ident_device_positioner
{
	LABEL		"Positioner"
	            "|de|Stellungsregler";
	ITEMS
	{
		manufacturer_id,
        device_id,
    	dev_ident_nr,
        device_type,
		komm_revision,
		regler_revision,
		electr_revision,
		mech_revision,
        date
	}
}

/* Identifikation - Gert - Stellantrieb *************************************/
MENU Tab_s_ident_device_actuator
{
	LABEL		"Control drive"
	            "|de|Stellantrieb";
	ITEMS
	{
		id_antrieb
	}
}

/* Identifikation - Gert - Stellglied ***************************************/
MENU Tab_s_ident_device_valve
{
	LABEL		"Regulating unit"
	            "|de|Stellglied";
	ITEMS
	{
		final_assembly_number,
		antrieb           (READ_ONLY),
		nennhub           (READ_ONLY),
		nennwinkel        (READ_ONLY),
        summ_beweg_value
	}
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_s_ident_device_gear
{
	LABEL		"Additional component"
	            "|de|Zusatzkomponente";
	ITEMS
	{
		kenn_gr_kont,
    	ind_gr_kont,
		kenn_stm,
		wirkricht_stell_m,
		kenn_shutd,
		write_protect
	}
}

/* Eingang *******************************************************************/
MENU Tab_s_input
{
	LABEL		[menu_input];
	ITEMS
	{
		Tab_s_input_input,
		Tab_s_input_workrange,
		Tab_s_input_table
	}
}

/* Eingang - Eingangsgrsse ***************************************************/
MENU Tab_s_input_input
{
	LABEL		"Input value"
	            "|de|Eingangsgre";
	ITEMS
	{
		wirkricht_regler,
		fuehr_gr_u,
		fuehr_gr_o,
		vent_auf,
		vent_zu
	}
}

/* Eingang - Arbeitsbereich **************************************************/
MENU Tab_s_input_workrange
{
	LABEL		"Working range"
	            "|de|Arbeitsbereich";
	ITEMS
	{
	    hubanfang,
	    hubende,
	    drehw_anfang,
	    drehw_ende,
		hubgr_u,
		hubgr_o
	}
}

/* Eingang - Kennlinie *******************************************************/
MENU Tab_s_input_table
{
	LABEL		"Characterization"
	            "|de|Kennlinie";
	ITEMS
	{
		eing_kl,
		Tab_s_input_table_usertable
	}
}

/* Eingang - Kennlinie - Benutzerdefinierte Kennlinie ************************/
MENU Tab_s_input_table_usertable
{
	LABEL	"User defined characterization"
	        "|de|Benutzerdefinierte Kennlinie";
	ITEMS
	{
		kennlinientyp,
    	x0   (READ_ONLY),
    	x1   (READ_ONLY),
    	x2   (READ_ONLY),
    	x3   (READ_ONLY),
    	x4   (READ_ONLY),
    	x5   (READ_ONLY),
    	x6   (READ_ONLY),
    	x7   (READ_ONLY),
    	x8   (READ_ONLY),
    	x9   (READ_ONLY),
    	x10  (READ_ONLY),
    	y0   (READ_ONLY),
    	y1   (READ_ONLY),
    	y2   (READ_ONLY),
    	y3   (READ_ONLY),
    	y4   (READ_ONLY),
    	y5   (READ_ONLY),
    	y6   (READ_ONLY),
    	y7   (READ_ONLY),
    	y8   (READ_ONLY),
    	y9   (READ_ONLY),
    	y10  (READ_ONLY)
	}
}

/* Kennwerte *****************************************************************/
MENU Tab_s_charact
{
	LABEL		"Performance characteristics"
	            "|de|Kennwerte";
	ITEMS
	{
		xtot,
		kp_y1,
		kp_y2,
		kd,
		ueberschw_w,
		Tab_s_charact_powerloss,
		Tab_s_charact_traveltime,
		Tab_s_charact_error
	}
}

/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_s_charact_powerloss
{
	LABEL		"Power loss"
	            "|de|Ausfallverhalten";
	ITEMS
	{
		federwirkung,
		stm_sonder,
		stm_com,
		stm_w_int
	}
}

/* Kennwerte - Stellzeit *****************************************************/
MENU Tab_s_charact_traveltime
{
	LABEL		"Travel time"
	            "|de|Stellzeit";
	ITEMS
	{
		min_lauf_zu,
		min_lauf_ab,
		gew_lauf_zu,
		gew_lauf_ab
	}
}

/* Kennwerte - Fehlerberwachung *********************************************/
MENU Tab_s_charact_error
{
	LABEL		"Error monitoring"
	            "|de|Fehlerberwachung";
	ITEMS
	{
		toleranzband,
		nachlaufzeit,
		summ_beweg_value,
		grenz_beweg,
	    swk_a,
	    swk_a_ein,
	    swk_b,
	    swk_b_ein
	}
}

/* Inbetriebnahme ************************************************************/
MENU Tab_s_adjustment
{
	LABEL		"Adjustment"
	            "|de|Inbetriebnahme";
	ITEMS
	{
	   antrieb,
	   anbau,
	   bauart,
       nennhub,
       nennwinkel,
	   h_code,
	   h_laenge,
	   stiftposition,
	   init_art,
	   anbaulage,
	   init_warn,
	   federwirkung,
	   maxhub,
       imp_1,
       imp_2,
       imp_3
	}
}

/* Zertifikate und Zulassungen ***********************************************/
MENU Tab_s_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		zuendschutzart	(READ_ONLY)
	}
}

/*******************************************************************************/
/* Table: Maintenance  (Parametertabelle fr Instandhalter)                    */
/*******************************************************************************/
MENU Table_Main_Maintenance
{
	LABEL	"SAMSON Positioner Type 3780"
	        "|de|SAMSON Stellungsregler Typ 3780";
	ITEMS
	{
		Tab_m_ident,
		Tab_m_input,
		Tab_m_charact,
		Tab_m_certificates
	}
}

/* Identifikation ************************************************************/
MENU Tab_m_ident
{
	LABEL		[menu_ident];

	ITEMS
	{
		Tab_m_ident_opunit,
		Tab_m_ident_device
	}
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_m_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		tag,
		descriptor,
		message,
		text_1,
		text_2,
		text_3,
		text_4
	}
}

/* Identifikation - Gert ****************************************************/
MENU Tab_m_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		Tab_m_ident_device_positioner,
		Tab_m_ident_device_actuator,
		Tab_m_ident_device_valve,
		Tab_m_ident_device_gear
	}
}

/* Identifikation - Gert - Stellungsregler **********************************/
MENU Tab_m_ident_device_positioner
{
	LABEL		"Positioner"
	            "|de|Stellungsregler";
	ITEMS
	{
		manufacturer_id,
		device_id,
    	dev_ident_nr,
        device_type,
		komm_revision,
		regler_revision,
		electr_revision,
		mech_revision,
        date
	}
}

/* Identifikation - Gert - Stellantrieb *************************************/
MENU Tab_m_ident_device_actuator
{
	LABEL		"Control drive"
	            "|de|Stellantrieb";
	ITEMS
	{
		id_antrieb
	}
}

/* Identifikation - Gert - Stellglied ***************************************/
MENU Tab_m_ident_device_valve
{
	LABEL		"Regulating unit"
	            "|de|Stellglied";
	ITEMS
	{
		final_assembly_number,
		antrieb           (READ_ONLY),
	    anbau             (READ_ONLY),
	    bauart            (READ_ONLY),
		nennhub           (READ_ONLY),
		nennwinkel        (READ_ONLY),
	    h_code            (READ_ONLY),
	    h_laenge          (READ_ONLY),
	    stiftposition     (READ_ONLY),
	    anbaulage         (READ_ONLY),
        summ_beweg_value
	}
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_m_ident_device_gear
{
	LABEL		"Additional component"
	            "|de|Zusatzkomponente";
	ITEMS
	{
		kenn_gr_kont,
		kenn_stm,
		wirkricht_stell_m,
		kenn_shutd,
		write_protect
	}
}

/* Eingang *******************************************************************/
MENU Tab_m_input
{
	LABEL		[menu_input];
	ITEMS
	{
		Tab_m_input_input,
		Tab_m_input_workrange,
		Tab_m_input_table
	}
}

/* Eingang - Eingangsgrsse ***************************************************/
MENU Tab_m_input_input
{
	LABEL		"Input value"
	            "|de|Eingangsgre";
	ITEMS
	{
		wirkricht_regler,
		fuehr_gr_u,
		fuehr_gr_o
	}
}

/* Eingang - Arbeitsbereich **************************************************/
MENU Tab_m_input_workrange
{
	LABEL		"Working range"
	            "|de|Arbeitsbereich";
	ITEMS
	{
	    hubanfang,
	    hubende,
	    drehw_anfang,
	    drehw_ende,
		hubgr_u,
		hubgr_o
	}
}

/* Eingang - Kennlinie *******************************************************/
MENU Tab_m_input_table
{
	LABEL		"Characterization"
	            "|de|Kennlinie";
	ITEMS
	{
		eing_kl
	}
}

/* Kennwerte *****************************************************************/
MENU Tab_m_charact
{
	LABEL		"Performance characteristics"
	            "|de|Kennwerte";
	ITEMS
	{
		Tab_m_charact_powerloss
	}
}

/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_m_charact_powerloss
{
	LABEL		"Power loss"
	            "|de|Ausfallverhalten";
	ITEMS
	{
		federwirkung
	}
}

/* Zertifikate und Zulassungen ***********************************************/
MENU Tab_m_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		zuendschutzart
	}
}

/*******************************************************************************/
/* Upload / Download Menu                                                      */
/*******************************************************************************/
MENU upload_variables  /* Schreiben ins Feldgert */
{
	LABEL		[menu_load_to_device];
	ITEMS
	{
        /* Inbetriebnahme / Initialisierung */
    	antrieb
    	/* Restliche Parameter werden durch PostWriteAction
    	   bei 'antrieb' geschrieben */
	}
}

/*****************************************************************************/
MENU download_variables  /* Lesen aus Feldgert */
{
    LABEL   [menu_load_to_PC];
    ITEMS
    {   /* Gerteidentifikation */
    	tag,
    	descriptor,
    	message,
    	date,
    	manufacturer_id,
    	device_type,
    	device_id,
    	dev_ident_nr,
    	zuendschutzart,
    	id_antrieb,
    	final_assembly_number,
        text_1,
        text_2,
        text_3,
        text_4,
    	komm_revision,
    	regler_revision,
    	electr_revision,
    	mech_revision,
    	universal_revision,
    	transmitter_revision,
    	request_preambles,
    	summ_beweg_value,
        /* Inbetriebnahme / Initialisierung */
    	antrieb,
    	anbau,
    	h_code,
    	h_laenge,
    	stiftposition,
    	nennhub,
    	nennwinkel,
    	anbaulage,
    	bauart,
    	init_art,
        init_warn,
    	federwirkung,
    	min_lauf_zu,
    	min_lauf_ab,
    	maxhub,
    	x0,
    	x1,
    	x2,
    	x3,
    	x4,
    	x5,
    	x6,
    	x7,
    	x8,
    	x9,
    	x10,
    	y0,
    	y1,
    	y2,
    	y3,
    	y4,
    	y5,
    	y6,
    	y7,
    	y8,
    	y9,
    	y10,
        /* Regelparameter */
    	kp_y1,
    	kp_y2,
    	kd,
    	xtot,
    	ueberschw_w,
        imp_1,
        imp_2,
        imp_3,
        /* Konfiguration */
    	kenn_stm,
    	kenn_shutd,
    	kenn_gr_kont,
    	ind_gr_kont,
    	toleranzband,
    	nachlaufzeit,
    	stm_com,
    	stm_sonder,
    	stm_w_int,
    	grenz_beweg,
    	gew_lauf_zu,
    	gew_lauf_ab,
    	wirkricht_regler,
    	fuehr_gr_u,
    	fuehr_gr_o,
    	hubanfang,
    	hubende,
    	drehw_anfang,
    	drehw_ende,
    	hubgr_u,
    	hubgr_o,
    	vent_zu,
    	vent_auf,
    	eing_kl,
		kennlinientyp,
        swk_a,
        swk_a_ein,
 	    swk_b,
	    swk_b_ein,
		write_protect,
		wirkricht_stell_m
    }
}
/*** ENDE **********************************************************************/
