/*--------------------------------------------------------------------------*/
/*	Copyright (C)   SAMSON AG (1999-2003). All Rights Reserved	            */
/*	Product:		SIEMENS SIMATIC PDM  					                */
/*	Device:			SAMSON Positioner 373X-3 HART capable                   */
/*	Communication:	HART									                */
/*	Dictionary:		SIHADC01.dct							                */
/*															                */
/*	Description:	Device Description with					                */
/*					- universal commands                                    */
/*					- common practice commands                              */
/*					- manufacturer specific commands                        */
/*					- methods for special functions     	                */
/*	Author:    		KMR - E42 - SAMSON AG	                                */
/*	Version:        1.0                                                     */
/*	Date:           21.05.2003  							                */
/*--------------------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                                          */
/* ------     ------  ------------                                          */
/* 24.10.2003 Kmr/E42 Erste Version                                         */
/*                    mit SIMATIC Manager Version 5.2 (V5.2.0.0) (OEM-Edit.)*/
/*                    mit PDM Version 5.2 SP1 (K5.2.1.0))                   */
/*                    xmtr_specific_status_5: 0x00 eingefgt, da sonst      */
/*                    '0' angezeigt wird wenn kein Bit gesetzt ist.         */
/*                    Methode fr Geraetezustand in der LifeList            */
/*                    (method_PDM_StandardDiagnosis) eingefgt.             */
/*                    EB-Aufruf eingefgt.                                  */
/*                    Bargraph w (BarVal_sp_display): bei Hand wird als     */
/*                    Sollwert w_hand angezeigt.                            */
/*                    Methode fr Gertezustand in der LifeList             */
/*                    (method_PDM_StandardDiagnosis) eingefgt.             */
/*                    Aufruf add_abort_method bei start_nullpunktabgleich   */
/*                    und start_initialisierung entfernt, da sonst lfd.     */
/*                    NP/Init. unbeabsichtigt abgebrochen werden kann.      */
/*                    MIN_VALUE=0 bei final_assembly_number eingefgt.      */
/* 29.10.2004 Kmr/E42 Franzsische und chinesische pdf-EB eingefgt.        */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

MANUFACTURER	  66,   /* SAMSON AG, Frankfurt, Germany  */
DEVICE_TYPE		 239,   /* Positioner 373X-3 HART capable */
DEVICE_REVISION    2,   /* Device Revision                */
DD_REVISION		   1    /* Device Description Revision    */

/*****************************************************************************/
/* DEFINES                                                                   */
/*****************************************************************************/
/* fr Methode methodOpenDeviceManual_3730: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3730 "e83843en.pdf"        \
                                    "|de|e83843de.pdf"    \
                                    "|fr|e83843fr.pdf"    \
                                    "|zh|e83843zh.pdf"

/* kmr: wenn 3731-3 EB verfgbar (richtige Dateinamen eintragen !) : */
/* fr Methode methodOpenDeviceManual_3731: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3731 "e83843en.pdf"        \
                                    "|de|e83843de.pdf"    \
                                    "|fr|e83843fr.pdf"    \
                                    "|zh|e83843zh.pdf"

#define DEV_STATUS_SIZE     25   /* cmd 48 hat 23+2 Bytes */
#define STATUS_SIZE			 3
#define DEVICE_BUSY          8

#define NOT_IMPLEMENTED      0
#define IMPLEMENTED          1

/* Parameter Gertesperre */
#define UNLOCKING_DEVICE     0
#define LOCKING_DEVICE       1

/* Parameter Bewegungsrichtung */
#define BEWEG_STEIGEND_STEIGEND       1
#define BEWEG_STEIGEND_FALLEND        0

/* Parameter Wirkrichtung Stellungsmelder */
#define WIRK_STELL_STEIGEND_STEIGEND  0
#define WIRK_STELL_STEIGEND_FALLEND   1

/* Parameter Stiftposition */
#define PIN_POS_OFF          0
#define PIN_POS_17_MM        1
#define PIN_POS_25_MM        2
#define PIN_POS_35_MM        3
#define PIN_POS_50_MM        4
#define PIN_POS_70_MM        5
#define PIN_POS_100_MM       6
#define PIN_POS_200_MM       8
#define PIN_POS_90_GRAD      9

/* Parameter Aktuelle Betriebsart */
#define AKT_BA_INBETRIEBNAHME      0
#define AKT_BA_INIT                1
#define AKT_BA_AUTO_REGELUNG       2
#define AKT_BA_AUTO_STEUERUNG      3
#define AKT_BA_HAND_IP             4
#define AKT_BA_HAND_W              5
#define AKT_BA_HAND_W_STEUERUNG    6
#define AKT_BA_SICHERHEIT          7
#define AKT_BA_TEST_MODUS          8
#define AKT_BA_ENTW_MODUS          9
#define AKT_BA_HART_REGELUNG      10
#define AKT_BA_HART_STEUERUNG     11

/* Parameter Gewnschte Betriebsart */
#define GEW_BA_AUTO                0
#define GEW_BA_HAND               32
#define GEW_BA_SICHERHEIT         16

#define INIT_ART_MAX   0
#define INIT_ART_NOM   1
#define INIT_ART_MAN   2
#define INIT_ART_SUB   3

/* Sonstiges */
#define PRIMARY		   0
#define SECONDARY	   1
#define TERTIARY	   2
#define FOURTH		   3

/* 'int wrProt' muss in der verwendeten Methode definiert sein !  */
/* (static_enums_code2...4 wegen Fehler beim Parameter anzahl_np) */
#define CHECK_WRITE_PROTECTION                                 \
	    iassign(static_enums_code1,  93);                      \
	    iassign(static_enums_code2,  94);    /* irgendwas */   \
	    iassign(static_enums_code3, 101);    /* irgendwas */   \
	    iassign(static_enums_code4, 102);    /* irgendwas */   \
        send_command(130); /* HART-Schreibschutz auslesen */   \
        wrProt = ivar_value (hart_schreibschutz);              \
        if (wrProt == 1)                                       \
        {   /* HART-Schreibschutz ist aktiv */                 \
            ACKNOWLEDGE("Device is write protected."           \
                        "|049Gert ist schreibgeschtzt.");    \
            process_abort();  /* Methode beenden */            \
        }

/* 'int akt_BA' muss in der verwendeten Methode definiert sein ! */
#define CHECK_ACT_MODE                                         \
	    iassign(static_enums_code1,  86);                      \
	    iassign(static_enums_code2,  94);  /* irgendwas */     \
	    iassign(static_enums_code3, 101);  /* irgendwas */     \
	    iassign(static_enums_code4, 102);  /* irgendwas */     \
        send_command(130); /* akt. Betriebsart auslesen */     \
        akt_BA = ivar_value (akt_betriebsart);                 \
        if (akt_BA == AKT_BA_SICHERHEIT)                       \
        {   /* Sicherheitsstellung ist aktiv */                \
            ACKNOWLEDGE("Fail safe position is active."        \
                        "|049Sicherheitsstellung ist aktiv."); \
            process_abort();  /* Methode beenden */            \
        }

/*****************************************************************************/
/* fr Methode method_PDM_StandardDiagnosis: */
#define PDM_DIAG_FAULT						0x0001
#define PDM_DIAG_MAINT_REQUIRED				0x0002
#define PDM_DIAG_MAINT_RECOMMENDED			0x0004
#define PDM_DIAG_PROCESS_ERROR				0x0010
#define PDM_DIAG_CONFIG_ERROR				0x0020
#define PDM_DIAG_SIMULATION					0x0040
#define PDM_DIAG_GOOD						0x0008
/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS   0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS                0xFFF7  /* Lsche GOOD */
/*****************************************************************************/

/* Hilfe fr benutzerdefinierte Kennlinienwerte x0...y10 */
#define xy_help                                                                      \
        "Coordinates for user - defined control valve characteristic. x[n] = "       \
        "reference variable in % of the respective range. y[n] = travel / opening "  \
        "angle in % of the respective range."                                        \
        "|049Sttzwerte fr benutzerdefinierte Zuordnung zwischen "                  \
        "Fhrungsgre und Hub / Drehwinkel. x[n] = Fhrungsgre in % "             \
        "des Fhrungsgrenbereichs. y[n] = Hub- / Drehwinkel in % des "             \
        "Hub / Drehwinkelbereichs."
/*****************************************************************************/

/*****************************************************************************/
/* Includes                                                                  */
/*****************************************************************************/
/* keine */

/*****************************************************************************/
/* VARIABLEN                                                                 */
/*****************************************************************************/

/* ------------------------------------------------------------------------ */
/* ARRAYs: static_param, static_enums, user_text                            */
/*         Indices nach Parameter-Nummer der Dokumentation                  */
/* ------------------------------------------------------------------------ */
/* fuer cmd 128 (Lesen) und 129 (Schreiben) */
ARRAY OF VARIABLE static_param /* float/integer */
{
    ELEMENTS
    {                                   /* Para.-Nr. (Doku): */
        7, antriebsdruck            ;   /*   51   */
        9, w_hand                   ;   /*    2   */
       10, nennbereich              ;   /*    6/54 (gew. und erm. Nennbereich) */
    /* 11, antriebswirkflaeche      ; siehe cmd 147/148 */  /*  153   */
       12, stelldruckbereich_anfang ;   /*  154   */
       13, stelldruckbereich_ende   ;   /*  155   */
       14, versorgungsdruck         ;   /*  156   */
       15, nennweite_dn             ;   /*  164   */
       16, kvs_wert                 ;   /*  166   */
       17, sitzdurchmesser_ventil   ;   /*  167   */
       24, x0                       ;   /*  111   */
       25, x1                       ;   /*  112   */
       26, x2                       ;   /*  113   */
       27, x3                       ;   /*  114   */
       28, x4                       ;   /*  115   */
       29, x5                       ;   /*  116   */
       30, x6                       ;   /*  117   */
       31, x7                       ;   /*  118   */
       32, x8                       ;   /*  119   */
       33, x9                       ;   /*  120   */
       34, x10                      ;   /*  121   */
       35, y0                       ;   /*  122   */
       36, y1                       ;   /*  123   */
       37, y2                       ;   /*  124   */
       38, y3                       ;   /*  125   */
       39, y4                       ;   /*  126   */
       40, y5                       ;   /*  127   */
       41, y6                       ;   /*  128   */
       42, y7                       ;   /*  129   */
       43, y8                       ;   /*  130   */
       44, y9                       ;   /*  131   */
       45, y10                      ;   /*  132   */
       47, wegintegral              ;   /*   28   */
       48, grenzwert_a1             ;   /*   32   */
       49, grenzwert_a2             ;   /*   34   */
       51, test_stellmelder         ;   /*   38   */
       52, min_laufzeit_zu          ;   /*   48   */
       55, min_laufzeit_auf         ;   /*   47   */
       58, toleranzband             ;   /*   24   */
       60, gw_wegintegral           ;   /*   29   */
       70, blockierstellung         ;   /*   42   */
       71, regeldifferenz           ;   /*   46   */
       72, device_id                ;   /*  106   */
       73, nachlaufzeit             ;   /*  133   */
      100, w_ma_bereich_anfang      ;   /*  339   */
      101, w_ma_bereich_ende        ;   /*  340   */
      102, ueberwachungszeit        ;   /*  324   */
      103, endlage_w_kleiner        ;   /*   18   */
      104, endlage_w_groesser       ;   /*   20   */
      105, gew_laufzeit_auf         ;   /*   26   */
      106, gew_laufzeit_zu          ;   /*   27   */
      107, x_bereich_anfang         ;   /*    9   */
      108, x_bereich_ende           ;   /*   10   */
      109, x_begrenzung_unten       ;   /*   12   */
      110, x_begrenzung_oben        ;   /*   14   */
    }
}

/* -------------------------------------------------------------------------- */
/* fuer cmd 130 (Lesen) und 131 (Schreiben) */
ARRAY OF VARIABLE static_enums /* combobox */
{
    ELEMENTS
    {                                      /* Para.-Nr. (Doku): */
       56, anzahl_np                  ;    /* 175   */
       57, initialisierungsart        ;    /*   7   */
       58, geraetetyp                 ;    /* 148   */
       59, geraetesperre              ;    /* 332   */
       60, bewegungsrichtung          ;    /*   8   */
       61, gew_betriebsart            ;    /*   1/350 */
       62, kennlinienauswahl          ;    /*  25   */
       63, booster                    ;    /* 152   */
       64, fliessrichtung             ;    /* 158   */
       65, stangenabdichtung          ;    /* 159   */
       66, dichtkante                 ;    /* 160   */
       67, druckentlastung            ;    /* 161   */
       68, kennlinie_kegel            ;    /* 162   */
       69, nennweiten_norm            ;    /* 163   */
       70, kvs_einheit                ;    /* 165   */
       71, stoerung_vorhanden         ;    /* 144   */
       72, stiftposition              ;    /*   5   */
       73, stellungsmelder            ;    /*  44   */
       75, ind_grenzkontakt           ;    /*  45   */
       77, stoerm_sonderfunktion      ;    /*  39   */
       79, stoerm_wegintegral         ;    /*  40   */
       80, wirkr_stellmelder          ;    /*  36   */
       81, status_a1                  ;    /* 141   */
       82, status_a2                  ;    /* 143   */
       83, zertifizierung             ;    /* 333   */
       84, bauart                     ;    /* 334   */
       85, anbau                      ;    /* 335   */
       86, akt_betriebsart            ;    /* 109/349 */
       87, sicherheitsstellung        ;    /* 134   */
       88, x_unterschreitet_a1        ;    /* 140   */
       89, x_ueberschreitet_a2        ;    /* 142   */
       93, hart_schreibschutz         ;    /* 336   */
       94, geraet_ini                 ;    /* 145   */
      101, aktiv_endlage_w_kleiner    ;    /*  17   */
      102, aktiv_endlage_w_groesser   ;    /*  19   */
      103, aktiv_x_begrenzung_unten   ;    /*  11   */
      104, aktiv_x_begrenzung_oben    ;    /*  13   */
      105, kp_stufe                   ;    /*  22   */
      106, tv_stufe                   ;    /*  23   */
      107, aktiv_gw_a1                ;    /*  31   */
      108, aktiv_gw_a2                ;    /*  33   */
      109, leserichtung               ;    /*   3   */
      110, alarmmodus                 ;    /*  30   */
      111, druckgrenze                ;    /*  21   */
      112, schliessrichtung           ;    /*  41   */
      113, stoerm_mit_stellmelder     ;    /*  37   */
      114, magnetventil               ;    /*  52   */
      115, zwangsentlueftung          ;    /* 138 Magnetventil */
      /* kmr: mit 120-143 koennten die Fehlercodes (pro Fehler 1 Byte) eingelesen
         werden. Wird hier aber nicht verwendet, da mit cmd 48 eingelesen. */
    }
}

/* ------------------------------------------------------------------------ */
ARRAY OF VARIABLE user_text
{
    ELEMENTS
    {                          /* Para#: */
         1, textfeld_1    ;    /* 103    */
         2, textfeld_2    ;    /* 104    */
         3, textfeld_3    ;    /* 105    */
         4, textfeld_4    ;    /* 146    */
         5, textfeld_5    ;    /* 147    */
         6, ident_antrieb ;    /* 151    */
         7, ident_ventil  ;    /* 157    */
    }
}

/*****************************************************************************/
/* PV, SV, TV, QV                                                            */
/*****************************************************************************/
ARRAY OF COLLECTION dynamic_variables
{
    ELEMENTS
    { /* PRIMARY ist immer Ausgang Split Range zugeordnet */
      PRIMARY   , transmitter_variables[0]                   , [primary]  ;
      SECONDARY , transmitter_variables[zuordnung_sek_var]   , [secondary];
      TERTIARY  , transmitter_variables[zuordnung_tert_var]  , [tertiary] ;
      FOURTH    , transmitter_variables[zuordnung_quart_var] , [fourth]   ;
    }
}

/* ------------------------------------------------------------------------ */
/* Alle mgliche dynamische Variablen */
ARRAY OF COLLECTION transmitter_variables
{
    ELEMENTS
    {
      0, coll_ausgang_split_range; /* Ausg. Split-Range */
      1, coll_ventilsollwert     ; /* Ventilsollwert    */
      2, coll_zielposition       ; /* Zielposition      */
      3, coll_ventilposition     ; /* Ventilposition    */
      4, coll_regeldifferenz     ; /* Regeldifferenz    */
      5, coll_wegintegral        ; /* Wegintegral       */
    }
}

/* ------------------------------------------------------------------------ */
/* Ausgang Split-Range */
COLLECTION OF VARIABLE coll_ausgang_split_range
{
  LABEL " ";
  HELP  " ";

  MEMBERS
  {
	  DIGITAL_VALUE, ausgang_split_range;
	  DIGITAL_UNITS, dynamic_units;
	  ANALOG_VALUE , ausgang_split_range;

	  PERCENT_RANGE       , dummy_float;
	  MINIMUM_SPAN        , dummy_float;
	  ALARM_CODE          , dummy_enum;
	  TRANSFER_FUNCTION   , dummy_enum;
	  SENSOR_SERIAL_NUMBER, serial_no;
	  SENSOR_UNITS        , dynamic_units;
	  LOWER_SENSOR_LIMIT  , dummy_float;
	  UPPER_SENSOR_LIMIT  , dummy_float;
	  RANGE_UNITS         , dynamic_units;
	  LOWER_RANGE_VALUE   , lower_range_value;
	  UPPER_RANGE_VALUE   , upper_range_value;
	  DAMPING_VALUE       , dummy_float;
  }
}

/* Ventilsollwert */
COLLECTION OF VARIABLE coll_ventilsollwert
{
  LABEL " ";
  HELP  " ";

  MEMBERS
  {
    DIGITAL_VALUE, ventilsollwert;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , ventilsollwert;
  }
}

/* Zielposition */
COLLECTION OF VARIABLE coll_zielposition
{
  LABEL " ";
  HELP  " ";

  MEMBERS
  {
    DIGITAL_VALUE, zielposition;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , zielposition;
  }
}

/* Ventilposition */
COLLECTION OF VARIABLE coll_ventilposition
{
  LABEL " ";
  HELP  " ";

  MEMBERS
  {
    DIGITAL_VALUE, ventilposition;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , ventilposition;
  }
}

/* Regeldifferenz */
COLLECTION OF VARIABLE coll_regeldifferenz
{
  LABEL " ";
  HELP  " ";

  MEMBERS
  {
    DIGITAL_VALUE, regeldifferenz;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , regeldifferenz;
  }
}

/* Wegintegral */
COLLECTION OF VARIABLE coll_wegintegral
{
  LABEL " ";
  HELP  " ";

  MEMBERS
  {
    DIGITAL_VALUE, wegintegral;
    DIGITAL_UNITS, dummy_enum;
    ANALOG_VALUE , wegintegral;
  }
}

/* ------------------------------------------------------------------------ */
/* Primary Variable                                                         */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE sollwert
{
    MEMBERS
    {
	  DIGITAL_VALUE, sollwert_value;
	  DIGITAL_UNITS, dynamic_units;
	  ANALOG_VALUE, sollwert_analog_value;
	  PERCENT_RANGE, dummy_float;
	  MINIMUM_SPAN, dummy_float;
	  ALARM_CODE, dummy_enum;
	  TRANSFER_FUNCTION, dummy_enum;
	  SENSOR_SERIAL_NUMBER, serial_no;
	  SENSOR_UNITS, dynamic_units;
	  LOWER_SENSOR_LIMIT, dummy_float;
	  UPPER_SENSOR_LIMIT, dummy_float;
	  RANGE_UNITS, dynamic_units;
	  LOWER_RANGE_VALUE, lower_range_value;
	  UPPER_RANGE_VALUE, upper_range_value;
	  DAMPING_VALUE, dummy_float;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE sollwert_value
{
  CLASS DEVICE&DYNAMIC;
  LABEL "w";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 120.0;
  }

  HELP "Reference variable (setpoint value) in % with consideration"
	   " to reference variable range."
	   "|049Fhrungsgre in % unter Bercksichtigung von "
	   "Fhrungsgre Anfang und Ende.";
}

/* ------------------------------------------------------------------------ */
VARIABLE sollwert_analog_value
{
  CLASS DEVICE&DYNAMIC;
  LABEL "w_analog";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.2f";

      MIN_VALUE  3.00;
      MAX_VALUE 24.00;
  }
  CONSTANT_UNIT "mA";

  HELP "Current input signal in mA; used as reference variable w"
  	   " in 'Auto' mode."
  	   "|049Stromeingang in mA, dient in Betriebsart 'Auto' als "
	   "Fhrungsgre.";
}

/* ------------------------------------------------------------------------ */
VARIABLE dynamic_units
{
  CLASS DEVICE&DYNAMIC;
  LABEL "units";
  HANDLING READ;
  TYPE ENUMERATED
  {
      { 57, "%"}
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE serial_no
{
    CLASS DEVICE;
	LABEL [pv_sensor_serial_number];
	TYPE  UNSIGNED_INTEGER (3)
	{
		DISPLAY_FORMAT  "7d";
		EDIT_FORMAT     "7d";
	}
}

/* ------------------------------------------------------------------------ */
VARIABLE upper_range_value
{
  CLASS DEVICE;
  LABEL "urv";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  HELP "Upper Range Value";
}

/* ------------------------------------------------------------------------ */
VARIABLE lower_range_value
{
  CLASS DEVICE;
  LABEL "lrv";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  HELP "Lower Range Value";
}

/* ------------------------------------------------------------------------ */
VARIABLE dummy_float
{
  LABEL "d_float";
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE dummy_enum
{
  LABEL "d_enum";
  TYPE ENUMERATED
  {
      { 0, " "}
  }
}

/* ------------------------------------------------------------------------ */
/* Secondary Variable                                                       */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE istwert
{
    MEMBERS
    {
	  DIGITAL_VALUE, istwert_value;
	  DIGITAL_UNITS, dynamic_units;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE istwert_value
{
  CLASS DEVICE&DYNAMIC;
  LABEL "x";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  HELP "Controlled variable (actual value) in % in reference to range"
       " of travel/opening angle"
       "|049Regelgre in % bezogen auf Hub-/Drehwinkelbereich";
}

/* ------------------------------------------------------------------------ */
/* Tertiary Variable                                                        */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE regeldiff
{
    MEMBERS
    {
	  DIGITAL_VALUE, regeldiff_value;
	  DIGITAL_UNITS, dynamic_units;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE regeldiff_value
{
  CLASS DEVICE&DYNAMIC;
  LABEL "e (w-x)";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  HELP "Control deviation; corresponds to error e = w - x"
       "|049Regeldifferenz in %";
}

/* ------------------------------------------------------------------------ */
/* Fourth Variable                                                          */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE wegint
{
    MEMBERS
    {
	  DIGITAL_VALUE, summ_beweg_value;
	  DIGITAL_UNITS, summ_beweg_units;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE summ_beweg_value
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Current value" "|049Aktueller Wert";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "7.0f";
      MIN_VALUE 0.0;
      MAX_VALUE 16500000.0;
  }

  HELP "Valve travel summation in cycles of the rated travel"
	   "|049Summe der Nennlastspiele";
}

/* ------------------------------------------------------------------------ */
VARIABLE summ_beweg_units
{
  CLASS DEVICE&DYNAMIC;
  LABEL "units";
  HANDLING READ;
  TYPE ENUMERATED
  {
      {251, " "}
  }
}


/*****************************************************************************/
/* Weitere Variablen                                                         */
/*****************************************************************************/
VARIABLE response_code
{
  HELP [command_specific_response_code_help];
/*
  APPHELP "NOTE- HART Revisions < 5 had a different specification for this"
	  " variable."
	  " "
	  "The Following Applies to HART Revision >= 5"
	  " Command Specific Response Codes are encoded in bits #6 - #0 of the"
	  " first byte of the Response Codes. These codes are 7-bit unsigned"
	  " integers, have values ranging from 0 to 127, and are not bit-mapped."
	  " "
	  "The Command Specific Response Codes have symbolic meanings which"
	  " fall into the following basic types:"
	  " "
	  "Success- Command executed properly. All Data Bytes are"
	  "         included in the Slave response."
	  " "
	  "Warning- Command executed was completed with a deviation, and the"
	  "         is described in the Command Specific Response Code."
	  "         All Data Bytes are included in the Slave response."
	  " "
	  "    Warnings with singular definitions are assigned to Command"
	  "    Specific Response Codes: 24-27, 96-111."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "    Warnings with multiple definitions are assigned to Command"
	  "    Specific Response Codes: 8, 14, 30, 31, 112-127."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "Error- Command execution was not completed, as defined by the"
	  "       Command, and the Command Specific Response Code indicates the"
	  "       reason. Therefore the Host request caused no change to"
	  "       occur in the Slave."
	  "       No Data Bytes, other than the two Response Code"
	  "       Bytes, should be included in the Slave response."
	  " "
	  "These basic types are further broken down into specific"
	  " 'Response Code Types'. See the Device Description Language
	  " Specification for the definitions of these 'Response Code Types'."
	  " "
	  "    Errors with singular definitions are assigned to Command"
	  "    Specific  Response Codes: 0-7, 16-23, 32, 33-63, 64."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "        Response Codes #32 and #64 may be returned in response to"
	  "        any command. Their definitions follow:"
	  " "
	  "            Response Code #32"
	  "                Busy- The Field Device is performing a function that"
	  "                cannot be interrupted by this command. The Command"
	  "                was not accepted."
	  " "
	  "            Response Code #64"
	  "                Command Not Implemented- The Command was not"
	  "                defined for this device. The Command was not"
	  "                accepted."
	  " "
	  "    Errors with multiple definitions are assigned to Command"
	  "    Specific Response Codes: 9-13, 15, 28, 29, 65-95."
	  "    NOTE- For HART Revision < 5 the following groupings were not"
	  "    maintained per these definitions."
	  " "
	  "NOTE- General definitions for Command Specific Response Codes"
	  "are located in the Document 'Appendix 1- Command Specific Response"
	  "Code Definitions'."
	  " "
	  "    NOTE- These assignments must be observed whenever new Command"
	  "    Specific Response Codes are defined and added to existing, or"
	  "    new, commands so that the Master can respond properly to the"
	  "    new code.";
	  " HART_VAR:Part of the Frame, RESP-CODE BYTE 1";
*/
  CLASS  LOCAL & DIAGNOSTIC;
  TYPE   ENUMERATED
    {
		{ 0,  [success] },
		{ 1,  [undefined] },
		{ 2,  [invalid_selection] },
		{ 3,  [passed_parameter_too_large] },
		{ 4,  [passed_parameter_too_small] },
		{ 5,  [too_few_data_bytes_recieved] },
		{ 6,  [xmtr_specific_command_error] },
		{ 7,  [in_write_protect_mode] },
		{ 8,  [xmtr_specific_command_error] },
		{ 9,  [xmtr_specific_command_error] },
		{ 10, [xmtr_specific_command_error] },
		{ 11, [xmtr_specific_command_error] },
		{ 12, [xmtr_specific_command_error] },
		{ 13, [xmtr_specific_command_error] },
		{ 14, [xmtr_specific_command_error] },
		{ 15, [xmtr_specific_command_error] },
		{ 16, [access_restricted] },
		{ 32, [busy] },
		{ 64, [command_not_implemented] }
	}
  HANDLING READ;  /* lt. Spec. READ/WRITE */
}

/*****************************************************************************/
VARIABLE communication_status
{
	CLASS	LOCAL;
	TYPE	BIT_ENUMERATED
    {
		{ 0x01, [communication_error]		},
		{ 0x02, [buffer_overflow]			},
		{ 0x08, [longitudinal_parity_error] },
		{ 0x10, [framing_error]				},
		{ 0x20, [overrun_error]				},
		{ 0x40, [vertical_parity_error]		}
	}
  HANDLING READ;
}

/*****************************************************************************/
VARIABLE device_status
{
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    LABEL	[device_status] ;
	HELP	[field_device_status_help];
/*
    APPHELP "This condition does not affect the actions of the Command in the"
	        " Master request. Therefore, does not affect the number of Data Bytes"
	        " in the Slave response."
	        " The Communications Error Summary is a higher priority diagnostic."
	        " Therefore, the Field Device Status should not be evaluated by the"
	        " Host if a Communications Error Summary bit is set."
	        " These specific bits can be given attributes called 'Cause Status"
	        " Classes'. See the Device Description Language Specification for the"
	        " definitions of these 'Cause Status Classes'."
	        " HART_VAR:Part of the Frame, RESP-CODE BYTE 2";
*/
  TYPE BIT_ENUMERATED
    {
        { 0x00, [no_error],                    MISC },
    	{ 0x01, [PV_out_of_limits],	           DV1 (AUTO & BAD) },
    	{ 0x02, [Non_PV_out_of_limits],        DV2 (AUTO & BAD) },
    	{ 0x04, [PV_analog_output_saturated],  AO1 (AUTO & BAD) },
    	{ 0x08, [PV_analog_output_fixed],      AO1 (MANUAL & GOOD) },
    	{ 0x10, [more_status_available],       MORE },
    	{ 0x20, [cold_start],		           MISC },
    	{ 0x40, [configuration_changed],       MISC & IGNORE_IN_HANDHELD },
    	{ 0x80, [device_malfunction],	       MORE }
    }
  HANDLING READ;
#ifdef _V510_
    STYLE "MULTILINE 12 2"; /* 2 Zeilen hoch */
#endif
}

/*****************************************************************************/
VARIABLE manufacturer_id
{
  CLASS     DEVICE;
  HELP [manufacturer_id_code_help];
/*
  APPHELP "For HART Revision >= 5
	  "    The long address of the frame is composed of the three variables"
	  "    manufacturer_id, device_type, and the device_id. The Long"
	  "    address is composed of 38 bits. The most significant bit is"
	  "    closest to the Delimiter Byte. Thus the least significant"
	  "    bit is located closest to the Command Byte. The least"
	  "    significant 6 bits of the variable manufacturer_id are mapped"
	  "    into the 6 most significant 6 bits of the long address. Note"
	  "    that the 2 most significant bits of the variable manufacturer_id"
	  "    are thrown away. The variable manufacturer_id is mapped into the"
	  "    next 8 most significant bits of the long address, and the"
	  "    device_id is mapped into the next 24 most significant bits of"
	  "    the long address."
	  " "
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, will uniquely identify a type of Field Device. The"
	  "    combination of these two variables will have only one unique"
	  "    Device Description, though there may be revisions of the Device"
	  "    Description."
	  " "
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, combined with the variable transmitter_revision,"
	  "    will identify the exact revision of the Device Description for"
	  "    this type of Field Device."
	  " "
	  "    The variable manufacturer_id, combined with the variable"
	  "    device_type, combined with the variable device_id, will"
	  "    uniquely identify a Field Device, such that there is only one"
	  "    such Field Device in the world."
	  " "
	  " NOTE- For HART Revision >= 5, the decimal numeric 254 that precedes"
	  " the manufacturer_id variable in Command #0 (i.e. one byte closer to"
	  " the Delimiter Byte), is part of an expansion mechanism that existed"
	  " for HART" Revisions < 5."
	  " NOTE- Rosemount Inc. subsidiaries should use their enumeration and"
	  " not 'Rosemount Inc.'.
	  " HART_VAR:MFR ID";
*/
  CLASS HART;
  LABEL "Manufacturer" "|de|Hersteller";
  HANDLING READ;
  TYPE ENUMERATED
    {
      { 1,   [Acromag] },
      { 2,   [Allen_Bradley] },
      { 3,   [Ametek] },
      { 4,   [Analog_Devices] },
      { 5,   [Bailey] },
      { 6,   [Beckman] },
      { 7,   [Bell_Microsensor] },
      { 8,   [Bourns] },
      { 9,   [Bristol_Babcock] },
      { 10,  [Brooks_Instrument] },
      { 11,  [Chessell] },
      { 12,  [Combustion_Engineering] },
      { 13,  [Daniel_Industries] },
      { 14,  [Delta] },
      { 15,  [Dieterich_Standard] },
      { 16,  [Dohrmann] },
      { 17,  [Endress_and_Hauser] },
      { 18,  [Fischer_and_Porter] },
      { 19,  [Fisher_Controls] },
      { 20,  [Foxboro] },
      { 21,  [Fuji] },
      { 22,  [Hartmann_and_Braun] },
      { 23,  [Honeywell] },
      { 24,  [ITT_Barton] },
      { 25,  [KayRay_Sensall] },
      { 26,  [Kent] },
      { 27,  [Leeds_and_Northrup] },
      { 28,  [Leslie] },
      { 29,  [M_System_Co] },
      { 30,  [Measurex] },
      { 31,  [Micro_Motion] },
      { 32,  [Moore_Industries] },
      { 33,  [Moore_Products] },
      { 34,  [Ohkura_Electric] },
      { 35,  [Paine] },
      { 36,  [Rochester_Instrument_Systems] },
      { 37,  [Ronan] },
      { 38,  [Rosemount] },
      { 39,  [Peek_Measurement] },
      { 40,  [Schlumberger] },
      { 41,  [Sensall] },
      { 42,  [Siemens] },
      { 43,  [Camille_Bauer] },
      { 44,  [Toshiba] },
      { 45,  [Transmation] },
      { 46,  [Rosemount_Analytical] },
      { 47,  [Valmet] },
      { 48,  [Valtek] },
      { 49,  [Varec] },
      { 50,  [Viatran] },
      { 51,  [Weed] },
      { 52,  [Westinghouse] },
      { 53,  [Xomox] },
      { 54,  [Yamatake] },
      { 55,  [Yokogawa] },
      { 56,  [Nuovo_Pignone] },
      { 57,  [Promac] },
      { 58,  [Exac_Corporation] },
      { 59,  [KDG_Mobrey] },
      { 60,  [Acrom_Control_System] },
      { 61,  [Princo] },
      { 62,  [Smar] },
      { 63,  [Eckardt] },
      { 64,  [Measurement_Technology] },
      { 65,  [Applied_System_Technologies] },
      { 66,  [Samson] },
      { 67,  [Sparling_Instruments] },
      { 68,  [Fireye] },
      { 69,  [Krohne] },
      { 70,  [Betz_Equipment] },
      { 71,  [Druck] },
      { 72,  [SOR] },
      { 73,  [Elcon_Instruments] },
      { 74,  [EMCO] },
      { 75,  [Termiflex] },
      { 76,  [VAF_Instruments] },
      { 77,  [Westlock_Controls] },
      { 78,  [Drexelbrook] },
      { 80,  [K_TEK] },
      { 81,  [Flowdata] },
      { 82,  [Draeger] },
	  { 83,  [Raytek] },
	  { 84,  [Meridian_Instruments] },
	  { 85,  [BTG] },
	  { 86,  [Magnetrol] },
	  { 87,  [Neles_Jamesbury] },
	  { 88,  [Milltronics] },
	  { 89,  [HELIOS] },
      { 90,  [Anderson_Instrument_Company] },
      { 91,  [INOR] },
      { 92,  [ROBERTSHAW] },
      { 93,  [PEPPERL_FUCHS] },
      { 94,  [ACCUTECH] },
      { 95,  [Flow_Measurement] },
      { 96,  [KAMSTRUP] },
      { 97,  [Knick] },
      { 98,  [VEGA] },
      { 99,  [MTS_SYS_CORPS_SENSORS] },
      { 100, [Oval] },
      { 101, [Masoneilan_DRESSER] },
      { 102, [Besta] },
      { 103, [Ohmart] },

      { 250, [not_used] },
      { 251, [none] },
      { 252, [unknown] },
      { 253, [special] }
    }
}

/*****************************************************************************/
VARIABLE universal_revision
{
  CLASS     HART;
  LABEL     [universal_revision];
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MAX_VALUE  253;
  }
  HELP [universal_revision_help];
/*
  APPHELP "The variable universal_revision in effect defines for the"
	  " Master how to interpret the valid Universal Command set, and also"
	  " how to send and receive the Universal Commands. Therefore, this"
	  " variable must be obtained from a Command #0 response to be able to"
	  " interpret any Universal Command. Thus to properly interpret any"
	  " Burst Mode response, the Master should know the Universal Revision"
	  " of that Slave."
	  " "
	  " NOTE- The HART Revision is a variable that is not available via the"
	  " protocol. This Revision identifies the a point in time where all"
	  " HART Documents were recorded, and was made available to Field Device"
	  " Developers as a valid set of documents for which to design a Field"
	  " Device to. Field Device Developers then can not pick and choose a"
	  " HART Document set at random."

	  " NOTE- For HART Revision <= 5 the following HART Specification"
	  " Revisions are not available via the protocol for the Physical Layer:"
	  " 'HART Physical Layer Specification'."

	  " NOTE- For HART Revision <= 5 the following HART Specification"
	  " Revisions are not available via the protocol for the Data Link"
	  " Layer: 'HART Data Link Layer Specification'."

	  " NOTE- For HART Revision <= 5 the following HART Specification"
	  " Revisions are not available via the protocol for the Application"
	  " Layer: 'HART Command Summary Information', 'HART Common"
	  " Practice Command Specification', 'HART Common Tables', 'HART"
	  " Appendix 1- Command Specific Response Code Definitions'."

	  " NOTE- A Field Device Description implicitly encodes the required"
	  " Application Layer Revisions that are required to communicate with"
	  " that Field Device."

	  " NOTE- If the Master attempts to communicate with a Field Device"
	  " that it does not have a Field Device Description for, it technically"
	  " has no way to ascertain the exact Common Practice Revision of Common"
	  " Tables Revision to utilize. It is possible by the variable"
	  " universal_revision to ascertain a minimum Common Practice Revision"
	  " and Common Tables Revision."

	  " NOTE- Value 254 is 'Reserved'."
	  " HART_VAR:UNIV CMD REV";
*/
}

/*****************************************************************************/
VARIABLE transmitter_revision
{
  CLASS     HART;
/*  LABEL     [transmitter_revision]; */
  LABEL     "Device Revision"
            "|de|Feldgerte-Revision";
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MAX_VALUE  253;
  }
  HELP [field_device_revision_help];
/*
  APPHELP "This variable in effect defines aspects of the Application"
	  " Layer, Data Link Layer, and Physical Layer, in that a HART Revision"
	  " was implicitly conformed to in the design of this Field Device"
	  " NOTE- Value 254 is 'Reserved'."
	  " HART_VAR:TRANS SPEC REV";
*/
}

/*****************************************************************************/
VARIABLE physical_signaling_code
{
  CLASS     DEVICE;
  LABEL     [physical_signalling_code];
  HANDLING  READ;
  TYPE      ENUMERATED
  {
      { 0, [bell_202_current] },
      { 1, [bell_202_voltage] },
      { 2, [rs_485] },
      { 3, [rs_232], [rs_232_help] },
      { 6, [special] }
  }
  HELP	[physical_signalling_code_help];
}

/*****************************************************************************/
VARIABLE device_flags
{
  CLASS     HART;
  LABEL     [device_flags];
  HANDLING  READ;
  TYPE      BIT_ENUMERATED
  {
      { 0x01, [Multisens_Dev], [multi_sensor_fld_dev] },
      { 0x02, [EEPROM_Ctrl] },
      { 0x04, [protocol_bridge_device] }
  }
  HELP [field_device_flags_help];
/*
  APPHELP "NOTE- The enumeration '1' does not conform to the help description."
	  " HART_VAR:FLAGS";
*/
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fehlercodes                 Doku-Nummer: 53    EB-Code: 50-75 */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_0
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Error codes byte 0" "|049Fehlercodes Byte 0";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
	  { 0x01, "x > range"
   	          "|049x > Bereich",                        DATA }, /* Fehler 50 */
	  { 0x02, "Delta x < range"
   	          "|049Delta x < Bereich",                  DATA }, /* Fehler 51 */
	  { 0x04, "Attachment"
   	          "|049Anbau",                              DATA }, /* Fehler 52 */
	  { 0x08, "Initialization time exceeded"
   	          "|049Initialisierungszeit berschritten", DATA }, /* Fehler 53 */
	  { 0x10, "Initialization / solenoid valve"
   	          "|049Initialisierung / Magnetventil",     DATA }, /* Fehler 54 */
	  { 0x20, "Travel time too short"
   	          "|049Laufzeit unterschritten",            DATA }, /* Fehler 55 */
	  { 0x40, "Pin position"
   	          "|049Stiftposition",                      DATA }, /* Fehler 56 */
	  { 0x80, "Control loop"
   	          "|049Regelkreis",                         DATA }  /* Fehler 57 */
	}
	HELP [field_device_status_0_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/*****************************************************************************/
VARIABLE xmtr_specific_status_1
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Error codes byte 1" "|049Fehlercodes Byte 1";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
   	  { 0x01, "Zero point"
      	          "|049Nullpunkt",      DATA }, /* Fehler 58 */
   	  { 0x02, "Autocorrection"
      	          "|049Autokorrektur",  DATA }, /* Fehler 59 */
   	  { 0x04, "Fatal error"
      	          "|049Fataler Fehler", DATA }, /* Fehler 60 */
   	  /*{ 0x08, "---"
      	          "|049---",            DATA },    Fehler 61 */
   	  { 0x10, "x-signal"
      	          "|049x-Signal",       DATA }, /* Fehler 62 */
   	  { 0x20, "W too small"
      	          "|049W zu klein",     DATA }, /* Fehler 63 */
   	  { 0x40, "i/p-converter"
      	          "|049i/p-Wandler",    DATA }, /* Fehler 64 */
   	  { 0x80, "Hardware"
      	          "|049Hardware",       DATA }  /* Fehler 65 */
	}
	HELP [field_device_status_1_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/*****************************************************************************/
VARIABLE xmtr_specific_status_2
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Error codes byte 2" "|049Fehlercodes Byte 2";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
    	{ 0x01, "Data memory"
     	        "|049Datenspeicher",           DATA }, /* Fehler 66 */
    	{ 0x02, "Test calculation"
     	        "|049Kontrollrechnung",        DATA }, /* Fehler 67 */
    	{ 0x04, "Control parameter"
     	        "|049Regelparameter",          DATA }, /* Fehler 68 */
    	{ 0x08, "Poti parameter"
     	        "|049Potiparameter",           DATA }, /* Fehler 69 */
    	{ 0x10, "Configuration parameter"
     	        "|049Abgleichparameter",       DATA }, /* Fehler 70 */
    	{ 0x20, "General parameter"
     	        "|049Allgemeine Parameter",    DATA }, /* Fehler 71 */
    	/*{ 0x40, "---"
     	        "|049---",                     DATA },    Fehler 72 */
    	{ 0x80, "Internal device error 1"
     	        "|049Interner Gertefehler 1", DATA }  /* Fehler 73 */
	}
	HELP [field_device_status_2_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/*****************************************************************************/
VARIABLE xmtr_specific_status_3
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Error codes byte 3" "|049Fehlercodes Byte 3";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
	  { 0x01, "HART parameter"
   	          "|049HART Parameter",           DATA }, /* Fehler 74 */
	  { 0x02, "Info parameter"
   	          "|049Info Parameter",           DATA }, /* Fehler 75 */
	  { 0x04, "No emergency mode"
   	          "|049Keine Notlaufeigenschaft", DATA }, /* Fehler 76 */
	  { 0x08, "Program load error"
   	          "|049Programmladefehler",       DATA }, /* Fehler 77 */
	  { 0x10, "Device status 3/10"
   	          "|049Gertestatus 3/10",        DATA }, /* dummy */
	  { 0x20, "Device status 3/20"
   	          "|049Gertestatus 3/20",        DATA }, /* dummy */
	  { 0x40, "Device status 3/40"
   	          "|049Gertestatus 3/40",        DATA }, /* dummy */
	  { 0x80, "Device status 3/80"
   	          "|049Gertestatus 3/80",        DATA }  /* dummy */
	}
	HELP [field_device_status_3_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kaltstart ausgefuehrt        Doku-Nummer: 348   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_4
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Start with default values executed"
               "|049Start mit Standardwerten ausgefhrt";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
        { 0x01, "Default values executed" "|049Standardwerte ausgefhrt", DATA },

    	{ 0x02, "Device status 4/02"
     	        "|049Gertestatus 4/02",       DATA }, /* dummy */
    	{ 0x04, "Device status 4/04"
     	        "|049Gertestatus 4/04",       DATA }, /* dummy */
    	{ 0x08, "Device status 4/08"
     	        "|049Gertestatus 4/08",       DATA }, /* dummy */
    	{ 0x10, "Device status 4/10"
     	        "|049Gertestatus 4/10",       DATA }, /* dummy */
    	{ 0x20, "Device status 4/20"
     	        "|049Gertestatus 4/20",       DATA }, /* dummy */
    	{ 0x40, "Device status 4/40"
     	        "|049Gertestatus 4/40",       DATA }, /* dummy */
    	{ 0x80, "Device status 4/80"
     	        "|049Gertestatus 4/80",       DATA }  /* dummy */
	}
	HELP [field_device_status_4_help];

#ifdef _V510_
    STYLE "MULTILINE 12 1"; /* 1 Zeile(n) hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ersatzabgleich durchgefuehrt  Doku-Nummer: 135   EB-Code: --  */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_5
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Initialization" "|049Initialisierung";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
    	/* wegen Darstellung von '0' wenn kein Bit gesetzt ist: 0x00 eingefgt */
        { 0x00, "No messages" "|049Keine Meldungen", DATA },

        { 0x01, "Device not initialized" "|049Gert nicht initialisiert",           DATA },
        { 0x02, "Initialized in substitution mode" "|049Ersatzabgleich durchgefhrt",
                "Indicates whether the substitution mode was executed."
                "|049Anzeige ob der Ersatzabgleich (sub mode) durchgefhrt wurde.", DATA },
    	{ 0x04, "Device status 5/04"
     	        "|049Gertestatus 5/04",       DATA }, /* dummy */
    	{ 0x08, "Device status 5/08"
     	        "|049Gertestatus 5/08",       DATA }, /* dummy */
    	{ 0x10, "Device status 5/10"
     	        "|049Gertestatus 5/10",       DATA }, /* dummy */
    	{ 0x20, "Device status 5/20"
     	        "|049Gertestatus 5/20",       DATA }, /* dummy */
    	{ 0x40, "Device status 5/40"
     	        "|049Gertestatus 5/40",       DATA }, /* dummy */
    	{ 0x80, "Device status 5/80"
     	        "|049Gertestatus 5/80",       DATA }  /* dummy */
	}
	HELP [field_device_status_5_help];

#ifdef _V510_
    STYLE "MULTILINE 12 2"; /* 2 Zeile(n) hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Wegintegral ueberschritten   Doku-Nummer: 139   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE operating_mode_1
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Total valve travel limit exceeded" "|049Wegintegral berschritten";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "Status total valve travel limit."
       "|049Status Grenzwert Wegintegral.";
}

/* ------------------------------------------------------------------------ */
/* operating_mode_2 (dummy)                                                 */
/* ------------------------------------------------------------------------ */
VARIABLE operating_mode_2
{
  CLASS DEVICE&DYNAMIC;
  LABEL "operating_mode_2" "|049operating_mode_2";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "operating_mode_2."
       "|049operating_mode_2.";
}

/* ------------------------------------------------------------------------ */
/* analog_output_saturated1 (dummy)                                         */
/* ------------------------------------------------------------------------ */
VARIABLE analog_output_saturated1
{
  CLASS DEVICE&DYNAMIC;
  LABEL "analog_output_saturated1" "|049analog_output_saturated1";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "analog_output_saturated1."
       "|049analog_output_saturated1.";
}

/* ------------------------------------------------------------------------ */
/* analog_output_saturated2 (dummy)                                         */
/* ------------------------------------------------------------------------ */
VARIABLE analog_output_saturated2
{
  CLASS DEVICE&DYNAMIC;
  LABEL "analog_output_saturated2" "|049analog_output_saturated2";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "analog_output_saturated2."
       "|049analog_output_saturated2.";
}

/* ------------------------------------------------------------------------ */
/* analog_output_saturated3 (dummy)                                         */
/* ------------------------------------------------------------------------ */
VARIABLE analog_output_saturated3
{
  CLASS DEVICE&DYNAMIC;
  LABEL "analog_output_saturated3" "|049analog_output_saturated3";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "analog_output_saturated3."
       "|049analog_output_saturated3.";
}

/* ------------------------------------------------------------------------ */
/* analog_output_fixed1 (dummy)                                             */
/* ------------------------------------------------------------------------ */
VARIABLE analog_output_fixed1
{
  CLASS DEVICE&DYNAMIC;
  LABEL "analog_output_fixed1" "|049analog_output_fixed1";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "analog_output_fixed1."
       "|049analog_output_fixed1.";
}

/* ------------------------------------------------------------------------ */
/* analog_output_fixed2 (dummy)                                             */
/* ------------------------------------------------------------------------ */
VARIABLE analog_output_fixed2
{
  CLASS DEVICE&DYNAMIC;
  LABEL "analog_output_fixed2" "|049analog_output_fixed2";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "analog_output_fixed2."
       "|049analog_output_fixed2.";
}

/* ------------------------------------------------------------------------ */
/* analog_output_fixed3 (dummy)                                             */
/* ------------------------------------------------------------------------ */
VARIABLE analog_output_fixed3
{
  CLASS DEVICE&DYNAMIC;
  LABEL "analog_output_fixed3" "|049analog_output_fixed3";
  HANDLING READ;
  TYPE ENUMERATED
  {
     { 0, "No"  "|049Nein" },
     { 1, "Yes" "|049Ja"   }
  }

  HELP "analog_output_fixed3."
       "|049analog_output_fixed3.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: device family status 6       Doku-Nummer: 325   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_6
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Device status 0" "|049Gertestatus 0";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
    	{ 0x01, "Hardware failure electronics"
    	        "|049Hardwarefehler Elektronik",      DATA },
    	{ 0x02, "Defective mechanics / pneumatics"
    	        "|049Fehler in Mechanik / Pneumatik", DATA },
    	{ 0x04, "Device status 6/04"
     	        "|049Gertestatus 6/04",              DATA }, /* dummy */
    	{ 0x08, "Checksum error EEPROM"
    	        "|049Checksum error EEPROM",          DATA },
    	{ 0x10, "Defective position transmitter"
    	        "|049Fehler in Wegaufnehmer",         DATA },
    	{ 0x20, "Power supply failed"
    	        "|049Hilfsenergie zu gering",         DATA },
    	{ 0x40, "Local operation active"
    	        "|049Vor-Ort-Bedienung aktiv",        DATA },
    	{ 0x80, "Solenoid valve active"
    	        "|049Magnetventil aktiv",             DATA }
	}
	HELP [field_device_status_6_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: device family status 7       Doku-Nummer: 326   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_7
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Device status 1" "|049Gertestatus 1";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
    	{ 0x01, "Device not initialized"
    	        "|049Gert nicht initialisiert",         DATA },
    	{ 0x02, "Initialization not successful"
    	        "|049Initialisierung nicht erfolgreich", DATA },
    	{ 0x04, "Initialization is running"
    	        "|049Initialisierung luft",             DATA },
    	{ 0x08, "Device status 7/08"
     	        "|049Gertestatus 7/08",                 DATA }, /* dummy */
    	{ 0x10, "User defined characteristics not valid"
    	        "|049Benutzerdef. Kennlinie ungltig",   DATA },
    	{ 0x20, "Device status 7/20"
     	        "|049Gertestatus 7/20",                 DATA }, /* dummy */
    	{ 0x40, "Device status 7/40"
     	        "|049Gertestatus 7/40",                 DATA }, /* dummy */
    	{ 0x80, "Device status 7/80"
     	        "|049Gertestatus 7/80",                 DATA }  /* dummy */
	}
	HELP [field_device_status_7_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: device family status 8       Doku-Nummer: 327   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_8
{
	CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
    LABEL      "Device status 2" "|049Gertestatus 2";
	HANDLING   READ;
	TYPE       BIT_ENUMERATED
	{
    	{ 0x01, "Travel time too short"
    	        "|049Laufzeit zu kurz",          DATA },
    	{ 0x02, "Control loop fault"
    	        "|049Regelkreis gestrt",        DATA },
    	{ 0x04, "Zero point error"
    	        "|049Nullpunktfehler",           DATA },
    	{ 0x08, "Device status 8/08"
     	        "|049Gertestatus 8/08",         DATA }, /* dummy */
    	{ 0x10, "Total valve travel exceeded"
    	        "|049Wegintegral berschritten", DATA },
    	{ 0x20, "Device status 8/20"
     	        "|049Gertestatus 8/20",         DATA }, /* dummy */
    	{ 0x40, "Device status 8/40"
     	        "|049Gertestatus 8/40",         DATA }, /* dummy */
    	{ 0x80, "Device status 8/80"
     	        "|049Gertestatus 8/80",         DATA }  /* dummy */
	}
	HELP [field_device_status_8_help];

#ifdef _V510_
    STYLE "MULTILINE 12 3"; /* 3 Zeilen hoch */
#endif
}

/*****************************************************************************/
VARIABLE transmitter_variable_code
{
    CLASS      LOCAL;
	LABEL	   [transmitter_variable_code];
    HANDLING   READ & WRITE;
	TYPE INDEX transmitter_variables;
	HELP       [index_into_dynamic_variables_array_help];
/*
	APPHELP "This variable can represent measured or calculated type variables."
		" The numeric assigned to a Field Device variable can never be"
		" changed. If it is changed this would be a violation of the Forward"
		" Compatibility rules."
		" HART_VAR:XMTR VAR CODE";
*/
}

/*****************************************************************************/
VARIABLE unit_tag
{
	CLASS      DEVICE;
	LABEL      [unit_tag];
    HANDLING   READ & WRITE;
	TYPE       PACKED_ASCII (8);
	HELP       [unit_tag_help];
/*
	APPHELP "A Field Device may have sub applications that require being"
		" addressed individually. For this addressing the Tag variable"
		" associated with Command #11 should be used. This Tag is used to"
		" identify the application that controls the sub applications. This"
		" Text can be used by the user in any way. A recommended use is as"
		" a unique label to a plant that correlates to a Field Device label:"
		" a plant drawing, or on a Control System."
		" NOTE- HART does not recommend using this variable. If you have an"
		" application that controls the sub applications, all of these"
		" applications should be addressed using the HART Frame itself."
		" HART_VAR:UNIT TAG";
*/
}

/*****************************************************************************/
VARIABLE unit_descriptor
{
	CLASS      DEVICE;
	LABEL      [unit_descriptor];
    HANDLING   READ & WRITE;
	TYPE       PACKED_ASCII (16);
	HELP       [unit_descriptor_help];
/*
	APPHELP "A Field Device may have sub applications that require being"
		" addressed individually. This Descriptor"
		" is used to identify the application that controls the sub"
		" applications. This text can be used by the user in any way. There is"
		" no recommended use.
		" NOTE- HART does not recommend using this variable. If you have an"
		" application that controls the sub applications, all of these"
		" applications should be addressed using the HART Frame itself."
		" HART_VAR:UNIT DESCR";
*/
}

/*****************************************************************************/
VARIABLE unit_date
{
	CLASS      DEVICE;
	LABEL      [unit_date];
    HANDLING   READ & WRITE;
	TYPE       DATE;
	HELP       [unit_date_help];
/*
	APPHELP "A Field Device may have sub applications that require being"
		" addressed individually. This Date is used to"
		" identify the application that controls the sub applications."
		" This text can be used by the user in any way. There is"
		" no recommended use.
		" Format: Byte Closest to the Delimiter: Day, Next Byte: Month,
		" Byte Furthest from the Delimiter: Year-1900.
		" NOTE- HART does not recommend using this variable. If you have an"
		" application that controls the sub applications, all of these"
		" applications should be addressed using the HART Frame itself."
		" HART_VAR:UNIT DATE";
*/
}

/*****************************************************************************/
VARIABLE request_preambles
{
  CLASS     HART;
/*  LABEL     [number_of_request_preambles]; */
  LABEL     "Number of preambels" "|049Anzahl Prambeln";
  HANDLING  READ;
  TYPE      UNSIGNED_INTEGER
  {
	MIN_VALUE   2;
	MAX_VALUE  20;
  }
/*  HELP [number_of_request_preambles_help]; */
  HELP "Number of preambels required from the control station "
       "requested by the positioner."
       "|049Anzahl der bentigten Synchronisationsbytes.";
}

/*****************************************************************************/
VARIABLE response_preambles
{
	CLASS      HART;
	LABEL      [number_of_response_preambles];
	HANDLING   WRITE;
    TYPE  UNSIGNED_INTEGER (1)
    {
      DISPLAY_FORMAT "2d";
      EDIT_FORMAT    "2d";

/*	  MIN_VALUE   2; geht nicht, da kein Defaultwert def. werden kann */
      MAX_VALUE  20;
    }
	HELP	   [number_of_response_preambles_help];
}

/*****************************************************************************/
VARIABLE analog_output_code
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	LABEL	   [analog_output_number];
	HELP	   [analog_output_number_help];
	TYPE INDEX dynamic_variables;
}

/*****************************************************************************/
VARIABLE analog_output_code_1
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_one_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #0 ANALOG OUTPUT NUMBER CODE";
*/
}

/*****************************************************************************/
VARIABLE analog_output_code_2
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_two_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #1 ANALOG OUTPUT NUMBER CODE";
*/
}

/*****************************************************************************/
VARIABLE analog_output_code_3
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_two_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #2 ANALOG OUTPUT NUMBER CODE";
*/
}

/*****************************************************************************/
VARIABLE analog_output_code_4
{
    CLASS      LOCAL & ANALOG_OUTPUT;
	TYPE INDEX dynamic_variables;
    HANDLING   READ & WRITE;
	HELP       [index_four_into_analog_output_array_help];
/*
	APPHELP "This variable is used to access more variables that relate to"
		" that Analog Output index."
		" NOTE- Index = 0 is not valid"
		" HART_VAR:SLOT #3 ANALOG OUTPUT NUMBER CODE";
*/
}

/*****************************************************************************/
VARIABLE static_param_code
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_param_code1
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static1";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_param_code2
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static2";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_param_code3
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static3";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_param_code4
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_param;
  LABEL      "static4";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_enums_code
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_enums_code1
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum1";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_enums_code2
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum2";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_enums_code3
{
  CLASS      USER_INTERFACE;
  TYPE INDEX static_enums;
  LABEL      "enum3";
  HANDLING   READ & WRITE;
}

/*****************************************************************************/
VARIABLE static_enums_code4
{
  TYPE INDEX static_enums;
  LABEL      "enum4";
  HANDLING   READ & WRITE;
  CLASS      USER_INTERFACE;
}

/*****************************************************************************/
VARIABLE text_index
{
  TYPE INDEX user_text;
  LABEL      "texts";
  HANDLING   READ & WRITE;
  CLASS      USER_INTERFACE;
}

/*************************************************************************************/
VARIABLE primary_variable_code
{
	LABEL	[primary_variable_code];
	HELP	[primary_variable_code_help];
/*
	APPHELP "The Primary Variable has other related variables. The Primary"
		" Variable is represented in an approximate analog format on Analog"
		" Output #1, if such an Analog Output exists."
		" HART_VAR:PV XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 0 ;
	}

  HANDLING READ&WRITE;  /* lt. Spec. READ/Write  */
}

/*************************************************************************************/
VARIABLE secondary_variable_code
{
	LABEL	[secondary_variable_code];
	HELP	[secondary_variable_code_help];
/*
	APPHELP "The Secondary Variable has other related variables. The Secondary"
		" Variable is represented in an approximate analog format on Analog"
		" Output #2, if such an Analog Output exists."
		" HART_VAR:SV XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 1 ;
	}
  HANDLING READ&WRITE;  /* lt. Spec. READ/Write  */
}

/*************************************************************************************/
VARIABLE tertiary_variable_code
{
	LABEL	[tertiary_variable_code];
	HELP	[tertiary_variable_code_help];
/*
	APPHELP "The Tertiary Variable has other related variables. The Tertiary"
		" Variable is represented in an approximate analog format on Analog"
		" Output #3, if such an Analog Output exists."
		" HART_VAR:TV XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 2 ;
	}
  HANDLING READ&WRITE;  /* lt. Spec. READ/Write  */
}

/*************************************************************************************/
VARIABLE fourth_variable_code
{
	LABEL	[fourth_variable_code];
	HELP	[fourth_variable_code_help];
/*
	APPHELP "The Fourth Variable has other related variables. The Fourth"
		" Variable is represented in an approximate analog format on Analog"
		" Output #4, if such an Analog Output exists."
		" HART_VAR:4TH XMTR VAR CODE";
*/
	CLASS HART;
	TYPE INDEX transmitter_variables
	{
		DEFAULT_VALUE 3 ;
	}
  HANDLING READ&WRITE;  /* lt. Spec. READ/Write  */
}


/* ------------------------------------------------------------------------ */
/* Parameter mit EB-Code                                                    */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Gewuenschte Betriebsart     Doku-Nummer: 1/350  EB-Code: 0    */
/* ------------------------------------------------------------------------ */
VARIABLE gew_betriebsart
{
  CLASS DEVICE;
  LABEL "Target mode" "|049Gewnschte Betriebsart";
  HANDLING WRITE;
  TYPE ENUMERATED
  {
      { GEW_BA_AUTO,       "Automatic"          "|049Automatik"           },
      { GEW_BA_HAND,       "Manual"             "|049Hand"                },
      { GEW_BA_SICHERHEIT, "Fail safe position" "|049Sicherheitsstellung" }
  }

  HELP "Selection of the required operating mode."
	   "|049Auswahl der gewnschten Betriebsart. "
       "Umschaltung von Automatik auf Hand erfolgt druckstossfrei.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Handsollwert w               Doku-Nummer: 2     EB-Code: 1    */
/* ------------------------------------------------------------------------ */
VARIABLE w_hand
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Manual reference variable w" "|049Hand Fhrungsgre w";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE
        SELECT (geraet_ini)
        {
          CASE 0:  100.0; /* nicht initialisiert */
          CASE 1:  140.0; /* initialisiert */
          DEFAULT: 100.0;
        }
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn die aktuelle Betriebsart = HAND (es gibt 3 Arten) */
  VALIDITY
    IF ((akt_betriebsart == AKT_BA_HAND_IP)  ||
        (akt_betriebsart == AKT_BA_HAND_W )  ||
        (akt_betriebsart == AKT_BA_HAND_W_STEUERUNG ))
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Adjust the manual setpoint in the manual mode."
       "|049Einstellung des Hand-Sollwertes in der Betriebsart Hand.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Leserichtung                 Doku-Nummer: 3     EB-Code: 2    */
/* ------------------------------------------------------------------------ */
VARIABLE leserichtung
{
  CLASS DEVICE;
  LABEL "Reading direction" "|049Leserichtung";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Pneumatic connection right" "|049Pneumatik-Anschluss rechts" },
      { 1, "Pneumatic connection left"  "|049Pneumatik-Anschluss links"  }
  }

  HELP "The reading direction of the LC-display at the device is turned by 180."
       "|049Die Leserichtung der LC-Anzeige am Gert wird um 180 gedreht.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stiftposition                Doku-Nummer: 5/352  EB-Code: 4   */
/* ------------------------------------------------------------------------ */
VARIABLE stiftposition
{
  CLASS DEVICE;
  LABEL "Pin position" "|049Stiftposition";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { PIN_POS_OFF,     "Off"    "|049Aus"    },
      { PIN_POS_17_MM,   "17 mm"  "|04917 mm"  },
      { PIN_POS_25_MM,   "25 mm"  "|04925 mm"  },
      { PIN_POS_35_MM,   "35 mm"  "|04935 mm"  },
      { PIN_POS_50_MM,   "50 mm"  "|04950 mm"  },
      { PIN_POS_70_MM,   "70 mm"  "|04970 mm"  },
      { PIN_POS_100_MM,  "100 mm" "|049100 mm" },
      { PIN_POS_200_MM,  "200 mm" "|049200 mm" },
      { PIN_POS_90_GRAD, "90 "   "|04990 "   }
  }

  HELP "The adjusted pin position is displayed, or the pin position can be "
       "selected. It must match the actual position in the lever."
       "|049Der Abtaststift muss je nach Ventilhub/-winkel in die richtige "
       "Stiftposition eingesetzt werden. Fr die Initialisierung unter "
       "NOM oder SUB muss diese Stiftposition eingegeben werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Gew./Erm. Nennbereich        Doku-Nummer: 6/54  EB-Code: 5    */
/* ------------------------------------------------------------------------ */
VARIABLE nennbereich
{
  CLASS DEVICE;
  LABEL
    IF (geraet_ini == 1) /* wenn Regler initialisiert: andere Label */
    {
      "Determined nominal range" "|049Ermittelter Nennbereich";
    }
    ELSE
    {
      "Required nominal range" "|049Gewnschter Nennbereich";
    }

  HANDLING  READ&WRITE;
  TYPE FLOAT
  {
    DISPLAY_FORMAT "5.1f";
    EDIT_FORMAT    "5.1f";

    /* Min.- und Max.-Grenze von der Stiftposition abhngig */
    MIN_VALUE
      SELECT (stiftposition)
      {
        CASE PIN_POS_OFF    :  20.0;
        CASE PIN_POS_17_MM  :   3.6;
        CASE PIN_POS_25_MM  :   5.0;
        CASE PIN_POS_35_MM  :   7.0;
        CASE PIN_POS_50_MM  :  10.0;
        CASE PIN_POS_70_MM  :  14.0;
        CASE PIN_POS_100_MM :  20.0;
        CASE PIN_POS_200_MM :  40.0;
        CASE PIN_POS_90_GRAD:  24.0;
        DEFAULT:               20.0;
      }

    MAX_VALUE
      SELECT (stiftposition)
      {
        CASE PIN_POS_OFF    :  100.0;
        CASE PIN_POS_17_MM  :   17.7;
        CASE PIN_POS_25_MM  :   25.0;
        CASE PIN_POS_35_MM  :   35.4;
        CASE PIN_POS_50_MM  :   50.0;
        CASE PIN_POS_70_MM  :   70.7;
        CASE PIN_POS_100_MM :  100.0;
        CASE PIN_POS_200_MM :  200.0;
        CASE PIN_POS_90_GRAD:  110.0;
        DEFAULT:               100.0;
      }
  }

  /* wenn Stiftposition = 90 dann Einheit = , sonst mm */
  CONSTANT_UNIT
    IF (stiftposition == PIN_POS_90_GRAD)
    { ""; }
    ELSE
    { "mm"; }

  /* wenn Stiftposition = AUS dann nicht sichtbar */
  VALIDITY
    IF (stiftposition == PIN_POS_OFF)
    { FALSE; }
    ELSE
    { TRUE; }

  /* Hilfetexte fr den ermittelten UND den gewnschten Nennbereich ! */
  HELP "The nominal travel/angle must be entered prior to initialization "
       "(initialization mode NOM or SUB). "
       "The achieved travel/angle is displayed after successful initialization."
       "|049Fr die Initialisierung unter NOM oder SUB muss der "
       "Nennhub/-winkel des Ventiles eingegeben werden. "
       "Nach erfolgreicher Initialisierung wird hier der Hub/Winkel angezeigt, "
       "der bei der Initialisierung erreicht worden ist.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Initialisierungsart          Doku-Nummer: 7     EB-Code: 6    */
/* ------------------------------------------------------------------------ */
VARIABLE initialisierungsart
{
  CLASS DEVICE;
  LABEL "Initialization mode" "|049Initialisierungsart";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { INIT_ART_MAX, "Maximum range"     "|049Maximalbereich"  },
      { INIT_ART_NOM, "Nominal range"     "|049Nennbereich"     },
      { INIT_ART_MAN, "Manual adjustment" "|049Handeinstellung" },
      { INIT_ART_SUB, "Substitute"        "|049Ersetzung"       }
  }

  HELP "Selection of the initialization mode. "
       "Determines the function of the INIT-button at the device, too."
       "|049Auswahl der Initialisierungsart. "
       "Bestimmt auch die Funktion der INIT-Taste am Gert.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Bewegungsrichtung            Doku-Nummer: 8/347  EB-Code: 7   */
/* ------------------------------------------------------------------------ */
VARIABLE bewegungsrichtung
{
  CLASS DEVICE;
  LABEL "Moving direction" "|049Bewegungsrichtung";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { BEWEG_STEIGEND_STEIGEND, "Increasing/increasing >>"
                                 "|049Steigend/steigend >>" },
      { BEWEG_STEIGEND_FALLEND,  "Increasing/decreasing <>"
                                 "|049Steigend/fallend <>"  }
  }

  HELP "Operating direction of the reference variable w towards "
       "the travel/angle x."
       "|049Bewegungsrichtung der Fhrungsgre w zum Hub/Drehwinkel x.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehw.-bereich Anfang   Doku-Nummer: 9     EB-Code: 8    */
/* ------------------------------------------------------------------------ */
VARIABLE x_bereich_anfang
{
  CLASS DEVICE;
  LABEL "Travel/angle range start" "|049Hub-/Drehwinkelbereich Anfang";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      /* Max.-Grenze von der Stiftposition abhngig */
      MAX_VALUE
        SELECT (stiftposition)
        {
          CASE PIN_POS_OFF    :   80.0;
          CASE PIN_POS_17_MM  :   14.2;
          CASE PIN_POS_25_MM  :   20.0;
          CASE PIN_POS_35_MM  :   28.3;
          CASE PIN_POS_50_MM  :   40.0;
          CASE PIN_POS_70_MM  :   56.6;
          CASE PIN_POS_100_MM :   80.0;
          CASE PIN_POS_200_MM :  160.0;
          CASE PIN_POS_90_GRAD:   88.0;
          DEFAULT:                80.0;
        }
  }
  /* Einheit von Stiftposition abhngig */
  CONSTANT_UNIT
      SELECT (stiftposition)
      {
        CASE PIN_POS_OFF    :    "%";
        CASE PIN_POS_17_MM  :   "mm";
        CASE PIN_POS_25_MM  :   "mm";
        CASE PIN_POS_35_MM  :   "mm";
        CASE PIN_POS_50_MM  :   "mm";
        CASE PIN_POS_70_MM  :   "mm";
        CASE PIN_POS_100_MM :   "mm";
        CASE PIN_POS_200_MM :   "mm";
        CASE PIN_POS_90_GRAD:    "";
        DEFAULT:                 "%";
      }

  HELP "Lower range value for the travel/angle in the nominal or working range."
       "|049Anfangswert fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbereich Ende  Doku-Nummer: 10    EB-Code: 9    */
/* ------------------------------------------------------------------------ */
VARIABLE x_bereich_ende
{
  CLASS DEVICE;
  LABEL "Travel/angle range end" "|049Hub-/Drehwinkelbereich Ende";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      /* Min.- und Max.-Grenzen von der Stiftposition abhngig */
      MIN_VALUE
        SELECT (stiftposition)
        {
          CASE PIN_POS_OFF    :   20.0;
          CASE PIN_POS_17_MM  :    0.7;
          CASE PIN_POS_25_MM  :    1.0;
          CASE PIN_POS_35_MM  :    1.4;
          CASE PIN_POS_50_MM  :    2.0;
          CASE PIN_POS_70_MM  :    2.8;
          CASE PIN_POS_100_MM :    4.0;
          CASE PIN_POS_200_MM :    8.0;
          CASE PIN_POS_90_GRAD:    4.8;
          DEFAULT:                20.0;
        }

      MAX_VALUE
        SELECT (stiftposition)
        {
          CASE PIN_POS_OFF    :  100.0;
          CASE PIN_POS_17_MM  :   17.7;
          CASE PIN_POS_25_MM  :   25.0;
          CASE PIN_POS_35_MM  :   35.4;
          CASE PIN_POS_50_MM  :   50.0;
          CASE PIN_POS_70_MM  :   70.7;
          CASE PIN_POS_100_MM :  100.0;
          CASE PIN_POS_200_MM :  200.0;
          CASE PIN_POS_90_GRAD:  110.0;
          DEFAULT:               100.0;
        }
  }
  /* Einheit von Stiftposition abhngig */
  CONSTANT_UNIT
      SELECT (stiftposition)
      {
        CASE PIN_POS_OFF    :    "%";
        CASE PIN_POS_17_MM  :   "mm";
        CASE PIN_POS_25_MM  :   "mm";
        CASE PIN_POS_35_MM  :   "mm";
        CASE PIN_POS_50_MM  :   "mm";
        CASE PIN_POS_70_MM  :   "mm";
        CASE PIN_POS_100_MM :   "mm";
        CASE PIN_POS_200_MM :   "mm";
        CASE PIN_POS_90_GRAD:    "";
        DEFAULT:                 "%";
      }

  HELP "Upper range value for the travel/angle in the nominal or working range."
       "|049Endwert fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Hub-/Drehwinkelbegrenzung unten                   */
/*                                         Doku-Nummer: 11    EB-Code: 10   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_x_begrenzung_unten
{
  CLASS DEVICE;
  LABEL "Enable travel/angle lower limit"
        "|049Aktivierung Hub-/Drehwinkelbegrenzung unten";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "On"  "|049Ein" }
  }

  HELP "Enables the limitation of the travel/angle downwards to the entered value."
       "|049Aktivierung der Begrenzung des Hubes/Drehwinkels nach unten.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbegrenzung unten Doku-Nummer: 12   EB-Code: 10 */
/* ------------------------------------------------------------------------ */
VARIABLE x_begrenzung_unten
{
  CLASS DEVICE;
  LABEL "Travel/angle lower limit" "|049Hub-/Drehwinkelbegrenzung unten";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.0;
      MAX_VALUE 49.9;
  }
  CONSTANT_UNIT "%";

  HELP "Limitation of the travel/angle downwards to the entered value."
       "|049Begrenzung des Hubes/Drehwinkels nach unten auf den "
       "eingegebenen Wert, die Kennlinie wird nicht angepasst.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Hub-/Drehwinkelbegrenzung oben
                                           Doku-Nummer: 13    EB-Code: 11   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_x_begrenzung_oben
{
  CLASS DEVICE;
  LABEL "Enable travel/angle upper limit"
        "|049Aktivierung Hub-/Drehwinkelbegrenzung oben";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "On"  "|049Ein" }
  }

  HELP "Enables the limitation of the travel/angle upwards to the entered value."
       "|049Aktivierung der Begrenzung des Hubes/Drehwinkels nach oben.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbegrenzung oben   Doku-Nummer: 14  EB-Code: 11 */
/* ------------------------------------------------------------------------ */
VARIABLE x_begrenzung_oben
{
  CLASS DEVICE;
  LABEL "Travel/angle upper limit" "|049Hub-/Drehwinkelbegrenzung oben";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE  50.0;
      MAX_VALUE 120.9;
  }
  CONSTANT_UNIT "%";

  HELP "Limitation of the travel/angle upwards to the entered value."
       "|049Begrenzung des Hubes/Drehwinkels nach oben auf den "
       "eingegebenen Wert, die Kennlinie wird nicht angepasst.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fuehrungsgr.-bereich Anfang   Doku-Nummer: 15   EB-Code: 12   */
/* ------------------------------------------------------------------------ */
VARIABLE w_bereich_anfang
{
  CLASS DEVICE;
  LABEL "Reference variable range start" "|049Fhrungsgrenbereich Anfang";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.0;
      MAX_VALUE 75.0;
  }
  CONSTANT_UNIT "%";

  HELP "Lower range value of the valid reference variable range."
       "|049Anfangswert des gltigen Fhrungsgrenbereiches.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fuehrungsgroessenber. Ende   Doku-Nummer: 16    EB-Code: 13   */
/* ------------------------------------------------------------------------ */
VARIABLE w_bereich_ende
{
  CLASS DEVICE;
  LABEL "Reference variable range end" "|049Fhrungsgrenbereich Ende";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE  25.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP "Upper range value of the valid reference variable range."
       "|049Endwert des gltigen Fhrungsgrenbereiches.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Endlage bei w <  Doku-Nummer: 17    EB-Code: 14   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_endlage_w_kleiner
{
  CLASS DEVICE;
  LABEL "Enable setpoint cutoff decrease"
        "|049Aktivierung Endlage bei w kleiner";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "On"  "|049Ein" }
  }

  HELP "Enables the setpoint cutoff decrease function."
       "|049Aktivierung der Endlagenfunktion bei w kleiner.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Endlage bei w <              Doku-Nummer: 18    EB-Code: 14   */
/* ------------------------------------------------------------------------ */
VARIABLE endlage_w_kleiner
{
  CLASS DEVICE;
  LABEL "Setpoint cutoff decrease" "|049Endlage bei w kleiner";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.0;
      MAX_VALUE 49.9;
  }
  CONSTANT_UNIT "%";

  HELP
    SELECT (bewegungsrichtung)
    {
      CASE BEWEG_STEIGEND_STEIGEND: /* steigend/steigend */
        "If w falls below the entered value, the valve is fully closed."
        "|049Unterschreitet w diesen Wert, wird der Antrieb voll geschlossen.";
      CASE BEWEG_STEIGEND_FALLEND:  /* steigend/fallend  */
        "If w exceeds the value of (100-entered value), the valve is fully closed."
        "|049berschreitet w den Wert von (100-Wert), wird der Antrieb voll geschlossen.";
    }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Endlage bei w >  Doku-Nummer: 19    EB-Code: 15   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_endlage_w_groesser
{
  CLASS DEVICE;
  LABEL "Enable setpoint cutoff increase"
        "|049Aktivierung Endlage bei w grer";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "On"  "|049Ein" }
  }

  HELP "Enables the setpoint cutoff increase function."
       "|049Aktivierung der Endlagenfunktion bei w grer.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Endlage bei w >              Doku-Nummer: 20    EB-Code: 15   */
/* ------------------------------------------------------------------------ */
VARIABLE endlage_w_groesser
{
  CLASS DEVICE;
  LABEL "Setpoint cutoff increase" "|049Endlage bei w grer";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE  50.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP
    SELECT (bewegungsrichtung)
    {
      CASE BEWEG_STEIGEND_STEIGEND: /* steigend/steigend */
        "If w exceeds the entered value, the valve is fully opened."
        "|049berschreitet w diesen Wert, wird der Antrieb voll geffnet.";
      CASE BEWEG_STEIGEND_FALLEND:  /* steigend/fallend  */
        "If w falls below the value of (100-entered value), the valve is fully opened."
        "|049Unterschreitet w den Wert von (100-Wert), wird der Antrieb voll geffnet.";
    }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Druckgrenze                  Doku-Nummer: 21    EB-Code: 16   */
/* ------------------------------------------------------------------------ */
VARIABLE druckgrenze
{
  CLASS DEVICE;
  LABEL "Pressure limit" "|049Druckgrenze";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 3, "Off"     "|049Aus"     },
      { 2, "3.7 bar" "|0493.7 bar" },
      { 1, "2.4 bar" "|0492.4 bar" },
      { 0, "1.4 bar" "|0491.4 bar" }
  }

  HELP "The pressure limit determined during initialization is "
       "displayed and can be modified."
       "|049Die whrend der Initialisierung ermittelte Druckbegrenzung "
       "wird angezeigt und kann gendert werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Prop.-faktor KP (Stufe)      Doku-Nummer: 22    EB-Code: 17   */
/* ------------------------------------------------------------------------ */
VARIABLE kp_stufe
{
  CLASS DEVICE;
  LABEL "Proportional action coeff. KP (step)"
        "|049Proportionalittsfaktor KP (Stufe)";
  HANDLING READ;
  TYPE UNSIGNED_INTEGER (1)
  {
    DISPLAY_FORMAT  "2d";
    EDIT_FORMAT     "2d";

    MIN_VALUE  0;
    MAX_VALUE 17;
  }

  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for unpermissibly high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization."
       "|049Bei der Initialisierung des Stellungsreglers werden die Werte fr "
       "KP und TV optimal eingestellt. Sollte der Regler aufgrund zustzlicher "
       "Strungen zu unzulssig hohen Nachschwingungen neigen, knnen "
       "KP und TV vor Ort angepasst werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Vorhaltezeit TV (Stufe)      Doku-Nummer: 23    EB-Code: 18   */
/* ------------------------------------------------------------------------ */
VARIABLE tv_stufe
{
  CLASS DEVICE;
  LABEL "Derivative action time TV (step)" "|049Vorhaltezeit TV (Stufe)";
  HANDLING READ;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "1"   "|0491"   },
      { 2, "2"   "|0492"   },
      { 3, "3"   "|0493"   },
      { 4, "4"   "|0494"   }
  }

  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for unpermissibly high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization."
       "|049Bei der Initialisierung des Stellungsreglers werden die Werte fr "
       "KP und TV optimal eingestellt. Sollte der Regler aufgrund zustzlicher "
       "Strungen zu unzulssig hohen Nachschwingungen neigen, knnen "
       "KP und TV vor Ort angepasst werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Toleranzband                 Doku-Nummer: 24    EB-Code: 19   */
/* ------------------------------------------------------------------------ */
VARIABLE toleranzband
{
  CLASS DEVICE;
  LABEL "Tolerance band" "|049Toleranzband";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.1;
      MAX_VALUE 10.0;
  }
  CONSTANT_UNIT "%";

  HELP "Used for error monitoring. Determination of the tolerance band in "
       "relation to the operating range."
       "|049Toleranzband bezogen auf den Arbeitsbereich. "
       "Zugehrige Nachlaufzeit ist Rcksetzkriterium. "
       "Wird whrend der Initialisierung eine Laufzeit festgestellt, "
       "deren 6 faches > 30s ist, wird die sechsfache Laufzeit als "
       "Nachlaufzeit bernommen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinienauswahl            Doku-Nummer: 25/351  EB-Code: 20 */
/* ------------------------------------------------------------------------ */
VARIABLE kennlinienauswahl
{
  CLASS DEVICE;
  LABEL "Characteristic" "|049Kennlinienauswahl";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      {  0, "Linear"                                "|049Linear"                             },
      {  1, "Equal percentage"                      "|049Gleichprozentig"                    },
      {  2, "Equal percentage reverse"              "|049Gleichprozentig invers"             },
      { 10, "SAMSON butterfly linear"               "|049SAMSON Stellklappe linear"          },
      { 11, "SAMSON butterfly equal percentage"     "|049SAMSON Stellklappe gleichprozentig" },
      { 12, "VETEC rotary linear"                   "|049VETEC Drehkegel linear"             },
      { 13, "VETEC rotary equal percentage"         "|049VETEC Drehkegel gleichprozentig"    },
      { 14, "Segmented ball valve linear"           "|049Kugelsegment linear"                },
      { 15, "Segmented ball valve equal percentage" "|049Kugelsegment gleichprozentig"       },
      {  3, "User defined"                          "|049Benutzerdefiniert"                  }
  }

  HELP "Selection of the used characteristic."
       "|049Auswahl der verwendeten Kennlinie.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Gewuenschte Laufzeit auf     Doku-Nummer: 26    EB-Code: 21   */
/* ------------------------------------------------------------------------ */
VARIABLE gew_laufzeit_auf
{
  CLASS DEVICE;
  LABEL "Required transit time open" "|049Gewnschte Laufzeit auf";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";

      MIN_VALUE   0.0;
      MAX_VALUE 240.0;
  }
  CONSTANT_UNIT "s";

  HELP "The time required to pass through the operating range when the valve opens."
       "|049Zeit um den Arbeitsbereich beim ffnen des Stellventiles zu durchfahren.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Gewuenschte Laufzeit zu      Doku-Nummer: 27    EB-Code: 22   */
/* ------------------------------------------------------------------------ */
VARIABLE gew_laufzeit_zu
{
  CLASS DEVICE;
  LABEL "Required transit time close" "|049Gewnschte Laufzeit zu";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";

      MIN_VALUE   0.0;
      MAX_VALUE 240.0;
  }
  CONSTANT_UNIT "s";

  HELP "The time required to pass through the operating range when "
       "the valve closes."
       "|049Zeit um den Arbeitsbereich beim Schlieen des Stellventiles "
       "zu durchfahren.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Absolutes Wegintegral        Doku-Nummer: 28    EB-Code: 23   */
/* ------------------------------------------------------------------------ */
VARIABLE wegintegral
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Total valve travel" "|049Wegintegral";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "9.0f";
  }

  HELP "Totalized double valve travel."
       "|049Aufsummierter Ventildoppelhub.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Grenzwert Wegintegral        Doku-Nummer: 29    EB-Code: 24   */
/* ------------------------------------------------------------------------ */
VARIABLE gw_wegintegral
{
  CLASS DEVICE;
  LABEL "Limit value total valve travel" "|049Grenzwert Wegintegral";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "9.0f";
      EDIT_FORMAT    "9.0f";

      MIN_VALUE      1000.0;
      MAX_VALUE 990000000.0;
  }

  HELP "Limit value of total valve travel. If the limit value is exceeded, "
       "the fault symbol and the wrench symbol on the display appear."
       "|049Grenzwert Wegintegral, nach dessen berschreiten erscheint die "
       "Strmeldung und das Maulschlsselsymbol auf der LC-Anzeige am Gert.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Alarmmodus                   Doku-Nummer: 30    EB-Code: 25   */
/* ------------------------------------------------------------------------ */
VARIABLE alarmmodus
{
  CLASS DEVICE;
  LABEL "Alarm mode" "|049Alarmmodus";
  HANDLING READ&WRITE;
  /* combobox-Inhalt von eingebautem ind. Grenzkontakt abhngig */
  TYPE ENUMERATED
  {
    IF (ind_grenzkontakt == IMPLEMENTED)
    {
        { 0, "A2 non conducting/low"
             "|049A2 sperrend/low"         },
        { 2, "A2 conducting/high"
             "|049A2 leitend/high"         }
    }
    ELSE
    {
        { 0, "A1 conducting/high - A2 non conducting/low"
             "|049A1 leitend/high - A2 sperrend/low"         },
        { 1, "A1 non conducting/low - A2 non conducting/low"
             "|049A1 sperrend/low - A2 sperrend/low"         },
        { 2, "A1 conducting/high - A2 conducting/high"
             "|049A1 leitend/high - A2 leitend/high"         },
        { 3, "A1 non conducting/low - A2 conducting/high"
             "|049A1 sperrend/low - A2 leitend/high"         }
    }
  }

  HELP
    IF (ind_grenzkontakt == IMPLEMENTED)
    {
         "Switching mode of limit switch A2."
         "|049Schaltmodus des Grenzkontaktes A2 im angesprochenen "
         "Zustand und bei Grundgert ohne elektrische Hilfsenergie.";
    }
    ELSE
    {
         "Switching mode of limit switches A1 and A2."
         "|049Schaltmodus der Grenzkontakte A1 und A2 im angesprochenen "
         "Zustand und bei Grundgert ohne elektrische Hilfsenergie.";
    }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Grenzwert A1     Doku-Nummer: 31    EB-Code: 26   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_gw_a1
{
  CLASS DEVICE;
  LABEL "Enable limit value A1" "|049Aktivierung Grenzwert A1";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "On"  "|049Ein" }
  }

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Enables the limit switch A1."
       "|049Aktivierung des Grenzwertes A1.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Grenzwert A1                 Doku-Nummer: 32    EB-Code: 26   */
/* ------------------------------------------------------------------------ */
VARIABLE grenzwert_a1
{
  CLASS DEVICE;
  LABEL "Limit value A1" "|049Grenzwert A1";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Limit value for A1 in relation to the working range."
       "|049Grenzwert A1, bezogen auf den Arbeitsbereich.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Grenzwert A2     Doku-Nummer: 33    EB-Code: 27   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_gw_a2
{
  CLASS DEVICE;
  LABEL "Enable limit value A2" "|049Aktivierung Grenzwert A2";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|049Aus" },
      { 1, "On"  "|049Ein" }
  }

  HELP "Enables the limit switch A2."
       "|049Aktivierung des Grenzwertes A2.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Grenzwert A2                 Doku-Nummer: 34    EB-Code: 27   */
/* ------------------------------------------------------------------------ */
VARIABLE grenzwert_a2
{
  CLASS DEVICE;
  LABEL "Limit value A2" "|049Grenzwert A2";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP "Limit value for A2 in relation to the working range."
       "|049Grenzwert A2, bezogen auf den Arbeitsbereich.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Wirkrichtung Stellungsmelder Doku-Nummer: 36    EB-Code: 29   */
/* ------------------------------------------------------------------------ */
VARIABLE wirkr_stellmelder
{
  CLASS DEVICE;
  LABEL "Operation direction position transmitter"
        "|049Wirkrichtung Stellungsmelder";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { WIRK_STELL_STEIGEND_STEIGEND, "Increasing/increasing >>"
                                      "|049Steigend/steigend >>" },
      { WIRK_STELL_STEIGEND_FALLEND,  "Increasing/decreasing <>"
                                      "|049Steigend/fallend <>"  }
  }

  /* nur sichtbar wenn Stellungsmelder eingebaut */
  VALIDITY
    IF (stellungsmelder == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Operating direction of the position transmitter. "
       "Indicates how the travel/angle position is assigned to the "
       "output signal i, based on the closed position."
       "|049Wirkrichtung des Stellungsmelders. Gibt ausgehend von der "
       "Schliestellung die Zuordnung der Hub-/Winkelstellung zum "
       "Ausgangssignal i an.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoermeldung mit Stellungsmelder  Doku-Nummer: 37 EB-Code: 30 */
/* ------------------------------------------------------------------------ */
VARIABLE stoerm_mit_stellmelder
{
  CLASS DEVICE;
  LABEL "Fault alarm position transmitter"
        "|049Strmeldung mit Stellungsmelder";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "No"                 "|049Nein"               },
      { 1, "High (ix > 20.5mA)" "|049High (ix > 20.5mA)" },
      { 2, "Low  (ix <  3.8mA)" "|049Low  (ix <  3.8mA)" }
  }

  /* nur sichtbar wenn Stellungsmelder eingebaut */
  VALIDITY
    IF (stellungsmelder == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Used to select whether faults causing the fault alarm contact to "
       "switch should also be signaled by the position transmitter output "
       "and how they should be signaled."
       "|049Auswahl, ob und wie Strungen, die zum Schalten des "
       "Strmeldekontaktes fhren, auch durch den Stellungsmelderausgang "
       "signalisiert werden sollen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stellungsmelder Test         Doku-Nummer: 38    EB-Code: 31   */
/* ------------------------------------------------------------------------ */
VARIABLE test_stellmelder
{
  CLASS DEVICE;
  LABEL "Position transmitter test" "|049Stellungsmelder Test";
  HANDLING WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn Stellungsmelder eingebaut */
  VALIDITY
    IF (stellungsmelder == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Testing the position transmitter. Values can be entered in relation "
       "to the operating range."
       "|049Test des Stellungsmelders. Werte knnen, bezogen auf den "
       "Arbeitsbereich, eingegeben werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoermeldung Sonderfunktionen  Doku-Nummer: 39    EB-Code: 32 */
/* ------------------------------------------------------------------------ */
VARIABLE stoerm_sonderfunktion
{
  CLASS DEVICE;
  LABEL "Fault alarm special functions" "|049Strmeldung Sonderfunktionen";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "No"  "|049Nein" },
      { 1, "Yes" "|049Ja"   }
  }

  HELP "Fault alarm via LC-display and fault alarm contact for special functions, "
       "e.g. zero point adjustment, initialization and test functions."
       "|049Strmeldung ber LC-Anzeige am Gert und Strmeldekontakt bei "
       "Sonderfunktionen wie Nullpunktabgleich, Initialisierung und Testfunktionen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoermeldung Wegintegral     Doku-Nummer: 40    EB-Code: 33   */
/* ------------------------------------------------------------------------ */
VARIABLE stoerm_wegintegral
{
  CLASS DEVICE;
  LABEL "Fault alarm total valve travel" "|049Strmeldung Wegintegral";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "No"  "|049Nein" },
      { 1, "Yes" "|049Ja"   }
  }

  HELP "Fault alarm via LC-display and fault alarm contact when the "
       "limit value for the total valve travel is exceeded."
       "|049Strmeldung ber LC-Anzeige am Gert und Strmeldekontakt "
       "bei berschreiten des Grenzwertes fr das Wegintegral.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Schliessrichtung             Doku-Nummer: 41    EB-Code: 34   */
/* ------------------------------------------------------------------------ */
VARIABLE schliessrichtung
{
  CLASS DEVICE;
  LABEL "Closing direction" "|049Schlierichtung";
  HANDLING
    /* wenn Regler NICHT initialisiert UND Initialisierungsart = Ersatzabgleich */
    IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))
    { READ&WRITE; }
    ELSE
    { READ; }

  TYPE ENUMERATED
  {
      { 0, "Clockwise"        "|049Im Uhrzeigersinn"    },
      { 1, "Counterclockwise" "|049Gegen Uhrzeigersinn" }
  }

  HELP "Turning direction in which the valve is moved to the closed position "
       "(view onto the rotary switch motion when the positioner cover is open). "
       "Can only be entered in initialization mode SUB."
       "|049Drehrichtung durch die die Zu-Stellung des Stellventiles erreicht wird "
       "(Blick auf Knebelknopfbewegung bei geffnetem Deckel des Stellungsreglers). "
       "Eingabe nur bei Initialisierungsart SUB mglich.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Blockierstellung             Doku-Nummer: 42    EB-Code: 35   */
/* ------------------------------------------------------------------------ */
VARIABLE blockierstellung
{
  CLASS DEVICE;
  LABEL "Blocking position" "|049Blockierstellung";
  HANDLING
    /* wenn Regler NICHT initialisiert UND Initialisierungsart = Ersatzabgleich */
    IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))
    { READ&WRITE; }
    ELSE
    { READ; }

  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      /* Max.-Grenze von der Stiftposition abhngig */
      MAX_VALUE
        SELECT (stiftposition)
        {
          CASE PIN_POS_OFF    :  100.0;
          CASE PIN_POS_17_MM  :   17.7;
          CASE PIN_POS_25_MM  :   25.0;
          CASE PIN_POS_35_MM  :   35.4;
          CASE PIN_POS_50_MM  :   50.0;
          CASE PIN_POS_70_MM  :   70.7;
          CASE PIN_POS_100_MM :  100.0;
          CASE PIN_POS_200_MM :  200.0;
          CASE PIN_POS_90_GRAD:  110.0;
          DEFAULT:               100.0;
        }
  }
  /* Einheit von Stiftposition abhngig */
  CONSTANT_UNIT
      SELECT (stiftposition)
      {
        CASE PIN_POS_OFF    :    "%";
        CASE PIN_POS_17_MM  :   "mm";
        CASE PIN_POS_25_MM  :   "mm";
        CASE PIN_POS_35_MM  :   "mm";
        CASE PIN_POS_50_MM  :   "mm";
        CASE PIN_POS_70_MM  :   "mm";
        CASE PIN_POS_100_MM :   "mm";
        CASE PIN_POS_200_MM :   "mm";
        CASE PIN_POS_90_GRAD:    "";
        DEFAULT:                 "%";
      }

  HELP "Distance up to the closed position. Can only be entered in "
       "initialization mode SUB."
       "|049Abstand bis zur Zu-Stellung. Nur bei Init.-modus SUB.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kaltstart                    Doku-Nummer: 43/201 EB-Code: 36  */
/* ------------------------------------------------------------------------ */
VARIABLE kaltstart
{
  CLASS DEVICE;
  LABEL "Start with default values" "|049Start mit Standardwerten";
  HANDLING WRITE;
  TYPE ENUMERATED
  {
      { 0, "No"  "|049Nein" },
      { 1, "Yes" "|049Ja"   }
  }

  HELP "Resets all parameters to default (factory setting). "
       "Note: After reset the device must be re-initialized."
       "|049Setzt alle Parameter auf Standardwerte (Werkseinstellung) zurck. "
       "Hinweis: Nach dem Setzen muss das Gert neu initialisiert werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stellungsmelder              Doku-Nummer: 44    EB-Code: 37   */
/* ------------------------------------------------------------------------ */
VARIABLE stellungsmelder
{
  CLASS DEVICE;
  LABEL "Position transmitter" "|049Stellungsmelder";
  HANDLING READ;
  TYPE ENUMERATED
  {
      { NOT_IMPLEMENTED, "Not implemented" "|049Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|049Eingebaut"       }
  }

  HELP "Indicates whether the option position transmitter is installed "
       "(no automatic identification)."
       "|049Anzeige ob die Option Stellungsmelder eingebaut ist. "
       "Wird nicht automatisch erkannt.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Induktiver Grenzkontakt      Doku-Nummer: 45    EB-Code: 38   */
/* ------------------------------------------------------------------------ */
VARIABLE ind_grenzkontakt
{
  CLASS DEVICE;
  LABEL "Inductive limit switch" "|049Induktiver Grenzkontakt";
  HANDLING READ;
  TYPE ENUMERATED
  {
      { NOT_IMPLEMENTED, "Not implemented" "|049Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|049Eingebaut"       }
  }

  HELP "Indicates whether the option inductive limit switch is installed "
       "(no automatic identification)."
       "|049Anzeige ob die Option induktiver Grenzkontakt eingebaut ist. "
       "Wird nicht automatisch erkannt.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Regeldifferenz e             Doku-Nummer: 46    EB-Code: 39   */
/* ------------------------------------------------------------------------ */
VARIABLE regeldifferenz
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Setpoint deviation e" "|049Regeldifferenz e";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn Geraet initialisiert */
  VALIDITY
    IF (geraet_ini == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Deviation from the reference position."
       "|049Abweichung von der Sollposition.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Minimale Laufzeit auf        Doku-Nummer: 47    EB-Code: 40   */
/* ------------------------------------------------------------------------ */
VARIABLE min_laufzeit_auf
{
  CLASS DEVICE;
  LABEL "Minimum transit time open" "|049Minimale Laufzeit auf";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "s";

  HELP "The minimum opening time is determined during initialization."
       "|049Minimale ffnungszeit, wird whrend der Initialisierung ermittelt.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Minimale Laufzeit zu         Doku-Nummer: 48    EB-Code: 41   */
/* ------------------------------------------------------------------------ */
VARIABLE min_laufzeit_zu
{
  CLASS DEVICE;
  LABEL "Minimum transit time close" "|049Minimale Laufzeit zu";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "s";

  HELP "The minimum closing time is determined during initialization."
       "|049Minimale Schliezeit, wird whrend der Initialisierung ermittelt.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fuehrungsgroesse w [%]       Doku-Nummer: 49    EB-Code: 42   */
/* ------------------------------------------------------------------------ */
VARIABLE w_prozent
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Reference variable w" "|049Fhrungsgre w";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  HELP "Indicates the supplied automatic reference variable "
       "corresponding 4 to 20 mA."
       "|049Anzeige der anliegenden Automatik - Fhrungsgre "
       "entsprechend 4 bis 20 mA.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Antriebsdruck y              Doku-Nummer: 51    EB-Code: 44   */
/* ------------------------------------------------------------------------ */
VARIABLE antriebsdruck
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Manipulated variable y" "|049Stellgre y";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn Geraet initialisiert */
  VALIDITY
    IF (geraet_ini == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Shows the actuator pressure after initialization."
       "|049Gibt nach der Initialisierung den Antriebsdruck an.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Magnetventil                 Doku-Nummer: 52    EB-Code: 45   */
/* ------------------------------------------------------------------------ */
VARIABLE magnetventil
{
  CLASS DEVICE;
  LABEL "Solenoid valve" "|049Magnetventil";
  HANDLING READ;
  TYPE ENUMERATED
  {
      { NOT_IMPLEMENTED, "Not implemented" "|049Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|049Eingebaut"       }
  }

  HELP "Indicates whether a solenoid valve is installed."
       "|049Anzeige ob die Option Magnetventil eingebaut ist.";
}

/* ------------------------------------------------------------------------ */
/* Parameter ohne EB-Code                                                   */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: TAG                          Doku-Nummer: 102/312 EB-Code: -- */
/* ------------------------------------------------------------------------ */
VARIABLE tag
{
  CLASS     DEVICE;
  LABEL     "TAG" "|049TAG";
  TYPE      PACKED_ASCII (8);
  HANDLING  READ & WRITE;
  HELP      "Tag identification number of the operation unit."
            "|049Messstellen - Kennzeichen der Betriebseinheit.";
}


/* ------------------------------------------------------------------------ */
/* Parameter: Serien-Nr.                   Doku-Nummer: 106     EB-Code: -- */
/* ------------------------------------------------------------------------ */
VARIABLE device_id
{
  CLASS     DEVICE;
  LABEL     "Serial number positioner" "|049Serien-Nummer Regler";
  TYPE      UNSIGNED_INTEGER (3);
  HANDLING  READ;
  HELP      "Serial number of the positioner."
            "|049Serien-Nummer des Stellungsreglers.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Beschreibung                 Doku-Nummer: 313   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE descriptor
{
  CLASS     DEVICE;
  LABEL     "Description" "|049Beschreibung";
  TYPE      PACKED_ASCII (16);
  HANDLING  READ & WRITE;
  HELP      "Free available space for entering text."
            "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Datum                        Doku-Nummer: 321   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE date
{
  CLASS     DEVICE;
  LABEL     "Date" "|049Datum";
  TYPE      DATE;
  HANDLING  READ & WRITE;
  HELP      "Gregorian calendar date that is stored in the Field Device. "
            "This date can be used by the user in any way. "
            "|049Ein Datum im Format des gregorianischen Kalenders kann im "
            "Feldgert gespeichert werden. Die Verwendung ist frei.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nachricht                    Doku-Nummer: 314   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE message
{
  CLASS     DEVICE;
  LABEL     "Message" "|049Nachricht";
  TYPE      PACKED_ASCII (32);
  HANDLING  READ & WRITE;
  HELP      "Free available space for entering text."
            "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Final assembly number        Doku-Nummer: 322   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE final_assembly_number
{
  CLASS     DEVICE;
  LABEL     "Final assembly number" "|049Werknummer";
  TYPE      UNSIGNED_INTEGER (3)
  {
    MIN_VALUE        0;
	MAX_VALUE 16777215;
	EDIT_FORMAT  "8u" ;
  }
  HANDLING  READ & WRITE;
  HELP      "Free available space for entering text."
            "|049Nummer die eindeutig das komplette Feldgert identifiziert.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Busadresse                   Doku-Nummer: 300   EB-Code: 46   */
/* ------------------------------------------------------------------------ */
VARIABLE polling_address
{
  CLASS DEVICE;
  LABEL "Bus address" "|049Busadresse";
  TYPE  UNSIGNED_INTEGER (1)
  {
      DISPLAY_FORMAT "2d";
      EDIT_FORMAT    "2d";

      MIN_VALUE  0;
      MAX_VALUE 15;  /* HART Rev. 5 */
/*    MAX_VALUE 63;     HART Rev. 6 */
  }

  /* hier nur schreibbar:
  HANDLING  READ & WRITE;*/
  HANDLING  WRITE;

/* Hilfetexte wenn Parameter in Parameterliste erscheint und nicht im Men: */

/* kmr: fuer HART Rev. 6:
  HELP "Address used to identify a field device. "
       "Changeable by the user under menu "
       "entry 'Device - Set Address...': "
       "0 for point-to-point, 1 to 63 for multidrop "
       "communication."
       "|049Adresse zur eindeutigen Identifizierung "
       "des Feldgertes, vom Anwender nderbar unter dem "
       "Menpunkt 'Gert - Adresse vergeben...': "
       "0 fr Punkt-zu-Punkt, 1 bis 63 fr Multidrop.";
*/
/* fuer HART Rev. <=5: */
/*
  HELP "Address used to identify a field device. "
       "Changeable by the user under menu "
       "entry 'Device - Set Address...': "
       "0 for point-to-point, 1 to 15 for multidrop "
       "communication."
       "|049Adresse zur eindeutigen Identifizierung "
       "des Feldgertes, vom Anwender nderbar unter dem "
       "Menpunkt 'Gert - Adresse vergeben...': "
       "0 fr Punkt-zu-Punkt, 1 bis 15 fr Multidrop.";
*/

/* Hilfetexte wenn Parameter im Men erscheint und nicht in Parameterliste: */

/* kmr: fuer HART Rev. 6:
  HELP "Address used to identify a field device: "
       "0 for point-to-point, 1 to 63 for multidrop "
       "communication."
       "|049Adresse zur eindeutigen Identifizierung "
       "des Feldgertes: "
       "0 fr Punkt-zu-Punkt, 1 bis 63 fr Multidrop.";
*/
/* fuer HART Rev. <=5: */
  HELP "Address used to identify a field device: "
       "0 for point-to-point, 1 to 15 for multidrop "
       "communication."
       "|049Adresse zur eindeutigen Identifizierung "
       "des Feldgertes: "
       "0 fr Punkt-zu-Punkt, 1 bis 15 fr Multidrop.";
}
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: ---                          Doku-Nummer: ---     EB-Code: -- */
/*   (hnlich: Parameter: geraetetyp       Doku-Nummer: 148     EB-Code: -- */
/* ------------------------------------------------------------------------ */
VARIABLE device_type
{
	CLASS		HART;
	LABEL		"Positioner type no."
	            "|de|Typ-Nr. Regler";
	HANDLING	READ;
	TYPE		ENUMERATED (1)
	{
        { 239,  "373X-3"  },
        { 249,  "3780"    },
		{ 252,  [unknown] }
	}
    HELP "Positioner type no.: Type number of the positioner."
         "|de|Typ-Nr. Regler: Typnummer des Stellungsreglers.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Regelgroesse x               Doku-Nummer: 100   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE regelgroesse
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Controlled variable x" "|049Regelgre x";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  /* Einheit von Geraet initialisiert abhaengig */
  CONSTANT_UNIT
    IF (geraet_ini == 1)
    { "%"; }
    ELSE
    { ""; }

  HELP "Current position."
       "|049Aktuelle Position.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 1               Doku-Nummer: 103/315   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_1
{
  CLASS DEVICE;
  LABEL "Text field 1" "|049Textfeld 1";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Free available space for entering text."
       "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 2               Doku-Nummer: 104/316   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_2
{
  CLASS DEVICE;
  LABEL "Text field 2" "|049Textfeld 2";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Free available space for entering text."
       "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 3               Doku-Nummer: 105/317   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_3
{
  CLASS DEVICE;
  LABEL "Text field 3" "|049Textfeld 3";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Free available space for entering text."
       "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Erzeugnis-Nummer Regler      Doku-Nummer: 107   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE erzeugnis_num_regler
{
  CLASS DEVICE;
  LABEL "Product number positioner" "|049Erzeugnis-Nummer Regler";
  HANDLING READ;
  TYPE ASCII (32);

  HELP "Manufacturer's product number of the positioner."
       "|049Hersteller - Erzeugnis - Nummer des Stellungsreglers.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[0]                         Doku-Nummer: 111   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x0
{
  CLASS DEVICE;
  LABEL "x[0]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[1]                         Doku-Nummer: 112   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x1
{
  CLASS DEVICE;
  LABEL "x[1]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[2]                         Doku-Nummer: 113   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x2
{
  CLASS DEVICE;
  LABEL "x[2]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[3]                         Doku-Nummer: 114   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x3
{
  CLASS DEVICE;
  LABEL "x[3]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[4]                         Doku-Nummer: 115   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x4
{
  CLASS DEVICE;
  LABEL "x[4]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[5]                         Doku-Nummer: 116   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x5
{
  CLASS DEVICE;
  LABEL "x[5]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[6]                         Doku-Nummer: 117   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x6
{
  CLASS DEVICE;
  LABEL "x[6]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[7]                         Doku-Nummer: 118   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x7
{
  CLASS DEVICE;
  LABEL "x[7]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[8]                         Doku-Nummer: 119   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x8
{
  CLASS DEVICE;
  LABEL "x[8]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[9]                         Doku-Nummer: 120   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x9
{
  CLASS DEVICE;
  LABEL "x[9]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[10]                        Doku-Nummer: 121   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x10
{
  CLASS DEVICE;
  LABEL "x[10]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[0]                         Doku-Nummer: 122   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y0
{
  CLASS DEVICE;
  LABEL "y[0]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[1]                         Doku-Nummer: 123   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y1
{
  CLASS DEVICE;
  LABEL "y[1]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[2]                         Doku-Nummer: 124   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y2
{
  CLASS DEVICE;
  LABEL "y[2]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[3]                         Doku-Nummer: 125   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y3
{
  CLASS DEVICE;
  LABEL "y[3]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[4]                         Doku-Nummer: 126   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y4
{
  CLASS DEVICE;
  LABEL "y[4]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[5]                         Doku-Nummer: 127   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y5
{
  CLASS DEVICE;
  LABEL "y[5]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[6]                         Doku-Nummer: 128   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y6
{
  CLASS DEVICE;
  LABEL "y[6]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[7]                         Doku-Nummer: 129   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y7
{
  CLASS DEVICE;
  LABEL "y[7]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[8]                         Doku-Nummer: 130   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y8
{
  CLASS DEVICE;
  LABEL "y[8]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[9]                         Doku-Nummer: 131   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y9
{
  CLASS DEVICE;
  LABEL "y[9]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[10]                        Doku-Nummer: 132   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y10
{
  CLASS DEVICE;
  LABEL "y[10]";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP xy_help;
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nachlaufzeit                 Doku-Nummer: 133   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE nachlaufzeit
{
  CLASS DEVICE;
  LABEL "Delay time" "|049Nachlaufzeit";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.0f";
      EDIT_FORMAT    "4.0f";

      MIN_VALUE    0.0;
      MAX_VALUE 9999.0;
  }
  CONSTANT_UNIT "s";

  HELP "Reset criterion for monitoring the active control loop. "
       "When delay time is exceeded and the setpoint deviation is not "
       "within the limits of the tolerance band, a control loop error "
       "is reported."
       "|049Rcksetzkriterium fr laufende Regelkreis - berwachung. "
       "Wenn die Nachlaufzeit berschritten ist und die Regelabweichung "
       "nicht innerhalb des Toleranzbandes liegt, wird Regelkreisstrung "
       "gemeldet.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Sicherheitsstellung          Doku-Nummer: 134   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE sicherheitsstellung
{
  CLASS DEVICE;
  LABEL "Fail safe position" "|049Sicherheitsstellung";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "Air to close" "|049ffnend"     },
    { 1, "Air to open"  "|049Schlieend"  },
    { 2, "Undefined"    "|049Undefiniert" }
  }

  HELP "Fail safe position of the actuator in the event of air/power "
       "failure or start-up. Determined during initialization."
       "|049Sicherheitsstellung des Antriebes bei Luft - /Hilfsenergieausfall "
       "oder Gerteanlauf. Wird whrend der Initialisierung ermittelt.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zwangsentlueftung/Magnetventil aktiv      Doku-Nummer: 138    */
/* ------------------------------------------------------------------------ */
VARIABLE zwangsentlueftung
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Status solenoid valve" "|049Status Magnetventil";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "Yes"             "|049Ja"                  },
    { 1, "No"              "|049Nein"                },
    { 2, "Not implemented" "|049Nicht implementiert" }
  }

  /* nur sichtbar wenn Magnetventil eingebaut */
  VALIDITY
    IF (magnetventil == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Status of option solenoid valve."
       "|049Status der Option Magnetventil.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: X unterschreitet A1          Doku-Nummer: 140   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x_unterschreitet_a1
{
  CLASS DEVICE&DYNAMIC;
  LABEL "X falls below A1" "|049X unterschreitet A1";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "No"  "|049Nein" },
    { 1, "Yes" "|049Ja"   }
  }

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Indicates whether the controlled variable x falls below the "
       "limit value A1."
       "|049Anzeige ob die Regelgre x den Grenzwert fr A1 unterschreitet.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Status Grenzkontakt A1       Doku-Nummer: 141   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE status_a1
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Status limit switch A1" "|049Status Grenzkontakt A1";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "Non conducting/low" "|049Sperrend/low" },
    { 1, "Conducting/high"    "|049Leitend/high" }
  }

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Status of output for limit switch A1."
       "|049Status des Schaltausgangs fr Grenzkontakt A1.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: X ueberschreitet A2          Doku-Nummer: 142   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x_ueberschreitet_a2
{
  CLASS DEVICE&DYNAMIC;
  LABEL "X exceeds A2" "|049X berschreitet A2";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "No"  "|049Nein" },
    { 1, "Yes" "|049Ja"   }
  }

  HELP "Indicates whether the controlled variable x exceeds the limit value A2."
       "|049Anzeige ob die Regelgre x den Grenzwert fr A2 berschreitet.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Status Grenzkontakt A2       Doku-Nummer: 143   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE status_a2
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Status limit switch A2" "|049Status Grenzkontakt A2";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "Non conducting/low" "|049Sperrend/low" },
    { 1, "Conducting/high"    "|049Leitend/high" }
  }

  HELP "Status of output for limit switch A2."
       "|049Status des Schaltausgangs fr Grenzkontakt A2.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoerung vorh. (Stoermeldeausgang) Doku-Nummer: 144 EB-Code:- */
/* ------------------------------------------------------------------------ */
VARIABLE stoerung_vorhanden
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Error" "|049Strung";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "No"  "|049Nein" },
    { 1, "Yes" "|049Ja"   }
  }

  HELP "Status of the fault alarm output."
       "|049Status des Strmeldeausgangs.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraet initialisiert         Doku-Nummer: 145   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE geraet_ini
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Device initialized" "|049Gert initialisiert";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "No"  "|049Nein" },
    { 1, "Yes" "|049Ja"   }
  }

  HELP "Status of the device initialization."
       "|049Status der Gerte - Initialisierung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 4               Doku-Nummer: 146/318   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_4
{
  CLASS DEVICE;
  LABEL "Text field 4" "|049Textfeld 4";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Free available space for entering text."
       "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 5               Doku-Nummer: 147/319   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_5
{
  CLASS DEVICE;
  LABEL "Text field 5" "|049Textfeld 5";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Free available space for entering text."
       "|049Frei verfgbares Textfeld.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraetetyp                   Doku-Nummer: 148   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE geraetetyp
{
  CLASS DEVICE;
  LABEL "Device type" "|049Gertetyp";
  HANDLING READ;
  TYPE ENUMERATED
  {
    {  30, "3730-3",
           "SAMSON Positioner 3730-3 HART capable"
           "|049SAMSON Stellungsregler 3730-3 HART-fhig" },
    {  31, "3731-3",
           "SAMSON Positioner 3731-3 HART capable"
           "|049SAMSON Stellungsregler 3731-3 HART-fhig" },
    { 255, "Unknown" "|049Unbekannt" }
  }

  HELP "Shows the exact device type."
       "|049Anzeige des genauen Gertetyps.";
}

/* ------------------------------------------------------------------------ */
/* Diagnose-Parameter                                                       */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Typenkennung Antrieb         Doku-Nummer: 151   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ident_antrieb
{
  CLASS DEVICE;
  LABEL "Type identification actuator" "|049Typenkennung Antrieb";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Manufacturer's identification number of the actuator."
       "|049Hersteller - Identnummer des zum Stellungsregler zugehrigen Antriebs.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Booster                      Doku-Nummer: 152   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE booster
{
  CLASS DEVICE;
  LABEL "Booster" "|049Booster";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Not present" "|049Nicht vorhanden" },
    { 1, "Present"     "|049Vorhanden"       }
  }

  HELP "Pneumatic volume booster."
       "|049Pneumatischer Volumenverstrker.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Antriebswirkflaeche          Doku-Nummer: 153   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE antriebswirkflaeche
{
  CLASS DEVICE;
  LABEL "Actuator size" "|049Antriebswirkflche";
  HANDLING READ&WRITE;
  TYPE UNSIGNED_INTEGER (2)
  {
    DISPLAY_FORMAT  "4d";
    EDIT_FORMAT     "4d";

    MIN_VALUE   60;
    MAX_VALUE 5600;
  }
  CONSTANT_UNIT "cm";

  HELP "Effective diaphragm or piston area of the actuator."
       "|049Wirksame Membran- oder Kolbenflche des Antriebs.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stelldruckbereich Anfang     Doku-Nummer: 154   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE stelldruckbereich_anfang
{
  CLASS DEVICE;
  LABEL "Signal pressure lower value" "|049Stelldruckbereich Anfang";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  HELP "Start value of the actuator's spring range."
       "|049Anfangswert des Federbereiches des Antriebes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stelldruckbereich Ende       Doku-Nummer: 155   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE stelldruckbereich_ende
{
  CLASS DEVICE;
  LABEL "Signal pressure upper value" "|049Stelldruckbereich Ende";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  HELP "End value of the actuator's spring range."
       "|049Endwert des Federbereiches des Antriebes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Versorgungsdruck             Doku-Nummer: 156   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE versorgungsdruck
{
  CLASS DEVICE;
  LABEL "Supply pressure" "|049Versorgungsdruck";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  HELP "Pressure of the pneumatic supply system."
       "|049Druck des Zuluftnetzes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Typenkennung Ventil          Doku-Nummer: 157   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ident_ventil
{
  CLASS DEVICE;
  LABEL "Type identification valve" "|049Typenkennung Ventil";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Manufacturer identification of the valve delivered with the actuator."
       "|049Hersteller - Identnummer des zum Stellungsregler zugehrigen Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fliessrichtung               Doku-Nummer: 158   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE fliessrichtung
{
  CLASS DEVICE;
  LABEL "Flow direction" "|049Flierichtung";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Valve opening (FTO)" "|049Ventil ffnend (FTO)"     },
    { 1, "Valve closing (FTC)" "|049Ventil schliessend (FTC)" }
  }

  HELP "Flow direction of the medium against the valve trim."
       "|049Anstrmrichtung Medium zu Drosselelement des Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stangenabdichtung            Doku-Nummer: 159   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE stangenabdichtung
{
  CLASS DEVICE;
  LABEL "Stuffing box" "|049Stangenabdichtung";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Self adjusting" "|049Selbstnachstellend" },
    { 1, "Retorque"       "|049Nachziehbar"        },
    { 2, "Bag sealing"    "|049Balgabdichtung"     }
  }

  HELP "Sealing of the valve stem."
       "|049Abdichtung der Kegelstange nach aussen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Dichtkante (Leckageklasse)   Doku-Nummer: 160   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE dichtkante
{
  CLASS DEVICE;
  LABEL "Sealing edge (leakage class)" "|049Dichtkante (Leckageklasse)";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Metaly sealed" "|049Metallisch dichtend" },
    { 1, "Sharpened"     "|049Eingeschliffen"      },
    { 2, "Soft sealed"   "|049Weichdichtend"       },
    { 3, "Nickel sealed" "|049Nickeldichtung"      }
  }

  HELP "Type of sealing between seat and plug."
       "|049Art der Abdichtung zwischen Sitz und Kegel.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Druckentlastung              Doku-Nummer: 161   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE druckentlastung
{
  CLASS DEVICE;
  LABEL "Pressure balancing" "|049Druckentlastung";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "None"            "|049Ohne"          },
    { 1, "With (PTFE)"     "|049Mit (PTFE)"    },
    { 2, "With (graphite)" "|049Mit (Graphit)" }
  }

  HELP "Plug with mostly compensated stroking forces."
       "|049Kegel mit weitgehender Kompensation der Stellkrfte.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinie Kegel              Doku-Nummer: 162   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kennlinie_kegel
{
  CLASS DEVICE;
  LABEL "Flow characteristic" "|049Kennlinie Kegel";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Linear 30:1"           "|049Linear 30:1"          },
    { 1, "Equal percentage 30:1" "|049Gleichprozentig 30:1" },
    { 2, "Linear 50:1"           "|049Linear 50:1"          },
    { 3, "Equal percentage 50:1" "|049Gleichprozentig 50:1" },
    { 4, "Other"                 "|049Sonstige"             }
  }

  HELP "Valve charecteristic flow versus valve travel."
       "|049Ventilkennlinie Durchfluss zu Ventilhub.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nennweiten-Norm              Doku-Nummer: 163   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE nennweiten_norm
{
  CLASS DEVICE;
  LABEL "Nominal diameter" "|049Nennweiten-Norm";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "DIN"  "|049DIN"  },
    { 1, "ANSI" "|049ANSI" }
  }

  HELP "Valve dimensions according to DIN- or ANSI-standard."
       "|049Ventilabmessumgen nach DIN- oder ANSI-Norm.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nennweite DN                 Doku-Nummer: 164   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE nennweite_dn
{
  CLASS DEVICE;
  LABEL "Nominal diameter DN" "|049Nennweite DN";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.0f";
      EDIT_FORMAT    "4.0f";

      MIN_VALUE    8.0;
      MAX_VALUE 2100.0;
  }

  HELP "Diameter in mm (DIN) or inches (ANSI)."
       "|049Nennweite in mm (DIN) oder inch (ANSI).";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kvs Einheit                  Doku-Nummer: 165   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kvs_einheit
{
  CLASS DEVICE;
  LABEL "Kvs unit" "|049Kvs Einheit";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Kv" "|049Kv" },
    { 1, "Cv" "|049Cv" }
  }

  HELP "Flow coefficient based metric (kvs) or us-american (cv)."
       "|049Durchfluss - Koeffizient aus Einheiten metrisch (kvs) "
       "oder us-amerikanisch (cv).";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kvs Wert                     Doku-Nummer: 166   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kvs_wert
{
  CLASS DEVICE;
  LABEL "Kvs value" "|049Kvs Wert";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "10.4f";
      EDIT_FORMAT    "10.4f";

      MIN_VALUE     0.0001;
      MAX_VALUE 20000.0;
  }
  /* Einheit von kvs_einheit abhaengig */
  CONSTANT_UNIT
    IF (kvs_einheit == 0)
    { "Kv"; }
    ELSE
    { "Cv"; }

  HELP "Flow coefficient of the valve."
       "|049Durchfluss - Koeffizient des Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Sitzdurchmesser Ventil       Doku-Nummer: 167   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE sitzdurchmesser_ventil
{
  CLASS DEVICE;
  LABEL "Seat diameter valve" "|049Sitzdurchmesser Ventil";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   2.0;
      MAX_VALUE 500.0;
  }
  CONSTANT_UNIT "mm";

  HELP "Diameter of the valve seat."
       "|049Durchmesser der Sitzbohrung des Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Anzahl Nullpunktabgleiche    Doku-Nummer: 175   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE anzahl_np
{
  CLASS DEVICE;
  LABEL "Number of zero point adjustments" "|049Anzahl Nullpunktabgleiche";
  HANDLING READ;
  TYPE UNSIGNED_INTEGER (1)
  {
    DISPLAY_FORMAT "3d";
  }

  HELP "Number of zero point adjustments since the latest initialization."
       "|049Anzahl der durchgefhrten Nullpunktabgleiche seit der "
       "letzten Initialisierung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Klassifizierungscode         Doku-Nummer: 301   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE klassifizierungscode
{
  CLASS DEVICE;
  LABEL "Classify code" "|049Klassifizierungscode";
  HANDLING READ;
  TYPE UNSIGNED_INTEGER (1)
  {
      DISPLAY_FORMAT "1d";
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ausgang Split-Range          Doku-Nummer: 302   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ausgang_split_range
{
  CLASS DEVICE;
  LABEL "Control value" "|049Fhrungsgre %";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  HELP "Control value"
       "|049Fhrungsgre %";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ventilsollwert               Doku-Nummer: 304   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ventilsollwert
{
  CLASS DEVICE;
  LABEL "Valve setpoint" "|049Ventilsollwert";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  HELP "Valve setpoint"
       "|049Ventilsollwert";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zielposition                 Doku-Nummer: 306   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zielposition
{
  CLASS DEVICE;
  LABEL "Target position" "|049Zielposition";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  HELP "Target position"
       "|049Zielposition";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ventilposition               Doku-Nummer: 308   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ventilposition
{
  CLASS DEVICE;
  LABEL "Valve position" "|049Ventilposition";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  HELP "Valve position"
       "|049Ventilposition";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinientyp                Doku-Nummer: 320   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kennlinientyp
{
  CLASS DEVICE;
  LABEL "Characteristic type" "|049Kennlinientyp";
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  HELP "Free form description of the user defined characteristics."
       "|049Freier Text zur Beschreibung der benutzerdefinierten Kennlinie.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Long TAG                     Doku-Nummer: 323   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE long_tag
{
  CLASS DEVICE;
  LABEL "Long TAG" "|049Lang TAG";
  HANDLING READ&WRITE;
  TYPE ASCII (32);

  HELP      "Tag identification number of the operation unit."
            "|049Messstellen - Kennzeichen der Betriebseinheit.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ueberwachungszeit            Doku-Nummer: 324   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ueberwachungszeit
{
  CLASS DEVICE;
  LABEL "Shed time" "|049berwachungszeit";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "9.0f";
      EDIT_FORMAT    "9.0f";

      MIN_VALUE         0.0;
      MAX_VALUE 100000000.0;
  }
  CONSTANT_UNIT "s";

  HELP "Shed time"
       "|049berwachungszeit";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraetesperre                Doku-Nummer: 332   EB-Code: 3    */
/* ------------------------------------------------------------------------ */
VARIABLE geraetesperre
{
  CLASS DEVICE;
  LABEL "Lock device" "|049Gertesperre";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { UNLOCKING_DEVICE, "Unlocked" "|049Freigegeben" },
    { LOCKING_DEVICE,   "Locked"   "|049Gesperrt"    }
  }

  HELP "State local operation"
       "|049Status Vor-Ort-Bedienung";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zertifizierung               Doku-Nummer: 333   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zertifizierung
{
  CLASS DEVICE;
  LABEL "Certification" "|049Zertifizierung";
  HANDLING READ;
  TYPE ENUMERATED
  {
    {   0, "Not implemented"    "|049Nicht vorhanden"    },
    {   1, "Eex ia IIC T6"      "|049Eex ia IIC T6"      },
    {   3, "CSA/FM"             "|049CSA/FM"             },
    {   7, "Japan JIS"          "|049Japan JIS"          },
    {   8, "Zone 2,with manufacturer certification"
           "|049Zone 2,mit Herstellererklrung"          },
    { 255, "Not valid"          "|049Ungltig"           }
  }

  HELP "Determines whether or not the positioner is suitable for hazardous "
       "areas; explosion-proof type of protection installed."
       "|049Gibt an, ob der Stellungsregler in explosionsgefhrdeten "
       "Bereichen eingesetzt werden kann.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Bauart                       Doku-Nummer: 334   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE bauart
{
  CLASS DEVICE;
  LABEL "Model" "|049Bauart";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Single acting" "|049Einfach wirkend" },
    { 1, "Double acting" "|049Doppelt wirkend" }
  }

  HELP "Actuator with or without spring loading."
       "|049Antrieb mit oder ohne Federrckstellung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Anbau                        Doku-Nummer: 335   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE anbau
{
  CLASS DEVICE;
  LABEL "Attachment" "|049Anbau";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Integrated" "|049Integriert" },
    { 1, "NAMUR"      "|049NAMUR"      }
  }

  HELP "Defines positioner attachment to the control valve."
       "|049Definiert den Anbau des Stellungsreglers an das Stellgert.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: HART-Schreibschutz           Doku-Nummer: 336   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE hart_schreibschutz
{
  CLASS DEVICE&DYNAMIC;
  LABEL "HART write protection" "|049HART-Schreibschutz";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Not write protected" "|049Nicht schreibgeschtzt" },
    { 1, "Write protected" "|049Schreibgeschtzt"           }
  }

  HELP "HART write protection for all HART commands."
       "|049Schreibschutz fr alle HART-Kommandos.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Status Initialisierung       Doku-Nummer: 337   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE status_init
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Status initialization" "|049Status Initialisierung";
  HANDLING READ;
  TYPE ENUMERATED (1)
  {
    {   0, "Not active"               "|049Nicht aktiv"                },
    {   1, "Running"                  "|049Luft"                      },
    {   2, "Test aborted"             "|049Test abgebrochen"           },
    {  16, "Zero point adjustment"    "|049Nullpunktabgleich"          },
    {  17, "Maximum point adjustment" "|049Maximalpunktabgleich"       },
    {  18, "Detection of mech. stops" "|049Ermittlung mech. Anschlge" },
    {  19, "Controller optimization"  "|049Regleroptimierung"          },
    {  20, "Fine adjustment"          "|049Feinabgleich"               },
    {  21, "Step 1 (step response)"   "|049Sprung 1 (Sprungantwort)"   },
    {  23, "Step 2 (step response)"   "|049Sprung 2 (Sprungantwort)"   },
    { 254, "Terminated"               "|049Beendet"                    }
  }

  HELP "Status of the running calibration sequence."
       "|049Status der laufenden Kalibrierung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fuehrungsgroesse w [mA]      Doku-Nummer: 338   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE w_ma
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Reference variable w" "|049Fhrungsgre w";
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
  }
  CONSTANT_UNIT "mA";

  HELP "Current input signal in mA; used as reference variable w "
       "in mode AUTOMATIC."
       "|049Stromeingang in mA, dient in Betriebsart Automatik als "
       "Fhrungsgre.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: w-Bereich Anfang [mA]        Doku-Nummer: 339   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE w_ma_bereich_anfang
{
  CLASS DEVICE;
  LABEL "Reference variable range start" "|049Fhrungsgrenbereich Anfang";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  4.0;
      MAX_VALUE 16.0; /* 4mA (25%) unter w_ma_bereich_ende */
  }
  CONSTANT_UNIT "mA";

  HELP "Lower range value of the valid reference variable range."
       "|049Anfangswert des gltigen Fhrungsgrenbereiches.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: w-Bereich Ende [mA]          Doku-Nummer: 340   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE w_ma_bereich_ende
{
  CLASS DEVICE;
  LABEL "Reference variable range end" "|049Fhrungsgrenbereich Ende";
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  8.0;  /* 4mA (25%) ber w_ma_bereich_anfang */
      MAX_VALUE 20.0;
  }
  CONSTANT_UNIT "mA";

  HELP "Upper range value of the valid reference variable range."
       "|049Endwert des gltigen Fhrungsgrenbereiches.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung primaere Variable  Doku-Nummer: 341   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_prim_var
{
  CLASS DEVICE;
  LABEL "Assignment primary variable" "|049Zuordnung primre Variable";
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "Control value"        "|049Fhrungsgre %"     },
    { 1, "Valve setpoint"       "|049Ventilsollwert"      },
    { 2, "Target position"      "|049Zielposition"        },
    { 3, "Valve position"       "|049Ventilposition"      },
    { 4, "Setpoint deviation e" "|049Regelabweichung e"   },
    { 5, "Total valve travel"   "|049Wegintegral"         }
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung sekundaere Var.    Doku-Nummer: 342   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_sek_var
{
  CLASS DEVICE;
  LABEL "Assignment secondary variable" "|049Zuordnung sekundre Variable";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Control value"        "|049Fhrungsgre %"     },
    { 1, "Valve setpoint"       "|049Ventilsollwert"      },
    { 2, "Target position"      "|049Zielposition"        },
    { 3, "Valve position"       "|049Ventilposition"      },
    { 4, "Setpoint deviation e" "|049Regelabweichung e"   },
    { 5, "Total valve travel"   "|049Wegintegral"         }
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung tertiaere Var.     Doku-Nummer: 343   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_tert_var
{
  CLASS DEVICE;
  LABEL "Assignment tertiary variable" "|049Zuordnung tertire Variable";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Control value"        "|049Fhrungsgre %"     },
    { 1, "Valve setpoint"       "|049Ventilsollwert"      },
    { 2, "Target position"      "|049Zielposition"        },
    { 3, "Valve position"       "|049Ventilposition"      },
    { 4, "Setpoint deviation e" "|049Regelabweichung e"   },
    { 5, "Total valve travel"   "|049Wegintegral"         }
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung quartaere Var.     Doku-Nummer: 344   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_quart_var
{
  CLASS DEVICE;
  LABEL "Assignment quaternary variable" "|049Zuordnung quartre Variable";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Control value"        "|049Fhrungsgre %"     },
    { 1, "Valve setpoint"       "|049Ventilsollwert"      },
    { 2, "Target position"      "|049Zielposition"        },
    { 3, "Valve position"       "|049Ventilposition"      },
    { 4, "Setpoint deviation e" "|049Regelabweichung e"   },
    { 5, "Total valve travel"   "|049Wegintegral"         }
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Firmware Version             Doku-Nummer: 50/345 EB-Code: --  */
/* ------------------------------------------------------------------------ */
VARIABLE firmware_version
{
  CLASS DEVICE;
  LABEL "Software revision" "|049Firmware Version";
  HANDLING READ;
  TYPE ASCII (8);

  HELP "Indicates the current firmware version of the device."
       "|049Aktuelle Firmware Version des Gertes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktuelle Betriebsart         Doku-Nummer: 109/349 EB-Code: -- */
/* ------------------------------------------------------------------------ */
VARIABLE akt_betriebsart
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Actual mode" "|049Aktuelle Betriebsart" ;
  HANDLING READ;
  TYPE ENUMERATED
  {
      { AKT_BA_INBETRIEBNAHME,   "Start-up"               "|049Inbetriebnahme"      },
      { AKT_BA_INIT,             "Initialization"         "|049Initialisierung"     },
      { AKT_BA_AUTO_REGELUNG,    "Automatic"              "|049Automatik"           },
      { AKT_BA_AUTO_STEUERUNG,   "Automatic"              "|049Automatik"           },
      { AKT_BA_HAND_IP,          "Manual"                 "|049Hand"                },
      { AKT_BA_HAND_W,           "Manual"                 "|049Hand"                },
      { AKT_BA_HAND_W_STEUERUNG, "Manual"                 "|049Hand"                },
      { AKT_BA_SICHERHEIT,       "Fail safe position"     "|049Sicherheitsstellung" },
      { AKT_BA_TEST_MODUS,       "Test mode"              "|049Test-Modus"          },
      { AKT_BA_ENTW_MODUS,       "Development mode"       "|049Entwicklungs-Modus"  },
      { AKT_BA_HART_REGELUNG,    "HART automatic control" "|049HART-Regelung"       },
      { AKT_BA_HART_STEUERUNG,   "HART control"           "|049HART-Steuerung"      }
  }

  HELP "Shows the actual operating mode of the device."
	   "|049Anzeige der aktuellen Betriebsart des Gertes.";
}


/* ------------------------------------------------------------------------ */
/* Relations                                                                */
/* (Variable rechts des Doppelpunktes wird neu gelesen wenn links gendert) */
/* ------------------------------------------------------------------------ */
/* nach der Initialisierung folgende Werte neu einlesen: */
REFRESH relation_init
{ /*      337 : 6/54, 134, 21, 47, 48, 22, 23 8/347, 41 */
  status_init : nennbereich, sicherheitsstellung, druckgrenze,
                min_laufzeit_auf, min_laufzeit_zu, kp_stufe, tv_stufe,
                bewegungsrichtung, schliessrichtung
}

REFRESH relation_geraet_ini
{ /*     145 : 6, 41, 42, 51, 54 */
  geraet_ini : nennbereich, schliessrichtung, blockierstellung, antriebsdruck
}

REFRESH relation_akt_betriebsart
{ /*          109 : 2 */
  akt_betriebsart : w_hand
}

REFRESH relation_stellungsmelder
{ /*           44 : 36, 37, 38 */
  stellungsmelder : wirkr_stellmelder, stoerm_mit_stellmelder, test_stellmelder
}

REFRESH relation_ind_grenzkontakt
{ /*            45 : 30, 35, 31, 32, 140, 141 */
  ind_grenzkontakt :
  alarmmodus, /* alarm_test, */ aktiv_gw_a1, grenzwert_a1, x_unterschreitet_a1, status_a1
}

REFRESH relation_magnetventil
{  /*        52 : 64, 138, 325 */
   magnetventil : xmtr_specific_status_0, zwangsentlueftung/*, xmtr_specific_status_6*/
   /* 64 = Fehler 64 (Initialisierung Magnetventil) in fehlercode_0 enthalten */
}

/* Einheitenabhngigkeiten: */
REFRESH unit_relation_geraet_ini
{ /*     145 : 100 */
  geraet_ini : regelgroesse
}

/* Einheitenabhngigkeiten: */
REFRESH unit_relation_stiftposition
{ /*      5/352 : 9, 10, 41, 6/54, 11, 13, 12, 14 */
  stiftposition : x_bereich_anfang, x_bereich_ende, schliessrichtung, nennbereich,
                  aktiv_x_begrenzung_unten, aktiv_x_begrenzung_oben,
                  x_begrenzung_unten, x_begrenzung_oben
}

/*****************************************************************************/
/* COMMANDS                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/*      UNIVERSAL COMMANDS                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* CMD #0 - READ UNIQUE IDENTIFIER  */
/*****************************************************************************/
COMMAND read_unique_identifier
{
	NUMBER 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{	/* IDENTIFY_REPLY */
			response_code, device_status, 254, manufacturer_id, device_type,
			request_preambles, universal_revision, transmitter_revision,
			software_revision,hardware_revision <0xf8>, physical_signaling_code <0x07>,
			device_flags, device_id
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #1 - READ PRIMARY VARIABLE */
/*****************************************************************************/
COMMAND read_pv
{
	NUMBER 1;
	OPERATION READ;
	TRANSACTION
    {
		REQUEST
		{}
		REPLY
		{
            response_code, device_status,
            dynamic_variables[0].DIGITAL_UNITS, dynamic_variables[0].DIGITAL_VALUE
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,		[no_command_specific_errors];
		6,	MISC_ERROR,		[xmtr_specific_command_error];
		8,	MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #2 - READ P.V. CURRENT AND PERCENT OF RANGE */
/*****************************************************************************/
COMMAND read_pv_current_and_percent_range
{
	NUMBER 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
            response_code, device_status,
            dynamic_variables[0].ANALOG_VALUE, dynamic_variables[0].PERCENT_RANGE
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,		[no_command_specific_errors];
		6,	MISC_ERROR,		[xmtr_specific_command_error];
		8,	MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #3 - READ DYNAMIC VARIABLES AND P.V. CURRENT */
/*****************************************************************************/
COMMAND read_dynamic_variables_and_pv_current
{
	NUMBER 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
    		response_code, device_status,
            dynamic_variables[0].ANALOG_VALUE,
            dynamic_variables[0].DIGITAL_UNITS, dynamic_variables[0].DIGITAL_VALUE,
            dynamic_variables[1].DIGITAL_UNITS, dynamic_variables[1].DIGITAL_VALUE,
            dynamic_variables[2].DIGITAL_UNITS, dynamic_variables[2].DIGITAL_VALUE,
            dynamic_variables[3].DIGITAL_UNITS, dynamic_variables[3].DIGITAL_VALUE
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,		[no_command_specific_errors];
		6,	MISC_ERROR,		[xmtr_specific_command_error];
		8,	MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #6 - WRITE POLLING ADDRESS */
/*****************************************************************************/
COMMAND write_polling_address
{
	NUMBER 6;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			polling_address
		}
		REPLY
		{
			response_code, device_status, polling_address
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		6,	MISC_ERROR,			[xmtr_specific_command_error];
		7,	MODE_ERROR,			[in_write_protect_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #11 - READ UNIQUE IDENTIFIER ASSICIATED WITH TAG */
/*****************************************************************************/
COMMAND read_unique_identifier_with_tag
{
	NUMBER 11;
	OPERATION COMMAND;
	TRANSACTION
	{
		REQUEST
		{
			tag
		}
		REPLY
		{	/* IDENTIFY_REPLY */
			response_code, device_status, 254, manufacturer_id, device_type,
			request_preambles, universal_revision, transmitter_revision,
			software_revision, hardware_revision <0xf8>, physical_signaling_code <0x07>,
			device_flags, device_id
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR,	[too_few_data_bytes_recieved];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #12 - READ MESSAGE */
/*****************************************************************************/
COMMAND read_message
{
	NUMBER 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status, message
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #13 - READ TAG, DESCRIPTOR, DATE */
/*****************************************************************************/
COMMAND read_tag_descriptor_date
{
	NUMBER 13;
	OPERATION READ;
	TRANSACTION
	{
    	REQUEST
		{}
		REPLY
		{
			response_code, device_status, tag, descriptor, date
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #14 - READ PRIMARY VARIABLE SENSOR INFORMATION */
/*****************************************************************************/
COMMAND read_pv_sensor_info
{
	NUMBER 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
            dynamic_variables[0].SENSOR_SERIAL_NUMBER, dynamic_variables[0].SENSOR_UNITS,
            dynamic_variables[0].UPPER_SENSOR_LIMIT,   dynamic_variables[0].LOWER_SENSOR_LIMIT,
            dynamic_variables[0].MINIMUM_SPAN
		}
	}
	RESPONSE_CODES
	{
		0,  SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #15 - READ PRIMARY VARIABLE OUTPUT INFORMATION */
/*****************************************************************************/
COMMAND read_pv_output_info
{
	NUMBER 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
            dynamic_variables[0].ALARM_CODE,     dynamic_variables[0].TRANSFER_FUNCTION,
            dynamic_variables[0].RANGE_UNITS,    dynamic_variables[0].UPPER_RANGE_VALUE,
            dynamic_variables[0].LOWER_RANGE_VALUE,
            dynamic_variables[0].DAMPING_VALUE, write_protect, private_label_distributor
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #16 - READ FINAL ASSEMBLY NUMBER */
/*****************************************************************************/
COMMAND read_final_assembly_number
{
	NUMBER 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status, final_assembly_number
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #17 - WRITE MESSAGE */
/*****************************************************************************/
COMMAND write_message
{
	NUMBER 17;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			message
		}
		REPLY
		{
			response_code, device_status, message
		}
    }
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR, [too_few_data_bytes_recieved];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #18 - WRITE TAG, DESCRIPTOR, DATE */
/*****************************************************************************/
COMMAND write_tag_descriptor_date
{
	NUMBER 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			tag, descriptor, date
		}
		REPLY
		{
			response_code, device_status, tag, descriptor, date
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR, [too_few_data_bytes_recieved];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #19 - WRITE FINAL ASSEMBLY NUMBER */
/*****************************************************************************/
COMMAND write_final_assembly_number
{
	NUMBER 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			final_assembly_number
		}
		REPLY
		{
			response_code, device_status, final_assembly_number
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		5,	MISC_ERROR, [too_few_data_bytes_recieved];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/*      COMMON PRACTICE COMMANDS                                             */
/*****************************************************************************/

/*****************************************************************************/
/* CMD #38 - RESET CONFIGURATION CHANGED FLAG */
/*****************************************************************************/
COMMAND reset_configuration_change_flag
{
	NUMBER 38;
	OPERATION COMMAND;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR, [xmtr_specific_command_error];
		7,	MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #48 - READ ADDITIONAL TRANSMITTER STATUS */
/*****************************************************************************/
COMMAND read_additional_transmitter_status
{
	NUMBER 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
        	response_code, device_status,
            xmtr_specific_status_0,         /* Byte 0 (Fehlercode 0) */
			xmtr_specific_status_1,         /* Byte 1 (Fehlercode 1) */
			xmtr_specific_status_2,         /* Byte 2 (Fehlercode 2) */
			xmtr_specific_status_3,         /* Byte 3 (Fehlercode 3) */
			xmtr_specific_status_4,         /* Byte 4 (Kaltstart ausgefuehrt) */
			xmtr_specific_status_5,         /* Byte 5 (Ersatzabgleich/Geraet init.) */
			operating_mode_1,               /* Byte 6 (Wegintegral ueberschritten) (0/1) */
			operating_mode_2,               /* Byte 7     dummy (=0) */
			analog_output_saturated1,       /* Byte 8-10  dummy (=0) */
			analog_output_saturated2,
			analog_output_saturated3,
			analog_output_fixed1,           /* Byte 11-13 dummy (=0) */
			analog_output_fixed2,
			analog_output_fixed3,
			xmtr_specific_status_6,         /* Byte 14 (device_family_status_0) */
			xmtr_specific_status_7,         /* Byte 15 (device_family_status_1) */
			xmtr_specific_status_8          /* Byte 16 (device_family_status_2) */
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,       [no_command_specific_errors];
		6,	MISC_ERROR,	   [xmtr_specific_command_error];
		8,	MISC_WARNING,  [update_in_progress];
		16,	MODE_ERROR,    [access_restricted];
	}
}

/*****************************************************************************/
/* CMD #50 - READ DYNAMIC VARIABLE ASSIGNMENTS */
/*****************************************************************************/
COMMAND read_transmitter_variable_assignments
{
	NUMBER 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{}
		REPLY
		{
			response_code, device_status,
			primary_variable_code, secondary_variable_code,
			tertiary_variable_code, fourth_variable_code
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,	[no_command_specific_errors];
		6,	MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #54 - READ TRANSMITTER VARIABLE INFORMATION */
/*****************************************************************************/
COMMAND read_transmitter_variable_information
{
	NUMBER 54;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
			transmitter_variable_code (INFO,INDEX)
		}
		REPLY
		{
			response_code, device_status, transmitter_variable_code,
			transmitter_variables[transmitter_variable_code].SENSOR_SERIAL_NUMBER,
			transmitter_variables[transmitter_variable_code].SENSOR_UNITS,
			transmitter_variables[transmitter_variable_code].UPPER_SENSOR_LIMIT,
			transmitter_variables[transmitter_variable_code].LOWER_SENSOR_LIMIT,
			transmitter_variables[transmitter_variable_code].DAMPING_VALUE,
			transmitter_variables[transmitter_variable_code].MINIMUM_SPAN
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
		2,	MISC_ERROR,			[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		6,	MISC_ERROR,			[xmtr_specific_command_error];
		16,	MODE_ERROR,			[access_restricted];
	}
}

/*****************************************************************************/
/* CMD #59 - WRITE NUMBER OF RESPONSE PRAEMBELS */
/*****************************************************************************/
COMMAND write_number_of_response_preambles
{
	NUMBER 59;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			response_preambles
		}
		REPLY
		{
			response_code, device_status, response_preambles
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
		3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		6,	MISC_ERROR,			[xmtr_specific_command_error];
		7,	MODE_ERROR,			[in_write_protect_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}

/*****************************************************************************/
/* MANUFACTURER SPECIFIC COMMANDS                                            */
/*****************************************************************************/

/*****************************************************************************/
/* Commands zum bertragen von floats                                        */
/*****************************************************************************/
/*****************************************************************************/
/* Command 128 read_static_variables
   Command wird verwendet zum Lesen von vier float Variablen aus der Tabelle
   static_param.
   static_param_code1...4 dienen als Index in die Tabelle. */
/*****************************************************************************/
COMMAND read_static_variables
{
  NUMBER 128;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
    {
	  static_param_code1 (INFO, INDEX),
	  static_param_code2 (INFO, INDEX),
	  static_param_code3 (INFO, INDEX),
	  static_param_code4 (INFO, INDEX)
	}
      REPLY
	{
	  response_code, device_status,
	  static_param_code1,
	  static_param[static_param_code1],
	  static_param_code2,
      static_param[static_param_code2],
	  static_param_code3,
      static_param[static_param_code3],
	  static_param_code4,
      static_param[static_param_code4]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 129 write_static_variables
   Command wird verwendet zum Schreiben einer float Variablen aus der Tabelle
   static_param.
   static_param_code dient als Index in die Tabelle. */
/*****************************************************************************/
COMMAND write_static_variables
{
  NUMBER 129;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  static_param_code (INFO, INDEX),
	  static_param[static_param_code]
	}
    REPLY
	{
	  response_code, device_status,
	  static_param_code,
	  static_param[static_param_code]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Commands zum bertragen von enumerates                                    */
/*****************************************************************************/

/*****************************************************************************/
/* Command 130 read_enums
   Command wird verwendet zum Lesen von vier enum. Variablen aus der Tabelle
   static_enums.
   static_enums_code1...4 dienen als Index in die Tabelle. */
/*****************************************************************************/
COMMAND read_enums
{
  NUMBER 130;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  static_enums_code1 (INFO, INDEX),
	  static_enums_code2 (INFO, INDEX),
	  static_enums_code3 (INFO, INDEX),
	  static_enums_code4 (INFO, INDEX)
	}
    REPLY
	{
	  response_code, device_status,
	  static_enums_code1,
	  static_enums[static_enums_code1],
	  static_enums_code2,
      static_enums[static_enums_code2],
	  static_enums_code3,
      static_enums[static_enums_code3],
	  static_enums_code4,
      static_enums[static_enums_code4]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 131 write_enums
   Command wird verwendet zum Schreiben einer enum. Variablen aus der Tabelle
   static_enums.
   static_enums_code1 dient als Index in die Tabelle. */
/*****************************************************************************/
COMMAND write_enums
{
  NUMBER 131;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  static_enums_code (INFO, INDEX),
	  static_enums[static_enums_code]
	}
    REPLY
	{
	  response_code, device_status,
	  static_enums_code,
	  static_enums[static_enums_code]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 147   Antriebswirkflche lesen (HART 5)                           */
/*****************************************************************************/
COMMAND read_antriebswirkflaeche
{
  NUMBER 147;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}

    REPLY
	{
	  response_code, device_status,
      antriebswirkflaeche
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
  }
}

/*****************************************************************************/
/* Command 148   Antriebswirkflche schreiben (HART 5)                       */
/*****************************************************************************/
COMMAND write_antriebswirkflaeche
{
  NUMBER 148;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      antriebswirkflaeche
	}

    REPLY
	{
	  response_code, device_status,
      antriebswirkflaeche
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
     3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
     7, MODE_ERROR,         [in_write_protect_mode];
  }
}

/*****************************************************************************/
/* Command 132   read Benutzer-Kennlienientyp */
/*****************************************************************************/
COMMAND read_kennlinientyp
{
  NUMBER 132;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}
    REPLY
	{
	  response_code, device_status,
	  kennlinientyp
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 133   write Benutzer-Kennlienientyp */
/*****************************************************************************/
COMMAND write_kennlinientyp
{
  NUMBER 133;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  kennlinientyp
	}

    REPLY
	{
	  response_code, device_status,
	  kennlinientyp
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 134
   Command wird verwendet zum Abfragen des Status von Aktionen */
/*****************************************************************************/
COMMAND read_action_status
{
  NUMBER 134;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	}

    REPLY
	{
	  response_code, device_status,
	  status_init
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 141 Read Info_Firmware
     Lesen der Firmware-Versionsnummer. */
/*****************************************************************************/
COMMAND read_info_firmware
{
  NUMBER 141;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
	  firmware_version
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS, [no_command_specific_errors];
  }
}

/*****************************************************************************/
/* Command 143      Lesen des Long-TAG */
/*****************************************************************************/
COMMAND read_long_tag
{
  NUMBER 143;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
	  long_tag
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS, [no_command_specific_errors];
  }
}

/*****************************************************************************/
/* Command 144       Schreiben des Long-TAG (fuer HART 5) */
/*****************************************************************************/
COMMAND write_long_tag
{
  NUMBER 144;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  long_tag
    }

    REPLY
	{
	  response_code, device_status,
	  long_tag
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS,    [no_command_specific_errors];
    5, MISC_ERROR, [too_few_data_bytes_recieved];
    7, MODE_ERROR, [in_write_protect_mode];
  }
}

/*****************************************************************************/
/* Command 145   Aktionen im Stellungsregler starten (HART 5) */
/*****************************************************************************/
COMMAND write_start_actions
{
  NUMBER 145;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      start_action
    }

    REPLY
	{
	  response_code, device_status,
      start_action
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 1,	MISC_ERROR,         [cal_failed]; /* NP- oder Init.-fehler */
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
     7, MODE_ERROR,         [in_write_protect_mode];
	16, MODE_ERROR,         [access_restricted];
  }
}

VARIABLE start_action
{
  CLASS DEVICE;
  LABEL "start action" "|049start action";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      {   2, "x" "|049Start_Init" },
      {   3, "x" "|049Nullpkt_Init" },
      {   4, "x" "|049Squawk" },
      { 100, "x" "|049Stoerm_Test" },
      { 101, "x" "|049GW1_Test" },
      { 102, "x" "|049GW2_Test" },
      { 103, "x" "|049Kennl_transfer_start" },
      { 104, "x" "|049Kennl_transfer_ende" },
      { 105, "x" "|049Kaltstart" },
      { 119, "x" "|049Reset_Wegint" },
      { 120, "x" "|049Reset_XFehler" },
      { 121, "x" "|049Reset_DXFehler" },
      { 122, "x" "|049Reset_AnbauFehler" },
      { 123, "x" "|049Reset_InitZeitFehler" },
      { 124, "x" "|049Reset_MGVFehler" },
      { 125, "x" "|049Reset_Laufz_Fehler" },
      { 126, "x" "|049Reset_StiftPos_Fehler" },
      { 127, "x" "|049Reset_Regelkr_Fehler" },
      { 128, "x" "|049Reset_Nullpkt_Fehler" },
      { 129, "x" "|049Reset_Autokorrektur_Fehler" },
      { 130, "x" "|049Reset_Fataler_Fehler" },
      { 131, "x" "|049Reset_XSignal_Fehler" },
      { 132, "x" "|049Reset_WzuKlein_Fehler" },
      { 133, "x" "|049Reset_IP_Fehler" },
      { 134, "x" "|049Reset_Hardware_Fehler" },
      { 135, "x" "|049Reset_Datensp_Fehler" },
      { 136, "x" "|049Reset_Kontrr_Fehler" },
      { 137, "x" "|049Reset_Regelparam_Fehler" },
      { 138, "x" "|049Reset_Poti_Param" },
      { 139, "x" "|049Reset_Abgleich_Fehler" },
      { 140, "x" "|049Reset_Allg_Param_Fehler" },
      { 141, "x" "|049Reset_Startup_Param_Fehler" },
      { 142, "x" "|049Reset_kein_produk_Fehler" },
      { 143, "x" "|049Reset_HART_Param_Fehler" },
      { 144, "x" "|049Reset_Kaltstart_Flag" }
  }
}

/*****************************************************************************/
/* Command 146   Aktionen im Stellungsregler abbrechen (HART 5) */
/*****************************************************************************/
COMMAND abort_actions
{
  NUMBER 146;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      abort_action
    }

    REPLY
	{
	  response_code, device_status,
      abort_action
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
     7, MODE_ERROR,         [in_write_protect_mode];
	16, MODE_ERROR,         [access_restricted];
  }
}

VARIABLE abort_action
{
  CLASS DEVICE;
  LABEL "Abort action" "|049Aktion abbrechen";
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      {   2, "Abort initialization" "|049Abbruch Initialisierung"   },
      {   3, "Abort ZP adjustment"  "|049Abbruch Nullpunktabgleich" }
  }

  HELP "abort action";
}

/*****************************************************************************/
/* Command 137 Read Trend-Values
     Sammel-Command um viele Werte zu erhalten (z.B. fuer Trend-Fenster) */
/*****************************************************************************/
COMMAND read_trend_values
{
  NUMBER 137;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
	  w_prozent,         /* Byte 0-3 Fhrungsgre in % */
	  regelgroesse,      /* Byte 4-7 Regelgre in %    */
	  dummy_enum,        /* Byte  8  'Regelkreis gestrt'- Fehler */
	  dummy_enum,        /* Byte  9  Nullpunktfehler */
	  status_init_piste  /* Byte 10  Status der Initialisierung und der Piste */
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS, [no_command_specific_errors];
  }
}

/*****************************************************************************/
/* Command 135 read_dev_ident_nr
   Command wird verwendet zum Abfragen der Erzeugnisnummer des Reglers */
/*****************************************************************************/
COMMAND read_dev_ident_nr
{
  NUMBER 135;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}
    REPLY
	{
	  response_code, device_status,
	  erzeugnis_num_regler
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 136
   Command wird verwendet zum Abfragen der dyn. Variablen des Reglers */
/*****************************************************************************/
COMMAND read_all_dynamics
{
  NUMBER 136;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}

    REPLY
	{
	  response_code, device_status,
	  w_ma,                 /* Byte 0-3   */
	  akt_betriebsart,      /* Byte 4     */
   	  w_prozent,            /* Byte 5-8   */
	  w_hand,               /* Byte 9-12  */
      regeldifferenz,       /* Byte 13-16 */
	  regelgroesse,         /* Byte 17-20 */
	  stoerung_vorhanden,   /* Byte 21    */
	  status_a1,            /* Byte 22    */
	  status_a2,            /* Byte 23    */
	  reglerstatus,         /* Byte 24    */
	  wegintegral,          /* Byte 25-28 */
	  status_init_piste     /* Byte 29    */
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE status_init_piste
{
  CLASS DEVICE&DYNAMIC;
  LABEL "status_init_piste";
  HANDLING READ;
  TYPE BIT_ENUMERATED (1)
  {
      { 0x01, "Device initialized" "|049Gert initialisiert", DATA },
      { 0x02, "Piste ok"           "|049Piste ok"           , DATA }
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Betriebszustand              Doku-Nummer: 365   EB-Code: -    */
/* ------------------------------------------------------------------------ */
VARIABLE reglerstatus
{
  CLASS DEVICE&DYNAMIC;
  LABEL "Operating status" "|049Betriebszustand";
  HANDLING READ;
  TYPE ENUMERATED
  {
      { 0, "See operating mode"        "|049Siehe Betriebsart"         },
      { 1, "Solenoid valve active"     "|049Magnetventil aktiv"        },
      { 2, "Lower travel limit active" "|049Hubbegrenzung unten aktiv" },
      { 3, "Upper travel limit active" "|049Hubbegrenzung oben aktiv"  },
      { 4, "End position < active"     "|049Endlage < aktiv"           },
      { 5, "End position > active"     "|049Endlage > aktiv"           }
  }

  HELP "Shows the current operating status of the internal position "
       "control algorithm."
       "|049Zeigt den aktuellen Betriebszustand der internen "
       "Stellungsregelung an.";
}

/*****************************************************************************/
/* Command 138 read_text
   Command wird verwendet zum Abfragen der Textfelder
   Auswahl des Texts erfolgt ber text_index */
/*****************************************************************************/
COMMAND read_text_inputs
{
  NUMBER 138;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  text_index (INFO, INDEX)
    }
    REPLY
	{
	  response_code, device_status,
	  text_index,
	  user_text[text_index]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Command 139 write_text
   Command wird verwendet zum Schreiben der Textfelder
   Auswahl des Texts erfolgt ber text_index */
/*****************************************************************************/
COMMAND write_text_inputs
{
  NUMBER 139;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  text_index (INFO, INDEX),
	  user_text[text_index]
    }
    REPLY
	{
	  response_code, device_status,
	  text_index,
	  user_text[text_index]
	}
  }
  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
	 7,	MODE_ERROR,		    [in_write_protect_mode];
	 8, MISC_WARNING,       [update_in_progress];
	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	14,	DATA_ENTRY_WARNING,	[span_too_small];
	16, MODE_ERROR,         [access_restricted];
  }
}

/*****************************************************************************/
/* Methods                                                                   */
/*****************************************************************************/
METHOD method_PDM_StandardDiagnosis
{
    LABEL       "method_PDM_StandardDiagnosis";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {
        int i_stat_0, i_stat_1, i_stat_2, i_stat_3;
        int i_stat_7, i_stat_8;
        int akt_BA, dev_status;
        int i_no_good, i_no_recommended; /* Merker zum Lschen anderer Stati */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        send_command(48);     /* Status einlesen */
        /* Status zuweisen */
        i_stat_0 = int_value(xmtr_specific_status_0);
        i_stat_1 = int_value(xmtr_specific_status_1);
        i_stat_2 = int_value(xmtr_specific_status_2);
        i_stat_3 = int_value(xmtr_specific_status_3);
        i_stat_7 = int_value(xmtr_specific_status_7);
        i_stat_8 = int_value(xmtr_specific_status_8);

        /* Parameter vorbelegen: */
		PDM_Diag_Status_Diagnosis = 0;
		PDM_Diag_Rule_Message     = "";
		i_no_good = 0;
		i_no_recommended = 0;

        dev_status = ivar_value (device_status); /* Gertezustand kopieren */

        /* bei Hand PDM_DIAG_SIMULATION setzen */
	    iassign(static_enums_code1,  86);    /* akt. Betriebsart */
	    iassign(static_enums_code2,  94);    /* irgendwas */
	    iassign(static_enums_code3, 101);    /* irgendwas */
	    iassign(static_enums_code4, 102);    /* irgendwas */
        send_command(130); /* akt. Betriebsart auslesen */
        akt_BA = ivar_value (akt_betriebsart);

        /*----------------------------------------------*/
        /* Auswertung der eingelesenen Statusparameter: */
        /*----------------------------------------------*/

        /* wenn Hand aktiv: */
        if ((akt_betriebsart == AKT_BA_HAND_IP)  ||
            (akt_betriebsart == AKT_BA_HAND_W )  ||
            (akt_betriebsart == AKT_BA_HAND_W_STEUERUNG ))
        {
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Manual mode active;"
			                         "|049Betriebsart Hand aktiv;";
            i_no_good += 1; /* good lschen */
        }

        /*---------------------------------------------*/
        /* device_status (Gertezustand)               */
        /*---------------------------------------------*/
		if( dev_status & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += [PV_out_of_limits] + ";";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( dev_status & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += [Non_PV_out_of_limits] + ";";
            i_no_good += 1; /* good lschen */
		}

		if( dev_status & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += [cold_start] + ";";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( dev_status & 0x40 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message += [configuration_changed] + ";";
		}

		if( dev_status & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += [device_malfunction] + ";";
            i_no_good += 1; /* good lschen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_0 (Fehlercodes Byte 0) */
        /*---------------------------------------------*/
		if( i_stat_0 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "x > range;" "|049x > Bereich;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_0 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Delta x < range;" "|049Delta x < Bereich;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_0 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Attachment;" "|049Anbau;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_0 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Initialization time exceeded;"
			                         "|049Initialisierungszeit berschritten;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_0 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Initialization / solenoid valve;"
			                         "|049Initialisierung / Magnetventil;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_0 & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Travel time too short;"
			                         "|049Laufzeit unterschritten;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_0 & 0x40 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Pin position;" "|049Stiftposition;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_0 & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Control loop;" "|049Regelkreis;";
            i_no_good += 1; /* good lschen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_1 (Fehlercodes Byte 1) */
        /*---------------------------------------------*/
		if( i_stat_1 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Zero point;" "|049Nullpunkt;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_1 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Autocorrection;" "|049Autokorrektur;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_1 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Fatal error;" "|049Fataler Fehler;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_1 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "x-signal;" "|049x-Signal;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_1 & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "W too small;" "|049W zu klein;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_1 & 0x40 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "i/p-converter;" "|049i/p-Wandler;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_1 & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Hardware;" "|049Hardware;";
            i_no_good += 1; /* good lschen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_2 (Fehlercodes Byte 2) */
        /*---------------------------------------------*/
		if( i_stat_2 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Data memory;" "|049Datenspeicher;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_2 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Test calculation;" "|049Kontrollrechnung;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_2 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Control parameter;" "|049Regelparameter;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_2 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Poti parameter;" "|049Potiparameter;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_2 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Configuration parameter;"
			                         "|049Abgleichparameter;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_2 & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "General parameter;" "|049Allgemeine Parameter;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_2 & 0x80 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Internal device error 1;"
			                         "|049Interner Gertefehler 1;";
            i_no_good += 1; /* good lschen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_3 (Fehlercodes Byte 3) */
        /*---------------------------------------------*/
		if( i_stat_3 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "HART parameter;" "|049HART Parameter;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_3 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Info parameter;" "|049Info Parameter;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_3 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message += "No emergency mode;"
			                         "|049Keine Notlaufeigenschaft;";
		}

		if( i_stat_3 & 0x08 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Program load error;"
			                         "|049Programmladefehler;";
            i_no_good += 1; /* good lschen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_7 (Gertestatus 1) */
        /*---------------------------------------------*/
		if( i_stat_7 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message += "Device not initialized;"
			                         "|049Gert nicht initialisiert;";
            i_no_good += 1; /* good lschen */
		}

		if( i_stat_7 & 0x02 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Initialization not successful;"
			                         "|049Initialisierung nicht erfolgreich;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_7 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Initialization is running;"
			                         "|049Initialisierung luft;";
		}

		if( i_stat_7 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message += "User defined characteristics not valid;"
			                         "|049Benutzerdef. Kennlinie ungltig;";
            i_no_good += 1; /* good lschen */
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_8 (Gertestatus 2)     */
        /*---------------------------------------------*/
		if( i_stat_8 & 0x04 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message += "Zero point error;" "|049Nullpunktfehler;";
            i_no_good += 1;        /* good lschen */
            i_no_recommended += 1; /* recommended lschen */
		}

		if( i_stat_8 & 0x10 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message += "Total valve travel exceeded;"
			                         "|049Wegintegral berschritten;";
            i_no_good += 1; /* good lschen */
		}

        /* wenn nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message = "Status OK"
			                        "|de|Zustand OK"
			                        "|fr|Etat OK"
			                        "|it|Stato OK"
			                        "|sp|Estado OK";
		}

        /* wenn Status PDM_DIAG_GOOD gelscht werden soll: */
		if( i_no_good != 0 )
		{    /* nur PDM_DIAG_GOOD lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_GOOD_INVERS;
		}

        /* wenn Status PDM_DIAG_MAINT_RECOMMENDED gelscht werden soll: */
		if( i_no_recommended != 0 )
		{    /* nur PDM_DIAG_MAINT_RECOMMENDED lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_MAINT_RECOMMENDED_INVERS;
		}
    }
}
/*****************************************************************************/

/* fr Aufruf von Manual 3730-3: */
METHOD methodOpenDeviceManual_3730
{
	LABEL "SAMSON 3730-3 " + [menu_DeviceManual];
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3730);
	}
    HELP "Mounting and operating instructions of the positioner 3730-3."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3730-3.";
}
/*****************************************************************************/

/* fr Aufruf von Manual 3731-3: */
METHOD methodOpenDeviceManual_3731
{
	LABEL "SAMSON 3731-3 " + [menu_DeviceManual];
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3731);
	}
    HELP "Mounting and operating instructions of the positioner 3731-3."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3731-3.";
}
/*****************************************************************************/

METHOD sie_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	DEFINITION
	{
	}
}
/*****************************************************************************/

METHOD std_CommWay
{
	LABEL		[menu_Device_CommWay];
	DEFINITION
	{
	}
}
/*****************************************************************************/

METHOD configuration_flag_reset
{
	CLASS		INPUT;
	LABEL		[configuration_flag_reset];
	HELP		[configuration_flag_reset_help];
	DEFINITION
	{
		int		choice;
		char	disp_string1[60];
		char	disp_string2[60];
		int		slen1;
		int		slen2;
        int     wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

		slen1=60;
		slen2=60;
		get_dictionary_string(configuration_flag_reset_execute, disp_string1, slen1);
		get_dictionary_string(yes_no, disp_string2, slen2);
		choice= SELECT_FROM_LIST(disp_string1, disp_string2);
		if ( choice == 0 )
		{
    		DELAY(2, "Reset" "|de|Wird rckgesetzt");
			send_command(38);
		}
	}
}
/*****************************************************************************/

/* ------------------------------------------------------------------------ */
/* Parameter: Nullpunktabgleich            Doku-Nummer: 211   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD start_nullpunktabgleich
{
    LABEL "Zero point adjustment" "|049Nullpunktabgleich";
    DEFINITION
    {
		char status[STATUS_SIZE];
		char dev_status[DEV_STATUS_SIZE];
		int  cnt;
        long ids[2];
        int  wrProt; /* Speicher fuer Schreibschutztest */
        int  error;
        int  akt_BA; /* aktuelle Betriebsart */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */
        CHECK_ACT_MODE /* Wenn akt. Betriebsart = Sicherheitsstellung: nicht auslsen ! */

        ACKNOWLEDGE("WARNING: Never start zero point adjustment during a running process !\n"
                    "During zero point adjustment the control valve departs from its current "
                    "position at full travel !\n\n"
                    "Status of zero point adjustment: \nsee parameter 'Status initialization', "
                    "'Error codes' and 'Device status'.\n\n"
                    "Start zero point adjustment ?"
                    "|de|WARNUNG: Der Nullpunktabgleich darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Nullpunktabgleich fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status des Nullpunktabgleichs: \nsiehe Parameter 'Status Initialisierung', "
                    "'Fehlercodes' und 'Gertestatus'.\n\n"
                    "Nullpunktabgleich starten ?");

	    iassign(start_action, 3); /* NP-Abgleich auslsen */
        send_command(145);
   		DELAY(3, "Zero point adjustment is running"
   		         "|de|Nullpunktabgleich luft");
    }

    HELP "Start the zero point adjustment."
         "|049Start des Nullpunktabgleichs.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Initialisierung              Doku-Nummer: 212   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD start_initialisierung
{
    LABEL "Initialization" "|049Initialisierung";
    DEFINITION
    {
      char  status[STATUS_SIZE];
      char  dev_status[DEV_STATUS_SIZE];
      int   cnt;
      long  ids[2];
      int   wrProt; /* Speicher fuer Schreibschutztest */
      int   error;
      int   akt_BA; /* aktuelle Betriebsart */

      XMTR_IGNORE_ALL_COMM_STATUS();
      XMTR_IGNORE_ALL_DEVICE_STATUS();
      XMTR_IGNORE_ALL_RESPONSE_CODES();
      XMTR_IGNORE_COMM_ERROR();

      IGNORE_ALL_COMM_STATUS();
      IGNORE_ALL_DEVICE_STATUS();
      IGNORE_ALL_RESPONSE_CODES();
      IGNORE_COMM_ERROR();

      XMTR_RETRY_ON_NO_DEVICE();
      RETRY_ON_NO_DEVICE();

      CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */
      CHECK_ACT_MODE /* Wenn akt. Betriebsart = Sicherheitsstellung: nicht auslsen ! */

      ACKNOWLEDGE("WARNING: Never start initialization during a running process !\n"
                  "During initialization the control valve departs from its current"
                  "position at full travel !\n"
                  "Hint: previously the parameter initialization mode "
                  "must have the required value.\n\n"
                  "Status of initialization: \nsee parameter 'Status initialization', "
                  "'Error codes' and 'Device status'.\n\n"
                  "Start initialization ?"
                  "|de|WARNUNG: Die Initialisierung darf nicht whrend eines laufenden"
                  " Prozesses erfolgen !\n"
                  "Bei Initialisierung fhrt das Stellgert den gesamten Bereich durch !\n"
                  "Hinweis: Initialisierungsart vorher "
                  "auf gewnschten Wert einstellen.\n\n"
                  "Status der Initialisierung: \nsiehe Parameter 'Status Initialisierung', "
                  "'Fehlercodes' und 'Gertestatus'.\n\n"
                  "Initialisierung starten ?");

      iassign(start_action, 2); /* Initialisierung auslsen */
      send_command(145);
      DELAY(3, "Initialization is running"
               "|de|Initialisierung luft");
    }

    HELP "Start the initialization sequence. Previously the parameter "
         "initialization mode must have the required value."
         "|049Start der Initialisierung. Der Parameter "
         "Initialisierungsart muss vorher auf die gewnschte "
         "Initialisierungs - Sequenz eingestellt sein.";
}

/* ------------------------------------------------------------------------ */
/* Kaltstart ausloesen                                                      */
/* ------------------------------------------------------------------------ */
METHOD start_kaltstart
{
    LABEL "Set to default values" "|049Auf Standardwerte setzen";
    DEFINITION
    {
        int  wrProt; /* Speicher fuer Schreibschutztest */

        CHECK_WRITE_PROTECTION  /* auf Schreibschutz testen */

        ACKNOWLEDGE("Warning: never start with default values during a running process !\n"
                    "The valve departs from its current position at full travel !"
                    "|049Warnung: Start mit Standardwerten darf nicht whrend eines "
                    "laufenden Prozesses erfolgen !\n"
                    "Ventil fhrt durch den gesamten Bereich !");

        ACKNOWLEDGE("Note: A new initialization will be necessary."
                    "|049Hinweis: Eine erneute Initialisierung wird erforderlich.");

        iassign( start_action, 105 ); /* Parameter Kaltstart auf Start setzen */
        send_command(145);            /* Kaltstart auslsen */

        DELAY(20, "Device is resetting..." "|049Gert wird zurckgesetzt...");

        ACKNOWLEDGE("Note: new communication startup necessary to get "
                    "current device data."
                    "|049Hinweis: Erneuter Verbindungsaufbau notwendig "
                    "um Gertedaten neu zu lesen.");
    }

    HELP "Resets all parameters to default (factory setting). "
         "Note: After reset the device must be re-initialized."
         "|049Setzt alle Parameter auf Standardwerte (Werkseinstellung) zurck. "
         "Hinweis: Nach dem Setzen muss das Gert neu initialisiert werden.";
}

/* ------------------------------------------------------------------------ */
/* Ruecksetzen der Fehlerbits                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_fehler
{
    LABEL "Selection reset error" "|049Auswahl Rcksetzen Fehler";
    DEFINITION
    {
        int result;
        int wrProt; /* Speicher fuer Schreibschutztest */

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        result = SELECT_FROM_LIST("Reset error:" "|049Rcksetzen Fehler:",
          "x > range;"                          /* 0  Fehler 50   */
          "Delta x < range;"                    /* 1  Fehler 51   */
          "Attachment;"                         /* 2  Fehler 52   */
          "Initialization time exceeded;"       /* 3  Fehler 53   */
          "Initialization/solenoid valve;"      /* 4  Fehler 54   */
          "Travel time too low;"                /* 5  Fehler 55   */
          "Pin position;"                       /* 6  Fehler 56   */
          "Zero point;"                         /* 7  Fehler 58   */
          "Autocorrection;"                     /* 8  Fehler 59   */
          "Hardware;"                           /* 9  Fehler 65   */
          "Test calculation;"                   /* 10 Fehler 67   */
          "Control parameter;"                  /* 11 Fehler 68   */
          "Poti parameter;"                     /* 12 Fehler 69   */
          "General parameter;"                  /* 13 Fehler 71   */
          "HART parameter;"                     /* 14 Fehler 74   */
          "Info parameter"                      /* 15 Fehler 75   */
          /*"Config. changed" */                /* 16 config changed flag (Para 358) */

          "|049x > Bereich;"                    /* 0  Fehler 50   */
          "Delta x < Bereich;"                  /* 1  Fehler 51   */
          "Anbau;"                              /* 2  Fehler 52   */
          "Initialisierungszeit berschritten;" /* 3  Fehler 53   */
          "Initialisierung/Magnetventil;"       /* 4  Fehler 54   */
          "Laufzeit unterschritten;"            /* 5  Fehler 55   */
          "Stiftposition;"                      /* 6  Fehler 56   */
          "Nullpunkt;"                          /* 7  Fehler 58   */
          "Autokorrektur;"                      /* 8  Fehler 59   */
          "Hardware;"                           /* 9  Fehler 65   */
          "Kontrollrechnung;"                   /* 10 Fehler 67   */
          "Regelparameter;"                     /* 11 Fehler 68   */
          "Potiparameter;"                      /* 12 Fehler 69   */
          "Allgemeine Parameter;"               /* 13 Fehler 71   */
          "HART Parameter;"                     /* 14 Fehler 74   */
          "Info Parameter"  );                  /* 15 Fehler 75   */
          /*"Konfig. gendert"*/                /* 16 config changed flag (Para 358) */

        /* ------------------------------------------------------------------------ */
        /* Parameter: Rcks. Fehlercodes  Doku-Nr.: 213-236,240,330  EB-Code: ab 50 */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset this error message ?"
                    "|049Diese Fehlermeldung zurcksetzen ?");
        if (result == 0)
        { /* Fehler 50  (X > Bereich-Fehler zuruecksetzen) */
          iassign(start_action, 120);
          send_command(145);
        }
        if (result == 1)
        { /* Fehler 51  (dX > Bereich zuruecksetzen) */
          iassign(start_action, 121);
          send_command(145);
        }
        if (result == 2)
        { /* Fehler 52  (Anbau-Fehler zuruecksetzen) */
          iassign(start_action, 122);
          send_command(145);
        }
        if (result == 3)
        { /* Fehler 53  (Init-Zeit > - Fehler zuruecksetzen) */
          iassign(start_action, 123);
          send_command(145);
        }
        if (result == 4)
        { /* Fehler 54  (Init-MGV-Fehler zuruecksetzen) */
          iassign(start_action, 124);
          send_command(145);
        }
        if (result == 5)
        { /* Fehler 55  (Laufzeit < - Fehler zuruecksetzen) */
          iassign(start_action, 125);
          send_command(145);
        }
        if (result == 6)
        { /* Fehler 56  (Stiftposition-Fehler zuruecksetzen) */
          iassign(start_action, 126);
          send_command(145);
        }
        if (result == 7)
        { /* Fehler 58  (Nullpunkt-Fehler zuruecksetzen) */
          iassign(start_action, 128);
          send_command(145);
        }
        if (result == 8)
        { /* Fehler 59  (Autokorrektur-Fehler zuruecksetzen) */
          iassign(start_action, 129);
          send_command(145);
        }
        if (result == 9)
        { /* Fehler 65  (Hardware-Fehler zuruecksetzen) */
          iassign(start_action, 134);
          send_command(145);
        }
        if (result == 10)
        { /* Fehler 67  (Kontrollrechnung-Fehler zuruecksetzen) */
          iassign(start_action, 136);
          send_command(145);
        }
        if (result == 11)
        { /* Fehler 68  (Regelparameter-Fehler zuruecksetzen) */
          iassign(start_action, 137);
          send_command(145);
        }
        if (result == 12)
        { /* Fehler 69  (Poti-Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 138);
          send_command(145);
        }
        if (result == 13)
        { /* Fehler 71  (Allgemeine-Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 140);
          send_command(145);
        }
        if (result == 14)
        { /*  Fehler 74  (HART-Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 143);
          send_command(145);
        }
        if (result == 15)
        { /*  Fehler 75  (Info Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 141);
          send_command(145);
        }

        /* ------------------------------------------------------------------------ */
        /* Parameter: Ruecksetzen 'Konfiguration geaendert'      Doku-Nummer: 358   */
        /* ------------------------------------------------------------------------ */
        /*if (result == 16)
        {
          ACKNOWLEDGE("Reset this message ?"
                      "|049Diese Meldung zurcksetzen ?");
          send_command(38);
        }*/

        DELAY(3, "resetting..." "|049wird zurckgesetzt...");
    }

    HELP "Resets different flags back to zero."
         "|049Setzt verschiedene Flags auf 0 zurck.";
}

/* ------------------------------------------------------------------------ */
/* Ruecksetzen Kaltstart-Flag                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_cold_start_flag
{
    LABEL "Reset default values flag" "|049Rcksetzen Standardwerte Flag";
    DEFINITION
    {
        int wrProt; /* Speicher fuer Schreibschutztest */

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        /* ------------------------------------------------------------------------ */
        /* Parameter: Ruecksetzen Kaltstart Flag   Doku-Nummer: 353   EB-Code: --   */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset default values flag ?"
                    "|049Standardwerte Flag zurcksetzen ?");
        iassign(start_action, 144); /* Kaltstart Flag zurcksetzen */
        send_command(145);

        DELAY(3, "resetting..." "|049wird zurckgesetzt...");
    }

    HELP "Resets default values flag back to zero."
         "|049Setzt Standardwerte Flag auf 0 zurck.";
}

/* ------------------------------------------------------------------------ */
/* Ruecksetzen Zhler Wegintegral                                           */
/* ------------------------------------------------------------------------ */
METHOD reset_valve_travel_counter
{
    LABEL "Reset travel counter" "|049Rcksetzen Wegintegral";
    DEFINITION
    {
        int result;
        int wrProt; /* Speicher fuer Schreibschutztest */

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        /* ------------------------------------------------------------------------ */
        /* Parameter: Ruecksetzen Wegintegral      Doku-Nummer: 209   EB-Code: --   */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset total valve travel counter to zero ?"
                    "|049Zhler fr absolutes Wegintegral auf 0 setzen ?");
        iassign(start_action, 119); /* Wegintegral zurcksetzen */
        send_command(145);

        DELAY(3, "resetting..." "|049wird zurckgesetzt...");
    }

    HELP "Resets total valve travel counter back to zero."
         "|049Setzt Zhler fr absolutes Wegintegral auf 0 zurck.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Abbruch Nullpunktabgleich    Doku-Nummer: 354   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD abort_zp_adjust
{
    LABEL "Abort zero point adjustment" "|049Abbruch Nullpunktabgleich";
    DEFINITION
    {
       int  wrProt; /* Speicher fuer Schreibschutztest */

       CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

       ACKNOWLEDGE("Abort running zero point adjustment ?"
                   "|049Laufenden Nullpunktabgleich abbrechen ?");

       iassign(abort_action, 3); /* 'Nullpunktabgleich abbrechen' senden */
       send_command(146);
       DELAY(3, "Zero point adjustment is aborted."
                "|049Nullpunktabgleich wird abgebrochen.");
    }

    HELP "Abort the running zero point adjustment. "
         "The valve is moved to the fail safe position."
         "|049Abbruch des laufenden Nullpunktabgleichs. "
         "Stellventil wird in die Sicherheitsstellung gefahren.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Abbruch Initialisierung      Doku-Nummer: 355   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD abort_init
{
    LABEL "Abort initialization" "|049Abbruch Initialisierung";
    DEFINITION
    {
        int  wrProt; /* Speicher fuer Schreibschutztest */

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        ACKNOWLEDGE("Abort the running initialization ?"
                    "|049Laufende Initialisierung abbrechen ?");

        iassign(abort_action, 2); /* 'Initialisierung abbrechen' senden */
        send_command(146);
        DELAY(3, "Initialization is aborted."
                 "|049Initialisierung wird abgebrochen.");
    }

    HELP "Abort the running initialization. "
         "The valve is moved to the fail safe position."
         "|049Abbruch der laufenden Initialisierung. "
         "Stellventil wird in die Sicherheitsstellung gefahren.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraet suchen                Doku-Nummer: 362   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD search_device
{
    LABEL "Search device" "|049Gert suchen";
    DEFINITION
    {
       int  wrProt; /* Speicher fuer Schreibschutztest */

       CHECK_WRITE_PROTECTION    /* auf Schreibschutz testen */

       iassign(start_action, 4); /* 'Gert suchen' senden */
       send_command(145);
    }

    HELP "Displays 'Here I am' at the connected device."
         "|049Anzeige von 'Here I am' am angeschlossenem Gert.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Alarm Test                Doku-Nummer: 35/238   EB-Code: 28   */
/* ------------------------------------------------------------------------ */
METHOD met_alarm_test
{
    LABEL "Selection alarm test" "|049Auswahl Alarm Test";
    DEFINITION
    {
        int  alarm_test_tmp;
        int  wrProt;
        int  ind_gk;

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        iassign(static_enums_code1, 75);  /* auf ind_grenzkontakt stellen */
        send_command(130);                /* ind_grenzkontakt einlesen */
        ind_gk = int_value(ind_grenzkontakt);

        /* wenn ind. Grenzkontakt eingebaut: Test A1 weglassen */
        if (ind_gk == IMPLEMENTED)
        {
          alarm_test_tmp = SELECT_FROM_LIST("Test ..." "|049Teste ...",
          "A2;"     "Fault alarm"
          "|049A2;" "Strmelder"  );
          alarm_test_tmp = alarm_test_tmp + 1; /* +1 weil Antwort 0 - 1 - 2 sein soll */
        }
        else
        {
          alarm_test_tmp = SELECT_FROM_LIST("Test ..." "|049Teste ...",
          "A1;"     "A2;" "Fault alarm"
          "|049A1;" "A2;" "Strmelder"  );
          /* keine Korrektur notwendig, weil Antwort 0 - 1 - 2 ist */
        }

        if (alarm_test_tmp == 0) /* Test A1 */
        {
          ACKNOWLEDGE("Limit switch A1 will switch 5 times."
                      "|049Grenzkontakt A1 wird 5 mal geschaltet.");
          iassign(start_action, 101); /* Test A1 senden */
          send_command(145);
        }
        if (alarm_test_tmp == 1) /* Test A2 */
        {
          ACKNOWLEDGE("Limit switch A2 will switch 5 times."
                      "|049Grenzkontakt A2 wird 5 mal geschaltet.");
          iassign(start_action, 102); /* Test A2 senden */
          send_command(145);
        }
        if (alarm_test_tmp == 2) /* Test Strmeldung A3 */
        {
          ACKNOWLEDGE("Error switch A3 will switch 5 times."
                      "|049Strmeldekontakt A3 wird 5 mal geschaltet.");
          iassign(start_action, 100); /* Test Strmeldung A3 senden */
          send_command(145);
        }
    }

    HELP "Testing the limit switches A1 / A2 and the fault "
         "alarm output A3."
         "|049Test der Grenzkontakte A1 und A2 sowie des "
         "Strmeldekontaktes A3.";
}

/* ------------------------------------------------------------------------ */
/* Methode: kennl_eingabe                                                   */
/*          zur Eingabe der Sttzwerte der benutzerdefinierten Kennlinie    */
/* ------------------------------------------------------------------------ */
METHOD kennl_eingabe
{
    LABEL "Input coordinates" "|049Eingabe Sttzwerte";
    DEFINITION
    {
	  char status[STATUS_SIZE];
	  char dev_status[DEV_STATUS_SIZE];
	  int  param_nr;
      int  wrProt;

	  XMTR_IGNORE_ALL_COMM_STATUS();
	  XMTR_IGNORE_ALL_DEVICE_STATUS();
	  XMTR_IGNORE_ALL_RESPONSE_CODES();
	  XMTR_IGNORE_COMM_ERROR();

	  IGNORE_ALL_COMM_STATUS();
	  IGNORE_ALL_DEVICE_STATUS();
	  IGNORE_ALL_RESPONSE_CODES();
	  IGNORE_COMM_ERROR();

      CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

	  GET_DEV_VAR_VALUE("x[0]", x0);
	  GET_DEV_VAR_VALUE("y[0]", y0);

	  GET_DEV_VAR_VALUE("x[1]", x1);
	  GET_DEV_VAR_VALUE("y[1]", y1);

	  GET_DEV_VAR_VALUE("x[2]", x2);
	  GET_DEV_VAR_VALUE("y[2]", y2);

	  GET_DEV_VAR_VALUE("x[3]", x3);
	  GET_DEV_VAR_VALUE("y[3]", y3);

	  GET_DEV_VAR_VALUE("x[4]", x4);
	  GET_DEV_VAR_VALUE("y[4]", y4);

	  GET_DEV_VAR_VALUE("x[5]", x5);
	  GET_DEV_VAR_VALUE("y[5]", y5);

	  GET_DEV_VAR_VALUE("x[6]", x6);
	  GET_DEV_VAR_VALUE("y[6]", y6);

	  GET_DEV_VAR_VALUE("x[7]", x7);
	  GET_DEV_VAR_VALUE("y[7]", y7);

	  GET_DEV_VAR_VALUE("x[8]", x8);
	  GET_DEV_VAR_VALUE("y[8]", y8);

	  GET_DEV_VAR_VALUE("x[9]", x9);
	  GET_DEV_VAR_VALUE("y[9]", y9);

	  GET_DEV_VAR_VALUE("x[10]", x10);
	  GET_DEV_VAR_VALUE("y[10]", y10);

	  /* Start Kennlinienbertragung */
	  DELAY(2, "Transmission of values. Please wait..."
               "|049Werte werden bertragen. Bitte warten...");

      iassign(start_action, 103); /* Start KL-bertragung */
	  send_command(145);

      /* Werte bertragen */
	  for( param_nr=24; param_nr<46; param_nr++ )
	  {
	    iassign(static_param_code, param_nr);
	    send_command(129); /* float-Wert schreiben */
	  }

      iassign(start_action, 104); /* Ende KL-bertragung */
	  send_command(145);

      ACKNOWLEDGE("Transmission of values completed."
                  "|049Kennlinienwerte wurden bertragen.");

      get_more_status(status, dev_status);  /* CMD 48 */

      /* dev_status[15] = device_family_status_1 */
      if (dev_status[15] & 0x10) /* Kennlinie fehlerhaft */
      {
	  	ACKNOWLEDGE("User defined characteristics is not valid."
	  		        "|049Benutzerdefinierte Kennlinie ist ungltig.");
      }
    }

    HELP "Coordinates for user-defined control valve characteristic."
         "|049Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
         "Fhrungsgre und Hub / Drehwinkel.";
}

/* ------------------------------------------------------------------------ */
/* Methode: kennl_einlesen                                                  */
/*          zum manuellem Einlesen der KL-Werte                             */
/* ------------------------------------------------------------------------ */
METHOD kennl_einlesen
{
    LABEL "Read coordinates from device" "|049Sttzwerte aus Gert lesen";
    DEFINITION
    {
	  int  param_nr;

	  XMTR_IGNORE_ALL_COMM_STATUS();
	  XMTR_IGNORE_ALL_DEVICE_STATUS();
	  XMTR_IGNORE_ALL_RESPONSE_CODES();
	  XMTR_IGNORE_COMM_ERROR();

	  IGNORE_ALL_COMM_STATUS();
	  IGNORE_ALL_DEVICE_STATUS();
	  IGNORE_ALL_RESPONSE_CODES();
	  IGNORE_COMM_ERROR();

	  DELAY(2, "Reading values. Please wait..."
               "|049Werte werden eingelesen. Bitte warten...");

      /* KL-Werte einlesen (Indices 24...45) */
	  for( param_nr=24; param_nr<46; param_nr++ )
	  {
        /* 2 Werte auf einmal, da nur dann bei static_param_code2 am Ende 45
           drinsteht (46 ist nicht vorhanden !) */
	    iassign(static_param_code1, param_nr);
	    param_nr++;
	    iassign(static_param_code2, param_nr);
        send_command(128); /* Werte einlesen */
	  }

      ACKNOWLEDGE("Reading of values completed."
                  "|049Kennlinienwerte wurden eingelesen.");
    }

    HELP "Reading of coordinates for user-defined control valve characteristic "
         "from the device."
         "|049Einlesen der Sttzwerte fr die benutzerdefinierte Kennlinie "
         "aus dem Gert.";
}

/*****************************************************************************/
/* MENU Bar (Menleiste)                                                     */
/*****************************************************************************/
MENU Menu_Main_Specialist
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_S_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}

MENU Menu_Main_Maintenance
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_M_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}

/*****************************************************************************/
/*    Menu: File (Datei)					                                 */
/*****************************************************************************/
MENU Menu_File
{
	LABEL		[menu_File];
	ITEMS
	{
		std_Save,
		SEPARATOR,
		std_Eigenschaften,
		SEPARATOR,
		std_Print,
		std_PrintPreview,
		std_PrintSetup,
		std_PageSetup,
		std_Schriftfelder,
		SEPARATOR,
		std_Exit
	}
}

METHOD std_Save
{
	LABEL		[menu_File_Save];
	DEFINITION
	{
	}
}

METHOD SEPARATOR
{
	LABEL		[menu_Separator];
	DEFINITION
	{
	}
}

METHOD std_Eigenschaften
{
	LABEL		[menu_File_Properties];
	DEFINITION
	{
	}
}

METHOD std_Print
{
	LABEL		[menu_File_Print];
	DEFINITION
	{
	}
}

METHOD std_PrintPreview
{
	LABEL		[menu_File_PrintPreview];
	DEFINITION
	{
	}
}

METHOD std_PrintSetup
{
	LABEL		[menu_File_PrintSetup];
	DEFINITION
	{
	}
}

METHOD std_PageSetup
{
	LABEL		[menu_File_PageSetup];
	DEFINITION
	{
	}
}

METHOD std_Schriftfelder
{
	LABEL		[menu_File_Labels];
	DEFINITION
	{
	}
}

METHOD std_Exit
{
	LABEL		[menu_File_Exit];
	DEFINITION
	{
	}
}

METHOD polling_address_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	CLASS		INPUT;
	DEFINITION
	{
		ACKNOWLEDGE([message_polling_address]);
	}
}

/*****************************************************************************/
/*    Menu: Device (Gert)											         */
/*****************************************************************************/
MENU Menu_S_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_CommWay,                 /* Methode */
		SEPARATOR,
		OnlineDialog_Device_NodeAddress,
		SEPARATOR,
		std_LoadinDevice,
		std_LoadinPC,
		SEPARATOR,
		OnlineDialog_operation,
		OnlineDialog_reset,
		SEPARATOR,
		OnlineDialog_self_calibration,
        OfflineWindow_graph_xy_editable,
		OnlineDialog_request_response_preambles,
        OnlineDialog_write_locking   /* Schreibverriegelung */
	}
}

MENU OnlineDialog_Device_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	ITEMS
	{
			polling_address,
			polling_address_set
	}
}

MENU Menu_M_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_CommWay,                 /* Methode */
		SEPARATOR,
/* nicht bei Instandhalter:
		OnlineDialog_Device_NodeAddress,
		SEPARATOR,
*/
		std_LoadinDevice,
		std_LoadinPC
/* nicht bei Instandhalter:
		SEPARATOR,
		OnlineDialog_operation,
		OnlineDialog_reset,
		SEPARATOR,
		OnlineDialog_self_calibration,
        OfflineWindow_graph_xy_editable,
		OnlineDialog_request_response_preambles,
        OnlineDialog_write_locking
*/
	}
}

METHOD std_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	DEFINITION
	{
	}
}

METHOD std_LoadinDevice
{
	LABEL		[menu_Device_LoadinDevice];
	DEFINITION
	{
	}
}

METHOD std_LoadinPC
{
	LABEL		[menu_Device_LoadinPC];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: View (Ansicht)											         */
/*****************************************************************************/
MENU Menu_View
{
	LABEL		[menu_View];
	ITEMS
	{
		OnlineWindow_display,
		OnlineWindow_yt,
		OnlineWindow_diagnosis,
		SEPARATOR,
		std_Funktionsleiste,
		std_Statuszeile,
		SEPARATOR,
		std_Update
	}
}

METHOD std_Funktionsleiste
{
	LABEL		[menu_View_Toolbar];
	DEFINITION
	{
	}
}

METHOD std_Statuszeile
{
	LABEL		[menu_View_Statusbar];
	DEFINITION
	{
	}
}

METHOD std_Update
{
	LABEL		[menu_View_Update];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: Options (Extras)										         */
/*****************************************************************************/
MENU Menu_Options
{
	LABEL		[menu_Options];
	ITEMS
	{
		std_Einstellungen,
		std_Untereintraege
	}
}

METHOD std_Einstellungen
{
	LABEL		[menu_Options_Properties];
	DEFINITION
	{
	}
}

METHOD std_Untereintraege
{
	LABEL		[menu_Options_Subitems];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: Help (Hilfe)											         */
/*****************************************************************************/
MENU Menu_Help
{
	LABEL		[menu_Help];
	ITEMS
	{
		std_Hilfethemen,
		std_HilfeKontext,
		SEPARATOR,
		std_HilfeGeraet,
		SEPARATOR,
		methodOpenDeviceManual_3730,
/* kmr: erst wenn EB verfgbar: */
/*		methodOpenDeviceManual_3731,*/
		SEPARATOR,
		std_HilfeEinfuehrung,
		std_HilfeErsteSchritte,
		SEPARATOR,
		std_Hilfebenutzen,
		std_Info
	}
}

METHOD std_Hilfethemen
{
	LABEL		[menu_Help_Topics];
	DEFINITION
	{
	}
}

METHOD std_HilfeKontext
{
	LABEL		[menu_Help_Context];
	DEFINITION
	{
	}
}

METHOD std_HilfeGeraet
{
	LABEL		[menu_Help_Device];
	DEFINITION
	{
	}
}

METHOD std_HilfeEinfuehrung
{
	LABEL		[menu_Help_Introduction];
	DEFINITION
	{
	}
}

METHOD std_HilfeErsteSchritte
{
	LABEL		[menu_Help_First_Steps];
	DEFINITION
	{
	}
}

METHOD std_Hilfebenutzen
{
	LABEL		[menu_Help_Using];
	DEFINITION
	{
	}
}

METHOD std_Info
{
	LABEL		[menu_Help_Info];
	DEFINITION
	{
	}
}

/*******************************************************************************/
/* Online Windows                                                              */
/*******************************************************************************/
/* Ansicht - Messwertanzeige ***************************************************/
MENU OnlineWindow_display
{
	LABEL		[menu_dialog_display];
	ITEMS
	{
		Page_display_measure,
		Page_display_state_1,   /* Status 1 */
		Page_display_state_2,   /* Status 2 */
		Page_display_statistic, /* Statistik */
		Page_display_device     /* Gert */
	}
}

/* Ansicht - Messwertanzeige - Messwert ****************************************/
MENU Page_display_measure
{
	LABEL		[menu_dialog_display_measure];
	ITEMS
	{
        Page_group_display_measure
	}
}

MENU Page_group_display_measure
{
	LABEL		"";
	ITEMS
	{
		BarVal_pv_display,
		BarVal_sp_display,
        akt_betriebsart,
        reglerstatus,
		SEPARATOR,
        VertBar_e_display
	}
}

MENU BarVal_pv_display /* Istwert Bargraph */
{
    LABEL "Controlled variable x" "|049Regelgre x";
	ITEMS
	{
		regelgroesse,
		dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE
	}
}

MENU BarVal_sp_display /* Sollwert Bargraph */
{
    LABEL
        /* bei Betriebsart HAND */
        IF ((akt_betriebsart == AKT_BA_HAND_IP)  ||
            (akt_betriebsart == AKT_BA_HAND_W )  ||
            (akt_betriebsart == AKT_BA_HAND_W_STEUERUNG ))
        {
            "Man. Reference variable w" "|049Hand Fhrungsgre w";
        }
        ELSE
        {
            "Reference variable w" "|049Fhrungsgre w";
        }

	ITEMS
	{
        /* bei Betriebsart HAND */
        IF ((akt_betriebsart == AKT_BA_HAND_IP)  ||
            (akt_betriebsart == AKT_BA_HAND_W )  ||
            (akt_betriebsart == AKT_BA_HAND_W_STEUERUNG ))
        {
            w_hand     (READ_ONLY), /* Handsollwert anzeigen */
        }
        ELSE
        {
		    w_prozent  (READ_ONLY), /* Autosollwert anzeigen */
        }

		dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE
	}
}

MENU VertBar_e_display /* Regeldifferenz Bargraph */
{
    LABEL "Setpoint deviation e" "|049Regeldifferenz e";
	ITEMS
	{
		regeldifferenz  (READ_ONLY),
		eMin,
		eMax
	}
}

/* Minimalwert Bargraph e */
VARIABLE eMin
{
	LABEL "e Min";
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE -10 ;
	}
}

/* Maximalwert Bargraph e */
VARIABLE eMax
{
	LABEL "e Max";
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE 10 ;
	}
}

/* Ansicht - Messwertanzeige - Status 1 ***************************************/
MENU Page_display_state_1
{
	LABEL	  "Status 1"
	          "|de|Status 1";
	ITEMS
	{
	   Page_group_display_state_1, /* Betrieb */
	   Page_group_display_state_2  /* Status */
	}
}

MENU Page_display_state_2
{
	LABEL	  "Status 2"
	          "|de|Status 2";
	ITEMS
	{
	   Page_group_display_state_3, /* Fehlercodes */
	   Page_group_display_state_4  /* Gertestatus */
	}
}

MENU Page_group_display_state_1
{
    LABEL  "Operating" "|de|Betrieb";
	ITEMS
	{
	   akt_betriebsart,
       reglerstatus
	}
}

MENU Page_group_display_state_2
{
    LABEL  "Status" "|de|Status";
	ITEMS
	{
	   stoerung_vorhanden,
       x_unterschreitet_a1,
       status_a1,
       x_ueberschreitet_a2,
       status_a2,
       magnetventil,
       xmtr_specific_status_4,
       xmtr_specific_status_5,  /* Ersatzabgleich durchgefhrt */
       device_status            /* Gertezustand */
	}
}

MENU Page_group_display_state_3
{
    LABEL  "Error codes" "|de|Fehlercodes";
	ITEMS
	{
       xmtr_specific_status_0,
       xmtr_specific_status_1,
       xmtr_specific_status_2,
       xmtr_specific_status_3
	}
}

MENU Page_group_display_state_4
{
    LABEL  "Device status" "|de|Gertestatus";
	ITEMS
	{
       xmtr_specific_status_6,
       xmtr_specific_status_7,
       xmtr_specific_status_8
	}
}

MENU Page_display_device
{
	LABEL	  "Device"
	          "|de|Gert";
	ITEMS
	{
	   Page_group_display_device
	}
}

MENU Page_group_display_device
{
    LABEL  "";
	ITEMS
	{
	  tag                   (READ_ONLY),
	  long_tag              (READ_ONLY),
	  manufacturer_id,
	  device_type,
	  device_id,
	  erzeugnis_num_regler,
	  firmware_version,
	  final_assembly_number (READ_ONLY),
      transmitter_revision,
      universal_revision
	}
}

/* Ansicht - Messwertanzeige - Statistik **************************************/
MENU Page_display_statistic
{
	LABEL  "Statistics"
	       "|de|Statistik";
	ITEMS
	{
        Page_group_statistic_1,
        Page_group_statistic_2
	}
}

MENU Page_group_statistic_1
{
	LABEL  "";
	ITEMS
	{
	    Val_wegintegral,
	    Val_gw_wegintegral
	}
}

MENU Page_group_statistic_2
{
	LABEL  "";
	ITEMS
	{
        Val_anzahl_np
	}
}

/* Grossanzeige */
MENU Val_wegintegral
{
    LABEL "Total valve travel" "|049Wegintegral";
	ITEMS
	{
		wegintegral
	}
}

/* Grossanzeige */
MENU Val_gw_wegintegral
{
    LABEL "Limit value total valve travel" "|049Grenzwert Wegintegral";
	ITEMS
	{
		gw_wegintegral	(READ_ONLY)
	}
}

/* Grossanzeige */
MENU Val_anzahl_np
{
    LABEL "Number of zero point adjustments" "|049Anzahl Nullpunktabgleiche";
	ITEMS
	{
		anzahl_np
	}
}

/* Ansicht - Gertezustand ***************************************************/
MENU OnlineWindow_diagnosis
{
	LABEL		[menu_dialog_diagnosis];
	ITEMS
	{
		Page_display_state_1, /* Status 1 */
		Page_display_state_2, /* Status 2 */
		Page_display_device   /* Gert */
	}
    HELP "Current device status and diagnosis messages."
         "|049Aktueller Gertezustand und Diagnosemeldungen.";
}

/* Ansicht - y-t Diagram *****************************************************/
MENU OnlineWindow_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
			Page_process_yt
	}
}

MENU Page_process_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Val_yt,
		Val_yt_2,
		OCX_out_display_yt
	}
}

/* Grossanzeige */
MENU Val_yt
{
	LABEL   "Controlled variable X"
			"|de|Regelgre X";
	STYLE   "OCX_DYNAMIC_YT";
	ITEMS
	{
			regelgroesse
	}
}

/* Grossanzeige */
MENU Val_yt_2
{
    LABEL  "Reference variable W"
           "|de|Fhrungsgre W";
	STYLE  "OCX_DYNAMIC_YT";
	ITEMS
	{
			w_prozent
	}
}

MENU OCX_out_display_yt								/* OCX-Control */
{
	LABEL		[menu_yt_diagram] ;
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		/* Name, unter dem das OCX in Windows registriert ist */
	ITEMS
	{
		OCX_ProfilNum_yt,							/* Profil-Nummer */
		OCX_out_display_1,							/* 1. Kurve */
		OCX_out_display_2,							/* 2. Kurve */
		OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
	}
}

MENU OCX_out_display_1								/* 1. Kurve im OCX-Control yt */
{
	LABEL   "Controlled variable X"
			"|de|Regelgre X";
	STYLE	"OCX_DYNAMIC_YT";
	ITEMS
	{
		regelgroesse,
		dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE
	}
}

MENU OCX_out_display_2								/* 1. Kurve im OCX-Control yt */
{
    LABEL   "Reference variable W"
            "|de|Fhrungsgre W";
	STYLE	"OCX_DYNAMIC_YT";
	ITEMS
	{
		w_prozent  (READ_ONLY),
		dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE
	}
}

VARIABLE OCX_ProfilNum_yt							/* Profil-Variable fr OCX yt */
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	0;							/* Profil 0 fr normale y-t-Darstellung */
	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}

/* Ansicht - x-y Diagram (ben. Kennlinie) ************************************/
VARIABLE xMin
{
	LABEL "x" ;
	CLASS LOCAL ;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0 ;
	}
    CONSTANT_UNIT "%";
}

VARIABLE xMax
{
	LABEL "x" ;
	CLASS LOCAL ;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100 ;
	}
    CONSTANT_UNIT "%";
}

VARIABLE yMin /* Untergrenze y-Bereich */
{
	LABEL		"y";
	CLASS		LOCAL; /* CONTAINED; */
	TYPE		FLOAT
	{
		DEFAULT_VALUE 0 ;
	}
    CONSTANT_UNIT "%";
	HANDLING    READ & WRITE ;
	PRE_EDIT_ACTIONS
	{
		DEFINITION
		{
			yMin = 0 ;
		}
	}
}

VARIABLE yMax /* Obergrenze y-Bereich */
{
	LABEL		"y";
	CLASS		LOCAL; /*CONTAINED;*/
	TYPE		FLOAT
	{
		DEFAULT_VALUE 100 ;
	}
    CONSTANT_UNIT "%";
	HANDLING    READ & WRITE ;
}

MENU xvalues1 /* Liste aller x-Wert-Variablen */
{
	STYLE		"OCX_X_LIST";
    ITEMS
    {
		x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10
    }
}

MENU yvalues1 /* Liste aller y-Wert-Variablen */
{
	STYLE		"OCX_Y_LIST";
    ITEMS
    {
		y0, y1, y2, y3, y4, y5, y6, y7, y8, y9, y10
    }
}

/* OCX Trendviewer ------------------------------------------------ */
VARIABLE OCX_ProfilNum_xy		/* Profil-Variable fr OCX yx */
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	1003;
	}

	HANDLING READ;
}

VARIABLE OCX_UserSettings_xy
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}

MENU OfflineWindow_graph_xy_editable
{
	LABEL "User defined characteristics"
	      "|de|Benutzerdefinierte Kennlinie";
	ITEMS
	{
		OCX_out_display_xy,
        kennl_eingabe  ,  /* Methode */
        kennl_einlesen ,  /* Methode */
        SEPARATOR      ,
	    x0  (READ_ONLY),
	    x1  (READ_ONLY),
	    x2  (READ_ONLY),
	    x3  (READ_ONLY),
	    x4  (READ_ONLY),
	    x5  (READ_ONLY),
	    x6  (READ_ONLY),
	    x7  (READ_ONLY),
	    x8  (READ_ONLY),
	    x9  (READ_ONLY),
	    x10 (READ_ONLY),
        SEPARATOR      ,
	    y0  (READ_ONLY),
	    y1  (READ_ONLY),
	    y2  (READ_ONLY),
	    y3  (READ_ONLY),
	    y4  (READ_ONLY),
	    y5  (READ_ONLY),
	    y6  (READ_ONLY),
	    y7  (READ_ONLY),
	    y8  (READ_ONLY),
	    y9  (READ_ONLY),
	    y10 (READ_ONLY)
	}
    HELP   "Arithmetic chart and coordinates for user - defined control valve characteristic."
           "|049Grafik und Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
           "Fhrungsgre und Hub / Drehwinkel.";
}

MENU OCX_out_display_xy_1
{
	LABEL  "xy";
	STYLE  "OCX_DYNAMIC_XY";
	ITEMS
	{
        xvalues1,               /* x-values      */
        yvalues1,               /* y-values      */
        xMin    (READ_ONLY),    /* start value X */
        xMax    (READ_ONLY),    /* end value X   */
        yMin    (READ_ONLY),    /* start value Y */
        yMax    (READ_ONLY)     /* end value Y   */
	}
}

MENU OCX_out_display_xy			/* OCX-Control */
{
	LABEL  "y=f(x)" ;
/* kmr:
    SIZE-Angabe geht wohl nicht auf allen Rechnern/mit allen PDM-Versionen:
    STYLE  "PDMTVPROXY.PDMTVProxyCtrl.1" & "SIZE 50 23"; */ /* Breite x Hoehe */
	STYLE  "PDMTVPROXY.PDMTVProxyCtrl.1";
	ITEMS
	{
		OCX_ProfilNum_xy,		/* profile number */
		OCX_out_display_xy_1,	/* 1. Curve */
		OCX_UserSettings_xy		/* storing of user settings */
	}
}

/*******************************************************************************/
/* Online Dialogs                                                              */
/*******************************************************************************/

/* Gert - Betrieb ***********************************************************/
MENU OnlineDialog_operation
{
	LABEL		"Operation"
	            "|de|Betrieb";
	ITEMS
	{
		Page_operation_AUTO,
		Page_operation_MANUAL,
		Page_operation_simulation
	}
    HELP  "Manipulation and monitoring of operating parameters."
          "|049ndern und Anzeigen von Betriebsparametern.";
}

/* Gert - Betrieb - Automatik ***********************************************/
MENU Page_operation_AUTO
{
	LABEL  "Automatic"
	       "|de|Automatik";
	ITEMS
	{
        Page_group_AUTO_1,
        Page_group_AUTO_2
	}
}

MENU Page_group_AUTO_1
{
	LABEL  "";
	ITEMS
	{
		gew_betriebsart,
		akt_betriebsart
	}
}

MENU Page_group_AUTO_2
{
	LABEL  "";
	ITEMS
	{
      Val_w,
      Val_x,
      Val_e
	}
}

/* Grossanzeige */
MENU Val_w
{
    LABEL "Reference variable w" "|049Fhrungsgre w";
	ITEMS
	{
		w_prozent
	}
}

/* Grossanzeige */
MENU Val_x
{
    LABEL "Controlled variable x" "|049Regelgre x";
	ITEMS
	{
		regelgroesse
	}
}

/* Grossanzeige */
MENU Val_e
{
    LABEL "Setpoint deviation e" "|049Regeldifferenz e";
	ITEMS
	{
		regeldifferenz
	}
}

/* Gert - Betrieb - Hand ****************************************************/
MENU Page_operation_MANUAL
{
	LABEL  "Manual"
	       "|de|Hand";
	ITEMS
	{
        Page_group_MANUAL_1,
        Page_group_MANUAL_2
	}
}

MENU Page_group_MANUAL_1
{
	LABEL		"";
	ITEMS
	{
		gew_betriebsart,
		akt_betriebsart
	}
}

MENU Page_group_MANUAL_2
{
	LABEL		"";
	ITEMS
	{
	  w_hand,       /* nur in Hand sichtbar */
      Val_w,
      Val_x,
      Val_e
	}
}

/* Gert - Betrieb - Simulation **********************************************/
MENU Page_operation_simulation
{
	LABEL  "Simulation"
	       "|de|Simulation";
	ITEMS
	{
        Page_group_simulation_1,
        Page_group_simulation_2
	}
}

MENU Page_group_simulation_1
{
	LABEL  "";
	ITEMS
	{
	  met_alarm_test,     /* Methode */
	  test_stellmelder    /* nur wenn Stellmelder installiert */
	}
}

MENU Page_group_simulation_2
{
	LABEL		"";
	ITEMS
	{
	  search_device       /* Methode */
	}
}

/* Gert - Rcksetzen ********************************************************/
MENU OnlineDialog_reset
{
	LABEL  "Reset" "|de|Rcksetzen";
	HELP   [master_reset_help];
	ITEMS
	{
		Page_reset_misc,
		Page_reset_factory
	}
}

/* Gert - Rcksetzen - Verschiedenes ****************************************/
MENU Page_reset_misc
{
	LABEL  "Reset miscellaneous"
	       "|de|Rcksetzen Verschiedenes";
	ITEMS
	{
        Page_group_reset_maintenance_1,
        Page_group_reset_maintenance_2,
        Page_group_reset_maintenance_3
	}
}

MENU Page_group_reset_maintenance_1
{
	LABEL  "";
	ITEMS
	{
        wegintegral,
        reset_valve_travel_counter   /* Methode */
	}
}

MENU Page_group_reset_maintenance_2
{
	LABEL  "";
	ITEMS
	{
        xmtr_specific_status_4, /* Kaltstart ausgefhrt */
        reset_cold_start_flag
	}
}

MENU Page_group_reset_maintenance_3
{
	LABEL  "";
	ITEMS
	{
        device_status,           /* Gertezustand */
        reset_fehler,            /* Methode */
        configuration_flag_reset /* Methode Reset config change flag */
	}
}

/* Gert - Rcksetzen - Rcksetzen in Auslieferzustand ***********************/
MENU Page_reset_factory
{
	LABEL  "Factory reset"
	       "|de|Rcksetzen in Auslieferzustand";
	ITEMS
    {
        Page_group_reset_factory
	}
}

MENU Page_group_reset_factory
{
	LABEL  "";
	ITEMS
	{
        device_status,    /* Gertezustand */
		start_kaltstart   /* Methode */
	}
}

/* Gert - Selbstkalibrierung ************************************************/
MENU OnlineDialog_self_calibration
{
	LABEL	"Self calibration"
	        "|de|Selbstkalibrierung";
	HELP	"Activation of calibration sequences "
	        "(Zero point adjustment, Initialization)"
	        "|de|Aufruf von Kalibrierfunktionen "
	        "(Nullpunktabgleich, Initialisierung)";
	ITEMS
	{
        Page_self_calibration,
        Page_operation_BA
	}
}

MENU Page_operation_BA
{
	LABEL  "Mode"
	       "|de|Betriebsart";
	ITEMS
	{
        Page_group_AUTO_1,
        Page_group_AUTO_2
	}
}

MENU Page_self_calibration
{
	LABEL	"Self calibration"
	        "|de|Selbstkalibrierung";
	ITEMS
    {
        Page_group_self_calibration_1,
        Page_group_self_calibration_2
	}
}

MENU Page_group_self_calibration_1
{
	LABEL  "";
	ITEMS
	{
      akt_betriebsart,
      initialisierungsart,
      anzahl_np
	}
}

MENU Page_group_self_calibration_2
{
	LABEL  "";
	ITEMS
	{
      start_nullpunktabgleich,   /* Methode */
      start_initialisierung,     /* Methode */
      abort_init,                /* Methode */
      status_init,
      xmtr_specific_status_0,    /* Initialisierungsfehler */
      xmtr_specific_status_3,    /* Initialisierungsfehler */
      xmtr_specific_status_7     /* Fehler, die die Init. betreffen */
	}
}

/* Gert - Request-/Response Prambeln ***************************************/
MENU OnlineDialog_request_response_preambles
{
	LABEL  [menu_request_response_preambles];
	ITEMS
	{
        Page_request_response_preambles
	}
}

MENU Page_request_response_preambles
{
	LABEL  [menu_request_response_preambles];
	ITEMS
    {
        Page_group_request_response_preambles
	}
}

MENU Page_group_request_response_preambles
{
	LABEL  "";
	ITEMS
	{
        request_preambles    (READ_ONLY),
		response_preambles
	}
}

/* Gert - Schreibverriegelung ***********************************************/
MENU OnlineDialog_write_locking
{
    LABEL "HART write protection" "|049HART-Schreibschutz";
	ITEMS
	{
		hart_schreibschutz   /* HART-Schreibschutz */
	}
    HELP  "HART write protection for all HART commands."
          "|049Schreibschutz fr alle HART-Kommandos.";
}

/*******************************************************************************/
/* Table: Specialist  (Parametertabelle fr Spezialist)                        */
/*******************************************************************************/
MENU Table_Main_Specialist
{
	LABEL	"SAMSON Positioner Type 373X-3"
	        "|de|SAMSON Stellungsregler Typ 373X-3";
	ITEMS
	{
		Tab_s_ident,      /* Identifikation */
		Tab_s_pos         /* Stellungsregler */
	}
}

/* Identifikation ************************************************************/
MENU Tab_s_ident
{
	LABEL  "Identification"
	       "|de|Identifikation";
	ITEMS
	{
		Tab_s_ident_opunit,  /* Identifikation - Betriebseinheit */
		Tab_s_ident_pos      /* Identifikation - Stellungsregler */
	}
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_s_ident_opunit
{
	LABEL  "Operation unit"
	       "|de|Betriebseinheit";
	ITEMS
	{
	  tag,
	  long_tag,
	  descriptor,
	  message,
	  textfeld_1,
	  textfeld_2,
	  textfeld_3,
	  textfeld_4,
	  textfeld_5,
	  device_id,
	  erzeugnis_num_regler,
	  firmware_version,
	  final_assembly_number,
      date,
	  zertifizierung,
      universal_revision,
      transmitter_revision,
      request_preambles    (READ_ONLY)
	}
}

/* Identifikation - Stellungsregler ******************************************/
MENU Tab_s_ident_pos
{
	LABEL  "Positioner"
	       "|de|Stellungsregler";
	ITEMS
	{
      geraetetyp,               /* '3730-3' oder '3731-3' */
	  Tab_s_ident_pos_actuator, /* Identifikation - Stellungsregler - Antrieb  */
	  Tab_s_ident_pos_valve,    /* Identifikation - Stellungsregler - Ventil   */
	  Tab_s_ident_pos_add       /* Identifikation - Stellungsregler - Zusatzk. */
	}
}

/* Identifikation - Stellungsregler - Antrieb ********************************/
MENU Tab_s_ident_pos_actuator
{
	LABEL  "Actuator"
	       "|de|Antrieb";
	ITEMS
	{
	  ident_antrieb,
	  bauart,
	  anbau,
	  booster,
	  antriebswirkflaeche,
	  stelldruckbereich_anfang,
	  stelldruckbereich_ende,
	  versorgungsdruck
	}
}

/* Identifikation - Stellungsregler - Ventil *********************************/
MENU Tab_s_ident_pos_valve
{
	LABEL  "Valve"
	       "|de|Ventil";
	ITEMS
	{
      ident_ventil,
      fliessrichtung,
      stangenabdichtung,
      dichtkante,
      druckentlastung,
      kennlinie_kegel,
      nennweiten_norm,
      nennweite_dn,
      kvs_wert,
      kvs_einheit,
      sitzdurchmesser_ventil
	}
}

/* Identifikation - Stellungsregler - Zusatzkomponente ***********************/
MENU Tab_s_ident_pos_add
{
	LABEL  "Additional component"
	       "|de|Zusatzkomponente";
	ITEMS
	{
	  magnetventil,
	  stellungsmelder,
	  wirkr_stellmelder,
	  ind_grenzkontakt
	}
}

/* Stellungsregler ***********************************************************/
MENU Tab_s_pos
{
	LABEL  "Positioner"
	       "|de|Stellungsregler";
	ITEMS
	{
		Tab_s_pos_refvar,
		Tab_s_pos_workrange,
		Tab_s_pos_charact,
		Tab_s_pos_perf,
		Tab_s_pos_failsafe,
		Tab_s_pos_error,
		Tab_s_pos_startup,
		Tab_s_pos_maint
	}
}

/* Stellungsregler - Fuehrungsgroesse ****************************************/
MENU Tab_s_pos_refvar
{
	LABEL  "Reference variable"
	       "|de|Fhrungsgre";
	ITEMS
	{
	  bewegungsrichtung,
	  w_ma_bereich_anfang,
      w_ma_bereich_ende,
      aktiv_endlage_w_kleiner,
      endlage_w_kleiner,
      aktiv_endlage_w_groesser,
      endlage_w_groesser,
      gew_laufzeit_auf,
      gew_laufzeit_zu
	}
}

/* Stellungsregler - Arbeitsbereich ******************************************/
MENU Tab_s_pos_workrange
{
	LABEL  "Working range"
	       "|de|Arbeitsbereich";
	ITEMS
	{
	  x_bereich_anfang,
	  x_bereich_ende,
	  aktiv_x_begrenzung_unten,
	  x_begrenzung_unten,
	  aktiv_x_begrenzung_oben,
	  x_begrenzung_oben
	}
}

/* Stellungsregler - Kennlinie ***********************************************/
MENU Tab_s_pos_charact
{
	LABEL  "Characteristic"
	       "|de|Kennlinie";
	ITEMS
	{
      kennlinienauswahl,
	  kennlinientyp,
	  x0  (READ_ONLY), /* Werte werden per Methode geschrieben */
	  x1  (READ_ONLY),
	  x2  (READ_ONLY),
	  x3  (READ_ONLY),
	  x4  (READ_ONLY),
	  x5  (READ_ONLY),
	  x6  (READ_ONLY),
	  x7  (READ_ONLY),
	  x8  (READ_ONLY),
	  x9  (READ_ONLY),
	  x10 (READ_ONLY),
	  y0  (READ_ONLY),
	  y1  (READ_ONLY),
	  y2  (READ_ONLY),
	  y3  (READ_ONLY),
	  y4  (READ_ONLY),
	  y5  (READ_ONLY),
	  y6  (READ_ONLY),
	  y7  (READ_ONLY),
	  y8  (READ_ONLY),
	  y9  (READ_ONLY),
	  y10 (READ_ONLY)
	}
}

/* Stellungsregler - Kennwerte ***********************************************/
MENU Tab_s_pos_perf
{
	LABEL  "Performance characteristic"
	       "|de|Kennwerte";
	ITEMS
	{
	  kp_stufe,
	  tv_stufe
	}
}

/* Stellungsregler - Ausfallverhalten ****************************************/
MENU Tab_s_pos_failsafe
{
	LABEL  "Fail safe action"
	       "|de|Ausfallverhalten";
	ITEMS
	{
      sicherheitsstellung
	}
}

/* Stellungsregler - Fehlerberwachung ***************************************/
MENU Tab_s_pos_error
{
	LABEL  "Error control"
	       "|de|Fehlerberwachung";
	ITEMS
	{
	  toleranzband,
	  nachlaufzeit,
	  wegintegral,
	  gw_wegintegral,
      alarmmodus,
      aktiv_gw_a1,
      grenzwert_a1,
      aktiv_gw_a2,
      grenzwert_a2,
	  stoerm_sonderfunktion,
	  stoerm_wegintegral,
	  stoerm_mit_stellmelder /* wenn Stellmelder vorhanden */
	}
}

/* Stellungsregler - Inbetriebnahme ******************************************/
MENU Tab_s_pos_startup
{
	LABEL  "Start-up"
	       "|de|Inbetriebnahme";
	ITEMS
	{
      leserichtung,
      stiftposition,
      initialisierungsart,
      druckgrenze,
      nennbereich,
      min_laufzeit_auf,
      min_laufzeit_zu,
      sicherheitsstellung,
      geraet_ini,
      Tab_s_pos_startup_sub
	}
}

/* Stellungsregler - Inbetriebnahme - Ersatzabgleich *************************/
MENU Tab_s_pos_startup_sub
{
	LABEL  "Substitution"
	       "|de|Ersatzabgleich";
	ITEMS
	{
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */
	  schliessrichtung,
	  blockierstellung
	}
}

/* Stellungsregler - Wartung / Diagnose **************************************/
MENU Tab_s_pos_maint
{
	LABEL  "Maintenance / diagnosis"
	       "|de|Wartung / Diagnose";
	ITEMS
	{
      geraet_ini, /* Gert initialisiert */
      geraetesperre,
      sicherheitsstellung,
      anzahl_np
	}
}

/*******************************************************************************/
/* Table: Maintenance  (Parametertabelle fr Instandhalter)                    */
/*******************************************************************************/
MENU Table_Main_Maintenance
{
	LABEL "SAMSON Positioner Type 373X-3"
	      "|de|SAMSON Stellungsregler Typ 373X-3";
	ITEMS
	{
		Tab_m_ident,      /* Identifikation */
		Tab_m_pos         /* Stellungsregler */
	}
}

/* Identifikation ************************************************************/
MENU Tab_m_ident
{
	LABEL  "Identification"
	       "|de|Identifikation";
	ITEMS
	{
		Tab_m_ident_opunit,  /* Identifikation - Betriebseinheit */
		Tab_m_ident_pos      /* Identifikation - Stellungsregler */
	}
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_m_ident_opunit
{
	LABEL  "Operation unit"
	       "|de|Betriebseinheit";
	ITEMS
	{
	  tag,
	  long_tag,
	  descriptor,
	  message,
	  textfeld_1,
	  textfeld_2,
	  textfeld_3,
	  textfeld_4,
	  textfeld_5,
	  device_id,
	  erzeugnis_num_regler,
	  firmware_version,
	  final_assembly_number,
      date,
	  zertifizierung,
      universal_revision,
      transmitter_revision,
      request_preambles    (READ_ONLY)
	}
}

/* Identifikation - Stellungsregler ******************************************/
MENU Tab_m_ident_pos
{
	LABEL  "Positioner"
	       "|de|Stellungsregler";
	ITEMS
	{
      geraetetyp,               /* '3730-3' oder '3731-3' */
	  Tab_m_ident_pos_actuator, /* Identifikation - Stellungsregler - Antrieb  */
	  Tab_m_ident_pos_valve,    /* Identifikation - Stellungsregler - Ventil   */
	  Tab_m_ident_pos_add       /* Identifikation - Stellungsregler - Zusatzk. */
	}
}

/* Identifikation - Stellungsregler - Antrieb ********************************/
MENU Tab_m_ident_pos_actuator
{
	LABEL  "Actuator"
	       "|de|Antrieb";
	ITEMS
	{
	  ident_antrieb,
	  bauart,
	  anbau,
	  booster,
	  antriebswirkflaeche,
	  stelldruckbereich_anfang,
	  stelldruckbereich_ende,
	  versorgungsdruck
	}
}

/* Identifikation - Stellungsregler - Ventil *********************************/
MENU Tab_m_ident_pos_valve
{
	LABEL  "Valve"
	       "|de|Ventil";
	ITEMS
	{
/* von Spezialistenebene: */
/* 4 x READ_ONLY bei Instandhalter: */
      stiftposition       (READ_ONLY),
      initialisierungsart (READ_ONLY),
      druckgrenze         (READ_ONLY),
      nennbereich         (READ_ONLY),
      min_laufzeit_auf,
      min_laufzeit_zu,
      sicherheitsstellung,
      geraet_ini,
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */
	  schliessrichtung,
	  blockierstellung,
/* Ende: von Spezialistenebene */
      ident_ventil,
      fliessrichtung,
      stangenabdichtung,
      dichtkante,
      druckentlastung,
      kennlinie_kegel,
      nennweiten_norm,
      nennweite_dn,
      kvs_wert,
      kvs_einheit,
      sitzdurchmesser_ventil
	}
}

/* Identifikation - Stellungsregler - Zusatzkomponente ***********************/
MENU Tab_m_ident_pos_add
{
	LABEL  "Additional component"
	       "|de|Zusatzkomponente";
	ITEMS
	{
	  magnetventil,
	  stellungsmelder,
	  wirkr_stellmelder,
	  ind_grenzkontakt
	}
}

/* Stellungsregler ***********************************************************/
MENU Tab_m_pos
{
	LABEL  "Positioner"
	       "|de|Stellungsregler";
	ITEMS
	{
		Tab_m_pos_refvar,
		Tab_m_pos_workrange,
		Tab_m_pos_charact,
		Tab_m_pos_perf,
		Tab_m_pos_failsafe,
/* kmr: nicht bei Instandhalter:
		Tab_m_pos_error,
		Tab_m_pos_startup, */
		Tab_m_pos_maint
	}
}

/* Stellungsregler - Fuehrungsgroesse ****************************************/
MENU Tab_m_pos_refvar
{
	LABEL  "Reference variable"
	       "|de|Fhrungsgre";
	ITEMS
	{
	  bewegungsrichtung,
	  w_ma_bereich_anfang,
      w_ma_bereich_ende
/* kmr: nicht bei Instandhalter:
      aktiv_endlage_w_kleiner,
      endlage_w_kleiner,
      aktiv_endlage_w_groesser,
      endlage_w_groesser,
      gew_laufzeit_auf,
      gew_laufzeit_zu */
	}
}

/* Stellungsregler - Arbeitsbereich ******************************************/
MENU Tab_m_pos_workrange
{
	LABEL  "Working range"
	       "|de|Arbeitsbereich";
	ITEMS
	{
	  x_bereich_anfang,
	  x_bereich_ende,
	  aktiv_x_begrenzung_unten,
	  x_begrenzung_unten,
	  aktiv_x_begrenzung_oben,
	  x_begrenzung_oben
	}
}

/* Stellungsregler - Kennlinie ***********************************************/
MENU Tab_m_pos_charact
{
	LABEL  "Characteristic"
	       "|de|Kennlinie";
	ITEMS
	{
      kennlinienauswahl,
	  kennlinientyp (READ_ONLY),
	  x0  (READ_ONLY), /* Werte werden per Methode geschrieben */
	  x1  (READ_ONLY),
	  x2  (READ_ONLY),
	  x3  (READ_ONLY),
	  x4  (READ_ONLY),
	  x5  (READ_ONLY),
	  x6  (READ_ONLY),
	  x7  (READ_ONLY),
	  x8  (READ_ONLY),
	  x9  (READ_ONLY),
	  x10 (READ_ONLY),
	  y0  (READ_ONLY),
	  y1  (READ_ONLY),
	  y2  (READ_ONLY),
	  y3  (READ_ONLY),
	  y4  (READ_ONLY),
	  y5  (READ_ONLY),
	  y6  (READ_ONLY),
	  y7  (READ_ONLY),
	  y8  (READ_ONLY),
	  y9  (READ_ONLY),
	  y10 (READ_ONLY)
	}
}

/* Stellungsregler - Kennwerte ***********************************************/
MENU Tab_m_pos_perf
{
	LABEL  "Performance characteristic"
	       "|de|Kennwerte";
	ITEMS
	{
	  kp_stufe,
	  tv_stufe
	}
}

/* Stellungsregler - Ausfallverhalten ****************************************/
MENU Tab_m_pos_failsafe
{
	LABEL  "Fail safe action"
	       "|de|Ausfallverhalten";
	ITEMS
	{
      sicherheitsstellung
	}
}

/* Stellungsregler - Fehlerberwachung ***************************************/
MENU Tab_m_pos_error
{
	LABEL  "Error control"
	       "|de|Fehlerberwachung";
	ITEMS
	{
	  toleranzband,
	  nachlaufzeit,
	  wegintegral,
	  gw_wegintegral,
      alarmmodus,
      aktiv_gw_a1,
      grenzwert_a1,
      aktiv_gw_a2,
      grenzwert_a2,
	  stoerm_sonderfunktion,
	  stoerm_wegintegral,
	  stoerm_mit_stellmelder /* wenn Stellmelder vorhanden */
	}
}

/* Stellungsregler - Inbetriebnahme ******************************************/
MENU Tab_m_pos_startup
{
	LABEL  "Start-up"
	       "|de|Inbetriebnahme";
	ITEMS
	{
      leserichtung,
      stiftposition,
      initialisierungsart,
      druckgrenze,
      nennbereich,
      min_laufzeit_auf,
      min_laufzeit_zu,
      sicherheitsstellung,
      geraet_ini,
      Tab_m_pos_startup_sub
	}
}

/* Stellungsregler - Inbetriebnahme - Ersatzabgleich *************************/
MENU Tab_m_pos_startup_sub
{
	LABEL  "Substitution"
	       "|de|Ersatzabgleich";
	ITEMS
	{
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */
	  schliessrichtung,
	  blockierstellung
	}
}

/* Stellungsregler - Wartung / Diagnose **************************************/
MENU Tab_m_pos_maint
{
	LABEL  "Maintenance / diagnosis"
	       "|de|Wartung / Diagnose";
	ITEMS
	{
      geraet_ini, /* Gert initialisiert */
      geraetesperre,
      sicherheitsstellung,
      anzahl_np
	}
}

/*******************************************************************************/
/* Upload / Download Menu                                                      */
/*******************************************************************************/
MENU upload_variables  /* Schreiben ins Feldgert */
{
	LABEL [menu_load_to_device];
	ITEMS
	{
      leserichtung                 ,
      stiftposition                ,
      nennbereich                  ,
      /* nur Schreiben wenn Regler NICHT initialisiert UND
         Initialisierungsart = Ersatzabgleich */
      IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))
      {
        schliessrichtung           ,
        blockierstellung           ,
      }
      initialisierungsart          ,
      bewegungsrichtung            ,
      x_bereich_anfang             ,
      x_bereich_ende               ,
      aktiv_x_begrenzung_unten     ,
      x_begrenzung_unten           ,
      aktiv_x_begrenzung_oben      ,
      x_begrenzung_oben            ,
      w_ma_bereich_anfang          ,
      w_ma_bereich_ende            ,
      aktiv_endlage_w_kleiner      ,
      endlage_w_kleiner            ,
      aktiv_endlage_w_groesser     ,
      endlage_w_groesser           ,
      druckgrenze                  ,
      toleranzband                 ,
      kennlinienauswahl            ,
      gew_laufzeit_auf             ,
      gew_laufzeit_zu              ,
      gw_wegintegral               ,
      alarmmodus                   ,
      /* nur Schreiben wenn ind. Grenzkontakt nicht eingebaut */
      IF (ind_grenzkontakt == NOT_IMPLEMENTED)
      {
        aktiv_gw_a1                ,
        grenzwert_a1               ,
      }
      aktiv_gw_a2                  ,
      grenzwert_a2                 ,
      /* nur Schreiben wenn Stellungsmelder eingebaut */
      IF (stellungsmelder == 1)
      {
        wirkr_stellmelder          ,
        stoerm_mit_stellmelder     ,
      }
      stoerm_sonderfunktion        ,
      stoerm_wegintegral           ,
      tag                          ,
      textfeld_1                   ,
      textfeld_2                   ,
      textfeld_3                   ,
      textfeld_4                   ,
      textfeld_5                   ,
      nachlaufzeit                 ,
      ident_antrieb                ,
      booster                      ,
      antriebswirkflaeche          ,
      stelldruckbereich_anfang     ,
      stelldruckbereich_ende       ,
      versorgungsdruck             ,
      ident_ventil                 ,
      fliessrichtung               ,
      stangenabdichtung            ,
      dichtkante                   ,
      druckentlastung              ,
      kennlinie_kegel              ,
      nennweiten_norm              ,
      nennweite_dn                 ,
      kvs_einheit                  ,
      kvs_wert                     ,
      sitzdurchmesser_ventil       ,
      descriptor                   ,
      message                      ,
      kennlinientyp                ,
      date                         ,
      final_assembly_number        ,
      long_tag                     ,
      ueberwachungszeit            ,
      bauart                       ,
      anbau                        ,
	  geraetesperre
	}
}

/*****************************************************************************/
MENU download_variables  /* Lesen aus Feldgert */
{
    LABEL [menu_load_to_PC];
    ITEMS
    {
	  tag,
	  long_tag,
	  descriptor,
	  message,
	  textfeld_1,
	  textfeld_2,
	  textfeld_3,
	  textfeld_4,
	  textfeld_5,
	  device_id,
	  erzeugnis_num_regler,
	  firmware_version,
	  final_assembly_number,
      date,
      universal_revision,
      transmitter_revision,
      request_preambles,
	  device_type,
	  geraetetyp,
	  ident_antrieb,
      stiftposition,
	  bauart,
	  anbau,
	  booster,
	  antriebswirkflaeche,
	  stelldruckbereich_anfang,
	  stelldruckbereich_ende,
	  versorgungsdruck,
      ident_ventil,
      fliessrichtung,
      stangenabdichtung,
      dichtkante,
      druckentlastung,
      kennlinie_kegel,
      nennweiten_norm,
      nennweite_dn,
      kvs_wert,
      kvs_einheit,
      sitzdurchmesser_ventil,
	  magnetventil,
	  stellungsmelder,
	  wirkr_stellmelder,
	  ind_grenzkontakt,
	  bewegungsrichtung,
	  w_ma_bereich_anfang,
      w_ma_bereich_ende,
      aktiv_endlage_w_kleiner,
      endlage_w_kleiner,
      aktiv_endlage_w_groesser,
      endlage_w_groesser,
      gew_laufzeit_auf,
      gew_laufzeit_zu,
	  x_bereich_anfang,
	  x_bereich_ende,
	  aktiv_x_begrenzung_unten,
	  x_begrenzung_unten,
	  aktiv_x_begrenzung_oben,
	  x_begrenzung_oben,
	  kennlinienauswahl,
	  kennlinientyp,
	  x0,
	  x1,
	  x2,
	  x3,
	  x4,
	  x5,
	  x6,
	  x7,
	  x8,
	  x9,
	  x10,
	  y0,
	  y1,
	  y2,
	  y3,
	  y4,
	  y5,
	  y6,
	  y7,
	  y8,
	  y9,
	  y10,
	  kp_stufe,
	  tv_stufe,
      sicherheitsstellung,
	  toleranzband,
	  nachlaufzeit,
	  wegintegral,
	  gw_wegintegral,
      alarmmodus,
      aktiv_gw_a1,
      grenzwert_a1,
      aktiv_gw_a2,
      grenzwert_a2,
	  stoerm_sonderfunktion,
	  stoerm_wegintegral,
	  stoerm_mit_stellmelder,
      leserichtung,
      initialisierungsart,
      druckgrenze,
      nennbereich,
      min_laufzeit_auf,
      min_laufzeit_zu,
      sicherheitsstellung,
      geraet_ini,
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */
	  schliessrichtung,
	  blockierstellung,
	  geraetesperre,
	  anzahl_np,
	  zertifizierung
    }
}
/*** ENDE **********************************************************************/
