/*****************************************************************************
 *
 * $Workfile: macros.h $
 * $Revision: 4 $
 *     $Date: 3/29/04 3:21p $
 *   $Author: Wallyp $
 *
 *****************************************************************************
 * Copyright (c) 2002, HART Communication Foundation, All Rights Reserved
 *****************************************************************************
 *
 * Description: HART Device Description Macro Definitions
 *
 *****************************************************************************
 *
 *   $History: macros.h $
 * 
 * *****************  Version 4  *****************
 * User: Wallyp       Date: 3/29/04    Time: 3:21p
 * Updated in $/h6.std.dds
 * #ifdef's for host applications (e.g., HC275) removed
 * 
 * *****************  Version 3  *****************
 * User: Wallyp       Date: 6/02/03    Time: 12:04p
 * Updated in $/h6.std.dds
 * added TRIM_POINT_CODES, DEVICE_VARIABLE_FAMILY_CODES macros
 * 
 * *****************  Version 2  *****************
 * User: Wallyp       Date: 3/05/03    Time: 12:18p
 * Updated in $/h6.std.dds
 * 1.  fixed syntax errors
 * 2. added ANALOG_CHANNEL, RANGE macros
 * 
 * *****************  Version 1  *****************
 * User: Wallyp       Date: 11/02/02   Time: 4:51p
 * Created in $/h6.std.dds
 * initial check into vss
 * 
 *****************************************************************************
 */

#define USER_INTERFACE LOCAL
#define LOCAL_INTERFACE LOCAL_DISPLAY
#define ANALOG_CHANNEL ANALOG_OUTPUT
#define RANGE INPUT

#define I_NO_COMMAND_SPECIFIC_ERRORS     0
#define I_INVALID_SELECTION              2
#define I_PARAMETER_TOO_LARGE            3
#define I_PARAMETER_TOO_SMALL            4
#define I_TOO_FEW_DATA_BYTES             5
#define I_TRANSMITTER_SPECIFIC_ERROR     6
#define I_IN_WRITE_PROTECT_MODE          7
#define I_ACCESS_RESTRICTED             16

/*
 * Strings for the single definition response codes.
 */

#define S_NO_COMMAND_SPECIFIC_ERRORS [no_command_specific_errors]
#define S_INVALID_SELECTION [invalid_selection]
#define S_PARAMETER_TOO_LARGE [passed_parameter_too_large]
#define S_PARAMETER_TOO_SMALL [passed_parameter_too_small]
#define S_TOO_FEW_DATA_BYTES [too_few_data_bytes_recieved]
#define S_TRANSMITTER_SPECIFIC_ERROR [xmtr_specific_command_error]
#define S_IN_WRITE_PROTECT_MODE [in_write_protect_mode]
#define S_ACCESS_RESTRICTED [access_restricted]

#define PRIMARY         0
#define SECONDARY       1
#define TERTIARY        2
#define QUATERNARY      3

#define PV  dynamic_variables[PRIMARY]
#define SV  dynamic_variables[SECONDARY]
#define TV  dynamic_variables[TERTIARY]
#define QV  dynamic_variables[QUATERNARY]

/*
 * Common table references.
 */

#define ROSEMOUNT_MODEL_CODE(N) { N, rosemount_model_code(N) }
#define ROSEMOUNT_ANALYTICAL_MODEL_CODE(N) { N, rosemount_analytical_model_code(N) }
#define KAYRAY_MODEL_CODE(N) { N, kayray_model_code(N) }
#define MICRO_MOTION_MODEL_CODE(N) { N, micro_motion_model_code(N) }
#define UNITS_CODE(N) { N, units_code(N) }
#define TRANSFER_FUNCTION_CODE(N) { N, transfer_function_code(N) }
#define MATERIAL_CODE(N) { N, material_code(N) }
#define ALARM_SELECTION_CODE(N) { N, alarm_selection_code(N) }
#define WRITE_PROTECT_CODE(N) { N, write_protect_code(N) }
#define COMPANY_IDENTIFICATION_CODE(N) { N, company_identification_code(N) }
#define BURST_MODE_CONTROL_CODE(N) { N, burst_mode_control_code(N) }
#define PHYSICAL_SIGNALING_CODE(N) { N, physical_signaling_codes(N) }
#define FLAG_ASSIGNMENT(N) { N, flag_assignment(N) }
#define OPERATING_MODE_CODE(N) { N, operating_mode_code(N) }
#define ANALOG_OUTPUT_NUMBERS_CODE(N) { N, analog_output_numbers_code(N) }
#define LOOP_CURRENT_MODE_CODE(N)  { N, loop_current_mode_codes(N) }
#define EXTENDED_DEVICE_STATUS_CODE(N)  { N, extended_device_status_codes(N)}
#define TRIM_POINT_CODES(N)   { N, trim_point_codes(N) }
#define DEVICE_VARIABLE_FAMILY_CODES(N)  { N, device_variable_family_codes(N)}
#define DEVICE_VARIABLE_CLASSIFICATION_CODES(N)  { N, device_variable_classification_codes(N)}


#define PROCESS_DATA_STATUS_CODES \
        {0 , process_data_status(0)}, \
        {1 , process_data_status(1)}, \
        {2 , process_data_status(2)}, \
        {3 , process_data_status(3)}

#define LIMIT_STATUS_CODES \
        {0 , limit_status(0)}, \
        {1 , limit_status(1)}, \
        {2 , limit_status(2)}, \
        {3 , limit_status(3)}

/*
 * The reply message of an identify request is defined here as a macro because
 * the same reply is returned by command 0,11,21,73 and 75 (the identify commands).
 */
#define IDENTIFY_REPLY \
    response_code, device_status, 254, manufacturer_id, device_type, \
    request_preambles, universal_revision, transmitter_revision, \
    software_revision, hardware_revision <0xf8>, physical_signaling_code <0x07>, \
    device_flags, device_id, response_preambles, max_num_device_variables, \
    config_change_counter, extended_fld_device_status


#define ALL_UNITS  \
        UNITS_CODE (1), \
        UNITS_CODE (2), \
        UNITS_CODE (3), \
        UNITS_CODE (4), \
        UNITS_CODE (5), \
        UNITS_CODE (6), \
        UNITS_CODE (7), \
        UNITS_CODE (8), \
        UNITS_CODE (9), \
        UNITS_CODE (10), \
        UNITS_CODE (11), \
        UNITS_CODE (12), \
        UNITS_CODE (13), \
        UNITS_CODE (14), \
        UNITS_CODE (15), \
        UNITS_CODE (16), \
        UNITS_CODE (17), \
        UNITS_CODE (18), \
        UNITS_CODE (19), \
        UNITS_CODE (20), \
        UNITS_CODE (21), \
        UNITS_CODE (22), \
        UNITS_CODE (23), \
        UNITS_CODE (24), \
        UNITS_CODE (25), \
        UNITS_CODE (26), \
        UNITS_CODE (27), \
        UNITS_CODE (28), \
        UNITS_CODE (29), \
        UNITS_CODE (30), \
        UNITS_CODE (31), \
        UNITS_CODE (32), \
        UNITS_CODE (33), \
        UNITS_CODE (34), \
        UNITS_CODE (35), \
        UNITS_CODE (36), \
        UNITS_CODE (37), \
        UNITS_CODE (38), \
        UNITS_CODE (39), \
        UNITS_CODE (40), \
        UNITS_CODE (41), \
        UNITS_CODE (42), \
        UNITS_CODE (43), \
        UNITS_CODE (44), \
        UNITS_CODE (45), \
        UNITS_CODE (46), \
        UNITS_CODE (47), \
        UNITS_CODE (48), \
        UNITS_CODE (49), \
        UNITS_CODE (50), \
        UNITS_CODE (51), \
        UNITS_CODE (52), \
        UNITS_CODE (53), \
        UNITS_CODE (54), \
        UNITS_CODE (55), \
        UNITS_CODE (56), \
        UNITS_CODE (57), \
        UNITS_CODE (58), \
        UNITS_CODE (59), \
        UNITS_CODE (60), \
        UNITS_CODE (61), \
        UNITS_CODE (62), \
        UNITS_CODE (63), \
        UNITS_CODE (64), \
        UNITS_CODE (65), \
        UNITS_CODE (70), \
        UNITS_CODE (71), \
        UNITS_CODE (72), \
        UNITS_CODE (73), \
        UNITS_CODE (74), \
        UNITS_CODE (75), \
        UNITS_CODE (76), \
        UNITS_CODE (77), \
        UNITS_CODE (78), \
        UNITS_CODE (79), \
        UNITS_CODE (80), \
        UNITS_CODE (81), \
        UNITS_CODE (82), \
        UNITS_CODE (83), \
        UNITS_CODE (84), \
        UNITS_CODE (85), \
        UNITS_CODE (86), \
        UNITS_CODE (87), \
        UNITS_CODE (88), \
        UNITS_CODE (90), \
        UNITS_CODE (91), \
        UNITS_CODE (92), \
        UNITS_CODE (93), \
        UNITS_CODE (94), \
        UNITS_CODE (95), \
        UNITS_CODE (96), \
        UNITS_CODE (97), \
        UNITS_CODE (98), \
        UNITS_CODE (99), \
        UNITS_CODE (100), \
        UNITS_CODE (101), \
        UNITS_CODE (102), \
        UNITS_CODE (103), \
        UNITS_CODE (104), \
        UNITS_CODE (105), \
        UNITS_CODE (106), \
        UNITS_CODE (107), \
        UNITS_CODE (108), \
        UNITS_CODE (109), \
        UNITS_CODE (110), \
        UNITS_CODE (111), \
        UNITS_CODE (112), \
        UNITS_CODE (113), \
        UNITS_CODE (120), \
        UNITS_CODE (130), \
        UNITS_CODE (131), \
        UNITS_CODE (132), \
        UNITS_CODE (133), \
        UNITS_CODE (134), \
        UNITS_CODE (135), \
        UNITS_CODE (136), \
        UNITS_CODE (137), \
        UNITS_CODE (138), \
        UNITS_CODE (150), \
        UNITS_CODE (151), \
        UNITS_CODE (152), \
        UNITS_CODE (153), \
        UNITS_CODE (160), \
        UNITS_CODE (235), \
        UNITS_CODE (236), \
        UNITS_CODE (237), \
        UNITS_CODE (238), \
        UNITS_CODE (239), \
        UNITS_CODE (250), \
        UNITS_CODE (251), \
        UNITS_CODE (252), \
        UNITS_CODE (253)

/*
 * Miscellaneous macros.
 */

#ifdef __GNUC__
#define LOCALVAR( x) #x     /*this is used by the get_local_var commands*/
#else
#define LOCALVAR( x) "x"
#endif


