/******************************************************************************/
/* DD for SAMSON Positioner 373x-3 EXPERT+ HART capable                       */
/******************************************************************************/
/* SAMSON AG Mess- und Regeltechnik                                           */
/* Weismuellerstrasse 3                                                       */
/* 60314 Frankfurt                                                            */
/* Germany                                                                    */
/* Tel.: (++49) 69 4009 0     Fax: (++49) 69 4009 1507                        */
/* Internet: http://www.samson.de                                             */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2008). All Rights Reserved                       */
/* Device:        SAMSON Positioner 373x-3 HART capable EXPERT FW 1.51 Rev 6  */
/******************************************************************************/
/* Autor: Thomas Kraemer / E82                                                */
/* Datei: SAHA_373X_3_r6d1.ddl                                                */
/******************************************************************************/
/* Datum:     Autor:  Aenderungen:                                            */
/* ------     ------  ------------                                            */
/* 31.01.2008 Kmr/E82 - Revision 6: Parameter fuer 1.51 ergaenzt              */
/*                      DD gilt fuer 3730-3 / 3731-3 FW 1.51  Device Rev 6    */
/* 11.06.2008 Kmr/E82 - 6.1.002: Anpassungen an PDM                           */
/*                    - einige PRE_WRITE_ACTIONS entfernt und dafr           */
/*                      SCALING_FACTOR reingemacht                            */
/* 10.07.2008 Kmr/E82 - 6.1.004: Parameter 'Konfiguration Binreingang'       */
/*                      implementiert. Neue EXPERT+ EB integriert.            */
/* 25.09.2008 Kmr/E82 - 6.1.005: Parameter lower_end_position_bsz_1 und       */
/*                      elapsed_hours_meter_1 .. 30 : statt Methode           */
/*                      convert_time_to_h, SCALING_FACTOR verwendet           */
/* 05.11.2008 Kmr/E82  6.1.006: Hilfetext 'Abs. Wegintegral' gendert.        */
/* 26.01.2009 Kmr/E82  6.1.007: Messdaten O/C dynamisch gemacht.              */
/* 02.03.2009 Kmr/E82  6.1.008: OnlineWindow_ statt OnlineDialog_ ,           */
/*                     dadurch mehr nicht modale Fenster.                     */
/* 12.07.2011 Kmr/E82  fr Siemens in SAHA_373X_3_r6d1_para.dd                */
/*                     'else' statt 'else if' gendert                        */
/* 08.10.2012 Kmr/E82 6.1.011: FW 1.55 untersttzt:                           */
/*                    - VARIABLE stiftposition: '300mm' ergnzt               */
/*                    - VARIABLE ident_optionen: 'x-Input 4..20mA' ergnzt    */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

MANUFACTURER	     66,   /* SAMSON AG, Frankfurt, Germany  */
DEVICE_TYPE		    239,   /* Positioner 373X-3 HART capable */
DEVICE_REVISION     6,   /* Device Revision 6 (EXPERT/EXPERT+/PST FW from 1.51) */
DD_REVISION         1    /* Device Description Revision 1 */


/*****************************************************************************/
/* fr Methode method_PDM_StandardDiagnosis: */
#define PDM_DIAG_FAULT                0x0001
#define PDM_DIAG_MAINT_REQUIRED       0x0002
#define PDM_DIAG_MAINT_RECOMMENDED    0x0004
#define PDM_DIAG_PROCESS_ERROR				0x0010
#define PDM_DIAG_CONFIG_ERROR				  0x0020
#define PDM_DIAG_SIMULATION					  0x0040
#define PDM_DIAG_GOOD						      0x0008
/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS   0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS                0xFFF7  /* Lsche GOOD */
/*****************************************************************************/

/* fr Methode methodOpenDeviceManual_3730: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3730 "e83843en.pdf"        \
                                    "|de|e83843de.pdf"    \
                                    "|fr|e83843fr.pdf"    \
                                    "|it|e83843it.pdf"    \
                                    "|nl|e83843nl.pdf"    \
                                    "|ru|e83843ru.pdf"    \
                                    "|zh|e83843zh.pdf"

/* fr Methode methodOpenDeviceManual_3731: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3731 "e83873en.pdf"        \
                                    "|de|e83873de.pdf"    \
                                    "|it|e83873it.pdf"    \
                                    "|ru|e83873ru.pdf"

/* fr Methode methodOpenValveDiagnostics: Ventildiagnose fr FW 1.52 Doku im pdf-Format */
#define VALVE_DIAGNOSTICS_FILENAME "e83890de.pdf"         \
                                   "|de|e83890de.pdf"

//*****************************************************************************

// PDM includes
#include "macros.h"
#include "methods.h"

// PDM Diagnose:
#include "Diagnosis.inc"

// fr enhanced DD (Tokenizer 6):
#define only_with_enhanced_ddl

// fr read/write Methoden nur in enhanced DD SAHA_373X_3_r6d1_menu.dd:
//#define only_with_read_write_buttons
//#include "SAM373X_3_r6d1_rwm.dd"

// definieren wenn Zahlen statt Texte bei messages_1..30:
//#define only_with_numbers_at_messages_xx
    
// damit PST-/FST-Zeilen im Men ein-/ausgeschaltet werden:
#define pst_stepresponse
#define fst_stepresponse
// definieren wenn Graph Statische Kennlinie erwnscht:
#define mit_static_characteristic_graph

#include "SAHA_373X_3_r6d1_para.dd"

// nicht enhanced (Tokenizer 5) Men-Datei:
//#include "SAM373X_r6d1_menu_t5.dd"
// enhanced (Tokenizer 6) Men-Datei:
#include "SAHA_373X_3_r6d1_menu.dd"

#include "SAHA_373X_3_r6d1_cmd.dd"

#include "datalogger_para.dd"
#include "datalogger_graph.dd"

// definieren wenn e graph erwnscht:
//#define mit_pst_e_graph
#include "pst_stepresp_para.dd"
#include "pst_stepresp_graph.dd"

// definieren wenn e graph erwnscht:
//#define mit_fst_e_graph
#include "fst_stepresp_para.dd"
#include "fst_stepresp_graph.dd"

/* ----------- the end ---------------------------------------------------- */
