/******************************************************************************/
/* DD for EXPERT+ Parameter SAMSON Positioner 373x-3                          */
/******************************************************************************/
/* SAMSON AG Mess- und Regeltechnik                                           */
/* Weismuellerstrasse 3                                                       */
/* 60314 Frankfurt                                                            */
/* Germany                                                                    */
/* Tel.: (++49) 69 4009 0     Fax: (++49) 69 4009 1507                        */
/* Internet: http://www.samson.de                                             */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2004). All Rights Reserved                       */
/* Device:        SAMSON Positioner 373x-3 HART capable EXPERT+  from FW 1.40 */
/******************************************************************************/
/* Datum:     Autor:   Aenderungen:                                           */
/* ------     ------   ------------                                           */
/* 06.02.2004 kmr/E42  Diagnoseparameter erstmals definiert.                  */
/*                     Defines fuer Parameterbekanntgabe in DD erstellt.      */
/* 29.03.2004 kmr/E42  Aenderungen abgearbeitet:                              */
/*            1.1.1  Betriebsstundenzaehler                                   */
/*            1.1.3  Protokollierungszuordnung erweitert                      */
/*            1.2    NAMUR-Counter eingefuehrt                                */
/*            2.1    Datenlogger - zusaetzliche long Zeiten eingefuehrt       */
/*            2.4    Histogramm Zyklenzaehler - Adressaenderung vom Mittelwert*/
/*                   der Kurzzeitbetrachtung gendert                         */
/*            2.5    Temperatursensor                                         */
/*            2.6    Stellsignal Y - Stationaer Adressaenderung durchgefuehrt */
/*            2.7    Stellsignal Y-Hysterese - Zeitformat gendert            */
/*            2.9.1  Koerperschallsensor Adresse geaendert                    */
/*            3.2    Sprungantwort - Bezeichung geaendert                     */
/*            3.4    Diagramm Stellsignal Y-Hysterese - Bezeichnung geaendert */
/*            4.1    zusaetzliche Diagnoseparameter eingefuehrt               */
/* 28.04.2006 kmr/E82  Teilmenge der Diagnoseparameter implementiert          */
/*                     (wegen Tokenizer-Beschraenkung)                        */
/* 21.06.2006 Kmr/E82 Device Revision 5: PST Parameter hinzugefuegt           */
/*                   messages_1..30: Texte fuer 10070 und 10071 ergaenzt.     */
/* 09.05.2007 kmr/E82  Grenzen um Faktor 10 gendert: step_sample_rate,       */
/*                   latency_after_step, sample_rate.                         */
/* 12.07.2007 Kmr/E82 Device Revision 5; DD Revision 2 erstellt.              */
/*                    Erweiterungen fr 3731-3 1.44 EXPERT+/PST               */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

/******************************************************************************
Inhaltsverzeichnis:
*******************************************************************************

1.1.1 Betriebsstundenzhler (BSZ)
1.1.2 Nullpunkt
1.1.3 Protokollierung
1.2   Erweitert

2.1   Datenlogger (permanent / getriggert)
2.2   Histogramm - Ventilstellung X
2.3   Histogramm - Regelabweichung e
2.4   Histogramm - Zyklenzhler
2.5   Temperaturbetrachtung
2.6   Diagramm Stellsignal Y - Stationr
2.7   Diagramm Stellsignal Y - Hysterese
2.8   Endlagentrend
2.9.1 Endlagentrend (Krperschallsensor)
2.9.2 Erfassung innere Leckage
2.9.3 Erfassung ber den gesamten Ventilbereich

3.1   Statische Kennlinie (TESTen (offline))
3.2   Sprungantwort
3.3   Diagramm Stellsignal Y - Stationr
3.4   Diagram Stellsignal Y - Hysterese
4.1   Zustzliche Diagnoseparameter
4.2   PST Parameter
4.2.1 PST Parameter (weitere fr FW 1.44)

*****************************************************************************/


/* ------------------------------------------------------------------------ */
/* Parameterdefinitionen Diagnose                                           */
/* ------------------------------------------------------------------------ */

/* unsigned char 117; READ: cmd 171/117 */
VARIABLE diag_reference_info
{
  #ifdef LABEL_DE_EN
  LABEL    "Diagnosis test information"
           "|de|Diagnose-Testlauf Information";
  #else
  LABEL    "Diagnosis test information";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "Reference not active"
         "|de|Referenzlauf nicht aktiviert" },
    { 1, "Drive signal y steady (d1) active"
         "|de|Stellsignal y Stationr (d1) aktiv" },
    { 2, "Drive signal hysteresis (d2) active"
         "|de|Stellsignal y Hysterese (d2) aktiv" },
    { 3, "Reference aborted" "|de|Referenzlauf wurde abgebrochen" },
    { 4, "Recorded reference values incomplete (Code 81)"
         "|de|Referenzwertaufnahme unvollstndig (Code 81)" }
  #else
    { 0, "Reference not active"                      },
    { 1, "Drive signal y steady (d1) active"         },
    { 2, "Drive signal hyst. (d2) active"            },
    { 3, "Reference aborted"                         },
    { 4, "Recorded ref. values incomplete (Code 81)" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Status of the diagnosis test."
           "|de|Status des Testlaufes.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 306; READ: cmd 171/306 */
VARIABLE error_code_81_ref_test_aborted
{
  #ifdef LABEL_DE_EN
  LABEL    "Reference test aborted" "|de|Referenzlauf abgebrochen";
  #else
  LABEL    "Reference test aborted";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  #else
    { 0, "No"  },
    { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The reference test was aborted and has not finished correctly."
           "|de|Der Referenzlauf wurde abgebrochen und nicht korrekt beendet.";
#endif
}

/* ------------------------------------------------------------------------ */
/* Start / Stopp Funktionen */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 39 */
VARIABLE start_abort_data_logger
{
  #ifdef LABEL_DE_EN
  LABEL    "Data logger control" "|de|Steuerung Datenlogger";
  #else
  LABEL    "Data logger control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Start or stop the data logger. "
           "Can only be performed in the AUTO operating mode."
           "|de|Datenlogger starten oder anhalten. "
           "Ausfhrung nur in der Betriebsart AUTO mglich.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 281 */
VARIABLE start_abort_step_response_test
{
  #ifdef LABEL_DE_EN
  LABEL    "Step response control" "|de|Steuerung Sprungantwort";
  #else
  LABEL    "Step response control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }

  POST_EDIT_ACTIONS
  {
    WARNING_BEFORE_TEST /* Warnmeldung */
  }

#ifdef HELP_EP_DE_EN
  HELP     "Starts or quits the execution of the test d4. "
           "Can only be performed in the MANUAL operating mode."
           "|de|Startet oder beendet die Durchfhrung vom Test d4. "
           "Ausfhrung nur in der Betriebsart HAND mglich.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 287 */
VARIABLE start_abort_tests_in_turn
{
  #ifdef LABEL_DE_EN
  LABEL    "Tests in turn control" "|de|Tests nacheinander starten";
  #else
  LABEL    "Tests in turn control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }

  POST_EDIT_ACTIONS
  {
    WARNING_BEFORE_TEST /* Warnmeldung */
  }

#ifdef HELP_EP_DE_EN
  HELP     "All tests d1,d2,d3,d4 were executed one after another. "
           "Can only be performed in the MANUAL operating mode."
           "|de|Alle Tests d1,d2,d3,d4 werden nacheinander durchgefhrt. "
           "Ausfhrung nur in der Betriebsart HAND mglich.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 255 */
VARIABLE start_abort_drive_signal_diagram_steady
{
  #ifdef LABEL_DE_EN
  LABEL    "Drive signal diagram steady control"
           "|de|Steuerung Stellsignal Stationr";
  #else
  LABEL    "Drive signal diagram steady control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }

  POST_EDIT_ACTIONS
  {
    WARNING_BEFORE_TEST /* Warnmeldung */
  }

#ifdef HELP_EP_DE_EN
  HELP     "Starts or quits the test d1."
           "|de|Startet oder beendet den Test d1.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 273 */
VARIABLE start_abort_drive_signal_diagram_hysteresis
{
  #ifdef LABEL_DE_EN
  LABEL    "Drive signal diagram hysteresis control"
           "|de|Steuerung Stellsignal Hysterese";
  #else
  LABEL    "Drive signal diagram hysteresis control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }

  POST_EDIT_ACTIONS
  {
    WARNING_BEFORE_TEST /* Warnmeldung */
  }

#ifdef HELP_EP_DE_EN
  HELP     "Starts or quits the test d2. "
           "Can only be performed in the MANUAL operating mode."
           "|de|Startet oder beendet den Test d2. "
           "Ausfhrung nur in der Betriebsart HAND mglich.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 275 */
VARIABLE start_abort_static_characteristic
{
  #ifdef LABEL_DE_EN
  LABEL    "Static characteristic control" "|de|Steuerung Statische Kennlinie";
  #else
  LABEL    "Static characteristic control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }

  POST_EDIT_ACTIONS
  {
    WARNING_BEFORE_TEST /* Warnmeldung */
  }

#ifdef HELP_EP_DE_EN
  HELP     "Starts or quits the execution of the test d3. "
           "Can only be performed in the MANUAL operating mode."
           "|de|Startet oder beendet die Durchfhrung vom Test d3. "
           "Ausfhrung nur in der Betriebsart HAND mglich.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 301 */
VARIABLE start_abort_reference_test
{
  #ifdef LABEL_DE_EN
  LABEL    "Reference test control" "|de|Steuerung Referenzlauf";
  #else
  LABEL    "Reference test control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }

  POST_EDIT_ACTIONS
  {
    WARNING_BEFORE_TEST /* Warnmeldung */
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Starts both reference tests d1 and d2. "
           "Can only be performed in the MANUAL operating mode."
           "|de|Startet die beiden Referenzlufe d1 und d2. "
           "Ausfhrung nur in der Betriebsart HAND mglich.";
#endif
}


/* ------------------------------------------------------------------------ */
/* Reset Funktionen */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 3; WRITE: cmd 170/3 */
VARIABLE reset_logger
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Logger'" "|de|Rcksetzen 'Protokollierung'";
  #else
  LABEL    "Reset 'Logger'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Measured data in the logging buffer were deleted."
           "|de|Messwerte im Protokollierungspuffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 49; WRITE: cmd 170/49 */
VARIABLE reset_x_long_term_histogram
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Travel histogram x'"
           "|de|Rcksetzen 'Histogramm Ventilstellung x'";
  #else
  LABEL    "Reset 'Travel histogram x'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the long-term histogram were deleted."
           "|de|Messwerte im Langzeit-Histogramm werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 50; WRITE: cmd 170/50 */
VARIABLE reset_x_short_term_histogram
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Travel histogram x - short term'"
           "|de|Rcksetzen 'Histogramm Ventilstellung x - Kurzzeit'";
  #else
  LABEL    "Reset 'Travel histogram x - short term'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the short-term histogram were deleted."
           "|de|Messwerte im Kurzzeit-Histogramm werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 119; WRITE: cmd 170/119 */
VARIABLE reset_e_long_term_setpoint_deviation
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Setpoint deviation histogram e'"
           "|de|Rcksetzen 'Histogramm Regelabweichung e'";
  #else
  LABEL    "Reset 'Setpoint deviation histogram e'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the long-term histogram were deleted."
           "|de|Messwerte im Langzeit-Histogramm werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 120; WRITE: cmd 170/120 */
VARIABLE reset_e_short_term_setpoint_deviation
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Setpoint deviation histogram e - short term'"
           "|de|Rcksetzen 'Histogramm Regelabweichung e (Kurzzeit)'";
  #else
  LABEL    "Reset 'Setpoint deviation histogram e - short term'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the short-term histogram were deleted."
           "|de|Messwerte im Kurzzeit-Histogramm werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 148; WRITE: cmd 170/148 */
VARIABLE reset_z_long_term
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Cycle counter histogram'"
           "|de|Rcksetzen 'Histogramm Zyklenzhler'";
  #else
  LABEL    "Reset 'Cycle counter histogram'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the long-term histogram were deleted."
           "|de|Messwerte im Langzeit-Histogramm werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 146; WRITE: cmd 170/146 */
VARIABLE reset_z_short_term
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Cycle counter histogram - short term'"
           "|de|Rcksetzen 'Histogramm Zyklenzhler (Kurzzeit)'";
  #else
  LABEL    "Reset 'Cycle counter histogram - short term'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the short-term histogram were deleted."
           "|de|Messwerte im Kurzzeit-Histogramm werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 190; WRITE: cmd 170/190 */
VARIABLE reset_y_x_long_term
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Drive signal diagram steady'"
           "|de|Rcksetzen 'Diagramm Stellsignal y Stationr'";
  #else
  LABEL    "Reset 'Drive signal diagram steady'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the buffer were deleted."
           "|de|Messwerte im Ringpuffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 191; WRITE: cmd 170/191 */
VARIABLE reset_y_x_short_term
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Drive signal diagram steady - short term'"
           "|de|Rcksetzen 'Diagramm Stellsignal y Stationr (Kurzzeit)'";
  #else
  LABEL    "Reset 'Drive signal diagram steady - short term'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the ring buffer were deleted."
           "|de|Messwerte im Ringpuffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 218; WRITE: cmd 170/218 */
VARIABLE reset_hysteresis_long_term
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Drive signal diagram hysteresis'"
           "|de|Rcksetzen 'Diagramm Stellsignal y Hysterese'";
  #else
  LABEL    "Reset 'Drive signal diagram hysteresis'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the buffer were deleted."
           "|de|Messwerte im Puffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 221; WRITE: cmd 170/221 */
VARIABLE reset_hysteresis_short_term
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Drive signal diagram hysteresis - short term'"
           "|de|Rcksetzen 'Diagramm Stellsignal y Hysterese (Kurzzeit)'";
  #else
  LABEL    "Reset 'Drive signal diagram hysteresis - short term'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the buffer were deleted."
           "|de|Messwerte im Puffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 245; WRITE: cmd 170/245 */
VARIABLE reset_lower_end_position
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Lower end position'"
           "|de|Rcksetzen 'Unterer Endlagentrend'";
  #else
  LABEL    "Reset 'Lower end position'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the lower end position of the buffer were deleted."
           "|de|Messwerte der unteren Endlage im Puffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 247; WRITE: cmd 170/247 */
VARIABLE reset_lower_end_position_ref_values
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Lower end position - ref. values'"
           "|de|Rcksetzen 'Untere Endlage - Referenzwerte'";
  #else
  LABEL    "Reset 'Lower end position - ref. values'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the lower end position of the buffer were deleted."
           "|de|Messwerte der unteren Endlage im Puffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 252; WRITE: cmd 170/252 */
VARIABLE reset_y_x_measured_values
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Drive signal diagram steady measured data'"
           "|de|Rcksetzen 'Diagramm Stellsignal y - Stationr Messwerte'";
  #else
  LABEL    "Reset 'Drive signal diagram steady measured data'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the ring buffer were deleted."
           "|de|Messwerte im Ringpuffer werden gelscht.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 271; WRITE: cmd 170/271 */
VARIABLE reset_hysteresis_measured_values
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'Drive signal diagram hysteresis measured data'"
           "|de|Rcksetzen 'Diagramm Stellsignal y - Hysterese Messwerte'";
  #else
  LABEL    "Reset 'Drive signal diagram hysteresis measured data'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Measured data of the ring buffer were deleted."
           "|de|Messwerte im Ringpuffer werden gelscht.";
#endif
}


/* ------------------------------------------------------------------------ */
/* 1.1.1 Betriebsstundenzhler (BSZ)                                        */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE elapsed_hours_meter (unsigned long 0)
*/
VARIABLE elapsed_hours_meter
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours meter" "|de|Betriebsstundenzhler";
  #else
  LABEL    "Elapsed hours meter";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time since the initial commissioning."
           "|de|Zeit seit der ersten Inbetriebnahme.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE device_in_closed_loop (unsigned long 1)
*/
VARIABLE device_in_closed_loop
{
  #ifdef LABEL_DE_EN
  LABEL    "Device in closed loop" "|de|Gert in Regelung";
  #else
  LABEL    "Device in closed loop";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time in closed loop since the initial commissioning."
           "|de|Zeit in der Regelung seit der ersten Inbetriebnahme.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE device_switched_on_since_init (unsigned long 2)
*/
VARIABLE device_switched_on_since_init
{
  #ifdef LABEL_DE_EN
  LABEL    "Device switched on since initialization"
           "|de|Gert eingeschaltet seit Initialisierung";
  #else
  LABEL    "Device switched on since initialization";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time since the last initialization."
           "|de|Zeit seit der letzten Initialisierung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE device_in_closed_loop_since_init (unsigned long 3)
*/
VARIABLE device_in_closed_loop_since_init
{
  #ifdef LABEL_DE_EN
  LABEL    "Device in closed loop since init."
           "|de|Gert seit Initialisierung in Regelung";
  #else
  LABEL    "Device in closed loop since init.";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time in closed loop since the last initialization."
           "|de|Zeit in der Regelung seit der letzten Initialisierung.";
#endif
}

/* ------------------------------------------------------------------------ */
/* 1.1.2 Nullpunkt                                                          */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE zero_point_limit (cmd 128/1 und 129/1)
*/
VARIABLE zero_point_limit
{
  #ifdef LABEL_DE_EN
  LABEL    "Zero point limit" "|de|Nullpunktgrenze";
  #else
  LABEL    "Zero point limit";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE   5.0;
      MIN_VALUE       0.0;
      MAX_VALUE     100.0;
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Limit value for zero point control."
           "|de|Grenze fr die Nullpunktberwachung.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE counter_init_start (cmd 130/52)
*/
VARIABLE counter_init_start
{
  #ifdef LABEL_DE_EN
  LABEL    "Number of initializations" "|de|Anzahl Initialisierungen";
  #else
  LABEL    "Number of initializations";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DISPLAY_FORMAT "2d";
  }
#ifdef HELP_EP_DE_EN
  HELP     "Number of initializations ever performed."
           "|de|Anzahl der jemals durchgefhrten Initialisierungen.";
#endif
}


/* ------------------------------------------------------------------------ */
/* 1.1.3 Protokollierung                                                    */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE messages_1 ... 30 (unsigned integer 0..29)
*/
VARIABLE messages_1
{
  LABEL    "Message 1" "|de|Meldung 1";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (2)
  {
  #ifdef LABEL_DE_EN
/* kmr: deutsch und englisch vollstaendig: */
    {     0, "No message logged" "|de|Keine Meldung protokolliert" },
    {     1, "Init. error: x > range"
             "|de|Init.-fehler: x > Bereich" },
    {     2, "Init. error: Delta x < range"
             "|de|Init.-fehler: delta x < Bereich" },
    {     3, "Init. error: Mech./Pneu. (Attachment)"
             "|de|Init.-fehler: Mech./Pneu. (Anbau)" },
    {     4, "Init. error: Initialization time exceeded"
             "|de|Init.-fehler: Initialisierungszeit berschritten" },
    {     5, "Init. error: Initialization/solenoid valve"
             "|de|Init.-fehler: Initialisierung/Magnetventil" },
    {     6, "Init. error: Travel time too short"
             "|de|Init.-fehler: Laufzeit unterschritten" },
    {     7, "Init. error: Pin position"
             "|de|Init.-fehler: Stiftposition" },
    {     8, "Init. error: No emergency mode"
             "|de|Init.-fehler: Keine Notlaufeigenschaft" },
    {     9, "9" },
    {    10, "Operating error: Control loop"
             "|de|Betriebsfehler: Regelkreis" },
    {    11, "Operating error: Zero point"
             "|de|Betriebsfehler: Nullpunkt" },
    {    12, "Operating error: Autocorrection"
             "|de|Betriebsfehler: Autokorrektur" },
    {    13, "Operating error: Fatal error"
             "|de|Betriebsfehler: Fataler Fehler" },
    {    14, "Operating error: W too small"
             "|de|Betriebsfehler: W zu klein" },
    {    15, "Operating error: Total valve travel exceeded"
             "|de|Betriebsfehler: Wegintegral berschritten" },
    {    16, "16" },
    {    17, "HW error: x - Signal"
             "|de|HW-Fehler: x - Signal" },
    {    18, "HW error: i/p converter"
             "|de|HW-Fehler: i/p Wandler" },
    {    19, "HW error: Hardware"
             "|de|HW-Fehler: Hardware" },
    {    20, "HW error: Data memory"
             "|de|HW-Fehler: Datenspeicher" },
    {    21, "HW error: Control calculation"
             "|de|HW-Fehler: Kontrollrechnung" },
    {    22, "HW error: Program load error"
             "|de|HW-Fehler: Programmladefehler" },
    {    23, "23" },
    {    24, "Data error: Control parameter"
             "|de|Datenfehler: Regelparameter" },
    {    25, "Data error: Poti parameter"
             "|de|Datenfehler: Potiparameter" },
    {    26, "Data error: Adjustment parameter"
             "|de|Datenfehler: Abgleichparameter" },
    {    27, "Data error: General parameter"
             "|de|Datenfehler: Allgemeine Parameter" },
    {    28, "Data error: Internal device error 1"
             "|de|Datenfehler: Interner Gertefehler 1" },
    {    29, "Data error: HART Parameter"
             "|de|Datenfehler: HART Parameter" },
    {    30, "Data error: Info parameter"
             "|de|Datenfehler: Info-Parameter"},
    {    31, "Data error: Options parameter"
             "|de|Datenfehler: Optionsparameter" },
    {    32, "Data errors: Diagnosis parameter"
             "|de|Datenfehler: Diagnoseparameter" },
    {    33, "Kp: manipulation" "|de|Kp: nderung" },
    {    34, "Tv: manipulation" "|de|Tv: nderung" },
    {    35, "35" },
    {    36, "36" },
    {    37, "37" },
    {    38, "38" },
    {    39, "39" },
    {    40, "40" },
    {    41, "41" },
    {    42, "42" },
    {    43, "43" },
    {    44, "44" },
    {    45, "45" },
    {    46, "46" },
    {    47, "47" },
    {    48, "48" },
    {    49, "49" },
    {    50, "50" },
    { 10000, "Range: Mostly near closing pos."
             "|de|Stellbereich: Vorwiegend nahe Schliessstellung" },
    { 10001, "Range: Mostly near max. opening"
             "|de|Stellbereich: Vorwiegend nahe max. ffnung" },
    { 10002, "Range: Mostly closing pos."
             "|de|Stellbereich: Vorwiegend Schliessstellung" },
    { 10003, "Range: Mostly max. opening"
             "|de|Stellbereich: Vorwiegend max. ffnung" },
    { 10004, "10004" },
    { 10005, "Trend range: Shifting working range to closing position"
             "|de|Trend Stellbereich: Arbeitsbereichversch. Schliessstellung" },
    { 10006, "Trend range: Shifting working range to max. opening pos."
             "|de|Trend Stellbereich: Arbeitsbereichversch. max. ffnung" },
    { 10007, "10007" },
    { 10008, "Limit range: Down"
             "|de|Beschr. Stellbereich: Nach unten" },
    { 10009, "Limit range: Up"
             "|de|Beschr. Stellbereich: Nach oben" },
    { 10010, "Limit range: Modification impossible"
             "|de|Beschr. Stellb.: Keine nderung mehr mglich (Klemmen)" },
    { 10011, "10011" },
    { 10012, "Trend end pos.: ZP-shift monotone down; aver. above ref."
             "|de|Trend Endlage: NP-versch. monoton unten; MW ob. Ref.-geraden" },
    { 10013, "Trend end pos.: ZP-shift monotone up; aver. above ref."
             "|de|Trend Endlage: NP-versch. monoton oben; MW ob. Ref.-geraden" },
    { 10014, "Trend end pos.: ZP-shift alternate; aver. above ref."
             "|de|Trend Endlage: NP altern.; MW ob. Ref.-geraden" },
    { 10015, "Trend end pos.: ZP-shift monotone down; aver. under ref."
             "|de|Trend Endlage: NP-versch. monoton unten; MW unt. Ref.-geraden" },
    { 10016, "Trend end pos.: ZP-shift monotone up; aver. under ref."
             "|de|Trend Endlage: NP-versch. monoton oben; MW unt. Ref.-geraden" },
    { 10017, "Trend end pos.: ZP-alternate; aver. under ref."
             "|de|Trend Endlage: NP altern.; MW unt. Ref.-geraden" },
    { 10018, "10018" },
    { 10019, "Mech. conn. Pos./Valve: No opt. travel transm.TEST"
             "|de|Mech. Verb. Regler/Ventil: Keine opt. Hubbertr. TEST" },
    { 10020, "Mech. conn. Pos./Valve: Perhaps loose"
             "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh." },
    { 10021, "Mech. conn. Pos./Valve: Perhaps limit. range"
             "|de|Mech. Verb. Regler/Ventil: Evtl. Einschr. Stellber." },
    { 10022, "10022" },
    { 10023, "Spring: Perhaps spring stiffness reduced TEST"
             "|de|Antriebsfedern: Evtl. Federsteifigkeit red. TEST" },
    { 10024, "Spring: Perhaps bias reduced TEST"
             "|de|Antriebsfedern: Evtl. Vorspannung reduziert TEST" },
    { 10025, "Spring: Perhaps bias increased TEST"
             "|de|Antriebsfedern: Evtl. Vorspannung erhht TEST" },
    { 10026, "Spring: Working at full capacity"
             "|de|Antriebsfedern: Stark ausgelastet" },
    { 10027, "Spring: Working at full capacity TEST"
             "|de|Antriebsfedern: Stark ausgelastet TEST" },
    { 10028, "10028" },
    { 10029, "Air supply: Perhaps modified TEST"
             "|de|Zuluftdruck: Evtl. verndert TEST" },
    { 10030, "Air supply: Perhaps not enough TEST"
             "|de|Zuluftdruck: Evtl. nicht ausreichend TEST" },
    { 10031, "Air supply: Perhaps not enough"
             "|de|Zuluftdruck: Evtl. nicht ausreichend" },
    { 10032, "Air supply: Working at full capacity"
             "|de|Zuluftdruck: Stark ausgelastet" },
    { 10033, "Air supply: Working at full capacity TEST"
             "|de|Zuluftdruck: Stark ausgelastet TEST" },
    { 10034, "Air supply: Perhaps modified"
             "|de|Zuluftdruck: Eventuell verndert" },
    { 10035, "Leakage Pneumatics: Perhaps existing TEST"
             "|de|Leckage Pneumatik: Evtl. vorhanden TEST" },
    { 10036, "Leakage Pneumatics: Perhaps too large TEST"
             "|de|Leckage Pneumatik: Evtl. zu gross TEST" },
    { 10037, "Leakage Pneumatics: Perhaps too large"
             "|de|Leckage Pneumatik: Evtl. zu gross" },
    { 10038, "Leakage Pneumatics: Perhaps existing"
             "|de|Leckage Pneumatik: Evtl. vorhanden" },
    { 10039, "Friction: Much higher over whole range"
             "|de|Reibung: ber ganzen Stellber. deutlich hher" },
    { 10040, "Friction: Much lower over whole range"
             "|de|Reibung: ber ganzen Stellber. deutlich niedriger" },
    { 10041, "Friction: Much higher over section"
             "|de|Reibung: ber Teilstellber. deutlich hher" },
    { 10042, "Friction: Much lower over section"
             "|de|Reibung: ber Teilstellber. deutlich niedriger" },
    { 10043, "10043" },
    { 10044, "Inner leakage: Perhaps larger than origin"
             "|de|Innere Leckage: Evtl. grsser als im Neuzustand" },
    { 10045, "Inner leakage: Perhaps larger than origin TEST"
             "|de|Innere Leckage: Evtl. grsser als im Neuzustand TEST" },
    { 10046, "Inner leakage - perhaps present"
             "|de|Innere Leckage - Eventuell vorhanden" },
    { 10047, "Ext. leakage: Perhaps soon expected"
             "|de|Externe Leckage: Evtl. bald zu erwarten" },
    { 10048, "Ext. leakage: Perhaps existing"
             "|de|Externe Leckage: Evtl. vorhanden" },
    { 10049, "10049" },
    { 10050, "PST: Movement actuator poss."
             "|de|PST: Bewegung Stellorgan mglich" },
    { 10051, "PST: Movement actuator imposs."
             "|de|PST: Bewegung Stellorgan nicht mglich" },
    { 10052, "PST: Error solenoid valve"
             "|de|PST: Magnetventil arbeitet nicht richtig" },
    { 10053, "10053" },
    { 10054, "10054" },
    { 10055, "10055" },
    { 10056, "10056" },
    { 10057, "10057" },
    { 10058, "10058" },
    { 10059, "10059" },
    { 10060, "Temperature below -40C" "|de|Temperatur kleiner -40C" },
    { 10061, "10061" },
    { 10062, "Temperature above +80C" "|de|Temperatur grer +80C" },
    { 10063, "10063" },
    { 10064, "10064" },
    { 10065, "10065" },
    { 10066, "10066" },
    { 10067, "10067" },
    { 10068, "10068" },
    { 10069, "10069" },
    { 10070, "Data logger started by travel condition"
             "|049Triggerstart Datenlogger ber Hubbed. akt." },
    { 10071, "Data logger started by solenoid valve condition"
             "|049Triggerstart Datenlogger ber Magnetventilbed. akt." },
    { 10072, "10072" },
    { 10073, "10073" },
    { 10074, "10074" },
    { 10075, "10075" },
    { 10076, "10076" },
    { 10077, "10077" },
    { 10078, "10078" },
    { 10079, "10079" },
    { 10080, "10080" },
    { 11020, "Mech. conn. Pos./Valve: Perhaps loose TEST"
             "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh. TEST" },
    { 11039, "Friction: Much higher over whole range TEST"
             "|de|Reibung: ber ganzen Stellber. deutlich hher TEST" },
    { 11040, "Friction: Much lower over whole range TEST"
             "|de|Reibung: ber ganzen Stellber. deutlich niedriger TEST" },
    { 11041, "Friction: Much higher over section TEST"
             "|de|Reibung: ber Teilbereich deutlich hher TEST" },
    { 11042, "Friction: Much lower over section TEST"
             "|de|Reibung: ber Teilbereich deutlich niedriger TEST" },
    { 12000, "Reset long-term histogram X"
             "|de|Langzeit-Histogramm x zurckgesetzt" },
    { 12001, "Reset long-term histogram cycle counter"
             "|de|Langzeithistogramm Zyklenzhler zurckgesetzt" },
    { 12002, "Reset elapsed hours meter"
             "|de|Betriebsstundenzhler zurckgesetzt" },
    { 12003, "Reset temp. meter and high. values"
             "|de|Temp. Schleppzeiger und Hchstwerte zurckgesetzt" },
    { 12004, "Reset long-term view Y-steady online"
             "|de|Langzeitbetrachtung Y-Stationr Online zurckgesetzt" },
    { 12005, "Reset long-term view hysteresis online"
             "|de|Langzeitbetrachtung Hysterese Online zurckgesetzt" },
    { 12006, "Reset end pos. trend ref. value upper end pos."
             "|de|Endlagentrend Referenzwert obere Endlage zurckgesetzt" },
    { 12007, "Reset end pos. trend ref. value lower end pos."
             "|de|Endlagentrend Referenzwert untere Endlage zurckgesetzt" },
    { 12008, "Long-term sound sensor: reset meas. whole range"
             "|de|Langzeit KS-sensor: Messung ges. Hubber. zurckgesetzt" },
    { 12009, "Reset long-term process values histogram"
             "|de|Langzeit Prozessgren-Histogramm zurckgesetzt" },
    { 12010, "Reset long-term histogram deviation"
             "|de|Langzeithistogramm e zurckgesetzt" },
    { 12011, "12011" },
    { 12012, "12012" },
    { 12013, "12013" },
    { 12014, "12014" },
    { 12015, "12015" },
    { 12016, "12016" },
    { 12017, "12017" },
    { 12018, "12018" },
    { 12019, "12019" },
    { 12020, "12020" },
    { 12500, "Langzeithistogramm e zurckgesetzt"
             "|de|Reset long-term histogram deviation" }

  #else

/* kmr: nur englisch wegen Tokenizer-Beschraenkung: */
    {     0, "No message logged" },
    {     1, "Init. error: x > range" },
    {     2, "Init. error: Delta x < range" },
    {     3, "Init. error: Mech./Pneu. (Attachment)" },
    {     4, "Init. error: Init. time exceeded" },
    {     5, "Init. error: Init./solenoid valve" },
    {     6, "Init. error: Travel time too short" },
    {     7, "Init. error: Pin position" },
    {     8, "Init. error: No emergency mode" },
    {     9, "9" },
    {    10, "Oper. error: Control loop" },
    {    11, "Oper. error: Zero point" },
    {    12, "Oper. error: Autocorrection" },
    {    13, "Oper. error: Fatal error" },
    {    14, "Oper. error: W too small" },
    {    15, "Oper. error: Total valve travel exceeded" },
    {    16, "16" },
    {    17, "HW error: x - Signal" },
    {    18, "HW error: i/p converter" },
    {    19, "HW error: Hardware" },
    {    20, "HW error: Data memory" },
    {    21, "HW error: Control calculation" },
    {    22, "HW error: Program load error" },
    {    23, "23" },
    {    24, "Data error: Control parameter" },
    {    25, "Data error: Poti parameter" },
    {    26, "Data error: Adjustment parameter" },
    {    27, "Data error: General parameter" },
    {    28, "Data error: Internal device error 1" },
    {    29, "Data error: HART Parameter" },
    {    30, "Data error: Info parameter" },
    {    31, "Data error: Options parameter" },
    {    32, "Data errors: Diagnosis parameter" },
    {    33, "Kp: manipulation" },
    {    34, "Tv: manipulation" },
    {    35, "35" },
    {    36, "36" },
    {    37, "37" },
    {    38, "38" },
    {    39, "39" },
    {    40, "40" },
    {    41, "41" },
    {    42, "42" },
    {    43, "43" },
    {    44, "44" },
    {    45, "45" },
    {    46, "46" },
    {    47, "47" },
    {    48, "48" },
    {    49, "49" },
    {    50, "50" },
    { 10000, "Range: Mostly near closing pos." },
    { 10001, "Range: Mostly near max. opening" },
    { 10002, "Range: Mostly closing pos." },
    { 10003, "Range: Mostly max. opening" },
    { 10004, "10004" },
    { 10005, "Trend range: Shift. work. range closing pos." },
    { 10006, "Trend range: Shift. work. range max. opening pos." },
    { 10007, "10007" },
    { 10008, "Limit range: Down" },
    { 10009, "Limit range: Up" },
    { 10010, "Limit range: Modification impossible" },
    { 10011, "10011" },
    { 10012, "Trend end pos.: ZP-shift mon.e down; aver. > ref." },
    { 10013, "Trend end pos.: ZP-shift mon. up; aver. > ref." },
    { 10014, "Trend end pos.: ZP-shift alt.; aver. > ref." },
    { 10015, "Trend end pos.: ZP-shift mon. down; aver. < ref." },
    { 10016, "Trend end pos.: ZP-shift mon. up; aver. < ref." },
    { 10017, "Trend end pos.: ZP-alternate; aver. < ref." },
    { 10018, "10018" },
    { 10019, "Mech. conn. Pos./Valve: No opt. travel transm.TEST" },
    { 10020, "Mech. conn. Pos./Valve: Perhaps loose" },
    { 10021, "Mech. conn. Pos./Valve: Perhaps limit. range" },
    { 10022, "10022" },
    { 10023, "Spring: Perhaps spring stiffness reduced TEST" },
    { 10024, "Spring: Perhaps bias reduced TEST" },
    { 10025, "Spring: Perhaps bias increased TEST" },
    { 10026, "Spring: Working at full capacity" },
    { 10027, "Spring: Working at full capacity TEST" },
    { 10028, "10028" },
    { 10029, "Air supply: Perhaps modified TEST" },
    { 10030, "Air supply: Perhaps not enough TEST" },
    { 10031, "Air supply: Perhaps not enough" },
    { 10032, "Air supply: Working at full capacity" },
    { 10033, "Air supply: Working at full capacity TEST" },
    { 10034, "Air supply: Perhaps modified" },
    { 10035, "Leakage Pneumatics: Perhaps existing TEST" },
    { 10036, "Leakage Pneumatics: Perhaps too large TEST" },
    { 10037, "Leakage Pneumatics: Perhaps too large" },
    { 10038, "Leakage Pneumatics: Perhaps existing" },
    { 10039, "Friction: Much higher over whole range" },
    { 10040, "Friction: Much lower over whole range" },
    { 10041, "Friction: Much higher over section" },
    { 10042, "Friction: Much lower over section" },
    { 10043, "10043" },
    { 10044, "Inner leakage: Perhaps larger than origin" },
    { 10045, "Inner leakage: Perhaps larger than origin TEST" },
    { 10046, "Inner leakage - maybe present" },
    { 10047, "Ext. leakage: Perhaps soon expected" },
    { 10048, "Ext. leakage: Perhaps existing" },
    { 10049, "10049" },
    { 10050, "PST: Movement actuator poss." },
    { 10051, "PST: Movement actuator imposs." },
    { 10052, "PST: Error solenoid valve" },
    { 10053, "10053" },
    { 10054, "10054" },
    { 10055, "10055" },
    { 10056, "10056" },
    { 10057, "10057" },
    { 10058, "10058" },
    { 10059, "10059" },
    { 10060, "Temperature below -40C" },
    { 10061, "10061" },
    { 10062, "Temperature above +80C" },
    { 10063, "10063" },
    { 10064, "10064" },
    { 10065, "10065" },
    { 10066, "10066" },
    { 10067, "10067" },
    { 10068, "10068" },
    { 10069, "10069" },
    { 10070, "Data logger started by travel condition" },
    { 10071, "Data logger started by solenoid valve condition" },
    { 10072, "10072" },
    { 10073, "10073" },
    { 10074, "10074" },
    { 10075, "10075" },
    { 10076, "10076" },
    { 10077, "10077" },
    { 10078, "10078" },
    { 10079, "10079" },
    { 10080, "10080" },
    { 11020, "Mech. conn. Pos./Valve: Perhaps loose TEST" },
    { 11039, "Friction: Much higher over whole range TEST" },
    { 11040, "Friction: Much lower over whole range TEST" },
    { 11041, "Friction: Much higher over section TEST" },
    { 11042, "Friction: Much lower over section TEST" },
    { 12000, "Reset long-term histogram X" },
    { 12001, "Reset long-term histogram cycle counter" },
    { 12002, "Reset elapsed hours meter" },
    { 12003, "Reset temp. meter and high. values" },
    { 12004, "Reset long-term view Y-steady online" },
    { 12005, "Reset long-term view hysteresis online" },
    { 12006, "Reset end pos. trend ref. value upper end pos." },
    { 12007, "Reset end pos. trend ref. value lower end pos." },
    { 12008, "Long-term sound sensor: reset meas. whole range" },
    { 12009, "Reset long-term process values histogram" },
    { 12010, "Reset long-term histogram deviation" },
    { 12011, "12011" },
    { 12012, "12012" },
    { 12013, "12013" },
    { 12014, "12014" },
    { 12015, "12015" },
    { 12016, "12016" },
    { 12017, "12017" },
    { 12018, "12018" },
    { 12019, "12019" },
    { 12020, "12020" },
    { 12500, "Reset long-term histogram deviation" }

  #endif

  }

#ifdef HELP_EP_DE_EN
  HELP     "Apprehended messages, set by the positioner."
           "|de|Erfasste Meldungen, die vom Stellungsregler gesetzt wurden.";
#endif
}

messages_2  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 2" "|de|Meldung 2"; }
messages_3  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 3" "|de|Meldung 3"; }
messages_4  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 4" "|de|Meldung 4"; }
messages_5  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 5" "|de|Meldung 5"; }
messages_6  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 6" "|de|Meldung 6"; }
messages_7  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 7" "|de|Meldung 7"; }
messages_8  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 8" "|de|Meldung 8"; }
messages_9  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 9" "|de|Meldung 9"; }
messages_10  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 10" "|de|Meldung 10"; }
messages_11  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 11" "|de|Meldung 11"; }
messages_12  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 12" "|de|Meldung 12"; }
messages_13  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 13" "|de|Meldung 13"; }
messages_14  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 14" "|de|Meldung 14"; }
messages_15  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 15" "|de|Meldung 15"; }
messages_16  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 16" "|de|Meldung 16"; }
messages_17  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 17" "|de|Meldung 17"; }
messages_18  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 18" "|de|Meldung 18"; }
messages_19  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 19" "|de|Meldung 19"; }
messages_20  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 20" "|de|Meldung 20"; }
messages_21  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 21" "|de|Meldung 21"; }
messages_22  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 22" "|de|Meldung 22"; }
messages_23  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 23" "|de|Meldung 23"; }
messages_24  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 24" "|de|Meldung 24"; }
messages_25  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 25" "|de|Meldung 25"; }
messages_26  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 26" "|de|Meldung 26"; }
messages_27  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 27" "|de|Meldung 27"; }
messages_28  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 28" "|de|Meldung 28"; }
messages_29  LIKE VARIABLE  messages_1
{ REDEFINE LABEL  "Message 29" "|de|Meldung 29"; }
messages_30  LIKE  VARIABLE  messages_1
{ REDEFINE LABEL  "Message 30" "|de|Meldung 30"; }


/* ------------------------------------------------------------------------ */
/*
VARIABLE elapsed_hours_meter_1 ... 30 (unsigned long 4..33)
*/
VARIABLE elapsed_hours_meter_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 1"
           "|de|Betriebsstunden seit erster Inbetriebnahme 1";
  #else
  LABEL    "Elapsed hours since first start-up 1";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 2"
           "|de|Betriebsstunden seit erster Inbetriebnahme 2";
  #else
  LABEL    "Elapsed hours since first start-up 2";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_3
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 3"
           "|de|Betriebsstunden seit erster Inbetriebnahme 3";
  #else
  LABEL    "Elapsed hours since first start-up 3";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_4
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 4"
           "|de|Betriebsstunden seit erster Inbetriebnahme 4";
  #else
  LABEL    "Elapsed hours since first start-up 4";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_5
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 5"
           "|de|Betriebsstunden seit erster Inbetriebnahme 5";
  #else
  LABEL    "Elapsed hours since first start-up 5";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_6
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 6"
           "|de|Betriebsstunden seit erster Inbetriebnahme 6";
  #else
  LABEL    "Elapsed hours since first start-up 6";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_7
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 7"
           "|de|Betriebsstunden seit erster Inbetriebnahme 7";
  #else
  LABEL    "Elapsed hours since first start-up 7";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_8
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 8"
           "|de|Betriebsstunden seit erster Inbetriebnahme 8";
  #else
  LABEL    "Elapsed hours since first start-up 8";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_9
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 9"
           "|de|Betriebsstunden seit erster Inbetriebnahme 9";
  #else
  LABEL    "Elapsed hours since first start-up 9";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_10
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 10"
           "|de|Betriebsstunden seit erster Inbetriebnahme 10";
  #else
  LABEL    "Elapsed hours since first start-up 10";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_11
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 11"
           "|de|Betriebsstunden seit erster Inbetriebnahme 11";
  #else
  LABEL    "Elapsed hours since first start-up 11";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_12
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 12"
           "|de|Betriebsstunden seit erster Inbetriebnahme 12";
  #else
  LABEL    "Elapsed hours since first start-up 12";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_13
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 13"
           "|de|Betriebsstunden seit erster Inbetriebnahme 13";
  #else
  LABEL    "Elapsed hours since first start-up 13";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_14
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 14"
           "|de|Betriebsstunden seit erster Inbetriebnahme 14";
  #else
  LABEL    "Elapsed hours since first start-up 14";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_15
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 15"
           "|de|Betriebsstunden seit erster Inbetriebnahme 15";
  #else
  LABEL    "Elapsed hours since first start-up 15";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_16
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 16"
           "|de|Betriebsstunden seit erster Inbetriebnahme 16";
  #else
  LABEL    "Elapsed hours since first start-up 16";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_17
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 17"
           "|de|Betriebsstunden seit erster Inbetriebnahme 17";
  #else
  LABEL    "Elapsed hours since first start-up 17";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_18
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 18"
           "|de|Betriebsstunden seit erster Inbetriebnahme 18";
  #else
  LABEL    "Elapsed hours since first start-up 18";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_19
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 19"
           "|de|Betriebsstunden seit erster Inbetriebnahme 19";
  #else
  LABEL    "Elapsed hours since first start-up 19";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_20
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 20"
           "|de|Betriebsstunden seit erster Inbetriebnahme 20";
  #else
  LABEL    "Elapsed hours since first start-up 20";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_21
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 21"
           "|de|Betriebsstunden seit erster Inbetriebnahme 21";
  #else
  LABEL    "Elapsed hours since first start-up 21";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_22
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 22"
           "|de|Betriebsstunden seit erster Inbetriebnahme 22";
  #else
  LABEL    "Elapsed hours since first start-up 22";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_23
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 23"
           "|de|Betriebsstunden seit erster Inbetriebnahme 23";
  #else
  LABEL    "Elapsed hours since first start-up 23";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_24
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 24"
           "|de|Betriebsstunden seit erster Inbetriebnahme 24";
  #else
  LABEL    "Elapsed hours since first start-up 24";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_25
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 25"
           "|de|Betriebsstunden seit erster Inbetriebnahme 25";
  #else
  LABEL    "Elapsed hours since first start-up 25";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_26
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 26"
           "|de|Betriebsstunden seit erster Inbetriebnahme 26";
  #else
  LABEL    "Elapsed hours since first start-up 26";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_27
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 27"
           "|de|Betriebsstunden seit erster Inbetriebnahme 27";
  #else
  LABEL    "Elapsed hours since first start-up 27";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_28
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 28"
           "|de|Betriebsstunden seit erster Inbetriebnahme 28";
  #else
  LABEL    "Elapsed hours since first start-up 28";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_29
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 29"
           "|de|Betriebsstunden seit erster Inbetriebnahme 29";
  #else
  LABEL    "Elapsed hours since first start-up 29";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}

VARIABLE elapsed_hours_meter_30
{
  #ifdef LABEL_DE_EN
  LABEL    "Elapsed hours since first start-up 30"
           "|de|Betriebsstunden seit erster Inbetriebnahme 30";
  #else
  LABEL    "Elapsed hours since first start-up 30";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
#endif
}


/* POST_READ_ACTIONS geht nicht mit LIKE VARIABE !

elapsed_hours_meter_2  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 2"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 2"; }
elapsed_hours_meter_3  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 3"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 3"; }
elapsed_hours_meter_4  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 4"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 4"; }
elapsed_hours_meter_5  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 5"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 5"; }
elapsed_hours_meter_6  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 6"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 6"; }
elapsed_hours_meter_7  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 7"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 7"; }
elapsed_hours_meter_8  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 8"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 8"; }
elapsed_hours_meter_9  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 9"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 9"; }
elapsed_hours_meter_10  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 10"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 10"; }
elapsed_hours_meter_11  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 11"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 11"; }
elapsed_hours_meter_12  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 12"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 12"; }
elapsed_hours_meter_13  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 13"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 13"; }
elapsed_hours_meter_14  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 14"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 14"; }
elapsed_hours_meter_15  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 15"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 15"; }
elapsed_hours_meter_16  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 16"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 16"; }
elapsed_hours_meter_17  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 17"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 17"; }
elapsed_hours_meter_18  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 18"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 18"; }
elapsed_hours_meter_19  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 19"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 19"; }
elapsed_hours_meter_20  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 20"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 20"; }
elapsed_hours_meter_21  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 21"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 21"; }
elapsed_hours_meter_22  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 22"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 22"; }
elapsed_hours_meter_23  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 23"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 23"; }
elapsed_hours_meter_24  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 24"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 24"; }
elapsed_hours_meter_25  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 25"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 25"; }
elapsed_hours_meter_26  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 26"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 26"; }
elapsed_hours_meter_27  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 27"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 27"; }
elapsed_hours_meter_28  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 28"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 28"; }
elapsed_hours_meter_29  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 29"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 29"; }
elapsed_hours_meter_30  LIKE  VARIABLE  elapsed_hours_meter_1
{ REDEFINE LABEL "Elapsed hours since first start-up 30"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 30"; } */


/* ------------------------------------------------------------------------ */
/* 2.1   Datenlogger (permanent / getriggert)                               */
/* ------------------------------------------------------------------------ */

/* unsigned long 200...299 */

VARIABLE datalogger_t_0
{
  LABEL    "Zeitmesswert - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "1/10 s Takt";
  HELP     "|de|Zeitmesswert";
}

datalogger_t_1 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 2"; }
datalogger_t_2 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 3"; }
datalogger_t_3 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 4"; }
datalogger_t_4 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 5"; }
datalogger_t_5 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 6"; }
datalogger_t_6 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 7"; }
datalogger_t_7 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 8"; }
datalogger_t_8 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 9"; }
datalogger_t_9 		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 10"; }
datalogger_t_10		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 11"; }
datalogger_t_11		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 12"; }
datalogger_t_12		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 13"; }
datalogger_t_13		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 14"; }
datalogger_t_14		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 15"; }
datalogger_t_15		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 16"; }
datalogger_t_16		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 17"; }
datalogger_t_17		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 18"; }
datalogger_t_18		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 19"; }
datalogger_t_19		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 20"; }
datalogger_t_20		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 21"; }
datalogger_t_21		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 22"; }
datalogger_t_22		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 23"; }
datalogger_t_23		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 24"; }
datalogger_t_24		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 25"; }
datalogger_t_25		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 26"; }
datalogger_t_26		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 27"; }
datalogger_t_27		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 28"; }
datalogger_t_28		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 29"; }
datalogger_t_29		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 30"; }
datalogger_t_30		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 31"; }
datalogger_t_31		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 32"; }
datalogger_t_32		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 33"; }
datalogger_t_33		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 34"; }
datalogger_t_34		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 35"; }
datalogger_t_35		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 36"; }
datalogger_t_36		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 37"; }
datalogger_t_37		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 38"; }
datalogger_t_38		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 39"; }
datalogger_t_39		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 40"; }
datalogger_t_40		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 41"; }
datalogger_t_41		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 42"; }
datalogger_t_42		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 43"; }
datalogger_t_43		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 44"; }
datalogger_t_44		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 45"; }
datalogger_t_45		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 46"; }
datalogger_t_46		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 47"; }
datalogger_t_47		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 48"; }
datalogger_t_48		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 49"; }
datalogger_t_49		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 50"; }
datalogger_t_50		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 51"; }
datalogger_t_51		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 52"; }
datalogger_t_52		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 53"; }
datalogger_t_53		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 54"; }
datalogger_t_54		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 55"; }
datalogger_t_55		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 56"; }
datalogger_t_56		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 57"; }
datalogger_t_57		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 58"; }
datalogger_t_58		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 59"; }
datalogger_t_59		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 60"; }
datalogger_t_60		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 61"; }
datalogger_t_61		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 62"; }
datalogger_t_62		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 63"; }
datalogger_t_63		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 64"; }
datalogger_t_64		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 65"; }
datalogger_t_65		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 66"; }
datalogger_t_66		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 67"; }
datalogger_t_67		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 68"; }
datalogger_t_68		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 69"; }
datalogger_t_69		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 70"; }
datalogger_t_70		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 71"; }
datalogger_t_71		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 72"; }
datalogger_t_72		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 73"; }
datalogger_t_73		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 74"; }
datalogger_t_74		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 75"; }
datalogger_t_75		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 76"; }
datalogger_t_76		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 77"; }
datalogger_t_77		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 78"; }
datalogger_t_78		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 79"; }
datalogger_t_79		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 80"; }
datalogger_t_80		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 81"; }
datalogger_t_81		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 82"; }
datalogger_t_82		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 83"; }
datalogger_t_83		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 84"; }
datalogger_t_84		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 85"; }
datalogger_t_85		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 86"; }
datalogger_t_86		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 87"; }
datalogger_t_87		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 88"; }
datalogger_t_88		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 89"; }
datalogger_t_89		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 90"; }
datalogger_t_90		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 91"; }
datalogger_t_91		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 92"; }
datalogger_t_92		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 93"; }
datalogger_t_93		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 94"; }
datalogger_t_94		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 95"; }
datalogger_t_95		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 96"; }
datalogger_t_96		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 97"; }
datalogger_t_97		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 98"; }
datalogger_t_98		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 99"; }
datalogger_t_99		LIKE  VARIABLE  		datalogger_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 100"; }


/* float 900...999 */

VARIABLE datalogger_vs_0
{
  LABEL    "Ventilstellung x - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Ventilstellung x";
}

datalogger_vs_1 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 2"; }
datalogger_vs_2 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 3"; }
datalogger_vs_3 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 4"; }
datalogger_vs_4 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 5"; }
datalogger_vs_5 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 6"; }
datalogger_vs_6 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 7"; }
datalogger_vs_7 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 8"; }
datalogger_vs_8 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 9"; }
datalogger_vs_9 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 10"; }
datalogger_vs_10 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 11"; }
datalogger_vs_11 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 12"; }
datalogger_vs_12 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 13"; }
datalogger_vs_13 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 14"; }
datalogger_vs_14 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 15"; }
datalogger_vs_15 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 16"; }
datalogger_vs_16 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 17"; }
datalogger_vs_17 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 18"; }
datalogger_vs_18 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 19"; }
datalogger_vs_19 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 20"; }
datalogger_vs_20 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 21"; }
datalogger_vs_21 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 22"; }
datalogger_vs_22 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 23"; }
datalogger_vs_23 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 24"; }
datalogger_vs_24 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 25"; }
datalogger_vs_25 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 26"; }
datalogger_vs_26 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 27"; }
datalogger_vs_27 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 28"; }
datalogger_vs_28 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 29"; }
datalogger_vs_29 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 30"; }
datalogger_vs_30 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 31"; }
datalogger_vs_31 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 32"; }
datalogger_vs_32 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 33"; }
datalogger_vs_33 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 34"; }
datalogger_vs_34 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 35"; }
datalogger_vs_35 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 36"; }
datalogger_vs_36 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 37"; }
datalogger_vs_37 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 38"; }
datalogger_vs_38 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 39"; }
datalogger_vs_39 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 40"; }
datalogger_vs_40 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 41"; }
datalogger_vs_41 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 42"; }
datalogger_vs_42 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 43"; }
datalogger_vs_43 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 44"; }
datalogger_vs_44 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 45"; }
datalogger_vs_45 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 46"; }
datalogger_vs_46 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 47"; }
datalogger_vs_47 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 48"; }
datalogger_vs_48 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 49"; }
datalogger_vs_49 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 50"; }
datalogger_vs_50 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 51"; }
datalogger_vs_51 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 52"; }
datalogger_vs_52 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 53"; }
datalogger_vs_53 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 54"; }
datalogger_vs_54 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 55"; }
datalogger_vs_55 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 56"; }
datalogger_vs_56 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 57"; }
datalogger_vs_57 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 58"; }
datalogger_vs_58 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 59"; }
datalogger_vs_59 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 60"; }
datalogger_vs_60 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 61"; }
datalogger_vs_61 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 62"; }
datalogger_vs_62 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 63"; }
datalogger_vs_63 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 64"; }
datalogger_vs_64 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 65"; }
datalogger_vs_65 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 66"; }
datalogger_vs_66 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 67"; }
datalogger_vs_67 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 68"; }
datalogger_vs_68 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 69"; }
datalogger_vs_69 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 70"; }
datalogger_vs_70 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 71"; }
datalogger_vs_71 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 72"; }
datalogger_vs_72 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 73"; }
datalogger_vs_73 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 74"; }
datalogger_vs_74 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 75"; }
datalogger_vs_75 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 76"; }
datalogger_vs_76 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 77"; }
datalogger_vs_77 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 78"; }
datalogger_vs_78 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 79"; }
datalogger_vs_79 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 80"; }
datalogger_vs_80 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 81"; }
datalogger_vs_81 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 82"; }
datalogger_vs_82 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 83"; }
datalogger_vs_83 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 84"; }
datalogger_vs_84 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 85"; }
datalogger_vs_85 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 86"; }
datalogger_vs_86 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 87"; }
datalogger_vs_87 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 88"; }
datalogger_vs_88 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 89"; }
datalogger_vs_89 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 90"; }
datalogger_vs_90 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 91"; }
datalogger_vs_91 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 92"; }
datalogger_vs_92 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 93"; }
datalogger_vs_93 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 94"; }
datalogger_vs_94 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 95"; }
datalogger_vs_95 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 96"; }
datalogger_vs_96 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 97"; }
datalogger_vs_97 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 98"; }
datalogger_vs_98 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 99"; }
datalogger_vs_99 		LIKE  VARIABLE  		datalogger_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 100"; }


/* float 700...799 */

VARIABLE datalogger_sw_0
{
  LABEL    "Sollwert w - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Sollwert w";
}

datalogger_sw_1 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 2"; }
datalogger_sw_2 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 3"; }
datalogger_sw_3 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 4"; }
datalogger_sw_4 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 5"; }
datalogger_sw_5 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 6"; }
datalogger_sw_6 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 7"; }
datalogger_sw_7 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 8"; }
datalogger_sw_8 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 9"; }
datalogger_sw_9 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 10"; }
datalogger_sw_10 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 11"; }
datalogger_sw_11 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 12"; }
datalogger_sw_12 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 13"; }
datalogger_sw_13 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 14"; }
datalogger_sw_14 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 15"; }
datalogger_sw_15 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 16"; }
datalogger_sw_16 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 17"; }
datalogger_sw_17 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 18"; }
datalogger_sw_18 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 19"; }
datalogger_sw_19 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 20"; }
datalogger_sw_20 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 21"; }
datalogger_sw_21 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 22"; }
datalogger_sw_22 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 23"; }
datalogger_sw_23 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 24"; }
datalogger_sw_24 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 25"; }
datalogger_sw_25 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 26"; }
datalogger_sw_26 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 27"; }
datalogger_sw_27 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 28"; }
datalogger_sw_28 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 29"; }
datalogger_sw_29 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 30"; }
datalogger_sw_30 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 31"; }
datalogger_sw_31 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 32"; }
datalogger_sw_32 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 33"; }
datalogger_sw_33 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 34"; }
datalogger_sw_34 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 35"; }
datalogger_sw_35 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 36"; }
datalogger_sw_36 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 37"; }
datalogger_sw_37 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 38"; }
datalogger_sw_38 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 39"; }
datalogger_sw_39 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 40"; }
datalogger_sw_40 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 41"; }
datalogger_sw_41 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 42"; }
datalogger_sw_42 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 43"; }
datalogger_sw_43 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 44"; }
datalogger_sw_44 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 45"; }
datalogger_sw_45 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 46"; }
datalogger_sw_46 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 47"; }
datalogger_sw_47 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 48"; }
datalogger_sw_48 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 49"; }
datalogger_sw_49 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 50"; }
datalogger_sw_50 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 51"; }
datalogger_sw_51 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 52"; }
datalogger_sw_52 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 53"; }
datalogger_sw_53 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 54"; }
datalogger_sw_54 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 55"; }
datalogger_sw_55 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 56"; }
datalogger_sw_56 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 57"; }
datalogger_sw_57 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 58"; }
datalogger_sw_58 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 59"; }
datalogger_sw_59 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 60"; }
datalogger_sw_60 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 61"; }
datalogger_sw_61 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 62"; }
datalogger_sw_62 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 63"; }
datalogger_sw_63 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 64"; }
datalogger_sw_64 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 65"; }
datalogger_sw_65 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 66"; }
datalogger_sw_66 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 67"; }
datalogger_sw_67 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 68"; }
datalogger_sw_68 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 69"; }
datalogger_sw_69 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 70"; }
datalogger_sw_70 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 71"; }
datalogger_sw_71 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 72"; }
datalogger_sw_72 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 73"; }
datalogger_sw_73 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 74"; }
datalogger_sw_74 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 75"; }
datalogger_sw_75 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 76"; }
datalogger_sw_76 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 77"; }
datalogger_sw_77 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 78"; }
datalogger_sw_78 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 79"; }
datalogger_sw_79 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 80"; }
datalogger_sw_80 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 81"; }
datalogger_sw_81 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 82"; }
datalogger_sw_82 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 83"; }
datalogger_sw_83 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 84"; }
datalogger_sw_84 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 85"; }
datalogger_sw_85 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 86"; }
datalogger_sw_86 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 87"; }
datalogger_sw_87 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 88"; }
datalogger_sw_88 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 89"; }
datalogger_sw_89 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 90"; }
datalogger_sw_90 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 91"; }
datalogger_sw_91 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 92"; }
datalogger_sw_92 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 93"; }
datalogger_sw_93 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 94"; }
datalogger_sw_94 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 95"; }
datalogger_sw_95 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 96"; }
datalogger_sw_96 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 97"; }
datalogger_sw_97 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 98"; }
datalogger_sw_98 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 99"; }
datalogger_sw_99 		LIKE  VARIABLE  		datalogger_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 100"; }


/* float 800...899 */

VARIABLE datalogger_e_0
{
  LABEL    "Regelabweichung e - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Regelabweichung e";
}

datalogger_e_1 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 2"; }
datalogger_e_2 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 3"; }
datalogger_e_3 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 4"; }
datalogger_e_4 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 5"; }
datalogger_e_5 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 6"; }
datalogger_e_6 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 7"; }
datalogger_e_7 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 8"; }
datalogger_e_8 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 9"; }
datalogger_e_9 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 10"; }
datalogger_e_10 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 11"; }
datalogger_e_11 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 12"; }
datalogger_e_12 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 13"; }
datalogger_e_13 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 14"; }
datalogger_e_14 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 15"; }
datalogger_e_15 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 16"; }
datalogger_e_16 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 17"; }
datalogger_e_17 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 18"; }
datalogger_e_18 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 19"; }
datalogger_e_19 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 20"; }
datalogger_e_20 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 21"; }
datalogger_e_21 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 22"; }
datalogger_e_22 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 23"; }
datalogger_e_23 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 24"; }
datalogger_e_24 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 25"; }
datalogger_e_25 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 26"; }
datalogger_e_26 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 27"; }
datalogger_e_27 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 28"; }
datalogger_e_28 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 29"; }
datalogger_e_29 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 30"; }
datalogger_e_30 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 31"; }
datalogger_e_31 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 32"; }
datalogger_e_32 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 33"; }
datalogger_e_33 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 34"; }
datalogger_e_34 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 35"; }
datalogger_e_35 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 36"; }
datalogger_e_36 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 37"; }
datalogger_e_37 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 38"; }
datalogger_e_38 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 39"; }
datalogger_e_39 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 40"; }
datalogger_e_40 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 41"; }
datalogger_e_41 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 42"; }
datalogger_e_42 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 43"; }
datalogger_e_43 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 44"; }
datalogger_e_44 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 45"; }
datalogger_e_45 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 46"; }
datalogger_e_46 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 47"; }
datalogger_e_47 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 48"; }
datalogger_e_48 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 49"; }
datalogger_e_49 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 50"; }
datalogger_e_50 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 51"; }
datalogger_e_51 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 52"; }
datalogger_e_52 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 53"; }
datalogger_e_53 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 54"; }
datalogger_e_54 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 55"; }
datalogger_e_55 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 56"; }
datalogger_e_56 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 57"; }
datalogger_e_57 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 58"; }
datalogger_e_58 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 59"; }
datalogger_e_59 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 60"; }
datalogger_e_60 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 61"; }
datalogger_e_61 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 62"; }
datalogger_e_62 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 63"; }
datalogger_e_63 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 64"; }
datalogger_e_64 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 65"; }
datalogger_e_65 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 66"; }
datalogger_e_66 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 67"; }
datalogger_e_67 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 68"; }
datalogger_e_68 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 69"; }
datalogger_e_69 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 70"; }
datalogger_e_70 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 71"; }
datalogger_e_71 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 72"; }
datalogger_e_72 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 73"; }
datalogger_e_73 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 74"; }
datalogger_e_74 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 75"; }
datalogger_e_75 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 76"; }
datalogger_e_76 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 77"; }
datalogger_e_77 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 78"; }
datalogger_e_78 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 79"; }
datalogger_e_79 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 80"; }
datalogger_e_80 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 81"; }
datalogger_e_81 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 82"; }
datalogger_e_82 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 83"; }
datalogger_e_83 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 84"; }
datalogger_e_84 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 85"; }
datalogger_e_85 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 86"; }
datalogger_e_86 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 87"; }
datalogger_e_87 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 88"; }
datalogger_e_88 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 89"; }
datalogger_e_89 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 90"; }
datalogger_e_90 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 91"; }
datalogger_e_91 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 92"; }
datalogger_e_92 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 93"; }
datalogger_e_93 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 94"; }
datalogger_e_94 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 95"; }
datalogger_e_95 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 96"; }
datalogger_e_96 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 97"; }
datalogger_e_97 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 98"; }
datalogger_e_98 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 99"; }
datalogger_e_99 		LIKE  VARIABLE  		datalogger_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 100"; }


/* unsigned int 400...499 */

VARIABLE datalogger_ss_0
{
  LABEL    "Stellsignal y - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
  HELP     "|de|Stellsignal y";
}

datalogger_ss_1 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 2"; }
datalogger_ss_2 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 3"; }
datalogger_ss_3 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 4"; }
datalogger_ss_4 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 5"; }
datalogger_ss_5 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 6"; }
datalogger_ss_6 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 7"; }
datalogger_ss_7 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 8"; }
datalogger_ss_8 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 9"; }
datalogger_ss_9 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 10"; }
datalogger_ss_10 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 11"; }
datalogger_ss_11 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 12"; }
datalogger_ss_12 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 13"; }
datalogger_ss_13 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 14"; }
datalogger_ss_14 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 15"; }
datalogger_ss_15 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 16"; }
datalogger_ss_16 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 17"; }
datalogger_ss_17 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 18"; }
datalogger_ss_18 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 19"; }
datalogger_ss_19 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 20"; }
datalogger_ss_20 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 21"; }
datalogger_ss_21 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 22"; }
datalogger_ss_22 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 23"; }
datalogger_ss_23 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 24"; }
datalogger_ss_24 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 25"; }
datalogger_ss_25 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 26"; }
datalogger_ss_26 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 27"; }
datalogger_ss_27 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 28"; }
datalogger_ss_28 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 29"; }
datalogger_ss_29 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 30"; }
datalogger_ss_30 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 31"; }
datalogger_ss_31 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 32"; }
datalogger_ss_32 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 33"; }
datalogger_ss_33 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 34"; }
datalogger_ss_34 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 35"; }
datalogger_ss_35 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 36"; }
datalogger_ss_36 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 37"; }
datalogger_ss_37 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 38"; }
datalogger_ss_38 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 39"; }
datalogger_ss_39 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 40"; }
datalogger_ss_40 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 41"; }
datalogger_ss_41 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 42"; }
datalogger_ss_42 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 43"; }
datalogger_ss_43 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 44"; }
datalogger_ss_44 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 45"; }
datalogger_ss_45 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 46"; }
datalogger_ss_46 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 47"; }
datalogger_ss_47 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 48"; }
datalogger_ss_48 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 49"; }
datalogger_ss_49 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 50"; }
datalogger_ss_50 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 51"; }
datalogger_ss_51 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 52"; }
datalogger_ss_52 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 53"; }
datalogger_ss_53 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 54"; }
datalogger_ss_54 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 55"; }
datalogger_ss_55 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 56"; }
datalogger_ss_56 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 57"; }
datalogger_ss_57 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 58"; }
datalogger_ss_58 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 59"; }
datalogger_ss_59 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 60"; }
datalogger_ss_60 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 61"; }
datalogger_ss_61 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 62"; }
datalogger_ss_62 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 63"; }
datalogger_ss_63 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 64"; }
datalogger_ss_64 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 65"; }
datalogger_ss_65 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 66"; }
datalogger_ss_66 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 67"; }
datalogger_ss_67 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 68"; }
datalogger_ss_68 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 69"; }
datalogger_ss_69 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 70"; }
datalogger_ss_70 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 71"; }
datalogger_ss_71 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 72"; }
datalogger_ss_72 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 73"; }
datalogger_ss_73 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 74"; }
datalogger_ss_74 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 75"; }
datalogger_ss_75 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 76"; }
datalogger_ss_76 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 77"; }
datalogger_ss_77 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 78"; }
datalogger_ss_78 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 79"; }
datalogger_ss_79 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 80"; }
datalogger_ss_80 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 81"; }
datalogger_ss_81 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 82"; }
datalogger_ss_82 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 83"; }
datalogger_ss_83 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 84"; }
datalogger_ss_84 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 85"; }
datalogger_ss_85 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 86"; }
datalogger_ss_86 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 87"; }
datalogger_ss_87 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 88"; }
datalogger_ss_88 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 89"; }
datalogger_ss_89 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 90"; }
datalogger_ss_90 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 91"; }
datalogger_ss_91 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 92"; }
datalogger_ss_92 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 93"; }
datalogger_ss_93 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 94"; }
datalogger_ss_94 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 95"; }
datalogger_ss_95 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 96"; }
datalogger_ss_96 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 97"; }
datalogger_ss_97 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 98"; }
datalogger_ss_98 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 99"; }
datalogger_ss_99 		LIKE  VARIABLE  		datalogger_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 100"; }



/* ------------------------------------------------------------------------ */
/* 2.2 Histogramm - Ventilstellung X                                        */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/*
VARIABLE his_x_mittelwert_int_1 (unsigned_char_288)
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x)
*/
VARIABLE his_x_mittelwert_int_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Average values x long" "|de|Mittelwert x Lang";
  #else
  LABEL    "Average values x long";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
/*  CONSTANT_UNIT "%";*/
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
  #else
    {  0, "No data read" },
  #endif
    {  1, "x <= 0%"         },
    {  2, "0% < x <= 5%"    },
    {  3, "5% < x <= 10%"   },
    {  4, "10% < x <= 15%"  },
    {  5, "15% < x <= 20%"  },
    {  6, "20% < x <= 25%"  },
    {  7, "25% < x <= 30%"  },
    {  8, "30% < x <= 35%"  },
    {  9, "35% < x <= 40%"  },
    { 10, "40% < x <= 45%"  },
    { 11, "45% < x <= 50%"  },
    { 12, "50% < x <= 55%"  },
    { 13, "55% < x <= 60%"  },
    { 14, "60% < x <= 65%"  },
    { 15, "65% < x <= 70%"  },
    { 16, "70% < x <= 75%"  },
    { 17, "75% < x <= 80%"  },
    { 18, "80% < x <= 85%"  },
    { 19, "85% < x <= 90%"  },
    { 20, "90% < x <= 95%"  },
    { 21, "95% < x <= 100%" },
    { 22, "x > 100%"        }
  }
#ifdef HELP_EP_DE_EN
  HELP     "Information on the average interval assignment."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE his_x_anzahl_messpunkte (unsigned_long_34)
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x)
*/
VARIABLE his_x_anzahl_messpunkte
{
  #ifdef LABEL_DE_EN
  LABEL    "Number of measurement points" "|de|Anzahl";
  #else
  LABEL    "Number of measurement points";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
#ifdef HELP_EP_DE_EN
  HELP     "Information on the previous recorded measured data."
           "|de|Angabe ber die bisher aufgenommenen Messwerte.";
#endif
}


/* ------------------------------------------------------------------------ */
/* unsigned char 73..94
*/
VARIABLE x_interval_value_0
{
  LABEL    "x <= 0%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);

  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Classified valve position."
           "|de|Klassifizierter Ventilaufenthalt.";
#endif
}

x_interval_value_1 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "0% < x <= 5%"; }
x_interval_value_2 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "5% < x <= 10%"; }
x_interval_value_3 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "10% < x <= 15%"; }
x_interval_value_4 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "15% < x <= 20%"; }
x_interval_value_5 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "20% < x <= 25%"; }
x_interval_value_6 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "25% < x <= 30%"; }
x_interval_value_7 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "30% < x <= 35%"; }
x_interval_value_8 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "35% < x <= 40%"; }
x_interval_value_9 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "40% < x <= 45%"; }
x_interval_value_10 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "45% < x <= 50%"; }
x_interval_value_11 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "50% < x <= 55%"; }
x_interval_value_12 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "55% < x <= 60%"; }
x_interval_value_13 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "60% < x <= 65%"; }
x_interval_value_14 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "65% < x <= 70%"; }
x_interval_value_15 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "70% < x <= 75%"; }
x_interval_value_16 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "75% < x <= 80%"; }
x_interval_value_17 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "80% < x <= 85%"; }
x_interval_value_18 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "85% < x <= 90%"; }
x_interval_value_19 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "90% < x <= 95%"; }
x_interval_value_20 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "95% < x <= 100%"; }
x_interval_value_21 LIKE  VARIABLE  x_interval_value_0
{ REDEFINE LABEL "x > 100%"; }


/* Histogramm - Ventilstellung X - Kurzzeitbetrachtung */

/* ------------------------------------------------------------------------ */
/* unsigned_char_289
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x - Kz.)
*/
VARIABLE his_x_mittelwert_kurz
{
  #ifdef LABEL_DE_EN
  LABEL    "Average values x short" "|de|Mittelwert x Kurz";
  #else
  LABEL    "Average values x short";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
  #else
    {  0, "No data read" },
  #endif
    {  1, "x <= 0%"         },
    {  2, "0% < x <= 5%"    },
    {  3, "5% < x <= 10%"   },
    {  4, "10% < x <= 15%"  },
    {  5, "15% < x <= 20%"  },
    {  6, "20% < x <= 25%"  },
    {  7, "25% < x <= 30%"  },
    {  8, "30% < x <= 35%"  },
    {  9, "35% < x <= 40%"  },
    { 10, "40% < x <= 45%"  },
    { 11, "45% < x <= 50%"  },
    { 12, "50% < x <= 55%"  },
    { 13, "55% < x <= 60%"  },
    { 14, "60% < x <= 65%"  },
    { 15, "65% < x <= 70%"  },
    { 16, "70% < x <= 75%"  },
    { 17, "75% < x <= 80%"  },
    { 18, "80% < x <= 85%"  },
    { 19, "85% < x <= 90%"  },
    { 20, "90% < x <= 95%"  },
    { 21, "95% < x <= 100%" },
    { 22, "x > 100%"        }
  }
/*  CONSTANT_UNIT "%";*/

#ifdef HELP_EP_DE_EN
  HELP     "Classified valve position - recorded in a ring buffer of 100 values."
           "|de|Klassifizierter Ventilaufenthalt - aufgenommen in einem "
           "Ringpuffer von 100 Werten.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_integer_196
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x - Kz.)
*/
VARIABLE sample_rate_st_hist
{
  #ifdef LABEL_DE_EN
  LABEL    "Scan rate short-term histogram"
           "|de|Abtastrate Kurzzeithistogramm";
  #else
  LABEL    "Scan rate short-term histogram";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
    DEFAULT_VALUE  1;
    MIN_VALUE    1; /* 1s */
    MAX_VALUE 3600; /* 3600s */
  }
  CONSTANT_UNIT "s";

#ifdef HELP_EP_DE_EN
  HELP     "Scan rate of the recording of the valve positions for the "
           "short-term histogram."
           "|de|Abtastrate der Aufnahme der Ventilstellungen fr das "
           "Kurzzeithistogramm.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 95..116
*/
VARIABLE x_interval_value_kz_0
{
  LABEL    "x <= 0%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);

  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Classified valve position." "|de|Klassifizierter Ventilaufenthalt";
#endif
}

x_interval_value_kz_1 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "0% < x <= 5%"; }
x_interval_value_kz_2 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "5% < x <= 10%"; }
x_interval_value_kz_3 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "10% < x <= 15%"; }
x_interval_value_kz_4 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "15% < x <= 20%"; }
x_interval_value_kz_5 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "20% < x <= 25%"; }
x_interval_value_kz_6 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "25% < x <= 30%"; }
x_interval_value_kz_7 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "30% < x <= 35%"; }
x_interval_value_kz_8 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "35% < x <= 40%"; }
x_interval_value_kz_9 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "40% < x <= 45%"; }
x_interval_value_kz_10 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "45% < x <= 50%"; }
x_interval_value_kz_11 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "50% < x <= 55%"; }
x_interval_value_kz_12 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "55% < x <= 60%"; }
x_interval_value_kz_13 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "60% < x <= 65%"; }
x_interval_value_kz_14 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "65% < x <= 70%"; }
x_interval_value_kz_15 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "70% < x <= 75%"; }
x_interval_value_kz_16 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "75% < x <= 80%"; }
x_interval_value_kz_17 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "80% < x <= 85%"; }
x_interval_value_kz_18 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "85% < x <= 90%"; }
x_interval_value_kz_19 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "90% < x <= 95%"; }
x_interval_value_kz_20 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "95% < x <= 100%"; }
x_interval_value_kz_21 LIKE  VARIABLE  x_interval_value_kz_0
{ REDEFINE LABEL "x > 100%"; }


/* ------------------------------------------------------------------------ */
/* 2.3   Histogramm - Regelabweichung                                       */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE deviation_min (float 7)
*/
VARIABLE deviation_min
{
  #ifdef LABEL_DE_EN
  LABEL    "Min. setpoint deviation" "|de|Min. Regelabweichung";
  #else
  LABEL    "Min. setpoint deviation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Smallest measured setpoint deviation."
           "|de|Kleinste gemessene Regelabweichung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE deviation_max (float 8)
*/
VARIABLE deviation_max
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. setpoint deviation" "|de|Max. Regelabweichung";
  #else
  LABEL    "Max. setpoint deviation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Greatest measured setpoint deviation."
           "|de|Grte gemessene Regelabweichung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE mittelwert_e_lang (unsigned char 290)
*/
VARIABLE mittelwert_e_lang
{
  #ifdef LABEL_DE_EN
  LABEL    "Average values e long" "|de|Mittelwert e Lang";
  #else
  LABEL    "Average values e long";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
  #else
    {  0, "No data read" },
  #endif
    {  1, "e <= -5%"            },
    {  2, "-5% < e <= -1%"      },
    {  3, "-1% < e <= -0.5%"    },
    {  4, "-0.5% < e <= -0.2%"  },
    {  5, "-0.2% < e <= -0.1%"  },
    {  6, "-0.1% < e <= 0%"     },
    {  7, "0% < e <= 0.1%"      },
    {  8, "0.1% < e <= 0.2%"    },
    {  9, "0.2% < e <= 0.5%"    },
    { 10, "0.5% < e <= 1%"      },
    { 11, "1% < e <= 5%"        },
    { 12, "e > 5%"              }
  }
/*  CONSTANT_UNIT "%";*/

#ifdef HELP_EP_DE_EN
  HELP     "Information on the average interval assignment."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE gesamtanzahl (unsigned long 57)
*/
VARIABLE gesamtanzahl
{
  #ifdef LABEL_DE_EN
  LABEL    "Counter of all measured data" "|de|Gesamtanzahl";
  #else
  LABEL    "Counter of all measured data";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
#ifdef HELP_EP_DE_EN
  HELP     "Information on the previous recorded measured data."
           "|de|Angabe ber die bisher aufgenommenen klassifizierten Messwerte.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE e_interval_value_long_0 ... 21 (unsigned char 121..132)
*/
VARIABLE e_interval_value_long_0
{
  LABEL    "e  <= -5%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
}

e_interval_value_long_1 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "-5% < e  <= -1%"; }
e_interval_value_long_2 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "-1% < e  <= -0.5%"; }
e_interval_value_long_3 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "-0.5% < e  <= -0.2%"; }
e_interval_value_long_4 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "-0.2% < e  <= -0.1%"; }
e_interval_value_long_5 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "-0.1% < e  <= 0%"; }
e_interval_value_long_6 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "0% < e  <= 0.1%"; }
e_interval_value_long_7 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "0.1% < e  <= 0.2%"; }
e_interval_value_long_8 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "0.2% < e  <= 0.5%"; }
e_interval_value_long_9 LIKE   VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "0.5% < e  <= 1%"; }
e_interval_value_long_10 LIKE  VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "1% < e  <= 5%"; }
e_interval_value_long_11 LIKE  VARIABLE  e_interval_value_long_0
{ REDEFINE LABEL "e > 5%"; }


/* 2.3   Histogramm - Regelabweichung e - Kurzzeitbetrachtung */

/* ------------------------------------------------------------------------ */
/* unsigned_char_296
(Diagnose - Beobachterfunktionen AUTO - Histogramm Regelabweichung e - Kz.)
*/
VARIABLE his_e_mittelwert_kurz
{
  #ifdef LABEL_DE_EN
  LABEL    "Average values e short" "|de|Mittelwert e Kurz";
  #else
  LABEL    "Average values e short";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
  #else
    {  0, "No data read" },
  #endif
    {  1, "e <= -5%"            },
    {  2, "-5% < e <= -1%"      },
    {  3, "-1% < e <= -0.5%"    },
    {  4, "-0.5% < e <= -0.2%"  },
    {  5, "-0.2% < e <= -0.1%"  },
    {  6, "-0.1% < e <= 0%"     },
    {  7, "0% < e <= 0.1%"      },
    {  8, "0.1% < e <= 0.2%"    },
    {  9, "0.2% < e <= 0.5%"    },
    { 10, "0.5% < e <= 1%"      },
    { 11, "1% < e <= 5%"        },
    { 12, "e > 5%"              }
  }
/*  CONSTANT_UNIT "%";*/

#ifdef HELP_EP_DE_EN
  HELP     "Classified setpoint deviation - recorded in a ring buffer of 100 values."
           "|de|Klassifizierte Regelabweichung - aufgenommen in einem "
           "Ringpuffer von 100 Werten.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_integer_198
(Diagnose - Beobachterfunktionen AUTO - Histogramm Regelabweichung e - Kz.)
*/
VARIABLE sample_rate_st_hist_e
{
  #ifdef LABEL_DE_EN
  LABEL    "Scan rate short-term histogram"
           "|de|Abtastrate Kurzzeithistogramm";
  #else
  LABEL    "Scan rate short-term histogram";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
    DEFAULT_VALUE  1;
    MIN_VALUE    1; /* 1s */
    MAX_VALUE 3600; /* 3600s */
  }
  CONSTANT_UNIT "s";

#ifdef HELP_EP_DE_EN
  HELP     "Scan rate of the recording of the setpoint deviations for the "
           "short-term histogram."
           "|de|Abtastrate der Aufnahme der Regelabweichungen fr das "
           "Kurzzeithistogramm.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 133..144
*/
VARIABLE e_interval_value_short_0
{
  LABEL    "e  <= -5%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
}

e_interval_value_short_1 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "-5% < e  <= -1%"; }
e_interval_value_short_2 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "-1% < e  <= -0.5%"; }
e_interval_value_short_3 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "-0.5% < e  <= -0.2%"; }
e_interval_value_short_4 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "-0.2% < e  <= -0.1%"; }
e_interval_value_short_5 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "-0.1% < e  <= 0%"; }
e_interval_value_short_6 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "0% < e  <= 0.1%"; }
e_interval_value_short_7 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "0.1% < e  <= 0.2%"; }
e_interval_value_short_8 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "0.2% < e  <= 0.5%"; }
e_interval_value_short_9 LIKE   VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "0.5% < e  <= 1%"; }
e_interval_value_short_10 LIKE  VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "1% < e  <= 5%"; }
e_interval_value_short_11 LIKE  VARIABLE  e_interval_value_short_0
{ REDEFINE LABEL "e > 5%"; }


/* ------------------------------------------------------------------------ */
/* 2.4   Histogramm - Zyklenzhler                                          */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/* unsigned char 162..174
*/
VARIABLE his_z_intervallwert_0
{
  #ifdef LABEL_DE_EN
  LABEL    "0% < cycle <= 2%" "|de|0% < Zyklus <= 2%";
  #else
  LABEL    "0% < cycle <= 2%" ;
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Classified cycle span is shown in percent of the interval "
           "positions."
           "|de|Klassifizierte Zyklenspanne wird als Prozentwert der "
           "Intervallaufenthalte angegeben.";

#endif
}

his_z_intervallwert_1  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "2% < cycle <= 5%" "|de|2% < Zyklus <= 5%"  ; }
  #else
{ REDEFINE LABEL "2% < cycle <= 5%"   ; }
  #endif
his_z_intervallwert_2  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "5% < cycle <= 10%" "|de|5% < Zyklus <= 10%"  ; }
  #else
{ REDEFINE LABEL "5% < cycle <= 10%"  ; }
  #endif
his_z_intervallwert_3  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "10% < cycle <= 20%" "|de|10% < Zyklus <= 20%"  ; }
  #else
{ REDEFINE LABEL "10% < cycle <= 20%" ; }
  #endif
his_z_intervallwert_4  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "20% < cycle <= 30%" "|de|20% < Zyklus <= 30%"  ; }
  #else
{ REDEFINE LABEL "20% < cycle <= 30%" ; }
  #endif
his_z_intervallwert_5  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "30% < cycle <= 40%" "|de|30% < Zyklus <= 40%"  ; }
  #else
{ REDEFINE LABEL "30% < cycle <= 40%" ; }
  #endif
his_z_intervallwert_6  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "40% < cycle <= 50%" "|de|40% < Zyklus <= 50%"  ; }
  #else
{ REDEFINE LABEL "40% < cycle <= 50%" ; }
  #endif
his_z_intervallwert_7  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "50% < cycle <= 60%" "|de|50% < Zyklus <= 60%"  ; }
  #else
{ REDEFINE LABEL "50% < cycle <= 60%" ; }
  #endif
his_z_intervallwert_8  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "60% < cycle <= 70%" "|de|60% < Zyklus <= 70%"  ; }
  #else
{ REDEFINE LABEL "60% < cycle <= 70%" ; }
  #endif
his_z_intervallwert_9  LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "70% < cycle <= 80%" "|de|70% < Zyklus <= 80%"  ; }
  #else
{ REDEFINE LABEL "70% < cycle <= 80%" ; }
  #endif
his_z_intervallwert_10 LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "80% < cycle <= 90%" "|de|80% < Zyklus <= 90%"  ; }
  #else
{ REDEFINE LABEL "80% < cycle <= 90%" ; }
  #endif
his_z_intervallwert_11 LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"  ; }
  #else
{ REDEFINE LABEL "90% < cycle <= 100%" ; }
  #endif
his_z_intervallwert_12 LIKE  VARIABLE  his_z_intervallwert_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Cycle > 100%" "|de|Zyklus > 100%"  ; }
  #else
{ REDEFINE LABEL "Cycle > 100%"       ; }
  #endif

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_z_mittelwert_int (unsigned char 297; cmd 171/297)
*/
VARIABLE his_z_mittelwert_int
{
  #ifdef LABEL_DE_EN
  LABEL    "Average values z long" "|de|Mittelwert z Lang";
  #else
  LABEL    "Average values z long";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "No data read"        "|de|Keine Daten ausgelesen"   },
    {  1, "0% < cycle <= 2%"    "|de|0% < Zyklus <= 2%"        },
    {  2, "2% < cycle <= 5%"    "|de|2% < Zyklus <= 5%"        },
    {  3, "5% < cycle <= 10%"   "|de|5% < Zyklus <= 10%"       },
    {  4, "10% < cycle <= 20%"  "|de|10% < Zyklus <= 20%"      },
    {  5, "20% < cycle <= 30%"  "|de|20% < Zyklus <= 30%"      },
    {  6, "30% < cycle <= 40%"  "|de|30% < Zyklus <= 40%"      },
    {  7, "40% < cycle <= 50%"  "|de|40% < Zyklus <= 50%"      },
    {  8, "50% < cycle <= 60%"  "|de|50% < Zyklus <= 60%"      },
    {  9, "60% < cycle <= 70%"  "|de|60% < Zyklus <= 70%"      },
    { 10, "70% < cycle <= 80%"  "|de|70% < Zyklus <= 80%"      },
    { 11, "80% < cycle <= 90%"  "|de|80% < Zyklus <= 90%"      },
    { 12, "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"     },
    { 13, "Cycle > 100%"        "|de|Zyklus > 100%"            }
  #else
    {  0, "No data read"        },
    {  1, "0% < cycle <= 2%"    },
    {  2, "2% < cycle <= 5%"    },
    {  3, "5% < cycle <= 10%"   },
    {  4, "10% < cycle <= 20%"  },
    {  5, "20% < cycle <= 30%"  },
    {  6, "30% < cycle <= 40%"  },
    {  7, "40% < cycle <= 50%"  },
    {  8, "50% < cycle <= 60%"  },
    {  9, "60% < cycle <= 70%"  },
    { 10, "70% < cycle <= 80%"  },
    { 11, "80% < cycle <= 90%"  },
    { 12, "90% < cycle <= 100%" },
    { 13, "Cycle > 100%"        }
  #endif
  }
/*  CONSTANT_UNIT "%";*/

#ifdef HELP_EP_DE_EN
  HELP     "Information on the average interval assignment."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_z_gesamtanzahl (unsigned long 70)
*/
VARIABLE his_z_gesamtanzahl
{
  #ifdef LABEL_DE_EN
  LABEL    "Counter of all measured data" "|de|Gesamtanzahl";
  #else
  LABEL    "Counter of all measured data";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
#ifdef HELP_EP_DE_EN
  HELP     "Information on the previous recorded measured data."
           "|de|Angabe ber die bisher aufgenommenen klassifizierten Messwerte.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_z_dynamic_stress_factor (unsigned char 11)
*/
VARIABLE his_z_dynamic_stress_factor
{
  #ifdef LABEL_DE_EN
  LABEL    "Dynamic stress factor" "|de|Dynamischer Belastungsfaktor";
  #else
  LABEL    "Dynamic stress factor";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}


/* 2.4   Histogramm - Zyklenzhler - Kurzzeitbetrachtung */

/* ------------------------------------------------------------------------ */
/* unsigned_char_298
(Diagnose - Beobachterfunktionen AUTO - Histogramm Zyklenzhler z - Kz.)
*/
VARIABLE his_z_mittelwert_kurz
{
  #ifdef LABEL_DE_EN
  LABEL    "Average values z short" "|de|Mittelwert z Kurz";
  #else
  LABEL    "Average values z short";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
/*  CONSTANT_UNIT "%";*/
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "No data read"        "|de|Keine Daten ausgelesen"   },
    {  1, "0% < cycle <= 2%"    "|de|0% < Zyklus <= 2%"        },
    {  2, "2% < cycle <= 5%"    "|de|2% < Zyklus <= 5%"        },
    {  3, "5% < cycle <= 10%"   "|de|5% < Zyklus <= 10%"       },
    {  4, "10% < cycle <= 20%"  "|de|10% < Zyklus <= 20%"      },
    {  5, "20% < cycle <= 30%"  "|de|20% < Zyklus <= 30%"      },
    {  6, "30% < cycle <= 40%"  "|de|30% < Zyklus <= 40%"      },
    {  7, "40% < cycle <= 50%"  "|de|40% < Zyklus <= 50%"      },
    {  8, "50% < cycle <= 60%"  "|de|50% < Zyklus <= 60%"      },
    {  9, "60% < cycle <= 70%"  "|de|60% < Zyklus <= 70%"      },
    { 10, "70% < cycle <= 80%"  "|de|70% < Zyklus <= 80%"      },
    { 11, "80% < cycle <= 90%"  "|de|80% < Zyklus <= 90%"      },
    { 12, "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"     },
    { 13, "Cycle > 100%"        "|de|Zyklus > 100%"            }
  #else
    {  0, "No data read"        },
    {  1, "0% < cycle <= 2%"    },
    {  2, "2% < cycle <= 5%"    },
    {  3, "5% < cycle <= 10%"   },
    {  4, "10% < cycle <= 20%"  },
    {  5, "20% < cycle <= 30%"  },
    {  6, "30% < cycle <= 40%"  },
    {  7, "40% < cycle <= 50%"  },
    {  8, "50% < cycle <= 60%"  },
    {  9, "60% < cycle <= 70%"  },
    { 10, "70% < cycle <= 80%"  },
    { 11, "80% < cycle <= 90%"  },
    { 12, "90% < cycle <= 100%" },
    { 13, "Cycle > 100%"        }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Information on the average interval assignment, formed over "
           "the recorded values of the ring buffer."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten, "
           "gebildet ber die aufgenommenen Werte im Ringpuffer.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 175..187
*/
VARIABLE his_z_intervallwert_short_0
{
  #ifdef LABEL_DE_EN
  LABEL    "0% < cycle <= 2%" "|de|0% < Zyklus <= 2%";
  #else
  LABEL    "0% < cycle <= 2%" ;
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Classified cycle span is shown in percent of the interval "
           "positions."
           "|de|Klassifizierte Zyklenspanne wird als Prozentwert der "
           "Intervallaufenthalte angegeben.";

#endif
}

his_z_intervallwert_short_1  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "2% < cycle <= 5%" "|de|2% < Zyklus <= 5%"  ; }
  #else
{ REDEFINE LABEL "2% < cycle <= 5%"   ; }
  #endif
his_z_intervallwert_short_2  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "5% < cycle <= 10%" "|de|5% < Zyklus <= 10%"  ; }
  #else
{ REDEFINE LABEL "5% < cycle <= 10%"  ; }
  #endif
his_z_intervallwert_short_3  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "10% < cycle <= 20%" "|de|10% < Zyklus <= 20%"  ; }
  #else
{ REDEFINE LABEL "10% < cycle <= 20%" ; }
  #endif
his_z_intervallwert_short_4  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "20% < cycle <= 30%" "|de|20% < Zyklus <= 30%"  ; }
  #else
{ REDEFINE LABEL "20% < cycle <= 30%" ; }
  #endif
his_z_intervallwert_short_5  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "30% < cycle <= 40%" "|de|30% < Zyklus <= 40%"  ; }
  #else
{ REDEFINE LABEL "30% < cycle <= 40%" ; }
  #endif
his_z_intervallwert_short_6  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "40% < cycle <= 50%" "|de|40% < Zyklus <= 50%"  ; }
  #else
{ REDEFINE LABEL "40% < cycle <= 50%" ; }
  #endif
his_z_intervallwert_short_7  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "50% < cycle <= 60%" "|de|50% < Zyklus <= 60%"  ; }
  #else
{ REDEFINE LABEL "50% < cycle <= 60%" ; }
  #endif
his_z_intervallwert_short_8  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "60% < cycle <= 70%" "|de|60% < Zyklus <= 70%"  ; }
  #else
{ REDEFINE LABEL "60% < cycle <= 70%" ; }
  #endif
his_z_intervallwert_short_9  LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "70% < cycle <= 80%" "|de|70% < Zyklus <= 80%"  ; }
  #else
{ REDEFINE LABEL "70% < cycle <= 80%" ; }
  #endif
his_z_intervallwert_short_10 LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "80% < cycle <= 90%" "|de|80% < Zyklus <= 90%"  ; }
  #else
{ REDEFINE LABEL "80% < cycle <= 90%" ; }
  #endif
his_z_intervallwert_short_11 LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"  ; }
  #else
{ REDEFINE LABEL "90% < cycle <= 100%" ; }
  #endif
his_z_intervallwert_short_12 LIKE  VARIABLE  his_z_intervallwert_short_0
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Cycle > 100%" "|de|Zyklus > 100%"  ; }
  #else
{ REDEFINE LABEL "Cycle > 100%"       ; }
  #endif


/* ------------------------------------------------------------------------ */
/* 2.5 Temperaturbetrachtung                                                */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/*
VARIABLE current_temperature (float 389; cmd 151/389)
*/
VARIABLE  current_temperature
{
  #ifdef LABEL_DE_EN
  LABEL    "Temperature" "|de|Temperatur";
  #else
  LABEL    "Temperature";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "C";
#ifdef HELP_EP_DE_EN
  HELP     "Current temperature of the positioner."
           "|de|Aktuelle Temperatur im Stellungsregler.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE max_temperature (float 369)
*/
VARIABLE max_temperature
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. temperature" "|de|Max. Temperatur";
  #else
  LABEL    "Max. temperature";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "C";
#ifdef HELP_EP_DE_EN
  HELP     "Highest recorded temperature inside the positioner."
           "|de|Hchste erfasste Temperatur im Stellungsregler.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_t_zeit_max_temperatur (unsigned long 192)
*/
VARIABLE his_t_zeit_max_temperatur
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. temperature (time)" "|de|Max. Temperatur (Zeit)";
  #else
  LABEL    "Max. temperature (time)";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours counter at the point of highest temperature "
           "inside the positioner."
           "|de|Betriebsstundenzhler zu der die hchste Temperatur im "
           "Stellungsregler erfasst wurde.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE min_temperature (float 370)
*/
VARIABLE min_temperature
{
  #ifdef LABEL_DE_EN
  LABEL    "Min. temperature" "|de|Min. Temperatur";
  #else
  LABEL    "Min. temperature";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "C";
#ifdef HELP_EP_DE_EN
  HELP     "Lowest recorded temperature of the positioner."
           "|de|Niedrigste erfasste Temperatur im Stellungsregler.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_t_zeit_min_temperatur (unsigned long 462)
*/
VARIABLE his_t_zeit_min_temperatur
{
  #ifdef LABEL_DE_EN
  LABEL    "Min. temperature (time)" "|de|Min. Temperatur (Zeit)";
  #else
  LABEL    "Min. temperature (time)";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Elapsed hours counter at the point of lowest temperature "
           "inside the positioner."
           "|de|Betriebsstundenzhler zu der die niedrigste Temperatur im "
           "Stellungsregler erfasst wurde.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE temp_period_time_high (unsigned long 465)
*/
VARIABLE temp_period_time_high
{
  #ifdef LABEL_DE_EN
  LABEL    "Period (temp > +80C)" "|de|Verweildauer (t > +80C)";
  #else
  LABEL    "Period (temp > +80C)";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Period of time the temperature is above +80C."
           "|de|Verweildauer der Temperatur oberhalb von +80C.";
#endif

  VALIDITY_ONLY_EXPERT_PLUS

}


/* ------------------------------------------------------------------------ */
/*
VARIABLE temp_period_time_low (unsigned long 463)
*/
VARIABLE temp_period_time_low
{
  #ifdef LABEL_DE_EN
  LABEL    "Period (temp < -40C)" "|de|Verweildauer (t < -40C)";
  #else
  LABEL    "Period (temp < -40C)";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Period of time the temperature is below -40C."
           "|de|Verweildauer der Temperatur unterhalb von -40C.";
#endif

  VALIDITY_ONLY_EXPERT_PLUS

}


/* ------------------------------------------------------------------------ */
/* 1.2 Erweitert                                                            */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: cmd 48: Byte 17: NAMUR-Sammel-Ampel-Status                    */
/* ------------------------------------------------------------------------ */
VARIABLE namur_sammelstatus
{
  #ifdef LABEL_DE_EN
  LABEL      "Condensed state" "|de|Sammelstatus";
  #else
  LABEL      "Condensed state";
  #endif

  CLASS      DEVICE & DYNAMIC;
  HANDLING   READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "No message"           "|de|Keine Meldung"       },
    { 1,   "Maintenance required" "|de|Wartungsbedarf"      },
    { 2,   "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3,   "Maintenance alarm"    "|de|Ausfall"             },
    { 7,   "Function check"       "|de|Funktionskontrolle"  }
  #else
    { 0,   "No message"           },
    { 1,   "Maintenance required" },
    { 2,   "Maintenance demanded" },
    { 3,   "Maintenance alarm"    },
    { 7,   "Function check"       }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Condensed state. Created by many other different states."
           "|de|Komprimierter Sammelstatus. Wird aus vielen verschiedenen Stati gebildet.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE air_supply (unsigned char 5)
*/
VARIABLE air_supply
{
  #ifdef LABEL_DE_EN
  LABEL    "Air supply" "|de|Zuluftdruck";
  #else
  LABEL    "Air supply";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                                   },
    { 1,   "Perhaps modified (TEST)"         "|de|Evtl. verndert (TEST)"         },
    { 2,   "Perhaps not enough (TEST)"       "|de|Evtl. nicht ausreichend (TEST)" },
    { 3,   "Perhaps not enough"              "|de|Evtl. nicht ausreichend"        },
    { 4,   "Working at full capacity"        "|de|Stark ausgelastet"              },
    { 5,   "Working at full capacity (TEST)" "|de|Stark ausgelastet (TEST)"       },
    { 6,   "Perhaps modified"                "|de|Evtl. verndert"                }
  #else
    { 0,   "OK"                            },
    { 1,   "Perhaps modified TEST"         },
    { 2,   "Perhaps not enough TEST"       },
    { 3,   "Perhaps not enough"            },
    { 4,   "Working at full capacity"      },
    { 5,   "Working at full capacity TEST" },
    { 6,   "Perhaps modified"              }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE actuator_spring (unsigned char 6)
*/
VARIABLE actuator_spring
{
  #ifdef LABEL_DE_EN
  LABEL    "Actuator springs" "|de|Antriebsfedern";
  #else
  LABEL    "Actuator springs";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                         },
    { 1,   "Perhaps spring stiffness reduced (TEST)"
           "|de|Evtl. Federsteifigkeit reduziert (Federausfall) (TEST)" },
    { 2,   "Perhaps bias reduced (TEST)"
           "|de|Evtl. Vorspannung reduziert (TEST)"                     },
    { 3,   "Perhaps bias increased (TEST)"
           "|de|Evtl. Vorspannung erhht (TEST)"                        },
    { 4,   "Working at full capacity"
           "|de|Stark ausgelastet"                                      },
    { 5,   "Working at full capacity (TEST)"
           "|de|Stark ausgelastet (TEST)"                               }
  #else
    { 0,   "OK"                                      },
    { 1,   "Perhaps spring stiffness reduced (TEST)" },
    { 2,   "Perhaps bias reduced (TEST)"             },
    { 3,   "Perhaps bias increased (TEST)"           },
    { 4,   "Working at full capacity"                },
    { 5,   "Working at full capacity (TEST)"         }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE shifting_working_range (unsigned char 7)
*/
VARIABLE shifting_working_range
{
  #ifdef LABEL_DE_EN
  LABEL    "Shifting working range" "|de|Trend Stellbereich";
  #else
  LABEL    "Shifting working range";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                     },
    { 1,   "Shifting working range to closing position"
           "|de|Arbeitsbereich verschiebt sich zur Schliestellung" },
    { 2,   "Shifting working range to max. opening pos."
           "|de|Arbeitsbereich verschiebt sich zur max. ffnung"    }
  #else
    { 0,   "OK"                                          },
    { 1,   "Shifting working range to closing position"  },
    { 2,   "Shifting working range to max. opening pos." }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE friction (unsigned char 8)
*/
VARIABLE friction
{
  #ifdef LABEL_DE_EN
  LABEL    "Friction" "|de|Reibung";
  #else
  LABEL    "Friction";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                              },
    { 1,  "Much higher over hole range"
          "|de|ber ganzen Stellbereich deutlich hher"                      },
    { 2,  "Much lower over hole range"
          "|de|ber ganzen Stellbereich deutlich niedriger"                  },
    { 3,  "Much higher over section"
          "|de|ber Teilbereich deutlich hher"                              },
    { 4,  "Much lower over section"
          "|de|ber Teilbereich deutlich niedriger"                          },
    { 5,  "Much higher over hole range (TEST)"
          "|de|Reibung - ber ganzen Stellbereich deutlich hher (TEST)"     },
    { 6,  "Much lower over hole range (TEST)"
          "|de|Reibung - ber ganzen Stellbereich deutlich niedriger (TEST)" },
    { 7,  "Much higher over section (TEST)"
          "|de|Reibung - ber Teilbereich deutlich hher (TEST)"             },
    { 8,  "Much lower over section (TEST)"
          "|de|Reibung - ber Teilbereich deutlich niedriger (TEST)"         }
  #else
    { 0,   "OK"                                },
    { 1,  "Much higher over hole range"        },
    { 2,  "Much lower over hole range"         },
    { 3,  "Much higher over section"           },
    { 4,  "Much lower over section"            },
    { 5,  "Much higher over hole range (TEST)" },
    { 6,  "Much lower over hole range (TEST)"  },
    { 7,  "Much higher over section (TEST)"    },
    { 8,  "Much lower over section (TEST)"     }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE leakage_pneumatic (unsigned char 9)
*/
VARIABLE leakage_pneumatic
{
  #ifdef LABEL_DE_EN
  LABEL    "Leakage pneumatics" "|de|Leckage Pneumatik";
  #else
  LABEL    "Leakage pneumatics";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                    },
    { 1,   "Perhaps existing (TEST)"  "|de|Evtl. vorhanden (TEST)" },
    { 2,   "Perhaps existing"         "|de|Evtl. vorhanden"        },
    { 3,   "Perhaps too large (TEST)" "|de|Evtl. zu gro  (TEST)"  },
    { 4,   "Perhaps too large"        "|de|Evtl. zu gro"          }
  #else
    { 0,   "OK"                       },
    { 1,   "Perhaps existing (TEST)"  },
    { 2,   "Perhaps existing"         },
    { 3,   "Perhaps too large (TEST)" },
    { 4,   "Perhaps too large"        }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE limit_working_range (unsigned char 10)
*/
VARIABLE limit_working_range
{
  #ifdef LABEL_DE_EN
  LABEL    "Limit working range" "|de|Beschrnkung Stellbereich";
  #else
  LABEL    "Limit working range";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                                  },
    { 1,   "Down"                    "|de|Nach unten"                            },
    { 2,   "Up"                      "|de|Nach oben"                             },
    { 3,   "Modification impossible" "|de|Keine nderung mehr mglich (Klemmen)" }
  #else
    { 0,   "OK"                      },
    { 1,   "Down"                    },
    { 2,   "Up"                      },
    { 3,   "Modification impossible" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE dynamic_stress_factor (unsigned char 11)
*/
VARIABLE dynamic_stress_factor
{
  #ifdef LABEL_DE_EN
  LABEL    "Dynamic stress factor" "|de|Dynamischer Belastungsfaktor";
  #else
  LABEL    "Dynamic stress factor";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE inner_leakage (unsigned char 12)
*/
VARIABLE inner_leakage
{
  #ifdef LABEL_DE_EN
  LABEL    "Inner leakage" "|de|Innere Leckage";
  #else
  LABEL    "Inner leakage";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                                             },
    { 1,   "Perhaps larger than origin"        "|de|Evtl. grer als im Neuzustand"         },
    { 2,   "Perhaps larger than origin (TEST)" "|de|Evtl. grer als im Neuzustand  (TEST)" },
    { 3,   "Perhaps existing"                  "|de|Evtl. vorhanden"                        }
  #else
    { 0,   "OK"                                },
    { 1,   "Perhaps larger than origin"        },
    { 2,   "Perhaps larger than origin (TEST)" },
    { 3,   "Perhaps existing"                  }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE external_leakage (unsigned char 13)
*/
VARIABLE external_leakage
{
  #ifdef LABEL_DE_EN
  LABEL    "External leakage" "|de|Externe Leckage";
  #else
  LABEL    "External leakage";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                 },
    { 1,   "Perhaps soon expected" "|de|Evtl. bald zu erwarten" },
    { 2,   "Perhaps existing"      "|de|Evtl. vorhanden"        }
  #else
    { 0,   "OK"                    },
    { 1,   "Perhaps soon expected" },
    { 2,   "Perhaps existing"      }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE observing_end_position (unsigned char 14)
*/
VARIABLE observing_end_position
{
  #ifdef LABEL_DE_EN
  LABEL    "End position trend" "|de|Trend Endlage";
  #else
  LABEL    "End position trend";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                                     },
    { 1,   "ZP-shift monotone down; aver. above ref."
           "|de|NP verschiebt sich monoton nach unten Mittelwert ob. Ref.-geraden"  },
    { 2,   "ZP-shift monotone up; aver. above ref."
           "|de|NP verschiebt sich monoton nach oben Mittelwert ob. Ref.-geraden"   },
    { 3,   "ZP-shift alternate; aver. above ref."
           "|de|NP alterniert - Mittelwert ob. Referenzgeraden"                     },
    { 4,   "ZP-shift monotone down; aver. below ref."
           "|de|NP verschiebt sich monoton nach unten Mittelwert unt. Ref.-geraden" },
    { 5,   "ZP-shift monotone up; aver. below ref."
           "|de|NP verschiebt sich monoton nach oben Mittelwert unt. Ref.-"         },
    { 6,   "ZP-alternate; aver. below ref."
           "|de|NP alterniert - Mittelwert unt. Ref.-geraden"                       }
  #else
    { 0,   "OK"                                       },
    { 1,   "ZP-shift monotone down; aver. above ref."  },
    { 2,   "ZP-shift monotone up; aver. above ref."    },
    { 3,   "ZP-shift alternate; aver. above ref."      },
    { 4,   "ZP-shift monotone down; aver. below ref." },
    { 5,   "ZP-shift monotone up; aver. below ref."   },
    { 6,   "ZP-alternate; aver. below ref."           }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE connection_positioner_valve (unsigned char 15)
*/
VARIABLE connection_positioner_valve
{
  #ifdef LABEL_DE_EN
  LABEL    "Connection positioner - valve"
           "|de|Mech. Verbindung Stellungsregler/Stellventil";
  #else
  LABEL    "Connection positioner - valve";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                   },
    { 1,   "Pos./valve - No opt. travel transm.(TEST)"
           "|de|Regler/Ventil - Keine opt. Hubbertragung (TEST)" },
    { 2,   "Pos./valve - Perhaps loose"
           "|de|Regler/Ventil - Evtl. Lose vorhanden"             },
    { 3,   "Pos./valve - Perhaps with limitation of range"
           "|de|Regler/Ventil - Evtl. Einschrnkung Stellbereich" },
    { 4,   "Pos./valve - Perhaps loose (TEST)"
           "|de|Regler/Ventil - Evt. Lose vorh. (TEST)"           }
  #else
    { 0,   "OK"                                                  },
    { 1,   "Pos./valve - No opt. travel transm.(TEST)"     },
    { 2,   "Pos./valve - Perhaps loose"                    },
    { 3,   "Pos./valve - Perhaps with limitation of range" },
    { 4,   "Pos./valve - Perhaps loose (TEST)"             }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE working_range (unsigned char 16)
*/
VARIABLE working_range
{
  #ifdef LABEL_DE_EN
  LABEL    "Working range" "|de|Stellbereich";
  #else
  LABEL    "Working range";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                             },
    { 1,   "Mostly near closing pos." "|de|Vorwiegend nahe Schliestellung" },
    { 2,   "Mostly near max. opening" "|de|Vorwiegend nahe max. ffnung"    },
    { 3,   "Mostly closing pos."      "|de|Vorwiegend Schliestellung"      },
    { 4,   "Mostly max. opening"      "|de|Vorwiegend max. ffnung"         }
  #else
    { 0,   "OK"                           },
    { 1,   "Mostly near closing position" },
    { 2,   "Mostly near max. opening"     },
    { 3,   "Mostly closing position"      },
    { 4,   "Mostly max. opening"          }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE pst_emergency_shut_down (unsigned char 17)
*/
VARIABLE pst_emergency_shut_down
{
  #ifdef LABEL_DE_EN
  LABEL    "PST" "|de|PST";
  #else
  LABEL    "PST";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                                      },
    { 1,   "Movement actuator possible"    "|de|Bewegung Stellorgan mglich"         },
    { 2,   "Movement actuator impossible"  "|de|Bewegung Stellorgan nicht mglich"   },
    { 3,   "Solenoid valve is not working" "|de|Magnetventil arbeitet nicht richtig" }
  #else
    { 0,   "OK"                            },
    { 1,   "Movement actuator possible"    },
    { 2,   "Movement actuator impossible"  },
    { 3,   "Solenoid valve is not working" }
  #endif
  }

  VALIDITY_ONLY_3730_3_143_PST

#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE temperature_error (unsigned char 300; cmd 171/300)
*/
VARIABLE temperature_error
{
  #ifdef LABEL_DE_EN
  LABEL    "Temperature exceeding" "|de|Temperaturberschreitung";
  #else
  LABEL    "Temperature exceeding";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0,   "OK"                                                       },
    { 1,   "Temperature below -40 C" "|de|Temperatur kleiner -40 C" },
    { 3,   "Temperature above +80 C" "|de|Temperatur grer +80 C"  }
  #else
    { 0,   "OK"                       },
    { 1,   "Temperature below -40 C" },
    { 3,   "Temperature above +80 C" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
#endif
}

/* ------------------------------------------------------------------------ */
/* 4.1 Zusaetzliche Diagnoseparameter                                       */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE diag_level (unsigned char 1; cmd 171/1 (Schreiben: 170/1))
*/
VARIABLE diag_level
{
  #ifdef LABEL_DE_EN
  LABEL    "Diagnosis level" "|de|Diagnose Leveleinstellung";
  #else
  LABEL    "Diagnosis level";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  1; /* damit am Anfang EXPERT+ */
    { 0, "EXPERT"   },
    { 1, "EXPERT+"  },
    { 2, "EXPERT++" },
    { 3, "PST"      }
  }
#ifdef HELP_EP_DE_EN
  HELP     "Shows the configuration level of the diagnosis."
           "|de|Anzeige der Diagnose-Ausbaustufe.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepstart (float_288)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE stepstart
{
  #ifdef LABEL_DE_EN
  LABEL    "Step start" "|de|Sprungstart";
  #else
  LABEL    "Step start";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE    10.0;
      MIN_VALUE         0.0;
      MAX_VALUE       100.0;
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Initial value to execute the step response."
           "|de|Startwert zur Durchfhrung der Sprungantwort.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_289)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE stepend
{
  #ifdef LABEL_DE_EN
  LABEL    "Step end" "|de|Sprungende";
  #else
  LABEL    "Step end";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE    90.0;
      MIN_VALUE         0.0;
      MAX_VALUE       100.0;
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "End value to execute the step response."
           "|de|Endwert zur Durchfhrung der Sprungantwort.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE step_sample_rate (unsigned_integer_188)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE step_sample_rate
{
  #ifdef LABEL_DE_EN
  LABEL    "Scan rate" "|de|Abtastzeit";
  #else
  LABEL    "Scan rate";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DISPLAY_FORMAT "2.1f";
      DEFAULT_VALUE   0.2; /* 0.2s */
      MIN_VALUE       0.2; /* 0.2s */
      MAX_VALUE      30.0; /* 30s */
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Scan rate of the step response."
           "|de|Abtastrate der Sprungantwortmessung.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_integer_189 (Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE duration_of_test
{
  #ifdef LABEL_DE_EN
  LABEL    "Duration of the test" "|de|Voraussichtliche Testdauer";
  #else
  LABEL    "Duration of the test";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Allowed test duration."
           "|de|Zugelassene Testdauer.";
#endif

  /* nur bei PST Regler notwendig, Abhaengigkeit aber in der Methode direkt: */
  POST_READ_ACTIONS
  {
    calculate_pst_rec_scan_rate /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE latency_after_step (unsigned_integer_187)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE latency_after_step
{
  #ifdef LABEL_DE_EN
  LABEL    "Delay time after step" "|de|Wartezeit nach Sprung";
  #else
  LABEL    "Delay time after step";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE  2.0;
      MIN_VALUE      2.0; /*   2 s */
      MAX_VALUE    100.0; /* 100 s */
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Delay between end of first step and start of second step."
           "|de|Wartezeit nach dem ersten Sprung bis zweiter Sprung gestartet wird.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE step_selection (unsigned_char_291)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE step_selection
{
  #ifdef LABEL_DE_EN
  LABEL    "Number of step responses" "|de|Anzahl Sprnge";
  #else
  LABEL    "Number of step responses";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE    2;
  #ifdef LABEL_DE_EN
    { 1, "One step"  "|de|1 Sprung"  },
    { 2, "Two steps" "|de|2 Sprnge" }
  #else
    { 1, "One step"  },
    { 2, "Two steps" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Selection between only one step or additionally the inverse step."
           "|de|Auswahlmglichkeit ob nur ein Sprung oder nach dem ersten Sprung auch "
           "der inverse Sprung durchgefhrt werden soll.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE overshoot_rising (float_290)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE overshoot_rising
{
  #ifdef LABEL_DE_EN
  LABEL    "Overshoot (rising)" "|de|berschwinger (steigend)";
  #else
  LABEL    "Overshoot (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: overshoot - rising step."
           "|de|Messauswertung: berschwinger - Sprung steigend.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE overshoot_falling (float_296)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE overshoot_falling
{
  #ifdef LABEL_DE_EN
  LABEL    "Overshoot (falling)" "|de|berschwinger (fallend)";
  #else
  LABEL    "Overshoot (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: overshoot - falling step."
           "|de|Messauswertung: berschwinger - Sprung fallend.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE dead_time_rising (unsigned_long_467)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE dead_time_rising
{
  #ifdef LABEL_DE_EN
  LABEL    "Dead time (rising)" "|de|Totzeit (steigend)";
  #else
  LABEL    "Dead time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: dead band - rising step."
           "|de|Messauswertung: Totzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE dead_time_falling (unsigned_long_472)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE dead_time_falling
{
  #ifdef LABEL_DE_EN
  LABEL    "Dead time (falling)" "|de|Totzeit (fallend)";
  #else
  LABEL    "Dead time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: dead band - falling step."
           "|de|Messauswertung: Totzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE time_63_rising (unsigned_long_468)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE time_63_rising
{
  #ifdef LABEL_DE_EN
  LABEL    "T63 (rising)" "|de|T63 (steigend)";
  #else
  LABEL    "T63 (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE time_63_falling (unsigned_long_473)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE time_63_falling
{
  #ifdef LABEL_DE_EN
  LABEL    "T63 (falling)" "|de|T63 (fallend)";
  #else
  LABEL    "T63 (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE time_98_rising (unsigned_long_469)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE time_98_rising
{
  #ifdef LABEL_DE_EN
  LABEL    "T98 (rising)" "|de|T98 (steigend)";
  #else
  LABEL    "T98 (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE time_98_falling (unsigned_long_474)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE time_98_falling
{
  #ifdef LABEL_DE_EN
  LABEL    "T98 (falling)" "|de|T98 (fallend)";
  #else
  LABEL    "T98 (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE rise_time_rising_step (unsigned_long_470)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE rise_time_rising_step
{
  #ifdef LABEL_DE_EN
  LABEL    "Rise time (rising)" "|de|Anregelzeit (steigend)";
  #else
  LABEL    "Rise time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: rise time - rising step."
           "|de|Messauswertung: Anregelzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE rise_time_falling_step (unsigned_long_475)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE rise_time_falling_step
{
  #ifdef LABEL_DE_EN
  LABEL    "Rise time (falling)" "|de|Anregelzeit (fallend)";
  #else
  LABEL    "Rise time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: rise time - falling step."
           "|de|Messauswertung: Anregelzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE settling_time_rising_step (unsigned_long_471)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE settling_time_rising_step
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time (rising)" "|de|Ausregelzeit (steigend)";
  #else
  LABEL    "Settling time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: settling time - rising step."
           "|de|Messauswertung: Ausregelzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE settling_time_falling_step (unsigned_long_476)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE settling_time_falling_step
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time (falling)" "|de|Ausregelzeit (fallend)";
  #else
  LABEL    "Settling time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";
#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: settling time - falling step."
           "|de|Messauswertung: Ausregelzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}



/* ------------------------------------------------------------------------ */
/*
VARIABLE step_progress (unsigned_char_282)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE step_progress
{
  #ifdef LABEL_DE_EN
  LABEL    "Progress" "|de|Fortschritt";
  #else
  LABEL    "Progress";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE datalogger_select (unsigned_char_38)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE datalogger_select
{
  #ifdef LABEL_DE_EN
  LABEL    "Selection" "|de|Auswahl";
  #else
  LABEL    "Selection";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Permanent" "|de|Permanent"  },
    { 1, "Trigger"   "|de|Getriggert" }
  #else
    { 0, "Permanent" },
    { 1, "Trigger"   }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Data logger in permanent or trigger mode."
           "|de|Datenlogger permanent oder getriggert betreiben.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE trigger_select (unsigned_char_47)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trigger_select
{
  #ifdef LABEL_DE_EN
  LABEL    "Trigger status" "|de|Triggerauswahl";
  #else
  LABEL    "Trigger status";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Start trigger: travel cond."
         "|de|Triggerstart: Hubbedingung"             },
    { 1, "Start trigger: solenoid valve cond."
         "|de|Triggerstart: Magnetventilbedingung"    },
    { 2, "Start trigger: travel/solenoid valve cond."
         "|de|Triggerstart: Hub-/Magnetventilbed."    }
  #else
    { 0, "Start: travel cond."                },
    { 1, "Start: solenoid valve cond."        },
    { 2, "Start: travel/solenoid valve cond." }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Selection of the start condition of the triggered data logger."
           "|de|Auswhlen der Startbedingung des getriggerten Datenloggers.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE sample_rate (unsigned_long_477)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE sample_rate
{
  #ifdef LABEL_DE_EN
  LABEL    "Scan rate" "|de|Abtastzeit";
  #else
  LABEL    "Scan rate";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (4)
  {
      MIN_VALUE     0.2;   /* 0.2  s */
      MAX_VALUE  3600.0;   /* 3600 s */
      DEFAULT_VALUE 1.0;   /* 1.0  s */
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Adjust the scan rate." "|de|Einstellen der Abtastrate.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE start_value (float_1)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE start_value
{
  #ifdef LABEL_DE_EN
  LABEL    "Start value" "|de|Startwertvorgabe";
  #else
  LABEL    "Start value";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DEFAULT_VALUE    99.0;
      DISPLAY_FORMAT "3.1f";
      MIN_VALUE         0.0;
      MAX_VALUE       100.0;
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Limit of the valve position from which the triggered data logger should start."
           "|de|Grenze der Ventilstellung ab der der getriggerte Datenlogger starten soll.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE logging_limit (unsigned_char_42)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE logging_limit
{
  #ifdef LABEL_DE_EN
  LABEL    "Logging limit" "|de|Protokollierungsgrenze";
  #else
  LABEL    "Logging limit";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Start: falls below init. value" "|de|Grenzunterschreitung" },
    { 1, "Start: exceeds initial value"   "|de|Grenzberschreitung"  }
  #else
    { 0, "Start: falls below init. value" },
    { 1, "Start: exceeds initial value"   }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Start condition for triggered data logger to start at "
           "falling below or exceeding the initial value."
           "|de|Startbedingung fr den getriggerten Datenlogger. "
           "Bei Unterschreitung oder berschreitung der Startwertvorgabe starten.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE pretrigger_time (unsigned_long_478)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE pretrigger_time
{
  #ifdef LABEL_DE_EN
  LABEL    "Pretrigger time" "|de|Pretriggerzeit";
  #else
  LABEL    "Pretrigger time";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (4)
  {
      /* keine Grenzen */
      DISPLAY_FORMAT "2.1f";
      DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Measuring time before actuating the trigger event."
           "|de|Angabe der Messzeit vor Auslsen des Triggerereignisses.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE max_pretrigger_time (unsigned_long_479)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE max_pretrigger_time
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. pretrigger time" "|de|Max. Pretriggerzeit";
  #else
  LABEL    "Max. pretrigger time";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Max. possible pretrigger time - depends on the scan rate."
           "|de|Grsste einstellbare Pretriggerzeit - "
           "richtet sich nach der Einstellung der Abtastrate.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE datalogger_progress (unsigned_char_44)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE datalogger_progress
{
  #ifdef LABEL_DE_EN
  LABEL    "Progress flag" "|de|Fortschritt";
  #else
  LABEL    "Progress flag";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "Trigger not selected"              "|de|Triggerung nicht ausgewhlt" },
    { 1, "Trigger selected"                  "|de|Triggerung ausgewhlt"       },
    { 2, "Trigger started: valve cond."      "|de|Triggerstart durch Hubbed."  },
    { 3, "Trigger started: sol. valve cond." "|de|Triggerstart durch MV-Bed."  },
    { 4, "Memory full, ending measuring"     "|de|Speicher voll, Ende Messung" }
  #else
    { 0, "Trigger not selected"              },
    { 1, "Trigger selected"                  },
    { 2, "Trigger started: valve cond."      },
    { 3, "Trigger started: sol. valve cond." },
    { 4, "Memory full, ending measuring"     }
  #endif
 }
#ifdef HELP_EP_DE_EN
  HELP     "Shows the status of the data logger."
           "|de|Gibt den Status vom Datenlogger an.";
#endif
}



/* ------------------------------------------------------------------------ */
/* 3.1   Statische Kennlinie (TESTen (HAND))                                */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 502; READ: cmd 171/502 */
VARIABLE automatical_test_status
{
  #ifdef LABEL_DE_EN
  LABEL    "Test information" "|de|Testinformation";
  #else
  LABEL    "Test information";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "Test sequence not active" "|de|Test nicht aktiviert" },
    { 10,"Running test static characteristic"
         "|de|Testdurchfhrung statische Kennlinie" },
    { 20,"Running test step response" "|de|Testdurchfhrung Sprungfunktion" },
    { 30,"Running test drive signal y steady"
         "|de|Testdurchfhrung Stellsignal y Stationr" },
    { 40,"Running test drive signal y hysteresis"
         "|de|Testdurchfhrung Stellsignal y Hysterese" },
    { 50,"Automatic test finished" "|de|Automatischer Testlauf beendet" },
    { 60,"Test only possible in manual mode"
         "|de|Testlauf nur in Hand mglich" },
    { 70,"Test aborted" "|de|Test wurde abgebrochen" }
  #else
    { 0, "Test sequence not active" },
    { 10,"Running test static characteristic" },
    { 20,"Running test step response" },
    { 30,"Running test drive signal y steady" },
    { 40,"Running test drive signal y hysteresis" },
    { 50,"Automatic test finished" },
    { 60,"Test only possible in manual mode" },
    { 70,"Test aborted" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status of the test." "|de|Status des Testlaufes.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_stepstart (float_282)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_stepstart
{
  #ifdef LABEL_DE_EN
  LABEL    "Start" "|de|Start";
  #else
  LABEL    "Start";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE    50.0;
      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Test starts at this valve position."
           "|de|Test wird bei dieser Ventilstellung gestartet.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_stepend (float_283)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_stepend
{
  #ifdef LABEL_DE_EN
  LABEL    "End" "|de|Ende";
  #else
  LABEL    "End";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE    52.0;
      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Test runs max. to this valve position and toggles the test."
           "|de|Test luft bis max. dieser Ventilstellung und schaltet den Testverlauf um.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_step_height (float_284)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_step_height
{
  #ifdef LABEL_DE_EN
  LABEL    "Step height" "|de|Sprunghhe";
  #else
  LABEL    "Step height";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.3f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Step height until the turning point or end point."
           "|de|Hhe der Sprnge bis zum Umkehrpunkt oder Endpunkt.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_delay_time_after_step (unsigned char 276)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_delay_time_after_step
{
  #ifdef LABEL_DE_EN
  LABEL    "Delay time after step" "|de|Wartezeit nach Sprung";
  #else
  LABEL    "Delay time after step";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DISPLAY_FORMAT "2.1f";
      DEFAULT_VALUE     10;
      MIN_VALUE    1; /* 0.1s */
      MAX_VALUE  250; /* 25s */
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

#ifdef HELP_EP_DE_EN
  HELP     "Delay time after executing the steps."
           "|de|Wartezeit nach Durchfhrung der Sprnge.";
#endif

}

/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_anzahl_bis_umkehr (unsigned char 277)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_anzahl_bis_umkehr
{
  #ifdef LABEL_DE_EN
  LABEL    "No. of meas. values until turn back" "|de|Anzahl bis Umkehr";
  #else
  LABEL    "No. of meas. values until turn back";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DEFAULT_VALUE    50;
      MIN_VALUE   1;
      MAX_VALUE  50;
  }
#ifdef HELP_EP_DE_EN
  HELP     "Number of measurement values recorded until the reversion."
           "|de|Anzahl der Messwerte, die bis zur Umkehr aufgenommen werden.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_285)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_min_dead_band
{
  #ifdef LABEL_DE_EN
  LABEL    "Min. dead band" "|de|Min. Tote Zone";
  #else
  LABEL    "Min. dead band";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.2f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Smallest detected dead band."
           "|de|Angabe der ermittelten kleinsten toten Zone.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_286)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_average_dead_band
{
  #ifdef LABEL_DE_EN
  LABEL    "Average dead band" "|de|Durchschnittliche Tote Zone";
  #else
  LABEL    "Average dead band";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.2f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Average measured data of the dead band."
           "|de|Angabe ber den durchschnittlichen Messwert der toten Zone.";
#endif
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_287)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_max_dead_band
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. dead band" "|de|Max. Tote Zone";
  #else
  LABEL    "Max. dead band";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.2f";
  }
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Greatest detected dead band."
           "|de|Angabe der ermittelten grssten toten Zone.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE step_progress (unsigned_char_280)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE kl_step_progress
{
  #ifdef LABEL_DE_EN
  LABEL    "Progress" "|de|Fortschritt";
  #else
  LABEL    "Progress";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
#endif
}


/* ------------------------------------------------------------------------ */
/* float 600...699 */

VARIABLE stat_kl_sw_0
{
  LABEL    "Sollwert w - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC;*/
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Sollwert w";
}

stat_kl_sw_1 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 2"; }
stat_kl_sw_2 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 3"; }
stat_kl_sw_3 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 4"; }
stat_kl_sw_4 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 5"; }
stat_kl_sw_5 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 6"; }
stat_kl_sw_6 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 7"; }
stat_kl_sw_7 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 8"; }
stat_kl_sw_8 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 9"; }
stat_kl_sw_9 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 10"; }
stat_kl_sw_10 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 11"; }
stat_kl_sw_11 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 12"; }
stat_kl_sw_12 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 13"; }
stat_kl_sw_13 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 14"; }
stat_kl_sw_14 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 15"; }
stat_kl_sw_15 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 16"; }
stat_kl_sw_16 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 17"; }
stat_kl_sw_17 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 18"; }
stat_kl_sw_18 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 19"; }
stat_kl_sw_19 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 20"; }
stat_kl_sw_20 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 21"; }
stat_kl_sw_21 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 22"; }
stat_kl_sw_22 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 23"; }
stat_kl_sw_23 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 24"; }
stat_kl_sw_24 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 25"; }
stat_kl_sw_25		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 26"; }
stat_kl_sw_26		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 27"; }
stat_kl_sw_27		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 28"; }
stat_kl_sw_28		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 29"; }
stat_kl_sw_29		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 30"; }
stat_kl_sw_30		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 31"; }
stat_kl_sw_31		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 32"; }
stat_kl_sw_32		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 33"; }
stat_kl_sw_33		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 34"; }
stat_kl_sw_34		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 35"; }
stat_kl_sw_35 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 36"; }
stat_kl_sw_36 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 37"; }
stat_kl_sw_37 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 38"; }
stat_kl_sw_38 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 39"; }
stat_kl_sw_39 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 40"; }
stat_kl_sw_40 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 41"; }
stat_kl_sw_41 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 42"; }
stat_kl_sw_42 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 43"; }
stat_kl_sw_43 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 44"; }
stat_kl_sw_44 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 45"; }
stat_kl_sw_45 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 46"; }
stat_kl_sw_46 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 47"; }
stat_kl_sw_47 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 48"; }
stat_kl_sw_48 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 49"; }
stat_kl_sw_49 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 50"; }
stat_kl_sw_50		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 51"; }
stat_kl_sw_51		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 52"; }
stat_kl_sw_52		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 53"; }
stat_kl_sw_53		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 54"; }
stat_kl_sw_54		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 55"; }
stat_kl_sw_55		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 56"; }
stat_kl_sw_56		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 57"; }
stat_kl_sw_57		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 58"; }
stat_kl_sw_58		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 59"; }
stat_kl_sw_59		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 60"; }
stat_kl_sw_60 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 61"; }
stat_kl_sw_61 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 62"; }
stat_kl_sw_62 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 63"; }
stat_kl_sw_63 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 64"; }
stat_kl_sw_64 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 65"; }
stat_kl_sw_65 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 66"; }
stat_kl_sw_66 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 67"; }
stat_kl_sw_67 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 68"; }
stat_kl_sw_68 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 69"; }
stat_kl_sw_69 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 70"; }
stat_kl_sw_70 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 71"; }
stat_kl_sw_71 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 72"; }
stat_kl_sw_72 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 73"; }
stat_kl_sw_73 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 74"; }
stat_kl_sw_74 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 75"; }
stat_kl_sw_75		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 76"; }
stat_kl_sw_76		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 77"; }
stat_kl_sw_77		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 78"; }
stat_kl_sw_78		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 79"; }
stat_kl_sw_79		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 80"; }
stat_kl_sw_80		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 81"; }
stat_kl_sw_81		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 82"; }
stat_kl_sw_82		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 83"; }
stat_kl_sw_83		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 84"; }
stat_kl_sw_84		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 85"; }
stat_kl_sw_85 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 86"; }
stat_kl_sw_86 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 87"; }
stat_kl_sw_87 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 88"; }
stat_kl_sw_88 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 89"; }
stat_kl_sw_89 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 90"; }
stat_kl_sw_90 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 91"; }
stat_kl_sw_91 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 92"; }
stat_kl_sw_92 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 93"; }
stat_kl_sw_93 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 94"; }
stat_kl_sw_94 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 95"; }
stat_kl_sw_95 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 96"; }
stat_kl_sw_96 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 97"; }
stat_kl_sw_97 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 98"; }
stat_kl_sw_98 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 99"; }
stat_kl_sw_99 		LIKE  VARIABLE  		stat_kl_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 500...599 */

VARIABLE stat_kl_vs_0
{
  LABEL    "Ventilstellung x - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC;*/
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Ventilstellung x";
}

stat_kl_vs_1 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 2"; }
stat_kl_vs_2 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 3"; }
stat_kl_vs_3 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 4"; }
stat_kl_vs_4 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 5"; }
stat_kl_vs_5 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 6"; }
stat_kl_vs_6 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 7"; }
stat_kl_vs_7 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 8"; }
stat_kl_vs_8 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 9"; }
stat_kl_vs_9 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 10"; }
stat_kl_vs_10 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 11"; }
stat_kl_vs_11 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 12"; }
stat_kl_vs_12 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 13"; }
stat_kl_vs_13 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 14"; }
stat_kl_vs_14 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 15"; }
stat_kl_vs_15 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 16"; }
stat_kl_vs_16 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 17"; }
stat_kl_vs_17 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 18"; }
stat_kl_vs_18 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 19"; }
stat_kl_vs_19 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 20"; }
stat_kl_vs_20 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 21"; }
stat_kl_vs_21 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 22"; }
stat_kl_vs_22 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 23"; }
stat_kl_vs_23 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 24"; }
stat_kl_vs_24 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 25"; }
stat_kl_vs_25 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 26"; }
stat_kl_vs_26 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 27"; }
stat_kl_vs_27 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 28"; }
stat_kl_vs_28 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 29"; }
stat_kl_vs_29 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 30"; }
stat_kl_vs_30 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 31"; }
stat_kl_vs_31 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 32"; }
stat_kl_vs_32 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 33"; }
stat_kl_vs_33 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 34"; }
stat_kl_vs_34 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 35"; }
stat_kl_vs_35 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 36"; }
stat_kl_vs_36 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 37"; }
stat_kl_vs_37 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 38"; }
stat_kl_vs_38 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 39"; }
stat_kl_vs_39 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 40"; }
stat_kl_vs_40 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 41"; }
stat_kl_vs_41 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 42"; }
stat_kl_vs_42 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 43"; }
stat_kl_vs_43 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 44"; }
stat_kl_vs_44 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 45"; }
stat_kl_vs_45 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 46"; }
stat_kl_vs_46 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 47"; }
stat_kl_vs_47 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 48"; }
stat_kl_vs_48 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 49"; }
stat_kl_vs_49 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 50"; }
stat_kl_vs_50		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 51"; }
stat_kl_vs_51 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 52"; }
stat_kl_vs_52 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 53"; }
stat_kl_vs_53 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 54"; }
stat_kl_vs_54 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 55"; }
stat_kl_vs_55 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 56"; }
stat_kl_vs_56 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 57"; }
stat_kl_vs_57 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 58"; }
stat_kl_vs_58 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 59"; }
stat_kl_vs_59 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 60"; }
stat_kl_vs_60 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 61"; }
stat_kl_vs_61 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 62"; }
stat_kl_vs_62 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 63"; }
stat_kl_vs_63 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 64"; }
stat_kl_vs_64 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 65"; }
stat_kl_vs_65 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 66"; }
stat_kl_vs_66 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 67"; }
stat_kl_vs_67 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 68"; }
stat_kl_vs_68 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 69"; }
stat_kl_vs_69 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 70"; }
stat_kl_vs_70 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 71"; }
stat_kl_vs_71 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 72"; }
stat_kl_vs_72 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 73"; }
stat_kl_vs_73 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 74"; }
stat_kl_vs_74 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 75"; }
stat_kl_vs_75 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 76"; }
stat_kl_vs_76 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 77"; }
stat_kl_vs_77 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 78"; }
stat_kl_vs_78 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 79"; }
stat_kl_vs_79 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 80"; }
stat_kl_vs_80 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 81"; }
stat_kl_vs_81 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 82"; }
stat_kl_vs_82 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 83"; }
stat_kl_vs_83 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 84"; }
stat_kl_vs_84 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 85"; }
stat_kl_vs_85 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 86"; }
stat_kl_vs_86 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 87"; }
stat_kl_vs_87 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 88"; }
stat_kl_vs_88 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 89"; }
stat_kl_vs_89 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 90"; }
stat_kl_vs_90 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 91"; }
stat_kl_vs_91 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 92"; }
stat_kl_vs_92 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 93"; }
stat_kl_vs_93 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 94"; }
stat_kl_vs_94 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 95"; }
stat_kl_vs_95 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 96"; }
stat_kl_vs_96 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 97"; }
stat_kl_vs_97 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 98"; }
stat_kl_vs_98 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 99"; }
stat_kl_vs_99 		LIKE  VARIABLE  		stat_kl_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 100"; }



/* ------------------------------------------------------------------------ */
/* 3.2   Sprungantwort */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned long 300...399 */

VARIABLE sprung_t_0
{
  LABEL    "Zeitmesswert - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "s";
  HELP     "|de|Zeitmesswert";
}

sprung_t_1 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 2"; }
sprung_t_2 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 3"; }
sprung_t_3 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 4"; }
sprung_t_4 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 5"; }
sprung_t_5 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 6"; }
sprung_t_6 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 7"; }
sprung_t_7 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 8"; }
sprung_t_8 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 9"; }
sprung_t_9 	    	LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 10"; }
sprung_t_10 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 11"; }
sprung_t_11 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 12"; }
sprung_t_12 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 13"; }
sprung_t_13 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 14"; }
sprung_t_14 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 15"; }
sprung_t_15 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 16"; }
sprung_t_16 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 17"; }
sprung_t_17 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 18"; }
sprung_t_18 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 19"; }
sprung_t_19 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 20"; }
sprung_t_20 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 21"; }
sprung_t_21 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 22"; }
sprung_t_22 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 23"; }
sprung_t_23 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 24"; }
sprung_t_24 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 25"; }
sprung_t_25 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 26"; }
sprung_t_26 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 27"; }
sprung_t_27 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 28"; }
sprung_t_28 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 29"; }
sprung_t_29 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 30"; }
sprung_t_30 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 31"; }
sprung_t_31 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 32"; }
sprung_t_32 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 33"; }
sprung_t_33 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 34"; }
sprung_t_34 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 35"; }
sprung_t_35 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 36"; }
sprung_t_36 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 37"; }
sprung_t_37 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 38"; }
sprung_t_38 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 39"; }
sprung_t_39 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 40"; }
sprung_t_40 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 41"; }
sprung_t_41 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 42"; }
sprung_t_42 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 43"; }
sprung_t_43 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 44"; }
sprung_t_44 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 45"; }
sprung_t_45 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 46"; }
sprung_t_46 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 47"; }
sprung_t_47 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 48"; }
sprung_t_48 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 49"; }
sprung_t_49 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 50"; }
sprung_t_50 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 51"; }
sprung_t_51 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 52"; }
sprung_t_52 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 53"; }
sprung_t_53 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 54"; }
sprung_t_54 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 55"; }
sprung_t_55 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 56"; }
sprung_t_56 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 57"; }
sprung_t_57 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 58"; }
sprung_t_58 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 59"; }
sprung_t_59 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 60"; }
sprung_t_60 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 61"; }
sprung_t_61 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 62"; }
sprung_t_62 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 63"; }
sprung_t_63 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 64"; }
sprung_t_64 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 65"; }
sprung_t_65 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 66"; }
sprung_t_66 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 67"; }
sprung_t_67 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 68"; }
sprung_t_68 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 69"; }
sprung_t_69 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 70"; }
sprung_t_70 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 71"; }
sprung_t_71 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 72"; }
sprung_t_72 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 73"; }
sprung_t_73 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 74"; }
sprung_t_74 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 75"; }
sprung_t_75 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 76"; }
sprung_t_76 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 77"; }
sprung_t_77 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 78"; }
sprung_t_78 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 79"; }
sprung_t_79 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 80"; }
sprung_t_80 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 81"; }
sprung_t_81 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 82"; }
sprung_t_82 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 83"; }
sprung_t_83 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 84"; }
sprung_t_84 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 85"; }
sprung_t_85 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 86"; }
sprung_t_86 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 87"; }
sprung_t_87 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 88"; }
sprung_t_88 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 89"; }
sprung_t_89 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 90"; }
sprung_t_90 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 91"; }
sprung_t_91 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 92"; }
sprung_t_92 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 93"; }
sprung_t_93 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 94"; }
sprung_t_94 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 95"; }
sprung_t_95 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 96"; }
sprung_t_96 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 97"; }
sprung_t_97 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 98"; }
sprung_t_98 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 99"; }
sprung_t_99 		LIKE  VARIABLE  		sprung_t_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 1000...1099 */

VARIABLE sprung_vs_0
{
  LABEL    "Ventilstellung x - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT "3.1";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Ventilstellung x";
}

sprung_vs_1 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 2"; }
sprung_vs_2 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 3"; }
sprung_vs_3 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 4"; }
sprung_vs_4 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 5"; }
sprung_vs_5 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 6"; }
sprung_vs_6 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 7"; }
sprung_vs_7 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 8"; }
sprung_vs_8 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 9"; }
sprung_vs_9 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 10"; }
sprung_vs_10 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 11"; }
sprung_vs_11 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 12"; }
sprung_vs_12 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 13"; }
sprung_vs_13 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 14"; }
sprung_vs_14 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 15"; }
sprung_vs_15 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 16"; }
sprung_vs_16 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 17"; }
sprung_vs_17 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 18"; }
sprung_vs_18 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 19"; }
sprung_vs_19 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 20"; }
sprung_vs_20 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 21"; }
sprung_vs_21 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 22"; }
sprung_vs_22 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 23"; }
sprung_vs_23 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 24"; }
sprung_vs_24 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 25"; }
sprung_vs_25 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 26"; }
sprung_vs_26 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 27"; }
sprung_vs_27 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 28"; }
sprung_vs_28 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 29"; }
sprung_vs_29 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 30"; }
sprung_vs_30 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 31"; }
sprung_vs_31 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 32"; }
sprung_vs_32 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 33"; }
sprung_vs_33 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 34"; }
sprung_vs_34 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 35"; }
sprung_vs_35 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 36"; }
sprung_vs_36 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 37"; }
sprung_vs_37 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 38"; }
sprung_vs_38 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 39"; }
sprung_vs_39 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 40"; }
sprung_vs_40 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 41"; }
sprung_vs_41 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 42"; }
sprung_vs_42 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 43"; }
sprung_vs_43 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 44"; }
sprung_vs_44 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 45"; }
sprung_vs_45 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 46"; }
sprung_vs_46 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 47"; }
sprung_vs_47 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 48"; }
sprung_vs_48 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 49"; }
sprung_vs_49 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 50"; }
sprung_vs_50		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 51"; }
sprung_vs_51 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 52"; }
sprung_vs_52 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 53"; }
sprung_vs_53 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 54"; }
sprung_vs_54 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 55"; }
sprung_vs_55 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 56"; }
sprung_vs_56 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 57"; }
sprung_vs_57 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 58"; }
sprung_vs_58 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 59"; }
sprung_vs_59 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 60"; }
sprung_vs_60 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 61"; }
sprung_vs_61 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 62"; }
sprung_vs_62 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 63"; }
sprung_vs_63 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 64"; }
sprung_vs_64 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 65"; }
sprung_vs_65 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 66"; }
sprung_vs_66 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 67"; }
sprung_vs_67 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 68"; }
sprung_vs_68 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 69"; }
sprung_vs_69 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 70"; }
sprung_vs_70 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 71"; }
sprung_vs_71 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 72"; }
sprung_vs_72 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 73"; }
sprung_vs_73 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 74"; }
sprung_vs_74 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 75"; }
sprung_vs_75		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 76"; }
sprung_vs_76 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 77"; }
sprung_vs_77 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 78"; }
sprung_vs_78 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 79"; }
sprung_vs_79 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 80"; }
sprung_vs_80 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 81"; }
sprung_vs_81 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 82"; }
sprung_vs_82 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 83"; }
sprung_vs_83 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 84"; }
sprung_vs_84 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 85"; }
sprung_vs_85 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 86"; }
sprung_vs_86 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 87"; }
sprung_vs_87 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 88"; }
sprung_vs_88 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 89"; }
sprung_vs_89 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 90"; }
sprung_vs_90 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 91"; }
sprung_vs_91 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 92"; }
sprung_vs_92 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 93"; }
sprung_vs_93 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 94"; }
sprung_vs_94 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 95"; }
sprung_vs_95 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 96"; }
sprung_vs_96 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 97"; }
sprung_vs_97 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 98"; }
sprung_vs_98 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 99"; }
sprung_vs_99 		LIKE  VARIABLE  		sprung_vs_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 1100...1199 */

VARIABLE sprung_sw_0
{
  LABEL    "Sollwert w - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT "3.1";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Sollwert w";
}

sprung_sw_1 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 2"; }
sprung_sw_2 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 3"; }
sprung_sw_3 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 4"; }
sprung_sw_4 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 5"; }
sprung_sw_5 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 6"; }
sprung_sw_6 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 7"; }
sprung_sw_7 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 8"; }
sprung_sw_8 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 9"; }
sprung_sw_9 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 10"; }
sprung_sw_10 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 11"; }
sprung_sw_11 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 12"; }
sprung_sw_12 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 13"; }
sprung_sw_13 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 14"; }
sprung_sw_14 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 15"; }
sprung_sw_15 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 16"; }
sprung_sw_16 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 17"; }
sprung_sw_17 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 18"; }
sprung_sw_18 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 19"; }
sprung_sw_19 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 20"; }
sprung_sw_20 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 21"; }
sprung_sw_21 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 22"; }
sprung_sw_22 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 23"; }
sprung_sw_23 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 24"; }
sprung_sw_24 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 25"; }
sprung_sw_25 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 26"; }
sprung_sw_26 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 27"; }
sprung_sw_27 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 28"; }
sprung_sw_28 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 29"; }
sprung_sw_29 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 30"; }
sprung_sw_30 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 31"; }
sprung_sw_31 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 32"; }
sprung_sw_32 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 33"; }
sprung_sw_33 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 34"; }
sprung_sw_34 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 35"; }
sprung_sw_35 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 36"; }
sprung_sw_36 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 37"; }
sprung_sw_37 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 38"; }
sprung_sw_38 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 39"; }
sprung_sw_39 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 40"; }
sprung_sw_40 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 41"; }
sprung_sw_41 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 42"; }
sprung_sw_42 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 43"; }
sprung_sw_43 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 44"; }
sprung_sw_44 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 45"; }
sprung_sw_45 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 46"; }
sprung_sw_46 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 47"; }
sprung_sw_47 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 48"; }
sprung_sw_48 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 49"; }
sprung_sw_49 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 50"; }
sprung_sw_50		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 51"; }
sprung_sw_51 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 52"; }
sprung_sw_52 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 53"; }
sprung_sw_53 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 54"; }
sprung_sw_54 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 55"; }
sprung_sw_55 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 56"; }
sprung_sw_56 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 57"; }
sprung_sw_57 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 58"; }
sprung_sw_58 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 59"; }
sprung_sw_59 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 60"; }
sprung_sw_60 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 61"; }
sprung_sw_61 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 62"; }
sprung_sw_62 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 63"; }
sprung_sw_63 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 64"; }
sprung_sw_64 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 65"; }
sprung_sw_65 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 66"; }
sprung_sw_66 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 67"; }
sprung_sw_67 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 68"; }
sprung_sw_68 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 69"; }
sprung_sw_69 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 70"; }
sprung_sw_70 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 71"; }
sprung_sw_71 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 72"; }
sprung_sw_72 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 73"; }
sprung_sw_73 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 74"; }
sprung_sw_74 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 75"; }
sprung_sw_75 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 76"; }
sprung_sw_76 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 77"; }
sprung_sw_77 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 78"; }
sprung_sw_78 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 79"; }
sprung_sw_79 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 80"; }
sprung_sw_80 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 81"; }
sprung_sw_81 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 82"; }
sprung_sw_82 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 83"; }
sprung_sw_83 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 84"; }
sprung_sw_84 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 85"; }
sprung_sw_85 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 86"; }
sprung_sw_86 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 87"; }
sprung_sw_87 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 88"; }
sprung_sw_88 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 89"; }
sprung_sw_89 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 90"; }
sprung_sw_90 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 91"; }
sprung_sw_91 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 92"; }
sprung_sw_92 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 93"; }
sprung_sw_93 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 94"; }
sprung_sw_94 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 95"; }
sprung_sw_95 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 96"; }
sprung_sw_96 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 97"; }
sprung_sw_97 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 98"; }
sprung_sw_98 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 99"; }
sprung_sw_99 		LIKE  VARIABLE  		sprung_sw_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 400...499 */

VARIABLE sprung_e_0
{
  LABEL    "Regelabweichung e - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT "3.1";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Regelabweichung e";
}

sprung_e_1 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 2"; }
sprung_e_2 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 3"; }
sprung_e_3 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 4"; }
sprung_e_4 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 5"; }
sprung_e_5 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 6"; }
sprung_e_6 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 7"; }
sprung_e_7 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 8"; }
sprung_e_8 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 9"; }
sprung_e_9 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 10"; }
sprung_e_10 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 11"; }
sprung_e_11 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 12"; }
sprung_e_12 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 13"; }
sprung_e_13 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 14"; }
sprung_e_14 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 15"; }
sprung_e_15 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 16"; }
sprung_e_16 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 17"; }
sprung_e_17 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 18"; }
sprung_e_18 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 19"; }
sprung_e_19 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 20"; }
sprung_e_20 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 21"; }
sprung_e_21 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 22"; }
sprung_e_22 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 23"; }
sprung_e_23 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 24"; }
sprung_e_24 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 25"; }
sprung_e_25 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 26"; }
sprung_e_26 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 27"; }
sprung_e_27 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 28"; }
sprung_e_28 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 29"; }
sprung_e_29 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 30"; }
sprung_e_30 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 31"; }
sprung_e_31 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 32"; }
sprung_e_32 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 33"; }
sprung_e_33 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 34"; }
sprung_e_34 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 35"; }
sprung_e_35 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 36"; }
sprung_e_36 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 37"; }
sprung_e_37 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 38"; }
sprung_e_38 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 39"; }
sprung_e_39 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 40"; }
sprung_e_40 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 41"; }
sprung_e_41 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 42"; }
sprung_e_42 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 43"; }
sprung_e_43 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 44"; }
sprung_e_44 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 45"; }
sprung_e_45 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 46"; }
sprung_e_46 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 47"; }
sprung_e_47 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 48"; }
sprung_e_48 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 49"; }
sprung_e_49 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 50"; }
sprung_e_50 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 51"; }
sprung_e_51 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 52"; }
sprung_e_52 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 53"; }
sprung_e_53 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 54"; }
sprung_e_54 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 55"; }
sprung_e_55 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 56"; }
sprung_e_56 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 57"; }
sprung_e_57 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 58"; }
sprung_e_58 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 59"; }
sprung_e_59 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 60"; }
sprung_e_60 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 61"; }
sprung_e_61 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 62"; }
sprung_e_62 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 63"; }
sprung_e_63 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 64"; }
sprung_e_64 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 65"; }
sprung_e_65 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 66"; }
sprung_e_66 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 67"; }
sprung_e_67 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 68"; }
sprung_e_68 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 69"; }
sprung_e_69 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 70"; }
sprung_e_70 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 71"; }
sprung_e_71 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 72"; }
sprung_e_72 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 73"; }
sprung_e_73 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 74"; }
sprung_e_74 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 75"; }
sprung_e_75 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 76"; }
sprung_e_76 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 77"; }
sprung_e_77 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 78"; }
sprung_e_78 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 79"; }
sprung_e_79 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 80"; }
sprung_e_80 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 81"; }
sprung_e_81 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 82"; }
sprung_e_82 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 83"; }
sprung_e_83 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 84"; }
sprung_e_84 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 85"; }
sprung_e_85 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 86"; }
sprung_e_86 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 87"; }
sprung_e_87 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 88"; }
sprung_e_88 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 89"; }
sprung_e_89 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 90"; }
sprung_e_90 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 91"; }
sprung_e_91 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 92"; }
sprung_e_92 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 93"; }
sprung_e_93 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 94"; }
sprung_e_94 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 95"; }
sprung_e_95 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 96"; }
sprung_e_96 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 97"; }
sprung_e_97 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 98"; }
sprung_e_98 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 99"; }
sprung_e_99 		LIKE  VARIABLE  		sprung_e_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* unsigned integer 300...399 */

VARIABLE sprung_ss_0
{
  LABEL    "Stellsignal y - Messpunkt - 1";
/* in PDM nicht DYNAMIC
  CLASS    DEVICE & DYNAMIC; */
/* werden per Methode eingelesen, daher USER_INTERFACE
  CLASS    DEVICE;*/
  CLASS    USER_INTERFACE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
  HELP     "|de|Stellsignal y";
}

sprung_ss_1 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 2"; }
sprung_ss_2 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 3"; }
sprung_ss_3 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 4"; }
sprung_ss_4 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 5"; }
sprung_ss_5 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 6"; }
sprung_ss_6 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 7"; }
sprung_ss_7 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 8"; }
sprung_ss_8 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 9"; }
sprung_ss_9 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 10"; }
sprung_ss_10 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 11"; }
sprung_ss_11 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 12"; }
sprung_ss_12 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 13"; }
sprung_ss_13 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 14"; }
sprung_ss_14 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 15"; }
sprung_ss_15 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 16"; }
sprung_ss_16 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 17"; }
sprung_ss_17 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 18"; }
sprung_ss_18 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 19"; }
sprung_ss_19 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 20"; }
sprung_ss_20 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 21"; }
sprung_ss_21 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 22"; }
sprung_ss_22 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 23"; }
sprung_ss_23 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 24"; }
sprung_ss_24 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 25"; }
sprung_ss_25 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 26"; }
sprung_ss_26 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 27"; }
sprung_ss_27 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 28"; }
sprung_ss_28 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 29"; }
sprung_ss_29 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 30"; }
sprung_ss_30 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 31"; }
sprung_ss_31 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 32"; }
sprung_ss_32 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 33"; }
sprung_ss_33 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 34"; }
sprung_ss_34 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 35"; }
sprung_ss_35 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 36"; }
sprung_ss_36 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 37"; }
sprung_ss_37 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 38"; }
sprung_ss_38 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 39"; }
sprung_ss_39 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 40"; }
sprung_ss_40 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 41"; }
sprung_ss_41 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 42"; }
sprung_ss_42 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 43"; }
sprung_ss_43 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 44"; }
sprung_ss_44 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 45"; }
sprung_ss_45 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 46"; }
sprung_ss_46 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 47"; }
sprung_ss_47 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 48"; }
sprung_ss_48 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 49"; }
sprung_ss_49 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 50"; }
sprung_ss_50 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 51"; }
sprung_ss_51 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 52"; }
sprung_ss_52 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 53"; }
sprung_ss_53 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 54"; }
sprung_ss_54 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 55"; }
sprung_ss_55 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 56"; }
sprung_ss_56 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 57"; }
sprung_ss_57 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 58"; }
sprung_ss_58 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 59"; }
sprung_ss_59 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 60"; }
sprung_ss_60 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 61"; }
sprung_ss_61 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 62"; }
sprung_ss_62 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 63"; }
sprung_ss_63 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 64"; }
sprung_ss_64 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 65"; }
sprung_ss_65 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 66"; }
sprung_ss_66 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 67"; }
sprung_ss_67 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 68"; }
sprung_ss_68 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 69"; }
sprung_ss_69 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 70"; }
sprung_ss_70 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 71"; }
sprung_ss_71 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 72"; }
sprung_ss_72 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 73"; }
sprung_ss_73 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 74"; }
sprung_ss_74 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 75"; }
sprung_ss_75 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 76"; }
sprung_ss_76 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 77"; }
sprung_ss_77 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 78"; }
sprung_ss_78 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 79"; }
sprung_ss_79 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 80"; }
sprung_ss_80 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 81"; }
sprung_ss_81 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 82"; }
sprung_ss_82 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 83"; }
sprung_ss_83 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 84"; }
sprung_ss_84 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 85"; }
sprung_ss_85 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 86"; }
sprung_ss_86 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 87"; }
sprung_ss_87 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 88"; }
sprung_ss_88 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 89"; }
sprung_ss_89 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 90"; }
sprung_ss_90 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 91"; }
sprung_ss_91 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 92"; }
sprung_ss_92 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 93"; }
sprung_ss_93 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 94"; }
sprung_ss_94 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 95"; }
sprung_ss_95 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 96"; }
sprung_ss_96 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 97"; }
sprung_ss_97 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 98"; }
sprung_ss_98 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 99"; }
sprung_ss_99 		LIKE  VARIABLE  		sprung_ss_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 100"; }



/* ------------------------------------------------------------------------ */
/* 3.3   Tests Hand - Stellsignal y Stationaer                              */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 118 */
VARIABLE hand_y_stat_test_information
{
  #ifdef LABEL_DE_EN
  LABEL    "Test information" "|de|Testinformation";
  #else
  LABEL    "Test information";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "Test not active" "|de|Test nicht aktiviert" },
    { 1, "Running test" "|de|Testdurchfhrung" },
    { 2, "Test finished" "|de|Test beendet" },
    { 3, "Test aborted" "|de|Test wurde abgebrochen" },
    { 4, "Reference not clear"
         "|de|Keine eindeutige Referenzkurve aufgenommen" },
    { 5, "Booster attached - no evaluation possible"
         "|de|Booster angebaut - keine Auswertung mglich" }
  #else
    { 0, "Test not active" },
    { 1, "Running test" },
    { 2, "Test finished" },
    { 3, "Test aborted" },
    { 4, "Reference not clear" },
    { 5, "Booster attached - no eval. possible" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status of the test." "|de|Status des Testlaufes.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_char_254 */
VARIABLE hand_y_stat_step_progress
{
  #ifdef LABEL_DE_EN
  LABEL    "Progress" "|de|Fortschritt";
  #else
  LABEL    "Progress";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned int 137-161
*/
VARIABLE hand_y_stat_wiederholungswerte_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Repetition value - 1" "|de|Wiederholungswert - 1";
  #else
  LABEL    "Repetition value - 1";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
#ifdef HELP_EP_DE_EN
  HELP     "Repeat valve positions moved to during the test."
           "|de|Ventilstellungen der Wiederholungsmessungen die beim "
           "Test angefahren wurden.";
#endif
}

hand_y_stat_wiederholungswerte_2 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 2" "|de|Wiederholungswert - 2"; }
  #else
{ REDEFINE LABEL "Repetition value - 2"; }
  #endif
hand_y_stat_wiederholungswerte_3 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 3" "|de|Wiederholungswert - 3"; }
  #else
{ REDEFINE LABEL "Repetition value - 3"; }
  #endif
hand_y_stat_wiederholungswerte_4 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 4" "|de|Wiederholungswert - 4"; }
  #else
{ REDEFINE LABEL "Repetition value - 4"; }
  #endif
hand_y_stat_wiederholungswerte_5 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 5" "|de|Wiederholungswert - 5"; }
  #else
{ REDEFINE LABEL "Repetition value - 5"; }
  #endif
hand_y_stat_wiederholungswerte_6 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 6" "|de|Wiederholungswert - 6"; }
  #else
{ REDEFINE LABEL "Repetition value - 6"; }
  #endif
hand_y_stat_wiederholungswerte_7 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 7" "|de|Wiederholungswert - 7"; }
  #else
{ REDEFINE LABEL "Repetition value - 7"; }
  #endif
hand_y_stat_wiederholungswerte_8 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 8" "|de|Wiederholungswert - 8"; }
  #else
{ REDEFINE LABEL "Repetition value - 8"; }
  #endif
hand_y_stat_wiederholungswerte_9 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 9" "|de|Wiederholungswert - 9"; }
  #else
{ REDEFINE LABEL "Repetition value - 9"; }
  #endif
hand_y_stat_wiederholungswerte_10 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 10" "|de|Wiederholungswert - 10"; }
  #else
{ REDEFINE LABEL "Repetition value - 10"; }
  #endif
hand_y_stat_wiederholungswerte_11 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 11" "|de|Wiederholungswert - 11"; }
  #else
{ REDEFINE LABEL "Repetition value - 11"; }
  #endif
hand_y_stat_wiederholungswerte_12 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 12" "|de|Wiederholungswert - 12"; }
  #else
{ REDEFINE LABEL "Repetition value - 12"; }
  #endif
hand_y_stat_wiederholungswerte_13 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 13" "|de|Wiederholungswert - 13"; }
  #else
{ REDEFINE LABEL "Repetition value - 13"; }
  #endif
hand_y_stat_wiederholungswerte_14 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 14" "|de|Wiederholungswert - 14"; }
  #else
{ REDEFINE LABEL "Repetition value - 14"; }
  #endif
hand_y_stat_wiederholungswerte_15 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 15" "|de|Wiederholungswert - 15"; }
  #else
{ REDEFINE LABEL "Repetition value - 15"; }
  #endif
hand_y_stat_wiederholungswerte_16 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 16" "|de|Wiederholungswert - 16"; }
  #else
{ REDEFINE LABEL "Repetition value - 16"; }
  #endif
hand_y_stat_wiederholungswerte_17 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 17" "|de|Wiederholungswert - 17"; }
  #else
{ REDEFINE LABEL "Repetition value - 17"; }
  #endif
hand_y_stat_wiederholungswerte_18 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 18" "|de|Wiederholungswert - 18"; }
  #else
{ REDEFINE LABEL "Repetition value - 18"; }
  #endif
hand_y_stat_wiederholungswerte_19 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 19" "|de|Wiederholungswert - 19"; }
  #else
{ REDEFINE LABEL "Repetition value - 19"; }
  #endif
hand_y_stat_wiederholungswerte_20 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 20" "|de|Wiederholungswert - 20"; }
  #else
{ REDEFINE LABEL "Repetition value - 20"; }
  #endif
hand_y_stat_wiederholungswerte_21 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 21" "|de|Wiederholungswert - 21"; }
  #else
{ REDEFINE LABEL "Repetition value - 21"; }
  #endif
hand_y_stat_wiederholungswerte_22 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 22" "|de|Wiederholungswert - 22"; }
  #else
{ REDEFINE LABEL "Repetition value - 22"; }
  #endif
hand_y_stat_wiederholungswerte_23 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 23" "|de|Wiederholungswert - 23"; }
  #else
{ REDEFINE LABEL "Repetition value - 23"; }
  #endif
hand_y_stat_wiederholungswerte_24 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 24" "|de|Wiederholungswert - 24"; }
  #else
{ REDEFINE LABEL "Repetition value - 24"; }
  #endif
hand_y_stat_wiederholungswerte_25 LIKE  VARIABLE  hand_y_stat_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 25" "|de|Wiederholungswert - 25"; }
  #else
{ REDEFINE LABEL "Repetition value - 25"; }
  #endif

/* ------------------------------------------------------------------------ */
/* unsigned int 112-136
*/
VARIABLE hand_y_stat_referenzwerte_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Reference value - 1" "|de|Referenzwert - 1";
  #else
  LABEL    "Reference value - 1";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
#ifdef HELP_EP_DE_EN
  HELP     "Reference valve positions moved to during the test."
           "|de|Ventilstellungen der Referenzwerte die beim Test "
           "angefahren wurden.";
#endif
}

hand_y_stat_referenzwerte_2 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 2" "|de|Referenzwert - 2"; }
  #else
{ REDEFINE LABEL "Reference value - 2"; }
  #endif
hand_y_stat_referenzwerte_3 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 3" "|de|Referenzwert - 3"; }
  #else
{ REDEFINE LABEL "Reference value - 3"; }
  #endif
hand_y_stat_referenzwerte_4 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 4" "|de|Referenzwert - 4"; }
  #else
{ REDEFINE LABEL "Reference value - 4"; }
  #endif
hand_y_stat_referenzwerte_5 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 5" "|de|Referenzwert - 5"; }
  #else
{ REDEFINE LABEL "Reference value - 5"; }
  #endif
hand_y_stat_referenzwerte_6 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 6" "|de|Referenzwert - 6"; }
  #else
{ REDEFINE LABEL "Reference value - 6"; }
  #endif
hand_y_stat_referenzwerte_7 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 7" "|de|Referenzwert - 7"; }
  #else
{ REDEFINE LABEL "Reference value - 7"; }
  #endif
hand_y_stat_referenzwerte_8 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 8" "|de|Referenzwert - 8"; }
  #else
{ REDEFINE LABEL "Reference value - 8"; }
  #endif
hand_y_stat_referenzwerte_9 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 9" "|de|Referenzwert - 9"; }
  #else
{ REDEFINE LABEL "Reference value - 9"; }
  #endif
hand_y_stat_referenzwerte_10 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 10" "|de|Referenzwert - 10"; }
  #else
{ REDEFINE LABEL "Reference value - 10"; }
  #endif
hand_y_stat_referenzwerte_11 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 11" "|de|Referenzwert - 11"; }
  #else
{ REDEFINE LABEL "Reference value - 11"; }
  #endif
hand_y_stat_referenzwerte_12 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 12" "|de|Referenzwert - 12"; }
  #else
{ REDEFINE LABEL "Reference value - 12"; }
  #endif
hand_y_stat_referenzwerte_13 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 13" "|de|Referenzwert - 13"; }
  #else
{ REDEFINE LABEL "Reference value - 13"; }
  #endif
hand_y_stat_referenzwerte_14 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 14" "|de|Referenzwert - 14"; }
  #else
{ REDEFINE LABEL "Reference value - 14"; }
  #endif
hand_y_stat_referenzwerte_15 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 15" "|de|Referenzwert - 15"; }
  #else
{ REDEFINE LABEL "Reference value - 15"; }
  #endif
hand_y_stat_referenzwerte_16 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 16" "|de|Referenzwert - 16"; }
  #else
{ REDEFINE LABEL "Reference value - 16"; }
  #endif
hand_y_stat_referenzwerte_17 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 17" "|de|Referenzwert - 17"; }
  #else
{ REDEFINE LABEL "Reference value - 17"; }
  #endif
hand_y_stat_referenzwerte_18 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 18" "|de|Referenzwert - 18"; }
  #else
{ REDEFINE LABEL "Reference value - 18"; }
  #endif
hand_y_stat_referenzwerte_19 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 19" "|de|Referenzwert - 19"; }
  #else
{ REDEFINE LABEL "Reference value - 19"; }
  #endif
hand_y_stat_referenzwerte_20 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 20" "|de|Referenzwert - 20"; }
  #else
{ REDEFINE LABEL "Reference value - 20"; }
  #endif
hand_y_stat_referenzwerte_21 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 21" "|de|Referenzwert - 21"; }
  #else
{ REDEFINE LABEL "Reference value - 21"; }
  #endif
hand_y_stat_referenzwerte_22 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 22" "|de|Referenzwert - 22"; }
  #else
{ REDEFINE LABEL "Reference value - 22"; }
  #endif
hand_y_stat_referenzwerte_23 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 23" "|de|Referenzwert - 23"; }
  #else
{ REDEFINE LABEL "Reference value - 23"; }
  #endif
hand_y_stat_referenzwerte_24 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 24" "|de|Referenzwert - 24"; }
  #else
{ REDEFINE LABEL "Reference value - 24"; }
  #endif
hand_y_stat_referenzwerte_25 LIKE  VARIABLE  hand_y_stat_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 25" "|de|Referenzwert - 25"; }
  #else
{ REDEFINE LABEL "Reference value - 25"; }
  #endif


/* ------------------------------------------------------------------------ */
/* float 217-241
*/
/* Referenzwerte Ventilstellung (x-Achse) */
/* (nur fr Grafik) */

VARIABLE stat_ref_vs_0
{
  LABEL    "Ventilstellung - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Referenzwert Ventilstellung x";
}

stat_ref_vs_1 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 2"; }
stat_ref_vs_2 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 3"; }
stat_ref_vs_3 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 4"; }
stat_ref_vs_4 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 5"; }
stat_ref_vs_5 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 6"; }
stat_ref_vs_6 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 7"; }
stat_ref_vs_7 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 8"; }
stat_ref_vs_8 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 9"; }
stat_ref_vs_9 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 10"; }
stat_ref_vs_10 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 11"; }
stat_ref_vs_11 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 12"; }
stat_ref_vs_12 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 13"; }
stat_ref_vs_13 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 14"; }
stat_ref_vs_14 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 15"; }
stat_ref_vs_15 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 16"; }
stat_ref_vs_16 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 17"; }
stat_ref_vs_17 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 18"; }
stat_ref_vs_18 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 19"; }
stat_ref_vs_19 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 20"; }
stat_ref_vs_20 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 21"; }
stat_ref_vs_21 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 22"; }
stat_ref_vs_22 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 23"; }
stat_ref_vs_23 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 24"; }
stat_ref_vs_24 		LIKE  VARIABLE  		stat_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 25"; }



/* ------------------------------------------------------------------------ */
/* float 242-266
*/
/* Wiederholungswerte Ventilstellung (x-Achse) */
/* (nur fr Grafik) */

VARIABLE stat_again_vs_0
{
  LABEL    "Ventilstellung - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Wiederholungswert Ventilstellung x";
}

stat_again_vs_1 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 2"; }
stat_again_vs_2 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 3"; }
stat_again_vs_3 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 4"; }
stat_again_vs_4 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 5"; }
stat_again_vs_5 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 6"; }
stat_again_vs_6 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 7"; }
stat_again_vs_7 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 8"; }
stat_again_vs_8 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 9"; }
stat_again_vs_9 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 10"; }
stat_again_vs_10 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 11"; }
stat_again_vs_11 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 12"; }
stat_again_vs_12 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 13"; }
stat_again_vs_13 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 14"; }
stat_again_vs_14 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 15"; }
stat_again_vs_15 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 16"; }
stat_again_vs_16 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 17"; }
stat_again_vs_17 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 18"; }
stat_again_vs_18 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 19"; }
stat_again_vs_19 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 20"; }
stat_again_vs_20 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 21"; }
stat_again_vs_21 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 22"; }
stat_again_vs_22 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 23"; }
stat_again_vs_23 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 24"; }
stat_again_vs_24 		LIKE  VARIABLE  		stat_again_vs_0
{ REDEFINE LABEL "Ventilstellung - 25"; }



/* ------------------------------------------------------------------------ */
/* 3.4   Tests Hand - Stellsignal y Hysterese                               */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 409 */
VARIABLE hand_y_hys_test_information
{
  #ifdef LABEL_DE_EN
  LABEL    "Test information" "|de|Testinformation";
  #else
  LABEL    "Test information";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "Test not active" "|de|Test nicht aktiviert" },
    { 1, "Running test" "|de|Testdurchfhrung" },
    { 2, "Test finished" "|de|Test beendet" },
    { 3, "Test aborted - no measured point"
         "|de|Test abgebrochen - Sttzstelle nicht erreichbar" },
    { 4, "Test aborted - time exceeded"
         "|de|Test abgebrochen - Zeitberschreitung" },
    { 5, "Reference not clear" "|de|Keine eindeutige Referenzkurve aufgenommen" },
    { 6, "Test aborted" "|de|Test wurde abgebrochen" },
    { 7, "Booster - test executed - no evaluation"
         "|de|Booster - Test durchgefhrt - keine Auswertung" }
  #else
    { 0, "Test not active" },
    { 1, "Running test" },
    { 2, "Test finished" },
    { 3, "Test aborted - no measured point" },
    { 4, "Test aborted - time exceeded" },
    { 5, "Reference not clear" },
    { 6, "Test aborted" },
    { 7, "Booster - test executed - no eval." }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status of the test." "|de|Status des Testlaufes.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_char_274 */
VARIABLE hand_y_hys_step_progress
{
  #ifdef LABEL_DE_EN
  LABEL    "Progress" "|de|Fortschritt";
  #else
  LABEL    "Progress";
  #endif
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
#ifdef HELP_EP_DE_EN
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
#endif
}


/* ------------------------------------------------------------------------ */
/* unsigned int 174-185
*/
VARIABLE hand_y_hys_wiederholungswerte_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Repetition value - 1 (5%)" "|de|Wiederholungswert - 1 (5%)";
  #else
  LABEL    "Repetition value - 1 (5%)";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
#ifdef HELP_EP_DE_EN
  HELP     "Repeat values of the hysteresis measurement."
           "|de|Wiederholungswerte der Hysteresemessung.";
#endif
}

hand_y_hys_wiederholungswerte_2 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 2 (10%)" "|de|Wiederholungswert - 2 (10%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 2 (10%)"; }
  #endif
hand_y_hys_wiederholungswerte_3 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 3 (15%)" "|de|Wiederholungswert - 3 (15%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 3 (15%)"; }
  #endif
hand_y_hys_wiederholungswerte_4 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 4 (20%)" "|de|Wiederholungswert - 4 (20%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 4 (20%)"; }
  #endif
hand_y_hys_wiederholungswerte_5 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 5 (30%)" "|de|Wiederholungswert - 5 (30%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 5 (30%)"; }
  #endif
hand_y_hys_wiederholungswerte_6 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 6 (40%)" "|de|Wiederholungswert - 6 (40%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 6 (40%)"; }
  #endif
hand_y_hys_wiederholungswerte_7 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 7 (50%)" "|de|Wiederholungswert - 7 (50%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 7 (50%)"; }
  #endif
hand_y_hys_wiederholungswerte_8 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 8 (60%)" "|de|Wiederholungswert - 8 (60%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 8 (60%)"; }
  #endif
hand_y_hys_wiederholungswerte_9 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 9 (70%)" "|de|Wiederholungswert - 9 (70%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 9 (70%)"; }
  #endif
hand_y_hys_wiederholungswerte_10 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 10 (80%)" "|de|Wiederholungswert - 10 (80%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 10 (80%)"; }
  #endif
hand_y_hys_wiederholungswerte_11 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 11 (90%)" "|de|Wiederholungswert - 11 (90%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 11 (90%)"; }
  #endif
hand_y_hys_wiederholungswerte_12 LIKE  VARIABLE  hand_y_hys_wiederholungswerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Repetition value - 12 (95%)" "|de|Wiederholungswert - 12 (95%)"; }
  #else
{ REDEFINE LABEL "Repetition value - 12 (95%)"; }
  #endif

/* ------------------------------------------------------------------------ */
/* unsigned int 162-173
*/
VARIABLE hand_y_hys_referenzwerte_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Reference value - 1 (5%)" "|de|Referenzwert - 1 (5%)";
  #else
  LABEL    "Reference value - 1 (5%)";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
#ifdef HELP_EP_DE_EN
  HELP     "Valve positions moved to during the test."
           "|de|Ventilstellungen die angefahren werden.";
#endif
}

hand_y_hys_referenzwerte_2 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 2 (10%)" "|de|Referenzwert - 2 (10%)"; }
  #else
{ REDEFINE LABEL "Reference value - 2 (10%)"; }
  #endif
hand_y_hys_referenzwerte_3 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 3 (15%)" "|de|Referenzwert - 3 (15%)"; }
  #else
{ REDEFINE LABEL "Reference value - 3 (15%)"; }
  #endif
hand_y_hys_referenzwerte_4 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 4 (20%)" "|de|Referenzwert - 4 (20%)"; }
  #else
{ REDEFINE LABEL "Reference value - 4 (20%)"; }
  #endif
hand_y_hys_referenzwerte_5 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 5 (30%)" "|de|Referenzwert - 5 (30%)"; }
  #else
{ REDEFINE LABEL "Reference value - 5 (30%)"; }
  #endif
hand_y_hys_referenzwerte_6 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 6 (40%)" "|de|Referenzwert - 6 (40%)"; }
  #else
{ REDEFINE LABEL "Reference value - 6 (40%)"; }
  #endif
hand_y_hys_referenzwerte_7 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 7 (50%)" "|de|Referenzwert - 7 (50%)"; }
  #else
{ REDEFINE LABEL "Reference value - 7 (50%)"; }
  #endif
hand_y_hys_referenzwerte_8 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 8 (60%)" "|de|Referenzwert - 8 (60%)"; }
  #else
{ REDEFINE LABEL "Reference value - 8 (60%)"; }
  #endif
hand_y_hys_referenzwerte_9 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 9 (70%)" "|de|Referenzwert - 9 (70%)"; }
  #else
{ REDEFINE LABEL "Reference value - 9 (70%)"; }
  #endif
hand_y_hys_referenzwerte_10 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 10 (80%)" "|de|Referenzwert - 10 (80%)"; }
  #else
{ REDEFINE LABEL "Reference value - 10 (80%)"; }
  #endif
hand_y_hys_referenzwerte_11 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 11 (90%)" "|de|Referenzwert - 11 (90%)"; }
  #else
{ REDEFINE LABEL "Reference value - 11 (90%)"; }
  #endif
hand_y_hys_referenzwerte_12 LIKE  VARIABLE  hand_y_hys_referenzwerte_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Reference value - 12 (95%)" "|de|Referenzwert - 12 (95%)"; }
  #else
{ REDEFINE LABEL "Reference value - 12 (95%)"; }
  #endif


/* ------------------------------------------------------------------------ */
/* unsigned char 258-269
*/
/* Referenzwerte Ventilstellung (x-Achse) */
/* (nur fr Grafik) */

VARIABLE hys_ref_vs_0
{
  LABEL    "Ventilstellung - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
  HELP     "|de|Referenzwert Ventilstellung";
}

hys_ref_vs_1 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 2"; }
hys_ref_vs_2 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 3"; }
hys_ref_vs_3 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 4"; }
hys_ref_vs_4 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 5"; }
hys_ref_vs_5 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 6"; }
hys_ref_vs_6 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 7"; }
hys_ref_vs_7 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 8"; }
hys_ref_vs_8 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 9"; }
hys_ref_vs_9 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 10"; }
hys_ref_vs_10 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 11"; }
hys_ref_vs_11 		LIKE  VARIABLE  		hys_ref_vs_0
{ REDEFINE LABEL "Ventilstellung - 12"; }


/* ------------------------------------------------------------------------ */
/* 2.6   AUTO - Diagramm Stellsignal Y - Stationaer                         */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* float 46..67
*/
VARIABLE average_value_stat_long_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Average value - 1 (x <= 0 % )"
           "|de|Mittelwert - 1 ( x <= 0 % )";
  #else
  LABEL    "Average value - 1 (x <= 0 % )";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "1/s";
}

average_value_stat_long_2 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 2 ( 0 % <x <= 5 % )"
                 "|de|Mittelwert - 2 ( 0 % < x <= 5 % )"; }
  #else
{ REDEFINE LABEL "Average value - 2 ( 0 % <x <= 5 % )"; }
  #endif
average_value_stat_long_3 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 3 ( 5 % <x <= 10 % )"
                 "|de|Mittelwert - 3 ( 5 % < x <= 10 % )"; }
  #else
{ REDEFINE LABEL "Average value - 3 ( 5 % <x <= 10 % )"; }
  #endif
average_value_stat_long_4 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 4 ( 10 % <x <= 15 % )"
                 "|de|Mittelwert - 4 ( 10 % < x <= 15 % )"; }
  #else
{ REDEFINE LABEL "Average value - 4 ( 10 % <x <= 15 % )"; }
  #endif
average_value_stat_long_5 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 5 ( 15 % <x <= 20 % )"
                 "|de|Mittelwert - 5 ( 15 % < x <= 20 % )"; }
  #else
{ REDEFINE LABEL "Average value - 5 ( 15 % <x <= 20 % )"; }
  #endif
average_value_stat_long_6 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 6 ( 20 % <x <= 25 % )"
                 "|de|Mittelwert - 6 ( 20 % < x <= 25 % )"; }
  #else
{ REDEFINE LABEL "Average value - 6 ( 20 % <x <= 25 % )"; }
  #endif
average_value_stat_long_7 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 7 ( 25 % <x <= 30 % )"
                 "|de|Mittelwert - 7 ( 25 % < x <= 30 % )"; }
  #else
{ REDEFINE LABEL "Average value - 7 ( 25 % <x <= 30 % )"; }
  #endif
average_value_stat_long_8 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 8 ( 30 % <x <= 35 % )"
                 "|de|Mittelwert - 8 ( 30 % < x <= 35 % )"; }
  #else
{ REDEFINE LABEL "Average value - 8 ( 30 % <x <= 35 % )"; }
  #endif
average_value_stat_long_9 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 9 ( 35 % <x <= 40 % )"
                 "|de|Mittelwert - 9 ( 35 % < x <= 40 % )"; }
  #else
{ REDEFINE LABEL "Average value - 9 ( 35 % <x <= 40 % )"; }
  #endif
average_value_stat_long_10 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 10 ( 40 % <x <= 45 % )"
                 "|de|Mittelwert - 10 ( 40 % < x <= 45 % )"; }
  #else
{ REDEFINE LABEL "Average value - 10 ( 40 % <x <= 45 % )"; }
  #endif
average_value_stat_long_11 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 11 ( 45 % <x <= 50 % )"
                 "|de|Mittelwert - 11 ( 45 % < x <= 50 % )"; }
  #else
{ REDEFINE LABEL "Average value - 11 ( 45 % <x <= 50 % )"; }
  #endif
average_value_stat_long_12 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 12 ( 50 % <x <= 55 % )"
                 "|de|Mittelwert - 12 ( 50 % < x <= 55 % )"; }
  #else
{ REDEFINE LABEL "Average value - 12 ( 50 % <x <= 55 % )"; }
  #endif
average_value_stat_long_13 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 13 ( 55 % <x <= 60 % )"
                 "|de|Mittelwert - 13 ( 55 % < x <= 60 % )"; }
  #else
{ REDEFINE LABEL "Average value - 13 ( 55 % <x <= 60 % )"; }
  #endif
average_value_stat_long_14 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 14 ( 60 % <x <= 65 % )"
                 "|de|Mittelwert - 14 ( 60 % < x <= 65 % )"; }
  #else
{ REDEFINE LABEL "Average value - 14 ( 60 % <x <= 65 % )"; }
  #endif
average_value_stat_long_15 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 15 ( 65 % <x <= 70 % )"
                 "|de|Mittelwert - 15 ( 65 % < x <= 70 % )"; }
  #else
{ REDEFINE LABEL "Average value - 15 ( 65 % <x <= 70 % )"; }
  #endif
average_value_stat_long_16 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 16 ( 70 % <x <= 75 % )"
                 "|de|Mittelwert - 16 ( 70 % < x <= 75 % )"; }
  #else
{ REDEFINE LABEL "Average value - 16 ( 70 % <x <= 75 % )"; }
  #endif
average_value_stat_long_17 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 17 ( 75 % <x <= 80 % )"
                 "|de|Mittelwert - 17 ( 75 % < x <= 80 % )"; }
  #else
{ REDEFINE LABEL "Average value - 17 ( 75 % <x <= 80 % )"; }
  #endif
average_value_stat_long_18 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 18 ( 80 % <x <= 85 % )"
                 "|de|Mittelwert - 18 ( 80 % < x <= 85 % )"; }
  #else
{ REDEFINE LABEL "Average value - 18 ( 80 % <x <= 85 % )"; }
  #endif
average_value_stat_long_19 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 19 ( 85 % <x <= 90 % )"
                 "|de|Mittelwert - 19 ( 85 % < x <= 90 % )"; }
  #else
{ REDEFINE LABEL "Average value - 19 ( 85 % <x <= 90 % )"; }
  #endif
average_value_stat_long_20 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 20 ( 90 % <x <= 95 % )"
                 "|de|Mittelwert - 20 ( 90 % < x <= 95 % )"; }
  #else
{ REDEFINE LABEL "Average value - 20 ( 90 % <x <= 95 % )"; }
  #endif
average_value_stat_long_21 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 21 ( 95 % <x <= 100 % )"
                 "|de|Mittelwert - 21 ( 95 % < x <= 100 % )"; }
  #else
{ REDEFINE LABEL "Average value - 21 ( 95 % <x <= 100 % )"; }
  #endif
average_value_stat_long_22 LIKE   VARIABLE  average_value_stat_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 22 ( x > 100 % )"
                 "|de|Mittelwert - 22 ( x > 100 % )"; }
  #else
{ REDEFINE LABEL "Average value - 22 ( x > 100 % )"; }
  #endif


/* ------------------------------------------------------------------------ */
/* AUTO - Diagramm Stellsignal Y - Stationaer - Kurzzeit                    */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* float 68...89
*/
VARIABLE average_value_stat_short_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Average value - 1 (x <= 0 % )"
           "|de|Mittelwert - 1 ( x <= 0 % )";
  #else
  LABEL    "Average value - 1 (x <= 0 % )";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "4.1f";
  }
  CONSTANT_UNIT "1/s";

#ifdef HELP_EP_DE_EN
  HELP     "Average value, formed over all measured data inside the interval."
           "|de|Mittelwert gebildet ber alle Messwerte innerhalb eines Intervalls.";
#endif
}

average_value_stat_short_2 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 2 ( 0 % <x <= 5 % )"
                 "|de|Mittelwert - 2 ( 0 % < x <= 5 % )"; }
  #else
{ REDEFINE LABEL "Average value - 2 ( 0 % <x <= 5 % )"; }
  #endif
average_value_stat_short_3 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 3 ( 5 % <x <= 10 % )"
                 "|de|Mittelwert - 3 ( 5 % < x <= 10 % )"; }
  #else
{ REDEFINE LABEL "Average value - 3 ( 5 % <x <= 10 % )"; }
  #endif
average_value_stat_short_4 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 4 ( 10 % <x <= 15 % )"
                 "|de|Mittelwert - 4 ( 10 % < x <= 15 % )"; }
  #else
{ REDEFINE LABEL "Average value - 4 ( 10 % <x <= 15 % )"; }
  #endif
average_value_stat_short_5 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 5 ( 15 % <x <= 20 % )"
                 "|de|Mittelwert - 5 ( 15 % < x <= 20 % )"; }
  #else
{ REDEFINE LABEL "Average value - 5 ( 15 % <x <= 20 % )"; }
  #endif
average_value_stat_short_6 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 6 ( 20 % <x <= 25 % )"
                 "|de|Mittelwert - 6 ( 20 % < x <= 25 % )"; }
  #else
{ REDEFINE LABEL "Average value - 6 ( 20 % <x <= 25 % )"; }
  #endif
average_value_stat_short_7 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 7 ( 25 % <x <= 30 % )"
                 "|de|Mittelwert - 7 ( 25 % < x <= 30 % )"; }
  #else
{ REDEFINE LABEL "Average value - 7 ( 25 % <x <= 30 % )"; }
  #endif
average_value_stat_short_8 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 8 ( 30 % <x <= 35 % )"
                 "|de|Mittelwert - 8 ( 30 % < x <= 35 % )"; }
  #else
{ REDEFINE LABEL "Average value - 8 ( 30 % <x <= 35 % )"; }
  #endif
average_value_stat_short_9 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 9 ( 35 % <x <= 40 % )"
                 "|de|Mittelwert - 9 ( 35 % < x <= 40 % )"; }
  #else
{ REDEFINE LABEL "Average value - 9 ( 35 % <x <= 40 % )"; }
  #endif
average_value_stat_short_10 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 10 ( 40 % <x <= 45 % )"
                 "|de|Mittelwert - 10 ( 40 % < x <= 45 % )"; }
  #else
{ REDEFINE LABEL "Average value - 10 ( 40 % <x <= 45 % )"; }
  #endif
average_value_stat_short_11 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 11 ( 45 % <x <= 50 % )"
                 "|de|Mittelwert - 11 ( 45 % < x <= 50 % )"; }
  #else
{ REDEFINE LABEL "Average value - 11 ( 45 % <x <= 50 % )"; }
  #endif
average_value_stat_short_12 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 12 ( 50 % <x <= 55 % )"
                 "|de|Mittelwert - 12 ( 50 % < x <= 55 % )"; }
  #else
{ REDEFINE LABEL "Average value - 12 ( 50 % <x <= 55 % )"; }
  #endif
average_value_stat_short_13 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 13 ( 55 % <x <= 60 % )"
                 "|de|Mittelwert - 13 ( 55 % < x <= 60 % )"; }
  #else
{ REDEFINE LABEL "Average value - 13 ( 55 % <x <= 60 % )"; }
  #endif
average_value_stat_short_14 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 14 ( 60 % <x <= 65 % )"
                 "|de|Mittelwert - 14 ( 60 % < x <= 65 % )"; }
  #else
{ REDEFINE LABEL "Average value - 14 ( 60 % <x <= 65 % )"; }
  #endif
average_value_stat_short_15 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 15 ( 65 % <x <= 70 % )"
                 "|de|Mittelwert - 15 ( 65 % < x <= 70 % )"; }
  #else
{ REDEFINE LABEL "Average value - 15 ( 65 % <x <= 70 % )"; }
  #endif
average_value_stat_short_16 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 16 ( 70 % <x <= 75 % )"
                 "|de|Mittelwert - 16 ( 70 % < x <= 75 % )"; }
  #else
{ REDEFINE LABEL "Average value - 16 ( 70 % <x <= 75 % )"; }
  #endif
average_value_stat_short_17 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 17 ( 75 % <x <= 80 % )"
                 "|de|Mittelwert - 17 ( 75 % < x <= 80 % )"; }
  #else
{ REDEFINE LABEL "Average value - 17 ( 75 % <x <= 80 % )"; }
  #endif
average_value_stat_short_18 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 18 ( 80 % <x <= 85 % )"
                 "|de|Mittelwert - 18 ( 80 % < x <= 85 % )"; }
  #else
{ REDEFINE LABEL "Average value - 18 ( 80 % <x <= 85 % )"; }
  #endif
average_value_stat_short_19 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 19 ( 85 % <x <= 90 % )"
                 "|de|Mittelwert - 19 ( 85 % < x <= 90 % )"; }
  #else
{ REDEFINE LABEL "Average value - 19 ( 85 % <x <= 90 % )"; }
  #endif
average_value_stat_short_20 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 20 ( 90 % <x <= 95 % )"
                 "|de|Mittelwert - 20 ( 90 % < x <= 95 % )"; }
  #else
{ REDEFINE LABEL "Average value - 20 ( 90 % <x <= 95 % )"; }
  #endif
average_value_stat_short_21 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 21 ( 95 % <x <= 100 % )"
                 "|de|Mittelwert - 21 ( 95 % < x <= 100 % )"; }
  #else
{ REDEFINE LABEL "Average value - 21 ( 95 % <x <= 100 % )"; }
  #endif
average_value_stat_short_22 LIKE   VARIABLE  average_value_stat_short_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 22 ( x > 100 % )"
                 "|de|Mittelwert - 22 ( x > 100 % )"; }
  #else
{ REDEFINE LABEL "Average value - 22 ( x > 100 % )"; }
  #endif


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Stationaer Kurz RP Stellsignal                           */
/* (unsigned integer 30..39) */
/* ------------------------------------------------------------------------ */

VARIABLE stat_stellsignal_Value_0
{
  LABEL    "Drive signal - value 1" "|de|Stellsignal - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";
  HELP     "Currently recorded drive signal." "|de|Aktuell aufgenommenes Stellsignal.";
}

stat_stellsignal_Value_1 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 2" "|de|Stellsignal - Wert 2"; }
stat_stellsignal_Value_2 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 3" "|de|Stellsignal - Wert 3"; }
stat_stellsignal_Value_3 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 4" "|de|Stellsignal - Wert 4"; }
stat_stellsignal_Value_4 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 5" "|de|Stellsignal - Wert 5"; }
stat_stellsignal_Value_5 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 6" "|de|Stellsignal - Wert 6"; }
stat_stellsignal_Value_6 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 7" "|de|Stellsignal - Wert 7"; }
stat_stellsignal_Value_7 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 8" "|de|Stellsignal - Wert 8"; }
stat_stellsignal_Value_8 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 9" "|de|Stellsignal - Wert 9"; }
stat_stellsignal_Value_9 		LIKE  VARIABLE  		stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 10" "|de|Stellsignal - Wert 10"; }


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Stationaer Kurz RP Ventilstellung                        */
/* (float 90..99) */
/* ------------------------------------------------------------------------ */

VARIABLE stat_ventilstellung_Value_0
{
  LABEL    "Valve position - value 1" "|de|Ventilstellung - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Currently recorded valve position." "|de|Aktuell aufgenommene Ventilstellung.";
}

stat_ventilstellung_Value_1 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 2" "|de|Ventilstellung - Wert 2"; }
stat_ventilstellung_Value_2 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 3" "|de|Ventilstellung - Wert 3"; }
stat_ventilstellung_Value_3 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 4" "|de|Ventilstellung - Wert 4"; }
stat_ventilstellung_Value_4 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 5" "|de|Ventilstellung - Wert 5"; }
stat_ventilstellung_Value_5 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 6" "|de|Ventilstellung - Wert 6"; }
stat_ventilstellung_Value_6 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 7" "|de|Ventilstellung - Wert 7"; }
stat_ventilstellung_Value_7 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 8" "|de|Ventilstellung - Wert 8"; }
stat_ventilstellung_Value_8 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 9" "|de|Ventilstellung - Wert 9"; }
stat_ventilstellung_Value_9 		LIKE  VARIABLE  		stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 10" "|de|Ventilstellung - Wert 10"; }



/* ------------------------------------------------------------------------ */
/* 2.7   AUTO - Diagramm Stellsignal Y - Hysterese                          */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 188 */
VARIABLE start_abort_hysteresis_online_test
{
  #ifdef LABEL_DE_EN
  LABEL    "Hysteresis online test control" "|de|Steuerung Hysterese online Test";
  #else
  LABEL    "Hysteresis online test control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Stop"  "|de|Stopp" },
    { 1, "Start" "|de|Start" }
  #else
    { 0, "Stop"  },
    { 1, "Start" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Activates the hysteresis online test d5."
           "|de|Aktiviert den Hysterese Online Test d5.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 408 */
VARIABLE test_information
{
  #ifdef LABEL_DE_EN
  LABEL    "Test information" "|de|Testinformation";
  #else
  LABEL    "Test information";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {  0, "Test not active" "|de|Test nicht aktiviert" },
    {  1, "Waiting for time permission" "|de|Warten auf Zeiterlaubnis" },
    {  2, "Running test" "|de|Testdurchfhrung" },
    {  3, "Test finished" "|de|Test beendet" },
    {  4, "Test aborted-ref. value was changed" "|de|Test abgebrochen-W wurde verndert" },
    {  5, "Test aborted-time exceeded" "|de|Test abgebrochen-Zeitberschreitung" },
    {  6, "Test finished-waiting for time permission" "|de|Test beendet-Warten auf Zeiterlaubnis" },
    {  7, "Test aborted" "|de|Test wurde abgebrochen" },
    {  8, "No test (wrong characteristic)" "|de|Kein Test (falscher Kennlinientyp)" },
    {  9, "Booster-test executed-no eval." "|de|Booster-Test durchgefhrt-keine Auswertung" },
    { 10, "No test-permitted range: 2%<travel<98%" "|de|Kein Testlauf-erl. Bereich: 2%<Hub<98%" }
  #else
    {  0, "Test not active" },
    {  1, "Waiting for time permission" },
    {  2, "Running test" },
    {  3, "Test finished" },
    {  4, "Test aborted-ref. value was changed" },
    {  5, "Test aborted-time exceeded" },
    {  6, "Test finished-waiting for time permission" },
    {  7, "Test aborted" },
    {  8, "No test (wrong characteristic)" },
    {  9, "Booster-test executed-no eval." },
    { 10, "No test-permitted range: 2%<travel<98%" }
  #endif
  }
#ifdef HELP_EP_DE_EN
  HELP     "Status of the test." "|de|Status des Testlaufes.";
#endif
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE hys_stell_y (unsigned_long_480)
(Diagnose - Beobachterfunktionen AUTO - Diagramm Stellsignal y - Hysterese)
*/
VARIABLE hys_stell_y
{
  #ifdef LABEL_DE_EN
  LABEL    "Min. time distance from test" "|de|Zeitl. Mindestabstand";
  #else
  LABEL    "Min. time distance from test";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE    36000;
     DISPLAY_FORMAT "2.1f";
     MIN_VALUE      0; /*  0h */
     MAX_VALUE 864000; /* 24h * 36000 */
  }
  CONSTANT_UNIT "h";          /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Shows in which time intervals the test is repeated."
           "|de|Gibt an, in welchen Zeitabstnden der Test wiederholt werden soll.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float 100..118
*/
VARIABLE average_value_long_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Average value - 1 ( 3 % <x <= 8 % )"
           "|de|Mittelwert - 1 ( 3 % < x <= 8 % )";
  #else
  LABEL    "Average value - 1 ( 3 % <x <= 8 % )";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "1/s";
}

average_value_long_2 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 2 ( 8 % <x <= 13 % )"
                 "|de|Mittelwert - 2 ( 8 % < x <= 13 % )"; }
  #else
{ REDEFINE LABEL "Average value - 2 ( 8 % <x <= 13 % )"; }
  #endif
average_value_long_3 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 3 ( 13 % <x <= 18 % )"
                 "|de|Mittelwert - 3 ( 13 % < x <= 18 % )"; }
  #else
{ REDEFINE LABEL "Average value - 3 ( 13 % <x <= 18 % )"; }
  #endif
average_value_long_4 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 4 ( 18 % <x <= 23 % )"
                 "|de|Mittelwert - 4 ( 18 % < x <= 23 % )"; }
  #else
{ REDEFINE LABEL "Average value - 4 ( 18 % <x <= 23 % )"; }
  #endif
average_value_long_5 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 5 ( 23 % <x <= 28 % )"
                 "|de|Mittelwert - 5 ( 23 % < x <= 28 % )"; }
  #else
{ REDEFINE LABEL "Average value - 5 ( 23 % <x <= 28 % )"; }
  #endif
average_value_long_6 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 6 ( 28 % <x <= 33 % )"
                 "|de|Mittelwert - 6 ( 28 % < x <= 33 % )"; }
  #else
{ REDEFINE LABEL "Average value - 6 ( 28 % <x <= 33 % )"; }
  #endif
average_value_long_7 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 7 ( 33 % <x <= 38 % )"
                 "|de|Mittelwert - 7 ( 33 % < x <= 38 % )"; }
  #else
{ REDEFINE LABEL "Average value - 7 ( 33 % <x <= 38 % )"; }
  #endif
average_value_long_8 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 8 ( 38 % <x <= 43 % )"
                 "|de|Mittelwert - 8 ( 38 % < x <= 43 % )"; }
  #else
{ REDEFINE LABEL "Average value - 8 ( 38 % <x <= 43 % )"; }
  #endif
average_value_long_9 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 9 ( 43 % <x <= 48 % )"
                 "|de|Mittelwert - 9 ( 43 % < x <= 48 % )"; }
  #else
{ REDEFINE LABEL "Average value - 9 ( 43 % <x <= 48 % )"; }
  #endif
average_value_long_10 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 10 ( 48 % <x <= 53 % )"
                 "|de|Mittelwert - 10 ( 48 % < x <= 53 % )"; }
  #else
{ REDEFINE LABEL "Average value - 10 ( 48 % <x <= 53 % )"; }
  #endif
average_value_long_11 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 11 ( 53 % <x <= 58 % )"
                 "|de|Mittelwert - 11 ( 53 % < x <= 58 % )"; }
  #else
{ REDEFINE LABEL "Average value - 11 ( 53 % <x <= 58 % )"; }
  #endif
average_value_long_12 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 12 ( 58 % <x <= 63 % )"
                 "|de|Mittelwert - 12 ( 58 % < x <= 63 % )"; }
  #else
{ REDEFINE LABEL "Average value - 12 ( 58 % <x <= 63 % )"; }
  #endif
average_value_long_13 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 13 ( 63 % <x <= 68 % )"
                 "|de|Mittelwert - 13 ( 63 % < x <= 68 % )"; }
  #else
{ REDEFINE LABEL "Average value - 13 ( 63 % <x <= 68 % )"; }
  #endif
average_value_long_14 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 14 ( 68 % <x <= 73 % )"
                 "|de|Mittelwert - 14 ( 68 % < x <= 73 % )"; }
  #else
{ REDEFINE LABEL "Average value - 14 ( 68 % <x <= 73 % )"; }
  #endif
average_value_long_15 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 15 ( 73 % <x <= 78 % )"
                 "|de|Mittelwert - 15 ( 73 % < x <= 78 % )"; }
  #else
{ REDEFINE LABEL "Average value - 15 ( 73 % <x <= 78 % )"; }
  #endif
average_value_long_16 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 16 ( 78 % <x <= 83 % )"
                 "|de|Mittelwert - 16 ( 78 % < x <= 83 % )"; }
  #else
{ REDEFINE LABEL "Average value - 16 ( 78 % <x <= 83 % )"; }
  #endif
average_value_long_17 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 17 ( 83 % <x <= 88 % )"
                 "|de|Mittelwert - 17 ( 83 % < x <= 88 % )"; }
  #else
{ REDEFINE LABEL "Average value - 17 ( 83 % <x <= 88 % )"; }
  #endif
average_value_long_18 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 18 ( 88 % <x <= 93 % )"
                 "|de|Mittelwert - 18 ( 88 % < x <= 93 % )"; }
  #else
{ REDEFINE LABEL "Average value - 18 ( 88 % <x <= 93 % )"; }
  #endif
average_value_long_19 LIKE   VARIABLE  average_value_long_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Average value - 19 ( 93 % <x <= 98 % )"
                 "|de|Mittelwert - 19 ( 93 % < x <= 98 % )"; }
  #else
{ REDEFINE LABEL "Average value - 19 ( 93 % <x <= 98 % )"; }
  #endif


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Hysterese Kurz RP Differenz Stellsignal                  */
/* (unsigned integer 40..49) */
/* ------------------------------------------------------------------------ */

VARIABLE hys_stellsignal_Value_0
{
  LABEL    "Drive signal - value 1" "|de|Stellsignal - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";
  HELP     "Hysteresis at the valve position." "|de|Hysteresebreite an der Ventilstellung.";
}

hys_stellsignal_Value_1 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 2" "|de|Stellsignal - Wert 2"; }
hys_stellsignal_Value_2 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 3" "|de|Stellsignal - Wert 3"; }
hys_stellsignal_Value_3 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 4" "|de|Stellsignal - Wert 4"; }
hys_stellsignal_Value_4 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 5" "|de|Stellsignal - Wert 5"; }
hys_stellsignal_Value_5 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 6" "|de|Stellsignal - Wert 6"; }
hys_stellsignal_Value_6 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 7" "|de|Stellsignal - Wert 7"; }
hys_stellsignal_Value_7 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 8" "|de|Stellsignal - Wert 8"; }
hys_stellsignal_Value_8 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 9" "|de|Stellsignal - Wert 9"; }
hys_stellsignal_Value_9 		LIKE  VARIABLE  		hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 10" "|de|Stellsignal - Wert 10"; }


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Hysterese Kurz RP Ventilstellung                         */
/* (float 144..153) */
/* ------------------------------------------------------------------------ */

VARIABLE hys_ventilstellung_Value_0
{
  LABEL    "Valve position - value 1" "|de|Ventilstellung - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Valve position." "|de|Ventilstellung.";
}

hys_ventilstellung_Value_1 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 2" "|de|Ventilstellung - Wert 2"; }
hys_ventilstellung_Value_2 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 3" "|de|Ventilstellung - Wert 3"; }
hys_ventilstellung_Value_3 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 4" "|de|Ventilstellung - Wert 4"; }
hys_ventilstellung_Value_4 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 5" "|de|Ventilstellung - Wert 5"; }
hys_ventilstellung_Value_5 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 6" "|de|Ventilstellung - Wert 6"; }
hys_ventilstellung_Value_6 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 7" "|de|Ventilstellung - Wert 7"; }
hys_ventilstellung_Value_7 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 8" "|de|Ventilstellung - Wert 8"; }
hys_ventilstellung_Value_8 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 9" "|de|Ventilstellung - Wert 9"; }
hys_ventilstellung_Value_9 		LIKE  VARIABLE  		hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 10" "|de|Ventilstellung - Wert 10"; }



/* ------------------------------------------------------------------------ */
/* 2.8   Endlagentrend                                                      */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* float 216
*/
VARIABLE ref_value_valve_position
{
  #ifdef LABEL_DE_EN
  LABEL    "Reference value - valve position"
           "|de|Referenzwert - Ventilstellung";
  #else
  LABEL    "Reference value - valve position";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";

#ifdef HELP_EP_DE_EN
  HELP     "Recorded reference valve position in the lower end position."
           "|de|Aufgenommene Referenzventilstellung in der unteren Endlage.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float 185...214
*/
VARIABLE valve_pos_meas_point_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Valve position - meas. point 1" "|de|Ventilstellung x - Messpunkt 1";
  #else
  LABEL    "Valve position - meas. point 1";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";

#ifdef HELP_EP_DE_EN
  HELP     "Valve position at activated lower end position."
           "|de|Ventilstellung bei Aktivierung der unteren Endlage.";
#endif
}

valve_pos_meas_point_2  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 2" "|de|Ventilstellung x - Messpunkt 2"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 2"; }
  #endif
valve_pos_meas_point_3  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 3" "|de|Ventilstellung x - Messpunkt 3"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 3"; }
  #endif
valve_pos_meas_point_4  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 4" "|de|Ventilstellung x - Messpunkt 4"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 4"; }
  #endif
valve_pos_meas_point_5  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 5" "|de|Ventilstellung x - Messpunkt 5"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 5"; }
  #endif
valve_pos_meas_point_6  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 6" "|de|Ventilstellung x - Messpunkt 6"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 6"; }
  #endif
valve_pos_meas_point_7  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 7" "|de|Ventilstellung x - Messpunkt 7"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 7"; }
  #endif
valve_pos_meas_point_8  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 8" "|de|Ventilstellung x - Messpunkt 8"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 8"; }
  #endif
valve_pos_meas_point_9  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 9" "|de|Ventilstellung x - Messpunkt 9"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 9"; }
  #endif
valve_pos_meas_point_10  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 10" "|de|Ventilstellung x - Messpunkt 10"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 10"; }
  #endif
valve_pos_meas_point_11  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 11" "|de|Ventilstellung x - Messpunkt 11"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 11"; }
  #endif
valve_pos_meas_point_12  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 12" "|de|Ventilstellung x - Messpunkt 12"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 12"; }
  #endif
valve_pos_meas_point_13  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 13" "|de|Ventilstellung x - Messpunkt 13"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 13"; }
  #endif
valve_pos_meas_point_14  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 14" "|de|Ventilstellung x - Messpunkt 14"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 14"; }
  #endif
valve_pos_meas_point_15  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 15" "|de|Ventilstellung x - Messpunkt 15"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 15"; }
  #endif
valve_pos_meas_point_16  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 16" "|de|Ventilstellung x - Messpunkt 16"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 16"; }
  #endif
valve_pos_meas_point_17  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 17" "|de|Ventilstellung x - Messpunkt 17"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 17"; }
  #endif
valve_pos_meas_point_18  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 18" "|de|Ventilstellung x - Messpunkt 18"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 18"; }
  #endif
valve_pos_meas_point_19  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 19" "|de|Ventilstellung x - Messpunkt 19"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 19"; }
  #endif
valve_pos_meas_point_20  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 20" "|de|Ventilstellung x - Messpunkt 20"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 20"; }
  #endif
valve_pos_meas_point_21  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 21" "|de|Ventilstellung x - Messpunkt 21"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 21"; }
  #endif
valve_pos_meas_point_22  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 22" "|de|Ventilstellung x - Messpunkt 22"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 22"; }
  #endif
valve_pos_meas_point_23  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 23" "|de|Ventilstellung x - Messpunkt 23"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 23"; }
  #endif
valve_pos_meas_point_24  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 24" "|de|Ventilstellung x - Messpunkt 24"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 24"; }
  #endif
valve_pos_meas_point_25  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 25" "|de|Ventilstellung x - Messpunkt 25"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 25"; }
  #endif
valve_pos_meas_point_26  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 26" "|de|Ventilstellung x - Messpunkt 26"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 26"; }
  #endif
valve_pos_meas_point_27  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 27" "|de|Ventilstellung x - Messpunkt 27"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 27"; }
  #endif
valve_pos_meas_point_28  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 28" "|de|Ventilstellung x - Messpunkt 28"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 28"; }
  #endif
valve_pos_meas_point_29  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 29" "|de|Ventilstellung x - Messpunkt 29"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 29"; }
  #endif
valve_pos_meas_point_30  LIKE  VARIABLE  valve_pos_meas_point_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Valve position - meas. point 30" "|de|Ventilstellung x - Messpunkt 30"; }
  #else
{ REDEFINE LABEL "Valve position - meas. point 30"; }
  #endif


/* ------------------------------------------------------------------------ */
/* unsigned long 191
*/
VARIABLE lower_end_position_ref_value_bsz
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position reference value EHM"
           "|de|Untere Endlage Referenzwert BSZ";
  #else
  LABEL    "Lower end position reference value EHM";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of reference value in the lower end position."
           "|de|Zeit vom Referenzwert in der unteren Endlage.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned long 160...189
*/
VARIABLE lower_end_position_bsz_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 1" "|de|Untere Endlage BSZ 1";
  #else
  LABEL    "Lower end position EHM 1";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 2" "|de|Untere Endlage BSZ 2";
  #else
  LABEL    "Lower end position EHM 2";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_3
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 3" "|de|Untere Endlage BSZ 3";
  #else
  LABEL    "Lower end position EHM 3";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_4
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 4" "|de|Untere Endlage BSZ 4";
  #else
  LABEL    "Lower end position EHM 4";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_5
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 5" "|de|Untere Endlage BSZ 5";
  #else
  LABEL    "Lower end position EHM 5";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_6
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 6" "|de|Untere Endlage BSZ 6";
  #else
  LABEL    "Lower end position EHM 6";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_7
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 7" "|de|Untere Endlage BSZ 7";
  #else
  LABEL    "Lower end position EHM 7";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_8
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 8" "|de|Untere Endlage BSZ 8";
  #else
  LABEL    "Lower end position EHM 8";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_9
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 9" "|de|Untere Endlage BSZ 9";
  #else
  LABEL    "Lower end position EHM 9";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_10
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 10" "|de|Untere Endlage BSZ 10";
  #else
  LABEL    "Lower end position EHM 10";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_11
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 11" "|de|Untere Endlage BSZ 11";
  #else
  LABEL    "Lower end position EHM 11";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_12
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 12" "|de|Untere Endlage BSZ 12";
  #else
  LABEL    "Lower end position EHM 12";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_13
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 13" "|de|Untere Endlage BSZ 13";
  #else
  LABEL    "Lower end position EHM 13";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_14
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 14" "|de|Untere Endlage BSZ 14";
  #else
  LABEL    "Lower end position EHM 14";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_15
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 15" "|de|Untere Endlage BSZ 15";
  #else
  LABEL    "Lower end position EHM 15";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_16
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 16" "|de|Untere Endlage BSZ 16";
  #else
  LABEL    "Lower end position EHM 16";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_17
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 17" "|de|Untere Endlage BSZ 17";
  #else
  LABEL    "Lower end position EHM 17";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_18
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 18" "|de|Untere Endlage BSZ 18";
  #else
  LABEL    "Lower end position EHM 18";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_19
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 19" "|de|Untere Endlage BSZ 19";
  #else
  LABEL    "Lower end position EHM 19";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_20
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 20" "|de|Untere Endlage BSZ 20";
  #else
  LABEL    "Lower end position EHM 20";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_21
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 21" "|de|Untere Endlage BSZ 21";
  #else
  LABEL    "Lower end position EHM 21";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_22
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 22" "|de|Untere Endlage BSZ 22";
  #else
  LABEL    "Lower end position EHM 22";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_23
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 23" "|de|Untere Endlage BSZ 23";
  #else
  LABEL    "Lower end position EHM 23";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_24
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 24" "|de|Untere Endlage BSZ 24";
  #else
  LABEL    "Lower end position EHM 24";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_25
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 25" "|de|Untere Endlage BSZ 25";
  #else
  LABEL    "Lower end position EHM 25";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_26
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 26" "|de|Untere Endlage BSZ 26";
  #else
  LABEL    "Lower end position EHM 26";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_27
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 27" "|de|Untere Endlage BSZ 27";
  #else
  LABEL    "Lower end position EHM 27";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_28
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 28" "|de|Untere Endlage BSZ 28";
  #else
  LABEL    "Lower end position EHM 28";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_29
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 29" "|de|Untere Endlage BSZ 29";
  #else
  LABEL    "Lower end position EHM 29";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}

VARIABLE lower_end_position_bsz_30
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position EHM 30" "|de|Untere Endlage BSZ 30";
  #else
  LABEL    "Lower end position EHM 30";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

#ifdef HELP_EP_DE_EN
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
#endif
}


/* POST_READ_ACTIONS geht nicht wegen LIKE VARIABLE !

lower_end_position_bsz_2  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 2" "|de|Untere Endlage BSZ 2"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 2"; }
  #endif
lower_end_position_bsz_3  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 3" "|de|Untere Endlage BSZ 3"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 3"; }
  #endif
lower_end_position_bsz_4  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 4" "|de|Untere Endlage BSZ 4"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 4"; }
  #endif
lower_end_position_bsz_5  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 5" "|de|Untere Endlage BSZ 5"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 5"; }
  #endif
lower_end_position_bsz_6  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 6" "|de|Untere Endlage BSZ 6"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 6"; }
  #endif
lower_end_position_bsz_7  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 7" "|de|Untere Endlage BSZ 7"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 7"; }
  #endif
lower_end_position_bsz_8  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 8" "|de|Untere Endlage BSZ 8"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 8"; }
  #endif
lower_end_position_bsz_9  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 9" "|de|Untere Endlage BSZ 9"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 9"; }
  #endif
lower_end_position_bsz_10  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 10" "|de|Untere Endlage BSZ 10"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 10"; }
  #endif
lower_end_position_bsz_11  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 11" "|de|Untere Endlage BSZ 11"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 11"; }
  #endif
lower_end_position_bsz_12  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 12" "|de|Untere Endlage BSZ 12"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 12"; }
  #endif
lower_end_position_bsz_13  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 13" "|de|Untere Endlage BSZ 13"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 13"; }
  #endif
lower_end_position_bsz_14  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 14" "|de|Untere Endlage BSZ 14"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 14"; }
  #endif
lower_end_position_bsz_15  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 15" "|de|Untere Endlage BSZ 15"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 15"; }
  #endif
lower_end_position_bsz_16  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 16" "|de|Untere Endlage BSZ 16"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 16"; }
  #endif
lower_end_position_bsz_17  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 17" "|de|Untere Endlage BSZ 17"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 17"; }
  #endif
lower_end_position_bsz_18  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 18" "|de|Untere Endlage BSZ 18"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 18"; }
  #endif
lower_end_position_bsz_19  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 19" "|de|Untere Endlage BSZ 19"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 19"; }
  #endif
lower_end_position_bsz_20  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 20" "|de|Untere Endlage BSZ 20"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 20"; }
  #endif
lower_end_position_bsz_21  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 21" "|de|Untere Endlage BSZ 21"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 21"; }
  #endif
lower_end_position_bsz_22  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 22" "|de|Untere Endlage BSZ 22"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 22"; }
  #endif
lower_end_position_bsz_23  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 23" "|de|Untere Endlage BSZ 23"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 23"; }
  #endif
lower_end_position_bsz_24  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 24" "|de|Untere Endlage BSZ 24"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 24"; }
  #endif
lower_end_position_bsz_25  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 25" "|de|Untere Endlage BSZ 25"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 25"; }
  #endif
lower_end_position_bsz_26  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 26" "|de|Untere Endlage BSZ 26"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 26"; }
  #endif
lower_end_position_bsz_27  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 27" "|de|Untere Endlage BSZ 27"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 27"; }
  #endif
lower_end_position_bsz_28  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 28" "|de|Untere Endlage BSZ 28"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 28"; }
  #endif
lower_end_position_bsz_29  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 29" "|de|Untere Endlage BSZ 29"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 29"; }
  #endif
lower_end_position_bsz_30  LIKE  VARIABLE  lower_end_position_bsz_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position EHM 30" "|de|Untere Endlage BSZ 30"; }
  #else
{ REDEFINE LABEL "Lower end position EHM 30"; }
  #endif
*/


/* ------------------------------------------------------------------------ */
/* unsigned int 111
*/
VARIABLE trend_travel_end_pos_drive_signal_ref
{
  #ifdef LABEL_DE_EN
  LABEL    "Trend travel end pos. drive signal ref."
           "|de|Endlage unten Ref.-wert Stellsignal";
  #else
  LABEL    "Trend travel end pos. drive signal ref.";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";

#ifdef HELP_EP_DE_EN
  HELP     "Drive signal y of reference value in the lower end position."
           "|de|Stellsignal y vom Referenzwert der unteren Endlage.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned int 50...79
*/
VARIABLE lower_end_pos_drive_signal_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Lower end position drive signal 1" "|de|Untere Endlage Stellsignal 1";
  #else
  LABEL    "Lower end position drive signal 1";
  #endif

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";

#ifdef HELP_EP_DE_EN
  HELP     "Drive signal y at activated lower end position."
           "|de|Stellsignal y bei Aktivierung der unteren Endlage.";
#endif
}

lower_end_pos_drive_signal_2 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 2" "|de|Untere Endlage Stellsignal 2"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 2"; }
  #endif
lower_end_pos_drive_signal_3 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 3" "|de|Untere Endlage Stellsignal 3"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 3"; }
  #endif
lower_end_pos_drive_signal_4 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 4" "|de|Untere Endlage Stellsignal 4"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 4"; }
  #endif
lower_end_pos_drive_signal_5 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 5" "|de|Untere Endlage Stellsignal 5"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 5"; }
  #endif
lower_end_pos_drive_signal_6 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 6" "|de|Untere Endlage Stellsignal 6"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 6"; }
  #endif
lower_end_pos_drive_signal_7 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 7" "|de|Untere Endlage Stellsignal 7"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 7"; }
  #endif
lower_end_pos_drive_signal_8 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 8" "|de|Untere Endlage Stellsignal 8"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 8"; }
  #endif
lower_end_pos_drive_signal_9 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 9" "|de|Untere Endlage Stellsignal 9"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 9"; }
  #endif
lower_end_pos_drive_signal_10 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 10" "|de|Untere Endlage Stellsignal 10"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 10"; }
  #endif
lower_end_pos_drive_signal_11 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 11" "|de|Untere Endlage Stellsignal 11"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 11"; }
  #endif
lower_end_pos_drive_signal_12 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 12" "|de|Untere Endlage Stellsignal 12"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 12"; }
  #endif
lower_end_pos_drive_signal_13 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 13" "|de|Untere Endlage Stellsignal 13"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 13"; }
  #endif
lower_end_pos_drive_signal_14 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 14" "|de|Untere Endlage Stellsignal 14"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 14"; }
  #endif
lower_end_pos_drive_signal_15 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 15" "|de|Untere Endlage Stellsignal 15"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 15"; }
  #endif
lower_end_pos_drive_signal_16 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 16" "|de|Untere Endlage Stellsignal 16"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 16"; }
  #endif
lower_end_pos_drive_signal_17 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 17" "|de|Untere Endlage Stellsignal 17"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 17"; }
  #endif
lower_end_pos_drive_signal_18 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 18" "|de|Untere Endlage Stellsignal 18"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 18"; }
  #endif
lower_end_pos_drive_signal_19 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 19" "|de|Untere Endlage Stellsignal 19"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 19"; }
  #endif
lower_end_pos_drive_signal_20 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 20" "|de|Untere Endlage Stellsignal 20"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 20"; }
  #endif
lower_end_pos_drive_signal_21 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 21" "|de|Untere Endlage Stellsignal 21"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 21"; }
  #endif
lower_end_pos_drive_signal_22 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 22" "|de|Untere Endlage Stellsignal 22"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 22"; }
  #endif
lower_end_pos_drive_signal_23 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 23" "|de|Untere Endlage Stellsignal 23"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 23"; }
  #endif
lower_end_pos_drive_signal_24 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 24" "|de|Untere Endlage Stellsignal 24"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 24"; }
  #endif
lower_end_pos_drive_signal_25 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 25" "|de|Untere Endlage Stellsignal 25"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 25"; }
  #endif
lower_end_pos_drive_signal_26 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 26" "|de|Untere Endlage Stellsignal 26"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 26"; }
  #endif
lower_end_pos_drive_signal_27 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 27" "|de|Untere Endlage Stellsignal 27"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 27"; }
  #endif
lower_end_pos_drive_signal_28 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 28" "|de|Untere Endlage Stellsignal 28"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 28"; }
  #endif
lower_end_pos_drive_signal_29 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 29" "|de|Untere Endlage Stellsignal 29"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 29"; }
  #endif
lower_end_pos_drive_signal_30 LIKE  VARIABLE  lower_end_pos_drive_signal_1
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Lower end position drive signal 30" "|de|Untere Endlage Stellsignal 30"; }
  #else
{ REDEFINE LABEL "Lower end position drive signal 30"; }
  #endif



/* ------------------------------------------------------------------------ */
/* 4.2 PST Parameter                                                        */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned integer (cmd 255)
*/
VARIABLE pst_enabling_code
{
  #ifdef LABEL_DE_EN
    LABEL "PST enabling code" "|de|PST Freigabecode";
  #else
    LABEL "PST enabling code";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
    MIN_VALUE    0;
    MAX_VALUE 1999;
  }

  VALIDITY_ONLY_3730_3_143_PST

  #ifdef HELP_EP_DE_EN
    HELP "Write protection for PST mode."
         "|de|PST Schreibschutz.";
  #endif
}


/* ----------------------------------------- */
/* Diagnose - PST                            */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned char 309 (cmd xx/xx)
*/
VARIABLE pst_mode_on_off
{
  #ifdef LABEL_DE_EN
  LABEL    "PST mode" "|de|PST-Modus";
  #else
  LABEL    "PST mode";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Off" "|de|Aus" },
    { 1, "On"  "|de|Ein" }
  #else
    { 0, "Off" },
    { 1, "On"  }
  #endif
  }

  VALIDITY_ONLY_3730_3_143_PST

#ifdef HELP_EP_DE_EN
  HELP     "PST mode."
           "|de|Einstellung PST-Modus.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 310 (cmd xx/xx)
*/
VARIABLE pst_operating_mode
{
  #ifdef LABEL_DE_EN
  LABEL    "PST operating mode" "|de|Betriebsmodus PST";
  #else
  LABEL    "PST operating mode";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "PST Man"  "|de|PST Man"  },
    { 1, "PST Auto" "|de|PST Auto" }
  #else
    { 0, "PST Man"  },
    { 1, "PST Auto" }
  #endif
  }

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Switches between manual (PST Man) and time controlled "
           "(PST Auto) test mode."
           "|de|Schaltet zwischen manueller (PST Man) und zeitgesteuerter "
           "(PST Auto) Testdurchfhrung um.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned long 557
*/
VARIABLE pst_elapsed_hours_meter_next_PST_test
{
  #ifdef LABEL_DE_EN
  LABEL    "Time until the next automatic PST test takes place"
           "|de|Zeit bis zum nchsten PST Autotest";
  #else
  LABEL    "Time until the next automatic PST test takes place";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Time left until the next PST test is conducted."
           "|de|Verbleibende Zeit bis zur nchsten Durchfhrung des PST-Test.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned long 466
*/
VARIABLE pst_elapsed_hours_meter_auto_test_time
{
  #ifdef LABEL_DE_EN
  LABEL    "Auto test time" "|de|Autotestzeit";
  #else
  LABEL    "Auto test time";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Desired time until the PST test is repeated."
           "|de|Die gewnschte Zeit fr die Wiederholung eines PST-Test.";
#endif
}




/* ----------------------------------------- */
/* Einstellungen                             */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* float 376 (cmd xx/xx)
*/
VARIABLE pst_step_tolerance_limit
{
  #ifdef LABEL_DE_EN
  LABEL    "Step tolerance limit" "|de|Sprungtoleranzgrenze";
  #else
  LABEL    "Step tolerance limit";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
      DEFAULT_VALUE   2.0;
      MIN_VALUE  0.1;
      MAX_VALUE 10.0;
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Step tolerance limit."
           "|de|Sprungtoleranzgrenze.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 313 (cmd xx/xx)
*/
VARIABLE pst_activation_ramp_function
{
  #ifdef LABEL_DE_EN
  LABEL    "Activation of the ramp function" "|de|Aktivierung Rampenfunktion";
  #else
  LABEL    "Activation of the ramp function";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Off" "|de|Aus" },
    { 1, "On"  "|de|Ein" }
  #else
    { 0, "Off" },
    { 1, "On"  }
  #endif
  }

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Activates or deactivates the ramp function.."
           "|de|Schaltet die Rampenfunktion ein oder aus.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer 193 (TV ID 90193 Diagnose xml)
*/
VARIABLE pst_ramp_time_rising
{
  #ifdef LABEL_DE_EN
  LABEL    "Ramp time (rising)" "|de|Rampenzeit (steigend)";
  #else
  LABEL    "Ramp time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE   0;
      MIN_VALUE       0;
      MAX_VALUE    1000;
  }
  CONSTANT_UNIT "s";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Ramp time (for 0% - 100%, increasing) to perform the ramp function. "
           "The initialization process provides a suitable value. "
           "The ramp time should not fall below this value."
           "|de|Rampenzeit (fr 0% - 100%, steigend) der Rampenfunktion. "
           "Die Initialisierung gibt einen sinnvollen Wert vor, "
           "der nach Mglichkeit nicht unterschritten werden sollte.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer 194 (TV ID 90194 Diagnose xml)
*/
VARIABLE pst_ramp_time_falling
{
  #ifdef LABEL_DE_EN
  LABEL    "Ramp time (falling)" "|de|Rampenzeit (fallend)";
  #else
  LABEL    "Ramp time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE   0;
      MIN_VALUE       0;
      MAX_VALUE    1000;
  }
  CONSTANT_UNIT "s";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Ramp time (for 100% - 0%, decreasing) to perform the ramp function. "
           "The initialization process provides a suitable value. "
           "The ramp time should not fall below this value."
           "|de|Rampenzeit (fr 100% - 0%, fallend) der Rampenfunktion. "
           "Die Initialisierung gibt einen sinnvollen Wert vor, "
           "der nach Mglichkeit nicht unterschritten werden sollte.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer 245
*/
VARIABLE pst_settling_time_before_start
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time before test start" "|de|Beruhigungszeit vor Testbeginn";
  #else
  LABEL    "Settling time before test start";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DISPLAY_FORMAT "2.0f";
      DEFAULT_VALUE  100;
      MIN_VALUE       10;
      MAX_VALUE     2400;
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Settling time before the test starts so the step start value "
           "is reached safely."
           "|de|Wartezeit vor Testbeginn, damit der Sprungstartwert sicher erreicht "
           "werden kann.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer = 1.03 * (Voraussichtliche Testdauer / 100)
*/
VARIABLE pst_rec_scan_rate
{
  #ifdef LABEL_DE_EN
  LABEL    "Min. recommended scan rate" "|de|Empfohlene Mindest-Abtastzeit";
  #else
  LABEL    "Min. recommended scan rate";
  #endif

  CLASS    LOCAL;
//  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "s";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "When the recommended scan rate is used, the complete step response "
           "is illustrated in the diagram."
           "|de|Durch die Benutzung der empfohlenen Abtastzeit steht die komplette "
           "Sprungantwort im Diagramm zur Verfgung.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer 191
*/
VARIABLE pst_max_test_duration
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. test duration" "|de|Max. Testdauer Anwendervorgabe";
  #else
  LABEL    "Max. test duration";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DISPLAY_FORMAT "2.0f";
      DEFAULT_VALUE   1200;
      MIN_VALUE        300;
      MAX_VALUE      30000;
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Maximum test period after which the test will be aborted in any case."
           "|de|Max. Testdauer, nachdem der Test auf jeden Fall abgebrochen wird.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 319 (cmd xx/xx)
*/
VARIABLE pst_fault_alarm_output
{
  #ifdef LABEL_DE_EN
  LABEL    "Fault alarm output" "|de|Strmeldeausgang";
  #else
  LABEL    "Fault alarm output";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Normal error message"              "|de|Normale Fehlermeldung" },
    { 1, "PST status"                        "|de|PST Status" }
    { 2, "Normal error message + PST status" "|de|Normale Fehlermeldung + PST Status" }
  #else
    { 0, "Normal error message"  },
    { 1, "PST status" }
    { 2, "Normal error message + PST status" }
  #endif
  }

  VALIDITY_ONLY_3730_3_143_PST

#ifdef HELP_EP_DE_EN
  HELP     "Error is issued to the hardware output."
           "|de|Fehlerausgabe auf den Hardwareausgang.";
#endif
}



/* ----------------------------------------- */
/* Abbruchbedingungen                        */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned char 323 (cmd xx/xx)
*/
VARIABLE pst_activation_x_control
{
  #ifdef LABEL_DE_EN
  LABEL    "Activation x control" "|de|Aktivierung x-berwachung";
  #else
  LABEL    "Activation x control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Off" "|de|Aus" },
    { 1, "On"  "|de|Ein" }
  #else
    { 0, "Off" },
    { 1, "On"  }
  #endif
  }

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Activates or deactivates the x control."
           "|de|Schaltet die x-berwachung ein oder aus.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float 1564
*/
VARIABLE pst_x_control_value
{
  #ifdef LABEL_DE_EN
  LABEL    "x control value" "|de|x-berwachungswert";
  #else
  LABEL    "x control value";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE     0.0;
      MIN_VALUE       -10.0;
      MAX_VALUE       110.0;
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "The test will be aborted as soon as the measured valve position "
           "value falls below the specified value of x."
           "|de|Der Test wird abgebrochen, sobald dieser Wert der Ventilstellung "
           "unterschritten wird.";
#endif
}


/* ------------------------------------------------------------------------ */
/* unsigned char 322 (cmd xx/xx)
*/
VARIABLE pst_activation_y_control
{
  #ifdef LABEL_DE_EN
  LABEL    "Activation y control" "|de|Aktivierung y-berwachung";
  #else
  LABEL    "Activation y control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Off" "|de|Aus" },
    { 1, "On"  "|de|Ein" }
  #else
    { 0, "Off" },
    { 1, "On"  }
  #endif
  }

  VALIDITY_ONLY_DEV_REV_4

#ifdef HELP_EP_DE_EN
  HELP     "Activates or deactivates the y control."
           "|de|Schaltet die y-berwachung ein oder aus.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float 1563
*/
VARIABLE pst_y_control_value
{
  #ifdef LABEL_DE_EN
  LABEL    "y control value" "|de|y-berwachungswert";
  #else
  LABEL    "y control value";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "3.0f";
      DEFAULT_VALUE     0.0;
      MIN_VALUE         0.0;
      MAX_VALUE      9999.0;
  }
  CONSTANT_UNIT "1/s";

  VALIDITY_ONLY_DEV_REV_4

#ifdef HELP_EP_DE_EN
  HELP     "The test will be aborted as soon as the control signal "
           "value falls below the specified monitoring value of y."
           "|de|Der Test wird abgebrochen, sobald dieser Wert des Stellsignals "
           "unterschritten wird.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 314 (cmd xx/xx)
*/
VARIABLE pst_activation_tol_band_control
{
  #ifdef LABEL_DE_EN
  LABEL    "Activation tolerance band control" "|de|Aktivierung PST Toleranzband-berwachung";
  #else
  LABEL    "Activation tolerance band control";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Off" "|de|Aus" },
    { 1, "On"  "|de|Ein" }
  #else
    { 0, "Off" },
    { 1, "On"  }
  #endif
  }

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Activates or deactivates the control of the tolerance band."
           "|de|Schaltet die PST Toleranzband-berwachung ein oder aus.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float 366
*/
VARIABLE pst_tolerance_band
{
  #ifdef LABEL_DE_EN
  LABEL    "PST Tolerance band" "|de|PST Toleranzband";
  #else
  LABEL    "PST Tolerance band";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "3.1f";
      DEFAULT_VALUE     5.0;
      MIN_VALUE         0.1;
      MAX_VALUE       100.0;
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "The test will be aborted as soon as the deviation of the valve position "
           "exceeds this value."
           "|de|Der Test wird abgebrochen, sobald die Abweichung der Ventilstellung "
           "diesen Wert berschreitet.";
#endif
}






/* ----------------------------------------- */
/* Anzeige                                   */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* float 1566
*/
VARIABLE pst_min_value_y_control
{
  #ifdef LABEL_DE_EN
  LABEL    "Minimum value y control" "|de|Minimalwert y-berwachung";
  #else
  LABEL    "Minimum value y control";
  #endif

  CLASS    DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "4.0f";
  }
  CONSTANT_UNIT "1/s";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Displays the minimum y value obtained from the last PST test. "
           "This parameter can be used to determine the limit for the y control value."
           "|de|Anzeige des minimalen y-Wertes (gemittelt) aus dem zuletzt "
           "durchgefhrten PST Test. Dieser Parameter kann zur Grenzbestimmung "
           "fr den y-berwachungswert eingesetzt werden.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned char 217 (2. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status_pst_test
{
  #ifdef LABEL_DE_EN
  LABEL    "Status PST test" "|de|Status PST Test";
  #else
  LABEL    "Status PST test";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "Not successful" "|de|Nicht erfolgreich" },
    { 1, "Successful"     "|de|Erfolgreich" }
  #else
    { 0, "Not successful" },
    { 1, "Successful" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "Shows the status of the last test. A more detailed analysis of the test "
           "can be found under 'Measurement data evaluation'."
           "|de|Anzeige des Status aus dem letzten Test. Eine genauere Bewertung "
           "vom Test kann man unter 'Messdatenauswertung' finden.";
#endif
}*/


/* ------------------------------------------------------------------------ */
/* unsigned int 216
*/
VARIABLE pst_number_of_tests
{
  #ifdef LABEL_DE_EN
  LABEL    "Number of tests" "|de|Testanzahl";
  #else
  LABEL    "Number of tests";
  #endif

  CLASS    DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Number of performed PST tests."
           "|de|Anzahl der durchgefhrten PST Tests.";
#endif
}




/* ------------------------------------------------------------- */
/* Gespeicherte Auswertungen:                                    */
/* ------------------------------------------------------------- */

/* ----------------------------------------- */
/* Aktueller Test                            */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned long 197
*/
VARIABLE pst_elapsed_hours_meter_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Time stamp for this test" "|de|Zeitstempel fr diesen Test";
  #else
  LABEL    "Time stamp for this test";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "The stored elapsed hours counter for this test."
           "|de|Der gespeicherte Betriebsstundenzhler zu diesem Test.";
#endif
}


/* Rest weiter oben bei Sprungantwort definiert */



/* ----------------------------------------- */
/* Test Status (aktueller Test)              */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (bit enumerated)
*/
VARIABLE pst_test_status_0
{
  #ifdef LABEL_DE_EN
  LABEL "Test status (current test)" "|de|Teststatus (aktueller Test)";
  #else
  LABEL "Test status (current test)";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE BIT_ENUMERATED (2)
  {
	  { 0x0001, "No test avail./Test man. canceled"
   	            "|de|Kein Test vorhanden",                DATA },
	  { 0x0002, "Test OK"
   	            "|de|Test OK",                            DATA },
	  { 0x0004, "x cancellation"
   	            "|de|x-Abbruch",                          DATA },
	  { 0x0008, "y cancellation"
   	            "|de|y-Abbruch",                          DATA },
	  { 0x0010, "Tolerance band exceeded"
   	            "|de|Toleranzband berschritten",         DATA },
	  { 0x0020, "Max. test time exceeded"
   	            "|de|Max. Testzeit berschritten",        DATA },
	  { 0x0040, "Test start in wrong operating mode"
   	            "|de|Test man. abgebrochen",              DATA },
	  { 0x0080, "Measured data storage out of memory"
   	            "|de|Messdatenspeicher voll",             DATA },
	  { 0x0100, "Aborted by solenoid valve"
   	            "|de|Magnetventil Abbruch",               DATA },
	  { 0x0200, "Supply pressure/friction"
   	            "|de|Zuluftdruck/Reibung",                DATA }
  }

  VALIDITY_373X_3_143_144_PST

  #ifdef HELP_DE_EN
  HELP "Test status of the current test."
       "|de|Teststatus vom aktuell durchgefhrten Test.";
  #endif

#ifdef _V510_
    STYLE "MULTILINE 12 5"; /* 5 Zeilen hoch */
#endif
}


/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (1. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__no_test_0
{
  #ifdef LABEL_DE_EN
  LABEL    "No test avail./Test man. canceled" "|de|Kein Test vorhanden";
  #else
  LABEL    "No test avail./Test man. canceled";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "No test available or the test has been aborted manually."
           "|de|Kein Test vorhanden oder der Test wurde man. abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (3. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__x_cancel_0
{
  #ifdef LABEL_DE_EN
  LABEL    "x cancellation" "|de|x-Abbruch";
  #else
  LABEL    "x cancellation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has been aborted by the 'x cancellation' function."
           "|de|Dieser Test wurde durch die Funktion x-Abbruch beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (4. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__y_cancel_0
{
  #ifdef LABEL_DE_EN
  LABEL    "y cancellation" "|de|y-Abbruch";
  #else
  LABEL    "y cancellation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has been aborted by the 'y cancellation' function."
           "|de|Dieser Test wurde durch die Funktion y-Abbruch beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (5. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__tol_band_exceed_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Tolerance band exceeded" "|de|Toleranzband berschritten";
  #else
  LABEL    "Tolerance band exceeded";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "x values occurred outside the tolerance band."
           "|de|Es sind x-Werte ausserhalb des Toleranzbandes aufgetreten.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (6. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__max_test_time_exceed_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. test time exceeded" "|de|Max. Testzeit berschritten";
  #else
  LABEL    "Max. test time exceeded";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test was not completed within the given maximum test time "
           "and has been aborted for this reason."
           "|de|Dieser Test wurde nach der max. Testzeitvorgabe nicht abgeschlossen "
           "und wurde beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (7. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__wrong_op_mode_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Test start in wrong operating mode" "|de|Test man. abgebrochen";
  #else
  LABEL    "Test start in wrong operating mode";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has not been started in the correct operating mode (PST Man)."
           "|de|Dieser Test wurde durch den Anwender abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (8. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__data_memory_full_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Measured data storage out of memory" "|de|Messdatenspeicher voll";
  #else
  LABEL    "Measured data storage out of memory";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The maximum storage capacity of the measured data storage has been achieved."
           "|de|Das max. Speichervolumen des Messdatenspeichers wurde erreicht.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (9. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__solenoid_valve_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Aborted by solenoid valve" "|de|Magnetventil Abbruch";
  #else
  LABEL    "Aborted by solenoid valve";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The test has been aborted by the solenoid valve."
           "|de|Der Test wurde durch das Magnetventil abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 217 (10. bit) (cmd xx/xx)
*/
/* mit pst_test_status_0 realisiert
VARIABLE pst_status__supply_pressure_friction_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Supply pressure/friction" "|de|Zuluftdruck/Reibung";
  #else
  LABEL    "Supply pressure/friction";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The test has been aborted due to insufficient supply pressure "
           "or excessive friction."
           "|de|Der Test wurde durch zu wenig Zuluftdruck oder eine zu hohe "
           "Reibung abgebrochen.";
#endif
}*/




/* ----------------------------------------- */
/* 1. gespeicherte Auswertung (letzter Test) */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned long 493
*/
VARIABLE pst_elapsed_hours_meter_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Time stamp for this test" "|de|Zeitstempel fr diesen Test";
  #else
  LABEL    "Time stamp for this test";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "The stored elapsed hours counter for this test."
           "|de|Der gespeicherte Betriebsstundenzhler zu diesem Test.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float_1542
*/
VARIABLE overshoot_rising_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Overshoot (rising)" "|de|berschwinger (steigend)";
  #else
  LABEL    "Overshoot (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: overshoot - rising step."
           "|de|Messauswertung: berschwinger - Sprung steigend.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float_1543
*/
VARIABLE overshoot_falling_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Overshoot (falling)" "|de|berschwinger (fallend)";
  #else
  LABEL    "Overshoot (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: overshoot - falling step."
           "|de|Messauswertung: berschwinger - Sprung fallend.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_494
*/
VARIABLE dead_time_rising_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Dead time (rising)" "|de|Totzeit (steigend)";
  #else
  LABEL    "Dead time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: dead band - rising step."
           "|de|Messauswertung: Totzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_499
*/
VARIABLE dead_time_falling_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Dead time (falling)" "|de|Totzeit (fallend)";
  #else
  LABEL    "Dead time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: dead band - falling step."
           "|de|Messauswertung: Totzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_495
*/
VARIABLE time_63_rising_1
{
  #ifdef LABEL_DE_EN
  LABEL    "T63 (rising)" "|de|T63 (steigend)";
  #else
  LABEL    "T63 (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_500
*/
VARIABLE time_63_falling_1
{
  #ifdef LABEL_DE_EN
  LABEL    "T63 (falling)" "|de|T63 (fallend)";
  #else
  LABEL    "T63 (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_496
*/
VARIABLE time_98_rising_1
{
  #ifdef LABEL_DE_EN
  LABEL    "T98 (rising)" "|de|T98 (steigend)";
  #else
  LABEL    "T98 (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_501
*/
VARIABLE time_98_falling_1
{
  #ifdef LABEL_DE_EN
  LABEL    "T98 (falling)" "|de|T98 (fallend)";
  #else
  LABEL    "T98 (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_497
*/
VARIABLE rise_time_rising_step_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Rise time (rising)" "|de|Anregelzeit (steigend)";
  #else
  LABEL    "Rise time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: rise time - rising step."
           "|de|Messauswertung: Anregelzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_502
*/
VARIABLE rise_time_falling_step_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Rise time (falling)" "|de|Anregelzeit (fallend)";
  #else
  LABEL    "Rise time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: rise time - falling step."
           "|de|Messauswertung: Anregelzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_498
*/
VARIABLE settling_time_rising_step_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time (rising)" "|de|Ausregelzeit (steigend)";
  #else
  LABEL    "Settling time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: settling time - rising step."
           "|de|Messauswertung: Ausregelzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_503
*/
VARIABLE settling_time_falling_step_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time (falling)" "|de|Ausregelzeit (fallend)";
  #else
  LABEL    "Settling time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: settling time - falling step."
           "|de|Messauswertung: Ausregelzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}


/* ----------------------------------------- */
/* Test Status (letzter Test)                */
/* ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (bit enumerated)
*/
VARIABLE pst_test_status_1
{
  #ifdef LABEL_DE_EN
  LABEL "Test status (last test)" "|de|Teststatus (letzter Test)";
  #else
  LABEL "Test status (last test)";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE BIT_ENUMERATED (2)
  {
	  { 0x0001, "No test avail./Test man. canceled"
   	            "|de|Kein Test vorhanden",                DATA },
	  { 0x0002, "Test OK"
   	            "|de|Test OK",                            DATA },
	  { 0x0004, "x cancellation"
   	            "|de|x-Abbruch",                          DATA },
	  { 0x0008, "y cancellation"
   	            "|de|y-Abbruch",                          DATA },
	  { 0x0010, "Tolerance band exceeded"
   	            "|de|Toleranzband berschritten",         DATA },
	  { 0x0020, "Max. test time exceeded"
   	            "|de|Max. Testzeit berschritten",        DATA },
	  { 0x0040, "Test start in wrong operating mode"
   	            "|de|Test man. abgebrochen",              DATA },
	  { 0x0080, "Measured data storage out of memory"
   	            "|de|Messdatenspeicher voll",             DATA },
	  { 0x0100, "Aborted by solenoid valve"
   	            "|de|Magnetventil Abbruch",               DATA },
	  { 0x0200, "Supply pressure/friction"
   	            "|de|Zuluftdruck/Reibung",                DATA }
  }

  VALIDITY_373X_3_143_144_PST

  #ifdef HELP_DE_EN
  HELP "Test status of the last test."
       "|de|Teststatus vom letzten Test.";
  #endif

#ifdef _V510_
    STYLE "MULTILINE 12 5"; /* 5 Zeilen hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (1. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__no_test_1
{
  #ifdef LABEL_DE_EN
  LABEL    "No test available/Test man. canceled" "|de|Kein Test vorhanden";
  #else
  LABEL    "No test available/Test man. canceled";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "No test available or the test has been aborted manually."
           "|de|Kein Test vorhanden oder der Test wurde man. abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (3. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__x_cancel_1
{
  #ifdef LABEL_DE_EN
  LABEL    "x cancellation" "|de|x-Abbruch";
  #else
  LABEL    "x cancellation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has been aborted by the 'x cancellation' function."
           "|de|Dieser Test wurde durch die Funktion x-Abbruch beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (4. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__y_cancel_1
{
  #ifdef LABEL_DE_EN
  LABEL    "y cancellation" "|de|y-Abbruch";
  #else
  LABEL    "y cancellation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has been aborted by the 'y cancellation' function."
           "|de|Dieser Test wurde durch die Funktion y-Abbruch beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (5. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__tol_band_exceed_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Tolerance band exceeded" "|de|Toleranzband berschritten";
  #else
  LABEL    "Tolerance band exceeded";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "x values occurred outside the tolerance band."
           "|de|Es sind x-Werte ausserhalb des Toleranzbandes aufgetreten.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (6. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__max_test_time_exceed_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. test time exceeded" "|de|Max. Testzeit berschritten";
  #else
  LABEL    "Max. test time exceeded";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test was not completed within the given maximum test time "
           "and has been aborted for this reason."
           "|de|Dieser Test wurde nach der max. Testzeitvorgabe nicht abgeschlossen "
           "und wurde beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (7. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__wrong_op_mode_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Test start in wrong operating mode" "|de|Test man. abgebrochen";
  #else
  LABEL    "Test start in wrong operating mode";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has not been started in the correct operating mode (PST Man)."
           "|de|Dieser Test wurde durch den Anwender abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (8. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__data_memory_full_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Measured data storage out of memory" "|de|Messdatenspeicher voll";
  #else
  LABEL    "Measured data storage out of memory";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The maximum storage capacity of the measured data storage has been achieved."
           "|de|Das max. Speichervolumen des Messdatenspeichers wurde erreicht.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (9. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__solenoid_valve_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Aborted by solenoid valve" "|de|Magnetventil Abbruch";
  #else
  LABEL    "Aborted by solenoid valve";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The test has been aborted by the solenoid valve."
           "|de|Der Test wurde durch das Magnetventil abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 218 (10. bit) (cmd xx/xx)
*/
/* mit pst_test_status_1 realisiert
VARIABLE pst_status__supply_pressure_friction_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Supply pressure/friction" "|de|Zuluftdruck/Reibung";
  #else
  LABEL    "Supply pressure/friction";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The test has been aborted due to insufficient supply pressure "
           "or excessive friction."
           "|de|Der Test wurde durch zu wenig Zuluftdruck oder eine zu hohe "
           "Reibung abgebrochen.";
#endif
}*/



/* -------------------------------------------- */
/* 2. gespeicherte Auswertung (vorletzter Test) */
/* -------------------------------------------- */

/* ------------------------------------------------------------------------ */
/* unsigned long 504
*/
VARIABLE pst_elapsed_hours_meter_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Time stamp for this test" "|de|Zeitstempel fr diesen Test";
  #else
  LABEL    "Time stamp for this test";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  SCALING_FACTOR  0.000027777778; /* 1/36000 */

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "The stored elapsed hours counter for this test."
           "|de|Der gespeicherte Betriebsstundenzhler zu diesem Test.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float_1548
*/
VARIABLE overshoot_rising_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Overshoot (rising)" "|de|berschwinger (steigend)";
  #else
  LABEL    "Overshoot (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: overshoot - rising step."
           "|de|Messauswertung: berschwinger - Sprung steigend.";
#endif
}

/* ------------------------------------------------------------------------ */
/* float_1549
*/
VARIABLE overshoot_falling_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Overshoot (falling)" "|de|berschwinger (fallend)";
  #else
  LABEL    "Overshoot (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: overshoot - falling step."
           "|de|Messauswertung: berschwinger - Sprung fallend.";
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_505
*/
VARIABLE dead_time_rising_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Dead time (rising)" "|de|Totzeit (steigend)";
  #else
  LABEL    "Dead time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: dead band - rising step."
           "|de|Messauswertung: Totzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_510
*/
VARIABLE dead_time_falling_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Dead time (falling)" "|de|Totzeit (fallend)";
  #else
  LABEL    "Dead time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: dead band - falling step."
           "|de|Messauswertung: Totzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_506
*/
VARIABLE time_63_rising_2
{
  #ifdef LABEL_DE_EN
  LABEL    "T63 (rising)" "|de|T63 (steigend)";
  #else
  LABEL    "T63 (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_511
*/
VARIABLE time_63_falling_2
{
  #ifdef LABEL_DE_EN
  LABEL    "T63 (falling)" "|de|T63 (fallend)";
  #else
  LABEL    "T63 (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_507
*/
VARIABLE time_98_rising_2
{
  #ifdef LABEL_DE_EN
  LABEL    "T98 (rising)" "|de|T98 (steigend)";
  #else
  LABEL    "T98 (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_512
*/
VARIABLE time_98_falling_2
{
  #ifdef LABEL_DE_EN
  LABEL    "T98 (falling)" "|de|T98 (fallend)";
  #else
  LABEL    "T98 (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_508
*/
VARIABLE rise_time_rising_step_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Rise time (rising)" "|de|Anregelzeit (steigend)";
  #else
  LABEL    "Rise time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: rise time - rising step."
           "|de|Messauswertung: Anregelzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_513
*/
VARIABLE rise_time_falling_step_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Rise time (falling)" "|de|Anregelzeit (fallend)";
  #else
  LABEL    "Rise time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: rise time - falling step."
           "|de|Messauswertung: Anregelzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_509
*/
VARIABLE settling_time_rising_step_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time (rising)" "|de|Ausregelzeit (steigend)";
  #else
  LABEL    "Settling time (rising)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: settling time - rising step."
           "|de|Messauswertung: Ausregelzeit - Sprung steigend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}

/* ------------------------------------------------------------------------ */
/* unsigned_long_514
*/
VARIABLE settling_time_falling_step_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Settling time (falling)" "|de|Ausregelzeit (fallend)";
  #else
  LABEL    "Settling time (falling)";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  CONSTANT_UNIT "ms";

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Measurement analysis: settling time - falling step."
           "|de|Messauswertung: Ausregelzeit - Sprung fallend.";
#endif

  POST_READ_ACTIONS
  {
    convert_mal_100_long /* Methode */
  }
}


/* ------------------------------------------ */
/* Test Status (vorletzter Test)              */
/* ------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (bit enumerated)
*/
VARIABLE pst_test_status_2
{
  #ifdef LABEL_DE_EN
  LABEL "Test status (last test but one)" "|de|Teststatus (vorletzter Test)";
  #else
  LABEL "Test status (last test but one)";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE BIT_ENUMERATED (2)
  {
	  { 0x0001, "No test avail./Test man. canceled"
   	            "|de|Kein Test vorhanden",                DATA },
	  { 0x0002, "Test OK"
   	            "|de|Test OK",                            DATA },
	  { 0x0004, "x cancellation"
   	            "|de|x-Abbruch",                          DATA },
	  { 0x0008, "y cancellation"
   	            "|de|y-Abbruch",                          DATA },
	  { 0x0010, "Tolerance band exceeded"
   	            "|de|Toleranzband berschritten",         DATA },
	  { 0x0020, "Max. test time exceeded"
   	            "|de|Max. Testzeit berschritten",        DATA },
	  { 0x0040, "Test start in wrong operating mode"
   	            "|de|Test man. abgebrochen",              DATA },
	  { 0x0080, "Measured data storage out of memory"
   	            "|de|Messdatenspeicher voll",             DATA },
	  { 0x0100, "Aborted by solenoid valve"
   	            "|de|Magnetventil Abbruch",               DATA },
	  { 0x0200, "Supply pressure/friction"
   	            "|de|Zuluftdruck/Reibung",                DATA }
  }

  VALIDITY_373X_3_143_144_PST

  #ifdef HELP_DE_EN
  HELP "Test status of the last test but one."
       "|de|Teststatus vom vorletzten Test.";
  #endif

#ifdef _V510_
    STYLE "MULTILINE 12 5"; /* 5 Zeilen hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (1. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__no_test_2
{
  #ifdef LABEL_DE_EN
  LABEL    "No test available/Test man. canceled" "|de|Kein Test vorhanden";
  #else
  LABEL    "No test available/Test man. canceled";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "No test available or the test has been aborted manually."
           "|de|Kein Test vorhanden oder der Test wurde man. abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (3. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__x_cancel_2
{
  #ifdef LABEL_DE_EN
  LABEL    "x cancellation" "|de|x-Abbruch";
  #else
  LABEL    "x cancellation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has been aborted by the 'x cancellation' function."
           "|de|Dieser Test wurde durch die Funktion x-Abbruch beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (4. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__y_cancel_2
{
  #ifdef LABEL_DE_EN
  LABEL    "y cancellation" "|de|y-Abbruch";
  #else
  LABEL    "y cancellation";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has been aborted by the 'y cancellation' function."
           "|de|Dieser Test wurde durch die Funktion y-Abbruch beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (5. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__tol_band_exceed_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Tolerance band exceeded" "|de|Toleranzband berschritten";
  #else
  LABEL    "Tolerance band exceeded";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "x values occurred outside the tolerance band."
           "|de|Es sind x-Werte ausserhalb des Toleranzbandes aufgetreten.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (6. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__max_test_time_exceed_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Max. test time exceeded" "|de|Max. Testzeit berschritten";
  #else
  LABEL    "Max. test time exceeded";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test was not completed within the given maximum test time "
           "and has been aborted for this reason."
           "|de|Dieser Test wurde nach der max. Testzeitvorgabe nicht abgeschlossen "
           "und wurde beendet.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (7. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__wrong_op_mode_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Test start in wrong operating mode" "|de|Test man. abgebrochen";
  #else
  LABEL    "Test start in wrong operating mode";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "This test has not been started in the correct operating mode (PST Man)."
           "|de|Dieser Test wurde durch den Anwender abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (8. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__data_memory_full_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Measured data storage out of memory" "|de|Messdatenspeicher voll";
  #else
  LABEL    "Measured data storage out of memory";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The maximum storage capacity of the measured data storage has been achieved."
           "|de|Das max. Speichervolumen des Messdatenspeichers wurde erreicht.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (9. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__solenoid_valve_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Aborted by solenoid valve" "|de|Magnetventil Abbruch";
  #else
  LABEL    "Aborted by solenoid valve";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The test has been aborted by the solenoid valve."
           "|de|Der Test wurde durch das Magnetventil abgebrochen.";
#endif
}*/

/* ------------------------------------------------------------------------ */
/* unsigned integer 219 (10. bit) (cmd xx/xx)
*/
/* mit pst_test_status_2 realisiert
VARIABLE pst_status__supply_pressure_friction_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Supply pressure/friction" "|de|Zuluftdruck/Reibung";
  #else
  LABEL    "Supply pressure/friction";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"        "|de|Keine Meldung" },
    { 1, "Maintenance alarm" "|de|Ausfall"       }
  #else
    { 0, "No message"        },
    { 1, "Maintenance alarm" }
  #endif
  }

  VALIDITY_ONLY_EXPERT_PLUS

#ifdef HELP_EP_DE_EN
  HELP     "The test has been aborted due to insufficient supply pressure "
           "or excessive friction."
           "|de|Der Test wurde durch zu wenig Zuluftdruck oder eine zu hohe "
           "Reibung abgebrochen.";
#endif
}*/


/* ------------------------------------------------------------------------ */
/* unsigned char ??; WRITE: cmd 170/3 ??? */
VARIABLE reset_pst
{
  #ifdef LABEL_DE_EN
  LABEL    "Reset 'PST'" "|de|Rcksetzen 'PST'";
  #else
  LABEL    "Reset 'PST'";
  #endif

  CLASS    DEVICE;
  HANDLING WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
     { 0, "No"  "|de|Nein" },
     { 1, "Yes" "|de|Ja"   }
  #else
     { 0, "No"  },
     { 1, "Yes" }
  #endif
  }

  VALIDITY_373X_3_143_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "All PST parameters will be reset to default values and "
           "all measured data will be deleted."
           "|de|Smtliche PST-Parameter werden auf Defaultwerte gesetzt "
           "und alle Messdaten werden gelscht.";
#endif
}



/* ------------------------------------------------------------------------ */
/* 4.2.1 PST Parameter (weitere fr FW 1.44)                                */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/* unsigned char ???? (Code 49 - A8)
*/
VARIABLE pst_activation_delta_y_monitoring
{
  #ifdef LABEL_DE_EN
  LABEL    "Activation delta y-monitoring" "|de|Aktivierung delta y-berwachung";
  #else
  LABEL    "Activation delta y-monitoring";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Off" "|de|Aus" },
    { 1, "On"  "|de|Ein" }
  #else
    { 0, "Off" },
    { 1, "On"  }
  #endif
  }

  VALIDITY_ONLY_3731_3_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Switches the delta y-monitoring value on or off. "
           "It only works if a PST reference test was performed successful."
           "|de|Schaltet die delta y-berwachung ein oder aus. "
           "Funktioniert erst wenn ein PST Referenzlauf erfolgreich ausgefhrt wurde.";
#endif
}



/* ------------------------------------------------------------------------ */
/* unsigned integer ??? (Code 49 - A9)
*/
VARIABLE pst_value_delta_y_monitoring
{
  #ifdef LABEL_DE_EN
  LABEL    "delta y-monitoring value" "|de|delta y-berwachungswert";
  #else
  LABEL    "delta y-monitoring value";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE   0;
      MIN_VALUE       0;
      MAX_VALUE    1000;
  }
  CONSTANT_UNIT "%";

  VALIDITY_ONLY_3731_3_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "The test will be aborted when the value of the drive signal is "
           "lower than this value. This parameter  relates to the range 0...10000 1/s."
           "|de|Der Test wird abgebrochen, sobald dieser Wert des Stellsignals "
           "unterschritten wird. Dieser Prozentwert bezieht sich auf den "
           "Bereich von 0...10000 1/s.";
#endif
}



/* ------------------------------------------------------------------------ */
/* unsigned integer ??? (Code 49 - A7)
*/
VARIABLE pst_delta_y_monitoring_reference_value
{
  #ifdef LABEL_DE_EN
  LABEL    "delta y-monitoring reference value" "|de|delta y-berwachung Referenzwert";
  #else
  LABEL    "delta y-monitoring reference value";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "4.0f";
  }
  CONSTANT_UNIT "1/s";

  VALIDITY_ONLY_3731_3_144_PST

#ifdef HELP_EP_DE_EN
  HELP     "Each modification of the level-change values or of the ramp times "
           "will cause the reference value to be redetermined during the next test."
           "|de|Jede nderung der Sprungwerte oder Rampenzeiten bewirkt "
           "eine neue Aufnahme des Referenzwertes beim nchsten Test.";
#endif
}


/* ------------------------------------------------------------------------ */
/* float ???
*/
VARIABLE pst_min_value_y_control_0
{
  #ifdef LABEL_DE_EN
  LABEL    "Minimum value y control" "|de|Minimalwert y-berwachung";
  #else
  LABEL    "Minimum value y control";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "4.0f";
  }
  CONSTANT_UNIT "1/s";

  VALIDITY_ONLY_3731_3_144_PST

/* in TV noch keine Hilfe vorhanden */
}



/* ------------------------------------------------------------------------ */
/* float ???
*/
VARIABLE pst_min_value_y_control_1
{
  #ifdef LABEL_DE_EN
  LABEL    "Minimum value y control" "|de|Minimalwert y-berwachung";
  #else
  LABEL    "Minimum value y control";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "4.0f";
  }
  CONSTANT_UNIT "1/s";

  VALIDITY_ONLY_3731_3_144_PST

/* in TV noch keine Hilfe vorhanden */
}



/* ------------------------------------------------------------------------ */
/* float ???
*/
VARIABLE pst_min_value_y_control_2
{
  #ifdef LABEL_DE_EN
  LABEL    "Minimum value y control" "|de|Minimalwert y-berwachung";
  #else
  LABEL    "Minimum value y control";
  #endif

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   "4.0f";
  }
  CONSTANT_UNIT "1/s";

  VALIDITY_ONLY_3731_3_144_PST

/* in TV noch keine Hilfe vorhanden */
}



/* ----------- the end ---------------------------------------------------- */

