/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2005). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 373X-4           */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.01                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*            			Physical Block				                      */
/*  $Revision:   1.3  $                                         */
/*  $Date:   31 May 2005 $					                            */
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 31.05.2005 Jung/E7 Physical Block ausgelagert				        */
/* 13.07.2005 Ald/E7  erweitert						                      */
/* 28.04.2006 kmr/E82 erweitert						                      */
/* 30.10.2006 Jung/E82 Attribut purpose eingefuehrt             */
/* 03.04.2008 WTM/E82 Defaultwerte Statusklassifikation korr.   */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/

/******************************************************************************/
/*    Sammelstatus                                                            */
/******************************************************************************/
VARIABLE phys_condensed_state
{
  LABEL      "Condensed state" "|de|Sammelstatus";
  CLASS      DEVICE & DYNAMIC;
  HANDLING   READ;
  TYPE       ENUMERATED (1)
  {
    DEFAULT_VALUE   0;
    { 0,   "No message"           "|de|Keine Meldung"       },
    { 1,   "Maintenance required" "|de|Wartungsbedarf"      },
    { 2,   "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3,   "Maintenance alarm"    "|de|Ausfall"             },
    { 4,   "Out of spezification" "|de|Auerhalb der Spezifikation" },
    { 7,   "Function check"       "|de|Funktionskontrolle"  }
  }

  HELP     "Condensed state based on NAMUR recommendation NE 107."
           "|de|Komprimierter Sammelstatus gemss NAMUR Empfehlung NE 107.";
}



/******************************************************************************/
/*    Physical Block                                                          */
/******************************************************************************/
BLOCK physical_block
{
    TYPE    PHYSICAL;
    NUMBER  1;
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_reserve
{
    LABEL       [blk_reserved];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_object
{
    LABEL       [blk_block_object];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        {   1,  [blk_block_object_PHYSICAL] }
    }
    HANDLING    READ;
    HELP        [blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_parent_class
{
    LABEL       [blk_parent_class];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   2,  [phys_blk_parent_class_ACTUATOR]    }
    }
    HANDLING    READ;
    HELP        [phys_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_class
{
    LABEL       [blk_class];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        { 250,  [not_used]  }
    }
    HANDLING    READ;
    HELP        [phys_blk_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_dd_reference
{
    LABEL       [blk_dd_reference];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (4);
    HANDLING    READ;
    HELP        [blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_dd_rev
{
    LABEL       [blk_dd_rev];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER(2);
    HANDLING    READ;
    HELP        [blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_profile
{
    LABEL       [blk_profile];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        {   0x4001, [blk_profile_PA_COMPACT_A] },
        {   0x4002, [blk_profile_PA_COMPACT_B] },
        {   0x4081, [blk_profile_PA_SIMPLE_A]  },
        {   0x4082, [blk_profile_PA_SIMPLE_B]  }
    }
    HANDLING    READ;
    HELP        [blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_profile_rev
{
    LABEL       [blk_profile_rev];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        {  0x0301,    "3.01"   }
    }
    HANDLING    READ;
    HELP        [blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_execution_time
{
    LABEL       [blk_execution_time];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER(1);
    HANDLING    READ;
    HELP        [blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE blk_num_parameters
{
    LABEL       [ blk_num_parameters];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_num_parameters_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_index_view_1
{
    LABEL       [blk_index_view_1];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_num_view_lists
{
    LABEL       [blk_num_view_lists];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_num_view_lists_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_st_rev
{
    LABEL       [st_rev];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_tag_desc
{
/*    LABEL       [tag_desc];*/
    LABEL       "TAG (Physical block)" "|de|TAG (Physical Block)";
    CLASS       DEVICE;
    TYPE        ASCII (32);
    HANDLING    READ & WRITE;
    PRE_WRITE_ACTIONS
    {
        check_write_protection_before_write   /* Schreibschutzprfung fr Download */
    }
    HELP        [tag_desc_help];
#ifdef _V602_
    PURPOSE "Device.App.Ident.TAG";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_strategy
{
    LABEL       [strategy];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2)
    {
            DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
    HELP        [strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_alert_key
{
    LABEL       [alert_key];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
    HELP        [alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_target_mode
{
    LABEL       [target_mode];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        { 0x08, [mode_AUTO] }
        {	0x80, [mode_OUT_OF_SERVICE]	}
    }
    HANDLING    READ & WRITE;
    HELP        [target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actual_mode
{
    LABEL       [actual_mode];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        { 0x08, [mode_AUTO] }
        {	0x80, [mode_OUT_OF_SERVICE]	}
    }
    HANDLING    READ;
    HELP        [actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_permitted_mode
{
    LABEL       [permitted_mode];
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        { 0x08, [mode_AUTO] }
        {	0x80, [mode_OUT_OF_SERVICE]	}
    }
    HANDLING    READ;
    HELP        [permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_normal_mode
{
    LABEL       [normal_mode];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        { 0x08, [mode_AUTO] }
    }
    HANDLING    READ;
    HELP        [normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_current_state_alarm_sum
{
    LABEL       [current_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_unacknowledged_state_alarm_sum
{
    LABEL       [unacknowledged_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_unreported_state_alarm_sum
{
    LABEL       [unreported_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_disabled_state_alarm_sum
{
    LABEL       [disabled_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [disabled_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_software_rev
{
    LABEL       [phys_software_revision];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ;
    HELP        "Code 43. " + [phys_software_revision_help];
#ifdef _V602_
    PURPOSE "Device.Type.Ident.SwRevision";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_hardware_rev
{
    LABEL       [phys_hardware_revision];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ;
    HELP        [phys_hardware_revision_help];
#ifdef _V602_
    PURPOSE "Device.Type.Ident.HwRevision";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_man_id
{
    LABEL       [phys_device_man_id];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
       DEFAULT_VALUE    66;
      { 1,      [Acromag]                       },
      { 2,      [Allen_Bradley]                 },
      { 3,      [Ametek]                        },
      { 4,      [Analog_Devices]                },
      { 5,      [Bailey]                        },
      { 6,      [Beckman]                       },
      { 7,      [Bell_Microsensor]              },
      { 8,      [Bourns]                        },
      { 9,      [Bristol_Babcock]               },
      { 10,     [Brooks_Instrument]             },
      { 11,     [Chessell]                      },
      { 12,     [Combustion_Engineering]        },
      { 13,     [Daniel_Industries]             },
      { 14,     [Delta]                         },
      { 15,     [Dieterich_Standard]            },
      { 16,     [Dohrmann]                      },
      { 17,     [Endress_and_Hauser]            },
      { 18,     [Fischer_and_Porter]            },
      { 19,     [Fisher_Controls]               },
      { 20,     [Foxboro]                       },
      { 21,     [Fuji]                          },
      { 22,     [Hartmann_and_Braun]            },
      { 23,     [Honeywell]                     },
      { 24,     [ITT_Barton]                    },
      { 25,     [KayRay_Sensall]                },
      { 26,     [Kent]                          },
      { 27,     [Leeds_and_Northrup]            },
      { 28,     [Leslie]                        },
      { 29,     [M_System_Co]                   },
      { 30,     [Measurex]                      },
      { 31,     [Micro_Motion]                  },
      { 32,     [Moore_Industries]              },
      { 33,     [Moore_Products]                },
      { 34,     [Ohkura_Electric]               },
      { 35,     [Paine]                         },
      { 36,     [Rochester_Instrument_Systems]  },
      { 37,     [Ronan]                         },
      { 38,     [Rosemount]                     },
      { 39,     [Peek_Measurement]              },
      { 40,     [Schlumberger]                  },
      { 41,     [Sensall]                       },
      { 42,     [Siemens]                       },
      { 43,     [Camille_Bauer]                 },
      { 44,     [Toshiba]                       },
      { 45,     [Transmation]                   },
      { 46,     [Rosemount_Analytical]          },
      { 47,     [Valmet]                        },
      { 48,     [Valtek]                        },
      { 49,     [Varec]                         },
      { 50,     [Viatran]                       },
      { 51,     [Weed]                          },
      { 52,     [Westinghouse]                  },
      { 53,     [Xomox]                         },
      { 54,     [Yamatake]                      },
      { 55,     [Yokogawa]                      },
      { 56,     [Nuovo_Pignone]                 },
      { 57,     [Promac]                        },
      { 58,     [Exac_Corporation]              },
      { 59,     [KDG_Mobrey]                    },
      { 60,     [Acrom_Control_System]          },
      { 61,     [Princo]                        },
      { 62,     [Smar]                          },
      { 63,     [Eckardt]                       },
      { 64,     [Measurement_Technology]        },
      { 65,     [Applied_System_Technologies]   },
      { 66,     [SAMSON]                        },
      { 67,     [Sparling_Instruments]          },
      { 68,     [Fireye]                        },
      { 69,     [Krohne]                        },
      { 70,     [Betz_Equipment]                },
      { 71,     [Druck]                         },
      { 72,     [SOR]                           },
      { 73,     [Elcon_Instruments]             },
      { 74,     [EMCO]                          },
      { 75,     [Termiflex]                     },
      { 76,     [VAF_Instruments]               },
      { 77,     [Westlock_Controls]             },
      { 78,     [Drexelbrook]                   },
      { 80,     [K_TEK]                         },
      { 81,     [Flowdata]                      },
      { 82,     [Draeger]                       },
      { 83,     [Raytek]                        },
      { 84,     [Meridian_Instruments]          },
      { 85,     [BTG]                           },
      { 86,     [Magnetrol]                     },
      { 87,     [Neles_Jamesbury]               },
      { 88,     [Milltronics]                   },
      { 89,     [HELIOS]                        },
      { 90,     [Anderson_Instrument_Company]   },
      { 91,     [INOR]                          },
      { 92,     [ROBERTSHAW]                    },
      { 93,     [PEPPERL_FUCHS]                 },
      { 94,     [ACCUTECH]                      },
      { 95,     [Flow_Measurement]              },
      { 96,     [KAMSTRUP]                      },
      { 97,     [Knick]                         },
      { 98,     [VEGA]                          },
      { 99,     [MTS_SYS_CORPS_SENSORS]         },
      { 100,    [Oval]                          },
      { 101,    [Masoneilan_DRESSER]            },
      { 102,    [Besta]                         },
      { 103,    [Ohmart]                        },
      { 250,    [not_used]                      },
      { 251,    [none]                          },
      { 252,    [unknown]                       },
      { 253,    [special]                       }
    }
    HANDLING    READ;
    HELP        [phys_device_man_id_help];
#ifdef _V602_
    PURPOSE "Device.Type.Ident.Manufacturer";
#endif
}


/*----------------------------------------------------------------------------*/
VARIABLE phys_device_id
{
    LABEL       [phys_device_id];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "3730-4";
    }
    HANDLING    READ;
    HELP        [phys_device_id_help];
#ifdef _V602_
    PURPOSE "Device.Type.Ident.Type";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_serial_num
{
/*    LABEL       [phys_device_ser_num];*/
    LABEL "Serial number positioner" "|de|Serien-Nummer Regler";
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ;
    HELP        [phys_device_ser_num_help];
#ifdef _V602_
    PURPOSE "Device.Ident.SerialNumber";
#endif
}
/*----------------------------------------------------------------------------*/


#define DIA_HW_ELECTR                 0x01000000      /* 0x00000001 */
#define DIA_HW_MECH                   0x02000000      /* 0x00000002 */
#define DIA_TEMP_MOTOR                0x04000000      /* 0x00000004 */
#define DIA_TEMP_ELECTR               0x08000000      /* 0x00000008 */
#define DIA_MEM_CHKSUM                0x10000000      /* 0x00000010 */
#define DIA_MEASUREMENT               0x20000000      /* 0x00000020 */
#define DIA_NOT_INIT                  0x40000000      /* 0x00000040 */
#define DIA_INIT_ERR                  0x80000000      /* 0x00000080 */
#define DIA_ZERO_ERR                  0x00010000      /* 0x00000100 */
#define DIA_SUPPLY                    0x00020000      /* 0x00000200 */
#define DIA_CONF_INVAL                0x00040000      /* 0x00000400 */
#define DIA_WARMSTART                 0x00080000      /* 0x00000800 */
#define DIA_COLDSTART                 0x00100000      /* 0x00001000 */
#define DIA_MAINTENANCE               0x00200000      /* 0x00002000 */
#define DIA_CHARACT                   0x00400000      /* 0x00004000 */
#define DIA_IDENT_NUMBER_VIOLATION    0x00800000      /* 0x00008000 */
#define DIA_MAINTENANCE_ALARM         0x00000100      /* 0x00010000 */
#define DIA_MAINTENANCE_DEMANDED      0x00000200      /* 0x00020000 */
#define DIA_FUNCTION_CHECK            0x00000400      /* 0x00040000 */
#define DIA_INV_PRO_COND              0x00000800      /* 0x00080000 */
#define EXTENSION_AVAILABLE           0x00000080      /* 0x80000000 */



VARIABLE phys_diagnosis
{
    LABEL       [phys_diagnosis];
    CLASS       DEVICE & DYNAMIC & DIAGNOSTIC;
    TYPE        BIT_ENUMERATED (4)
    {
        {   0,                               [dia_OK],                   [dia_OK_help]                   },
        {   DIA_HW_ELECTR,                   [dia_HW_ELECTR],            [dia_HW_ELECTR_help]            },
        {   DIA_HW_MECH,                     [dia_HW_MECH],              [dia_HW_MECH_help]              },
/*        {   DIA_TEMP_MOTOR,                  [dia_TEMP_MOTOR],           [dia_TEMP_MOTOR_help]           },
        {   DIA_TEMP_ELECTR,                 [dia_TEMP_ELECTR],          [dia_TEMP_ELECTR_help]          },*/
        {   DIA_MEM_CHKSUM,                  [dia_MEM_CHKSUM],           [dia_MEM_CHKSUM_help]           },
        {   DIA_MEASUREMENT,                 [dia_MEASUREMENT],          [dia_MEASUREMENT_help]          },
        {   DIA_NOT_INIT,                    [dia_NOT_INIT],             [dia_NOT_INIT_help]             },
        {   DIA_INIT_ERR,                    [dia_INIT_ERR],             [dia_INIT_ERR_help]             },
        {   DIA_ZERO_ERR,                    [dia_ZERO_ERR],             [dia_ZERO_ERR_help]             },
/*        {   DIA_SUPPLY,                      [dia_SUPPLY],               [dia_SUPPLY_help]               },*/
        {   DIA_CONF_INVAL,                  [dia_CONF_INVAL],           [dia_CONF_INVAL_help]           },
        {   DIA_WARMSTART,                   [dia_WARMSTART],            [dia_WARMSTART_help]            },
        {   DIA_COLDSTART,                   [dia_COLDSTART],            [dia_COLDSTART_help]            },

        {   DIA_MAINTENANCE,                 "Maintenance required" "|de|Wartungsbedarf",
                                             "Maintenance required" "|de|Wartungsbedarf"         		 },
        {   DIA_CHARACT,                     [dia_CHARACT],              [dia_CHARACT_help]              },
        {   DIA_IDENT_NUMBER_VIOLATION,      [dia_IDENT_VIOL],           [dia_IDENT_VIOL_help]           },
        {   DIA_MAINTENANCE_ALARM,           "Maintenance alarm" "|de|Ausfall",
                                             "Maintenance alarm" "|de|Ausfall"   					     },
        {   DIA_MAINTENANCE_DEMANDED,        "Maintenance demanded" "|de|Wartungsanforderung",
                                             "Maintenance demanded"  "|de|Wartungsanforderung"   		 },
        {   DIA_FUNCTION_CHECK,				 "Function check" "|de|Funktionskontrolle",
                                             "Function check" "|de|Funktionskontrolle"			         },
        {   DIA_INV_PRO_COND,				 "Invalid process condition" "|de|Ungltiger Prozesszustand",
                                             "Invalid process condition" "|de|Ungltiger Prozesszustand" },
        {   EXTENSION_AVAILABLE,             [dia_EXTENSION_AVAILABLE],  [dia_EXTENSION_AVAILABLE_help]  }
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 5"; /* 5 Zeilen hoch */
#endif
    HELP        [phys_diagnosis_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_mask
{
    LABEL       [phys_diagnosis_mask];
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (4)
    {
        {   0,                               [dia_OK],                   [dia_OK_help]                   },
        {   DIA_HW_ELECTR,                   [dia_HW_ELECTR],            [dia_HW_ELECTR_help]            },
        {   DIA_HW_MECH,                     [dia_HW_MECH],              [dia_HW_MECH_help]              },
/*        {   DIA_TEMP_MOTOR,                  [dia_TEMP_MOTOR],           [dia_TEMP_MOTOR_help]           },
        {   DIA_TEMP_ELECTR,                 [dia_TEMP_ELECTR],          [dia_TEMP_ELECTR_help]          },*/
        {   DIA_MEM_CHKSUM,                  [dia_MEM_CHKSUM],           [dia_MEM_CHKSUM_help]           },
        {   DIA_MEASUREMENT,                 [dia_MEASUREMENT],          [dia_MEASUREMENT_help]          },
        {   DIA_NOT_INIT,                    [dia_NOT_INIT],             [dia_NOT_INIT_help]             },
        {   DIA_INIT_ERR,                    [dia_INIT_ERR],             [dia_INIT_ERR_help]             },
        {   DIA_ZERO_ERR,                    [dia_ZERO_ERR],             [dia_ZERO_ERR_help]             },
/*        {   DIA_SUPPLY,                      [dia_SUPPLY],               [dia_SUPPLY_help]               },*/
        {   DIA_CONF_INVAL,                  [dia_CONF_INVAL],           [dia_CONF_INVAL_help]           },
        {   DIA_WARMSTART,                   [dia_WARMSTART],            [dia_WARMSTART_help]            },
        {   DIA_COLDSTART,                   [dia_COLDSTART],            [dia_COLDSTART_help]            },

        {   DIA_MAINTENANCE,                 "Maintenance required" "|de|Wartungsbedarf",
                                             "Maintenance required" "|de|Wartungsbedarf"         		 },
        {   DIA_CHARACT,                     [dia_CHARACT],              [dia_CHARACT_help]              },
        {   DIA_IDENT_NUMBER_VIOLATION,      [dia_IDENT_VIOL],           [dia_IDENT_VIOL_help]           },
        {   DIA_MAINTENANCE_ALARM,           "Maintenance alarm" "|de|Ausfall",
                                             "Maintenance alarm" "|de|Ausfall"   					     },
        {   DIA_MAINTENANCE_DEMANDED,        "Maintenance demanded" "|de|Wartungsanforderung",
                                             "Maintenance demanded"  "|de|Wartungsanforderung"   		 },
        {   DIA_FUNCTION_CHECK,				 "Function check" "|de|Funktionskontrolle",
                                             "Function check" "|de|Funktionskontrolle"			         },
        {   DIA_INV_PRO_COND,				 "Invalid process condition" "|de|Ungltiger Prozesszustand",
                                             "Invalid process condition" "|de|Ungltiger Prozesszustand" },
        {   EXTENSION_AVAILABLE,             [dia_EXTENSION_AVAILABLE],  [dia_EXTENSION_AVAILABLE_help]  }

    }
    HANDLING    READ;
    HELP        [phys_diagnosis_mask_help];
}
/*----------------------------------------------------------------------------*/
#if 0  /* nur bei 'BIT_ENUMERATED (6)' gltig: */
  #define DIA_NOT_TESTED          0x400000000000      /* 0x000000000040 */
  #define DIA_LOGIK_NOT_TESTED    0x800000000000      /* 0x000000000080 */
  #define DIA_NOT_CALIB           0x000100000000      /* 0x000000000100 */
#endif
/* bei 'BIT_ENUMERATED (2)' gltig: */
#define DIA_NOT_TESTED          0x4000
#define DIA_LOGIK_NOT_TESTED    0x8000
#define DIA_NOT_CALIB           0x0001


#ifdef XXX /* wird nicht vom Geraet verwendet */
/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_extension_mask /* optional */
{
    LABEL       [phys_diagnosis_extension_mask];
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (6);
    HANDLING    READ;
    HELP        [phys_diagnosis_extension_mask_help];
}
#endif

/*----------------------------------------------------------------------------*/
VARIABLE phys_device_certification
{
    LABEL "Certification" "|de|Zertifizierung";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ;
    HELP        [phys_device_certification_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_write_locking
{
    LABEL       "Software Write Protection"
                "|de|Software-Schreibschutz";
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   2457;
        { 2457, "Not write protected" "|de|Nicht schreibgeschtzt"  },
        {    0, "Write protected"     "|de|Schreibgeschtzt"        }
    }
    HANDLING    READ & WRITE;
    HELP        "Activates or deactivates the software write protection. "
    						"Acyclic write services of all parameters were refused, except "
    						"this parameter."
                "|de|Aktiviert oder deaktiviert den PA Software-Schreibschutz. "
                "Azyklische Schreibzugriffe auf alle Parameter werden abgewiesen "
                "mit Ausnahme dieses Parameters.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_factory_reset
{
    LABEL       [phys_factory_reset];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE  0;
        {     0, "No action"
                 "|de|Keine Aktion"                                             },
        { 32769, "Reset application ,function blocks ans classification to default values"
                 "|de|Rcksetzen der Appl. , Funktions Blcke und Klassifizierung auf Kaltstartwerte"},
        { 32768, "Reset device identification to default values"
                 "|de|Rcksetzen der Gerteidentifikation auf Kaltstartwerte"   },
        {     1, "Reset application, device ident.,function blocks ans classification to default values"
                 "|de|Rcksetzen der Appl. ,Gerteident., Funktions Blcke und Klassifizierung auf Kaltstartwerte" },
        {  2506, "Warmstart of the device"
                 "|de|Auslsen eines Warmstarts"                                },
        {  2712, "Reset bus address"
                 "|de|Rcksetzen der Busadresse"                                },
        { 32770, "Reset application (Code 36)"
                 "|de|Rcksetzen der Appl. (Code 36)" }
    }
    HANDLING   READ & WRITE;
    HELP       [phys_factory_reset_help];
}

/*----------------------------------------------------------------------------*/
/*    Physical Block: Actuator                                                */
/*----------------------------------------------------------------------------*/
VARIABLE phys_descriptor
{
    LABEL       [phys_descriptor];
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "SAMSON 373X-4 (PA-Profile 3.01)" "|de|SAMSON 373X-4 (PA-Profil 3.01)";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_descriptor_help];
#ifdef _V602_
    PURPOSE "Device.App.Ident.Description";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_message
{
    LABEL       [phys_message];
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_message_help];
#ifdef _V602_
    PURPOSE "Device.App.Ident.Message";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_instal_date
{
    LABEL       [phys_install_date];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "XX.XX.20XX";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_install_date_help];
#ifdef _V602_
    PURPOSE "Device.App.Ident.InstallDate";
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_local_operation_enable
{
    LABEL       [trans_act_local_operation];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [disabled]   },
        {   1,  [enabled]  },

    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_local_operation_help];
}
/*---------------------------------------------------------------------*/
VARIABLE phys_ident_number_selector
{
    LABEL       "PROFIBUS ident.-number selection"
                "|de|Auswahl PROFIBUS Ident.-Nummer";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, "Profile specific ident.-number"
             "|de|Profilspezifische Ident.-Nummer"     },
        { 1, "Manufacturer specific ident.-number"
             "|de|Herstellerspezifische Ident.-Nummer" },
/* ab K 1.15: */
        { 127, "Adaptation mode"
             "|de|Kompatibilittsmodus"                }
    }
    HANDLING    READ & WRITE;
    POST_EDIT_ACTIONS
    {
        meld_wirksamkeit    /* Methode (Text: '..erst nach Neustart wirksam') */
    }

    HELP        [phys_ident_number_help];

}


/*----------------------------------------------------------------------------*/
VARIABLE phys_hw_write_protection
{
    LABEL       [phys_hw_write_protection];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Not write protected"
                "|de|Nicht schreibgeschtzt"  },
        {   1,  "Write protected"
                "|de|Schreibgeschtzt"        }
    }
    HANDLING    READ;
    HELP        "Code 47. Switching state of the write protection switch in the device. "
                "When this option is activated, the device data can only be read, "
                "but they cannot be overwritten. The only way to activate the "
                "write protection option is by using the switch installed in the device."
                "|de|Code 47. Schaltzustand des Schreibschutzschalters im Gert. "
                "Bei aktivem Schreibschutz knnen Gertedaten nur ausgelesen, "
                "jedoch nicht berschrieben werden. Aktivierung kann nur "
                "ber einen Schalter im Gert erfolgen.";
/*    HELP        [phys_hw_write_protection_help];*/
}


/* DT 68 */
VARIABLE phys_feature_supported
{
    LABEL       "Supported features" "|de|Zusatzfunktionen";
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (1)
    {
        { 0x01, "Condensed status and diagnosis is supported"
                "|de|Sammelstatus und Diagnose wird untersttzt" },
        { 0x02, "Extended status/diagnosis is supported"
                "|de|Erweiterter Status/Diagnose wird untersttzt" }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_feature_enabled
{
    LABEL       "Enabled features" "|de|Freigegebene Funktionen";
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (1)
    {
        { 0x01, "Condensed status and diagnosis is supported"
                "|de|Sammelstatus und Diagnose wird untersttzt" },
        { 0x02, "Extended status/diagnosis is supported"
                "|de|Erweiterter Status/Diagnose wird untersttzt" }
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/

VARIABLE phys_cond_status_diag
{
    LABEL       "Setting condensed status diagnosis"
                "|de|Einstellung Sammelstatus Diagnose";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        {   0,  "Status and Diagnosis as described in profile 3.01"
                "|de|Status und Diagnose wie in Profil 3.01 beschrieben" },
        {   1,  "Condensed Status and Diagnosis information is provided"
                "|de|Sammelstatus und Diagnose Untersttzung" }
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* Defines fuer folgende comboboxen: */
/*----------------------------------------------------------------------------*/

#define GOOD_UNCERTAIN_BAD_0_TO_8                                            \
        { 0, "GOOD - ok"                                                     \
             "|de|GUT - ok" },                                               \
        { 1, "GOOD - maintenance required"                                   \
             "|de|GUT - Wartungsbedarf" },                                   \
        { 2, "GOOD - maintenance demanded"                                   \
             "|de|GUT - Wartungsanforderung" },                              \
        { 3, "UNCERTAIN - maintenance demanded"                              \
             "|de|UNSICHER - Wartungsanforderung" },                         \
        { 4, "BAD - maintenance alarm"                                       \
             "|de|SCHLECHT - Ausfall" },                                     \
        { 5, "UNCERTAIN - process related, no maintenance"                   \
             "|de|UNSICHER - prozessabhngig, keine Wartung" },              \
        { 6, "BAD - process related, no maintenance"                         \
             "|de|SCHLECHT - prozessabhngig, keine Wartung" },              \
        { 7, "BAD - function check / local override"                         \
             "|de|SCHLECHT - Funktionskontrolle / lokale berlagerung" },    \
        { 8, "GOOD - function check"                                         \
             "|de|GUT - Funktionskontrolle" }


#define DIA_0_TO_5                                                           \
        { 0, "No message"                "|de|Keine Meldung"             },  \
        { 1, "Maintenance required"      "|de|Wartungsbedarf"            },  \
        { 2, "Maintenance demanded"      "|de|Wartungsanforderung"       },  \
        { 3, "Maintenance alarm"         "|de|Ausfall"                   },  \
        { 4, "Invalid process condition" "|de|Ungltiger Prozesszustand" },  \
        { 5, "Function check"            "|de|Funktionskontrolle"        }



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_0_S
{
    LABEL       "Device not initialized" "|de|Gert nicht initialisiert";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_0_D
{
    LABEL      "Device not initialized" "|de|Gert nicht initialisiert";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_1_S
{
    LABEL	 "Solenoid valve active" "|de|Magnetventil aktiv";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_1_D
{
    LABEL	 "Solenoid valve active" "|de|Magnetventil aktiv";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_2_S
{
    LABEL	 "Total valve travel exceeded" "|de|Wegintegral berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_2_D
{
    LABEL	 "Total valve travel exceeded" "|de|Wegintegral berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_3_S
{
    LABEL	 		"Control loop" "|de|Regelkreis";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 57.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_3_D
{
    LABEL	 		"Control loop" "|de|Regelkreis";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 57.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_4_S
{
    LABEL	 "Zero point error" "|de|Nullpunktfehler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 58.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_4_D
{
    LABEL	 "Zero point error" "|de|Nullpunktfehler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 58.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_5_S
{
    LABEL       "Autocorrection" "|de|Autokorrektur";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 59.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_5_D
{
    LABEL       "Autocorrection" "|de|Autokorrektur";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 59.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_6_S
{
    LABEL       "Fatal error" "|de|Fataler Fehler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 8" ; /* x Zeilen hoch */
#endif
}

VARIABLE phys_diag_event_switch__Diag_Status_Link_1_6_D
{
    LABEL       "Fatal error" "|de|Fataler Fehler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_7_S
{
    LABEL       "Extended diagnostic" "|de|Erweiterte Diagnose";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_7_D
{
    LABEL       "Extended diagnostic" "|de|Erweiterte Diagnose";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_8_S
{
    LABEL	 "x > range" "|de|x > Bereich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 50.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_8_D
{
    LABEL	 "x > range" "|de|x > Bereich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 50.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_9_S
{
     LABEL	 		"Delta x < range" "|de|Delta x < Bereich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 51.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_9_D
{
    LABEL	 			"Delta x < range" "|de|Delta x < Bereich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 51.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_10_S
{
    LABEL	 			"Attachment" "|de|Anbau";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
     DEFAULT_VALUE   1;  
     GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 52.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_10_D
{
    LABEL	 			"Attachment" "|de|Anbau";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 52.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_11_S
{
    LABEL	 "Initialization time exceeded" "|de|Initialisierungszeit berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 53.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_11_D
{
    LABEL	 "Initialization time exceeded" "|de|Initialisierungszeit berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 53.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_12_S
{
    LABEL	 			"Initialization / int. solenoid valve / forced venting"
                "|de|Initialisierung / int. MGV / Zwangsentl.";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 54.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_12_D
{
    LABEL	 			"Initialization / int. solenoid valve / forced venting"
                "|de|Initialisierung / int. MGV / Zwangsentl.";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 54.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_13_S
{
    LABEL	 			"Travel time too short" "|de|Laufzeit unterschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 55.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_13_D
{
    LABEL	 			"Travel time too short" "|de|Laufzeit unterschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 55.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_14_S
{
    LABEL	 		  "Pin position" "|de|Stiftposition";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 56.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_14_D
{
    LABEL	 		  "Pin position" "|de|Stiftposition";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 56.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_15_S
{
    LABEL	 			"Test or calibration running" "|de|Test oder Kalibrierung luft";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_15_D
{
    LABEL	 			"Test or calibration running" "|de|Test oder Kalibrierung luft";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_16_S
{
    LABEL	 			"x-signal" "|de|x-Signal";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   2;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 62.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_16_D
{
    LABEL	 			"x-signal" "|de|x-Signal";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   2;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 62.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_17_S
{
    LABEL	 			"i/p-converter" "|de|i/p-Wandler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_17_D
{
    LABEL	 			"i/p-converter" "|de|i/p-Wandler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_18_S
{
    LABEL	 			"Hardware" "|de|Hardware";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_18_D
{
    LABEL	 			"Hardware" "|de|Hardware";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_19_S
{
    LABEL	 			"Control parameter"	"|de|Regelparameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 68.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_19_D
{
    LABEL	 			"Control parameter"	"|de|Regelparameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 68.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_20_S
{
    LABEL	 			"Poti parameter" "|de|Poti Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 69.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_20_D
{
    LABEL	 			"Poti parameter" "|de|Poti Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 69.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_21_S
{
    LABEL       "Adjustment parameter" "|de|Abgleichparameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 70.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_21_D
{
    LABEL       "Adjustment parameter" "|de|Abgleichparameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 70.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_22_S
{
    LABEL	 			"Internal device error 1"	"|de|Interner Gertefehler 1";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 73.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_22_D
{
    LABEL	 			"Internal device error 1"	"|de|Interner Gertefehler 1";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 73.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_23_S
{
    LABEL	 			"General parameter"	"|de|Allgemeine Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 71.";
}

VARIABLE phys_diag_event_switch__Diag_Status_Link_1_23_D
{
    LABEL	 			"General parameter"	"|de|Allgemeine Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 71.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_24_S
{
    LABEL	 			"No emergency mode" "|de|Keine Notlaufeigenschaft";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 76.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_24_D
{
    LABEL	 			"No emergency mode" "|de|Keine Notlaufeigenschaft";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 76.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_25_S
{
    LABEL	 			"Program load error" "|de|Programm Ladefehler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_25_D
{
    LABEL	 			"Program load error" "|de|Programm Ladefehler";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_26_S
{
    LABEL	 			"Options parameter"	"|de|Optionsparameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 78.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_26_D
{
    LABEL	 			"Options parameter"	"|de|Optionsparameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 78.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_27_S
{
    LABEL	 			"Info parameter" "|de|Info-Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 75.";
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_27_D
{
    LABEL	 			"Info parameter" "|de|Info-Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 75.";
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_28_S
{
    LABEL       "Data parameter" "|de|Parameter Daten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_28_D
{
    LABEL       "Data parameter" "|de|Parameter Daten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_29_S
{
    LABEL       "Control calculation" "|de|Kontrollrechnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_29_D
{
    LABEL       "Control calculation" "|de|Kontrollrechnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   3;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_30_S
{
    LABEL       "Reset Communication controller" "|de|Reset Kommunikations - Controller";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_30_D
{
    LABEL       "Reset Communication controller" "|de|Reset Kommunikations - Controller";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_31_S
{
    LABEL      "Communication interface" "|de|Busanschaltung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_31_D
{
    LABEL      "Communication interface" "|de|Busanschaltung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_32_S
{
    LABEL       "Dicrete Input 2 not activated" "|de|Binreingang 2 nicht aktiviert";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_32_D
{
    LABEL       "Dicrete Input 2 not activated" "|de|Binreingang 2 nicht aktiviert";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_33_S
{
    LABEL      "Reset control controller" "|de|Reset Regelungs-Controller";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_33_D
{
    LABEL      "Reset control controller" "|de|Reset Regelungs-Controller";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_34_S
{
    LABEL      "Perhaps modified TEST"
    			 		 "|de|Eventuell verndert TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_34_D
{
    LABEL      "Perhaps modified TEST"
    			 		 "|de|Eventuell verndert TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_35_S
{
    LABEL      "Perhaps not enough TEST"
    			 		 "|de|Eventuell nicht ausreichend TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_35_D
{
    LABEL      "Perhaps not enough TEST"
    			 		 "|de|Eventuell nicht ausreichend TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_36_S
{
    LABEL      "Perhaps not enough "
    			 		 "|de|Eventuell nicht ausreichend ";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_36_D
{
    LABEL      "Perhaps not enough "
    			 		 "|de|Eventuell nicht ausreichend ";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_37_S
{
    LABEL      "Working at full capacity"
    			 		 "|de|Stark ausgelastet";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_37_D
{
    LABEL      "Working at full capacity"
    			 		 "|de|Stark ausgelastet";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_38_S
{
    LABEL      "Working at full capacity TEST"
    			 		 "|de|Stark ausgelastet TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_38_D
{
    LABEL      "Working at full capacity TEST"
    			 		 "|de|Stark ausgelastet TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_39_S
{
    LABEL      "Perhaps modified"
    			 		 "|de|Eventuell verndert";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_39_D
{
    LABEL      "Perhaps modified"
    			 		 "|de|Eventuell verndert";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_40_S
{
    LABEL      "Perhaps spring stiffness reduced TEST"
    			 		 "|de|Eventuell Federsteifigkeit reduziert (Federausfall) TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_40_D
{
    LABEL      "Perhaps spring stiffness reduced TEST"
    			 		 "|de|Eventuell Federsteifigkeit reduziert (Federausfall) TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_41_S
{
    LABEL      "Perhaps bias reduced TEST"
    			 		 "|de|Eventuell Vorspannung reduziert TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_41_D
{
    LABEL      "Perhaps bias reduced TEST"
    			 		 "|de|Eventuell Vorspannung reduziert TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_42_S
{
    LABEL      "Perhaps bias increased TEST"
    			 		 "|de|Eventuell Vorspannung erhht TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_42_D
{
    LABEL      "Perhaps bias increased TEST"
    			 		 "|de|Eventuell Vorspannung erhht TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_43_S
{
    LABEL      "Working at full capacity"
    			 		 "|de|Stark ausgelastet";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_43_D
{
    LABEL      "Working at full capacity"
    			 		 "|de|Stark ausgelastet";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_44_S
{
    LABEL      "Working at full capacity TEST"
    			 		 "|de|Stark ausgelastet TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_44_D
{
    LABEL      "Working at full capacity TEST"
    			 		 "|de|Stark ausgelastet TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_45_S
{
    LABEL      "Shifting working range to closing position"
    			 		 "|de|Arbeitsbereichverschiebung Schliestellung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_45_D
{
    LABEL      "Shifting working range to closing position"
    			 		 "|de|Arbeitsbereichverschiebung Schliestellung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_46_S
{
    LABEL      "Shifting working range to max. opening position"
    			 		 "|de|Arbeitsbereichverschiebung max. ffnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_46_D
{
    LABEL      "Shifting working range to max. opening position"
    			 		 "|de|Arbeitsbereichverschiebung max. ffnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_47_S
{
     LABEL      "Much higher over whole range"
    			 		 "|de|ber gesamten Stellbereich deutlich erhht";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}
VARIABLE phys_diag_event_switch__Diag_Status_Link_1_47_D
{
     LABEL      "Much higher over whole range"
    			 		 "|de|ber gesamten Stellbereich deutlich erhht";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Slot
{
    LABEL       "Diag event switch (Slot)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch__Index
{
    LABEL       "Diag event switch (Index)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Herstellerspezifische Parameter                                  */
/*---------------------------------------------------------------------*/


VARIABLE phys_ident_options
{
	LABEL		"Identification options" "|de|Identifikation Optionen";
	CLASS		DEVICE;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
		{ 0x00,     "Not implemented" "|de|Nicht implementiert" },
      	{ 0x80,     "Binary input 2"  "|de|Binreingang 2" },
      	{ 0x40,     "Solenoid valve"  "|de|Magnetventil" },
      	{ 0x20,     "Limit switch"    "|de|Grenzkontakt" }
 /*     	{ 0x10,     "Option 4"        "|de|Option 4" },
      	{ 0x08,     "Option 5"        "|de|Option 5" },
      	{ 0x04,     "Option 6"        "|de|Option 6" },
      	{ 0x02,     "Option 7"        "|de|Option 7" },
      	{ 0x01,     "Option 8"        "|de|Option 8" }
 */
	}
	HELP "Code 45. Describes, which options are implemented."
	     "|de|Code 45. Beschreibt welche Optionen eingebaut sind." ;
#ifdef _V510_
    STYLE "MULTILINE 12 3" ; /* x Zeilen hoch */
#endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Induktiver Grenzkontakt      Doku-Nummer: 45    EB-Code: 38   */
/* ------------------------------------------------------------------------ */
VARIABLE phys_ident_limit_switches
{
  LABEL    "Inductive limit switch" "|de|Induktiver Grenzkontakt";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
      { NOT_IMPLEMENTED, "Not implemented" "|de|Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|de|Eingebaut"       }
  }
  HELP "Code 38. Indicates whether the option inductive limit switch is installed "
       "(no automatic identification)."
       "|de|Code 38. Zeigt an ob die Option 'Induktiver Grenzkontakt' eingebaut ist "
       "(keine automatische Erkennung).";
}



/*----------------------------------------------------------------------------*/

VARIABLE phys_device_product_num
{
    LABEL       "Product number" "|de|Erzeugnis-Nummer";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "XX.XX.20XX";
    }
    HANDLING    READ;
    HELP        "Product number: Manufacturer's product number of the positioner."
                "|de|Erzeugnis-Nummer: Hersteller-Erzeugnisnummer des Stellungsreglers.";
#ifdef _V602_
   PURPOSE "Device.Type.Ident.OrderNumber";
#endif
}


/*----------------------------------------------------------------------------*/

VARIABLE phys_text_input_1
{
    LABEL       "Text field 1"
                "|de|Textfeld 1";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}

/*----------------------------------------------------------------------------*/

VARIABLE phys_text_input_2
{
    LABEL       "Text field 2"
                "|de|Textfeld 2";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}


/*----------------------------------------------------------------------------*/

VARIABLE phys_text_input_3
{
    LABEL       "Text field 3"
                "|de|Textfeld 3";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}

/*----------------------------------------------------------------------------*/

VARIABLE phys_text_input_4
{
    LABEL       "Text field 4"
                "|de|Textfeld 4";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}

/*----------------------------------------------------------------------------*/

VARIABLE phys_text_input_5
{
    LABEL       "Text field 5"
                "|de|Textfeld 5";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}


/*----------------------------------------------------------------------------*/

VARIABLE phys_production_id
{
    LABEL       "Final assembly number" "|de|Werknummer";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        "Number that is used for identification purposes, "
                "and is associated with the overall Field Device."
                "|de|Nummer die eindeutig das komplette Feldgert identifiziert.";
}



/* ------------------------------------------------------------------------ */
/* Parameter: Leserichtung                 Doku-Nummer: 3     EB-Code: 2    */
/* ------------------------------------------------------------------------ */
VARIABLE phys_reading_direction
{
  LABEL     "Reading direction" "|de|Leserichtung";
  CLASS	    DEVICE;
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED (1)
  {
      { 0, "Pneumatic connection right" "|de|Pneumatik-Anschluss rechts" },
      { 1, "Pneumatic connection left"  "|de|Pneumatik-Anschluss links"  }
  }
  HELP "Code 2. The reading direction of the LC display at the device is turned by 180."
       "|de|Code 2. Die Leserichtung der LC-Anzeige am Gert wird um 180 gedreht.";
}

/*----------------------------------------------------------------------------*/

/* ------------------------------------------------------------------------ */
/* Parameter: Konfiguration Binreingang 2   */
/* ------------------------------------------------------------------------ */
VARIABLE phys_config_binary_input_2
{
  LABEL     "Configuration binary input 2" "|de|Konfiguration Binreingang 2";
  CLASS	    DEVICE;
  HANDLING  READ & WRITE;
  TYPE      ENUMERATED (1)
  {
      { 0, "Floating contact"
           "|de|Offener Kontakt" },
      { 1, "Actively open - leakage sensor"
           "|de|Aktiv offen - Leckagefhler" },
      { 2, "Actively closed - leakage sensor"
           "|de|Aktiv geschlossen - Leckagefhler" },
      { 3, "Solenoid valve 	- CB_FAIL_SAFE"
           "|de|Magnetventil - CB_FAIL_SAFE" },
      { 4, "Actively open 	- leakage sensor / CD_ADD_INPUT / Solenoid valve"
           "|de|Aktiv offen - Leckagefhler / CD_ADD_INPUT / Magnetventil" },
      { 5, "Actively closed - leakage sensor / CD_ADD_INPUT / Solenoid valve"
           "|de|Aktiv geschlossen - Leckagefhler / CD_ADD_INPUT / Magnetventil" },
      { 6, "Actively open 	- leakage sensor - DI2 / Solenoid valve CD_ADD_INPUT"
           "|de|Aktiv offen - Leckagefhler - DI2 / Magnetventil CD_ADD_INPUT" },
      { 7, "Actively closed - leakage sensor - DI2 / Solenoid valve CD_ADD_INPUT"
           "|de|Aktiv geschlossen - Leckagefhler - DI2 / Magnetventil CD_ADD_INPUT" }
  }
/*  HELP "---";*/
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_0_S
{
    LABEL      "Much lower over whole range"
    			 		 "|de|ber gesamten Stellbereich deutlich niedriger";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_0_D
{
    LABEL      "Much lower over whole range"
    			 		 "|de|ber gesamten Stellbereich deutlich niedriger";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_1_S
{
    LABEL      "Much higher over partition"
    			 		 "|de|ber Teilbereich deutlich erhht";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_1_D
{
    LABEL      "Much higher over partition"
    			 		 "|de|ber Teilbereich deutlich erhht";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_2_S
{
    LABEL      "Much lower over partition"
    			 		 "|de|ber Teilbereich deutlich niedriger";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_2_D
{
    LABEL      "Much lower over partition"
    			 		 "|de|ber Teilbereich deutlich niedriger";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_3_S
{
    LABEL      "Much higher over whole range TEST"
    			 		 "|de|ber gesamten Stellbereich deutlich erhht TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_3_D
{
    LABEL      "Much higher over whole range TEST"
    			 		 "|de|ber gesamten Stellbereich deutlich erhht TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_4_S
{
    LABEL      "Much lower over whole range TEST"
    			 		 "|de|ber gesamten Stellbereich deutlich niedriger TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_4_D
{
    LABEL      "Much lower over whole range TEST"
    			 		 "|de|ber gesamten Stellbereich deutlich niedriger TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_5_S
{
    LABEL      "Much higher over partition TEST"
    			 		 "|de|ber Teilbereich deutlich erhht TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_5_D
{
    LABEL      "Much higher over partition TEST"
    			 		 "|de|ber Teilbereich deutlich erhht TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_6_S
{
    LABEL      "Much lower over partition TEST"
    			 		 "|de|ber Teilbereich deutlich niedriger TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_6_D
{
    LABEL      "Much lower over partition TEST"
    			 		 "|de|ber Teilbereich deutlich niedriger TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_7_S
{
    LABEL      "Perhaps existing TEST"
    			 		 "|de|Eventuell vorhanden TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_7_D
{
    LABEL      "Perhaps existing TEST"
    			 		 "|de|Eventuell vorhanden TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_8_S
{
    LABEL      "Perhaps existing"
    			 		 "|de|Eventuell vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_8_D
{
    LABEL      "Perhaps existing"
    			 		 "|de|Eventuell vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_9_S
{
    LABEL      "Perhaps too large TEST"
    			 		 "|de|Eventuell zu gross TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_9_D
{
    LABEL      "Perhaps too large TEST"
    			 		 "|de|Eventuell zu gross TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_10_S
{
    LABEL      "Perhaps too large"
    			 		 "|de|Eventuell zu gross";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_10_D
{
    LABEL      "Perhaps too large"
    			 		 "|de|Eventuell zu gross";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_11_S
{
    LABEL      "Down"
    			 		 "|de|Nach unten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_11_D
{
    LABEL      "Down"
    			 		 "|de|Nach unten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_12_S
{
    LABEL      "Up"
    			 		 "|de|Nach oben";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_12_D
{
    LABEL      "Up"
    			 		 "|de|Nach oben";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_13_S
{
    LABEL      "Modification impossible"
    			 		 "|de|Keine nderung mglich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_13_D
{
    LABEL      "Modification impossible"
    			 		 "|de|Keine nderung mglich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_14_S
{
    LABEL      "Dynamic stress factor > 90 %"
    			 		 "|de|Dynamischer Belastungsfaktor > 90 %";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_14_D
{
    LABEL      "Dynamic stress factor > 90 %"
    			 		 "|de|Dynamischer Belastungsfaktor > 90 %";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}





/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_15_S
{
    LABEL      "Perhaps existing"
    			 		 "|de|Eventuell vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_15_D
{
    LABEL      "Perhaps existing"
    			 		 "|de|Eventuell vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_16_S
{
    LABEL      "Alarm limit 3 exceeded"
    			 		  "|de|Alarmgrenze 3 berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_16_D
{
    LABEL      "Alarm limit 3 exceeded"
    			 		 "|de|Alarmgrenze 3 berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_17_S
{
    LABEL      "Alarm limit 2 exceeded"
    			 		  "|de|Alarmgrenze 2 berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_17_D
{
    LABEL      "Alarm limit 2 exceeded"
    			 		  "|de|Alarmgrenze 2 berschritten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}




/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_18_S
{
    LABEL      "Perhaps soon expected"
    			 		 "|de|Eventuell bald zu erwarten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_18_D
{
    LABEL      "Perhaps soon expected"
    			 		 "|de|Eventuell bald zu erwarten";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_19_S
{
    LABEL      "Perhaps existing"
    			 		 "|de|Eventuell vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_19_D
{
    LABEL      "Perhaps existing"
    			 		 "|de|Eventuell vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_20_S
{
    LABEL      "Existing"
    			 		 "|de|Vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_20_D
{
    LABEL      "Existing"
    			 		 "|de|Vorhanden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_21_S
{
   LABEL      "ZP-shift monotone down; aver. over ref"
    			 		 "|de|NP-Verschiebung monoton unten, Mittelwert ob. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_21_D
{
    LABEL      "ZP-shift monotone down; aver. over ref"
    			 		 "|de|NP-Verschiebung monoton unten, Mittelwert ob. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_22_S
{
   LABEL      "ZP-shift monotone up; aver. over ref."
    			 		 "|de|NP-Verschiebung monoton oben, Mittelwert ob. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_22_D
{
    LABEL      "ZP-shift monotone up; aver. over ref."
    			 		 "|de|NP-Verschiebung monoton oben, Mittelwert ob. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_23_S
{
    LABEL      "ZP-shift alternate; aver. over ref."
    			 		 "|de|NP-alterniert - Mittelwert ob. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_23_D
{
    LABEL      "ZP-shift alternate; aver. over ref."
    			 		 "|de|NP-alterniert - Mittelwert ob. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_24_S
{
    LABEL      "ZP-shift monotone down; aver. under ref."
    			 		 "|de|NP-Verschiebung - monoton unten, Mittelwert unt. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_24_D
{
    LABEL      "ZP-shift monotone down; aver. under ref."
    			 		 "|de|NP-Verschiebung - monoton unten, Mittelwert unt. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_25_S
{
    LABEL      "ZP-shift monotone up; aver. under ref."
    			 		 "|de|NP-Verschiebung - monoton oben, Mittelwert unt. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_25_D
{
    LABEL      "ZP-shift monotone up; aver. under ref."
    			 		 "|de|NP-Verschiebung - monoton oben, Mittelwert unt. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_26_S
{
    LABEL      "ZP-alternate; aver. under ref."
    			 		 "|de|NP-alterniert - Mittelwert unt. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_26_D
{
    LABEL      "ZP-alternate; aver. under ref."
    			 		 "|de|NP-alterniert - Mittelwert unt. Ref.-geraden";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_27_S
{
   LABEL       " no opt. travel transm.(TEST)"
    			 		 "|de|Keine opt. Hubbertragung TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_27_D
{
    LABEL      " no opt. travel transm.(TEST)"
    			 		 "|de|Keine opt. Hubbertragung TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_28_S
{
    LABEL      "Perhaps loose"
    			 		 "|de|Eventuell lose";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_28_D
{
    LABEL      "Perhaps loose"
    			 		 "|de|Eventuell lose";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_29_S
{
    LABEL      "Perhaps with limitation of range"
    			 		 "|de|Eventuell Einschrnkung Stellbereich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_29_D
{
    LABEL      "Perhaps with limitation of range"
    			 		 "|de|Eventuell Einschrnkung Stellbereich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_30_S
{
    LABEL      "Perhaps loose TEST"
    			 		 "|de|Eventuell lose TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_30_D
{
    LABEL      "Perhaps loose TEST"
    			 		 "|de|Eventuell lose TEST";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_31_S
{
    LABEL      "Mostly near closing position"
    			 		 "|de|Vorwiegend nahe Schliessstellung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_31_D
{
    LABEL      "Mostly near closing position"
    			 		 "|de|Vorwiegend nahe Schliessstellung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_32_S
{
    LABEL      "Mostly near max. opening"
    			 		 "|de|Vorwiegend nahe max. ffnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_32_D
{
    LABEL      "Mostly near max. opening"
    			 		 "|de|Vorwiegend nahe max. ffnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_33_S
{
    LABEL      "Mostly closing position"
    			 		 "|de|Vorwiegend Schliessstellung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_33_D
{
    LABEL      "Mostly closing position"
    			 		 "|de|Vorwiegend Schliessstellung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_34_S
{
    LABEL      "Mostly max. opening"
    			 		 "|de|Vorwiegend max. ffnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_34_D
{
    LABEL      "Mostly max. opening"
    			 		 "|de|Vorwiegend max. ffnung";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_35_S
{
    LABEL      "Temperature below -40C"
    			 		 "|de|Temperatur unterhalb -40C";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_35_D
{
    LABEL      "Temperature below -40C"
    			 		 "|de|Temperatur unterhalb -40C";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_36_S
{
     LABEL      "Temperature above +80C"
    			 		 "|de|Temperatur oberhalb +80C";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_36_D
{
     LABEL      "Temperature above +80C"
    			 		 "|de|Temperatur oberhalb +80C";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}




/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_37_S
{
    LABEL      "Reference test aborted"
    			 		 "|de|Referenzlauf abgebrochen";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 81.";
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_37_D
{
    LABEL      "Reference test aborted"
    			 		 "|de|Referenzlauf abgebrochen";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 81.";
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_38_S
{
    LABEL      "Movement actuator possible"
    			 		 "|de|Verfahren Antrieb mglich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_38_D
{
    LABEL      "Movement actuator possible"
    			 		 "|de|Verfahren Antrieb mglich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}



/*----------------------------------------------------------------------------*/
/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_39_S
{
    LABEL      "Movement actuator not possible"
    			 		 "|de|Verfahren Antrieb nicht mglich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}



VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_39_D
{
    LABEL      "Movement actuator not possible"
    			 		 "|de|Verfahren Antrieb nicht mglich";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

/* DT 69 */
VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_40_S
{
    LABEL      "Error Solenoid Valve"
    			 		 "|de|Fehler Magnetventil";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_40_D
{
    LABEL      "Error Solenoid Valve"
    			 		 "|de|Fehler Magnetventil";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   0;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}


VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_41_S
{
    LABEL      "PA parameter"
    			 		 "|de|PA Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_41_D
{
    LABEL      "PA parameter"
    			 		 "|de|PA Parameter";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_42_S
{
    LABEL      "Diagnosis parameter"
    			 		 "|de|Diagnoseparameter";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
      GOOD_UNCERTAIN_BAD_0_TO_8
    }
    HANDLING    READ & WRITE;
    HELP     "Code 80.";
}


VARIABLE phys_diag_event_switch_2__Diag_Status_Link_2_42_D
{
    LABEL      "Diagnosis parameter"
    			 		 "|de|Diagnoseparameter";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
      DEFAULT_VALUE   1;
      DIA_0_TO_5
    }
    HANDLING    READ & WRITE;
    HELP     "Code 80.";
}

phys_diag_event_switch_2__Diag_Status_Link_2_43_S  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_S
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_43_D  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_D
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_44_S  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_S
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_44_D  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_D
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_45_S  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_S
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_45_D  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_D
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_46_S  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_S
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_46_D  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_D
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_47_S  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_S
{
   REDEFINE LABEL "";
}

phys_diag_event_switch_2__Diag_Status_Link_2_47_D  LIKE VARIABLE	phys_diag_event_switch_2__Diag_Status_Link_2_40_D
{
   REDEFINE LABEL "";
}


/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch_2__Slot
{
    LABEL       "Diag event switch 2 (Slot)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_event_switch_2__Index
{
    LABEL       "Diag event switch 2 (Index)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_ext_1_raw_0
{
	LABEL		"Operation errors" "|de|Betriebsfehler";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "Device not initialized"            "|de|Gert nicht initialisiert" },
        { 0x02, "Solenoid valve active"             "|de|Magnetventil aktiv" },
        { 0x04, "Total valve travel limit exceeded"	"|de|Wegintegral berschritten" },
      	{ 0x08, "Control loop"	                    "|de|Regelkreis" },
        { 0x10, "Zero point"	                    "|de|Nullpunkt" },
        { 0x20, "Autocorrection"	                "|de|Autokorrektur" },
     	{ 0x40, "Fatal error"	                    "|de|Fataler Fehler" },
        { 0x80, "Extented diagnosis"                "|de|Erweiterte Diagnose" }
   }
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_1_0 	LIKE VARIABLE 	phys_diagnosis_ext_1_raw_0
{	}



/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_operation
{
	LABEL		"Operation errors" "|de|Betriebsfehler";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "Device not initialized"            "|de|Gert nicht initialisiert" },
        { 0x02, "Solenoid valve active"             "|de|Magnetventil aktiv" },
        { 0x04, "Total valve travel limit exceeded"	"|de|Wegintegral berschritten" },
      	{ 0x08, "Control loop"	                    "|de|Regelkreis" },
        { 0x10, "Zero point"	                    "|de|Nullpunkt" },
        { 0x20, "Autocorrection"	                "|de|Autokorrektur" },
     		{ 0x40, "Fatal error"	                    "|de|Fataler Fehler" },
        { 0x80, "Extented diagnosis"                "|de|Erweiterte Diagnose" }
   }
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}



/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_ext_1_raw_1
{
	LABEL		"Initialization errors" "|de|Initialisierungsfehler";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "x > range"	                      "|de|x > Bereich" },
      	{ 0x02, "Delta x < range"                 "|de|Delta x < Bereich" },
        { 0x04, "Attachment"		              "|de|Anbau" },
      	{ 0x08, "Initialization time exceeded"	  "|de|Initialisierungszeit berschritten" },
      	{ 0x10, "Initialization / solenoid valve" "|de|Initialisierung / Magnetventil" },
      	{ 0x20, "Travel time too short"           "|de|Laufzeit unterschritten" },
      	{ 0x40, "Pin position"	                  "|de|Stiftposition" },
      	{ 0x80, "Test or calibration running"     "|de|Test oder Kalibrierung luft" }
   }
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_1_1 	LIKE VARIABLE 	phys_diagnosis_ext_1_raw_1
{	}


/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_init_1
{
	LABEL		"Initialization errors 1" "|de|Initialisierungsfehler 1";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "x > range"	                      "|de|x > Bereich" },
      	{ 0x02, "Delta x < range"                 "|de|Delta x < Bereich" },
        { 0x04, "Attachment"		              "|de|Anbau" },
      	{ 0x08, "Initialization time exceeded"	  "|de|Initialisierungszeit berschritten" },
      	{ 0x10, "Initialization / solenoid valve" "|de|Initialisierung / Magnetventil" },
      	{ 0x20, "Travel time too short"           "|de|Laufzeit unterschritten" },
      	{ 0x40, "Pin position"	                  "|de|Stiftposition" },
      	{ 0x80, "Test or calibration running"     "|de|Test oder Kalibrierung luft" }
   }
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}



/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_init_2
{
	LABEL		"Initialization errors 2" "|de|Initialisierungsfehler 2";
  CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "No emergency mode"	"|de|Keine Notlaufeigenschaften" }
   }
#ifdef _V510_
    STYLE "MULTILINE 12 1" ; /* x Zeilen hoch */
#endif
}


/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_ext_1_raw_2
{
	LABEL		"Hardware errors" "|de|Hardwarefehler";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "x-signal"	    "|de|x-Signal" },
        { 0x02, "i/p-converter"	"|de|i/p Wandler" },
        { 0x04, "Hardware"	    "|de|Hardware" }
  }
#ifdef _V510_
    STYLE "MULTILINE 12 3" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_1_2 	LIKE VARIABLE 	phys_diagnosis_ext_1_raw_2
{	}


/*----------------------------------------------------------------------------*/
VARIABLE phys_diag_hw
{
	LABEL		"Hardware errors" "|de|Hardwarefehler";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
        { 0x01, "x-signal"	    			"|de|x-Signal" },
        { 0x02, "i/p-converter"				"|de|i/p Wandler" },
        { 0x04, "Hardware"	    			"|de|Hardware" },
        { 0x08, "Data memory"	    		"|de|Datenspeicher" },
        { 0x10, "Control calculation" "|de|Kontrollrechnung" },
        { 0x20, "Program load error"	"|de|Programmladefehler" }
  }
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}


VARIABLE phys_diagnosis_ext_1_raw_3
{
	LABEL		"Data memory errors" "|de|Datenspeicherfehler";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (3)
	{
      	{ 0x080000, "Control parameter"	               "|de|Regelparameter" },
        { 0x100000, "Poti parameter"		           "|de|Potiparameter" },
        { 0x200000, "Adjustment parameter"	           "|de|Abgleichparameter" },
   		{ 0x400000, "Internal device error 1"	       "|de|Interner Gertefehler 1" },
        { 0x800000, "General parameter"			       "|de|Allgemeine Parameter" },
      	{ 0x000100, "No emergency mode"			       "|de|Keine Notlaufeigenschaft" },
      	{ 0x000200, "Program load error"		       "|de|Programmladefehler" },
        { 0x000400, "Options parameter"		           "|de|Optionsparameter" },
      	{ 0x000800, "Info parameter"		           "|de|Info-Parameter" },
      	{ 0x001000, "Data memory"			           "|de|Datenspeicher" },
      	{ 0x002000, "Control calculation"	           "|de|Berechnung Regelung" },
      	{ 0x004000, "PA parameter"			           "|de|PA Parameter" },
      	{ 0x008000, "Diagnosis parameter" 			   "|de|Diagnoseparameter" },
      	{ 0x000001, "Reset communication controller"   "|de|Reset Kommunikations-Controller" },
      	{ 0x000002, "Reset communication HW interface" "|de|Reset Busanschaltung" },
    	{ 0x000004, "Bin Input 2 deactivated"	       "|de|Bin Eingang 2 deaktiviert" },
        { 0x000008, "Reset application controller"	   "|de|Reset Anwendungs-Controller" },
        { 0x000010, "not used"	                   	   "|de|nicht verwendet" },
        { 0x000020, "not used"		                   "|de|nicht verwendet" },
        { 0x000040, "not used"		                   "|de|nicht verwendet" },
        { 0x000080, "not used"		                   "|de|nicht verwendet" }
	}
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

VARIABLE phys_diag_ext_1_3
{
	LABEL		"Data memory errors 2" "|de|Datenspeicherfehler 2";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
/* kmr: soll nicht angezeigt werden      	{ 0x080000, "Control parameter"	               "|de|Regelparameter" },
        { 0x100000, "Poti parameter"		           "|de|Potiparameter" },
        { 0x200000, "Adjustment parameter"	           "|de|Abgleichparameter" },
   		{ 0x400000, "Internal device error 1"	       "|de|Interner Gertefehler 1" },
        { 0x800000, "General parameter"			       "|de|Allgemeine Parameter" },
      	{ 0x000100, "No emergency mode"			       "|de|Keine Notlaufeigenschaft" },
      	{ 0x000200, "Program load error"		       "|de|Programmladefehler" },
        { 0x000400, "Options parameter"		           "|de|Optionsparameter" },
      	{ 0x000800, "Info parameter"		           "|de|Info-Parameter" },
      	{ 0x001000, "Data memory"			           "|de|Datenspeicher" },
      	{ 0x002000, "Control calculation"	           "|de|Berechnung Regelung" },
      	{ 0x004000, "PA parameter"			           "|de|PA Parameter" },*/
      	{ 0x80, "Diagnosis parameter" 			   "|de|Diagnoseparameter" }
/*      	{ 0x000001, "Reset communication controller"   "|de|Reset Kommunikations-Controller" },
      	{ 0x000002, "Reset communication HW interface" "|de|Reset Busanschaltung" },
    	{ 0x000004, "Bin Input 2 deactivated"	       "|de|Bin Eingang 2 deaktiviert" },
        { 0x000008, "Reset application controller"	   "|de|Reset Anwendungs-Controller" },
        { 0x000010, "not used"	                   	   "|de|nicht verwendet" },
        { 0x000020, "not used"		                   "|de|nicht verwendet" },
        { 0x000040, "not used"		                   "|de|nicht verwendet" },
        { 0x000080, "not used"		                   "|de|nicht verwendet" }*/
	}
#ifdef _V510_
    STYLE "MULTILINE 12 1" ; /* x Zeilen hoch */
#endif
}


VARIABLE phys_diag_data_1
{
	LABEL		"Data memory errors 1" "|de|Datenspeicherfehler 1";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
      	{ 0x01, "Control parameter"	         "|de|Regelparameter" },
      	{ 0x02, "Poti parameter"		         "|de|Potiparameter"},
      	{ 0x04, "Adjustment parameter"	     "|de|Abgleichparameter"},
      	{ 0x08, "General parameter"			     "|de|Allgemeine Parameter"},
      	{ 0x10, "Internal device error 1"	   "|de|Interner Gertefehler 1"},
      	{ 0x20, "PA parameter"	   					 "|de|PA Parameter"},
      	{ 0x40, "Info parameter"		         "|de|Info-Parameter" },
      	{ 0x80, "Options parameter"		       "|de|Optionsparameter" }
	}
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

VARIABLE phys_diag_data_2
{
	LABEL		"Data memory errors 2" "|de|Datenspeicherfehler 2";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
      	{ 0x01, "Diagnosis parameter" 			 "|de|Diagnoseparameter" }
	}
#ifdef _V510_
    STYLE "MULTILINE 12 1" ; /* x Zeilen hoch */
#endif
}

/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_ext_1_raw_4
{
	LABEL		"Enhanced Diagnosis 1" "|de|Erweiterte Diagnose 1";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (1)
	{
      { 0x01, "Air supply: Perhaps modified TEST"
              "|de|Zuluftdruck: Evtl. verndert TEST" },
      { 0x02, "Air supply: Perhaps not enough TEST"
              "|de|Zuluftdruck: Evtl. nicht ausreichend TEST" },
      { 0x04, "Air supply: Perhaps not enough"
              "|de|Zuluftdruck: Evtl. nicht ausreichend" },
      { 0x08, "Air supply: Working at full capacity"
              "|de|Zuluftdruck: Stark ausgelastet" },
      { 0x10, "Air supply: Working at full capacity TEST"
              "|de|Zuluftdruck: Stark ausgelastet TEST" },
      { 0x20, "Air supply: Perhaps modified"
              "|de|Zuluftdruck: Eventuell verndert" },

      { 0x40, "Spring: Perhaps spring stiffness reduced TEST"
              "|de|Antriebsfedern: Evtl. Federsteifigkeit red. TEST" },
      { 0x80, "Spring: Perhaps bias reduced TEST"
              "|de|Antriebsfedern: Evtl. Vorspannung reduziert TEST" }
	}

#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_1_4 	LIKE VARIABLE 	phys_diagnosis_ext_1_raw_4
{	}

/*----------------------------------------------------------------------------*/
VARIABLE phys_ext_2_raw_enh_diag_1
{
	LABEL		"Enhanced Diagnosis 2" "|de|Erweiterte Diagnose 2";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (2)
	{
        { 0x0100, "Spring: Perhaps bias increased TEST"
                  "|de|Antriebsfedern: Evtl. Vorspannung erhht TEST" },
        { 0x0200, "Spring: Working at full capacity"
                  "|de|Antriebsfedern: Stark ausgelastet" },
        { 0x0400, "Spring: Working at full capacity TEST"
                  "|de|Antriebsfedern: Stark ausgelastet TEST" },

        { 0x0800, "Trend range: Shifting working range to closing position"
                  "|de|Trend Stellbereich: Arbeitsbereichversch. Schliessstellung" },
        { 0x1000, "Trend range: Shifting working range to max. opening pos."
                  "|de|Trend Stellbereich: Arbeitsbereichversch. max. ffnung" },

        { 0x2000, "Friction: Much higher over whole range"
                  "|de|Reibung: ber ganzen Stellber. deutlich hher" },
        { 0x4000, "Friction: Much lower over whole range"
                  "|de|Reibung: ber ganzen Stellber. deutlich niedriger" },
        { 0x8000, "Friction: Much higher over section"
                  "|de|Reibung: ber Teilstellber. deutlich hher" },
        { 0x0001, "Friction: Much lower over section"
                  "|de|Reibung: ber Teilstellber. deutlich niedriger" },
        { 0x0002, "Friction: Much higher over whole range TEST"
                  "|de|Reibung: ber ganzen Stellber. deutlich hher TEST" },
        { 0x0004, "Friction: Much lower over whole range TEST"
                  "|de|Reibung: ber ganzen Stellber. deutlich niedriger TEST" },
        { 0x0008, "Friction: Much higher over section TEST"
                  "|de|Reibung: ber Teilbereich deutlich hher TEST" },
        { 0x0010, "Friction: Much lower over section TEST"
                  "|de|Reibung: ber Teilbereich deutlich niedriger TEST" },

        { 0x0020, "Leakage Pneumatics: Perhaps existing TEST"
                  "|de|Leckage Pneumatik: Evtl. vorhanden TEST" },
        { 0x0040, "Leakage Pneumatics: Perhaps existing"
                  "|de|Leckage Pneumatik: Evtl. vorhanden" },
        { 0x0080, "Leakage Pneumatics: Perhaps too large TEST"
                  "|de|Leckage Pneumatik: Evtl. zu gross TEST" }
  }

#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_2_0 	LIKE VARIABLE 	phys_ext_2_raw_enh_diag_1
{	}


/*----------------------------------------------------------------------------*/


VARIABLE phys_ext_2_raw_enh_diag_2
{
	LABEL		"Enhanced Diagnosis 3" "|de|Erweiterte Diagnose 3";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (2)
	{
        { 0x0100, "Leakage Pneumatics: Perhaps too large"
                 "|de|Leckage Pneumatik: Evtl. zu gross" },

        { 0x0200, "Limit range: Down"
                 "|de|Beschr. Stellbereich: Nach unten" },
        { 0x0400, "Limit range: Up"
                 "|de|Beschr. Stellbereich: Nach oben" },
        { 0x0800, "Limit range: Modification impossible"
                 "|de|Beschr. Stellb.: Keine nderung mehr mglich (Klemmen)" },

/*   	    { 0x1000, "Dynamic stress factor higher than 90%"
                  "|de|Dyn. Belastungsfaktor > 90%" },*/

        { 0x2000, "Inner leakage: Alarm limit 2 exceeded"
                 "|de|Innere Leckage: Alarmgrenze 2 berschritten" },
        { 0x4000, "Inner leakage: Alarm limit 3 exceeded"
                 "|de|Innere Leckage: Alarmgrenze 3 berschritten" },
        { 0x8000, "Inner leakage: perhaps present"
                 "|de|Innere Leckage: Eventuell vorhanden" },

        { 0x0001, "Ext. leakage: Perhaps soon expected"
                 "|de|Externe Leckage: Evtl. bald zu erwarten" },
        { 0x0002, "Ext. leakage: Perhaps existing"
                 "|de|Externe Leckage: Evtl. vorhanden" },
   	    { 0x0004, "Ext. leakage: existing"
                  "|de|Externe Leckage: vorhanden" },

        { 0x0008, "Trend end pos.: ZP-shift monotone down; aver. above ref."
                 "|de|Trend Endlage: NP-versch. monoton unten; MW ob. Ref.-geraden" },
        { 0x0010, "Trend end pos.: ZP-shift monotone up; aver. above ref."
                 "|de|Trend Endlage: NP-versch. monoton oben; MW ob. Ref.-geraden" },
        { 0x0020, "Trend end pos.: ZP-shift alternate; aver. above ref."
                 "|de|Trend Endlage: NP altern.; MW ob. Ref.-geraden" },
        { 0x0040, "Trend end pos.: ZP-shift monotone down; aver. under ref."
                 "|de|Trend Endlage: NP-versch. monoton unten; MW unt. Ref.-geraden" },
        { 0x0080, "Trend end pos.: ZP-shift monotone up; aver. under ref."
                 "|de|Trend Endlage: NP-versch. monoton oben; MW unt. Ref.-geraden" }
	}

#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_2_1 	LIKE VARIABLE 	phys_ext_2_raw_enh_diag_2
{	}

/*----------------------------------------------------------------------------*/

VARIABLE phys_ext_2_raw_enh_diag_3
{
	LABEL		"Enhanced Diagnosis 4" "|de|Erweiterte Diagnose 4";
    CLASS       DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE		BIT_ENUMERATED (2)
	{
        { 0x0100, "Trend end pos.: ZP-alternate; aver. under ref."
                 "|de|Trend Endlage: NP altern.; MW unt. Ref.-geraden" },

        { 0x0200, "Mech. conn. Pos./Valve: No opt. travel transm.TEST"
                 "|de|Mech. Verb. Regler/Ventil: Keine opt. Hubbertr. TEST" },
        { 0x0400, "Mech. conn. Pos./Valve: Perhaps loose"
                 "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh." },
        { 0x0800, "Mech. conn. Pos./Valve: Perhaps limit. range"
                 "|de|Mech. Verb. Regler/Ventil: Evtl. Einschr. Stellber." },
        { 0x1000, "Mech. conn. Pos./Valve: Perhaps loose TEST"
                 "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh. TEST" },

        { 0x2000, "Range: Mostly near closing pos."
                 "|de|Stellbereich: Vorwiegend nahe Schliessstellung" },
        { 0x4000, "Range: Mostly near max. opening"
                 "|de|Stellbereich: Vorwiegend nahe max. ffnung" },
        { 0x8000, "Range: Mostly closing position"
                 "|de|Stellbereich: Vorwiegend Schliessstellung" },
        { 0x0001, "Range: Mostly max. opening"
                 "|de|Stellbereich: Vorwiegend max. ffnung" },

        { 0x0002, "Temperature below -40C" "|de|Temperatur kleiner -40C" },
        { 0x0004, "Temperature above +80C" "|de|Temperatur grer +80C" },

   	    { 0x0008, "Reference test aborted"
                  "|de|Referenzlauf abgebrochen" },

        { 0x0010, "ESD: Movement actuator poss."
                 "|de|ESD: Bewegung Stellorgan mglich" },
        { 0x0020, "ESD: Movement actuator imposs."
                 "|de|ESD: Bewegung Stellorgan nicht mglich" },
        { 0x0040, "ESD: Error solenoid valve"
                 "|de|ESD: Magnetventil arbeitet nicht richtig" },

   	    { 0x0080, "not used"
                  "|de|nicht verwendet" }
  }

#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* x Zeilen hoch */
#endif
}

phys_diag_ext_2_2 	LIKE VARIABLE 	phys_ext_2_raw_enh_diag_3
{	}


/*----------------------------------------------------------------------------*/
VARIABLE phys_feature_select
{
    LABEL   "Feature select" "|de|Auswahl Zusatzfunktionen";
    CLASS   DEVICE;
    TYPE		BIT_ENUMERATED (1)
	  {
        DEFAULT_VALUE  0x01;
        { 0x01, "DIA_MAINTENANCE_ALARM sets DIAG_EXT bit"	
                "|de|DIA_MAINTENANCE_ALARM setzt DIAG_EXT Bit" },
        { 0x02, "Enable test function"
        	      "|de|Testfunktion freischalten" },
        { 0x04, "LO and active diagnosis function sets GOOD_FUNCTION_CHECK" 
                "|de|LO und aktive Diagnosefunktion setzt GOOD_FUNCTION_CHECK" },
      	{ 0x08, "DP standard diagnosis (6 Byte) during start-up" 
							  "|de|DP Standard Diagnose (6 Byte) whrend Start-Up Phase" },
        { 0x10, "Extended diagnosis suppression"
        	      "|de|Unterdrckung der erweiterten Diagnose Meldungen" }
/*      { 0x20, "not used" "|de|nicht verwendet" },
     	  { 0x40, "not used" "|de|nicht verwendet" },
        { 0x80, "not used" "|de|nicht verwendet" }*/
    }
    HANDLING    READ & WRITE;
    HELP "Activation 'Extended diagnosis suppression' only possible with firmware K1.16 or higher."
         "|de|Aktivierung 'Unterdrckung der erweiterten Diagnose Meldungen' nur ab Firmware K1.16 mglich.";

#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* 5 Zeilen hoch */
#endif
}


/*----------------------------------------------------------------------------*/
VARIABLE phys_testfunktion
{
    LABEL       "Simulation status messages" "|de|Simulation Statusmeldungen";
    CLASS       DEVICE;

  TYPE     ENUMERATED (2)
  {
    {   0x00, "No simulation" "|de|Keine Simulation" },
    {   0xA0, "Device not initialized" "|de|Gert nicht initialisiert" },
    {   0xA1, "Solenoid value active" "|de|Magnetventil aktiv" },
    {   0xA2, "Total valve travel exceeded" "|de|Wegintegral berschritten" },
    {   0xA3, "Control loop" "|de|Regelkreis" },
    {   0xA4, "Zero point" "|de|Nullpunkt" },
    {   0xA5, "Autocorrection" "|de|Autokorrektur" },
    {   0xA6, "Fatal error" "|de|Fataler Fehler" },
    {   0xA7, "Extended diagnosis" "|de|Erweiterte Diagnose" },
    {   0xA8, "x > range" "|de|x > Bereich" },
    {   0xA9, "Delta x < range" "|de|delta x < Bereich" },
    {   0xAA, "Attachment" "|de|Anbau" },
    {   0xAB, "Initialization time exceeded" "|de|Initialisierungszeit berschritten" },
    {   0xAC, "Initialization / solenoid valve" "|de|Initialisierung / Magnetventil" },
    {   0xAD, "Travel time too short" "|de|Laufzeit unterschritten" },
    {   0xAE, "Pin position" "|de|Stiftposition" },
    {   0xAF, "Test or calibration running" "|de|Test oder Kalibrierung luft" },
    {   0xB0, "x-signal" "|de|x-Signal" },
    {   0xB1, "i/p-converter" "|de|i/p Wandler" },
    {   0xB2, "Hardware" "|de|Hardware" },
    {   0xB3, "Control parameter" "|de|Regelparameter" },
    {   0xB4, "Poti parameter" "|de|Potiparameter" },
    {   0xB5, "Adjustment parameter" "|de|Abgleichparameter" },
    {   0xB6, "Internal device error 1" "|de|Interner Gertefehler 1" },
    {   0xB7, "General parameter" "|de|Allgemeine Parameter" },
    {   0xB8, "No emergency mode" "|de|Keine Notlaufeigenschaft" },
    {   0xB9, "Program load error" "|de|Programmladefehler" },
    {   0xBA, "Options parameter" "|de|Optionsparameter" },
    {   0xBB, "Info parameter" "|de|Info-Parameter" },
    {   0xBC, "Data memory" "|de|Datenspeicher" },
    {   0xBD, "Control calculation" "|de|Kontrollrechnung" },
    {   0xBE, "PA parameter" "|de|PA Parameter" },
    {   0xBF, "Diagnosis parameter" "|de|Diagnoseparameter" },
/*    {   0xC0, "Reset communication controller" "|de|Reset Kommunikations-Controller" },
    {   0xC1, "Reset communication HW interface" "|de|Reset Busanschaltung" },
    {   0xC2, "Binary input 2 deactivated" "|de|Bin Eingang 2 deaktiviert" },
    {   0xC3, "Reset application controller" "|de|Reset Anwendungs-Controller" },*/
    {   0xC4, "Air supply: Perhaps modified TEST" "|de|Zuluftdruck: Evtl. verndert TEST" },
    {   0xC5, "Air supply: Perhaps not enough TEST" "|de|Zuluftdruck: Evtl. nicht ausreichend TEST" },
    {   0xC6, "Air supply: Perhaps not enough" "|de|Zuluftdruck: Evtl. nicht ausreichend" },
    {   0xC7, "Air supply: Working at full capacity" "|de|Zuluftdruck: Stark ausgelastet" },
    {   0xC8, "Air supply: Working at full capacity TEST" "|de|Zuluftdruck: Stark ausgelastet TEST" },
    {   0xC9, "Air supply: Perhaps modified" "|de|Zuluftdruck: Evtl. verndert" },
    {   0xCA, "Actuator spring: Perhaps spring stiffness reduced TEST" "|de|Antriebsfedern: Evtl. Federsteifigkeit red. TEST" },
    {   0xCB, "Actuator spring: Perhaps bias reduced TEST" "|de|Antriebsfedern: Evtl. Vorspannung red. TEST" },
    {   0xCC, "Actuator spring: Perhaps bias increased TEST" "|de|Antriebsfedern: Evtl. Vorspannung erhht TEST" },
    {   0xCD, "Actuator spring: Working at full capacity" "|de|Antriebsfedern: Stark ausgelastet" },
    {   0xCE, "Actuator spring: Working at full capacity TEST" "|de|Antriebsfedern: Stark ausgelastet TEST" },
    {   0xCF, "Shifting working range to closing pos." "|de|Trend Stellbereich: Arbeitsbereichversch. Schliessstellung" },
    {   0xD0, "Shifting working range to max. openting pos." "|de|Trend Stellbereich: Arbeitsbereichversch. max. ffnung" },
    {   0xD1, "Friction: Much higher over hole range" "|de|Reibung: ber ganzen Stellber. deutlich hher" },
    {   0xD2, "Friction: Much lower over hole range" "|de|Reibung: ber ganzen Stellber. deutlich niedriger" },
    {   0xD3, "Friction: Much higher over section" "|de|Reibung: ber Teilstellber. deutlich hher" },
    {   0xD4, "Friction: Much lower over section" "|de|Reibung: ber Teilstellber. deutlich niedriger" },
    {   0xD5, "Friction: Much higher over hole range TEST" "|de|Reibung: ber ganzen Stellber. deutlich hher TEST" },
    {   0xD6, "Friction: Much lower over hole range TEST" "|de|Reibung: ber ganzen Stellber. deutlich niedriger TEST" },
    {   0xD7, "Friction: Much higher over selection TEST" "|de|Reibung: ber Teilbereich deutlich hher TEST" },
    {   0xD8, "Friction: Much lower over section TEST" "|de|Reibung: ber Teilbereich deutlich niedriger TEST" },
    {   0xD9, "Leakage pneumatic: Perhaps existing TEST" "|de|Leckage Pneumatik: Evtl. vorhanden TEST" },
    {   0xDA, "Leakage pneumatic: Perhaps existing" "|de|Leckage Pneumatik: Evtl. vorhanden" },
    {   0xDB, "Leakage pneumatic: Perhaps too large TEST" "|de|Leckage Pneumatik: Evtl. zu gross TEST" },
    {   0xDC, "Leakage pneumatic: Perhaps too large" "|de|Leckage Pneumatik: Evtl. zu gross" },
    {   0xDD, "Limit working range: Down" "|de|Beschrnkung Stellbereich: Nach unten" },
    {   0xDE, "Limit working range: Up" "|de|Beschrnkung Stellbereich: Nach oben" },
    {   0xDF, "Limit working range: Modification impossible" "|de|Beschrnkung Stellbereich: Keine nderung mehr mglich (Klemmen)" },
/*    {   0xE0, "Dynamic stress factor > 90 %" "|de|Dyn. Belastungsfaktor > 90%" },*/
    {   0xE1, "Inner leakage: Alarm limit 2 exceeded" "|de|Innere Leckage: Alarmgrenze 2 berschritten" },
    {   0xE2, "Inner leakage: Alarm limit 3 exceeded" "|de|Innere Leckage: Alarmgrenze 3 berschritten" },
    {   0xE3, "Inner leakage: Perhaps existing" "|de|Innere Leckage: Evtl. vorhanden" },
    {   0xE4, "External leakage: Perhaps soon expected" "|de|Externe Leckage: Evtl. bald zu erwarten" },
    {   0xE5, "External leakage: Perhaps existing" "|de|Externe Leckage: Evtl. vorhanden" },
    {   0xE6, "External leakage: Existing" "|de|Externe Leckage: vorhanden" },
    {   0xE7, "Obs. end pos.: ZP shift monotone down; aver. over ref." "|de|Trend Endlage: NP-Versch. monoton unten; MW ob. Ref.-geraden" },
    {   0xE8, "Obs. end pos.: ZP shift monotone up; aver. over ref" "|de|Trend Endlage: NP-Versch. monoton oben; MW ob. Ref.-geraden" },
    {   0xE9, "Obs. end pos.: ZP alternate; aver. over ref." "|de|Trend Endlage: NP altern.; MW ob. Ref.-geraden" },
    {   0xEA, "Obs. end pos.: ZP shift monotone down; aver. under ref." "|de|Trend Endlage: NP-Versch. monoton unten; MW unt. Ref.-geraden" },
    {   0xEB, "Obs. end pos.: ZP shift monotone up; aver. under ref." "|de|Trend Endlage: NP-Versch. monoton oben; MW unt. Ref.-geraden" },
    {   0xEC, "Obs. end pos.: ZP alternate; aver. under ref." "|de|Trend Endlage: NP altern.; MW unt. Ref.-geraden" },
    {   0xED, "Conn. pos./valve: No opt. travel transm. TEST" "|de|Mech. Verb. Regler/Ventil: Keine opt. Hubbertr. TEST" },
    {   0xEE, "Conn. pos./valve: Perhaps loose" "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh." },
    {   0xEF, "Conn. pos./valve: Perhaps range limit" "|de|Mech. Verb. Regler/Ventil: Evtl. Einschrnkung Stellbereich" },
/*    {   0xF0, "Conn. pos./valve: Perhaps loose TEST" "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorhanden TEST" },*/
    {   0xF1, "Working range: Mostly near closing position" "|de|Stellbereich: Vorwiegend nahe Schliessstellung" },
    {   0xF2, "Working range: Mostly near max. opening" "|de|Stellbereich: Vorwiegend nahe max. ffnung" },
    {   0xF3, "Working range: Mostly closing position" "|de|Stellbereich: Vorwiegend Schliessstellung" },
    {   0xF4, "Working range: Mostly max. opening" "|de|Stellbereich: Vorwiegend max. ffnung" },
    {   0xF5, "Temperature below -40C" "|de|Temperatur kleiner -40C" },
    {   0xF6, "Temperature above +80C" "|de|Temperatur grsser +80C" },
    {   0xF7, "Reference test aborted" "|de|Referenzlauf abgebrochen" },
    {   0xF8, "ESD: Movement actuator possible" "|de|ESD: Bewegung Stellorgan mglich" },
    {   0xF9, "ESD: Movement actuator impossible" "|de|ESD: Bewegung Stellorgan nicht mglich" },
    {   0xFA, "ESD: Solenoid valve is not working" "|de|ESD: Magnetventil arbeitet nicht richtig" }
 }

    HANDLING    READ & WRITE;

    POST_EDIT_ACTIONS
    {
        warning_simulate_status    /* Methode (Warnmeldung) */
    }
}

/*----------------------------------------------------------------------------*/
METHOD warning_simulate_status    /* Warnung bei 'Simulation Statusmeldungen' */
{
    LABEL       "Simulation status messages" "|de|Simulation Statusmeldungen";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ACKNOWLEDGE("Warning: status messages were simulated !\n"
                    "Switch off the simulation after the test !"
                    "|de|Warnung: Es werden Statusmeldungen simuliert !\n"
                    "Nach dem Test die Simulation wieder abschalten !");
    }
}


/*----------------------------------------------------------------------------*/
VARIABLE phys_device_dp_status
{
    LABEL      "DP status" "|de|DP Status";
    CLASS       DEVICE & DYNAMIC;
    TYPE		BIT_ENUMERATED (1)
	  {
       /* { 0x00, "Ungltige Konfiguration"	"|de|Ungltige Konfiguration"			   },*/
        { 0x01, "Valid CFG-telegr. received"     "|de|Gltiges CFG-Telegr. erhalten" },
        { 0x02, "Valid PRM-telegr. received"     "|de|Gltiges PRM-Telegr. erhalten" },
        { 0x04, "Device in cyclic data exchange" "|de|Gert im zykl. Datenaustausch" }
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 3" ; /* x Zeilen hoch */
#endif
}


/*----------------------------------------------------------------------------*/

VARIABLE phys_dl_trigger_select_bin
{
    LABEL       "Selection binary input for trigger start"
                "|de|Auswahl Binreingang fr Triggerstart";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, "Binary Input 1" "|de|Binreingang 1" },
        { 1, "Binary Input 2" "|de|Binreingang 2" }
    }
    HANDLING    READ & WRITE;        

    HELP     "Selection of the binary input for the trigger start via binary input."
             "|de|Auswahl des Binreinganges fr den Triggerstart ber Binreingang.";
}




/*----------------------------------------------------------------------------*/
/* Physical Block                                                             */
/*----------------------------------------------------------------------------*/
COMMAND read_phys_blk
{
    SLOT 0;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_blk_reserve, phys_blk_object, phys_blk_parent_class, phys_blk_class,
            phys_blk_dd_reference, phys_blk_dd_rev, phys_blk_profile, phys_blk_profile_rev,
            phys_blk_execution_time, blk_num_parameters, phys_blk_index_view_1,
            phys_blk_num_view_lists
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_st_rev
{
    SLOT 0;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_st_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_tag_desc
{
    SLOT 0;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_tag_desc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_tag_desc
{
    SLOT 0;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_tag_desc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_strategy
{
    SLOT 0;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_strategy
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_strategy
{
    SLOT 0;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_strategy
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_alert_key
{
    SLOT 0;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_alert_key
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_alert_key
{
    SLOT 0;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_alert_key
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_target_mode
{
    SLOT 0;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_target_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_target_mode
{
    SLOT 0;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_target_mode
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_mode
{
    SLOT 0;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             phys_actual_mode, phys_permitted_mode, phys_normal_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_alarm
{
    SLOT 0;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_current_state_alarm_sum, phys_unacknowledged_state_alarm_sum,
            phys_unreported_state_alarm_sum, phys_disabled_state_alarm_sum
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_software_rev
{
    SLOT 0;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_software_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_hardware_rev
{
    SLOT 0;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_hardware_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
 COMMAND read_phys_device_man_id
 {
    SLOT 0;
    INDEX 26;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {

        }
        REPLY
        {
            phys_device_man_id
        }
    }
 }
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_id
{
    SLOT 0;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_id
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_serial_num
{
    SLOT 0;
    INDEX 28;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_serial_num
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis
{
    SLOT 0;
    INDEX 29;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis
        }
    }
}


/*----------------------------------------------------------------------------*/
/* kmr: alte Stati:
COMMAND read_phys_diagnosis_ext_1
{
    SLOT 0;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diag_ext_1_0,
            phys_diag_ext_1_1,
            phys_diag_ext_1_2 <0x070000>,
            phys_diag_ext_1_3 <0xF8FFFF>,
            phys_diag_ext_1_4
        }
    }
}*/

COMMAND read_phys_diagnosis_ext_1
{
    SLOT 0;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diag_ext_1_0,
            phys_diag_ext_1_1,
            dummy_byte,
            phys_diag_ext_1_3, /* nur 'Diagnoseparameter' interessant */
            dummy_byte,
            phys_diag_ext_1_4
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_diag_operation
{
    SLOT 0;
    INDEX 127;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           phys_diag_operation
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_diag_init_1
{
    SLOT 0;
    INDEX 128;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           phys_diag_init_1
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_phys_diag_init_2
{
    SLOT 0;
    INDEX 129;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           phys_diag_init_2
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_phys_diag_hw
{
    SLOT 0;
    INDEX 130;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           phys_diag_hw
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_diag_data_1
{
    SLOT 0;
    INDEX 131;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           phys_diag_data_1
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_diag_data_2
{
    SLOT 0;
    INDEX 132;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           phys_diag_data_2
        }
    }
}



/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_mask
{
    SLOT 0;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_mask
        }
    }
}

#ifdef XXX /* wird nicht vom Geraet verwendet */
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_extension_mask
{
    SLOT 0;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_extension_mask
        }
    }
}
#endif

/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_certification
{
    SLOT 0;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_certification
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_certification
{
    SLOT 0;
    INDEX 33;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_device_certification
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_write_locking
{
    SLOT 0;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_write_locking
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_write_locking
{
    SLOT 0;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_write_locking
        }
        REPLY
        {

        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_factory_reset
{
    SLOT 0;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
        		phys_factory_reset
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_factory_reset
{
    SLOT 0;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_factory_reset
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_descriptor
{
    SLOT 0;
    INDEX 36;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_descriptor
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_descriptor
{
    SLOT 0;
    INDEX 36;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_descriptor
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_message
{
    SLOT 0;
    INDEX 37;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_device_message
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_message
{
    SLOT 0;
    INDEX 37;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_message
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_instal_date
{
    SLOT 0;
    INDEX 38;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_instal_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_instal_date
{
    SLOT 0;
    INDEX 38;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_device_instal_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_local_operation_enable
{
    SLOT 0;
    INDEX 39;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {

            phys_local_operation_enable
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_local_operation_enable
{
    SLOT 0;
    INDEX 39;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
         phys_local_operation_enable
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_number_selector
{
    SLOT 0;
    INDEX 40;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
         phys_ident_number_selector
        }
    }
}



/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_number_selector
{
    SLOT 0;
    INDEX 40;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
         phys_ident_number_selector
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_hw_write_protection
{
    SLOT 0;
    INDEX 41;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {

        }
        REPLY
        {
         phys_hw_write_protection
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_phys_feature
{
    SLOT 0;
    INDEX 42;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_feature_supported,
            dummy_byte,
            dummy_byte,
            dummy_byte,
            phys_feature_enabled,
            dummy_byte,
            dummy_byte,
            dummy_byte
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_phys_cond_status_diag
{
    SLOT 0;
    INDEX 43;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_cond_status_diag
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_cond_status_diag
{
    SLOT 0;
    INDEX 43;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_cond_status_diag
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_phys_diag_event_switch
{
    SLOT 0;
    INDEX 44;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diag_event_switch__Diag_Status_Link_1_0_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_0_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_1_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_1_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_2_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_2_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_3_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_3_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_4_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_4_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_5_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_5_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_6_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_6_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_7_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_7_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_8_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_8_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_9_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_9_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_10_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_10_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_11_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_11_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_12_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_12_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_13_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_13_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_14_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_14_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_15_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_15_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_16_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_16_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_17_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_17_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_18_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_18_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_19_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_19_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_20_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_20_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_21_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_21_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_22_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_22_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_23_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_23_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_24_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_24_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_25_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_25_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_26_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_26_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_27_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_27_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_28_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_28_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_29_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_29_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_30_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_30_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_31_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_31_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_32_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_32_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_33_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_33_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_34_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_34_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_35_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_35_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_36_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_36_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_37_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_37_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_38_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_38_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_39_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_39_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_40_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_40_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_41_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_41_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_42_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_42_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_43_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_43_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_44_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_44_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_45_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_45_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_46_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_46_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_47_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_47_S  <0x0F>,
            phys_diag_event_switch__Slot,
            phys_diag_event_switch__Index
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_diag_event_switch
{
    SLOT 0;
    INDEX 44;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_diag_event_switch__Diag_Status_Link_1_0_D  <0xF0>,
			phys_diag_event_switch__Diag_Status_Link_1_0_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_1_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_1_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_2_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_2_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_3_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_3_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_4_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_4_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_5_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_5_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_6_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_6_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_7_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_7_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_8_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_8_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_9_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_9_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_10_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_10_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_11_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_11_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_12_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_12_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_13_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_13_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_14_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_14_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_15_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_15_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_16_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_16_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_17_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_17_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_18_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_18_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_19_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_19_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_20_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_20_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_21_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_21_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_22_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_22_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_23_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_23_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_24_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_24_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_25_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_25_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_26_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_26_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_27_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_27_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_28_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_28_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_29_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_29_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_30_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_30_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_31_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_31_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_32_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_32_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_33_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_33_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_34_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_34_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_35_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_35_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_36_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_36_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_37_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_37_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_38_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_38_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_39_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_39_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_40_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_40_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_41_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_41_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_42_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_42_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_43_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_43_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_44_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_44_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_45_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_45_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_46_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_46_S  <0x0F>,
            phys_diag_event_switch__Diag_Status_Link_1_47_D  <0xF0>,
            phys_diag_event_switch__Diag_Status_Link_1_47_S  <0x0F>,
            phys_diag_event_switch__Slot,
            phys_diag_event_switch__Index
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_options
{
    SLOT 0;
    INDEX 49;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ident_options
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_limit_switches
{
    SLOT 0;
    INDEX 50;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ident_limit_switches
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_limit_switches
{
    SLOT 0;
    INDEX 50;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_ident_limit_switches
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_phys_device_product_num
{
    SLOT 0;
    INDEX 51;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_product_num
        }
    }
}
/*----------------------------------------------------------------------------*/

COMMAND read_phys_text_input_1
{
    SLOT 0;
    INDEX 52;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_1
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_1
{
    SLOT 0;
    INDEX 52;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_1
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/

COMMAND read_phys_text_input_2
{
    SLOT 0;
    INDEX 53;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_2
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_2
{
    SLOT 0;
    INDEX 53;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_2
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_phys_text_input_3
{
    SLOT 0;
    INDEX 54;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_3
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_3
{
    SLOT 0;
    INDEX 54;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_3
        }
        REPLY
        {
        }
    }
}


/*----------------------------------------------------------------------------*/

COMMAND read_phys_text_input_4
{
    SLOT 0;
    INDEX 55;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_4
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_4
{
    SLOT 0;
    INDEX 55;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_4
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_phys_text_input_5
{
    SLOT 0;
    INDEX 56;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_5
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_5
{
    SLOT 0;
    INDEX 56;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_5
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_production_id
{
    SLOT 0;
    INDEX 57;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_production_id
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_production_id
{
    SLOT 0;
    INDEX 57;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_production_id
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_reading_direction
{
    SLOT 0;
    INDEX 58;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_reading_direction
        }
    }
}



/*----------------------------------------------------------------------------*/
COMMAND write_phys_reading_direction
{
    SLOT 0;
    INDEX 58;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_reading_direction
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_config_binary_input_2
{
    SLOT 0;
    INDEX 59;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_config_binary_input_2
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_config_binary_input_2
{
    SLOT 0;
    INDEX 59;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_config_binary_input_2
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_ext_2
{
    SLOT 0;
    INDEX 60;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diag_ext_2_0,
            phys_diag_ext_2_1,
            phys_diag_ext_2_2
        }
    }
}

COMMAND read_phys_diag_event_switch_2
{
    SLOT 0;
    INDEX 61;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            /* Friction */
            phys_diag_event_switch_2__Diag_Status_Link_2_0_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_0_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_1_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_1_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_2_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_2_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_3_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_3_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_4_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_4_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_5_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_5_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_6_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_6_S <0x0F>,
            /* Leakage pneumatic */
            phys_diag_event_switch_2__Diag_Status_Link_2_7_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_7_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_8_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_8_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_9_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_9_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_10_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_10_S <0x0F>,
            /* Limit working range */
            phys_diag_event_switch_2__Diag_Status_Link_2_11_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_11_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_12_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_12_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_13_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_13_S <0x0F>,
            /* Dynamic stress factor */
            phys_diag_event_switch_2__Diag_Status_Link_2_14_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_14_S <0x0F>,
            /* Inner leakage */
            phys_diag_event_switch_2__Diag_Status_Link_2_15_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_15_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_16_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_16_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_17_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_17_S <0x0F>,
            /* External leakage */
            phys_diag_event_switch_2__Diag_Status_Link_2_18_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_18_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_19_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_19_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_20_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_20_S <0x0F>,
            /* Observing end position */
            phys_diag_event_switch_2__Diag_Status_Link_2_21_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_21_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_22_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_22_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_23_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_23_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_24_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_24_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_25_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_25_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_26_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_26_S <0x0F>,
            /* Connection positioner valve */
            phys_diag_event_switch_2__Diag_Status_Link_2_27_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_27_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_28_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_28_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_29_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_29_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_30_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_30_S <0x0F>,
            /* Working range */
            phys_diag_event_switch_2__Diag_Status_Link_2_31_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_31_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_32_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_32_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_33_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_33_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_34_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_34_S <0x0F>,
            /* Temperature */
            phys_diag_event_switch_2__Diag_Status_Link_2_35_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_35_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_36_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_36_S <0x0F>,
            /* Reference test aborted */
            phys_diag_event_switch_2__Diag_Status_Link_2_37_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_37_S <0x0F>,
            /* ESD */
            phys_diag_event_switch_2__Diag_Status_Link_2_38_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_38_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_39_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_39_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_40_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_40_S <0x0F>,

            /* PA Parameter */
            phys_diag_event_switch_2__Diag_Status_Link_2_41_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_41_S  <0x0F>,

            /* DIAG Parameter */
            phys_diag_event_switch_2__Diag_Status_Link_2_42_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_42_S  <0x0F>,

            /* ab hier nicht benutzte Parameter */
            phys_diag_event_switch_2__Diag_Status_Link_2_43_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_43_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_44_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_44_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_45_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_45_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_46_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_46_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_47_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_47_S  <0x0F>,

            /* Slot und Index fuer den naechsten Diag_Event_Switch */
            phys_diag_event_switch_2__Slot,
            phys_diag_event_switch_2__Index

        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_diag_event_switch_2
{
    SLOT 0;
    INDEX 61;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            /* Friction */
            phys_diag_event_switch_2__Diag_Status_Link_2_0_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_0_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_1_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_1_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_2_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_2_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_3_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_3_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_4_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_4_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_5_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_5_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_6_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_6_S <0x0F>,
            /* Leakage pneumatic */
            phys_diag_event_switch_2__Diag_Status_Link_2_7_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_7_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_8_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_8_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_9_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_9_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_10_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_10_S <0x0F>,
            /* Limit working range */
            phys_diag_event_switch_2__Diag_Status_Link_2_11_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_11_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_12_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_12_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_13_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_13_S <0x0F>,
            /* Dynamic stress factor */
            phys_diag_event_switch_2__Diag_Status_Link_2_14_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_14_S <0x0F>,
            /* Inner leakage */
            phys_diag_event_switch_2__Diag_Status_Link_2_15_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_15_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_16_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_16_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_17_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_17_S <0x0F>,
            /* External leakage */
            phys_diag_event_switch_2__Diag_Status_Link_2_18_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_18_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_19_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_19_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_20_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_20_S <0x0F>,
            /* Observing end position */
            phys_diag_event_switch_2__Diag_Status_Link_2_21_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_21_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_22_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_22_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_23_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_23_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_24_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_24_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_25_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_25_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_26_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_26_S <0x0F>,
            /* Connection positioner valve */
            phys_diag_event_switch_2__Diag_Status_Link_2_27_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_27_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_28_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_28_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_29_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_29_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_30_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_30_S <0x0F>,
            /* Working range */
            phys_diag_event_switch_2__Diag_Status_Link_2_31_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_31_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_32_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_32_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_33_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_33_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_34_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_34_S <0x0F>,
            /* Temperature */
            phys_diag_event_switch_2__Diag_Status_Link_2_35_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_35_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_36_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_36_S <0x0F>,
            /* Reference test aborted */
            phys_diag_event_switch_2__Diag_Status_Link_2_37_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_37_S <0x0F>,
            /* ESD */
            phys_diag_event_switch_2__Diag_Status_Link_2_38_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_38_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_39_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_39_S <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_40_D <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_40_S <0x0F>,

            /* PA Parameter */
            phys_diag_event_switch_2__Diag_Status_Link_2_41_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_41_S  <0x0F>,

            /* DIAG Parameter */
            phys_diag_event_switch_2__Diag_Status_Link_2_42_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_42_S  <0x0F>,

            /* ab hier nicht benutzte Parameter */
            phys_diag_event_switch_2__Diag_Status_Link_2_43_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_43_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_44_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_44_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_45_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_45_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_46_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_46_S  <0x0F>,
            phys_diag_event_switch_2__Diag_Status_Link_2_47_D  <0xF0>,
            phys_diag_event_switch_2__Diag_Status_Link_2_47_S  <0x0F>,

            /* Slot und Index fuer den naechsten Diag_Event_Switch */
            phys_diag_event_switch_2__Slot,
            phys_diag_event_switch_2__Index
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_ext_1_raw
{
    SLOT 0;
    INDEX 62;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_ext_1_raw_0,
            phys_diagnosis_ext_1_raw_1,
            phys_diagnosis_ext_1_raw_2 <0x070000>,
            phys_diagnosis_ext_1_raw_3 <0xF8FFFF>,
            phys_diagnosis_ext_1_raw_4
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_ext_2_raw
{
    SLOT 0;
    INDEX 63;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ext_2_raw_enh_diag_1,
            phys_ext_2_raw_enh_diag_2,
            phys_ext_2_raw_enh_diag_3
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_feature_select
{
    SLOT 0;
    INDEX 64;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_feature_select
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_phys_feature_select
{
    SLOT 0;
    INDEX 64;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
					 phys_feature_select
        }
        REPLY
        {
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_phys_testfunktion
{
    SLOT 0;
    INDEX 65;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_testfunktion
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND write_phys_testfunktion
{
    SLOT 0;
    INDEX 65;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
					 phys_testfunktion
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_dp_status
{
    SLOT 0;
    INDEX 126;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_dp_status
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_condensed_state
{
    SLOT 0;
    INDEX 133;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_condensed_state
        }
    }
}



/*----------------------------------------------------------------------------*/
COMMAND read_phys_dl_trigger_select_bin
{
    SLOT 0;
    INDEX 136;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_dl_trigger_select_bin
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND write_phys_dl_trigger_select_bin
{
    SLOT 0;
    INDEX 136;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
          phys_dl_trigger_select_bin
        }
        REPLY
        {
            
        }
    }
}
