/******************************************************************************/
/* Device Description for SAMSON Positioner 3730-6 HART capable               */
/******************************************************************************/
/* SAMSON AG - MESS- UND REGELTECHNIK                                         */
/* Weismllerstrae 3 - 60314 Frankfurt am Main - Germany                     */
/* Phone: +49 69 4009-0 - Fax: +49 69 4009-1507                               */
/* E-mail: samson@samson.de - Internet: www.samson.de                         */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2010). All Rights Reserved                       */
/* Device:        SAMSON Positioner 3730-6 HART capable Dev Rev 1             */
/******************************************************************************/
/* Author: Thomas Kraemer / E82                                               */
/* File:   SAHA_373X_6_r1d1.ddl                                               */
/******************************************************************************/
/* Date:      Author: Comments:                                               */
/* -----      ------- ---------                                               */
/* 18.02.2010 Kmr/E82 DD Version 1.1.001 beta (xx.xx.2010):                   */
/*                    Beta Version der DD.                                    */
/* 14.02.2011 Kmr/E82 1.1.001: erste offizielle Version der DD.               */
/* 15.04.2011 Kmr/E82 1.1.003: - Kv Kennlinie unsichtbar gemacht.             */
/*                             - viele Textnderungen deutsch und englisch    */
/*                             - Grafikdaten in AMS Mens eingefgt (Export)  */
/*                             - SIL-Tests Code 86 nicht mehr rcksetzbar     */
/*                             - Protokollierungstext 13000 gendert          */
/*                             - Para Zertifizierung 30333 und Varianten-ID   */
/*                               100112 aus Men entfernt                     */
/*                             - Protokollierungseintrag 13101 ergnzt        */
/*                             - cmd 50/51 wg. HCF Zert. nicht redefiniert    */
/* 18.04.2011 Kmr/E82 1.1.004: - die 4 dyn. HART Variablen aus Men entfernt. */
/* 25.05.2011 Kmr/E82 1.1.005: - Bereiche der 3 Isentropenexponenten gendert.*/
/*                             - Labelnderung Parameter:                     */
/*                               startbed_erm_federbereich_gr_0_8bar          */
/*                               startbed_erm_federbereichsanfang_gr_0_4bar   */
/*                             - Einheiten der 3 Austrittsgeschwindigkeiten   */
/*                               jetzt abhngig vom Mediumszustand            */
/*                             - Parameter belegter_ausgang_umkehrverstaerker */
/*                               Text in combobox gendert                    */
/*                             - Label startbed_kl_kegel gendert             */
/*                             - Hilfetext Parameter empfindlichkeit gendert */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

MANUFACTURER           66,   /* (66  = 42 hex) SAMSON AG, Frankfurt, Germany  */
DEVICE_TYPE           238,   /* (238 = EE hex) Positioner 3730-6 HART capable */
DEVICE_REVISION         1,   /* Device Revision 1 (3730-6 FW 1.00) */
DD_REVISION             1    /* Device Description Revision 1 */

/*****************************************************************************/
/* fr Methode method_PDM_StandardDiagnosis: */
#define PDM_DIAG_FAULT                0x0001
#define PDM_DIAG_MAINT_REQUIRED       0x0002
#define PDM_DIAG_MAINT_RECOMMENDED    0x0004
#define PDM_DIAG_PROCESS_ERROR				0x0010
#define PDM_DIAG_CONFIG_ERROR				  0x0020
#define PDM_DIAG_SIMULATION					  0x0040
#define PDM_DIAG_GOOD						      0x0008
/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS   0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS                0xFFF7  /* Lsche GOOD */
/*****************************************************************************/

/* fr Methode methodOpenDeviceManual_3730: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3730 "e83846en.pdf"        \
                                    "|de|e83846de.pdf"

/* fr Methode methodOpenValveDiagnostics: Ventildiagnose fr FW 1.00 Doku im pdf-Format */
#define VALVE_DIAGNOSTICS_FILENAME "e83891en.pdf"         \
                                   "|de|e83891de.pdf"

//*****************************************************************************

#include "macros.h"
#include "methods.h"

// PDM Diagnose:
#include "Diagnosis.inc"

#ifdef AMS_APPLICATION
  #undef AMS_APPLICATION
#endif

#define LABEL_DE_EN                // wenn deutsche UND englische Labels erwnscht
#define HELP_DE_EN                 // wenn deutsche UND englische Hilfetexte der normalen Parameter erwnscht
#define HELP_EP_DE_EN              // wenn deutsche UND englische Hilfetexte der EXPERTplus Parameter erwnscht
#define fuer_siemens_pdm           // DD is for PDM
#define WITH_CONSTANT_UNIT_DEPEND  // depends from used Tokenizer

#define pst_stepresponse          // wenn PST-Grafik erwnscht
#define mit_pst_e_graph           // wenn PST e-Grafik erwnscht
#define mit_deadband_d3_graph     // wenn Tote Zone Stellgert Grafik erwnscht
#define mit_endlagenverlauf_graph // wenn Endlagenverlauf Grafik erwnscht
#define fst_stepresponse          // wenn FST-Grafik erwnscht
#define mit_fst_e_graph           // wenn FST e-Grafik erwnscht

#define mit_ventilsignatur_zuluftdruckverlauf_graph // wenn Ventilsignatur-Zuluftdruckverlauf Grafik erwnscht
#define mit_leckagesensor_kz_und_pegel_graph        // wenn Leckagesensor-Kurzzeitbeob. / Pegel Grafiken erwnscht
#define mit_datenlogger_graph                       // wenn Datenlogger Grafik erwnscht
#define mit_leckagesensor_referenz_d8_d9_graph      // wenn Referenzkurven-Leckagesensor-H./P.-referenz D8 und D9 Grafiken erwnscht
#define mit_hist_x_und_z_kz_graph                   // wenn Histogramm x und z Kurzzeit Grafiken erwnscht

#include "42EE01_defines.dd"
#include "42EE01_imports.dd"
#include "42EE01_enh_menu.dd"
#include "42EE01_para_1.dd"
#include "42EE01_para_2.dd"
#include "42EE01_para_3.dd"
#include "42EE01_commands.dd"
#include "42EE01_methods.dd"
#include "42EE01_graph_2.dd"
#ifdef mit_datenlogger_graph
  #include "42EE01_datalogger.dd"
#endif
#ifdef pst_stepresponse
  #include "42EE01_pst_d4.dd"
#endif
#ifdef fst_stepresponse
  #include "42EE01_fst_d6.dd"
#endif
#ifdef mit_deadband_d3_graph
  #include "42EE01_deadband_d3.dd"
#endif


//METHOD method_PDM_StandardDiagnosis
METHOD method_PDM_DeviceDiagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {
        int i_stat_0, i_stat_1, i_stat_2, i_stat_3, i_stat_4, i_stat_5, i_stat_6, i_stat_7, i_stat_8;
        int akt_BA, dev_status;
        int i_no_good; /* Merker zum Lschen anderer Stati */
        int sammelstatus;

    		methods_at_begin_of_user_method

        send_command(48);     /* Status einlesen */
        /* Status zuweisen */
        i_stat_0 = int_value(xmtr_specific_status_0);
        i_stat_1 = int_value(xmtr_specific_status_1);
        i_stat_2 = int_value(xmtr_specific_status_2);
        i_stat_3 = int_value(xmtr_specific_status_3);
        i_stat_4 = int_value(xmtr_specific_status_4);
        i_stat_5 = int_value(xmtr_specific_status_5);
        i_stat_6 = int_value(xmtr_specific_status_6);
        i_stat_7 = int_value(xmtr_specific_status_7);
        i_stat_8 = int_value(xmtr_specific_status_8);
        sammelstatus = ivar_value (namur_sammelstatus);  /* NAMUR Sammelstatus kopieren */
        dev_status = ivar_value (device_status);         /* Gertezustand kopieren */

        /* Parameter vorbelegen: */
    		PDM_Diag_Status_Diagnosis = 0;     /* NAMUR-Icon */
		    PDM_Diag_Rule_Message     = "";    /* Diagnose Meldung */
    		i_no_good = 0;                     /* unten setzen wenn in Methode PDM_Diag_Status_Diagnosis
                                              neu gesetzt wird */
        send_command(136); /* akt. Betriebsart auslesen */
        akt_BA = VARID(akt_betriebsart);

        /*----------------------------------------------*/
        /* Auswertung der eingelesenen Statusparameter: */
        /*----------------------------------------------*/
        /* wenn Hand aktiv: */
        if ((akt_BA == AKT_BA_HAND_IP)  ||
            (akt_BA == AKT_BA_HAND_W )  ||
            (akt_BA == AKT_BA_HAND_W_STEUERUNG ))
        {
    			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MODE_LOCAL_OVERRIDE;
		    	PDM_Diag_Rule_Message += "Manual mode active;"
			                             "|de|Betriebsart Hand aktiv;";
          i_no_good += 1; /* good lschen */
        }

    /*---------------------------------------------*/
    /* device_status (Gertezustand)               */
    /*---------------------------------------------*/
		if( dev_status & 0x40 )
		{
			PDM_Diag_Rule_Message += [configuration_changed] + ";";
		}

		if( dev_status & 0x80 )
		{
			PDM_Diag_Rule_Message += [device_malfunction] + ";";
		}

		if( dev_status & 0x10 )
		{
			PDM_Diag_Rule_Message += [more_status_available] + ";";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_0 (Fehlercodes Byte 0) */
    /*---------------------------------------------*/
		if( i_stat_0 & 0x01 )
		{   /* Code 50 */
			PDM_Diag_Rule_Message += "x > range;" "|de|x > Bereich;";
		}

		if( i_stat_0 & 0x02 )
		{   /* Code 51 */
			PDM_Diag_Rule_Message += "Delta x < range;" "|de|Delta x < Bereich;";
		}

		if( i_stat_0 & 0x04 )
		{   /* Code 52 */
			PDM_Diag_Rule_Message += "Attachment;" "|de|Anbau;";
		}

		if( i_stat_0 & 0x08 )
		{   /* Code 53 */
			PDM_Diag_Rule_Message += "Initialization time exceeded;"
			                         "|de|Initialisierungszeit berschritten;";
		}

		if( i_stat_0 & 0x10 )
		{   /* Code 54 */
			PDM_Diag_Rule_Message += "Initialization/int. solenoid valve/forced venting;"
			                         "|de|Initialisierung/int. MGV/ZWE;";
		}

		if( i_stat_0 & 0x20 )
		{   /* Code 55 */
			PDM_Diag_Rule_Message += "Transit time not reached;"
			                         "|de|Laufzeit unterschritten;";
		}

		if( i_stat_0 & 0x40 )
		{   /* Code 56 */
			PDM_Diag_Rule_Message += "Pin position;" "|de|Stiftposition;";
		}

		if( i_stat_0 & 0x80 )
		{   /* Code 57 */
			PDM_Diag_Rule_Message += "Control loop;" "|de|Regelkreis;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_1 (Fehlercodes Byte 1) */
    /*---------------------------------------------*/
		if( i_stat_1 & 0x01 )
		{   /* Code 58 */
			PDM_Diag_Rule_Message += "Zero point;" "|de|Nullpunkt;";
		}

		if( i_stat_1 & 0x02 )
		{   /* Code 59 */
			PDM_Diag_Rule_Message += "Inkonsistenter Datenspeicher;" "|de|Inkonsistenter Datenspeicher;";
		}

		if( i_stat_1 & 0x04 )
		{   /* Code 60 */
			PDM_Diag_Rule_Message += "Internal device error;" "|de|Interner Gertefehler;";
		}

		if( i_stat_1 & 0x10 )
		{   /* Code 62 */
			PDM_Diag_Rule_Message += "x-signal;" "|de|x-Signal;";
		}

		if( i_stat_1 & 0x20 )
		{   /* Code 63 */
			PDM_Diag_Rule_Message += "W too low;" "|de|W zu klein;";
		}

		if( i_stat_1 & 0x40 )
		{   /* Code 64 */
			PDM_Diag_Rule_Message += "i/p-converter;" "|de|i/p-Wandler;";
		}

		if( i_stat_1 & 0x80 )
		{   /* Code 65 */
			PDM_Diag_Rule_Message += "Hardware;" "|de|Hardware;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_2 (Fehlercodes Byte 2) */
    /*---------------------------------------------*/
		if( i_stat_2 & 0x01 )
		{   /* Code 67 */
			PDM_Diag_Rule_Message += "Check calculation;" "|de|Kontrollrechnung;";
		}

		if( i_stat_2 & 0x02 )
		{   /* Code 72 */
			PDM_Diag_Rule_Message += "Pressure sensor;" "|de|Drucksensor;";
		}

		if( i_stat_2 & 0x04 )
		{   /* Code 76 */
			PDM_Diag_Rule_Message += "No emergency mode;" "|de|Keine Notlaufeigenschaft;";
		}

		if( i_stat_2 & 0x08 )
		{   /* Code 81 */
			PDM_Diag_Rule_Message += "Valve signature canceled;" "|de|Ventilsignatur abgebrochen;";
		}

		if( i_stat_2 & 0x10 )
		{   /* Code 84 */
			PDM_Diag_Rule_Message += "Status PST/FST;" "|de|Status PST/FST;";
		}

		if( i_stat_2 & 0x20 )
		{   /* Code 85 */
			PDM_Diag_Rule_Message += "Status on/off valve;" "|de|Status Auf/Zu-Ventil;";
		}

		if( i_stat_2 & 0x40 )
		{   /* Code 86 */
			PDM_Diag_Rule_Message += "SIL-Tests;" "|de|SIL-Tests;";
		}

		if( i_stat_2 & 0x80 )
		{   /* Code 79 */
			PDM_Diag_Rule_Message += "Collected error;" "|de|Sammelfehler;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_3 (Fehlercodes Byte 3) */
    /*---------------------------------------------*/
		if( i_stat_3 & 0x01 )
		{
			PDM_Diag_Rule_Message += "Set point outside range;" "|de|Sollwert auerhalb Bereich;";
		}

		if( i_stat_3 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Fehlerstatus Binreingang;" "|de|Fehlerstatus Binreingang;";
		}

		if( i_stat_3 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Total valve travel exceeded;" "|de|Wegintegral berschritten;";
		}

		if( i_stat_3 & 0x08 )
		{
			PDM_Diag_Rule_Message += "Operating mode not AUTO;" "|de|Betriebsart ungleich AUTO;";
		}

		if( i_stat_3 & 0x10 )
		{
			PDM_Diag_Rule_Message += "Start performed with default values;" "|de|Start mit Defaultwerten durchgefhrt;";
		}

		if( i_stat_3 & 0x20 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_HIGH;
      i_no_good += 1; /* good lschen */
			PDM_Diag_Rule_Message += "Device not initialized;" "|de|Gert ist nicht initialisiert;";
		}

		if( i_stat_3 & 0x40 )
		{
			PDM_Diag_Rule_Message += "Substitute calibration performed;" "|de|Ersatzabgleich durchgefhrt;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_4 (Gertestatus 4) */
    /*---------------------------------------------*/
		if( i_stat_4 & 0x01 )
		{
			PDM_Diag_Rule_Message += "Supply pressure;" "|de|Zuluftdruck;";
		}

		if( i_stat_4 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Actuator springs;" "|de|Antriebsfedern;";
		}

		if( i_stat_4 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Shifting working range;" "|de|nderung des Stellbereichs;";
		}

		if( i_stat_4 & 0x08 )
		{
			PDM_Diag_Rule_Message += "Friction;" "|de|Reibung;";
		}

		if( i_stat_4 & 0x10 )
		{
			PDM_Diag_Rule_Message += "Leakage pneumatics;" "|de|Leckage Pneumatik;";
		}

		if( i_stat_4 & 0x20 )
		{
			PDM_Diag_Rule_Message += "Limit working range;" "|de|Beschrnkung Stellbereich;";
		}

		if( i_stat_4 & 0x40 )
		{
			PDM_Diag_Rule_Message += "Inner leakage;" "|de|Innere Leckage;";
		}

		if( i_stat_4 & 0x80 )
		{
			PDM_Diag_Rule_Message += "External leakage;" "|de|uere Leckage;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_5 (Gertestatus 5) */
    /*---------------------------------------------*/
		if( i_stat_5 & 0x01 )
		{
			PDM_Diag_Rule_Message += "Endlagenverlauf;" "|de|Endlagenverlauf;";
		}

		if( i_stat_5 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Mech. Verb. Stellungsregler/Stellventil;" "|de|Mech. Verb. Stellungsregler/Stellventil;";
		}

		if( i_stat_5 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Stellbereich;" "|de|Stellbereich;";
		}

		if( i_stat_5 & 0x08 )
		{
			PDM_Diag_Rule_Message += "PST/FST;" "|de|PST/FST;";
		}

		if( i_stat_5 & 0x10 )
		{
			PDM_Diag_Rule_Message += "Temperaturberwachung;" "|de|Temperaturberwachung;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_6 (Gertestatus 6) */
    /*---------------------------------------------*/
		if( i_stat_6 & 0x01 )
		{
			PDM_Diag_Rule_Message += "Hardware failure electronics;" "|de|Hardwarefehler Elektronik;";
		}

		if( i_stat_6 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Defective mechanics / pneumatics;" "|de|Fehler in Mechanik / Pneumatik;";
		}

		if( i_stat_6 & 0x08 )
		{
			PDM_Diag_Rule_Message += "Checksum error EEPROM;" "|de|Checksum error EEPROM;";
		}

		if( i_stat_6 & 0x10 )
		{
			PDM_Diag_Rule_Message += "Defective position transmitter;" "|de|Fehler in Wegaufnehmer;";
		}

		if( i_stat_6 & 0x20 )
		{
			PDM_Diag_Rule_Message += "Power supply failed;" "|de|Hilfsenergie zu gering;";
		}

		if( i_stat_6 & 0x40 )
		{
			PDM_Diag_Rule_Message += "Local operation active;" "|de|Vor-Ort-Bedienung aktiv;";
		}

		if( i_stat_6 & 0x80 )
		{
			PDM_Diag_Rule_Message += "Solenoid valve active;" "|de|Magnetventil aktiv;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_7 (Gertestatus 1) */
    /*---------------------------------------------*/
		if( i_stat_7 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_HIGH;
      i_no_good += 1; /* good lschen */
			PDM_Diag_Rule_Message += "Device not initialized;" "|de|Gert nicht initialisiert;";
		}

		if( i_stat_7 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Initialization not successful;"
			                         "|de|Initialisierung nicht erfolgreich;";
		}

		if( i_stat_7 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Initialization is running;"
			                         "|de|Initialisierung luft;";
		}

		if( i_stat_7 & 0x10 )
		{
			PDM_Diag_Rule_Message += "User defined characteristics not valid;"
			                         "|de|Benutzerdef. Kennlinie ungltig;";
		}

    /*---------------------------------------------*/
    /* xmtr_specific_status_8 (Gertestatus 2)     */
    /*---------------------------------------------*/
		if( i_stat_8 & 0x01 )
		{
			PDM_Diag_Rule_Message += "Travel time too short;" "|de|Laufzeit zu kurz;";
		}

		if( i_stat_8 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Control loop fault;" "|de|Regelkreis gestrt;";
		}

		if( i_stat_8 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Zero point error;" "|de|Nullpunktfehler;";
		}

		if( i_stat_8 & 0x10 )
		{
			PDM_Diag_Rule_Message += "Total valve travel exceeded;"
			                         "|de|Wegintegral berschritten;";
		}

        /********************************/
        /* NAMUR Sammelstatus auswerten */
        /********************************/
        /*   { 0,   "No message"           "|de|Keine Meldung"       },
             { 1,   "Maintenance required" "|de|Wartungsbedarf"      },
             { 2,   "Maintenance demanded" "|de|Wartungsanforderung" },
             { 3,   "Failure"    "|de|Ausfall"             },
             { 4,   "Out of specification" "|de|Auerhalb der Spezifikation" },
             { 7,   "Function check"       "|de|Funktionskontrolle"  }  */

		if( sammelstatus == 0 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
		}
		else if( sammelstatus == 1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_LOW;
      i_no_good += 1; /* good lschen */
		}
		else if( sammelstatus == 2 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_MEDIUM;
      i_no_good += 1; /* good lschen */
		}
		else if( sammelstatus == 3 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_HIGH;
      i_no_good += 1; /* good lschen */
		}
		else if( sammelstatus == 4 )
		{
//			PDM_Diag_Status_Diagnosis |= PDM_DIAG_CONFIG_WARNING;
//      i_no_good += 1; /* good lschen */
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
		}
		else if( sammelstatus == 7 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MODE_TEST;
      i_no_good += 1; /* good lschen */
		}

    /* wenn Icon nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message = "Status OK"
			                        "|de|Zustand OK"
			                        "|fr|Etat OK"
			                        "|it|Stato OK"
			                        "|sp|Estado OK";
		}

    /* wenn Status PDM_DIAG_GOOD gelscht werden soll: */
		if( i_no_good != 0 )
		{    /* nur PDM_DIAG_GOOD lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_GOOD_INVERS;
		}


  }
}

