/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2006). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 373X-4           */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.01                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*            													                        */
/*  $Revision:   1.0  $                                         */
/*  $Date:   1 May 2006 $					                              */
/*--------------------------------------------------------------*/
/* Datum:     Autor:       Aenderungen:                         */
/* ------     ------       ------------                         */
/* 31.05.2005 Jung/E7      Menus ausgelagert                    */
/* 21.06.2005 Arnhold/E7   Erweitert                            */
/* 08.06.2006 Jung/E7	     Online Dialoge angepasst             */
/* 28.08.2006 Kraemer/E82  Erweiterungen/Anpassungen            */
/* 10.09.2007 Kraemer/E82  std_NodeAddress fuer Busadresse      */
/* 08.05.2008 Kraemer/E82  Tab_s_error_unmaskiert entfllt      */
/*                         ab K1.11                             */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
/*#ifdef _V602_*/

/* fuer Umschaltung EXPERT / EXPERT+ (VALIDITY):
VALIDITY_ONLY_EXPERT_PLUS             */


/******************************************************************************/
/*    MENU Bar (Menleiste)                                                   */
/******************************************************************************/
MENU Menu_Main_Specialist /* Hauptmen Spezialist */
{
    LABEL       [main_menu];
    ITEMS
    {
        Menu_File,             /* Datei    */
        Menu_S_Device,         /* Gert    */
        Menu_View,             /* Ansicht  */
        Menu_S_Options,        /* Extras   */
        Menu_Help              /* Hilfe    */
    }
}

MENU Menu_Main_Maintenance /* Hauptmen Instandhalter */
{
    LABEL       [main_menu];
    ITEMS
    {
        Menu_File,              /* Datei    */
        Menu_M_Device,          /* Gert    */
        Menu_View,              /* Ansicht  */
        Menu_M_Options,         /* Extras   */
        Menu_Help               /* Hilfe    */
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: File (Datei)                                                      */
/*----------------------------------------------------------------------------*/
MENU Menu_File /* Datei */
{
    LABEL       [menu_File];
    ITEMS
    {
        std_Save,            /* Speichern          */
        SEPARATOR,           /* ------------------ */
        std_Eigenschaften,   /* Eigenschaften      */
        SEPARATOR,           /* ------------------ */
        std_Print,           /* Drucken            */
        std_PrintPreview,    /* Seitenansicht      */
        std_PrintSetup,      /* Drucker einrichten */
        std_PageSetup,       /* Seite einrichten   */
        std_Schriftfelder,   /* Schriftfelder      */
        SEPARATOR,           /* ------------------ */
        std_Exit             /* Beenden            */
    }
}

METHOD std_Save
{
    LABEL       [menu_File_Save];
    DEFINITION
    {
    }
}

METHOD SEPARATOR
{
    LABEL       [menu_Separator];
    DEFINITION
    {
    }
}

METHOD std_Eigenschaften
{
    LABEL       [menu_File_Properties];
    DEFINITION
    {
    }
}

METHOD std_Print
{
    LABEL       [menu_File_Print];
    DEFINITION
    {
    }
}

METHOD std_PrintPreview
{
    LABEL       [menu_File_PrintPreview];
    DEFINITION
    {
    }
}

METHOD std_PrintSetup
{
    LABEL       [menu_File_PrintSetup];
    DEFINITION
    {
    }
}

METHOD std_PageSetup
{
    LABEL       [menu_File_PageSetup];
    DEFINITION
    {
    }
}

METHOD std_Schriftfelder
{
    LABEL       [menu_File_Labels];
    DEFINITION
    {
    }
}

METHOD std_Exit
{
    LABEL       [menu_File_Exit];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: Device (Gert)                                                    */
/*----------------------------------------------------------------------------*/


/* ----------------------  Menu Spezialist -----------------------------------*/

MENU Menu_S_Device /* Gert (Spezialist) */
{
    LABEL       [menu_Device];
    ITEMS
    {
        std_LoadinDevice,                  		/* Laden in Gert      */
        std_LoadinPC,                      		/* Laden in PG/PC      */
        SEPARATOR,                         		/* ------------------- */
        std_NodeAddress,                      /* Busadresse          */
        SEPARATOR,                         		/* ------------------- */
        OnlineWindow_operation,            		/* Betrieb             */
        OnlineWindow_reset,                     /* Ruecksetzen         */
        SEPARATOR,
        OnlineWindow_self_calibration,     		/* Selbstkalibrierung  */
        OnlineWindow_write_locking,        		/* Schreibverriegelung */
        SEPARATOR,
        OnlineWindow_online_diagnosis           /* Diagnose (EXPERT/EXPERT+) */
    }
}

METHOD std_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	DEFINITION
	{
	}
}



/* -------------------- Menu Instandhalter ------------------------------------*/


MENU Menu_M_Device /* Gert (Instandhalter) */
{
    LABEL       [menu_Device];
    ITEMS
    {
        std_LoadinDevice,                  		/* Laden in Gert      */
        std_LoadinPC                      		/* Laden in PG/PC      */
    }
}

METHOD std_LoadinDevice
{
    LABEL       [menu_Device_LoadinDevice];
    DEFINITION
    {
    }
}

METHOD std_LoadinPC
{
    LABEL       [menu_Device_LoadinPC];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: View                                                              */
/*----------------------------------------------------------------------------*/
MENU Menu_View /* Ansicht */
{
    LABEL       [menu_View];
    ITEMS
    {
        OnlineWindow_display,        /* Messwertanzeige    */
        OnlineWindow_yt,             /* Kurvenschreiber    */
        OnlineWindow_diagnosis,      /* Gertezustand      */
        SEPARATOR,                   /* ------------------ */
        std_Funktionsleiste,         /* Funktionsleiste    */
        std_Statuszeile,             /* Statuszeile        */
        SEPARATOR,                   /* ------------------ */
        std_Update                   /* Aktualisieren      */
    }
}

METHOD std_Funktionsleiste
{
    LABEL       [menu_View_Toolbar];
    DEFINITION
    {
    }
}

METHOD std_Statuszeile
{
    LABEL       [menu_View_Statusbar];
    DEFINITION
    {
    }
}

METHOD std_Update
{
    LABEL       [menu_View_Update];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: Options                                                           */
/*----------------------------------------------------------------------------*/
MENU Menu_S_Options /* Extras (Spezialist) */
{
    LABEL       [menu_Options];
    ITEMS
    {
        std_Einstellungen,                  /* Einstellungen          */
        std_Untereintraege                  /* Untereintrge anzeigen */
    }
}

MENU Menu_M_Options /* Extras (Instandhalter) */
{
    LABEL       [menu_Options];
    ITEMS
    {
        std_Einstellungen,                  /* Einstellungen          */
        std_Untereintraege                  /* Untereintrge anzeigen */
    }
}

METHOD std_Einstellungen
{
    LABEL       [menu_Options_Properties];
    DEFINITION
    {
    }
}

METHOD std_Untereintraege
{
    LABEL       [menu_Options_Subitems];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: Help                                                              */
/*----------------------------------------------------------------------------*/
MENU Menu_Help /* Hilfe */
{
    LABEL       [menu_Help];
    ITEMS
    {
        std_Hilfethemen,              /* Hilfethemen            */
        std_HilfeKontext,             /* Hilfe zum Kontext      */
        SEPARATOR,                    /* ---------------------- */
        std_HilfeGeraet,              /* Hilfe zum Gert        */
		SEPARATOR,
		methodOpenDeviceManual_3730,
/* kmr: wenn 3731-4 verfuegbar:
        methodOpenDeviceManual_3731,*/
        methodOpenValveDiagnostics,
        SEPARATOR,                    /* ---------------------- */
        std_HilfeEinfuehrung,         /* Einfhrung             */
        std_HilfeErsteSchritte,       /* Erste Schritte         */
        SEPARATOR,                    /* ---------------------- */
        std_Hilfebenutzen,            /* Hilfe benutzen         */
        std_Info                      /* Info                   */
    }
}

METHOD std_Hilfethemen
{
    LABEL       [menu_Help_Topics];
    DEFINITION
    {
    }
}

METHOD std_HilfeKontext
{
    LABEL       [menu_Help_Context];
    DEFINITION
    {
    }
}

METHOD std_HilfeGeraet
{
    LABEL       [menu_Help_Device];
    DEFINITION
    {
    }
}

METHOD std_HilfeEinfuehrung
{
    LABEL       [menu_Help_Introduction];
    DEFINITION
    {
    }
}

METHOD std_HilfeErsteSchritte
{
    LABEL       [menu_Help_First_Steps];
    DEFINITION
    {
    }
}

METHOD std_Hilfebenutzen
{
    LABEL       [menu_Help_Using];
    DEFINITION
    {
    }
}

METHOD std_Info
{
    LABEL       [menu_Help_Info];
    DEFINITION
    {
    }
}

/******************************************************************************/
/*      Online-Windows                                                        */
/******************************************************************************/
/* Ansicht - Messwertanzeige **************************************************/
MENU OnlineWindow_display
{
    LABEL       [menu_dialog_display];
    ITEMS
    {
        Page_display_measure,
        Page_display_out,
        Page_display_di


    }
}

MENU Page_display_measure
{
    LABEL       [menu_dialog_display_measure];
    ITEMS
    {
        Page_group_display_measure_x,
        Page_group_display_measure_w,
        Page_group_display_measure_state
    }
}

MENU Page_group_display_measure_x
{
    LABEL       "";
    ITEMS
    {
        Val_pv,           /* Grossanzeige */
        Bar_pv_display,   /* Bargraph    */
        func1_readback_status,
        func1_readback_status_limit,
        SEPARATOR,
        func1_setpoint_deviation,
        func1_position_discrete_value
    }
}

MENU Page_group_display_measure_w
{
    LABEL       "";
    ITEMS
    {
        Val_sp,          /* Grossanzeige */
        Bar_sp_display,  /* Bargraph    */
        func1_setpoint_status           (READ_ONLY),
        func1_setpoint_status_limit     (READ_ONLY),
        SEPARATOR,
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU Page_group_display_measure_state
{
    LABEL     "State" "|de|Status";
    ITEMS
    {
        phys_condensed_state,
        trans1_transducer_state,
        trans1_Current_Temp
    }
}

MENU Bar_pv_display /* Bargraph */
{
    LABEL       "";
    ITEMS
    {
        func1_readback_value,
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU Bar_sp_display /* Bargraph */
{
    LABEL       "";
    ITEMS
    {
        func1_setpoint_value            (READ_ONLY),
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU Val_pv /* Grossanzeige */
{
    LABEL     "Controlled variable X"
              "|de|Regelgre X";
    ITEMS
    {
        func1_readback_value
    }
}

MENU Val_sp /* Grossanzeige */
{
    LABEL     "Reference variable W"
              "|de|Fhrungsgre W";
    ITEMS
    {
        func1_setpoint_value
    }
}

MENU Page_display_out
{
    LABEL       [menu_dialog_display_output];
    ITEMS
    {
        Page_group_display_out
    }
}

MENU Page_group_display_out
{
    LABEL       "";
    ITEMS
    {
        Bar_out_display,    /* Bargraph    */
        func1_out_value                 (READ_ONLY),
        func1_out_status_quality        (READ_ONLY),
        func1_out_status_limit          (READ_ONLY),
        func1_out_lower_range_value     (READ_ONLY),
        func1_out_upper_range_value     (READ_ONLY)
    }
}

MENU Bar_out_display /* Bargraph */
{
    LABEL       [func_out_value];
    ITEMS
    {
        func1_out_value                 (READ_ONLY),
        func1_out_lower_range_value     (READ_ONLY),
        func1_out_upper_range_value     (READ_ONLY)
    }
}


MENU Page_display_di
{
  	LABEL	"Binary inputs" "|de|Binreingnge";
    ITEMS
    {
        Page_group_display_di1,
        SEPARATOR,
        Page_group_display_di2
    }
}

MENU Page_group_display_di1
{
  	LABEL	"Binary input 1" "|de|Binreingang 1";
    ITEMS
    {
       trans2_DI_value,
       trans2_DI_status_quality,
	     trans2_DI_status_limit

       func2_DI_out_value,
       func2_DI_out_status_quality,
       func2_DI_out_status_limit
    }
}

MENU Page_group_display_di2
{
  	LABEL	"Binary input 2" "|de|Binreingang 2";
    ITEMS
    {
       trans3_DI_value,
       trans3_DI_status_quality,
	   trans3_DI_status_limit,

       func3_DI_out_value,
       func3_DI_out_status_quality,
       func3_DI_out_status_limit
    }
}


MENU Page_display_state
{
    LABEL       [limit_state];
    ITEMS
    {
        Page_group_display_state
    }
}

MENU Page_group_display_state
{
    LABEL       "";
    ITEMS
    {
       Tab_s_weitere_stat_infos,
       Tab_s_enhanced_diag
    }
}

MENU Tab_s_weitere_stat_infos
{
  	LABEL	"More diagnosis information"
  			"|de|Weitere Statusinformationen";

  	ITEMS
  	{
	     phys_diag_operation,
       phys_diag_init_1,
       phys_diag_init_2,
       phys_diag_hw,
       phys_diag_data_1,
       phys_diag_ext_1_3
/* kmr geht nicht       phys_diag_data_2*/
   	}
}

MENU Page_display_statistic
{
  	LABEL	"Statistics" "|de|Statistik";
    ITEMS
    {
        Page_group_display_statistic_1,
        Page_group_display_statistic_2
    }
}

MENU Page_group_display_statistic_1
{
    LABEL       "";
    ITEMS
    {
        trans1_total_valve_travel,
        trans1_total_valve_travel_limit (READ_ONLY)
    }
}

MENU Page_group_display_statistic_2
{
    LABEL       "";
    ITEMS
    {
        trans1_counter_init_start,
        trans1_no_of_zero_point_adj
    }
}

/* Ansicht - y-t Diagram *****************************************************/
MENU OnlineWindow_yt
{
    LABEL       [menu_yt_diagram] ;
    ITEMS
    {
            Page_process_yt
    }
}

MENU Page_process_yt
{
    LABEL       [menu_yt_diagram] ;
    ITEMS
    {
        Val_yt,
        Val_yt_2,
        OCX_out_display_yt
    }
}

MENU Val_yt
{
    LABEL   "Controlled variable X"
            "|de|Regelgre X";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
            func1_readback_value (READ_ONLY)
    }
}

MENU Val_yt_2
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
            func1_setpoint_value (READ_ONLY)
    }
}

MENU OCX_out_display_yt                             /* OCX-Control */
{
    LABEL       [menu_yt_diagram] ;
    STYLE       "PDMTVPROXY.PDMTVProxyCtrl.1";      /* Name, unter dem das OCX in Windows registriert ist */
    ITEMS
    {
        OCX_ProfilNum_yt,                           /* Profil-Nummer */
        OCX_out_display_1,                          /* 1. Kurve */
        OCX_out_display_2,                          /* 2. Kurve */
        OCX_UserSettings_yt /* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
    }
}

MENU OCX_out_display_1                              /* 1. Kurve im OCX-Control yt */
{
    LABEL   "Controlled variable X"
            "|de|Regelgre X";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
        func1_readback_value            (READ_ONLY),
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU OCX_out_display_2                              /* 1. Kurve im OCX-Control yt */
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
        func1_setpoint_value            (READ_ONLY),
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

VARIABLE OCX_ProfilNum_yt                           /* Profil-Variable fr OCX yt */
{
    LABEL       "ProfilID";
    STYLE       "OCX_PROPERTY";
    CLASS       LOCAL;
    TYPE        INTEGER(2)
    {
        DEFAULT_VALUE   0;                          /* Profil 0 fr normale y-t-Darstellung */
    }
    HANDLING    READ;
}

/* Fr Speicherung von Einstellungen, die vom Benutzer zur Laufzeit gendert wurden */
VARIABLE OCX_UserSettings_yt
{
    LABEL       "UserSettings";
    STYLE       "OCX_PROPERTY";
    CLASS       LOCAL;
    TYPE        ASCII (1000)
    {
        DEFAULT_VALUE   "";
    }
    HANDLING    READ & WRITE;
}

/* Ansicht - Gertezustand ***************************************************/
MENU OnlineWindow_diagnosis
{
    LABEL       [menu_dialog_diagnosis];
    ITEMS
    {
	    Page_display_state_status_messages,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( trans1_diag_level == DIAG_LEVEL_ESD              ))
      {
        /* EXPERT+ Geraet */
	    Page_display_state_extended,
	  }

	    Page_display_state_logger_1,
	    Page_display_state_logger_2,

        Page_diagnosis_general,
        Page_diagnosis_checkback,
        Page_diagnosis_diagnosis,
        Page_diagnosis_phys_block,
        Page_diagnosis_AOtrans_block,
        Page_diagnosis_AOfunc_block,
        Page_diagnosis_DI1trans_block,
        Page_diagnosis_DI1func_block,
        Page_diagnosis_DI2trans_block,
        Page_diagnosis_DI2func_block
    }
}

MENU Page_diagnosis_general
{
    LABEL       [menu_dialog_general];
    ITEMS
    {
        Page_group_diagnosis_general
    }
}

MENU Page_group_diagnosis_general
{
    LABEL       "";
    ITEMS
    {
        phys_tag_desc             (READ_ONLY),
        phys_st_rev,
        phys_strategy,
#ifdef _V602_
        phys_device_man_id,
#endif
        phys_device_id,
        phys_serial_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_device_instal_date   (READ_ONLY)
    }
}

MENU Page_diagnosis_checkback
{
    LABEL "CHECKBACK" "|de|Gertezustand - CHECKBACK";
    ITEMS
    {
      func1_check_back,
    }
}

MENU Page_diagnosis_diagnosis
{
    LABEL      "DIAGNOSIS" "|de|DIAGNOSIS";
    ITEMS
    {
      phys_diagnosis
    }
}

MENU Page_diagnosis_phys_block
{
    LABEL       [blk_block_object_PHYSICAL];
    ITEMS
    {
        Page_group_diagnosis_phys_block
    }
}

MENU Page_group_diagnosis_phys_block
{
    LABEL       "";
    ITEMS
    {
        phys_blk_object,
        phys_blk_parent_class,
        phys_blk_class,
        phys_blk_dd_reference,
        phys_blk_dd_rev,
        phys_blk_profile,
        phys_blk_profile_rev,
        phys_st_rev,
        phys_actual_mode
    }
}

MENU Page_diagnosis_AOtrans_block
{
    LABEL         "AO Transducer Block"; /* [blk_block_object_TRANSDUCER]; */
    ITEMS
    {
        Page_group_diagnosis_trans_block
    }
}

MENU Page_group_diagnosis_trans_block
{
    LABEL       "";
    ITEMS
    {
        trans1_blk_object,
        trans1_blk_parent_class,
        trans1_blk_class,
        trans1_blk_dd_reference,
        trans1_blk_dd_rev,
        trans1_blk_profile,
        trans1_blk_profile_rev,
        trans1_st_rev,
        trans1_actual_mode
    }
}

MENU Page_diagnosis_AOfunc_block
{
    LABEL       "AO Function Block"; /* [blk_block_object_FUNCTION]; */
    ITEMS
    {
        Page_group_diagnosis_func_block
    }
}

MENU Page_group_diagnosis_func_block
{
    LABEL       "";
    ITEMS
    {
        func1_blk_object,
        func1_blk_parent_class,
        func1_blk_class,
        func1_blk_dd_reference,
        func1_blk_dd_rev,
        func1_blk_profile,
        func1_blk_profile_rev,
        func1_st_rev,
        func1_actual_mode
    }
}

MENU Page_diagnosis_DI1trans_block
{
    LABEL       "DI1 Transducer Block";
    ITEMS
    {
        Page_group_diagnosis_DI2trans_block
    }
}

MENU Page_group_diagnosis_DI1trans_block
{
    LABEL       "";
    ITEMS
    {
        trans2_blk_object,
        trans2_blk_parent_class,
        trans2_blk_class,
        trans2_blk_dd_reference,
        trans2_blk_dd_rev,
        trans2_blk_profile,
        trans2_blk_profile_rev,
        trans2_st_rev,
        trans2_actual_mode
    }
}

MENU Page_diagnosis_DI1func_block
{
    LABEL       "DI1 Function Block";
    ITEMS
    {
        Page_group_diagnosis_DI1func_block
    }
}

MENU Page_group_diagnosis_DI1func_block
{
    LABEL       "";
    ITEMS
    {
        func2_DI_blk_object,
        func2_DI_blk_parent_class,
        func2_DI_blk_class,
        func2_DI_blk_dd_reference,
        func2_DI_blk_dd_rev,
        func2_DI_blk_profile,
        func2_DI_blk_profile_rev,
        func2_DI_st_rev,
        func2_DI_actual_mode
    }
}

MENU Page_diagnosis_DI2trans_block
{
    LABEL       "DI2 Transducer Block";
    ITEMS
    {
        Page_group_diagnosis_DI2trans_block
    }
}

MENU Page_group_diagnosis_DI2trans_block
{
    LABEL       "";
    ITEMS
    {
        trans3_blk_object,
        trans3_blk_parent_class,
        trans3_blk_class,
        trans3_blk_dd_reference,
        trans3_blk_dd_rev,
        trans3_blk_profile,
        trans3_blk_profile_rev,
        trans3_st_rev,
        trans3_actual_mode
    }
}

MENU Page_diagnosis_DI2func_block
{
    LABEL       "DI2 Function Block";
    ITEMS
    {
        Page_group_diagnosis_DI2func_block
    }
}

MENU Page_group_diagnosis_DI2func_block
{
    LABEL       "";
    ITEMS
    {
        func3_DI_blk_object,
        func3_DI_blk_parent_class,
        func3_DI_blk_class,
        func3_DI_blk_dd_reference,
        func3_DI_blk_dd_rev,
        func3_DI_blk_profile,
        func3_DI_blk_profile_rev,
        func3_DI_st_rev,
        func3_DI_actual_mode
    }
}

/******************************************************************************/
/*      Online-Dialogs                                                        */
/******************************************************************************/

/* Gert - Betrieb ***********************************************************/
MENU OnlineWindow_operation
{
    LABEL       [menu_dialog_operation];
    ITEMS
    {
        Page_oper_PB,
        Page_operation_fail_safe_pos,
        Page_oper_AOFB,
      /*  Page_operation_RCAS,  */
      /*  Page_operation_LO,    */
        Page_operation_TRD,
        Page_oper_DI,
        Page_simulation
    }
}


MENU Page_operation_fail_safe_pos
{
    LABEL       "Fail safe position"
				"|de|Sicherheitsstellung";
    ITEMS
    {
        Page_group_fail_safe_position
    }
}

MENU Page_group_fail_safe_position
{
    LABEL    "";
    ITEMS
    {
        trans1_transducer_state,
        trans1_set_fail_safe_pos
    }
}



MENU Page_operation_AUTO
{
    LABEL       [mode_AUTO];
    ITEMS
    {
        Page_group_operation_AUTO
    }
}


/*************************************************/

MENU Page_oper_AOFB
{
    LABEL "AO Function Block" "|de|AO Function Block";
    ITEMS
    {
        Page_group_oper_AOFB_mode,
        Page_group_oper_AOFB_SP,
        Page_group_oper_AOFB_OUT,
        Page_group_oper_AOFB_RB,
        Page_group_oper_AOFB_deviation
    }
}

MENU Page_group_oper_AOFB_mode
{
    LABEL       "Mode" "|de|Betriebsart";
    ITEMS
    {
        func1_target_mode,
        func1_actual_mode,
        func1_permitted_mode,
        func1_normal_mode
    }
}




MENU Page_group_oper_AOFB_SP
{
    LABEL       "Setpoint" "|de|Fhrungsgre";
    ITEMS
    {
        func1_setpoint_value,
        func1_setpoint_status,
        func1_setpoint_status_limit
    }
}

MENU Page_group_oper_AOFB_OUT
{
    LABEL       "Output" "|de|Ausgang";
    ITEMS
    {
        func1_out_value,
        func1_out_status_quality,
        func1_out_status_limit
    }
}


MENU Page_group_oper_AOFB_RB
{
    LABEL       "Readback" "|de|Stellungsrckmeldung";
    ITEMS
    {
       func1_readback_value,
       func1_readback_status,
       func1_readback_status_limit

    }
}

MENU Page_group_oper_AOFB_deviation
{
    LABEL       "Deviation" "|de|Regelabweichung";
    ITEMS
    {
        func1_setpoint_deviation
    }
}


/*************************************************/


MENU Page_operation_TRD
{
    LABEL   "Mode transducer" "|de|Betriebsart Transducer";
    ITEMS
    {
        Page_group_oper_TRD_mode,
        Page_group_oper_TRD_SP,
        Page_group_oper_TRD_RB
    }
}




MENU Page_group_oper_TRD_mode
{
    LABEL "AO Transducer";
    ITEMS
    {
        trans1_target_mode,
        trans1_actual_mode,
        trans1_permitted_mode,
        trans1_normal_mode

    }
}


MENU Page_group_oper_TRD_SP
{
    LABEL "Setpoint" "|de|Fhrungsgre";
    ITEMS
    {
 			/*	trans1_positioning_value,
 				trans1_positioning_quality,
        trans1_positioning_limit,  */
        trans1_final_value__value,
        trans1_final_value__quality,
		    trans1_final_value__limit
		}
}


MENU Page_group_oper_TRD_RB
{
    LABEL "Readback" "|de|Stellungsrckmeldung";
    ITEMS
    {
        trans1_final_position_value__value,
        trans1_final_position_value__quality,
        trans1_final_position_value__limit,
       /* trans1_feedback_value,
        trans1_feedback_quality,
        trans1_feedback_limit */
		}
}

/*************************************************/

MENU Page_oper_PB
{
    LABEL   "Mode operation unit (PB)" "|de|Betriebsart Betriebseinheit (PB)";
    ITEMS
    {
        Page_group_oper_PB
    }
}

MENU Page_group_oper_PB
{
    LABEL   "Operation unit (PB)" "|de|Betriebseinheit (PB)";
    ITEMS
    {
      phys_target_mode,
      phys_actual_mode,
      phys_permitted_mode,
      phys_normal_mode
    }
}



/*******************************************************/

MENU Page_oper_DI
{
    LABEL   "DI Function Blocks" "|de|DI Function Blocks";
    ITEMS
    {
        Page_group_oper_DI1_TRD,
        // trans2_target_mode,
        // trans2_actual_mode,
        // trans2_permitted_mode,
        // trans2_normal_mode,

        Page_group_oper_DI1_FB,
        // func2_DI_target_mode,
        //func2_DI_actual_mode,
        //func2_DI_permitted_mode,
        //func2_DI_normal_mode,

        // Page_group_oper_DI1_process,

        func2_DI_out_value,
        func2_DI_out_status_quality,
 		func2_DI_out_status_limit

        SEPARATOR,

        Page_group_oper_DI2_TRD,
        // trans2_target_mode,
        // trans2_actual_mode,
        // trans2_permitted_mode,
        // trans2_normal_mode,

        Page_group_oper_DI2_FB,
        // func3_DI_target_mode,
        // func3_DI_actual_mode,
        // func3_DI_permitted_mode,
        // func3_DI_normal_mode,

        // Page_group_oper_DI2_process,
        func3_DI_out_value,
        func3_DI_out_status_quality,
        func3_DI_out_status_limit
    }
}

MENU Page_group_oper_DI1_TRD
{
    LABEL   "Mode Binary input 1 (TRD)" "|de|Betriebsart Binreingang 1 (TRD)";
    ITEMS
    {
      trans2_target_mode,
      trans2_actual_mode,
      trans2_permitted_mode,
      trans2_normal_mode
    }
}



MENU Page_group_oper_DI1_FB
{
    LABEL   "Mode Binary input 1 (FB)" "|de|Betriebsart Binreingang 1 (FB)";
    ITEMS
    {
      func2_DI_target_mode,
      func2_DI_actual_mode,
      func2_DI_permitted_mode,
      func2_DI_normal_mode
    }
}


MENU Page_group_oper_DI1_process
{
    LABEL   "Process values" "|de|Prozesswerte";
    ITEMS
    {
 			func2_DI_out_value,
 			func2_DI_out_status_quality,
 			func2_DI_out_status_limit
    }
}




MENU Page_group_oper_DI2_TRD
{
    LABEL   "Mode Binary input 2 (TRD)" "|de|Betriebsart Binreingang 2 (TRD)";
    ITEMS
    {
      trans3_target_mode,
      trans3_actual_mode,
      trans3_permitted_mode,
      trans3_normal_mode
    }
}

MENU Page_group_oper_DI2_FB
{
    LABEL   "Mode Binary input 2 (FB)" "|de|Betriebsart Binreingang 2 (FB)";
    ITEMS
    {
      func3_DI_target_mode,
      func3_DI_actual_mode,
      func3_DI_permitted_mode,
      func3_DI_normal_mode
    }
}


MENU Page_group_oper_DI2_process
{
    LABEL   "Process values" "|de|Prozesswerte";
    ITEMS
    {
 			func3_DI_out_value,
 			func3_DI_out_status_quality,
 			func3_DI_out_status_limit
    }
}

/*******************************************************/

MENU Page_simulation
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        search_device,
        Page_group_operation_simulation_AO_TRD,
        Page_group_operation_simulation_DI1,
        Page_group_operation_simulation_DI2,
        Page_group_operation_simulation_device,
        transmit_button
    }
}

MENU Page_group_operation_simulation_device
{
    LABEL   "Device" "|de|Gert";
    ITEMS
    {
        phys_testfunktion
    }
}

MENU Page_group_operation_simulation_AO_TRD
{
    LABEL   "Positioner (AO, TRD)" "|de|Stellungsregler (AO, TRD)";
    ITEMS
    {
        func1_simulate_enabled,
        func1_simulate_value,
        func1_simulate_status_quality,
        func1_simulate_status_limit
    }
}

MENU Page_group_operation_simulation_DI1
{
    LABEL   "Binary input 1 (DI1, TRD)" "|de|Binreingang 1 (DI1, TRD)";
    ITEMS
    {
      func2_DI_simulation_enabled,
      func2_DI_simulate_value,
	  func2_DI_simulate_status_quality,
	  func2_DI_simulate_status_limit
    }
}

MENU Page_group_operation_simulation_DI2
{
    LABEL   "Binary input 2 (DI2, TRD)" "|de|Binreingang 2 (DI2, TRD)";
    ITEMS
    {
      func3_DI_simulation_enabled,
      func3_DI_simulate_value,
	  func3_DI_simulate_status_quality,
	  func3_DI_simulate_status_limit
    }
}

MENU Page_group_operation_testfunction
{
    LABEL   "" "|de|";
    ITEMS
    {
		phys_testfunktion
    }
}


/* Gert - Rcksetzen ********************************************************/
MENU OnlineWindow_reset
{
    LABEL       [master_reset];
    ITEMS
    {
        Page_reset_maintenance,
        Page_reset_diagnosis,
        Page_reset_device,
        Page_reset_factory
    }
    HELP        [master_reset_help];
}

MENU Page_reset_maintenance
{
	LABEL  "Reset miscellaneous"
	       "|de|Rcksetzen Verschiedenes";
    ITEMS
    {
        Page_group_reset_maintenance
    }
}

MENU Page_group_reset_maintenance
{
    LABEL       "";
    ITEMS
    {
        func1_check_back,
        phys_diagnosis,
        trans1_total_valve_travel,
        wegint_reset,
        reset_fehler
    }
}

MENU Page_reset_diagnosis
{
	LABEL  "Reset diagnosis"
	       "|de|Rcksetzen Diagnose";
    ITEMS
    {
        Page_group_reset_factory_diagnosis,
        Page_group_reset_diagnosis
    }
}

MENU Page_group_reset_diagnosis
{
    LABEL       "";
    ITEMS
    {
        reset_diag_logger,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( trans1_diag_level == DIAG_LEVEL_ESD              ))
      {
        /* EXPERT+ Geraet */

        reset_diag_travel_hist_x_long,
        reset_diag_travel_hist_x_short,
        reset_diag_setpoint_hist_e_long,
        reset_diag_setpoint_hist_e_short,
        reset_diag_cycle_counter_hist_long,
        reset_diag_cycle_counter_hist_short,
        reset_diag_drive_signal_dia_steady_long,
        SEPARATOR,
        reset_diag_drive_signal_dia_steady_short,
        reset_diag_drive_signal_dia_hys_long,
        reset_diag_drive_signal_dia_his_short,
        reset_diag_lower_end_pos,
        reset_diag_lower_end_pos_ref_values,
        reset_diag_drive_signal_dia_steady_data,
        reset_diag_drive_signal_dia_hys_data
      }

    }
}

MENU Page_reset_device
{
    LABEL       [phys_device_reset_cmd];
    ITEMS
    {
        Page_group_reset_device
    }
}

MENU Page_group_reset_device
{
    LABEL       "";
    ITEMS
    {
        func1_check_back,
        phys_diagnosis,
        warmstart
    }
}

MENU Page_reset_factory
{
    LABEL       [phys_factory_reset];
    ITEMS
    {
        Page_group_reset_factory_diagnosis
        Page_group_reset_factory
    }
}

MENU Page_group_reset_factory_diagnosis
{
    LABEL       "";
    ITEMS
    {
        func1_check_back,
        phys_diagnosis,

    }
}

MENU Page_group_reset_factory
{
    LABEL "Reset" "|de|Rcksetzen";
    ITEMS
    {
        coldstart_appl,
        coldstart_ident,
        coldstart_appl_ident,
        reset_code_36,
        reset_busadr
    }
}
/* Gert - Diagnose Optionen *************************************************/
MENU OnlineWindow_diagnosis_options
{
    LABEL   "Selection device messages"
            "|de|Auswahl Gertemeldungen";
    ITEMS
    {
        Page_diagnosis_options
    }
    HELP    "Activation or deactivation of diagnosis and device status messages."
            "|de|Aktivierung oder Deaktivierung der Meldungen fr Diagnose und Gertestatus.";
}

MENU Page_diagnosis_options
{
    LABEL   "Selection device messages"
            "|de|Auswahl Gertemeldungen";
    ITEMS
    {
        Page_group_diagnosis_options
    }
}

MENU Page_group_diagnosis_options
{
    LABEL       "";
    ITEMS
    {
        func1_check_back_opt
    }
}


/* Gert - Selbstkalibrierung ************************************************/
MENU OnlineWindow_self_calibration
{
    LABEL       [trans_act_self_calibration_cmd];
    ITEMS
    {
        Page_self_calibration,
        Page_substitution,
        Page_mode,
        Page_start_self_calibration
    }
    HELP        [trans_act_self_calibration_cmd_help];
}

MENU Page_self_calibration
{
    LABEL       [trans_act_self_calibration_cmd];
    ITEMS
    {
        Page_group_self_calibration
    }
}

MENU Page_group_self_calibration
{
    LABEL       "";
    ITEMS
    {
        trans1_device_init_state,
        phys_reading_direction,
        trans1_transm_pin_pos,
        trans1_init_method,
        trans1_pressure_limit,
        trans1_rated_travel,
        trans1_actuator_version,
        trans1_device_calib_date,
        trans1_device_config_date,
        trans1_valve_maintenance_date
    }
}


MENU Page_substitution
{
	LABEL	"Substitution"
	        "|de|Ersatzabgleich";
	ITEMS
    {
        Page_group_substitution
	}
}

MENU Page_group_substitution
{
	LABEL  "";
	ITEMS
	{
	  trans1_sub_mode_init,
      trans1_closing_direction,
      trans1_blocking_position,
      trans1_travel_upper_limit_on
	}
}

MENU Page_mode
{
	LABEL	"Mode"
	        "|de|Betriebsart";
	ITEMS
    {
      Page_group_mode
	}
}

MENU Page_group_mode
{
	LABEL	"Mode Transducer"
	        "|de|Betriebsart Transducer";
	ITEMS
	{
        trans1_actual_mode,
        trans1_target_mode,
        trans1_transducer_state,
        trans1_set_fail_safe_pos,
        trans1_final_value__value,
        trans1_final_value__quality,
        trans1_final_value__limit
	}
}


MENU Page_start_self_calibration
{
	LABEL	"Start self calibration"
	        "|de|Start Selbstkalibrierung";
    ITEMS
    {
        Page_group_start_self_calibration
    }
}

MENU Page_group_start_self_calibration
{
    LABEL       "";
    ITEMS
    {
        cal_zero_valve,             /* Methode */
        init_valve,                 /* Methode */
        abort_initialization,       /* Methode */

        trans1_act_stroke_time_inc,
        trans1_act_stroke_time_dec,
        trans1_actuator_action,
        trans1_device_init_state,
        trans1_no_of_zero_point_adj,
        trans1_counter_init_start,

        SEPARATOR,

        trans1_self_calibration_status,
        trans1_diag_testinfo,
        phys_diag_operation,
        phys_diag_init_1,          /* Initialisierungsfehler */
        phys_diag_init_2,
        phys_diagnosis,

        transmit_button
    }
}



/* Gert - Schreibverriegelung ***********************************************/
MENU OnlineWindow_write_locking
{
	LABEL		[phys_write_locking];
	HELP		[phys_write_locking_help];
	ITEMS
	{
		phys_write_locking,         /* Software-Schreibschutz */
		phys_hw_write_protection    /* Zustand Schreibschutzschalter */
	}
}



/************ hier kommen die Online-Graphen unter Nutzung der Enhancements **********/


MENU OnlineWindow_online_diagnosis
{
    LABEL   "Diagnosis" "|de|Diagnose";
/*     STYLE WINDOW;*/
   ITEMS
	{
	    Page_diagnosis_1,
	    Page_display_state_status_messages,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( trans1_diag_level == DIAG_LEVEL_ESD              ))
      {
        /* EXPERT+ Geraet */
	    Page_display_state_extended,
	  }

	    Page_display_state_logger_1,
	    Page_display_state_logger_2,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( trans1_diag_level == DIAG_LEVEL_ESD              ))
      {
        /* EXPERT+ Geraet */

        Page_online_graph,
        Page_offline_graph,
      }

			Page_dp_status
   }
}


MENU Page_diagnosis_1
{
    LABEL "Diagnosis" "|de|Diagnose";
/*    STYLE WINDOW;*/
    ITEMS
	{
	  trans1_diag_level,
    trans1_actual_mode,
	  start_reference_test,
	  abort_reference_test,
	  trans1_diag_testinfo

  }
}


MENU Page_display_state_logger_1
{
	LABEL	  "Logger 1" "|de|Protokollierung 1";
	ITEMS
	{
         trans1_Message_0,
         trans1_Message_1,
         trans1_Message_2,
         trans1_Message_3,
         trans1_Message_4,
         trans1_Message_5,
         trans1_Message_6,
         trans1_Message_7,
         trans1_Message_8,
         trans1_Message_9,
         trans1_Message_10,
         trans1_Message_11,
         trans1_Message_12,
         trans1_Message_13,
         trans1_Message_14,
         SEPARATOR,
         trans1_Elapsed_Hours_Meters_0,
         trans1_Elapsed_Hours_Meters_1,
         trans1_Elapsed_Hours_Meters_2,
         trans1_Elapsed_Hours_Meters_3,
         trans1_Elapsed_Hours_Meters_4,
         trans1_Elapsed_Hours_Meters_5,
         trans1_Elapsed_Hours_Meters_6,
         trans1_Elapsed_Hours_Meters_7,
         trans1_Elapsed_Hours_Meters_8,
         trans1_Elapsed_Hours_Meters_9,
         trans1_Elapsed_Hours_Meters_10,
         trans1_Elapsed_Hours_Meters_11,
         trans1_Elapsed_Hours_Meters_12,
         trans1_Elapsed_Hours_Meters_13,
         trans1_Elapsed_Hours_Meters_14
    }
}


MENU Page_display_state_logger_2
{
	LABEL	  "Logger 2" "|de|Protokollierung 2";
	ITEMS
	{
         trans1_Message_15,
         trans1_Message_16,
         trans1_Message_17,
         trans1_Message_18,
         trans1_Message_19,
         trans1_Message_20,
         trans1_Message_21,
         trans1_Message_22,
         trans1_Message_23,
         trans1_Message_24,
         trans1_Message_25,
         trans1_Message_26,
         trans1_Message_27,
         trans1_Message_28,
         trans1_Message_29,
         SEPARATOR,
         trans1_Elapsed_Hours_Meters_15,
         trans1_Elapsed_Hours_Meters_16,
         trans1_Elapsed_Hours_Meters_17,
         trans1_Elapsed_Hours_Meters_18,
         trans1_Elapsed_Hours_Meters_19,
         trans1_Elapsed_Hours_Meters_20,
         trans1_Elapsed_Hours_Meters_21,
         trans1_Elapsed_Hours_Meters_22,
         trans1_Elapsed_Hours_Meters_23,
         trans1_Elapsed_Hours_Meters_24,
         trans1_Elapsed_Hours_Meters_25,
         trans1_Elapsed_Hours_Meters_26,
         trans1_Elapsed_Hours_Meters_27,
         trans1_Elapsed_Hours_Meters_28,
         trans1_Elapsed_Hours_Meters_29
	}
}



MENU Page_display_state_status_messages
{
	LABEL	  "Status messages" "|de|Statusmeldungen";
	ITEMS
	{
	     phys_condensed_state,
         trans1_Elapsed_Hours_Meters,
         trans1_Device_In_Closed_Loop,
         trans1_Power_On_Since_Init,
         trans1_Device_In_Closed_Loop_Since_Last_Init,

         trans1_no_of_zero_point_adj,
         trans1_counter_init_start,
         trans1_zero_point_limit  (READ_ONLY),

         trans1_Min_Temp,
         trans1_Max_Temp,
         trans1_Time_Min_Temp,
         trans1_Time_Max_Temp,
         trans1_Period_Time_Low,
         trans1_Period_Time_High,

         SEPARATOR,

		 trans1_transducer_state,

         phys_diag_operation,
         phys_diag_init_1,
         phys_diag_init_2,
         phys_diag_hw,
         phys_diag_data_1,
         phys_diag_ext_1_3
/* kmr: geht nicht         phys_diag_data_2*/

	}
}



MENU Page_display_state_extended
{
	LABEL	  "Extended" "|de|Erweitert";
	ITEMS
	{
	  Page_group_display_state_4
	}
}

MENU Page_group_display_state_4
{
	LABEL		"";
	ITEMS
	{
	  phys_diag_ext_1_4,
	  phys_diag_ext_2_0,
	  phys_diag_ext_2_1,
	  phys_diag_ext_2_2
	}
}


MENU Page_online_graph
{
    LABEL "Statistical information AUTO" "|de|Beobachterfunktionen AUTO";
/*     STYLE WINDOW;*/
   ITEMS
	{
      OnlineWindow_EDDL_DL,
	  OnlineWindow_EDDL_x,
	  OnlineWindow_EDDL_e,
	  OnlineWindow_EDDL_z,
	  OnlineWindow_EDDL_y,
	  OnlineWindow_EDDL_et
   }
}

/*----------------- Datalogger -----------------*/
MENU OnlineWindow_EDDL_DL
{
	LABEL "Data logger" "|de|Datenlogger";
    STYLE WINDOW;
    ITEMS
	{
	   trans1_datalogger_select,
	   trans1_datalogger_trigger_select,
	   phys_dl_trigger_select_bin,
	   trans1_datalogger_sample_rate,
	   trans1_datalogger_start_value,
	   trans1_datalogger_logging_limit,
	   trans1_datalogger_pretrigger_time,
       trans1_datalogger_max_pretrig,
       phys_ident_options,
       Tab_s_datalogger_online
  }
}

/* Datenlogger ************************************************************/
MENU Tab_s_datalogger_online
{
    LABEL     "Data logger measurement" "|de|Datenlogger Messung";

    ITEMS
    {
/* wenn enhanced PDM Version */
#ifdef _V602_
       graph14,
#endif
       start_data_logger,
       abort_data_logger,
	   trans1_datalogger_testinfo,
	   trans1_datalogger_progress,
	   func1_setpoint_value,
	   transmit_button

/* wenn enhanced PDM Version */
#ifdef _V602_
	  ,SEPARATOR,
	   "Actual time:" "|de|Aktuelle Zeit:",
	   trans1_datalogger_counter_day,
	   trans1_datalogger_counter_hour,
	   trans1_datalogger_counter_minute,
	   trans1_datalogger_counter_second
	   /* trans1_datalogger_counter_msec*/
#endif
    }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph14
{
	LABEL   "Data logger" "|de|Datenlogger";
	HEIGHT  X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis18;
	MEMBERS
	{
		WAVEFORM24, waveform24;
		WAVEFORM25, waveform25;
		WAVEFORM26, waveform26;
		WAVEFORM27, waveform27;
	}
}

AXIS xaxis18
{
	LABEL "Time t" "|de|Zeit t";
	MIN_VALUE 0;
	MAX_VALUE 360000;
	CONSTANT_UNIT "1/10 s";
}


WAVEFORM waveform24
{
	Y_AXIS yaxis19;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_datalogger_t_1_0,
            trans1_datalogger_t_1_1,
            trans1_datalogger_t_1_2,
            trans1_datalogger_t_1_3,
            trans1_datalogger_t_1_4,
            trans1_datalogger_t_1_5,
            trans1_datalogger_t_1_6,
            trans1_datalogger_t_2_0,
            trans1_datalogger_t_2_1,
            trans1_datalogger_t_2_2,
            trans1_datalogger_t_2_3,
            trans1_datalogger_t_2_4,
            trans1_datalogger_t_2_5,
            trans1_datalogger_t_2_6,
            trans1_datalogger_t_3_0,
            trans1_datalogger_t_3_1,
            trans1_datalogger_t_3_2,
            trans1_datalogger_t_3_3,
            trans1_datalogger_t_3_4,
            trans1_datalogger_t_3_5,
            trans1_datalogger_t_3_6,
            trans1_datalogger_t_4_0,
            trans1_datalogger_t_4_1,
            trans1_datalogger_t_4_2,
            trans1_datalogger_t_4_3,
            trans1_datalogger_t_4_4,
            trans1_datalogger_t_4_5,
            trans1_datalogger_t_4_6,
            trans1_datalogger_t_5_0,
            trans1_datalogger_t_5_1,
            trans1_datalogger_t_5_2,
            trans1_datalogger_t_5_3,
            trans1_datalogger_t_5_4,
            trans1_datalogger_t_5_5,
            trans1_datalogger_t_5_6,
            trans1_datalogger_t_6_0,
            trans1_datalogger_t_6_1,
            trans1_datalogger_t_6_2,
            trans1_datalogger_t_6_3,
            trans1_datalogger_t_6_4,
            trans1_datalogger_t_6_5,
            trans1_datalogger_t_6_6,
            trans1_datalogger_t_7_0,
            trans1_datalogger_t_7_1,
            trans1_datalogger_t_7_2,
            trans1_datalogger_t_7_3,
            trans1_datalogger_t_7_4,
            trans1_datalogger_t_7_5,
            trans1_datalogger_t_7_6,
            trans1_datalogger_t_8_0,
            trans1_datalogger_t_8_1,
            trans1_datalogger_t_8_2,
            trans1_datalogger_t_8_3,
            trans1_datalogger_t_8_4,
            trans1_datalogger_t_8_5,
            trans1_datalogger_t_8_6,
            trans1_datalogger_t_9_0,
            trans1_datalogger_t_9_1,
            trans1_datalogger_t_9_2,
            trans1_datalogger_t_9_3,
            trans1_datalogger_t_9_4,
            trans1_datalogger_t_9_5,
            trans1_datalogger_t_9_6,
            trans1_datalogger_t_10_0,
            trans1_datalogger_t_10_1,
            trans1_datalogger_t_10_2,
            trans1_datalogger_t_10_3,
            trans1_datalogger_t_10_4,
            trans1_datalogger_t_10_5,
            trans1_datalogger_t_10_6,
            trans1_datalogger_t_11_0,
            trans1_datalogger_t_11_1,
            trans1_datalogger_t_11_2,
            trans1_datalogger_t_11_3,
            trans1_datalogger_t_11_4,
            trans1_datalogger_t_11_5,
            trans1_datalogger_t_11_6,
            trans1_datalogger_t_12_0,
            trans1_datalogger_t_12_1,
            trans1_datalogger_t_12_2,
            trans1_datalogger_t_12_3,
            trans1_datalogger_t_12_4,
            trans1_datalogger_t_12_5,
            trans1_datalogger_t_12_6,
            trans1_datalogger_t_13_0,
            trans1_datalogger_t_13_1,
            trans1_datalogger_t_13_2,
            trans1_datalogger_t_13_3,
            trans1_datalogger_t_13_4,
            trans1_datalogger_t_13_5,
            trans1_datalogger_t_13_6,
            trans1_datalogger_t_14_0,
            trans1_datalogger_t_14_1,
            trans1_datalogger_t_14_2,
            trans1_datalogger_t_14_3,
            trans1_datalogger_t_14_4,
            trans1_datalogger_t_14_5,
            trans1_datalogger_t_14_6,
            trans1_datalogger_t_15_0,
            trans1_datalogger_t_15_1

		}
		Y_VALUES
		{
	        trans1_datalogger_vs_1_0,
		    trans1_datalogger_vs_1_1,
		    trans1_datalogger_vs_1_2,
		    trans1_datalogger_vs_1_3,
		    trans1_datalogger_vs_1_4,
		    trans1_datalogger_vs_1_5,
		    trans1_datalogger_vs_1_6,
		    trans1_datalogger_vs_2_0,
		    trans1_datalogger_vs_2_1,
		    trans1_datalogger_vs_2_2,
		    trans1_datalogger_vs_2_3,
		    trans1_datalogger_vs_2_4,
		    trans1_datalogger_vs_2_5,
		    trans1_datalogger_vs_2_6,
		    trans1_datalogger_vs_3_0,
		    trans1_datalogger_vs_3_1,
		    trans1_datalogger_vs_3_2,
		    trans1_datalogger_vs_3_3,
		    trans1_datalogger_vs_3_4,
		    trans1_datalogger_vs_3_5,
		    trans1_datalogger_vs_3_6,
		    trans1_datalogger_vs_4_0,
		    trans1_datalogger_vs_4_1,
		    trans1_datalogger_vs_4_2,
		    trans1_datalogger_vs_4_3,
		    trans1_datalogger_vs_4_4,
		    trans1_datalogger_vs_4_5,
		    trans1_datalogger_vs_4_6,
		    trans1_datalogger_vs_5_0,
		    trans1_datalogger_vs_5_1,
		    trans1_datalogger_vs_5_2,
		    trans1_datalogger_vs_5_3,
		    trans1_datalogger_vs_5_4,
		    trans1_datalogger_vs_5_5,
		    trans1_datalogger_vs_5_6,
		    trans1_datalogger_vs_6_0,
		    trans1_datalogger_vs_6_1,
		    trans1_datalogger_vs_6_2,
		    trans1_datalogger_vs_6_3,
		    trans1_datalogger_vs_6_4,
		    trans1_datalogger_vs_6_5,
		    trans1_datalogger_vs_6_6,
		    trans1_datalogger_vs_7_0,
		    trans1_datalogger_vs_7_1,
		    trans1_datalogger_vs_7_2,
		    trans1_datalogger_vs_7_3,
		    trans1_datalogger_vs_7_4,
		    trans1_datalogger_vs_7_5,
		    trans1_datalogger_vs_7_6,
		    trans1_datalogger_vs_8_0,
		    trans1_datalogger_vs_8_1,
		    trans1_datalogger_vs_8_2,
		    trans1_datalogger_vs_8_3,
		    trans1_datalogger_vs_8_4,
		    trans1_datalogger_vs_8_5,
		    trans1_datalogger_vs_8_6,
		    trans1_datalogger_vs_9_0,
		    trans1_datalogger_vs_9_1,
		    trans1_datalogger_vs_9_2,
		    trans1_datalogger_vs_9_3,
		    trans1_datalogger_vs_9_4,
		    trans1_datalogger_vs_9_5,
		    trans1_datalogger_vs_9_6,
		    trans1_datalogger_vs_10_0,
		    trans1_datalogger_vs_10_1,
		    trans1_datalogger_vs_10_2,
		    trans1_datalogger_vs_10_3,
		    trans1_datalogger_vs_10_4,
		    trans1_datalogger_vs_10_5,
		    trans1_datalogger_vs_10_6,
		    trans1_datalogger_vs_11_0,
		    trans1_datalogger_vs_11_1,
		    trans1_datalogger_vs_11_2,
		    trans1_datalogger_vs_11_3,
		    trans1_datalogger_vs_11_4,
		    trans1_datalogger_vs_11_5,
		    trans1_datalogger_vs_11_6,
		    trans1_datalogger_vs_12_0,
		    trans1_datalogger_vs_12_1,
		    trans1_datalogger_vs_12_2,
		    trans1_datalogger_vs_12_3,
		    trans1_datalogger_vs_12_4,
		    trans1_datalogger_vs_12_5,
		    trans1_datalogger_vs_12_6,
		    trans1_datalogger_vs_13_0,
		    trans1_datalogger_vs_13_1,
		    trans1_datalogger_vs_13_2,
		    trans1_datalogger_vs_13_3,
		    trans1_datalogger_vs_13_4,
		    trans1_datalogger_vs_13_5,
		    trans1_datalogger_vs_13_6,
		    trans1_datalogger_vs_14_0,
		    trans1_datalogger_vs_14_1,
		    trans1_datalogger_vs_14_2,
		    trans1_datalogger_vs_14_3,
		    trans1_datalogger_vs_14_4,
		    trans1_datalogger_vs_14_5,
		    trans1_datalogger_vs_14_6,
		    trans1_datalogger_vs_15_0,
		    trans1_datalogger_vs_15_1
	  }
  }
}


WAVEFORM waveform25
{
	Y_AXIS yaxis20;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_datalogger_t_1_0,
            trans1_datalogger_t_1_1,
            trans1_datalogger_t_1_2,
            trans1_datalogger_t_1_3,
            trans1_datalogger_t_1_4,
            trans1_datalogger_t_1_5,
            trans1_datalogger_t_1_6,
            trans1_datalogger_t_2_0,
            trans1_datalogger_t_2_1,
            trans1_datalogger_t_2_2,
            trans1_datalogger_t_2_3,
            trans1_datalogger_t_2_4,
            trans1_datalogger_t_2_5,
            trans1_datalogger_t_2_6,
            trans1_datalogger_t_3_0,
            trans1_datalogger_t_3_1,
            trans1_datalogger_t_3_2,
            trans1_datalogger_t_3_3,
            trans1_datalogger_t_3_4,
            trans1_datalogger_t_3_5,
            trans1_datalogger_t_3_6,
            trans1_datalogger_t_4_0,
            trans1_datalogger_t_4_1,
            trans1_datalogger_t_4_2,
            trans1_datalogger_t_4_3,
            trans1_datalogger_t_4_4,
            trans1_datalogger_t_4_5,
            trans1_datalogger_t_4_6,
            trans1_datalogger_t_5_0,
            trans1_datalogger_t_5_1,
            trans1_datalogger_t_5_2,
            trans1_datalogger_t_5_3,
            trans1_datalogger_t_5_4,
            trans1_datalogger_t_5_5,
            trans1_datalogger_t_5_6,
            trans1_datalogger_t_6_0,
            trans1_datalogger_t_6_1,
            trans1_datalogger_t_6_2,
            trans1_datalogger_t_6_3,
            trans1_datalogger_t_6_4,
            trans1_datalogger_t_6_5,
            trans1_datalogger_t_6_6,
            trans1_datalogger_t_7_0,
            trans1_datalogger_t_7_1,
            trans1_datalogger_t_7_2,
            trans1_datalogger_t_7_3,
            trans1_datalogger_t_7_4,
            trans1_datalogger_t_7_5,
            trans1_datalogger_t_7_6,
            trans1_datalogger_t_8_0,
            trans1_datalogger_t_8_1,
            trans1_datalogger_t_8_2,
            trans1_datalogger_t_8_3,
            trans1_datalogger_t_8_4,
            trans1_datalogger_t_8_5,
            trans1_datalogger_t_8_6,
            trans1_datalogger_t_9_0,
            trans1_datalogger_t_9_1,
            trans1_datalogger_t_9_2,
            trans1_datalogger_t_9_3,
            trans1_datalogger_t_9_4,
            trans1_datalogger_t_9_5,
            trans1_datalogger_t_9_6,
            trans1_datalogger_t_10_0,
            trans1_datalogger_t_10_1,
            trans1_datalogger_t_10_2,
            trans1_datalogger_t_10_3,
            trans1_datalogger_t_10_4,
            trans1_datalogger_t_10_5,
            trans1_datalogger_t_10_6,
            trans1_datalogger_t_11_0,
            trans1_datalogger_t_11_1,
            trans1_datalogger_t_11_2,
            trans1_datalogger_t_11_3,
            trans1_datalogger_t_11_4,
            trans1_datalogger_t_11_5,
            trans1_datalogger_t_11_6,
            trans1_datalogger_t_12_0,
            trans1_datalogger_t_12_1,
            trans1_datalogger_t_12_2,
            trans1_datalogger_t_12_3,
            trans1_datalogger_t_12_4,
            trans1_datalogger_t_12_5,
            trans1_datalogger_t_12_6,
            trans1_datalogger_t_13_0,
            trans1_datalogger_t_13_1,
            trans1_datalogger_t_13_2,
            trans1_datalogger_t_13_3,
            trans1_datalogger_t_13_4,
            trans1_datalogger_t_13_5,
            trans1_datalogger_t_13_6,
            trans1_datalogger_t_14_0,
            trans1_datalogger_t_14_1,
            trans1_datalogger_t_14_2,
            trans1_datalogger_t_14_3,
            trans1_datalogger_t_14_4,
            trans1_datalogger_t_14_5,
            trans1_datalogger_t_14_6,
            trans1_datalogger_t_15_0,
            trans1_datalogger_t_15_1
		}
		Y_VALUES
		{
	        trans1_datalogger_sw_1_0,
		    trans1_datalogger_sw_1_1,
		    trans1_datalogger_sw_1_2,
		    trans1_datalogger_sw_1_3,
		    trans1_datalogger_sw_1_4,
		    trans1_datalogger_sw_1_5,
		    trans1_datalogger_sw_1_6,
		    trans1_datalogger_sw_2_0,
		    trans1_datalogger_sw_2_1,
		    trans1_datalogger_sw_2_2,
		    trans1_datalogger_sw_2_3,
		    trans1_datalogger_sw_2_4,
		    trans1_datalogger_sw_2_5,
		    trans1_datalogger_sw_2_6,
		    trans1_datalogger_sw_3_0,
		    trans1_datalogger_sw_3_1,
		    trans1_datalogger_sw_3_2,
		    trans1_datalogger_sw_3_3,
		    trans1_datalogger_sw_3_4,
		    trans1_datalogger_sw_3_5,
		    trans1_datalogger_sw_3_6,
		    trans1_datalogger_sw_4_0,
		    trans1_datalogger_sw_4_1,
		    trans1_datalogger_sw_4_2,
		    trans1_datalogger_sw_4_3,
		    trans1_datalogger_sw_4_4,
		    trans1_datalogger_sw_4_5,
		    trans1_datalogger_sw_4_6,
		    trans1_datalogger_sw_5_0,
		    trans1_datalogger_sw_5_1,
		    trans1_datalogger_sw_5_2,
		    trans1_datalogger_sw_5_3,
		    trans1_datalogger_sw_5_4,
		    trans1_datalogger_sw_5_5,
		    trans1_datalogger_sw_5_6,
		    trans1_datalogger_sw_6_0,
		    trans1_datalogger_sw_6_1,
		    trans1_datalogger_sw_6_2,
		    trans1_datalogger_sw_6_3,
		    trans1_datalogger_sw_6_4,
		    trans1_datalogger_sw_6_5,
		    trans1_datalogger_sw_6_6,
		    trans1_datalogger_sw_7_0,
		    trans1_datalogger_sw_7_1,
		    trans1_datalogger_sw_7_2,
		    trans1_datalogger_sw_7_3,
		    trans1_datalogger_sw_7_4,
		    trans1_datalogger_sw_7_5,
		    trans1_datalogger_sw_7_6,
		    trans1_datalogger_sw_8_0,
		    trans1_datalogger_sw_8_1,
		    trans1_datalogger_sw_8_2,
		    trans1_datalogger_sw_8_3,
		    trans1_datalogger_sw_8_4,
		    trans1_datalogger_sw_8_5,
		    trans1_datalogger_sw_8_6,
		    trans1_datalogger_sw_9_0,
		    trans1_datalogger_sw_9_1,
		    trans1_datalogger_sw_9_2,
		    trans1_datalogger_sw_9_3,
		    trans1_datalogger_sw_9_4,
		    trans1_datalogger_sw_9_5,
		    trans1_datalogger_sw_9_6,
		    trans1_datalogger_sw_10_0,
		    trans1_datalogger_sw_10_1,
		    trans1_datalogger_sw_10_2,
		    trans1_datalogger_sw_10_3,
		    trans1_datalogger_sw_10_4,
		    trans1_datalogger_sw_10_5,
		    trans1_datalogger_sw_10_6,
		    trans1_datalogger_sw_11_0,
		    trans1_datalogger_sw_11_1,
		    trans1_datalogger_sw_11_2,
		    trans1_datalogger_sw_11_3,
		    trans1_datalogger_sw_11_4,
		    trans1_datalogger_sw_11_5,
		    trans1_datalogger_sw_11_6,
		    trans1_datalogger_sw_12_0,
		    trans1_datalogger_sw_12_1,
		    trans1_datalogger_sw_12_2,
		    trans1_datalogger_sw_12_3,
		    trans1_datalogger_sw_12_4,
		    trans1_datalogger_sw_12_5,
		    trans1_datalogger_sw_12_6,
		    trans1_datalogger_sw_13_0,
		    trans1_datalogger_sw_13_1,
		    trans1_datalogger_sw_13_2,
		    trans1_datalogger_sw_13_3,
		    trans1_datalogger_sw_13_4,
		    trans1_datalogger_sw_13_5,
		    trans1_datalogger_sw_13_6,
		    trans1_datalogger_sw_14_0,
		    trans1_datalogger_sw_14_1,
		    trans1_datalogger_sw_14_2,
		    trans1_datalogger_sw_14_3,
		    trans1_datalogger_sw_14_4,
		    trans1_datalogger_sw_14_5,
		    trans1_datalogger_sw_14_6,
		    trans1_datalogger_sw_15_0,
		    trans1_datalogger_sw_15_1
	  }
  }
}

WAVEFORM waveform26
{
	Y_AXIS yaxis21;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_datalogger_t_1_0,
            trans1_datalogger_t_1_1,
            trans1_datalogger_t_1_2,
            trans1_datalogger_t_1_3,
            trans1_datalogger_t_1_4,
            trans1_datalogger_t_1_5,
            trans1_datalogger_t_1_6,
            trans1_datalogger_t_2_0,
            trans1_datalogger_t_2_1,
            trans1_datalogger_t_2_2,
            trans1_datalogger_t_2_3,
            trans1_datalogger_t_2_4,
            trans1_datalogger_t_2_5,
            trans1_datalogger_t_2_6,
            trans1_datalogger_t_3_0,
            trans1_datalogger_t_3_1,
            trans1_datalogger_t_3_2,
            trans1_datalogger_t_3_3,
            trans1_datalogger_t_3_4,
            trans1_datalogger_t_3_5,
            trans1_datalogger_t_3_6,
            trans1_datalogger_t_4_0,
            trans1_datalogger_t_4_1,
            trans1_datalogger_t_4_2,
            trans1_datalogger_t_4_3,
            trans1_datalogger_t_4_4,
            trans1_datalogger_t_4_5,
            trans1_datalogger_t_4_6,
            trans1_datalogger_t_5_0,
            trans1_datalogger_t_5_1,
            trans1_datalogger_t_5_2,
            trans1_datalogger_t_5_3,
            trans1_datalogger_t_5_4,
            trans1_datalogger_t_5_5,
            trans1_datalogger_t_5_6,
            trans1_datalogger_t_6_0,
            trans1_datalogger_t_6_1,
            trans1_datalogger_t_6_2,
            trans1_datalogger_t_6_3,
            trans1_datalogger_t_6_4,
            trans1_datalogger_t_6_5,
            trans1_datalogger_t_6_6,
            trans1_datalogger_t_7_0,
            trans1_datalogger_t_7_1,
            trans1_datalogger_t_7_2,
            trans1_datalogger_t_7_3,
            trans1_datalogger_t_7_4,
            trans1_datalogger_t_7_5,
            trans1_datalogger_t_7_6,
            trans1_datalogger_t_8_0,
            trans1_datalogger_t_8_1,
            trans1_datalogger_t_8_2,
            trans1_datalogger_t_8_3,
            trans1_datalogger_t_8_4,
            trans1_datalogger_t_8_5,
            trans1_datalogger_t_8_6,
            trans1_datalogger_t_9_0,
            trans1_datalogger_t_9_1,
            trans1_datalogger_t_9_2,
            trans1_datalogger_t_9_3,
            trans1_datalogger_t_9_4,
            trans1_datalogger_t_9_5,
            trans1_datalogger_t_9_6,
            trans1_datalogger_t_10_0,
            trans1_datalogger_t_10_1,
            trans1_datalogger_t_10_2,
            trans1_datalogger_t_10_3,
            trans1_datalogger_t_10_4,
            trans1_datalogger_t_10_5,
            trans1_datalogger_t_10_6,
            trans1_datalogger_t_11_0,
            trans1_datalogger_t_11_1,
            trans1_datalogger_t_11_2,
            trans1_datalogger_t_11_3,
            trans1_datalogger_t_11_4,
            trans1_datalogger_t_11_5,
            trans1_datalogger_t_11_6,
            trans1_datalogger_t_12_0,
            trans1_datalogger_t_12_1,
            trans1_datalogger_t_12_2,
            trans1_datalogger_t_12_3,
            trans1_datalogger_t_12_4,
            trans1_datalogger_t_12_5,
            trans1_datalogger_t_12_6,
            trans1_datalogger_t_13_0,
            trans1_datalogger_t_13_1,
            trans1_datalogger_t_13_2,
            trans1_datalogger_t_13_3,
            trans1_datalogger_t_13_4,
            trans1_datalogger_t_13_5,
            trans1_datalogger_t_13_6,
            trans1_datalogger_t_14_0,
            trans1_datalogger_t_14_1,
            trans1_datalogger_t_14_2,
            trans1_datalogger_t_14_3,
            trans1_datalogger_t_14_4,
            trans1_datalogger_t_14_5,
            trans1_datalogger_t_14_6,
            trans1_datalogger_t_15_0,
            trans1_datalogger_t_15_1
		}
		Y_VALUES
		{
	        trans1_datalogger_e_1_0,
		    trans1_datalogger_e_1_1,
		    trans1_datalogger_e_1_2,
		    trans1_datalogger_e_1_3,
		    trans1_datalogger_e_1_4,
		    trans1_datalogger_e_1_5,
		    trans1_datalogger_e_1_6,
		    trans1_datalogger_e_2_0,
		    trans1_datalogger_e_2_1,
		    trans1_datalogger_e_2_2,
		    trans1_datalogger_e_2_3,
		    trans1_datalogger_e_2_4,
		    trans1_datalogger_e_2_5,
		    trans1_datalogger_e_2_6,
		    trans1_datalogger_e_3_0,
		    trans1_datalogger_e_3_1,
		    trans1_datalogger_e_3_2,
		    trans1_datalogger_e_3_3,
		    trans1_datalogger_e_3_4,
		    trans1_datalogger_e_3_5,
		    trans1_datalogger_e_3_6,
		    trans1_datalogger_e_4_0,
		    trans1_datalogger_e_4_1,
		    trans1_datalogger_e_4_2,
		    trans1_datalogger_e_4_3,
		    trans1_datalogger_e_4_4,
		    trans1_datalogger_e_4_5,
		    trans1_datalogger_e_4_6,
		    trans1_datalogger_e_5_0,
		    trans1_datalogger_e_5_1,
		    trans1_datalogger_e_5_2,
		    trans1_datalogger_e_5_3,
		    trans1_datalogger_e_5_4,
		    trans1_datalogger_e_5_5,
		    trans1_datalogger_e_5_6,
		    trans1_datalogger_e_6_0,
		    trans1_datalogger_e_6_1,
		    trans1_datalogger_e_6_2,
		    trans1_datalogger_e_6_3,
		    trans1_datalogger_e_6_4,
		    trans1_datalogger_e_6_5,
		    trans1_datalogger_e_6_6,
		    trans1_datalogger_e_7_0,
		    trans1_datalogger_e_7_1,
		    trans1_datalogger_e_7_2,
		    trans1_datalogger_e_7_3,
		    trans1_datalogger_e_7_4,
		    trans1_datalogger_e_7_5,
		    trans1_datalogger_e_7_6,
		    trans1_datalogger_e_8_0,
		    trans1_datalogger_e_8_1,
		    trans1_datalogger_e_8_2,
		    trans1_datalogger_e_8_3,
		    trans1_datalogger_e_8_4,
		    trans1_datalogger_e_8_5,
		    trans1_datalogger_e_8_6,
		    trans1_datalogger_e_9_0,
		    trans1_datalogger_e_9_1,
		    trans1_datalogger_e_9_2,
		    trans1_datalogger_e_9_3,
		    trans1_datalogger_e_9_4,
		    trans1_datalogger_e_9_5,
		    trans1_datalogger_e_9_6,
		    trans1_datalogger_e_10_0,
		    trans1_datalogger_e_10_1,
		    trans1_datalogger_e_10_2,
		    trans1_datalogger_e_10_3,
		    trans1_datalogger_e_10_4,
		    trans1_datalogger_e_10_5,
		    trans1_datalogger_e_10_6,
		    trans1_datalogger_e_11_0,
		    trans1_datalogger_e_11_1,
		    trans1_datalogger_e_11_2,
		    trans1_datalogger_e_11_3,
		    trans1_datalogger_e_11_4,
		    trans1_datalogger_e_11_5,
		    trans1_datalogger_e_11_6,
		    trans1_datalogger_e_12_0,
		    trans1_datalogger_e_12_1,
		    trans1_datalogger_e_12_2,
		    trans1_datalogger_e_12_3,
		    trans1_datalogger_e_12_4,
		    trans1_datalogger_e_12_5,
		    trans1_datalogger_e_12_6,
		    trans1_datalogger_e_13_0,
		    trans1_datalogger_e_13_1,
		    trans1_datalogger_e_13_2,
		    trans1_datalogger_e_13_3,
		    trans1_datalogger_e_13_4,
		    trans1_datalogger_e_13_5,
		    trans1_datalogger_e_13_6,
		    trans1_datalogger_e_14_0,
		    trans1_datalogger_e_14_1,
		    trans1_datalogger_e_14_2,
		    trans1_datalogger_e_14_3,
		    trans1_datalogger_e_14_4,
		    trans1_datalogger_e_14_5,
		    trans1_datalogger_e_14_6,
		    trans1_datalogger_e_15_0,
		    trans1_datalogger_e_15_1
	  }
  }
}

WAVEFORM waveform27
{
	Y_AXIS yaxis22;
    EMPHASIS TRUE;
    LINE_COLOR 0x00b3df ;   /* Farbe Gelbbraun */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_datalogger_t_1_0,
            trans1_datalogger_t_1_1,
            trans1_datalogger_t_1_2,
            trans1_datalogger_t_1_3,
            trans1_datalogger_t_1_4,
            trans1_datalogger_t_1_5,
            trans1_datalogger_t_1_6,
            trans1_datalogger_t_2_0,
            trans1_datalogger_t_2_1,
            trans1_datalogger_t_2_2,
            trans1_datalogger_t_2_3,
            trans1_datalogger_t_2_4,
            trans1_datalogger_t_2_5,
            trans1_datalogger_t_2_6,
            trans1_datalogger_t_3_0,
            trans1_datalogger_t_3_1,
            trans1_datalogger_t_3_2,
            trans1_datalogger_t_3_3,
            trans1_datalogger_t_3_4,
            trans1_datalogger_t_3_5,
            trans1_datalogger_t_3_6,
            trans1_datalogger_t_4_0,
            trans1_datalogger_t_4_1,
            trans1_datalogger_t_4_2,
            trans1_datalogger_t_4_3,
            trans1_datalogger_t_4_4,
            trans1_datalogger_t_4_5,
            trans1_datalogger_t_4_6,
            trans1_datalogger_t_5_0,
            trans1_datalogger_t_5_1,
            trans1_datalogger_t_5_2,
            trans1_datalogger_t_5_3,
            trans1_datalogger_t_5_4,
            trans1_datalogger_t_5_5,
            trans1_datalogger_t_5_6,
            trans1_datalogger_t_6_0,
            trans1_datalogger_t_6_1,
            trans1_datalogger_t_6_2,
            trans1_datalogger_t_6_3,
            trans1_datalogger_t_6_4,
            trans1_datalogger_t_6_5,
            trans1_datalogger_t_6_6,
            trans1_datalogger_t_7_0,
            trans1_datalogger_t_7_1,
            trans1_datalogger_t_7_2,
            trans1_datalogger_t_7_3,
            trans1_datalogger_t_7_4,
            trans1_datalogger_t_7_5,
            trans1_datalogger_t_7_6,
            trans1_datalogger_t_8_0,
            trans1_datalogger_t_8_1,
            trans1_datalogger_t_8_2,
            trans1_datalogger_t_8_3,
            trans1_datalogger_t_8_4,
            trans1_datalogger_t_8_5,
            trans1_datalogger_t_8_6,
            trans1_datalogger_t_9_0,
            trans1_datalogger_t_9_1,
            trans1_datalogger_t_9_2,
            trans1_datalogger_t_9_3,
            trans1_datalogger_t_9_4,
            trans1_datalogger_t_9_5,
            trans1_datalogger_t_9_6,
            trans1_datalogger_t_10_0,
            trans1_datalogger_t_10_1,
            trans1_datalogger_t_10_2,
            trans1_datalogger_t_10_3,
            trans1_datalogger_t_10_4,
            trans1_datalogger_t_10_5,
            trans1_datalogger_t_10_6,
            trans1_datalogger_t_11_0,
            trans1_datalogger_t_11_1,
            trans1_datalogger_t_11_2,
            trans1_datalogger_t_11_3,
            trans1_datalogger_t_11_4,
            trans1_datalogger_t_11_5,
            trans1_datalogger_t_11_6,
            trans1_datalogger_t_12_0,
            trans1_datalogger_t_12_1,
            trans1_datalogger_t_12_2,
            trans1_datalogger_t_12_3,
            trans1_datalogger_t_12_4,
            trans1_datalogger_t_12_5,
            trans1_datalogger_t_12_6,
            trans1_datalogger_t_13_0,
            trans1_datalogger_t_13_1,
            trans1_datalogger_t_13_2,
            trans1_datalogger_t_13_3,
            trans1_datalogger_t_13_4,
            trans1_datalogger_t_13_5,
            trans1_datalogger_t_13_6,
            trans1_datalogger_t_14_0,
            trans1_datalogger_t_14_1,
            trans1_datalogger_t_14_2,
            trans1_datalogger_t_14_3,
            trans1_datalogger_t_14_4,
            trans1_datalogger_t_14_5,
            trans1_datalogger_t_14_6,
            trans1_datalogger_t_15_0,
            trans1_datalogger_t_15_1
		}
		Y_VALUES
		{
	        trans1_datalogger_ss_1_0,
		    trans1_datalogger_ss_1_1,
		    trans1_datalogger_ss_1_2,
		    trans1_datalogger_ss_1_3,
		    trans1_datalogger_ss_1_4,
		    trans1_datalogger_ss_1_5,
		    trans1_datalogger_ss_1_6,
		    trans1_datalogger_ss_2_0,
		    trans1_datalogger_ss_2_1,
		    trans1_datalogger_ss_2_2,
		    trans1_datalogger_ss_2_3,
		    trans1_datalogger_ss_2_4,
		    trans1_datalogger_ss_2_5,
		    trans1_datalogger_ss_2_6,
		    trans1_datalogger_ss_3_0,
		    trans1_datalogger_ss_3_1,
		    trans1_datalogger_ss_3_2,
		    trans1_datalogger_ss_3_3,
		    trans1_datalogger_ss_3_4,
		    trans1_datalogger_ss_3_5,
		    trans1_datalogger_ss_3_6,
		    trans1_datalogger_ss_4_0,
		    trans1_datalogger_ss_4_1,
		    trans1_datalogger_ss_4_2,
		    trans1_datalogger_ss_4_3,
		    trans1_datalogger_ss_4_4,
		    trans1_datalogger_ss_4_5,
		    trans1_datalogger_ss_4_6,
		    trans1_datalogger_ss_5_0,
		    trans1_datalogger_ss_5_1,
		    trans1_datalogger_ss_5_2,
		    trans1_datalogger_ss_5_3,
		    trans1_datalogger_ss_5_4,
		    trans1_datalogger_ss_5_5,
		    trans1_datalogger_ss_5_6,
		    trans1_datalogger_ss_6_0,
		    trans1_datalogger_ss_6_1,
		    trans1_datalogger_ss_6_2,
		    trans1_datalogger_ss_6_3,
		    trans1_datalogger_ss_6_4,
		    trans1_datalogger_ss_6_5,
		    trans1_datalogger_ss_6_6,
		    trans1_datalogger_ss_7_0,
		    trans1_datalogger_ss_7_1,
		    trans1_datalogger_ss_7_2,
		    trans1_datalogger_ss_7_3,
		    trans1_datalogger_ss_7_4,
		    trans1_datalogger_ss_7_5,
		    trans1_datalogger_ss_7_6,
		    trans1_datalogger_ss_8_0,
		    trans1_datalogger_ss_8_1,
		    trans1_datalogger_ss_8_2,
		    trans1_datalogger_ss_8_3,
		    trans1_datalogger_ss_8_4,
		    trans1_datalogger_ss_8_5,
		    trans1_datalogger_ss_8_6,
		    trans1_datalogger_ss_9_0,
		    trans1_datalogger_ss_9_1,
		    trans1_datalogger_ss_9_2,
		    trans1_datalogger_ss_9_3,
		    trans1_datalogger_ss_9_4,
		    trans1_datalogger_ss_9_5,
		    trans1_datalogger_ss_9_6,
		    trans1_datalogger_ss_10_0,
		    trans1_datalogger_ss_10_1,
		    trans1_datalogger_ss_10_2,
		    trans1_datalogger_ss_10_3,
		    trans1_datalogger_ss_10_4,
		    trans1_datalogger_ss_10_5,
		    trans1_datalogger_ss_10_6,
		    trans1_datalogger_ss_11_0,
		    trans1_datalogger_ss_11_1,
		    trans1_datalogger_ss_11_2,
		    trans1_datalogger_ss_11_3,
		    trans1_datalogger_ss_11_4,
		    trans1_datalogger_ss_11_5,
		    trans1_datalogger_ss_11_6,
		    trans1_datalogger_ss_12_0,
		    trans1_datalogger_ss_12_1,
		    trans1_datalogger_ss_12_2,
		    trans1_datalogger_ss_12_3,
		    trans1_datalogger_ss_12_4,
		    trans1_datalogger_ss_12_5,
		    trans1_datalogger_ss_12_6,
		    trans1_datalogger_ss_13_0,
		    trans1_datalogger_ss_13_1,
		    trans1_datalogger_ss_13_2,
		    trans1_datalogger_ss_13_3,
		    trans1_datalogger_ss_13_4,
		    trans1_datalogger_ss_13_5,
		    trans1_datalogger_ss_13_6,
		    trans1_datalogger_ss_14_0,
		    trans1_datalogger_ss_14_1,
		    trans1_datalogger_ss_14_2,
		    trans1_datalogger_ss_14_3,
		    trans1_datalogger_ss_14_4,
		    trans1_datalogger_ss_14_5,
		    trans1_datalogger_ss_14_6,
		    trans1_datalogger_ss_15_0,
		    trans1_datalogger_ss_15_1
	  }
  }
}

#endif

/*----------------- Travel histogram X -----------------*/

/*MENU device_root_menu_EDDL_x*/
MENU OnlineWindow_EDDL_x
{
	LABEL "Travel histogram x" "|de|Histogramm Ventilstellung x";
    STYLE WINDOW;
    ITEMS
	{
	  Page_group_EDDL_x_long,
	  Page_group_EDDL_x_short
   }
}


/*----------------- Travel histogram X (long term) -----------------*/

MENU Page_group_EDDL_x_long
{
	LABEL "Travel histogram x (long term)" "|de|Histogramm Ventilstellung x (Langzeit)";
    STYLE WINDOW;
    ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
	  graph2,
#endif
	  trans1_X_Average,
	  trans1_Number_Mess_Points

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_X_Interval_Value_0,
      trans1_X_Interval_Value_1,
      trans1_X_Interval_Value_2,
      trans1_X_Interval_Value_3,
      trans1_X_Interval_Value_4,
      trans1_X_Interval_Value_5,
      trans1_X_Interval_Value_6,
      trans1_X_Interval_Value_7,
      trans1_X_Interval_Value_8,
      trans1_X_Interval_Value_9,
      trans1_X_Interval_Value_10,
      trans1_X_Interval_Value_11,
      trans1_X_Interval_Value_12,
      trans1_X_Interval_Value_13,
      trans1_X_Interval_Value_14,
      trans1_X_Interval_Value_15,
      trans1_X_Interval_Value_16,
      trans1_X_Interval_Value_17,
      trans1_X_Interval_Value_18,
      trans1_X_Interval_Value_19,
      trans1_X_Interval_Value_20,
      trans1_X_Interval_Value_21
#endif

   }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph2
{
	LABEL "Travel histogram x (long term)" "|de|Histogramm Ventilstellung x (Langzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis1;
	MEMBERS
	{
		WAVEFORM1, waveform2;
	}
}

WAVEFORM waveform2
{
	Y_AXIS yaxis1;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 46;
		X_VALUES
		{
			aXHistogram[0],
			aXHistogram[0],	aXHistogram[1],
			aXHistogram[1],	aXHistogram[2],
			aXHistogram[2], aXHistogram[3],
			aXHistogram[3],	aXHistogram[4],
			aXHistogram[4],	aXHistogram[5],
			aXHistogram[5],	aXHistogram[6],
			aXHistogram[6],	aXHistogram[7],
			aXHistogram[7],	aXHistogram[8],
			aXHistogram[8],	aXHistogram[9],
			aXHistogram[9],	aXHistogram[10],
			aXHistogram[10], aXHistogram[11],
			aXHistogram[11], aXHistogram[12],
			aXHistogram[12], aXHistogram[13],
			aXHistogram[13], aXHistogram[14],
			aXHistogram[14], aXHistogram[15],
			aXHistogram[15], aXHistogram[16],
			aXHistogram[16], aXHistogram[17],
			aXHistogram[17], aXHistogram[18],
			aXHistogram[18], aXHistogram[19],
			aXHistogram[19], aXHistogram[20],
			aXHistogram[20], aXHistogram[21],
			aXHistogram[21], aXHistogram[22],
			aXHistogram[22]
		}
		Y_VALUES
		{
			y000,
		    trans1_X_Interval_Value_0,  trans1_X_Interval_Value_0,
			trans1_X_Interval_Value_1,  trans1_X_Interval_Value_1,
			trans1_X_Interval_Value_2,  trans1_X_Interval_Value_2,
			trans1_X_Interval_Value_3,  trans1_X_Interval_Value_3,
			trans1_X_Interval_Value_4,  trans1_X_Interval_Value_4,
			trans1_X_Interval_Value_5,  trans1_X_Interval_Value_5,
			trans1_X_Interval_Value_6,  trans1_X_Interval_Value_6,
			trans1_X_Interval_Value_7,  trans1_X_Interval_Value_7,
			trans1_X_Interval_Value_8,  trans1_X_Interval_Value_8,
			trans1_X_Interval_Value_9,  trans1_X_Interval_Value_9,
			trans1_X_Interval_Value_10, trans1_X_Interval_Value_10,
			trans1_X_Interval_Value_11, trans1_X_Interval_Value_11,
			trans1_X_Interval_Value_12, trans1_X_Interval_Value_12,
			trans1_X_Interval_Value_13, trans1_X_Interval_Value_13,
			trans1_X_Interval_Value_14, trans1_X_Interval_Value_14,
			trans1_X_Interval_Value_15, trans1_X_Interval_Value_15,
			trans1_X_Interval_Value_16, trans1_X_Interval_Value_16,
			trans1_X_Interval_Value_17, trans1_X_Interval_Value_17,
			trans1_X_Interval_Value_18, trans1_X_Interval_Value_18,
			trans1_X_Interval_Value_19, trans1_X_Interval_Value_19,
			trans1_X_Interval_Value_20, trans1_X_Interval_Value_20,
			trans1_X_Interval_Value_21, trans1_X_Interval_Value_21,
		    y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform1
		}
}

#endif

/*----------------- Travel histogram X (short term) -----------------*/

MENU Page_group_EDDL_x_short
{
	LABEL "Travel histogram x (short term)" "|de|Histogramm Ventilstellung x (Kurzzeit)";
     STYLE WINDOW;
   ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
	  graph1,
#endif
	  trans1_X_Average_KURZ,
	  trans1_X_HIS_ABTASTRATE,
	  transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_X_Interval_Value_0_KURZ,
      trans1_X_Interval_Value_1_KURZ,
      trans1_X_Interval_Value_2_KURZ,
      trans1_X_Interval_Value_3_KURZ,
      trans1_X_Interval_Value_4_KURZ,
      trans1_X_Interval_Value_5_KURZ,
      trans1_X_Interval_Value_6_KURZ,
      trans1_X_Interval_Value_7_KURZ,
      trans1_X_Interval_Value_8_KURZ,
      trans1_X_Interval_Value_9_KURZ,
      trans1_X_Interval_Value_10_KURZ,
      trans1_X_Interval_Value_11_KURZ,
      trans1_X_Interval_Value_12_KURZ,
      trans1_X_Interval_Value_13_KURZ,
      trans1_X_Interval_Value_14_KURZ,
      trans1_X_Interval_Value_15_KURZ,
      trans1_X_Interval_Value_16_KURZ,
      trans1_X_Interval_Value_17_KURZ,
      trans1_X_Interval_Value_18_KURZ,
      trans1_X_Interval_Value_19_KURZ,
      trans1_X_Interval_Value_20_KURZ,
      trans1_X_Interval_Value_21_KURZ
#endif

  }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph1
{
	LABEL "Travel histogram x (short term)" "|de|Histogramm Ventilstellung x (Kurzzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis1;
	MEMBERS
	{
		WAVEFORM1, waveform1;
	}
}

AXIS xaxis1
{
	LABEL "x";
	MIN_VALUE -5;
	MAX_VALUE 105;
	CONSTANT_UNIT "%";
}

AXIS yaxis1
{
	LABEL "Frequency" "|de|Hufigkeit";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform1
{
	Y_AXIS yaxis1;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 46;
		X_VALUES
		{
			aXHistogram[0],
			aXHistogram[0],	aXHistogram[1],
			aXHistogram[1],	aXHistogram[2],
			aXHistogram[2], aXHistogram[3],
			aXHistogram[3],	aXHistogram[4],
			aXHistogram[4],	aXHistogram[5],
			aXHistogram[5],	aXHistogram[6],
			aXHistogram[6],	aXHistogram[7],
			aXHistogram[7],	aXHistogram[8],
			aXHistogram[8],	aXHistogram[9],
			aXHistogram[9],	aXHistogram[10],
			aXHistogram[10], aXHistogram[11],
			aXHistogram[11], aXHistogram[12],
			aXHistogram[12], aXHistogram[13],
			aXHistogram[13], aXHistogram[14],
			aXHistogram[14], aXHistogram[15],
			aXHistogram[15], aXHistogram[16],
			aXHistogram[16], aXHistogram[17],
			aXHistogram[17], aXHistogram[18],
			aXHistogram[18], aXHistogram[19],
			aXHistogram[19], aXHistogram[20],
			aXHistogram[20], aXHistogram[21],
			aXHistogram[21], aXHistogram[22],
			aXHistogram[22]
		}
		Y_VALUES
		{
			y000,
            trans1_X_Interval_Value_0_KURZ,	 trans1_X_Interval_Value_0_KURZ,
            trans1_X_Interval_Value_1_KURZ,  trans1_X_Interval_Value_1_KURZ,
            trans1_X_Interval_Value_2_KURZ,  trans1_X_Interval_Value_2_KURZ,
            trans1_X_Interval_Value_3_KURZ,  trans1_X_Interval_Value_3_KURZ,
            trans1_X_Interval_Value_4_KURZ,  trans1_X_Interval_Value_4_KURZ,
            trans1_X_Interval_Value_5_KURZ,  trans1_X_Interval_Value_5_KURZ,
            trans1_X_Interval_Value_6_KURZ,  trans1_X_Interval_Value_6_KURZ,
            trans1_X_Interval_Value_7_KURZ,  trans1_X_Interval_Value_7_KURZ,
            trans1_X_Interval_Value_8_KURZ,  trans1_X_Interval_Value_8_KURZ,
            trans1_X_Interval_Value_9_KURZ,  trans1_X_Interval_Value_9_KURZ,
            trans1_X_Interval_Value_10_KURZ, trans1_X_Interval_Value_10_KURZ,
            trans1_X_Interval_Value_11_KURZ, trans1_X_Interval_Value_11_KURZ,
            trans1_X_Interval_Value_12_KURZ, trans1_X_Interval_Value_12_KURZ,
            trans1_X_Interval_Value_13_KURZ, trans1_X_Interval_Value_13_KURZ,
            trans1_X_Interval_Value_14_KURZ, trans1_X_Interval_Value_14_KURZ,
            trans1_X_Interval_Value_15_KURZ, trans1_X_Interval_Value_15_KURZ,
            trans1_X_Interval_Value_16_KURZ, trans1_X_Interval_Value_16_KURZ,
            trans1_X_Interval_Value_17_KURZ, trans1_X_Interval_Value_17_KURZ,
            trans1_X_Interval_Value_18_KURZ, trans1_X_Interval_Value_18_KURZ,
            trans1_X_Interval_Value_19_KURZ, trans1_X_Interval_Value_19_KURZ,
            trans1_X_Interval_Value_20_KURZ, trans1_X_Interval_Value_20_KURZ,
            trans1_X_Interval_Value_21_KURZ, trans1_X_Interval_Value_21_KURZ,
		    y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform1/*, methodRefresh*/
		}
}

VARIABLE y000
{
	LABEL "0";
	TYPE FLOAT
	{
	   DEFAULT_VALUE 0;
	}
	CLASS LOCAL;
	HANDLING READ;
}

VARIABLE hist_x0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_x1   LIKE VARIABLE   hist_x0
{
}
hist_x2   LIKE VARIABLE   hist_x0
{
}
hist_x3   LIKE VARIABLE   hist_x0
{
}
hist_x4   LIKE VARIABLE   hist_x0
{
}
hist_x5   LIKE VARIABLE   hist_x0
{
}
hist_x6   LIKE VARIABLE   hist_x0
{
}
hist_x7   LIKE VARIABLE   hist_x0
{
}
hist_x8   LIKE VARIABLE   hist_x0
{
}
hist_x9   LIKE VARIABLE   hist_x0
{
}
hist_x10   LIKE VARIABLE   hist_x0
{
}
hist_x11   LIKE VARIABLE   hist_x0
{
}
hist_x12   LIKE VARIABLE   hist_x0
{
}
hist_x13   LIKE VARIABLE   hist_x0
{
}
hist_x14   LIKE VARIABLE   hist_x0
{
}
hist_x15   LIKE VARIABLE   hist_x0
{
}
hist_x16   LIKE VARIABLE   hist_x0
{
}
hist_x17   LIKE VARIABLE   hist_x0
{
}
hist_x18   LIKE VARIABLE   hist_x0
{
}
hist_x19   LIKE VARIABLE   hist_x0
{
}
hist_x20   LIKE VARIABLE   hist_x0
{
}
hist_x21   LIKE VARIABLE   hist_x0
{
}
hist_x22   LIKE VARIABLE   hist_x0
{
}


ARRAY OF VARIABLE aXHistogram
{
	LABEL "x[]";
	ELEMENTS
	{
		 0, hist_x0;
		 1, hist_x1;
		 2, hist_x2;
		 3, hist_x3;
		 4, hist_x4;
		 5, hist_x5;
		 6, hist_x6;
		 7, hist_x7;
		 8, hist_x8;
		 9, hist_x9;
		10, hist_x10;
		11, hist_x11;
		12, hist_x12;
		13, hist_x13;
		14, hist_x14;
		15, hist_x15;
		16, hist_x16;
		17, hist_x17;
		18, hist_x18;
		19, hist_x19;
		20, hist_x20;
		21, hist_x21;
		22, hist_x22;
	}
}

METHOD methodInitWaveform1
{
	LABEL "methodInitWaveform1";
	DEFINITION
	{
		assign_float(aXHistogram[0], -5 );
		assign_float(aXHistogram[1], 0 );
		assign_float(aXHistogram[2], 5 );
		assign_float(aXHistogram[3], 10 );
		assign_float(aXHistogram[4], 15 );
		assign_float(aXHistogram[5], 20 );
		assign_float(aXHistogram[6], 25 );
		assign_float(aXHistogram[7], 30 );
		assign_float(aXHistogram[8], 35 );
		assign_float(aXHistogram[9], 40 );
		assign_float(aXHistogram[10], 45 );
		assign_float(aXHistogram[11], 50 );
		assign_float(aXHistogram[12], 55 );
		assign_float(aXHistogram[13], 60 );
		assign_float(aXHistogram[14], 65 );
		assign_float(aXHistogram[15], 70 );
		assign_float(aXHistogram[16], 75 );
		assign_float(aXHistogram[17], 80 );
		assign_float(aXHistogram[18], 85 );
		assign_float(aXHistogram[19], 90 );
		assign_float(aXHistogram[20], 95 );
		assign_float(aXHistogram[21], 100 );
		assign_float(aXHistogram[22], 105 );

		save_values ();
	}
}

METHOD methodInit
{
	LABEL "methodInit";
	DEFINITION
	{
		ACKNOWLEDGE ("Init Action");
	}
}

METHOD methodExit
{
	LABEL "methodExit";
	DEFINITION
	{
		ACKNOWLEDGE ("Exit Action");
	}
}

#endif

/*-------------------------------------------------------------------*/





/*----------------- Travel histogram E -----------------*/

MENU OnlineWindow_EDDL_e
{
	LABEL "Travel histogram e" "|de|Histogramm Regelabweichung e";
    STYLE WINDOW;
    ITEMS
	{
	  Page_EDDL_e_long,
	  Page_EDDL_e_short
   }
}


/*----------------- Travel histogram E (long term) -----------------*/

MENU Page_EDDL_e_long
{
	LABEL "Travel histogram e (long term)" "|de|Histogramm Regelabweichung e (Langzeit)";
    STYLE WINDOW;
    ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
	  graph4,
#endif
	  trans1_E_Average,
	  trans1_Total_Number_E,
      trans1_deviation_min,
	  trans1_deviation_max

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_E_Interval_Value_0,
      trans1_E_Interval_Value_1,
      trans1_E_Interval_Value_2,
      trans1_E_Interval_Value_3,
      trans1_E_Interval_Value_4,
      trans1_E_Interval_Value_5,
      trans1_E_Interval_Value_6,
      trans1_E_Interval_Value_7,
      trans1_E_Interval_Value_8,
      trans1_E_Interval_Value_9,
      trans1_E_Interval_Value_10,
      trans1_E_Interval_Value_11
#endif

   }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph4
{
	LABEL "Travel histogram e" "|de|Histogramm Regelabweichung e";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis3;
	MEMBERS
	{
		WAVEFORM4, waveform4;
	}
}

WAVEFORM waveform4
{
	Y_AXIS yaxis3;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 26;
		X_VALUES
		{
			aEHistogram[0],
			aEHistogram[0],	aEHistogram[1],
			aEHistogram[1],	aEHistogram[2],
			aEHistogram[2], aEHistogram[3],
			aEHistogram[3],	aEHistogram[4],
			aEHistogram[4],	aEHistogram[5],
			aEHistogram[5],	aEHistogram[6],
			aEHistogram[6],	aEHistogram[7],
			aEHistogram[7],	aEHistogram[8],
			aEHistogram[8],	aEHistogram[9],
			aEHistogram[9],	aEHistogram[10],
			aEHistogram[10], aEHistogram[11],
			aEHistogram[11], aEHistogram[12],
			aEHistogram[12]
		}
		Y_VALUES
		{
			y000,
		    trans1_E_Interval_Value_0,  trans1_E_Interval_Value_0,
		    trans1_E_Interval_Value_1,  trans1_E_Interval_Value_1,
		    trans1_E_Interval_Value_2,  trans1_E_Interval_Value_2,
		    trans1_E_Interval_Value_3,  trans1_E_Interval_Value_3,
		    trans1_E_Interval_Value_4,  trans1_E_Interval_Value_4,
		    trans1_E_Interval_Value_5,  trans1_E_Interval_Value_5,
		    trans1_E_Interval_Value_6,  trans1_E_Interval_Value_6,
		    trans1_E_Interval_Value_7,  trans1_E_Interval_Value_7,
		    trans1_E_Interval_Value_8,  trans1_E_Interval_Value_8,
		    trans1_E_Interval_Value_9,  trans1_E_Interval_Value_9,
		    trans1_E_Interval_Value_10, trans1_E_Interval_Value_10,
		    trans1_E_Interval_Value_11, trans1_E_Interval_Value_11,
			y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform3/*, methodRefresh*/
		}
}

#endif

/*----------------- Travel histogram E (short term) -----------------*/

MENU Page_EDDL_e_short
{
	LABEL "Travel histogram e (short term)" "|de|Histogramm Regelabweichung e (Kurzzeit)";
    STYLE WINDOW;
    ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
	  graph3,
#endif
	  trans1_E_Average_KURZ,
	  trans1_E_HIS_ABTASTRATE,
	  transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_E_Interval_Value_0_KURZ,
      trans1_E_Interval_Value_1_KURZ,
      trans1_E_Interval_Value_2_KURZ,
      trans1_E_Interval_Value_3_KURZ,
      trans1_E_Interval_Value_4_KURZ,
      trans1_E_Interval_Value_5_KURZ,
      trans1_E_Interval_Value_6_KURZ,
      trans1_E_Interval_Value_7_KURZ,
      trans1_E_Interval_Value_8_KURZ,
      trans1_E_Interval_Value_9_KURZ,
      trans1_E_Interval_Value_10_KURZ,
      trans1_E_Interval_Value_11_KURZ
#endif

  }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph3
{
	LABEL "Travel histogram e" "|de|Histogramm Regelabweichung e";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis3;
	MEMBERS
	{
		WAVEFORM3, waveform3;
	}
}

AXIS xaxis3
{
	LABEL "e";
  SCALING LOGARITHMIC;  /* Funktioniert irgendwie noch nicht, nehme an da fehlt noch das entsprechende LOGARITMIC Define */
	MIN_VALUE -5.5;
	MAX_VALUE 5.5;
	CONSTANT_UNIT "%";
}

AXIS yaxis3
{
	LABEL "Frequency" "|de|Hufigkeit";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform3
{
	Y_AXIS yaxis3;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 26;
		X_VALUES
		{
			aEHistogram[0],
			aEHistogram[0],	aEHistogram[1],
			aEHistogram[1],	aEHistogram[2],
			aEHistogram[2], aEHistogram[3],
			aEHistogram[3],	aEHistogram[4],
			aEHistogram[4],	aEHistogram[5],
			aEHistogram[5],	aEHistogram[6],
			aEHistogram[6],	aEHistogram[7],
			aEHistogram[7],	aEHistogram[8],
			aEHistogram[8],	aEHistogram[9],
			aEHistogram[9],	aEHistogram[10],
			aEHistogram[10], aEHistogram[11],
			aEHistogram[11], aEHistogram[12],
			aEHistogram[12]
		}
		Y_VALUES
		{
			y000,
		    trans1_E_Interval_Value_0_KURZ,	 trans1_E_Interval_Value_0_KURZ,
		    trans1_E_Interval_Value_1_KURZ,  trans1_E_Interval_Value_1_KURZ,
		    trans1_E_Interval_Value_2_KURZ,  trans1_E_Interval_Value_2_KURZ,
		    trans1_E_Interval_Value_3_KURZ,  trans1_E_Interval_Value_3_KURZ,
		    trans1_E_Interval_Value_4_KURZ,  trans1_E_Interval_Value_4_KURZ,
		    trans1_E_Interval_Value_5_KURZ,  trans1_E_Interval_Value_5_KURZ,
		    trans1_E_Interval_Value_6_KURZ,  trans1_E_Interval_Value_6_KURZ,
		    trans1_E_Interval_Value_7_KURZ,  trans1_E_Interval_Value_7_KURZ,
		    trans1_E_Interval_Value_8_KURZ,  trans1_E_Interval_Value_8_KURZ,
		    trans1_E_Interval_Value_9_KURZ,  trans1_E_Interval_Value_9_KURZ,
		    trans1_E_Interval_Value_10_KURZ, trans1_E_Interval_Value_10_KURZ,
		    trans1_E_Interval_Value_11_KURZ, trans1_E_Interval_Value_11_KURZ,
			y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform3/*, methodRefresh*/
		}
}

VARIABLE hist_e0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_e1   LIKE VARIABLE   hist_e0
{
}
hist_e2   LIKE VARIABLE   hist_e0
{
}
hist_e3   LIKE VARIABLE   hist_e0
{
}
hist_e4   LIKE VARIABLE   hist_e0
{
}
hist_e5   LIKE VARIABLE   hist_e0
{
}
hist_e6   LIKE VARIABLE   hist_e0
{
}
hist_e7   LIKE VARIABLE   hist_e0
{
}
hist_e8   LIKE VARIABLE   hist_e0
{
}
hist_e9   LIKE VARIABLE   hist_e0
{
}
hist_e10   LIKE VARIABLE   hist_e0
{
}
hist_e11   LIKE VARIABLE   hist_e0
{
}
hist_e12   LIKE VARIABLE   hist_e0
{
}


ARRAY OF VARIABLE aEHistogram
{
	LABEL "x[]";
	ELEMENTS
	{
		 0, hist_e0;
		 1, hist_e1;
		 2, hist_e2;
		 3, hist_e3;
		 4, hist_e4;
		 5, hist_e5;
		 6, hist_e6;
		 7, hist_e7;
		 8, hist_e8;
		 9, hist_e9;
		10, hist_e10;
		11, hist_e11;
		12, hist_e12;
	}
}

METHOD methodInitWaveform3
{
	LABEL "methodInitWaveform3";
	DEFINITION
	{
		assign_float(aEHistogram[0], -5.5 );
		assign_float(aEHistogram[1], -5.0 );
		assign_float(aEHistogram[2], -1.0 );
		assign_float(aEHistogram[3], -0.5 );
		assign_float(aEHistogram[4], -0.2 );
		assign_float(aEHistogram[5], -0.1 );
		assign_float(aEHistogram[6], 0 );
		assign_float(aEHistogram[7], 0.1 );
		assign_float(aEHistogram[8], 0.2 );
		assign_float(aEHistogram[9], 0.5 );
		assign_float(aEHistogram[10], 1.0 );
		assign_float(aEHistogram[11], 5.0 );
		assign_float(aEHistogram[12], 5.5 );

		save_values ();
	}
}

#endif

/*--------------------------------------------------------------------*/

/*----------------- Travel histogram Z -----------------*/

MENU OnlineWindow_EDDL_z
{
	LABEL "Cycle counter histogram" "|de|Histogramm Zyklenzhler";
    STYLE WINDOW;
	ITEMS
	{
      Page_EDDL_z_long,
      Page_EDDL_z_short
    }
}


/*----------------- Travel histogram Z (long term) -----------------*/

MENU Page_EDDL_z_long
{
	LABEL "Cycle counter histogram (long term)" "|de|Histogramm Zyklenzhler (Langzeit)";
    STYLE WINDOW;
	ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
      graph5,
#endif
      trans1_Z_Average,
	  trans1_Total_Number_Z,
	  trans1_Dynamic_Factor

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_Z_Interval_Value_0,
      trans1_Z_Interval_Value_1,
      trans1_Z_Interval_Value_2,
      trans1_Z_Interval_Value_3,
      trans1_Z_Interval_Value_4,
      trans1_Z_Interval_Value_5,
      trans1_Z_Interval_Value_6,
      trans1_Z_Interval_Value_7,
      trans1_Z_Interval_Value_8,
      trans1_Z_Interval_Value_9,
      trans1_Z_Interval_Value_10,
      trans1_Z_Interval_Value_11,
      trans1_Z_Interval_Value_12
#endif

    }
}


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph5
{
	LABEL "Cycle counter histogram (long term)" "|de|Histogramm Zyklenzhler (Langzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis6;
	MEMBERS
	{
		WAVEFORM5, waveform5;
	}
}

WAVEFORM waveform5
{
	Y_AXIS yaxis6;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 28;
		X_VALUES
		{
			aZHistogram[0],
			aZHistogram[0],	aZHistogram[1],
			aZHistogram[1],	aZHistogram[2],
			aZHistogram[2], aZHistogram[3],
			aZHistogram[3],	aZHistogram[4],
			aZHistogram[4],	aZHistogram[5],
			aZHistogram[5],	aZHistogram[6],
			aZHistogram[6],	aZHistogram[7],
			aZHistogram[7],	aZHistogram[8],
			aZHistogram[8],	aZHistogram[9],
			aZHistogram[9],	aZHistogram[10],
			aZHistogram[10], aZHistogram[11],
			aZHistogram[11], aZHistogram[12],
			aZHistogram[12], aZHistogram[13],
			aZHistogram[13]
		}
		Y_VALUES
		{
			y000,
	        trans1_Z_Interval_Value_0,  trans1_Z_Interval_Value_0,
			trans1_Z_Interval_Value_1,  trans1_Z_Interval_Value_1,
			trans1_Z_Interval_Value_2,  trans1_Z_Interval_Value_2,
			trans1_Z_Interval_Value_3,  trans1_Z_Interval_Value_3,
			trans1_Z_Interval_Value_4,  trans1_Z_Interval_Value_4,
			trans1_Z_Interval_Value_5,  trans1_Z_Interval_Value_5,
			trans1_Z_Interval_Value_6,  trans1_Z_Interval_Value_6,
			trans1_Z_Interval_Value_7,  trans1_Z_Interval_Value_7,
			trans1_Z_Interval_Value_8,  trans1_Z_Interval_Value_8,
			trans1_Z_Interval_Value_9,  trans1_Z_Interval_Value_9,
			trans1_Z_Interval_Value_10, trans1_Z_Interval_Value_10,
			trans1_Z_Interval_Value_11, trans1_Z_Interval_Value_11,
			trans1_Z_Interval_Value_12, trans1_Z_Interval_Value_12,
		    y000
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform6
		}
}

#endif


/*----------------- Travel histogram Z (short term) -----------------*/

MENU Page_EDDL_z_short
{
	LABEL "Cycle counter histogram (short term)" "|de|Histogramm Zyklenzhler (Kurzzeit)";
    STYLE WINDOW;
	ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
      graph6,
#endif
      trans1_Z_Average_KURZ

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_Z_Interval_Value_0_KURZ,
      trans1_Z_Interval_Value_1_KURZ,
      trans1_Z_Interval_Value_2_KURZ,
      trans1_Z_Interval_Value_3_KURZ,
      trans1_Z_Interval_Value_4_KURZ,
      trans1_Z_Interval_Value_5_KURZ,
      trans1_Z_Interval_Value_6_KURZ,
      trans1_Z_Interval_Value_7_KURZ,
      trans1_Z_Interval_Value_8_KURZ,
      trans1_Z_Interval_Value_9_KURZ,
      trans1_Z_Interval_Value_10_KURZ,
      trans1_Z_Interval_Value_11_KURZ,
      trans1_Z_Interval_Value_12_KURZ
#endif

   }
}

/* Cycle counter histogram (short term) */

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph6
{
	LABEL "Cycle counter histogram (short term)" "|de|Histogramm Zyklenzhler (Kurzzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis6;
	MEMBERS
	{
		WAVEFORM6, waveform6;
	}
}

AXIS xaxis6
{
	LABEL "Cycle" "|de|Zyklus";
	MIN_VALUE 0;
	MAX_VALUE 110;
	CONSTANT_UNIT "%";
}

AXIS yaxis6
{
	LABEL "Frequency" "|de|Hufigkeit";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform6
{
	Y_AXIS yaxis6;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 28;
		X_VALUES
		{
			aZHistogram[0],
			aZHistogram[0],	aZHistogram[1],
			aZHistogram[1],	aZHistogram[2],
			aZHistogram[2], aZHistogram[3],
			aZHistogram[3],	aZHistogram[4],
			aZHistogram[4],	aZHistogram[5],
			aZHistogram[5],	aZHistogram[6],
			aZHistogram[6],	aZHistogram[7],
			aZHistogram[7],	aZHistogram[8],
			aZHistogram[8],	aZHistogram[9],
			aZHistogram[9],	aZHistogram[10],
			aZHistogram[10], aZHistogram[11],
			aZHistogram[11], aZHistogram[12],
			aZHistogram[12], aZHistogram[13],
			aZHistogram[13]
		}
		Y_VALUES
		{
			y000,
	        trans1_Z_Interval_Value_0_KURZ,	 trans1_Z_Interval_Value_0_KURZ,
			trans1_Z_Interval_Value_1_KURZ,  trans1_Z_Interval_Value_1_KURZ,
			trans1_Z_Interval_Value_2_KURZ,  trans1_Z_Interval_Value_2_KURZ,
			trans1_Z_Interval_Value_3_KURZ,  trans1_Z_Interval_Value_3_KURZ,
			trans1_Z_Interval_Value_4_KURZ,  trans1_Z_Interval_Value_4_KURZ,
			trans1_Z_Interval_Value_5_KURZ,  trans1_Z_Interval_Value_5_KURZ,
			trans1_Z_Interval_Value_6_KURZ,  trans1_Z_Interval_Value_6_KURZ,
			trans1_Z_Interval_Value_7_KURZ,  trans1_Z_Interval_Value_7_KURZ,
			trans1_Z_Interval_Value_8_KURZ,  trans1_Z_Interval_Value_8_KURZ,
			trans1_Z_Interval_Value_9_KURZ,  trans1_Z_Interval_Value_9_KURZ,
			trans1_Z_Interval_Value_10_KURZ, trans1_Z_Interval_Value_10_KURZ,
			trans1_Z_Interval_Value_11_KURZ, trans1_Z_Interval_Value_11_KURZ,
			trans1_Z_Interval_Value_12_KURZ, trans1_Z_Interval_Value_12_KURZ,
		    y000
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform6
		}
}

/*
METHOD methodRefresh_z
{
	LABEL "Reload data";
	DEFINITION
	{
        PUT_MESSAGE (" Reloading Histogram Data ");
		send_command_trans(157,25);
	}
}*/

/*ARRAY aZHistogram
{
	LABEL "z";
	TYPE x000;
	NUMBER_OF_ELEMENTS 14;
}*/

VARIABLE hist_z_0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}
hist_z_1   LIKE VARIABLE   hist_z_0
{
}
hist_z_2   LIKE VARIABLE   hist_z_0
{
}
hist_z_3   LIKE VARIABLE   hist_z_0
{
}
hist_z_4   LIKE VARIABLE   hist_z_0
{
}
hist_z_5   LIKE VARIABLE   hist_z_0
{
}
hist_z_6   LIKE VARIABLE   hist_z_0
{
}
hist_z_7   LIKE VARIABLE   hist_z_0
{
}
hist_z_8   LIKE VARIABLE   hist_z_0
{
}
hist_z_9   LIKE VARIABLE   hist_z_0
{
}
hist_z_10   LIKE VARIABLE   hist_z_0
{
}
hist_z_11   LIKE VARIABLE   hist_z_0
{
}
hist_z_12   LIKE VARIABLE   hist_z_0
{
}
hist_z_13   LIKE VARIABLE   hist_z_0
{
}

ARRAY OF VARIABLE aZHistogram
{
	LABEL "z[]";
	ELEMENTS
	{
		 0, hist_z_0;
		 1, hist_z_1;
		 2, hist_z_2;
		 3, hist_z_3;
		 4, hist_z_4;
		 5, hist_z_5;
		 6, hist_z_6;
		 7, hist_z_7;
		 8, hist_z_8;
		 9, hist_z_9;
		10, hist_z_10;
		11, hist_z_11;
		12, hist_z_12;
		13, hist_z_13;
	}
}

METHOD methodInitWaveform6
{
	LABEL "methodInitWaveform6";
	DEFINITION
	{
		assign_float(aZHistogram[0], 0 );
		assign_float(aZHistogram[1], 2 );
		assign_float(aZHistogram[2], 5 );
		assign_float(aZHistogram[3], 10 );
		assign_float(aZHistogram[4], 20 );
		assign_float(aZHistogram[5], 30 );
		assign_float(aZHistogram[6], 40 );
		assign_float(aZHistogram[7], 50 );
		assign_float(aZHistogram[8], 60 );
		assign_float(aZHistogram[9], 70 );
		assign_float(aZHistogram[10], 80 );
		assign_float(aZHistogram[11], 90 );
		assign_float(aZHistogram[12], 100 );
		assign_float(aZHistogram[13], 110 );

        save_values ();
  }
}

#endif

/*--------------------------------------------------------------------*/

/*----------------- Drive Signal diagram Y  -----------------*/


MENU OnlineWindow_EDDL_y
{
	LABEL "Drive signal diagram y" "|de|Diagramm Stellsignal y";
    STYLE WINDOW;
	ITEMS
	{

/* wenn enhanced PDM Version */
#ifdef _V602_
      Page_EDDL_y_steady,
#endif

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
      Page_display_EDDL_y_steady_long,
      Page_display_EDDL_y_steady_short,
#endif

      Page_EDDL_y_hysteresis
  }
}

/*----------------- Drive Diagram Y (Steady) -----------------*/

/* wenn enhanced PDM Version */
#ifdef _V602_

MENU Page_EDDL_y_steady
{
	LABEL "Drive signal diagram y (steady)" "|de|Diagramm Stellsignal y (Stationr)";
/*    STYLE WINDOW;*/
	ITEMS
	{
      graph7
  }
}

#endif



/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_

MENU Page_display_EDDL_y_steady_long
{
	LABEL "Drive signal diagram y steady (long term)" "|de|Diagramm Stellsignal y Stationaer (Langzeit)";
/*    STYLE WINDOW;*/
	ITEMS
	{
       /* Diagramm Stellsignal y Stationaer Langzeit */
	  trans1_stationaer_lang_Value_0,
      trans1_stationaer_lang_Value_1,
      trans1_stationaer_lang_Value_2,
      trans1_stationaer_lang_Value_3,
      trans1_stationaer_lang_Value_4,
      trans1_stationaer_lang_Value_5,
      trans1_stationaer_lang_Value_6,
      trans1_stationaer_lang_Value_7,
      trans1_stationaer_lang_Value_8,
      trans1_stationaer_lang_Value_9,
      trans1_stationaer_lang_Value_10,
      SEPARATOR,
      trans1_stationaer_lang_Value_11,
      trans1_stationaer_lang_Value_12,
      trans1_stationaer_lang_Value_13,
      trans1_stationaer_lang_Value_14,
      trans1_stationaer_lang_Value_15,
      trans1_stationaer_lang_Value_16,
      trans1_stationaer_lang_Value_17,
      trans1_stationaer_lang_Value_18,
      trans1_stationaer_lang_Value_19,
      trans1_stationaer_lang_Value_20,
      trans1_stationaer_lang_Value_21
  }
}

MENU Page_display_EDDL_y_steady_short
{
	LABEL "Drive signal diagram y steady (short term)" "|de|Diagramm Stellsignal y Stationaer (Kurzzeit)";
/*    STYLE WINDOW;*/
	ITEMS
	{
       /* Diagramm Stellsignal y Stationaer Kurzzeit */
	  trans1_stationaer_kurz_Value_0,
      trans1_stationaer_kurz_Value_1,
      trans1_stationaer_kurz_Value_2,
      trans1_stationaer_kurz_Value_3,
      trans1_stationaer_kurz_Value_4,
      trans1_stationaer_kurz_Value_5,
      trans1_stationaer_kurz_Value_6,
      trans1_stationaer_kurz_Value_7,
      trans1_stationaer_kurz_Value_8,
      trans1_stationaer_kurz_Value_9,
      trans1_stationaer_kurz_Value_10,
      SEPARATOR,
      trans1_stationaer_kurz_Value_11,
      trans1_stationaer_kurz_Value_12,
      trans1_stationaer_kurz_Value_13,
      trans1_stationaer_kurz_Value_14,
      trans1_stationaer_kurz_Value_15,
      trans1_stationaer_kurz_Value_16,
      trans1_stationaer_kurz_Value_17,
      trans1_stationaer_kurz_Value_18,
      trans1_stationaer_kurz_Value_19,
      trans1_stationaer_kurz_Value_20,
      trans1_stationaer_kurz_Value_21
  }
}

#endif


/*----------------- Drive Signal diagram Y (steady) -----------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph7
{
	LABEL  "Steady" "|de|Stationr";
	HEIGHT  X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS  xaxis7;
	MEMBERS
	{
		WAVEFORM7, waveform7;
		WAVEFORM8, waveform8;
		/* Referenzkurve */
        WAVEFORM15, waveform15;
	}
}

AXIS xaxis7
{
	LABEL "x";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis7
{
	LABEL "steady - short y" "|de|Stationr - Kz. y";
	MIN_VALUE 0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

AXIS yaxis8
{
	LABEL "steady - long y" "|de|Stationr - Lz. y";
	MIN_VALUE 0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform7
{
	Y_AXIS     yaxis7;
    EMPHASIS   TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 22;
		X_VALUES
		{
			aYsteadylong[0],
			aYsteadylong[1],
			aYsteadylong[2],
			aYsteadylong[3],
			aYsteadylong[4],
			aYsteadylong[5],
			aYsteadylong[6],
			aYsteadylong[7],
			aYsteadylong[8],
			aYsteadylong[9],
			aYsteadylong[10],
			aYsteadylong[11],
			aYsteadylong[12],
			aYsteadylong[13],
			aYsteadylong[14],
			aYsteadylong[15],
			aYsteadylong[16],
			aYsteadylong[17],
			aYsteadylong[18],
			aYsteadylong[19],
			aYsteadylong[20],
			aYsteadylong[21]

		}
		Y_VALUES
		{
	        trans1_stationaer_kurz_Value_0,
            trans1_stationaer_kurz_Value_1,
            trans1_stationaer_kurz_Value_2,
            trans1_stationaer_kurz_Value_3,
            trans1_stationaer_kurz_Value_4,
            trans1_stationaer_kurz_Value_5,
            trans1_stationaer_kurz_Value_6,
            trans1_stationaer_kurz_Value_7,
            trans1_stationaer_kurz_Value_8,
            trans1_stationaer_kurz_Value_9,
            trans1_stationaer_kurz_Value_10,
            trans1_stationaer_kurz_Value_11,
            trans1_stationaer_kurz_Value_12,
            trans1_stationaer_kurz_Value_13,
            trans1_stationaer_kurz_Value_14,
            trans1_stationaer_kurz_Value_15,
            trans1_stationaer_kurz_Value_16,
            trans1_stationaer_kurz_Value_17,
            trans1_stationaer_kurz_Value_18,
            trans1_stationaer_kurz_Value_19,
            trans1_stationaer_kurz_Value_20,
            trans1_stationaer_kurz_Value_21
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform7
		}
}

WAVEFORM waveform8
{
	Y_AXIS yaxis8;
    EMPHASIS TRUE;
	LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 22;
		X_VALUES
		{
			aYsteadylong[0],
			aYsteadylong[1],
			aYsteadylong[2],
			aYsteadylong[3],
			aYsteadylong[4],
			aYsteadylong[5],
			aYsteadylong[6],
			aYsteadylong[7],
			aYsteadylong[8],
			aYsteadylong[9],
			aYsteadylong[10],
			aYsteadylong[11],
			aYsteadylong[12],
			aYsteadylong[13],
			aYsteadylong[14],
			aYsteadylong[15],
			aYsteadylong[16],
			aYsteadylong[17],
			aYsteadylong[18],
			aYsteadylong[19],
			aYsteadylong[20],
			aYsteadylong[21]
		}
		Y_VALUES
		{
	        trans1_stationaer_lang_Value_0,
            trans1_stationaer_lang_Value_1,
            trans1_stationaer_lang_Value_2,
            trans1_stationaer_lang_Value_3,
            trans1_stationaer_lang_Value_4,
            trans1_stationaer_lang_Value_5,
            trans1_stationaer_lang_Value_6,
            trans1_stationaer_lang_Value_7,
            trans1_stationaer_lang_Value_8,
            trans1_stationaer_lang_Value_9,
            trans1_stationaer_lang_Value_10,
            trans1_stationaer_lang_Value_11,
            trans1_stationaer_lang_Value_12,
            trans1_stationaer_lang_Value_13,
            trans1_stationaer_lang_Value_14,
            trans1_stationaer_lang_Value_15,
            trans1_stationaer_lang_Value_16,
            trans1_stationaer_lang_Value_17,
            trans1_stationaer_lang_Value_18,
            trans1_stationaer_lang_Value_19,
            trans1_stationaer_lang_Value_20,
            trans1_stationaer_lang_Value_21
		}
      }
    INIT_ACTIONS
		{
			methodInitWaveform7
		}
}


ARRAY OF VARIABLE aYsteadylong
{
	LABEL "y_steady[]";
	ELEMENTS
	{
		 0, hist_ysteady_long_0;
		 1, hist_ysteady_long_1;
		 2, hist_ysteady_long_2;
		 3, hist_ysteady_long_3;
		 4, hist_ysteady_long_4;
		 5, hist_ysteady_long_5;
		 6, hist_ysteady_long_6;
		 7, hist_ysteady_long_7;
		 8, hist_ysteady_long_8;
		 9, hist_ysteady_long_9;
		 10, hist_ysteady_long_10;
		 11, hist_ysteady_long_11;
		 12, hist_ysteady_long_12;
		 13, hist_ysteady_long_13;
		 14, hist_ysteady_long_14;
		 15, hist_ysteady_long_15;
		 16, hist_ysteady_long_16;
		 17, hist_ysteady_long_17;
		 18, hist_ysteady_long_18;
		 19, hist_ysteady_long_19;
		 20, hist_ysteady_long_20;
		 21, hist_ysteady_long_21;
	}
}

VARIABLE hist_ysteady_long_0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}
hist_ysteady_long_1   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_2   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_3   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_4   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_5   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_6   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_7   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_8   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_9   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_10   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_11   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_12   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_13   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_14   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_15   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_16   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_17   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_18   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_19   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_20   LIKE VARIABLE   hist_ysteady_long_0
{
}
hist_ysteady_long_21   LIKE VARIABLE   hist_ysteady_long_0
{
}

METHOD methodInitWaveform7
{
	LABEL "methodInitWaveform7";
	DEFINITION
	{
		assign_float(aYsteadylong[0], 0 );
		assign_float(aYsteadylong[1], 2.5 );
		assign_float(aYsteadylong[2], 7.5 );
		assign_float(aYsteadylong[3], 12.5 );
		assign_float(aYsteadylong[4], 17.5 );
		assign_float(aYsteadylong[5], 22.5 );
		assign_float(aYsteadylong[6], 27.5 );
		assign_float(aYsteadylong[7], 32.5 );
		assign_float(aYsteadylong[8], 37.5 );
		assign_float(aYsteadylong[9], 42.5 );
		assign_float(aYsteadylong[10], 47.5 );
		assign_float(aYsteadylong[11], 52.5 );
		assign_float(aYsteadylong[12], 57.5 );
		assign_float(aYsteadylong[13], 62.5 );
		assign_float(aYsteadylong[14], 67.5 );
		assign_float(aYsteadylong[15], 72.5 );
		assign_float(aYsteadylong[16], 77.5 );
		assign_float(aYsteadylong[17], 82.5 );
		assign_float(aYsteadylong[18], 87.5 );
		assign_float(aYsteadylong[19], 92.5 );
		assign_float(aYsteadylong[20], 97.5 );
		assign_float(aYsteadylong[21], 100 );

		save_values ();
  }
}

#endif

/*----------------- Drive Signal diagram Y (hysteresis) -----------------*/

MENU Page_EDDL_y_hysteresis
{
	LABEL "Drive signal diagram y hysteresis" "|de|Diagramm Stellsignal y (Hysterese)";
/*    STYLE WINDOW;*/
	ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
      graph8,
#endif
      start_hys_online_test,
      abort_hys_online_test,
      trans1_autostart_hyst,
      transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_hysterese_lang_Value_0,
      trans1_hysterese_lang_Value_1,
      trans1_hysterese_lang_Value_2,
      trans1_hysterese_lang_Value_3,
      trans1_hysterese_lang_Value_4,
      trans1_hysterese_lang_Value_5,
      trans1_hysterese_lang_Value_6,
      trans1_hysterese_lang_Value_7,
      trans1_hysterese_lang_Value_8,
      trans1_hysterese_lang_Value_9,
      trans1_hysterese_lang_Value_10,
      trans1_hysterese_lang_Value_11,
      trans1_hysterese_lang_Value_12,
      trans1_hysterese_lang_Value_13,
      trans1_hysterese_lang_Value_14,
      trans1_hysterese_lang_Value_15,
      trans1_hysterese_lang_Value_16,
      trans1_hysterese_lang_Value_17,
      trans1_hysterese_lang_Value_18
#endif

  }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph8
{
	LABEL "Hysteresis" "|de|Hysterese";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis7;
	MEMBERS
	{
		WAVEFORM10, waveform10;
		/* Referenzkurve */
		WAVEFORM17, waveform17;
	}
}

AXIS yaxis10
{
	LABEL "Measurement delta y" "|de|Messung delta y";
	MIN_VALUE 0;
	MAX_VALUE 500;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform10
{
	Y_AXIS yaxis10;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 19;
		X_VALUES
		{
			aYhysteresis[0],
			aYhysteresis[1],
			aYhysteresis[2],
			aYhysteresis[3],
			aYhysteresis[4],
			aYhysteresis[5],
			aYhysteresis[6],
			aYhysteresis[7],
			aYhysteresis[8],
			aYhysteresis[9],
			aYhysteresis[10],
			aYhysteresis[11],
			aYhysteresis[12],
			aYhysteresis[13],
			aYhysteresis[14],
			aYhysteresis[15],
			aYhysteresis[16],
			aYhysteresis[17],
			aYhysteresis[18]
		}
		Y_VALUES
		{
          trans1_hysterese_lang_Value_0,
          trans1_hysterese_lang_Value_1,
          trans1_hysterese_lang_Value_2,
          trans1_hysterese_lang_Value_3,
          trans1_hysterese_lang_Value_4,
          trans1_hysterese_lang_Value_5,
          trans1_hysterese_lang_Value_6,
          trans1_hysterese_lang_Value_7,
          trans1_hysterese_lang_Value_8,
          trans1_hysterese_lang_Value_9,
          trans1_hysterese_lang_Value_10,
          trans1_hysterese_lang_Value_11,
          trans1_hysterese_lang_Value_12,
          trans1_hysterese_lang_Value_13,
          trans1_hysterese_lang_Value_14,
          trans1_hysterese_lang_Value_15,
          trans1_hysterese_lang_Value_16,
          trans1_hysterese_lang_Value_17,
          trans1_hysterese_lang_Value_18
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform8
		}
}


ARRAY OF VARIABLE aYhysteresis
{
	LABEL "y_steady[]";
	ELEMENTS
	{
		 0, hist_yhysteresis_0;
		 1, hist_yhysteresis_1;
		 2, hist_yhysteresis_2;
		 3, hist_yhysteresis_3;
		 4, hist_yhysteresis_4;
		 5, hist_yhysteresis_5;
		 6, hist_yhysteresis_6;
		 7, hist_yhysteresis_7;
		 8, hist_yhysteresis_8;
		 9, hist_yhysteresis_9;
		 10, hist_yhysteresis_10;
		 11, hist_yhysteresis_11;
		 12, hist_yhysteresis_12;
		 13, hist_yhysteresis_13;
		 14, hist_yhysteresis_14;
		 15, hist_yhysteresis_15;
		 16, hist_yhysteresis_16;
		 17, hist_yhysteresis_17;
		 18, hist_yhysteresis_18;
	}
}

VARIABLE hist_yhysteresis_0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}
hist_yhysteresis_1   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_2   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_3   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_4   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_5   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_6   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_7   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_8   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_9   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_10   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_11   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_12   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_13   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_14   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_15   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_16   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_17   LIKE VARIABLE   hist_yhysteresis_0
{
}
hist_yhysteresis_18   LIKE VARIABLE   hist_yhysteresis_0
{
}


METHOD methodInitWaveform8
{
	LABEL "methodInitWaveform8";
	DEFINITION
	{
		assign_float(aYhysteresis[0], 3 );
		assign_float(aYhysteresis[1], 10.5 );
		assign_float(aYhysteresis[2], 15.5 );
		assign_float(aYhysteresis[3], 20.5 );
		assign_float(aYhysteresis[4], 25.5 );
		assign_float(aYhysteresis[5], 30.5 );
		assign_float(aYhysteresis[6], 35.5 );
		assign_float(aYhysteresis[7], 40.5 );
		assign_float(aYhysteresis[8], 45.5 );
		assign_float(aYhysteresis[9], 50.5 );
		assign_float(aYhysteresis[10], 55.5 );
		assign_float(aYhysteresis[11], 60.5 );
		assign_float(aYhysteresis[12], 65.5 );
		assign_float(aYhysteresis[13], 70.5 );
		assign_float(aYhysteresis[14], 75.5 );
		assign_float(aYhysteresis[15], 80.5 );
		assign_float(aYhysteresis[16], 85.5 );
		assign_float(aYhysteresis[17], 90.5 );
		assign_float(aYhysteresis[18], 98 );

        save_values ();
  }
}

#endif

/*--------------------------------------------------------------------*/

/*----------------- Trend of travel end position ET ------------------*/

/*--------------------------------------------------------------------*/

MENU OnlineWindow_EDDL_et
{
	LABEL "Trend of travel end position" "|de|Endlagentrend";
    STYLE WINDOW;
	ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      graph9,
#endif

      trans1_et_ventil_refwert,
      trans1_et_BSZ_refwert,
      trans1_et_endlage_refwert,

	  Page_EDDL_et_1,
	  Page_EDDL_et_2
  }
}


MENU Page_EDDL_et_1
{
	LABEL "Trend of travel end position 1-15" "|de|Endlagentrend 1-15";
/*    STYLE WINDOW;*/
	ITEMS
	{
      trans1_et_ventil_Value_0,
      trans1_et_ventil_Value_1,
      trans1_et_ventil_Value_2,
      trans1_et_ventil_Value_3,
      trans1_et_ventil_Value_4,
      trans1_et_ventil_Value_5,
      trans1_et_ventil_Value_6,
      trans1_et_ventil_Value_7,
      trans1_et_ventil_Value_8,
      trans1_et_ventil_Value_9,
      trans1_et_ventil_Value_10,
      trans1_et_ventil_Value_11,
      trans1_et_ventil_Value_12,
      trans1_et_ventil_Value_13,
      trans1_et_ventil_Value_14,
      SEPARATOR,
      trans1_et_BSZ_Value_0,
      trans1_et_BSZ_Value_1,
      trans1_et_BSZ_Value_2,
      trans1_et_BSZ_Value_3,
      trans1_et_BSZ_Value_4,
      trans1_et_BSZ_Value_5,
      trans1_et_BSZ_Value_6,
      trans1_et_BSZ_Value_7,
      trans1_et_BSZ_Value_8,
      trans1_et_BSZ_Value_9,
      trans1_et_BSZ_Value_10,
      trans1_et_BSZ_Value_11,
      trans1_et_BSZ_Value_12,
      trans1_et_BSZ_Value_13,
      trans1_et_BSZ_Value_14,
      SEPARATOR,
      trans1_et_endlage_Value_0,
      trans1_et_endlage_Value_1,
      trans1_et_endlage_Value_2,
      trans1_et_endlage_Value_3,
      trans1_et_endlage_Value_4,
      trans1_et_endlage_Value_5,
      trans1_et_endlage_Value_6,
      trans1_et_endlage_Value_7,
      trans1_et_endlage_Value_8,
      trans1_et_endlage_Value_9,
      trans1_et_endlage_Value_10,
      trans1_et_endlage_Value_11,
      trans1_et_endlage_Value_12,
      trans1_et_endlage_Value_13,
      trans1_et_endlage_Value_14
    }
}

MENU Page_EDDL_et_2
{
	LABEL "Trend of travel end position 16-30" "|de|Endlagentrend 16-30";
/*    STYLE WINDOW;*/
	ITEMS
	{
      trans1_et_ventil_Value_15,
      trans1_et_ventil_Value_16,
      trans1_et_ventil_Value_17,
      trans1_et_ventil_Value_18,
      trans1_et_ventil_Value_19,
      trans1_et_ventil_Value_20,
      trans1_et_ventil_Value_21,
      trans1_et_ventil_Value_22,
      trans1_et_ventil_Value_23,
      trans1_et_ventil_Value_24,
      trans1_et_ventil_Value_25,
      trans1_et_ventil_Value_26,
      trans1_et_ventil_Value_27,
      trans1_et_ventil_Value_28,
      trans1_et_ventil_Value_29,
      SEPARATOR,
      trans1_et_BSZ_Value_15,
      trans1_et_BSZ_Value_16,
      trans1_et_BSZ_Value_17,
      trans1_et_BSZ_Value_18,
      trans1_et_BSZ_Value_19,
      trans1_et_BSZ_Value_20,
      trans1_et_BSZ_Value_21,
      trans1_et_BSZ_Value_22,
      trans1_et_BSZ_Value_23,
      trans1_et_BSZ_Value_24,
      trans1_et_BSZ_Value_25,
      trans1_et_BSZ_Value_26,
      trans1_et_BSZ_Value_27,
      trans1_et_BSZ_Value_28,
      trans1_et_BSZ_Value_29,
      SEPARATOR,
      trans1_et_endlage_Value_15,
      trans1_et_endlage_Value_16,
      trans1_et_endlage_Value_17,
      trans1_et_endlage_Value_18,
      trans1_et_endlage_Value_19,
      trans1_et_endlage_Value_20,
      trans1_et_endlage_Value_21,
      trans1_et_endlage_Value_22,
      trans1_et_endlage_Value_23,
      trans1_et_endlage_Value_24,
      trans1_et_endlage_Value_25,
      trans1_et_endlage_Value_26,
      trans1_et_endlage_Value_27,
      trans1_et_endlage_Value_28,
      trans1_et_endlage_Value_29
    }
}



/*----------------- Endlagentrend ------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph9
{
	LABEL "Trend of travel end position" "|de|Endlagentrend";
	HEIGHT X_LARGE;
	WIDTH  X_LARGE;
	X_AXIS xaxis9;
	MEMBERS
	{
		WAVEFORM9, waveform9;
		WAVEFORM_endlage, waveform_endlage;
	}
}

/* Waagerechte Linie (Referenzwert Ventilstellung) */
WAVEFORM waveform_endlage
{
	Y_AXIS yaxis_ref;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE HORIZONTAL
	{
		Y_VALUES
		{
	        trans1_et_ventil_refwert
		}
      }
}

/* fuer waagerechte Linie (Referenzwert Ventilstellung) */
AXIS yaxis_ref
{
	LABEL "Reference" "|de|Referenz";
	MIN_VALUE -10;
	MAX_VALUE 10;
	CONSTANT_UNIT "%";
}


AXIS xaxis9
{
	LABEL "No. of measurement points" "|de|Anzahl Messpunkte";
	MIN_VALUE 0;
	MAX_VALUE 30;
	CONSTANT_UNIT "n";
}

AXIS yaxis9
{
	LABEL "x";
	MIN_VALUE -10;
	MAX_VALUE 10;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform9
{
	Y_AXIS yaxis9;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 30;
		X_VALUES
		{
			aET[1],aET[2],aET[3],aET[4],
			aET[5],aET[6],aET[7],aET[8],aET[9],
			aET[10],aET[11],aET[12],aET[13],aET[14],
			aET[15],aET[16],aET[17],aET[18],aET[19],
			aET[20],aET[21],aET[22],aET[23],aET[24],
			aET[25],aET[26],aET[27],aET[28],aET[29],aET[30]
		}
		Y_VALUES
		{
	        trans1_et_ventil_Value_0,
            trans1_et_ventil_Value_1,
            trans1_et_ventil_Value_2,
            trans1_et_ventil_Value_3,
            trans1_et_ventil_Value_4,
            trans1_et_ventil_Value_5,
            trans1_et_ventil_Value_6,
            trans1_et_ventil_Value_7,
            trans1_et_ventil_Value_8,
            trans1_et_ventil_Value_9,
            trans1_et_ventil_Value_10,
            trans1_et_ventil_Value_11,
            trans1_et_ventil_Value_12,
            trans1_et_ventil_Value_13,
            trans1_et_ventil_Value_14,
            trans1_et_ventil_Value_15,
            trans1_et_ventil_Value_16,
            trans1_et_ventil_Value_17,
            trans1_et_ventil_Value_18,
            trans1_et_ventil_Value_19,
            trans1_et_ventil_Value_20,
            trans1_et_ventil_Value_21,
            trans1_et_ventil_Value_22,
            trans1_et_ventil_Value_23,
            trans1_et_ventil_Value_24,
            trans1_et_ventil_Value_25,
            trans1_et_ventil_Value_26,
            trans1_et_ventil_Value_27,
            trans1_et_ventil_Value_28,
            trans1_et_ventil_Value_29
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform9
		}
}

ARRAY OF VARIABLE aET
{
	LABEL "endlagentrend[]";
	ELEMENTS
	{
		 1, aET_1;
		 2, aET_2;
		 3, aET_3;
		 4, aET_4;
		 5, aET_5;
		 6, aET_6;
		 7, aET_7;
		 8, aET_8;
		 9, aET_9;
		 10, aET_10;
		 11, aET_11;
		 12, aET_12;
		 13, aET_13;
		 14, aET_14;
		 15, aET_15;
		 16, aET_16;
		 17, aET_17;
		 18, aET_18;
		 19, aET_19;
		 20, aET_20;
		 21, aET_21;
		 22, aET_22;
		 23, aET_23;
		 24, aET_24;
		 25, aET_25;
		 26, aET_26;
		 27, aET_27;
		 28, aET_28;
		 29, aET_29;
		 30, aET_30;

	}
}

VARIABLE aET_1
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}
aET_2   LIKE VARIABLE   aET_1
{
}
aET_3   LIKE VARIABLE   aET_1
{
}
aET_4   LIKE VARIABLE   aET_1
{
}
aET_5   LIKE VARIABLE   aET_1
{
}
aET_6   LIKE VARIABLE   aET_1
{
}
aET_7   LIKE VARIABLE   aET_1
{
}
aET_8   LIKE VARIABLE   aET_1
{
}
aET_9   LIKE VARIABLE   aET_1
{
}
aET_10   LIKE VARIABLE   aET_1
{
}
aET_11   LIKE VARIABLE   aET_1
{
}
aET_12   LIKE VARIABLE   aET_1
{
}
aET_13   LIKE VARIABLE   aET_1
{
}
aET_14   LIKE VARIABLE   aET_1
{
}
aET_15   LIKE VARIABLE   aET_1
{
}
aET_16   LIKE VARIABLE   aET_1
{
}
aET_17   LIKE VARIABLE   aET_1
{
}
aET_18   LIKE VARIABLE   aET_1
{
}
aET_19   LIKE VARIABLE   aET_1
{
}
aET_20   LIKE VARIABLE   aET_1
{
}
aET_21   LIKE VARIABLE   aET_1
{
}
aET_22   LIKE VARIABLE   aET_1
{
}
aET_23   LIKE VARIABLE   aET_1
{
}
aET_24   LIKE VARIABLE   aET_1
{
}
aET_25   LIKE VARIABLE   aET_1
{
}
aET_26   LIKE VARIABLE   aET_1
{
}
aET_27   LIKE VARIABLE   aET_1
{
}
aET_28   LIKE VARIABLE   aET_1
{
}
aET_29   LIKE VARIABLE   aET_1
{
}
aET_30   LIKE VARIABLE   aET_1
{
}


METHOD methodInitWaveform9
{
	LABEL "methodInitWaveform9";
	DEFINITION
	{
		int i;
        float j;
		for( i = 1 ; i < 31 ; i++ )
		{
            j = i;
			assign_float(aET[i], j );
		}
        save_values ();
    }
}

#endif



/***************** HAND Testfunktionen ************************/

MENU Page_offline_graph
{
   LABEL "Tests MAN" "|de|Testfunktionen HAND";
/*   STYLE WINDOW;*/
   ITEMS
   {
      start_all_tests_MAN,
      OnlineWindow_diag_steady,
	    OnlineWindow_diag_hysteresis,
	    OnlineWindow_diag_stat_char,
	    OnlineWindow_diag_step,
	    trans1_diag_testinfo,
      abort_all_tests_MAN
   }
}

MENU Page_dp_status
{
   LABEL "DP Status" "|de|DP Status";
/*   STYLE WINDOW;*/
   ITEMS
   {
     phys_device_dp_status
   }
}



/*----------------- Diagramm Stellsignal Stationaer MAN------------------------------------*/

MENU OnlineWindow_diag_steady
{
	LABEL "Drive signal diagram steady" "|de|Diagramm Stellsignal y Stationr";
    STYLE WINDOW;
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph10,
#endif
	  start_drive_signal_diagram_steady,
	  abort_drive_signal_diagram_steady,
      trans1_stat_ss_refzeit,
      trans1_stat_ss_testinfo,
      trans1_stat_ss_progress

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,trans1_stat_again_ss_0,
      trans1_stat_again_ss_1,
      trans1_stat_again_ss_2,
      trans1_stat_again_ss_3,
      trans1_stat_again_ss_4,
      trans1_stat_again_ss_5,
      trans1_stat_again_ss_6,
      trans1_stat_again_ss_7,
      trans1_stat_again_ss_8,
      trans1_stat_again_ss_9,
      trans1_stat_again_ss_10,
      trans1_stat_again_ss_11,
      trans1_stat_again_ss_12,
      trans1_stat_again_ss_13,
      trans1_stat_again_ss_14,
      trans1_stat_again_ss_15,
      trans1_stat_again_ss_16,
      SEPARATOR,
      trans1_stat_again_ss_17,
      trans1_stat_again_ss_18,
      trans1_stat_again_ss_19,
      trans1_stat_again_ss_20,
      trans1_stat_again_ss_21,
      trans1_stat_again_ss_22,
      trans1_stat_again_ss_23,
      trans1_stat_again_ss_24,

      trans1_stat_ref_ss_0,
      trans1_stat_ref_ss_1,
      trans1_stat_ref_ss_2,
      trans1_stat_ref_ss_3,
      trans1_stat_ref_ss_4,
      trans1_stat_ref_ss_5,
      trans1_stat_ref_ss_6,
      trans1_stat_ref_ss_7,
      trans1_stat_ref_ss_8,
      trans1_stat_ref_ss_9,
      trans1_stat_ref_ss_10,
      trans1_stat_ref_ss_11,
      SEPARATOR,
      trans1_stat_ref_ss_12,
      trans1_stat_ref_ss_13,
      trans1_stat_ref_ss_14,
      trans1_stat_ref_ss_15,
      trans1_stat_ref_ss_16,
      trans1_stat_ref_ss_17,
      trans1_stat_ref_ss_18,
      trans1_stat_ref_ss_19,
      trans1_stat_ref_ss_20,
      trans1_stat_ref_ss_21,
      trans1_stat_ref_ss_22,
      trans1_stat_ref_ss_23,
      trans1_stat_ref_ss_24
#endif
  }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph10
{
	LABEL "Drive signal diagram steady" "|de|Diagramm Stellsignal y Stationr";
	HEIGHT  X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis15;
	MEMBERS
	{
		WAVEFORM15, waveform15;
		WAVEFORM16, waveform16;
	}
}

AXIS xaxis15
{
	LABEL	"Valve position x" "|de|Ventilposition x";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis15
{
	LABEL "Drive Signal y Reference" "|de|Stellsignal y Referenz";
	MIN_VALUE 0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

AXIS yaxis16
{
	LABEL "Drive Signal y Repetition" "|de|Stellsignal y Wiederholung";
	MIN_VALUE 0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform15
{
	Y_AXIS     yaxis15;
    EMPHASIS   TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 25;
		X_VALUES
		{
			trans1_stat_ref_vs_0,
            trans1_stat_ref_vs_1,
            trans1_stat_ref_vs_2,
            trans1_stat_ref_vs_3,
            trans1_stat_ref_vs_4,
            trans1_stat_ref_vs_5,
            trans1_stat_ref_vs_6,
            trans1_stat_ref_vs_7,
            trans1_stat_ref_vs_8,
            trans1_stat_ref_vs_9,
            trans1_stat_ref_vs_10,
            trans1_stat_ref_vs_11,
            trans1_stat_ref_vs_12,
            trans1_stat_ref_vs_13,
            trans1_stat_ref_vs_14,
            trans1_stat_ref_vs_15,
            trans1_stat_ref_vs_16,
            trans1_stat_ref_vs_17,
            trans1_stat_ref_vs_18,
            trans1_stat_ref_vs_19,
            trans1_stat_ref_vs_20,
            trans1_stat_ref_vs_21,
            trans1_stat_ref_vs_22,
            trans1_stat_ref_vs_23,
            trans1_stat_ref_vs_24
		}
		Y_VALUES
		{
	        trans1_stat_ref_ss_0,
	        trans1_stat_ref_ss_1,
	        trans1_stat_ref_ss_2,
	        trans1_stat_ref_ss_3,
	        trans1_stat_ref_ss_4,
	        trans1_stat_ref_ss_5,
	        trans1_stat_ref_ss_6,
	        trans1_stat_ref_ss_7,
	        trans1_stat_ref_ss_8,
	        trans1_stat_ref_ss_9,
	        trans1_stat_ref_ss_10,
	        trans1_stat_ref_ss_11,
	        trans1_stat_ref_ss_12,
	        trans1_stat_ref_ss_13,
	        trans1_stat_ref_ss_14,
	        trans1_stat_ref_ss_15,
	        trans1_stat_ref_ss_16,
	        trans1_stat_ref_ss_17,
	        trans1_stat_ref_ss_18,
	        trans1_stat_ref_ss_19,
	        trans1_stat_ref_ss_20,
	        trans1_stat_ref_ss_21,
	        trans1_stat_ref_ss_22,
	        trans1_stat_ref_ss_23,
	        trans1_stat_ref_ss_24
	  }
  }
}

WAVEFORM waveform16
{
	Y_AXIS yaxis16;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 25;
		X_VALUES
		{
			trans1_stat_again_vs_0,
            trans1_stat_again_vs_1,
            trans1_stat_again_vs_2,
            trans1_stat_again_vs_3,
            trans1_stat_again_vs_4,
            trans1_stat_again_vs_5,
            trans1_stat_again_vs_6,
            trans1_stat_again_vs_7,
            trans1_stat_again_vs_8,
            trans1_stat_again_vs_9,
            trans1_stat_again_vs_10,
            trans1_stat_again_vs_11,
            trans1_stat_again_vs_12,
            trans1_stat_again_vs_13,
            trans1_stat_again_vs_14,
            trans1_stat_again_vs_15,
            trans1_stat_again_vs_16,
            trans1_stat_again_vs_17,
            trans1_stat_again_vs_18,
            trans1_stat_again_vs_19,
            trans1_stat_again_vs_20,
            trans1_stat_again_vs_21,
            trans1_stat_again_vs_22,
            trans1_stat_again_vs_23,
            trans1_stat_again_vs_24
		}
		Y_VALUES
		{
	        trans1_stat_again_ss_0,
	        trans1_stat_again_ss_1,
	        trans1_stat_again_ss_2,
	        trans1_stat_again_ss_3,
	        trans1_stat_again_ss_4,
	        trans1_stat_again_ss_5,
	        trans1_stat_again_ss_6,
	        trans1_stat_again_ss_7,
	        trans1_stat_again_ss_8,
	        trans1_stat_again_ss_9,
	        trans1_stat_again_ss_10,
	        trans1_stat_again_ss_11,
	        trans1_stat_again_ss_12,
	        trans1_stat_again_ss_13,
	        trans1_stat_again_ss_14,
	        trans1_stat_again_ss_15,
	        trans1_stat_again_ss_16,
	        trans1_stat_again_ss_17,
	        trans1_stat_again_ss_18,
	        trans1_stat_again_ss_19,
	        trans1_stat_again_ss_20,
	        trans1_stat_again_ss_21,
	        trans1_stat_again_ss_22,
	        trans1_stat_again_ss_23,
	        trans1_stat_again_ss_24
	  }
  }
}

#endif

/*----------------- Diagramm Stellsignal Hyterese MAN ------------------------------------*/

MENU OnlineWindow_diag_hysteresis
{
	LABEL "Drive signal diagram hysteresis" "|de|Diagramm Stellsignal y Hysterese";
    STYLE WINDOW;
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph11,
#endif
	  start_drive_signal_diagram_hys,
	  abort_drive_signal_diagram_hys,
      trans1_hys_ss_refzeit,
      trans1_hys_ss_testinfo,
      trans1_hys_ss_progress

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      trans1_hys_again_hys_0,
      trans1_hys_again_hys_1,
      trans1_hys_again_hys_2,
      trans1_hys_again_hys_3,
      trans1_hys_again_hys_4,
      trans1_hys_again_hys_5,
      trans1_hys_again_hys_6,
      trans1_hys_again_hys_7,
      trans1_hys_again_hys_8,
      trans1_hys_again_hys_9,
      trans1_hys_again_hys_10,
      trans1_hys_again_hys_11,
      SEPARATOR,
      trans1_hys_ref_hys_0,
      trans1_hys_ref_hys_1,
      trans1_hys_ref_hys_2,
      trans1_hys_ref_hys_3,
      trans1_hys_ref_hys_4,
      trans1_hys_ref_hys_5,
      trans1_hys_ref_hys_6,
      trans1_hys_ref_hys_7,
      trans1_hys_ref_hys_8,
      trans1_hys_ref_hys_9,
      trans1_hys_ref_hys_10,
      trans1_hys_ref_hys_11
#endif
  }
}



/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph11
{
	LABEL "Drive signal diagram hysteresis" "|de|Diagramm Stellsignal y Hysterese";
	HEIGHT  X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis15;
	MEMBERS
	{
		WAVEFORM17, waveform17;
		WAVEFORM18, waveform18;
	}
}

AXIS yaxis17
{
	LABEL "Drive Signal y Reference" "|de|Stellsignal y Referenz";
	MIN_VALUE 0;
	MAX_VALUE 500;
	CONSTANT_UNIT "1/s";
}

AXIS yaxis18
{
	LABEL "Drive Signal y Repetition" "|de|Stellsignal y Wiederholung";
	MIN_VALUE 0;
	MAX_VALUE 500;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform17
{
	Y_AXIS yaxis17;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 12;
		X_VALUES
		{
			trans1_hys_ref_vs_0,
			trans1_hys_ref_vs_1,
			trans1_hys_ref_vs_2,
			trans1_hys_ref_vs_3,
			trans1_hys_ref_vs_4,
			trans1_hys_ref_vs_5,
			trans1_hys_ref_vs_6,
			trans1_hys_ref_vs_7,
			trans1_hys_ref_vs_8,
			trans1_hys_ref_vs_9,
			trans1_hys_ref_vs_10,
			trans1_hys_ref_vs_11

		}
		Y_VALUES
		{
	        trans1_hys_ref_hys_0,
	        trans1_hys_ref_hys_1,
	        trans1_hys_ref_hys_2,
	        trans1_hys_ref_hys_3,
	        trans1_hys_ref_hys_4,
	        trans1_hys_ref_hys_5,
	        trans1_hys_ref_hys_6,
	        trans1_hys_ref_hys_7,
	        trans1_hys_ref_hys_8,
	        trans1_hys_ref_hys_9,
	        trans1_hys_ref_hys_10,
	        trans1_hys_ref_hys_11
	  }
  }
}

WAVEFORM waveform18
{
	Y_AXIS yaxis18;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 12;
		X_VALUES
		{
			trans1_hys_ref_vs_0,
			trans1_hys_ref_vs_1,
			trans1_hys_ref_vs_2,
			trans1_hys_ref_vs_3,
			trans1_hys_ref_vs_4,
			trans1_hys_ref_vs_5,
			trans1_hys_ref_vs_6,
			trans1_hys_ref_vs_7,
			trans1_hys_ref_vs_8,
			trans1_hys_ref_vs_9,
			trans1_hys_ref_vs_10,
			trans1_hys_ref_vs_11
		}
		Y_VALUES
		{
	        trans1_hys_again_hys_0,
	        trans1_hys_again_hys_1,
	        trans1_hys_again_hys_2,
	        trans1_hys_again_hys_3,
	        trans1_hys_again_hys_4,
	        trans1_hys_again_hys_5,
	        trans1_hys_again_hys_6,
	        trans1_hys_again_hys_7,
	        trans1_hys_again_hys_8,
	        trans1_hys_again_hys_9,
	        trans1_hys_again_hys_10,
	        trans1_hys_again_hys_11
	  }
  }
}

#endif

/*----------------- Diagramm Statische Kennlinie MAN ------------------------------------*/

MENU OnlineWindow_diag_stat_char
{
	LABEL "Static characteristic" "|de|Statische Kennlinie";
    STYLE WINDOW;
    ITEMS
	{
        trans1_stat_kenn_start,
    	trans1_stat_kenn_ende,
    	trans1_stat_kenn_warte,
    	trans1_stat_kenn_anzahl,
		transmit_button,
		SEPARATOR,
		trans1_stat_kenn_sprunghoehe,
		trans1_stat_kenn_min_tot,
		trans1_stat_kenn_durch_tot,
		trans1_stat_kenn_max_tot,
        Tab_s_static_charact_online
    }
}

/* Statische Kennlinie ************************************************************/
MENU Tab_s_static_charact_online
{
	LABEL "Static characteristic measurement" "|de|Statische Kennlinie Messung";

    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph12,
#endif
	  start_static_char,
	  abort_static_char,
      trans1_stat_kenn_testinfo,
      trans1_stat_kenn_progress
    }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph12
{
	LABEL "Static characteristic" "|de|Statische Kennlinie";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis16;
	MEMBERS
	{
		WAVEFORM19, waveform19;
	}
}

AXIS xaxis16
{
	LABEL "Reference variable w" "|de|Fhrungsgre w";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis19
{
	LABEL "Valve position x" "|de|Ventilposition x";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform19
{
	Y_AXIS yaxis19;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_stat_sw_1_0,
            trans1_stat_sw_1_1,
            trans1_stat_sw_1_2,
            trans1_stat_sw_1_3,
            trans1_stat_sw_1_4,
            trans1_stat_sw_1_5,
            trans1_stat_sw_1_6,
            trans1_stat_sw_1_7,
            trans1_stat_sw_1_8,
            trans1_stat_sw_1_9,
            trans1_stat_sw_1_10,
            trans1_stat_sw_1_11,
            trans1_stat_sw_1_12,
            trans1_stat_sw_1_13,
            trans1_stat_sw_1_14,
            trans1_stat_sw_1_15,
            trans1_stat_sw_1_16,
            trans1_stat_sw_1_17,
            trans1_stat_sw_1_18,
            trans1_stat_sw_1_19,
            trans1_stat_sw_1_20,
            trans1_stat_sw_1_21,
            trans1_stat_sw_1_22,
            trans1_stat_sw_1_23,
            trans1_stat_sw_1_24,
            trans1_stat_sw_2_0,
            trans1_stat_sw_2_1,
            trans1_stat_sw_2_2,
            trans1_stat_sw_2_3,
            trans1_stat_sw_2_4,
            trans1_stat_sw_2_5,
            trans1_stat_sw_2_6,
            trans1_stat_sw_2_7,
            trans1_stat_sw_2_8,
            trans1_stat_sw_2_9,
            trans1_stat_sw_2_10,
            trans1_stat_sw_2_11,
            trans1_stat_sw_2_12,
            trans1_stat_sw_2_13,
            trans1_stat_sw_2_14,
            trans1_stat_sw_2_15,
            trans1_stat_sw_2_16,
            trans1_stat_sw_2_17,
            trans1_stat_sw_2_18,
            trans1_stat_sw_2_19,
            trans1_stat_sw_2_20,
            trans1_stat_sw_2_21,
            trans1_stat_sw_2_22,
            trans1_stat_sw_2_23,
            trans1_stat_sw_2_24,
            trans1_stat_sw_3_0,
            trans1_stat_sw_3_1,
            trans1_stat_sw_3_2,
            trans1_stat_sw_3_3,
            trans1_stat_sw_3_4,
            trans1_stat_sw_3_5,
            trans1_stat_sw_3_6,
            trans1_stat_sw_3_7,
            trans1_stat_sw_3_8,
            trans1_stat_sw_3_9,
            trans1_stat_sw_3_10,
            trans1_stat_sw_3_11,
            trans1_stat_sw_3_12,
            trans1_stat_sw_3_13,
            trans1_stat_sw_3_14,
            trans1_stat_sw_3_15,
            trans1_stat_sw_3_16,
            trans1_stat_sw_3_17,
            trans1_stat_sw_3_18,
            trans1_stat_sw_3_19,
            trans1_stat_sw_3_20,
            trans1_stat_sw_3_21,
            trans1_stat_sw_3_22,
            trans1_stat_sw_3_23,
            trans1_stat_sw_3_24,
            trans1_stat_sw_4_0,
            trans1_stat_sw_4_1,
            trans1_stat_sw_4_2,
            trans1_stat_sw_4_3,
            trans1_stat_sw_4_4,
            trans1_stat_sw_4_5,
            trans1_stat_sw_4_6,
            trans1_stat_sw_4_7,
            trans1_stat_sw_4_8,
            trans1_stat_sw_4_9,
            trans1_stat_sw_4_10,
            trans1_stat_sw_4_11,
            trans1_stat_sw_4_12,
            trans1_stat_sw_4_13,
            trans1_stat_sw_4_14,
            trans1_stat_sw_4_15,
            trans1_stat_sw_4_16,
            trans1_stat_sw_4_17,
            trans1_stat_sw_4_18,
            trans1_stat_sw_4_19,
            trans1_stat_sw_4_20,
            trans1_stat_sw_4_21,
            trans1_stat_sw_4_22,
            trans1_stat_sw_4_23,
            trans1_stat_sw_4_24
		}
		Y_VALUES
		{
	        trans1_stat_vs_1_0,
            trans1_stat_vs_1_1,
            trans1_stat_vs_1_2,
            trans1_stat_vs_1_3,
            trans1_stat_vs_1_4,
            trans1_stat_vs_1_5,
            trans1_stat_vs_1_6,
            trans1_stat_vs_1_7,
            trans1_stat_vs_1_8,
            trans1_stat_vs_1_9,
            trans1_stat_vs_1_10,
            trans1_stat_vs_1_11,
            trans1_stat_vs_1_12,
            trans1_stat_vs_1_13,
            trans1_stat_vs_1_14,
            trans1_stat_vs_1_15,
            trans1_stat_vs_1_16,
            trans1_stat_vs_1_17,
            trans1_stat_vs_1_18,
            trans1_stat_vs_1_19,
            trans1_stat_vs_1_20,
            trans1_stat_vs_1_21,
            trans1_stat_vs_1_22,
            trans1_stat_vs_1_23,
            trans1_stat_vs_1_24,
            trans1_stat_vs_2_0,
            trans1_stat_vs_2_1,
            trans1_stat_vs_2_2,
            trans1_stat_vs_2_3,
            trans1_stat_vs_2_4,
            trans1_stat_vs_2_5,
            trans1_stat_vs_2_6,
            trans1_stat_vs_2_7,
            trans1_stat_vs_2_8,
            trans1_stat_vs_2_9,
            trans1_stat_vs_2_10,
            trans1_stat_vs_2_11,
            trans1_stat_vs_2_12,
            trans1_stat_vs_2_13,
            trans1_stat_vs_2_14,
            trans1_stat_vs_2_15,
            trans1_stat_vs_2_16,
            trans1_stat_vs_2_17,
            trans1_stat_vs_2_18,
            trans1_stat_vs_2_19,
            trans1_stat_vs_2_20,
            trans1_stat_vs_2_21,
            trans1_stat_vs_2_22,
            trans1_stat_vs_2_23,
            trans1_stat_vs_2_24,
            trans1_stat_vs_3_0,
            trans1_stat_vs_3_1,
            trans1_stat_vs_3_2,
            trans1_stat_vs_3_3,
            trans1_stat_vs_3_4,
            trans1_stat_vs_3_5,
            trans1_stat_vs_3_6,
            trans1_stat_vs_3_7,
            trans1_stat_vs_3_8,
            trans1_stat_vs_3_9,
            trans1_stat_vs_3_10,
            trans1_stat_vs_3_11,
            trans1_stat_vs_3_12,
            trans1_stat_vs_3_13,
            trans1_stat_vs_3_14,
            trans1_stat_vs_3_15,
            trans1_stat_vs_3_16,
            trans1_stat_vs_3_17,
            trans1_stat_vs_3_18,
            trans1_stat_vs_3_19,
            trans1_stat_vs_3_20,
            trans1_stat_vs_3_21,
            trans1_stat_vs_3_22,
            trans1_stat_vs_3_23,
            trans1_stat_vs_3_24,
            trans1_stat_vs_4_0,
            trans1_stat_vs_4_1,
            trans1_stat_vs_4_2,
            trans1_stat_vs_4_3,
            trans1_stat_vs_4_4,
            trans1_stat_vs_4_5,
            trans1_stat_vs_4_6,
            trans1_stat_vs_4_7,
            trans1_stat_vs_4_8,
            trans1_stat_vs_4_9,
            trans1_stat_vs_4_10,
            trans1_stat_vs_4_11,
            trans1_stat_vs_4_12,
            trans1_stat_vs_4_13,
            trans1_stat_vs_4_14,
            trans1_stat_vs_4_15,
            trans1_stat_vs_4_16,
            trans1_stat_vs_4_17,
            trans1_stat_vs_4_18,
            trans1_stat_vs_4_19,
            trans1_stat_vs_4_20,
            trans1_stat_vs_4_21,
            trans1_stat_vs_4_22,
            trans1_stat_vs_4_23,
            trans1_stat_vs_4_24
	  }
  }
}

#endif

/*----------------- Diagramm Sprungantwort MAN ------------------------------------*/

MENU OnlineWindow_diag_step
{
    LABEL     "Step response" "|de|Sprungantwort";
    STYLE WINDOW;
    ITEMS
	{
	    trans1_Stepstart,
		trans1_Stepend,
		trans1_Step_Sample_Rate,
/* kmr: fuer ESD: */
/*		trans1_Rampe_Up,
		trans1_Rampe_Down,*/
		trans1_Latency_After_Step,
	    trans1_Duration_of_test,
	    trans1_Step_Selection,
	    transmit_button,
	    SEPARATOR,
  	    trans1_Overshoot_Rising,
		trans1_Overshoot_Falling,
		trans1_Dead_Time_Rising,
		trans1_Dead_Time_Falling,
		trans1_Time_63_Rising,
		trans1_Time_63_Falling,
		trans1_Time_98_Rising,
		trans1_Time_98_Falling,
	    trans1_Rise_Time_Rising,
		trans1_Rise_Time_Falling,
	    trans1_Settling_Time_Rising,
	    trans1_Settling_Time_Falling,

        Tab_s_step_response_online
  }
}

/* Sprungantwort ************************************************************/
MENU Tab_s_step_response_online
{
    LABEL     "Step response measurement" "|de|Sprungantwort Messung";

    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      graph13,
#endif
	  	start_step_response,  /* Methode */
	  	abort_step_response,  /* Methode */
    	trans1_Testinfo,
    	trans1_Step_Progress,

      trans1_actual_mode,
      trans1_target_mode
    }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph13
{
    LABEL     "Step response" "|de|Sprungantwort";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis17;
	MEMBERS
	{
		WAVEFORM20, waveform20;
		WAVEFORM21, waveform21;
		WAVEFORM22, waveform22;
		WAVEFORM23, waveform23;
	}
}

AXIS xaxis17
{
	LABEL "Time t" "|de|Zeit t";
	MIN_VALUE 0;
	MAX_VALUE 10;
	CONSTANT_UNIT "s";
}

AXIS yaxis20
{
	LABEL "Reference variable w" "|de|Fhrungsgre w";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis21
{
	LABEL "Setpoint deviation e" "|de|Regelabweichung e";
	MIN_VALUE 0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis22
{
	LABEL "Drive signal y" "|de|Stellsignal y";
	MIN_VALUE 0;
	MAX_VALUE 10000;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform20
{
	Y_AXIS yaxis19;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_sprung_t_1_0,
            trans1_sprung_t_1_1,
            trans1_sprung_t_1_2,
            trans1_sprung_t_1_3,
            trans1_sprung_t_1_4,
            trans1_sprung_t_1_5,
            trans1_sprung_t_1_6,
            trans1_sprung_t_1_7,
            trans1_sprung_t_1_8,
            trans1_sprung_t_1_9,
            trans1_sprung_t_1_10,
            trans1_sprung_t_1_11,
            trans1_sprung_t_1_12,
            trans1_sprung_t_1_13,
            trans1_sprung_t_1_14,
            trans1_sprung_t_1_15,
            trans1_sprung_t_1_16,
            trans1_sprung_t_1_17,
            trans1_sprung_t_1_18,
            trans1_sprung_t_1_19,
            trans1_sprung_t_1_20,
            trans1_sprung_t_1_21,
            trans1_sprung_t_1_22,
            trans1_sprung_t_1_23,
            trans1_sprung_t_1_24,
            trans1_sprung_t_2_0,
            trans1_sprung_t_2_1,
            trans1_sprung_t_2_2,
            trans1_sprung_t_2_3,
            trans1_sprung_t_2_4,
            trans1_sprung_t_2_5,
            trans1_sprung_t_2_6,
            trans1_sprung_t_2_7,
            trans1_sprung_t_2_8,
            trans1_sprung_t_2_9,
            trans1_sprung_t_2_10,
            trans1_sprung_t_2_11,
            trans1_sprung_t_2_12,
            trans1_sprung_t_2_13,
            trans1_sprung_t_2_14,
            trans1_sprung_t_2_15,
            trans1_sprung_t_2_16,
            trans1_sprung_t_2_17,
            trans1_sprung_t_2_18,
            trans1_sprung_t_2_19,
            trans1_sprung_t_2_20,
            trans1_sprung_t_2_21,
            trans1_sprung_t_2_22,
            trans1_sprung_t_2_23,
            trans1_sprung_t_2_24,
            trans1_sprung_t_3_0,
            trans1_sprung_t_3_1,
            trans1_sprung_t_3_2,
            trans1_sprung_t_3_3,
            trans1_sprung_t_3_4,
            trans1_sprung_t_3_5,
            trans1_sprung_t_3_6,
            trans1_sprung_t_3_7,
            trans1_sprung_t_3_8,
            trans1_sprung_t_3_9,
            trans1_sprung_t_3_10,
            trans1_sprung_t_3_11,
            trans1_sprung_t_3_12,
            trans1_sprung_t_3_13,
            trans1_sprung_t_3_14,
            trans1_sprung_t_3_15,
            trans1_sprung_t_3_16,
            trans1_sprung_t_3_17,
            trans1_sprung_t_3_18,
            trans1_sprung_t_3_19,
            trans1_sprung_t_3_20,
            trans1_sprung_t_3_21,
            trans1_sprung_t_3_22,
            trans1_sprung_t_3_23,
            trans1_sprung_t_3_24,
            trans1_sprung_t_4_0,
            trans1_sprung_t_4_1,
            trans1_sprung_t_4_2,
            trans1_sprung_t_4_3,
            trans1_sprung_t_4_4,
            trans1_sprung_t_4_5,
            trans1_sprung_t_4_6,
            trans1_sprung_t_4_7,
            trans1_sprung_t_4_8,
            trans1_sprung_t_4_9,
            trans1_sprung_t_4_10,
            trans1_sprung_t_4_11,
            trans1_sprung_t_4_12,
            trans1_sprung_t_4_13,
            trans1_sprung_t_4_14,
            trans1_sprung_t_4_15,
            trans1_sprung_t_4_16,
            trans1_sprung_t_4_17,
            trans1_sprung_t_4_18,
            trans1_sprung_t_4_19,
            trans1_sprung_t_4_20,
            trans1_sprung_t_4_21,
            trans1_sprung_t_4_22,
            trans1_sprung_t_4_23,
            trans1_sprung_t_4_24
		}
		Y_VALUES
		{
	        trans1_sprung_vs_1_0,
            trans1_sprung_vs_1_1,
            trans1_sprung_vs_1_2,
            trans1_sprung_vs_1_3,
            trans1_sprung_vs_1_4,
            trans1_sprung_vs_1_5,
            trans1_sprung_vs_1_6,
            trans1_sprung_vs_1_7,
            trans1_sprung_vs_1_8,
            trans1_sprung_vs_1_9,
            trans1_sprung_vs_1_10,
            trans1_sprung_vs_1_11,
            trans1_sprung_vs_1_12,
            trans1_sprung_vs_1_13,
            trans1_sprung_vs_1_14,
            trans1_sprung_vs_1_15,
            trans1_sprung_vs_1_16,
            trans1_sprung_vs_1_17,
            trans1_sprung_vs_1_18,
            trans1_sprung_vs_1_19,
            trans1_sprung_vs_1_20,
            trans1_sprung_vs_1_21,
            trans1_sprung_vs_1_22,
            trans1_sprung_vs_1_23,
            trans1_sprung_vs_1_24,
            trans1_sprung_vs_2_0,
            trans1_sprung_vs_2_1,
            trans1_sprung_vs_2_2,
            trans1_sprung_vs_2_3,
            trans1_sprung_vs_2_4,
            trans1_sprung_vs_2_5,
            trans1_sprung_vs_2_6,
            trans1_sprung_vs_2_7,
            trans1_sprung_vs_2_8,
            trans1_sprung_vs_2_9,
            trans1_sprung_vs_2_10,
            trans1_sprung_vs_2_11,
            trans1_sprung_vs_2_12,
            trans1_sprung_vs_2_13,
            trans1_sprung_vs_2_14,
            trans1_sprung_vs_2_15,
            trans1_sprung_vs_2_16,
            trans1_sprung_vs_2_17,
            trans1_sprung_vs_2_18,
            trans1_sprung_vs_2_19,
            trans1_sprung_vs_2_20,
            trans1_sprung_vs_2_21,
            trans1_sprung_vs_2_22,
            trans1_sprung_vs_2_23,
            trans1_sprung_vs_2_24,
            trans1_sprung_vs_3_0,
            trans1_sprung_vs_3_1,
            trans1_sprung_vs_3_2,
            trans1_sprung_vs_3_3,
            trans1_sprung_vs_3_4,
            trans1_sprung_vs_3_5,
            trans1_sprung_vs_3_6,
            trans1_sprung_vs_3_7,
            trans1_sprung_vs_3_8,
            trans1_sprung_vs_3_9,
            trans1_sprung_vs_3_10,
            trans1_sprung_vs_3_11,
            trans1_sprung_vs_3_12,
            trans1_sprung_vs_3_13,
            trans1_sprung_vs_3_14,
            trans1_sprung_vs_3_15,
            trans1_sprung_vs_3_16,
            trans1_sprung_vs_3_17,
            trans1_sprung_vs_3_18,
            trans1_sprung_vs_3_19,
            trans1_sprung_vs_3_20,
            trans1_sprung_vs_3_21,
            trans1_sprung_vs_3_22,
            trans1_sprung_vs_3_23,
            trans1_sprung_vs_3_24,
            trans1_sprung_vs_4_0,
            trans1_sprung_vs_4_1,
            trans1_sprung_vs_4_2,
            trans1_sprung_vs_4_3,
            trans1_sprung_vs_4_4,
            trans1_sprung_vs_4_5,
            trans1_sprung_vs_4_6,
            trans1_sprung_vs_4_7,
            trans1_sprung_vs_4_8,
            trans1_sprung_vs_4_9,
            trans1_sprung_vs_4_10,
            trans1_sprung_vs_4_11,
            trans1_sprung_vs_4_12,
            trans1_sprung_vs_4_13,
            trans1_sprung_vs_4_14,
            trans1_sprung_vs_4_15,
            trans1_sprung_vs_4_16,
            trans1_sprung_vs_4_17,
            trans1_sprung_vs_4_18,
            trans1_sprung_vs_4_19,
            trans1_sprung_vs_4_20,
            trans1_sprung_vs_4_21,
            trans1_sprung_vs_4_22,
            trans1_sprung_vs_4_23,
            trans1_sprung_vs_4_24
	  }
  }
}

WAVEFORM waveform21
{
	Y_AXIS yaxis20;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_sprung_t_1_0,
            trans1_sprung_t_1_1,
            trans1_sprung_t_1_2,
            trans1_sprung_t_1_3,
            trans1_sprung_t_1_4,
            trans1_sprung_t_1_5,
            trans1_sprung_t_1_6,
            trans1_sprung_t_1_7,
            trans1_sprung_t_1_8,
            trans1_sprung_t_1_9,
            trans1_sprung_t_1_10,
            trans1_sprung_t_1_11,
            trans1_sprung_t_1_12,
            trans1_sprung_t_1_13,
            trans1_sprung_t_1_14,
            trans1_sprung_t_1_15,
            trans1_sprung_t_1_16,
            trans1_sprung_t_1_17,
            trans1_sprung_t_1_18,
            trans1_sprung_t_1_19,
            trans1_sprung_t_1_20,
            trans1_sprung_t_1_21,
            trans1_sprung_t_1_22,
            trans1_sprung_t_1_23,
            trans1_sprung_t_1_24,
            trans1_sprung_t_2_0,
            trans1_sprung_t_2_1,
            trans1_sprung_t_2_2,
            trans1_sprung_t_2_3,
            trans1_sprung_t_2_4,
            trans1_sprung_t_2_5,
            trans1_sprung_t_2_6,
            trans1_sprung_t_2_7,
            trans1_sprung_t_2_8,
            trans1_sprung_t_2_9,
            trans1_sprung_t_2_10,
            trans1_sprung_t_2_11,
            trans1_sprung_t_2_12,
            trans1_sprung_t_2_13,
            trans1_sprung_t_2_14,
            trans1_sprung_t_2_15,
            trans1_sprung_t_2_16,
            trans1_sprung_t_2_17,
            trans1_sprung_t_2_18,
            trans1_sprung_t_2_19,
            trans1_sprung_t_2_20,
            trans1_sprung_t_2_21,
            trans1_sprung_t_2_22,
            trans1_sprung_t_2_23,
            trans1_sprung_t_2_24,
            trans1_sprung_t_3_0,
            trans1_sprung_t_3_1,
            trans1_sprung_t_3_2,
            trans1_sprung_t_3_3,
            trans1_sprung_t_3_4,
            trans1_sprung_t_3_5,
            trans1_sprung_t_3_6,
            trans1_sprung_t_3_7,
            trans1_sprung_t_3_8,
            trans1_sprung_t_3_9,
            trans1_sprung_t_3_10,
            trans1_sprung_t_3_11,
            trans1_sprung_t_3_12,
            trans1_sprung_t_3_13,
            trans1_sprung_t_3_14,
            trans1_sprung_t_3_15,
            trans1_sprung_t_3_16,
            trans1_sprung_t_3_17,
            trans1_sprung_t_3_18,
            trans1_sprung_t_3_19,
            trans1_sprung_t_3_20,
            trans1_sprung_t_3_21,
            trans1_sprung_t_3_22,
            trans1_sprung_t_3_23,
            trans1_sprung_t_3_24,
            trans1_sprung_t_4_0,
            trans1_sprung_t_4_1,
            trans1_sprung_t_4_2,
            trans1_sprung_t_4_3,
            trans1_sprung_t_4_4,
            trans1_sprung_t_4_5,
            trans1_sprung_t_4_6,
            trans1_sprung_t_4_7,
            trans1_sprung_t_4_8,
            trans1_sprung_t_4_9,
            trans1_sprung_t_4_10,
            trans1_sprung_t_4_11,
            trans1_sprung_t_4_12,
            trans1_sprung_t_4_13,
            trans1_sprung_t_4_14,
            trans1_sprung_t_4_15,
            trans1_sprung_t_4_16,
            trans1_sprung_t_4_17,
            trans1_sprung_t_4_18,
            trans1_sprung_t_4_19,
            trans1_sprung_t_4_20,
            trans1_sprung_t_4_21,
            trans1_sprung_t_4_22,
            trans1_sprung_t_4_23,
            trans1_sprung_t_4_24
		}
		Y_VALUES
		{
	        trans1_sprung_sw_1_0,
            trans1_sprung_sw_1_1,
            trans1_sprung_sw_1_2,
            trans1_sprung_sw_1_3,
            trans1_sprung_sw_1_4,
            trans1_sprung_sw_1_5,
            trans1_sprung_sw_1_6,
            trans1_sprung_sw_1_7,
            trans1_sprung_sw_1_8,
            trans1_sprung_sw_1_9,
            trans1_sprung_sw_1_10,
            trans1_sprung_sw_1_11,
            trans1_sprung_sw_1_12,
            trans1_sprung_sw_1_13,
            trans1_sprung_sw_1_14,
            trans1_sprung_sw_1_15,
            trans1_sprung_sw_1_16,
            trans1_sprung_sw_1_17,
            trans1_sprung_sw_1_18,
            trans1_sprung_sw_1_19,
            trans1_sprung_sw_1_20,
            trans1_sprung_sw_1_21,
            trans1_sprung_sw_1_22,
            trans1_sprung_sw_1_23,
            trans1_sprung_sw_1_24,
            trans1_sprung_sw_2_0,
            trans1_sprung_sw_2_1,
            trans1_sprung_sw_2_2,
            trans1_sprung_sw_2_3,
            trans1_sprung_sw_2_4,
            trans1_sprung_sw_2_5,
            trans1_sprung_sw_2_6,
            trans1_sprung_sw_2_7,
            trans1_sprung_sw_2_8,
            trans1_sprung_sw_2_9,
            trans1_sprung_sw_2_10,
            trans1_sprung_sw_2_11,
            trans1_sprung_sw_2_12,
            trans1_sprung_sw_2_13,
            trans1_sprung_sw_2_14,
            trans1_sprung_sw_2_15,
            trans1_sprung_sw_2_16,
            trans1_sprung_sw_2_17,
            trans1_sprung_sw_2_18,
            trans1_sprung_sw_2_19,
            trans1_sprung_sw_2_20,
            trans1_sprung_sw_2_21,
            trans1_sprung_sw_2_22,
            trans1_sprung_sw_2_23,
            trans1_sprung_sw_2_24,
            trans1_sprung_sw_3_0,
            trans1_sprung_sw_3_1,
            trans1_sprung_sw_3_2,
            trans1_sprung_sw_3_3,
            trans1_sprung_sw_3_4,
            trans1_sprung_sw_3_5,
            trans1_sprung_sw_3_6,
            trans1_sprung_sw_3_7,
            trans1_sprung_sw_3_8,
            trans1_sprung_sw_3_9,
            trans1_sprung_sw_3_10,
            trans1_sprung_sw_3_11,
            trans1_sprung_sw_3_12,
            trans1_sprung_sw_3_13,
            trans1_sprung_sw_3_14,
            trans1_sprung_sw_3_15,
            trans1_sprung_sw_3_16,
            trans1_sprung_sw_3_17,
            trans1_sprung_sw_3_18,
            trans1_sprung_sw_3_19,
            trans1_sprung_sw_3_20,
            trans1_sprung_sw_3_21,
            trans1_sprung_sw_3_22,
            trans1_sprung_sw_3_23,
            trans1_sprung_sw_3_24,
            trans1_sprung_sw_4_0,
            trans1_sprung_sw_4_1,
            trans1_sprung_sw_4_2,
            trans1_sprung_sw_4_3,
            trans1_sprung_sw_4_4,
            trans1_sprung_sw_4_5,
            trans1_sprung_sw_4_6,
            trans1_sprung_sw_4_7,
            trans1_sprung_sw_4_8,
            trans1_sprung_sw_4_9,
            trans1_sprung_sw_4_10,
            trans1_sprung_sw_4_11,
            trans1_sprung_sw_4_12,
            trans1_sprung_sw_4_13,
            trans1_sprung_sw_4_14,
            trans1_sprung_sw_4_15,
            trans1_sprung_sw_4_16,
            trans1_sprung_sw_4_17,
            trans1_sprung_sw_4_18,
            trans1_sprung_sw_4_19,
            trans1_sprung_sw_4_20,
            trans1_sprung_sw_4_21,
            trans1_sprung_sw_4_22,
            trans1_sprung_sw_4_23,
            trans1_sprung_sw_4_24
	  }
  }
}

WAVEFORM waveform22
{
	Y_AXIS yaxis21;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_sprung_t_1_0,
            trans1_sprung_t_1_1,
            trans1_sprung_t_1_2,
            trans1_sprung_t_1_3,
            trans1_sprung_t_1_4,
            trans1_sprung_t_1_5,
            trans1_sprung_t_1_6,
            trans1_sprung_t_1_7,
            trans1_sprung_t_1_8,
            trans1_sprung_t_1_9,
            trans1_sprung_t_1_10,
            trans1_sprung_t_1_11,
            trans1_sprung_t_1_12,
            trans1_sprung_t_1_13,
            trans1_sprung_t_1_14,
            trans1_sprung_t_1_15,
            trans1_sprung_t_1_16,
            trans1_sprung_t_1_17,
            trans1_sprung_t_1_18,
            trans1_sprung_t_1_19,
            trans1_sprung_t_1_20,
            trans1_sprung_t_1_21,
            trans1_sprung_t_1_22,
            trans1_sprung_t_1_23,
            trans1_sprung_t_1_24,
            trans1_sprung_t_2_0,
            trans1_sprung_t_2_1,
            trans1_sprung_t_2_2,
            trans1_sprung_t_2_3,
            trans1_sprung_t_2_4,
            trans1_sprung_t_2_5,
            trans1_sprung_t_2_6,
            trans1_sprung_t_2_7,
            trans1_sprung_t_2_8,
            trans1_sprung_t_2_9,
            trans1_sprung_t_2_10,
            trans1_sprung_t_2_11,
            trans1_sprung_t_2_12,
            trans1_sprung_t_2_13,
            trans1_sprung_t_2_14,
            trans1_sprung_t_2_15,
            trans1_sprung_t_2_16,
            trans1_sprung_t_2_17,
            trans1_sprung_t_2_18,
            trans1_sprung_t_2_19,
            trans1_sprung_t_2_20,
            trans1_sprung_t_2_21,
            trans1_sprung_t_2_22,
            trans1_sprung_t_2_23,
            trans1_sprung_t_2_24,
            trans1_sprung_t_3_0,
            trans1_sprung_t_3_1,
            trans1_sprung_t_3_2,
            trans1_sprung_t_3_3,
            trans1_sprung_t_3_4,
            trans1_sprung_t_3_5,
            trans1_sprung_t_3_6,
            trans1_sprung_t_3_7,
            trans1_sprung_t_3_8,
            trans1_sprung_t_3_9,
            trans1_sprung_t_3_10,
            trans1_sprung_t_3_11,
            trans1_sprung_t_3_12,
            trans1_sprung_t_3_13,
            trans1_sprung_t_3_14,
            trans1_sprung_t_3_15,
            trans1_sprung_t_3_16,
            trans1_sprung_t_3_17,
            trans1_sprung_t_3_18,
            trans1_sprung_t_3_19,
            trans1_sprung_t_3_20,
            trans1_sprung_t_3_21,
            trans1_sprung_t_3_22,
            trans1_sprung_t_3_23,
            trans1_sprung_t_3_24,
            trans1_sprung_t_4_0,
            trans1_sprung_t_4_1,
            trans1_sprung_t_4_2,
            trans1_sprung_t_4_3,
            trans1_sprung_t_4_4,
            trans1_sprung_t_4_5,
            trans1_sprung_t_4_6,
            trans1_sprung_t_4_7,
            trans1_sprung_t_4_8,
            trans1_sprung_t_4_9,
            trans1_sprung_t_4_10,
            trans1_sprung_t_4_11,
            trans1_sprung_t_4_12,
            trans1_sprung_t_4_13,
            trans1_sprung_t_4_14,
            trans1_sprung_t_4_15,
            trans1_sprung_t_4_16,
            trans1_sprung_t_4_17,
            trans1_sprung_t_4_18,
            trans1_sprung_t_4_19,
            trans1_sprung_t_4_20,
            trans1_sprung_t_4_21,
            trans1_sprung_t_4_22,
            trans1_sprung_t_4_23,
            trans1_sprung_t_4_24
		}
		Y_VALUES
		{
	        trans1_sprung_e_1_0,
            trans1_sprung_e_1_1,
            trans1_sprung_e_1_2,
            trans1_sprung_e_1_3,
            trans1_sprung_e_1_4,
            trans1_sprung_e_1_5,
            trans1_sprung_e_1_6,
            trans1_sprung_e_1_7,
            trans1_sprung_e_1_8,
            trans1_sprung_e_1_9,
            trans1_sprung_e_1_10,
            trans1_sprung_e_1_11,
            trans1_sprung_e_1_12,
            trans1_sprung_e_1_13,
            trans1_sprung_e_1_14,
            trans1_sprung_e_1_15,
            trans1_sprung_e_1_16,
            trans1_sprung_e_1_17,
            trans1_sprung_e_1_18,
            trans1_sprung_e_1_19,
            trans1_sprung_e_1_20,
            trans1_sprung_e_1_21,
            trans1_sprung_e_1_22,
            trans1_sprung_e_1_23,
            trans1_sprung_e_1_24,
            trans1_sprung_e_2_0,
            trans1_sprung_e_2_1,
            trans1_sprung_e_2_2,
            trans1_sprung_e_2_3,
            trans1_sprung_e_2_4,
            trans1_sprung_e_2_5,
            trans1_sprung_e_2_6,
            trans1_sprung_e_2_7,
            trans1_sprung_e_2_8,
            trans1_sprung_e_2_9,
            trans1_sprung_e_2_10,
            trans1_sprung_e_2_11,
            trans1_sprung_e_2_12,
            trans1_sprung_e_2_13,
            trans1_sprung_e_2_14,
            trans1_sprung_e_2_15,
            trans1_sprung_e_2_16,
            trans1_sprung_e_2_17,
            trans1_sprung_e_2_18,
            trans1_sprung_e_2_19,
            trans1_sprung_e_2_20,
            trans1_sprung_e_2_21,
            trans1_sprung_e_2_22,
            trans1_sprung_e_2_23,
            trans1_sprung_e_2_24,
            trans1_sprung_e_3_0,
            trans1_sprung_e_3_1,
            trans1_sprung_e_3_2,
            trans1_sprung_e_3_3,
            trans1_sprung_e_3_4,
            trans1_sprung_e_3_5,
            trans1_sprung_e_3_6,
            trans1_sprung_e_3_7,
            trans1_sprung_e_3_8,
            trans1_sprung_e_3_9,
            trans1_sprung_e_3_10,
            trans1_sprung_e_3_11,
            trans1_sprung_e_3_12,
            trans1_sprung_e_3_13,
            trans1_sprung_e_3_14,
            trans1_sprung_e_3_15,
            trans1_sprung_e_3_16,
            trans1_sprung_e_3_17,
            trans1_sprung_e_3_18,
            trans1_sprung_e_3_19,
            trans1_sprung_e_3_20,
            trans1_sprung_e_3_21,
            trans1_sprung_e_3_22,
            trans1_sprung_e_3_23,
            trans1_sprung_e_3_24,
            trans1_sprung_e_4_0,
            trans1_sprung_e_4_1,
            trans1_sprung_e_4_2,
            trans1_sprung_e_4_3,
            trans1_sprung_e_4_4,
            trans1_sprung_e_4_5,
            trans1_sprung_e_4_6,
            trans1_sprung_e_4_7,
            trans1_sprung_e_4_8,
            trans1_sprung_e_4_9,
            trans1_sprung_e_4_10,
            trans1_sprung_e_4_11,
            trans1_sprung_e_4_12,
            trans1_sprung_e_4_13,
            trans1_sprung_e_4_14,
            trans1_sprung_e_4_15,
            trans1_sprung_e_4_16,
            trans1_sprung_e_4_17,
            trans1_sprung_e_4_18,
            trans1_sprung_e_4_19,
            trans1_sprung_e_4_20,
            trans1_sprung_e_4_21,
            trans1_sprung_e_4_22,
            trans1_sprung_e_4_23,
            trans1_sprung_e_4_24
	  }
  }
}

WAVEFORM waveform23
{
	Y_AXIS yaxis22;
    EMPHASIS TRUE;
    LINE_COLOR 0x00b3df ;   /* Farbe Gelbbraun */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			trans1_sprung_t_1_0,
            trans1_sprung_t_1_1,
            trans1_sprung_t_1_2,
            trans1_sprung_t_1_3,
            trans1_sprung_t_1_4,
            trans1_sprung_t_1_5,
            trans1_sprung_t_1_6,
            trans1_sprung_t_1_7,
            trans1_sprung_t_1_8,
            trans1_sprung_t_1_9,
            trans1_sprung_t_1_10,
            trans1_sprung_t_1_11,
            trans1_sprung_t_1_12,
            trans1_sprung_t_1_13,
            trans1_sprung_t_1_14,
            trans1_sprung_t_1_15,
            trans1_sprung_t_1_16,
            trans1_sprung_t_1_17,
            trans1_sprung_t_1_18,
            trans1_sprung_t_1_19,
            trans1_sprung_t_1_20,
            trans1_sprung_t_1_21,
            trans1_sprung_t_1_22,
            trans1_sprung_t_1_23,
            trans1_sprung_t_1_24,
            trans1_sprung_t_2_0,
            trans1_sprung_t_2_1,
            trans1_sprung_t_2_2,
            trans1_sprung_t_2_3,
            trans1_sprung_t_2_4,
            trans1_sprung_t_2_5,
            trans1_sprung_t_2_6,
            trans1_sprung_t_2_7,
            trans1_sprung_t_2_8,
            trans1_sprung_t_2_9,
            trans1_sprung_t_2_10,
            trans1_sprung_t_2_11,
            trans1_sprung_t_2_12,
            trans1_sprung_t_2_13,
            trans1_sprung_t_2_14,
            trans1_sprung_t_2_15,
            trans1_sprung_t_2_16,
            trans1_sprung_t_2_17,
            trans1_sprung_t_2_18,
            trans1_sprung_t_2_19,
            trans1_sprung_t_2_20,
            trans1_sprung_t_2_21,
            trans1_sprung_t_2_22,
            trans1_sprung_t_2_23,
            trans1_sprung_t_2_24,
            trans1_sprung_t_3_0,
            trans1_sprung_t_3_1,
            trans1_sprung_t_3_2,
            trans1_sprung_t_3_3,
            trans1_sprung_t_3_4,
            trans1_sprung_t_3_5,
            trans1_sprung_t_3_6,
            trans1_sprung_t_3_7,
            trans1_sprung_t_3_8,
            trans1_sprung_t_3_9,
            trans1_sprung_t_3_10,
            trans1_sprung_t_3_11,
            trans1_sprung_t_3_12,
            trans1_sprung_t_3_13,
            trans1_sprung_t_3_14,
            trans1_sprung_t_3_15,
            trans1_sprung_t_3_16,
            trans1_sprung_t_3_17,
            trans1_sprung_t_3_18,
            trans1_sprung_t_3_19,
            trans1_sprung_t_3_20,
            trans1_sprung_t_3_21,
            trans1_sprung_t_3_22,
            trans1_sprung_t_3_23,
            trans1_sprung_t_3_24,
            trans1_sprung_t_4_0,
            trans1_sprung_t_4_1,
            trans1_sprung_t_4_2,
            trans1_sprung_t_4_3,
            trans1_sprung_t_4_4,
            trans1_sprung_t_4_5,
            trans1_sprung_t_4_6,
            trans1_sprung_t_4_7,
            trans1_sprung_t_4_8,
            trans1_sprung_t_4_9,
            trans1_sprung_t_4_10,
            trans1_sprung_t_4_11,
            trans1_sprung_t_4_12,
            trans1_sprung_t_4_13,
            trans1_sprung_t_4_14,
            trans1_sprung_t_4_15,
            trans1_sprung_t_4_16,
            trans1_sprung_t_4_17,
            trans1_sprung_t_4_18,
            trans1_sprung_t_4_19,
            trans1_sprung_t_4_20,
            trans1_sprung_t_4_21,
            trans1_sprung_t_4_22,
            trans1_sprung_t_4_23,
            trans1_sprung_t_4_24
		}
		Y_VALUES
		{
	        trans1_sprung_ss_1_0,
            trans1_sprung_ss_1_1,
            trans1_sprung_ss_1_2,
            trans1_sprung_ss_1_3,
            trans1_sprung_ss_1_4,
            trans1_sprung_ss_1_5,
            trans1_sprung_ss_1_6,
            trans1_sprung_ss_1_7,
            trans1_sprung_ss_1_8,
            trans1_sprung_ss_1_9,
            trans1_sprung_ss_1_10,
            trans1_sprung_ss_1_11,
            trans1_sprung_ss_1_12,
            trans1_sprung_ss_1_13,
            trans1_sprung_ss_1_14,
            trans1_sprung_ss_1_15,
            trans1_sprung_ss_1_16,
            trans1_sprung_ss_1_17,
            trans1_sprung_ss_1_18,
            trans1_sprung_ss_1_19,
            trans1_sprung_ss_1_20,
            trans1_sprung_ss_1_21,
            trans1_sprung_ss_1_22,
            trans1_sprung_ss_1_23,
            trans1_sprung_ss_1_24,
            trans1_sprung_ss_1_25,
            trans1_sprung_ss_1_26,
            trans1_sprung_ss_1_27,
            trans1_sprung_ss_1_28,
            trans1_sprung_ss_1_29,
            trans1_sprung_ss_1_30,
            trans1_sprung_ss_1_31,
            trans1_sprung_ss_1_32,
            trans1_sprung_ss_1_33,
            trans1_sprung_ss_1_34,
            trans1_sprung_ss_1_35,
            trans1_sprung_ss_1_36,
            trans1_sprung_ss_1_37,
            trans1_sprung_ss_1_38,
            trans1_sprung_ss_1_39,
            trans1_sprung_ss_1_40,
            trans1_sprung_ss_1_41,
            trans1_sprung_ss_1_42,
            trans1_sprung_ss_1_43,
            trans1_sprung_ss_1_44,
            trans1_sprung_ss_1_45,
            trans1_sprung_ss_1_46,
            trans1_sprung_ss_1_47,
            trans1_sprung_ss_1_48,
            trans1_sprung_ss_1_49,
            trans1_sprung_ss_2_0,
            trans1_sprung_ss_2_1,
            trans1_sprung_ss_2_2,
            trans1_sprung_ss_2_3,
            trans1_sprung_ss_2_4,
            trans1_sprung_ss_2_5,
            trans1_sprung_ss_2_6,
            trans1_sprung_ss_2_7,
            trans1_sprung_ss_2_8,
            trans1_sprung_ss_2_9,
            trans1_sprung_ss_2_10,
            trans1_sprung_ss_2_11,
            trans1_sprung_ss_2_12,
            trans1_sprung_ss_2_13,
            trans1_sprung_ss_2_14,
            trans1_sprung_ss_2_15,
            trans1_sprung_ss_2_16,
            trans1_sprung_ss_2_17,
            trans1_sprung_ss_2_18,
            trans1_sprung_ss_2_19,
            trans1_sprung_ss_2_20,
            trans1_sprung_ss_2_21,
            trans1_sprung_ss_2_22,
            trans1_sprung_ss_2_23,
            trans1_sprung_ss_2_24,
            trans1_sprung_ss_2_25,
            trans1_sprung_ss_2_26,
            trans1_sprung_ss_2_27,
            trans1_sprung_ss_2_28,
            trans1_sprung_ss_2_29,
            trans1_sprung_ss_2_30,
            trans1_sprung_ss_2_31,
            trans1_sprung_ss_2_32,
            trans1_sprung_ss_2_33,
            trans1_sprung_ss_2_34,
            trans1_sprung_ss_2_35,
            trans1_sprung_ss_2_36,
            trans1_sprung_ss_2_37,
            trans1_sprung_ss_2_38,
            trans1_sprung_ss_2_39,
            trans1_sprung_ss_2_40,
            trans1_sprung_ss_2_41,
            trans1_sprung_ss_2_42,
            trans1_sprung_ss_2_43,
            trans1_sprung_ss_2_44,
            trans1_sprung_ss_2_45,
            trans1_sprung_ss_2_46,
            trans1_sprung_ss_2_47,
            trans1_sprung_ss_2_48,
            trans1_sprung_ss_2_49
	  }
  }
}


#endif


/******************************************************************************/
/*    Table: Specialist (Parametertabelle fr Spezialistenebene)              */
/******************************************************************************/
MENU Table_Main_Specialist
{
    LABEL   "SAMSON Positioner 373X-4 (PA-Profile 3.01)"
            "|de|SAMSON Stellungsregler 373X-4 (PA-Profil 3.01)";
    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
        DD_REVISION_TEXT, /* DD Versionsnummer */
#else
        local_dd_version, /* DD Versionsnummer */
#endif
        Tab_s_ident,		/* Identifikation */
        Tab_s_pb,		  	/* Physical Block */
        Tab_s_positioner,	/* AO TRD */
        Tab_s_di1,			/* Binreingang 1 */
        Tab_s_di2,			/* Binreingang 2 */
        Tab_s_diagnosis		/* Diagnose */
    }
}

/* Identifikation ************************************************************/
MENU Tab_s_ident
{
    LABEL       [menu_ident];

    ITEMS
    {
        Tab_s_ident_opunit,
        Tab_s_ident_device,
        Tab_s_ident_di1,
        Tab_s_ident_di2
    }
}


/* Identifikation ******************************************/
MENU Tab_s_ident_opunit
{
    LABEL       "Operation unit (PB)"
    						"|de|Betriebseinheit (PB)";
    ITEMS
    {
        phys_tag_desc,
        phys_st_rev,
        phys_strategy,
        phys_descriptor,
        phys_device_message,
        phys_device_certification,
        phys_production_id,
        phys_ident_number_selector,
        trans1_add_u8_1,
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3,
        phys_text_input_4,
        phys_text_input_5,
        phys_alert_key
    }
}

/* Physical Block  ************************************************************/
MENU Tab_s_pb
{
    LABEL   "Operation unit (PB)" "|de|Betriebseinheit (PB)";
    ITEMS
    {
        phys_local_operation_enable,
        phys_feature_supported,
        phys_feature_enabled,
        phys_cond_status_diag,
        phys_feature_select,
        phys_reading_direction
    }
}


/* Identifikation - Stellungsregler ****************************************************/
MENU Tab_s_ident_device
{
    LABEL       "Positioner (AO, TRD)" "|de|Stellungsregler (AO, TRD)";
    ITEMS
    {
        func1_tag_desc,
        trans1_tag_desc,
        func1_st_rev,
        trans1_st_rev,
        func1_strategy,
        trans1_strategy,
        func1_alert_key,
        trans1_alert_key,
#ifdef _V602_
        phys_device_man_id,
#endif
        phys_device_id,
        phys_serial_num,
        phys_device_product_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_device_instal_date,
        phys_ident_number_selector,
				trans1_add_u8_1,
        Tab_s_ident_device_actuator,
        Tab_s_ident_device_valve,
        Tab_s_ident_device_gear,
        Tab_s_ident_device_batch
    }
}


/* Identifikation - Gert - Antrieb *************************************/
MENU Tab_s_ident_device_actuator
{
    LABEL       "Actuator" "|de|Antrieb";
    ITEMS
    {
        trans1_actuator_man,
        trans1_actuator_type,
        trans1_actuator_serial_number,
        trans1_supply_pressure,
        trans1_actuator_version,
        trans1_pressure_range_start,
        trans1_pressure_range_end,
        trans1_manufac_actuator_size,
        trans1_actuator_size,
        trans1_attachment,
        trans1_booster
    }
}

/* Identifikation - Gert - Ventil ***************************************/
MENU Tab_s_ident_device_valve
{
    LABEL       "Valve" "|de|Ventil";
    ITEMS
    {
        trans1_valve_man,
        trans1_valve_serial_number,
        trans1_valve_type,
        trans1_rated_travel          (READ_ONLY),
        trans1_stuffing_box,
        trans1_cycle_counter_limit,
        trans1_sealing_edge,
        trans1_pressure_balancing,
        trans1_flow_characteristic,
        trans1_flow_direction,
        trans1_nom_diameter,
        trans1_nom_diameter_dn,
        trans1_kvs_value,
        trans1_kvs_unit,
        trans1_seat_diam_valve
    }
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_s_ident_device_gear
{
    LABEL       "Additional component" "|de|Zusatzkomponente";
    ITEMS
    {
        phys_ident_options,
        phys_ident_limit_switches,
        trans1_additional_gear_install_date,
        trans1_additional_gear_id,
        trans1_additional_gear_man,
        trans1_additional_gear_ser_number,
        phys_hw_write_protection,
        phys_write_locking     (READ_ONLY)
    }
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_s_ident_device_batch
{
    LABEL       "Batch-information" "|de|Batch-Information";
    ITEMS
    {
      func1_batch_id,
      func1_batch_unit,
      func1_batch_operation,
      func1_batch_phase
    }
}

MENU Tab_s_ident_di1
{
    LABEL   "Binary input 1 (DI1)" "|de|Binreingang 1 (DI1)";
    ITEMS
    {
       Tab_s_Trd_DI1,
       Tab_s_FB_DI1,
       Tab_s_sensor_di1,
       Tab_s_sensor_di1_batch
    }
}

/* Identifikation - Trd DI1 ****************************************************/
MENU Tab_s_Trd_DI1
{
    LABEL 	"Identification TRD" "|de|Identifikation TRD";
    ITEMS
    {
       trans2_tag_desc,
       trans2_st_rev,
       trans2_strategy,
       trans2_alert_key
    }
}

/* Identifikation - FB DI1 ****************************************************/
MENU Tab_s_FB_DI1
{
    LABEL 	"Identification FB" "|de|Identifikation FB";
    ITEMS
    {
       func2_DI_tag_desc,
       func2_DI_st_rev,
       func2_DI_strategy,
       func2_DI_alert_key
    }
}

/* Identifikation - DI1 ****************************************************/
MENU Tab_s_sensor_di1
{
    LABEL 	"Identification DI1"	"|de|Identifikation DI1";
    ITEMS
    {
      trans2_sensor_id,
      trans2_sensor_ser_num,
      trans2_sensor_man
    }
}

/* Identifikation - Batch-Information ******************************************/
MENU Tab_s_sensor_di1_batch
{
    LABEL 	"Batch-information"	"|de|Batch-Information";
    ITEMS
    {
      func2_DI_batch_id,
      func2_DI_batch_unit,
      func2_DI_batch_operation,
      func2_DI_batch_phase
    }
}

MENU Tab_s_ident_di2
{
    LABEL   "Binary input 2 (DI2)" "|de|Binreingang 2 (DI2)";
    ITEMS
    {
       Tab_s_Trd_DI2,
       Tab_s_FB_DI2,
       Tab_s_sensor_di2,
       Tab_s_sensor_di2_batch
    }
}

/* Identifikation - Trd DI2 ****************************************************/
MENU Tab_s_Trd_DI2
{
    LABEL 	"Identification TRD" "|de|Identifikation TRD";
    ITEMS
    {
       trans3_tag_desc,
       trans3_st_rev,
       trans3_strategy,
       trans3_alert_key
    }
}

/* Identifikation - FB DI2 ****************************************************/
MENU Tab_s_FB_DI2
{
    LABEL 	"Identification FB" "|de|Identifikation FB";
    ITEMS
    {
       func3_DI_tag_desc,
       func3_DI_st_rev,
       func3_DI_strategy,
       func3_DI_alert_key
    }
}

/* Identifikation - DI2 ****************************************************/
MENU Tab_s_sensor_di2
{
    LABEL 	"Identification DI2"	"|de|Identifikation DI2";
    ITEMS
    {
      trans3_sensor_id,
      trans3_sensor_ser_num,
      trans3_sensor_man
    }
}

/* Identifikation - Batch-Information ******************************************/
MENU Tab_s_sensor_di2_batch
{
    LABEL 	"Batch-information"	"|de|Batch-Information";
    ITEMS
    {
      func3_DI_batch_id,
      func3_DI_batch_unit,
      func3_DI_batch_operation,
      func3_DI_batch_phase
    }
}


/* Stellungsregler (AO, TRD) *******************************/

MENU Tab_s_positioner
{
    LABEL	"Positioner (AO, TRD)" "|de|Stellungsregler (AO, TRD)";
    ITEMS
    {
        func1_in_channel,
        func1_out_channel,
        trans1_transducer_state,
        Tab_s_input_range,							/* Fuehrungsgroee */
        Tab_s_workrange,							/* Arbeitsbereich */
        Tab_s_characteristic,						/* Kennlinie */
        Tab_s_charact,								/* Kennwerte */
        Tab_s_charact_powerloss,     				/* Ausfallverhalten */
        Tab_s_error_control,    					/* Fehlerueberwachung */
        Tab_s_adjustment,							/* Inbetriebnahme */
        Tab_s_interface_simulate					/* Simulation */

    }
}



/* Stellungsregler (AO, TRD) - Arbeitsbereich *******************************/

MENU Tab_s_workrange
{
	LABEL		"Working range"
	            "|de|Arbeitsbereich";
    ITEMS
    {
        trans1_final_value_range_start,
        trans1_final_value_range_end,
        trans1_final_value_range_units, 
        func1_pos_d_limit_low,
        func1_pos_d_limit_high,       
        trans1_travel_lower_limit_on,
        trans1_travel_limit_lower_value,
        trans1_travel_upper_limit_on,
        trans1_travel_limit_upper_value,
        Tab_s_workrange_subst
    }
}

MENU Tab_s_workrange_subst
{
    LABEL  "Out scale (AO)" "|de|Ausgangsskalierung (AO)";
    ITEMS
    {
        func1_out_lower_range_value,
        func1_out_upper_range_value,
        func1_out_unit
    }
}


/* Stellungsregler (AO, TRD) -  Eingangsgrsse ***************************************************/
MENU Tab_s_input_range
{
	LABEL		"Reference variable"
	            "|de|Fhrungsgre";
    ITEMS
    {
        trans1_moving_direction,
        func1_pv_lower_range_value,
        func1_pv_upper_range_value,
        func1_pv_unit,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc,
        trans1_final_value_cutoff_lo_on,
        trans1_setp_cutoff_dec,
        trans1_final_value_cutoff_hi_on,
        trans1_setp_cutoff_inc
    }
}

/* Stellungsregler (AO, TRD) -  Kennlinie ***************************************************/
MENU Tab_s_characteristic
{
	LABEL		"Characteristic"
	            "|de|Kennlinie";
    ITEMS
    {
        trans1_lin_type,
        trans1_charact_type,
        trans1_X0,
        trans1_X1,
        trans1_X2,
        trans1_X3,
        trans1_X4,
        trans1_X5,
        trans1_X6,
        trans1_X7,
        trans1_X8,
        trans1_X9,
        trans1_X10,
        trans1_Y0,
        trans1_Y1,
        trans1_Y2,
        trans1_Y3,
        trans1_Y4,
        trans1_Y5,
        trans1_Y6,
        trans1_Y7,
        trans1_Y8,
        trans1_Y9,
        trans1_Y10
    }
}


/* unsichtbarer Button */
METHOD meth_invisible
{
  LABEL		"";
  DEFINITION{}
  VALIDITY FALSE;
}

/* Kennwerte - ***************************************************************/
MENU Tab_s_charact
{
	LABEL		"Performance characteristics"
	            "|de|Kennwerte";
    ITEMS
    {
        trans1_servo_gain_1,
        trans1_servo_rate_1
    }
}


/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_s_charact_powerloss
{
	LABEL		"Fail-safe action"
	            "|de|Ausfallverhalten";
    ITEMS
    {
        trans1_actuator_action,
        func1_fsafe_type,
        func1_fsafe_time,
        func1_fsafe_value
    }
}


/* Fehlerueberwachung **********************************************/
MENU Tab_s_error_control
{
    LABEL       "Error control"	"|de|Fehlerberwachung";
    ITEMS
    {
        trans1_tolerance_band,
        trans1_delay_time,
        trans1_total_valve_travel,
        trans1_total_valve_travel_limit,
        trans1_zero_point_limit,
        Tab_s_error_classification,
        Tab_s_checkback_mask
    }
}


/* Kennwerte - Fehlerberwachung *********************************************/
MENU Tab_s_error_classification
{
    LABEL       "Classification report" "|de|Statusklassifikation";
    ITEMS
    {
        phys_cond_status_diag,
        Tab_s_operator_error,
        Tab_s_init_error,
        Tab_s_hardware_error,
        Tab_s_data_error,
        Tab_s_error_temperature,
        Tab_s_error_enhanced
    }
}


/* Maskierung CHECKBACK *********************************************/
MENU Tab_s_checkback_mask
{
    LABEL       "CHECKBACK mask" "|de|Maskierung CHECKBACK";
    ITEMS
    {
        func1_check_back_opt     /* Klassifikation Checkback */
    }
}

/********** Texte anzeigen ************/
VARIABLE string_ascii_status
{
    LABEL       "";
    CLASS       LOCAL;
    TYPE				ASCII (32)
    {
      DEFAULT_VALUE	"Einstellung von 'Status'";
    }
		HANDLING READ;
}

VARIABLE string_ascii_diagnosis
{
    LABEL       "";
    CLASS       LOCAL;
    TYPE				ASCII (32)
    {
      DEFAULT_VALUE	"Einstellung von 'Diagnosis'";
    }
		HANDLING READ;
}

METHOD transmit_button
{
	LABEL [transfer];
	CLASS INPUT;
	DEFINITION{}
}

/*************************************/

MENU Tab_s_operator_error
{
    LABEL       "Operation error"
                "|de|Betriebsfehler";
    ITEMS
    {
				/* Betriebsfehler */

        /* string_ascii_status, */
        page_group_operation_error_status,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        page_group_operation_error_diagnosis,
		transmit_button
    }
}

MENU page_group_operation_error_status
{
    LABEL       "Status";
    ITEMS
    {
/*        phys_diag_event_switch__Diag_Status_Link_1_0_S,	*//* Gert nicht init. */
        phys_diag_event_switch__Diag_Status_Link_1_1_S, /* Magnetventil aktiv */
        phys_diag_event_switch__Diag_Status_Link_1_2_S, /* Wegintegral berschritten */
        phys_diag_event_switch__Diag_Status_Link_1_3_S, /* Regelkreisfehler */
        phys_diag_event_switch__Diag_Status_Link_1_4_S, /* Nullpunktfehler */
        phys_diag_event_switch__Diag_Status_Link_1_5_S  /* Autokorrektur */
/*        phys_diag_event_switch__Diag_Status_Link_1_6_S, *//* Fataler Fehler */
/*        phys_diag_event_switch__Diag_Status_Link_1_7_S  *//* Erweiterte Diagnose */
    }
}

MENU page_group_operation_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
/*        phys_diag_event_switch__Diag_Status_Link_1_0_D, *//* Gert nicht init. */
        phys_diag_event_switch__Diag_Status_Link_1_1_D, /* Magnetventil aktiv */
        phys_diag_event_switch__Diag_Status_Link_1_2_D, /* Wegintegral berschritten */
        phys_diag_event_switch__Diag_Status_Link_1_3_D, /* Regelkreisfehler */
        phys_diag_event_switch__Diag_Status_Link_1_4_D, /* Nullpunktfehler */
        phys_diag_event_switch__Diag_Status_Link_1_5_D  /* Autokorrektur */
/*        phys_diag_event_switch__Diag_Status_Link_1_6_D, *//* Fataler Fehler */
/*        phys_diag_event_switch__Diag_Status_Link_1_7_D*/
    }
}

MENU Tab_s_init_error
{
    LABEL       "Initialization error"
                "|de|Initialisierungsfehler";
    ITEMS
    {
        /* Initialisierungsfehler*/
        /* string_ascii_status, */
        page_group_init_error_status,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        page_group_init_error_diagnosis,
        transmit_button
    }
}


MENU page_group_init_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_8_S,
        phys_diag_event_switch__Diag_Status_Link_1_9_S,
        phys_diag_event_switch__Diag_Status_Link_1_10_S,
        phys_diag_event_switch__Diag_Status_Link_1_11_S,
        phys_diag_event_switch__Diag_Status_Link_1_12_S,
        phys_diag_event_switch__Diag_Status_Link_1_13_S,
        phys_diag_event_switch__Diag_Status_Link_1_14_S,
        phys_diag_event_switch__Diag_Status_Link_1_15_S
    }
}

MENU page_group_init_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
		phys_diag_event_switch__Diag_Status_Link_1_8_D,
        phys_diag_event_switch__Diag_Status_Link_1_9_D,
        phys_diag_event_switch__Diag_Status_Link_1_10_D,
        phys_diag_event_switch__Diag_Status_Link_1_11_D,
        phys_diag_event_switch__Diag_Status_Link_1_12_D,
        phys_diag_event_switch__Diag_Status_Link_1_13_D,
        phys_diag_event_switch__Diag_Status_Link_1_14_D,
        phys_diag_event_switch__Diag_Status_Link_1_15_D
    }
}




MENU Tab_s_hardware_error
{
    LABEL       "Hardware error"
                "|de|Hardwarefehler";
    ITEMS
    {
 				/* Hardware */
        /* string_ascii_status, */
        page_group_hw_error_status,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        page_group_hw_error_diagnosis,
        transmit_button
    }
}


MENU page_group_hw_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_16_S
/*        phys_diag_event_switch__Diag_Status_Link_1_17_S,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_18_S*/
    }
}

MENU page_group_hw_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
		phys_diag_event_switch__Diag_Status_Link_1_16_D
/*        phys_diag_event_switch__Diag_Status_Link_1_17_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_18_D*/
    }
}




MENU Tab_s_data_error
{
    LABEL       "Data error"
                "|de|Datenfehler";
    ITEMS
    {
 				/* Datenfehler */
        /* string_ascii_status, */
        page_group_data_error_status,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        page_group_data_error_diagnosis
    }
}


MENU page_group_data_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_19_S,
        phys_diag_event_switch__Diag_Status_Link_1_20_S,
        phys_diag_event_switch__Diag_Status_Link_1_21_S,
        phys_diag_event_switch__Diag_Status_Link_1_22_S,
        phys_diag_event_switch__Diag_Status_Link_1_23_S,
        phys_diag_event_switch__Diag_Status_Link_1_24_S,
/*        phys_diag_event_switch__Diag_Status_Link_1_25_S,*/
        phys_diag_event_switch__Diag_Status_Link_1_26_S,
        phys_diag_event_switch__Diag_Status_Link_1_27_S,
/*        phys_diag_event_switch__Diag_Status_Link_1_28_S,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_29_S,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_41_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_S
/*        phys_diag_event_switch__Diag_Status_Link_1_30_S,
        phys_diag_event_switch__Diag_Status_Link_1_31_S,
        phys_diag_event_switch__Diag_Status_Link_1_32_S,
        phys_diag_event_switch__Diag_Status_Link_1_33_S*/
    }
}




MENU page_group_data_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_19_D,
        phys_diag_event_switch__Diag_Status_Link_1_20_D,
        phys_diag_event_switch__Diag_Status_Link_1_21_D,
        phys_diag_event_switch__Diag_Status_Link_1_22_D,
        phys_diag_event_switch__Diag_Status_Link_1_23_D,
        phys_diag_event_switch__Diag_Status_Link_1_24_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_25_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_26_D,
        phys_diag_event_switch__Diag_Status_Link_1_27_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_28_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_29_D,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_41_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_D
/*        phys_diag_event_switch__Diag_Status_Link_1_30_D,
        phys_diag_event_switch__Diag_Status_Link_1_31_D,
        phys_diag_event_switch__Diag_Status_Link_1_32_D,
        phys_diag_event_switch__Diag_Status_Link_1_33_D*/
    }
}



MENU Tab_s_error_enhanced
{
    LABEL       "Extended" "|de|Erweitert";
    ITEMS
    {
		phys_diag_event_switch_2__Diag_Status_Link_2_37_S, /* Code 81 */
		phys_diag_event_switch_2__Diag_Status_Link_2_37_D,

		Tab_s_error_enhanced_air_supply,
		Tab_s_error_enhanced_shifting_working_range,
        Tab_s_error_enhanced_leakage_pneumatic,
        Tab_s_error_enhanced_limit_working_range,
        Tab_s_error_enhanced_obs_end_pos,
        Tab_s_error_enhanced_connection_pos_valve,
        Tab_s_error_enhanced_working_range,
		Tab_s_error_enhanced_friction,
		Tab_s_error_enhanced_actuator_spring,
        Tab_s_error_enhanced_inner_leakage,
        Tab_s_error_enhanced_external_leakage
/*      Tab_s_error_enhanced_dynamic_stress_factor      */
/* kmr: noch kein ESD:
            Tab_s_error_enhanced_esd*/
    }
    VALIDITY_ONLY_EXPERT_PLUS
}







MENU Tab_s_error_enhanced_air_supply
{
    LABEL       "Air supply"
                "|de|Zuluftdruck";
    ITEMS
    {
				/* Air supply */
				/* string_ascii_status, */
			  page_group_air_supply_error_status,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        page_group_air_supply_error_diagnosis,
        transmit_button
     }
}

MENU page_group_air_supply_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_34_S,
        phys_diag_event_switch__Diag_Status_Link_1_35_S,
        phys_diag_event_switch__Diag_Status_Link_1_36_S,
        phys_diag_event_switch__Diag_Status_Link_1_37_S,
        phys_diag_event_switch__Diag_Status_Link_1_38_S,
        phys_diag_event_switch__Diag_Status_Link_1_39_S
    }
}

MENU page_group_air_supply_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
				phys_diag_event_switch__Diag_Status_Link_1_34_D,
        phys_diag_event_switch__Diag_Status_Link_1_35_D,
        phys_diag_event_switch__Diag_Status_Link_1_36_D,
        phys_diag_event_switch__Diag_Status_Link_1_37_D,
        phys_diag_event_switch__Diag_Status_Link_1_38_D,
        phys_diag_event_switch__Diag_Status_Link_1_39_D
    }
}


MENU Tab_s_error_enhanced_actuator_spring
{
    LABEL       "Actuator spring"
                "|de|Antriebsfedern";
    ITEMS
    {
				/* string_ascii_status, */
		    page_group_actuator_spring_error_status,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        page_group_actuator_spring_error_diagnosis,
        transmit_button
     }
}

MENU page_group_actuator_spring_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_40_S,
        phys_diag_event_switch__Diag_Status_Link_1_41_S,
        phys_diag_event_switch__Diag_Status_Link_1_42_S,
        phys_diag_event_switch__Diag_Status_Link_1_43_S,
        phys_diag_event_switch__Diag_Status_Link_1_44_S
    }
}

MENU page_group_actuator_spring_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
				phys_diag_event_switch__Diag_Status_Link_1_40_D,
        phys_diag_event_switch__Diag_Status_Link_1_41_D,
        phys_diag_event_switch__Diag_Status_Link_1_42_D,
        phys_diag_event_switch__Diag_Status_Link_1_43_D,
        phys_diag_event_switch__Diag_Status_Link_1_44_D
    }
}



MENU Tab_s_error_enhanced_shifting_working_range
{
    LABEL       "Shifting working range"
                "|de|Trend Stellbereich";
    ITEMS
    {
				/*string_ascii_status,*/
				page_group_shifting_working_range_error_status,
				SEPARATOR,
				page_group_shifting_working_range_error_diagnosis,
				transmit_button
    }
}


MENU page_group_shifting_working_range_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_45_S,
		    phys_diag_event_switch__Diag_Status_Link_1_46_S
    }
}

MENU page_group_shifting_working_range_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
				phys_diag_event_switch__Diag_Status_Link_1_45_D,
		    phys_diag_event_switch__Diag_Status_Link_1_46_D
    }
}



MENU Tab_s_error_enhanced_friction
{
    LABEL       "Friction"
                "|de|Reibung";
    ITEMS
    {
				/*string_ascii_status,*/
				page_group_friction_error_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_friction_error_diagnosis,
        transmit_button
    }
}

MENU page_group_friction_error_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch__Diag_Status_Link_1_47_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_0_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_1_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_2_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_3_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_4_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_5_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_6_S
    }
}

MENU page_group_friction_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
				phys_diag_event_switch__Diag_Status_Link_1_47_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_0_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_1_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_2_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_3_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_4_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_5_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_6_D
    }
}

MENU Tab_s_error_enhanced_leakage_pneumatic
{
    LABEL       "Leakage pneumatic"
                "|de|Leckage Pneumatik";
    ITEMS
    {
				/*string_ascii_status,*/
				page_group_leakage_pneumatic_error_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_leakage_pneumatic_error_diagnosis,
        transmit_button
    }
}


MENU page_group_leakage_pneumatic_error_status
{
    LABEL       "Status";
    ITEMS
    {
      	phys_diag_event_switch_2__Diag_Status_Link_2_7_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_8_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_9_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_10_S
    }
}

MENU page_group_leakage_pneumatic_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			 phys_diag_event_switch_2__Diag_Status_Link_2_7_D,
       phys_diag_event_switch_2__Diag_Status_Link_2_8_D,
       phys_diag_event_switch_2__Diag_Status_Link_2_9_D,
       phys_diag_event_switch_2__Diag_Status_Link_2_10_D
    }
}


MENU Tab_s_error_enhanced_limit_working_range
{
    LABEL       "Limit working range"
                "|de|Beschrnkung Stellbereich";
    ITEMS
    {
        /*string_ascii_status,*/
    		page_group_limit_working_range_error_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
     		page_group_limit_working_range_error_diagnosis,
        transmit_button
    }
}

MENU page_group_limit_working_range_error_status
{
    LABEL       "Status";
    ITEMS
    {
      	phys_diag_event_switch_2__Diag_Status_Link_2_11_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_12_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_13_S
    }
}

MENU page_group_limit_working_range_error_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			  phys_diag_event_switch_2__Diag_Status_Link_2_11_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_12_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_13_D
    }
}



// MENU Tab_s_error_enhanced_dynamic_stress_factor
// {
//    LABEL       "Dynamic stress factor"
//                "|de|Dynamischer Belastungsfaktor";
//    ITEMS
//    {
//				/*string_ascii_status,*/
//				page_group_dynamic_stress_factor_status,
//        SEPARATOR,
//        /*string_ascii_diagnosis,*/
//        page_group_dynamic_stress_factor_diagnosis,
//        transmit_button
//		}
// }

/*
MENU page_group_dynamic_stress_factor_status
{
    LABEL       "Status";
    ITEMS
    {
       phys_diag_event_switch_2__Diag_Status_Link_2_14_S
    }
}

MENU page_group_dynamic_stress_factor_diagnosis
{
    LABEL       "Diagnosis";
    ITEMS
    {
			 phys_diag_event_switch_2__Diag_Status_Link_2_14_D
    }
}

*/


MENU Tab_s_error_enhanced_inner_leakage
{
    LABEL       "Inner leakage"
                "|de|Innere Leckage";
    ITEMS
    {
		/*string_ascii_status,*/
		page_group_inner_leakage_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_inner_leakage_diagnosis,
        transmit_button
	}
}

MENU page_group_inner_leakage_status
{
    LABEL       "Status";
    ITEMS
    {
        phys_diag_event_switch_2__Diag_Status_Link_2_15_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_16_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_17_S
    }
}

MENU page_group_inner_leakage_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			  phys_diag_event_switch_2__Diag_Status_Link_2_15_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_16_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_17_D
    }
}




MENU Tab_s_error_enhanced_external_leakage
{
    LABEL       "External leakage"
                "|de|Externe Leckage";
    ITEMS
    {
				/*string_ascii_status,*/
				page_group_external_leakage_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_external_leakage_diagnosis,
       	transmit_button
    }
}

MENU page_group_external_leakage_status
{
    LABEL       "Status";
    ITEMS
    {
       	phys_diag_event_switch_2__Diag_Status_Link_2_18_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_19_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_20_S
    }
}

MENU page_group_external_leakage_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
        phys_diag_event_switch_2__Diag_Status_Link_2_18_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_19_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_20_D
    }
}

MENU Tab_s_error_enhanced_obs_end_pos
{
    LABEL       "Observing end position"
                "|de|Trend Endlage";
    ITEMS
    {
				/*string_ascii_status,*/
        page_group_obs_end_pos_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_obs_end_pos_diagnosis,
        transmit_button
    }
}

MENU page_group_obs_end_pos_status
{
    LABEL       "Status";
    ITEMS
    {
       	phys_diag_event_switch_2__Diag_Status_Link_2_21_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_22_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_23_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_24_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_25_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_26_S
    }
}

MENU page_group_obs_end_pos_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			  phys_diag_event_switch_2__Diag_Status_Link_2_21_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_22_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_23_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_24_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_25_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_26_D
    }
}

MENU Tab_s_error_enhanced_connection_pos_valve
{
    LABEL       "Connection positioner - valve"
                "|de|Mech. Verbindung SR / Ventil";
    ITEMS
    {
				/*string_ascii_status,*/
				page_group_connection_pos_valve_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_connection_pos_valve_diagnosis,
        transmit_button

	}
}

MENU page_group_connection_pos_valve_status
{
    LABEL       "Status";
    ITEMS
    {
       	phys_diag_event_switch_2__Diag_Status_Link_2_27_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_28_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_29_S
/* entfllt vorerst
        phys_diag_event_switch_2__Diag_Status_Link_2_30_S
*/
    }
}

MENU page_group_connection_pos_valve_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			  phys_diag_event_switch_2__Diag_Status_Link_2_27_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_28_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_29_D
/* entfllt vorerst
        phys_diag_event_switch_2__Diag_Status_Link_2_30_D
*/
    }
}




MENU Tab_s_error_enhanced_working_range
{
    LABEL       "Working range" "|de|Stellbereich";
    ITEMS
    {
				/*string_ascii_status,*/
        page_group_working_range_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_working_range_diagnosis,
        transmit_button

    }
}

MENU page_group_working_range_status
{
    LABEL       "Status";
    ITEMS
    {
      	phys_diag_event_switch_2__Diag_Status_Link_2_31_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_32_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_33_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_34_S
    }
}

MENU page_group_working_range_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			  phys_diag_event_switch_2__Diag_Status_Link_2_31_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_32_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_33_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_34_D
    }
}



MENU Tab_s_error_temperature
{
    LABEL       "Temperature" "|de|Temperatur";
    ITEMS
    {
				/*string_ascii_status,*/
        page_group_temperature_status,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_temperature_diagnosis,
        transmit_button
	}
}


MENU page_group_temperature_status
{
    LABEL       "Status";
    ITEMS
    {
      	phys_diag_event_switch_2__Diag_Status_Link_2_35_S,
				phys_diag_event_switch_2__Diag_Status_Link_2_36_S
    }
}

MENU page_group_temperature_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
			  phys_diag_event_switch_2__Diag_Status_Link_2_35_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_36_D
    }
}


MENU Tab_s_error_enhanced_esd
{
    LABEL       "ESD" "|de|ESD";
    ITEMS
    {
				/*string_ascii_status,*/
				page_group_esd_status,
				SEPARATOR,
        /*string_ascii_diagnosis,*/
        page_group_esd_diagnosis,
    		transmit_button
    }
}


MENU page_group_esd_status
{
    LABEL       "Status";
    ITEMS
    {
      	phys_diag_event_switch_2__Diag_Status_Link_2_38_S,
				phys_diag_event_switch_2__Diag_Status_Link_2_39_S,
				phys_diag_event_switch_2__Diag_Status_Link_2_40_S
    }
}

MENU page_group_esd_diagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ITEMS
    {
		phys_diag_event_switch_2__Diag_Status_Link_2_38_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_39_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_40_D
    }
}





/* Inbetriebnahme ************************************************************/
MENU Tab_s_adjustment
{
    LABEL       "Adjustment" "|de|Inbetriebnahme";
    ITEMS
    {
       phys_reading_direction,
       trans1_transm_pin_pos,
       trans1_init_method,
       trans1_pressure_limit,
       trans1_rated_travel,
       trans1_actuator_version,
       trans1_act_stroke_time_dec,
       trans1_act_stroke_time_inc,
/* in 1.43 nicht untersttzt       trans1_signal_pressure_action,*/
       trans1_actuator_action,

       trans1_device_calib_date,
       trans1_device_config_date,
       trans1_valve_maintenance_date,

       trans1_device_init_state,
       Tab_s_adjustment_subst
    }
}


MENU Tab_s_adjustment_subst
{
    LABEL  "Substitution" "|de|Ersatzabgleich";
    ITEMS
    {
       trans1_sub_mode_init,
       trans1_closing_direction,
       trans1_blocking_position,
       trans1_travel_upper_limit_on
    }
}


/* Simulation ********************************/
MENU Tab_s_interface_simulate
{
    LABEL       [menu_interface_simulate];
    ITEMS
    {
        func1_simulate_enabled          (READ_ONLY),
        func1_simulate_value            (READ_ONLY),
        func1_simulate_status_quality   (READ_ONLY),
        func1_simulate_status_limit     (READ_ONLY)
    }
}




/* Binreingang 1 *****************************************************/
MENU Tab_s_di1
{
    LABEL   "Binary input 1 (DI1)" "|de|Binreingang 1 (DI1)";
    ITEMS
    {
       func2_DI_channel,
       Tab_s_invert_di1,
       Tab_s_fail_safe_di1,
       Tab_s_simulation_di1
    }
}

MENU Tab_s_invert_di1
{
    LABEL 	"Selection I/O-handling" "|de|Auswahl Ein-/Ausgangsverhalten";
    ITEMS
    {
       func2_DI_invert
    }
}


/* Ausfallverhalten ****************************************************/
MENU Tab_s_fail_safe_di1
{
    LABEL 	"Fail safe action" "|de|Ausfallverhalten";
    ITEMS
    {
      func2_DI_fsafe_type,
      func2_DI_fsafe_value
    }
}

/* Binreingang 1 - simulation ****************************************************/
MENU Tab_s_simulation_di1
{
    LABEL   "Simulation" "|de|Simulation";
    ITEMS
    {
      func2_DI_simulation_enabled        (READ_ONLY),
      func2_DI_simulate_value            (READ_ONLY),
	  func2_DI_simulate_status_quality   (READ_ONLY),
	  func2_DI_simulate_status_limit     (READ_ONLY)
    }
}



/* Binreingang 2 *****************************************************/
MENU Tab_s_di2
{
    LABEL       "Binary input 2 (DI2)"	"|de|Binreingang 2 (DI2)";
    ITEMS
    {
       func3_DI_channel,
       phys_config_binary_input_2,
       Tab_s_invert_di2,
       Tab_s_fail_safe_di2,
       Tab_s_simulation_di2
    }
}

MENU Tab_s_invert_di2
{
    LABEL 	"Selection I/O-handling" "|de|Auswahl Ein-/Ausgangsverhalten";
    ITEMS
    {
       func3_DI_invert
    }
}


/* Ausfallverhalten ****************************************************/
MENU Tab_s_fail_safe_di2
{
    LABEL 	"Fail safe action" "|de|Ausfallverhalten";
    ITEMS
    {
      func3_DI_fsafe_type,
      func3_DI_fsafe_value
    }
}

/* Binreingang 2 - simulation ****************************************************/
MENU Tab_s_simulation_di2
{
    LABEL   "Simulation" "|de|Simulation";
    ITEMS
    {
        func3_DI_simulation_enabled        (READ_ONLY),
		func3_DI_simulate_value            (READ_ONLY),
		func3_DI_simulate_status_quality   (READ_ONLY),
		func3_DI_simulate_status_limit     (READ_ONLY)
    }
}

/*********************** Diagnose ***********************************/
MENU Tab_s_diagnosis
{
    LABEL   "Diagnosis"	"|de|Diagnose";
    ITEMS
    {
        trans1_diag_testinfo,
        trans1_diag_level,
        phys_device_dp_status,

        Tab_s_statusmeldungen,
        Tab_s_beobachter_auto,
        Tab_s_beobachter_hand
    }
}

/* Statusmeldungen ************************************************************/
MENU Tab_s_statusmeldungen
{
    LABEL     	"Status messages" "|de|Statusmeldungen";
    ITEMS
    {
        phys_condensed_state,
        trans1_Elapsed_Hours_Meters,
		trans1_Device_In_Closed_Loop,
		trans1_Power_On_Since_Init,
		trans1_Device_In_Closed_Loop_Since_Last_Init,

		trans1_no_of_zero_point_adj,
		trans1_counter_init_start,
		trans1_zero_point_limit  (READ_ONLY),
  	    phys_diag_operation,
        phys_diag_init_1,
        phys_diag_init_2,
        phys_diag_hw,
        phys_diag_data_1,
        phys_diag_ext_1_3
/* kmr: geht nicht        phys_diag_data_2,*/

		trans1_Min_Temp,
		trans1_Max_Temp,
		trans1_Time_Min_Temp,
		trans1_Time_Max_Temp,
		trans1_Period_Time_Low,
		trans1_Period_Time_High,

    Tab_s_logger,
		Tab_s_enhanced_diag
/* kmr: kann ab K1.11 entfallen
		,Tab_s_error_unmaskiert */
    }
}

/* Fehler unmaskiert (RAW) ************************************************************/
/* entfllt
MENU Tab_s_error_unmaskiert
{
    LABEL     "Status messages unmasked" "|de|Statusmeldungen unmaskiert";

    ITEMS
    {
		 		 phys_diagnosis_ext_1_raw_0,
  	     phys_diagnosis_ext_1_raw_1,
  	     phys_diagnosis_ext_1_raw_2,
  	     phys_diagnosis_ext_1_raw_3,
  	     Tab_s_error_raw_diag
    }
}*/

/* Fehler unmaskiert (RAW) ************************************************************/
/* entfllt
MENU Tab_s_error_raw_diag
{
    LABEL   "Extended unmasked" "|de|Erweitert unmaskiert" ;

    ITEMS
    {
		 phys_diagnosis_ext_1_raw_4,
  	     phys_ext_2_raw_enh_diag_1,
         phys_ext_2_raw_enh_diag_2,
         phys_ext_2_raw_enh_diag_3
    }
    VALIDITY_ONLY_EXPERT_PLUS
}*/

/* Protokollierung 1************************************************************/
MENU Tab_s_logger
{
	LABEL	  "Logger" "|de|Protokollierung";
    ITEMS
    {
      trans1_Message_0,
      trans1_Elapsed_Hours_Meters_0,
      trans1_Message_1,
      trans1_Elapsed_Hours_Meters_1,
      trans1_Message_2,
      trans1_Elapsed_Hours_Meters_2,
      trans1_Message_3,
      trans1_Elapsed_Hours_Meters_3,
      trans1_Message_4,
      trans1_Elapsed_Hours_Meters_4,
      trans1_Message_5,
      trans1_Elapsed_Hours_Meters_5,
      trans1_Message_6,
      trans1_Elapsed_Hours_Meters_6,
      trans1_Message_7,
      trans1_Elapsed_Hours_Meters_7,
      trans1_Message_8,
      trans1_Elapsed_Hours_Meters_8,
      trans1_Message_9,
      trans1_Elapsed_Hours_Meters_9,
      trans1_Message_10,
      trans1_Elapsed_Hours_Meters_10,
      trans1_Message_11,
      trans1_Elapsed_Hours_Meters_11,
      trans1_Message_12,
      trans1_Elapsed_Hours_Meters_12,
      trans1_Message_13,
      trans1_Elapsed_Hours_Meters_13,
      trans1_Message_14,
      trans1_Elapsed_Hours_Meters_14,
      trans1_Message_15,
      trans1_Elapsed_Hours_Meters_15,
      trans1_Message_16,
      trans1_Elapsed_Hours_Meters_16,
      trans1_Message_17,
      trans1_Elapsed_Hours_Meters_17,
      trans1_Message_18,
      trans1_Elapsed_Hours_Meters_18,
      trans1_Message_19,
      trans1_Elapsed_Hours_Meters_19,
      trans1_Message_20,
      trans1_Elapsed_Hours_Meters_20,
      trans1_Message_21,
      trans1_Elapsed_Hours_Meters_21,
      trans1_Message_22,
      trans1_Elapsed_Hours_Meters_22,
      trans1_Message_23,
      trans1_Elapsed_Hours_Meters_23,
      trans1_Message_24,
      trans1_Elapsed_Hours_Meters_24,
      trans1_Message_25,
      trans1_Elapsed_Hours_Meters_25,
      trans1_Message_26,
      trans1_Elapsed_Hours_Meters_26,
      trans1_Message_27,
      trans1_Elapsed_Hours_Meters_27,
      trans1_Message_28,
      trans1_Elapsed_Hours_Meters_28,
      trans1_Message_29,
      trans1_Elapsed_Hours_Meters_29
    }
}


/* Beobachterfunktionen AUTO ************************************************************/
MENU Tab_s_beobachter_auto
{
    LABEL "Statistical information AUTO" "|de|Beobachterfunktionen AUTO";

    ITEMS
    {
         Tab_s_datenlogger,
         Tab_s_histogramm_x,
         Tab_s_histogramm_e,
         Tab_s_histogramm_z,
         Tab_s_stellsignal_y,
         Tab_s_endlagentrend
    }
    VALIDITY_ONLY_EXPERT_PLUS
}

/* Datenlogger ************************************************************/
MENU Tab_s_datenlogger
{
	LABEL	"Data logger" "|de|Datenlogger";

    ITEMS
    {
        trans1_datalogger_select,
	 	trans1_datalogger_trigger_select,
	 	phys_dl_trigger_select_bin,
		trans1_datalogger_sample_rate,
		trans1_datalogger_start_value,
		trans1_datalogger_logging_limit,
		trans1_datalogger_pretrigger_time,
        trans1_datalogger_max_pretrig
/* kmr: wird nicht angezeigt:
		Tab_s_measured_values_datalogger*/
    }
}

/* kmr: wird nicht angezeigt:
MENU Tab_s_measured_values_datalogger
{
    LABEL     "Data" "|de|Messwerte";

    ITEMS
    {
          Tab_s_pos_x_datalogger,
          Tab_s_pos_w_datalogger,
          Tab_s_pos_y_datalogger,
          Tab_s_pos_e_datalogger,
          Tab_s_pos_t_datalogger
    }
}

MENU Tab_s_pos_x_datalogger
{
	LABEL   "Controlled variable X" "|de|Regelgre X";

    ITEMS
    {
          Tab_s_measured_values_1_x_datalogger,
          Tab_s_measured_values_2_x_datalogger,
          Tab_s_measured_values_3_x_datalogger
    }
}

MENU Tab_s_measured_values_1_x_datalogger
{
    LABEL     "|de|Messpunkt 1 - 34";

    ITEMS
    {
          trans1_datalogger_vs_1_0,
          trans1_datalogger_vs_1_1,
          trans1_datalogger_vs_1_2,
          trans1_datalogger_vs_1_3,
          trans1_datalogger_vs_1_4,
          trans1_datalogger_vs_1_5,
          trans1_datalogger_vs_1_6,
          trans1_datalogger_vs_2_0,
          trans1_datalogger_vs_2_1,
          trans1_datalogger_vs_2_2,
          trans1_datalogger_vs_2_3,
          trans1_datalogger_vs_2_4,
          trans1_datalogger_vs_2_5,
          trans1_datalogger_vs_2_6,
          trans1_datalogger_vs_3_0,
          trans1_datalogger_vs_3_1,
          trans1_datalogger_vs_3_2,
          trans1_datalogger_vs_3_3,
          trans1_datalogger_vs_3_4,
          trans1_datalogger_vs_3_5,
          trans1_datalogger_vs_3_6,
          trans1_datalogger_vs_4_0,
          trans1_datalogger_vs_4_1,
          trans1_datalogger_vs_4_2,
          trans1_datalogger_vs_4_3,
          trans1_datalogger_vs_4_4,
          trans1_datalogger_vs_4_5,
          trans1_datalogger_vs_4_6,
          trans1_datalogger_vs_5_0,
          trans1_datalogger_vs_5_1,
          trans1_datalogger_vs_5_2,
          trans1_datalogger_vs_5_3,
          trans1_datalogger_vs_5_4,
          trans1_datalogger_vs_5_5
    }
}

MENU Tab_s_measured_values_2_x_datalogger
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_datalogger_vs_5_6,
          trans1_datalogger_vs_6_0,
          trans1_datalogger_vs_6_1,
          trans1_datalogger_vs_6_2,
          trans1_datalogger_vs_6_3,
          trans1_datalogger_vs_6_4,
          trans1_datalogger_vs_6_5,
          trans1_datalogger_vs_6_6,
          trans1_datalogger_vs_7_0,
          trans1_datalogger_vs_7_1,
          trans1_datalogger_vs_7_2,
          trans1_datalogger_vs_7_3,
          trans1_datalogger_vs_7_4,
          trans1_datalogger_vs_7_5,
          trans1_datalogger_vs_7_6,
          trans1_datalogger_vs_8_0,
          trans1_datalogger_vs_8_1,
          trans1_datalogger_vs_8_2,
          trans1_datalogger_vs_8_3,
          trans1_datalogger_vs_8_4,
          trans1_datalogger_vs_8_5,
          trans1_datalogger_vs_8_6,
          trans1_datalogger_vs_9_0,
          trans1_datalogger_vs_9_1,
          trans1_datalogger_vs_9_2,
          trans1_datalogger_vs_9_3,
          trans1_datalogger_vs_9_4,
          trans1_datalogger_vs_9_5,
          trans1_datalogger_vs_9_6
          trans1_datalogger_vs_10_0,
          trans1_datalogger_vs_10_1,
          trans1_datalogger_vs_10_2,
          trans1_datalogger_vs_10_3,
          trans1_datalogger_vs_10_4
    }
}


MENU Tab_s_measured_values_3_x_datalogger
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_datalogger_vs_10_5,
          trans1_datalogger_vs_10_6,
          trans1_datalogger_vs_11_0,
          trans1_datalogger_vs_11_1,
          trans1_datalogger_vs_11_2,
          trans1_datalogger_vs_11_3,
          trans1_datalogger_vs_11_4,
          trans1_datalogger_vs_11_5,
          trans1_datalogger_vs_11_6,
          trans1_datalogger_vs_12_0,
          trans1_datalogger_vs_12_1,
          trans1_datalogger_vs_12_2,
          trans1_datalogger_vs_12_3,
          trans1_datalogger_vs_12_4,
          trans1_datalogger_vs_12_5,
          trans1_datalogger_vs_12_6,
          trans1_datalogger_vs_13_0,
          trans1_datalogger_vs_13_1,
          trans1_datalogger_vs_13_2,
          trans1_datalogger_vs_13_3,
          trans1_datalogger_vs_13_4,
          trans1_datalogger_vs_13_5,
          trans1_datalogger_vs_13_6,
          trans1_datalogger_vs_14_0,
          trans1_datalogger_vs_14_1,
          trans1_datalogger_vs_14_2,
          trans1_datalogger_vs_14_3,
          trans1_datalogger_vs_14_4,
          trans1_datalogger_vs_14_5,
          trans1_datalogger_vs_14_6,
          trans1_datalogger_vs_15_0,
          trans1_datalogger_vs_15_1
    }
}


MENU Tab_s_pos_w_datalogger
{
    LABEL     "|de|Sollwert w" ;

    ITEMS
    {
          Tab_s_measured_values_1_w_datalogger,
          Tab_s_measured_values_2_w_datalogger,
          Tab_s_measured_values_3_w_datalogger
    }
}

MENU Tab_s_measured_values_1_w_datalogger
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_datalogger_sw_1_0,
          trans1_datalogger_sw_1_1,
          trans1_datalogger_sw_1_2,
          trans1_datalogger_sw_1_3,
          trans1_datalogger_sw_1_4,
          trans1_datalogger_sw_1_5,
          trans1_datalogger_sw_1_6,
          trans1_datalogger_sw_2_0,
          trans1_datalogger_sw_2_1,
          trans1_datalogger_sw_2_2,
          trans1_datalogger_sw_2_3,
          trans1_datalogger_sw_2_4,
          trans1_datalogger_sw_2_5,
          trans1_datalogger_sw_2_6,
          trans1_datalogger_sw_3_0,
          trans1_datalogger_sw_3_1,
          trans1_datalogger_sw_3_2,
          trans1_datalogger_sw_3_3,
          trans1_datalogger_sw_3_4,
          trans1_datalogger_sw_3_5,
          trans1_datalogger_sw_3_6,
          trans1_datalogger_sw_4_0,
          trans1_datalogger_sw_4_1,
          trans1_datalogger_sw_4_2,
          trans1_datalogger_sw_4_3,
          trans1_datalogger_sw_4_4,
          trans1_datalogger_sw_4_5,
          trans1_datalogger_sw_4_6,
          trans1_datalogger_sw_5_0,
          trans1_datalogger_sw_5_1,
          trans1_datalogger_sw_5_2,
          trans1_datalogger_sw_5_3,
          trans1_datalogger_sw_5_4,
          trans1_datalogger_sw_5_5
    }
}

MENU Tab_s_measured_values_2_w_datalogger
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_datalogger_sw_5_6,
          trans1_datalogger_sw_6_0,
          trans1_datalogger_sw_6_1,
          trans1_datalogger_sw_6_2,
          trans1_datalogger_sw_6_3,
          trans1_datalogger_sw_6_4,
          trans1_datalogger_sw_6_5,
          trans1_datalogger_sw_6_6,
          trans1_datalogger_sw_7_0,
          trans1_datalogger_sw_7_1,
          trans1_datalogger_sw_7_2,
          trans1_datalogger_sw_7_3,
          trans1_datalogger_sw_7_4,
          trans1_datalogger_sw_7_5,
          trans1_datalogger_sw_7_6,
          trans1_datalogger_sw_8_0,
          trans1_datalogger_sw_8_1,
          trans1_datalogger_sw_8_2,
          trans1_datalogger_sw_8_3,
          trans1_datalogger_sw_8_4,
          trans1_datalogger_sw_8_5,
          trans1_datalogger_sw_8_6,
          trans1_datalogger_sw_9_0,
          trans1_datalogger_sw_9_1,
          trans1_datalogger_sw_9_2,
          trans1_datalogger_sw_9_3,
          trans1_datalogger_sw_9_4,
          trans1_datalogger_sw_9_5,
          trans1_datalogger_sw_9_6,
          trans1_datalogger_sw_10_0,
          trans1_datalogger_sw_10_1,
          trans1_datalogger_sw_10_2,
          trans1_datalogger_sw_10_3,
          trans1_datalogger_sw_10_4
    }
}


MENU Tab_s_measured_values_3_w_datalogger
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_datalogger_sw_10_5,
          trans1_datalogger_sw_10_6,
          trans1_datalogger_sw_11_0,
          trans1_datalogger_sw_11_1,
          trans1_datalogger_sw_11_2,
          trans1_datalogger_sw_11_3,
          trans1_datalogger_sw_11_4,
          trans1_datalogger_sw_11_5,
          trans1_datalogger_sw_11_6,
          trans1_datalogger_sw_12_0,
          trans1_datalogger_sw_12_1,
          trans1_datalogger_sw_12_2,
          trans1_datalogger_sw_12_3,
          trans1_datalogger_sw_12_4,
          trans1_datalogger_sw_12_5,
          trans1_datalogger_sw_12_6,
          trans1_datalogger_sw_13_0,
          trans1_datalogger_sw_13_1,
          trans1_datalogger_sw_13_2,
          trans1_datalogger_sw_13_3,
          trans1_datalogger_sw_13_4,
          trans1_datalogger_sw_13_5,
          trans1_datalogger_sw_13_6,
          trans1_datalogger_sw_14_0,
          trans1_datalogger_sw_14_1,
          trans1_datalogger_sw_14_2,
          trans1_datalogger_sw_14_3,
          trans1_datalogger_sw_14_4,
          trans1_datalogger_sw_14_5,
          trans1_datalogger_sw_14_6,
          trans1_datalogger_sw_15_0,
          trans1_datalogger_sw_15_1
    }
}

MENU Tab_s_pos_y_datalogger
{
    LABEL     "Drive signal y" "|de|Stellsignal y";

    ITEMS
    {
          Tab_s_measured_values_1_y_datalogger,
          Tab_s_measured_values_2_y_datalogger,
          Tab_s_measured_values_3_y_datalogger
    }
}

MENU Tab_s_measured_values_1_y_datalogger
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_datalogger_ss_1_0,
          trans1_datalogger_ss_1_1,
          trans1_datalogger_ss_1_2,
          trans1_datalogger_ss_1_3,
          trans1_datalogger_ss_1_4,
          trans1_datalogger_ss_1_5,
          trans1_datalogger_ss_1_6,
          trans1_datalogger_ss_2_0,
          trans1_datalogger_ss_2_1,
          trans1_datalogger_ss_2_2,
          trans1_datalogger_ss_2_3,
          trans1_datalogger_ss_2_4,
          trans1_datalogger_ss_2_5,
          trans1_datalogger_ss_2_6,
          trans1_datalogger_ss_3_0,
          trans1_datalogger_ss_3_1,
          trans1_datalogger_ss_3_2,
          trans1_datalogger_ss_3_3,
          trans1_datalogger_ss_3_4,
          trans1_datalogger_ss_3_5,
          trans1_datalogger_ss_3_6,
          trans1_datalogger_ss_4_0,
          trans1_datalogger_ss_4_1,
          trans1_datalogger_ss_4_2,
          trans1_datalogger_ss_4_3,
          trans1_datalogger_ss_4_4,
          trans1_datalogger_ss_4_5,
          trans1_datalogger_ss_4_6,
          trans1_datalogger_ss_5_0,
          trans1_datalogger_ss_5_1,
          trans1_datalogger_ss_5_2,
          trans1_datalogger_ss_5_3,
          trans1_datalogger_ss_5_4,
          trans1_datalogger_ss_5_5
    }
}

MENU Tab_s_measured_values_2_y_datalogger
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_datalogger_ss_5_6,
          trans1_datalogger_ss_6_0,
          trans1_datalogger_ss_6_1,
          trans1_datalogger_ss_6_2,
          trans1_datalogger_ss_6_3,
          trans1_datalogger_ss_6_4,
          trans1_datalogger_ss_6_5,
          trans1_datalogger_ss_6_6,
          trans1_datalogger_ss_7_0,
          trans1_datalogger_ss_7_1,
          trans1_datalogger_ss_7_2,
          trans1_datalogger_ss_7_3,
          trans1_datalogger_ss_7_4,
          trans1_datalogger_ss_7_5,
          trans1_datalogger_ss_7_6,
          trans1_datalogger_ss_8_0,
          trans1_datalogger_ss_8_1,
          trans1_datalogger_ss_8_2,
          trans1_datalogger_ss_8_3,
          trans1_datalogger_ss_8_4,
          trans1_datalogger_ss_8_5,
          trans1_datalogger_ss_8_6,
          trans1_datalogger_ss_9_0,
          trans1_datalogger_ss_9_1,
          trans1_datalogger_ss_9_2,
          trans1_datalogger_ss_9_3,
          trans1_datalogger_ss_9_4,
          trans1_datalogger_ss_9_5,
          trans1_datalogger_ss_9_6,
          trans1_datalogger_ss_10_0,
          trans1_datalogger_ss_10_1,
          trans1_datalogger_ss_10_2,
          trans1_datalogger_ss_10_3,
          trans1_datalogger_ss_10_4
    }
}


MENU Tab_s_measured_values_3_y_datalogger
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_datalogger_ss_10_5,
          trans1_datalogger_ss_10_6,
          trans1_datalogger_ss_11_0,
          trans1_datalogger_ss_11_1,
          trans1_datalogger_ss_11_2,
          trans1_datalogger_ss_11_3,
          trans1_datalogger_ss_11_4,
          trans1_datalogger_ss_11_5,
          trans1_datalogger_ss_11_6,
          trans1_datalogger_ss_12_0,
          trans1_datalogger_ss_12_1,
          trans1_datalogger_ss_12_2,
          trans1_datalogger_ss_12_3,
          trans1_datalogger_ss_12_4,
          trans1_datalogger_ss_12_5,
          trans1_datalogger_ss_12_6,
          trans1_datalogger_ss_13_0,
          trans1_datalogger_ss_13_1,
          trans1_datalogger_ss_13_2,
          trans1_datalogger_ss_13_3,
          trans1_datalogger_ss_13_4,
          trans1_datalogger_ss_13_5,
          trans1_datalogger_ss_13_6,
          trans1_datalogger_ss_14_0,
          trans1_datalogger_ss_14_1,
          trans1_datalogger_ss_14_2,
          trans1_datalogger_ss_14_3,
          trans1_datalogger_ss_14_4,
          trans1_datalogger_ss_14_5,
          trans1_datalogger_ss_14_6,
          trans1_datalogger_ss_15_0,
          trans1_datalogger_ss_15_1
    }
}

MENU Tab_s_pos_e_datalogger
{
    LABEL     "Setpoint deviation e" "|de|Regelabweichung e";

    ITEMS
    {
          Tab_s_measured_values_1_e_datalogger,
          Tab_s_measured_values_2_e_datalogger,
          Tab_s_measured_values_3_e_datalogger
    }
}

MENU Tab_s_measured_values_1_e_datalogger
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_datalogger_e_1_0,
          trans1_datalogger_e_1_1,
          trans1_datalogger_e_1_2,
          trans1_datalogger_e_1_3,
          trans1_datalogger_e_1_4,
          trans1_datalogger_e_1_5,
          trans1_datalogger_e_1_6,
          trans1_datalogger_e_2_0,
          trans1_datalogger_e_2_1,
          trans1_datalogger_e_2_2,
          trans1_datalogger_e_2_3,
          trans1_datalogger_e_2_4,
          trans1_datalogger_e_2_5,
          trans1_datalogger_e_2_6,
          trans1_datalogger_e_3_0,
          trans1_datalogger_e_3_1,
          trans1_datalogger_e_3_2,
          trans1_datalogger_e_3_3,
          trans1_datalogger_e_3_4,
          trans1_datalogger_e_3_5,
          trans1_datalogger_e_3_6,
          trans1_datalogger_e_4_0,
          trans1_datalogger_e_4_1,
          trans1_datalogger_e_4_2,
          trans1_datalogger_e_4_3,
          trans1_datalogger_e_4_4,
          trans1_datalogger_e_4_5,
          trans1_datalogger_e_4_6,
          trans1_datalogger_e_5_0,
          trans1_datalogger_e_5_1,
          trans1_datalogger_e_5_2,
          trans1_datalogger_e_5_3,
          trans1_datalogger_e_5_4,
          trans1_datalogger_e_5_5
    }
}

MENU Tab_s_measured_values_2_e_datalogger
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_datalogger_e_5_6,
          trans1_datalogger_e_6_0,
          trans1_datalogger_e_6_1,
          trans1_datalogger_e_6_2,
          trans1_datalogger_e_6_3,
          trans1_datalogger_e_6_4,
          trans1_datalogger_e_6_5,
          trans1_datalogger_e_6_6,
          trans1_datalogger_e_7_0,
          trans1_datalogger_e_7_1,
          trans1_datalogger_e_7_2,
          trans1_datalogger_e_7_3,
          trans1_datalogger_e_7_4,
          trans1_datalogger_e_7_5,
          trans1_datalogger_e_7_6,
          trans1_datalogger_e_8_0,
          trans1_datalogger_e_8_1,
          trans1_datalogger_e_8_2,
          trans1_datalogger_e_8_3,
          trans1_datalogger_e_8_4,
          trans1_datalogger_e_8_5,
          trans1_datalogger_e_8_6,
          trans1_datalogger_e_9_0,
          trans1_datalogger_e_9_1,
          trans1_datalogger_e_9_2,
          trans1_datalogger_e_9_3,
          trans1_datalogger_e_9_4,
          trans1_datalogger_e_9_5,
          trans1_datalogger_e_9_6,
          trans1_datalogger_e_10_0,
          trans1_datalogger_e_10_1,
          trans1_datalogger_e_10_2,
          trans1_datalogger_e_10_3,
          trans1_datalogger_e_10_4
    }
}


MENU Tab_s_measured_values_3_e_datalogger
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_datalogger_e_10_5,
          trans1_datalogger_e_10_6,
          trans1_datalogger_e_11_0,
          trans1_datalogger_e_11_1,
          trans1_datalogger_e_11_2,
          trans1_datalogger_e_11_3,
          trans1_datalogger_e_11_4,
          trans1_datalogger_e_11_5,
          trans1_datalogger_e_11_6,
          trans1_datalogger_e_12_0,
          trans1_datalogger_e_12_1,
          trans1_datalogger_e_12_2,
          trans1_datalogger_e_12_3,
          trans1_datalogger_e_12_4,
          trans1_datalogger_e_12_5,
          trans1_datalogger_e_12_6,
          trans1_datalogger_e_13_0,
          trans1_datalogger_e_13_1,
          trans1_datalogger_e_13_2,
          trans1_datalogger_e_13_3,
          trans1_datalogger_e_13_4,
          trans1_datalogger_e_13_5,
          trans1_datalogger_e_13_6,
          trans1_datalogger_e_14_0,
          trans1_datalogger_e_14_1,
          trans1_datalogger_e_14_2,
          trans1_datalogger_e_14_3,
          trans1_datalogger_e_14_4,
          trans1_datalogger_e_14_5,
          trans1_datalogger_e_14_6,
          trans1_datalogger_e_15_0,
          trans1_datalogger_e_15_1
    }
}

MENU Tab_s_pos_t_datalogger
{
    LABEL     "Time data t" "|de|Zeitmesswerte t";

    ITEMS
    {
          trans1_datalogger_counter_day,
          trans1_datalogger_counter_hour,
          trans1_datalogger_counter_minute,
          trans1_datalogger_counter_second,
          Tab_s_measured_values_1_t_datalogger,
          Tab_s_measured_values_2_t_datalogger,
          Tab_s_measured_values_3_t_datalogger
    }
}


MENU Tab_s_measured_values_1_t_datalogger
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_datalogger_t_1_0,
          trans1_datalogger_t_1_1,
          trans1_datalogger_t_1_2,
          trans1_datalogger_t_1_3,
          trans1_datalogger_t_1_4,
          trans1_datalogger_t_1_5,
          trans1_datalogger_t_1_6,
          trans1_datalogger_t_2_0,
          trans1_datalogger_t_2_1,
          trans1_datalogger_t_2_2,
          trans1_datalogger_t_2_3,
          trans1_datalogger_t_2_4,
          trans1_datalogger_t_2_5,
          trans1_datalogger_t_2_6,
          trans1_datalogger_t_3_0,
          trans1_datalogger_t_3_1,
          trans1_datalogger_t_3_2,
          trans1_datalogger_t_3_3,
          trans1_datalogger_t_3_4,
          trans1_datalogger_t_3_5,
          trans1_datalogger_t_3_6,
          trans1_datalogger_t_4_0,
          trans1_datalogger_t_4_1,
          trans1_datalogger_t_4_2,
          trans1_datalogger_t_4_3,
          trans1_datalogger_t_4_4,
          trans1_datalogger_t_4_5,
          trans1_datalogger_t_4_6,
          trans1_datalogger_t_5_0,
          trans1_datalogger_t_5_1,
          trans1_datalogger_t_5_2,
          trans1_datalogger_t_5_3,
          trans1_datalogger_t_5_4,
          trans1_datalogger_t_5_5
    }
}

MENU Tab_s_measured_values_2_t_datalogger
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_datalogger_t_5_6,
          trans1_datalogger_t_6_0,
          trans1_datalogger_t_6_1,
          trans1_datalogger_t_6_2,
          trans1_datalogger_t_6_3,
          trans1_datalogger_t_6_4,
          trans1_datalogger_t_6_5,
          trans1_datalogger_t_6_6,
          trans1_datalogger_t_7_0,
          trans1_datalogger_t_7_1,
          trans1_datalogger_t_7_2,
          trans1_datalogger_t_7_3,
          trans1_datalogger_t_7_4,
          trans1_datalogger_t_7_5,
          trans1_datalogger_t_7_6,
          trans1_datalogger_t_8_0,
          trans1_datalogger_t_8_1,
          trans1_datalogger_t_8_2,
          trans1_datalogger_t_8_3,
          trans1_datalogger_t_8_4,
          trans1_datalogger_t_8_5,
          trans1_datalogger_t_8_6,
          trans1_datalogger_t_9_0,
          trans1_datalogger_t_9_1,
          trans1_datalogger_t_9_2,
          trans1_datalogger_t_9_3,
          trans1_datalogger_t_9_4,
          trans1_datalogger_t_9_5,
          trans1_datalogger_t_9_6,
          trans1_datalogger_t_10_0,
          trans1_datalogger_t_10_1,
          trans1_datalogger_t_10_2,
          trans1_datalogger_t_10_3,
          trans1_datalogger_t_10_4
    }
}


MENU Tab_s_measured_values_3_t_datalogger
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_datalogger_t_10_5,
          trans1_datalogger_t_10_6,
          trans1_datalogger_t_11_0,
          trans1_datalogger_t_11_1,
          trans1_datalogger_t_11_2,
          trans1_datalogger_t_11_3,
          trans1_datalogger_t_11_4,
          trans1_datalogger_t_11_5,
          trans1_datalogger_t_11_6,
          trans1_datalogger_t_12_0,
          trans1_datalogger_t_12_1,
          trans1_datalogger_t_12_2,
          trans1_datalogger_t_12_3,
          trans1_datalogger_t_12_4,
          trans1_datalogger_t_12_5,
          trans1_datalogger_t_12_6,
          trans1_datalogger_t_13_0,
          trans1_datalogger_t_13_1,
          trans1_datalogger_t_13_2,
          trans1_datalogger_t_13_3,
          trans1_datalogger_t_13_4,
          trans1_datalogger_t_13_5,
          trans1_datalogger_t_13_6,
          trans1_datalogger_t_14_0,
          trans1_datalogger_t_14_1,
          trans1_datalogger_t_14_2,
          trans1_datalogger_t_14_3,
          trans1_datalogger_t_14_4,
          trans1_datalogger_t_14_5,
          trans1_datalogger_t_14_6,
          trans1_datalogger_t_15_0,
          trans1_datalogger_t_15_1
    }
}
*/

/* Histogramm X Lang ************************************************************/
MENU Tab_s_histogramm_x
{
    LABEL   "Travel histogram x" "|de|Histogramm Ventilstellung x" ;

    ITEMS
    {
		trans1_X_Average,
		trans1_Number_Mess_Points,

        trans1_X_Interval_Value_0,
		trans1_X_Interval_Value_1,
		trans1_X_Interval_Value_2,
		trans1_X_Interval_Value_3,
		trans1_X_Interval_Value_4,
		trans1_X_Interval_Value_5,
		trans1_X_Interval_Value_6,
		trans1_X_Interval_Value_7,
		trans1_X_Interval_Value_8,
		trans1_X_Interval_Value_9,
		trans1_X_Interval_Value_10,
		trans1_X_Interval_Value_11,
		trans1_X_Interval_Value_12,
		trans1_X_Interval_Value_13,
		trans1_X_Interval_Value_14,
		trans1_X_Interval_Value_15,
		trans1_X_Interval_Value_16,
		trans1_X_Interval_Value_17,
		trans1_X_Interval_Value_18,
		trans1_X_Interval_Value_19,
		trans1_X_Interval_Value_20,
		trans1_X_Interval_Value_21,

        Tab_s_short_terme_X
    }
}

/* Histogramm X Kurz ******************************************/
MENU Tab_s_short_terme_X
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
		trans1_X_HIS_ABTASTRATE,
		trans1_X_Average_KURZ,

        trans1_X_Interval_Value_0_KURZ,
		trans1_X_Interval_Value_1_KURZ,
		trans1_X_Interval_Value_2_KURZ,
		trans1_X_Interval_Value_3_KURZ,
		trans1_X_Interval_Value_4_KURZ,
		trans1_X_Interval_Value_5_KURZ,
		trans1_X_Interval_Value_6_KURZ,
		trans1_X_Interval_Value_7_KURZ,
		trans1_X_Interval_Value_8_KURZ,
		trans1_X_Interval_Value_9_KURZ,
		trans1_X_Interval_Value_10_KURZ,
		trans1_X_Interval_Value_11_KURZ,
		trans1_X_Interval_Value_12_KURZ,
		trans1_X_Interval_Value_13_KURZ,
		trans1_X_Interval_Value_14_KURZ,
		trans1_X_Interval_Value_15_KURZ,
		trans1_X_Interval_Value_16_KURZ,
		trans1_X_Interval_Value_17_KURZ,
		trans1_X_Interval_Value_18_KURZ,
		trans1_X_Interval_Value_19_KURZ,
		trans1_X_Interval_Value_20_KURZ,
		trans1_X_Interval_Value_21_KURZ
    }
}




/* Histogramm E ************************************************************/
MENU Tab_s_histogramm_e
{
    LABEL   "Setpoint deviation histogram e" "|de|Histogramm Regelabweichung e" ;

    ITEMS
    {
		trans1_E_Average,
		trans1_Total_Number_E,
        trans1_deviation_min,
		trans1_deviation_max,

        trans1_E_Interval_Value_0,
        trans1_E_Interval_Value_1,
		trans1_E_Interval_Value_2,
		trans1_E_Interval_Value_3,
		trans1_E_Interval_Value_4,
		trans1_E_Interval_Value_5,
		trans1_E_Interval_Value_6,
		trans1_E_Interval_Value_7,
		trans1_E_Interval_Value_8,
		trans1_E_Interval_Value_9,
		trans1_E_Interval_Value_10,
		trans1_E_Interval_Value_11,

		Tab_s_short_time_E
    }
}

/* Histogramm E Kurz ******************************************/
MENU Tab_s_short_time_E
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
		trans1_E_HIS_ABTASTRATE,
		trans1_E_Average_KURZ,

        trans1_E_Interval_Value_0_KURZ,
        trans1_E_Interval_Value_1_KURZ,
		trans1_E_Interval_Value_2_KURZ,
		trans1_E_Interval_Value_3_KURZ,
		trans1_E_Interval_Value_4_KURZ,
		trans1_E_Interval_Value_5_KURZ,
		trans1_E_Interval_Value_6_KURZ,
		trans1_E_Interval_Value_7_KURZ,
		trans1_E_Interval_Value_8_KURZ,
		trans1_E_Interval_Value_9_KURZ,
		trans1_E_Interval_Value_10_KURZ,
		trans1_E_Interval_Value_11_KURZ
    }
}


/* Histogramm Z ************************************************************/
MENU Tab_s_histogramm_z
{
    LABEL  "Cycle counter histogram" "|de|Histogramm Zyklenzhler" ;

    ITEMS
    {
		trans1_Z_Average,
		trans1_Total_Number_Z,
		trans1_Dynamic_Factor,

        trans1_Z_Interval_Value_0,
        trans1_Z_Interval_Value_1,
		trans1_Z_Interval_Value_2,
		trans1_Z_Interval_Value_3,
		trans1_Z_Interval_Value_4,
		trans1_Z_Interval_Value_5,
		trans1_Z_Interval_Value_6,
		trans1_Z_Interval_Value_7,
		trans1_Z_Interval_Value_8,
		trans1_Z_Interval_Value_9,
		trans1_Z_Interval_Value_10,
		trans1_Z_Interval_Value_11,
		trans1_Z_Interval_Value_12,

        Tab_s_short_terme_Z
    }
}

/* Histogramm Z Kurz ******************************************/
MENU Tab_s_short_terme_Z
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
		trans1_Z_Average_KURZ,

        trans1_Z_Interval_Value_0_KURZ,
        trans1_Z_Interval_Value_1_KURZ,
		trans1_Z_Interval_Value_2_KURZ,
		trans1_Z_Interval_Value_3_KURZ,
		trans1_Z_Interval_Value_4_KURZ,
		trans1_Z_Interval_Value_5_KURZ,
		trans1_Z_Interval_Value_6_KURZ,
		trans1_Z_Interval_Value_7_KURZ,
		trans1_Z_Interval_Value_8_KURZ,
		trans1_Z_Interval_Value_9_KURZ,
		trans1_Z_Interval_Value_10_KURZ,
		trans1_Z_Interval_Value_11_KURZ,
		trans1_Z_Interval_Value_12_KURZ
    }
}

/* Stellsignal Y ************************************************************/
MENU Tab_s_stellsignal_y
{
    LABEL     "Drive signal diagram y" "|de|Diagramm Stellsignal y" ;

    ITEMS
    {
          Tab_s_stationaer,
          Tab_s_hysterese
    }
}

/* Stellsignal Y - Stationaer ************************************************************/
MENU Tab_s_stationaer
{
    LABEL     "Steady" "|de|Stationaer" ;

    ITEMS
    {
          Tab_s_stat_longterm,
          Tab_s_stat_shortterm
    }
}


/* Stellsignal Y - Stationaer Langzeit ************************************************************/
MENU Tab_s_stat_longterm
{
    LABEL "Long-term" "|de|Langzeitbetrachtung";

    ITEMS
    {
          trans1_stationaer_lang_Value_0,
          trans1_stationaer_lang_Value_1,
          trans1_stationaer_lang_Value_2,
          trans1_stationaer_lang_Value_3,
          trans1_stationaer_lang_Value_4,
          trans1_stationaer_lang_Value_5,
          trans1_stationaer_lang_Value_6,
          trans1_stationaer_lang_Value_7,
          trans1_stationaer_lang_Value_8,
          trans1_stationaer_lang_Value_9,
          trans1_stationaer_lang_Value_10,
          trans1_stationaer_lang_Value_11,
          trans1_stationaer_lang_Value_12,
          trans1_stationaer_lang_Value_13,
          trans1_stationaer_lang_Value_14,
          trans1_stationaer_lang_Value_15,
          trans1_stationaer_lang_Value_16,
          trans1_stationaer_lang_Value_17,
          trans1_stationaer_lang_Value_18,
          trans1_stationaer_lang_Value_19,
          trans1_stationaer_lang_Value_20,
          trans1_stationaer_lang_Value_21
    }
}

/* Stellsignal Y - Stationaer Kurzzeit ************************************************************/
MENU Tab_s_stat_shortterm
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
          trans1_stationaer_kurz_Value_0,
          trans1_stationaer_kurz_Value_1,
          trans1_stationaer_kurz_Value_2,
          trans1_stationaer_kurz_Value_3,
          trans1_stationaer_kurz_Value_4,
          trans1_stationaer_kurz_Value_5,
          trans1_stationaer_kurz_Value_6,
          trans1_stationaer_kurz_Value_7,
          trans1_stationaer_kurz_Value_8,
          trans1_stationaer_kurz_Value_9,
          trans1_stationaer_kurz_Value_10,
          trans1_stationaer_kurz_Value_11,
          trans1_stationaer_kurz_Value_12,
          trans1_stationaer_kurz_Value_13,
          trans1_stationaer_kurz_Value_14,
          trans1_stationaer_kurz_Value_15,
          trans1_stationaer_kurz_Value_16,
          trans1_stationaer_kurz_Value_17,
          trans1_stationaer_kurz_Value_18,
          trans1_stationaer_kurz_Value_19,
          trans1_stationaer_kurz_Value_20,
          trans1_stationaer_kurz_Value_21,

          Tab_s_stat_stellsignal,
          Tab_s_stat_ventilstellung
    }
}

/* Stellsignal Y - Stationaer Kurzzeit Stellsignal ****************************************************/
MENU Tab_s_stat_stellsignal
{
    LABEL     "Drive signal" "|de|Stellsignal" ;

    ITEMS
    {
          trans1_stat_stellsignal_Value_0,
          trans1_stat_stellsignal_Value_1,
          trans1_stat_stellsignal_Value_2,
          trans1_stat_stellsignal_Value_3,
          trans1_stat_stellsignal_Value_4,
          trans1_stat_stellsignal_Value_5,
          trans1_stat_stellsignal_Value_6,
          trans1_stat_stellsignal_Value_7,
          trans1_stat_stellsignal_Value_8,
          trans1_stat_stellsignal_Value_9

    }
}

/* Stellsignal Y - Stationaer Kurzzeit Ventilstellung ****************************************************/
MENU Tab_s_stat_ventilstellung
{
    LABEL     "Valve position" "|de|Ventilstellung" ;

    ITEMS
    {
          trans1_stat_ventilstellung_Value_0,
          trans1_stat_ventilstellung_Value_1,
          trans1_stat_ventilstellung_Value_2,
          trans1_stat_ventilstellung_Value_3,
          trans1_stat_ventilstellung_Value_4,
          trans1_stat_ventilstellung_Value_5,
          trans1_stat_ventilstellung_Value_6,
          trans1_stat_ventilstellung_Value_7,
          trans1_stat_ventilstellung_Value_8,
          trans1_stat_ventilstellung_Value_9
    }
}

/* Stellsignal Y - Hysterese ********************************************************/
MENU Tab_s_hysterese
{
    LABEL     "Hysteresis" "|de|Hysterese" ;

    ITEMS
    {
          start_hys_online_test,
          abort_hys_online_test,
          trans1_autostart_hyst,

          Tab_s_hys_longterm,
          Tab_s_hys_shortterm
    }
}


/* Stellsignal Y - Hysterese Langzeit ************************************************************/
MENU Tab_s_hys_longterm
{
    LABEL "Long-term" "|de|Langzeitbetrachtung";

    ITEMS
    {
          trans1_hysterese_lang_Value_0,
          trans1_hysterese_lang_Value_1,
          trans1_hysterese_lang_Value_2,
          trans1_hysterese_lang_Value_3,
          trans1_hysterese_lang_Value_4,
          trans1_hysterese_lang_Value_5,
          trans1_hysterese_lang_Value_6,
          trans1_hysterese_lang_Value_7,
          trans1_hysterese_lang_Value_8,
          trans1_hysterese_lang_Value_9,
          trans1_hysterese_lang_Value_10,
          trans1_hysterese_lang_Value_11,
          trans1_hysterese_lang_Value_12,
          trans1_hysterese_lang_Value_13,
          trans1_hysterese_lang_Value_14,
          trans1_hysterese_lang_Value_15,
          trans1_hysterese_lang_Value_16,
          trans1_hysterese_lang_Value_17,
          trans1_hysterese_lang_Value_18
    }
}

/* Stellsignal Y - Hysterese Kurzzeit ************************************************************/
MENU Tab_s_hys_shortterm
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
          Tab_s_hys_stellsignal,
          Tab_s_hys_ventilstellung
    }
}

/* Stellsignal Y - Hysterese Kurzzeit Stellsignal ****************************************************/
MENU Tab_s_hys_stellsignal
{
    LABEL     "Difference drive signal" "|de|Differenz Stellsignal" ;

    ITEMS
    {
          trans1_hys_stellsignal_Value_0,
          trans1_hys_stellsignal_Value_1,
          trans1_hys_stellsignal_Value_2,
          trans1_hys_stellsignal_Value_3,
          trans1_hys_stellsignal_Value_4,
          trans1_hys_stellsignal_Value_5,
          trans1_hys_stellsignal_Value_6,
          trans1_hys_stellsignal_Value_7,
          trans1_hys_stellsignal_Value_8,
          trans1_hys_stellsignal_Value_9
    }
}

/* Stellsignal Y - Hysterese Kurzzeit Ventilstellung ****************************************************/
MENU Tab_s_hys_ventilstellung
{
    LABEL     "Valve position" "|de|Ventilstellung" ;

    ITEMS
    {
          trans1_hys_ventilstellung_Value_0,
          trans1_hys_ventilstellung_Value_1,
          trans1_hys_ventilstellung_Value_2,
          trans1_hys_ventilstellung_Value_3,
          trans1_hys_ventilstellung_Value_4,
          trans1_hys_ventilstellung_Value_5,
          trans1_hys_ventilstellung_Value_6,
          trans1_hys_ventilstellung_Value_7,
          trans1_hys_ventilstellung_Value_8,
          trans1_hys_ventilstellung_Value_9
    }
}

/* Endlagentrend ****************************************************/
MENU Tab_s_endlagentrend
{
    LABEL     "Trend of travel end position" "|de|Endlagentrend" ;

    ITEMS
    {
          trans1_et_ventil_refwert,
          trans1_et_BSZ_refwert,
          trans1_et_endlage_refwert,

          trans1_et_ventil_Value_0,
          trans1_et_BSZ_Value_0,
          trans1_et_endlage_Value_0,

          trans1_et_ventil_Value_1,
          trans1_et_BSZ_Value_1,
          trans1_et_endlage_Value_1,

          trans1_et_ventil_Value_2,
          trans1_et_BSZ_Value_2,
          trans1_et_endlage_Value_2,

          trans1_et_ventil_Value_3,
          trans1_et_BSZ_Value_3,
          trans1_et_endlage_Value_3,

          trans1_et_ventil_Value_4,
          trans1_et_BSZ_Value_4,
          trans1_et_endlage_Value_4,

          trans1_et_ventil_Value_5,
          trans1_et_BSZ_Value_5,
          trans1_et_endlage_Value_5,

          trans1_et_ventil_Value_6,
          trans1_et_BSZ_Value_6,
          trans1_et_endlage_Value_6,

          trans1_et_ventil_Value_7,
          trans1_et_BSZ_Value_7,
          trans1_et_endlage_Value_7,

          trans1_et_ventil_Value_8,
          trans1_et_BSZ_Value_8,
          trans1_et_endlage_Value_8,

          trans1_et_ventil_Value_9,
          trans1_et_BSZ_Value_9,
          trans1_et_endlage_Value_9,

          trans1_et_ventil_Value_10,
          trans1_et_BSZ_Value_10,
          trans1_et_endlage_Value_10,

          trans1_et_ventil_Value_11,
          trans1_et_BSZ_Value_11,
          trans1_et_endlage_Value_11,

          trans1_et_ventil_Value_12,
          trans1_et_BSZ_Value_12,
          trans1_et_endlage_Value_12,

          trans1_et_ventil_Value_13,
          trans1_et_BSZ_Value_13,
          trans1_et_endlage_Value_13,

          trans1_et_ventil_Value_14,
          trans1_et_BSZ_Value_14,
          trans1_et_endlage_Value_14,

          trans1_et_ventil_Value_15,
          trans1_et_BSZ_Value_15,
          trans1_et_endlage_Value_15,

          trans1_et_ventil_Value_16,
          trans1_et_BSZ_Value_16,
          trans1_et_endlage_Value_16,

          trans1_et_ventil_Value_17,
          trans1_et_BSZ_Value_17,
          trans1_et_endlage_Value_17,

          trans1_et_ventil_Value_18,
          trans1_et_BSZ_Value_18,
          trans1_et_endlage_Value_18,

          trans1_et_ventil_Value_19,
          trans1_et_BSZ_Value_19,
          trans1_et_endlage_Value_19,

          trans1_et_ventil_Value_20,
          trans1_et_BSZ_Value_20,
          trans1_et_endlage_Value_20,

          trans1_et_ventil_Value_21,
          trans1_et_BSZ_Value_21,
          trans1_et_endlage_Value_21,

          trans1_et_ventil_Value_22,
          trans1_et_BSZ_Value_22,
          trans1_et_endlage_Value_22,

          trans1_et_ventil_Value_23,
          trans1_et_BSZ_Value_23,
          trans1_et_endlage_Value_23,

          trans1_et_ventil_Value_24,
          trans1_et_BSZ_Value_24,
          trans1_et_endlage_Value_24,

          trans1_et_ventil_Value_25,
          trans1_et_BSZ_Value_25,
          trans1_et_endlage_Value_25,

          trans1_et_ventil_Value_26,
          trans1_et_BSZ_Value_26,
          trans1_et_endlage_Value_26,

          trans1_et_ventil_Value_27,
          trans1_et_BSZ_Value_27,
          trans1_et_endlage_Value_27,

          trans1_et_ventil_Value_28,
          trans1_et_BSZ_Value_28,
          trans1_et_endlage_Value_28,

          trans1_et_BSZ_Value_29,
          trans1_et_ventil_Value_29,
          trans1_et_endlage_Value_29
    }
}





/* Testfunktionen HAND ************************************************************/
MENU Tab_s_beobachter_hand
{
    LABEL     "Tests MAN" "|de|Testfunktionen HAND" ;

    ITEMS
    {
          Tab_s_drive_signal_stat,
          Tab_s_drive_signal_hys,
          Tab_s_static_charact,
          Tab_s_step_response
    }
    VALIDITY_ONLY_EXPERT_PLUS
}


/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat
{
    LABEL     "Drive signal steady" "|de|Stellsignal y Stationaer" ;

    ITEMS
    {
          trans1_stat_ss_refzeit,

          Tab_s_drive_signal_stat_ref_vs,
          Tab_s_drive_signal_stat_ref_ss,
          Tab_s_drive_signal_stat_again_vs,
          Tab_s_drive_signal_stat_again_ss

    }
}


/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_ref_vs
{
    LABEL     "Reference data valve position" "|de|Referenzwert Ventilstellung" ;

    ITEMS
    {
	       trans1_stat_ref_vs_0,
	       trans1_stat_ref_vs_1,
	       trans1_stat_ref_vs_2,
	       trans1_stat_ref_vs_3,
	       trans1_stat_ref_vs_4,
	       trans1_stat_ref_vs_5,
	       trans1_stat_ref_vs_6,
	       trans1_stat_ref_vs_7,
	       trans1_stat_ref_vs_8,
	       trans1_stat_ref_vs_9,
	       trans1_stat_ref_vs_10,
	       trans1_stat_ref_vs_11,
	       trans1_stat_ref_vs_12,
	       trans1_stat_ref_vs_13,
	       trans1_stat_ref_vs_14,
	       trans1_stat_ref_vs_15,
	       trans1_stat_ref_vs_16,
	       trans1_stat_ref_vs_17,
	       trans1_stat_ref_vs_18,
	       trans1_stat_ref_vs_19,
	       trans1_stat_ref_vs_20,
	       trans1_stat_ref_vs_21,
	       trans1_stat_ref_vs_22,
	       trans1_stat_ref_vs_23,
	       trans1_stat_ref_vs_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_ref_ss
{
    LABEL     "Reference data drive signal" "|de|Referenzwert Stellsignal" ;

    ITEMS
    {
		   trans1_stat_ref_ss_0,
	       trans1_stat_ref_ss_1,
	       trans1_stat_ref_ss_2,
	       trans1_stat_ref_ss_3,
	       trans1_stat_ref_ss_4,
	       trans1_stat_ref_ss_5,
	       trans1_stat_ref_ss_6,
	       trans1_stat_ref_ss_7,
	       trans1_stat_ref_ss_8,
	       trans1_stat_ref_ss_9,
	       trans1_stat_ref_ss_10,
	       trans1_stat_ref_ss_11,
	       trans1_stat_ref_ss_12,
	       trans1_stat_ref_ss_13,
	       trans1_stat_ref_ss_14,
	       trans1_stat_ref_ss_15,
	       trans1_stat_ref_ss_16,
	       trans1_stat_ref_ss_17,
	       trans1_stat_ref_ss_18,
	       trans1_stat_ref_ss_19,
	       trans1_stat_ref_ss_20,
	       trans1_stat_ref_ss_21,
	       trans1_stat_ref_ss_22,
	       trans1_stat_ref_ss_23,
	       trans1_stat_ref_ss_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_again_vs
{
    LABEL    "Repetition data valve position"  "|de|Wiederholungswert Ventilstellung" ;

    ITEMS
    {
		   trans1_stat_again_vs_0,
	       trans1_stat_again_vs_1,
	       trans1_stat_again_vs_2,
	       trans1_stat_again_vs_3,
	       trans1_stat_again_vs_4,
	       trans1_stat_again_vs_5,
	       trans1_stat_again_vs_6,
	       trans1_stat_again_vs_7,
	       trans1_stat_again_vs_8,
	       trans1_stat_again_vs_9,
	       trans1_stat_again_vs_10,
	       trans1_stat_again_vs_11,
	       trans1_stat_again_vs_12,
	       trans1_stat_again_vs_13,
	       trans1_stat_again_vs_14,
	       trans1_stat_again_vs_15,
	       trans1_stat_again_vs_16,
	       trans1_stat_again_vs_17,
	       trans1_stat_again_vs_18,
	       trans1_stat_again_vs_19,
	       trans1_stat_again_vs_20,
	       trans1_stat_again_vs_21,
	       trans1_stat_again_vs_22,
	       trans1_stat_again_vs_23,
	       trans1_stat_again_vs_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_again_ss
{
    LABEL    "Repetition data drive signal" "|de|Wiederholungswert Stellsignal" ;

    ITEMS
    {
	       trans1_stat_again_ss_0,
	       trans1_stat_again_ss_1,
	       trans1_stat_again_ss_2,
	       trans1_stat_again_ss_3,
	       trans1_stat_again_ss_4,
	       trans1_stat_again_ss_5,
	       trans1_stat_again_ss_6,
	       trans1_stat_again_ss_7,
	       trans1_stat_again_ss_8,
	       trans1_stat_again_ss_9,
	       trans1_stat_again_ss_10,
	       trans1_stat_again_ss_11,
	       trans1_stat_again_ss_12,
	       trans1_stat_again_ss_13,
	       trans1_stat_again_ss_14,
	       trans1_stat_again_ss_15,
	       trans1_stat_again_ss_16,
	       trans1_stat_again_ss_17,
	       trans1_stat_again_ss_18,
	       trans1_stat_again_ss_19,
	       trans1_stat_again_ss_20,
	       trans1_stat_again_ss_21,
	       trans1_stat_again_ss_22,
	       trans1_stat_again_ss_23,
	       trans1_stat_again_ss_24
    }
}


/* Stellsignal Y hysterese ************************************************************/
MENU Tab_s_drive_signal_hys
{
    LABEL     "Drive signal y hysteresis" "|de|Stellsignal y Hysterese" ;

    ITEMS
    {
          trans1_hys_ss_refzeit,

          Tab_s_drive_signal_hys_ref_vs,
          Tab_s_drive_signal_hys_ref_hys,
          Tab_s_drive_signal_hys_again_hys
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_hys_ref_vs
{
    LABEL     "Reference data valve position" "|de|Referenzwert Ventilstellung" ;

    ITEMS
    {
	     	 trans1_hys_ref_vs_0,
	     	 trans1_hys_ref_vs_1,
	     	 trans1_hys_ref_vs_2,
	     	 trans1_hys_ref_vs_3,
	     	 trans1_hys_ref_vs_4,
	     	 trans1_hys_ref_vs_5,
	     	 trans1_hys_ref_vs_6,
	     	 trans1_hys_ref_vs_7,
	     	 trans1_hys_ref_vs_8,
	     	 trans1_hys_ref_vs_9,
	     	 trans1_hys_ref_vs_10,
	     	 trans1_hys_ref_vs_11
	  }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_hys_ref_hys
{
    LABEL    "Reference measurement hysteresis" "|de|Referenzmessung Hysterese" ;

    ITEMS
    {
	     	 trans1_hys_ref_hys_0,
	     	 trans1_hys_ref_hys_1,
	     	 trans1_hys_ref_hys_2,
	     	 trans1_hys_ref_hys_3,
	     	 trans1_hys_ref_hys_4,
	     	 trans1_hys_ref_hys_5,
	     	 trans1_hys_ref_hys_6,
	     	 trans1_hys_ref_hys_7,
	     	 trans1_hys_ref_hys_8,
	     	 trans1_hys_ref_hys_9,
	     	 trans1_hys_ref_hys_10,
	     	 trans1_hys_ref_hys_11
	  }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_hys_again_hys
{
    LABEL     "Repetition data hysteresis" "|de|Wiederholungswert Hysterese" ;

    ITEMS
    {
	     	 trans1_hys_again_hys_0,
	     	 trans1_hys_again_hys_1,
	     	 trans1_hys_again_hys_2,
	     	 trans1_hys_again_hys_3,
	     	 trans1_hys_again_hys_4,
	     	 trans1_hys_again_hys_5,
	     	 trans1_hys_again_hys_6,
	     	 trans1_hys_again_hys_7,
	     	 trans1_hys_again_hys_8,
	     	 trans1_hys_again_hys_9,
	     	 trans1_hys_again_hys_10,
	     	 trans1_hys_again_hys_11
	  }
}


/* Statische Kennlinie ************************************************************/
MENU Tab_s_static_charact
{
    LABEL    "Static characteristic" "|de|Statische Kennlinie" ;

    ITEMS
    {
          trans1_stat_kenn_start,
          trans1_stat_kenn_ende,
          trans1_stat_kenn_warte,
          trans1_stat_kenn_anzahl,
          trans1_stat_kenn_sprunghoehe,
          trans1_stat_kenn_min_tot,
          trans1_stat_kenn_durch_tot,
          trans1_stat_kenn_max_tot
/* kmr: wird nicht angezeigt:
          Tab_s_measured_values*/
    }
}

/* kmr: wird nicht angezeigt:
MENU Tab_s_measured_values
{
    LABEL     "Data" "|de|Messwerte" ;

    ITEMS
    {
          Tab_s_stat_valve_pos_x,
          Tab_s_stat_valve_pos_w
    }
}

MENU Tab_s_stat_valve_pos_x
{
    LABEL     "Controlled variable x" "|de|Regelgre x" ;

    ITEMS
    {
          Tab_s_measured_values_1,
          Tab_s_measured_values_2,
          Tab_s_measured_values_3
    }
}

MENU Tab_s_measured_values_1
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_stat_vs_1_0,
          trans1_stat_vs_1_1,
          trans1_stat_vs_1_2,
          trans1_stat_vs_1_3,
          trans1_stat_vs_1_4,
          trans1_stat_vs_1_5,
          trans1_stat_vs_1_6,
          trans1_stat_vs_1_7,
          trans1_stat_vs_1_8,
          trans1_stat_vs_1_9,
          trans1_stat_vs_1_10,
          trans1_stat_vs_1_11,
          trans1_stat_vs_1_12,
          trans1_stat_vs_1_13,
          trans1_stat_vs_1_14,
          trans1_stat_vs_1_15,
          trans1_stat_vs_1_16,
          trans1_stat_vs_1_17,
          trans1_stat_vs_1_18,
          trans1_stat_vs_1_19,
          trans1_stat_vs_1_20,
          trans1_stat_vs_1_21,
          trans1_stat_vs_1_22,
          trans1_stat_vs_1_23,
          trans1_stat_vs_1_24,
          trans1_stat_vs_2_0,
          trans1_stat_vs_2_1,
          trans1_stat_vs_2_2,
          trans1_stat_vs_2_3,
          trans1_stat_vs_2_4,
          trans1_stat_vs_2_5,
          trans1_stat_vs_2_6,
          trans1_stat_vs_2_7,
          trans1_stat_vs_2_8
    }
}

MENU Tab_s_measured_values_2
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_stat_vs_2_9,
          trans1_stat_vs_2_10,
          trans1_stat_vs_2_11,
          trans1_stat_vs_2_12,
          trans1_stat_vs_2_13,
          trans1_stat_vs_2_14,
          trans1_stat_vs_2_15,
          trans1_stat_vs_2_16,
          trans1_stat_vs_2_17,
          trans1_stat_vs_2_18,
          trans1_stat_vs_2_19,
          trans1_stat_vs_2_20,
          trans1_stat_vs_2_21,
          trans1_stat_vs_2_22,
          trans1_stat_vs_2_23,
          trans1_stat_vs_2_24,
          trans1_stat_vs_3_0,
          trans1_stat_vs_3_1,
          trans1_stat_vs_3_2,
          trans1_stat_vs_3_3,
          trans1_stat_vs_3_4,
          trans1_stat_vs_3_5,
          trans1_stat_vs_3_6,
          trans1_stat_vs_3_7,
          trans1_stat_vs_3_8,
          trans1_stat_vs_3_9,
          trans1_stat_vs_3_10,
          trans1_stat_vs_3_11,
          trans1_stat_vs_3_12,
          trans1_stat_vs_3_13,
          trans1_stat_vs_3_14,
          trans1_stat_vs_3_15,
          trans1_stat_vs_3_16,
          trans1_stat_vs_3_17
    }
}


MENU Tab_s_measured_values_3
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_stat_vs_3_18,
          trans1_stat_vs_3_19,
          trans1_stat_vs_3_20,
          trans1_stat_vs_3_21,
          trans1_stat_vs_3_22,
          trans1_stat_vs_3_23,
          trans1_stat_vs_3_24,
          trans1_stat_vs_4_0,
          trans1_stat_vs_4_1,
          trans1_stat_vs_4_2,
          trans1_stat_vs_4_3,
          trans1_stat_vs_4_4,
          trans1_stat_vs_4_5,
          trans1_stat_vs_4_6,
          trans1_stat_vs_4_7,
          trans1_stat_vs_4_8,
          trans1_stat_vs_4_9,
          trans1_stat_vs_4_10,
          trans1_stat_vs_4_11,
          trans1_stat_vs_4_12,
          trans1_stat_vs_4_13,
          trans1_stat_vs_4_14,
          trans1_stat_vs_4_15,
          trans1_stat_vs_4_16,
          trans1_stat_vs_4_17,
          trans1_stat_vs_4_18,
          trans1_stat_vs_4_19,
          trans1_stat_vs_4_20,
          trans1_stat_vs_4_21,
          trans1_stat_vs_4_22,
          trans1_stat_vs_4_23,
          trans1_stat_vs_4_24
    }
}

MENU Tab_s_stat_valve_pos_w
{
    LABEL     "|de|Sollwert w" ;

    ITEMS
    {
          Tab_s_measured_values_1_w,
          Tab_s_measured_values_2_w,
          Tab_s_measured_values_3_w
    }
}

MENU Tab_s_measured_values_1_w
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_stat_sw_1_0,
          trans1_stat_sw_1_1,
          trans1_stat_sw_1_2,
          trans1_stat_sw_1_3,
          trans1_stat_sw_1_4,
          trans1_stat_sw_1_5,
          trans1_stat_sw_1_6,
          trans1_stat_sw_1_7,
          trans1_stat_sw_1_8,
          trans1_stat_sw_1_9,
          trans1_stat_sw_1_10,
          trans1_stat_sw_1_11,
          trans1_stat_sw_1_12,
          trans1_stat_sw_1_13,
          trans1_stat_sw_1_14,
          trans1_stat_sw_1_15,
          trans1_stat_sw_1_16,
          trans1_stat_sw_1_17,
          trans1_stat_sw_1_18,
          trans1_stat_sw_1_19,
          trans1_stat_sw_1_20,
          trans1_stat_sw_1_21,
          trans1_stat_sw_1_22,
          trans1_stat_sw_1_23,
          trans1_stat_sw_1_24,
          trans1_stat_sw_2_0,
          trans1_stat_sw_2_1,
          trans1_stat_sw_2_2,
          trans1_stat_sw_2_3,
          trans1_stat_sw_2_4,
          trans1_stat_sw_2_5,
          trans1_stat_sw_2_6,
          trans1_stat_sw_2_7,
          trans1_stat_sw_2_8
    }
}

MENU Tab_s_measured_values_2_w
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_stat_sw_2_9,
          trans1_stat_sw_2_10,
          trans1_stat_sw_2_11,
          trans1_stat_sw_2_12,
          trans1_stat_sw_2_13,
          trans1_stat_sw_2_14,
          trans1_stat_sw_2_15,
          trans1_stat_sw_2_16,
          trans1_stat_sw_2_17,
          trans1_stat_sw_2_18,
          trans1_stat_sw_2_19,
          trans1_stat_sw_2_20,
          trans1_stat_sw_2_21,
          trans1_stat_sw_2_22,
          trans1_stat_sw_2_23,
          trans1_stat_sw_2_24,
          trans1_stat_sw_3_0,
          trans1_stat_sw_3_1,
          trans1_stat_sw_3_2,
          trans1_stat_sw_3_3,
          trans1_stat_sw_3_4,
          trans1_stat_sw_3_5,
          trans1_stat_sw_3_6,
          trans1_stat_sw_3_7,
          trans1_stat_sw_3_8,
          trans1_stat_sw_3_9,
          trans1_stat_sw_3_10,
          trans1_stat_sw_3_11,
          trans1_stat_sw_3_12,
          trans1_stat_sw_3_13,
          trans1_stat_sw_3_14,
          trans1_stat_sw_3_15,
          trans1_stat_sw_3_16,
          trans1_stat_sw_3_17
    }
}


MENU Tab_s_measured_values_3_w
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_stat_sw_3_18,
          trans1_stat_sw_3_19,
          trans1_stat_sw_3_20,
          trans1_stat_sw_3_21,
          trans1_stat_sw_3_22,
          trans1_stat_sw_3_23,
          trans1_stat_sw_3_24,
          trans1_stat_sw_4_0,
          trans1_stat_sw_4_1,
          trans1_stat_sw_4_2,
          trans1_stat_sw_4_3,
          trans1_stat_sw_4_4,
          trans1_stat_sw_4_5,
          trans1_stat_sw_4_6,
          trans1_stat_sw_4_7,
          trans1_stat_sw_4_8,
          trans1_stat_sw_4_9,
          trans1_stat_sw_4_10,
          trans1_stat_sw_4_11,
          trans1_stat_sw_4_12,
          trans1_stat_sw_4_13,
          trans1_stat_sw_4_14,
          trans1_stat_sw_4_15,
          trans1_stat_sw_4_16,
          trans1_stat_sw_4_17,
          trans1_stat_sw_4_18,
          trans1_stat_sw_4_19,
          trans1_stat_sw_4_20,
          trans1_stat_sw_4_21,
          trans1_stat_sw_4_22,
          trans1_stat_sw_4_23,
          trans1_stat_sw_4_24
    }
}
*/

/* Sprungantwort ************************************************************/
MENU Tab_s_step_response
{
    LABEL    "Step response"  "|de|Sprungantwort" ;

    ITEMS
    {
        trans1_Stepstart,
		trans1_Stepend,
		trans1_Step_Sample_Rate,
/* kmr: fuer ESD: */
/*		trans1_Rampe_Up,
		trans1_Rampe_Down,*/
		trans1_Latency_After_Step,
		trans1_Step_Selection,
       	trans1_Overshoot_Rising,
		trans1_Overshoot_Falling,
		trans1_Dead_Time_Rising,
		trans1_Dead_Time_Falling,
		trans1_Time_63_Rising,
		trans1_Time_63_Falling,
		trans1_Time_98_Rising,
		trans1_Time_98_Falling,
		trans1_Step_Progress,
		trans1_Rise_Time_Falling,
		trans1_Settling_Time_Falling,
		trans1_Rise_Time_Rising,
		trans1_Settling_Time_Rising,
		trans1_Duration_of_test
/* kmr: wird nicht angezeigt:
        Tab_s_measured_values_step*/
    }
}

/* kmr: wird nicht angezeigt:
MENU Tab_s_measured_values_step
{
    LABEL    "Data" "|de|Messwerte" ;

    ITEMS
    {
          Tab_s_sprung_valve_pos_x_step,
          Tab_s_sprung_valve_pos_w_step,
          Tab_s_sprung_valve_pos_y_step,
          Tab_s_sprung_valve_pos_e_step,
          Tab_s_sprung_valve_pos_t_step
    }
}

MENU Tab_s_sprung_valve_pos_x_step
{
    LABEL    "Controlled variable x"  "|de|Regelgre x" ;

    ITEMS
    {
          Tab_s_measured_values_1_x_step,
          Tab_s_measured_values_2_x_step,
          Tab_s_measured_values_3_x_step
    }
}

MENU Tab_s_measured_values_1_x_step
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_sprung_vs_1_0,
          trans1_sprung_vs_1_1,
          trans1_sprung_vs_1_2,
          trans1_sprung_vs_1_3,
          trans1_sprung_vs_1_4,
          trans1_sprung_vs_1_5,
          trans1_sprung_vs_1_6,
          trans1_sprung_vs_1_7,
          trans1_sprung_vs_1_8,
          trans1_sprung_vs_1_9,
          trans1_sprung_vs_1_10,
          trans1_sprung_vs_1_11,
          trans1_sprung_vs_1_12,
          trans1_sprung_vs_1_13,
          trans1_sprung_vs_1_14,
          trans1_sprung_vs_1_15,
          trans1_sprung_vs_1_16,
          trans1_sprung_vs_1_17,
          trans1_sprung_vs_1_18,
          trans1_sprung_vs_1_19,
          trans1_sprung_vs_1_20,
          trans1_sprung_vs_1_21,
          trans1_sprung_vs_1_22,
          trans1_sprung_vs_1_23,
          trans1_sprung_vs_1_24,
          trans1_sprung_vs_2_0,
          trans1_sprung_vs_2_1,
          trans1_sprung_vs_2_2,
          trans1_sprung_vs_2_3,
          trans1_sprung_vs_2_4,
          trans1_sprung_vs_2_5,
          trans1_sprung_vs_2_6,
          trans1_sprung_vs_2_7,
          trans1_sprung_vs_2_8
    }
}

MENU Tab_s_measured_values_2_x_step
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_sprung_vs_2_9,
          trans1_sprung_vs_2_10,
          trans1_sprung_vs_2_11,
          trans1_sprung_vs_2_12,
          trans1_sprung_vs_2_13,
          trans1_sprung_vs_2_14,
          trans1_sprung_vs_2_15,
          trans1_sprung_vs_2_16,
          trans1_sprung_vs_2_17,
          trans1_sprung_vs_2_18,
          trans1_sprung_vs_2_19,
          trans1_sprung_vs_2_20,
          trans1_sprung_vs_2_21,
          trans1_sprung_vs_2_22,
          trans1_sprung_vs_2_23,
          trans1_sprung_vs_2_24,
          trans1_sprung_vs_3_0,
          trans1_sprung_vs_3_1,
          trans1_sprung_vs_3_2,
          trans1_sprung_vs_3_3,
          trans1_sprung_vs_3_4,
          trans1_sprung_vs_3_5,
          trans1_sprung_vs_3_6,
          trans1_sprung_vs_3_7,
          trans1_sprung_vs_3_8,
          trans1_sprung_vs_3_9,
          trans1_sprung_vs_3_10,
          trans1_sprung_vs_3_11,
          trans1_sprung_vs_3_12,
          trans1_sprung_vs_3_13,
          trans1_sprung_vs_3_14,
          trans1_sprung_vs_3_15,
          trans1_sprung_vs_3_16,
          trans1_sprung_vs_3_17
    }
}


MENU Tab_s_measured_values_3_x_step
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_sprung_vs_3_18,
          trans1_sprung_vs_3_19,
          trans1_sprung_vs_3_20,
          trans1_sprung_vs_3_21,
          trans1_sprung_vs_3_22,
          trans1_sprung_vs_3_23,
          trans1_sprung_vs_3_24,
          trans1_sprung_vs_4_0,
          trans1_sprung_vs_4_1,
          trans1_sprung_vs_4_2,
          trans1_sprung_vs_4_3,
          trans1_sprung_vs_4_4,
          trans1_sprung_vs_4_5,
          trans1_sprung_vs_4_6,
          trans1_sprung_vs_4_7,
          trans1_sprung_vs_4_8,
          trans1_sprung_vs_4_9,
          trans1_sprung_vs_4_10,
          trans1_sprung_vs_4_11,
          trans1_sprung_vs_4_12,
          trans1_sprung_vs_4_13,
          trans1_sprung_vs_4_14,
          trans1_sprung_vs_4_15,
          trans1_sprung_vs_4_16,
          trans1_sprung_vs_4_17,
          trans1_sprung_vs_4_18,
          trans1_sprung_vs_4_19,
          trans1_sprung_vs_4_20,
          trans1_sprung_vs_4_21,
          trans1_sprung_vs_4_22,
          trans1_sprung_vs_4_23,
          trans1_sprung_vs_4_24
    }
}

MENU Tab_s_sprung_valve_pos_w_step
{
    LABEL    "Reference variable w" "|de|Sollwert w" ;

    ITEMS
    {
          Tab_s_measured_values_1_w_step,
          Tab_s_measured_values_2_w_step,
          Tab_s_measured_values_3_w_step
    }
}

MENU Tab_s_measured_values_1_w_step
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_sprung_sw_1_0,
          trans1_sprung_sw_1_1,
          trans1_sprung_sw_1_2,
          trans1_sprung_sw_1_3,
          trans1_sprung_sw_1_4,
          trans1_sprung_sw_1_5,
          trans1_sprung_sw_1_6,
          trans1_sprung_sw_1_7,
          trans1_sprung_sw_1_8,
          trans1_sprung_sw_1_9,
          trans1_sprung_sw_1_10,
          trans1_sprung_sw_1_11,
          trans1_sprung_sw_1_12,
          trans1_sprung_sw_1_13,
          trans1_sprung_sw_1_14,
          trans1_sprung_sw_1_15,
          trans1_sprung_sw_1_16,
          trans1_sprung_sw_1_17,
          trans1_sprung_sw_1_18,
          trans1_sprung_sw_1_19,
          trans1_sprung_sw_1_20,
          trans1_sprung_sw_1_21,
          trans1_sprung_sw_1_22,
          trans1_sprung_sw_1_23,
          trans1_sprung_sw_1_24,
          trans1_sprung_sw_2_0,
          trans1_sprung_sw_2_1,
          trans1_sprung_sw_2_2,
          trans1_sprung_sw_2_3,
          trans1_sprung_sw_2_4,
          trans1_sprung_sw_2_5,
          trans1_sprung_sw_2_6,
          trans1_sprung_sw_2_7,
          trans1_sprung_sw_2_8
    }
}

MENU Tab_s_measured_values_2_w_step
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_sprung_sw_2_9,
          trans1_sprung_sw_2_10,
          trans1_sprung_sw_2_11,
          trans1_sprung_sw_2_12,
          trans1_sprung_sw_2_13,
          trans1_sprung_sw_2_14,
          trans1_sprung_sw_2_15,
          trans1_sprung_sw_2_16,
          trans1_sprung_sw_2_17,
          trans1_sprung_sw_2_18,
          trans1_sprung_sw_2_19,
          trans1_sprung_sw_2_20,
          trans1_sprung_sw_2_21,
          trans1_sprung_sw_2_22,
          trans1_sprung_sw_2_23,
          trans1_sprung_sw_2_24,
          trans1_sprung_sw_3_0,
          trans1_sprung_sw_3_1,
          trans1_sprung_sw_3_2,
          trans1_sprung_sw_3_3,
          trans1_sprung_sw_3_4,
          trans1_sprung_sw_3_5,
          trans1_sprung_sw_3_6,
          trans1_sprung_sw_3_7,
          trans1_sprung_sw_3_8,
          trans1_sprung_sw_3_9,
          trans1_sprung_sw_3_10,
          trans1_sprung_sw_3_11,
          trans1_sprung_sw_3_12,
          trans1_sprung_sw_3_13,
          trans1_sprung_sw_3_14,
          trans1_sprung_sw_3_15,
          trans1_sprung_sw_3_16,
          trans1_sprung_sw_3_17
    }
}


MENU Tab_s_measured_values_3_w_step
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_sprung_sw_3_18,
          trans1_sprung_sw_3_19,
          trans1_sprung_sw_3_20,
          trans1_sprung_sw_3_21,
          trans1_sprung_sw_3_22,
          trans1_sprung_sw_3_23,
          trans1_sprung_sw_3_24,
          trans1_sprung_sw_4_0,
          trans1_sprung_sw_4_1,
          trans1_sprung_sw_4_2,
          trans1_sprung_sw_4_3,
          trans1_sprung_sw_4_4,
          trans1_sprung_sw_4_5,
          trans1_sprung_sw_4_6,
          trans1_sprung_sw_4_7,
          trans1_sprung_sw_4_8,
          trans1_sprung_sw_4_9,
          trans1_sprung_sw_4_10,
          trans1_sprung_sw_4_11,
          trans1_sprung_sw_4_12,
          trans1_sprung_sw_4_13,
          trans1_sprung_sw_4_14,
          trans1_sprung_sw_4_15,
          trans1_sprung_sw_4_16,
          trans1_sprung_sw_4_17,
          trans1_sprung_sw_4_18,
          trans1_sprung_sw_4_19,
          trans1_sprung_sw_4_20,
          trans1_sprung_sw_4_21,
          trans1_sprung_sw_4_22,
          trans1_sprung_sw_4_23,
          trans1_sprung_sw_4_24
    }
}

MENU Tab_s_sprung_valve_pos_y_step
{
    LABEL    "Drive signal y" "|de|Stellsignal y" ;

    ITEMS
    {
          Tab_s_measured_values_1_y_step,
          Tab_s_measured_values_2_y_step,
          Tab_s_measured_values_3_y_step
    }
}

MENU Tab_s_measured_values_1_y_step
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_sprung_ss_1_0,
          trans1_sprung_ss_1_1,
          trans1_sprung_ss_1_2,
          trans1_sprung_ss_1_3,
          trans1_sprung_ss_1_4,
          trans1_sprung_ss_1_5,
          trans1_sprung_ss_1_6,
          trans1_sprung_ss_1_7,
          trans1_sprung_ss_1_8,
          trans1_sprung_ss_1_9,
          trans1_sprung_ss_1_10,
          trans1_sprung_ss_1_11,
          trans1_sprung_ss_1_12,
          trans1_sprung_ss_1_13,
          trans1_sprung_ss_1_14,
          trans1_sprung_ss_1_15,
          trans1_sprung_ss_1_16,
          trans1_sprung_ss_1_17,
          trans1_sprung_ss_1_18,
          trans1_sprung_ss_1_19,
          trans1_sprung_ss_1_20,
          trans1_sprung_ss_1_21,
          trans1_sprung_ss_1_22,
          trans1_sprung_ss_1_23,
          trans1_sprung_ss_1_24,
          trans1_sprung_ss_1_25,
          trans1_sprung_ss_1_26,
          trans1_sprung_ss_1_27,
          trans1_sprung_ss_1_28,
          trans1_sprung_ss_1_29,
          trans1_sprung_ss_1_30,
          trans1_sprung_ss_1_31,
          trans1_sprung_ss_1_32,
          trans1_sprung_ss_1_33
    }
}

MENU Tab_s_measured_values_2_y_step
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_sprung_ss_1_34,
          trans1_sprung_ss_1_35,
          trans1_sprung_ss_1_36,
          trans1_sprung_ss_1_37,
          trans1_sprung_ss_1_38,
          trans1_sprung_ss_1_39,
          trans1_sprung_ss_1_40,
          trans1_sprung_ss_1_41,
          trans1_sprung_ss_1_42,
          trans1_sprung_ss_1_43,
          trans1_sprung_ss_1_44,
          trans1_sprung_ss_1_45,
          trans1_sprung_ss_1_46,
          trans1_sprung_ss_1_47,
          trans1_sprung_ss_1_48,
          trans1_sprung_ss_1_49,
          trans1_sprung_ss_2_0,
          trans1_sprung_ss_2_1,
          trans1_sprung_ss_2_2,
          trans1_sprung_ss_2_3,
          trans1_sprung_ss_2_4,
          trans1_sprung_ss_2_5,
          trans1_sprung_ss_2_6,
          trans1_sprung_ss_2_7,
          trans1_sprung_ss_2_8,
          trans1_sprung_ss_2_9,
          trans1_sprung_ss_2_10,
          trans1_sprung_ss_2_11,
          trans1_sprung_ss_2_12,
          trans1_sprung_ss_2_13,
          trans1_sprung_ss_2_14,
          trans1_sprung_ss_2_15,
          trans1_sprung_ss_2_16,
          trans1_sprung_ss_2_17
    }
}


MENU Tab_s_measured_values_3_y_step
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_sprung_ss_2_18,
          trans1_sprung_ss_2_19,
          trans1_sprung_ss_2_20,
          trans1_sprung_ss_2_21,
          trans1_sprung_ss_2_22,
          trans1_sprung_ss_2_23,
          trans1_sprung_ss_2_24,
          trans1_sprung_ss_2_25,
          trans1_sprung_ss_2_26,
          trans1_sprung_ss_2_27,
          trans1_sprung_ss_2_28,
          trans1_sprung_ss_2_29,
          trans1_sprung_ss_2_30,
          trans1_sprung_ss_2_31,
          trans1_sprung_ss_2_32,
          trans1_sprung_ss_2_33,
          trans1_sprung_ss_2_34,
          trans1_sprung_ss_2_35,
          trans1_sprung_ss_2_36,
          trans1_sprung_ss_2_37,
          trans1_sprung_ss_2_38,
          trans1_sprung_ss_2_39,
          trans1_sprung_ss_2_40,
          trans1_sprung_ss_2_41,
          trans1_sprung_ss_2_42,
          trans1_sprung_ss_2_43,
          trans1_sprung_ss_2_44,
          trans1_sprung_ss_2_45,
          trans1_sprung_ss_2_46,
          trans1_sprung_ss_2_47,
          trans1_sprung_ss_2_48,
          trans1_sprung_ss_2_49
    }
}

MENU Tab_s_sprung_valve_pos_e_step
{
    LABEL    "Setpoint deviation e" "|de|Regelabweichung e" ;

    ITEMS
    {
          Tab_s_measured_values_1_e_step,
          Tab_s_measured_values_2_e_step,
          Tab_s_measured_values_3_e_step
    }
}

MENU Tab_s_measured_values_1_e_step
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_sprung_e_1_0,
          trans1_sprung_e_1_1,
          trans1_sprung_e_1_2,
          trans1_sprung_e_1_3,
          trans1_sprung_e_1_4,
          trans1_sprung_e_1_5,
          trans1_sprung_e_1_6,
          trans1_sprung_e_1_7,
          trans1_sprung_e_1_8,
          trans1_sprung_e_1_9,
          trans1_sprung_e_1_10,
          trans1_sprung_e_1_11,
          trans1_sprung_e_1_12,
          trans1_sprung_e_1_13,
          trans1_sprung_e_1_14,
          trans1_sprung_e_1_15,
          trans1_sprung_e_1_16,
          trans1_sprung_e_1_17,
          trans1_sprung_e_1_18,
          trans1_sprung_e_1_19,
          trans1_sprung_e_1_20,
          trans1_sprung_e_1_21,
          trans1_sprung_e_1_22,
          trans1_sprung_e_1_23,
          trans1_sprung_e_1_24,
          trans1_sprung_e_2_0,
          trans1_sprung_e_2_1,
          trans1_sprung_e_2_2,
          trans1_sprung_e_2_3,
          trans1_sprung_e_2_4,
          trans1_sprung_e_2_5,
          trans1_sprung_e_2_6,
          trans1_sprung_e_2_7,
          trans1_sprung_e_2_8
    }
}

MENU Tab_s_measured_values_2_e_step
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_sprung_e_2_9,
          trans1_sprung_e_2_10,
          trans1_sprung_e_2_11,
          trans1_sprung_e_2_12,
          trans1_sprung_e_2_13,
          trans1_sprung_e_2_14,
          trans1_sprung_e_2_15,
          trans1_sprung_e_2_16,
          trans1_sprung_e_2_17,
          trans1_sprung_e_2_18,
          trans1_sprung_e_2_19,
          trans1_sprung_e_2_20,
          trans1_sprung_e_2_21,
          trans1_sprung_e_2_22,
          trans1_sprung_e_2_23,
          trans1_sprung_e_2_24,
          trans1_sprung_e_3_0,
          trans1_sprung_e_3_1,
          trans1_sprung_e_3_2,
          trans1_sprung_e_3_3,
          trans1_sprung_e_3_4,
          trans1_sprung_e_3_5,
          trans1_sprung_e_3_6,
          trans1_sprung_e_3_7,
          trans1_sprung_e_3_8,
          trans1_sprung_e_3_9,
          trans1_sprung_e_3_10,
          trans1_sprung_e_3_11,
          trans1_sprung_e_3_12,
          trans1_sprung_e_3_13,
          trans1_sprung_e_3_14,
          trans1_sprung_e_3_15,
          trans1_sprung_e_3_16,
          trans1_sprung_e_3_17
    }
}


MENU Tab_s_measured_values_3_e_step
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_sprung_e_3_18,
          trans1_sprung_e_3_19,
          trans1_sprung_e_3_20,
          trans1_sprung_e_3_21,
          trans1_sprung_e_3_22,
          trans1_sprung_e_3_23,
          trans1_sprung_e_3_24,
          trans1_sprung_e_4_0,
          trans1_sprung_e_4_1,
          trans1_sprung_e_4_2,
          trans1_sprung_e_4_3,
          trans1_sprung_e_4_4,
          trans1_sprung_e_4_5,
          trans1_sprung_e_4_6,
          trans1_sprung_e_4_7,
          trans1_sprung_e_4_8,
          trans1_sprung_e_4_9,
          trans1_sprung_e_4_10,
          trans1_sprung_e_4_11,
          trans1_sprung_e_4_12,
          trans1_sprung_e_4_13,
          trans1_sprung_e_4_14,
          trans1_sprung_e_4_15,
          trans1_sprung_e_4_16,
          trans1_sprung_e_4_17,
          trans1_sprung_e_4_18,
          trans1_sprung_e_4_19,
          trans1_sprung_e_4_20,
          trans1_sprung_e_4_21,
          trans1_sprung_e_4_22,
          trans1_sprung_e_4_23,
          trans1_sprung_e_4_24
    }
}

MENU Tab_s_sprung_valve_pos_t_step
{
    LABEL    "Time data t" "|de|Zeitmesswerte t" ;

    ITEMS
    {
          Tab_s_measured_values_1_t_step,
          Tab_s_measured_values_2_t_step,
          Tab_s_measured_values_3_t_step
    }
}

MENU Tab_s_measured_values_1_t_step
{
    LABEL     "|de|Messpunkt 1 - 34" ;

    ITEMS
    {
          trans1_sprung_t_1_0,
          trans1_sprung_t_1_1,
          trans1_sprung_t_1_2,
          trans1_sprung_t_1_3,
          trans1_sprung_t_1_4,
          trans1_sprung_t_1_5,
          trans1_sprung_t_1_6,
          trans1_sprung_t_1_7,
          trans1_sprung_t_1_8,
          trans1_sprung_t_1_9,
          trans1_sprung_t_1_10,
          trans1_sprung_t_1_11,
          trans1_sprung_t_1_12,
          trans1_sprung_t_1_13,
          trans1_sprung_t_1_14,
          trans1_sprung_t_1_15,
          trans1_sprung_t_1_16,
          trans1_sprung_t_1_17,
          trans1_sprung_t_1_18,
          trans1_sprung_t_1_19,
          trans1_sprung_t_1_20,
          trans1_sprung_t_1_21,
          trans1_sprung_t_1_22,
          trans1_sprung_t_1_23,
          trans1_sprung_t_1_24,
          trans1_sprung_t_2_0,
          trans1_sprung_t_2_1,
          trans1_sprung_t_2_2,
          trans1_sprung_t_2_3,
          trans1_sprung_t_2_4,
          trans1_sprung_t_2_5,
          trans1_sprung_t_2_6,
          trans1_sprung_t_2_7,
          trans1_sprung_t_2_8
    }
}

MENU Tab_s_measured_values_2_t_step
{
    LABEL     "|de|Messpunkt 35 - 68" ;

    ITEMS
    {
          trans1_sprung_t_2_9,
          trans1_sprung_t_2_10,
          trans1_sprung_t_2_11,
          trans1_sprung_t_2_12,
          trans1_sprung_t_2_13,
          trans1_sprung_t_2_14,
          trans1_sprung_t_2_15,
          trans1_sprung_t_2_16,
          trans1_sprung_t_2_17,
          trans1_sprung_t_2_18,
          trans1_sprung_t_2_19,
          trans1_sprung_t_2_20,
          trans1_sprung_t_2_21,
          trans1_sprung_t_2_22,
          trans1_sprung_t_2_23,
          trans1_sprung_t_2_24,
          trans1_sprung_t_3_0,
          trans1_sprung_t_3_1,
          trans1_sprung_t_3_2,
          trans1_sprung_t_3_3,
          trans1_sprung_t_3_4,
          trans1_sprung_t_3_5,
          trans1_sprung_t_3_6,
          trans1_sprung_t_3_7,
          trans1_sprung_t_3_8,
          trans1_sprung_t_3_9,
          trans1_sprung_t_3_10,
          trans1_sprung_t_3_11,
          trans1_sprung_t_3_12,
          trans1_sprung_t_3_13,
          trans1_sprung_t_3_14,
          trans1_sprung_t_3_15,
          trans1_sprung_t_3_16,
          trans1_sprung_t_3_17
    }
}


MENU Tab_s_measured_values_3_t_step
{
    LABEL     "|de|Messpunkt 69 - 100" ;

    ITEMS
    {
          trans1_sprung_t_3_18,
          trans1_sprung_t_3_19,
          trans1_sprung_t_3_20,
          trans1_sprung_t_3_21,
          trans1_sprung_t_3_22,
          trans1_sprung_t_3_23,
          trans1_sprung_t_3_24,
          trans1_sprung_t_4_0,
          trans1_sprung_t_4_1,
          trans1_sprung_t_4_2,
          trans1_sprung_t_4_3,
          trans1_sprung_t_4_4,
          trans1_sprung_t_4_5,
          trans1_sprung_t_4_6,
          trans1_sprung_t_4_7,
          trans1_sprung_t_4_8,
          trans1_sprung_t_4_9,
          trans1_sprung_t_4_10,
          trans1_sprung_t_4_11,
          trans1_sprung_t_4_12,
          trans1_sprung_t_4_13,
          trans1_sprung_t_4_14,
          trans1_sprung_t_4_15,
          trans1_sprung_t_4_16,
          trans1_sprung_t_4_17,
          trans1_sprung_t_4_18,
          trans1_sprung_t_4_19,
          trans1_sprung_t_4_20,
          trans1_sprung_t_4_21,
          trans1_sprung_t_4_22,
          trans1_sprung_t_4_23,
          trans1_sprung_t_4_24
    }
}
*/

MENU Tab_s_enhanced_diag
{
  	LABEL	"Extended" "|de|Erweitert";

  	ITEMS
  	{
		phys_diag_ext_1_4,
		phys_diag_ext_2_0,
		phys_diag_ext_2_1,
		phys_diag_ext_2_2
   	}
    VALIDITY_ONLY_EXPERT_PLUS
}



/*******************************************************************************/
/*     Table: Maintenance (Parametertabelle fr Instandhalterebene)            */
/*******************************************************************************/
MENU Table_Main_Maintenance
{
    LABEL   "SAMSON 373X-4 (PA-Profil 3.01)"
            "|de|SAMSON 373X-4 (PA-Profil 3.01)";
    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
        DD_REVISION_TEXT, /* DD Versionsnummer */
#else
        local_dd_version, /* DD Versionsnummer */
#endif
        Tab_m_ident,		/* Identifikation */
        Tab_m_pb,		  	/* Physical Block */
        Tab_m_positioner,	/* AO TRD */
        Tab_m_di1,			/* Binreingang 1 */
        Tab_m_di2,			/* Binreingang 2 */
        Tab_m_diagnosis		/* Diagnose */
    }
}


/* Identifikation ************************************************************/
MENU Tab_m_ident
{
    LABEL       [menu_ident];

    ITEMS
    {
        Tab_m_ident_opunit,
        Tab_m_ident_device,
        Tab_m_ident_di1,
        Tab_m_ident_di2
    }
}


/* Identifikation ******************************************/
MENU Tab_m_ident_opunit
{
    LABEL       "Operation unit (PB)" "|de|Betriebseinheit (PB)";
    ITEMS
    {
        phys_tag_desc,
        phys_st_rev,
        phys_strategy,
        phys_descriptor,
        phys_device_message,
        phys_device_certification,
        phys_production_id,
        phys_ident_number_selector,
        trans1_add_u8_1,
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3,
        phys_text_input_4,
        phys_text_input_5,
        phys_alert_key
    }
}

/* Physical Block  ************************************************************/
MENU Tab_m_pb
{
    LABEL   "Operation unit (PB)" "|de|Betriebseinheit (PB)";
    ITEMS
    {
        phys_local_operation_enable,
        phys_feature_supported,
        phys_feature_enabled,
        phys_cond_status_diag,
        phys_feature_select,
        phys_reading_direction
    }
}


/* Identifikation - Stellungsregler ****************************************************/
MENU Tab_m_ident_device
{
    LABEL       "Positioner (AO, TRD)" "|de|Stellungsregler (AO, TRD)";
    ITEMS
    {
        func1_tag_desc,
        trans1_tag_desc,
        func1_st_rev,
        trans1_st_rev,
        func1_strategy,
        trans1_strategy,
        func1_alert_key,
        trans1_alert_key,
#ifdef _V602_
        phys_device_man_id,
#endif
        phys_device_id,
        phys_serial_num,
        phys_device_product_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_device_instal_date,
        phys_ident_number_selector,
				trans1_add_u8_1,
        Tab_m_ident_device_actuator,
        Tab_m_ident_device_valve,
        Tab_m_ident_device_gear,
        Tab_m_ident_device_batch
    }
}


/* Identifikation - Gert - Antrieb *************************************/
MENU Tab_m_ident_device_actuator
{
    LABEL       "Actuator" "|de|Antrieb";
    ITEMS
    {
        trans1_actuator_man,
        trans1_actuator_type,
        trans1_actuator_serial_number,
        trans1_supply_pressure,
        trans1_actuator_version,
        trans1_pressure_range_start,
        trans1_pressure_range_end,
        trans1_manufac_actuator_size,
        trans1_actuator_size,
        trans1_attachment,
        trans1_booster
    }
}

/* Identifikation - Gert - Ventil ***************************************/
MENU Tab_m_ident_device_valve
{
    LABEL       "Valve" "|de|Ventil";
    ITEMS
    {
        trans1_valve_man,
        trans1_valve_serial_number,
        trans1_valve_type,
        trans1_rated_travel          (READ_ONLY),
        trans1_stuffing_box,
        trans1_cycle_counter_limit, 
        trans1_sealing_edge,
        trans1_pressure_balancing,
        trans1_flow_characteristic,
        trans1_flow_direction,
        trans1_nom_diameter,
        trans1_nom_diameter_dn,
        trans1_kvs_value,
        trans1_kvs_unit,
        trans1_seat_diam_valve
    }
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_m_ident_device_gear
{
    LABEL       "Additional component" "|de|Zusatzkomponente";
    ITEMS
    {
        phys_ident_options,
        phys_ident_limit_switches,
        trans1_additional_gear_install_date,
        trans1_additional_gear_id,
        trans1_additional_gear_man,
        trans1_additional_gear_ser_number,
        phys_hw_write_protection,
        phys_write_locking     (READ_ONLY)
    }
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_m_ident_device_batch
{
    LABEL       "Batch-information" "|de|Batch-Information";
    ITEMS
    {
      func1_batch_id,
      func1_batch_unit,
      func1_batch_operation,
      func1_batch_phase
    }
}



MENU Tab_m_ident_di1
{
    LABEL   "Binary input 1 (DI1)" "|de|Binreingang 1 (DI1)";
    ITEMS
    {
       Tab_m_Trd_DI1,
       Tab_m_FB_DI1,
       Tab_m_sensor_di1,
       Tab_m_sensor_di1_batch
    }
}

/* Identifikation - Trd DI1 ****************************************************/
MENU Tab_m_Trd_DI1
{
    LABEL 	"Identification TRD" "|de|Identifikation TRD";
    ITEMS
    {
       trans2_tag_desc,
       trans2_st_rev,
       trans2_strategy,
       trans2_alert_key
    }
}

/* Identifikation - FB DI1 ****************************************************/
MENU Tab_m_FB_DI1
{
    LABEL 	"Identification FB" "|de|Identifikation FB";
    ITEMS
    {
       func2_DI_tag_desc,
       func2_DI_st_rev,
       func2_DI_strategy,
       func2_DI_alert_key
    }
}

/* Identifikation - DI1 ****************************************************/
MENU Tab_m_sensor_di1
{
    LABEL 	"Identification DI1"	"|de|Identifikation DI1";
    ITEMS
    {
      trans2_sensor_id,
      trans2_sensor_ser_num,
      trans2_sensor_man
    }
}

/* Identifikation - Batch-Information ******************************************/
MENU Tab_m_sensor_di1_batch
{
    LABEL 	"Batch-information"	"|de|Batch-Information";
    ITEMS
    {
      func2_DI_batch_id,
      func2_DI_batch_unit,
      func2_DI_batch_operation,
      func2_DI_batch_phase
    }
}




MENU Tab_m_ident_di2
{
    LABEL   "Binary input 2 (DI2)" "|de|Binreingang 2 (DI2)";
    ITEMS
    {
       Tab_m_Trd_DI2,
       Tab_m_FB_DI2,
       Tab_m_sensor_di2,
       Tab_m_sensor_di2_batch
    }
}

/* Identifikation - Trd DI2 ****************************************************/
MENU Tab_m_Trd_DI2
{
    LABEL 	"Identification TRD" "|de|Identifikation TRD";
    ITEMS
    {
       trans3_tag_desc,
       trans3_st_rev,
       trans3_strategy,
       trans3_alert_key
    }
}

/* Identifikation - FB DI2 ****************************************************/
MENU Tab_m_FB_DI2
{
    LABEL 	"Identification FB" "|de|Identifikation FB";
    ITEMS
    {
       func3_DI_tag_desc,
       func3_DI_st_rev,
       func3_DI_strategy,
       func3_DI_alert_key
    }
}

/* Identifikation - DI2 ****************************************************/
MENU Tab_m_sensor_di2
{
    LABEL 	"Identification DI2"	"|de|Identifikation DI2";
    ITEMS
    {
      trans3_sensor_id,
      trans3_sensor_ser_num,
      trans3_sensor_man
    }
}

/* Identifikation - Batch-Information ******************************************/
MENU Tab_m_sensor_di2_batch
{
    LABEL 	"Batch-information"	"|de|Batch-Information";
    ITEMS
    {
      func3_DI_batch_id,
      func3_DI_batch_unit,
      func3_DI_batch_operation,
      func3_DI_batch_phase
    }
}





/* Stellungsregler (AO, TRD) *******************************/

MENU Tab_m_positioner
{
    LABEL	"Positioner (AO, TRD)" "|de|Stellungsregler (AO, TRD)";
    ITEMS
    {
        func1_in_channel,
        func1_out_channel,
        trans1_transducer_state,
        Tab_m_input_range,							/* Fuehrungsgroee */
        Tab_m_workrange,							/* Arbeitsbereich */
        Tab_m_characteristic,						/* Kennlinie */
        Tab_m_charact,								/* Kennwerte */
        Tab_m_charact_powerloss,     				/* Ausfallverhalten */
        Tab_m_error_control,    					/* Fehlerueberwachung */
        Tab_m_adjustment,							/* Inbetriebnahme */
        Tab_m_interface_simulate					/* Simulation */

    }
}



/* Stellungsregler (AO, TRD) - Arbeitsbereich *******************************/

MENU Tab_m_workrange
{
	LABEL		"Working range"
	            "|de|Arbeitsbereich";
    ITEMS
    {
        trans1_final_value_range_start,
        trans1_final_value_range_end,
        trans1_final_value_range_units,
        func1_pos_d_limit_low,
        func1_pos_d_limit_high,
        trans1_travel_lower_limit_on,
        trans1_travel_limit_lower_value,
        trans1_travel_upper_limit_on,
        trans1_travel_limit_upper_value,
        func1_out_lower_range_value,
        func1_out_upper_range_value,
        func1_out_unit
    }
}



/* Stellungsregler (AO, TRD) -  Eingangsgrsse ***************************************************/
MENU Tab_m_input_range
{
	LABEL		"Reference variable"
	            "|de|Fhrungsgre";
    ITEMS
    {
        trans1_moving_direction,
        func1_pv_lower_range_value,
        func1_pv_upper_range_value,
        func1_pv_unit,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc,
        trans1_final_value_cutoff_lo_on,
        trans1_setp_cutoff_dec,
        trans1_final_value_cutoff_hi_on,
        trans1_setp_cutoff_inc
    }
}

/* Stellungsregler (AO, TRD) -  Kennlinie ***************************************************/
MENU Tab_m_characteristic
{
	LABEL		"Characteristic"
	            "|de|Kennlinie";
    ITEMS
    {
        trans1_lin_type,
        trans1_charact_type,
        trans1_X0,
        trans1_X1,
        trans1_X2,
        trans1_X3,
        trans1_X4,
        trans1_X5,
        trans1_X6,
        trans1_X7,
        trans1_X8,
        trans1_X9,
        trans1_X10,
        trans1_Y0,
        trans1_Y1,
        trans1_Y2,
        trans1_Y3,
        trans1_Y4,
        trans1_Y5,
        trans1_Y6,
        trans1_Y7,
        trans1_Y8,
        trans1_Y9,
        trans1_Y10
    }
}


/* Kennwerte - ***************************************************************/
MENU Tab_m_charact
{
	LABEL		"Performance characteristics"
	            "|de|Kennwerte";
    ITEMS
    {
        trans1_servo_gain_1,
        trans1_servo_rate_1
    }
}


/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_m_charact_powerloss
{
	LABEL		"Fail-safe action"
	            "|de|Ausfallverhalten";
    ITEMS
    {
        trans1_actuator_action,
        func1_fsafe_type,
        func1_fsafe_time,
        func1_fsafe_value
    }
}


/* Fehlerueberwachung **********************************************/
MENU Tab_m_error_control
{
    LABEL       "Error control"	"|de|Fehlerberwachung";
    ITEMS
    {
        trans1_tolerance_band,
        trans1_delay_time,
        trans1_total_valve_travel,
        trans1_total_valve_travel_limit,
        trans1_zero_point_limit
    }
}


/* Kennwerte - Fehlerberwachung *********************************************/
MENU Tab_m_error_classification
{
    LABEL       "Classification report" "|de|Statusklassifikation";
    ITEMS
    {
        phys_cond_status_diag,
        Tab_m_operator_error,
        Tab_m_init_error,
        Tab_m_hardware_error,
        Tab_m_data_error,
        Tab_m_error_temperature,
        Tab_m_error_enhanced
    }
}


MENU Tab_m_operator_error
{
    LABEL       "Operation error"
                "|de|Betriebsfehler";
    ITEMS
    {
		/* Betriebsfehler */
        /* string_ascii_status, */
/*        phys_diag_event_switch__Diag_Status_Link_1_0_S,	*//* Gert nicht init. */
        phys_diag_event_switch__Diag_Status_Link_1_1_S, /* Magnetventil aktiv */
        phys_diag_event_switch__Diag_Status_Link_1_2_S, /* Wegintegral berschritten */
        phys_diag_event_switch__Diag_Status_Link_1_3_S, /* Regelkreisfehler */
        phys_diag_event_switch__Diag_Status_Link_1_4_S, /* Nullpunktfehler */
        phys_diag_event_switch__Diag_Status_Link_1_5_S  /* Autokorrektur */
/*        phys_diag_event_switch__Diag_Status_Link_1_6_S, *//* Fataler Fehler */
/*        phys_diag_event_switch__Diag_Status_Link_1_7_S, *//* Erweiterte Diagnose */
        transmit_button,
        SEPARATOR,
        /* string_ascii_diagnosis, */
/*        phys_diag_event_switch__Diag_Status_Link_1_0_D, *//* Gert nicht init. */
        phys_diag_event_switch__Diag_Status_Link_1_1_D, /* Magnetventil aktiv */
        phys_diag_event_switch__Diag_Status_Link_1_2_D, /* Wegintegral berschritten */
        phys_diag_event_switch__Diag_Status_Link_1_3_D, /* Regelkreisfehler */
        phys_diag_event_switch__Diag_Status_Link_1_4_D, /* Nullpunktfehler */
        phys_diag_event_switch__Diag_Status_Link_1_5_D  /* Autokorrektur */
/*        phys_diag_event_switch__Diag_Status_Link_1_6_D, *//* Fataler Fehler */
/*        phys_diag_event_switch__Diag_Status_Link_1_7_D *//* Erweiterte Diagnose */

    }
}

MENU Tab_m_init_error
{
    LABEL       "Initialization error"
                "|de|Initialisierungsfehler";
    ITEMS
    {
        /* Initialisierungsfehler*/
        /* string_ascii_status, */
        phys_diag_event_switch__Diag_Status_Link_1_8_S,
        phys_diag_event_switch__Diag_Status_Link_1_9_S,
        phys_diag_event_switch__Diag_Status_Link_1_10_S,
        phys_diag_event_switch__Diag_Status_Link_1_11_S,
        phys_diag_event_switch__Diag_Status_Link_1_12_S,
        phys_diag_event_switch__Diag_Status_Link_1_13_S,
        phys_diag_event_switch__Diag_Status_Link_1_14_S,
        phys_diag_event_switch__Diag_Status_Link_1_15_S,
        transmit_button,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        phys_diag_event_switch__Diag_Status_Link_1_8_D,
        phys_diag_event_switch__Diag_Status_Link_1_9_D,
        phys_diag_event_switch__Diag_Status_Link_1_10_D,
        phys_diag_event_switch__Diag_Status_Link_1_11_D,
        phys_diag_event_switch__Diag_Status_Link_1_12_D,
        phys_diag_event_switch__Diag_Status_Link_1_13_D,
        phys_diag_event_switch__Diag_Status_Link_1_14_D,
        phys_diag_event_switch__Diag_Status_Link_1_15_D
    }
}

MENU Tab_m_hardware_error
{
    LABEL       "Hardware error"
                "|de|Hardwarefehler";
    ITEMS
    {
 				/* Hardware */
        /* string_ascii_status, */
        phys_diag_event_switch__Diag_Status_Link_1_16_S,
/*        phys_diag_event_switch__Diag_Status_Link_1_17_S,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_18_S,*/
        transmit_button,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        phys_diag_event_switch__Diag_Status_Link_1_16_D
/*        phys_diag_event_switch__Diag_Status_Link_1_17_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_18_D*/
    }
}

MENU Tab_m_data_error
{
    LABEL       "Data error"
                "|de|Datenfehler";
    ITEMS
    {
 				/* Datenfehler */
        /* string_ascii_status, */
        phys_diag_event_switch__Diag_Status_Link_1_19_S,
        phys_diag_event_switch__Diag_Status_Link_1_20_S,
        phys_diag_event_switch__Diag_Status_Link_1_21_S,
        phys_diag_event_switch__Diag_Status_Link_1_22_S,
        phys_diag_event_switch__Diag_Status_Link_1_23_S,
        phys_diag_event_switch__Diag_Status_Link_1_24_S,
/*        phys_diag_event_switch__Diag_Status_Link_1_25_S,*/
        phys_diag_event_switch__Diag_Status_Link_1_26_S,
        phys_diag_event_switch__Diag_Status_Link_1_27_S,
/*        phys_diag_event_switch__Diag_Status_Link_1_28_S,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_29_S,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_41_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_S,
/*        phys_diag_event_switch__Diag_Status_Link_1_30_S,
        phys_diag_event_switch__Diag_Status_Link_1_31_S,
        phys_diag_event_switch__Diag_Status_Link_1_32_S,
        phys_diag_event_switch__Diag_Status_Link_1_33_S,*/
        transmit_button,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        phys_diag_event_switch__Diag_Status_Link_1_19_D,
        phys_diag_event_switch__Diag_Status_Link_1_20_D,
        phys_diag_event_switch__Diag_Status_Link_1_21_D,
        phys_diag_event_switch__Diag_Status_Link_1_22_D,
        phys_diag_event_switch__Diag_Status_Link_1_23_D,
        phys_diag_event_switch__Diag_Status_Link_1_24_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_25_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_26_D,
        phys_diag_event_switch__Diag_Status_Link_1_27_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_28_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_29_D,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_41_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_D
/*        phys_diag_event_switch__Diag_Status_Link_1_30_D,
        phys_diag_event_switch__Diag_Status_Link_1_31_D,
        phys_diag_event_switch__Diag_Status_Link_1_32_D,
        phys_diag_event_switch__Diag_Status_Link_1_33_D*/
    }
}

MENU Tab_m_error_enhanced
{
    LABEL       "Extended" "|de|Erweitert";
    ITEMS
    {
			phys_diag_event_switch_2__Diag_Status_Link_2_37_S, /* Code 81 */
            phys_diag_event_switch_2__Diag_Status_Link_2_37_D,

			Tab_m_error_enhanced_air_supply,
			Tab_m_error_enhanced_shifting_working_range,
            Tab_m_error_enhanced_leakage_pneumatic,
            Tab_m_error_enhanced_limit_working_range,
            Tab_m_error_enhanced_obs_end_pos,
            Tab_m_error_enhanced_connection_pos_valve,
            Tab_m_error_enhanced_working_range,
			Tab_m_error_enhanced_friction,
			Tab_m_error_enhanced_actuator_spring,
            Tab_m_error_enhanced_inner_leakage,
            Tab_m_error_enhanced_external_leakage
       /*     Tab_m_error_enhanced_dynamic_stress_factor,*/
/* kmr: noch kein ESD:
            Tab_m_error_enhanced_esd*/
    }
    VALIDITY_ONLY_EXPERT_PLUS
}

MENU Tab_m_error_enhanced_air_supply
{
    LABEL       "Air supply"
                "|de|Zuluftdruck";
    ITEMS
    {
		/* Air supply */
		/* string_ascii_status, */
		phys_diag_event_switch__Diag_Status_Link_1_34_S,
        phys_diag_event_switch__Diag_Status_Link_1_35_S,
        phys_diag_event_switch__Diag_Status_Link_1_36_S,
        phys_diag_event_switch__Diag_Status_Link_1_37_S,
        phys_diag_event_switch__Diag_Status_Link_1_38_S,
        phys_diag_event_switch__Diag_Status_Link_1_39_S,
        transmit_button,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        phys_diag_event_switch__Diag_Status_Link_1_34_D,
        phys_diag_event_switch__Diag_Status_Link_1_35_D,
        phys_diag_event_switch__Diag_Status_Link_1_36_D,
        phys_diag_event_switch__Diag_Status_Link_1_37_D,
        phys_diag_event_switch__Diag_Status_Link_1_38_D,
        phys_diag_event_switch__Diag_Status_Link_1_39_D
     }
}

MENU Tab_m_error_enhanced_actuator_spring
{
    LABEL       "Actuator spring"
                "|de|Antriebsfedern";
    ITEMS
    {
		/* string_ascii_status, */
		phys_diag_event_switch__Diag_Status_Link_1_40_S,
        phys_diag_event_switch__Diag_Status_Link_1_41_S,
        phys_diag_event_switch__Diag_Status_Link_1_42_S,
        phys_diag_event_switch__Diag_Status_Link_1_43_S,
        phys_diag_event_switch__Diag_Status_Link_1_44_S,
        transmit_button,
        SEPARATOR,
        /* string_ascii_diagnosis, */
        phys_diag_event_switch__Diag_Status_Link_1_40_D,
        phys_diag_event_switch__Diag_Status_Link_1_41_D,
        phys_diag_event_switch__Diag_Status_Link_1_42_D,
        phys_diag_event_switch__Diag_Status_Link_1_43_D,
        phys_diag_event_switch__Diag_Status_Link_1_44_D
     }
}

MENU Tab_m_error_enhanced_shifting_working_range
{
    LABEL       "Shifting working range"
                "|de|Trend Stellbereich";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch__Diag_Status_Link_1_45_S,
		phys_diag_event_switch__Diag_Status_Link_1_46_S,
		transmit_button,
		SEPARATOR,
		/*string_ascii_diagnosis,*/
		phys_diag_event_switch__Diag_Status_Link_1_45_D,
		phys_diag_event_switch__Diag_Status_Link_1_46_D
    }
}


MENU Tab_m_error_enhanced_friction
{
    LABEL       "Friction"
                "|de|Reibung";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch__Diag_Status_Link_1_47_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_0_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_1_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_2_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_3_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_4_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_5_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_6_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch__Diag_Status_Link_1_47_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_0_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_1_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_2_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_3_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_4_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_5_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_6_D
    }
}


MENU Tab_m_error_enhanced_leakage_pneumatic
{
    LABEL       "Leakage pneumatic"
                "|de|Leckage Pneumatik";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_7_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_8_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_9_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_10_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_7_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_8_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_9_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_10_D
    }
}


MENU Tab_m_error_enhanced_limit_working_range
{
    LABEL       "Limit working range"
                "|de|Beschrnkung Stellbereich";
    ITEMS
    {
        /*string_ascii_status,*/
    	phys_diag_event_switch_2__Diag_Status_Link_2_11_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_12_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_13_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_11_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_12_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_13_D
    }
}

MENU Tab_m_error_enhanced_dynamic_stress_factor
{
    LABEL       "Dynamic stress factor"
                "|de|Dynamischer Belastungsfaktor";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_14_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_14_D
		}
}

MENU Tab_m_error_enhanced_inner_leakage
{
    LABEL       "Inner leakage"
                "|de|Innere Leckage";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_15_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_16_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_17_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_15_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_16_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_17_D
	}
}


MENU Tab_m_error_enhanced_external_leakage
{
    LABEL       "External leakage"
                "|de|Externe Leckage";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_18_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_19_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_20_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_18_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_19_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_20_D
    }
}



MENU Tab_m_error_enhanced_obs_end_pos
{
    LABEL       "Observing end position"
                "|de|Trend Endlage";
    ITEMS
    {
		/*string_ascii_status,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_21_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_22_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_23_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_24_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_25_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_26_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_21_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_22_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_23_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_24_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_25_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_26_D
    }
}


MENU Tab_m_error_enhanced_connection_pos_valve
{
    LABEL       "Connection positioner - valve"
                "|de|Mech. Verbindung SR / Ventil";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_27_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_28_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_29_S,
/* entfllt vorerst
        phys_diag_event_switch_2__Diag_Status_Link_2_30_S,
*/
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_27_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_28_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_29_D
/* entfllt vorerst
        phys_diag_event_switch_2__Diag_Status_Link_2_30_D
*/
	}
}



MENU Tab_m_error_enhanced_working_range
{
    LABEL       "Working range" "|de|Stellbereich";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_31_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_32_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_33_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_34_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_31_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_32_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_33_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_34_D
    }
}

 MENU Tab_m_error_temperature
 {
    LABEL       "Temperature" "|de|Temperatur";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_35_S,
		phys_diag_event_switch_2__Diag_Status_Link_2_36_S,
        transmit_button,
        SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_35_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_36_D
	}
}

MENU Tab_m_error_enhanced_esd
{
    LABEL       "ESD" "|de|ESD";
    ITEMS
    {
		/*string_ascii_status,*/
		phys_diag_event_switch_2__Diag_Status_Link_2_38_S,
		phys_diag_event_switch_2__Diag_Status_Link_2_39_S,
		phys_diag_event_switch_2__Diag_Status_Link_2_40_S,
		transmit_button,
		SEPARATOR,
        /*string_ascii_diagnosis,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_38_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_39_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_40_D
    }
}


/* Inbetriebnahme ************************************************************/
MENU Tab_m_adjustment
{
    LABEL       "Adjustment" "|de|Inbetriebnahme";
    ITEMS
    {
       phys_reading_direction,
       trans1_transm_pin_pos,
       trans1_init_method,
       trans1_pressure_limit,
       trans1_rated_travel,
       trans1_act_stroke_time_dec,
       trans1_act_stroke_time_inc,
/* in 1.43 nicht untersttzt       trans1_signal_pressure_action,*/
       trans1_actuator_action,

       trans1_device_calib_date,
       trans1_device_config_date,
       trans1_valve_maintenance_date,

       trans1_device_init_state,
       Tab_m_adjustment_subst
    }
}


MENU Tab_m_adjustment_subst
{
    LABEL  "Substitution" "|de|Ersatzabgleich";
    ITEMS
    {
       trans1_sub_mode_init,
       trans1_closing_direction,
       trans1_blocking_position
    }
}



MENU Tab_m_adjustment_init
{
    LABEL  "Initialization" "|de|Initialisierung";
    ITEMS
    {
        trans1_self_calibration_cmd,
        trans1_self_calibration_status,
        phys_diagnosis_ext_1_raw_1,
        trans1_transducer_state,
        trans1_actual_mode,
        phys_diag_ext_1_1 			/* Initialisierungsfehler */
	}
}


/* Simulation ********************************/
MENU Tab_m_interface_simulate
{
    LABEL       [menu_interface_simulate];
    ITEMS
    {
        func1_simulate_enabled          (READ_ONLY),
        func1_simulate_value            (READ_ONLY),
        func1_simulate_status_quality   (READ_ONLY),
        func1_simulate_status_limit     (READ_ONLY)
    }
}




/* Binreingang 1 *****************************************************/
MENU Tab_m_di1
{
    LABEL   "Binary input 1 (DI1, TRD)" "|de|Binreingang 1 (DI1, TRD)";
    ITEMS
    {
       func2_DI_channel,
       Tab_m_invert_di1,
       Tab_m_fail_safe_di1,
       Tab_m_simulation_di1
    }
}

MENU Tab_m_invert_di1
{
    LABEL 	"Selection I/O-handling" "|de|Auswahl Ein-/Ausgangsverhalten";
    ITEMS
    {
       func2_DI_invert
    }
}


/* Ausfallverhalten ****************************************************/
MENU Tab_m_fail_safe_di1
{
    LABEL 	"Fail safe action" "|de|Ausfallverhalten";
    ITEMS
    {
      func2_DI_fsafe_type,
      func2_DI_fsafe_value
    }
}

/* Binreingang 1 - simulation ****************************************************/
MENU Tab_m_simulation_di1
{
    LABEL   "Simulation" "|de|Simulation";
    ITEMS
    {
      func2_DI_simulation_enabled        (READ_ONLY),
      func2_DI_simulate_value            (READ_ONLY),
	  func2_DI_simulate_status_quality   (READ_ONLY),
	  func2_DI_simulate_status_limit     (READ_ONLY)
    }
}



/* Binreingang 2 *****************************************************/
MENU Tab_m_di2
{
    LABEL       "Binary input 2 (DI2, TRD)"	"|de|Binreingang 2 (DI2, TRD)";
    ITEMS
    {
       func3_DI_channel,
       phys_config_binary_input_2,
       Tab_m_invert_di2,
       Tab_m_fail_safe_di2,
       Tab_m_simulation_di2
    }
}

MENU Tab_m_invert_di2
{
    LABEL 	"Selection I/O-handling" "|de|Auswahl Ein-/Ausgangsverhalten";
    ITEMS
    {
       func3_DI_invert
    }
}


/* Ausfallverhalten ****************************************************/
MENU Tab_m_fail_safe_di2
{
    LABEL 	"Fail safe action" "|de|Ausfallverhalten";
    ITEMS
    {
      func3_DI_fsafe_type,
      func3_DI_fsafe_value
    }
}

/* Binreingang 2 - simulation ****************************************************/
MENU Tab_m_simulation_di2
{
    LABEL   "Simulation" "|de|Simulation";
    ITEMS
    {
        func3_DI_simulation_enabled        (READ_ONLY),
		func3_DI_simulate_value            (READ_ONLY),
		func3_DI_simulate_status_quality   (READ_ONLY),
		func3_DI_simulate_status_limit     (READ_ONLY)
    }
}

/*********************** Diagnose ***********************************/
MENU Tab_m_diagnosis
{
    LABEL   "Diagnosis"	"|de|Diagnose";
    ITEMS
    {
        trans1_diag_testinfo,
        trans1_diag_level,
        phys_device_dp_status,

        Tab_m_statusmeldungen,
        Tab_m_beobachter_auto,
        Tab_m_beobachter_hand
    }
}

/* Statusmeldungen ************************************************************/
MENU Tab_m_statusmeldungen
{
    LABEL     	"Status messages" "|de|Statusmeldungen";
    ITEMS
    {
        phys_condensed_state,
        trans1_Elapsed_Hours_Meters,
		trans1_Device_In_Closed_Loop,
		trans1_Power_On_Since_Init,
		trans1_Device_In_Closed_Loop_Since_Last_Init,

		trans1_no_of_zero_point_adj,
		trans1_counter_init_start,
		trans1_zero_point_limit  (READ_ONLY),
  	phys_diag_operation,
    phys_diag_init_1,
    phys_diag_init_2,
    phys_diag_hw,
    phys_diag_data_1,
    phys_diag_ext_1_3
/* kmr: geht nicht    phys_diag_data_2,*/

		trans1_Min_Temp,
		trans1_Max_Temp,
		trans1_Time_Min_Temp,
		trans1_Time_Max_Temp,
		trans1_Period_Time_Low,
		trans1_Period_Time_High,

/* entfllt  	    Tab_m_error_unmaskiert,*/
  	    Tab_m_logger,
		Tab_m_enhanced_diag
    }
}

/* Fehler unmaskiert (RAW) ************************************************************/
/* entfllt
MENU Tab_m_error_unmaskiert
{
    LABEL     "Errors unmasked" "|de|Fehler unmaskiert";

    ITEMS
    {
    		 phys_diagnosis_ext_1_raw_0,
  	     phys_diagnosis_ext_1_raw_1,
  	     phys_diagnosis_ext_1_raw_2,
  	     phys_diagnosis_ext_1_raw_3,
  	     Tab_m_error_raw_diag
    }
}*/

/* Fehler unmaskiert (RAW) ************************************************************/
/* entfllt
MENU Tab_m_error_raw_diag
{
    LABEL   "Valve diagnosis E+ unmasked" "|de|Ventildiagnose E+ unmaskiert" ;

    ITEMS
    {
		     phys_diagnosis_ext_1_raw_4,
  	     phys_ext_2_raw_enh_diag_1,
         phys_ext_2_raw_enh_diag_2,
         phys_ext_2_raw_enh_diag_3
    }
    VALIDITY_ONLY_EXPERT_PLUS
}*/

/* Protokollierung 1************************************************************/
MENU Tab_m_logger
{
	LABEL	  "Logger" "|de|Protokollierung";
    ITEMS
    {
      trans1_Message_0,
      trans1_Elapsed_Hours_Meters_0,
      trans1_Message_1,
      trans1_Elapsed_Hours_Meters_1,
      trans1_Message_2,
      trans1_Elapsed_Hours_Meters_2,
      trans1_Message_3,
      trans1_Elapsed_Hours_Meters_3,
      trans1_Message_4,
      trans1_Elapsed_Hours_Meters_4,
      trans1_Message_5,
      trans1_Elapsed_Hours_Meters_5,
      trans1_Message_6,
      trans1_Elapsed_Hours_Meters_6,
      trans1_Message_7,
      trans1_Elapsed_Hours_Meters_7,
      trans1_Message_8,
      trans1_Elapsed_Hours_Meters_8,
      trans1_Message_9,
      trans1_Elapsed_Hours_Meters_9,
      trans1_Message_10,
      trans1_Elapsed_Hours_Meters_10,
      trans1_Message_11,
      trans1_Elapsed_Hours_Meters_11,
      trans1_Message_12,
      trans1_Elapsed_Hours_Meters_12,
      trans1_Message_13,
      trans1_Elapsed_Hours_Meters_13,
      trans1_Message_14,
      trans1_Elapsed_Hours_Meters_14,
      trans1_Message_15,
      trans1_Elapsed_Hours_Meters_15,
      trans1_Message_16,
      trans1_Elapsed_Hours_Meters_16,
      trans1_Message_17,
      trans1_Elapsed_Hours_Meters_17,
      trans1_Message_18,
      trans1_Elapsed_Hours_Meters_18,
      trans1_Message_19,
      trans1_Elapsed_Hours_Meters_19,
      trans1_Message_20,
      trans1_Elapsed_Hours_Meters_20,
      trans1_Message_21,
      trans1_Elapsed_Hours_Meters_21,
      trans1_Message_22,
      trans1_Elapsed_Hours_Meters_22,
      trans1_Message_23,
      trans1_Elapsed_Hours_Meters_23,
      trans1_Message_24,
      trans1_Elapsed_Hours_Meters_24,
      trans1_Message_25,
      trans1_Elapsed_Hours_Meters_25,
      trans1_Message_26,
      trans1_Elapsed_Hours_Meters_26,
      trans1_Message_27,
      trans1_Elapsed_Hours_Meters_27,
      trans1_Message_28,
      trans1_Elapsed_Hours_Meters_28,
      trans1_Message_29,
      trans1_Elapsed_Hours_Meters_29
    }
}


/* Beobachterfunktionen AUTO ************************************************************/
MENU Tab_m_beobachter_auto
{
    LABEL "Statistical information AUTO" "|de|Beobachterfunktionen AUTO";

    ITEMS
    {
         Tab_m_datenlogger,
         Tab_m_histogramm_x,
         Tab_m_histogramm_e,
         Tab_m_histogramm_z,
         Tab_m_stellsignal_y,
         Tab_m_endlagentrend
    }
    VALIDITY_ONLY_EXPERT_PLUS
}

/* Datenlogger ************************************************************/
MENU Tab_m_datenlogger
{
	LABEL	"Data logger" "|de|Datenlogger";

    ITEMS
    {
        trans1_datalogger_select,
	 			trans1_datalogger_trigger_select,
	 			phys_dl_trigger_select_bin,
				trans1_datalogger_sample_rate,
				trans1_datalogger_start_value,
				trans1_datalogger_logging_limit,
				trans1_datalogger_pretrigger_time,
        trans1_datalogger_max_pretrig
/* kmr: wird nicht angezeigt:
		Tab_m_measured_values_datalogger*/
    }
}


/* Histogramm X Lang ************************************************************/
MENU Tab_m_histogramm_x
{
    LABEL   "Travel histogram x" "|de|Histogramm Ventilstellung x" ;

    ITEMS
    {
		trans1_X_Average,
		trans1_Number_Mess_Points,

        trans1_X_Interval_Value_0,
		trans1_X_Interval_Value_1,
		trans1_X_Interval_Value_2,
		trans1_X_Interval_Value_3,
		trans1_X_Interval_Value_4,
		trans1_X_Interval_Value_5,
		trans1_X_Interval_Value_6,
		trans1_X_Interval_Value_7,
		trans1_X_Interval_Value_8,
		trans1_X_Interval_Value_9,
		trans1_X_Interval_Value_10,
		trans1_X_Interval_Value_11,
		trans1_X_Interval_Value_12,
		trans1_X_Interval_Value_13,
		trans1_X_Interval_Value_14,
		trans1_X_Interval_Value_15,
		trans1_X_Interval_Value_16,
		trans1_X_Interval_Value_17,
		trans1_X_Interval_Value_18,
		trans1_X_Interval_Value_19,
		trans1_X_Interval_Value_20,
		trans1_X_Interval_Value_21,

        Tab_m_short_terme_X
    }
}

/* Histogramm X Kurz ******************************************/
MENU Tab_m_short_terme_X
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
		trans1_X_HIS_ABTASTRATE,
		trans1_X_Average_KURZ,

        trans1_X_Interval_Value_0_KURZ,
		trans1_X_Interval_Value_1_KURZ,
		trans1_X_Interval_Value_2_KURZ,
		trans1_X_Interval_Value_3_KURZ,
		trans1_X_Interval_Value_4_KURZ,
		trans1_X_Interval_Value_5_KURZ,
		trans1_X_Interval_Value_6_KURZ,
		trans1_X_Interval_Value_7_KURZ,
		trans1_X_Interval_Value_8_KURZ,
		trans1_X_Interval_Value_9_KURZ,
		trans1_X_Interval_Value_10_KURZ,
		trans1_X_Interval_Value_11_KURZ,
		trans1_X_Interval_Value_12_KURZ,
		trans1_X_Interval_Value_13_KURZ,
		trans1_X_Interval_Value_14_KURZ,
		trans1_X_Interval_Value_15_KURZ,
		trans1_X_Interval_Value_16_KURZ,
		trans1_X_Interval_Value_17_KURZ,
		trans1_X_Interval_Value_18_KURZ,
		trans1_X_Interval_Value_19_KURZ,
		trans1_X_Interval_Value_20_KURZ,
		trans1_X_Interval_Value_21_KURZ
    }
}




/* Histogramm E ************************************************************/
MENU Tab_m_histogramm_e
{
    LABEL   "Setpoint deviation histogram e" "|de|Histogramm Regelabweichung e" ;

    ITEMS
    {
		trans1_E_Average,
		trans1_Total_Number_E,
        trans1_deviation_min,
		trans1_deviation_max,

        trans1_E_Interval_Value_0,
        trans1_E_Interval_Value_1,
		trans1_E_Interval_Value_2,
		trans1_E_Interval_Value_3,
		trans1_E_Interval_Value_4,
		trans1_E_Interval_Value_5,
		trans1_E_Interval_Value_6,
		trans1_E_Interval_Value_7,
		trans1_E_Interval_Value_8,
		trans1_E_Interval_Value_9,
		trans1_E_Interval_Value_10,
		trans1_E_Interval_Value_11,

		Tab_m_short_terme_E
    }
}

/* Histogramm E Kurz ******************************************/
MENU Tab_m_short_terme_E
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
		trans1_E_HIS_ABTASTRATE,
		trans1_E_Average_KURZ,

        trans1_E_Interval_Value_0_KURZ,
        trans1_E_Interval_Value_1_KURZ,
		trans1_E_Interval_Value_2_KURZ,
		trans1_E_Interval_Value_3_KURZ,
		trans1_E_Interval_Value_4_KURZ,
		trans1_E_Interval_Value_5_KURZ,
		trans1_E_Interval_Value_6_KURZ,
		trans1_E_Interval_Value_7_KURZ,
		trans1_E_Interval_Value_8_KURZ,
		trans1_E_Interval_Value_9_KURZ,
		trans1_E_Interval_Value_10_KURZ,
		trans1_E_Interval_Value_11_KURZ
    }
}


/* Histogramm Z ************************************************************/
MENU Tab_m_histogramm_z
{
    LABEL  "Cycle counter histogram" "|de|Histogramm Zyklenzhler" ;

    ITEMS
    {
		trans1_Z_Average,
		trans1_Total_Number_Z,
		trans1_Dynamic_Factor,

        trans1_Z_Interval_Value_0,
        trans1_Z_Interval_Value_1,
		trans1_Z_Interval_Value_2,
		trans1_Z_Interval_Value_3,
		trans1_Z_Interval_Value_4,
		trans1_Z_Interval_Value_5,
		trans1_Z_Interval_Value_6,
		trans1_Z_Interval_Value_7,
		trans1_Z_Interval_Value_8,
		trans1_Z_Interval_Value_9,
		trans1_Z_Interval_Value_10,
		trans1_Z_Interval_Value_11,
		trans1_Z_Interval_Value_12,

        Tab_m_short_terme_Z
    }
}

/* Histogramm Z Kurz ******************************************/
MENU Tab_m_short_terme_Z
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
		trans1_Z_Average_KURZ,

        trans1_Z_Interval_Value_0_KURZ,
        trans1_Z_Interval_Value_1_KURZ,
		trans1_Z_Interval_Value_2_KURZ,
		trans1_Z_Interval_Value_3_KURZ,
		trans1_Z_Interval_Value_4_KURZ,
		trans1_Z_Interval_Value_5_KURZ,
		trans1_Z_Interval_Value_6_KURZ,
		trans1_Z_Interval_Value_7_KURZ,
		trans1_Z_Interval_Value_8_KURZ,
		trans1_Z_Interval_Value_9_KURZ,
		trans1_Z_Interval_Value_10_KURZ,
		trans1_Z_Interval_Value_11_KURZ,
		trans1_Z_Interval_Value_12_KURZ
    }
}

/* Stellsignal Y ************************************************************/
MENU Tab_m_stellsignal_y
{
    LABEL     "Drive signal diagram y" "|de|Diagramm Stellsignal y" ;

    ITEMS
    {
          Tab_m_stationaer,
          Tab_m_hysterese
    }
}

/* Stellsignal Y - Stationaer ************************************************************/
MENU Tab_m_stationaer
{
    LABEL     "Steady" "|de|Stationaer" ;

    ITEMS
    {
          Tab_m_stat_longterm,
          Tab_m_stat_shortterm
    }
}


/* Stellsignal Y - Stationaer Langzeit ************************************************************/
MENU Tab_m_stat_longterm
{
    LABEL "Long-term" "|de|Langzeitbetrachtung";

    ITEMS
    {
          trans1_stationaer_lang_Value_0,
          trans1_stationaer_lang_Value_1,
          trans1_stationaer_lang_Value_2,
          trans1_stationaer_lang_Value_3,
          trans1_stationaer_lang_Value_4,
          trans1_stationaer_lang_Value_5,
          trans1_stationaer_lang_Value_6,
          trans1_stationaer_lang_Value_7,
          trans1_stationaer_lang_Value_8,
          trans1_stationaer_lang_Value_9,
          trans1_stationaer_lang_Value_10,
          trans1_stationaer_lang_Value_11,
          trans1_stationaer_lang_Value_12,
          trans1_stationaer_lang_Value_13,
          trans1_stationaer_lang_Value_14,
          trans1_stationaer_lang_Value_15,
          trans1_stationaer_lang_Value_16,
          trans1_stationaer_lang_Value_17,
          trans1_stationaer_lang_Value_18,
          trans1_stationaer_lang_Value_19,
          trans1_stationaer_lang_Value_20,
          trans1_stationaer_lang_Value_21
    }
}

/* Stellsignal Y - Stationaer Kurzzeit ************************************************************/
MENU Tab_m_stat_shortterm
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
          trans1_stationaer_kurz_Value_0,
          trans1_stationaer_kurz_Value_1,
          trans1_stationaer_kurz_Value_2,
          trans1_stationaer_kurz_Value_3,
          trans1_stationaer_kurz_Value_4,
          trans1_stationaer_kurz_Value_5,
          trans1_stationaer_kurz_Value_6,
          trans1_stationaer_kurz_Value_7,
          trans1_stationaer_kurz_Value_8,
          trans1_stationaer_kurz_Value_9,
          trans1_stationaer_kurz_Value_10,
          trans1_stationaer_kurz_Value_11,
          trans1_stationaer_kurz_Value_12,
          trans1_stationaer_kurz_Value_13,
          trans1_stationaer_kurz_Value_14,
          trans1_stationaer_kurz_Value_15,
          trans1_stationaer_kurz_Value_16,
          trans1_stationaer_kurz_Value_17,
          trans1_stationaer_kurz_Value_18,
          trans1_stationaer_kurz_Value_19,
          trans1_stationaer_kurz_Value_20,
          trans1_stationaer_kurz_Value_21,

          Tab_m_stat_stellsignal,
          Tab_m_stat_ventilstellung
    }
}

/* Stellsignal Y - Stationaer Kurzzeit Stellsignal ****************************************************/
MENU Tab_m_stat_stellsignal
{
    LABEL     "Drive signal" "|de|Stellsignal" ;

    ITEMS
    {
          trans1_stat_stellsignal_Value_0,
          trans1_stat_stellsignal_Value_1,
          trans1_stat_stellsignal_Value_2,
          trans1_stat_stellsignal_Value_3,
          trans1_stat_stellsignal_Value_4,
          trans1_stat_stellsignal_Value_5,
          trans1_stat_stellsignal_Value_6,
          trans1_stat_stellsignal_Value_7,
          trans1_stat_stellsignal_Value_8,
          trans1_stat_stellsignal_Value_9

    }
}

/* Stellsignal Y - Stationaer Kurzzeit Ventilstellung ****************************************************/
MENU Tab_m_stat_ventilstellung
{
    LABEL     "Valve position" "|de|Ventilstellung" ;

    ITEMS
    {
          trans1_stat_ventilstellung_Value_0,
          trans1_stat_ventilstellung_Value_1,
          trans1_stat_ventilstellung_Value_2,
          trans1_stat_ventilstellung_Value_3,
          trans1_stat_ventilstellung_Value_4,
          trans1_stat_ventilstellung_Value_5,
          trans1_stat_ventilstellung_Value_6,
          trans1_stat_ventilstellung_Value_7,
          trans1_stat_ventilstellung_Value_8,
          trans1_stat_ventilstellung_Value_9
    }
}

/* Stellsignal Y - Hysterese ********************************************************/
MENU Tab_m_hysterese
{
    LABEL     "Hysteresis" "|de|Hysterese" ;

    ITEMS
    {
          start_hys_online_test,
          abort_hys_online_test,
          trans1_autostart_hyst,

          Tab_m_hys_longterm,
          Tab_m_hys_shortterm
    }
}


/* Stellsignal Y - Hysterese Langzeit ************************************************************/
MENU Tab_m_hys_longterm
{
    LABEL "Long-term" "|de|Langzeitbetrachtung";

    ITEMS
    {
          trans1_hysterese_lang_Value_0,
          trans1_hysterese_lang_Value_1,
          trans1_hysterese_lang_Value_2,
          trans1_hysterese_lang_Value_3,
          trans1_hysterese_lang_Value_4,
          trans1_hysterese_lang_Value_5,
          trans1_hysterese_lang_Value_6,
          trans1_hysterese_lang_Value_7,
          trans1_hysterese_lang_Value_8,
          trans1_hysterese_lang_Value_9,
          trans1_hysterese_lang_Value_10,
          trans1_hysterese_lang_Value_11,
          trans1_hysterese_lang_Value_12,
          trans1_hysterese_lang_Value_13,
          trans1_hysterese_lang_Value_14,
          trans1_hysterese_lang_Value_15,
          trans1_hysterese_lang_Value_16,
          trans1_hysterese_lang_Value_17,
          trans1_hysterese_lang_Value_18
    }
}

/* Stellsignal Y - Hysterese Kurzzeit ************************************************************/
MENU Tab_m_hys_shortterm
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
          Tab_m_hys_stellsignal,
          Tab_m_hys_ventilstellung
    }
}

/* Stellsignal Y - Hysterese Kurzzeit Stellsignal ****************************************************/
MENU Tab_m_hys_stellsignal
{
    LABEL     "Difference drive signal" "|de|Differenz Stellsignal" ;

    ITEMS
    {
          trans1_hys_stellsignal_Value_0,
          trans1_hys_stellsignal_Value_1,
          trans1_hys_stellsignal_Value_2,
          trans1_hys_stellsignal_Value_3,
          trans1_hys_stellsignal_Value_4,
          trans1_hys_stellsignal_Value_5,
          trans1_hys_stellsignal_Value_6,
          trans1_hys_stellsignal_Value_7,
          trans1_hys_stellsignal_Value_8,
          trans1_hys_stellsignal_Value_9
    }
}

/* Stellsignal Y - Hysterese Kurzzeit Ventilstellung ****************************************************/
MENU Tab_m_hys_ventilstellung
{
    LABEL     "Valve position" "|de|Ventilstellung" ;

    ITEMS
    {
          trans1_hys_ventilstellung_Value_0,
          trans1_hys_ventilstellung_Value_1,
          trans1_hys_ventilstellung_Value_2,
          trans1_hys_ventilstellung_Value_3,
          trans1_hys_ventilstellung_Value_4,
          trans1_hys_ventilstellung_Value_5,
          trans1_hys_ventilstellung_Value_6,
          trans1_hys_ventilstellung_Value_7,
          trans1_hys_ventilstellung_Value_8,
          trans1_hys_ventilstellung_Value_9
    }
}

/* Endlagentrend ****************************************************/
MENU Tab_m_endlagentrend
{
    LABEL     "Trend of travel end position" "|de|Endlagentrend" ;

    ITEMS
    {
          trans1_et_ventil_refwert,
          trans1_et_BSZ_refwert,
          trans1_et_endlage_refwert,

          trans1_et_ventil_Value_0,
          trans1_et_BSZ_Value_0,
          trans1_et_endlage_Value_0,

          trans1_et_ventil_Value_1,
          trans1_et_BSZ_Value_1,
          trans1_et_endlage_Value_1,

          trans1_et_ventil_Value_2,
          trans1_et_BSZ_Value_2,
          trans1_et_endlage_Value_2,

          trans1_et_ventil_Value_3,
          trans1_et_BSZ_Value_3,
          trans1_et_endlage_Value_3,

          trans1_et_ventil_Value_4,
          trans1_et_BSZ_Value_4,
          trans1_et_endlage_Value_4,

          trans1_et_ventil_Value_5,
          trans1_et_BSZ_Value_5,
          trans1_et_endlage_Value_5,

          trans1_et_ventil_Value_6,
          trans1_et_BSZ_Value_6,
          trans1_et_endlage_Value_6,

          trans1_et_ventil_Value_7,
          trans1_et_BSZ_Value_7,
          trans1_et_endlage_Value_7,

          trans1_et_ventil_Value_8,
          trans1_et_BSZ_Value_8,
          trans1_et_endlage_Value_8,

          trans1_et_ventil_Value_9,
          trans1_et_BSZ_Value_9,
          trans1_et_endlage_Value_9,

          trans1_et_ventil_Value_10,
          trans1_et_BSZ_Value_10,
          trans1_et_endlage_Value_10,

          trans1_et_ventil_Value_11,
          trans1_et_BSZ_Value_11,
          trans1_et_endlage_Value_11,

          trans1_et_ventil_Value_12,
          trans1_et_BSZ_Value_12,
          trans1_et_endlage_Value_12,

          trans1_et_ventil_Value_13,
          trans1_et_BSZ_Value_13,
          trans1_et_endlage_Value_13,

          trans1_et_ventil_Value_14,
          trans1_et_BSZ_Value_14,
          trans1_et_endlage_Value_14,

          trans1_et_ventil_Value_15,
          trans1_et_BSZ_Value_15,
          trans1_et_endlage_Value_15,

          trans1_et_ventil_Value_16,
          trans1_et_BSZ_Value_16,
          trans1_et_endlage_Value_16,

          trans1_et_ventil_Value_17,
          trans1_et_BSZ_Value_17,
          trans1_et_endlage_Value_17,

          trans1_et_ventil_Value_18,
          trans1_et_BSZ_Value_18,
          trans1_et_endlage_Value_18,

          trans1_et_ventil_Value_19,
          trans1_et_BSZ_Value_19,
          trans1_et_endlage_Value_19,

          trans1_et_ventil_Value_20,
          trans1_et_BSZ_Value_20,
          trans1_et_endlage_Value_20,

          trans1_et_ventil_Value_21,
          trans1_et_BSZ_Value_21,
          trans1_et_endlage_Value_21,

          trans1_et_ventil_Value_22,
          trans1_et_BSZ_Value_22,
          trans1_et_endlage_Value_22,

          trans1_et_ventil_Value_23,
          trans1_et_BSZ_Value_23,
          trans1_et_endlage_Value_23,

          trans1_et_ventil_Value_24,
          trans1_et_BSZ_Value_24,
          trans1_et_endlage_Value_24,

          trans1_et_ventil_Value_25,
          trans1_et_BSZ_Value_25,
          trans1_et_endlage_Value_25,

          trans1_et_ventil_Value_26,
          trans1_et_BSZ_Value_26,
          trans1_et_endlage_Value_26,

          trans1_et_ventil_Value_27,
          trans1_et_BSZ_Value_27,
          trans1_et_endlage_Value_27,

          trans1_et_ventil_Value_28,
          trans1_et_BSZ_Value_28,
          trans1_et_endlage_Value_28,

          trans1_et_BSZ_Value_29,
          trans1_et_ventil_Value_29,
          trans1_et_endlage_Value_29
    }
}





/* Testfunktionen HAND ************************************************************/
MENU Tab_m_beobachter_hand
{
    LABEL     "Tests MAN" "|de|Testfunktionen HAND" ;

    ITEMS
    {
          Tab_m_drive_signal_stat,
          Tab_m_drive_signal_hys,
          Tab_m_static_charact,
          Tab_m_step_response
    }
    VALIDITY_ONLY_EXPERT_PLUS
}


/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_stat
{
    LABEL     "Drive signal steady" "|de|Stellsignal y Stationaer" ;

    ITEMS
    {
          trans1_stat_ss_refzeit,

          Tab_m_drive_signal_stat_ref_vs,
          Tab_m_drive_signal_stat_ref_ss,
          Tab_m_drive_signal_stat_again_vs,
          Tab_m_drive_signal_stat_again_ss

    }
}


/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_stat_ref_vs
{
    LABEL     "Reference data valve position" "|de|Referenzwert Ventilstellung" ;

    ITEMS
    {
	       trans1_stat_ref_vs_0,
	       trans1_stat_ref_vs_1,
	       trans1_stat_ref_vs_2,
	       trans1_stat_ref_vs_3,
	       trans1_stat_ref_vs_4,
	       trans1_stat_ref_vs_5,
	       trans1_stat_ref_vs_6,
	       trans1_stat_ref_vs_7,
	       trans1_stat_ref_vs_8,
	       trans1_stat_ref_vs_9,
	       trans1_stat_ref_vs_10,
	       trans1_stat_ref_vs_11,
	       trans1_stat_ref_vs_12,
	       trans1_stat_ref_vs_13,
	       trans1_stat_ref_vs_14,
	       trans1_stat_ref_vs_15,
	       trans1_stat_ref_vs_16,
	       trans1_stat_ref_vs_17,
	       trans1_stat_ref_vs_18,
	       trans1_stat_ref_vs_19,
	       trans1_stat_ref_vs_20,
	       trans1_stat_ref_vs_21,
	       trans1_stat_ref_vs_22,
	       trans1_stat_ref_vs_23,
	       trans1_stat_ref_vs_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_stat_ref_ss
{
    LABEL     "Reference data drive signal" "|de|Referenzwert Stellsignal" ;

    ITEMS
    {
		   trans1_stat_ref_ss_0,
	       trans1_stat_ref_ss_1,
	       trans1_stat_ref_ss_2,
	       trans1_stat_ref_ss_3,
	       trans1_stat_ref_ss_4,
	       trans1_stat_ref_ss_5,
	       trans1_stat_ref_ss_6,
	       trans1_stat_ref_ss_7,
	       trans1_stat_ref_ss_8,
	       trans1_stat_ref_ss_9,
	       trans1_stat_ref_ss_10,
	       trans1_stat_ref_ss_11,
	       trans1_stat_ref_ss_12,
	       trans1_stat_ref_ss_13,
	       trans1_stat_ref_ss_14,
	       trans1_stat_ref_ss_15,
	       trans1_stat_ref_ss_16,
	       trans1_stat_ref_ss_17,
	       trans1_stat_ref_ss_18,
	       trans1_stat_ref_ss_19,
	       trans1_stat_ref_ss_20,
	       trans1_stat_ref_ss_21,
	       trans1_stat_ref_ss_22,
	       trans1_stat_ref_ss_23,
	       trans1_stat_ref_ss_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_stat_again_vs
{
    LABEL    "Repetition data valve position"  "|de|Wiederholungswert Ventilstellung" ;

    ITEMS
    {
		   trans1_stat_again_vs_0,
	       trans1_stat_again_vs_1,
	       trans1_stat_again_vs_2,
	       trans1_stat_again_vs_3,
	       trans1_stat_again_vs_4,
	       trans1_stat_again_vs_5,
	       trans1_stat_again_vs_6,
	       trans1_stat_again_vs_7,
	       trans1_stat_again_vs_8,
	       trans1_stat_again_vs_9,
	       trans1_stat_again_vs_10,
	       trans1_stat_again_vs_11,
	       trans1_stat_again_vs_12,
	       trans1_stat_again_vs_13,
	       trans1_stat_again_vs_14,
	       trans1_stat_again_vs_15,
	       trans1_stat_again_vs_16,
	       trans1_stat_again_vs_17,
	       trans1_stat_again_vs_18,
	       trans1_stat_again_vs_19,
	       trans1_stat_again_vs_20,
	       trans1_stat_again_vs_21,
	       trans1_stat_again_vs_22,
	       trans1_stat_again_vs_23,
	       trans1_stat_again_vs_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_stat_again_ss
{
    LABEL    "Repetition data drive signal" "|de|Wiederholungswert Stellsignal" ;

    ITEMS
    {
	       trans1_stat_again_ss_0,
	       trans1_stat_again_ss_1,
	       trans1_stat_again_ss_2,
	       trans1_stat_again_ss_3,
	       trans1_stat_again_ss_4,
	       trans1_stat_again_ss_5,
	       trans1_stat_again_ss_6,
	       trans1_stat_again_ss_7,
	       trans1_stat_again_ss_8,
	       trans1_stat_again_ss_9,
	       trans1_stat_again_ss_10,
	       trans1_stat_again_ss_11,
	       trans1_stat_again_ss_12,
	       trans1_stat_again_ss_13,
	       trans1_stat_again_ss_14,
	       trans1_stat_again_ss_15,
	       trans1_stat_again_ss_16,
	       trans1_stat_again_ss_17,
	       trans1_stat_again_ss_18,
	       trans1_stat_again_ss_19,
	       trans1_stat_again_ss_20,
	       trans1_stat_again_ss_21,
	       trans1_stat_again_ss_22,
	       trans1_stat_again_ss_23,
	       trans1_stat_again_ss_24
    }
}


/* Stellsignal Y hysterese ************************************************************/
MENU Tab_m_drive_signal_hys
{
    LABEL     "Drive signal y hysteresis" "|de|Stellsignal y Hysterese" ;

    ITEMS
    {
          trans1_hys_ss_refzeit,

          Tab_m_drive_signal_hys_ref_vs,
          Tab_m_drive_signal_hys_ref_hys,
          Tab_m_drive_signal_hys_again_hys
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_hys_ref_vs
{
    LABEL     "Reference data valve position" "|de|Referenzwert Ventilstellung" ;

    ITEMS
    {
	     	 trans1_hys_ref_vs_0,
	     	 trans1_hys_ref_vs_1,
	     	 trans1_hys_ref_vs_2,
	     	 trans1_hys_ref_vs_3,
	     	 trans1_hys_ref_vs_4,
	     	 trans1_hys_ref_vs_5,
	     	 trans1_hys_ref_vs_6,
	     	 trans1_hys_ref_vs_7,
	     	 trans1_hys_ref_vs_8,
	     	 trans1_hys_ref_vs_9,
	     	 trans1_hys_ref_vs_10,
	     	 trans1_hys_ref_vs_11
	  }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_hys_ref_hys
{
    LABEL    "Reference measurement hysteresis" "|de|Referenzmessung Hysterese" ;

    ITEMS
    {
	     	 trans1_hys_ref_hys_0,
	     	 trans1_hys_ref_hys_1,
	     	 trans1_hys_ref_hys_2,
	     	 trans1_hys_ref_hys_3,
	     	 trans1_hys_ref_hys_4,
	     	 trans1_hys_ref_hys_5,
	     	 trans1_hys_ref_hys_6,
	     	 trans1_hys_ref_hys_7,
	     	 trans1_hys_ref_hys_8,
	     	 trans1_hys_ref_hys_9,
	     	 trans1_hys_ref_hys_10,
	     	 trans1_hys_ref_hys_11
	  }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_m_drive_signal_hys_again_hys
{
    LABEL     "Repetition data hysteresis" "|de|Wiederholungswert Hysterese" ;

    ITEMS
    {
	     	 trans1_hys_again_hys_0,
	     	 trans1_hys_again_hys_1,
	     	 trans1_hys_again_hys_2,
	     	 trans1_hys_again_hys_3,
	     	 trans1_hys_again_hys_4,
	     	 trans1_hys_again_hys_5,
	     	 trans1_hys_again_hys_6,
	     	 trans1_hys_again_hys_7,
	     	 trans1_hys_again_hys_8,
	     	 trans1_hys_again_hys_9,
	     	 trans1_hys_again_hys_10,
	     	 trans1_hys_again_hys_11
	  }
}


/* Statische Kennlinie ************************************************************/
MENU Tab_m_static_charact
{
    LABEL    "Static characteristic" "|de|Statische Kennlinie" ;

    ITEMS
    {
          trans1_stat_kenn_start,
          trans1_stat_kenn_ende,
          trans1_stat_kenn_warte,
          trans1_stat_kenn_anzahl,
          trans1_stat_kenn_sprunghoehe,
          trans1_stat_kenn_min_tot,
          trans1_stat_kenn_durch_tot,
          trans1_stat_kenn_max_tot
/* kmr: wird nicht angezeigt:
          Tab_m_measured_values*/
    }
}


/* Sprungantwort ************************************************************/
MENU Tab_m_step_response
{
    LABEL    "Step response"  "|de|Sprungantwort" ;

    ITEMS
    {
        trans1_Stepstart,
		trans1_Stepend,
		trans1_Step_Sample_Rate,
/* kmr: fuer ESD: */
/*		trans1_Rampe_Up,
		trans1_Rampe_Down,*/
		trans1_Latency_After_Step,
		trans1_Step_Selection,
       	trans1_Overshoot_Rising,
		trans1_Overshoot_Falling,
		trans1_Dead_Time_Rising,
		trans1_Dead_Time_Falling,
		trans1_Time_63_Rising,
		trans1_Time_63_Falling,
		trans1_Time_98_Rising,
		trans1_Time_98_Falling,
		trans1_Step_Progress,
		trans1_Rise_Time_Falling,
		trans1_Settling_Time_Falling,
		trans1_Rise_Time_Rising,
		trans1_Settling_Time_Rising,
		trans1_Duration_of_test
/* kmr: wird nicht angezeigt:
        Tab_m_measured_values_step*/
    }
}


MENU Tab_m_enhanced_diag
{
  	LABEL	"Extended" "|de|Erweitert";

  	ITEMS
  	{
		phys_diag_ext_1_4,
		phys_diag_ext_2_0,
		phys_diag_ext_2_1,
		phys_diag_ext_2_2
   	}
    VALIDITY_ONLY_EXPERT_PLUS
}



/********* ende **************************************************************/