/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2005). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 373X-4           */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.01                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*                                                              */
/*  $Revision:   1.3  $                                         */
/*  $Date:   20.07.2005 19:49:52  $                             */
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 20.07.2005 Ald/E7  Erstellung der Diagnose-DD                */
/* 28.04.2006 kmr/E82 Fertigstellung der Diagnose-DD            */
/*                    trans1_Message_0..30: Texte fuer 10070 und*/
/*                    10071 ergaenzt.                           */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/


/* ------------------------------------------------------------------------ */
/*
VARIABLE datalogger_select (unsigned_char_38)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_select
{
  LABEL    "Selection" "|de|Auswahl";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE	 0;
    { 0, "Permanent" "|de|Permanent"  },
    { 1, "Trigger"   "|de|Getriggert" }
  }

  HELP     "Data logger in permanent or trigger mode."
           "|de|Datenlogger permanent oder getriggert betreiben.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE trigger_select (unsigned_char_47)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_trigger_select
{
  LABEL    "Trigger status" "|de|Triggerauswahl";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  // TYPE     UNSIGNED_INTEGER (1)  WTM sonst ist der gesamte Bereich 0-255 schreibbar
  
  { 
    DEFAULT_VALUE 128;  
    { 1, "Start trigger via int. sol. valve / forced venting"
         "|de|Triggerstart ber int. MGV / Zwangsentlftung" },
    { 8, "Start trigger via valve position"
         "|de|Triggerstart ber Ventilstellung" }, 
    { 16, "Start trigger via setpoint deviation"
         "|de|Triggerstart ber Regeldifferenz" },     
    { 32, "Start trigger via drive signal y"
         "|de|Triggerstart ber Stellsignal y" },                            
    { 64, "Start trigger via binary input"
         "|de|Triggerstart ber Binreingang" },   
    { 128, "Start trigger via setpoint"
         "|de|Triggerstart ber Sollwert" },
    { 129, "Start trigger via SP or int sol. valve/forced vent. cond."
         "|de|Triggerstart ber Sollwert- oder int. MGV-/ZWE-Bed." }
  }
  HELP     "Selection of the start condition of the triggered data logger."
           "|de|Auswhlen der Startbedingung des getriggerten Datenloggers.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE sample_rate (unsigned_long_477)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_sample_rate
{
  LABEL    "Scan rate" "|de|Abtastzeit";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (4)
  {
      DEFAULT_VALUE  1000; /* 1.0 s */
      MIN_VALUE       200; /* 0.2 s */
      MAX_VALUE   3600000; /* 3600 s */
  }
  CONSTANT_UNIT "ms";
  HELP     "Adjust the scan rate." "|de|Einstellen der Abtastrate.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE start_value (float_1)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_start_value
{
  LABEL    "Start value" "|de|Startwertvorgabe";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
  DISPLAY_FORMAT "6.1f";
  DEFAULT_VALUE 99.0;
  MIN_VALUE 0.0;
  
  MAX_VALUE
	IF (trans1_datalogger_trigger_select == 32 )  
	     {10000.0;}
	  ELSE
		 {100.0;}
		  
   }
  CONSTANT_UNIT 
		IF (trans1_datalogger_trigger_select == 32 )  
			{"1/s";}   // Triggerstart: Stellsignal y, Einheit 1/s
		ELSE
			{"%";}
  
  HELP     "Limit of the valve position from which the triggered data logger should start."
           "|de|Grenze der Ventilstellung ab der der getriggerte Datenlogger starten soll.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE logging_limit (unsigned_char_42)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_logging_limit
{
  LABEL    "Logging limit" "|de|Protokollierungsgrenze";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE 0;
    
    IF (trans1_datalogger_trigger_select == 64)
    {
		{0, "Start: Low Level" "|de|Low Pegel" },
	    {1, "Start: High Level"   "|de|High Pegel"}
    }
    ELSE
    {
		{0, "Start: falls below init. value" "|de|Grenzunterschreitung"},
		{1, "Start: exceeds initial value"   "|de|Grenzberschreitung"}
    }
  }
  
  HELP     "Start condition for triggered data logger to start at "
           "falling below or exceeding the initial value."
           "|de|Startbedingung fr den getriggerten Datenlogger. "
           "Bei Unterschreitung oder berschreitung der Startwertvorgabe starten.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE pretrigger_time (unsigned_long_478)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_pretrigger_time
{
  LABEL    "Pretrigger time" "|de|Pretriggerzeit";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (4)
  {
    DEFAULT_VALUE       0;
    MIN_VALUE           0;
    MAX_VALUE   120000000;  /* 120000 s entspricht max. Abtastrate * 100 / 3 */
  }
  CONSTANT_UNIT "ms";
  HELP     "Measuring time before actuating the trigger event. "
           "The maximum value is the parameter 'Max. pretrigger time'."
           "|de|Angabe der Messzeit vor Auslsen des Triggerereignisses. "
           "Der Maximalwert ist der Parameter 'Max. Pretriggerzeit'.";
}


VARIABLE trans1_datalogger_testinfo
{
  LABEL    "Test information" "|de|Testinformation";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE    0;
    { 0, "Test not active" "|de|Test nicht aktiv" },
    { 1, "Test active"     "|de|Test aktiv"       }
  }

  HELP    "Status of the test" "|de|Status des Testlaufes.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE max_pretrigger_time (unsigned_long_479)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_max_pretrig
{
  LABEL    "Max. pretrigger time" "|de|Max. Pretriggerzeit";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT   ".0f";
      DEFAULT_VALUE    0.0;
  }
  SCALING_FACTOR  1000; /* damit alle Zeiten vom Datenlogger in ms und nicht gemischt */
  CONSTANT_UNIT "ms";
  HELP     "Max. possible pretrigger time - depends on the scan rate."
           "|de|Grsste einstellbare Pretriggerzeit - "
           "richtet sich nach der Einstellung der Abtastrate.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE datalogger_progress (unsigned_char_44)
(Diagnose - Beobachterfunktionen AUTO - Datenlogger)
*/
VARIABLE trans1_datalogger_progress
{
  LABEL    "Progress flag" "|de|Fortschritt";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    { 0, "Trigger not selected"              						"|de|Triggerung nicht ausgewhlt" },
    { 1, "Trigger selected"                  						"|de|Triggerung ausgewhlt"       },
    { 2, "Trigger started: valve cond."      						"|de|Triggerstart durch Hubbed."  },
    { 3, "Trigger started: sol. valve cond." 						"|de|Triggerstart durch MV-Bed."  },
    { 4, "Memory full, ending measuring"     						"|de|Speicher voll, Ende Messung" },
    { 10, "Trigger started: setpoint condition" 				"|de|Triggerstart durch Sollwert."  },
    { 11, "Trigger started: solenoid valve condition" 	"|de|Triggerstart durch MV-Bed."  },
    { 12, "Trigger started: valve position" 						"|de|Triggerstart durch Istwert."  },
    { 13, "Trigger started: setpoint deviation " 				"|de|Triggerstart durch Regeldifferenz"  },		
    { 14, "Trigger started: drive signal y" 						"|de|Triggerstart durch Stellsignal."  },
    { 15, "Trigger started: binary input" 							"|de|Triggerstart durch Binreingang."  },
    { 16, "Trigger started: condensed status" 					"|de|Triggerstart durch Sammelstatus."  },
    { 17, "Trigger started: binary input 1" 						"|de|Triggerstart durch Binreingang 1."  },
    { 18, "Trigger started: binary input 2" 						"|de|Triggerstart durch Binreingang 2."  },
	  { 19, "no binary input 2 exist" 						        "|de|Binreingang 2 nicht vorhanden."  }
 }
  HELP     "Shows the statuis of the data logger."
           "|de|Gibt den Status vom Datenlogger an.";
}

VARIABLE trans1_datalogger_counter_day
{
  LABEL    "Days" "|de|Tage";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE     0;
  }
  CONSTANT_UNIT "d";
  HELP     "Count of days";
}

VARIABLE trans1_datalogger_counter_hour
{
  LABEL    "Hours" "|de|Stunden";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
     DEFAULT_VALUE     0;
  }
  CONSTANT_UNIT "h";
  HELP     "Count of hours";
}

VARIABLE trans1_datalogger_counter_minute
{
  LABEL    "Minutes" "|de|Minuten";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
     DEFAULT_VALUE     0;
  }
  CONSTANT_UNIT "min";
  HELP     "Count of Minutes";
}

VARIABLE trans1_datalogger_counter_second
{
  LABEL    "Seconds" "|de|Sekunden";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
     DEFAULT_VALUE     0;
  }
  CONSTANT_UNIT "sec";
  HELP     "Count of Seconds";
}

VARIABLE trans1_datalogger_counter_msec
{
  LABEL    "Takt (1/10 s)" "|de|Takt (1/10 s)";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
     DEFAULT_VALUE     0;
  }
  CONSTANT_UNIT "1/10 sec";
  HELP     "Count of 1/10 seconds";
}

/* ------------------------------------------------------------------------ */
/* Histogramm - Ventilstellung X  Lang                                      */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 73..94
*/
VARIABLE trans1_X_Interval_Value_0
{
  LABEL    "x <= 0%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);

  CONSTANT_UNIT "%";
  HELP     "Classified valve position."
           "|de|Klassifizierter Ventilaufenthalt.";
}

trans1_X_Interval_Value_1 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "0% < x <= 5%"; }
trans1_X_Interval_Value_2 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "5% < x <= 10%"; }
trans1_X_Interval_Value_3 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "10% < x <= 15%"; }
trans1_X_Interval_Value_4 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "15% < x <= 20%"; }
trans1_X_Interval_Value_5 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "20% < x <= 25%"; }
trans1_X_Interval_Value_6 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "25% < x <= 30%"; }
trans1_X_Interval_Value_7 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "30% < x <= 35%"; }
trans1_X_Interval_Value_8 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "35% < x <= 40%"; }
trans1_X_Interval_Value_9 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "40% < x <= 45%"; }
trans1_X_Interval_Value_10 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "45% < x <= 50%"; }
trans1_X_Interval_Value_11 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "50% < x <= 55%"; }
trans1_X_Interval_Value_12 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "55% < x <= 60%"; }
trans1_X_Interval_Value_13 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "60% < x <= 65%"; }
trans1_X_Interval_Value_14 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "65% < x <= 70%"; }
trans1_X_Interval_Value_15 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "70% < x <= 75%"; }
trans1_X_Interval_Value_16 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "75% < x <= 80%"; }
trans1_X_Interval_Value_17 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "80% < x <= 85%"; }
trans1_X_Interval_Value_18 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "85% < x <= 90%"; }
trans1_X_Interval_Value_19 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "90% < x <= 95%"; }
trans1_X_Interval_Value_20 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "95% < x <= 100%"; }
trans1_X_Interval_Value_21 LIKE  VARIABLE  trans1_X_Interval_Value_0
{ REDEFINE LABEL "x > 100%"; }


/* ------------------------------------------------------------------------ */
/*
VARIABLE his_x_mittelwert_int_1 (unsigned_char_288)
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x)
*/
VARIABLE trans1_X_Average
{
  LABEL    "Average values x long" "|de|Mittelwert x Lang";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
/*  CONSTANT_UNIT "%";*/
  TYPE     ENUMERATED (1)
  {
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
    {  1, "x <= 0%"         },
    {  2, "0% < x <= 5%"    },
    {  3, "5% < x <= 10%"   },
    {  4, "10% < x <= 15%"  },
    {  5, "15% < x <= 20%"  },
    {  6, "20% < x <= 25%"  },
    {  7, "25% < x <= 30%"  },
    {  8, "30% < x <= 35%"  },
    {  9, "35% < x <= 40%"  },
    { 10, "40% < x <= 45%"  },
    { 11, "45% < x <= 50%"  },
    { 12, "50% < x <= 55%"  },
    { 13, "55% < x <= 60%"  },
    { 14, "60% < x <= 65%"  },
    { 15, "65% < x <= 70%"  },
    { 16, "70% < x <= 75%"  },
    { 17, "75% < x <= 80%"  },
    { 18, "80% < x <= 85%"  },
    { 19, "85% < x <= 90%"  },
    { 20, "90% < x <= 95%"  },
    { 21, "95% < x <= 100%" },
    { 22, "x > 100%"        }
  }
  HELP     "Information on the average interval assignment."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_x_anzahl_messpunkte (unsigned_long_34)
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x)
*/
VARIABLE trans1_Number_Mess_Points
{
  LABEL    "Number of measurement points" "|de|Anzahl";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  HELP     "Information on the previous recorded measured data."
           "|de|Angabe ber die bisher aufgenommenen Messwerte.";
}


/* ------------------------------------------------------------------------ */
/*       Histogramm - Regelabweichung  Lang                                     */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE e_interval_value_long_0 ... 21 (unsigned char 121..132)
*/
VARIABLE trans1_E_Interval_Value_0
{
  LABEL    "e  <= -5%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
}

trans1_E_Interval_Value_1 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "-5% < e  <= -1%"; }
trans1_E_Interval_Value_2 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "-1% < e  <= -0.5%"; }
trans1_E_Interval_Value_3 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "-0.5% < e  <= -0.2%"; }
trans1_E_Interval_Value_4 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "-0.2% < e  <= -0.1%"; }
trans1_E_Interval_Value_5 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "-0.1% < e  <= 0%"; }
trans1_E_Interval_Value_6 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "0% < e  <= 0.1%"; }
trans1_E_Interval_Value_7 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "0.1% < e  <= 0.2%"; }
trans1_E_Interval_Value_8 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "0.2% < e  <= 0.5%"; }
trans1_E_Interval_Value_9 LIKE   VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "0.5% < e  <= 1%"; }
trans1_E_Interval_Value_10 LIKE  VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "1% < e  <= 5%"; }
trans1_E_Interval_Value_11 LIKE  VARIABLE  trans1_E_Interval_Value_0
{ REDEFINE LABEL "e > 5%"; }



/* ------------------------------------------------------------------------ */
/*
VARIABLE mittelwert_e_lang (unsigned char 290)
*/
VARIABLE trans1_E_Average
{
  LABEL    "Average values e long" "|de|Mittelwert e Lang";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
    {  1, "e <= -5%"            },
    {  2, "-5% < e <= -1%"      },
    {  3, "-1% < e <= -0.5%"    },
    {  4, "-0.5% < e <= -0.2%"  },
    {  5, "-0.2% < e <= -0.1%"  },
    {  6, "-0.1% < e <= 0%"     },
    {  7, "0% < e <= 0.1%"      },
    {  8, "0.1% < e <= 0.2%"    },
    {  9, "0.2% < e <= 0.5%"    },
    { 10, "0.5% < e <= 1%"      },
    { 11, "1% < e <= 5%"        },
    { 12, "e > 5%"              }
  }
/*  CONSTANT_UNIT "%";*/

  HELP     "Information on the average interval assignment."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE gesamtanzahl (unsigned long 57)
*/
VARIABLE trans1_Total_Number_E
{
  LABEL    "Counter of all measured data" "|de|Gesamtanzahl";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  HELP     "Information on the previous recorded measured data."
           "|de|Angabe ber die bisher aufgenommenen klassifizierten Messwerte.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE deviation_min (float 7)
*/
VARIABLE trans1_deviation_min
{
  LABEL    "Min. setpoint deviation" "|de|Min. Regelabweichung";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Smallest measured setpoint deviation."
           "|de|Kleinste gemessene Regelabweichung.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE deviation_max (float 8)
*/
VARIABLE trans1_deviation_max
{
  LABEL    "Max. setpoint deviation" "|de|Max. Regelabweichung";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Greatest measured setpoint deviation."
           "|de|Grte gemessene Regelabweichung.";
}


/* ------------------------------------------------------------------------ */
/*     Histogramm - Zyklenzhler  Lang                                          */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 162..174
*/
VARIABLE trans1_Z_Interval_Value_0
{
  LABEL    "0% < cycle <= 2%" "|de|0% < Zyklus <= 2%";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
  HELP     "Classified cycle span is shown in percent of the interval "
           "positions."
           "|de|Klassifizierte Zyklenspanne wird als Prozentwert der "
           "Intervallaufenthalte angegeben.";

}

trans1_Z_Interval_Value_1  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "2% < cycle <= 5%" "|de|2% < Zyklus <= 5%"  ; }
trans1_Z_Interval_Value_2  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "5% < cycle <= 10%" "|de|5% < Zyklus <= 10%"  ; }
trans1_Z_Interval_Value_3  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "10% < cycle <= 20%" "|de|10% < Zyklus <= 20%"  ; }
trans1_Z_Interval_Value_4  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "20% < cycle <= 30%" "|de|20% < Zyklus <= 30%"  ; }
trans1_Z_Interval_Value_5  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "30% < cycle <= 40%" "|de|30% < Zyklus <= 40%"  ; }
trans1_Z_Interval_Value_6  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "40% < cycle <= 50%" "|de|40% < Zyklus <= 50%"  ; }
trans1_Z_Interval_Value_7  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "50% < cycle <= 60%" "|de|50% < Zyklus <= 60%"  ; }
trans1_Z_Interval_Value_8  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "60% < cycle <= 70%" "|de|60% < Zyklus <= 70%"  ; }
trans1_Z_Interval_Value_9  LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "70% < cycle <= 80%" "|de|70% < Zyklus <= 80%"  ; }
trans1_Z_Interval_Value_10 LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "80% < cycle <= 90%" "|de|80% < Zyklus <= 90%"  ; }
trans1_Z_Interval_Value_11 LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"  ; }
trans1_Z_Interval_Value_12 LIKE  VARIABLE  trans1_Z_Interval_Value_0
{ REDEFINE LABEL "Cycle > 100%" "|de|Zyklus > 100%"  ; }


/* ------------------------------------------------------------------------ */
/*
VARIABLE his_z_mittelwert_int (unsigned char 297; cmd 171/297)
*/
VARIABLE trans1_Z_Average
{
  LABEL    "Average values z long" "|de|Mittelwert z Lang";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    {  0, "No data read"        "|de|Keine Daten ausgelesen"   },
    {  1, "0% < cycle <= 2%"    "|de|0% < Zyklus <= 2%"        },
    {  2, "2% < cycle <= 5%"    "|de|2% < Zyklus <= 5%"        },
    {  3, "5% < cycle <= 10%"   "|de|5% < Zyklus <= 10%"       },
    {  4, "10% < cycle <= 20%"  "|de|10% < Zyklus <= 20%"      },
    {  5, "20% < cycle <= 30%"  "|de|20% < Zyklus <= 30%"      },
    {  6, "30% < cycle <= 40%"  "|de|30% < Zyklus <= 40%"      },
    {  7, "40% < cycle <= 50%"  "|de|40% < Zyklus <= 50%"      },
    {  8, "50% < cycle <= 60%"  "|de|50% < Zyklus <= 60%"      },
    {  9, "60% < cycle <= 70%"  "|de|60% < Zyklus <= 70%"      },
    { 10, "70% < cycle <= 80%"  "|de|70% < Zyklus <= 80%"      },
    { 11, "80% < cycle <= 90%"  "|de|80% < Zyklus <= 90%"      },
    { 12, "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"     },
    { 13, "Cycle > 100%"        "|de|Zyklus > 100%"            }
  }
/*  CONSTANT_UNIT "%";*/

  HELP     "Information on the average interval assignment."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE his_z_gesamtanzahl (unsigned long 70)
*/
VARIABLE trans1_Total_Number_Z
{
  LABEL    "Counter of all measured data" "|de|Gesamtanzahl";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4);
  HELP     "Information on the previous recorded measured data."
           "|de|Angabe ber die bisher aufgenommenen klassifizierten Messwerte.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE his_z_dynamic_stress_factor (unsigned char 11)
*/
VARIABLE trans1_Dynamic_Factor
{
  LABEL    "Dynamic stress factor" "|de|Dynamischer Belastungsfaktor";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
  HELP     "Status message, resulting from diagnosis analysis."
           "|de|Statusmeldung resultierend aus der Diagnoseauswertung.";
}



/* ------------------------------------------------------------------------ */
/* Histogramm - Ventilstellung X  Kurz                                      */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 95..116
*/
VARIABLE trans1_X_Interval_Value_0_KURZ
{
  LABEL    "x <= 0%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);

  CONSTANT_UNIT "%";
  HELP     "Classified valve position." "|de|Klassifizierter Ventilaufenthalt";
}

trans1_X_Interval_Value_1_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "0% < x <= 5%"; }
trans1_X_Interval_Value_2_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "5% < x <= 10%"; }
trans1_X_Interval_Value_3_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "10% < x <= 15%"; }
trans1_X_Interval_Value_4_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "15% < x <= 20%"; }
trans1_X_Interval_Value_5_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "20% < x <= 25%"; }
trans1_X_Interval_Value_6_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "25% < x <= 30%"; }
trans1_X_Interval_Value_7_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "30% < x <= 35%"; }
trans1_X_Interval_Value_8_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "35% < x <= 40%"; }
trans1_X_Interval_Value_9_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "40% < x <= 45%"; }
trans1_X_Interval_Value_10_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "45% < x <= 50%"; }
trans1_X_Interval_Value_11_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "50% < x <= 55%"; }
trans1_X_Interval_Value_12_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "55% < x <= 60%"; }
trans1_X_Interval_Value_13_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "60% < x <= 65%"; }
trans1_X_Interval_Value_14_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "65% < x <= 70%"; }
trans1_X_Interval_Value_15_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "70% < x <= 75%"; }
trans1_X_Interval_Value_16_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "75% < x <= 80%"; }
trans1_X_Interval_Value_17_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "80% < x <= 85%"; }
trans1_X_Interval_Value_18_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "85% < x <= 90%"; }
trans1_X_Interval_Value_19_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "90% < x <= 95%"; }
trans1_X_Interval_Value_20_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "95% < x <= 100%"; }
trans1_X_Interval_Value_21_KURZ LIKE  VARIABLE  trans1_X_Interval_Value_0_KURZ
{ REDEFINE LABEL "x > 100%"; }


/* ------------------------------------------------------------------------ */
/* unsigned_char_289
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x - Kz.)
*/
VARIABLE trans1_X_Average_KURZ
{
  LABEL    "Average values x short" "|de|Mittelwert x Kurz";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
    {  1, "x <= 0%"         },
    {  2, "0% < x <= 5%"    },
    {  3, "5% < x <= 10%"   },
    {  4, "10% < x <= 15%"  },
    {  5, "15% < x <= 20%"  },
    {  6, "20% < x <= 25%"  },
    {  7, "25% < x <= 30%"  },
    {  8, "30% < x <= 35%"  },
    {  9, "35% < x <= 40%"  },
    { 10, "40% < x <= 45%"  },
    { 11, "45% < x <= 50%"  },
    { 12, "50% < x <= 55%"  },
    { 13, "55% < x <= 60%"  },
    { 14, "60% < x <= 65%"  },
    { 15, "65% < x <= 70%"  },
    { 16, "70% < x <= 75%"  },
    { 17, "75% < x <= 80%"  },
    { 18, "80% < x <= 85%"  },
    { 19, "85% < x <= 90%"  },
    { 20, "90% < x <= 95%"  },
    { 21, "95% < x <= 100%" },
    { 22, "x > 100%"        }
  }
/*  CONSTANT_UNIT "%";*/

  HELP     "Classified valve position - recorded in a ring buffer of 100 values."
           "|de|Klassifizierter Ventilaufenthalt - aufgenommen in einem "
           "Ringpuffer von 100 Werten.";
}


/* ------------------------------------------------------------------------ */
/* unsigned_integer_196
(Diagnose - Beobachterfunktionen AUTO - Histogramm Ventilstellung x - Kz.)
*/
VARIABLE trans1_X_HIS_ABTASTRATE
{
  LABEL    "Scan rate short-term histogram"
           "|de|Abtastrate Kurzzeithistogramm";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
    MIN_VALUE 1; /* 1s */
    MAX_VALUE 3600; /* 3600s */
  }
  CONSTANT_UNIT "s";

  HELP     "Scan rate of the recording of the valve positions for the "
           "short-term histogram."
           "|de|Abtastrate der Aufnahme der Ventilstellungen fr das "
           "Kurzzeithistogramm.";
}



/* ------------------------------------------------------------------------ */
/*       Histogramm - Regelabweichung  Kurz                                     */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 133..144
*/
VARIABLE trans1_E_Interval_Value_0_KURZ
{
  LABEL    "e  <= -5%";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
}

trans1_E_Interval_Value_1_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "-5% < e  <= -1%"; }
trans1_E_Interval_Value_2_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "-1% < e  <= -0.5%"; }
trans1_E_Interval_Value_3_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "-0.5% < e  <= -0.2%"; }
trans1_E_Interval_Value_4_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "-0.2% < e  <= -0.1%"; }
trans1_E_Interval_Value_5_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "-0.1% < e  <= 0%"; }
trans1_E_Interval_Value_6_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "0% < e  <= 0.1%"; }
trans1_E_Interval_Value_7_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "0.1% < e  <= 0.2%"; }
trans1_E_Interval_Value_8_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "0.2% < e  <= 0.5%"; }
trans1_E_Interval_Value_9_KURZ LIKE   VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "0.5% < e  <= 1%"; }
trans1_E_Interval_Value_10_KURZ LIKE  VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "1% < e  <= 5%"; }
trans1_E_Interval_Value_11_KURZ LIKE  VARIABLE  trans1_E_Interval_Value_0_KURZ
{ REDEFINE LABEL "e > 5%"; }

/* ------------------------------------------------------------------------ */
/* unsigned_char_296
(Diagnose - Beobachterfunktionen AUTO - Histogramm Regelabweichung e - Kz.)
*/
VARIABLE trans1_E_Average_KURZ
{
  LABEL    "Average values e short" "|de|Mittelwert e Kurz";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    {  0, "No data read" "|de|Keine Daten ausgelesen" },
    {  1, "e <= -5%"            },
    {  2, "-5% < e <= -1%"      },
    {  3, "-1% < e <= -0.5%"    },
    {  4, "-0.5% < e <= -0.2%"  },
    {  5, "-0.2% < e <= -0.1%"  },
    {  6, "-0.1% < e <= 0%"     },
    {  7, "0% < e <= 0.1%"      },
    {  8, "0.1% < e <= 0.2%"    },
    {  9, "0.2% < e <= 0.5%"    },
    { 10, "0.5% < e <= 1%"      },
    { 11, "1% < e <= 5%"        },
    { 12, "e > 5%"              }
  }
/*  CONSTANT_UNIT "%";*/

  HELP     "Classified setpoint deviation - recorded in a ring buffer of 100 values."
           "|de|Klassifizierte Regelabweichung - aufgenommen in einem "
           "Ringpuffer von 100 Werten.";
}

/* ------------------------------------------------------------------------ */
/* unsigned_integer_198
(Diagnose - Beobachterfunktionen AUTO - Histogramm Regelabweichung e - Kz.)
*/
VARIABLE trans1_E_HIS_ABTASTRATE
{
  LABEL    "Scan rate short-term histogram"
           "|de|Abtastrate Kurzzeithistogramm";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
    MIN_VALUE 1; /* 1s */
    MAX_VALUE 3600; /* 3600s */
  }
  CONSTANT_UNIT "s";

  HELP     "Scan rate of the recording of the setpoint deviations for the "
           "short-term histogram."
           "|de|Abtastrate der Aufnahme der Regelabweichungen fr das "
           "Kurzzeithistogramm.";
}


/* ------------------------------------------------------------------------ */
/*     Histogramm - Zyklenzhler  Kurz                                      */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* unsigned char 175..187
*/
VARIABLE trans1_Z_Interval_Value_0_KURZ
{
  LABEL    "0% < cycle <= 2%" "|de|0% < Zyklus <= 2%";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
  HELP     "Classified cycle span is shown in percent of the interval "
           "positions."
           "|de|Klassifizierte Zyklenspanne wird als Prozentwert der "
           "Intervallaufenthalte angegeben.";

}

trans1_Z_Interval_Value_1_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "2% < cycle <= 5%" "|de|2% < Zyklus <= 5%"  ; }
trans1_Z_Interval_Value_2_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "5% < cycle <= 10%" "|de|5% < Zyklus <= 10%"  ; }
trans1_Z_Interval_Value_3_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "10% < cycle <= 20%" "|de|10% < Zyklus <= 20%"  ; }
trans1_Z_Interval_Value_4_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "20% < cycle <= 30%" "|de|20% < Zyklus <= 30%"  ; }
trans1_Z_Interval_Value_5_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "30% < cycle <= 40%" "|de|30% < Zyklus <= 40%"  ; }
trans1_Z_Interval_Value_6_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "40% < cycle <= 50%" "|de|40% < Zyklus <= 50%"  ; }
trans1_Z_Interval_Value_7_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "50% < cycle <= 60%" "|de|50% < Zyklus <= 60%"  ; }
trans1_Z_Interval_Value_8_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "60% < cycle <= 70%" "|de|60% < Zyklus <= 70%"  ; }
trans1_Z_Interval_Value_9_KURZ  LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "70% < cycle <= 80%" "|de|70% < Zyklus <= 80%"  ; }
trans1_Z_Interval_Value_10_KURZ LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "80% < cycle <= 90%" "|de|80% < Zyklus <= 90%"  ; }
trans1_Z_Interval_Value_11_KURZ LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"  ; }
trans1_Z_Interval_Value_12_KURZ LIKE  VARIABLE  trans1_Z_Interval_Value_0_KURZ
{ REDEFINE LABEL "Cycle > 100%" "|de|Zyklus > 100%"  ; }

/* ------------------------------------------------------------------------ */
/* unsigned_char_298
(Diagnose - Beobachterfunktionen AUTO - Histogramm Zyklenzhler z - Kz.)
*/
VARIABLE trans1_Z_Average_KURZ
{
  LABEL    "Average values z short" "|de|Mittelwert z Kurz";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
/*  CONSTANT_UNIT "%";*/
  TYPE     ENUMERATED (1)
  {
    {  0, "No data read"        "|de|Keine Daten ausgelesen"   },
    {  1, "0% < cycle <= 2%"    "|de|0% < Zyklus <= 2%"        },
    {  2, "2% < cycle <= 5%"    "|de|2% < Zyklus <= 5%"        },
    {  3, "5% < cycle <= 10%"   "|de|5% < Zyklus <= 10%"       },
    {  4, "10% < cycle <= 20%"  "|de|10% < Zyklus <= 20%"      },
    {  5, "20% < cycle <= 30%"  "|de|20% < Zyklus <= 30%"      },
    {  6, "30% < cycle <= 40%"  "|de|30% < Zyklus <= 40%"      },
    {  7, "40% < cycle <= 50%"  "|de|40% < Zyklus <= 50%"      },
    {  8, "50% < cycle <= 60%"  "|de|50% < Zyklus <= 60%"      },
    {  9, "60% < cycle <= 70%"  "|de|60% < Zyklus <= 70%"      },
    { 10, "70% < cycle <= 80%"  "|de|70% < Zyklus <= 80%"      },
    { 11, "80% < cycle <= 90%"  "|de|80% < Zyklus <= 90%"      },
    { 12, "90% < cycle <= 100%" "|de|90% < Zyklus <= 100%"     },
    { 13, "Cycle > 100%"        "|de|Zyklus > 100%"            }
  }
  HELP     "Information on the average interval assignment, formed over "
           "the recorded values of the ring buffer."
           "|de|Angabe ber die gemittelten Intervallzugehrigkeiten, "
           "gebildet ber die aufgenommenen Werte im Ringpuffer.";
}


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Stationaer Lang                                          */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* float 46..67
*/
VARIABLE trans1_stationaer_lang_Value_0
{
  LABEL    "Average value - 1 (x <= 0 % )"
           "|de|Mittelwert - 1 ( x <= 0 % )";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "1/s";
}

trans1_stationaer_lang_Value_1 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 2 ( 0 % <x <= 5 % )"
                 "|de|Mittelwert - 2 ( 0 % < x <= 5 % )"; }
trans1_stationaer_lang_Value_2 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 3 ( 5 % <x <= 10 % )"
                 "|de|Mittelwert - 3 ( 5 % < x <= 10 % )"; }
trans1_stationaer_lang_Value_3 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 4 ( 10 % <x <= 15 % )"
                 "|de|Mittelwert - 4 ( 10 % < x <= 15 % )"; }
trans1_stationaer_lang_Value_4 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 5 ( 15 % <x <= 20 % )"
                 "|de|Mittelwert - 5 ( 15 % < x <= 20 % )"; }
trans1_stationaer_lang_Value_5 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 6 ( 20 % <x <= 25 % )"
                 "|de|Mittelwert - 6 ( 20 % < x <= 25 % )"; }
trans1_stationaer_lang_Value_6 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 7 ( 25 % <x <= 30 % )"
                 "|de|Mittelwert - 7 ( 25 % < x <= 30 % )"; }
trans1_stationaer_lang_Value_7 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 8 ( 30 % <x <= 35 % )"
                 "|de|Mittelwert - 8 ( 30 % < x <= 35 % )"; }
trans1_stationaer_lang_Value_8 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 9 ( 35 % <x <= 40 % )"
                 "|de|Mittelwert - 9 ( 35 % < x <= 40 % )"; }
trans1_stationaer_lang_Value_9 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 10 ( 40 % <x <= 45 % )"
                 "|de|Mittelwert - 10 ( 40 % < x <= 45 % )"; }
trans1_stationaer_lang_Value_10 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 11 ( 45 % <x <= 50 % )"
                 "|de|Mittelwert - 11 ( 45 % < x <= 50 % )"; }
trans1_stationaer_lang_Value_11 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 12 ( 50 % <x <= 55 % )"
                 "|de|Mittelwert - 12 ( 50 % < x <= 55 % )"; }
trans1_stationaer_lang_Value_12 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 13 ( 55 % <x <= 60 % )"
                 "|de|Mittelwert - 13 ( 55 % < x <= 60 % )"; }
trans1_stationaer_lang_Value_13 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 14 ( 60 % <x <= 65 % )"
                 "|de|Mittelwert - 14 ( 60 % < x <= 65 % )"; }
trans1_stationaer_lang_Value_14 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 15 ( 65 % <x <= 70 % )"
                 "|de|Mittelwert - 15 ( 65 % < x <= 70 % )"; }
trans1_stationaer_lang_Value_15 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 16 ( 70 % <x <= 75 % )"
                 "|de|Mittelwert - 16 ( 70 % < x <= 75 % )"; }
trans1_stationaer_lang_Value_16 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 17 ( 75 % <x <= 80 % )"
                 "|de|Mittelwert - 17 ( 75 % < x <= 80 % )"; }
trans1_stationaer_lang_Value_17 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 18 ( 80 % <x <= 85 % )"
                 "|de|Mittelwert - 18 ( 80 % < x <= 85 % )"; }
trans1_stationaer_lang_Value_18 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 19 ( 85 % <x <= 90 % )"
                 "|de|Mittelwert - 19 ( 85 % < x <= 90 % )"; }
trans1_stationaer_lang_Value_19 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 20 ( 90 % <x <= 95 % )"
                 "|de|Mittelwert - 20 ( 90 % < x <= 95 % )"; }
trans1_stationaer_lang_Value_20 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 21 ( 95 % <x <= 100 % )"
                 "|de|Mittelwert - 21 ( 95 % < x <= 100 % )"; }
trans1_stationaer_lang_Value_21 LIKE   VARIABLE  trans1_stationaer_lang_Value_0
{ REDEFINE LABEL "Average value - 22 ( x > 100 % )"
                 "|de|Mittelwert - 22 ( x > 100 % )"; }



/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Stationaer Kurz                                          */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* float 68...89
*/
VARIABLE trans1_stationaer_kurz_Value_0
{
  LABEL    "Average value - 1 (x <= 0 % )"
           "|de|Mittelwert - 1 ( x <= 0 % )";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "4.1f";
  }
  CONSTANT_UNIT "1/s";

  HELP     "Average value, formed over all measured data inside the interval."
           "|de|Mittelwert gebildet ber alle Messwerte innerhalb eines Intervalls.";
}

trans1_stationaer_kurz_Value_1 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 2 ( 0 % <x <= 5 % )"
                 "|de|Mittelwert - 2 ( 0 % < x <= 5 % )"; }
trans1_stationaer_kurz_Value_2 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 3 ( 5 % <x <= 10 % )"
                 "|de|Mittelwert - 3 ( 5 % < x <= 10 % )"; }
trans1_stationaer_kurz_Value_3 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 4 ( 10 % <x <= 15 % )"
                 "|de|Mittelwert - 4 ( 10 % < x <= 15 % )"; }
trans1_stationaer_kurz_Value_4 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 5 ( 15 % <x <= 20 % )"
                 "|de|Mittelwert - 5 ( 15 % < x <= 20 % )"; }
trans1_stationaer_kurz_Value_5 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 6 ( 20 % <x <= 25 % )"
                 "|de|Mittelwert - 6 ( 20 % < x <= 25 % )"; }
trans1_stationaer_kurz_Value_6 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 7 ( 25 % <x <= 30 % )"
                 "|de|Mittelwert - 7 ( 25 % < x <= 30 % )"; }
trans1_stationaer_kurz_Value_7 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 8 ( 30 % <x <= 35 % )"
                 "|de|Mittelwert - 8 ( 30 % < x <= 35 % )"; }
trans1_stationaer_kurz_Value_8 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 9 ( 35 % <x <= 40 % )"
                 "|de|Mittelwert - 9 ( 35 % < x <= 40 % )"; }
trans1_stationaer_kurz_Value_9 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 10 ( 40 % <x <= 45 % )"
                 "|de|Mittelwert - 10 ( 40 % < x <= 45 % )"; }
trans1_stationaer_kurz_Value_10 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 11 ( 45 % <x <= 50 % )"
                 "|de|Mittelwert - 11 ( 45 % < x <= 50 % )"; }
trans1_stationaer_kurz_Value_11 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 12 ( 50 % <x <= 55 % )"
                 "|de|Mittelwert - 12 ( 50 % < x <= 55 % )"; }
trans1_stationaer_kurz_Value_12 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 13 ( 55 % <x <= 60 % )"
                 "|de|Mittelwert - 13 ( 55 % < x <= 60 % )"; }
trans1_stationaer_kurz_Value_13 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 14 ( 60 % <x <= 65 % )"
                 "|de|Mittelwert - 14 ( 60 % < x <= 65 % )"; }
trans1_stationaer_kurz_Value_14 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 15 ( 65 % <x <= 70 % )"
                 "|de|Mittelwert - 15 ( 65 % < x <= 70 % )"; }
trans1_stationaer_kurz_Value_15 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 16 ( 70 % <x <= 75 % )"
                 "|de|Mittelwert - 16 ( 70 % < x <= 75 % )"; }
trans1_stationaer_kurz_Value_16 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 17 ( 75 % <x <= 80 % )"
                 "|de|Mittelwert - 17 ( 75 % < x <= 80 % )"; }
trans1_stationaer_kurz_Value_17 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 18 ( 80 % <x <= 85 % )"
                 "|de|Mittelwert - 18 ( 80 % < x <= 85 % )"; }
trans1_stationaer_kurz_Value_18 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 19 ( 85 % <x <= 90 % )"
                 "|de|Mittelwert - 19 ( 85 % < x <= 90 % )"; }
trans1_stationaer_kurz_Value_19 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 20 ( 90 % <x <= 95 % )"
                 "|de|Mittelwert - 20 ( 90 % < x <= 95 % )"; }
trans1_stationaer_kurz_Value_20 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 21 ( 95 % <x <= 100 % )"
                 "|de|Mittelwert - 21 ( 95 % < x <= 100 % )"; }
trans1_stationaer_kurz_Value_21 LIKE   VARIABLE  trans1_stationaer_kurz_Value_0
{ REDEFINE LABEL "Average value - 22 ( x > 100 % )"
                 "|de|Mittelwert - 22 ( x > 100 % )"; }



/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Stationaer Kurz RP Stellsignal                           */
/* (unsigned integer 30..39) */
/* ------------------------------------------------------------------------ */

VARIABLE trans1_stat_stellsignal_Value_0
{
  LABEL    "Drive signal - value 1" "|de|Stellsignal - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";
  HELP     "Currently recorded drive signal." "|de|Aktuell aufgenommenes Stellsignal.";
}

trans1_stat_stellsignal_Value_1 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 2" "|de|Stellsignal - Wert 2"; }
trans1_stat_stellsignal_Value_2 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 3" "|de|Stellsignal - Wert 3"; }
trans1_stat_stellsignal_Value_3 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 4" "|de|Stellsignal - Wert 4"; }
trans1_stat_stellsignal_Value_4 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 5" "|de|Stellsignal - Wert 5"; }
trans1_stat_stellsignal_Value_5 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 6" "|de|Stellsignal - Wert 6"; }
trans1_stat_stellsignal_Value_6 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 7" "|de|Stellsignal - Wert 7"; }
trans1_stat_stellsignal_Value_7 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 8" "|de|Stellsignal - Wert 8"; }
trans1_stat_stellsignal_Value_8 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 9" "|de|Stellsignal - Wert 9"; }
trans1_stat_stellsignal_Value_9 		LIKE  VARIABLE  		trans1_stat_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 10" "|de|Stellsignal - Wert 10"; }


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Stationaer Kurz RP Ventilstellung                        */
/* (float 90..99) */
/* ------------------------------------------------------------------------ */

VARIABLE trans1_stat_ventilstellung_Value_0
{
  LABEL    "Valve position - value 1" "|de|Ventilstellung - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Currently recorded valve position." "|de|Aktuell aufgenommene Ventilstellung.";
}

trans1_stat_ventilstellung_Value_1 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 2" "|de|Ventilstellung - Wert 2"; }
trans1_stat_ventilstellung_Value_2 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 3" "|de|Ventilstellung - Wert 3"; }
trans1_stat_ventilstellung_Value_3 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 4" "|de|Ventilstellung - Wert 4"; }
trans1_stat_ventilstellung_Value_4 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 5" "|de|Ventilstellung - Wert 5"; }
trans1_stat_ventilstellung_Value_5 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 6" "|de|Ventilstellung - Wert 6"; }
trans1_stat_ventilstellung_Value_6 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 7" "|de|Ventilstellung - Wert 7"; }
trans1_stat_ventilstellung_Value_7 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 8" "|de|Ventilstellung - Wert 8"; }
trans1_stat_ventilstellung_Value_8 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 9" "|de|Ventilstellung - Wert 9"; }
trans1_stat_ventilstellung_Value_9 		LIKE  VARIABLE  		trans1_stat_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 10" "|de|Ventilstellung - Wert 10"; }


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Hysterese Lang                                           */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* float 100..118
*/
VARIABLE trans1_hysterese_lang_Value_0
{
  LABEL    "Average value - 1 ( 3 % <x <= 8 % )"
           "|de|Mittelwert - 1 ( 3 % < x <= 8 % )";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "1/s";
}

trans1_hysterese_lang_Value_1 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 2 ( 8 % <x <= 13 % )"
                 "|de|Mittelwert - 2 ( 8 % < x <= 13 % )"; }
trans1_hysterese_lang_Value_2 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 3 ( 13 % <x <= 18 % )"
                 "|de|Mittelwert - 3 ( 13 % < x <= 18 % )"; }
trans1_hysterese_lang_Value_3 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 4 ( 18 % <x <= 23 % )"
                 "|de|Mittelwert - 4 ( 18 % < x <= 23 % )"; }
trans1_hysterese_lang_Value_4 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 5 ( 23 % <x <= 28 % )"
                 "|de|Mittelwert - 5 ( 23 % < x <= 28 % )"; }
trans1_hysterese_lang_Value_5 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 6 ( 28 % <x <= 33 % )"
                 "|de|Mittelwert - 6 ( 28 % < x <= 33 % )"; }
trans1_hysterese_lang_Value_6 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 7 ( 33 % <x <= 38 % )"
                 "|de|Mittelwert - 7 ( 33 % < x <= 38 % )"; }
trans1_hysterese_lang_Value_7 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 8 ( 38 % <x <= 43 % )"
                 "|de|Mittelwert - 8 ( 38 % < x <= 43 % )"; }
trans1_hysterese_lang_Value_8 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 9 ( 43 % <x <= 48 % )"
                 "|de|Mittelwert - 9 ( 43 % < x <= 48 % )"; }
trans1_hysterese_lang_Value_9 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 10 ( 48 % <x <= 53 % )"
                 "|de|Mittelwert - 10 ( 48 % < x <= 53 % )"; }
trans1_hysterese_lang_Value_10 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 11 ( 53 % <x <= 58 % )"
                 "|de|Mittelwert - 11 ( 53 % < x <= 58 % )"; }
trans1_hysterese_lang_Value_11 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 12 ( 58 % <x <= 63 % )"
                 "|de|Mittelwert - 12 ( 58 % < x <= 63 % )"; }
trans1_hysterese_lang_Value_12 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 13 ( 63 % <x <= 68 % )"
                 "|de|Mittelwert - 13 ( 63 % < x <= 68 % )"; }
trans1_hysterese_lang_Value_13 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 14 ( 68 % <x <= 73 % )"
                 "|de|Mittelwert - 14 ( 68 % < x <= 73 % )"; }
trans1_hysterese_lang_Value_14 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 15 ( 73 % <x <= 78 % )"
                 "|de|Mittelwert - 15 ( 73 % < x <= 78 % )"; }
trans1_hysterese_lang_Value_15 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 16 ( 78 % <x <= 83 % )"
                 "|de|Mittelwert - 16 ( 78 % < x <= 83 % )"; }
trans1_hysterese_lang_Value_16 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 17 ( 83 % <x <= 88 % )"
                 "|de|Mittelwert - 17 ( 83 % < x <= 88 % )"; }
trans1_hysterese_lang_Value_17 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 18 ( 88 % <x <= 93 % )"
                 "|de|Mittelwert - 18 ( 88 % < x <= 93 % )"; }
trans1_hysterese_lang_Value_18 LIKE   VARIABLE  trans1_hysterese_lang_Value_0
{ REDEFINE LABEL "Average value - 19 ( 93 % <x <= 98 % )"
                 "|de|Mittelwert - 19 ( 93 % < x <= 98 % )"; }



/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Hysterese Kurz RP Differenz Stellsignal                  */
/* (unsigned integer 40..49) */
/* ------------------------------------------------------------------------ */

VARIABLE trans1_hys_stellsignal_Value_0
{
  LABEL    "Drive signal - value 1" "|de|Stellsignal - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";
  HELP     "Hysteresis at the valve position." "|de|Hysteresebreite an der Ventilstellung.";
}

trans1_hys_stellsignal_Value_1 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 2" "|de|Stellsignal - Wert 2"; }
trans1_hys_stellsignal_Value_2 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 3" "|de|Stellsignal - Wert 3"; }
trans1_hys_stellsignal_Value_3 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 4" "|de|Stellsignal - Wert 4"; }
trans1_hys_stellsignal_Value_4 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 5" "|de|Stellsignal - Wert 5"; }
trans1_hys_stellsignal_Value_5 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 6" "|de|Stellsignal - Wert 6"; }
trans1_hys_stellsignal_Value_6 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 7" "|de|Stellsignal - Wert 7"; }
trans1_hys_stellsignal_Value_7 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 8" "|de|Stellsignal - Wert 8"; }
trans1_hys_stellsignal_Value_8 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 9" "|de|Stellsignal - Wert 9"; }
trans1_hys_stellsignal_Value_9 		LIKE  VARIABLE  		trans1_hys_stellsignal_Value_0
{ REDEFINE LABEL "Drive signal - value 10" "|de|Stellsignal - Wert 10"; }


/* ------------------------------------------------------------------------ */
/* Stellsignal Y - Hysterese Kurz RP Ventilstellung                         */
/* (float 144..153) */
/* ------------------------------------------------------------------------ */

VARIABLE trans1_hys_ventilstellung_Value_0
{
  LABEL    "Valve position - value 1" "|de|Ventilstellung - Wert 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Valve position." "|de|Ventilstellung.";
}

trans1_hys_ventilstellung_Value_1 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 2" "|de|Ventilstellung - Wert 2"; }
trans1_hys_ventilstellung_Value_2 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 3" "|de|Ventilstellung - Wert 3"; }
trans1_hys_ventilstellung_Value_3 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 4" "|de|Ventilstellung - Wert 4"; }
trans1_hys_ventilstellung_Value_4 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 5" "|de|Ventilstellung - Wert 5"; }
trans1_hys_ventilstellung_Value_5 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 6" "|de|Ventilstellung - Wert 6"; }
trans1_hys_ventilstellung_Value_6 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 7" "|de|Ventilstellung - Wert 7"; }
trans1_hys_ventilstellung_Value_7 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 8" "|de|Ventilstellung - Wert 8"; }
trans1_hys_ventilstellung_Value_8 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 9" "|de|Ventilstellung - Wert 9"; }
trans1_hys_ventilstellung_Value_9 		LIKE  VARIABLE  		trans1_hys_ventilstellung_Value_0
{ REDEFINE LABEL "Valve position - value 10" "|de|Ventilstellung - Wert 10"; }


/* ------------------------------------------------------------------------ */
/* Endlagentrend - Ventilstellung                                           */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/* float 185...214
*/
VARIABLE trans1_et_ventil_Value_0
{
  LABEL    "Valve position - meas. point 1" "|de|Ventilstellung x - Messpunkt 1";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";

  HELP     "Valve position at activated lower end position."
           "|de|Ventilstellung bei Aktivierung der unteren Endlage.";
}

trans1_et_ventil_Value_1  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 2" "|de|Ventilstellung x - Messpunkt 2"; }
trans1_et_ventil_Value_2  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 3" "|de|Ventilstellung x - Messpunkt 3"; }
trans1_et_ventil_Value_3  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 4" "|de|Ventilstellung x - Messpunkt 4"; }
trans1_et_ventil_Value_4  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 5" "|de|Ventilstellung x - Messpunkt 5"; }
trans1_et_ventil_Value_5  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 6" "|de|Ventilstellung x - Messpunkt 6"; }
trans1_et_ventil_Value_6  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 7" "|de|Ventilstellung x - Messpunkt 7"; }
trans1_et_ventil_Value_7  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 8" "|de|Ventilstellung x - Messpunkt 8"; }
trans1_et_ventil_Value_8  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 9" "|de|Ventilstellung x - Messpunkt 9"; }
trans1_et_ventil_Value_9  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 10" "|de|Ventilstellung x - Messpunkt 10"; }
trans1_et_ventil_Value_10  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 11" "|de|Ventilstellung x - Messpunkt 11"; }
trans1_et_ventil_Value_11  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 12" "|de|Ventilstellung x - Messpunkt 12"; }
trans1_et_ventil_Value_12  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 13" "|de|Ventilstellung x - Messpunkt 13"; }
trans1_et_ventil_Value_13  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 14" "|de|Ventilstellung x - Messpunkt 14"; }
trans1_et_ventil_Value_14  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 15" "|de|Ventilstellung x - Messpunkt 15"; }
trans1_et_ventil_Value_15  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 16" "|de|Ventilstellung x - Messpunkt 16"; }
trans1_et_ventil_Value_16  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 17" "|de|Ventilstellung x - Messpunkt 17"; }
trans1_et_ventil_Value_17  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 18" "|de|Ventilstellung x - Messpunkt 18"; }
trans1_et_ventil_Value_18  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 19" "|de|Ventilstellung x - Messpunkt 19"; }
trans1_et_ventil_Value_19  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 20" "|de|Ventilstellung x - Messpunkt 20"; }
trans1_et_ventil_Value_20  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 21" "|de|Ventilstellung x - Messpunkt 21"; }
trans1_et_ventil_Value_21  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 22" "|de|Ventilstellung x - Messpunkt 22"; }
trans1_et_ventil_Value_22  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 23" "|de|Ventilstellung x - Messpunkt 23"; }
trans1_et_ventil_Value_23  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 24" "|de|Ventilstellung x - Messpunkt 24"; }
trans1_et_ventil_Value_24  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 25" "|de|Ventilstellung x - Messpunkt 25"; }
trans1_et_ventil_Value_25  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 26" "|de|Ventilstellung x - Messpunkt 26"; }
trans1_et_ventil_Value_26  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 27" "|de|Ventilstellung x - Messpunkt 27"; }
trans1_et_ventil_Value_27  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 28" "|de|Ventilstellung x - Messpunkt 28"; }
trans1_et_ventil_Value_28  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 29" "|de|Ventilstellung x - Messpunkt 29"; }
trans1_et_ventil_Value_29  LIKE  VARIABLE  trans1_et_ventil_Value_0
{ REDEFINE LABEL "Valve position - meas. point 30" "|de|Ventilstellung x - Messpunkt 30"; }


VARIABLE trans1_et_ventil_refwert
{
  LABEL    "Reference value - valve position" "|de|Referenzwert - Ventilstellung";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DEFAULT_VALUE   0.0;
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "%";

  HELP     "Recorded reference valve position in the lower end position."
           "|de|Aufgenommene Referenzventilstellung in der unteren Endlage.";
}


/* ------------------------------------------------------------------------ */
/* Endlagentrend - Betriebsstundenzaehler                                   */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/* unsigned long 160...189
*/
VARIABLE trans1_et_BSZ_Value_0
{
  LABEL    "Lower end position EHM 1" "|de|Untere Endlage BSZ 1";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0;
     DISPLAY_FORMAT ".2f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  HELP     "Time of activating lower end position."
           "|de|Zeit bei Aktivierung der unteren Endlage.";
}


trans1_et_BSZ_Value_1  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 2" "|de|Untere Endlage BSZ 2"; }
trans1_et_BSZ_Value_2  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 3" "|de|Untere Endlage BSZ 3"; }
trans1_et_BSZ_Value_3  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 4" "|de|Untere Endlage BSZ 4"; }
trans1_et_BSZ_Value_4  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 5" "|de|Untere Endlage BSZ 5"; }
trans1_et_BSZ_Value_5  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 6" "|de|Untere Endlage BSZ 6"; }
trans1_et_BSZ_Value_6  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 7" "|de|Untere Endlage BSZ 7"; }
trans1_et_BSZ_Value_7  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 8" "|de|Untere Endlage BSZ 8"; }
trans1_et_BSZ_Value_8  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 9" "|de|Untere Endlage BSZ 9"; }
trans1_et_BSZ_Value_9  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 10" "|de|Untere Endlage BSZ 10"; }
trans1_et_BSZ_Value_10  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 11" "|de|Untere Endlage BSZ 11"; }
trans1_et_BSZ_Value_11  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 12" "|de|Untere Endlage BSZ 12"; }
trans1_et_BSZ_Value_12  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 13" "|de|Untere Endlage BSZ 13"; }
trans1_et_BSZ_Value_13  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 14" "|de|Untere Endlage BSZ 14"; }
trans1_et_BSZ_Value_14  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 15" "|de|Untere Endlage BSZ 15"; }
trans1_et_BSZ_Value_15  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 16" "|de|Untere Endlage BSZ 16"; }
trans1_et_BSZ_Value_16  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 17" "|de|Untere Endlage BSZ 17"; }
trans1_et_BSZ_Value_17  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 18" "|de|Untere Endlage BSZ 18"; }
trans1_et_BSZ_Value_18  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 19" "|de|Untere Endlage BSZ 19"; }
trans1_et_BSZ_Value_19  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 20" "|de|Untere Endlage BSZ 20"; }
trans1_et_BSZ_Value_20  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 21" "|de|Untere Endlage BSZ 21"; }
trans1_et_BSZ_Value_21  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 22" "|de|Untere Endlage BSZ 22"; }
trans1_et_BSZ_Value_22  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 23" "|de|Untere Endlage BSZ 23"; }
trans1_et_BSZ_Value_23  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 24" "|de|Untere Endlage BSZ 24"; }
trans1_et_BSZ_Value_24  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 25" "|de|Untere Endlage BSZ 25"; }
trans1_et_BSZ_Value_25  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 26" "|de|Untere Endlage BSZ 26"; }
trans1_et_BSZ_Value_26  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 27" "|de|Untere Endlage BSZ 27"; }
trans1_et_BSZ_Value_27  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 28" "|de|Untere Endlage BSZ 28"; }
trans1_et_BSZ_Value_28  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 29" "|de|Untere Endlage BSZ 29"; }
trans1_et_BSZ_Value_29  LIKE  VARIABLE  trans1_et_BSZ_Value_0
{ REDEFINE LABEL "Lower end position EHM 30" "|de|Untere Endlage BSZ 30"; }

VARIABLE trans1_et_BSZ_refwert
{
  LABEL    "Lower end position reference value EHM" "|de|Untere Endlage Referenzwert BSZ";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0;
     DISPLAY_FORMAT ".2f";
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  HELP     "Time of reference value in the lower end position."
           "|de|Zeit vom Referenzwert in der unteren Endlage.";
}


/* ------------------------------------------------------------------------ */
/* Endlagentrend - Endlage                                                  */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/* unsigned integer 50...79
*/
VARIABLE trans1_et_endlage_Value_0
{
  LABEL    "Lower end position drive signal 1" "|de|Untere Endlage Stellsignal 1";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";

  HELP     "Drive signal y at activated lower end position."
           "|de|Stellsignal y bei Aktivierung der unteren Endlage.";
}

trans1_et_endlage_Value_1 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 2" "|de|Untere Endlage Stellsignal 2"; }
trans1_et_endlage_Value_2 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 3" "|de|Untere Endlage Stellsignal 3"; }
trans1_et_endlage_Value_3 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 4" "|de|Untere Endlage Stellsignal 4"; }
trans1_et_endlage_Value_4 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 5" "|de|Untere Endlage Stellsignal 5"; }
trans1_et_endlage_Value_5 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 6" "|de|Untere Endlage Stellsignal 6"; }
trans1_et_endlage_Value_6 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 7" "|de|Untere Endlage Stellsignal 7"; }
trans1_et_endlage_Value_7 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 8" "|de|Untere Endlage Stellsignal 8"; }
trans1_et_endlage_Value_8 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 9" "|de|Untere Endlage Stellsignal 9"; }
trans1_et_endlage_Value_9 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 10" "|de|Untere Endlage Stellsignal 10"; }
trans1_et_endlage_Value_10 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 11" "|de|Untere Endlage Stellsignal 11"; }
trans1_et_endlage_Value_11 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 12" "|de|Untere Endlage Stellsignal 12"; }
trans1_et_endlage_Value_12 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 13" "|de|Untere Endlage Stellsignal 13"; }
trans1_et_endlage_Value_13 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 14" "|de|Untere Endlage Stellsignal 14"; }
trans1_et_endlage_Value_14 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 15" "|de|Untere Endlage Stellsignal 15"; }
trans1_et_endlage_Value_15 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 16" "|de|Untere Endlage Stellsignal 16"; }
trans1_et_endlage_Value_16 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 17" "|de|Untere Endlage Stellsignal 17"; }
trans1_et_endlage_Value_17 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 18" "|de|Untere Endlage Stellsignal 18"; }
trans1_et_endlage_Value_18 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 19" "|de|Untere Endlage Stellsignal 19"; }
trans1_et_endlage_Value_19 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 20" "|de|Untere Endlage Stellsignal 20"; }
trans1_et_endlage_Value_20 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 21" "|de|Untere Endlage Stellsignal 21"; }
trans1_et_endlage_Value_21 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 22" "|de|Untere Endlage Stellsignal 22"; }
trans1_et_endlage_Value_22 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 23" "|de|Untere Endlage Stellsignal 23"; }
trans1_et_endlage_Value_23 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 24" "|de|Untere Endlage Stellsignal 24"; }
trans1_et_endlage_Value_24 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 25" "|de|Untere Endlage Stellsignal 25"; }
trans1_et_endlage_Value_25 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 26" "|de|Untere Endlage Stellsignal 26"; }
trans1_et_endlage_Value_26 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 27" "|de|Untere Endlage Stellsignal 27"; }
trans1_et_endlage_Value_27 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 28" "|de|Untere Endlage Stellsignal 28"; }
trans1_et_endlage_Value_28 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 29" "|de|Untere Endlage Stellsignal 29"; }
trans1_et_endlage_Value_29 LIKE  VARIABLE  trans1_et_endlage_Value_0
{ REDEFINE LABEL "Lower end position drive signal 30" "|de|Untere Endlage Stellsignal 30"; }

VARIABLE trans1_et_endlage_refwert
{
  LABEL    "Trend of travel end position drive signal reference" "|de|Endlage unten Referenzwert Stellsignal";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";

/*  HELP     "."
           "|de|.";*/
}


/*-------------------------------- Diagnose Testinfo -------------------------------------*/

/* unsigned char 117 */
VARIABLE trans1_diag_testinfo
{
  LABEL    "Diagnosis test information"
           "|de|Diagnose-Testlauf Information";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     BIT_ENUMERATED (2)
  {
        { 0x0000, "Reference not active"
                  "|de|Referenzlauf nicht aktiv" },
        { 0x0001, "Drive signal y steady (d1) active"
                  "|de|Stellsignal y Stationr (d1) aktiv" },
        { 0x0002, "Drive signal hysteresis (d2) active"
                  "|de|Stellsignal y Hysterese (d2) aktiv"	},
        { 0x0004, "Static characteristic (d3) active"
                  "|de|Statische Kennlinie (d3) aktiv" },
      	{ 0x0008, "Step response (d4) active"
      	          "|de|Sprungantwort (d4) aktiv" },
        { 0x0010, "Hysteresis online test (d5) activated"
                  "|de|Hysterese online test (d5) aktiviert" },
        { 0x0020, "Hysteresis online test (d5) started"
                  "|de|Hysterese online test (d5) gestartet" },
        { 0x0040, "Data logger permanent active"
                  "|de|Datenlogger permanent aktiv"  },
        { 0x0080, "Data logger trigger active"
                  "|de|Datenlogger getriggert aktiv" },
/*        { 0x0100, "Reference test running"
                  "|de|Referenzlauf luft" }, */
      	{ 0x0200, "Tests in turn running"
                  "|de|Tests nacheinander luft" }
 /*       { 0x0400, "not used" "|de|nicht verwendet" },
      	{ 0x0800, "not used" "|de|nicht verwendet" },
      	{ 0x1000, "not used" "|de|nicht verwendet" },
      	{ 0x2000, "not used" "|de|nicht verwendet" },
      	{ 0x4000, "not used" "|de|nicht verwendet" },
      	{ 0x8000, "not used" "|de|nicht verwendet" }
*/
  }

  VALIDITY_ONLY_EXPERT_PLUS

  HELP     "Status of the diagnosis test." "|de|Status des Testlaufes.";
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* 5 Zeilen hoch */
#endif
}


/* ------------------------------------------------------------------------ */
/*     Temperaturbetrachtung                                                */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE current_temperature (float 389)
*/
VARIABLE trans1_Current_Temp
{
  LABEL    "Temperature" "|de|Temperatur";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE		0;
  }
  CONSTANT_UNIT "C";
  HELP     "Current temperature of the positioner."
           "|de|Aktuelle Temperatur im Stellungsregler.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE max_temperature (float 369)
*/
VARIABLE trans1_Max_Temp
{
  LABEL    "Max. temperature" "|de|Max. Temperatur";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE		0;
  }
  CONSTANT_UNIT "C";
  HELP     "Code 48 d2. Highest recorded temperature inside the positioner."
           "|de|Code 48 d2. Hchste erfasste Temperatur im Stellungsregler.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_t_zeit_max_temperatur (unsigned long 192)
*/
VARIABLE trans1_Time_Max_Temp
{
  LABEL    "Max. temperature (time)" "|de|Max. Temperatur (Zeit)";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0.0;
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  HELP     "Elapsed hours counter at the point of highest temperature "
           "inside the positioner."
           "|de|Betriebsstundenzhler zu der die hchste Temperatur im "
           "Stellungsregler erfasst wurde.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE min_temperature (float 370)
*/
VARIABLE trans1_Min_Temp
{
  LABEL    "Min. temperature" "|de|Min. Temperatur";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE			0;
  }
  CONSTANT_UNIT "C";
  HELP     "Code 48 d1. Lowest recorded temperature of the positioner."
           "|de|Code 48 d1. Niedrigste erfasste Temperatur im Stellungsregler.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE his_t_zeit_min_temperatur (unsigned long 462)
*/
VARIABLE trans1_Time_Min_Temp
{
  LABEL    "Min. temperature (time)" "|de|Min. Temperatur (Zeit)";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0.0;
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  HELP     "Elapsed hours counter at the point of lowest temperature "
           "inside the positioner."
           "|de|Betriebsstundenzhler zu der die niedrigste Temperatur im "
           "Stellungsregler erfasst wurde.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE temp_period_time_high (unsigned long 465)
*/
VARIABLE trans1_Period_Time_High
{
  LABEL    "Period (temp > +80C)" "|de|Verweildauer (t > +80C)";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0.0;
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  VALIDITY_ONLY_EXPERT_PLUS
  HELP     "Period of time the temperature is above +80C."
           "|de|Verweildauer der Temperatur oberhalb von +80C.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE temp_period_time_low (unsigned long 463)
*/
VARIABLE trans1_Period_Time_Low
{
  LABEL    "Period (temp < -40C)" "|de|Verweildauer (t < -40C)";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0.0;
  }

  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  VALIDITY_ONLY_EXPERT_PLUS
  HELP     "Period of time the temperature is below -40C."
           "|de|Verweildauer der Temperatur unterhalb von -40C.";
}

/* ------------------------------------------------------------------------ */
/*     Sprungantwort                                                        */
/* ------------------------------------------------------------------------ */

/* ---------------------READ WRITE----------------------------------------- */

/* ------------------------------------------------------------------------ */
/*
VARIABLE stepstart (float_288)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Stepstart
{
  LABEL    "Step start" "|de|Sprungstart";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE 10.0;
      MIN_VALUE 0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
  HELP     "Initial value to execute the step response."
           "|de|Startwert zur Durchfhrung der Sprungantwort.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_289)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Stepend
{
  LABEL    "Step end" "|de|Sprungende";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE 90.0;
      MIN_VALUE 0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
  HELP     "End value to execute the step response."
           "|de|Endwert zur Durchfhrung der Sprungantwort.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE step_sample_rate (unsigned_integer_188)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Step_Sample_Rate
{
  LABEL    "Scan rate" "|de|Abtastzeit";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE 2000;
      MIN_VALUE     200; 		/*  0.2s */
      MAX_VALUE     30000; 	/* 30s */
  }
  CONSTANT_UNIT "ms";
  SCALING_FACTOR  100.0; /* Wert vom Geraet in 1/10s */
  HELP     "Scan rate of the step response."
           "|de|Abtastrate der Sprungantwortmessung.";
}


/* kmr: fuer ESD: */
VARIABLE trans1_Rampe_Up
{
  LABEL    "Ramp up of step" "|de|Rampe Sprungantwort steigend";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "s";
  HELP     "Ramp up of step" "|de|Rampe Sprungantwort steigend";
}

VARIABLE trans1_Rampe_Down
{
  LABEL    "Ramp down of step" "|de|Rampe Sprungantwort fallend";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "s";
  HELP     "Ramp down of step" "|de|Rampe Sprungantwort fallend";
}



/* ------------------------------------------------------------------------ */
/*
VARIABLE latency_after_step (unsigned_integer_187)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Latency_After_Step
{
  LABEL    "Delay time after step" "|de|Wartezeit nach Sprung";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE   2.0;    /*   2 s */
      DISPLAY_FORMAT "2.1f";
      MIN_VALUE       2.0;    /*   2 s */
      MAX_VALUE     100.0;    /* 100 s */


/* kmr so sollte es sein:
      MIN_VALUE 2000;*/ /*   2 s */
/*      MAX_VALUE 100000;*/ /* 100 s */
/*  CONSTANT_UNIT "ms"; geht nicht, da sonst als max. Wert 100000 eingegeben
werden muesste, geht nicht bei 2 byte ! */
  }
  CONSTANT_UNIT "s";
  SCALING_FACTOR  0.1; /* Wert vom Geraet in 1/10s */
  HELP     "Delay between end of first step and start of second step."
           "|de|Wartezeit nach dem ersten Sprung bis zweiter Sprung gestartet wird.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE step_selection (unsigned_char_291)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Step_Selection
{
  LABEL    "Number of step responses" "|de|Anzahl Sprnge";

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE    2;
    { 1, "One step"  "|de|1 Sprung"  },
    { 2, "Two steps" "|de|2 Sprnge" }
  }
  HELP     "Selection between only one step or additionally the inverse step."
           "|de|Auswahlmglichkeit ob nur ein Sprung oder nach dem ersten Sprung auch "
           "der inverse Sprung durchgefhrt werden soll.";
}



/* ---------------------READ----------------------------------------- */

/* ------------------------------------------------------------------------ */
/*
VARIABLE overshoot_rising (float_290)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Overshoot_Rising
{
  LABEL    "Overshoot (rising)" "|de|berschwinger (steigend)";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Measurement analysis: overshoot - rising step."
           "|de|Messauswertung: berschwinger - Sprung steigend.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE overshoot_falling (float_296)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Overshoot_Falling
{
  LABEL    "Overshoot (falling)" "|de|berschwinger (fallend)";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP     "Measurement analysis: overshoot - falling step."
           "|de|Messauswertung: berschwinger - Sprung fallend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE dead_time_rising (unsigned_long_467)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Dead_Time_Rising
{
  LABEL    "Dead time (rising)" "|de|Totzeit (steigend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: dead band - rising step."
           "|de|Messauswertung: Totzeit - Sprung steigend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE dead_time_falling (unsigned_long_472)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Dead_Time_Falling
{
  LABEL    "Dead time (falling)" "|de|Totzeit (fallend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: dead band - falling step."
           "|de|Messauswertung: Totzeit - Sprung fallend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE time_63_rising (unsigned_long_468)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Time_63_Rising
{
  LABEL    "T63 (rising)" "|de|T63 (steigend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung steigend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE time_63_falling (unsigned_long_473)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Time_63_Falling
{
  LABEL    "T63 (falling)" "|de|T63 (fallend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: time at reaching 63% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 63% vom Sprung - "
           "Sprung fallend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE time_98_rising (unsigned_long_469)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Time_98_Rising
{
  LABEL    "T98 (rising)" "|de|T98 (steigend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "rising step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung steigend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE time_98_falling (unsigned_long_474)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Time_98_Falling
{
  LABEL    "T98 (falling)" "|de|T98 (fallend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: time at reaching 98% of the step - "
           "falling step."
           "|de|Messauswertung: Zeitwert bei Erreichen von 98% vom Sprung - "
           "Sprung fallend.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE step_progress (unsigned_char_282)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Step_Progress
{
  LABEL    "Progress" "|de|Fortschritt";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1);
  CONSTANT_UNIT "%";
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE rise_time_falling_step (unsigned_long_475)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Rise_Time_Falling
{
  LABEL    "Rise time (falling)" "|de|Anregelzeit (fallend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: rise time - falling step."
           "|de|Messauswertung: Anregelzeit - Sprung fallend.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE settling_time_falling_step (unsigned_long_476)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Settling_Time_Falling
{
  LABEL    "Settling time (falling)" "|de|Ausregelzeit (fallend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: settling time - falling step."
           "|de|Messauswertung: Ausregelzeit - Sprung fallend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE rise_time_rising_step (unsigned_long_470)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Rise_Time_Rising
{
  LABEL    "Rise time (rising)" "|de|Anregelzeit (steigend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: rise time - rising step."
           "|de|Messauswertung: Anregelzeit - Sprung steigend.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE settling_time_rising_step (unsigned_long_471)
(Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Settling_Time_Rising
{
  LABEL    "Settling time (rising)" "|de|Ausregelzeit (steigend)";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Measurement analysis: settling time - rising step."
           "|de|Messauswertung: Ausregelzeit - Sprung steigend.";
}


/* ------------------------------------------------------------------------ */
/* unsigned_integer_189 (Diagnose - Testfunktionen HAND - Sprungantwort)
*/
VARIABLE trans1_Duration_of_test
{
  LABEL    "Duration of the test" "|de|Voraussichtliche Testdauer";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "ms";
  HELP     "Allowed test duration."
           "|de|Zugelassene Testdauer.";
}


VARIABLE trans1_Testinfo
{
  LABEL    "Test information" "|de|Testinformation";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
     DEFAULT_VALUE    0;
    { 0, "Test not active" "|de|Test nicht aktiv" },
    { 1, "Test active"     "|de|Test aktiv"       }
  }
  HELP     "Status of the test." "|de|Status des Testlaufes.";
}


/* ------------------------------------------------------------------------ */
/* Protokollierung                                                          */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/*
VARIABLE messages_1 ... 30 (unsigned integer 0..29)
*/
VARIABLE trans1_Message_0
{
  LABEL    "Message 1" "|de|Meldung 1";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (2)
  {
    {     0, "No message logged" "|de|Keine Meldung protokolliert" },
    {     1, "Init. error: x > range"
             "|de|Init.-fehler: x > Bereich" },
    {     2, "Init. error: Delta x < range"
             "|de|Init.-fehler: delta x < Bereich" },
    {     3, "Init. error: Mech./Pneu. (Attachment)"
             "|de|Init.-fehler: Mech./Pneu. (Anbau)" },
    {     4, "Init. error: Initialization time exceeded"
             "|de|Init.-fehler: Initialisierungszeit berschritten" },
    {     5, "Init. error: Initialization/solenoid valve"
             "|de|Init.-fehler: Initialisierung/Magnetventil" },
    {     6, "Init. error: Travel time too short"
             "|de|Init.-fehler: Laufzeit unterschritten" },
    {     7, "Init. error: Pin position"
             "|de|Init.-fehler: Stiftposition" },
    {     8, "Init. error: No emergency mode"
             "|de|Init.-fehler: Keine Notlaufeigenschaft" },
    {     9, "9" },
    {    10, "Operating error: Control loop"
             "|de|Betriebsfehler: Regelkreis" },
    {    11, "Operating error: Zero point"
             "|de|Betriebsfehler: Nullpunkt" },
    {    12, "Operating error: Autocorrection"
             "|de|Betriebsfehler: Autokorrektur" },
    {    13, "Operating error: Fatal error"
             "|de|Betriebsfehler: Fataler Fehler" },
    {    14, "Operating error: W too small"
             "|de|Betriebsfehler: W zu klein" },
    {    15, "Operating error: Total valve travel exceeded"
             "|de|Betriebsfehler: Wegintegral berschritten" },
    {    16, "16" },
    {    17, "HW error: x - Signal"
             "|de|HW-Fehler: x - Signal" },
    {    18, "HW error: i/p converter"
             "|de|HW-Fehler: i/p Wandler" },
    {    19, "HW error: Hardware"
             "|de|HW-Fehler: Hardware" },
    {    20, "HW error: Data memory"
             "|de|HW-Fehler: Datenspeicher" },
    {    21, "HW error: Control calculation"
             "|de|HW-Fehler: Kontrollrechnung" },
    {    22, "HW error: Program load error"
             "|de|HW-Fehler: Programmladefehler" },
    {    23, "23" },
    {    24, "Data error: Control parameter"
             "|de|Datenfehler: Regelparameter" },
    {    25, "Data error: Poti parameter"
             "|de|Datenfehler: Potiparameter" },
    {    26, "Data error: Adjustment parameter"
             "|de|Datenfehler: Abgleichparameter" },
    {    27, "Data error: General parameter"
             "|de|Datenfehler: Allgemeine Parameter" },
    {    28, "Data error: Internal device error 1"
             "|de|Datenfehler: Interner Gertefehler 1" },
    {    29, "Data error: HART Parameter"
             "|de|Datenfehler: HART Parameter" },
    {    30, "Data error: Info parameter"
             "|de|Datenfehler: Info-Parameter"},
    {    31, "Data error: Options parameter"
             "|de|Datenfehler: Optionsparameter" },
    {    32, "Data errors: Diagnosis parameter"
             "|de|Datenfehler: Diagnoseparameter" },
    {    33, "Kp: manipulation" "|de|Kp: nderung" },
    {    34, "Tv: manipulation" "|de|Tv: nderung" },
    {    35, "35" },
    {    36, "36" },
    {    37, "37" },
    {    38, "38" },
    {    39, "39" },
    {    40, "40" },
    {    41, "41" },
    {    42, "42" },
    {    43, "43" },
    {    44, "44" },
    {    45, "45" },
    {    46, "46" },
    {    47, "47" },
    {    48, "48" },
    {    49, "49" },
    {    50, "50" },
    {    51, "Initialization was aborted"
             "|de|Initialisierung wurde abgebrochen" },
    { 10000, "Range: Mostly near closing pos."
             "|de|Stellbereich: Vorwiegend nahe Schliessstellung" },
    { 10001, "Range: Mostly near max. opening"
             "|de|Stellbereich: Vorwiegend nahe max. ffnung" },
    { 10002, "Range: Mostly closing pos."
             "|de|Stellbereich: Vorwiegend Schliessstellung" },
    { 10003, "Range: Mostly max. opening"
             "|de|Stellbereich: Vorwiegend max. ffnung" },
    { 10004, "10004" },
    { 10005, "Trend range: Shifting working range to closing position"
             "|de|Trend Stellbereich: Arbeitsbereichversch. Schliessstellung" },
    { 10006, "Trend range: Shifting working range to max. opening pos."
             "|de|Trend Stellbereich: Arbeitsbereichversch. max. ffnung" },
    { 10007, "10007" },
    { 10008, "Limit range: Down"
             "|de|Beschr. Stellbereich: Nach unten" },
    { 10009, "Limit range: Up"
             "|de|Beschr. Stellbereich: Nach oben" },
    { 10010, "Limit range: Modification impossible"
             "|de|Beschr. Stellb.: Keine nderung mehr mglich (Klemmen)" },
    { 10011, "10011" },
    { 10012, "Trend end pos.: ZP-shift monotone down; aver. above ref."
             "|de|Trend Endlage: NP-versch. monoton unten; MW ob. Ref.-geraden" },
    { 10013, "Trend end pos.: ZP-shift monotone up; aver. above ref."
             "|de|Trend Endlage: NP-versch. monoton oben; MW ob. Ref.-geraden" },
    { 10014, "Trend end pos.: ZP-shift alternate; aver. above ref."
             "|de|Trend Endlage: NP altern.; MW ob. Ref.-geraden" },
    { 10015, "Trend end pos.: ZP-shift monotone down; aver. under ref."
             "|de|Trend Endlage: NP-versch. monoton unten; MW unt. Ref.-geraden" },
    { 10016, "Trend end pos.: ZP-shift monotone up; aver. under ref."
             "|de|Trend Endlage: NP-versch. monoton oben; MW unt. Ref.-geraden" },
    { 10017, "Trend end pos.: ZP-alternate; aver. under ref."
             "|de|Trend Endlage: NP altern.; MW unt. Ref.-geraden" },
    { 10018, "10018" },
    { 10019, "Mech. conn. Pos./Valve: No opt. travel transm.TEST"
             "|de|Mech. Verb. Regler/Ventil: Keine opt. Hubbertr. TEST" },
    { 10020, "Mech. conn. Pos./Valve: Perhaps loose"
             "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh." },
    { 10021, "Mech. conn. Pos./Valve: Perhaps limit. range"
             "|de|Mech. Verb. Regler/Ventil: Evtl. Einschr. Stellber." },
    { 10022, "10022" },
    { 10023, "Spring: Perhaps spring stiffness reduced TEST"
             "|de|Antriebsfedern: Evtl. Federsteifigkeit red. TEST" },
    { 10024, "Spring: Perhaps bias reduced TEST"
             "|de|Antriebsfedern: Evtl. Vorspannung reduziert TEST" },
    { 10025, "Spring: Perhaps bias increased TEST"
             "|de|Antriebsfedern: Evtl. Vorspannung erhht TEST" },
    { 10026, "Spring: Working at full capacity"
             "|de|Antriebsfedern: Stark ausgelastet" },
    { 10027, "Spring: Working at full capacity TEST"
             "|de|Antriebsfedern: Stark ausgelastet TEST" },
    { 10028, "10028" },
    { 10029, "Air supply: Perhaps modified TEST"
             "|de|Zuluftdruck: Evtl. verndert TEST" },
    { 10030, "Air supply: Perhaps not enough TEST"
             "|de|Zuluftdruck: Evtl. nicht ausreichend TEST" },
    { 10031, "Air supply: Perhaps not enough"
             "|de|Zuluftdruck: Evtl. nicht ausreichend" },
    { 10032, "Air supply: Working at full capacity"
             "|de|Zuluftdruck: Stark ausgelastet" },
    { 10033, "Air supply: Working at full capacity TEST"
             "|de|Zuluftdruck: Stark ausgelastet TEST" },
    { 10034, "Air supply: Perhaps modified"
             "|de|Zuluftdruck: Eventuell verndert" },
    { 10035, "Leakage Pneumatics: Perhaps existing TEST"
             "|de|Leckage Pneumatik: Evtl. vorhanden TEST" },
    { 10036, "Leakage Pneumatics: Perhaps too large TEST"
             "|de|Leckage Pneumatik: Evtl. zu gross TEST" },
    { 10037, "Leakage Pneumatics: Perhaps too large"
             "|de|Leckage Pneumatik: Evtl. zu gross" },
    { 10038, "Leakage Pneumatics: Perhaps existing"
             "|de|Leckage Pneumatik: Evtl. vorhanden" },
    { 10039, "Friction: Much higher over whole range"
             "|de|Reibung: ber ganzen Stellber. deutlich hher" },
    { 10040, "Friction: Much lower over whole range"
             "|de|Reibung: ber ganzen Stellber. deutlich niedriger" },
    { 10041, "Friction: Much higher over section"
             "|de|Reibung: ber Teilstellber. deutlich hher" },
    { 10042, "Friction: Much lower over section"
             "|de|Reibung: ber Teilstellber. deutlich niedriger" },
    { 10043, "10043" },
    { 10044, "Inner leakage: Alarm limit 2 exceeded"
             "|de|Innere Leckage: Alarmgrenze 2 berschritten" },
    { 10045, "Inner leakage: Alarm limit 3 exceeded"
             "|de|Innere Leckage: Alarmgrenze 3 berschritten" },
    { 10046, "Inner leakage - perhaps present"
             "|de|Innere Leckage - Eventuell vorhanden" },
    { 10047, "Ext. leakage: Perhaps soon expected"
             "|de|Externe Leckage: Evtl. bald zu erwarten" },
    { 10048, "Ext. leakage: Perhaps existing"
             "|de|Externe Leckage: Evtl. vorhanden" },
    { 10049, "Ext. leakage: Existing"
             "|de|Externe Leckage: vorhanden" },
    { 10050, "ESD: Movement actuator poss."
             "|de|ESD: Bewegung Stellorgan mglich" },
    { 10051, "ESD: Movement actuator imposs."
             "|de|ESD: Bewegung Stellorgan nicht mglich" },
    { 10052, "ESD: Error solenoid valve"
             "|de|ESD: Magnetventil arbeitet nicht richtig" },
    { 10053, "10053" },
    { 10054, "10054" },
    { 10055, "10055" },
    { 10056, "10056" },
    { 10057, "10057" },
    { 10058, "10058" },
    { 10059, "10059" },
    { 10060, "Temperature below -40C" "|de|Temperatur kleiner -40C" },
    { 10061, "10061" },
    { 10062, "Temperature above +80C" "|de|Temperatur grer +80C" },
    { 10063, "10063" },
    { 10064, "10064" },
    { 10065, "10065" },
    { 10066, "10066" },
    { 10067, "10067" },
    { 10068, "10068" },
    { 10069, "10069" },
    { 10070, "Data logger started by travel condition"
             "|de|Triggerstart Datenlogger ber Hubbed. akt." },
    { 10071, "Data logger started by solenoid valve condition"
             "|de|Triggerstart Datenlogger ber Magnetventilbed. akt." },
    { 10072, "Data logger started by setpoint condition."
             "|de|Triggerstart Datenlogger ber Sollwertbedingung akt." },
    { 10073, "Data logger started by int. solenoid valve condition."
             "|de|Triggerstart Datenlogger ber int. Magnetventil akt." },
    { 10074, "Data logger started by actual value condition."
             "|de|Triggerstart Datenlogger ber Istwertbedingung akt." },
    { 10075, "Data logger started by setpoint deviation condition."
             "|de|Triggerstart Datenlogger ber Regelabw.-bedingung akt." },
    { 10076, "Data logger started by drive signal condition."
             "|de|Triggerstart Datenlogger  ber Stellsignalbedingung akt." },
    { 10077, "Data logger started by binary input."
             "|de|Triggerstart Datenlogger ber Binreingang akt." },
    { 10078, "10078" },
    { 10079, "Data logger started by binary input 1" 
    	       "|de|Triggerstart beim Datenlogger ber Binreingang 1 aktiviert" },
    { 10080, "Data logger started by binary input 2" 
    	       "|de|Triggerstart beim Datenlogger ber Binreingang 2 aktiviert" },
    { 11020, "Mech. conn. Pos./Valve: Perhaps loose TEST"
             "|de|Mech. Verb. Regler/Ventil: Evtl. Lose vorh. TEST" },
    { 11039, "Friction: Much higher over whole range TEST"
             "|de|Reibung: ber ganzen Stellber. deutlich hher TEST" },
    { 11040, "Friction: Much lower over whole range TEST"
             "|de|Reibung: ber ganzen Stellber. deutlich niedriger TEST" },
    { 11041, "Friction: Much higher over section TEST"
             "|de|Reibung: ber Teilbereich deutlich hher TEST" },
    { 11042, "Friction: Much lower over section TEST"
             "|de|Reibung: ber Teilbereich deutlich niedriger TEST" },
    { 12000, "Reset long-term histogram X"
             "|de|Langzeit-Histogramm x zurckgesetzt" },
    { 12001, "Reset long-term histogram cycle counter"
             "|de|Langzeithistogramm Zyklenzhler zurckgesetzt" },
    { 12002, "Reset elapsed hours meter"
             "|de|Betriebsstundenzhler zurckgesetzt" },
    { 12003, "Reset temp. meter and high. values"
             "|de|Temp. Schleppzeiger und Hchstwerte zurckgesetzt" },
    { 12004, "Reset long-term view Y-steady online"
             "|de|Langzeitbetrachtung Y-Stationr Online zurckgesetzt" },
    { 12005, "Reset long-term view hysteresis online"
             "|de|Langzeitbetrachtung Hysterese Online zurckgesetzt" },
    { 12006, "Reset end pos. trend ref. value upper end pos."
             "|de|Endlagentrend Referenzwert obere Endlage zurckgesetzt" },
    { 12007, "Reset end pos. trend ref. value lower end pos."
             "|de|Endlagentrend Referenzwert untere Endlage zurckgesetzt" },
    { 12008, "Long-term sound sensor: reset meas. whole range"
             "|de|Langzeit KS-sensor: Messung ges. Hubber. zurckgesetzt" },
    { 12009, "Reset long-term process values histogram"
             "|de|Langzeit Prozessgren-Histogramm zurckgesetzt" },
    { 12010, "Reset long-term histogram deviation"
             "|de|Langzeithistogramm e zurckgesetzt" },
    { 12011, "12011" },
    { 12012, "12012" },
    { 12013, "12013" },
    { 12014, "12014" },
    { 12015, "12015" },
    { 12016, "12016" },
    { 12017, "12017" },
    { 12018, "12018" },
    { 12019, "12019" },
    { 12020, "12020" },
    { 12500, "Solenoid valve activated"
             "|de| Magnetventil hat ausgelst" },
    { 12510, "Overflow of the operating hours counter"
             "|de| berlauf des Betriebsstundenzhler" },
    { 12520, "PST: status 'No test performed' active."
             "|de|PST: Status 'Kein Test vorhanden' gesetzt." },
    { 12521, "PST: status 'x-cancellation' active."
             "|de|PST: Status 'x-Abbruch' gesetzt." },
    { 12522, "PST: status 'delta y-cancellation' active."
             "|de|PST: Status 'delta y-Abbruch' gesetzt." },
    { 12523, "PST: status 'Tolerance band exceeded' active."
             "|de|PST: Status 'Toleranzband berschritten' gesetzt." },
    { 12524, "PST: status 'Max. test time exceeded' active."
             "|de|PST: Status 'max. Testzeit berschritten' gesetzt." },
    { 12525, "PST: status 'Test man. aborted' active."
             "|de|PST: Status 'Test manuell abgebrochen' gesetzt." },
    { 12526, "PST: status 'Measured data storage out of memory' active."
             "|de|PST: Status 'Messdatenspeicher voll' gesetzt." },
    { 12527, "PST: status 'Aborted by solenoid valve' active."
             "|de|PST: Status 'Magnetventil Abbruch' gesetzt." },
    { 12528, "PST: status 'Supply pressure / friction' active."
             "|de|PST: Status 'Zuluftdruck / Reibung' gesetzt." },
    { 12529, "PST: successful."
             "|de|PST: erfolgreich durchgefhrt." }

  }

  HELP     "Apprehended messages, set by the positioner."
           "|de|Erfasste Meldungen, die vom Stellungsregler gesetzt wurden.";
}

trans1_Message_1  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 2" "|de|Meldung 2"; }
trans1_Message_2  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 3" "|de|Meldung 3"; }
trans1_Message_3  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 4" "|de|Meldung 4"; }
trans1_Message_4  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 5" "|de|Meldung 5"; }
trans1_Message_5  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 6" "|de|Meldung 6"; }
trans1_Message_6  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 7" "|de|Meldung 7"; }
trans1_Message_7  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 8" "|de|Meldung 8"; }
trans1_Message_8  LIKE  VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 9" "|de|Meldung 9"; }
trans1_Message_9  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 10" "|de|Meldung 10"; }
trans1_Message_10  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 11" "|de|Meldung 11"; }
trans1_Message_11  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 12" "|de|Meldung 12"; }
trans1_Message_12  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 13" "|de|Meldung 13"; }
trans1_Message_13  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 14" "|de|Meldung 14"; }
trans1_Message_14  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 15" "|de|Meldung 15"; }
trans1_Message_15  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 16" "|de|Meldung 16"; }
trans1_Message_16  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 17" "|de|Meldung 17"; }
trans1_Message_17  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 18" "|de|Meldung 18"; }
trans1_Message_18  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 19" "|de|Meldung 19"; }
trans1_Message_19  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 20" "|de|Meldung 20"; }
trans1_Message_20  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 21" "|de|Meldung 21"; }
trans1_Message_21  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 22" "|de|Meldung 22"; }
trans1_Message_22  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 23" "|de|Meldung 23"; }
trans1_Message_23  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 24" "|de|Meldung 24"; }
trans1_Message_24  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 25" "|de|Meldung 25"; }
trans1_Message_25  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 26" "|de|Meldung 26"; }
trans1_Message_26  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 27" "|de|Meldung 27"; }
trans1_Message_27  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 28" "|de|Meldung 28"; }
trans1_Message_28  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 29" "|de|Meldung 29"; }
trans1_Message_29  LIKE VARIABLE  trans1_Message_0
{ REDEFINE LABEL  "Message 30" "|de|Meldung 30"; }



/* ------------------------------------------------------------------------ */
/*
VARIABLE elapsed_hours_meter_1 ... 30 (unsigned long 4..33)
*/
VARIABLE trans1_Elapsed_Hours_Meters_0
{
  LABEL    "Elapsed hours since first start-up 1"
           "|de|Betriebsstunden seit erster Inbetriebnahme 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE		0.0;
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  HELP     "Elapsed hours of the particular message."
           "|de|Betriebsstundenzhler der jeweiligen Meldung.";
}


trans1_Elapsed_Hours_Meters_1  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 2"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 2"; }
trans1_Elapsed_Hours_Meters_2  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 3"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 3"; }
trans1_Elapsed_Hours_Meters_3  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 4"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 4"; }
trans1_Elapsed_Hours_Meters_4  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 5"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 5"; }
trans1_Elapsed_Hours_Meters_5  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 6"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 6"; }
trans1_Elapsed_Hours_Meters_6  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 7"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 7"; }
trans1_Elapsed_Hours_Meters_7  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 8"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 8"; }
trans1_Elapsed_Hours_Meters_8  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 9"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 9"; }
trans1_Elapsed_Hours_Meters_9  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 10"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 10"; }
trans1_Elapsed_Hours_Meters_10  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 11"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 11"; }
trans1_Elapsed_Hours_Meters_11  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 12"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 12"; }
trans1_Elapsed_Hours_Meters_12  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 13"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 13"; }
trans1_Elapsed_Hours_Meters_13  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 14"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 14"; }
trans1_Elapsed_Hours_Meters_14  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 15"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 15"; }
trans1_Elapsed_Hours_Meters_15  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 16"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 16"; }
trans1_Elapsed_Hours_Meters_16  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 17"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 17"; }
trans1_Elapsed_Hours_Meters_17  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 18"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 18"; }
trans1_Elapsed_Hours_Meters_18  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 19"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 19"; }
trans1_Elapsed_Hours_Meters_19  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 20"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 20"; }
trans1_Elapsed_Hours_Meters_20  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 21"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 21"; }
trans1_Elapsed_Hours_Meters_21  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 22"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 22"; }
trans1_Elapsed_Hours_Meters_22  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 23"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 23"; }
trans1_Elapsed_Hours_Meters_23  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 24"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 24"; }
trans1_Elapsed_Hours_Meters_24  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 25"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 25"; }
trans1_Elapsed_Hours_Meters_25  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 26"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 26"; }
trans1_Elapsed_Hours_Meters_26  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 27"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 27"; }
trans1_Elapsed_Hours_Meters_27  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 28"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 28"; }
trans1_Elapsed_Hours_Meters_28  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 29"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 29"; }
trans1_Elapsed_Hours_Meters_29  LIKE  VARIABLE  trans1_Elapsed_Hours_Meters_0
{ REDEFINE LABEL "Elapsed hours since first start-up 30"
                 "|de|Betriebsstunden seit erster Inbetriebnahme 30"; }



/* ------------------------------------------------------------------------ */
/*     Enhanced Diagnostic CMD                                        */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_enhanced_diag_cmd
{
  LABEL    "Enhanced Diagnostic Command";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    {  0, "no function"                                  },
    {  1, "Start datalogger"                             },
    {  2, "Abort datalogger"                             },
    {  3, "Start Hysteresis online test"                 },
    {  4, "Abort Hysteresis online test"                 },
    {  5, "Start step response"                          },
    {  6, "Abort step response"                          },
    {  7, "Start tests in turn"                          },
    {  8, "Abort tests in turn"                          },
    {  9, "Start drive signal diagram steady"            },
    { 10, "Abort drive signal diagram steady"            },
    { 11, "Start drive signal diagram hysteresis"        },
    { 12, "Abort drive signal diagram hysteresis"        },
    { 13, "Start statistic characteristic"               },
    { 14, "Abort statistic characteristic"               },
    { 15, "Start reference test"                         },
    { 16, "Abort reference test"                         },

    { 17, "Reset logger"  },
  /*{ 18, "Reset 'complete diagnosis information'"       },*/
  /*{ 19, "Reset 'elapsed hours meter'"                  },*/
  /*{ 20, "Reset 'temperature information'"              },*/
    { 21, "Reset 'X - long term histogram'"              },
    { 22, "Reset 'cycle counter histogram - long time'"  },
    { 23, "Reset 'E long term setpoint deviation'"       },
    { 24, "Reset 'Y - X long term'"                      },
    { 25, "Reset 'Y - X short term'"                     },
    { 26, "Reset 'hysteresis long term'"                 },
    { 27, "Reset 'lower end position'"                   },
    { 28, "Reset 'lower end position - ref. values'"     },
    { 29, "Reset 'X - short term histogram'"             },
    { 30, "Reset 'E - short term setpoint deviation'"    },
    { 31, "Reset 'cycle counter histogram - short term'" },
    { 32, "Reset 'hysteresis short term'"                },
  /*  { 33, "Reset 'Y - X reference values'"             },*/
  /*  { 34, "Reset 'Hysteresis reference'"               },*/
  /*  { 35, "Reset 'data logger'"                        },*/
  /*  { 36, "Reset 'static characteristic'"              },*/
  /*  { 37, "Reset 'step response'"                      },*/
    { 38, "Reset 'Y - X measured values'"                },
    { 39, "Reset 'hysteresis measured values'"           }
  }

}

/* ------------------------------------------------------------------------ */
/*       Betriebsstundenzhler (BSZ)                                        */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*
VARIABLE elapsed_hours_meter (unsigned long 0)
*/
VARIABLE trans1_Elapsed_Hours_Meters
{
  LABEL    "Elapsed hours meter" "|de|Betriebsstundenzhler";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  HELP     "Time since the initial commissioning."
           "|de|Zeit seit der ersten Inbetriebnahme.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE device_in_closed_loop (unsigned long 1)
*/
VARIABLE trans1_Device_In_Closed_Loop
{
  LABEL    "Device in closed loop" "|de|Gert in Regelung";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  HELP     "Time in closed loop since the initial commissioning."
           "|de|Zeit in der Regelung seit der ersten Inbetriebnahme.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE device_switched_on_since_init (unsigned long 2)
*/
VARIABLE trans1_Power_On_Since_Init
{
  LABEL    "Device switched on since initialization"
           "|de|Gert eingeschaltet seit Initialisierung";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT ".2f";
      DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "h";   /* dd:hh:mm:ss */
  HELP     "Time since the last initialization."
           "|de|Zeit seit der letzten Initialisierung.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE device_in_closed_loop_since_init (unsigned long 3)
*/
VARIABLE trans1_Device_In_Closed_Loop_Since_Last_Init
{
  LABEL    "Device in closed loop since init."
           "|de|Gert seit Initialisierung in Regelung";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE  0;
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  HELP     "Time in closed loop since the last initialization."
           "|de|Zeit in der Regelung seit der letzten Initialisierung.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE hys_stell_y (unsigned_long_480)
(Diagnose - Beobachterfunktionen AUTO - Diagramm Stellsignal y - Hysterese)
*/
/* ------------------------------------------------------------------------ */
VARIABLE trans1_autostart_hyst
{
  LABEL    "Min. time distance from test" "|de|Zeitl. Mindestabstand";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE 1;
     MIN_VALUE 0; /*  0h */
     MAX_VALUE 24; /* 24h */
  }
  CONSTANT_UNIT "h";    /* dd:hh:mm:ss */
  HELP     "Shows in which time intervals the test is repeated."
           "|de|Gibt an, in welchen Zeitabstnden der Test wiederholt werden soll.";
}

/* ------------------------------------------------------------------------ */
/*
VARIABLE diag_level (unsigned char 1; cmd 171/1 (Schreiben: 170/1))
*/
VARIABLE trans1_diag_level
{
  LABEL    "Diagnosis level" "|de|Diagnose Leveleinstellung";

  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
	  DEFAULT_VALUE  1;  /* damit am Anfang EXPERT+ */
    { 0, "EXPERT"   },
    { 1, "EXPERT+"  },
    { 2, "EXPERT++" },
    { 3, "ESD"      }
  }
  HELP     "Shows the configuration level of the diagnosis."
           "|de|Anzeige der Diagnose-Ausbaustufe.";
}



/* ------------------------------------------------------------------------ */
/*  Nullpunkt                                                          */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Anzahl Nullpunktabgleiche    Doku-Nummer: 175   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_no_of_zero_point_adj
{
  LABEL "No. of zero point adjustments" "|de|Anzahl Nullpunktabgleiche";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DEFAULT_VALUE   0;
  }
  HELP "Code 48 d3. Number of zero point adjustments since the latest initialization."
       "|de|Code 48 d3. Anzahl der durchgefhrten Nullpunktabgleiche seit der "
       "letzten Initialisierung.";
}


/* ------------------------------------------------------------------------ */
VARIABLE trans1_zero_point_limit
{
  LABEL    "Zero point limit" "|de|Nullpunktgrenze";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "2.1f";
      DEFAULT_VALUE 5.0;
      MIN_VALUE 0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
  HELP     "Code 48 d5. Limit value for zero point control."
           "|de|Code 48 d5. Grenze fr die Nullpunktberwachung.";
}


/* ------------------------------------------------------------------------ */
VARIABLE trans1_counter_init_start
{
  LABEL    "Number of initializations" "|de|Anzahl Initialisierungen";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
      DEFAULT_VALUE   0;
  }
  HELP     "Code 48 d4. Number of initializations ever performed."
           "|de|Code 48 d4. Anzahl der jemals durchgefhrten Initialisierungen.";
}



/* ------------------------------------------------------------------------ */
/* float 217-241
*/
/* Referenzwerte Ventilstellung (x-Achse) */
/* (nur fr Grafik) */
VARIABLE trans1_stat_ref_vs_0
{
  LABEL    "Valve position - 1" "|de|Ventilstellung - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP    "Reference valve positions moved to during the test."
          "|de|Ventilstellungen der Referenzwerte, die beim Test angefahren wurden.";
}

trans1_stat_ref_vs_1 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 2" "|de|Ventilstellung - 2"; }
trans1_stat_ref_vs_2 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 3" "|de|Ventilstellung - 3"; }
trans1_stat_ref_vs_3 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 4" "|de|Ventilstellung - 4"; }
trans1_stat_ref_vs_4 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 5" "|de|Ventilstellung - 5"; }
trans1_stat_ref_vs_5 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 6" "|de|Ventilstellung - 6"; }
trans1_stat_ref_vs_6 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 7" "|de|Ventilstellung - 7"; }
trans1_stat_ref_vs_7 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 8" "|de|Ventilstellung - 8"; }
trans1_stat_ref_vs_8 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 9" "|de|Ventilstellung - 9"; }
trans1_stat_ref_vs_9 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 10" "|de|Ventilstellung - 10"; }
trans1_stat_ref_vs_10 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 11" "|de|Ventilstellung - 11"; }
trans1_stat_ref_vs_11 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 12" "|de|Ventilstellung - 12"; }
trans1_stat_ref_vs_12 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 13" "|de|Ventilstellung - 13"; }
trans1_stat_ref_vs_13 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 14" "|de|Ventilstellung - 14"; }
trans1_stat_ref_vs_14 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 15" "|de|Ventilstellung - 15"; }
trans1_stat_ref_vs_15 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 16" "|de|Ventilstellung - 16"; }
trans1_stat_ref_vs_16 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 17" "|de|Ventilstellung - 17"; }
trans1_stat_ref_vs_17 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 18" "|de|Ventilstellung - 18"; }
trans1_stat_ref_vs_18 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 19" "|de|Ventilstellung - 19"; }
trans1_stat_ref_vs_19 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 20" "|de|Ventilstellung - 20"; }
trans1_stat_ref_vs_20 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 21" "|de|Ventilstellung - 21"; }
trans1_stat_ref_vs_21 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 22" "|de|Ventilstellung - 22"; }
trans1_stat_ref_vs_22 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 23" "|de|Ventilstellung - 23"; }
trans1_stat_ref_vs_23 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 24" "|de|Ventilstellung - 24"; }
trans1_stat_ref_vs_24 		LIKE  VARIABLE  		trans1_stat_ref_vs_0
{ REDEFINE LABEL "Valve position - 25" "|de|Ventilstellung - 25"; }


/* ------------------------------------------------------------------------ */
/* float 242-266
*/
/* Wiederholungswerte Ventilstellung (x-Achse) */
/* (nur fr Grafik) */

VARIABLE trans1_stat_again_vs_0
{
  LABEL    "Valve position - 1" "|de|Ventilstellung - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT "2.1f";
  }
  CONSTANT_UNIT "%";
  HELP    "Repeat valve positions moved to during the test."
          "|de|Ventilstellungen der Wiederholungsmessung, die beim Test angefahren wurden.";
}

trans1_stat_again_vs_1 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 2" "|de|Ventilstellung - 2"; }
trans1_stat_again_vs_2 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 3" "|de|Ventilstellung - 3"; }
trans1_stat_again_vs_3 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 4" "|de|Ventilstellung - 4"; }
trans1_stat_again_vs_4 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 5" "|de|Ventilstellung - 5"; }
trans1_stat_again_vs_5 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 6" "|de|Ventilstellung - 6"; }
trans1_stat_again_vs_6 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 7" "|de|Ventilstellung - 7"; }
trans1_stat_again_vs_7 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 8" "|de|Ventilstellung - 8"; }
trans1_stat_again_vs_8 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 9" "|de|Ventilstellung - 9"; }
trans1_stat_again_vs_9 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 10" "|de|Ventilstellung - 10"; }
trans1_stat_again_vs_10 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 11" "|de|Ventilstellung - 11"; }
trans1_stat_again_vs_11 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 12" "|de|Ventilstellung - 12"; }
trans1_stat_again_vs_12 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 13" "|de|Ventilstellung - 13"; }
trans1_stat_again_vs_13 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 14" "|de|Ventilstellung - 14"; }
trans1_stat_again_vs_14 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 15" "|de|Ventilstellung - 15"; }
trans1_stat_again_vs_15 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 16" "|de|Ventilstellung - 16"; }
trans1_stat_again_vs_16 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 17" "|de|Ventilstellung - 17"; }
trans1_stat_again_vs_17 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 18" "|de|Ventilstellung - 18"; }
trans1_stat_again_vs_18 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 19" "|de|Ventilstellung - 19"; }
trans1_stat_again_vs_19 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 20" "|de|Ventilstellung - 20"; }
trans1_stat_again_vs_20 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 21" "|de|Ventilstellung - 21"; }
trans1_stat_again_vs_21 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 22" "|de|Ventilstellung - 22"; }
trans1_stat_again_vs_22 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 23" "|de|Ventilstellung - 23"; }
trans1_stat_again_vs_23 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 24" "|de|Ventilstellung - 24"; }
trans1_stat_again_vs_24 		LIKE  VARIABLE  		trans1_stat_again_vs_0
{ REDEFINE LABEL "Valve position - 25" "|de|Ventilstellung - 25"; }


VARIABLE trans1_stat_ss_refzeit
{
  LABEL    "Reference time stamp" "|de|Referenzzeitstempel";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "h";
  HELP     "Time stamp of the recorded reference value."
           "|de|Zeitstempel der Referenzwertaufnahme.";
}

/* ------------------------------------------------------------------------ */
/* unsigned char 118 */
VARIABLE trans1_stat_ss_testinfo
{
  LABEL    "Test information" "|de|Testinformation";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE    0;
    { 0, "Test not active" "|de|Test nicht aktiv" },
    { 1, "Running test" "|de|Testdurchfhrung" },
    { 2, "Test finished" "|de|Test beendet" },
    { 3, "Test aborted" "|de|Test wurde abgebrochen" },
    { 4, "Reference not clear"
         "|de|Keine eindeutige Referenzkurve aufgenommen" },
    { 5, "Booster attached - no evaluation possible"
         "|de|Booster angebaut - keine Auswertung mglich" },
    { 6, "Test aborted - Time exceeded"
         "|de|Test abgebrochen - Zeitberschreitung"}
  }
  HELP     "Status of the test." "|de|Status des Testlaufes.";
}


/* ------------------------------------------------------------------------ */
/* unsigned_char_254 */
VARIABLE trans1_stat_ss_progress
{
  LABEL    "Progress" "|de|Fortschritt";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "%";
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
}


/* ------------------------------------------------------------------------ */
/* unsigned integer 112-136
*/
VARIABLE trans1_stat_ref_ss_0
{
  LABEL    "Reference value - 1" "|de|Referenzwert - 1";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
  HELP     "Reference valve positions moved to during the test."
           "|de|Ventilstellungen der Referenzwerte die beim Test "
           "angefahren wurden.";
}

trans1_stat_ref_ss_1 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 2" "|de|Referenzwert - 2"; }
trans1_stat_ref_ss_2 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 3" "|de|Referenzwert - 3"; }
trans1_stat_ref_ss_3 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 4" "|de|Referenzwert - 4"; }
trans1_stat_ref_ss_4 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 5" "|de|Referenzwert - 5"; }
trans1_stat_ref_ss_5 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 6" "|de|Referenzwert - 6"; }
trans1_stat_ref_ss_6 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 7" "|de|Referenzwert - 7"; }
trans1_stat_ref_ss_7 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 8" "|de|Referenzwert - 8"; }
trans1_stat_ref_ss_8 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 9" "|de|Referenzwert - 9"; }
trans1_stat_ref_ss_9 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 10" "|de|Referenzwert - 10"; }
trans1_stat_ref_ss_10 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 11" "|de|Referenzwert - 11"; }
trans1_stat_ref_ss_11 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 12" "|de|Referenzwert - 12"; }
trans1_stat_ref_ss_12 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 13" "|de|Referenzwert - 13"; }
trans1_stat_ref_ss_13 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 14" "|de|Referenzwert - 14"; }
trans1_stat_ref_ss_14 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 15" "|de|Referenzwert - 15"; }
trans1_stat_ref_ss_15 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 16" "|de|Referenzwert - 16"; }
trans1_stat_ref_ss_16 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 17" "|de|Referenzwert - 17"; }
trans1_stat_ref_ss_17 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 18" "|de|Referenzwert - 18"; }
trans1_stat_ref_ss_18 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 19" "|de|Referenzwert - 19"; }
trans1_stat_ref_ss_19 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 20" "|de|Referenzwert - 20"; }
trans1_stat_ref_ss_20 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 21" "|de|Referenzwert - 21"; }
trans1_stat_ref_ss_21 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 22" "|de|Referenzwert - 22"; }
trans1_stat_ref_ss_22 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 23" "|de|Referenzwert - 23"; }
trans1_stat_ref_ss_23 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 24" "|de|Referenzwert - 24"; }
trans1_stat_ref_ss_24 LIKE  VARIABLE  trans1_stat_ref_ss_0
{ REDEFINE LABEL "Reference value - 25" "|de|Referenzwert - 25"; }



/* ------------------------------------------------------------------------ */
/* unsigned integer 137-161
*/
VARIABLE trans1_stat_again_ss_0
{
  LABEL    "Repetition value - 1" "|de|Wiederholungswert - 1";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
  HELP     "Repeat valve positions moved to during the test."
           "|de|Ventilstellungen der Wiederholungsmessungen die beim "
           "Test angefahren wurden.";
}

trans1_stat_again_ss_1 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 2" "|de|Wiederholungswert - 2"; }
trans1_stat_again_ss_2 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 3" "|de|Wiederholungswert - 3"; }
trans1_stat_again_ss_3 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 4" "|de|Wiederholungswert - 4"; }
trans1_stat_again_ss_4 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 5" "|de|Wiederholungswert - 5"; }
trans1_stat_again_ss_5 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 6" "|de|Wiederholungswert - 6"; }
trans1_stat_again_ss_6 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 7" "|de|Wiederholungswert - 7"; }
trans1_stat_again_ss_7 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 8" "|de|Wiederholungswert - 8"; }
trans1_stat_again_ss_8 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 9" "|de|Wiederholungswert - 9"; }
trans1_stat_again_ss_9 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 10" "|de|Wiederholungswert - 10"; }
trans1_stat_again_ss_10 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 11" "|de|Wiederholungswert - 11"; }
trans1_stat_again_ss_11 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 12" "|de|Wiederholungswert - 12"; }
trans1_stat_again_ss_12 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 13" "|de|Wiederholungswert - 13"; }
trans1_stat_again_ss_13 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 14" "|de|Wiederholungswert - 14"; }
trans1_stat_again_ss_14 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 15" "|de|Wiederholungswert - 15"; }
trans1_stat_again_ss_15 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 16" "|de|Wiederholungswert - 16"; }
trans1_stat_again_ss_16 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 17" "|de|Wiederholungswert - 17"; }
trans1_stat_again_ss_17 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 18" "|de|Wiederholungswert - 18"; }
trans1_stat_again_ss_18 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 19" "|de|Wiederholungswert - 19"; }
trans1_stat_again_ss_19 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 20" "|de|Wiederholungswert - 20"; }
trans1_stat_again_ss_20 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 21" "|de|Wiederholungswert - 21"; }
trans1_stat_again_ss_21 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 22" "|de|Wiederholungswert - 22"; }
trans1_stat_again_ss_22 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 23" "|de|Wiederholungswert - 23"; }
trans1_stat_again_ss_23 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 24" "|de|Wiederholungswert - 24"; }
trans1_stat_again_ss_24 LIKE  VARIABLE  trans1_stat_again_ss_0
{ REDEFINE LABEL "Repetition value - 25" "|de|Wiederholungswert - 25"; }


VARIABLE trans1_hys_ss_refzeit
{
  LABEL    "Reference time stamp" "|de|Referenzzeitstempel";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DISPLAY_FORMAT ".2f";
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "h";
  HELP     "Time stamp of the recorded reference value."
           "|de|Zeitstempel der Referenzwertaufnahme.";
}


/* ------------------------------------------------------------------------ */
/* unsigned char 409 */
VARIABLE trans1_hys_ss_testinfo
{
  LABEL    "Test information" "|de|Testinformation";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    { 0, "Test not active" "|de|Test nicht aktiv" },
    { 1, "Running test" "|de|Testdurchfhrung" },
    { 2, "Test finished" "|de|Test beendet" },
    { 3, "Test aborted - no measured point"
         "|de|Test abgebrochen - Sttzstelle nicht erreichbar" },
    { 4, "Test aborted - time exceeded"
         "|de|Test abgebrochen - Zeitberschreitung" },
    { 5, "Reference not clear" "|de|Keine eindeutige Referenzkurve aufgenommen" },
    { 6, "Test aborted" "|de|Test wurde abgebrochen" },
    { 7, "Booster - test executed - no evaluation"
         "|de|Booster - Test durchgefhrt - keine Auswertung" }
  }
  HELP     "Status of the test." "|de|Status des Testlaufes.";
}


trans1_hys_ss_progress 	LIKE  VARIABLE		trans1_stat_ss_progress
{ }

/* ------------------------------------------------------------------------ */
/* unsigned char 258-269
*/
/* Referenzwerte Ventilstellung (x-Achse) */
/* (nur fr Grafik) */
VARIABLE trans1_hys_ref_vs_0
{
  LABEL    "Valve position - 1" "|de|Ventilstellung - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "%";
  HELP    "Valve positions moved to during the test."
          "|de|Ventilstellungen die angefahren werden.";
}

trans1_hys_ref_vs_1 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 2" "|de|Ventilstellung - 2"; }
trans1_hys_ref_vs_2 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 3" "|de|Ventilstellung - 3"; }
trans1_hys_ref_vs_3 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 4" "|de|Ventilstellung - 4"; }
trans1_hys_ref_vs_4 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 5" "|de|Ventilstellung - 5"; }
trans1_hys_ref_vs_5 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 6" "|de|Ventilstellung - 6"; }
trans1_hys_ref_vs_6 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 7" "|de|Ventilstellung - 7"; }
trans1_hys_ref_vs_7 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 8" "|de|Ventilstellung - 8"; }
trans1_hys_ref_vs_8 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 9" "|de|Ventilstellung - 9"; }
trans1_hys_ref_vs_9 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 10" "|de|Ventilstellung - 10"; }
trans1_hys_ref_vs_10 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 11" "|de|Ventilstellung - 11"; }
trans1_hys_ref_vs_11 		LIKE  VARIABLE  		trans1_hys_ref_vs_0
{ REDEFINE LABEL "Valve position - 12" "|de|Ventilstellung - 12"; }


/* ------------------------------------------------------------------------ */
/* unsigned integer 162-173
*/
VARIABLE trans1_hys_ref_hys_0
{
  LABEL    "Reference value - 1 (5%)" "|de|Referenzwert - 1 (5%)";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
  HELP     "Valve positions moved to during the test."
           "|de|Ventilstellungen die angefahren werden.";
}

trans1_hys_ref_hys_1 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 2 (10%)" "|de|Referenzwert - 2 (10%)"; }
trans1_hys_ref_hys_2 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 3 (15%)" "|de|Referenzwert - 3 (15%)"; }
trans1_hys_ref_hys_3 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 4 (20%)" "|de|Referenzwert - 4 (20%)"; }
trans1_hys_ref_hys_4 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 5 (30%)" "|de|Referenzwert - 5 (30%)"; }
trans1_hys_ref_hys_5 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 6 (40%)" "|de|Referenzwert - 6 (40%)"; }
trans1_hys_ref_hys_6 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 7 (50%)" "|de|Referenzwert - 7 (50%)"; }
trans1_hys_ref_hys_7 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 8 (60%)" "|de|Referenzwert - 8 (60%)"; }
trans1_hys_ref_hys_8 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 9 (70%)" "|de|Referenzwert - 9 (70%)"; }
trans1_hys_ref_hys_9 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 10 (80%)" "|de|Referenzwert - 10 (80%)"; }
trans1_hys_ref_hys_10 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 11 (90%)" "|de|Referenzwert - 11 (90%)"; }
trans1_hys_ref_hys_11 LIKE  VARIABLE  trans1_hys_ref_hys_0
{ REDEFINE LABEL "Reference value - 12 (95%)" "|de|Referenzwert - 12 (95%)"; }



/* ------------------------------------------------------------------------ */
/* unsigned integer 174-185
*/
VARIABLE trans1_hys_again_hys_0
{
  LABEL    "Repetition value - 1 (5%)" "|de|Wiederholungswert - 1 (5%)";

  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2);
  CONSTANT_UNIT "1/s";
  HELP     "Repeat values of the hysteresis measurement."
           "|de|Wiederholungswerte der Hysteresemessung.";
}

trans1_hys_again_hys_1 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 2 (10%)" "|de|Wiederholungswert - 2 (10%)"; }
trans1_hys_again_hys_2 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 3 (15%)" "|de|Wiederholungswert - 3 (15%)"; }
trans1_hys_again_hys_3 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 4 (20%)" "|de|Wiederholungswert - 4 (20%)"; }
trans1_hys_again_hys_4 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 5 (30%)" "|de|Wiederholungswert - 5 (30%)"; }
trans1_hys_again_hys_5 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 6 (40%)" "|de|Wiederholungswert - 6 (40%)"; }
trans1_hys_again_hys_6 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 7 (50%)" "|de|Wiederholungswert - 7 (50%)"; }
trans1_hys_again_hys_7 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 8 (60%)" "|de|Wiederholungswert - 8 (60%)"; }
trans1_hys_again_hys_8 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 9 (70%)" "|de|Wiederholungswert - 9 (70%)"; }
trans1_hys_again_hys_9 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 10 (80%)" "|de|Wiederholungswert - 10 (80%)"; }
trans1_hys_again_hys_10 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 11 (90%)" "|de|Wiederholungswert - 11 (90%)"; }
trans1_hys_again_hys_11 LIKE  VARIABLE  trans1_hys_again_hys_0
{ REDEFINE LABEL "Repetition value - 12 (95%)" "|de|Wiederholungswert - 12 (95%)"; }


VARIABLE trans1_stat_kenn_testinfo
{
  LABEL    "Test information" "|de|Testinformation";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
      DEFAULT_VALUE    0;
    { 0, "Test not active" "|de|Test nicht aktiv" },
    { 1, "Test active"     "|de|Test aktiv"       }
  }
  HELP    "Status of the test" "|de|Status des Testlaufes.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_step_height (float_284)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_sprunghoehe
{
  LABEL    "Step height" "|de|Sprunghhe";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DEFAULT_VALUE    0.0;
      DISPLAY_FORMAT   "2.3f";
  }
  CONSTANT_UNIT "%";
  HELP     "Step height until the turning point or end point."
           "|de|Hhe der Sprnge bis zum Umkehrpunkt oder Endpunkt.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_285)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_min_tot
{
  LABEL    "Min. dead band" "|de|Min. Tote Zone";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DEFAULT_VALUE    0.0;
      DISPLAY_FORMAT   "2.2f";
  }
  CONSTANT_UNIT "%";
  HELP     "Smallest detected dead band."
           "|de|Angabe der ermittelten kleinsten toten Zone.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_286)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_durch_tot
{
  LABEL    "Average dead band" "|de|Durchschnittliche Tote Zone";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DEFAULT_VALUE    0.0;
      DISPLAY_FORMAT   "2.2f";
  }
  CONSTANT_UNIT "%";
  HELP     "Average measured data of the dead band."
           "|de|Angabe ber den durchschnittlichen Messwert der toten Zone.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE stepend (float_287)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_max_tot
{
  LABEL    "Max. dead band" "|de|Max. Tote Zone";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     FLOAT
  {
      DEFAULT_VALUE    0.0;
      DISPLAY_FORMAT   "2.2f";
  }
  CONSTANT_UNIT "%";
  HELP     "Greatest detected dead band."
           "|de|Angabe der ermittelten grssten toten Zone.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE step_progress (unsigned_char_280)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_progress
{
  LABEL    "Progress" "|de|Fortschritt";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DEFAULT_VALUE    0;
  }
  CONSTANT_UNIT "%";
  HELP     "Progress of the test."
           "|de|Angabe ber den Fortschritt vom Test.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_stepstart (float_282)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_start
{
  LABEL    "Start" "|de|Start";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE 50.0;
      MIN_VALUE 0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
  HELP     "Test starts at this valve position."
           "|de|Test wird bei dieser Ventilstellung gestartet.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_stepend (float_283)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_ende
{
  LABEL    "End" "|de|Ende";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      DEFAULT_VALUE 52.0;
      MIN_VALUE 0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";
  HELP     "Test runs max. to this valve position and toggles the test."
           "|de|Test luft bis max. dieser Ventilstellung und schaltet den Testverlauf um.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_delay_time_after_step (unsigned char 276)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_warte
{
  LABEL    "Delay time after step" "|de|Wartezeit nach Sprung";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DEFAULT_VALUE     1000.0; /* 1s */
      MIN_VALUE          100.0; /* normal: 0.1s */
      MAX_VALUE         2500.0; /* normal: 25s, wird aber in der Kommunikation bei 2,5s begrenzt */
  }
  CONSTANT_UNIT "ms";
  SCALING_FACTOR  100;
  HELP     "Delay time after executing the steps."
           "|de|Wartezeit nach Durchfhrung der Sprnge.";
}


/* ------------------------------------------------------------------------ */
/*
VARIABLE kl_anzahl_bis_umkehr (unsigned char 277)
(Diagnose - Testfunktionen HAND - Statische Kennlinie)
*/
VARIABLE trans1_stat_kenn_anzahl
{
  LABEL    "No. of meas. values until turn back" "|de|Anzahl bis Umkehr";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     UNSIGNED_INTEGER (1)
  {
      DEFAULT_VALUE 50;
      MIN_VALUE 1;
      MAX_VALUE 50;
  }

  HELP     "Number of measurement values recorded until the reversion."
           "|de|Anzahl der Messwerte, die bis zur Umkehr aufgenommen werden.";
}


/* ------------------------------------------------------------------------ */
/* float 500...599 */

VARIABLE trans1_stat_vs_1_0
{
  LABEL    "Ventilstellung x - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT ".2f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Ventilstellung x";
}

trans1_stat_vs_1_1 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 2"; }
trans1_stat_vs_1_2 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 3"; }
trans1_stat_vs_1_3 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 4"; }
trans1_stat_vs_1_4 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 5"; }
trans1_stat_vs_1_5 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 6"; }
trans1_stat_vs_1_6 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 7"; }
trans1_stat_vs_1_7 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 8"; }
trans1_stat_vs_1_8 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 9"; }
trans1_stat_vs_1_9 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 10"; }
trans1_stat_vs_1_10 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 11"; }
trans1_stat_vs_1_11 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 12"; }
trans1_stat_vs_1_12 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 13"; }
trans1_stat_vs_1_13 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 14"; }
trans1_stat_vs_1_14 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 15"; }
trans1_stat_vs_1_15 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 16"; }
trans1_stat_vs_1_16 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 17"; }
trans1_stat_vs_1_17 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 18"; }
trans1_stat_vs_1_18 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 19"; }
trans1_stat_vs_1_19 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 20"; }
trans1_stat_vs_1_20 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 21"; }
trans1_stat_vs_1_21 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 22"; }
trans1_stat_vs_1_22 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 23"; }
trans1_stat_vs_1_23 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 24"; }
trans1_stat_vs_1_24 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 25"; }
trans1_stat_vs_2_0 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 26"; }
trans1_stat_vs_2_1 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 27"; }
trans1_stat_vs_2_2 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 28"; }
trans1_stat_vs_2_3 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 29"; }
trans1_stat_vs_2_4 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 30"; }
trans1_stat_vs_2_5 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 31"; }
trans1_stat_vs_2_6 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 32"; }
trans1_stat_vs_2_7 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 33"; }
trans1_stat_vs_2_8 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 34"; }
trans1_stat_vs_2_9 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 35"; }
trans1_stat_vs_2_10 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 36"; }
trans1_stat_vs_2_11 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 37"; }
trans1_stat_vs_2_12 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 38"; }
trans1_stat_vs_2_13 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 39"; }
trans1_stat_vs_2_14 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 40"; }
trans1_stat_vs_2_15 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 41"; }
trans1_stat_vs_2_16 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 42"; }
trans1_stat_vs_2_17 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 43"; }
trans1_stat_vs_2_18 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 44"; }
trans1_stat_vs_2_19 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 45"; }
trans1_stat_vs_2_20 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 46"; }
trans1_stat_vs_2_21 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 47"; }
trans1_stat_vs_2_22 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 48"; }
trans1_stat_vs_2_23 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 49"; }
trans1_stat_vs_2_24 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 50"; }
trans1_stat_vs_3_0 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 51"; }
trans1_stat_vs_3_1 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 52"; }
trans1_stat_vs_3_2 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 53"; }
trans1_stat_vs_3_3 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 54"; }
trans1_stat_vs_3_4 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 55"; }
trans1_stat_vs_3_5 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 56"; }
trans1_stat_vs_3_6 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 57"; }
trans1_stat_vs_3_7 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 58"; }
trans1_stat_vs_3_8 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 59"; }
trans1_stat_vs_3_9 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 60"; }
trans1_stat_vs_3_10 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 61"; }
trans1_stat_vs_3_11 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 62"; }
trans1_stat_vs_3_12 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 63"; }
trans1_stat_vs_3_13 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 64"; }
trans1_stat_vs_3_14 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 65"; }
trans1_stat_vs_3_15 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 66"; }
trans1_stat_vs_3_16 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 67"; }
trans1_stat_vs_3_17 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 68"; }
trans1_stat_vs_3_18 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 69"; }
trans1_stat_vs_3_19 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 70"; }
trans1_stat_vs_3_20 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 71"; }
trans1_stat_vs_3_21 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 72"; }
trans1_stat_vs_3_22 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 73"; }
trans1_stat_vs_3_23 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 74"; }
trans1_stat_vs_3_24 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 75"; }
trans1_stat_vs_4_0 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 76"; }
trans1_stat_vs_4_1 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 77"; }
trans1_stat_vs_4_2 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 78"; }
trans1_stat_vs_4_3 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 79"; }
trans1_stat_vs_4_4 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 80"; }
trans1_stat_vs_4_5 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 81"; }
trans1_stat_vs_4_6 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 82"; }
trans1_stat_vs_4_7 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 83"; }
trans1_stat_vs_4_8 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 84"; }
trans1_stat_vs_4_9 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 85"; }
trans1_stat_vs_4_10 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 86"; }
trans1_stat_vs_4_11 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 87"; }
trans1_stat_vs_4_12 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 88"; }
trans1_stat_vs_4_13 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 89"; }
trans1_stat_vs_4_14 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 90"; }
trans1_stat_vs_4_15 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 91"; }
trans1_stat_vs_4_16 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 92"; }
trans1_stat_vs_4_17 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 93"; }
trans1_stat_vs_4_18 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 94"; }
trans1_stat_vs_4_19 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 95"; }
trans1_stat_vs_4_20 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 96"; }
trans1_stat_vs_4_21 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 97"; }
trans1_stat_vs_4_22 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 98"; }
trans1_stat_vs_4_23 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 99"; }
trans1_stat_vs_4_24 		LIKE  VARIABLE  		trans1_stat_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 600...699 */

VARIABLE trans1_stat_sw_1_0
{
  LABEL    "Sollwert w - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
     DISPLAY_FORMAT ".2f";
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Sollwert w";
}

trans1_stat_sw_1_1 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 2"; }
trans1_stat_sw_1_2 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 3"; }
trans1_stat_sw_1_3 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 4"; }
trans1_stat_sw_1_4 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 5"; }
trans1_stat_sw_1_5 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 6"; }
trans1_stat_sw_1_6 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 7"; }
trans1_stat_sw_1_7 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 8"; }
trans1_stat_sw_1_8 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 9"; }
trans1_stat_sw_1_9 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 10"; }
trans1_stat_sw_1_10 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 11"; }
trans1_stat_sw_1_11 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 12"; }
trans1_stat_sw_1_12 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 13"; }
trans1_stat_sw_1_13 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 14"; }
trans1_stat_sw_1_14 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 15"; }
trans1_stat_sw_1_15 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 16"; }
trans1_stat_sw_1_16 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 17"; }
trans1_stat_sw_1_17 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 18"; }
trans1_stat_sw_1_18 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 19"; }
trans1_stat_sw_1_19 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 20"; }
trans1_stat_sw_1_20 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 21"; }
trans1_stat_sw_1_21 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 22"; }
trans1_stat_sw_1_22 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 23"; }
trans1_stat_sw_1_23 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 24"; }
trans1_stat_sw_1_24 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 25"; }
trans1_stat_sw_2_0 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 26"; }
trans1_stat_sw_2_1 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 27"; }
trans1_stat_sw_2_2 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 28"; }
trans1_stat_sw_2_3 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 29"; }
trans1_stat_sw_2_4 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 30"; }
trans1_stat_sw_2_5 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 31"; }
trans1_stat_sw_2_6 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 32"; }
trans1_stat_sw_2_7 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 33"; }
trans1_stat_sw_2_8 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 34"; }
trans1_stat_sw_2_9 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 35"; }
trans1_stat_sw_2_10 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 36"; }
trans1_stat_sw_2_11 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 37"; }
trans1_stat_sw_2_12 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 38"; }
trans1_stat_sw_2_13 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 39"; }
trans1_stat_sw_2_14 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 40"; }
trans1_stat_sw_2_15 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 41"; }
trans1_stat_sw_2_16 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 42"; }
trans1_stat_sw_2_17 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 43"; }
trans1_stat_sw_2_18 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 44"; }
trans1_stat_sw_2_19 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 45"; }
trans1_stat_sw_2_20 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 46"; }
trans1_stat_sw_2_21 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 47"; }
trans1_stat_sw_2_22 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 48"; }
trans1_stat_sw_2_23 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 49"; }
trans1_stat_sw_2_24 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 50"; }
trans1_stat_sw_3_0 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 51"; }
trans1_stat_sw_3_1 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 52"; }
trans1_stat_sw_3_2 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 53"; }
trans1_stat_sw_3_3 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 54"; }
trans1_stat_sw_3_4 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 55"; }
trans1_stat_sw_3_5 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 56"; }
trans1_stat_sw_3_6 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 57"; }
trans1_stat_sw_3_7 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 58"; }
trans1_stat_sw_3_8 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 59"; }
trans1_stat_sw_3_9 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 60"; }
trans1_stat_sw_3_10 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 61"; }
trans1_stat_sw_3_11 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 62"; }
trans1_stat_sw_3_12 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 63"; }
trans1_stat_sw_3_13 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 64"; }
trans1_stat_sw_3_14 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 65"; }
trans1_stat_sw_3_15 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 66"; }
trans1_stat_sw_3_16 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 67"; }
trans1_stat_sw_3_17 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 68"; }
trans1_stat_sw_3_18 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 69"; }
trans1_stat_sw_3_19 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 70"; }
trans1_stat_sw_3_20 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 71"; }
trans1_stat_sw_3_21 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 72"; }
trans1_stat_sw_3_22 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 73"; }
trans1_stat_sw_3_23 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 74"; }
trans1_stat_sw_3_24 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 75"; }
trans1_stat_sw_4_0 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 76"; }
trans1_stat_sw_4_1 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 77"; }
trans1_stat_sw_4_2 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 78"; }
trans1_stat_sw_4_3 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 79"; }
trans1_stat_sw_4_4 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 80"; }
trans1_stat_sw_4_5 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 81"; }
trans1_stat_sw_4_6 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 82"; }
trans1_stat_sw_4_7 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 83"; }
trans1_stat_sw_4_8 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 84"; }
trans1_stat_sw_4_9 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 85"; }
trans1_stat_sw_4_10 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 86"; }
trans1_stat_sw_4_11 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 87"; }
trans1_stat_sw_4_12 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 88"; }
trans1_stat_sw_4_13 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 89"; }
trans1_stat_sw_4_14 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 90"; }
trans1_stat_sw_4_15 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 91"; }
trans1_stat_sw_4_16 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 92"; }
trans1_stat_sw_4_17 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 93"; }
trans1_stat_sw_4_18 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 94"; }
trans1_stat_sw_4_19 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 95"; }
trans1_stat_sw_4_20 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 96"; }
trans1_stat_sw_4_21 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 97"; }
trans1_stat_sw_4_22 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 98"; }
trans1_stat_sw_4_23 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 99"; }
trans1_stat_sw_4_24 		LIKE  VARIABLE  		trans1_stat_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 1000...1099 */

VARIABLE trans1_sprung_vs_1_0
{
  LABEL    "Ventilstellung x - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Ventilstellung x";
}

trans1_sprung_vs_1_1 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 2"; }
trans1_sprung_vs_1_2 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 3"; }
trans1_sprung_vs_1_3 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 4"; }
trans1_sprung_vs_1_4 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 5"; }
trans1_sprung_vs_1_5 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 6"; }
trans1_sprung_vs_1_6 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 7"; }
trans1_sprung_vs_1_7 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 8"; }
trans1_sprung_vs_1_8 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 9"; }
trans1_sprung_vs_1_9 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 10"; }
trans1_sprung_vs_1_10 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 11"; }
trans1_sprung_vs_1_11 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 12"; }
trans1_sprung_vs_1_12 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 13"; }
trans1_sprung_vs_1_13 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 14"; }
trans1_sprung_vs_1_14 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 15"; }
trans1_sprung_vs_1_15 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 16"; }
trans1_sprung_vs_1_16 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 17"; }
trans1_sprung_vs_1_17 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 18"; }
trans1_sprung_vs_1_18 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 19"; }
trans1_sprung_vs_1_19 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 20"; }
trans1_sprung_vs_1_20 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 21"; }
trans1_sprung_vs_1_21 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 22"; }
trans1_sprung_vs_1_22 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 23"; }
trans1_sprung_vs_1_23 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 24"; }
trans1_sprung_vs_1_24 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 25"; }
trans1_sprung_vs_2_0 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 26"; }
trans1_sprung_vs_2_1 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 27"; }
trans1_sprung_vs_2_2 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 28"; }
trans1_sprung_vs_2_3 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 29"; }
trans1_sprung_vs_2_4 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 30"; }
trans1_sprung_vs_2_5 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 31"; }
trans1_sprung_vs_2_6 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 32"; }
trans1_sprung_vs_2_7 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 33"; }
trans1_sprung_vs_2_8 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 34"; }
trans1_sprung_vs_2_9 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 35"; }
trans1_sprung_vs_2_10 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 36"; }
trans1_sprung_vs_2_11 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 37"; }
trans1_sprung_vs_2_12 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 38"; }
trans1_sprung_vs_2_13 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 39"; }
trans1_sprung_vs_2_14 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 40"; }
trans1_sprung_vs_2_15 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 41"; }
trans1_sprung_vs_2_16 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 42"; }
trans1_sprung_vs_2_17 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 43"; }
trans1_sprung_vs_2_18 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 44"; }
trans1_sprung_vs_2_19 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 45"; }
trans1_sprung_vs_2_20 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 46"; }
trans1_sprung_vs_2_21 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 47"; }
trans1_sprung_vs_2_22 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 48"; }
trans1_sprung_vs_2_23 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 49"; }
trans1_sprung_vs_2_24 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 50"; }
trans1_sprung_vs_3_0 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 51"; }
trans1_sprung_vs_3_1 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 52"; }
trans1_sprung_vs_3_2 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 53"; }
trans1_sprung_vs_3_3 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 54"; }
trans1_sprung_vs_3_4 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 55"; }
trans1_sprung_vs_3_5 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 56"; }
trans1_sprung_vs_3_6 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 57"; }
trans1_sprung_vs_3_7 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 58"; }
trans1_sprung_vs_3_8 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 59"; }
trans1_sprung_vs_3_9 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 60"; }
trans1_sprung_vs_3_10 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 61"; }
trans1_sprung_vs_3_11 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 62"; }
trans1_sprung_vs_3_12 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 63"; }
trans1_sprung_vs_3_13 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 64"; }
trans1_sprung_vs_3_14 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 65"; }
trans1_sprung_vs_3_15 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 66"; }
trans1_sprung_vs_3_16 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 67"; }
trans1_sprung_vs_3_17 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 68"; }
trans1_sprung_vs_3_18 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 69"; }
trans1_sprung_vs_3_19 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 70"; }
trans1_sprung_vs_3_20 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 71"; }
trans1_sprung_vs_3_21 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 72"; }
trans1_sprung_vs_3_22 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 73"; }
trans1_sprung_vs_3_23 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 74"; }
trans1_sprung_vs_3_24 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 75"; }
trans1_sprung_vs_4_0 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 76"; }
trans1_sprung_vs_4_1 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 77"; }
trans1_sprung_vs_4_2 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 78"; }
trans1_sprung_vs_4_3 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 79"; }
trans1_sprung_vs_4_4 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 80"; }
trans1_sprung_vs_4_5 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 81"; }
trans1_sprung_vs_4_6 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 82"; }
trans1_sprung_vs_4_7 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 83"; }
trans1_sprung_vs_4_8 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 84"; }
trans1_sprung_vs_4_9 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 85"; }
trans1_sprung_vs_4_10 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 86"; }
trans1_sprung_vs_4_11 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 87"; }
trans1_sprung_vs_4_12 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 88"; }
trans1_sprung_vs_4_13 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 89"; }
trans1_sprung_vs_4_14 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 90"; }
trans1_sprung_vs_4_15 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 91"; }
trans1_sprung_vs_4_16 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 92"; }
trans1_sprung_vs_4_17 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 93"; }
trans1_sprung_vs_4_18 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 94"; }
trans1_sprung_vs_4_19 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 95"; }
trans1_sprung_vs_4_20 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 96"; }
trans1_sprung_vs_4_21 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 97"; }
trans1_sprung_vs_4_22 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 98"; }
trans1_sprung_vs_4_23 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 99"; }
trans1_sprung_vs_4_24 		LIKE  VARIABLE  		trans1_sprung_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 1100...1199 */

VARIABLE trans1_sprung_sw_1_0
{
  LABEL    "Sollwert w - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Sollwert w";
}

trans1_sprung_sw_1_1 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 2"; }
trans1_sprung_sw_1_2 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 3"; }
trans1_sprung_sw_1_3 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 4"; }
trans1_sprung_sw_1_4 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 5"; }
trans1_sprung_sw_1_5 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 6"; }
trans1_sprung_sw_1_6 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 7"; }
trans1_sprung_sw_1_7 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 8"; }
trans1_sprung_sw_1_8 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 9"; }
trans1_sprung_sw_1_9 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 10"; }
trans1_sprung_sw_1_10 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 11"; }
trans1_sprung_sw_1_11 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 12"; }
trans1_sprung_sw_1_12 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 13"; }
trans1_sprung_sw_1_13 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 14"; }
trans1_sprung_sw_1_14 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 15"; }
trans1_sprung_sw_1_15 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 16"; }
trans1_sprung_sw_1_16 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 17"; }
trans1_sprung_sw_1_17 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 18"; }
trans1_sprung_sw_1_18 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 19"; }
trans1_sprung_sw_1_19 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 20"; }
trans1_sprung_sw_1_20 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 21"; }
trans1_sprung_sw_1_21 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 22"; }
trans1_sprung_sw_1_22 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 23"; }
trans1_sprung_sw_1_23 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 24"; }
trans1_sprung_sw_1_24 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 25"; }
trans1_sprung_sw_2_0 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 26"; }
trans1_sprung_sw_2_1 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 27"; }
trans1_sprung_sw_2_2 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 28"; }
trans1_sprung_sw_2_3 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 29"; }
trans1_sprung_sw_2_4 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 30"; }
trans1_sprung_sw_2_5 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 31"; }
trans1_sprung_sw_2_6 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 32"; }
trans1_sprung_sw_2_7 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 33"; }
trans1_sprung_sw_2_8 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 34"; }
trans1_sprung_sw_2_9 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 35"; }
trans1_sprung_sw_2_10 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 36"; }
trans1_sprung_sw_2_11 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 37"; }
trans1_sprung_sw_2_12 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 38"; }
trans1_sprung_sw_2_13 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 39"; }
trans1_sprung_sw_2_14 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 40"; }
trans1_sprung_sw_2_15 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 41"; }
trans1_sprung_sw_2_16 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 42"; }
trans1_sprung_sw_2_17 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 43"; }
trans1_sprung_sw_2_18 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 44"; }
trans1_sprung_sw_2_19 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 45"; }
trans1_sprung_sw_2_20 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 46"; }
trans1_sprung_sw_2_21 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 47"; }
trans1_sprung_sw_2_22 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 48"; }
trans1_sprung_sw_2_23 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 49"; }
trans1_sprung_sw_2_24 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 50"; }
trans1_sprung_sw_3_0 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 51"; }
trans1_sprung_sw_3_1 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 52"; }
trans1_sprung_sw_3_2 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 53"; }
trans1_sprung_sw_3_3 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 54"; }
trans1_sprung_sw_3_4 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 55"; }
trans1_sprung_sw_3_5 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 56"; }
trans1_sprung_sw_3_6 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 57"; }
trans1_sprung_sw_3_7 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 58"; }
trans1_sprung_sw_3_8 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 59"; }
trans1_sprung_sw_3_9 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 60"; }
trans1_sprung_sw_3_10 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 61"; }
trans1_sprung_sw_3_11 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 62"; }
trans1_sprung_sw_3_12 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 63"; }
trans1_sprung_sw_3_13 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 64"; }
trans1_sprung_sw_3_14 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 65"; }
trans1_sprung_sw_3_15 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 66"; }
trans1_sprung_sw_3_16 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 67"; }
trans1_sprung_sw_3_17 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 68"; }
trans1_sprung_sw_3_18 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 69"; }
trans1_sprung_sw_3_19 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 70"; }
trans1_sprung_sw_3_20 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 71"; }
trans1_sprung_sw_3_21 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 72"; }
trans1_sprung_sw_3_22 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 73"; }
trans1_sprung_sw_3_23 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 74"; }
trans1_sprung_sw_3_24 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 75"; }
trans1_sprung_sw_4_0 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 76"; }
trans1_sprung_sw_4_1 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 77"; }
trans1_sprung_sw_4_2 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 78"; }
trans1_sprung_sw_4_3 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 79"; }
trans1_sprung_sw_4_4 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 80"; }
trans1_sprung_sw_4_5 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 81"; }
trans1_sprung_sw_4_6 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 82"; }
trans1_sprung_sw_4_7 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 83"; }
trans1_sprung_sw_4_8 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 84"; }
trans1_sprung_sw_4_9 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 85"; }
trans1_sprung_sw_4_10 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 86"; }
trans1_sprung_sw_4_11 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 87"; }
trans1_sprung_sw_4_12 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 88"; }
trans1_sprung_sw_4_13 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 89"; }
trans1_sprung_sw_4_14 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 90"; }
trans1_sprung_sw_4_15 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 91"; }
trans1_sprung_sw_4_16 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 92"; }
trans1_sprung_sw_4_17 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 93"; }
trans1_sprung_sw_4_18 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 94"; }
trans1_sprung_sw_4_19 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 95"; }
trans1_sprung_sw_4_20 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 96"; }
trans1_sprung_sw_4_21 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 97"; }
trans1_sprung_sw_4_22 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 98"; }
trans1_sprung_sw_4_23 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 99"; }
trans1_sprung_sw_4_24 		LIKE  VARIABLE  		trans1_sprung_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* unsigned integer 300...399 */

VARIABLE trans1_sprung_ss_1_0
{
  LABEL    "Stellsignal y - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";
  HELP     "|de|Stellsignal y";
}

trans1_sprung_ss_1_1 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 2"; }
trans1_sprung_ss_1_2 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 3"; }
trans1_sprung_ss_1_3 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 4"; }
trans1_sprung_ss_1_4 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 5"; }
trans1_sprung_ss_1_5 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 6"; }
trans1_sprung_ss_1_6 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 7"; }
trans1_sprung_ss_1_7 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 8"; }
trans1_sprung_ss_1_8 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 9"; }
trans1_sprung_ss_1_9 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 10"; }
trans1_sprung_ss_1_10 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 11"; }
trans1_sprung_ss_1_11 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 12"; }
trans1_sprung_ss_1_12 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 13"; }
trans1_sprung_ss_1_13 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 14"; }
trans1_sprung_ss_1_14 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 15"; }
trans1_sprung_ss_1_15 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 16"; }
trans1_sprung_ss_1_16 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 17"; }
trans1_sprung_ss_1_17 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 18"; }
trans1_sprung_ss_1_18 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 19"; }
trans1_sprung_ss_1_19 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 20"; }
trans1_sprung_ss_1_20 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 21"; }
trans1_sprung_ss_1_21 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 22"; }
trans1_sprung_ss_1_22 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 23"; }
trans1_sprung_ss_1_23 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 24"; }
trans1_sprung_ss_1_24 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 25"; }
trans1_sprung_ss_1_25 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 26"; }
trans1_sprung_ss_1_26 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 27"; }
trans1_sprung_ss_1_27 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 28"; }
trans1_sprung_ss_1_28 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 29"; }
trans1_sprung_ss_1_29 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 30"; }
trans1_sprung_ss_1_30 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 31"; }
trans1_sprung_ss_1_31 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 32"; }
trans1_sprung_ss_1_32 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 33"; }
trans1_sprung_ss_1_33 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 34"; }
trans1_sprung_ss_1_34 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 35"; }
trans1_sprung_ss_1_35 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 36"; }
trans1_sprung_ss_1_36 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 37"; }
trans1_sprung_ss_1_37 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 38"; }
trans1_sprung_ss_1_38 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 39"; }
trans1_sprung_ss_1_39 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 40"; }
trans1_sprung_ss_1_40 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 41"; }
trans1_sprung_ss_1_41 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 42"; }
trans1_sprung_ss_1_42 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 43"; }
trans1_sprung_ss_1_43 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 44"; }
trans1_sprung_ss_1_44 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 45"; }
trans1_sprung_ss_1_45 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 46"; }
trans1_sprung_ss_1_46 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 47"; }
trans1_sprung_ss_1_47 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 48"; }
trans1_sprung_ss_1_48 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 49"; }
trans1_sprung_ss_1_49 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 50"; }
trans1_sprung_ss_2_0 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 51"; }
trans1_sprung_ss_2_1 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 52"; }
trans1_sprung_ss_2_2 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 53"; }
trans1_sprung_ss_2_3 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 54"; }
trans1_sprung_ss_2_4 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 55"; }
trans1_sprung_ss_2_5 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 56"; }
trans1_sprung_ss_2_6 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 57"; }
trans1_sprung_ss_2_7 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 58"; }
trans1_sprung_ss_2_8 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 59"; }
trans1_sprung_ss_2_9 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 60"; }
trans1_sprung_ss_2_10 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 61"; }
trans1_sprung_ss_2_11 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 62"; }
trans1_sprung_ss_2_12 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 63"; }
trans1_sprung_ss_2_13 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 64"; }
trans1_sprung_ss_2_14 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 65"; }
trans1_sprung_ss_2_15 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 66"; }
trans1_sprung_ss_2_16 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 67"; }
trans1_sprung_ss_2_17 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 68"; }
trans1_sprung_ss_2_18 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 69"; }
trans1_sprung_ss_2_19 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 70"; }
trans1_sprung_ss_2_20 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 71"; }
trans1_sprung_ss_2_21 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 72"; }
trans1_sprung_ss_2_22 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 73"; }
trans1_sprung_ss_2_23 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 74"; }
trans1_sprung_ss_2_24 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 75"; }
trans1_sprung_ss_2_25 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 76"; }
trans1_sprung_ss_2_26 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 77"; }
trans1_sprung_ss_2_27 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 78"; }
trans1_sprung_ss_2_28 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 79"; }
trans1_sprung_ss_2_29 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 80"; }
trans1_sprung_ss_2_30 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 81"; }
trans1_sprung_ss_2_31 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 82"; }
trans1_sprung_ss_2_32 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 83"; }
trans1_sprung_ss_2_33 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 84"; }
trans1_sprung_ss_2_34 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 85"; }
trans1_sprung_ss_2_35 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 86"; }
trans1_sprung_ss_2_36 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 87"; }
trans1_sprung_ss_2_37 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 88"; }
trans1_sprung_ss_2_38 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 89"; }
trans1_sprung_ss_2_39 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 90"; }
trans1_sprung_ss_2_40 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 91"; }
trans1_sprung_ss_2_41 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 92"; }
trans1_sprung_ss_2_42 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 93"; }
trans1_sprung_ss_2_43 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 94"; }
trans1_sprung_ss_2_44 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 95"; }
trans1_sprung_ss_2_45 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 96"; }
trans1_sprung_ss_2_46 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 97"; }
trans1_sprung_ss_2_47 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 98"; }
trans1_sprung_ss_2_48 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 99"; }
trans1_sprung_ss_2_49 		LIKE  VARIABLE  		trans1_sprung_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* float 400...499 */

VARIABLE trans1_sprung_e_1_0
{
  LABEL    "Regelabweichung e - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Regelabweichung e";
}

trans1_sprung_e_1_1 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 2"; }
trans1_sprung_e_1_2 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 3"; }
trans1_sprung_e_1_3 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 4"; }
trans1_sprung_e_1_4 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 5"; }
trans1_sprung_e_1_5 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 6"; }
trans1_sprung_e_1_6 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 7"; }
trans1_sprung_e_1_7 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 8"; }
trans1_sprung_e_1_8 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 9"; }
trans1_sprung_e_1_9 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 10"; }
trans1_sprung_e_1_10 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 11"; }
trans1_sprung_e_1_11 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 12"; }
trans1_sprung_e_1_12 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 13"; }
trans1_sprung_e_1_13 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 14"; }
trans1_sprung_e_1_14 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 15"; }
trans1_sprung_e_1_15 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 16"; }
trans1_sprung_e_1_16 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 17"; }
trans1_sprung_e_1_17 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 18"; }
trans1_sprung_e_1_18 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 19"; }
trans1_sprung_e_1_19 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 20"; }
trans1_sprung_e_1_20 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 21"; }
trans1_sprung_e_1_21 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 22"; }
trans1_sprung_e_1_22 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 23"; }
trans1_sprung_e_1_23 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 24"; }
trans1_sprung_e_1_24 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 25"; }
trans1_sprung_e_2_0 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 26"; }
trans1_sprung_e_2_1 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 27"; }
trans1_sprung_e_2_2 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 28"; }
trans1_sprung_e_2_3 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 29"; }
trans1_sprung_e_2_4 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 30"; }
trans1_sprung_e_2_5 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 31"; }
trans1_sprung_e_2_6 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 32"; }
trans1_sprung_e_2_7 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 33"; }
trans1_sprung_e_2_8 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 34"; }
trans1_sprung_e_2_9 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 35"; }
trans1_sprung_e_2_10 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 36"; }
trans1_sprung_e_2_11 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 37"; }
trans1_sprung_e_2_12 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 38"; }
trans1_sprung_e_2_13 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 39"; }
trans1_sprung_e_2_14 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 40"; }
trans1_sprung_e_2_15 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 41"; }
trans1_sprung_e_2_16 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 42"; }
trans1_sprung_e_2_17 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 43"; }
trans1_sprung_e_2_18 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 44"; }
trans1_sprung_e_2_19 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 45"; }
trans1_sprung_e_2_20 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 46"; }
trans1_sprung_e_2_21 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 47"; }
trans1_sprung_e_2_22 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 48"; }
trans1_sprung_e_2_23 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 49"; }
trans1_sprung_e_2_24 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 50"; }
trans1_sprung_e_3_0 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 51"; }
trans1_sprung_e_3_1 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 52"; }
trans1_sprung_e_3_2 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 53"; }
trans1_sprung_e_3_3 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 54"; }
trans1_sprung_e_3_4 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 55"; }
trans1_sprung_e_3_5 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 56"; }
trans1_sprung_e_3_6 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 57"; }
trans1_sprung_e_3_7 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 58"; }
trans1_sprung_e_3_8 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 59"; }
trans1_sprung_e_3_9 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 60"; }
trans1_sprung_e_3_10 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 61"; }
trans1_sprung_e_3_11 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 62"; }
trans1_sprung_e_3_12 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 63"; }
trans1_sprung_e_3_13 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 64"; }
trans1_sprung_e_3_14 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 65"; }
trans1_sprung_e_3_15 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 66"; }
trans1_sprung_e_3_16 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 67"; }
trans1_sprung_e_3_17 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 68"; }
trans1_sprung_e_3_18 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 69"; }
trans1_sprung_e_3_19 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 70"; }
trans1_sprung_e_3_20 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 71"; }
trans1_sprung_e_3_21 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 72"; }
trans1_sprung_e_3_22 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 73"; }
trans1_sprung_e_3_23 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 74"; }
trans1_sprung_e_3_24 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 75"; }
trans1_sprung_e_4_0 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 76"; }
trans1_sprung_e_4_1 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 77"; }
trans1_sprung_e_4_2 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 78"; }
trans1_sprung_e_4_3 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 79"; }
trans1_sprung_e_4_4 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 80"; }
trans1_sprung_e_4_5 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 81"; }
trans1_sprung_e_4_6 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 82"; }
trans1_sprung_e_4_7 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 83"; }
trans1_sprung_e_4_8 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 84"; }
trans1_sprung_e_4_9 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 85"; }
trans1_sprung_e_4_10 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 86"; }
trans1_sprung_e_4_11 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 87"; }
trans1_sprung_e_4_12 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 88"; }
trans1_sprung_e_4_13 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 89"; }
trans1_sprung_e_4_14 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 90"; }
trans1_sprung_e_4_15 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 91"; }
trans1_sprung_e_4_16 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 92"; }
trans1_sprung_e_4_17 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 93"; }
trans1_sprung_e_4_18 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 94"; }
trans1_sprung_e_4_19 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 95"; }
trans1_sprung_e_4_20 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 96"; }
trans1_sprung_e_4_21 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 97"; }
trans1_sprung_e_4_22 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 98"; }
trans1_sprung_e_4_23 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 99"; }
trans1_sprung_e_4_24 		LIKE  VARIABLE  		trans1_sprung_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 100"; }


/* ------------------------------------------------------------------------ */
/* unsigned long 300...399 */

VARIABLE trans1_sprung_t_1_0
{
  LABEL    "Zeitmesswert - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "s";
  HELP     "|de|Zeitmesswert";
}

trans1_sprung_t_1_1 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 2"; }
trans1_sprung_t_1_2 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 3"; }
trans1_sprung_t_1_3 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 4"; }
trans1_sprung_t_1_4 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 5"; }
trans1_sprung_t_1_5 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 6"; }
trans1_sprung_t_1_6 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 7"; }
trans1_sprung_t_1_7 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 8"; }
trans1_sprung_t_1_8 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 9"; }
trans1_sprung_t_1_9 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 10"; }
trans1_sprung_t_1_10 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 11"; }
trans1_sprung_t_1_11 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 12"; }
trans1_sprung_t_1_12 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 13"; }
trans1_sprung_t_1_13 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 14"; }
trans1_sprung_t_1_14 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 15"; }
trans1_sprung_t_1_15 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 16"; }
trans1_sprung_t_1_16 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 17"; }
trans1_sprung_t_1_17 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 18"; }
trans1_sprung_t_1_18 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 19"; }
trans1_sprung_t_1_19 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 20"; }
trans1_sprung_t_1_20 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 21"; }
trans1_sprung_t_1_21 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 22"; }
trans1_sprung_t_1_22 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 23"; }
trans1_sprung_t_1_23 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 24"; }
trans1_sprung_t_1_24 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 25"; }
trans1_sprung_t_2_0 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 26"; }
trans1_sprung_t_2_1 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 27"; }
trans1_sprung_t_2_2 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 28"; }
trans1_sprung_t_2_3 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 29"; }
trans1_sprung_t_2_4 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 30"; }
trans1_sprung_t_2_5 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 31"; }
trans1_sprung_t_2_6 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 32"; }
trans1_sprung_t_2_7 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 33"; }
trans1_sprung_t_2_8 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 34"; }
trans1_sprung_t_2_9 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 35"; }
trans1_sprung_t_2_10 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 36"; }
trans1_sprung_t_2_11 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 37"; }
trans1_sprung_t_2_12 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 38"; }
trans1_sprung_t_2_13 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 39"; }
trans1_sprung_t_2_14 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 40"; }
trans1_sprung_t_2_15 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 41"; }
trans1_sprung_t_2_16 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 42"; }
trans1_sprung_t_2_17 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 43"; }
trans1_sprung_t_2_18 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 44"; }
trans1_sprung_t_2_19 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 45"; }
trans1_sprung_t_2_20 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 46"; }
trans1_sprung_t_2_21 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 47"; }
trans1_sprung_t_2_22 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 48"; }
trans1_sprung_t_2_23 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 49"; }
trans1_sprung_t_2_24 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 50"; }
trans1_sprung_t_3_0 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 51"; }
trans1_sprung_t_3_1 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 52"; }
trans1_sprung_t_3_2 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 53"; }
trans1_sprung_t_3_3 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 54"; }
trans1_sprung_t_3_4 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 55"; }
trans1_sprung_t_3_5 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 56"; }
trans1_sprung_t_3_6 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 57"; }
trans1_sprung_t_3_7 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 58"; }
trans1_sprung_t_3_8 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 59"; }
trans1_sprung_t_3_9 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 60"; }
trans1_sprung_t_3_10 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 61"; }
trans1_sprung_t_3_11 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 62"; }
trans1_sprung_t_3_12 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 63"; }
trans1_sprung_t_3_13 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 64"; }
trans1_sprung_t_3_14 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 65"; }
trans1_sprung_t_3_15 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 66"; }
trans1_sprung_t_3_16 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 67"; }
trans1_sprung_t_3_17 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 68"; }
trans1_sprung_t_3_18 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 69"; }
trans1_sprung_t_3_19 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 70"; }
trans1_sprung_t_3_20 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 71"; }
trans1_sprung_t_3_21 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 72"; }
trans1_sprung_t_3_22 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 73"; }
trans1_sprung_t_3_23 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 74"; }
trans1_sprung_t_3_24 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 75"; }
trans1_sprung_t_4_0 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 76"; }
trans1_sprung_t_4_1 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 77"; }
trans1_sprung_t_4_2 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 78"; }
trans1_sprung_t_4_3 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 79"; }
trans1_sprung_t_4_4 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 80"; }
trans1_sprung_t_4_5 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 81"; }
trans1_sprung_t_4_6 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 82"; }
trans1_sprung_t_4_7 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 83"; }
trans1_sprung_t_4_8 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 84"; }
trans1_sprung_t_4_9 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 85"; }
trans1_sprung_t_4_10 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 86"; }
trans1_sprung_t_4_11 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 87"; }
trans1_sprung_t_4_12 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 88"; }
trans1_sprung_t_4_13 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 89"; }
trans1_sprung_t_4_14 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 90"; }
trans1_sprung_t_4_15 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 91"; }
trans1_sprung_t_4_16 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 92"; }
trans1_sprung_t_4_17 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 93"; }
trans1_sprung_t_4_18 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 94"; }
trans1_sprung_t_4_19 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 95"; }
trans1_sprung_t_4_20 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 96"; }
trans1_sprung_t_4_21 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 97"; }
trans1_sprung_t_4_22 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 98"; }
trans1_sprung_t_4_23 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 99"; }
trans1_sprung_t_4_24 		LIKE  VARIABLE  		trans1_sprung_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 100"; }


/* float 900...999 */

VARIABLE trans1_datalogger_vs_1_0
{
  LABEL    "Ventilstellung x - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Ventilstellung x";
}

trans1_datalogger_vs_1_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 2"; }
trans1_datalogger_vs_1_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 3"; }
trans1_datalogger_vs_1_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 4"; }
trans1_datalogger_vs_1_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 5"; }
trans1_datalogger_vs_1_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 6"; }
trans1_datalogger_vs_1_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 7"; }
trans1_datalogger_vs_2_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 8"; }
trans1_datalogger_vs_2_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 9"; }
trans1_datalogger_vs_2_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 10"; }
trans1_datalogger_vs_2_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 11"; }
trans1_datalogger_vs_2_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 12"; }
trans1_datalogger_vs_2_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 13"; }
trans1_datalogger_vs_2_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 14"; }
trans1_datalogger_vs_3_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 15"; }
trans1_datalogger_vs_3_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 16"; }
trans1_datalogger_vs_3_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 17"; }
trans1_datalogger_vs_3_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 18"; }
trans1_datalogger_vs_3_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 19"; }
trans1_datalogger_vs_3_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 20"; }
trans1_datalogger_vs_3_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 21"; }
trans1_datalogger_vs_4_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 22"; }
trans1_datalogger_vs_4_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 23"; }
trans1_datalogger_vs_4_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 24"; }
trans1_datalogger_vs_4_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 25"; }
trans1_datalogger_vs_4_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 26"; }
trans1_datalogger_vs_4_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 27"; }
trans1_datalogger_vs_4_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 28"; }
trans1_datalogger_vs_5_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 29"; }
trans1_datalogger_vs_5_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 30"; }
trans1_datalogger_vs_5_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 31"; }
trans1_datalogger_vs_5_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 32"; }
trans1_datalogger_vs_5_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 33"; }
trans1_datalogger_vs_5_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 34"; }
trans1_datalogger_vs_5_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 35"; }
trans1_datalogger_vs_6_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 36"; }
trans1_datalogger_vs_6_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 37"; }
trans1_datalogger_vs_6_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 38"; }
trans1_datalogger_vs_6_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 39"; }
trans1_datalogger_vs_6_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 40"; }
trans1_datalogger_vs_6_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 41"; }
trans1_datalogger_vs_6_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 42"; }
trans1_datalogger_vs_7_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 43"; }
trans1_datalogger_vs_7_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 44"; }
trans1_datalogger_vs_7_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 45"; }
trans1_datalogger_vs_7_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 46"; }
trans1_datalogger_vs_7_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 47"; }
trans1_datalogger_vs_7_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 48"; }
trans1_datalogger_vs_7_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 49"; }
trans1_datalogger_vs_8_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 50"; }
trans1_datalogger_vs_8_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 51"; }
trans1_datalogger_vs_8_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 52"; }
trans1_datalogger_vs_8_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 53"; }
trans1_datalogger_vs_8_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 54"; }
trans1_datalogger_vs_8_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 55"; }
trans1_datalogger_vs_8_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 56"; }
trans1_datalogger_vs_9_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 57"; }
trans1_datalogger_vs_9_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 58"; }
trans1_datalogger_vs_9_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 59"; }
trans1_datalogger_vs_9_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 60"; }
trans1_datalogger_vs_9_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 61"; }
trans1_datalogger_vs_9_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 62"; }
trans1_datalogger_vs_9_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 63"; }
trans1_datalogger_vs_10_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 64"; }
trans1_datalogger_vs_10_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 65"; }
trans1_datalogger_vs_10_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 66"; }
trans1_datalogger_vs_10_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 67"; }
trans1_datalogger_vs_10_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 68"; }
trans1_datalogger_vs_10_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 69"; }
trans1_datalogger_vs_10_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 70"; }
trans1_datalogger_vs_11_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 71"; }
trans1_datalogger_vs_11_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 72"; }
trans1_datalogger_vs_11_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 73"; }
trans1_datalogger_vs_11_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 74"; }
trans1_datalogger_vs_11_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 75"; }
trans1_datalogger_vs_11_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 76"; }
trans1_datalogger_vs_11_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 77"; }
trans1_datalogger_vs_12_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 78"; }
trans1_datalogger_vs_12_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 79"; }
trans1_datalogger_vs_12_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 80"; }
trans1_datalogger_vs_12_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 81"; }
trans1_datalogger_vs_12_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 82"; }
trans1_datalogger_vs_12_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 83"; }
trans1_datalogger_vs_12_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 84"; }
trans1_datalogger_vs_13_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 85"; }
trans1_datalogger_vs_13_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 86"; }
trans1_datalogger_vs_13_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 87"; }
trans1_datalogger_vs_13_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 88"; }
trans1_datalogger_vs_13_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 89"; }
trans1_datalogger_vs_13_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 90"; }
trans1_datalogger_vs_13_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 91"; }
trans1_datalogger_vs_14_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 92"; }
trans1_datalogger_vs_14_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 93"; }
trans1_datalogger_vs_14_2 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 94"; }
trans1_datalogger_vs_14_3 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 95"; }
trans1_datalogger_vs_14_4 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 96"; }
trans1_datalogger_vs_14_5 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 97"; }
trans1_datalogger_vs_14_6 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 98"; }
trans1_datalogger_vs_15_0 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 99"; }
trans1_datalogger_vs_15_1 		LIKE  VARIABLE  		trans1_datalogger_vs_1_0
{ REDEFINE LABEL "Ventilstellung x - Messpunkt - 100"; }


/* float 700...799 */

VARIABLE trans1_datalogger_sw_1_0
{
  LABEL    "Sollwert w - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Sollwert w";
}

trans1_datalogger_sw_1_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 2"; }
trans1_datalogger_sw_1_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 3"; }
trans1_datalogger_sw_1_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 4"; }
trans1_datalogger_sw_1_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 5"; }
trans1_datalogger_sw_1_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 6"; }
trans1_datalogger_sw_1_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 7"; }
trans1_datalogger_sw_2_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 8"; }
trans1_datalogger_sw_2_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 9"; }
trans1_datalogger_sw_2_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 10"; }
trans1_datalogger_sw_2_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 11"; }
trans1_datalogger_sw_2_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 12"; }
trans1_datalogger_sw_2_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 13"; }
trans1_datalogger_sw_2_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 14"; }
trans1_datalogger_sw_3_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 15"; }
trans1_datalogger_sw_3_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 16"; }
trans1_datalogger_sw_3_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 17"; }
trans1_datalogger_sw_3_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 18"; }
trans1_datalogger_sw_3_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 19"; }
trans1_datalogger_sw_3_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 20"; }
trans1_datalogger_sw_3_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 21"; }
trans1_datalogger_sw_4_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 22"; }
trans1_datalogger_sw_4_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 23"; }
trans1_datalogger_sw_4_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 24"; }
trans1_datalogger_sw_4_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 25"; }
trans1_datalogger_sw_4_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 26"; }
trans1_datalogger_sw_4_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 27"; }
trans1_datalogger_sw_4_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 28"; }
trans1_datalogger_sw_5_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 29"; }
trans1_datalogger_sw_5_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 30"; }
trans1_datalogger_sw_5_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 31"; }
trans1_datalogger_sw_5_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 32"; }
trans1_datalogger_sw_5_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 33"; }
trans1_datalogger_sw_5_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 34"; }
trans1_datalogger_sw_5_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 35"; }
trans1_datalogger_sw_6_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 36"; }
trans1_datalogger_sw_6_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 37"; }
trans1_datalogger_sw_6_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 38"; }
trans1_datalogger_sw_6_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 39"; }
trans1_datalogger_sw_6_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 40"; }
trans1_datalogger_sw_6_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 41"; }
trans1_datalogger_sw_6_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 42"; }
trans1_datalogger_sw_7_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 43"; }
trans1_datalogger_sw_7_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 44"; }
trans1_datalogger_sw_7_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 45"; }
trans1_datalogger_sw_7_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 46"; }
trans1_datalogger_sw_7_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 47"; }
trans1_datalogger_sw_7_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 48"; }
trans1_datalogger_sw_7_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 49"; }
trans1_datalogger_sw_8_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 50"; }
trans1_datalogger_sw_8_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 51"; }
trans1_datalogger_sw_8_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 52"; }
trans1_datalogger_sw_8_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 53"; }
trans1_datalogger_sw_8_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 54"; }
trans1_datalogger_sw_8_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 55"; }
trans1_datalogger_sw_8_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 56"; }
trans1_datalogger_sw_9_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 57"; }
trans1_datalogger_sw_9_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 58"; }
trans1_datalogger_sw_9_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 59"; }
trans1_datalogger_sw_9_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 60"; }
trans1_datalogger_sw_9_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 61"; }
trans1_datalogger_sw_9_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 62"; }
trans1_datalogger_sw_9_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 63"; }
trans1_datalogger_sw_10_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 64"; }
trans1_datalogger_sw_10_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 65"; }
trans1_datalogger_sw_10_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 66"; }
trans1_datalogger_sw_10_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 67"; }
trans1_datalogger_sw_10_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 68"; }
trans1_datalogger_sw_10_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 69"; }
trans1_datalogger_sw_10_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 70"; }
trans1_datalogger_sw_11_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 71"; }
trans1_datalogger_sw_11_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 72"; }
trans1_datalogger_sw_11_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 73"; }
trans1_datalogger_sw_11_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 74"; }
trans1_datalogger_sw_11_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 75"; }
trans1_datalogger_sw_11_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 76"; }
trans1_datalogger_sw_11_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 77"; }
trans1_datalogger_sw_12_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 78"; }
trans1_datalogger_sw_12_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 79"; }
trans1_datalogger_sw_12_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 80"; }
trans1_datalogger_sw_12_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 81"; }
trans1_datalogger_sw_12_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 82"; }
trans1_datalogger_sw_12_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 83"; }
trans1_datalogger_sw_12_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 84"; }
trans1_datalogger_sw_13_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 85"; }
trans1_datalogger_sw_13_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 86"; }
trans1_datalogger_sw_13_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 87"; }
trans1_datalogger_sw_13_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 88"; }
trans1_datalogger_sw_13_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 89"; }
trans1_datalogger_sw_13_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 90"; }
trans1_datalogger_sw_13_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 91"; }
trans1_datalogger_sw_14_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 92"; }
trans1_datalogger_sw_14_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 93"; }
trans1_datalogger_sw_14_2 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 94"; }
trans1_datalogger_sw_14_3 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 95"; }
trans1_datalogger_sw_14_4 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 96"; }
trans1_datalogger_sw_14_5 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 97"; }
trans1_datalogger_sw_14_6 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 98"; }
trans1_datalogger_sw_15_0 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 99"; }
trans1_datalogger_sw_15_1 		LIKE  VARIABLE  		trans1_datalogger_sw_1_0
{ REDEFINE LABEL "Sollwert w - Messpunkt - 100"; }



/* unsigned int 400...499 */

VARIABLE trans1_datalogger_ss_1_0
{
  LABEL    "Stellsignal y - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (2)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "1/s";
  HELP     "|de|Stellsignal y";
}

trans1_datalogger_ss_1_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 2"; }
trans1_datalogger_ss_1_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 3"; }
trans1_datalogger_ss_1_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 4"; }
trans1_datalogger_ss_1_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 5"; }
trans1_datalogger_ss_1_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 6"; }
trans1_datalogger_ss_1_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 7"; }
trans1_datalogger_ss_2_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 8"; }
trans1_datalogger_ss_2_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 9"; }
trans1_datalogger_ss_2_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 10"; }
trans1_datalogger_ss_2_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 11"; }
trans1_datalogger_ss_2_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 12"; }
trans1_datalogger_ss_2_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 13"; }
trans1_datalogger_ss_2_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 14"; }
trans1_datalogger_ss_3_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 15"; }
trans1_datalogger_ss_3_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 16"; }
trans1_datalogger_ss_3_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 17"; }
trans1_datalogger_ss_3_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 18"; }
trans1_datalogger_ss_3_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 19"; }
trans1_datalogger_ss_3_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 20"; }
trans1_datalogger_ss_3_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 21"; }
trans1_datalogger_ss_4_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 22"; }
trans1_datalogger_ss_4_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 23"; }
trans1_datalogger_ss_4_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 24"; }
trans1_datalogger_ss_4_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 25"; }
trans1_datalogger_ss_4_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 26"; }
trans1_datalogger_ss_4_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 27"; }
trans1_datalogger_ss_4_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 28"; }
trans1_datalogger_ss_5_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 29"; }
trans1_datalogger_ss_5_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 30"; }
trans1_datalogger_ss_5_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 31"; }
trans1_datalogger_ss_5_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 32"; }
trans1_datalogger_ss_5_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 33"; }
trans1_datalogger_ss_5_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 34"; }
trans1_datalogger_ss_5_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 35"; }
trans1_datalogger_ss_6_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 36"; }
trans1_datalogger_ss_6_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 37"; }
trans1_datalogger_ss_6_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 38"; }
trans1_datalogger_ss_6_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 39"; }
trans1_datalogger_ss_6_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 40"; }
trans1_datalogger_ss_6_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 41"; }
trans1_datalogger_ss_6_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 42"; }
trans1_datalogger_ss_7_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 43"; }
trans1_datalogger_ss_7_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 44"; }
trans1_datalogger_ss_7_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 45"; }
trans1_datalogger_ss_7_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 46"; }
trans1_datalogger_ss_7_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 47"; }
trans1_datalogger_ss_7_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 48"; }
trans1_datalogger_ss_7_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 49"; }
trans1_datalogger_ss_8_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 50"; }
trans1_datalogger_ss_8_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 51"; }
trans1_datalogger_ss_8_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 52"; }
trans1_datalogger_ss_8_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 53"; }
trans1_datalogger_ss_8_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 54"; }
trans1_datalogger_ss_8_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 55"; }
trans1_datalogger_ss_8_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 56"; }
trans1_datalogger_ss_9_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 57"; }
trans1_datalogger_ss_9_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 58"; }
trans1_datalogger_ss_9_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 59"; }
trans1_datalogger_ss_9_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 60"; }
trans1_datalogger_ss_9_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 61"; }
trans1_datalogger_ss_9_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 62"; }
trans1_datalogger_ss_9_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 63"; }
trans1_datalogger_ss_10_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 64"; }
trans1_datalogger_ss_10_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 65"; }
trans1_datalogger_ss_10_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 66"; }
trans1_datalogger_ss_10_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 67"; }
trans1_datalogger_ss_10_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 68"; }
trans1_datalogger_ss_10_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 69"; }
trans1_datalogger_ss_10_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 70"; }
trans1_datalogger_ss_11_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 71"; }
trans1_datalogger_ss_11_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 72"; }
trans1_datalogger_ss_11_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 73"; }
trans1_datalogger_ss_11_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 74"; }
trans1_datalogger_ss_11_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 75"; }
trans1_datalogger_ss_11_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 76"; }
trans1_datalogger_ss_11_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 77"; }
trans1_datalogger_ss_12_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 78"; }
trans1_datalogger_ss_12_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 79"; }
trans1_datalogger_ss_12_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 80"; }
trans1_datalogger_ss_12_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 81"; }
trans1_datalogger_ss_12_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 82"; }
trans1_datalogger_ss_12_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 83"; }
trans1_datalogger_ss_12_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 84"; }
trans1_datalogger_ss_13_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 85"; }
trans1_datalogger_ss_13_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 86"; }
trans1_datalogger_ss_13_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 87"; }
trans1_datalogger_ss_13_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 88"; }
trans1_datalogger_ss_13_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 89"; }
trans1_datalogger_ss_13_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 90"; }
trans1_datalogger_ss_13_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 91"; }
trans1_datalogger_ss_14_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 92"; }
trans1_datalogger_ss_14_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 93"; }
trans1_datalogger_ss_14_2 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 94"; }
trans1_datalogger_ss_14_3 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 95"; }
trans1_datalogger_ss_14_4 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 96"; }
trans1_datalogger_ss_14_5 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 97"; }
trans1_datalogger_ss_14_6 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 98"; }
trans1_datalogger_ss_15_0 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 99"; }
trans1_datalogger_ss_15_1 		LIKE  VARIABLE  		trans1_datalogger_ss_1_0
{ REDEFINE LABEL "Stellsignal y - Messpunkt - 100"; }



/* float 800...899 */

VARIABLE trans1_datalogger_e_1_0
{
  LABEL    "Regelabweichung e - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     FLOAT
  {
     DEFAULT_VALUE   0.0;
  }
  CONSTANT_UNIT "%";
  HELP     "|de|Regelabweichung e";
}

trans1_datalogger_e_1_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 2"; }
trans1_datalogger_e_1_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 3"; }
trans1_datalogger_e_1_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 4"; }
trans1_datalogger_e_1_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 5"; }
trans1_datalogger_e_1_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 6"; }
trans1_datalogger_e_1_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 7"; }
trans1_datalogger_e_2_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 8"; }
trans1_datalogger_e_2_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 9"; }
trans1_datalogger_e_2_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 10"; }
trans1_datalogger_e_2_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 11"; }
trans1_datalogger_e_2_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 12"; }
trans1_datalogger_e_2_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 13"; }
trans1_datalogger_e_2_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 14"; }
trans1_datalogger_e_3_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 15"; }
trans1_datalogger_e_3_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 16"; }
trans1_datalogger_e_3_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 17"; }
trans1_datalogger_e_3_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 18"; }
trans1_datalogger_e_3_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 19"; }
trans1_datalogger_e_3_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 20"; }
trans1_datalogger_e_3_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 21"; }
trans1_datalogger_e_4_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 22"; }
trans1_datalogger_e_4_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 23"; }
trans1_datalogger_e_4_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 24"; }
trans1_datalogger_e_4_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 25"; }
trans1_datalogger_e_4_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 26"; }
trans1_datalogger_e_4_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 27"; }
trans1_datalogger_e_4_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 28"; }
trans1_datalogger_e_5_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 29"; }
trans1_datalogger_e_5_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 30"; }
trans1_datalogger_e_5_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 31"; }
trans1_datalogger_e_5_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 32"; }
trans1_datalogger_e_5_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 33"; }
trans1_datalogger_e_5_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 34"; }
trans1_datalogger_e_5_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 35"; }
trans1_datalogger_e_6_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 36"; }
trans1_datalogger_e_6_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 37"; }
trans1_datalogger_e_6_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 38"; }
trans1_datalogger_e_6_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 39"; }
trans1_datalogger_e_6_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 40"; }
trans1_datalogger_e_6_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 41"; }
trans1_datalogger_e_6_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 42"; }
trans1_datalogger_e_7_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 43"; }
trans1_datalogger_e_7_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 44"; }
trans1_datalogger_e_7_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 45"; }
trans1_datalogger_e_7_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 46"; }
trans1_datalogger_e_7_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 47"; }
trans1_datalogger_e_7_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 48"; }
trans1_datalogger_e_7_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 49"; }
trans1_datalogger_e_8_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 50"; }
trans1_datalogger_e_8_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 51"; }
trans1_datalogger_e_8_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 52"; }
trans1_datalogger_e_8_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 53"; }
trans1_datalogger_e_8_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 54"; }
trans1_datalogger_e_8_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 55"; }
trans1_datalogger_e_8_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 56"; }
trans1_datalogger_e_9_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 57"; }
trans1_datalogger_e_9_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 58"; }
trans1_datalogger_e_9_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 59"; }
trans1_datalogger_e_9_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 60"; }
trans1_datalogger_e_9_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 61"; }
trans1_datalogger_e_9_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 62"; }
trans1_datalogger_e_9_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 63"; }
trans1_datalogger_e_10_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 64"; }
trans1_datalogger_e_10_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 65"; }
trans1_datalogger_e_10_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 66"; }
trans1_datalogger_e_10_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 67"; }
trans1_datalogger_e_10_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 68"; }
trans1_datalogger_e_10_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 69"; }
trans1_datalogger_e_10_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 70"; }
trans1_datalogger_e_11_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 71"; }
trans1_datalogger_e_11_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 72"; }
trans1_datalogger_e_11_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 73"; }
trans1_datalogger_e_11_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 74"; }
trans1_datalogger_e_11_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 75"; }
trans1_datalogger_e_11_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 76"; }
trans1_datalogger_e_11_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 77"; }
trans1_datalogger_e_12_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 78"; }
trans1_datalogger_e_12_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 79"; }
trans1_datalogger_e_12_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 80"; }
trans1_datalogger_e_12_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 81"; }
trans1_datalogger_e_12_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 82"; }
trans1_datalogger_e_12_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 83"; }
trans1_datalogger_e_12_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 84"; }
trans1_datalogger_e_13_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 85"; }
trans1_datalogger_e_13_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 86"; }
trans1_datalogger_e_13_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 87"; }
trans1_datalogger_e_13_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 88"; }
trans1_datalogger_e_13_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 89"; }
trans1_datalogger_e_13_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 90"; }
trans1_datalogger_e_13_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 91"; }
trans1_datalogger_e_14_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 92"; }
trans1_datalogger_e_14_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 93"; }
trans1_datalogger_e_14_2 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 94"; }
trans1_datalogger_e_14_3 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 95"; }
trans1_datalogger_e_14_4 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 96"; }
trans1_datalogger_e_14_5 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 97"; }
trans1_datalogger_e_14_6 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 98"; }
trans1_datalogger_e_15_0 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 99"; }
trans1_datalogger_e_15_1 		LIKE  VARIABLE  		trans1_datalogger_e_1_0
{ REDEFINE LABEL "Regelabweichung e - Messpunkt - 100"; }



/* unsigned long 200...299 */

VARIABLE trans1_datalogger_t_1_0
{
  LABEL    "Zeitmesswert - Messpunkt - 1";
  CLASS    DEVICE & DYNAMIC;
  HANDLING READ;
  TYPE     UNSIGNED_INTEGER (4)
  {
     DEFAULT_VALUE   0;
  }
  CONSTANT_UNIT "100ms Takt";
  HELP     "|de|Zeitmesswert";
}

trans1_datalogger_t_1_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 2"; }
trans1_datalogger_t_1_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 3"; }
trans1_datalogger_t_1_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 4"; }
trans1_datalogger_t_1_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 5"; }
trans1_datalogger_t_1_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 6"; }
trans1_datalogger_t_1_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 7"; }
trans1_datalogger_t_2_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 8"; }
trans1_datalogger_t_2_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 9"; }
trans1_datalogger_t_2_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 10"; }
trans1_datalogger_t_2_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 11"; }
trans1_datalogger_t_2_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 12"; }
trans1_datalogger_t_2_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 13"; }
trans1_datalogger_t_2_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 14"; }
trans1_datalogger_t_3_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 15"; }
trans1_datalogger_t_3_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 16"; }
trans1_datalogger_t_3_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 17"; }
trans1_datalogger_t_3_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 18"; }
trans1_datalogger_t_3_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 19"; }
trans1_datalogger_t_3_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 20"; }
trans1_datalogger_t_3_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 21"; }
trans1_datalogger_t_4_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 22"; }
trans1_datalogger_t_4_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 23"; }
trans1_datalogger_t_4_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 24"; }
trans1_datalogger_t_4_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 25"; }
trans1_datalogger_t_4_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 26"; }
trans1_datalogger_t_4_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 27"; }
trans1_datalogger_t_4_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 28"; }
trans1_datalogger_t_5_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 29"; }
trans1_datalogger_t_5_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 30"; }
trans1_datalogger_t_5_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 31"; }
trans1_datalogger_t_5_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 32"; }
trans1_datalogger_t_5_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 33"; }
trans1_datalogger_t_5_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 34"; }
trans1_datalogger_t_5_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 35"; }
trans1_datalogger_t_6_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 36"; }
trans1_datalogger_t_6_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 37"; }
trans1_datalogger_t_6_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 38"; }
trans1_datalogger_t_6_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 39"; }
trans1_datalogger_t_6_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 40"; }
trans1_datalogger_t_6_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 41"; }
trans1_datalogger_t_6_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 42"; }
trans1_datalogger_t_7_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 43"; }
trans1_datalogger_t_7_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 44"; }
trans1_datalogger_t_7_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 45"; }
trans1_datalogger_t_7_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 46"; }
trans1_datalogger_t_7_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 47"; }
trans1_datalogger_t_7_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 48"; }
trans1_datalogger_t_7_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 49"; }
trans1_datalogger_t_8_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 50"; }
trans1_datalogger_t_8_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 51"; }
trans1_datalogger_t_8_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 52"; }
trans1_datalogger_t_8_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 53"; }
trans1_datalogger_t_8_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 54"; }
trans1_datalogger_t_8_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 55"; }
trans1_datalogger_t_8_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 56"; }
trans1_datalogger_t_9_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 57"; }
trans1_datalogger_t_9_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 58"; }
trans1_datalogger_t_9_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 59"; }
trans1_datalogger_t_9_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 60"; }
trans1_datalogger_t_9_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 61"; }
trans1_datalogger_t_9_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 62"; }
trans1_datalogger_t_9_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 63"; }
trans1_datalogger_t_10_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 64"; }
trans1_datalogger_t_10_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 65"; }
trans1_datalogger_t_10_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 66"; }
trans1_datalogger_t_10_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 67"; }
trans1_datalogger_t_10_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 68"; }
trans1_datalogger_t_10_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 69"; }
trans1_datalogger_t_10_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 70"; }
trans1_datalogger_t_11_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 71"; }
trans1_datalogger_t_11_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 72"; }
trans1_datalogger_t_11_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 73"; }
trans1_datalogger_t_11_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 74"; }
trans1_datalogger_t_11_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 75"; }
trans1_datalogger_t_11_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 76"; }
trans1_datalogger_t_11_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 77"; }
trans1_datalogger_t_12_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 78"; }
trans1_datalogger_t_12_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 79"; }
trans1_datalogger_t_12_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 80"; }
trans1_datalogger_t_12_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 81"; }
trans1_datalogger_t_12_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 82"; }
trans1_datalogger_t_12_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 83"; }
trans1_datalogger_t_12_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 84"; }
trans1_datalogger_t_13_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 85"; }
trans1_datalogger_t_13_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 86"; }
trans1_datalogger_t_13_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 87"; }
trans1_datalogger_t_13_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 88"; }
trans1_datalogger_t_13_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 89"; }
trans1_datalogger_t_13_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 90"; }
trans1_datalogger_t_13_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 91"; }
trans1_datalogger_t_14_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 92"; }
trans1_datalogger_t_14_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 93"; }
trans1_datalogger_t_14_2 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 94"; }
trans1_datalogger_t_14_3 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 95"; }
trans1_datalogger_t_14_4 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 96"; }
trans1_datalogger_t_14_5 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 97"; }
trans1_datalogger_t_14_6 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 98"; }
trans1_datalogger_t_15_0 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 99"; }
trans1_datalogger_t_15_1 		LIKE  VARIABLE  		trans1_datalogger_t_1_0
{ REDEFINE LABEL "Zeitmesswert - Messpunkt - 100"; }



/****************** Lesen bzw. Schreiben ************************/

COMMAND read_trans1_datalogger
{
    SLOT 1;
    INDEX 185;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_datalogger_select,
	        trans1_datalogger_trigger_select,
	        trans1_datalogger_sample_rate,
	        trans1_datalogger_start_value,
	        trans1_datalogger_logging_limit,
	        trans1_datalogger_pretrigger_time
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_datalogger
{
    SLOT 1;
    INDEX 185;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_datalogger_select,
	        trans1_datalogger_trigger_select,
	        trans1_datalogger_sample_rate,
	        trans1_datalogger_start_value,
	        trans1_datalogger_logging_limit,
	        trans1_datalogger_pretrigger_time
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_read
{
    SLOT 1;
    INDEX 186;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_datalogger_testinfo,
            trans1_datalogger_max_pretrig,
            trans1_datalogger_progress,
            trans1_datalogger_counter_day,
            trans1_datalogger_counter_hour,
            trans1_datalogger_counter_minute,
            trans1_datalogger_counter_second,
            trans1_datalogger_counter_msec
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_histogramm_X
{
    SLOT 0;
    INDEX 66;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_X_Interval_Value_0,
			 trans1_X_Interval_Value_1,
			 trans1_X_Interval_Value_2,
			 trans1_X_Interval_Value_3,
			 trans1_X_Interval_Value_4,
			 trans1_X_Interval_Value_5,
			 trans1_X_Interval_Value_6,
			 trans1_X_Interval_Value_7,
			 trans1_X_Interval_Value_8,
			 trans1_X_Interval_Value_9,
			 trans1_X_Interval_Value_10,
			 trans1_X_Interval_Value_11,
			 trans1_X_Interval_Value_12,
			 trans1_X_Interval_Value_13,
			 trans1_X_Interval_Value_14,
			 trans1_X_Interval_Value_15,
			 trans1_X_Interval_Value_16,
			 trans1_X_Interval_Value_17,
			 trans1_X_Interval_Value_18,
			 trans1_X_Interval_Value_19,
			 trans1_X_Interval_Value_20,
			 trans1_X_Interval_Value_21,
			 trans1_X_Average,
			 trans1_Number_Mess_Points
		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_histogramm_E
{
    SLOT 0;
    INDEX 67;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_E_Interval_Value_0,
             trans1_E_Interval_Value_1,
			 trans1_E_Interval_Value_2,
			 trans1_E_Interval_Value_3,
			 trans1_E_Interval_Value_4,
			 trans1_E_Interval_Value_5,
			 trans1_E_Interval_Value_6,
			 trans1_E_Interval_Value_7,
			 trans1_E_Interval_Value_8,
			 trans1_E_Interval_Value_9,
			 trans1_E_Interval_Value_10,
			 trans1_E_Interval_Value_11,
			 trans1_E_Average,
			 trans1_Total_Number_E,
             trans1_deviation_min,
			 trans1_deviation_max
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_histogramm_Z
{
    SLOT 0;
    INDEX 68;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_Z_Interval_Value_0,
             trans1_Z_Interval_Value_1,
			 trans1_Z_Interval_Value_2,
			 trans1_Z_Interval_Value_3,
			 trans1_Z_Interval_Value_4,
			 trans1_Z_Interval_Value_5,
			 trans1_Z_Interval_Value_6,
			 trans1_Z_Interval_Value_7,
			 trans1_Z_Interval_Value_8,
			 trans1_Z_Interval_Value_9,
			 trans1_Z_Interval_Value_10,
			 trans1_Z_Interval_Value_11,
			 trans1_Z_Interval_Value_12,
			 trans1_Z_Average,
			 trans1_Total_Number_Z,
			 trans1_Dynamic_Factor
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_temp_monitoring
{
    SLOT 1;
    INDEX 187;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             	 trans1_Current_Temp,
				 trans1_Max_Temp,
				 trans1_Time_Max_Temp,
				 trans1_Min_Temp,
				 trans1_Time_Min_Temp,
				 trans1_Period_Time_High,
				 trans1_Period_Time_Low
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_trans1_step_response_R
{
    SLOT 1;
    INDEX 188;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
         		trans1_Overshoot_Rising,
				trans1_Overshoot_Falling,
				trans1_Dead_Time_Rising,
				trans1_Dead_Time_Falling,
				trans1_Time_63_Rising,
				trans1_Time_63_Falling,
				trans1_Time_98_Rising,
				trans1_Time_98_Falling,
				trans1_Step_Progress,
				trans1_Rise_Time_Falling,
				trans1_Settling_Time_Falling,
				trans1_Rise_Time_Rising,
				trans1_Settling_Time_Rising,
				trans1_Duration_of_test,
				trans1_Testinfo
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_trans1_step_response_RW
{
    SLOT 1;
    INDEX 189;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
         		trans1_Stepstart,
				trans1_Stepend,
				trans1_Step_Sample_Rate,
				trans1_Rampe_Up,
				trans1_Rampe_Down,
				trans1_Latency_After_Step,
				trans1_Step_Selection
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_trans1_step_response_RW
{
    SLOT 1;
    INDEX 189;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
        		trans1_Stepstart,
				trans1_Stepend,
				trans1_Step_Sample_Rate,
				trans1_Rampe_Up,
				trans1_Rampe_Down,
				trans1_Latency_After_Step,
				trans1_Step_Selection
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_event_logging_1
{
    SLOT 1;
    INDEX 190;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
         		trans1_Message_0,
				trans1_Elapsed_Hours_Meters_0,
				trans1_Message_1,
				trans1_Elapsed_Hours_Meters_1,
				trans1_Message_2,
				trans1_Elapsed_Hours_Meters_2,
				trans1_Message_3,
				trans1_Elapsed_Hours_Meters_3,
				trans1_Message_4,
				trans1_Elapsed_Hours_Meters_4,
				trans1_Message_5,
				trans1_Elapsed_Hours_Meters_5,
				trans1_Message_6,
				trans1_Elapsed_Hours_Meters_6,
				trans1_Message_7,
				trans1_Elapsed_Hours_Meters_7,
				trans1_Message_8,
				trans1_Elapsed_Hours_Meters_8,
				trans1_Message_9,
				trans1_Elapsed_Hours_Meters_9,
				trans1_Message_10,
				trans1_Elapsed_Hours_Meters_10,
				trans1_Message_11,
				trans1_Elapsed_Hours_Meters_11,
				trans1_Message_12,
				trans1_Elapsed_Hours_Meters_12,
				trans1_Message_13,
				trans1_Elapsed_Hours_Meters_13,
				trans1_Message_14,
				trans1_Elapsed_Hours_Meters_14
		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_event_logging_2
{
    SLOT 1;
    INDEX 191;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
         		trans1_Message_15,
				trans1_Elapsed_Hours_Meters_15,
				trans1_Message_16,
				trans1_Elapsed_Hours_Meters_16,
				trans1_Message_17,
				trans1_Elapsed_Hours_Meters_17,
				trans1_Message_18,
				trans1_Elapsed_Hours_Meters_18,
				trans1_Message_19,
				trans1_Elapsed_Hours_Meters_19,
				trans1_Message_20,
				trans1_Elapsed_Hours_Meters_20,
				trans1_Message_21,
				trans1_Elapsed_Hours_Meters_21,
				trans1_Message_22,
				trans1_Elapsed_Hours_Meters_22,
				trans1_Message_23,
				trans1_Elapsed_Hours_Meters_23,
				trans1_Message_24,
				trans1_Elapsed_Hours_Meters_24,
				trans1_Message_25,
				trans1_Elapsed_Hours_Meters_25,
				trans1_Message_26,
				trans1_Elapsed_Hours_Meters_26,
				trans1_Message_27,
				trans1_Elapsed_Hours_Meters_27,
				trans1_Message_28,
				trans1_Elapsed_Hours_Meters_28,
				trans1_Message_29,
				trans1_Elapsed_Hours_Meters_29
	     }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_trans1_enhanced_diag_cmd
{
    SLOT 1;
    INDEX 192;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_enhanced_diag_cmd
        }
        REPLY
        {
        }
 		}
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_elapsed_hours_meters
{
    SLOT 1;
    INDEX 193;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            	 trans1_Elapsed_Hours_Meters,
				 trans1_Device_In_Closed_Loop,
				 trans1_Power_On_Since_Init,
				 trans1_Device_In_Closed_Loop_Since_Last_Init
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_autostart_hyst
{
    SLOT 1;
    INDEX 194;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_autostart_hyst
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_autostart_hyst
{
    SLOT 1;
    INDEX 194;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_autostart_hyst
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_diag_level
{
    SLOT 1;
    INDEX 195;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_diag_level
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_no_of_zero_point_adj
{
    SLOT 1;
    INDEX 196;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_no_of_zero_point_adj
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_zero_point_limit
{
    SLOT 1;
    INDEX 197;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_zero_point_limit
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_trans1_zero_point_limit
{
    SLOT 1;
    INDEX 197;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_zero_point_limit
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_counter_init_start
{
    SLOT 1;
    INDEX 198;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_counter_init_start
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_histogramm_X_KURZ
{
    SLOT 0;
    INDEX 69;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_X_Interval_Value_0_KURZ,
			 trans1_X_Interval_Value_1_KURZ,
			 trans1_X_Interval_Value_2_KURZ,
			 trans1_X_Interval_Value_3_KURZ,
			 trans1_X_Interval_Value_4_KURZ,
			 trans1_X_Interval_Value_5_KURZ,
			 trans1_X_Interval_Value_6_KURZ,
			 trans1_X_Interval_Value_7_KURZ,
			 trans1_X_Interval_Value_8_KURZ,
			 trans1_X_Interval_Value_9_KURZ,
			 trans1_X_Interval_Value_10_KURZ,
			 trans1_X_Interval_Value_11_KURZ,
			 trans1_X_Interval_Value_12_KURZ,
			 trans1_X_Interval_Value_13_KURZ,
			 trans1_X_Interval_Value_14_KURZ,
			 trans1_X_Interval_Value_15_KURZ,
			 trans1_X_Interval_Value_16_KURZ,
			 trans1_X_Interval_Value_17_KURZ,
			 trans1_X_Interval_Value_18_KURZ,
			 trans1_X_Interval_Value_19_KURZ,
			 trans1_X_Interval_Value_20_KURZ,
			 trans1_X_Interval_Value_21_KURZ,
			 trans1_X_Average_KURZ
		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_histogramm_E_KURZ
{
    SLOT 0;
    INDEX 70;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_E_Interval_Value_0_KURZ,
             trans1_E_Interval_Value_1_KURZ,
			 trans1_E_Interval_Value_2_KURZ,
			 trans1_E_Interval_Value_3_KURZ,
			 trans1_E_Interval_Value_4_KURZ,
			 trans1_E_Interval_Value_5_KURZ,
			 trans1_E_Interval_Value_6_KURZ,
			 trans1_E_Interval_Value_7_KURZ,
			 trans1_E_Interval_Value_8_KURZ,
			 trans1_E_Interval_Value_9_KURZ,
			 trans1_E_Interval_Value_10_KURZ,
			 trans1_E_Interval_Value_11_KURZ,
			 trans1_E_Average_KURZ
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_histogramm_Z_KURZ
{
    SLOT 0;
    INDEX 71;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_Z_Interval_Value_0_KURZ,
             trans1_Z_Interval_Value_1_KURZ,
			 trans1_Z_Interval_Value_2_KURZ,
			 trans1_Z_Interval_Value_3_KURZ,
			 trans1_Z_Interval_Value_4_KURZ,
			 trans1_Z_Interval_Value_5_KURZ,
			 trans1_Z_Interval_Value_6_KURZ,
			 trans1_Z_Interval_Value_7_KURZ,
			 trans1_Z_Interval_Value_8_KURZ,
			 trans1_Z_Interval_Value_9_KURZ,
			 trans1_Z_Interval_Value_10_KURZ,
			 trans1_Z_Interval_Value_11_KURZ,
			 trans1_Z_Interval_Value_12_KURZ,
			 trans1_Z_Average_KURZ
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_X_HIS_ABTASTRATE
{
    SLOT 1;
    INDEX 199;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_X_HIS_ABTASTRATE
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_X_HIS_ABTASTRATE
{
    SLOT 1;
    INDEX 199;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_X_HIS_ABTASTRATE
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_E_HIS_ABTASTRATE
{
    SLOT 1;
    INDEX 200;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_E_HIS_ABTASTRATE
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_E_HIS_ABTASTRATE
{
    SLOT 1;
    INDEX 200;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_E_HIS_ABTASTRATE
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stationaer_lang
{
    SLOT 0;
    INDEX 72;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stationaer_lang_Value_0,
             trans1_stationaer_lang_Value_1,
             trans1_stationaer_lang_Value_2,
             trans1_stationaer_lang_Value_3,
             trans1_stationaer_lang_Value_4,
             trans1_stationaer_lang_Value_5,
             trans1_stationaer_lang_Value_6,
             trans1_stationaer_lang_Value_7,
             trans1_stationaer_lang_Value_8,
             trans1_stationaer_lang_Value_9,
             trans1_stationaer_lang_Value_10,
             trans1_stationaer_lang_Value_11,
             trans1_stationaer_lang_Value_12,
             trans1_stationaer_lang_Value_13,
             trans1_stationaer_lang_Value_14,
             trans1_stationaer_lang_Value_15,
             trans1_stationaer_lang_Value_16,
             trans1_stationaer_lang_Value_17,
             trans1_stationaer_lang_Value_18,
             trans1_stationaer_lang_Value_19,
             trans1_stationaer_lang_Value_20,
             trans1_stationaer_lang_Value_21
		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stationaer_kurz
{
    SLOT 0;
    INDEX 73;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stationaer_kurz_Value_0,
             trans1_stationaer_kurz_Value_1,
             trans1_stationaer_kurz_Value_2,
             trans1_stationaer_kurz_Value_3,
             trans1_stationaer_kurz_Value_4,
             trans1_stationaer_kurz_Value_5,
             trans1_stationaer_kurz_Value_6,
             trans1_stationaer_kurz_Value_7,
             trans1_stationaer_kurz_Value_8,
             trans1_stationaer_kurz_Value_9,
             trans1_stationaer_kurz_Value_10,
             trans1_stationaer_kurz_Value_11,
             trans1_stationaer_kurz_Value_12,
             trans1_stationaer_kurz_Value_13,
             trans1_stationaer_kurz_Value_14,
             trans1_stationaer_kurz_Value_15,
             trans1_stationaer_kurz_Value_16,
             trans1_stationaer_kurz_Value_17,
             trans1_stationaer_kurz_Value_18,
             trans1_stationaer_kurz_Value_19,
             trans1_stationaer_kurz_Value_20,
             trans1_stationaer_kurz_Value_21
		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stationaer_kurz_RP
{
    SLOT 0;
    INDEX 74;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_stellsignal_Value_0,
             trans1_stat_ventilstellung_Value_0,
             trans1_stat_stellsignal_Value_1,
             trans1_stat_ventilstellung_Value_1,
             trans1_stat_stellsignal_Value_2,
             trans1_stat_ventilstellung_Value_2,
             trans1_stat_stellsignal_Value_3,
             trans1_stat_ventilstellung_Value_3,
             trans1_stat_stellsignal_Value_4,
             trans1_stat_ventilstellung_Value_4,
             trans1_stat_stellsignal_Value_5,
             trans1_stat_ventilstellung_Value_5,
             trans1_stat_stellsignal_Value_6,
             trans1_stat_ventilstellung_Value_6,
             trans1_stat_stellsignal_Value_7,
             trans1_stat_ventilstellung_Value_7,
             trans1_stat_stellsignal_Value_8,
             trans1_stat_ventilstellung_Value_8,
             trans1_stat_stellsignal_Value_9,
             trans1_stat_ventilstellung_Value_9
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_hysterese_lang
{
    SLOT 0;
    INDEX 75;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_hysterese_lang_Value_0,
             trans1_hysterese_lang_Value_1,
             trans1_hysterese_lang_Value_2,
             trans1_hysterese_lang_Value_3,
             trans1_hysterese_lang_Value_4,
             trans1_hysterese_lang_Value_5,
             trans1_hysterese_lang_Value_6,
             trans1_hysterese_lang_Value_7,
             trans1_hysterese_lang_Value_8,
             trans1_hysterese_lang_Value_9,
             trans1_hysterese_lang_Value_10,
             trans1_hysterese_lang_Value_11,
             trans1_hysterese_lang_Value_12,
             trans1_hysterese_lang_Value_13,
             trans1_hysterese_lang_Value_14,
             trans1_hysterese_lang_Value_15,
             trans1_hysterese_lang_Value_16,
             trans1_hysterese_lang_Value_17,
             trans1_hysterese_lang_Value_18
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_hysterese_kurz_RP
{
    SLOT 0;
    INDEX 76;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_hys_stellsignal_Value_0,
             trans1_hys_ventilstellung_Value_0,
             trans1_hys_stellsignal_Value_1,
             trans1_hys_ventilstellung_Value_1,
             trans1_hys_stellsignal_Value_2,
             trans1_hys_ventilstellung_Value_2,
             trans1_hys_stellsignal_Value_3,
             trans1_hys_ventilstellung_Value_3,
             trans1_hys_stellsignal_Value_4,
             trans1_hys_ventilstellung_Value_4,
             trans1_hys_stellsignal_Value_5,
             trans1_hys_ventilstellung_Value_5,
             trans1_hys_stellsignal_Value_6,
             trans1_hys_ventilstellung_Value_6,
             trans1_hys_stellsignal_Value_7,
             trans1_hys_ventilstellung_Value_7,
             trans1_hys_stellsignal_Value_8,
             trans1_hys_ventilstellung_Value_8,
             trans1_hys_stellsignal_Value_9,
             trans1_hys_ventilstellung_Value_9
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_ET_Ventilstellung
{
    SLOT 0;
    INDEX 77;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_et_ventil_Value_0,
             trans1_et_ventil_Value_1,
             trans1_et_ventil_Value_2,
             trans1_et_ventil_Value_3,
             trans1_et_ventil_Value_4,
             trans1_et_ventil_Value_5,
             trans1_et_ventil_Value_6,
             trans1_et_ventil_Value_7,
             trans1_et_ventil_Value_8,
             trans1_et_ventil_Value_9,
             trans1_et_ventil_Value_10,
             trans1_et_ventil_Value_11,
             trans1_et_ventil_Value_12,
             trans1_et_ventil_Value_13,
             trans1_et_ventil_Value_14,
             trans1_et_ventil_Value_15,
             trans1_et_ventil_Value_16,
             trans1_et_ventil_Value_17,
             trans1_et_ventil_Value_18,
             trans1_et_ventil_Value_19,
             trans1_et_ventil_Value_20,
             trans1_et_ventil_Value_21,
             trans1_et_ventil_Value_22,
             trans1_et_ventil_Value_23,
             trans1_et_ventil_Value_24,
             trans1_et_ventil_Value_25,
             trans1_et_ventil_Value_26,
             trans1_et_ventil_Value_27,
             trans1_et_ventil_Value_28,
             trans1_et_ventil_Value_29,
             trans1_et_ventil_refwert
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_ET_BSZ
{
    SLOT 0;
    INDEX 78;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_et_BSZ_Value_0,
             trans1_et_BSZ_Value_1,
             trans1_et_BSZ_Value_2,
             trans1_et_BSZ_Value_3,
             trans1_et_BSZ_Value_4,
             trans1_et_BSZ_Value_5,
             trans1_et_BSZ_Value_6,
             trans1_et_BSZ_Value_7,
             trans1_et_BSZ_Value_8,
             trans1_et_BSZ_Value_9,
             trans1_et_BSZ_Value_10,
             trans1_et_BSZ_Value_11,
             trans1_et_BSZ_Value_12,
             trans1_et_BSZ_Value_13,
             trans1_et_BSZ_Value_14,
             trans1_et_BSZ_Value_15,
             trans1_et_BSZ_Value_16,
             trans1_et_BSZ_Value_17,
             trans1_et_BSZ_Value_18,
             trans1_et_BSZ_Value_19,
             trans1_et_BSZ_Value_20,
             trans1_et_BSZ_Value_21,
             trans1_et_BSZ_Value_22,
             trans1_et_BSZ_Value_23,
             trans1_et_BSZ_Value_24,
             trans1_et_BSZ_Value_25,
             trans1_et_BSZ_Value_26,
             trans1_et_BSZ_Value_27,
             trans1_et_BSZ_Value_28,
             trans1_et_BSZ_Value_29,
             trans1_et_BSZ_refwert
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_ET_Endlage
{
    SLOT 0;
    INDEX 79;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_et_endlage_Value_0,
             trans1_et_endlage_Value_1,
             trans1_et_endlage_Value_2,
             trans1_et_endlage_Value_3,
             trans1_et_endlage_Value_4,
             trans1_et_endlage_Value_5,
             trans1_et_endlage_Value_6,
             trans1_et_endlage_Value_7,
             trans1_et_endlage_Value_8,
             trans1_et_endlage_Value_9,
             trans1_et_endlage_Value_10,
             trans1_et_endlage_Value_11,
             trans1_et_endlage_Value_12,
             trans1_et_endlage_Value_13,
             trans1_et_endlage_Value_14,
             trans1_et_endlage_Value_15,
             trans1_et_endlage_Value_16,
             trans1_et_endlage_Value_17,
             trans1_et_endlage_Value_18,
             trans1_et_endlage_Value_19,
             trans1_et_endlage_Value_20,
             trans1_et_endlage_Value_21,
             trans1_et_endlage_Value_22,
             trans1_et_endlage_Value_23,
             trans1_et_endlage_Value_24,
             trans1_et_endlage_Value_25,
             trans1_et_endlage_Value_26,
             trans1_et_endlage_Value_27,
             trans1_et_endlage_Value_28,
             trans1_et_endlage_Value_29,
             trans1_et_endlage_refwert
     	}
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_trans1_diag_testinfo
{
    SLOT 1;
    INDEX 201;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_diag_testinfo
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_ref_vs_0
{
    SLOT 0;
    INDEX 80;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_ref_vs_0,
             trans1_stat_ref_vs_1,
             trans1_stat_ref_vs_2,
             trans1_stat_ref_vs_3,
             trans1_stat_ref_vs_4,
             trans1_stat_ref_vs_5,
             trans1_stat_ref_vs_6,
             trans1_stat_ref_vs_7,
             trans1_stat_ref_vs_8,
             trans1_stat_ref_vs_9,
             trans1_stat_ref_vs_10,
             trans1_stat_ref_vs_11,
             trans1_stat_ref_vs_12,
             trans1_stat_ref_vs_13,
             trans1_stat_ref_vs_14,
             trans1_stat_ref_vs_15,
             trans1_stat_ref_vs_16,
             trans1_stat_ref_vs_17,
             trans1_stat_ref_vs_18,
             trans1_stat_ref_vs_19,
             trans1_stat_ref_vs_20,
             trans1_stat_ref_vs_21,
             trans1_stat_ref_vs_22,
             trans1_stat_ref_vs_23,
             trans1_stat_ref_vs_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_again_vs
{
    SLOT 0;
    INDEX 81;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_again_vs_0,
             trans1_stat_again_vs_1,
             trans1_stat_again_vs_2,
             trans1_stat_again_vs_3,
             trans1_stat_again_vs_4,
             trans1_stat_again_vs_5,
             trans1_stat_again_vs_6,
             trans1_stat_again_vs_7,
             trans1_stat_again_vs_8,
             trans1_stat_again_vs_9,
             trans1_stat_again_vs_10,
             trans1_stat_again_vs_11,
             trans1_stat_again_vs_12,
             trans1_stat_again_vs_13,
             trans1_stat_again_vs_14,
             trans1_stat_again_vs_15,
             trans1_stat_again_vs_16,
             trans1_stat_again_vs_17,
             trans1_stat_again_vs_18,
             trans1_stat_again_vs_19,
             trans1_stat_again_vs_20,
             trans1_stat_again_vs_21,
             trans1_stat_again_vs_22,
             trans1_stat_again_vs_23,
             trans1_stat_again_vs_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_stellsignal
{
    SLOT 0;
    INDEX 82;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_ss_refzeit,
             trans1_stat_ss_testinfo,
             trans1_stat_ss_progress,
             trans1_stat_ref_ss_0,
             trans1_stat_again_ss_0,
             trans1_stat_ref_ss_1,
             trans1_stat_again_ss_1,
             trans1_stat_ref_ss_2,
             trans1_stat_again_ss_2,
             trans1_stat_ref_ss_3,
             trans1_stat_again_ss_3,
             trans1_stat_ref_ss_4,
             trans1_stat_again_ss_4,
             trans1_stat_ref_ss_5,
             trans1_stat_again_ss_5,
             trans1_stat_ref_ss_6,
             trans1_stat_again_ss_6,
             trans1_stat_ref_ss_7,
             trans1_stat_again_ss_7,
             trans1_stat_ref_ss_8,
             trans1_stat_again_ss_8,
             trans1_stat_ref_ss_9,
             trans1_stat_again_ss_9,
             trans1_stat_ref_ss_10,
             trans1_stat_again_ss_10,
             trans1_stat_ref_ss_11,
             trans1_stat_again_ss_11,
             trans1_stat_ref_ss_12,
             trans1_stat_again_ss_12,
             trans1_stat_ref_ss_13,
             trans1_stat_again_ss_13,
             trans1_stat_ref_ss_14,
             trans1_stat_again_ss_14,
             trans1_stat_ref_ss_15,
             trans1_stat_again_ss_15,
             trans1_stat_ref_ss_16,
             trans1_stat_again_ss_16,
             trans1_stat_ref_ss_17,
             trans1_stat_again_ss_17,
             trans1_stat_ref_ss_18,
             trans1_stat_again_ss_18,
             trans1_stat_ref_ss_19,
             trans1_stat_again_ss_19,
             trans1_stat_ref_ss_20,
             trans1_stat_again_ss_20,
             trans1_stat_ref_ss_21,
             trans1_stat_again_ss_21,
             trans1_stat_ref_ss_22,
             trans1_stat_again_ss_22,
             trans1_stat_ref_ss_23,
             trans1_stat_again_ss_23,
             trans1_stat_ref_ss_24,
             trans1_stat_again_ss_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_hys_stellsignal
{
    SLOT 0;
    INDEX 83;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_hys_ss_refzeit,
             trans1_hys_ss_testinfo,
             trans1_hys_ss_progress,
             trans1_hys_ref_vs_0,
             trans1_hys_ref_hys_0,
             trans1_hys_again_hys_0,
             trans1_hys_ref_vs_1,
             trans1_hys_ref_hys_1,
             trans1_hys_again_hys_1,
             trans1_hys_ref_vs_2,
             trans1_hys_ref_hys_2,
             trans1_hys_again_hys_2,
             trans1_hys_ref_vs_3,
             trans1_hys_ref_hys_3,
             trans1_hys_again_hys_3,
             trans1_hys_ref_vs_4,
             trans1_hys_ref_hys_4,
             trans1_hys_again_hys_4,
             trans1_hys_ref_vs_5,
             trans1_hys_ref_hys_5,
             trans1_hys_again_hys_5,
             trans1_hys_ref_vs_6,
             trans1_hys_ref_hys_6,
             trans1_hys_again_hys_6,
             trans1_hys_ref_vs_7,
             trans1_hys_ref_hys_7,
             trans1_hys_again_hys_7,
             trans1_hys_ref_vs_8,
             trans1_hys_ref_hys_8,
             trans1_hys_again_hys_8,
             trans1_hys_ref_vs_9,
             trans1_hys_ref_hys_9,
             trans1_hys_again_hys_9,
             trans1_hys_ref_vs_10,
             trans1_hys_ref_hys_10,
             trans1_hys_again_hys_10,
             trans1_hys_ref_vs_11,
             trans1_hys_ref_hys_11,
             trans1_hys_again_hys_11
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_statische_kennlinie
{
    SLOT 0;
    INDEX 84;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_kenn_testinfo,
             trans1_stat_kenn_sprunghoehe,
             trans1_stat_kenn_min_tot,
             trans1_stat_kenn_durch_tot,
             trans1_stat_kenn_max_tot,
             trans1_stat_kenn_progress
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_statische_kennlinie_RW
{
    SLOT 1;
    INDEX 204;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_kenn_start,
             trans1_stat_kenn_ende,
             trans1_stat_kenn_warte,
             trans1_stat_kenn_anzahl
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_trans1_statische_kennlinie_RW
{
    SLOT 1;
    INDEX 204;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
        	 trans1_stat_kenn_start,
             trans1_stat_kenn_ende,
             trans1_stat_kenn_warte,
             trans1_stat_kenn_anzahl
        }
        REPLY
        {
        }
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_vs_1
{
    SLOT 0;
    INDEX 85;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_vs_1_0,
             trans1_stat_vs_1_1,
             trans1_stat_vs_1_2,
             trans1_stat_vs_1_3,
             trans1_stat_vs_1_4,
             trans1_stat_vs_1_5,
             trans1_stat_vs_1_6,
             trans1_stat_vs_1_7,
             trans1_stat_vs_1_8,
             trans1_stat_vs_1_9,
             trans1_stat_vs_1_10,
             trans1_stat_vs_1_11,
             trans1_stat_vs_1_12,
             trans1_stat_vs_1_13,
             trans1_stat_vs_1_14,
             trans1_stat_vs_1_15,
             trans1_stat_vs_1_16,
             trans1_stat_vs_1_17,
             trans1_stat_vs_1_18,
             trans1_stat_vs_1_19,
             trans1_stat_vs_1_20,
             trans1_stat_vs_1_21,
             trans1_stat_vs_1_22,
             trans1_stat_vs_1_23,
             trans1_stat_vs_1_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_vs_2
{
    SLOT 0;
    INDEX 86;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_vs_2_0,
             trans1_stat_vs_2_1,
             trans1_stat_vs_2_2,
             trans1_stat_vs_2_3,
             trans1_stat_vs_2_4,
             trans1_stat_vs_2_5,
             trans1_stat_vs_2_6,
             trans1_stat_vs_2_7,
             trans1_stat_vs_2_8,
             trans1_stat_vs_2_9,
             trans1_stat_vs_2_10,
             trans1_stat_vs_2_11,
             trans1_stat_vs_2_12,
             trans1_stat_vs_2_13,
             trans1_stat_vs_2_14,
             trans1_stat_vs_2_15,
             trans1_stat_vs_2_16,
             trans1_stat_vs_2_17,
             trans1_stat_vs_2_18,
             trans1_stat_vs_2_19,
             trans1_stat_vs_2_20,
             trans1_stat_vs_2_21,
             trans1_stat_vs_2_22,
             trans1_stat_vs_2_23,
             trans1_stat_vs_2_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_vs_3
{
    SLOT 0;
    INDEX 87;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_vs_3_0,
             trans1_stat_vs_3_1,
             trans1_stat_vs_3_2,
             trans1_stat_vs_3_3,
             trans1_stat_vs_3_4,
             trans1_stat_vs_3_5,
             trans1_stat_vs_3_6,
             trans1_stat_vs_3_7,
             trans1_stat_vs_3_8,
             trans1_stat_vs_3_9,
             trans1_stat_vs_3_10,
             trans1_stat_vs_3_11,
             trans1_stat_vs_3_12,
             trans1_stat_vs_3_13,
             trans1_stat_vs_3_14,
             trans1_stat_vs_3_15,
             trans1_stat_vs_3_16,
             trans1_stat_vs_3_17,
             trans1_stat_vs_3_18,
             trans1_stat_vs_3_19,
             trans1_stat_vs_3_20,
             trans1_stat_vs_3_21,
             trans1_stat_vs_3_22,
             trans1_stat_vs_3_23,
             trans1_stat_vs_3_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_vs_4
{
    SLOT 0;
    INDEX 88;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_vs_4_0,
             trans1_stat_vs_4_1,
             trans1_stat_vs_4_2,
             trans1_stat_vs_4_3,
             trans1_stat_vs_4_4,
             trans1_stat_vs_4_5,
             trans1_stat_vs_4_6,
             trans1_stat_vs_4_7,
             trans1_stat_vs_4_8,
             trans1_stat_vs_4_9,
             trans1_stat_vs_4_10,
             trans1_stat_vs_4_11,
             trans1_stat_vs_4_12,
             trans1_stat_vs_4_13,
             trans1_stat_vs_4_14,
             trans1_stat_vs_4_15,
             trans1_stat_vs_4_16,
             trans1_stat_vs_4_17,
             trans1_stat_vs_4_18,
             trans1_stat_vs_4_19,
             trans1_stat_vs_4_20,
             trans1_stat_vs_4_21,
             trans1_stat_vs_4_22,
             trans1_stat_vs_4_23,
             trans1_stat_vs_4_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_sw_1
{
    SLOT 0;
    INDEX 89;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_sw_1_0,
             trans1_stat_sw_1_1,
             trans1_stat_sw_1_2,
             trans1_stat_sw_1_3,
             trans1_stat_sw_1_4,
             trans1_stat_sw_1_5,
             trans1_stat_sw_1_6,
             trans1_stat_sw_1_7,
             trans1_stat_sw_1_8,
             trans1_stat_sw_1_9,
             trans1_stat_sw_1_10,
             trans1_stat_sw_1_11,
             trans1_stat_sw_1_12,
             trans1_stat_sw_1_13,
             trans1_stat_sw_1_14,
             trans1_stat_sw_1_15,
             trans1_stat_sw_1_16,
             trans1_stat_sw_1_17,
             trans1_stat_sw_1_18,
             trans1_stat_sw_1_19,
             trans1_stat_sw_1_20,
             trans1_stat_sw_1_21,
             trans1_stat_sw_1_22,
             trans1_stat_sw_1_23,
             trans1_stat_sw_1_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_sw_2
{
    SLOT 0;
    INDEX 90;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_sw_2_0,
             trans1_stat_sw_2_1,
             trans1_stat_sw_2_2,
             trans1_stat_sw_2_3,
             trans1_stat_sw_2_4,
             trans1_stat_sw_2_5,
             trans1_stat_sw_2_6,
             trans1_stat_sw_2_7,
             trans1_stat_sw_2_8,
             trans1_stat_sw_2_9,
             trans1_stat_sw_2_10,
             trans1_stat_sw_2_11,
             trans1_stat_sw_2_12,
             trans1_stat_sw_2_13,
             trans1_stat_sw_2_14,
             trans1_stat_sw_2_15,
             trans1_stat_sw_2_16,
             trans1_stat_sw_2_17,
             trans1_stat_sw_2_18,
             trans1_stat_sw_2_19,
             trans1_stat_sw_2_20,
             trans1_stat_sw_2_21,
             trans1_stat_sw_2_22,
             trans1_stat_sw_2_23,
             trans1_stat_sw_2_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_sw_3
{
    SLOT 0;
    INDEX 91;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_sw_3_0,
             trans1_stat_sw_3_1,
             trans1_stat_sw_3_2,
             trans1_stat_sw_3_3,
             trans1_stat_sw_3_4,
             trans1_stat_sw_3_5,
             trans1_stat_sw_3_6,
             trans1_stat_sw_3_7,
             trans1_stat_sw_3_8,
             trans1_stat_sw_3_9,
             trans1_stat_sw_3_10,
             trans1_stat_sw_3_11,
             trans1_stat_sw_3_12,
             trans1_stat_sw_3_13,
             trans1_stat_sw_3_14,
             trans1_stat_sw_3_15,
             trans1_stat_sw_3_16,
             trans1_stat_sw_3_17,
             trans1_stat_sw_3_18,
             trans1_stat_sw_3_19,
             trans1_stat_sw_3_20,
             trans1_stat_sw_3_21,
             trans1_stat_sw_3_22,
             trans1_stat_sw_3_23,
             trans1_stat_sw_3_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_stat_sw_4
{
    SLOT 0;
    INDEX 92;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_stat_sw_4_0,
             trans1_stat_sw_4_1,
             trans1_stat_sw_4_2,
             trans1_stat_sw_4_3,
             trans1_stat_sw_4_4,
             trans1_stat_sw_4_5,
             trans1_stat_sw_4_6,
             trans1_stat_sw_4_7,
             trans1_stat_sw_4_8,
             trans1_stat_sw_4_9,
             trans1_stat_sw_4_10,
             trans1_stat_sw_4_11,
             trans1_stat_sw_4_12,
             trans1_stat_sw_4_13,
             trans1_stat_sw_4_14,
             trans1_stat_sw_4_15,
             trans1_stat_sw_4_16,
             trans1_stat_sw_4_17,
             trans1_stat_sw_4_18,
             trans1_stat_sw_4_19,
             trans1_stat_sw_4_20,
             trans1_stat_sw_4_21,
             trans1_stat_sw_4_22,
             trans1_stat_sw_4_23,
             trans1_stat_sw_4_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_vs_1
{
    SLOT 0;
    INDEX 93;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_vs_1_0,
             trans1_sprung_vs_1_1,
             trans1_sprung_vs_1_2,
             trans1_sprung_vs_1_3,
             trans1_sprung_vs_1_4,
             trans1_sprung_vs_1_5,
             trans1_sprung_vs_1_6,
             trans1_sprung_vs_1_7,
             trans1_sprung_vs_1_8,
             trans1_sprung_vs_1_9,
             trans1_sprung_vs_1_10,
             trans1_sprung_vs_1_11,
             trans1_sprung_vs_1_12,
             trans1_sprung_vs_1_13,
             trans1_sprung_vs_1_14,
             trans1_sprung_vs_1_15,
             trans1_sprung_vs_1_16,
             trans1_sprung_vs_1_17,
             trans1_sprung_vs_1_18,
             trans1_sprung_vs_1_19,
             trans1_sprung_vs_1_20,
             trans1_sprung_vs_1_21,
             trans1_sprung_vs_1_22,
             trans1_sprung_vs_1_23,
             trans1_sprung_vs_1_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_vs_2
{
    SLOT 0;
    INDEX 94;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_vs_2_0,
             trans1_sprung_vs_2_1,
             trans1_sprung_vs_2_2,
             trans1_sprung_vs_2_3,
             trans1_sprung_vs_2_4,
             trans1_sprung_vs_2_5,
             trans1_sprung_vs_2_6,
             trans1_sprung_vs_2_7,
             trans1_sprung_vs_2_8,
             trans1_sprung_vs_2_9,
             trans1_sprung_vs_2_10,
             trans1_sprung_vs_2_11,
             trans1_sprung_vs_2_12,
             trans1_sprung_vs_2_13,
             trans1_sprung_vs_2_14,
             trans1_sprung_vs_2_15,
             trans1_sprung_vs_2_16,
             trans1_sprung_vs_2_17,
             trans1_sprung_vs_2_18,
             trans1_sprung_vs_2_19,
             trans1_sprung_vs_2_20,
             trans1_sprung_vs_2_21,
             trans1_sprung_vs_2_22,
             trans1_sprung_vs_2_23,
             trans1_sprung_vs_2_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_vs_3
{
    SLOT 0;
    INDEX 95;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_vs_3_0,
             trans1_sprung_vs_3_1,
             trans1_sprung_vs_3_2,
             trans1_sprung_vs_3_3,
             trans1_sprung_vs_3_4,
             trans1_sprung_vs_3_5,
             trans1_sprung_vs_3_6,
             trans1_sprung_vs_3_7,
             trans1_sprung_vs_3_8,
             trans1_sprung_vs_3_9,
             trans1_sprung_vs_3_10,
             trans1_sprung_vs_3_11,
             trans1_sprung_vs_3_12,
             trans1_sprung_vs_3_13,
             trans1_sprung_vs_3_14,
             trans1_sprung_vs_3_15,
             trans1_sprung_vs_3_16,
             trans1_sprung_vs_3_17,
             trans1_sprung_vs_3_18,
             trans1_sprung_vs_3_19,
             trans1_sprung_vs_3_20,
             trans1_sprung_vs_3_21,
             trans1_sprung_vs_3_22,
             trans1_sprung_vs_3_23,
             trans1_sprung_vs_3_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_vs_4
{
    SLOT 0;
    INDEX 96;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_vs_4_0,
             trans1_sprung_vs_4_1,
             trans1_sprung_vs_4_2,
             trans1_sprung_vs_4_3,
             trans1_sprung_vs_4_4,
             trans1_sprung_vs_4_5,
             trans1_sprung_vs_4_6,
             trans1_sprung_vs_4_7,
             trans1_sprung_vs_4_8,
             trans1_sprung_vs_4_9,
             trans1_sprung_vs_4_10,
             trans1_sprung_vs_4_11,
             trans1_sprung_vs_4_12,
             trans1_sprung_vs_4_13,
             trans1_sprung_vs_4_14,
             trans1_sprung_vs_4_15,
             trans1_sprung_vs_4_16,
             trans1_sprung_vs_4_17,
             trans1_sprung_vs_4_18,
             trans1_sprung_vs_4_19,
             trans1_sprung_vs_4_20,
             trans1_sprung_vs_4_21,
             trans1_sprung_vs_4_22,
             trans1_sprung_vs_4_23,
             trans1_sprung_vs_4_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_sw_1
{
    SLOT 0;
    INDEX 97;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_sw_1_0,
             trans1_sprung_sw_1_1,
             trans1_sprung_sw_1_2,
             trans1_sprung_sw_1_3,
             trans1_sprung_sw_1_4,
             trans1_sprung_sw_1_5,
             trans1_sprung_sw_1_6,
             trans1_sprung_sw_1_7,
             trans1_sprung_sw_1_8,
             trans1_sprung_sw_1_9,
             trans1_sprung_sw_1_10,
             trans1_sprung_sw_1_11,
             trans1_sprung_sw_1_12,
             trans1_sprung_sw_1_13,
             trans1_sprung_sw_1_14,
             trans1_sprung_sw_1_15,
             trans1_sprung_sw_1_16,
             trans1_sprung_sw_1_17,
             trans1_sprung_sw_1_18,
             trans1_sprung_sw_1_19,
             trans1_sprung_sw_1_20,
             trans1_sprung_sw_1_21,
             trans1_sprung_sw_1_22,
             trans1_sprung_sw_1_23,
             trans1_sprung_sw_1_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_sw_2
{
    SLOT 0;
    INDEX 98;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_sw_2_0,
             trans1_sprung_sw_2_1,
             trans1_sprung_sw_2_2,
             trans1_sprung_sw_2_3,
             trans1_sprung_sw_2_4,
             trans1_sprung_sw_2_5,
             trans1_sprung_sw_2_6,
             trans1_sprung_sw_2_7,
             trans1_sprung_sw_2_8,
             trans1_sprung_sw_2_9,
             trans1_sprung_sw_2_10,
             trans1_sprung_sw_2_11,
             trans1_sprung_sw_2_12,
             trans1_sprung_sw_2_13,
             trans1_sprung_sw_2_14,
             trans1_sprung_sw_2_15,
             trans1_sprung_sw_2_16,
             trans1_sprung_sw_2_17,
             trans1_sprung_sw_2_18,
             trans1_sprung_sw_2_19,
             trans1_sprung_sw_2_20,
             trans1_sprung_sw_2_21,
             trans1_sprung_sw_2_22,
             trans1_sprung_sw_2_23,
             trans1_sprung_sw_2_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_sw_3
{
    SLOT 0;
    INDEX 99;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_sw_3_0,
             trans1_sprung_sw_3_1,
             trans1_sprung_sw_3_2,
             trans1_sprung_sw_3_3,
             trans1_sprung_sw_3_4,
             trans1_sprung_sw_3_5,
             trans1_sprung_sw_3_6,
             trans1_sprung_sw_3_7,
             trans1_sprung_sw_3_8,
             trans1_sprung_sw_3_9,
             trans1_sprung_sw_3_10,
             trans1_sprung_sw_3_11,
             trans1_sprung_sw_3_12,
             trans1_sprung_sw_3_13,
             trans1_sprung_sw_3_14,
             trans1_sprung_sw_3_15,
             trans1_sprung_sw_3_16,
             trans1_sprung_sw_3_17,
             trans1_sprung_sw_3_18,
             trans1_sprung_sw_3_19,
             trans1_sprung_sw_3_20,
             trans1_sprung_sw_3_21,
             trans1_sprung_sw_3_22,
             trans1_sprung_sw_3_23,
             trans1_sprung_sw_3_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_sw_4
{
    SLOT 0;
    INDEX 100;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_sw_4_0,
             trans1_sprung_sw_4_1,
             trans1_sprung_sw_4_2,
             trans1_sprung_sw_4_3,
             trans1_sprung_sw_4_4,
             trans1_sprung_sw_4_5,
             trans1_sprung_sw_4_6,
             trans1_sprung_sw_4_7,
             trans1_sprung_sw_4_8,
             trans1_sprung_sw_4_9,
             trans1_sprung_sw_4_10,
             trans1_sprung_sw_4_11,
             trans1_sprung_sw_4_12,
             trans1_sprung_sw_4_13,
             trans1_sprung_sw_4_14,
             trans1_sprung_sw_4_15,
             trans1_sprung_sw_4_16,
             trans1_sprung_sw_4_17,
             trans1_sprung_sw_4_18,
             trans1_sprung_sw_4_19,
             trans1_sprung_sw_4_20,
             trans1_sprung_sw_4_21,
             trans1_sprung_sw_4_22,
             trans1_sprung_sw_4_23,
             trans1_sprung_sw_4_24
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_ss_1
{
    SLOT 0;
    INDEX 101;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_ss_1_0,
             trans1_sprung_ss_1_1,
             trans1_sprung_ss_1_2,
             trans1_sprung_ss_1_3,
             trans1_sprung_ss_1_4,
             trans1_sprung_ss_1_5,
             trans1_sprung_ss_1_6,
             trans1_sprung_ss_1_7,
             trans1_sprung_ss_1_8,
             trans1_sprung_ss_1_9,
             trans1_sprung_ss_1_10,
             trans1_sprung_ss_1_11,
             trans1_sprung_ss_1_12,
             trans1_sprung_ss_1_13,
             trans1_sprung_ss_1_14,
             trans1_sprung_ss_1_15,
             trans1_sprung_ss_1_16,
             trans1_sprung_ss_1_17,
             trans1_sprung_ss_1_18,
             trans1_sprung_ss_1_19,
             trans1_sprung_ss_1_20,
             trans1_sprung_ss_1_21,
             trans1_sprung_ss_1_22,
             trans1_sprung_ss_1_23,
             trans1_sprung_ss_1_24,
             trans1_sprung_ss_1_25,
             trans1_sprung_ss_1_26,
             trans1_sprung_ss_1_27,
             trans1_sprung_ss_1_28,
             trans1_sprung_ss_1_29,
             trans1_sprung_ss_1_30,
             trans1_sprung_ss_1_31,
             trans1_sprung_ss_1_32,
             trans1_sprung_ss_1_33,
             trans1_sprung_ss_1_34,
             trans1_sprung_ss_1_35,
             trans1_sprung_ss_1_36,
             trans1_sprung_ss_1_37,
             trans1_sprung_ss_1_38,
             trans1_sprung_ss_1_39,
             trans1_sprung_ss_1_40,
             trans1_sprung_ss_1_41,
             trans1_sprung_ss_1_42,
             trans1_sprung_ss_1_43,
             trans1_sprung_ss_1_44,
             trans1_sprung_ss_1_45,
             trans1_sprung_ss_1_46,
             trans1_sprung_ss_1_47,
             trans1_sprung_ss_1_48,
             trans1_sprung_ss_1_49
     	}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_ss_2
{
    SLOT 0;
    INDEX 102;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_ss_2_0,
             trans1_sprung_ss_2_1,
             trans1_sprung_ss_2_2,
             trans1_sprung_ss_2_3,
             trans1_sprung_ss_2_4,
             trans1_sprung_ss_2_5,
             trans1_sprung_ss_2_6,
             trans1_sprung_ss_2_7,
             trans1_sprung_ss_2_8,
             trans1_sprung_ss_2_9,
             trans1_sprung_ss_2_10,
             trans1_sprung_ss_2_11,
             trans1_sprung_ss_2_12,
             trans1_sprung_ss_2_13,
             trans1_sprung_ss_2_14,
             trans1_sprung_ss_2_15,
             trans1_sprung_ss_2_16,
             trans1_sprung_ss_2_17,
             trans1_sprung_ss_2_18,
             trans1_sprung_ss_2_19,
             trans1_sprung_ss_2_20,
             trans1_sprung_ss_2_21,
             trans1_sprung_ss_2_22,
             trans1_sprung_ss_2_23,
             trans1_sprung_ss_2_24,
             trans1_sprung_ss_2_25,
             trans1_sprung_ss_2_26,
             trans1_sprung_ss_2_27,
             trans1_sprung_ss_2_28,
             trans1_sprung_ss_2_29,
             trans1_sprung_ss_2_30,
             trans1_sprung_ss_2_31,
             trans1_sprung_ss_2_32,
             trans1_sprung_ss_2_33,
             trans1_sprung_ss_2_34,
             trans1_sprung_ss_2_35,
             trans1_sprung_ss_2_36,
             trans1_sprung_ss_2_37,
             trans1_sprung_ss_2_38,
             trans1_sprung_ss_2_39,
             trans1_sprung_ss_2_40,
             trans1_sprung_ss_2_41,
             trans1_sprung_ss_2_42,
             trans1_sprung_ss_2_43,
             trans1_sprung_ss_2_44,
             trans1_sprung_ss_2_45,
             trans1_sprung_ss_2_46,
             trans1_sprung_ss_2_47,
             trans1_sprung_ss_2_48,
             trans1_sprung_ss_2_49
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_e_1
{
    SLOT 0;
    INDEX 103;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_e_1_0,
             trans1_sprung_e_1_1,
             trans1_sprung_e_1_2,
             trans1_sprung_e_1_3,
             trans1_sprung_e_1_4,
             trans1_sprung_e_1_5,
             trans1_sprung_e_1_6,
             trans1_sprung_e_1_7,
             trans1_sprung_e_1_8,
             trans1_sprung_e_1_9,
             trans1_sprung_e_1_10,
             trans1_sprung_e_1_11,
             trans1_sprung_e_1_12,
             trans1_sprung_e_1_13,
             trans1_sprung_e_1_14,
             trans1_sprung_e_1_15,
             trans1_sprung_e_1_16,
             trans1_sprung_e_1_17,
             trans1_sprung_e_1_18,
             trans1_sprung_e_1_19,
             trans1_sprung_e_1_20,
             trans1_sprung_e_1_21,
             trans1_sprung_e_1_22,
             trans1_sprung_e_1_23,
             trans1_sprung_e_1_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_e_2
{
    SLOT 0;
    INDEX 104;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_e_2_0,
             trans1_sprung_e_2_1,
             trans1_sprung_e_2_2,
             trans1_sprung_e_2_3,
             trans1_sprung_e_2_4,
             trans1_sprung_e_2_5,
             trans1_sprung_e_2_6,
             trans1_sprung_e_2_7,
             trans1_sprung_e_2_8,
             trans1_sprung_e_2_9,
             trans1_sprung_e_2_10,
             trans1_sprung_e_2_11,
             trans1_sprung_e_2_12,
             trans1_sprung_e_2_13,
             trans1_sprung_e_2_14,
             trans1_sprung_e_2_15,
             trans1_sprung_e_2_16,
             trans1_sprung_e_2_17,
             trans1_sprung_e_2_18,
             trans1_sprung_e_2_19,
             trans1_sprung_e_2_20,
             trans1_sprung_e_2_21,
             trans1_sprung_e_2_22,
             trans1_sprung_e_2_23,
             trans1_sprung_e_2_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_e_3
{
    SLOT 0;
    INDEX 105;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_e_3_0,
             trans1_sprung_e_3_1,
             trans1_sprung_e_3_2,
             trans1_sprung_e_3_3,
             trans1_sprung_e_3_4,
             trans1_sprung_e_3_5,
             trans1_sprung_e_3_6,
             trans1_sprung_e_3_7,
             trans1_sprung_e_3_8,
             trans1_sprung_e_3_9,
             trans1_sprung_e_3_10,
             trans1_sprung_e_3_11,
             trans1_sprung_e_3_12,
             trans1_sprung_e_3_13,
             trans1_sprung_e_3_14,
             trans1_sprung_e_3_15,
             trans1_sprung_e_3_16,
             trans1_sprung_e_3_17,
             trans1_sprung_e_3_18,
             trans1_sprung_e_3_19,
             trans1_sprung_e_3_20,
             trans1_sprung_e_3_21,
             trans1_sprung_e_3_22,
             trans1_sprung_e_3_23,
             trans1_sprung_e_3_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_e_4
{
    SLOT 0;
    INDEX 106;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_e_4_0,
             trans1_sprung_e_4_1,
             trans1_sprung_e_4_2,
             trans1_sprung_e_4_3,
             trans1_sprung_e_4_4,
             trans1_sprung_e_4_5,
             trans1_sprung_e_4_6,
             trans1_sprung_e_4_7,
             trans1_sprung_e_4_8,
             trans1_sprung_e_4_9,
             trans1_sprung_e_4_10,
             trans1_sprung_e_4_11,
             trans1_sprung_e_4_12,
             trans1_sprung_e_4_13,
             trans1_sprung_e_4_14,
             trans1_sprung_e_4_15,
             trans1_sprung_e_4_16,
             trans1_sprung_e_4_17,
             trans1_sprung_e_4_18,
             trans1_sprung_e_4_19,
             trans1_sprung_e_4_20,
             trans1_sprung_e_4_21,
             trans1_sprung_e_4_22,
             trans1_sprung_e_4_23,
             trans1_sprung_e_4_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_t_1
{
    SLOT 0;
    INDEX 107;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_t_1_0,
             trans1_sprung_t_1_1,
             trans1_sprung_t_1_2,
             trans1_sprung_t_1_3,
             trans1_sprung_t_1_4,
             trans1_sprung_t_1_5,
             trans1_sprung_t_1_6,
             trans1_sprung_t_1_7,
             trans1_sprung_t_1_8,
             trans1_sprung_t_1_9,
             trans1_sprung_t_1_10,
             trans1_sprung_t_1_11,
             trans1_sprung_t_1_12,
             trans1_sprung_t_1_13,
             trans1_sprung_t_1_14,
             trans1_sprung_t_1_15,
             trans1_sprung_t_1_16,
             trans1_sprung_t_1_17,
             trans1_sprung_t_1_18,
             trans1_sprung_t_1_19,
             trans1_sprung_t_1_20,
             trans1_sprung_t_1_21,
             trans1_sprung_t_1_22,
             trans1_sprung_t_1_23,
             trans1_sprung_t_1_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_t_2
{
    SLOT 0;
    INDEX 108;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_t_2_0,
             trans1_sprung_t_2_1,
             trans1_sprung_t_2_2,
             trans1_sprung_t_2_3,
             trans1_sprung_t_2_4,
             trans1_sprung_t_2_5,
             trans1_sprung_t_2_6,
             trans1_sprung_t_2_7,
             trans1_sprung_t_2_8,
             trans1_sprung_t_2_9,
             trans1_sprung_t_2_10,
             trans1_sprung_t_2_11,
             trans1_sprung_t_2_12,
             trans1_sprung_t_2_13,
             trans1_sprung_t_2_14,
             trans1_sprung_t_2_15,
             trans1_sprung_t_2_16,
             trans1_sprung_t_2_17,
             trans1_sprung_t_2_18,
             trans1_sprung_t_2_19,
             trans1_sprung_t_2_20,
             trans1_sprung_t_2_21,
             trans1_sprung_t_2_22,
             trans1_sprung_t_2_23,
             trans1_sprung_t_2_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_t_3
{
    SLOT 0;
    INDEX 109;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_t_3_0,
             trans1_sprung_t_3_1,
             trans1_sprung_t_3_2,
             trans1_sprung_t_3_3,
             trans1_sprung_t_3_4,
             trans1_sprung_t_3_5,
             trans1_sprung_t_3_6,
             trans1_sprung_t_3_7,
             trans1_sprung_t_3_8,
             trans1_sprung_t_3_9,
             trans1_sprung_t_3_10,
             trans1_sprung_t_3_11,
             trans1_sprung_t_3_12,
             trans1_sprung_t_3_13,
             trans1_sprung_t_3_14,
             trans1_sprung_t_3_15,
             trans1_sprung_t_3_16,
             trans1_sprung_t_3_17,
             trans1_sprung_t_3_18,
             trans1_sprung_t_3_19,
             trans1_sprung_t_3_20,
             trans1_sprung_t_3_21,
             trans1_sprung_t_3_22,
             trans1_sprung_t_3_23,
             trans1_sprung_t_3_24
     		}
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_sprung_t_4
{
    SLOT 0;
    INDEX 110;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_sprung_t_4_0,
             trans1_sprung_t_4_1,
             trans1_sprung_t_4_2,
             trans1_sprung_t_4_3,
             trans1_sprung_t_4_4,
             trans1_sprung_t_4_5,
             trans1_sprung_t_4_6,
             trans1_sprung_t_4_7,
             trans1_sprung_t_4_8,
             trans1_sprung_t_4_9,
             trans1_sprung_t_4_10,
             trans1_sprung_t_4_11,
             trans1_sprung_t_4_12,
             trans1_sprung_t_4_13,
             trans1_sprung_t_4_14,
             trans1_sprung_t_4_15,
             trans1_sprung_t_4_16,
             trans1_sprung_t_4_17,
             trans1_sprung_t_4_18,
             trans1_sprung_t_4_19,
             trans1_sprung_t_4_20,
             trans1_sprung_t_4_21,
             trans1_sprung_t_4_22,
             trans1_sprung_t_4_23,
             trans1_sprung_t_4_24
     		}
    }
}


/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_1
{
    SLOT 0;
    INDEX 111;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_1_0,
             trans1_datalogger_sw_1_0,
             trans1_datalogger_ss_1_0,
             trans1_datalogger_e_1_0,
             trans1_datalogger_t_1_0,
             trans1_datalogger_vs_1_1,
             trans1_datalogger_sw_1_1,
             trans1_datalogger_ss_1_1,
             trans1_datalogger_e_1_1,
             trans1_datalogger_t_1_1,
             trans1_datalogger_vs_1_2,
             trans1_datalogger_sw_1_2,
             trans1_datalogger_ss_1_2,
             trans1_datalogger_e_1_2,
             trans1_datalogger_t_1_2,
             trans1_datalogger_vs_1_3,
             trans1_datalogger_sw_1_3,
             trans1_datalogger_ss_1_3,
             trans1_datalogger_e_1_3,
             trans1_datalogger_t_1_3,
             trans1_datalogger_vs_1_4,
             trans1_datalogger_sw_1_4,
             trans1_datalogger_ss_1_4,
             trans1_datalogger_e_1_4,
             trans1_datalogger_t_1_4,
             trans1_datalogger_vs_1_5,
             trans1_datalogger_sw_1_5,
             trans1_datalogger_ss_1_5,
             trans1_datalogger_e_1_5,
             trans1_datalogger_t_1_5,
             trans1_datalogger_vs_1_6,
             trans1_datalogger_sw_1_6,
             trans1_datalogger_ss_1_6,
             trans1_datalogger_e_1_6,
             trans1_datalogger_t_1_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_2
{
    SLOT 0;
    INDEX 112;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_2_0,
             trans1_datalogger_sw_2_0,
             trans1_datalogger_ss_2_0,
             trans1_datalogger_e_2_0,
             trans1_datalogger_t_2_0,
             trans1_datalogger_vs_2_1,
             trans1_datalogger_sw_2_1,
             trans1_datalogger_ss_2_1,
             trans1_datalogger_e_2_1,
             trans1_datalogger_t_2_1,
             trans1_datalogger_vs_2_2,
             trans1_datalogger_sw_2_2,
             trans1_datalogger_ss_2_2,
             trans1_datalogger_e_2_2,
             trans1_datalogger_t_2_2,
             trans1_datalogger_vs_2_3,
             trans1_datalogger_sw_2_3,
             trans1_datalogger_ss_2_3,
             trans1_datalogger_e_2_3,
             trans1_datalogger_t_2_3,
             trans1_datalogger_vs_2_4,
             trans1_datalogger_sw_2_4,
             trans1_datalogger_ss_2_4,
             trans1_datalogger_e_2_4,
             trans1_datalogger_t_2_4,
             trans1_datalogger_vs_2_5,
             trans1_datalogger_sw_2_5,
             trans1_datalogger_ss_2_5,
             trans1_datalogger_e_2_5,
             trans1_datalogger_t_2_5,
             trans1_datalogger_vs_2_6,
             trans1_datalogger_sw_2_6,
             trans1_datalogger_ss_2_6,
             trans1_datalogger_e_2_6,
             trans1_datalogger_t_2_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_3
{
    SLOT 0;
    INDEX 113;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_3_0,
             trans1_datalogger_sw_3_0,
             trans1_datalogger_ss_3_0,
             trans1_datalogger_e_3_0,
             trans1_datalogger_t_3_0,
             trans1_datalogger_vs_3_1,
             trans1_datalogger_sw_3_1,
             trans1_datalogger_ss_3_1,
             trans1_datalogger_e_3_1,
             trans1_datalogger_t_3_1,
             trans1_datalogger_vs_3_2,
             trans1_datalogger_sw_3_2,
             trans1_datalogger_ss_3_2,
             trans1_datalogger_e_3_2,
             trans1_datalogger_t_3_2,
             trans1_datalogger_vs_3_3,
             trans1_datalogger_sw_3_3,
             trans1_datalogger_ss_3_3,
             trans1_datalogger_e_3_3,
             trans1_datalogger_t_3_3,
             trans1_datalogger_vs_3_4,
             trans1_datalogger_sw_3_4,
             trans1_datalogger_ss_3_4,
             trans1_datalogger_e_3_4,
             trans1_datalogger_t_3_4,
             trans1_datalogger_vs_3_5,
             trans1_datalogger_sw_3_5,
             trans1_datalogger_ss_3_5,
             trans1_datalogger_e_3_5,
             trans1_datalogger_t_3_5,
             trans1_datalogger_vs_3_6,
             trans1_datalogger_sw_3_6,
             trans1_datalogger_ss_3_6,
             trans1_datalogger_e_3_6,
             trans1_datalogger_t_3_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_4
{
    SLOT 0;
    INDEX 114;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_4_0,
             trans1_datalogger_sw_4_0,
             trans1_datalogger_ss_4_0,
             trans1_datalogger_e_4_0,
             trans1_datalogger_t_4_0,
             trans1_datalogger_vs_4_1,
             trans1_datalogger_sw_4_1,
             trans1_datalogger_ss_4_1,
             trans1_datalogger_e_4_1,
             trans1_datalogger_t_4_1,
             trans1_datalogger_vs_4_2,
             trans1_datalogger_sw_4_2,
             trans1_datalogger_ss_4_2,
             trans1_datalogger_e_4_2,
             trans1_datalogger_t_4_2,
             trans1_datalogger_vs_4_3,
             trans1_datalogger_sw_4_3,
             trans1_datalogger_ss_4_3,
             trans1_datalogger_e_4_3,
             trans1_datalogger_t_4_3,
             trans1_datalogger_vs_4_4,
             trans1_datalogger_sw_4_4,
             trans1_datalogger_ss_4_4,
             trans1_datalogger_e_4_4,
             trans1_datalogger_t_4_4,
             trans1_datalogger_vs_4_5,
             trans1_datalogger_sw_4_5,
             trans1_datalogger_ss_4_5,
             trans1_datalogger_e_4_5,
             trans1_datalogger_t_4_5,
             trans1_datalogger_vs_4_6,
             trans1_datalogger_sw_4_6,
             trans1_datalogger_ss_4_6,
             trans1_datalogger_e_4_6,
             trans1_datalogger_t_4_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_5
{
    SLOT 0;
    INDEX 115;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_5_0,
             trans1_datalogger_sw_5_0,
             trans1_datalogger_ss_5_0,
             trans1_datalogger_e_5_0,
             trans1_datalogger_t_5_0,
             trans1_datalogger_vs_5_1,
             trans1_datalogger_sw_5_1,
             trans1_datalogger_ss_5_1,
             trans1_datalogger_e_5_1,
             trans1_datalogger_t_5_1,
             trans1_datalogger_vs_5_2,
             trans1_datalogger_sw_5_2,
             trans1_datalogger_ss_5_2,
             trans1_datalogger_e_5_2,
             trans1_datalogger_t_5_2,
             trans1_datalogger_vs_5_3,
             trans1_datalogger_sw_5_3,
             trans1_datalogger_ss_5_3,
             trans1_datalogger_e_5_3,
             trans1_datalogger_t_5_3,
             trans1_datalogger_vs_5_4,
             trans1_datalogger_sw_5_4,
             trans1_datalogger_ss_5_4,
             trans1_datalogger_e_5_4,
             trans1_datalogger_t_5_4,
             trans1_datalogger_vs_5_5,
             trans1_datalogger_sw_5_5,
             trans1_datalogger_ss_5_5,
             trans1_datalogger_e_5_5,
             trans1_datalogger_t_5_5,
             trans1_datalogger_vs_5_6,
             trans1_datalogger_sw_5_6,
             trans1_datalogger_ss_5_6,
             trans1_datalogger_e_5_6,
             trans1_datalogger_t_5_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_6
{
    SLOT 0;
    INDEX 116;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_6_0,
             trans1_datalogger_sw_6_0,
             trans1_datalogger_ss_6_0,
             trans1_datalogger_e_6_0,
             trans1_datalogger_t_6_0,
             trans1_datalogger_vs_6_1,
             trans1_datalogger_sw_6_1,
             trans1_datalogger_ss_6_1,
             trans1_datalogger_e_6_1,
             trans1_datalogger_t_6_1,
             trans1_datalogger_vs_6_2,
             trans1_datalogger_sw_6_2,
             trans1_datalogger_ss_6_2,
             trans1_datalogger_e_6_2,
             trans1_datalogger_t_6_2,
             trans1_datalogger_vs_6_3,
             trans1_datalogger_sw_6_3,
             trans1_datalogger_ss_6_3,
             trans1_datalogger_e_6_3,
             trans1_datalogger_t_6_3,
             trans1_datalogger_vs_6_4,
             trans1_datalogger_sw_6_4,
             trans1_datalogger_ss_6_4,
             trans1_datalogger_e_6_4,
             trans1_datalogger_t_6_4,
             trans1_datalogger_vs_6_5,
             trans1_datalogger_sw_6_5,
             trans1_datalogger_ss_6_5,
             trans1_datalogger_e_6_5,
             trans1_datalogger_t_6_5,
             trans1_datalogger_vs_6_6,
             trans1_datalogger_sw_6_6,
             trans1_datalogger_ss_6_6,
             trans1_datalogger_e_6_6,
             trans1_datalogger_t_6_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_7
{
    SLOT 0;
    INDEX 117;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_7_0,
             trans1_datalogger_sw_7_0,
             trans1_datalogger_ss_7_0,
             trans1_datalogger_e_7_0,
             trans1_datalogger_t_7_0,
             trans1_datalogger_vs_7_1,
             trans1_datalogger_sw_7_1,
             trans1_datalogger_ss_7_1,
             trans1_datalogger_e_7_1,
             trans1_datalogger_t_7_1,
             trans1_datalogger_vs_7_2,
             trans1_datalogger_sw_7_2,
             trans1_datalogger_ss_7_2,
             trans1_datalogger_e_7_2,
             trans1_datalogger_t_7_2,
             trans1_datalogger_vs_7_3,
             trans1_datalogger_sw_7_3,
             trans1_datalogger_ss_7_3,
             trans1_datalogger_e_7_3,
             trans1_datalogger_t_7_3,
             trans1_datalogger_vs_7_4,
             trans1_datalogger_sw_7_4,
             trans1_datalogger_ss_7_4,
             trans1_datalogger_e_7_4,
             trans1_datalogger_t_7_4,
             trans1_datalogger_vs_7_5,
             trans1_datalogger_sw_7_5,
             trans1_datalogger_ss_7_5,
             trans1_datalogger_e_7_5,
             trans1_datalogger_t_7_5,
             trans1_datalogger_vs_7_6,
             trans1_datalogger_sw_7_6,
             trans1_datalogger_ss_7_6,
             trans1_datalogger_e_7_6,
             trans1_datalogger_t_7_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_8
{
    SLOT 0;
    INDEX 118;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_8_0,
             trans1_datalogger_sw_8_0,
             trans1_datalogger_ss_8_0,
             trans1_datalogger_e_8_0,
             trans1_datalogger_t_8_0,
             trans1_datalogger_vs_8_1,
             trans1_datalogger_sw_8_1,
             trans1_datalogger_ss_8_1,
             trans1_datalogger_e_8_1,
             trans1_datalogger_t_8_1,
             trans1_datalogger_vs_8_2,
             trans1_datalogger_sw_8_2,
             trans1_datalogger_ss_8_2,
             trans1_datalogger_e_8_2,
             trans1_datalogger_t_8_2,
             trans1_datalogger_vs_8_3,
             trans1_datalogger_sw_8_3,
             trans1_datalogger_ss_8_3,
             trans1_datalogger_e_8_3,
             trans1_datalogger_t_8_3,
             trans1_datalogger_vs_8_4,
             trans1_datalogger_sw_8_4,
             trans1_datalogger_ss_8_4,
             trans1_datalogger_e_8_4,
             trans1_datalogger_t_8_4,
             trans1_datalogger_vs_8_5,
             trans1_datalogger_sw_8_5,
             trans1_datalogger_ss_8_5,
             trans1_datalogger_e_8_5,
             trans1_datalogger_t_8_5,
             trans1_datalogger_vs_8_6,
             trans1_datalogger_sw_8_6,
             trans1_datalogger_ss_8_6,
             trans1_datalogger_e_8_6,
             trans1_datalogger_t_8_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_9
{
    SLOT 0;
    INDEX 119;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_9_0,
             trans1_datalogger_sw_9_0,
             trans1_datalogger_ss_9_0,
             trans1_datalogger_e_9_0,
             trans1_datalogger_t_9_0,
             trans1_datalogger_vs_9_1,
             trans1_datalogger_sw_9_1,
             trans1_datalogger_ss_9_1,
             trans1_datalogger_e_9_1,
             trans1_datalogger_t_9_1,
             trans1_datalogger_vs_9_2,
             trans1_datalogger_sw_9_2,
             trans1_datalogger_ss_9_2,
             trans1_datalogger_e_9_2,
             trans1_datalogger_t_9_2,
             trans1_datalogger_vs_9_3,
             trans1_datalogger_sw_9_3,
             trans1_datalogger_ss_9_3,
             trans1_datalogger_e_9_3,
             trans1_datalogger_t_9_3,
             trans1_datalogger_vs_9_4,
             trans1_datalogger_sw_9_4,
             trans1_datalogger_ss_9_4,
             trans1_datalogger_e_9_4,
             trans1_datalogger_t_9_4,
             trans1_datalogger_vs_9_5,
             trans1_datalogger_sw_9_5,
             trans1_datalogger_ss_9_5,
             trans1_datalogger_e_9_5,
             trans1_datalogger_t_9_5,
             trans1_datalogger_vs_9_6,
             trans1_datalogger_sw_9_6,
             trans1_datalogger_ss_9_6,
             trans1_datalogger_e_9_6,
             trans1_datalogger_t_9_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_10
{
    SLOT 0;
    INDEX 120;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_10_0,
             trans1_datalogger_sw_10_0,
             trans1_datalogger_ss_10_0,
             trans1_datalogger_e_10_0,
             trans1_datalogger_t_10_0,
             trans1_datalogger_vs_10_1,
             trans1_datalogger_sw_10_1,
             trans1_datalogger_ss_10_1,
             trans1_datalogger_e_10_1,
             trans1_datalogger_t_10_1,
             trans1_datalogger_vs_10_2,
             trans1_datalogger_sw_10_2,
             trans1_datalogger_ss_10_2,
             trans1_datalogger_e_10_2,
             trans1_datalogger_t_10_2,
             trans1_datalogger_vs_10_3,
             trans1_datalogger_sw_10_3,
             trans1_datalogger_ss_10_3,
             trans1_datalogger_e_10_3,
             trans1_datalogger_t_10_3,
             trans1_datalogger_vs_10_4,
             trans1_datalogger_sw_10_4,
             trans1_datalogger_ss_10_4,
             trans1_datalogger_e_10_4,
             trans1_datalogger_t_10_4,
             trans1_datalogger_vs_10_5,
             trans1_datalogger_sw_10_5,
             trans1_datalogger_ss_10_5,
             trans1_datalogger_e_10_5,
             trans1_datalogger_t_10_5,
             trans1_datalogger_vs_10_6,
             trans1_datalogger_sw_10_6,
             trans1_datalogger_ss_10_6,
             trans1_datalogger_e_10_6,
             trans1_datalogger_t_10_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_11
{
    SLOT 0;
    INDEX 121;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_11_0,
             trans1_datalogger_sw_11_0,
             trans1_datalogger_ss_11_0,
             trans1_datalogger_e_11_0,
             trans1_datalogger_t_11_0,
             trans1_datalogger_vs_11_1,
             trans1_datalogger_sw_11_1,
             trans1_datalogger_ss_11_1,
             trans1_datalogger_e_11_1,
             trans1_datalogger_t_11_1,
             trans1_datalogger_vs_11_2,
             trans1_datalogger_sw_11_2,
             trans1_datalogger_ss_11_2,
             trans1_datalogger_e_11_2,
             trans1_datalogger_t_11_2,
             trans1_datalogger_vs_11_3,
             trans1_datalogger_sw_11_3,
             trans1_datalogger_ss_11_3,
             trans1_datalogger_e_11_3,
             trans1_datalogger_t_11_3,
             trans1_datalogger_vs_11_4,
             trans1_datalogger_sw_11_4,
             trans1_datalogger_ss_11_4,
             trans1_datalogger_e_11_4,
             trans1_datalogger_t_11_4,
             trans1_datalogger_vs_11_5,
             trans1_datalogger_sw_11_5,
             trans1_datalogger_ss_11_5,
             trans1_datalogger_e_11_5,
             trans1_datalogger_t_11_5,
             trans1_datalogger_vs_11_6,
             trans1_datalogger_sw_11_6,
             trans1_datalogger_ss_11_6,
             trans1_datalogger_e_11_6,
             trans1_datalogger_t_11_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_12
{
    SLOT 0;
    INDEX 122;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_12_0,
             trans1_datalogger_sw_12_0,
             trans1_datalogger_ss_12_0,
             trans1_datalogger_e_12_0,
             trans1_datalogger_t_12_0,
             trans1_datalogger_vs_12_1,
             trans1_datalogger_sw_12_1,
             trans1_datalogger_ss_12_1,
             trans1_datalogger_e_12_1,
             trans1_datalogger_t_12_1,
             trans1_datalogger_vs_12_2,
             trans1_datalogger_sw_12_2,
             trans1_datalogger_ss_12_2,
             trans1_datalogger_e_12_2,
             trans1_datalogger_t_12_2,
             trans1_datalogger_vs_12_3,
             trans1_datalogger_sw_12_3,
             trans1_datalogger_ss_12_3,
             trans1_datalogger_e_12_3,
             trans1_datalogger_t_12_3,
             trans1_datalogger_vs_12_4,
             trans1_datalogger_sw_12_4,
             trans1_datalogger_ss_12_4,
             trans1_datalogger_e_12_4,
             trans1_datalogger_t_12_4,
             trans1_datalogger_vs_12_5,
             trans1_datalogger_sw_12_5,
             trans1_datalogger_ss_12_5,
             trans1_datalogger_e_12_5,
             trans1_datalogger_t_12_5,
             trans1_datalogger_vs_12_6,
             trans1_datalogger_sw_12_6,
             trans1_datalogger_ss_12_6,
             trans1_datalogger_e_12_6,
             trans1_datalogger_t_12_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_13
{
    SLOT 0;
    INDEX 123;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_13_0,
             trans1_datalogger_sw_13_0,
             trans1_datalogger_ss_13_0,
             trans1_datalogger_e_13_0,
             trans1_datalogger_t_13_0,
             trans1_datalogger_vs_13_1,
             trans1_datalogger_sw_13_1,
             trans1_datalogger_ss_13_1,
             trans1_datalogger_e_13_1,
             trans1_datalogger_t_13_1,
             trans1_datalogger_vs_13_2,
             trans1_datalogger_sw_13_2,
             trans1_datalogger_ss_13_2,
             trans1_datalogger_e_13_2,
             trans1_datalogger_t_13_2,
             trans1_datalogger_vs_13_3,
             trans1_datalogger_sw_13_3,
             trans1_datalogger_ss_13_3,
             trans1_datalogger_e_13_3,
             trans1_datalogger_t_13_3,
             trans1_datalogger_vs_13_4,
             trans1_datalogger_sw_13_4,
             trans1_datalogger_ss_13_4,
             trans1_datalogger_e_13_4,
             trans1_datalogger_t_13_4,
             trans1_datalogger_vs_13_5,
             trans1_datalogger_sw_13_5,
             trans1_datalogger_ss_13_5,
             trans1_datalogger_e_13_5,
             trans1_datalogger_t_13_5,
             trans1_datalogger_vs_13_6,
             trans1_datalogger_sw_13_6,
             trans1_datalogger_ss_13_6,
             trans1_datalogger_e_13_6,
             trans1_datalogger_t_13_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_14
{
    SLOT 0;
    INDEX 124;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_14_0,
             trans1_datalogger_sw_14_0,
             trans1_datalogger_ss_14_0,
             trans1_datalogger_e_14_0,
             trans1_datalogger_t_14_0,
             trans1_datalogger_vs_14_1,
             trans1_datalogger_sw_14_1,
             trans1_datalogger_ss_14_1,
             trans1_datalogger_e_14_1,
             trans1_datalogger_t_14_1,
             trans1_datalogger_vs_14_2,
             trans1_datalogger_sw_14_2,
             trans1_datalogger_ss_14_2,
             trans1_datalogger_e_14_2,
             trans1_datalogger_t_14_2,
             trans1_datalogger_vs_14_3,
             trans1_datalogger_sw_14_3,
             trans1_datalogger_ss_14_3,
             trans1_datalogger_e_14_3,
             trans1_datalogger_t_14_3,
             trans1_datalogger_vs_14_4,
             trans1_datalogger_sw_14_4,
             trans1_datalogger_ss_14_4,
             trans1_datalogger_e_14_4,
             trans1_datalogger_t_14_4,
             trans1_datalogger_vs_14_5,
             trans1_datalogger_sw_14_5,
             trans1_datalogger_ss_14_5,
             trans1_datalogger_e_14_5,
             trans1_datalogger_t_14_5,
             trans1_datalogger_vs_14_6,
             trans1_datalogger_sw_14_6,
             trans1_datalogger_ss_14_6,
             trans1_datalogger_e_14_6,
             trans1_datalogger_t_14_6
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_datalogger_ds_15
{
    SLOT 0;
    INDEX 125;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_datalogger_vs_15_0,
             trans1_datalogger_sw_15_0,
             trans1_datalogger_ss_15_0,
             trans1_datalogger_e_15_0,
             trans1_datalogger_t_15_0,
             trans1_datalogger_vs_15_1,
             trans1_datalogger_sw_15_1,
             trans1_datalogger_ss_15_1,
             trans1_datalogger_e_15_1,
             trans1_datalogger_t_15_1
        }
    }
}


