// PA_Detect.inc
// Description: Common Include for detecting and identifying PA devices



VARIABLE ret_DetectDevice
{
	LABEL		"ret_DetectDevice";
	CLASS		LOCAL;
	TYPE		ASCII(256) ;
	CLASS		TEMPORARY ;
	HANDLING	READ;

#ifdef _PDM_
	STYLE "MULTILINE 64 4" ;
#endif

}


// --- DEBUG Dialog -------------------------------------

#ifdef _DEBUG
MENU OfflineDialog_DetectDevice
{
	LABEL "Detect" ;
	ITEMS
	{
		Page_DetectDevice
	}
}



MENU Page_DetectDevice
{
	LABEL "Detect" ;
	ITEMS
	{
		group_detect_physical_block,
		group_detect_transducer_block,
		group_detect_result,
		SEPARATOR,
		std_DetectDevice
	}
}



MENU group_detect_physical_block
{
	LABEL "Physical Block" ;
	ITEMS
	{
		phys_blk_parent_class,
		phys_blk_profile_rev,
		phys_device_man_id,
		phys_device_id

	}
}

MENU group_detect_transducer_block
{
	LABEL "Transducer Block" ;
	ITEMS
	{
		trans1_blk_parent_class,
		trans1_blk_class,
	}
}

MENU group_detect_result
{
	LABEL "Result" ;
	ITEMS
	{
		ret_DetectDevice
	}
}

#endif



// --- Physical Block Parameter -------------------------------------

BLOCK physical_block
{
	TYPE	PHYSICAL;
	NUMBER	1;
}


VARIABLE phys_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[phys_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[phys_blk_parent_class_TRANSMITTER]	},
		{	2,	[phys_blk_parent_class_ACTUATOR]	},
		{   3,  [phys_blk_parent_class_BIN_IO]		},
		{	5,	[phys_blk_parent_class_ANALYSER]	}
	}
	CLASS		TEMPORARY ;
#ifndef _DEBUG
	HANDLING	READ;
#endif
}

VARIABLE phys_blk_reserve
{
	LABEL		[blk_reserved];
	HELP		[blk_reserved_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	1,	[blk_block_object_PHYSICAL]	}
	}
	CLASS		TEMPORARY ;
	HANDLING	READ;
}


VARIABLE phys_blk_class
{
	LABEL		[blk_class];
	HELP		[phys_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE	250;
		{	250,	[not_used]		}
	}
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	HELP		[blk_dd_reference_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	HELP		[blk_dd_rev_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_profile
{
	LABEL		[blk_profile];
	HELP		[blk_profile_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{ 0x4001,	[blk_profile_PA_COMPACT_A]	},
		{ 0x4002,	[blk_profile_PA_COMPACT_B]	},
		{ 0x4081,	[blk_profile_PA_SIMPLE_A]	},
		{ 0x4082,	[blk_profile_PA_SIMPLE_B]	}
	}
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	HELP		[blk_profile_rev_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	0x0200,	"2.0"	},
		{	0x025D,	"2.93"	},
		{	0x025F,	"2.95"	},
		{	0x0300,	"3.0"	}

	}
	CLASS		TEMPORARY ;
#ifndef _DEBUG
	HANDLING	READ;
#endif
}

VARIABLE phys_blk_execution_time
{
	LABEL		[blk_execution_time];
	HELP		[blk_execution_time_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(1);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_num_parameters
{
	LABEL		[blk_num_parameters];
	HELP		[blk_num_parameters_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	HELP		[blk_index_view_1_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE phys_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	HELP		[blk_num_view_lists_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}



COMMAND read_phys_blk
{
	BLOCK physical_block;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_blk_reserve, phys_blk_object, phys_blk_parent_class, phys_blk_class,
			phys_blk_dd_reference, phys_blk_dd_rev, phys_blk_profile, phys_blk_profile_rev,
			phys_blk_execution_time, phys_blk_num_parameters, phys_blk_index_view_1,
			phys_blk_num_view_lists
		}
	}
}



VARIABLE phys_device_man_id
{
	LABEL		[phys_device_man_id];
	HELP		[phys_device_man_id_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2) ;
	CLASS		TEMPORARY ;
#ifndef _DEBUG
	HANDLING	READ;
#endif
}



COMMAND read_phys_device_man_id
{
	BLOCK physical_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_man_id
		}
	}
}



VARIABLE phys_device_id
{
	LABEL		[phys_device_type];
	HELP		[phys_device_type_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16) ;
	CLASS		TEMPORARY ;
#ifndef _DEBUG
	HANDLING	READ;
#endif
}



COMMAND read_phys_device_id
{
	BLOCK physical_block;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_id
		}
	}
}



VARIABLE phys_software_rev
{
	LABEL		[phys_software_revision];
	HELP		[phys_software_revision_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
		DEFAULT_VALUE	"1";
	}
	HANDLING	READ;
}


COMMAND read_phys_software_rev
{
	BLOCK physical_block;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_software_rev
		}
	}
}




// --- Transducer Block Parameter -------------------------------------

BLOCK transducer_block_1
{
	TYPE	TRANSDUCER;
	NUMBER	1 ;
}



// -- Index 0: blk_object

COMMAND read_trans1_blk
{
	BLOCK transducer_block_1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_blk_reserve, trans1_blk_object, trans1_blk_parent_class, trans1_blk_class,
			trans1_blk_dd_reference, trans1_blk_dd_rev, trans1_blk_profile, trans1_blk_profile_rev,
			trans1_blk_execution_time, trans1_blk_highest_rel_offset, trans1_blk_index_view_1,
			trans1_blk_num_view_lists
		}
	}
}

VARIABLE trans1_blk_reserve
{
	LABEL		[blk_reserved];
	HELP		[blk_reserved_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(1);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE trans1_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	3,	[blk_block_object_TRANSDUCER]		}
	}
	HANDLING	READ;
}

VARIABLE trans1_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[trans_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE 252 ;
		{	1,	[trans_blk_parent_class_PRES]	},
		{	2,	[trans_blk_parent_class_TEMP]	},
		{	3,	[trans_blk_parent_class_FLOW]	},
		{	4,	[trans_blk_parent_class_LEVEL]	},
		{	5,	[trans_blk_parent_class_VALVE]	}
		{	6,	[trans_blk_parent_class_BIN_IO]	},
		{	7,	[trans_blk_parent_class_ANALYSIS]	},
		{	252,	[unknown]					}
	}
	CLASS		TEMPORARY ;
#ifndef _DEBUG
	HANDLING	READ;
#endif
}

VARIABLE trans1_blk_class
{
	LABEL		[blk_class];
	HELP		[trans_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		SELECT( trans1_blk_parent_class )
		{
			CASE 1:
			{	1,		[trans_pres_blk_class_DIFF]	},		
			{	2,		[trans_pres_blk_class_ABS]	},		
			{	3,		[trans_pres_blk_class_GAGE]	},		

			CASE 2:
			{	1,		[trans_temp_blk_class_TC]	},
			{	2,		[trans_temp_blk_class_RTD]	},
			{	3,		[trans_temp_blk_class_PYR]	},
			{	16,		"TC + DC U"					},
			{	17,		"RTD + R"					},
			{	18,		"TC + RTD + R + DC U"		},

			CASE 3:
			{	1,		[trans_flow_blk_class_MAGNETIC]	},
			{	2,		[trans_flow_blk_class_VORTEX]	},
			{	3,		[trans_flow_blk_class_CORIOLIS]	},
			{	4,		[trans_flow_blk_class_THERMAL]	},
			{	5,		[trans_flow_blk_class_ULTRASONIC]},
			
			CASE 4:
			{	1,		[trans_lev_blk_class_HYDRO]	},
			{	2,		[trans_lev_blk_class_ECHO]	},
			{	4,		[trans_lev_blk_class_CAPACITIVE]},
			DEFAULT:
			{	1,		[standard]					},

			CASE 6:
			{	1,		[trans_DI_blk_class_IO]		},

		}

		{	250,	[not_used] 					},
		{	251,	[none]						},
		{	252,	[unknown]					},
		{	253,	[special]					}
	}
	CLASS		TEMPORARY ;
#ifndef _DEBUG
	HANDLING	READ;
#endif
}

VARIABLE trans1_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	HELP		[blk_dd_reference_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE trans1_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	HELP		[blk_dd_rev_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ;
}

VARIABLE trans1_blk_profile
{
	LABEL		[blk_profile];
	HELP		[blk_profile_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0x4001;
		{ 0x4001,	[blk_profile_PA_COMPACT_A]	},
		{ 0x4002,	[blk_profile_PA_COMPACT_B]	},
		{ 0x4081,	[blk_profile_PA_SIMPLE_A]	},
		{ 0x4082,	[blk_profile_PA_SIMPLE_B]	}
	}
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE trans1_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	HELP		[blk_profile_rev_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	0x0200,	"2.0"	},
		{	0x025D,	"2.93"	},
		{	0x025F,	"2.95"	},
		{	0x0300,	"3.0"	}

	}
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE trans1_blk_execution_time
{
	LABEL		[blk_execution_time];
	HELP		[blk_execution_time_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE trans1_blk_highest_rel_offset
{	// Profile 3: number of parameters
	LABEL		[blk_highest_rel_offset];
	HELP		[blk_highest_rel_offset_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	CLASS		TEMPORARY ;
	HANDLING	READ;
	POST_READ_ACTIONS
	{
		DEFINITION
		{
			trans1_blk_num_parameters = trans1_blk_highest_rel_offset ;
		}
	}
}

VARIABLE trans1_blk_num_parameters
{
	LABEL		[blk_num_parameters];
	HELP		[blk_num_parameters_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}




VARIABLE trans1_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	HELP		[blk_index_view_1_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}

VARIABLE trans1_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	HELP		[blk_num_view_lists_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	CLASS		TEMPORARY ;
	HANDLING	READ;
}




