/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (1998-2003). All Rights Reserved  */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 3785             */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3                   */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*                                                              */
/*  $Revision:   1.3  $                                         */
/*  $Date:   01 Oct 1999 19:49:52  $                            */
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 06.04.1999 Kmr/E42 Profibus PA Profil 2                      */
/*                    fr > K1.33 (mit Schreibschutz-Erkennung) */
/* 16.11.1999 Kmr/E42 <Ansicht - Verlaufskurve> implementiert   */
/*                    und unit relations aktiviert              */
/* 15.06.2000 Kmr/E42 Hilfe fr KP_Y2 korrigiert.               */
/*                    In METHOD support_antrieb wird jetzt bei  */
/*                    Umschaltung auf Schwenkantrieb der Anbau  */
/*                    auf NAMUR geschaltet.                     */
/*                    In phys_valve_type LONG_DELAY_TIME statt  */
/*                    SHORT_DELAY_TIME.                         */
/* 21.09.2000 Kmr/E42 Warnmeldung fr Warmstart implementiert.  */
/*                    Warntext fr Kaltstart gendert.          */
/*                    Warntext fr Nullp.-abgl./Init. gendert. */
/*                    Defaultwerte und Bereiche gendert:       */
/*                    Nennwinkel = 90                           */
/*                    Drehw.-ber. Ende = 90                     */
/*                    Nennwinkelbereich = 0...120               */
/*                    Gew. Laufzeiten = 0...75                  */
/* 23.08.2001 Jung/E7 Anpassung an Profil 3.0.                  */
/* 06.06.2002 Kmr/E42 Anpassung an Profil 3.0:                  */
/*                    Abfrage auch des SW-Schreibschutzes bei   */
/*                    den Methoden (neben HW-Schreibschutz):    */
/*                    Jetzt mit unterschiedlichen Meldungen.    */
/*                    Benutzerdef. Kennlinie nicht implement.   */
/*                    Parameter SW-Schreibschutz nur ber       */
/*                    Menpunkt Gert-Schreibverriegelung       */
/*                    lesbar und schreibbar.                    */
/*                    MENU download_variables (Parameter die aus*/
/*                    dem Gert gelesen werden) eingefhrt.     */
/*                    Vor Schreiben von Tag mittels Methode auf */
/*                    Schreibschutz geprft (fr Download).     */
/*                    Methoden fuer Nullpunktabgleich und       */
/*                    Initialisierung vereinfacht.              */
/* 24.10.2003 Kmr/E42 mit SIMATIC Manager 5.2 (V5.2.0.0) (OEM)  */
/*                    mit PDM Version 5.2 SP1 (K5.2.1.0))       */
/*                    EB in pdf-Format jetzt in Hilfe aufrufbar.*/
/*                    func1_tag_desc und trans1_tag_desc        */
/*                    neu definiert und angezeigt.              */
/*                    Methode fr Gertezustand in der LifeList */
/*                    (method_PDM_StandardDiagnosis) eingefgt. */
/*                    func1_out_unit: in Abh. von valve_type    */
/*                    jetzt eingeschrnkte Auswahl. Post_edit   */
/*                    von valve_type gendert (support_antrieb).*/
/*                    Label der 3 TAGs gendert.                */
/*                    Parameter ..._blk_profile der 3 Blcke    */
/*                    gendert.                                 */
/*                    Parameter trans1_actual_mode jetzt        */
/*                    enumerated statt bit_enumerated.          */
/*                    Hilfe von trans1_valve_serial_number und  */
/*                    trans1_actuator_serial_number gendert.   */
/*                    Bei trans1_setp_cutoff_dec/inc Methode    */
/*                    SHORT_DELAY_TIME statt VERY_SHORT_...     */
/*                    eingefgt (Schreibfehler).                */
/*                    Neue Texte wegen quality/limit-Unter-     */
/*                    scheidung: func1_rcas_out_status_...,     */
/*                    func1_out_status_... .                    */
/* 29.10.2004 Kmr/E42 Parameter func1_setpoint_status_limit und */
/*                    func1_readback_status_limit eingefhrt.   */
/*                    (Status Limit der beiden Parameter)       */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/
MANUFACTURER         66,   /* SAMSON */
DEVICE_TYPE           2,
DEVICE_REVISION  0x0300,   /* PA-Profil 3 */
DD_REVISION           1

#define CHECK_PROFILE_REV           0x300

/* Antworten von func1_target_mode */
#define BLOCK_MODE_RCAS             0x02
#define BLOCK_MODE_AUTO             0x08
#define BLOCK_MODE_MAN              0x10
#define BLOCK_MODE_LOCAL_OVERRIDE   0x20
#define BLOCK_MODE_OUT_OF_SERVICE   0x80

/* Herstellerspezifische Defines */
#define HUBANTRIEB       0
#define SCHWENKANTRIEB   1

#define INTEGRIERT       0
#define NAMUR            1

#define AUTO             0
#define HAND             1
#define SICHER           2

#define NICHT_VORHANDEN  0
#define VORHANDEN        1
#define INDUKTIV         1
#define SOFTWARE         2

/* Codes fuer trans1_self_calibration_cmd */
#define NO_TEST             0
#define NULLP_CAL           1
#define INIT                2
#define WEGINT_RESET        7
#define RK_STOER_RESET     10
#define INIT_ERW           20
#define INIT_IMP           21
#define KALTSTART         254
#define ABBRUCH           255

/********************************************************************************/
/* Define fr Test auf HW- oder SW-Schreibschutz in den Methoden                */
/*   In der Methode mssen die Variablen HWwrProt und SWwrProt definiert sein ! */
#define CHECK_WRITE_PROTECTION                                                        \
        ReadCommand (read_phys_write_locking);       /* SW-Schreibschutz auslesen */  \
        SWwrProt = ivar_value (phys_write_locking);                                   \
        ReadCommand (read_phys_hw_write_protection); /* HW-Schreibschutz auslesen */  \
        HWwrProt = ivar_value (phys_hw_write_protection);                             \
        if (HWwrProt == 1)       /* wenn HW-Schreibschutz aktiv */                    \
        {                                                                             \
            ACKNOWLEDGE("Device is write protected (hardware write protection)."      \
                        "|de|Gert ist schreibgeschtzt (Hardware-Schreibschutz).");  \
        }                                                                             \
        if (SWwrProt == 0)       /* wenn SW-Schreibschutz aktiv */                    \
        {                                                                             \
            ACKNOWLEDGE("Device is write protected (software write protection)."      \
                        "|de|Gert ist schreibgeschtzt (Software-Schreibschutz).");  \
        }                                                                             \
        if (HWwrProt == 1 || SWwrProt == 0) /* wenn HW- ODER SW-Schreibschutz aktiv */\
        {                                                                             \
            process_abort(); /* Abbruch der Methode */                                \
        }

/********************************************************************************/
/* Define fr Standardfunktionen am Beginn einer Methode */
#define FUNCTIONS_IGNORE_XXX          \
        IGNORE_ALL_COMM_STATUS();     \
        IGNORE_ALL_DEVICE_STATUS();   \
        IGNORE_ALL_RESPONSE_CODES();  \
        IGNORE_COMM_ERROR();

/********************************************************************************/
/* Define fr Statusmeldungen BAD, UNCERTAIN und GOOD nach Profil 3 */
#define STATUS_BAD_UNCERTAIN_GOOD                       \
/* bad */                                               \
        {   0,  [bad_0]         },                      \
        {   4,  [bad_4]         },                      \
        {   8,  [bad_8]         },                      \
        {   12, [bad_12]        },                      \
        {   16, [bad_16]        },                      \
        {   20, [bad_20]        },                      \
        {   24, [bad_24]        },                      \
        {   28, [bad_28]        },                      \
/* uncertain */                                         \
        {   64, [uncertain_64]  },                      \
        {   68, [uncertain_68]  },                      \
        {   72, [uncertain_72]  },                      \
        {   76, [uncertain_76]  },                      \
        {   80, [uncertain_80]  },                      \
        {   84, [uncertain_84]  },                      \
        {   88, [uncertain_88]  },                      \
        {   92, [uncertain_92]  },                      \
        {   96, "Uncertain, Simulated value"            \
                "|de|Unsicher, Simulationswert"     },  \
        {  100, "Uncertain, Sensor calibration"         \
                "|de|Unsicher, Sensor-Kalibrierung" },  \
/* good */                                              \
        {   128,[good_128]      },                      \
        {   132,[good_132]      },                      \
        {   136,[good_136]      },                      \
        {   140,[good_140]      },                      \
        {   144,[good_144]      },                      \
        {   148,[good_148]      },                      \
        {   152,[good_152]      },                      \
        {   160,[good_160]      },                      \
        {   164, "Good, Maintenance required"           \
                 "|de|Gut, Wartung erforderlich" }

/********************************************************************************/
/* Define nur fr Statusmeldungen GOOD (CASCADE) nach Profil 3 */
/*  (zum Anhngen an STATUS_BAD_UNCERTAIN_GOOD)  */
#define STATUS_GOOD_CASCADE          \
                                 ,   \
/* good (cascade) */                 \
        {   192,[good_192]      },   \
        {   196,[good_196]      },   \
        {   200,[good_200]      },   \
        {   204,[good_204]      },   \
        {   208,[good_208]      },   \
        {   212,[good_212]      },   \
        {   216,[good_216]      },   \
        {   220,[good_220]      },   \
        {   224,[good_224]      }

/********************************************************************************/
/* Define fr Statusmeldungen BAD, UNCERTAIN und GOOD nach Profil 3 */
/* (Nur fr maskierte Stati ! Wegen Limit-Bits um 2 Bits nach rechts verschoben) */
#define STATUS_BAD_UNCERTAIN_GOOD_MASK                  \
/* bad */                                               \
        {   0,  [bad_0]         },                      \
        {   1,  [bad_4]         },                      \
        {   2,  [bad_8]         },                      \
        {   3, [bad_12]         },                      \
        {   4, [bad_16]         },                      \
        {   5, [bad_20]         },                      \
        {   6, [bad_24]         },                      \
        {   7, [bad_28]         },                      \
/* uncertain */                                         \
        {   16, [uncertain_64]  },                      \
        {   17, [uncertain_68]  },                      \
        {   18, [uncertain_72]  },                      \
        {   19, [uncertain_76]  },                      \
        {   20, [uncertain_80]  },                      \
        {   21, [uncertain_84]  },                      \
        {   22, [uncertain_88]  },                      \
        {   23, [uncertain_92]  },                      \
        {   24, "Uncertain, Simulated value"            \
                "|de|Unsicher, Simulationswert"     },  \
        {   25, "Uncertain, Sensor calibration"         \
                "|de|Unsicher, Sensor-Kalibrierung" },  \
/* good */                                              \
        {   32, [good_128]      },                      \
        {   33, [good_132]      },                      \
        {   34, [good_136]      },                      \
        {   35, [good_140]      },                      \
        {   36, [good_144]      },                      \
        {   37, [good_148]      },                      \
        {   38, [good_152]      },                      \
        {   40, [good_160]      },                      \
        {   41, "Good, Maintenance required"            \
                 "|de|Gut, Wartung erforderlich" }

/********************************************************************************/
/* Define nur fr Statusmeldungen GOOD (CASCADE) nach Profil 3 */
/*  (zum Anhngen an STATUS_BAD_UNCERTAIN_GOOD)  */
#define STATUS_GOOD_CASCADE_MASK    \
                                 ,  \
/* good (cascade) */                \
        {   48,[good_192]      },   \
        {   49,[good_196]      },   \
        {   50,[good_200]      },   \
        {   51,[good_204]      },   \
        {   52,[good_208]      },   \
        {   53,[good_212]      },   \
        {   54,[good_216]      },   \
        {   55,[good_220]      },   \
        {   56,[good_224]      }

/********************************************************************************/
/* Fr Status Quality / Limit Verarbeitung */
#define STATUS_LIMIT                                \
        { 0x00, [status_limit_OK]               },  \
        { 0x01, [status_limit_UNDERFLOW]        },  \
        { 0x02, [status_limit_OVERFLOW]         },  \
        { 0x03, [status_limit_VALUE_CONSTANT]   }

/********************************************************************************/
/* fr Methode methodOpenDeviceManual: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME "e83822en.pdf"      \
                               "|de|e83822de.pdf"  \
                               "|fr|e83822en.pdf"  \
                               "|it|e83822en.pdf"  \
                               "|es|e83822en.pdf"

/********************************************************************************/

/********************************************************************************/
/* Includes                                                                     */
/********************************************************************************/
#include "PA_Detect.inc"
#include "Diagnosis.inc"
/********************************************************************************/

/********************************************************************************/
/* defines fr units                                                            */
/********************************************************************************/
VARIABLE    dummy_byte
{
    LABEL       "";
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

/******************************************************************************/
/*    Physical Block                                                          */
/******************************************************************************/
BLOCK physical_block
{
    TYPE    PHYSICAL;
    NUMBER  1;
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_reserve
{
    LABEL       [blk_reserved];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_object
{
    LABEL       [blk_block_object];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {   1,  [blk_block_object_PHYSICAL] }
    }
    HANDLING    READ;
    HELP        [blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_parent_class
{
    LABEL       [blk_parent_class];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   2,  [phys_blk_parent_class_ACTUATOR]    }
    }
    HANDLING    READ;
    HELP        [phys_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_class
{
    LABEL       [blk_class];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        { 250,  [not_used]  }
    }
    HANDLING    READ;
    HELP        [phys_blk_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_dd_reference
{
    LABEL       [blk_dd_reference];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4);
    HANDLING    READ;
    HELP        [blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_dd_rev
{
    LABEL       [blk_dd_rev];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER(2);
    HANDLING    READ;
    HELP        [blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_profile
{
    LABEL       [blk_profile];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        {   0x4001, [blk_profile_PA_COMPACT_A] },
        {   0x4002, [blk_profile_PA_COMPACT_B] },
        {   0x4081, [blk_profile_PA_SIMPLE_A]  },
        {   0x4082, [blk_profile_PA_SIMPLE_B]  }
    }
    HANDLING    READ;
    HELP        [blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_profile_rev
{
    LABEL       [blk_profile_rev];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        {   768,    "3.0"   }
    }
    HANDLING    READ;
    HELP        [blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_execution_time
{
    LABEL       [blk_execution_time];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER(1);
    HANDLING    READ;
    HELP        [blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE blk_num_parameters
{
    LABEL       [ blk_num_parameters];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_num_parameters_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_index_view_1
{
    LABEL       [blk_index_view_1];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_num_view_lists
{
    LABEL       [blk_num_view_lists];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_num_view_lists_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_st_rev
{
    LABEL       [st_rev];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_tag_desc
{
/*    LABEL       [tag_desc];*/
    LABEL       "TAG (Physical block)" "|de|TAG (Physical Block)";
    CLASS       CONTAINED;
    TYPE        ASCII (32);
    HANDLING    READ & WRITE;
    PRE_WRITE_ACTIONS
    {
        check_write_protection_before_write   /* Schreibschutzprfung fr Download */
    }
    HELP        [tag_desc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_strategy
{
    LABEL       [strategy];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ & WRITE;
    HELP        [strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_alert_key
{
    LABEL       [alert_key];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
    HELP        [alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_target_mode
{
    LABEL       [target_mode];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO] }
    }
    HANDLING    READ & WRITE;
    HELP        [target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actual_mode
{
    LABEL       [actual_mode];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO] }
    }
    HANDLING    READ;
    HELP        [actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_permitted_mode
{
    LABEL       [permitted_mode];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        { 0x08, [mode_AUTO] }
    }
    HANDLING    READ;
    HELP        [permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_normal_mode
{
    LABEL       [normal_mode];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO] }
    }
    HANDLING    READ;
    HELP        [normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_current_state_alarm_sum
{
    LABEL       [current_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_unacknowledged_state_alarm_sum
{
    LABEL       [unacknowledged_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_unreported_state_alarm_sum
{
    LABEL       [unreported_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_disabled_state_alarm_sum
{
    LABEL       [disabled_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [disabled_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_software_rev
{
    LABEL       [phys_software_revision];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ;
    HELP        [phys_software_revision_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_hardware_rev
{
    LABEL       [phys_hardware_revision];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ;
    HELP        [phys_hardware_revision_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_man_id
{
    LABEL       [phys_device_man_id];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
       DEFAULT_VALUE    66;
      { 1,      [Acromag]                       },
      { 2,      [Allen_Bradley]                 },
      { 3,      [Ametek]                        },
      { 4,      [Analog_Devices]                },
      { 5,      [Bailey]                        },
      { 6,      [Beckman]                       },
      { 7,      [Bell_Microsensor]              },
      { 8,      [Bourns]                        },
      { 9,      [Bristol_Babcock]               },
      { 10,     [Brooks_Instrument]             },
      { 11,     [Chessell]                      },
      { 12,     [Combustion_Engineering]        },
      { 13,     [Daniel_Industries]             },
      { 14,     [Delta]                         },
      { 15,     [Dieterich_Standard]            },
      { 16,     [Dohrmann]                      },
      { 17,     [Endress_and_Hauser]            },
      { 18,     [Fischer_and_Porter]            },
      { 19,     [Fisher_Controls]               },
      { 20,     [Foxboro]                       },
      { 21,     [Fuji]                          },
      { 22,     [Hartmann_and_Braun]            },
      { 23,     [Honeywell]                     },
      { 24,     [ITT_Barton]                    },
      { 25,     [KayRay_Sensall]                },
      { 26,     [Kent]                          },
      { 27,     [Leeds_and_Northrup]            },
      { 28,     [Leslie]                        },
      { 29,     [M_System_Co]                   },
      { 30,     [Measurex]                      },
      { 31,     [Micro_Motion]                  },
      { 32,     [Moore_Industries]              },
      { 33,     [Moore_Products]                },
      { 34,     [Ohkura_Electric]               },
      { 35,     [Paine]                         },
      { 36,     [Rochester_Instrument_Systems]  },
      { 37,     [Ronan]                         },
      { 38,     [Rosemount]                     },
      { 39,     [Peek_Measurement]              },
      { 40,     [Schlumberger]                  },
      { 41,     [Sensall]                       },
      { 42,     [Siemens]                       },
      { 43,     [Camille_Bauer]                 },
      { 44,     [Toshiba]                       },
      { 45,     [Transmation]                   },
      { 46,     [Rosemount_Analytical]          },
      { 47,     [Valmet]                        },
      { 48,     [Valtek]                        },
      { 49,     [Varec]                         },
      { 50,     [Viatran]                       },
      { 51,     [Weed]                          },
      { 52,     [Westinghouse]                  },
      { 53,     [Xomox]                         },
      { 54,     [Yamatake]                      },
      { 55,     [Yokogawa]                      },
      { 56,     [Nuovo_Pignone]                 },
      { 57,     [Promac]                        },
      { 58,     [Exac_Corporation]              },
      { 59,     [KDG_Mobrey]                    },
      { 60,     [Acrom_Control_System]          },
      { 61,     [Princo]                        },
      { 62,     [Smar]                          },
      { 63,     [Eckardt]                       },
      { 64,     [Measurement_Technology]        },
      { 65,     [Applied_System_Technologies]   },
      { 66,     [Samson]                        },
      { 67,     [Sparling_Instruments]          },
      { 68,     [Fireye]                        },
      { 69,     [Krohne]                        },
      { 70,     [Betz_Equipment]                },
      { 71,     [Druck]                         },
      { 72,     [SOR]                           },
      { 73,     [Elcon_Instruments]             },
      { 74,     [EMCO]                          },
      { 75,     [Termiflex]                     },
      { 76,     [VAF_Instruments]               },
      { 77,     [Westlock_Controls]             },
      { 78,     [Drexelbrook]                   },
      { 80,     [K_TEK]                         },
      { 81,     [Flowdata]                      },
      { 82,     [Draeger]                       },
      { 83,     [Raytek]                        },
      { 84,     [Meridian_Instruments]          },
      { 85,     [BTG]                           },
      { 86,     [Magnetrol]                     },
      { 87,     [Neles_Jamesbury]               },
      { 88,     [Milltronics]                   },
      { 89,     [HELIOS]                        },
      { 90,     [Anderson_Instrument_Company]   },
      { 91,     [INOR]                          },
      { 92,     [ROBERTSHAW]                    },
      { 93,     [PEPPERL_FUCHS]                 },
      { 94,     [ACCUTECH]                      },
      { 95,     [Flow_Measurement]              },
      { 96,     [KAMSTRUP]                      },
      { 97,     [Knick]                         },
      { 98,     [VEGA]                          },
      { 99,     [MTS_SYS_CORPS_SENSORS]         },
      { 100,    [Oval]                          },
      { 101,    [Masoneilan_DRESSER]            },
      { 102,    [Besta]                         },
      { 103,    [Ohmart]                        },
      { 250,    [not_used]                      },
      { 251,    [none]                          },
      { 252,    [unknown]                       },
      { 253,    [special]                       }
    }
    HANDLING    READ;
    HELP        [phys_device_man_id_help];
}

#define UNIT_LIST                           \
        { 1000, [unit_1000],    [unit_1000_help]    },  \
        { 1001, [unit_1001],    [unit_1001_help]    },  \
        { 1002, [unit_1002],    [unit_1002_help]    },  \
        { 1003, [unit_1003],    [unit_1003_help]    },  \
        { 1004, [unit_1004],    [unit_1004_help]    },  \
        { 1005, [unit_1005],    [unit_1005_help]    },  \
        { 1006, [unit_1006],    [unit_1006_help]    },  \
        { 1007, [unit_1007],    [unit_1007_help]    },  \
        { 1008, [unit_1008],    [unit_1008_help]    },  \
        { 1009, [unit_1009],    [unit_1009_help]    },  \
        { 1010, [unit_1010],    [unit_1010_help]    },  \
        { 1011, [unit_1011],    [unit_1011_help]    },  \
        { 1012, [unit_1012],    [unit_1012_help]    },  \
        { 1013, [unit_1013],    [unit_1013_help]    },  \
        { 1014, [unit_1014],    [unit_1014_help]    },  \
        { 1015, [unit_1015],    [unit_1015_help]    },  \
        { 1016, [unit_1016],    [unit_1016_help]    },  \
        { 1017, [unit_1017],    [unit_1017_help]    },  \
        { 1018, [unit_1018],    [unit_1018_help]    },  \
        { 1019, [unit_1019],    [unit_1019_help]    },  \
        { 1020, [unit_1020],    [unit_1020_help]    },  \
        { 1021, [unit_1021],    [unit_1021_help]    },  \
        { 1022, [unit_1022],    [unit_1022_help]    },  \
        { 1023, [unit_1023],    [unit_1023_help]    },  \
        { 1024, [unit_1024],    [unit_1024_help]    },  \
        { 1025, [unit_1025],    [unit_1025_help]    },  \
        { 1026, [unit_1026],    [unit_1026_help]    },  \
        { 1027, [unit_1027],    [unit_1027_help]    },  \
        { 1028, [unit_1028],    [unit_1028_help]    },  \
        { 1029, [unit_1029],    [unit_1029_help]    },  \
        { 1030, [unit_1030],    [unit_1030_help]    },  \
        { 1031, [unit_1031],    [unit_1031_help]    },  \
        { 1032, [unit_1032],    [unit_1032_help]    },  \
        { 1033, [unit_1033],    [unit_1033_help]    },  \
        { 1034, [unit_1034],    [unit_1034_help]    },  \
        { 1035, [unit_1035],    [unit_1035_help]    },  \
        { 1036, [unit_1036],    [unit_1036_help]    },  \
        { 1037, [unit_1037],    [unit_1037_help]    },  \
        { 1038, [unit_1038],    [unit_1038_help]    },  \
        { 1039, [unit_1039],    [unit_1039_help]    },  \
        { 1040, [unit_1040],    [unit_1040_help]    },  \
        { 1041, [unit_1041],    [unit_1041_help]    },  \
        { 1042, [unit_1042],    [unit_1042_help]    },  \
        { 1043, [unit_1043],    [unit_1043_help]    },  \
        { 1044, [unit_1044],    [unit_1044_help]    },  \
        { 1045, [unit_1045],    [unit_1045_help]    },  \
        { 1046, [unit_1046],    [unit_1046_help]    },  \
        { 1047, [unit_1047],    [unit_1047_help]    },  \
        { 1048, [unit_1048],    [unit_1048_help]    },  \
        { 1049, [unit_1049],    [unit_1049_help]    },  \
        { 1050, [unit_1050],    [unit_1050_help]    },  \
        { 1051, [unit_1051],    [unit_1051_help]    },  \
        { 1052, [unit_1052],    [unit_1052_help]    },  \
        { 1053, [unit_1053],    [unit_1053_help]    },  \
        { 1054, [unit_1054],    [unit_1054_help]    },  \
        { 1055, [unit_1055],    [unit_1055_help]    },  \
        { 1056, [unit_1056],    [unit_1056_help]    },  \
        { 1057, [unit_1057],    [unit_1057_help]    },  \
        { 1058, [unit_1058],    [unit_1058_help]    },  \
        { 1059, [unit_1059],    [unit_1059_help]    },  \
        { 1060, [unit_1060],    [unit_1060_help]    },  \
        { 1061, [unit_1061],    [unit_1061_help]    },  \
        { 1062, [unit_1062],    [unit_1062_help]    },  \
        { 1063, [unit_1063],    [unit_1063_help]    },  \
        { 1064, [unit_1064],    [unit_1064_help]    },  \
        { 1065, [unit_1065],    [unit_1065_help]    },  \
        { 1066, [unit_1066],    [unit_1066_help]    },  \
        { 1067, [unit_1067],    [unit_1067_help]    },  \
        { 1068, [unit_1068],    [unit_1068_help]    },  \
        { 1069, [unit_1069],    [unit_1069_help]    },  \
        { 1070, [unit_1070],    [unit_1070_help]    },  \
        { 1071, [unit_1071],    [unit_1071_help]    },  \
        { 1072, [unit_1072],    [unit_1072_help]    },  \
        { 1073, [unit_1073],    [unit_1073_help]    },  \
        { 1074, [unit_1074],    [unit_1074_help]    },  \
        { 1075, [unit_1075],    [unit_1075_help]    },  \
        { 1076, [unit_1076],    [unit_1076_help]    },  \
        { 1077, [unit_1077],    [unit_1077_help]    },  \
        { 1078, [unit_1078],    [unit_1078_help]    },  \
        { 1079, [unit_1079],    [unit_1079_help]    },  \
        { 1080, [unit_1080],    [unit_1080_help]    },  \
        { 1081, [unit_1081],    [unit_1081_help]    },  \
        { 1082, [unit_1082],    [unit_1082_help]    },  \
        { 1083, [unit_1083],    [unit_1083_help]    },  \
        { 1084, [unit_1084],    [unit_1084_help]    },  \
        { 1085, [unit_1085],    [unit_1085_help]    },  \
        { 1086, [unit_1086],    [unit_1086_help]    },  \
        { 1087, [unit_1087],    [unit_1087_help]    },  \
        { 1088, [unit_1088],    [unit_1088_help]    },  \
        { 1089, [unit_1089],    [unit_1089_help]    },  \
        { 1090, [unit_1090],    [unit_1090_help]    },  \
        { 1091, [unit_1091],    [unit_1091_help]    },  \
        { 1092, [unit_1092],    [unit_1092_help]    },  \
        { 1093, [unit_1093],    [unit_1093_help]    },  \
        { 1094, [unit_1094],    [unit_1094_help]    },  \
        { 1095, [unit_1095],    [unit_1095_help]    },  \
        { 1096, [unit_1096],    [unit_1096_help]    },  \
        { 1097, [unit_1097],    [unit_1097_help]    },  \
        { 1098, [unit_1098],    [unit_1098_help]    },  \
        { 1099, [unit_1099],    [unit_1099_help]    },  \
        { 1100, [unit_1100],    [unit_1100_help]    },  \
        { 1101, [unit_1101],    [unit_1101_help]    },  \
        { 1102, [unit_1102],    [unit_1102_help]    },  \
        { 1103, [unit_1103],    [unit_1103_help]    },  \
        { 1104, [unit_1104],    [unit_1104_help]    },  \
        { 1105, [unit_1105],    [unit_1105_help]    },  \
        { 1106, [unit_1106],    [unit_1106_help]    },  \
        { 1107, [unit_1107],    [unit_1107_help]    },  \
        { 1108, [unit_1108],    [unit_1108_help]    },  \
        { 1109, [unit_1109],    [unit_1109_help]    },  \
        { 1110, [unit_1110],    [unit_1110_help]    },  \
        { 1111, [unit_1111],    [unit_1111_help]    },  \
        { 1112, [unit_1112],    [unit_1112_help]    },  \
        { 1113, [unit_1113],    [unit_1113_help]    },  \
        { 1114, [unit_1114],    [unit_1114_help]    },  \
        { 1115, [unit_1115],    [unit_1115_help]    },  \
        { 1116, [unit_1116],    [unit_1116_help]    },  \
        { 1117, [unit_1117],    [unit_1117_help]    },  \
        { 1118, [unit_1118],    [unit_1118_help]    },  \
        { 1119, [unit_1119],    [unit_1119_help]    },  \
        { 1120, [unit_1120],    [unit_1120_help]    },  \
        { 1121, [unit_1121],    [unit_1121_help]    },  \
        { 1122, [unit_1122],    [unit_1122_help]    },  \
        { 1123, [unit_1123],    [unit_1123_help]    },  \
        { 1124, [unit_1124],    [unit_1124_help]    },  \
        { 1125, [unit_1125],    [unit_1125_help]    },  \
        { 1126, [unit_1126],    [unit_1126_help]    },  \
        { 1127, [unit_1127],    [unit_1127_help]    },  \
        { 1128, [unit_1128],    [unit_1128_help]    },  \
        { 1129, [unit_1129],    [unit_1129_help]    },  \
        { 1130, [unit_1130],    [unit_1130_help]    },  \
        { 1131, [unit_1131],    [unit_1131_help]    },  \
        { 1132, [unit_1132],    [unit_1132_help]    },  \
        { 1133, [unit_1133],    [unit_1133_help]    },  \
        { 1134, [unit_1134],    [unit_1134_help]    },  \
        { 1135, [unit_1135],    [unit_1135_help]    },  \
        { 1136, [unit_1136],    [unit_1136_help]    },  \
        { 1137, [unit_1137],    [unit_1137_help]    },  \
        { 1138, [unit_1138],    [unit_1138_help]    },  \
        { 1139, [unit_1139],    [unit_1139_help]    },  \
        { 1140, [unit_1140],    [unit_1140_help]    },  \
        { 1141, [unit_1141],    [unit_1141_help]    },  \
        { 1142, [unit_1142],    [unit_1142_help]    },  \
        { 1143, [unit_1143],    [unit_1143_help]    },  \
        { 1144, [unit_1144],    [unit_1144_help]    },  \
        { 1145, [unit_1145],    [unit_1145_help]    },  \
        { 1146, [unit_1146],    [unit_1146_help]    },  \
        { 1147, [unit_1147],    [unit_1147_help]    },  \
        { 1148, [unit_1148],    [unit_1148_help]    },  \
        { 1149, [unit_1149],    [unit_1149_help]    },  \
        { 1150, [unit_1150],    [unit_1150_help]    },  \
        { 1151, [unit_1151],    [unit_1151_help]    },  \
        { 1152, [unit_1152],    [unit_1152_help]    },  \
        { 1153, [unit_1153],    [unit_1153_help]    },  \
        { 1154, [unit_1154],    [unit_1154_help]    },  \
        { 1155, [unit_1155],    [unit_1155_help]    },  \
        { 1156, [unit_1156],    [unit_1156_help]    },  \
        { 1157, [unit_1157],    [unit_1157_help]    },  \
        { 1158, [unit_1158],    [unit_1158_help]    },  \
        { 1159, [unit_1159],    [unit_1159_help]    },  \
        { 1160, [unit_1160],    [unit_1160_help]    },  \
        { 1161, [unit_1161],    [unit_1161_help]    },  \
        { 1162, [unit_1162],    [unit_1162_help]    },  \
        { 1163, [unit_1163],    [unit_1163_help]    },  \
        { 1164, [unit_1164],    [unit_1164_help]    },  \
        { 1165, [unit_1165],    [unit_1165_help]    },  \
        { 1166, [unit_1166],    [unit_1166_help]    },  \
        { 1167, [unit_1167],    [unit_1167_help]    },  \
        { 1168, [unit_1168],    [unit_1168_help]    },  \
        { 1169, [unit_1169],    [unit_1169_help]    },  \
        { 1170, [unit_1170],    [unit_1170_help]    },  \
        { 1171, [unit_1171],    [unit_1171_help]    },  \
        { 1172, [unit_1172],    [unit_1172_help]    },  \
        { 1173, [unit_1173],    [unit_1173_help]    },  \
        { 1174, [unit_1174],    [unit_1174_help]    },  \
        { 1175, [unit_1175],    [unit_1175_help]    },  \
        { 1176, [unit_1176],    [unit_1176_help]    },  \
        { 1177, [unit_1177],    [unit_1177_help]    },  \
        { 1178, [unit_1178],    [unit_1178_help]    },  \
        { 1179, [unit_1179],    [unit_1179_help]    },  \
        { 1180, [unit_1180],    [unit_1180_help]    },  \
        { 1181, [unit_1181],    [unit_1181_help]    },  \
        { 1182, [unit_1182],    [unit_1182_help]    },  \
        { 1183, [unit_1183],    [unit_1183_help]    },  \
        { 1184, [unit_1184],    [unit_1184_help]    },  \
        { 1185, [unit_1185],    [unit_1185_help]    },  \
        { 1186, [unit_1186],    [unit_1186_help]    },  \
        { 1187, [unit_1187],    [unit_1187_help]    },  \
        { 1188, [unit_1188],    [unit_1188_help]    },  \
        { 1189, [unit_1189],    [unit_1189_help]    },  \
        { 1190, [unit_1190],    [unit_1190_help]    },  \
        { 1191, [unit_1191],    [unit_1191_help]    },  \
        { 1192, [unit_1192],    [unit_1192_help]    },  \
        { 1193, [unit_1193],    [unit_1193_help]    },  \
        { 1194, [unit_1194],    [unit_1194_help]    },  \
        { 1195, [unit_1195],    [unit_1195_help]    },  \
        { 1196, [unit_1196],    [unit_1196_help]    },  \
        { 1197, [unit_1197],    [unit_1197_help]    },  \
        { 1198, [unit_1198],    [unit_1198_help]    },  \
        { 1199, [unit_1199],    [unit_1199_help]    },  \
        { 1200, [unit_1200],    [unit_1200_help]    },  \
        { 1201, [unit_1201],    [unit_1201_help]    },  \
        { 1202, [unit_1202],    [unit_1202_help]    },  \
        { 1203, [unit_1203],    [unit_1203_help]    },  \
        { 1204, [unit_1204],    [unit_1204_help]    },  \
        { 1205, [unit_1205],    [unit_1205_help]    },  \
        { 1206, [unit_1206],    [unit_1206_help]    },  \
        { 1207, [unit_1207],    [unit_1207_help]    },  \
        { 1208, [unit_1208],    [unit_1208_help]    },  \
        { 1209, [unit_1209],    [unit_1209_help]    },  \
        { 1210, [unit_1210],    [unit_1210_help]    },  \
        { 1211, [unit_1211],    [unit_1211_help]    },  \
        { 1212, [unit_1212],    [unit_1212_help]    },  \
        { 1213, [unit_1213],    [unit_1213_help]    },  \
        { 1214, [unit_1214],    [unit_1214_help]    },  \
        { 1215, [unit_1215],    [unit_1215_help]    },  \
        { 1216, [unit_1216],    [unit_1216_help]    },  \
        { 1217, [unit_1217],    [unit_1217_help]    },  \
        { 1218, [unit_1218],    [unit_1218_help]    },  \
        { 1219, [unit_1219],    [unit_1219_help]    },  \
        { 1220, [unit_1220],    [unit_1220_help]    },  \
        { 1221, [unit_1221],    [unit_1221_help]    },  \
        { 1222, [unit_1222],    [unit_1222_help]    },  \
        { 1223, [unit_1223],    [unit_1223_help]    },  \
        { 1224, [unit_1224],    [unit_1224_help]    },  \
        { 1225, [unit_1225],    [unit_1225_help]    },  \
        { 1226, [unit_1226],    [unit_1226_help]    },  \
        { 1227, [unit_1227],    [unit_1227_help]    },  \
        { 1228, [unit_1228],    [unit_1228_help]    },  \
        { 1229, [unit_1229],    [unit_1229_help]    },  \
        { 1230, [unit_1230],    [unit_1230_help]    },  \
        { 1231, [unit_1231],    [unit_1231_help]    },  \
        { 1232, [unit_1232],    [unit_1232_help]    },  \
        { 1233, [unit_1233],    [unit_1233_help]    },  \
        { 1234, [unit_1234],    [unit_1234_help]    },  \
        { 1235, [unit_1235],    [unit_1235_help]    },  \
        { 1236, [unit_1236],    [unit_1236_help]    },  \
        { 1237, [unit_1237],    [unit_1237_help]    },  \
        { 1238, [unit_1238],    [unit_1238_help]    },  \
        { 1239, [unit_1239],    [unit_1239_help]    },  \
        { 1240, [unit_1240],    [unit_1240_help]    },  \
        { 1241, [unit_1241],    [unit_1241_help]    },  \
        { 1242, [unit_1242],    [unit_1242_help]    },  \
        { 1243, [unit_1243],    [unit_1243_help]    },  \
        { 1244, [unit_1244],    [unit_1244_help]    },  \
        { 1245, [unit_1245],    [unit_1245_help]    },  \
        { 1246, [unit_1246],    [unit_1246_help]    },  \
        { 1247, [unit_1247],    [unit_1247_help]    },  \
        { 1248, [unit_1248],    [unit_1248_help]    },  \
        { 1249, [unit_1249],    [unit_1249_help]    },  \
        { 1250, [unit_1250],    [unit_1250_help]    },  \
        { 1251, [unit_1251],    [unit_1251_help]    },  \
        { 1252, [unit_1252],    [unit_1252_help]    },  \
        { 1253, [unit_1253],    [unit_1253_help]    },  \
        { 1254, [unit_1254],    [unit_1254_help]    },  \
        { 1255, [unit_1255],    [unit_1255_help]    },  \
        { 1256, [unit_1256],    [unit_1256_help]    },  \
        { 1257, [unit_1257],    [unit_1257_help]    },  \
        { 1258, [unit_1258],    [unit_1258_help]    },  \
        { 1259, [unit_1259],    [unit_1259_help]    },  \
        { 1260, [unit_1260],    [unit_1260_help]    },  \
        { 1261, [unit_1261],    [unit_1261_help]    },  \
        { 1262, [unit_1262],    [unit_1262_help]    },  \
        { 1263, [unit_1263],    [unit_1263_help]    },  \
        { 1264, [unit_1264],    [unit_1264_help]    },  \
        { 1265, [unit_1265],    [unit_1265_help]    },  \
        { 1266, [unit_1266],    [unit_1266_help]    },  \
        { 1267, [unit_1267],    [unit_1267_help]    },  \
        { 1268, [unit_1268],    [unit_1268_help]    },  \
        { 1269, [unit_1269],    [unit_1269_help]    },  \
        { 1270, [unit_1270],    [unit_1270_help]    },  \
        { 1271, [unit_1271],    [unit_1271_help]    },  \
        { 1272, [unit_1272],    [unit_1272_help]    },  \
        { 1273, [unit_1273],    [unit_1273_help]    },  \
        { 1274, [unit_1274],    [unit_1274_help]    },  \
        { 1275, [unit_1275],    [unit_1275_help]    },  \
        { 1276, [unit_1276],    [unit_1276_help]    },  \
        { 1277, [unit_1277],    [unit_1277_help]    },  \
        { 1278, [unit_1278],    [unit_1278_help]    },  \
        { 1279, [unit_1279],    [unit_1279_help]    },  \
        { 1280, [unit_1280],    [unit_1280_help]    },  \
        { 1281, [unit_1281],    [unit_1281_help]    },  \
        { 1282, [unit_1282],    [unit_1282_help]    },  \
        { 1283, [unit_1283],    [unit_1283_help]    },  \
        { 1284, [unit_1284],    [unit_1284_help]    },  \
        { 1285, [unit_1285],    [unit_1285_help]    },  \
        { 1286, [unit_1286],    [unit_1286_help]    },  \
        { 1287, [unit_1287],    [unit_1287_help]    },  \
        { 1288, [unit_1288],    [unit_1288_help]    },  \
        { 1289, [unit_1289],    [unit_1289_help]    },  \
        { 1290, [unit_1290],    [unit_1290_help]    },  \
        { 1291, [unit_1291],    [unit_1291_help]    },  \
        { 1292, [unit_1292],    [unit_1292_help]    },  \
        { 1293, [unit_1293],    [unit_1293_help]    },  \
        { 1294, [unit_1294],    [unit_1294_help]    },  \
        { 1295, [unit_1295],    [unit_1295_help]    },  \
        { 1296, [unit_1296],    [unit_1296_help]    },  \
        { 1297, [unit_1297],    [unit_1297_help]    },  \
        { 1298, [unit_1298],    [unit_1298_help]    },  \
        { 1299, [unit_1299],    [unit_1299_help]    },  \
        { 1300, [unit_1300],    [unit_1300_help]    },  \
        { 1301, [unit_1301],    [unit_1301_help]    },  \
        { 1302, [unit_1302],    [unit_1302_help]    },  \
        { 1303, [unit_1303],    [unit_1303_help]    },  \
        { 1304, [unit_1304],    [unit_1304_help]    },  \
        { 1305, [unit_1305],    [unit_1305_help]    },  \
        { 1306, [unit_1306],    [unit_1306_help]    },  \
        { 1307, [unit_1307],    [unit_1307_help]    },  \
        { 1308, [unit_1308],    [unit_1308_help]    },  \
        { 1309, [unit_1309],    [unit_1309_help]    },  \
        { 1310, [unit_1310],    [unit_1310_help]    },  \
        { 1311, [unit_1311],    [unit_1311_help]    },  \
        { 1312, [unit_1312],    [unit_1312_help]    },  \
        { 1313, [unit_1313],    [unit_1313_help]    },  \
        { 1314, [unit_1314],    [unit_1314_help]    },  \
        { 1315, [unit_1315],    [unit_1315_help]    },  \
        { 1316, [unit_1316],    [unit_1316_help]    },  \
        { 1317, [unit_1317],    [unit_1317_help]    },  \
        { 1318, [unit_1318],    [unit_1318_help]    },  \
        { 1319, [unit_1319],    [unit_1319_help]    },  \
        { 1320, [unit_1320],    [unit_1320_help]    },  \
        { 1321, [unit_1321],    [unit_1321_help]    },  \
        { 1322, [unit_1322],    [unit_1322_help]    },  \
        { 1323, [unit_1323],    [unit_1323_help]    },  \
        { 1324, [unit_1324],    [unit_1324_help]    },  \
        { 1325, [unit_1325],    [unit_1325_help]    },  \
        { 1326, [unit_1326],    [unit_1326_help]    },  \
        { 1327, [unit_1327],    [unit_1327_help]    },  \
        { 1328, [unit_1328],    [unit_1328_help]    },  \
        { 1329, [unit_1329],    [unit_1329_help]    },  \
        { 1330, [unit_1330],    [unit_1330_help]    },  \
        { 1331, [unit_1331],    [unit_1331_help]    },  \
        { 1332, [unit_1332],    [unit_1332_help]    },  \
        { 1333, [unit_1333],    [unit_1333_help]    },  \
        { 1334, [unit_1334],    [unit_1334_help]    },  \
        { 1335, [unit_1335],    [unit_1335_help]    },  \
        { 1336, [unit_1336],    [unit_1336_help]    },  \
        { 1337, [unit_1337],    [unit_1337_help]    },  \
        { 1338, [unit_1338],    [unit_1338_help]    },  \
        { 1339, [unit_1339],    [unit_1339_help]    },  \
        { 1340, [unit_1340],    [unit_1340_help]    },  \
        { 1341, [unit_1341],    [unit_1341_help]    },  \
        { 1342, [unit_1342],    [unit_1342_help]    },  \
        { 1343, [unit_1343],    [unit_1343_help]    },  \
        { 1344, [unit_1344],    [unit_1344_help]    },  \
        { 1345, [unit_1345],    [unit_1345_help]    },  \
        { 1346, [unit_1346],    [unit_1346_help]    },  \
        { 1347, [unit_1347],    [unit_1347_help]    },  \
        { 1348, [unit_1348],    [unit_1348_help]    },  \
        { 1349, [unit_1349],    [unit_1349_help]    },  \
        { 1350, [unit_1350],    [unit_1350_help]    },  \
        { 1351, [unit_1351],    [unit_1351_help]    },  \
        { 1352, [unit_1352],    [unit_1352_help]    },  \
        { 1353, [unit_1353],    [unit_1353_help]    },  \
        { 1354, [unit_1354],    [unit_1354_help]    },  \
        { 1355, [unit_1355],    [unit_1355_help]    },  \
        { 1356, [unit_1356],    [unit_1356_help]    },  \
        { 1357, [unit_1357],    [unit_1357_help]    },  \
        { 1358, [unit_1358],    [unit_1358_help]    },  \
        { 1359, [unit_1359],    [unit_1359_help]    },  \
        { 1360, [unit_1360],    [unit_1360_help]    },  \
        { 1361, [unit_1361],    [unit_1361_help]    },  \
        { 1362, [unit_1362],    [unit_1362_help]    },  \
        { 1363, [unit_1363],    [unit_1363_help]    },  \
        { 1364, [unit_1364],    [unit_1364_help]    },  \
        { 1365, [unit_1365],    [unit_1365_help]    },  \
        { 1366, [unit_1366],    [unit_1366_help]    },  \
        { 1367, [unit_1367],    [unit_1367_help]    },  \
        { 1368, [unit_1368],    [unit_1368_help]    },  \
        { 1369, [unit_1369],    [unit_1369_help]    },  \
        { 1370, [unit_1370],    [unit_1370_help]    },  \
        { 1371, [unit_1371],    [unit_1371_help]    },  \
        { 1372, [unit_1372],    [unit_1372_help]    },  \
        { 1373, [unit_1373],    [unit_1373_help]    },  \
        { 1374, [unit_1374],    [unit_1374_help]    },  \
        { 1375, [unit_1375],    [unit_1375_help]    },  \
        { 1376, [unit_1376],    [unit_1376_help]    },  \
        { 1377, [unit_1377],    [unit_1377_help]    },  \
        { 1378, [unit_1378],    [unit_1378_help]    },  \
        { 1379, [unit_1379],    [unit_1379_help]    },  \
        { 1380, [unit_1380],    [unit_1380_help]    },  \
        { 1381, [unit_1381],    [unit_1381_help]    },  \
        { 1382, [unit_1382],    [unit_1382_help]    },  \
        { 1383, [unit_1383],    [unit_1383_help]    },  \
        { 1384, [unit_1384],    [unit_1384_help]    },  \
        { 1385, [unit_1385],    [unit_1385_help]    },  \
        { 1386, [unit_1386],    [unit_1386_help]    },  \
        { 1387, [unit_1387],    [unit_1387_help]    },  \
        { 1388, [unit_1388],    [unit_1388_help]    },  \
        { 1389, [unit_1389],    [unit_1389_help]    },  \
        { 1390, [unit_1390],    [unit_1390_help]    },  \
        { 1391, [unit_1391],    [unit_1391_help]    },  \
        { 1392, [unit_1392],    [unit_1392_help]    },  \
        { 1393, [unit_1393],    [unit_1393_help]    },  \
        { 1394, [unit_1394],    [unit_1394_help]    },  \
        { 1395, [unit_1395],    [unit_1395_help]    },  \
        { 1396, [unit_1396],    [unit_1396_help]    },  \
        { 1397, [unit_1397],    [unit_1397_help]    },  \
        { 1398, [unit_1398],    [unit_1398_help]    },  \
        { 1399, [unit_1399],    [unit_1399_help]    },  \
        { 1400, [unit_1400],    [unit_1400_help]    },  \
        { 1401, [unit_1401],    [unit_1401_help]    },  \
        { 1402, [unit_1402],    [unit_1402_help]    },  \
        { 1403, [unit_1403],    [unit_1403_help]    },  \
        { 1404, [unit_1404],    [unit_1404_help]    },  \
        { 1405, [unit_1405],    [unit_1405_help]    },  \
        { 1406, [unit_1406],    [unit_1406_help]    },  \
        { 1407, [unit_1407],    [unit_1407_help]    },  \
        { 1408, [unit_1408],    [unit_1408_help]    },  \
        { 1409, [unit_1409],    [unit_1409_help]    },  \
        { 1410, [unit_1410],    [unit_1410_help]    },  \
        { 1411, [unit_1411],    [unit_1411_help]    },  \
        { 1412, [unit_1412],    [unit_1412_help]    },  \
        { 1413, [unit_1413],    [unit_1413_help]    },  \
        { 1414, [unit_1414],    [unit_1414_help]    },  \
        { 1415, [unit_1415],    [unit_1415_help]    },  \
        { 1416, [unit_1416],    [unit_1416_help]    },  \
        { 1417, [unit_1417],    [unit_1417_help]    },  \
        { 1418, [unit_1418],    [unit_1418_help]    },  \
        { 1419, [unit_1419],    [unit_1419_help]    },  \
        { 1420, [unit_1420],    [unit_1420_help]    },  \
        { 1421, [unit_1421],    [unit_1421_help]    },  \
        { 1422, [unit_1422],    [unit_1422_help]    },  \
        { 1423, [unit_1423],    [unit_1423_help]    },  \
        { 1424, [unit_1424],    [unit_1424_help]    },  \
        { 1425, [unit_1425],    [unit_1425_help]    },  \
        { 1426, [unit_1426],    [unit_1426_help]    },  \
        { 1427, [unit_1427],    [unit_1427_help]    },  \
        { 1428, [unit_1428],    [unit_1428_help]    },  \
        { 1429, [unit_1429],    [unit_1429_help]    },  \
        { 1430, [unit_1430],    [unit_1430_help]    },  \
        { 1431, [unit_1431],    [unit_1431_help]    },  \
        { 1432, [unit_1432],    [unit_1432_help]    },  \
        { 1433, [unit_1433],    [unit_1433_help]    },  \
        { 1434, [unit_1434],    [unit_1434_help]    },  \
        { 1435, [unit_1435],    [unit_1435_help]    },  \
        { 1436, [unit_1436],    [unit_1436_help]    },  \
        { 1437, [unit_1437],    [unit_1437_help]    },  \
        { 1438, [unit_1438],    [unit_1438_help]    },  \
        { 1439, [unit_1439],    [unit_1439_help]    },  \
        { 1440, [unit_1440],    [unit_1440_help]    },  \
        { 1441, [unit_1441],    [unit_1441_help]    },  \
        { 1442, [unit_1442],    [unit_1442_help]    },  \
        { 1443, [unit_1443],    [unit_1443_help]    },  \
        { 1444, [unit_1444],    [unit_1444_help]    },  \
        { 1445, [unit_1445],    [unit_1445_help]    },  \
        { 1446, [unit_1446],    [unit_1446_help]    },  \
        { 1447, [unit_1447],    [unit_1447_help]    },  \
        { 1448, [unit_1448],    [unit_1448_help]    },  \
        { 1449, [unit_1449],    [unit_1449_help]    },  \
        { 1450, [unit_1450],    [unit_1450_help]    },  \
        { 1451, [unit_1451],    [unit_1451_help]    },  \
        { 1452, [unit_1452],    [unit_1452_help]    },  \
        { 1453, [unit_1453],    [unit_1453_help]    },  \
        { 1454, [unit_1454],    [unit_1454_help]    },  \
        { 1455, [unit_1455],    [unit_1455_help]    },  \
        { 1456, [unit_1456],    [unit_1456_help]    },  \
        { 1457, [unit_1457],    [unit_1457_help]    },  \
        { 1458, [unit_1458],    [unit_1458_help]    },  \
        { 1459, [unit_1459],    [unit_1459_help]    },  \
        { 1460, [unit_1460],    [unit_1460_help]    },  \
        { 1461, [unit_1461],    [unit_1461_help]    },  \
        { 1462, [unit_1462],    [unit_1462_help]    },  \
        { 1463, [unit_1463],    [unit_1463_help]    },  \
        { 1464, [unit_1464],    [unit_1464_help]    },  \
        { 1465, [unit_1465],    [unit_1465_help]    },  \
        { 1466, [unit_1466],    [unit_1466_help]    },  \
        { 1467, [unit_1467],    [unit_1467_help]    },  \
        { 1468, [unit_1468],    [unit_1468_help]    },  \
        { 1469, [unit_1469],    [unit_1469_help]    },  \
        { 1470, [unit_1470],    [unit_1470_help]    },  \
        { 1471, [unit_1471],    [unit_1471_help]    },  \
        { 1472, [unit_1472],    [unit_1472_help]    },  \
        { 1473, [unit_1473],    [unit_1473_help]    },  \
        { 1474, [unit_1474],    [unit_1474_help]    },  \
        { 1475, [unit_1475],    [unit_1475_help]    },  \
        { 1476, [unit_1476],    [unit_1476_help]    },  \
        { 1477, [unit_1477],    [unit_1477_help]    },  \
        { 1478, [unit_1478],    [unit_1478_help]    },  \
        { 1479, [unit_1479],    [unit_1479_help]    },  \
        { 1480, [unit_1480],    [unit_1480_help]    },  \
        { 1481, [unit_1481],    [unit_1481_help]    },  \
        { 1482, [unit_1482],    [unit_1482_help]    },  \
        { 1483, [unit_1483],    [unit_1483_help]    },  \
        { 1484, [unit_1484],    [unit_1484_help]    },  \
        { 1485, [unit_1485],    [unit_1485_help]    },  \
        { 1486, [unit_1486],    [unit_1486_help]    },  \
        { 1487, [unit_1487],    [unit_1487_help]    },  \
        { 1488, [unit_1488],    [unit_1488_help]    },  \
        { 1489, [unit_1489],    [unit_1489_help]    },  \
        { 1490, [unit_1490],    [unit_1490_help]    },  \
        { 1491, [unit_1491],    [unit_1491_help]    },  \
        { 1492, [unit_1492],    [unit_1492_help]    },  \
        { 1493, [unit_1493],    [unit_1493_help]    },  \
        { 1494, [unit_1494],    [unit_1494_help]    },  \
        { 1495, [unit_1495],    [unit_1495_help]    },  \
        { 1496, [unit_1496],    [unit_1496_help]    },  \
        { 1497, [unit_1497],    [unit_1497_help]    },  \
        { 1498, [unit_1498],    [unit_1498_help]    },  \
        { 1499, [unit_1499],    [unit_1499_help]    },  \
        { 1500, [unit_1500],    [unit_1500_help]    },  \
        { 1501, [unit_1501],    [unit_1501_help]    },  \
        { 1502, [unit_1502],    [unit_1502_help]    },  \
        { 1503, [unit_1503],    [unit_1503_help]    },  \
        { 1504, [unit_1504],    [unit_1504_help]    },  \
        { 1505, [unit_1505],    [unit_1505_help]    },  \
        { 1506, [unit_1506],    [unit_1506_help]    },  \
        { 1507, [unit_1507],    [unit_1507_help]    },  \
        { 1508, [unit_1508],    [unit_1508_help]    },  \
        { 1509, [unit_1509],    [unit_1509_help]    },  \
        { 1510, [unit_1510],    [unit_1510_help]    },  \
        { 1511, [unit_1511],    [unit_1511_help]    },  \
        { 1512, [unit_1512],    [unit_1512_help]    },  \
        { 1513, [unit_1513],    [unit_1513_help]    },  \
        { 1514, [unit_1514],    [unit_1514_help]    },  \
        { 1515, [unit_1515],    [unit_1515_help]    },  \
        { 1516, [unit_1516],    [unit_1516_help]    },  \
        { 1517, [unit_1517],    [unit_1517_help]    },  \
        { 1518, [unit_1518],    [unit_1518_help]    },  \
        { 1519, [unit_1519],    [unit_1519_help]    },  \
        { 1520, [unit_1520],    [unit_1520_help]    }   \


/*----------------------------------------------------------------------------*/
VARIABLE phys_device_id
{
    LABEL       [phys_device_id];
    CLASS       CONTAINED;
    TYPE        ASCII (16);
    HANDLING    READ;
    HELP        [phys_device_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_serial_num
{
    LABEL       [phys_device_ser_num];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ;
    HELP        [phys_device_ser_num_help];
}
/*----------------------------------------------------------------------------*/
#define DIA_HW_ELECTR                 0x01000000      /* 0x00000001 */
#define DIA_HW_MECH                   0x02000000      /* 0x00000002 */
#define DIA_TEMP_MOTOR                0x04000000      /* 0x00000004 */
#define DIA_TEMP_ELECTR               0x08000000      /* 0x00000008 */
#define DIA_MEM_CHKSUM                0x10000000      /* 0x00000010 */
#define DIA_MEASUREMENT               0x20000000      /* 0x00000020 */
#define DIA_NOT_INIT                  0x40000000      /* 0x00000040 */
#define DIA_INIT_ERR                  0x80000000      /* 0x00000080 */
#define DIA_ZERO_ERR                  0x00010000      /* 0x00000100 */
#define DIA_SUPPLY                    0x00020000      /* 0x00000200 */
#define DIA_CONF_INVAL                0x00040000      /* 0x00000400 */
#define DIA_WARMSTART                 0x00080000      /* 0x00000800 */
#define DIA_COLDSTART                 0x00100000      /* 0x00001000 */
#define DIA_MAINTENANCE               0x00200000      /* 0x00002000 */
#define DIA_CHARACT                   0x00400000      /* 0x00004000 */
#define DIA_IDENT_NUMBER_VIOLATION    0x00800000      /* 0x00008000 */
#define EXTENSION_AVAILABLE           0x00000080      /* 0x80000000 */

VARIABLE phys_diagnosis
{
    LABEL       [phys_diagnosis];
    CLASS       CONTAINED & DYNAMIC & DIAGNOSTIC;
    TYPE        BIT_ENUMERATED (4)
    {
        {   0,                               [dia_OK],                   [dia_OK_help]                   },
        {   DIA_HW_ELECTR,                   [dia_HW_ELECTR],            [dia_HW_ELECTR_help]            },
        {   DIA_HW_MECH,                     [dia_HW_MECH],              [dia_HW_MECH_help]              },
/*        {   DIA_TEMP_MOTOR,                  [dia_TEMP_MOTOR],           [dia_TEMP_MOTOR_help]           },
        {   DIA_TEMP_ELECTR,                 [dia_TEMP_ELECTR],          [dia_TEMP_ELECTR_help]          },*/
        {   DIA_MEM_CHKSUM,                  [dia_MEM_CHKSUM],           [dia_MEM_CHKSUM_help]           },
        {   DIA_MEASUREMENT,                 [dia_MEASUREMENT],          [dia_MEASUREMENT_help]          },
        {   DIA_NOT_INIT,                    [dia_NOT_INIT],             [dia_NOT_INIT_help]             },
        {   DIA_INIT_ERR,                    [dia_INIT_ERR],             [dia_INIT_ERR_help]             },
        {   DIA_ZERO_ERR,                    [dia_ZERO_ERR],             [dia_ZERO_ERR_help]             },
/*        {   DIA_SUPPLY,                      [dia_SUPPLY],               [dia_SUPPLY_help]               },*/
        {   DIA_CONF_INVAL,                  [dia_CONF_INVAL],           [dia_CONF_INVAL_help]           },
        {   DIA_WARMSTART,                   [dia_WARMSTART],            [dia_WARMSTART_help]            },
        {   DIA_COLDSTART,                   [dia_COLDSTART],            [dia_COLDSTART_help]            },
        {   DIA_MAINTENANCE,                 [dia_MAINTENANCE],          [dia_MAINTENANCE_help]          },
        {   DIA_CHARACT,                     [dia_CHARACT],              [dia_CHARACT_help]              },
        {   DIA_IDENT_NUMBER_VIOLATION,      [dia_IDENT_VIOL],           [dia_IDENT_VIOL_help]           },
        {   EXTENSION_AVAILABLE,             [dia_EXTENSION_AVAILABLE],  [dia_EXTENSION_AVAILABLE_help]  }
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 5"; /* 5 Zeilen hoch */
#endif
    HELP        [phys_diagnosis_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_mask
{
    LABEL       [phys_diagnosis_mask];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (4)
    {
        {   DIA_HW_ELECTR,          [dia_HW_ELECTR],            [dia_HW_ELECTR_help]            },
        {   DIA_HW_MECH,            [dia_HW_MECH],              [dia_HW_MECH_help]              },
        {   DIA_TEMP_MOTOR,         [dia_TEMP_MOTOR],           [dia_TEMP_MOTOR_help]           },
        {   DIA_TEMP_ELECTR,        [dia_TEMP_ELECTR],          [dia_TEMP_ELECTR_help]          },
        {   DIA_MEM_CHKSUM,         [dia_MEM_CHKSUM],           [dia_MEM_CHKSUM_help]           },
        {   DIA_MEASUREMENT,        [dia_MEASUREMENT],          [dia_MEASUREMENT_help]          },
        {   DIA_NOT_INIT,           [dia_NOT_INIT],             [dia_NOT_INIT_help]             },
        {   DIA_INIT_ERR,           [dia_INIT_ERR],             [dia_INIT_ERR_help]             },
        {   DIA_ZERO_ERR,           [dia_ZERO_ERR],             [dia_ZERO_ERR_help]             },
        {   DIA_SUPPLY,             [dia_SUPPLY],               [dia_SUPPLY_help]               },
        {   DIA_CONF_INVAL,         [dia_CONF_INVAL],           [dia_CONF_INVAL_help]           },
        {   DIA_WARMSTART,          [dia_WARMSTART],            [dia_WARMSTART_help]            },
        {   DIA_COLDSTART,          [dia_COLDSTART],            [dia_COLDSTART_help]            },
        {   DIA_MAINTENANCE,        [dia_MAINTENANCE],          [dia_MAINTENANCE_help]          },
        {   DIA_CHARACT,            [dia_CHARACT],              [dia_CHARACT_help]              },
        {   EXTENSION_AVAILABLE,    [dia_EXTENSION_AVAILABLE],  [dia_EXTENSION_AVAILABLE_help]  }
    }
    HANDLING    READ;
    HELP        [phys_diagnosis_mask_help];
}
/*----------------------------------------------------------------------------*/
#if 0  /* kmr: nur bei 'BIT_ENUMERATED (6)' gltig: */
  #define DIA_NOT_TESTED          0x400000000000      /* 0x000000000040 */
  #define DIA_LOGIK_NOT_TESTED    0x800000000000      /* 0x000000000080 */
  #define DIA_NOT_CALIB           0x000100000000      /* 0x000000000100 */
#endif
/* kmr: bei 'BIT_ENUMERATED (2)' gltig: */
#define DIA_NOT_TESTED          0x4000
#define DIA_LOGIK_NOT_TESTED    0x8000
#define DIA_NOT_CALIB           0x0001

VARIABLE phys_diagnosis_extension
{
    LABEL       "Diagnosis extension"
                "|de|Erweiterte Diagnose";
/*    LABEL       [phys_diagnosis_extension];*/
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0,                  [dia_OK], [dia_OK_help]                                },
/*        {   DIA_START_PULS_1,   "Pulses range 1 (0%...20%) not valid"
                                "|de|Stellimpulse Bereich 1 (0%...20%) nicht gltig"   },
        {   DIA_START_PULS_2,   "Pulses range 2 (20%...80%) not valid"
                                "|de|Stellimpulse Bereich 2 (20%...80%) nicht gltig"  },
        {   DIA_START_PULS_3,   "Pulses range 3 (80%...100%) not valid"
                                "|de|Stellimpulse Bereich 3 (80%...100%) nicht gltig" },*/
        {   DIA_NOT_TESTED,     "Internal error 1"
                                "|de|Interner Fehler 1"                                },
        {   DIA_LOGIK_NOT_TESTED, "Internal error 2"
                                "|de|Interner Fehler 2"                                },
        {   DIA_NOT_CALIB,      "Internal error 3"
                                "|de|Interner Fehler 3"                                }
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 4" ; /* 4 Zeilen hoch */
#endif
    HELP        [phys_diagnosis_extension_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_extension_mask /* optional */
{
    LABEL       [phys_diagnosis_extension_mask];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (6);
    HANDLING    READ;
    HELP        [phys_diagnosis_extension_mask_help];
}
/*----------------------------------------------------------------------------*/

/* Aufteilung von phys_diagnosis_opt in 2x2 Bytes, wegen Fehler am
   hherwertigsten Bit DIA_INIT_ERR bei 4 Byte */
/* fr phys_diagnosis_opt_1: */
#define DIA_HW_ELECTR                0x0100      /* 0x00000001 */
#define DIA_HW_MECH                  0x0200      /* 0x00000002 */
#define DIA_TEMP_MOTOR               0x0400      /* 0x00000004 */
#define DIA_TEMP_ELECTR              0x0800      /* 0x00000008 */
#define DIA_MEM_CHKSUM               0x1000      /* 0x00000010 */
#define DIA_MEASUREMENT              0x2000      /* 0x00000020 */
#define DIA_NOT_INIT                 0x4000      /* 0x00000040 */
#define DIA_INIT_ERR                 0x8000      /* 0x00000080 */
#define DIA_ZERO_ERR                 0x0001      /* 0x00000100 */
#define DIA_SUPPLY                   0x0002      /* 0x00000200 */
#define DIA_CONF_INVAL               0x0004      /* 0x00000400 */
#define DIA_WARMSTART                0x0008      /* 0x00000800 */
#define DIA_COLDSTART                0x0010      /* 0x00001000 */
#define DIA_MAINTENANCE              0x0020      /* 0x00002000 */
#define DIA_CHARACT                  0x0040      /* 0x00004000 */
#define DIA_IDENT_NUMBER_VIOLATION   0x0080      /* 0x00008000 */
/* fr phys_diagnosis_opt_2: */
#define EXTENSION_AVAILABLE          0x0080      /* 0x80000000 */

VARIABLE phys_diagnosis_opt_1
{
    LABEL       "Selection Diagnosis Messages"
                "|de|Auswahl Diagnosemeldungen";
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (2)
    {
        {   DIA_HW_ELECTR,          [dia_HW_ELECTR],            [dia_HW_ELECTR_help]            },
        {   DIA_HW_MECH,            [dia_HW_MECH],              [dia_HW_MECH_help]              },
/* not supported        {   DIA_TEMP_MOTOR,         [dia_TEMP_MOTOR],           [dia_TEMP_MOTOR_help]           },*/
/* not supported        {   DIA_TEMP_ELECTR,        [dia_TEMP_ELECTR],          [dia_TEMP_ELECTR_help]          },*/
        {   DIA_MEM_CHKSUM,         [dia_MEM_CHKSUM],           [dia_MEM_CHKSUM_help]           },
        {   DIA_MEASUREMENT,        [dia_MEASUREMENT],          [dia_MEASUREMENT_help]          },
        {   DIA_NOT_INIT,           [dia_NOT_INIT],             [dia_NOT_INIT_help]             },
        {   DIA_INIT_ERR,           [dia_INIT_ERR],             [dia_INIT_ERR_help]             },
        {   DIA_ZERO_ERR,           [dia_ZERO_ERR],             [dia_ZERO_ERR_help]             },
/* not supported        {   DIA_SUPPLY,             [dia_SUPPLY],               [dia_SUPPLY_help]               },*/
        {   DIA_CONF_INVAL,         [dia_CONF_INVAL],           [dia_CONF_INVAL_help]           },
        {   DIA_WARMSTART,          [dia_WARMSTART],            [dia_WARMSTART_help]            },
        {   DIA_COLDSTART,          [dia_COLDSTART],            [dia_COLDSTART_help]            },
        {   DIA_MAINTENANCE,        [dia_MAINTENANCE],          [dia_MAINTENANCE_help]          },
        {   DIA_CHARACT,            [dia_CHARACT],              [dia_CHARACT_help]              },
        {   DIA_IDENT_NUMBER_VIOLATION,  [dia_IDENT_VIOL],      [dia_IDENT_VIOL_help]           }
    }
    HANDLING    READ & WRITE;
#ifdef _V510_
    STYLE "MULTILINE 12 13" ; /* 13 Zeilen hoch */
#endif
    HELP    "Activation or deactivation of diagnosis messages."
            "|de|Aktivieren oder Deaktivieren der Diagnosemeldungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_opt_2
{
    LABEL       "";   /* kein Label da direkt unter phys_diagnosis_opt_1 angezeigt */
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (2)
    {
        {   EXTENSION_AVAILABLE,    [dia_EXTENSION_AVAILABLE],  [dia_EXTENSION_AVAILABLE_help]  }
    }
    HANDLING    READ & WRITE;
#ifdef _V510_
    STYLE "MULTILINE 12 1" ; /* 1 Zeilen hoch */
#endif
    HELP         "Activation or deactivation of diagnosis messages."
                 "|de|Aktivieren oder Deaktivieren der Diagnosemeldungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_certification
{
    LABEL       [phys_device_certification];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ;
    HELP        [phys_device_certification_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_write_locking
{
    LABEL       "Software Write Protection"
                "|de|Software-Schreibschutz";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   2457;
        { 2457, "Not write protected"
                "|de|Nicht schreibgeschtzt"  },
        {    0, "Write protected"
                "|de|Schreibgeschtzt"        }
    }
    HANDLING    READ & WRITE;
    HELP        "Activates or deactivates the software write protection."
                "|de|Aktiviert oder deaktiviert den Software-Schreibschutz.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_factory_reset
{
    LABEL       [phys_factory_reset];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   0;
        {     0, "No action"
                 "|de|Keine Aktion"                                             },
        { 32769, "Reset application to default values"
                 "|de|Rcksetzen der Applikation auf Kaltstartwerte"            },
        { 32768, "Reset device identification to default values"
                 "|de|Rcksetzen der Gerteidentifikation auf Kaltstartwerte"   },
        {     1, "Reset application and device ident. to default values"
                 "|de|Rcksetzen der Appl. und Gerteident. auf Kaltstartwerte" },
        {  2506, "Warmstart of the device"
                 "|de|Auslsen eines Warmstarts"                                },
        {  2712, "Reset bus address"
                 "|de|Rcksetzen der Busadresse"                                }
    }
    HANDLING    WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_LONG_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [phys_factory_reset_help];
}

/*----------------------------------------------------------------------------*/
/*    Physical Block: Actuator                                                */
/*----------------------------------------------------------------------------*/
VARIABLE phys_descriptor
{
    LABEL       [phys_descriptor];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "SAMSON Typ 3785 (PA-Profil 3)";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_descriptor_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_message
{
    LABEL       [phys_message];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_message_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_instal_date
{
    LABEL       [phys_install_date];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "01.01.2002";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_install_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_local_operation_enable
{
    LABEL       [trans_act_local_operation];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        {   0,  [disabled]  },
        {   1,  [enabled]   }
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_local_operation_help];
}
/*---------------------------------------------------------------------*/
VARIABLE phys_ident_number_selector
{
    LABEL       "PROFIBUS Ident.-Number Selection"
                "|de|Auswahl PROFIBUS Ident.-nummer";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, "Profile specific ident.-number"
             "|de|Profilspezifische Ident.-nummer"     },
        { 1, "Manufacturer specific ident.-number"
             "|de|Herstellerspezifische Ident.-nummer" }
    }
    HANDLING    READ & WRITE;
    POST_EDIT_ACTIONS
    {
        meld_wirksamkeit   /* Methode (Text: '..erst nach Neustart wirksam') */
    }
    HELP        [phys_ident_number_help];

}
/*----------------------------------------------------------------------------*/
VARIABLE phys_hw_write_protection
{
    LABEL       [phys_hw_write_protection];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Not write protected"
                "|de|Nicht schreibgeschtzt"  },
        {   1,  "Write protected"
                "|de|Schreibgeschtzt"        }
    }
    HANDLING    READ;
    HELP        "Switching state of the write protection switch in the device. "
                "When this option is activated, the device data can only be read, "
                "but they cannot be overwritten. The only way to activate the "
                "write protection option is by using the switch installed in the device."
                "|de|Schaltzustand des Schreibschutzschalters im Gert. "
                "Bei aktivem Schreibschutz knnen Gertedaten nur ausgelesen, "
                "jedoch nicht berschrieben werden. Aktivierung kann nur "
                "ber einen Schalter im Gert erfolgen.";
/*    HELP        [phys_hw_write_protection_help];*/
}

/*---------------------------------------------------------------------*/
/*    Herstellerspezifische Parameter                                  */
/*---------------------------------------------------------------------*/
VARIABLE phys_ident_limit_switches
{
    LABEL       "Inductive Limit Switches"
                "|de|Induktive Grenzkontakte";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Not implemented"
                "|de|Nicht eingebaut"   },
        {   1,  "Implemented"
                "|de|Eingebaut"         }
    }
    HANDLING    READ & WRITE;
    HELP        "Indicates whether option inductive limit switches is installed."
                "|de|Gibt an, ob die Option induktive Grenzkontakte eingebaut ist.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_ident_forced_venting
{
    LABEL       "Forced Venting"
                "|de|Zwangsentlftung";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Not implemented"
                "|de|Nicht eingebaut"   },
        {   1,  "Implemented"
                "|de|Eingebaut"         }
    }
    HANDLING    READ;
    HELP        "Indicates whether or not the optional forced venting"
                " (forced fail safe action) is installed. If installed, the absence"
                " of the input signal forces the valve to move in the appropriate"
                " fail safe position."
                "|de|Gibt an, ob die Option Zwangsentlftung"
                " eingebaut ist. Wenn die Option vorhanden ist, fhrt ein Wegfall"
                " des Steuersignals zum Anfahren der Sicherheitsstellung.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_ident_binary_input
{
    LABEL       [trans_bin_blk_class_BIN_IN];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Not evaluated"
                "|de|Nicht ausgewertet" },
        {   1,  "Actively open"
                "|de|Aktiv offen"       },
        {   2,  "Actively closed"
                "|de|Aktiv geschlossen" }
    }
    HANDLING    READ & WRITE;
    HELP        "Describes, whether and how the binary switch option is evaluated."
                "|de|Beschreibt, ob und wie der Binreingang ausgewertet wird.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_text_input_1
{
    LABEL       "Text Field 1"
                "|de|Textfeld 1";
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_text_input_2
{
    LABEL       "Text Field 2"
                "|de|Textfeld 2";
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_text_input_3
{
    LABEL       "Text Field 3"
                "|de|Textfeld 3";
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Space for 32 digits of information text."
                "|de|Raum fr 32 Zeichen Informationstext.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_product_num
{
    LABEL       "Product number"
                "|de|Erzeugnis-Nummer";
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "3785-XXXXXXXX-00";
    }
    HANDLING    READ;
    HELP        "Product number: Manufacturer's product number of the positioner."
                "|de|Erzeugnis-Nummer: Hersteller-Erzeugnisnummer des Stellungsreglers.";
}

/******************************************************************************/
/*    Transducer Block: Actuator                                              */
/******************************************************************************/
BLOCK transducer_block_1
{
    TYPE    TRANSDUCER;
    NUMBER  1;
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_reserve
{
    LABEL       [blk_reserved];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER(1);
    HANDLING    READ;
    HELP        [blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_object
{
    LABEL       [blk_block_object];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   3,  [blk_block_object_TRANSDUCER]   }
    }
    HANDLING    READ;
    HELP        [blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_parent_class
{
    LABEL       [blk_parent_class];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   5,  [trans_blk_parent_class_VALVE]  }
    }
    HANDLING    READ;
    HELP        [trans_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_class
{
    LABEL       [blk_class];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   2,      [trans_act_blk_class_ELECTRO_PNEU]  },
        {   250,    [not_used]                          },
        {   251,    [none]                              },
        {   252,    [unknown]                           },
        {   253,    [special]                           }
    }
    HANDLING    READ;
    HELP        [trans_blk_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_dd_reference
{
    LABEL       [blk_dd_reference];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4);
    HANDLING    READ;
    HELP        [blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_dd_rev
{
    LABEL       [blk_dd_rev];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER(2);
    HANDLING    READ;
    HELP        [blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_profile
{
    LABEL       [blk_profile];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        {   0x4001, [blk_profile_PA_COMPACT_A] },
        {   0x4002, [blk_profile_PA_COMPACT_B] },
        {   0x4081, [blk_profile_PA_SIMPLE_A]  },
        {   0x4082, [blk_profile_PA_SIMPLE_B]  }
    }
    HANDLING    READ;
    HELP        [blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_profile_rev
{
    LABEL       [blk_profile_rev];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        {   768,    "3.0"   }
    }
    HANDLING    READ;
    HELP        [blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_execution_time
{
    LABEL       [blk_execution_time];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_num_parameters
{
    LABEL       [blk_num_parameters];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_num_parameters_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_index_view_1
{
    LABEL       [blk_index_view_1];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_num_view_lists
{
    LABEL       [blk_num_view_lists];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_num_view_lists_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_st_rev
{
    LABEL       [st_rev];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tag_desc
{
/*    LABEL       [tag_desc];*/
    LABEL       "TAG (Transducer block)" "|de|TAG (Transducer Block)";
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [tag_desc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_strategy
{
    LABEL       [strategy];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ & WRITE;
    HELP        [strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_alert_key
{
    LABEL       [alert_key];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
    HELP        [alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_target_mode
{
    LABEL       [target_mode];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ & WRITE;
    HELP        [target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_actual_mode
{
    LABEL       [actual_mode];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ;
    HELP        [actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_permitted_mode
{
    LABEL       [permitted_mode];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ;
    HELP        [permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_normal_mode
{
    LABEL       [normal_mode];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ;
    HELP        [normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_current_state_alarm_sum
{
    LABEL       [current_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_unacknowledged_state_alarm_sum
{
    LABEL       [unacknowledged_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_unreported_state_alarm_sum
{
    LABEL       [unreported_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_disabled_state_alarm_sum
{
    LABEL       [disabled_state_alarm_sum];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [disabled_state_alarm_sum_help];
}

/*----------------------------------------------------------------------------*/
/*    Transducer Block: Actuator ELECTRO PNEUMATIC                            */
/*----------------------------------------------------------------------------*/
VARIABLE trans1_act_stroke_time_dec
{
/*    LABEL       [trans_act_stroke_time_dec];*/
    LABEL       "Determined stroke time CLOSE"
                "|de|Ermittelte Laufzeit ZU";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
            DEFAULT_VALUE   0.0;
            DISPLAY_FORMAT "3.1f";
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ;
    HELP        [trans_act_stroke_time_dec_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_act_stroke_time_inc
{
/*    LABEL       [trans_act_stroke_time_inc];*/
    LABEL       "Determined stroke time OPEN"
                "|de|Ermittelte Laufzeit AUF";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT "3.1f";
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ;
    HELP        [trans_act_stroke_time_inc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_deadband
{
    LABEL       [trans_act_deadband];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.5;
        DISPLAY_FORMAT "2.1f";
        MIN_VALUE       0.1;
        MAX_VALUE      10.0;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_deadband_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_device_calib_date
{
    LABEL       [trans_act_device_calib_date];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "01.01.2002";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_device_calib_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_device_config_date
{
    LABEL       [trans_act_device_config_date];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "01.01.2002";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_device_config_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_lin_type    /* nach Profil 2: CHARACT */
{
    LABEL       [trans_act_characteristic_type];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [linear]                                 },
/* kmr: vorerst nicht implementieren
        {   3,  [lin_type_TABLE]                         }, */
        {  52,  "Equal percentage"
                "|de|Gleichprozentig"                    },  /* 1:50 */
        {  53,  "Equal percentage reverse"
                "|de|Gleichprozentig invers"             },  /* 1:50 */
        { 240,  "SAMSON Butterfly linear"
                "|de|SAMSON Stellklappe linear"          },
        { 241,  "SAMSON Butterfly equal percentage"
                "|de|SAMSON Stellklappe gleichprozentig" },
        { 242,  "VETEC Rotary linear"
                "|de|VETEC Drehkegel linear"             },
        { 243,  "VETEC Rotary equal percentage"
                "|de|VETEC Drehkegel gleichprozentig"    }
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        LONG_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "For the creation of assignments between the reference variable"
                " and valve travel/angle range."
                "|de|Zur Zuordnung von Fhrungsgre und"
                " Hub-/Drehwinkelbereich des Ventils.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_rated_travel
{
    LABEL       [trans_act_rated_travel_value];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     15.0;
        DISPLAY_FORMAT    "3.1f";
        MIN_VALUE          0.0;
        MAX_VALUE        255.9; /* wg. Hubantrieb bis 255.9 */
    }
    HANDLING    READ & WRITE;
    CONSTANT_UNIT
        IF (trans1_valve_type == HUBANTRIEB)
            { [mm]; }
        ELSE
            { [degrees]; }
    POST_EDIT_ACTIONS
    {
        meld_hub_dreh_bereich   /* Methode */
    }
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_rated_travel_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calibration_cmd
{
    LABEL       [trans_act_self_calibration_cmd];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "No test, standard control operation"
                "|de|Kein Test, normaler Regelbetrieb"       },
        {   1,  "Zero calibration"
                "|de|Nullpunktabgleich"                      },
        {   2,  "Initialization"
                "|de|Initialisierung"                        },
        {   7,  "Reset total valve travel"
                "|de|Rcksetzen des absoluten Wegintegrals"  },
        {  10,  "Reset 'Control loop fault'"
                "|de|Rcksetzen von 'Regelkreis gestrt'"    },
        { 255,  "Abort process in action"
                "|de|Laufende Aktion abbrechen"              }
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_self_calibration_cmd_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calibration_status
{
    LABEL       [trans_act_self_calibration_status];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Undetermined"
                "|de|Unbestimmt"                      },
        {   1,  "Running"
                "|de|Luft"                           },
        {   2,  "Aborted"
                "|de|Abgebrochen"                     },
        {   3,  "Range error"
                "|de|Bereich fehlerhaft"              },
        {   4,  "Defective mechanics/pneumatics"
                "|de|Fehler in Mechanik/Pneumatik"    },
        {   5,  "Gain error"
                "|de|Verstrkungsfehler"              },
        {   6,  "Offset error"
                "|de|Offsetfehler"                    },
        {   7,  "Wrong calibration order"
                "|de|Reihenfolge Abgleich vertauscht" },
        {   8,  "Test zero point key: 'Key pressed'"
                "|de|Test Nullpunkttaste: 'Taste gedrckt'"   },
        {   9,  "Continue test"
                "|de|Test fortsetzen"                         },
        {  10,  "default"
                "|de|default"                                 },
        {  11,  "Timeout"
                "|de|Zeitfehler"                              },
        {  12,  "Proportional range restricted"
                "|de|Proportionalbereich zu stark eingeschrnkt"              },
        {  13,  "Rated travel or transmission error"
                "|de|Nennhub oder bersetzung falsch gewhlt"                 },
        {  14,  "Mechanical error (at initialization)"
                "|de|Mechanisches System klemmt (bei Initialisierung)"        },
        {  15,  "Pneumatical error (at initialization)"
                "|de|Pneumatisches System undicht (bei Initialisierung)"      },
        {  16,  "Action aborted; no successful manufacturing test"
                "|de|Aktion abgebrochen; kein erfolgreicher Fertigungstest"   },
        {  17,  "Initialization status: determination of mechanical stops"
                "|de|Initialisierungsstatus: Ermittlung der mechanischen Anschlge"  },
        {  18,  "Initialization status: determination of minimum pulses"
                "|de|Initialisierungsstatus: Ermittlung der minimalen Stellimpulse"  },
        {  19,  "Initialization status: determination of minimum transit times"
                "|de|Initialisierungsstatus: Ermittlung der minimalen Laufzeiten"    },
        {  20,  "Initialization aborted due to activated forced venting option"
                "|de|Initialisierung durch Aktivierung Zwangsentlftung abgebrochen" },
        {  21,  "Step 1 (Step response)"
                "|de|Sprung 1 (Sprungantwort)"                },
        {  22,  "Delay (step response)"
                "|de|Verzug (Sprungantwort)"                  },
        {  23,  "Step 2 (Step response)"
                "|de|Sprung 2 (Sprungantwort)"                },
        {  24,  "Step value transfered (Step response)"
                "|de|Sprungwert bergeben (Sprungantwort)"    },
        {  25,  "Timeout: Detection of step response"
                "|de|Zeitfehler: Sprungantwortermittlung"     },
        {  26,  "Timeout: Measuring delay time"
                "|de|Zeitfehler: Messung der Verzugszeit"     },
        {  27,  "Timeout: Zero point check"
                "|de|Zeitfehler: Nullpunktberprfung"        },
        {  28,  "Timeout: Leakage test"
                "|de|Zeitfehler: Leckagetest"                 },
        {  29,  "Test finished. Waiting for command (does not follow W)"
                "|de|Test beendet. Wartet auf Anweisung (folgt nicht W)"      },
        {  30,  "Zero point error"
                "|de|Nullpunktfehler"                                         },
        {  31,  "Aborted, not initialized"
                "|de|Abbruch, nicht initialisiert"                            },
        {  32,  "Timeout: Control operating point"
                "|de|Zeitfehler: Arbeitspunkt anregeln"                       },
        {  33,  "Special function in process (zero point, leakage,...)"
                "|de|Sonderfunktion in Bearbeitung (Nullpunkt, Leckage,...)"  },
        {  34,  "Max. permissible leakage exceeded"
                "|de|Max. zulssige Leckage berschritten"                    },
        {  35,  "Timeout: Detection of max. possible position"
                "|de|Zeitfehler: Ermitteln der max. mglichen Position"       },
        { 254,  "Successful"
                "|de|Erfolgreich"                                             },
        { 255,  "No valid data from the application"
                "|de|Keine gltigen Daten von der Applikation"                }
    }
    HANDLING    READ;
    HELP        [trans_act_self_calibration_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_servo_gain_1
{
    LABEL       "Proportional Action Coeff. Filling KP_Y1"
                "|de|Proportionalittsfaktor Zuluft KP_Y1";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.50;
        DISPLAY_FORMAT "2.2f";
        MIN_VALUE       0.01;
        MAX_VALUE      10.0;
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Used to enter the proportional action coefficient (filling)"
                " for pressurizing (loading air to) the actuator."
                " For optimizing steps of 0.1 are recommended."
                "|de|Eingabe des Proportionalittsfaktors Zuluft."
                " Bei Anpassung des Wertes werden 0.1 - Schritte empfohlen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_servo_rate_1
{
    LABEL       "Derivative Action Coeff. KD"
                "|de|Verstrkungsfaktor KD";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.12;
        DISPLAY_FORMAT  "1.2f";
        MIN_VALUE        0.00;
        MAX_VALUE        1.00;
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Derivative action coefficient of the differential element."
                " For optimizing steps of 0.02 are recommended."
                "|de|Verstrkungsfaktor des Differenziergliedes."
                " Bei Anpassung des Wertes werden 0.02 - Schritte empfohlen. ";
}
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_servo_reset_1
{
    LABEL       [trans_act_servo_reset];
    CLASS       CONTAINED;
    TYPE        FLOAT;
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME
    }
    HELP        [trans_act_servo_reset_help];
}*/
/*----------------------------------------------------------------------------*/
VARIABLE trans1_setp_cutoff_dec
{
    LABEL       [trans_act_setp_cutoff_dec];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     1.0;
        DISPLAY_FORMAT   "2.1f";
        MIN_VALUE        -2.5;
        MAX_VALUE        99.0;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "In case the setpoint falls below the entered value, the valve will"
                " move to a position which corresponds to a setpoint value of 0 %."
                " A value of -2,5 % will deactivate the function. Hysteresis 1 %."
                "|de|Unterschreitet die Fhrungsgre den eingegebenen"
                " Wert, wird das Ventil in Richtung der Endlage, die 0 %"
                " der Fhrungsgre entspricht, gefahren. Hysterese 1 %."
                " Bei Wert = -2,5 % ist die Funktion deaktiviert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_setp_cutoff_inc
{
    LABEL       [trans_act_setp_cutoff_inc];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    99.0;
        DISPLAY_FORMAT   "3.1f";
        MIN_VALUE         0.0;
        MAX_VALUE       125.0;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "In case the setpoint exceeds the entered value, the valve will"
                " move to a position which corresponds to a setpoint value of 100 %."
                " A value of 125 % will deactivate the function. Hysteresis 1 %."
                "|de|berschreitet die Fhrungsgre den eingegebenen"
                " Wert, wird das Ventil in Richtung der Endlage, die 100 %"
                " der Fhrungsgre entspricht, gefahren. Hysterese 1 %."
                " Bei Wert = 125 % ist die Funktion deaktiviert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_total_valve_travel
{
    LABEL       [trans_act_total_valve_travel];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT ".0f";
    }
    HANDLING    READ;
    HELP        [trans_act_total_valve_travel_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_total_valve_travel_limit
{
    LABEL       [trans_act_total_valve_travel_limit];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   1000000.0;
        DISPLAY_FORMAT       ".0f";
        MIN_VALUE             0.0;
        MAX_VALUE      16500000.0;
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_total_valve_travel_limit_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_lower_value
{
    LABEL       "Travel / Angle Limit Lower"
                "|de|Hub-/Drehwinkelbegrenzung UNTEN";
/*    LABEL       [trans_act_travel_limit_lower_value];*/
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     0.0;
        DISPLAY_FORMAT   "3.1f";
        MIN_VALUE       -20.0;
        MAX_VALUE        99.9;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_travel_limit_lower_value_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_upper_value
{
    LABEL       "Travel / Angle Limit Upper"
                "|de|Hub-/Drehwinkelbegrenzung OBEN";
/*    LABEL       [trans_act_travel_limit_upper_value];*/
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   100.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE         0.0;
        MAX_VALUE       120.0;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_travel_limit_upper_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_rate_dec
{
/*    LABEL       [trans_act_travel_time_dec];*/
    LABEL       "Required stroke time CLOSE"
                "|de|Gewnschte Laufzeit ZU";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     0.0;
        DISPLAY_FORMAT   "3.1f";
        MIN_VALUE         0.0;
        MAX_VALUE        75.0;
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_travel_time_dec_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_rate_inc
{
/*    LABEL       [trans_act_travel_time_inc];*/
    LABEL       "Required stroke time OPEN"
                "|de|Gewnschte Laufzeit AUF";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     0.0;
        DISPLAY_FORMAT   "3.1f";
        MIN_VALUE         0.0;
        MAX_VALUE        75.0;
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        [trans_act_travel_time_inc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_valve_maintenance_date
{
    LABEL       [trans_act_valve_maintenance_date];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "01.01.2002";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_valve_maintenance_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_servo_gain_2
{
    LABEL       "Proportional Action Coeff. Venting KP_Y2"
                "|de|Proportionalittsfaktor Abluft KP_Y2";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     1.2;
        DISPLAY_FORMAT   "2.2f";
        MIN_VALUE         0.01;
        MAX_VALUE        10.00;
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Used to enter the proportional action "
                "coefficient (venting) for exhausting (dumping air from) the"
                " actuator. For optimizing steps of 0.1 are recommended."
                "|de|Eingabe des Proportionalittsfaktors Abluft. "
                "Bei Anpassung des Wertes werden 0.1 - Schritte empfohlen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_positioning_value
{
    LABEL       [trans_act_positioning_value];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
    }
    HANDLING    READ;
    HELP        [trans_act_positioning_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_positioning_status
{
    LABEL       [trans_act_positioning_status];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
    HELP        [trans_act_positioning_status_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_feedback_value
{
    LABEL       [trans_act_feedback_value];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT ".2f";
    }
    HANDLING    READ;
    HELP        [trans_act_feedback_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_feedback_status
{
    LABEL       [trans_act_feedback_status];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
    HELP        [trans_act_feedback_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_valve_man
{
    LABEL       [phys_device_man_id];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "SAMSON";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_man
{
    LABEL       [phys_device_man_id];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "SAMSON";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_valve_type
{
    LABEL       [phys_valve_type];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [phys_valve_type_LINEAR]        },
        {   1,  [phys_valve_type_PART_TURN]     }
    }
    HANDLING    READ & WRITE;
    POST_EDIT_ACTIONS
    {
        support_antrieb /* Methode */
    }
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Describes the valve design."
                "|de|Beschreibt die Ventilkonstruktion.";
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_type
{
    LABEL       [phys_actuator_type];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [phys_actuator_type_ELECTRO_PNEUMATIC]  },
        {   1,  [phys_actuator_type_ELECTRIC]           },
        {   2,  [phys_actuator_type_ELECTRO_HYDRAULIC]  },
        {   3,  [other]                                 }
    }
    HANDLING    READ;
    HELP        "Identifies the actuator design."
                " Parameter is determined by the actuator."
                "|de|Beschreibt die Antriebskonstruktion."
                " Parameter wird vom Antrieb bestimmt.";
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_action
{
    LABEL       [phys_actuator_action];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [phys_actuator_action_NOT_INIT]     },
        {   1,  [phys_actuator_action_OPEN]         },
        {   2,  [phys_actuator_action_CLOSE]        },
        {   3,  [phys_actuator_action_NONE]         }
    }
    HANDLING    READ;
    HELP        [phys_actuator_action_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_valve_serial_number
{
    LABEL       [phys_serial_num];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_valve_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_serial_number
{
    LABEL       [trans_serial_num];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_actuator_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_additional_gear_install_date
{
    LABEL       [trans_additional_gear_install_date];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "01.01.2002";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_additional_gear_install_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_additional_gear_ser_number
{
    LABEL       "Serial Number Additional Component"
                "|de|Seriennummer Zusatzkomponente";
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_additional_gear_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_additional_gear_man
{
    LABEL       "Manufacturer Additional Component"
                "|de|Hersteller Zusatzkomponente";
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "References a specific manufacturer, which is usually a company name, "
                "that is responsible for the manufacture of this additional component."
                "|de|Kennzeichnet eindeutig den Hersteller der Zusatzkomponente. blicherweise "
                "der Name der Firma, die die entsprechende Zusatzkomponente herstellt.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_additional_gear_id              /* optional */
{
    LABEL       "ID Additional Component"
                "|de|Bezeichnung Zusatzkomponente";
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Manufacturer specific type identification of the additional component "
                "(e.g. gearbox, booster)."
                "|de|Herstellerspezifische Bezeichnung der Zusatzkomponente (z.B. Getriebe, "
                "Booster).";
}

/******************************************************************************/
/*    Herstellerspezifische Parameter                                         */
/******************************************************************************/
VARIABLE trans1_transducer_state
{
    LABEL       "Transducer State"
                "|de|Betriebszustand";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "See current mode"
                "|de|Siehe Aktueller Modus"       },
        {   1,  "Forced venting active"
                "|de|Zwangsentlftung aktiv"      },
        {   2,  "Lower travel limit active"
                "|de|Hubbegrenzung unten aktiv"   },
        {   3,  "Upper travel limit active"
                "|de|Hubbegrenzung oben aktiv"    },
        {   4,  "End position active at < "
                "|de|Endlage bei < aktiv"         },
        {   5,  "End position active at > "
                "|de|Endlage bei > aktiv"         }
    }
    HANDLING    READ;
    HELP        "Current state of the transducer block."
                "|de|Aktueller Zustand des Transducerblocks.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_transm_code_value        /* (DS34) */
{
    LABEL       "Transmission Code"
                "|de|bersetzung Code";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        IF (trans1_valve_type == HUBANTRIEB)
        {
            {   1,  "D1" },
            {   2,  "D2" }
        }
        ELSE
        {
            {   3,  "S90"  },
            {   4,  "S120" }

        }
    }
    VALIDITY
    IF ( (trans1_valve_type == HUBANTRIEB) && (trans1_attachment == NAMUR) )
        { FALSE; }
    ELSE
        { TRUE; }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP
        IF (trans1_valve_type == HUBANTRIEB)
        {
            "Selecting the lever type for direct attachment."
            "|de|Festlegung der geometrischen Abmessungen"
            " des Hubabgriffs bei integriertem Anbau.";
        }
        ELSE
        {
            "Maximum angular travel (slewing angle) of the mounted cam plate."
            "|de|Maximaler Schwenkwinkel der eingebauten Kurvenscheibe.";
        }
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_transm_code_status    /* (DS34) */
{
    LABEL       "Status Transmission Code"
                "|de|Status bersetzung Code";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
/*        DEFAULT_VALUE   128; nicht bei _MASK !*/
        DEFAULT_VALUE   32;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    VALIDITY
        IF ( (trans1_valve_type == HUBANTRIEB) && (trans1_attachment == NAMUR) )
            { FALSE; }
        ELSE
            { TRUE; }
    HANDLING    READ;
    HELP        [value_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_transm_length
{
    LABEL       "Transmission Length"
                "|de|bersetzung Lnge";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  42.0;
        DISPLAY_FORMAT "4.1f";
        MIN_VALUE       0.0;
        MAX_VALUE    1023.0;
    }
    CONSTANT_UNIT   [mm];
    VALIDITY
        IF ( (trans1_valve_type == HUBANTRIEB) && (trans1_attachment == NAMUR) )
            { TRUE; }
        ELSE
            { FALSE; }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Lever length. Distance between travel pick up and "
                "pivot of the pick up lever."
                "|de|Hebellnge; Abstand zwischen Hubabgriff und"
                " Drehpunkt des Abgriffhebels.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_transm_pin_pos
{
    LABEL       "Transmission Pin Position"
                "|de|bersetzung Stiftposition";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, "A " },
        { 1, "B " }
    }
    VALIDITY
        IF ( (trans1_valve_type == HUBANTRIEB) && (trans1_attachment == NAMUR) )
            { TRUE; }
        ELSE
            { FALSE; }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Transmitter pin in position A or B"
                " (see also Mounting Instructions)."
                "|de|Position des Stiftes am Hebel des Stellungsreglers."
                " Siehe Markierung am Hebel.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_init_method
{
    LABEL       "Initialization Method"
                "|de|Initialisierungsart";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Maximum range"
                "|de|Maximalbereich"    },
        {   1,  "Nominal range"
                "|de|Nennbereich"       }
    }
    HANDLING    READ & WRITE;
    POST_EDIT_ACTIONS
    {
        meld_init_art   /* Methode */
    }
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Initialization related to nominal or maximum range."
                "|de|Initialisierung bezogen auf Nenn- oder Maximalbereich.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calib_warning
{
    LABEL       "Calibration Alarm Message"
                "|de|Kalibrierung Warnmeldung";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Undetermined"
                "|de|Unbestimmt"                                  },
        {  13,  "Wrong selection of rated travel or transmission"
                "|de|Nennhub oder bersetzung falsch gewhlt"     },
        {  15,  "Air leakage of pneumatic system"
                "|de|Pneumatisches System undicht"                },
        { 254,  "Successful"
                "|de|Erfolgreich"                                 },
        { 255,  "No valid data from application"
                "|de|Keine gltigen Daten von der Applikation"    }
    }
    HANDLING    READ;
    HELP        "Additional alarm message of the initiated calibration procedure."
                "|de|Zustzliche Warnmeldung der gestarteten Kalibrierungssequenz.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_charact_type
{
    LABEL       [trans_lin_type];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Free form description of the user defined characteristics."
                "|de|Freier Text zur Beschreibung der"
                " benutzerdefinierten Kennlinie.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_max_hub
{
    LABEL       "Max. Permissible Travel/Angle of Rotation"
                "|de|Max. mglicher Hub/Drehwinkel";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   100.0;
        DISPLAY_FORMAT   "3.1f";
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ;
    HELP        "Possible stroke/angle (% of nominal stroke/angle)."
                " Determined during initialization."
                "|de|Maximal erreichter Hub/Drehwinkel"
                " (% von Nennhub/Drehwinkel). Ermittelt whrend der Initialisierung.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tolerance_band
{
    LABEL       "Tolerance Band"
                "|de|Toleranzband";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   5.0;
        DISPLAY_FORMAT "2.1f";
        MIN_VALUE       0.1;
        MAX_VALUE      10.0;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Reset criteria for active control loop monitoring."
                " Entry of the specified maximum permissible control deviation."
                " See also delay time. Cold start value = Xtot"
                "|de|Rcksetzkriterium fr laufende Regelkreisberwachung."
                " Eingabe der hierfr erlaubten Regelabweichung. Siehe auch"
                " Nachlaufzeit. Kaltstartwert = Xtot";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_delay_time
{
    LABEL       "Delay Time"
                "|de|Nachlaufzeit";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  10.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE     240.0;
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Reset criteria for active control loop monitoring. If the entered"
                " delay time is exceeded and the control deviation does not lie within"
                " the tolerance band entered, a control loop fault is reported."
                "|de|Rcksetzkriterium fr laufende Regelkreisberwachung."
                " Wenn die eingegebene Nachlaufzeit berschritten ist und die"
                " Regelabweichung nicht innerhalb des eingegebenen Toleranzbandes"
                " liegt, wird eine Regelkreisstrung gemeldet.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tol_overshoot
{
    LABEL       "Tolerated Overshoot"
                "|de|Tolerierte berschwingweite";
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.5;
        DISPLAY_FORMAT "2.2f";
        MIN_VALUE       0.1;
        MAX_VALUE      10.00;
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "In case the control difference e exceeds"
                " the tolerable overshoot, the impulse adaption will modify the"
                " minimum impulse adaption for the motion direction which caused the"
                " exceeding. In case the control difference e exceeds the dead zone"
                " xtot but remains in between the maximum overshoot, the impulse"
                " adaption will reduce the minimum impulses in both motion direction"
                " after two complete cycles in between the maximum overshoot."
                "|de|berschreitet die Regeldifferenz e"
                " die berschwingweite, so verringert die Impulsanpassung die"
                " minimalen Impulse in der Bewegungsrichtung, welche die berschreitung"
                " verursacht hat. berschreitet die Regeldifferenz e die tote Zone"
                " xtot, bleibt aber innerhalb der berschwingweite, verringert die"
                " Impulsanpassung die minimalen Impulse in beide Bewegungsrichtungen"
                " erst nach 2 vollstndigen Schwingungen innerhalb der"
                " berschwingweite.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_binary_input
{
    LABEL       "State Binary Input"
                "|de|Zustand Binreingang";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        {   0,  "Not active"
                "|de|Nicht aktiv"       },
        {   1,  "Active"
                "|de|Aktiv"             },
        { 254,  "Not evaluated"
                "|de|Nicht ausgewertet" }
    }
    HANDLING    READ;
    HELP        "Switching state of the binary switch."
                "|de|Schaltzustand des Binrschalters.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_attachment
{
    LABEL       "Attachment"
                "|de|Anbau";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Integrated"
                "|de|Integriert" },
        {   1,  "NAMUR"          }
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    VALIDITY
        IF (trans1_valve_type == HUBANTRIEB)
            { TRUE; }
        ELSE
            { FALSE; }
    HELP        "Defines positioner attachment to the control valve."
                "|de|Definiert den Anbau des Stellungsreglers"
                " an das Stellgert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_actuator_version
{
    LABEL       "Actuator Version"
                "|de|Bauart";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  "Single acting with spring return"
                "|de|Einfach wirkend mit Federrckstellung"  },
        {   1,  "Double acting without spring return"
                "|de|Doppelt wirkend ohne Federrckstellung" }
    }
    HANDLING    READ & WRITE;
    HELP        "Actuator with or without spring loading."
                "|de|Antrieb mit oder ohne Federrckstellung.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_mounting_position
{
    LABEL       "Mounting Position"
                "|de|Anbaulage";
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        {   0,  "Arrow pointing away from the actuator"
                "|de|Pfeil zeigt vom Antrieb weg"   },
        {   1,  "Arrow pointing toward the actuator"
                "|de|Pfeil zeigt zum Antrieb hin"   }
    }
    VALIDITY
        IF (trans1_valve_type == HUBANTRIEB)
            { TRUE; }
        ELSE
            { FALSE; }
    HANDLING    READ & WRITE;
    HELP        "An arrow is located on the cover plate of the"
                " positioner which is used for alignment on the actuator. This arrow"
                " must either point toward the actuator (direct attachment) or away"
                " from the actuator (NAMUR attachment). Exception: Control valves for"
                " which the seat is solely closed by a retracting actuator stem. In"
                " this case, the arrow must point either away from the actuator"
                " (direct attachment) or toward the actuator (NAMUR attachment)."
                "|de|Auf der Abdeckplatte des Stellungsreglers befindet"
                " sich ein Pfeil, der zur Ausrichtung auf den Antrieb dient. Bei"
                " Direktanbau muss dieser Pfeil zum Antrieb hin und bei NAMUR-Anbau"
                " vom Antrieb weg zeigen. Ausnahme: Stellgerte, bei denen der Sitz"
                " ausschliesslich durch eine einfahrende Antriebsstange geschlossen"
                " wird. Hier muss der Pfeil bei Direktanbau vom Antrieb weg und bei"
                " NAMUR-Anbau zum Antrieb hin zeigen.";
}

/***********************************************************************/
/*    Function Block                                                         */
/***********************************************************************/
BLOCK function_block_1
{
    TYPE    FUNCTION;
    NUMBER  1;
}

func1_blk_reserve                           LIKE VARIABLE   phys_blk_reserve
{
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   2,  [blk_block_object_FUNCTION]     }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   2,  [func_blk_parent_class_OUTPUT]  }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {   1,  [func_blk_class_AO]     }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
func1_blk_dd_reference              LIKE VARIABLE   phys_blk_dd_reference
{
}
/*----------------------------------------------------------------------------*/
func1_blk_dd_rev                    LIKE VARIABLE   phys_blk_dd_rev
{
}
/*----------------------------------------------------------------------------*/
func1_blk_profile                   LIKE VARIABLE   phys_blk_profile
{
}
/*----------------------------------------------------------------------------*/
func1_blk_profile_rev               LIKE VARIABLE   phys_blk_profile_rev
{
}
/*----------------------------------------------------------------------------*/
func1_blk_execution_time            LIKE VARIABLE   phys_blk_execution_time
{
}
/*----------------------------------------------------------------------------*/
func1_blk_num_parameters            LIKE VARIABLE   blk_num_parameters
{
}
/*----------------------------------------------------------------------------*/
func1_blk_index_view_1              LIKE VARIABLE   phys_blk_index_view_1
{
}
/*----------------------------------------------------------------------------*/
func1_blk_num_view_lists            LIKE VARIABLE   phys_blk_num_view_lists
{
}
/*----------------------------------------------------------------------------*/
func1_st_rev                        LIKE VARIABLE   phys_st_rev
{
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_tag_desc
{
/*    LABEL       [tag_desc];*/
    LABEL       "TAG (Function block)" "|de|TAG (Function Block)";
    CLASS       CONTAINED;
    TYPE        ASCII (32);
    HANDLING    READ & WRITE;
    HELP        [tag_desc_help];
}
/*----------------------------------------------------------------------------*/
func1_strategy                      LIKE VARIABLE   phys_strategy
{
}
/*----------------------------------------------------------------------------*/
func1_alert_key                     LIKE VARIABLE   phys_alert_key
{
}
/*----------------------------------------------------------------------------*/
func1_target_mode                   LIKE VARIABLE   phys_target_mode
{
    REDEFINE TYPE       ENUMERATED (1)
    {
        DEFAULT_VALUE   BLOCK_MODE_AUTO;
        {   0x02,   [mode_RCAS]                 },
        {   0x08,   [mode_AUTO]                 },
        {   0x10,   [mode_MAN]                  },
        {   0x20,   [mode_LO]                   },
        {   0x80,   "Fail safe position"
                    "|de|Sicherheitsstellung"   }
    }
}
/*----------------------------------------------------------------------------*/
func1_actual_mode                   LIKE VARIABLE   phys_actual_mode
{
    REDEFINE TYPE       ENUMERATED (1)
    {
        {   0x02,   [mode_RCAS]             },
        {   0x08,   [mode_AUTO]             },
        {   0x10,   [mode_MAN]              },
        {   0x20,   [mode_LO]               },
        {   0x80,   [mode_OUT_OF_SERVICE]   }
    }
}
/*----------------------------------------------------------------------------*/
func1_permitted_mode                LIKE VARIABLE   phys_permitted_mode
{
    REDEFINE TYPE       BIT_ENUMERATED (1)
    {
        {   0x02,   [mode_RCAS]             },
        {   0x08,   [mode_AUTO]             },
        {   0x10,   [mode_MAN]              },
        {   0x20,   [mode_LO]               },
        {   0x80,   [mode_OUT_OF_SERVICE]   }
    }
}
/*----------------------------------------------------------------------------*/
func1_normal_mode                   LIKE VARIABLE   phys_normal_mode
{
    REDEFINE TYPE       ENUMERATED (1)
    {
        {   0x02,   [mode_RCAS]             },
        {   0x08,   [mode_AUTO]             },
        {   0x10,   [mode_MAN]              },
        {   0x20,   [mode_LO]               },
        {   0x80,   [mode_OUT_OF_SERVICE]   }
    }
}
/*----------------------------------------------------------------------------*/
func1_current_state_alarm_sum       LIKE VARIABLE   phys_current_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}
/*----------------------------------------------------------------------------*/
func1_unacknowledged_state_alarm_sum        LIKE VARIABLE   phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}
/*----------------------------------------------------------------------------*/
func1_unreported_state_alarm_sum            LIKE VARIABLE   phys_unreported_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}
/*----------------------------------------------------------------------------*/
func1_disabled_state_alarm_sum              LIKE VARIABLE   phys_disabled_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}

/*---------------------------------------------------------------------*/
/*    Function Block: Analog Output                                    */
/*---------------------------------------------------------------------*/
VARIABLE func1_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_value
{
    LABEL       [func_ao_setpoint_value];
    HELP        [func_ao_setpoint_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT ".2f" ;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_status
{
/*    LABEL       [func_ao_setpoint_status];*/
    LABEL	"Status quality (Setpoint Value)"
	        "|de|Status Qualitt (Sollwert)";
    HELP        [func_ao_setpoint_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
func1_setpoint_status_limit    LIKE VARIABLE   func1_rcas_out_status_quality
{
    REDEFINE LABEL "Status limit (Setpoint Value)"
                   "|de|Status Limit (Sollwert)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HANDLING    READ & WRITE;
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_upper_range_value
{
    LABEL       [func_pv_scale_upper_value];
    HELP        [func_pv_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT    ".2f";
        DEFAULT_VALUE   100.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_lower_range_value
{
    LABEL       [func_pv_scale_lower_value];
    HELP        [func_pv_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_unit
{
    LABEL       [func_pv_scale_unit];
    HELP        [func_pv_scale_unit_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_decimal_point
{
    LABEL       [decimal_point];
    HELP        [decimal_point_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,   "0"        },
        {   1,   "1"        },
        {   2,   "2"        },
        {   3,   "3"        },
        {   4,   "4"        },
        {   5,   "5"        },
        {   6,   "6"        }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_value
{
    LABEL       [func_ao_readback_value];
    HELP        [func_ao_readback_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT ".2f" ;
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_status
{
/*    LABEL       [func_ao_readback_status];*/
    LABEL	"Status quality (Readback Value)"
	        "|de|Status Qualitt (Istwert)";
    HELP        [func_ao_readback_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
func1_readback_status_limit    LIKE VARIABLE   func1_rcas_out_status_quality
{
    REDEFINE LABEL "Status limit (Readback Value)"
                   "|de|Status Limit (Istwert)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_in_value
{
    LABEL       [func_rcas_in_value];
    HELP        [func_rcas_in_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_in_status
{
    LABEL       [func_rcas_in_status];
    HELP        [func_rcas_in_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
/*        DEFAULT_VALUE   0x1B; nicht bei _MASK !*/
        DEFAULT_VALUE   6;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
        STATUS_GOOD_CASCADE_MASK
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_in_channel
{
    LABEL       "Channel In"
                "|de|Kanal Eingang";
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   314;
        {      0,  "Not active"
                   "|de|Nicht aktiv"  },
        {    314,  "Active"
                   "|de|Aktiv" }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_channel
{
    LABEL       "Channel Out"
                "|de|Kanal Ausgang";
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   313;
        {      0,  "Not active"
                   "|de|Nicht aktiv"  },
        {    313,  "Active"
                   "|de|Aktiv" }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_time
{
    LABEL       [func_ao_fsafe_time];
    HELP        [func_ao_fsafe_time_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".0f";
        DEFAULT_VALUE    0.0;
        MIN_VALUE        0.0;
        MAX_VALUE     3600.0;
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [func_ao_fsafe_type_FAIL_SAFE_VALUE]        },
        {   1,  [func_ao_fsafe_type_STORING_LAST_SETPOINT]  },
        {   2,  [func_ao_fsafe_type_FAIL_SAFE_POSITION]     }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_value
{
    LABEL       [func_ao_fsafe_value];
    HELP        [func_ao_fsafe_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT    ".2f";
        DEFAULT_VALUE     0.0;
        MIN_VALUE         0.0;
        MAX_VALUE       100.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_out_value
{
    LABEL       [func_rcas_out_value];
    HELP        [func_rcas_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_out_status_quality
{
/*  LABEL       [func_rcas_out_status];*/
    LABEL	"Status quality (RCAS OUT)"
	        "|de|Status Qualitt (RCAS OUT)";
    HELP        [func_rcas_out_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
        STATUS_GOOD_CASCADE_MASK
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
func1_rcas_out_status_limit         LIKE VARIABLE   func1_rcas_out_status_quality
{
    REDEFINE LABEL "Status limit (RCAS OUT)"
                   "|de|Status Limit (RCAS OUT)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_position_discrete_value
{
    LABEL       [func_ao_position_discrete_value];
    HELP        [func_ao_position_discrete_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        {   0,  [func_ao_position_discrete_status_NOT_INIT]         },
        {   1,  [func_ao_position_discrete_status_CLOSED]           },
        {   2,  [func_ao_position_discrete_status_OPENED]           },
        {   3,  [func_ao_position_discrete_status_INTERMEDIATE]     }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_position_discrete_status
{
    LABEL       [func_ao_position_discrete_status];
    HELP        [func_ao_position_discrete_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_deviation
{
    LABEL       [func_ao_setpoint_deviation];
    HELP        [func_ao_setpoint_deviation_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
#define CB_FAIL_SAFE            0x010000      /* Bit  0 */
#define CB_REQ_LOC_OP           0x020000      /* Bit  1 */
#define CB_LOCAL_OP             0x040000      /* Bit  2 */
#define CB_OVERRIDE             0x080000      /* Bit  3 */
#define CB_DISC_DIR             0x100000      /* Bit  4 */
#define CB_TORQUE_D_OP          0x200000      /* Bit  5 */
#define CB_TORQUE_D_CL          0x400000      /* Bit  6 */
#define CB_TRAV_TIME            0x800000      /* Bit  7 */
#define CB_ACT_OPEN             0x000100      /* Bit  8 */
#define CB_ACT_CLOSE            0x000200      /* Bit  9 */
#define CB_UPDATE_EVT           0x000400      /* Bit 10 */
#define CB_SIMULATE             0x000800      /* Bit 11 */
#define CB_DISTURBANCE          0x001000      /* Bit 12 */
#define CB_CONTR_ERR            0x002000      /* Bit 13 */
#define CB_CONTR_INACT          0x004000      /* Bit 14 */
#define CB_SELFTEST             0x008000      /* Bit 15 */
#define CB_TOT_VALVE_TRAV       0x000001      /* Bit 16 */
#define CB_BINARY_INPUT         0x000002      /* Bit 17 */

VARIABLE func1_check_back
{
    LABEL       [func_check_back];
    HELP        [func_check_back_help];
    CLASS       CONTAINED & DYNAMIC & DIAGNOSTIC;
    TYPE        BIT_ENUMERATED (3)
    {
        {   0,                  [dia_OK],               [dia_OK_help]               },
        {   CB_FAIL_SAFE,       "Fail safe action active"
                                "|de|Sicherheitsverhalten aktiv",
                                                        [cb_FAIL_SAFE_help]         },
        {   CB_REQ_LOC_OP,      [cb_REQ_LOC_OP],        [cb_REQ_LOC_OP_help]        },
        {   CB_LOCAL_OP,        [cb_LOCAL_OP],          [cb_LOCAL_OP_help]          },
        {   CB_OVERRIDE,        "Forced venting active"
                                "|de|Zwangsentlftung aktiv", [cb_OVERRIDE_help]    },
/*        {   CB_DISC_DIR,        [cb_DISC_DIR],          [cb_DISC_DIR_help]          },
        {   CB_TORQUE_D_OP,     [cb_TORQUE_D_OP],       [cb_TORQUE_D_OP_help]       },
        {   CB_TORQUE_D_CL,     [cb_TORQUE_D_CL],       [cb_TORQUE_D_CL_help]       },*/
        {   CB_TRAV_TIME,       [cb_TRAV_TIME],         [cb_TRAV_TIME_help]         },
/*        {   CB_ACT_OPEN,        [cb_ACT_OPEN],          [cb_ACT_OPEN_help]          },
        {   CB_ACT_CLOSE,       [cb_ACT_CLOSE],         [cb_ACT_CLOSE_help]         },*/
		{	CB_UPDATE_EVT,		"Configuration changed"
	                            "|de|Konfiguration verndert", [cb_UPDATE_EVT_help] },
        {   CB_SIMULATE,        [cb_SIMULATE],          [cb_SIMULATE_help]          },
/*        {   CB_DISTURBANCE,     [cb_DISTURBANCE],       [cb_DISTURBANCE_help]       },*/
        {   CB_CONTR_ERR,       [cb_CONTR_ERR],         [cb_CONTR_ERR_help]         },
        {   CB_CONTR_INACT,     [cb_CONTR_INACT],       [cb_CONTR_INACT_help]       },
        {   CB_SELFTEST,        [cb_SELFTEST],          [cb_SELFTEST_help]          },
        {   CB_TOT_VALVE_TRAV,  [cb_TOT_VALVE_TRAV],    [cb_TOT_VALVE_TRAV_help]    },
        {   CB_BINARY_INPUT,    "Binary input active"
                                "|de|Binreingang aktiv"                            }
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* 5 Zeilen hoch */
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_check_back_mask
{
    LABEL       [func_check_back_mask];
    HELP        [func_check_back_mask_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (3)
    {
        {   CB_FAIL_SAFE,       [cb_FAIL_SAFE],         [cb_FAIL_SAFE_help]         },
        {   CB_REQ_LOC_OP,      [cb_REQ_LOC_OP],        [cb_REQ_LOC_OP_help]        },
        {   CB_LOCAL_OP,        [cb_LOCAL_OP],          [cb_LOCAL_OP_help]          },
/*        {   CB_OVERRIDE,        [cb_OVERRIDE],          [cb_OVERRIDE_help]          },*/
        {   CB_OVERRIDE,        "Forced venting active"
                                "|de|Zwangsentlftung aktiv",          [cb_OVERRIDE_help]          },
        {   CB_DISC_DIR,        [cb_DISC_DIR],          [cb_DISC_DIR_help]          },
        {   CB_TORQUE_D_OP,     [cb_TORQUE_D_OP],       [cb_TORQUE_D_OP_help]       },
        {   CB_TORQUE_D_CL,     [cb_TORQUE_D_CL],       [cb_TORQUE_D_CL_help]       },
        {   CB_TRAV_TIME,       [cb_TRAV_TIME],         [cb_TRAV_TIME_help]         },
        {   CB_ACT_OPEN,        [cb_ACT_OPEN],          [cb_ACT_OPEN_help]          },
        {   CB_ACT_CLOSE,       [cb_ACT_CLOSE],         [cb_ACT_CLOSE_help]         },
		{	CB_UPDATE_EVT,		"Configuration changed"
	                            "|de|Konfiguration verndert", [cb_UPDATE_EVT_help] },
        {   CB_SIMULATE,        [cb_SIMULATE],          [cb_SIMULATE_help]          },
        {   CB_DISTURBANCE,     [cb_DISTURBANCE],       [cb_DISTURBANCE_help]       },
        {   CB_CONTR_ERR,       [cb_CONTR_ERR],         [cb_CONTR_ERR_help]         },
        {   CB_CONTR_INACT,     [cb_CONTR_INACT],       [cb_CONTR_INACT_help]       },
        {   CB_SELFTEST,        [cb_SELFTEST],          [cb_SELFTEST_help]          },
        {   CB_TOT_VALVE_TRAV,  [cb_TOT_VALVE_TRAV],    [cb_TOT_VALVE_TRAV_help]    }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_check_back_opt
{
    LABEL       "Selection Device Status Messages"
                "|de|Auswahl Gertestatusmeldungen";
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (3)
    {
        {   CB_FAIL_SAFE,       "Fail safe action active"
                                "|de|Sicherheitsverhalten aktiv",
                                                        [cb_FAIL_SAFE_help]         },
        {   CB_REQ_LOC_OP,      [cb_REQ_LOC_OP],        [cb_REQ_LOC_OP_help]        },
        {   CB_LOCAL_OP,        [cb_LOCAL_OP],          [cb_LOCAL_OP_help]          },
        {   CB_OVERRIDE,        "Forced venting active"
                                "|de|Zwangsentlftung aktiv", [cb_OVERRIDE_help]    },
/* not supported        {   CB_DISC_DIR,        [cb_DISC_DIR],          [cb_DISC_DIR_help]          },*/
/* not supported        {   CB_TORQUE_D_OP,     [cb_TORQUE_D_OP],       [cb_TORQUE_D_OP_help]       },*/
/* not supported        {   CB_TORQUE_D_CL,     [cb_TORQUE_D_CL],       [cb_TORQUE_D_CL_help]       },*/
        {   CB_TRAV_TIME,       [cb_TRAV_TIME],         [cb_TRAV_TIME_help]         },
/* not supported        {   CB_ACT_OPEN,        [cb_ACT_OPEN],          [cb_ACT_OPEN_help]          },*/
/* not supported        {   CB_ACT_CLOSE,       [cb_ACT_CLOSE],         [cb_ACT_CLOSE_help]         },*/
		{	CB_UPDATE_EVT,		"Configuration changed"
	                            "|de|Konfiguration verndert", [cb_UPDATE_EVT_help] },
        {   CB_SIMULATE,        [cb_SIMULATE],          [cb_SIMULATE_help]          },
/*        {   CB_DISTURBANCE,     [cb_DISTURBANCE],       [cb_DISTURBANCE_help]       },*/
        {   CB_CONTR_ERR,       [cb_CONTR_ERR],         [cb_CONTR_ERR_help]         },
        {   CB_CONTR_INACT,     [cb_CONTR_INACT],       [cb_CONTR_INACT_help]       },
        {   CB_SELFTEST,        [cb_SELFTEST],          [cb_SELFTEST_help]          },
        {   CB_TOT_VALVE_TRAV,  [cb_TOT_VALVE_TRAV],    [cb_TOT_VALVE_TRAV_help]    },
        {   CB_BINARY_INPUT,    "Binary input active"
                                "|de|Binreingang aktiv"                            }
    }
    HANDLING    READ & WRITE;
#ifdef _V510_
    STYLE "MULTILINE 12 12" ; /* 12 Zeilen hoch (2. Wert) */
#endif
    HELP    "Activation or deactivation of device status messages."
            "|de|Aktivieren oder Deaktivieren der Gertestatusmeldungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ao_simulate_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_status_quality
{
    LABEL      "Status quality (Simulation value)"
               "|de|Status Qualitt (Simulationswert)";
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   32;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
func1_simulate_status_limit                 LIKE VARIABLE   func1_simulate_status_quality
{
    REDEFINE LABEL      "Status (Limit) (Simulation value)"
                        "|de|Status (Limit) (Simulationswert)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_enabled
 {
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [disabled]      },
        {   1,  [enabled]       }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_increase_close
{
    LABEL       [func_ao_increase_close];
    HELP        [func_ao_increase_close_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [func_ao_increase_close_RISING]     },
        {   1,  [func_ao_increase_close_FALLING]    }
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ao_out_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT "3.2f";
        DEFAULT_VALUE   0.0;
    }
    HANDLING
        IF ((func1_target_mode == BLOCK_MODE_MAN) || (func1_target_mode == BLOCK_MODE_LOCAL_OVERRIDE))
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_status_quality
{
/*    LABEL       [func_out_status];*/
    LABEL "Status quality (Output)"
          "|de|Status Qualitt (Ausgang)";
    HELP        [func_out_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING
        IF ((func1_target_mode == BLOCK_MODE_MAN) || (func1_target_mode == BLOCK_MODE_LOCAL_OVERRIDE))
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
func1_out_status_limit                      LIKE VARIABLE   func1_out_status_quality
{
    REDEFINE LABEL "Status limit (Output)"
                   "|de|Status Limit (Ausgang)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_upper_range_value
{
    LABEL       [func_out_scale_upper_value];
    HELP        [func_out_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT    ".2f";
        DEFAULT_VALUE   100.0;
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_lower_range_value
{
    LABEL       [func_out_scale_lower_value];
    HELP        [func_out_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".2f";
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_unit
{
    LABEL       [func_out_scale_unit];
    HELP        [func_out_scale_unit_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1342;
        IF (trans1_valve_type == HUBANTRIEB)
        {
          { 1342,  [Percent], [Percent_help]  }
          { 1013,  [mm],      [mm_help]       }
        }
        ELSE
        {
          { 1342,  [Percent], [Percent_help]  }
          { 1005,  [degrees], [degrees_help]  }
        }

    }
    HANDLING    READ & WRITE;
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
func1_out_decimal_point                     LIKE VARIABLE   func1_pv_decimal_point
{
}

/******************************************************************************/
/*    Unit relations                                                          */
/******************************************************************************/
UNIT AO_PV_SCALE_UNIT
{
    func1_pv_unit:

    func1_pv_upper_range_value,
    func1_pv_lower_range_value,
    func1_readback_value,
    func1_setpoint_value,
    func1_rcas_in_value,
    func1_rcas_out_value,
    func1_fsafe_value,
    func1_simulate_value
}

UNIT AO_OUT_SCALE_UNIT
{
    func1_out_unit:

    func1_out_value,
    func1_out_upper_range_value,
    func1_out_lower_range_value,
    trans1_feedback_value,
    trans1_positioning_value
}

/******************************************************************************/
/*      Refresh relations                                                     */
/******************************************************************************/
/* kmr: nicht implementiert */

/******************************************************************************/
/* Methods                                                                    */
/******************************************************************************/

/* Defines fr Diagnosis und checkback: */
#define CB_FAIL_SAFE_1                0x00010000   /* Bit  0 0x010000    */
#define CB_REQ_LOC_OP_1               0x00020000   /* Bit  1 0x020000    */
#define CB_LOCAL_OP_1                 0x00040000   /* Bit  2 0x040000    */
#define CB_OVERRIDE_1                 0x00080000   /* Bit  3 0x080000    */
#define CB_TRAV_TIME_1                0x00800000   /* Bit  7 0x800000    */
#define CB_UPDATE_EVT_1               0x00000400   /* Bit 10 0x000400    */
#define CB_SIMULATE_1                 0x00000800   /* Bit 11 0x000800    */
#define CB_CONTR_INACT_1              0x00004000   /* Bit 14 0x004000    */
#define CB_SELFTEST_1                 0x00008000   /* Bit 15 0x008000    */
#define CB_TOT_VALVE_TRAV_1           0x00000001   /* Bit 16 0x000001    */
#define CB_BINARY_INPUT_1             0x00000002   /* Bit 17 0x000002    */

#define DIA_HW_ELECTR_1               0x01000000   /* Bit  0 0x00000001  */
#define DIA_HW_MECH_1                 0x02000000   /* Bit  1 0x00000002  */
#define DIA_MEM_CHKSUM_1              0x10000000   /* Bit  4 0x00000010  */
#define DIA_MEASUREMENT_1             0x20000000   /* Bit  5 0x00000020  */
#define DIA_NOT_INIT_1                0x40000000   /* Bit  6 0x00000040  */
#define DIA_INIT_ERR_1                0x80000000   /* Bit  7 0x00000080  */
#define DIA_ZERO_ERR_1                0x00010000   /* Bit  8 0x00000100  */
#define DIA_CONF_INVAL_1              0x00040000   /* Bit 10 0x00000400  */
#define DIA_WARMSTART_1               0x00080000   /* Bit 11 0x00000800  */
#define DIA_COLDSTART_1               0x00100000   /* Bit 12 0x00001000  */
#define DIA_MAINTENANCE_1             0x00200000   /* Bit 13 0x00002000  */
#define DIA_CHARACT_1                 0x00400000   /* Bit 14 0x00004000  */
#define DIA_IDENT_NUMBER_VIOLATION_1  0x00800000   /* Bit 15 0x00008000  */

/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS  0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS               0xFFF7  /* Lsche GOOD */

/* fr PDM-LifeList / Diagnose */
METHOD  method_PDM_StandardDiagnosis
{
    LABEL       "method_PDM_StandardDiagnosis";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {
        long i_phys_diagnosis;   /* Diagnosis hat 4 Byte */
        long i_func1_check_back; /* Checkback hat 3 Byte */
        int  i_no_good, i_no_recommended; /* Merker zum Lschen anderer Stati */
        int  akt_BA; /* akt. Betriebsart */

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */

        ReadCommand (read_phys_diagnosis);   /* lese phys_diagnosis   (#13) */
        ReadCommand (read_func1_check_back); /* lese func1_check_back (#33) */
        i_phys_diagnosis   = lvar_value (phys_diagnosis);
        i_func1_check_back = lvar_value (func1_check_back);

        /* Vorbelegen: */
		PDM_Diag_Status_Diagnosis = 0;
		PDM_Diag_Rule_Message     = "";
		i_no_good = 0;
		i_no_recommended = 0;

        /* bei Hand PDM_DIAG_SIMULATION setzen */
        ReadCommand (read_func1_mode);  /* lese akt. Betriebsart */
        akt_BA = ivar_value (func1_actual_mode);

        /* wenn Hand aktiv: */
        if( akt_BA == BLOCK_MODE_MAN )
        {
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Manual mode active;"
			                         "|049Betriebsart Hand aktiv;";
            i_no_good += 1; /* Merker setzen */
        }
        /* wenn alles 0: */
		else if( (i_phys_diagnosis == 0) && (i_func1_check_back == 0) )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message     = [dia_OK];
		}

		if( i_func1_check_back & CB_FAIL_SAFE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Fail safe action active;"
                                        "|de|Sicherheitsverhalten aktiv;";
		}
		if( i_func1_check_back & CB_OVERRIDE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Forced venting active;"
                                        "|de|Zwangsentlftung aktiv;";
		}
		if( i_func1_check_back & CB_UPDATE_EVT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Configuration changed;"
		                                 "|de|Konfiguration verndert;";
		}
		if( i_func1_check_back & CB_CONTR_INACT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += [cb_CONTR_INACT] + ";";
		}
		if( i_func1_check_back & CB_BINARY_INPUT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Binary input active;"
                                        "|de|Binreingang aktiv;";
		}
		if( i_phys_diagnosis & DIA_WARMSTART_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += [dia_WARMSTART] + ";";
		}
		if( i_phys_diagnosis & DIA_COLDSTART_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += [dia_COLDSTART] + ";";
		}
        /************/
		if( i_phys_diagnosis & DIA_CONF_INVAL_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_CONFIG_ERROR;
			PDM_Diag_Rule_Message     += [dia_CONF_INVAL] + ";";
            i_no_good += 1; /* Merker setzen */
		}
        /************/
		if( i_func1_check_back & CB_TOT_VALVE_TRAV_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [cb_TOT_VALVE_TRAV] + ";";
            i_no_good += 1; /* Merker setzen */
		}
 		if( (i_func1_check_back & CB_TRAV_TIME_1) )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [cb_TRAV_TIME] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_func1_check_back & CB_REQ_LOC_OP_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [cb_REQ_LOC_OP] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_CHARACT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [dia_CHARACT] + ";";
            i_no_good += 1; /* Merker setzen */
		}
        /************/
		if( i_phys_diagnosis & DIA_IDENT_NUMBER_VIOLATION_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message     += [dia_IDENT_VIOL] + ";";
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_MAINTENANCE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			/* PDM_Diag_Rule_Message     += [dia_MAINTENANCE]; doppelte Meldung */
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_ZERO_ERR_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message     += [dia_ZERO_ERR] + ";";
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_INIT_ERR_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message     += [dia_INIT_ERR] + ";";
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
        /************/
		if( i_phys_diagnosis & DIA_HW_ELECTR_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_HW_ELECTR] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_HW_MECH_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_HW_MECH] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_MEM_CHKSUM_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_MEM_CHKSUM] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_MEASUREMENT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_MEASUREMENT] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_NOT_INIT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_NOT_INIT] + ";";
            i_no_good += 1; /* Merker setzen */
		}
        /************/
		if( i_func1_check_back & CB_SELFTEST_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message     += [cb_SELFTEST] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_func1_check_back & CB_SIMULATE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message     += [cb_SIMULATE] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_func1_check_back & CB_LOCAL_OP_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message     += [cb_LOCAL_OP] + ";";
            i_no_good += 1; /* Merker setzen */
		}

        /* wenn nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message     = [dia_OK];
		}

        /* wenn Status PDM_DIAG_GOOD gelscht werden soll: */
		if( i_no_good != 0 )
		{    /* nur PDM_DIAG_GOOD lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_GOOD_INVERS;
		}

        /* wenn Status PDM_DIAG_MAINT_RECOMMENDED gelscht werden soll: */
		if( i_no_recommended != 0 )
		{    /* nur PDM_DIAG_MAINT_RECOMMENDED lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_MAINT_RECOMMENDED_INVERS;
		}
    }
}
/*****************************************************************************/

/* fr Aufruf von Manual: */
METHOD methodOpenDeviceManual
{
	LABEL "SAMSON 3785 " + [menu_DeviceManual];
	ACCESS OFFLINE ;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME) ;
	}
    HELP "Mounting and operating instructions of the positioner."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers.";
}
/*****************************************************************************/

METHOD sie_set
{
    LABEL       [transfer];
    DEFINITION
    {
    }
    HELP        [transfer_help];
}
/*----------------------------------------------------------------------------*/
METHOD support_antrieb         /* Aktionen fr Hub-/Schwenkantriebumschaltung */
{
    LABEL " ";
    DEFINITION
    {
        int antr;
        int old_unit;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        antr = ivar_value (trans1_valve_type);
        old_unit = ivar_value (func1_out_unit); /* alte eingestellte Einheit */

        if (antr == HUBANTRIEB) /* wenn Umschaltung auf Hubantrieb */
        {
          if (old_unit == 1005) /* nur wenn alte Einheit =  auf mm schalten */
          {
            iassign (func1_out_unit, 1013);        /* Einheit out = mm        */
          }
          iassign (trans1_transm_code_value, 1);   /* bersetzung Code = D1   */
          fassign (trans1_rated_travel, 15);       /* Nennhub/-winkel = 15 mm */
        }
        else                    /* wenn Umschaltung auf Schwenkantrieb */
        {
          if (old_unit == 1013) /* nur wenn alte Einheit = mm auf  schalten */
          {
            iassign (func1_out_unit, 1005);        /* Einheit out =            */
          }
          iassign (trans1_transm_code_value, 3);   /* bersetzung Code = S90    */
          fassign (trans1_rated_travel, 90);       /* Nennhub/-winkel = 90 Grad */
          iassign (trans1_attachment,  NAMUR);     /* Anbau = NAMUR             */
        }
    }
}
/*----------------------------------------------------------------------------*/
METHOD meld_hub_dreh_bereich          /* Anpassung Nennbereich/Arbeitsbereich */
{
    LABEL " ";
    DEFINITION
    {
        float nennhub_dreh;
        float hub_dreh_ber_end;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        nennhub_dreh     = fvar_value (trans1_rated_travel);
        hub_dreh_ber_end = fvar_value (func1_out_upper_range_value);

        if (nennhub_dreh < hub_dreh_ber_end) /* Bereich zu gross */
        {
            ACKNOWLEDGE("Hint: travel/angle range will be adapted to rated travel/angle"
                        " in the device."
                        "|de|Hinweis: Der Hub-/Drehwinkelbereich wird im Gert an den"
                        " Nennhub/-winkel angepasst.");
        }
        if (nennhub_dreh > hub_dreh_ber_end) /* Nennhub/-winkel zu gross */
        {
            ACKNOWLEDGE("Recommendation: travel/angle range should be adapted."
                        "|de|Empfehlung: Der Hub-/Drehwinkelbereich sollte angepasst werden.");
        }
    }
}
/*----------------------------------------------------------------------------*/
METHOD meld_init_art                      /* nderung der Initialisierungsart */
{
    LABEL " ";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ACKNOWLEDGE("A change of the initialization method will"
                    " take effect only after a new initialization !"
                    "|de|Eine nderung der Initialisierungsart wird erst"
                    " nach einer erneuten Initialisierung wirksam !");
    }
}
/*----------------------------------------------------------------------------*/
METHOD meld_wirksamkeit            /* nderung von phys_ident_number_selector */
{
    LABEL " ";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ACKNOWLEDGE("A change of Selection Ident.-Number will"
                    " take effect only after a device restart !"
                    "|de|Eine nderung der Auswahl Ident.-nummer wird erst"
                    " nach einem Neustart des Gertes wirksam !");
    }
}
/*----------------------------------------------------------------------------*/
METHOD abort_initialization            /* Abbruch der Initialisierungssequenz */
{
    LABEL "Abort process in action"
          "|de|Laufende Aktion abbrechen";
    DEFINITION
    {
        int  HWwrProt;
        int  SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        iassign (trans1_self_calibration_cmd, ABBRUCH);   /* Abbruch starten     */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        ACKNOWLEDGE("Action aborted"
                    "|de|Aktion wurde abgebrochen");
    }
    HELP "Aborts running calibration sequence."
         "|de|Abbruch der laufenden Kalibrierungssequenz.";
}
/*----------------------------------------------------------------------------*/
METHOD cal_zero_valve                                    /* Nullpunktabgleich */
{
    LABEL "Start zero adjustment"
          "|de|Nullpunktabgleich starten";
    DEFINITION
    {
        int  HWwrProt;
        int  SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Never start zero adjustment during a running process !\n"
                    "During zero adjustment the control valve departs from its current "
                    "position at full travel !\n\n"
                    "Status of zero adjustment: \nsee parameter 'Status (Selfcalibration)' "
                    "and 'Calibration Alarm Message'.\n\n"
                    "Start zero adjustment ?"
                    "|de|WARNUNG: Der Nullpunktabgleich darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Nullpunktabgleich fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status des Nullpunktabgleichs: \nsiehe Parameter 'Status (Selbstkalibrierung)' "
                    "und 'Kalibrierung Warnmeldung'.\n\n"
                    "Nullpunktabgleich starten ?");

        add_abort_method(abort_initialization);
        iassign (trans1_self_calibration_cmd, NULLP_CAL); /* Nullpunktabgleich starten */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        DELAY(3,"Zero adjustment is running"
                "|de|Nullpunktabgleich luft");
    }
    HELP "Automatic zero point correction."
         "|de|Automatische Korrektur des Nullpunktes.";
}
/*----------------------------------------------------------------------------*/
/* Initialisierung (ohne erweiterte Initialisierung) ! */
METHOD init_valve
{
    LABEL "Start initialization"
          "|de|Initialisierung starten";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Never start initialization during a running process !\n"
                    "During initialization the control valve departs from its current"
                    "position at full travel !\n\n"
                    "Status of initialization: \nsee parameter 'Status (Selfcalibration)' "
                    "and 'Calibration Alarm Message'.\n\n"
                    "Start initialization ?"
                    "|de|WARNUNG: Die Initialisierung darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Initialisierung fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status der Initialisierung: \nsiehe Parameter 'Status (Selbstkalibrierung)' "
                    "und 'Kalibrierung Warnmeldung'.\n\n"
                    "Initialisierung starten ?");

        add_abort_method(abort_initialization);
        iassign (trans1_self_calibration_cmd, INIT);  /* Initialisierung starten */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        DELAY(3,"Initialization is running"
                "|de|Initialisierung luft");
    }
    HELP "Automatic start up."
         " Requires manual zero adjustment and valid initialization parameters."
         "|de|Automatische Inbetriebnahme. Voraussetzung: mechanische"
         " Nullpunktabgleich muss einmal durchgefhrt worden sein. Gltige"
         " Initialisierungswerte mssen eingegeben sein.";
}
/*----------------------------------------------------------------------------*/
METHOD warmstart                                                 /* Warmstart */
{
    LABEL   [factory_reset_WARMSTART];
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Application data will be set to default values !\n"
                    "Never start warm start during a running process !\n"
                    "During warm start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Der Warmstart darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\nBei Warmstart fhrt das Stellgert den"
                    " gesamten Bereich durch !\nAusfhren ?");

        DELAY(2,"Warm start is starting"
                "|de|Warmstart wird gestartet");
        lassign(phys_factory_reset, 2506);       /* Warmstart auslsen  */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        DELAY(10,"Warm start is running"
                 "|de|Warmstart luft");
        ACKNOWLEDGE("Warm start was executed"
                    "|de|Warmstart wurde ausgefhrt");
    }
    HELP "Command to reset the device (warm start)."
         "|de|Auslsen eines Warmstarts.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_appl                                /* Kaltstart Applikation */
{
    LABEL "Reset application to default values"
          "|de|Rcksetzen Applikation auf Kaltstartwerte";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Application data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Applikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        DELAY(2,"Reset application is starting"
                "|de|Kaltstart Applikation wird gestartet");
        lassign (phys_factory_reset, 32769);     /* Kaltstart Applikation auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        DELAY(15,"Running"
                 "|de|Luft");
        ACKNOWLEDGE("Reset application executed. New communication startup"
                    " necessary to get current device data."
                    "|de|Rcksetzen der Applikation durchgefhrt."
                    " Erneuter Verbindungsaufbau erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset application to default values."
         "|de|Rcksetzen der Applikation auf Kaltstartwerte.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_ident                      /* Kaltstart Gerteidentifikation */
{
    LABEL "Reset device identification to default values"
          "|de|Rcksetzen Gerteidentifikation auf Kaltstartwerte";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Device identification data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Gerteidentifikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        DELAY(2,"Reset device identification is starting"
                "|de|Kaltstart Gerteidentifikation wird gestartet");
        lassign (phys_factory_reset, 32768);     /* Kaltstart Identifikation auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        DELAY(3,"Reset device identification is running"
                "|de|Kaltstart Gerteidentifikation luft");
        ACKNOWLEDGE("Reset device identification executed."
                    " New communication startup is necessary to get"
                    " current device data."
                    "|de|Rcksetzen der Gerteidentifikation durchgefhrt."
                    " Erneuter Verbindungsaufbau ist erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset device identification to default values."
         "|de|Rcksetzen der Gerteidentifikation auf Kaltstartwerte.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_appl_ident         /* Kaltstart Applikation + Identifikation */
{
    LABEL "Reset application and device identification to default values"
          "|de|Rcksetzen Applikation und Gerteidentifikation auf Kaltstartwerte";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Device identification and application data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Gerteidentifikationsdaten und Applikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        DELAY(2,"Reset application and device identification is starting"
                "|de|Kaltstart Applikation und Gerteidentifikationsdaten wird gestartet");
        lassign (phys_factory_reset, 1);    /* Kaltstart Applikation+Ger.-ID auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        DELAY(15,"Running"
                 "|de|Luft");
        ACKNOWLEDGE("Reset executed. New communication startup"
                    " necessary to get current device data."
                    "|de|Rcksetzen durchgefhrt."
                    " Erneuter Verbindungsaufbau erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset application and device identification to default values."
         "|de|Rcksetzen der Applikation und Gerteidentifikationsdaten auf Kaltstartwerte.";
}
/*----------------------------------------------------------------------------*/
METHOD wegint_reset                                 /* Rcksetzen Wegintegral */
{
    LABEL "Reset total valve travel"
          "|de|Rcksetzen Wegintegral";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        iassign (trans1_self_calibration_cmd, WEGINT_RESET);
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        DELAY(5,"Reset total valve travel in process"
                "|de|Wegintegral wird zurckgesetzt");
    }
    HELP "Reset total valve travel to 0."
         "|de|Rcksetzen des Wegintegrals auf 0.";
}
/*----------------------------------------------------------------------------*/
METHOD rk_stoer_reset                         /* Rcksetzen Regelkreisstrung */
{
    LABEL "Reset control loop error"
          "|de|Rcksetzen Regelkreisstrung";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        iassign (trans1_self_calibration_cmd, RK_STOER_RESET);
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        DELAY(5,"Reset control loop error in process"
                "|de|Regelkreisstrung wird zurckgesetzt");
    }
    HELP "Reset control loop error."
         "|de|Rcksetzen der Regelkreisstrung.";
}
/*----------------------------------------------------------------------------*/
METHOD reset_busadr                              /* Rcksetzen der Busadresse */
{
    LABEL   "Reset bus address to default value"
            "|de|Rcksetzen der Busadresse auf Kaltstartwert";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Bus address will be reset to factory value 126 !\n"
                    "Then communication is possible only with this bus address !\n"
                    "Execute ?"
                    "|de|WARNUNG: Die Busadresse wird auf den Auslieferwert 126 gestellt !\n"
                    "Verbindung kann dann nur noch mit dieser Busadresse aufgebaut werden !\n"
                    "Ausfhren ?");
        lassign(phys_factory_reset, 2712);       /* Reset Busadresse auslsen  */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        ACKNOWLEDGE("Bus address was reset"
                    "|de|Busadresse wurde zurckgesetzt");
    }
    HELP "Bus address in the device is set to factory value 126."
         "|de|Die Busadresse im Gert wird auf den Auslieferwert 126 zurckgesetzt.";
}
/*----------------------------------------------------------------------------*/
#if 0
/* kmr: Methode muss noch auf Profil 3 umgestellt werden */
/* siehe 'Table Handling' im Profil 3 ! */
METHOD kennl_eingabe      /* Eingabe der benutzerdefinierten Kennlinienpunkte */
{
    LABEL "User defined characteristics"
          "|de|Benutzerdefinierte Kennlinie";
    DEFINITION
    {
        char  status[STATUS_SIZE];
        char  dev_status[DEV_STATUS_SIZE];
        int   param_nr;
        int   cnt;
        int   nr;
        long  ids[2];
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */

        GET_DEV_VAR_VALUE("x[0]", x0);
        GET_DEV_VAR_VALUE("y[0]", y0);
        GET_DEV_VAR_VALUE("x[1]", x1);
        GET_DEV_VAR_VALUE("y[1]", y1);
        GET_DEV_VAR_VALUE("x[2]", x2);
        GET_DEV_VAR_VALUE("y[2]", y2);
        GET_DEV_VAR_VALUE("x[3]", x3);
        GET_DEV_VAR_VALUE("y[3]", y3);
        GET_DEV_VAR_VALUE("x[4]", x4);
        GET_DEV_VAR_VALUE("y[4]", y4);
        GET_DEV_VAR_VALUE("x[5]", x5);
        GET_DEV_VAR_VALUE("y[5]", y5);
        GET_DEV_VAR_VALUE("x[6]", x6);
        GET_DEV_VAR_VALUE("y[6]", y6);
        GET_DEV_VAR_VALUE("x[7]", x7);
        GET_DEV_VAR_VALUE("y[7]", y7);
        GET_DEV_VAR_VALUE("x[8]", x8);
        GET_DEV_VAR_VALUE("y[8]", y8);
        GET_DEV_VAR_VALUE("x[9]", x9);
        GET_DEV_VAR_VALUE("y[9]", y9);
        GET_DEV_VAR_VALUE("x[10]", x10);
        GET_DEV_VAR_VALUE("y[10]", y10);

        add_abort_method(action_abort);
        /* Start Kennlinienbertragung */
        DELAY(3,"Transmission of values, please wait..."
                "|de|Werte werden bertragen, bitte warten...");
        iassign(action_code, START_KENNLINIE);
        send_command(132);
        for (param_nr = 24; param_nr < 46; param_nr++)  /* Werte bertragen */
        {
            iassign(static_param_code, param_nr);
            send_command(129);
        }
        iassign(action_code, ENDE_KENNLINIE);       /* Beenden Kennlinienbertragung */
        send_command(132);
        DELAY(3,"Transmission of values finished"
                "|de|bertragen der Werte beendet");
        cnt = 2000;
        do {    /* Status auslesen */
            get_more_status(status,dev_status);
            cnt--;
        } while ((status[STATUS_RESPONSE_CODE] == DEVICE_BUSY) && cnt);

        if (cnt == 0)
        {
            ACKNOWLEDGE("Timeout"
                        "|de|Zeitfehler");
        }
        else
        {
            get_more_status(status,dev_status);
            iassign(static_enums_code1, 90);    /* Nr. fehlerh. Kennl.pkt. */
            iassign(static_enums_code2, 69);    /* Kennl.auswahl */
            iassign(static_enums_code3, 90);
            iassign(static_enums_code4, 90);
            send_command(130);

            if (dev_status[2] & 0x80)   /* Kennlinie allgemein */
            {
                nr = ivar_value(nr_kenn_err);
                acknowledge("Characteristic error point %{nr}"
                            "|de|Kennlinienfehler Punkt %{nr}", ids);
            }

            if (dev_status[3] & 0x02)   /* Kennlinie Monotonie */
            {
                nr = ivar_value(nr_kenn_err);
                acknowledge("Characteristic monotonie error point %{nr}"
                            "|de|Kennlinie Monotoniefehler Punkt %{nr}", ids);
            }

            if (dev_status[3] & 0x04)   /* Kennlinie Steigung */
            {
                nr = ivar_value(nr_kenn_err);
                acknowledge("Characteristic gradient error point %{nr}"
                            "|de|Kennlinie Steigungsfehler Punkt %{nr}", ids);
            }
        }
    }
    HELP "Coordinates for user defined control valve characteristic."
         " \nx[n] = reference variable in % of the respective range."
         " \ny[n] = travel/opening angle in % of the respective range."
         "|de|Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
         "Fhrungsgre und Hub/Drehwinkel."
         " \nx[n] = Fhrungsgre in % des Fhrungsgrenbereichs."
         " \ny[n] = Hub/Drehwinkel in % des Hub-/Drehwinkelbereichs.";
}
#endif
/*----------------------------------------------------------------------------*/
METHOD check_write_protection_before_write        /* auf Schreibschutz prfen */
{
    LABEL "check_write_protection_before_write";
    DEFINITION
    {
        int  HWwrProt;
        int  SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ReadCommand (read_phys_write_locking);       /* SW-Schreibschutz auslesen */
        SWwrProt = ivar_value (phys_write_locking);
        ReadCommand (read_phys_hw_write_protection); /* HW-Schreibschutz auslesen */
        HWwrProt = ivar_value (phys_hw_write_protection);
        if (HWwrProt == 1)       /* wenn HW-Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected (hardware write protection)."
                        "|de|Gert ist schreibgeschtzt (Hardware-Schreibschutz).");
        }
        if (SWwrProt == 0)       /* wenn SW-Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected (software write protection)."
                        "|de|Gert ist schreibgeschtzt (Software-Schreibschutz).");
        }
    }
}
/*----------------------------------------------------------------------------*/
METHOD VERY_SHORT_DELAY_TIME                         /* kurze Zeitverzgerung */
{
    LABEL "Time delay";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX      /* Standardfunktionen */
        DELAY_TIME(1); /* Verzgerung in s ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
METHOD SHORT_DELAY_TIME                              /* kurze Zeitverzgerung */
{
    LABEL "Time delay";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX      /* Standardfunktionen */
        DELAY_TIME(4); /* Verzgerung in s ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
METHOD LONG_DELAY_TIME                               /* lange Zeitverzgerung */
{
    LABEL "Time delay";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX       /* Standardfunktionen */
        DELAY_TIME(8);  /* Verzgerung in s ohne Meldung */
    }
}
/*----------------------------------------------------------------------------*/
METHOD VERY_LONG_DELAY_TIME                          /* lange Zeitverzgerung */
{
    LABEL "Time delay";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX       /* Standardfunktionen */
        DELAY_TIME(20); /* Verzgerung in s ohne Meldung */
    }
}

/******************************************************************************/
/*    MENU Bar (Menleiste)                                                   */
/******************************************************************************/
MENU Menu_Main_Specialist /* Hauptmen Spezialist */
{
    LABEL       [main_menu];
    ITEMS
    {
        Menu_File,             /* Datei    */
        Menu_S_Device,         /* Gert    */
        Menu_View,             /* Ansicht  */
        Menu_S_Options,        /* Extras   */
        Menu_Help              /* Hilfe    */
    }
}

MENU Menu_Main_Maintenance /* Hauptmen Instandhalter */
{
    LABEL       [main_menu];
    ITEMS
    {
        Menu_File,              /* Datei    */
        Menu_M_Device,          /* Gert    */
        Menu_View,              /* Ansicht  */
        Menu_M_Options,         /* Extras   */
        Menu_Help               /* Hilfe    */
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: File (Datei)                                                      */
/*----------------------------------------------------------------------------*/
MENU Menu_File /* Datei */
{
    LABEL       [menu_File];
    ITEMS
    {
        std_Save,            /* Speichern          */
        SEPARATOR,           /* ------------------ */
        std_Eigenschaften,   /* Eigenschaften      */
        SEPARATOR,           /* ------------------ */
        std_Print,           /* Drucken            */
        std_PrintPreview,    /* Seitenansicht      */
        std_PrintSetup,      /* Drucker einrichten */
        std_PageSetup,       /* Seite einrichten   */
        std_Schriftfelder,   /* Schriftfelder      */
        SEPARATOR,           /* ------------------ */
        std_Exit             /* Beenden            */
    }
}

METHOD std_Save
{
    LABEL       [menu_File_Save];
    DEFINITION
    {
    }
}

METHOD SEPARATOR
{
    LABEL       [menu_Separator];
    DEFINITION
    {
    }
}

METHOD std_Eigenschaften
{
    LABEL       [menu_File_Properties];
    DEFINITION
    {
    }
}

METHOD std_Print
{
    LABEL       [menu_File_Print];
    DEFINITION
    {
    }
}

METHOD std_PrintPreview
{
    LABEL       [menu_File_PrintPreview];
    DEFINITION
    {
    }
}

METHOD std_PrintSetup
{
    LABEL       [menu_File_PrintSetup];
    DEFINITION
    {
    }
}

METHOD std_PageSetup
{
    LABEL       [menu_File_PageSetup];
    DEFINITION
    {
    }
}

METHOD std_Schriftfelder
{
    LABEL       [menu_File_Labels];
    DEFINITION
    {
    }
}

METHOD std_Exit
{
    LABEL       [menu_File_Exit];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: Device (Gert)                                                    */
/*----------------------------------------------------------------------------*/
MENU Menu_S_Device /* Gert (Spezialist) */
{
    LABEL       [menu_Device];
    ITEMS
    {
        std_LoadinDevice,                  /* Laden in Gert      */
        std_LoadinPC,                      /* Laden in PG/PC      */
        SEPARATOR,                         /* ------------------- */
        OnlineDialog_operation,            /* Betrieb             */
        OnlineDialog_reset,                /* Rcksetzen          */
        SEPARATOR,                         /* ------------------- */
        OnlineDialog_self_calibration,     /* Selbstkalibrierung  */
        OnlineDialog_diagnosis_options,    /* Auswahl Diagnose    */
        OnlineDialog_write_locking         /* Schreibverriegelung */
        /* kennl_eingabe */                /* Benutzerdefinierte Kennlinie (Methode) */
    }
}

MENU Menu_M_Device /* Gert (Instandhalter) */
{
    LABEL       [menu_Device];
    ITEMS
    {
        std_LoadinDevice,
        std_LoadinPC
    }
}

METHOD std_LoadinDevice
{
    LABEL       [menu_Device_LoadinDevice];
    DEFINITION
    {
    }
}

METHOD std_LoadinPC
{
    LABEL       [menu_Device_LoadinPC];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: View                                                              */
/*----------------------------------------------------------------------------*/
MENU Menu_View /* Ansicht */
{
    LABEL       [menu_View];
    ITEMS
    {
        OnlineWindow_display,        /* Messwertanzeige    */
        OnlineWindow_yt,             /* Kurvenschreiber    */
        OnlineWindow_diagnosis,      /* Gertezustand      */
        SEPARATOR,                   /* ------------------ */
        std_Funktionsleiste,         /* Funktionsleiste    */
        std_Statuszeile,             /* Statuszeile        */
        SEPARATOR,                   /* ------------------ */
        std_Update                   /* Aktualisieren      */
    }
}

METHOD std_Funktionsleiste
{
    LABEL       [menu_View_Toolbar];
    DEFINITION
    {
    }
}

METHOD std_Statuszeile
{
    LABEL       [menu_View_Statusbar];
    DEFINITION
    {
    }
}

METHOD std_Update
{
    LABEL       [menu_View_Update];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: Options                                                           */
/*----------------------------------------------------------------------------*/
MENU Menu_S_Options /* Extras (Spezialist) */
{
    LABEL       [menu_Options];
    ITEMS
    {
        std_Einstellungen,                  /* Einstellungen          */
        std_Untereintraege                  /* Untereintrge anzeigen */
/*      SEPARATOR,    */                      /* ---------------------- */
/*      OfflineDialog_CommErrorHandling */    /* Fehlerbehandlung       */
    }
}

MENU Menu_M_Options /* Extras (Instandhalter) */
{
    LABEL       [menu_Options];
    ITEMS
    {
        std_Einstellungen,                  /* Einstellungen          */
        std_Untereintraege                  /* Untereintrge anzeigen */
    }
}

METHOD std_Einstellungen
{
    LABEL       [menu_Options_Properties];
    DEFINITION
    {
    }
}

METHOD std_Untereintraege
{
    LABEL       [menu_Options_Subitems];
    DEFINITION
    {
    }
}

/*----------------------------------------------------------------------------*/
/*    Menu: Help                                                              */
/*----------------------------------------------------------------------------*/
MENU Menu_Help /* Hilfe */
{
    LABEL       [menu_Help];
    ITEMS
    {
        std_Hilfethemen,            /* Hilfethemen            */
        std_HilfeKontext,           /* Hilfe zum Kontext      */
        SEPARATOR,                  /* ---------------------- */
        std_HilfeGeraet,            /* Hilfe zum Gert        */
		SEPARATOR,
		methodOpenDeviceManual,
        SEPARATOR,                  /* ---------------------- */
        std_HilfeEinfuehrung,       /* Einfhrung             */
        std_HilfeErsteSchritte,     /* Erste Schritte         */
        SEPARATOR,                  /* ---------------------- */
        std_Hilfebenutzen,          /* Hilfe benutzen         */
        std_Info                    /* Info                   */
    }
}

METHOD std_Hilfethemen
{
    LABEL       [menu_Help_Topics];
    DEFINITION
    {
    }
}

METHOD std_HilfeKontext
{
    LABEL       [menu_Help_Context];
    DEFINITION
    {
    }
}

METHOD std_HilfeGeraet
{
    LABEL       [menu_Help_Device];
    DEFINITION
    {
    }
}

METHOD std_HilfeEinfuehrung
{
    LABEL       [menu_Help_Introduction];
    DEFINITION
    {
    }
}

METHOD std_HilfeErsteSchritte
{
    LABEL       [menu_Help_First_Steps];
    DEFINITION
    {
    }
}

METHOD std_Hilfebenutzen
{
    LABEL       [menu_Help_Using];
    DEFINITION
    {
    }
}

METHOD std_Info
{
    LABEL       [menu_Help_Info];
    DEFINITION
    {
    }
}

/******************************************************************************/
/*      Online-Windows                                                        */
/******************************************************************************/
/* Ansicht - Messwertanzeige **************************************************/
MENU OnlineWindow_display
{
    LABEL       [menu_dialog_display];
    ITEMS
    {
        Page_display_measure,
        Page_display_out,
        Page_display_state,
        Page_display_statistic
    }
}

MENU Page_display_measure
{
    LABEL       [menu_dialog_display_measure];
    ITEMS
    {
        Page_group_display_measure_x,
        Page_group_display_measure_w,
        Page_group_display_checkback
    }
}

MENU Page_group_display_measure_x
{
    LABEL       "";
    ITEMS
    {
        Val_pv,           /* Grossanzeige */
        Bar_pv_display,   /* Bargraph    */
        func1_readback_status,
        func1_readback_status_limit,
        SEPARATOR,
        func1_setpoint_deviation,
        func1_position_discrete_value
    }
}

MENU Page_group_display_measure_w
{
    LABEL       "";
    ITEMS
    {
        Val_sp,          /* Grossanzeige */
        Bar_sp_display,  /* Bargraph    */
        func1_setpoint_status           (READ_ONLY),
        func1_setpoint_status_limit     (READ_ONLY),
        SEPARATOR,
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU Page_group_display_checkback
{
    LABEL       "";
    ITEMS
    {
        func1_check_back
    }
}

MENU Bar_pv_display /* Bargraph */
{
    LABEL       " ";
    ITEMS
    {
        func1_readback_value,
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU Bar_sp_display /* Bargraph */
{
    LABEL       " ";
    ITEMS
    {
        func1_setpoint_value            (READ_ONLY),
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU Val_pv /* Grossanzeige */
{
    LABEL     "Controlled variable X"
              "|de|Regelgre X";
    ITEMS
    {
        func1_readback_value
    }
}

MENU Val_sp /* Grossanzeige */
{
    LABEL     "Reference variable W"
              "|de|Fhrungsgre W";
    ITEMS
    {
        func1_setpoint_value
    }
}

MENU Page_display_out
{
    LABEL       [menu_dialog_display_output];
    ITEMS
    {
        Page_group_display_out
    }
}

MENU Page_group_display_out
{
    LABEL       "";
    ITEMS
    {
        Bar_out_display,    /* Bargraph    */
        func1_out_value                 (READ_ONLY),
        func1_out_status_quality        (READ_ONLY),
        func1_out_status_limit          (READ_ONLY),
        func1_out_lower_range_value     (READ_ONLY),
        func1_out_upper_range_value     (READ_ONLY),
        func1_check_back
    }
}

MENU Bar_out_display /* Bargraph */
{
    LABEL       [func_out_value];
    ITEMS
    {
        func1_out_value                 (READ_ONLY),
        func1_out_lower_range_value     (READ_ONLY),
        func1_out_upper_range_value     (READ_ONLY)
    }
}

MENU Page_display_state
{
    LABEL       [limit_state];
    ITEMS
    {
        Page_group_display_state
    }
}

MENU Page_group_display_state
{
    LABEL       "";
    ITEMS
    {
       trans1_binary_input,
       func1_check_back,
       phys_diagnosis,
       phys_diagnosis_extension,
       func1_actual_mode,
       trans1_transducer_state
    }
}

MENU Page_display_statistic
{
    LABEL       [menu_dialog_display_statistic];
    ITEMS
    {
        Page_group_display_statistic
    }
}

MENU Page_group_display_statistic
{
    LABEL       "";
    ITEMS
    {
        trans1_total_valve_travel,
        trans1_total_valve_travel_limit (READ_ONLY)
    }
}

/* Ansicht - y-t Diagram *****************************************************/
MENU OnlineWindow_yt
{
    LABEL       [menu_yt_diagram] ;
    ITEMS
    {
            Page_process_yt
    }
}

MENU Page_process_yt
{
    LABEL       [menu_yt_diagram] ;
    ITEMS
    {
        Val_yt,
        Val_yt_2,
        OCX_out_display_yt
    }
}

MENU Val_yt
{
    LABEL   "Controlled variable X"
            "|de|Regelgre X";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
            func1_readback_value (READ_ONLY)
    }
}

MENU Val_yt_2
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
            func1_setpoint_value (READ_ONLY)
    }
}

MENU OCX_out_display_yt                             /* OCX-Control */
{
    LABEL       [menu_yt_diagram] ;
    STYLE       "PDMTVPROXY.PDMTVProxyCtrl.1";      /* Name, unter dem das OCX in Windows registriert ist */
    ITEMS
    {
        OCX_ProfilNum_yt,                           /* Profil-Nummer */
        OCX_out_display_1,                          /* 1. Kurve */
        OCX_out_display_2,                          /* 2. Kurve */
        OCX_UserSettings_yt /* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
    }
}

MENU OCX_out_display_1                              /* 1. Kurve im OCX-Control yt */
{
    LABEL   "Controlled variable X"
            "|de|Regelgre X";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
        func1_readback_value            (READ_ONLY),
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

MENU OCX_out_display_2                              /* 1. Kurve im OCX-Control yt */
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

    STYLE       "OCX_DYNAMIC_YT";
    ITEMS
    {
        func1_setpoint_value            (READ_ONLY),
        func1_pv_lower_range_value      (READ_ONLY),
        func1_pv_upper_range_value      (READ_ONLY)
    }
}

VARIABLE OCX_ProfilNum_yt                           /* Profil-Variable fr OCX yt */
{
    LABEL       "ProfilID";
    STYLE       "OCX_PROPERTY";
    CLASS       LOCAL;
    TYPE        INTEGER(2)
    {
        DEFAULT_VALUE   0;                          /* Profil 0 fr normale y-t-Darstellung */
    }
    HANDLING    READ;
}

/* Fr Speicherung von Einstellungen, die vom Benutzer zur Laufzeit gendert wurden */
VARIABLE OCX_UserSettings_yt
{
    LABEL       "UserSettings";
    STYLE       "OCX_PROPERTY";
    CLASS       LOCAL;
    TYPE        ASCII (1000)
    {
        DEFAULT_VALUE   "";
    }
    HANDLING    READ & WRITE;
}

/* Ansicht - Gertezustand ***************************************************/
MENU OnlineWindow_diagnosis
{
    LABEL       [menu_dialog_diagnosis];
    ITEMS
    {
        Page_diagnosis_general,
        Page_diagnosis_phys_block,
        Page_diagnosis_trans_block,
        Page_diagnosis_func_block
    }
}

MENU Page_diagnosis_general
{
    LABEL       [menu_dialog_general];
    ITEMS
    {
        Page_group_diagnosis_general
    }
}

MENU Page_group_diagnosis_general
{
    LABEL       "";
    ITEMS
    {
        phys_tag_desc             (READ_ONLY),
        phys_device_man_id,
        phys_device_id,
        phys_serial_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_device_instal_date   (READ_ONLY),
        phys_diagnosis,
        func1_check_back
    }
}

MENU Page_diagnosis_phys_block
{
    LABEL       [blk_block_object_PHYSICAL];
    ITEMS
    {
        Page_group_diagnosis_phys_block
    }
}

MENU Page_group_diagnosis_phys_block
{
    LABEL       "";
    ITEMS
    {
        phys_blk_object,
        phys_blk_parent_class,
        phys_blk_class,
        phys_blk_dd_reference,
        phys_blk_dd_rev,
        phys_blk_profile,
        phys_blk_profile_rev,
        phys_st_rev,
        phys_actual_mode
    }
}

MENU Page_diagnosis_trans_block
{
    LABEL       [blk_block_object_TRANSDUCER];
    ITEMS
    {
        Page_group_diagnosis_trans_block
    }
}

MENU Page_group_diagnosis_trans_block
{
    LABEL       "";
    ITEMS
    {
        trans1_blk_object,
        trans1_blk_parent_class,
        trans1_blk_class,
        trans1_blk_dd_reference,
        trans1_blk_dd_rev,
        trans1_blk_profile,
        trans1_blk_profile_rev,
        trans1_st_rev,
        trans1_actual_mode
    }
}

MENU Page_diagnosis_func_block
{
    LABEL       [blk_block_object_FUNCTION];
    ITEMS
    {
        Page_group_diagnosis_func_block
    }
}

MENU Page_group_diagnosis_func_block
{
    LABEL       "";
    ITEMS
    {
        func1_blk_object,
        func1_blk_parent_class,
        func1_blk_class,
        func1_blk_dd_reference,
        func1_blk_dd_rev,
        func1_blk_profile,
        func1_blk_profile_rev,
        func1_st_rev,
        func1_actual_mode
    }
}

/******************************************************************************/
/*      Online-Dialogs                                                        */
/******************************************************************************/
/* Gert - Betrieb ***********************************************************/
MENU OnlineDialog_operation
{
    LABEL       [menu_dialog_operation];
    ITEMS
    {
        Page_operation_AUTO,
        Page_operation_RCAS,
        Page_operation_LO,
        Page_operation_TRD,
        Page_simulation
    }
}

MENU Page_operation_AUTO
{
    LABEL       [mode_AUTO];
    ITEMS
    {
        Page_group_operation_AUTO
    }
}

MENU Page_group_operation_AUTO
{
    LABEL       "";
    ITEMS
    {
        func1_target_mode,
        func1_actual_mode,
        func1_setpoint_value,
        func1_setpoint_status,
        func1_setpoint_status_limit,
        func1_readback_value,
        func1_readback_status,
        func1_readback_status_limit,
        func1_setpoint_deviation,
        func1_check_back
    }
}

MENU Page_operation_RCAS
{
    LABEL       [mode_RCAS];
    ITEMS
    {
        func1_target_mode,
        func1_actual_mode,
        func1_rcas_in_value,
        func1_rcas_in_status,
        func1_rcas_out_value            (READ_ONLY),
        func1_rcas_out_status_quality   (READ_ONLY),
        func1_rcas_out_status_limit     (READ_ONLY),
        trans1_positioning_value,
        trans1_positioning_status,
        trans1_feedback_value,
        trans1_feedback_status,
        func1_setpoint_deviation,
        func1_check_back
    }
}

MENU Page_operation_LO
{
    LABEL   "MAN / Local Override"
            "|de|MAN / Lokale berlagerung";
    ITEMS
    {
        Page_group_operation_LO
    }
}

MENU Page_group_operation_LO
{
    LABEL       "";
    ITEMS
    {
        func1_target_mode,
        func1_actual_mode,
        func1_out_value,
        func1_out_status_quality,
        func1_readback_value,
        func1_readback_status,
        func1_setpoint_deviation,
        func1_check_back
    }
}

MENU Page_operation_TRD
{
    LABEL   "Mode transducer"
            "|de|Betriebsart Transducer";
    ITEMS
    {
        Page_group_operation_TRD
    }
}

MENU Page_group_operation_TRD
{
    LABEL       "";
    ITEMS
    {
        trans1_target_mode,
        trans1_actual_mode,
        trans1_positioning_value,
        trans1_positioning_status,
        trans1_feedback_value,
        trans1_feedback_status
    }
}

MENU Page_simulation
{
    LABEL       [menu_dialog_simulation];
    ITEMS
    {
        Page_group_operation_simulation
    }
}

MENU Page_group_operation_simulation
{
    LABEL       "";
    ITEMS
    {
        func1_simulate_enabled,
        func1_simulate_value,
        func1_simulate_status_quality,
        func1_simulate_status_limit
    }
}

/* Gert - Rcksetzen ********************************************************/
MENU OnlineDialog_reset
{
    LABEL       [master_reset];
    ITEMS
    {
        Page_reset_maintenance,
        Page_reset_device,
        Page_reset_factory
    }
    HELP        [master_reset_help];
}

MENU Page_reset_maintenance
{
    LABEL       "Reset maintenance message"
                "|de|Rcksetzen Wartungsmeldung";
    ITEMS
    {
        Page_group_reset_maintenance
    }
}

MENU Page_group_reset_maintenance
{
    LABEL       "";
    ITEMS
    {
        func1_check_back,
        phys_diagnosis,
        trans1_total_valve_travel,
        wegint_reset,
        rk_stoer_reset
    }
}

MENU Page_reset_device
{
    LABEL       [phys_device_reset_cmd];
    ITEMS
    {
        Page_group_reset_device
    }
}

MENU Page_group_reset_device
{
    LABEL       "";
    ITEMS
    {
        func1_check_back,
        phys_diagnosis,
        warmstart
    }
}

MENU Page_reset_factory
{
    LABEL       [phys_factory_reset];
    ITEMS
    {
        Page_group_reset_factory
    }
}

MENU Page_group_reset_factory
{
    LABEL       "";
    ITEMS
    {
        func1_check_back,
        phys_diagnosis,
        coldstart_appl,
        coldstart_ident,
        coldstart_appl_ident,
        reset_busadr
    }
}

/* Gert - Diagnose Optionen *************************************************/
MENU OnlineDialog_diagnosis_options
{
    LABEL   "Selection Device Messages"
            "|de|Auswahl Gertemeldungen";
    ITEMS
    {
        Page_diagnosis_options
    }
    HELP    "Activation or deactivation of diagnosis and device status messages."
            "|de|Aktivieren oder Deaktivieren der Meldungen fr Diagnose und Gertestatus.";
}

MENU Page_diagnosis_options
{
    LABEL   "Selection Device Messages"
            "|de|Auswahl Gertemeldungen";
    ITEMS
    {
        Page_group_diagnosis_options
    }
}

MENU Page_group_diagnosis_options
{
    LABEL       "";
    ITEMS
    {
        phys_diagnosis_opt_1,
        phys_diagnosis_opt_2,
        func1_check_back_opt
    }
}

/* Gert - Selbstkalibrierung ************************************************/
MENU OnlineDialog_self_calibration
{
    LABEL       [trans_act_self_calibration_cmd];
    ITEMS
    {
        Page_self_calibration
    }
    HELP        [trans_act_self_calibration_cmd_help];
}

MENU Page_self_calibration
{
    LABEL       [trans_act_self_calibration_cmd];
    ITEMS
    {
        Page_group_self_calibration
    }
}

MENU Page_group_self_calibration
{
    LABEL       "";
    ITEMS
    {
        trans1_self_calibration_status,
        trans1_self_calib_warning,
        func1_check_back,
        phys_diagnosis,
        abort_initialization, /* Methode */
        cal_zero_valve,       /* Methode */
        init_valve            /* Methode */
    }
}

/* Gert - Schreibverriegelung ***********************************************/
MENU OnlineDialog_write_locking
{
	LABEL		[phys_write_locking];
	HELP		[phys_write_locking_help];
	ITEMS
	{
		phys_write_locking,         /* Software-Schreibschutz */
		phys_hw_write_protection    /* Zustand Schreibschutzschalter */
	}
}

/******************************************************************************/
/*    Table: Specialist (Parametertabelle fr Spezialistenebene)              */
/******************************************************************************/
MENU Table_Main_Specialist
{
    LABEL   "SAMSON Positioner Type 3785 (PA-Profile 3)"
            "|de|SAMSON Stellungsregler Typ 3785 (PA-Profil 3)";
    ITEMS
    {
        Tab_s_ident,
        Tab_s_input,
        Tab_s_charact,
        Tab_s_adjustment,
        Tab_s_interface,
        Tab_s_certificates
    }
}

/* Identifikation ************************************************************/
MENU Tab_s_ident
{
    LABEL       [menu_ident];

    ITEMS
    {
        Tab_s_ident_opunit,
        Tab_s_ident_device,
        Tab_s_ident_batch
    }
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_s_ident_opunit
{
    LABEL       [menu_ident_opunit];
    ITEMS
    {
        phys_tag_desc,
        phys_descriptor,
        phys_device_message,
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3
    }
}

/* Identifikation - Gert ****************************************************/
MENU Tab_s_ident_device
{
    LABEL       [menu_ident_device];
    ITEMS
    {
        Tab_s_ident_device_positioner,
        Tab_s_ident_device_actuator,
        Tab_s_ident_device_valve,
        Tab_s_ident_device_gear
    }
}

/* Identifikation - Batch ****************************************************/
MENU Tab_s_ident_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
        func1_batch_id,
        func1_batch_unit,
        func1_batch_operation,
        func1_batch_phase
    }
}

/* Identifikation - Gert - Stellungsregler **********************************/
MENU Tab_s_ident_device_positioner
{
    LABEL       [menu_ident_device_positioner];
    ITEMS
    {
        func1_tag_desc,
        trans1_tag_desc,
        phys_device_man_id,
        phys_serial_num,
        phys_device_product_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_device_instal_date,
        phys_ident_number_selector,
        phys_st_rev
    }
}

/* Identifikation - Gert - Stellantrieb *************************************/
MENU Tab_s_ident_device_actuator
{
    LABEL       [menu_ident_device_actuator];
    ITEMS
    {
        trans1_actuator_man,
        trans1_actuator_type,
        trans1_actuator_serial_number
    }
}

/* Identifikation - Gert - Stellglied ***************************************/
MENU Tab_s_ident_device_valve
{
    LABEL       [menu_ident_device_valve];
    ITEMS
    {
        trans1_valve_man,
        trans1_valve_serial_number,
        trans1_valve_type            (READ_ONLY),
        trans1_rated_travel          (READ_ONLY)
    }
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_s_ident_device_gear
{
    LABEL       [menu_ident_device_addition];
    ITEMS
    {
        phys_ident_binary_input,
        phys_ident_limit_switches,
        phys_ident_forced_venting,
        trans1_additional_gear_install_date,
        trans1_additional_gear_id,
        trans1_additional_gear_man,
        trans1_additional_gear_ser_number,
        phys_hw_write_protection,
        phys_write_locking     (READ_ONLY)
    }
}

/* Eingang - *****************************************************************/
MENU Tab_s_input
{
    LABEL       [menu_input];
    ITEMS
    {
        Tab_s_input_input,
        Tab_s_input_workrange,
        Tab_s_input_table
    }
}

/* Eingang - Eingangsgrsse ***************************************************/
MENU Tab_s_input_input
{
	LABEL		"Reference variable"
	            "|de|Fhrungsgre";
    ITEMS
    {
        func1_increase_close,
        func1_pv_lower_range_value,
        func1_pv_upper_range_value,
        func1_pv_unit,
        trans1_setp_cutoff_dec,
        trans1_setp_cutoff_inc
    }
}

/* Eingang - Arbeitsbereich **************************************************/
MENU Tab_s_input_workrange
{
    LABEL       [menu_input_workrange];
    ITEMS
    {
        func1_out_lower_range_value,
        func1_out_upper_range_value,
        func1_out_unit,
        trans1_travel_limit_lower_value,
        trans1_travel_limit_upper_value
    }
}

/* Eingang - Kennlinie *******************************************************/
MENU Tab_s_input_table
{
    LABEL       [menu_input_table];
    ITEMS
    {
        trans1_lin_type /* ,
kmr: spaeter        Tab_s_input_table_usertable */
    }
}

/* Eingang - Kennlinie - Benutzerdefinierte Kennlinie ************************/
/*
MENU Tab_s_input_table_usertable
{
    LABEL   "User defined characterization"
            "|de|Benutzerdefinierte Kennlinie";
    ITEMS
    {
        trans1_charact_type,
        x0   (READ_ONLY),
        x1   (READ_ONLY),
        x2   (READ_ONLY),
        x3   (READ_ONLY),
        x4   (READ_ONLY),
        x5   (READ_ONLY),
        x6   (READ_ONLY),
        x7   (READ_ONLY),
        x8   (READ_ONLY),
        x9   (READ_ONLY),
        x10  (READ_ONLY),
        y0   (READ_ONLY),
        y1   (READ_ONLY),
        y2   (READ_ONLY),
        y3   (READ_ONLY),
        y4   (READ_ONLY),
        y5   (READ_ONLY),
        y6   (READ_ONLY),
        y7   (READ_ONLY),
        y8   (READ_ONLY),
        y9   (READ_ONLY),
        y10  (READ_ONLY)
    }
}
*/

/* Kennwerte - ***************************************************************/
MENU Tab_s_charact
{
    LABEL       [menu_charact];
    ITEMS
    {
        trans1_deadband,
        trans1_servo_gain_1,
        trans1_servo_gain_2,
        trans1_servo_rate_1,
        trans1_tol_overshoot,
        Tab_s_charact_powerloss,
        Tab_s_charact_traveltime,
        Tab_s_charact_error
    }
}

/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_s_charact_powerloss
{
    LABEL       [menu_charact_powerloss];
    ITEMS
    {
        trans1_actuator_action,
        func1_fsafe_type,
        func1_fsafe_time,
        func1_fsafe_value
    }
}

/* Kennwerte - Laufzeit *****************************************************/
MENU Tab_s_charact_traveltime
{
    LABEL       "Stroke Time"
                "|de|Laufzeit";
    ITEMS
    {
        trans1_act_stroke_time_dec,
        trans1_act_stroke_time_inc,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc
    }
}

/* Kennwerte - Fehlerberwachung *********************************************/
MENU Tab_s_charact_error
{
    LABEL       "Error monitoring"
                "|de|Fehlerberwachung";
    ITEMS
    {
        trans1_tolerance_band,
        trans1_delay_time,
        trans1_total_valve_travel,
        trans1_total_valve_travel_limit
    }
}

/* Inbetriebnahme ************************************************************/
MENU Tab_s_adjustment
{
    LABEL       "Adjustment"
                "|de|Inbetriebnahme";
    ITEMS
    {
       trans1_valve_type,
       trans1_attachment,
       trans1_actuator_version,
       trans1_rated_travel,
       trans1_transm_code_value,
       trans1_transm_length,
       trans1_transm_pin_pos,
       trans1_init_method,
       trans1_mounting_position,
       trans1_self_calib_warning,
       trans1_actuator_action,
       trans1_act_stroke_time_dec,
       trans1_act_stroke_time_inc,
       trans1_max_hub,
       func1_in_channel,
       func1_out_channel
    }
}

/* Anzeige- und Bedienoberflche *********************************************/
MENU Tab_s_interface
{
    LABEL       [menu_interface];
    ITEMS
    {
        phys_local_operation_enable,
        Tab_s_interface_maintenance,
        Tab_s_interface_simulate
    }
}

/* Anzeige- und Bedienoberflche - Wartung ***********************************/
MENU Tab_s_interface_maintenance
{
    LABEL       [menu_interface_maintenance];
    ITEMS
    {
        trans1_device_calib_date,
        trans1_device_config_date,
        trans1_valve_maintenance_date
    }
}

/* Anzeige- und Bedienoberflche - Simulation ********************************/
MENU Tab_s_interface_simulate
{
    LABEL       [menu_interface_simulate];
    ITEMS
    {
        func1_simulate_enabled          (READ_ONLY),
        func1_simulate_value            (READ_ONLY),
        func1_simulate_status_quality   (READ_ONLY),
        func1_simulate_status_limit     (READ_ONLY)
    }
}

/* Zertifikate und Zulassungen ***********************************************/
MENU Tab_s_certificates
{
    LABEL       [menu_certificates];
    ITEMS
    {
        phys_device_certification
    }
}

/*******************************************************************************/
/*     Table: Maintenance (Parametertabelle fr Instandhalterebene)            */
/*******************************************************************************/
MENU Table_Main_Maintenance
{
    LABEL   "SAMSON Positioner Type 3785 (PA-Profile 3)"
            "|de|SAMSON Stellungsregler Typ 3785 (PA-Profil 3)";
    ITEMS
    {
        Tab_m_ident,
        Tab_m_input,
        Tab_m_charact,
        Tab_m_certificates
    }
}

/* Identifikation ************************************************************/
MENU Tab_m_ident
{
    LABEL       [menu_ident];
    ITEMS
    {
        Tab_m_ident_opunit,
        Tab_m_ident_device,
        Tab_m_ident_batch
    }
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_m_ident_opunit
{
    LABEL       [menu_ident_opunit];
    ITEMS
    {
        phys_tag_desc,
        phys_descriptor,
        phys_device_message,
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3
    }
}

/* Identifikation - Gert ****************************************************/
MENU Tab_m_ident_device
{
    LABEL       [menu_ident_device];
    ITEMS
    {
        Tab_m_ident_device_positioner,
        Tab_m_ident_device_actuator,
        Tab_m_ident_device_valve,
        Tab_m_ident_device_gear
    }
}

/* Identifikation - Batch ****************************************************/
MENU Tab_m_ident_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
        func1_batch_id,
        func1_batch_unit,
        func1_batch_operation,
        func1_batch_phase
    }
}

/* Identifikation - Gert - Stellungsregler **********************************/
MENU Tab_m_ident_device_positioner
{
    LABEL       [menu_ident_device_positioner];
    ITEMS
    {
        phys_device_man_id,
        phys_serial_num,
        phys_device_product_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_device_instal_date,
        phys_st_rev
    }
}

/* Identifikation - Gert - Stellantrieb *************************************/
MENU Tab_m_ident_device_actuator
{
    LABEL       [menu_ident_device_actuator];
    ITEMS
    {
        trans1_actuator_man          (READ_ONLY),
        trans1_actuator_type         (READ_ONLY),
        trans1_actuator_serial_number
    }
}

/* Identifikation - Gert - Stellglied ***************************************/
MENU Tab_m_ident_device_valve
{
    LABEL       [menu_ident_device_valve];
    ITEMS
    {
        trans1_valve_man          (READ_ONLY),
        trans1_valve_serial_number,
        trans1_valve_type         (READ_ONLY),
        trans1_attachment         (READ_ONLY),
        trans1_actuator_version   (READ_ONLY),
        trans1_rated_travel       (READ_ONLY),
        trans1_transm_code_value  (READ_ONLY),
        trans1_transm_length      (READ_ONLY),
        trans1_transm_pin_pos     (READ_ONLY),
        trans1_mounting_position  (READ_ONLY),
        trans1_actuator_action
    }
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_m_ident_device_gear
{
    LABEL       [menu_ident_device_addition];
    ITEMS
    {
        phys_ident_binary_input   (READ_ONLY),
        phys_ident_limit_switches (READ_ONLY),
        phys_ident_forced_venting,
        phys_hw_write_protection,
        trans1_additional_gear_install_date,
        trans1_additional_gear_id,
        trans1_additional_gear_man,
        trans1_additional_gear_ser_number
    }
}

/* Eingang - *****************************************************************/
MENU Tab_m_input
{
    LABEL       [menu_input];
    ITEMS
    {
        Tab_m_input_input,
        Tab_m_input_workrange,
        Tab_m_input_table
    }
}

/* Eingang - Eingangsgrsse **************************************************/
MENU Tab_m_input_input
{
	LABEL		"Reference variable"
	            "|de|Fhrungsgre";
    ITEMS
    {
        func1_increase_close,
        func1_pv_lower_range_value,
        func1_pv_upper_range_value,
        func1_pv_unit
    }
}

/* Eingang - Arbeitsbereich **************************************************/
MENU Tab_m_input_workrange
{
    LABEL       [menu_input_workrange];
    ITEMS
    {
        func1_out_lower_range_value,
        func1_out_upper_range_value,
        func1_out_unit,
        trans1_travel_limit_lower_value,
        trans1_travel_limit_upper_value
    }
}

/* Eingang - Kennlinie *******************************************************/
MENU Tab_m_input_table
{
    LABEL       [menu_input_table];
    ITEMS
    {
        trans1_lin_type /* ,
kmr: spaeter    Tab_s_input_table_usertable */
    }
}

/* Kennwerte *****************************************************************/
MENU Tab_m_charact
{
    LABEL       [menu_charact];
    ITEMS
    {
        Tab_m_charact_powerloss
    }
}

/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_m_charact_powerloss
{
    LABEL       [menu_charact_powerloss];
    ITEMS
    {
        trans1_actuator_action
    }
}

/* Zertifikate und Zulassungen ***********************************************/
MENU Tab_m_certificates
{
    LABEL       [menu_certificates];
    ITEMS
    {
        phys_device_certification
    }
}

/******************************************************************************/
/*      Communication Error Handling                                          */
/******************************************************************************/
VARIABLE CommError_0000_009F
{
    LABEL       [comm_err_dp_error_reserved];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_error_reserved_help];
}

VARIABLE CommError_00A0_00A0
{
    LABEL       [comm_err_dp_read_error];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_read_error_help];
}

VARIABLE CommError_00A1_00A1
{
    LABEL       [comm_err_dp_write_error];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_write_error_help];
}

VARIABLE CommError_00A2_00A2
{
    LABEL       [comm_err_dp_module_failure];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_module_failure_help];
}

VARIABLE CommError_00A3_00A7
{
    LABEL       [comm_err_dp_application_reserved];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_application_reserved_help];
}

VARIABLE CommError_00A8_00A8
{
    LABEL       [comm_err_dp_version_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_version_conflict_help];
}

VARIABLE CommError_00A9_00A9
{
    LABEL       [comm_err_dp_feature_not_supported];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_feature_not_supported_help];
}

VARIABLE CommError_00AA_00AF
{
    LABEL       [comm_err_dp_application_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_application_user_specific_help];
}

VARIABLE CommError_00B0_00B0
{
    LABEL       [comm_err_dp_invalid_index];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_index_help];
}

VARIABLE CommError_00B1_00B1
{
    LABEL       [comm_err_dp_write_length_error];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_write_length_error_help];
}

VARIABLE CommError_00B2_00B2
{
    LABEL       [comm_err_dp_invalid_slot];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_slot_help];
}

VARIABLE CommError_00B3_00B3
{
    LABEL       [comm_err_dp_type_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_type_conflict_help];
}

VARIABLE CommError_00B4_00B4
{
    LABEL       [comm_err_dp_invalid_area];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_area_help];
}

VARIABLE CommError_00B5_00B5
{
    LABEL       [comm_err_dp_state_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_state_conflict_help];
}

VARIABLE CommError_00B6_00B6
{
    LABEL       [comm_err_dp_access_denied];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_access_denied_help];
}

VARIABLE CommError_00B7_00B7
{
    LABEL       [comm_err_dp_invalid_range];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_range_help];
}

VARIABLE CommError_00B8_00B8
{
    LABEL       [comm_err_dp_invalid_parameter];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_parameter_help];
}

VARIABLE CommError_00B9_00B9
{
    LABEL       [comm_err_dp_invalid_type];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_type_help];
}

VARIABLE CommError_00BA_00BF
{
    LABEL       [comm_err_dp_access_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_access_user_specific_help];
}

VARIABLE CommError_00C0_00C0
{
    LABEL       [comm_err_dp_read_constrain_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_read_constrain_conflict_help];
}

VARIABLE CommError_00C1_00C1
{
    LABEL       [comm_err_dp_write_constrain_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_write_constrain_conflict_help];
}

VARIABLE CommError_00C2_00C2
{
    LABEL       [comm_err_dp_resource_busy];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_resource_busy_help];
}

VARIABLE CommError_00C3_00C3
{
    LABEL       [comm_err_dp_resource_unavailable];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_resource_unavailable_help];
}

VARIABLE CommError_00C4_00C7
{
    LABEL       [comm_err_dp_resource_reserved];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_resource_reserved_help];
}

VARIABLE CommError_00C8_00CF
{
    LABEL       [comm_err_dp_recource_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_recource_user_specific_help];
}

VARIABLE CommError_00D0_00FF
{
    LABEL       [comm_err_dp_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_user_specific_help];
}

VARIABLE CommError_ShowIgnoredErrors
{
    LABEL       [comm_show_ignored_errors];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [comm_show_ignored_errors_NOT_SHOW]    },
        { 1, [comm_show_ignored_errors_SHOW]        }
    }
    HELP        [comm_show_ignored_errors_help];
}

VARIABLE CommError_Delay_Read
{
    LABEL       [comm_delay_read];
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE   0;
    }
    CONSTANT_UNIT   [msec];
    HELP        [comm_delay_read_help];
}

VARIABLE CommError_Delay_Write
{
    LABEL       [comm_delay_write];
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE   0;
    }
    CONSTANT_UNIT   [msec];
    HELP        [comm_delay_write_help];
}

MENU Menu_CommError
{
    LABEL   " ";
    ITEMS
    {
        CommError_0000_009F,            /* DP Error Reserved                            */
        CommError_00A0_00A0,            /* Application: DP Read Error                   */
        CommError_00A1_00A1,            /* Application: DP Write Error                  */
        CommError_00A2_00A2,            /* Application: DP Module Failure               */
        CommError_00A3_00A7,            /* Application: DP Application Reserved         */
        CommError_00A8_00A8,            /* Application: DP Version Conflict             */
        CommError_00A9_00A9,            /* Application: DP Feature Not Supported        */
        CommError_00AA_00AF,            /* Application: DP Application User Specific    */
        CommError_00B0_00B0,            /* Access:      DP Invalid Index                */
        CommError_00B1_00B1,            /* Access:      DP Write Length Error           */
        CommError_00B2_00B2,            /* Access:      DP Invalid Slot                 */
        CommError_00B3_00B3,            /* Access:      DP Type Conflict                */
        CommError_00B4_00B4,            /* Access:      DP Invalid Area                 */
        CommError_00B5_00B5,            /* Access:      DP State Conflict               */
        CommError_00B6_00B6,            /* Access:      DP Access Denied                */
        CommError_00B7_00B7,            /* Access:      DP Invalid Range                */
        CommError_00B8_00B8,            /* Access:      DP Invalid Parameter            */
        CommError_00B9_00B9,            /* Access:      DP Invalid Type                 */
        CommError_00BA_00BF,            /* Access:      DP Access User Specific         */
        CommError_00C0_00C0,            /* Resource:    DP Read Constrain Conflict      */
        CommError_00C1_00C1,            /* Resource:    DP Write Constrain Conflict     */
        CommError_00C2_00C2,            /* Resource:    DP Resource Busy                */
        CommError_00C3_00C3,            /* Resource:    DP Resource unavailable         */
        CommError_00C4_00C7,            /* Resource:    DP Resource Reserved            */
        CommError_00C8_00CF,            /* Resource:    DP Recource User Specific       */
        CommError_00D0_00FF             /* DP User Specific                             */
    }
}

MENU Menu_CommError_Delay
{
    LABEL   " ";
    ITEMS
    {
        CommError_Delay_Read,
        CommError_Delay_Write
    }
}


MENU OfflineDialog_CommErrorHandling
{
    LABEL   [menu_dialog_error_handling];
    ITEMS
    {
        Page_CommError_General  /*,
        Page_CommError_Application,
        Page_CommError_Access,
        Page_CommError_Resource,
        Page_CommError_Other    */
    }
}

MENU Page_CommError_General
{
    LABEL   [menu_dialog_general];
    ITEMS
    {
        CommError_Delay_Read,
        CommError_Delay_Write,
/*      CommError_ShowIgnoredErrors,    */
        CommError_DefaultHandling   /*,
        CommError_CheckAllErrors,
        CommError_IgnoreAllErrors   */
    }
}

MENU Page_CommError_Application
{
    LABEL   [menu_dialog_error_handling_application];
    ITEMS
    {
        CommError_00A0_00A0,    /* Application: DP Read Error                   */
        CommError_00A1_00A1,    /* Application: DP Write Error                  */
        CommError_00A2_00A2,    /* Application: DP Module Failure               */
        CommError_00A3_00A7,    /* Application: DP Application Reserved         */
        CommError_00A8_00A8,    /* Application: DP Version Conflict             */
        CommError_00A9_00A9,    /* Application: DP Feature Not Supported        */
        CommError_00AA_00AF     /* Application: DP Application User Specific    */
    }
}

MENU Page_CommError_Access
{
    LABEL   [menu_dialog_error_handling_access];
    ITEMS
    {
        CommError_00B0_00B0,    /* Access:      DP Invalid Index                */
        CommError_00B1_00B1,    /* Access:      DP Write Length Error           */
        CommError_00B2_00B2,    /* Access:      DP Invalid Slot                 */
        CommError_00B3_00B3,    /* Access:      DP Type Conflict                */
        CommError_00B4_00B4,    /* Access:      DP Invalid Area                 */
        CommError_00B5_00B5,    /* Access:      DP State Conflict               */
        CommError_00B6_00B6,    /* Access:      DP Access Denied                */
        CommError_00B7_00B7,    /* Access:      DP Invalid Range                */
        CommError_00B8_00B8,    /* Access:      DP Invalid Parameter            */
        CommError_00B9_00B9,    /* Access:      DP Invalid Type                 */
        CommError_00BA_00BF     /* Access:      DP Access User Specific         */
    }
}

MENU Page_CommError_Resource
{
    LABEL   [menu_dialog_error_handling_resource];
    ITEMS
    {
        CommError_00C0_00C0,    /* Resource:    DP Read Constrain Conflict      */
        CommError_00C1_00C1,    /* Resource:    DP Write Constrain Conflict     */
        CommError_00C2_00C2,    /* Resource:    DP Resource Busy                */
        CommError_00C3_00C3,    /* Resource:    DP Resource unavailable         */
        CommError_00C4_00C7,    /* Resource:    DP Resource Reserved            */
        CommError_00C8_00CF     /* Resource:    DP Recource User Specific       */
    }
}

MENU Page_CommError_Other
{
    LABEL   [menu_dialog_error_handling_other];
    ITEMS
    {
        CommError_0000_009F,
        CommError_00D0_00FF
    }
}

METHOD  CommError_IgnoreAllErrors
{
    LABEL       [comm_ignore_all_errors];
    DEFINITION
    {
        iassign(CommError_0000_009F, 0);    /* DP Error Reserved                            */
        iassign(CommError_00A0_00A0, 0);    /* Application: DP Read Error                   */
        iassign(CommError_00A1_00A1, 0);    /* Application: DP Write Error                  */
        iassign(CommError_00A2_00A2, 0);    /* Application: DP Module Failure               */
        iassign(CommError_00A3_00A7, 0);    /* Application: DP Application Reserved         */
        iassign(CommError_00A8_00A8, 0);    /* Application: DP Version Conflict             */
        iassign(CommError_00A9_00A9, 0);    /* Application: DP Feature Not Supported        */
        iassign(CommError_00AA_00AF, 0);    /* Application: DP Application User Specific    */
        iassign(CommError_00B0_00B0, 0);    /* Access:      DP Invalid Index                */
        iassign(CommError_00B1_00B1, 0);    /* Access:      DP Write Length Error           */
        iassign(CommError_00B2_00B2, 0);    /* Access:      DP Invalid Slot                 */
        iassign(CommError_00B3_00B3, 0);    /* Access:      DP Type Conflict                */
        iassign(CommError_00B4_00B4, 0);    /* Access:      DP Invalid Area                 */
        iassign(CommError_00B5_00B5, 0);    /* Access:      DP State Conflict               */
        iassign(CommError_00B6_00B6, 0);    /* Access:      DP Access Denied                */
        iassign(CommError_00B7_00B7, 0);    /* Access:      DP Invalid Range                */
        iassign(CommError_00B8_00B8, 0);    /* Access:      DP Invalid Parameter            */
        iassign(CommError_00B9_00B9, 0);    /* Access:      DP Invalid Type                 */
        iassign(CommError_00BA_00BF, 0);    /* Access:      DP Access User Specific         */
        iassign(CommError_00C0_00C0, 0);    /* Resource:    DP Read Constrain Conflict      */
        iassign(CommError_00C1_00C1, 0);    /* Resource:    DP Write Constrain Conflict     */
        iassign(CommError_00C2_00C2, 0);    /* Resource:    DP Resource Busy                */
        iassign(CommError_00C3_00C3, 0);    /* Resource:    DP Resource unavailable         */
        iassign(CommError_00C4_00C7, 0);    /* Resource:    DP Resource Reserved            */
        iassign(CommError_00C8_00CF, 0);    /* Resource:    DP Recource User Specific       */
        iassign(CommError_00D0_00FF, 0);    /* DP User Specific                             */
    }
    HELP        [comm_ignore_all_errors_help];
}

METHOD  CommError_CheckAllErrors
{
    LABEL       [comm_check_all_errors];
    DEFINITION
    {
        iassign(CommError_0000_009F, 1);    /* DP Error Reserved                            */
        iassign(CommError_00A0_00A0, 1);    /* Application: DP Read Error                   */
        iassign(CommError_00A1_00A1, 1);    /* Application: DP Write Error                  */
        iassign(CommError_00A2_00A2, 1);    /* Application: DP Module Failure               */
        iassign(CommError_00A3_00A7, 1);    /* Application: DP Application Reserved         */
        iassign(CommError_00A8_00A8, 1);    /* Application: DP Version Conflict             */
        iassign(CommError_00A9_00A9, 1);    /* Application: DP Feature Not Supported        */
        iassign(CommError_00AA_00AF, 1);    /* Application: DP Application User Specific    */
        iassign(CommError_00B0_00B0, 1);    /* Access:      DP Invalid Index                */
        iassign(CommError_00B1_00B1, 1);    /* Access:      DP Write Length Error           */
        iassign(CommError_00B2_00B2, 1);    /* Access:      DP Invalid Slot                 */
        iassign(CommError_00B3_00B3, 1);    /* Access:      DP Type Conflict                */
        iassign(CommError_00B4_00B4, 1);    /* Access:      DP Invalid Area                 */
        iassign(CommError_00B5_00B5, 1);    /* Access:      DP State Conflict               */
        iassign(CommError_00B6_00B6, 1);    /* Access:      DP Access Denied                */
        iassign(CommError_00B7_00B7, 1);    /* Access:      DP Invalid Range                */
        iassign(CommError_00B8_00B8, 1);    /* Access:      DP Invalid Parameter            */
        iassign(CommError_00B9_00B9, 1);    /* Access:      DP Invalid Type                 */
        iassign(CommError_00BA_00BF, 1);    /* Access:      DP Access User Specific         */
        iassign(CommError_00C0_00C0, 1);    /* Resource:    DP Read Constrain Conflict      */
        iassign(CommError_00C1_00C1, 1);    /* Resource:    DP Write Constrain Conflict     */
        iassign(CommError_00C2_00C2, 1);    /* Resource:    DP Resource Busy                */
        iassign(CommError_00C3_00C3, 1);    /* Resource:    DP Resource unavailable         */
        iassign(CommError_00C4_00C7, 1);    /* Resource:    DP Resource Reserved            */
        iassign(CommError_00C8_00CF, 1);    /* Resource:    DP Recource User Specific       */
        iassign(CommError_00D0_00FF, 1);    /* DP User Specific                             */
    }
    HELP        [comm_check_all_errors_help];
}

METHOD  CommError_DefaultHandling
{
    LABEL       [comm_default_handling];
    DEFINITION
    {
        lassign(CommError_Delay_Read,  0);  /* Delay after Read Command                     */
        lassign(CommError_Delay_Write, 0);  /* Delay after Write Command                    */
        iassign(CommError_0000_009F, 1);    /* DP Error Reserved                            */
        iassign(CommError_00A0_00A0, 1);    /* Application: DP Read Error                   */
        iassign(CommError_00A1_00A1, 1);    /* Application: DP Write Error                  */
        iassign(CommError_00A2_00A2, 1);    /* Application: DP Module Failure               */
        iassign(CommError_00A3_00A7, 1);    /* Application: DP Application Reserved         */
        iassign(CommError_00A8_00A8, 1);    /* Application: DP Version Conflict             */
        iassign(CommError_00A9_00A9, 1);    /* Application: DP Feature Not Supported        */
        iassign(CommError_00AA_00AF, 1);    /* Application: DP Application User Specific    */
        iassign(CommError_00B0_00B0, 0);    /* Access:      DP Invalid Index                */
        iassign(CommError_00B1_00B1, 1);    /* Access:      DP Write Length Error           */
        iassign(CommError_00B2_00B2, 0);    /* Access:      DP Invalid Slot                 */
        iassign(CommError_00B3_00B3, 1);    /* Access:      DP Type Conflict                */
        iassign(CommError_00B4_00B4, 1);    /* Access:      DP Invalid Area                 */
        iassign(CommError_00B5_00B5, 0);    /* Access:      DP State Conflict               */
        iassign(CommError_00B6_00B6, 0);    /* Access:      DP Access Denied                */
        iassign(CommError_00B7_00B7, 0);    /* Access:      DP Invalid Range                */
        iassign(CommError_00B8_00B8, 0);    /* Access:      DP Invalid Parameter            */
        iassign(CommError_00B9_00B9, 1);    /* Access:      DP Invalid Type                 */
        iassign(CommError_00BA_00BF, 0);    /* Access:      DP Access User Specific         */
        iassign(CommError_00C0_00C0, 1);    /* Resource:    DP Read Constrain Conflict      */
        iassign(CommError_00C1_00C1, 1);    /* Resource:    DP Write Constrain Conflict     */
        iassign(CommError_00C2_00C2, 1);    /* Resource:    DP Resource Busy                */
        iassign(CommError_00C3_00C3, 1);    /* Resource:    DP Resource unavailable         */
        iassign(CommError_00C4_00C7, 1);    /* Resource:    DP Resource Reserved            */
        iassign(CommError_00C8_00CF, 1);    /* Resource:    DP Recource User Specific       */
        iassign(CommError_00D0_00FF, 1);    /* DP User Specific                             */
    }
    HELP        [comm_default_handling_help];
}

/*******************************************************************************/
/*     Commands                                                                */
/*******************************************************************************/
MENU upload_variables         /* Parameter die in das Gert geschrieben werden */
{
    LABEL       [menu_load_to_device];
    ITEMS
    {
        phys_tag_desc, /* hier wird mit PRE_WRITE_ACTIONS auf Schreibschutz getestet */
        func1_tag_desc,
        trans1_tag_desc,
        phys_descriptor,
        phys_device_message,
        phys_device_instal_date,
        phys_ident_number_selector,
        phys_local_operation_enable,
        trans1_attachment,

        /* Nur notwendige Initialisierungs-Parameter ins Gert schreiben: */
        IF ((trans1_valve_type == HUBANTRIEB) && (trans1_attachment == NAMUR))
        {
            trans1_transm_length,
            trans1_transm_pin_pos,
        }
        ELSE
        {
            trans1_transm_code_value,
        }

        trans1_rated_travel,
        trans1_init_method,

        IF (trans1_valve_type == HUBANTRIEB)
        {
           trans1_mounting_position,
        }

        trans1_valve_man,
        trans1_valve_serial_number,
        trans1_actuator_serial_number,
        trans1_actuator_man,
        trans1_valve_type,
        trans1_lin_type,
        trans1_deadband,
        trans1_device_calib_date,
        trans1_device_config_date,
        trans1_servo_gain_1,
        trans1_servo_gain_2,
        trans1_servo_rate_1,
        trans1_travel_limit_lower_value,
        trans1_travel_limit_upper_value,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc,
        trans1_setp_cutoff_dec,
        trans1_setp_cutoff_inc,
        trans1_valve_maintenance_date,
        trans1_total_valve_travel_limit,
        trans1_additional_gear_ser_number,
        trans1_additional_gear_man,
        trans1_additional_gear_id,
        trans1_additional_gear_install_date,
        func1_pv_upper_range_value,
        func1_pv_lower_range_value,
        func1_pv_unit,
        func1_fsafe_time,
        func1_fsafe_type,
        func1_fsafe_value,
        func1_increase_close,
        func1_out_upper_range_value,
        func1_out_lower_range_value,
        func1_out_unit,
        func1_in_channel,
        func1_out_channel,
        trans1_delay_time,
        trans1_tolerance_band,
        trans1_tol_overshoot,
        trans1_actuator_version,
        phys_ident_binary_input,
        phys_ident_limit_switches,
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3,
        func1_batch_id,
        func1_batch_unit,
        func1_batch_operation,
        func1_batch_phase
    }
}

MENU download_variables         /* Parameter die aus dem Gert gelesen werden */
{
	LABEL		[menu_load_to_PC];
    ITEMS
    {
        /* alle schreibbaren Parameter der Parameterspalte: */
        phys_device_id,
        phys_tag_desc,
        func1_tag_desc,
        trans1_tag_desc,
        phys_descriptor,
        phys_device_message,
        phys_device_instal_date,
        phys_ident_number_selector,
        phys_local_operation_enable,
        trans1_attachment,
        trans1_transm_length,
        trans1_transm_pin_pos,
        trans1_transm_code_value,
        trans1_rated_travel,
        trans1_init_method,
        trans1_mounting_position,
        trans1_valve_man,
        trans1_valve_serial_number,
        trans1_actuator_serial_number,
        trans1_actuator_man,
        trans1_valve_type,
        trans1_lin_type,
        trans1_deadband,
        trans1_device_calib_date,
        trans1_device_config_date,
        trans1_servo_gain_1,
        trans1_servo_gain_2,
        trans1_servo_rate_1,
        trans1_travel_limit_lower_value,
        trans1_travel_limit_upper_value,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc,
        trans1_setp_cutoff_dec,
        trans1_setp_cutoff_inc,
        trans1_valve_maintenance_date,
        trans1_total_valve_travel_limit,
        trans1_additional_gear_ser_number,
        trans1_additional_gear_man,
        trans1_additional_gear_id,
        trans1_additional_gear_install_date,
        func1_pv_upper_range_value,
        func1_pv_lower_range_value,
        func1_pv_unit,
        func1_fsafe_time,
        func1_fsafe_type,
        func1_fsafe_value,
        func1_increase_close,
        func1_out_upper_range_value,
        func1_out_lower_range_value,
        func1_out_unit,
        func1_in_channel,
        func1_out_channel,
        trans1_delay_time,
        trans1_tolerance_band,
        trans1_tol_overshoot,
        trans1_actuator_version,
        phys_ident_binary_input,
        phys_ident_limit_switches,
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3,
        func1_batch_id,
        func1_batch_unit,
        func1_batch_operation,
        func1_batch_phase,
        /* alle nur lesbaren Parameter der Parameterspalte: */
        phys_device_man_id,
        phys_serial_num,
        phys_device_product_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_st_rev,
        trans1_actuator_type,
        phys_ident_forced_venting,
        phys_hw_write_protection,
        phys_write_locking,
        trans1_actuator_action,
        trans1_act_stroke_time_dec,
        trans1_act_stroke_time_inc,
        trans1_total_valve_travel,
        trans1_self_calib_warning,
        trans1_actuator_action,
        trans1_act_stroke_time_dec,
        trans1_act_stroke_time_inc,
        trans1_max_hub,
        func1_simulate_enabled,
        func1_simulate_value,
        func1_simulate_status_quality,
        func1_simulate_status_limit,
        phys_device_certification
    }
}

/*----------------------------------------------------------------------------*/
/* Physical Block                                                             */
/*----------------------------------------------------------------------------*/
COMMAND read_phys_blk
{
    BLOCK physical_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_blk_reserve, phys_blk_object, phys_blk_parent_class, phys_blk_class,
            phys_blk_dd_reference, phys_blk_dd_rev, phys_blk_profile, phys_blk_profile_rev,
            phys_blk_execution_time, blk_num_parameters, phys_blk_index_view_1,
            phys_blk_num_view_lists
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_st_rev
{
    BLOCK physical_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_st_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_tag_desc
{
    BLOCK physical_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_tag_desc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_tag_desc
{
    BLOCK physical_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_tag_desc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_strategy
{
    BLOCK physical_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_strategy
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_strategy
{
    BLOCK physical_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_strategy
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_alert_key
{
    BLOCK physical_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_alert_key
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_alert_key
{
    BLOCK physical_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_alert_key
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_target_mode
{
    BLOCK physical_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_target_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_target_mode
{
    BLOCK physical_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_target_mode
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_mode
{
    BLOCK physical_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             phys_actual_mode, phys_permitted_mode, phys_normal_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_alarm
{
    BLOCK physical_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_current_state_alarm_sum, phys_unacknowledged_state_alarm_sum,
            phys_unreported_state_alarm_sum, phys_disabled_state_alarm_sum
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_software_rev
{
    BLOCK physical_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_software_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_hardware_rev
{
    BLOCK physical_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_hardware_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
 COMMAND read_phys_device_man_id
 {
    BLOCK physical_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {

        }
        REPLY
        {
            phys_device_man_id
        }
    }
 }
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_id
{
    BLOCK physical_block;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_id
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_serial_num
{
    BLOCK physical_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_serial_num
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis
{
    BLOCK physical_block;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis
        }
    }
}
/*-----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_opt
{
    BLOCK physical_block;
    INDEX 43;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_opt_1, phys_diagnosis_opt_2
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_diagnosis_opt
{
    BLOCK physical_block;
    INDEX 43;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_diagnosis_opt_1, phys_diagnosis_opt_2
        }
        REPLY
        {
        }
    }
}
/*-----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_extension
{
    BLOCK physical_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_extension,
            dummy_byte,
            dummy_byte,
            dummy_byte,
            dummy_byte,
            dummy_byte
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_mask
{
    BLOCK physical_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_mask
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_extension_mask
{
    BLOCK physical_block;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_extension_mask
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_certification
{
    BLOCK physical_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_certification
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_certification
{
    BLOCK physical_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_device_certification
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_write_locking
{
    BLOCK physical_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_write_locking
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_write_locking
{
    BLOCK physical_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_write_locking
        }
        REPLY
        {

        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_factory_reset
{
    BLOCK physical_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_factory_reset
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_descriptor
{
    BLOCK physical_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_descriptor
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_descriptor
{
    BLOCK physical_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_descriptor
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_message
{
    BLOCK physical_block;
    INDEX 21;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_device_message
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_message
{
    BLOCK physical_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_message
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_instal_date
{
    BLOCK physical_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_instal_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_instal_date
{
    BLOCK physical_block;
    INDEX 22;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_device_instal_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_local_operation_enable
{
    BLOCK physical_block;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {

            phys_local_operation_enable
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_local_operation_enable
{
    BLOCK physical_block;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
         phys_local_operation_enable
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_number_selector
{
    BLOCK physical_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
         phys_ident_number_selector
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_number_selector
{
    BLOCK physical_block;
    INDEX 24;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
         phys_ident_number_selector
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_hw_write_protection
{
    BLOCK physical_block;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {

        }
        REPLY
        {
         phys_hw_write_protection
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_forced_venting
{
    BLOCK physical_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ident_forced_venting
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_binary_input
{
    BLOCK physical_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ident_binary_input
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_binary_input
{
    BLOCK physical_block;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_ident_binary_input
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_limit_switches
{
    BLOCK physical_block;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ident_limit_switches
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_limit_switches
{
    BLOCK physical_block;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_ident_limit_switches
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_product_num
{
    BLOCK physical_block;
    INDEX 36;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_product_num
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_text_input_1
{
    BLOCK physical_block;
    INDEX 39;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_1
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_1
{
    BLOCK physical_block;
    INDEX 39;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_1
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_text_input_2
{
    BLOCK physical_block;
    INDEX 40;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_2
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_2
{
    BLOCK physical_block;
    INDEX 40;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_2
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_text_input_3
{
    BLOCK physical_block;
    INDEX 41;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_text_input_3
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_3
{
    BLOCK physical_block;
    INDEX 41;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_text_input_3
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/* Transducer Block                                                           */
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_blk
{
    BLOCK transducer_block_1;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_blk_reserve, trans1_blk_object, trans1_blk_parent_class, trans1_blk_class,
            trans1_blk_dd_reference, trans1_blk_dd_rev, trans1_blk_profile, trans1_blk_profile_rev,
            trans1_blk_execution_time, trans1_blk_num_parameters, trans1_blk_index_view_1,
            trans1_blk_num_view_lists
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_st_rev
{
    BLOCK transducer_block_1;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_st_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tag_desc
{
    BLOCK transducer_block_1;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tag_desc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tag_desc
{
    BLOCK transducer_block_1;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tag_desc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_strategy
{
    BLOCK transducer_block_1;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_strategy
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_strategy
{
    BLOCK transducer_block_1;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_strategy
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_alert_key
{
    BLOCK transducer_block_1;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_alert_key
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_alert_key
{
    BLOCK transducer_block_1;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_alert_key
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_target_mode
{
    BLOCK transducer_block_1;
    INDEX 5;
    OPERATION  READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_target_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_target_mode
{
    BLOCK transducer_block_1;
    INDEX 5;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_target_mode
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_mode
{
    BLOCK transducer_block_1;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_actual_mode, trans1_permitted_mode, trans1_normal_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_alarm
{
    BLOCK transducer_block_1;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_current_state_alarm_sum, trans1_unacknowledged_state_alarm_sum,
            trans1_unreported_state_alarm_sum, trans1_disabled_state_alarm_sum
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_act_stroke_time_dec
{
    BLOCK transducer_block_1;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_act_stroke_time_dec
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_act_stroke_time_inc
{
    BLOCK transducer_block_1;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_act_stroke_time_inc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_deadband
{
    BLOCK transducer_block_1;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_deadband
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_deadband
{
    BLOCK transducer_block_1;
    INDEX 22;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_deadband
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_calib_date
{
    BLOCK transducer_block_1;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_device_calib_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_calib_date
{
    BLOCK transducer_block_1;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_device_calib_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_config_date
{
    BLOCK transducer_block_1;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_device_config_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_config_date
{
    BLOCK transducer_block_1;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_device_config_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_lin_type
{
    BLOCK transducer_block_1;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_lin_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_lin_type
{
    BLOCK transducer_block_1;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_lin_type
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
/*
COMMAND read_trans1_lin_type_curve
{
    BLOCK transducer_block_1;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_characteristic_curve_index, trans1_characteristic_curve_input_value,
            trans1_characteristic_curve_output_value, trans1_characteristic_curve_lin_op_code
        }
    }
}
*/
/*----------------------------------------------------------------------------*/
/*
COMMAND write_trans1_lin_type_curve
{
    BLOCK transducer_block_1;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_characteristic_curve_index, trans1_characteristic_curve_input_value,
            trans1_characteristic_curve_output_value, trans1_characteristic_curve_lin_op_code
        }
        REPLY
        {
        }
    }
}
*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_rated_travel
{
    BLOCK transducer_block_1;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_rated_travel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_rated_travel
{
    BLOCK transducer_block_1;
    INDEX 32;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_rated_travel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calibration_cmd
{
    BLOCK transducer_block_1;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_self_calibration_cmd
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_self_calibration_cmd
{
    BLOCK transducer_block_1;
    INDEX 33;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_self_calibration_cmd
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calibration_status
{
    BLOCK transducer_block_1;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_self_calibration_status
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_gain_1
{
    BLOCK transducer_block_1;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_servo_gain_1
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_gain_1
{
    BLOCK transducer_block_1;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_servo_gain_1
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_rate_1
{
    BLOCK transducer_block_1;
    INDEX 36;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_servo_rate_1
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_rate_1
{
    BLOCK transducer_block_1;
    INDEX 36;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_servo_rate_1
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
/*
COMMAND read_trans1_servo_reset_1
{
    BLOCK transducer_block_1;
    INDEX 37;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_servo_reset
        }
    }
}
*/
/*----------------------------------------------------------------------------*/
/*
COMMAND write_trans1_servo_reset_1
{
    BLOCK transducer_block_1;
    INDEX 37;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_servo_reset
        }
        REPLY
        {
        }
    }
}
*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_setp_cutoff_dec
{
    BLOCK transducer_block_1;
    INDEX 38;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_setp_cutoff_dec
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_setp_cutoff_dec
{
    BLOCK transducer_block_1;
    INDEX 38;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_setp_cutoff_dec
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_setp_cutoff_inc
{
    BLOCK transducer_block_1;
    INDEX 39;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_setp_cutoff_inc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_setp_cutoff_inc
{
    BLOCK transducer_block_1;
    INDEX 39;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_setp_cutoff_inc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_total_valve_travel
{
    BLOCK transducer_block_1;
    INDEX 45;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_total_valve_travel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_total_valve_travel
{
    BLOCK transducer_block_1;
    INDEX 45;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_total_valve_travel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_total_valve_travel_limit
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_total_valve_travel_limit
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_total_valve_travel_limit
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_total_valve_travel_limit
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_limit_low
{
    BLOCK transducer_block_1;
    INDEX 47;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_limit_lower_value
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_limit_low
{
    BLOCK transducer_block_1;
    INDEX 47;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_limit_lower_value
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_limit_upper
{
    BLOCK transducer_block_1;
    INDEX 48;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_limit_upper_value
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_limit_upper
{
    BLOCK transducer_block_1;
    INDEX 48;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_limit_upper_value
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_rate_dec
{
    BLOCK transducer_block_1;
    INDEX 49;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_rate_dec
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_rate_dec
{
    BLOCK transducer_block_1;
    INDEX 49;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_rate_dec
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_rate_inc
{
    BLOCK transducer_block_1;
    INDEX 50;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_rate_inc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_rate_inc
{
    BLOCK transducer_block_1;
    INDEX 50;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_rate_inc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_maintenance_date
{
    BLOCK transducer_block_1;
    INDEX 51;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_maintenance_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_maintenance_date
{
    BLOCK transducer_block_1;
    INDEX 51;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_maintenance_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_gain2
{
    BLOCK transducer_block_1;
    INDEX 52;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_servo_gain_2
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_gain2
{
    BLOCK transducer_block_1;
    INDEX 52;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_servo_gain_2
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_positioning
{
    BLOCK transducer_block_1;
    INDEX 57;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_positioning_value,
            trans1_positioning_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_positioning
{
    BLOCK transducer_block_1;
    INDEX 57;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_positioning_value,
            trans1_positioning_status   <0xFC>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_feedback
{
    BLOCK transducer_block_1;
    INDEX 58;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_feedback_value,
            trans1_feedback_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_feedback
{
    BLOCK transducer_block_1;
    INDEX 58;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_feedback_value,
            trans1_feedback_status   <0xFC>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_man
{
    BLOCK transducer_block_1;
    INDEX 59;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_man
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_man
{
    BLOCK transducer_block_1;
    INDEX 59;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_man
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_man
{
    BLOCK transducer_block_1;
    INDEX 60;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_man
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_man
{
    BLOCK transducer_block_1;
    INDEX 60;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_man
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_type
{
    BLOCK transducer_block_1;
    INDEX 61;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_type
{
    BLOCK transducer_block_1;
    INDEX 61;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_type
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_type
{
    BLOCK transducer_block_1;
    INDEX 62;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_action
{
    BLOCK transducer_block_1;
    INDEX 63;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_action
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_action
{
    BLOCK transducer_block_1;
    INDEX 63;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_action
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_serial_number
{
    BLOCK transducer_block_1;
    INDEX 64;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_serial_number
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_serial_number
{
    BLOCK transducer_block_1;
    INDEX 64;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_serial_number
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_serial_number
{
    BLOCK transducer_block_1;
    INDEX 65;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_serial_number
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_serial_number
{
    BLOCK transducer_block_1;
    INDEX 65;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_serial_number
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_ser_number
{
    BLOCK transducer_block_1;
    INDEX 66;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_ser_number
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_ser_number
{
    BLOCK transducer_block_1;
    INDEX 66;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_ser_number
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_man
{
    BLOCK transducer_block_1;
    INDEX 67;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_man
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_man
{
    BLOCK transducer_block_1;
    INDEX 67;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_man
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_id
{
    BLOCK transducer_block_1;
    INDEX 68;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_id
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_id
{
    BLOCK transducer_block_1;
    INDEX 68;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_id
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_install_date
{
    BLOCK transducer_block_1;
    INDEX 69;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_install_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_install_date
{
    BLOCK transducer_block_1;
    INDEX 69;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_install_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_code
{
    BLOCK transducer_block_1;
    INDEX 80;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_transm_code_value,
            trans1_transm_code_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_code
{
    BLOCK transducer_block_1;
    INDEX 80;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_transm_code_value,
            trans1_transm_code_status   <0xFC>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_length
{
    BLOCK transducer_block_1;
    INDEX 81;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_transm_length
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_length
{
    BLOCK transducer_block_1;
    INDEX 81;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_transm_length
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_pin_pos
{
    BLOCK transducer_block_1;
    INDEX 82;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_transm_pin_pos
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_pin_pos
{
    BLOCK transducer_block_1;
    INDEX 82;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_transm_pin_pos
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_init_method
{
    BLOCK transducer_block_1;
    INDEX 83;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_init_method
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_init_method
{
    BLOCK transducer_block_1;
    INDEX 83;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_init_method
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_delay_time
{
    BLOCK transducer_block_1;
    INDEX 84;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_delay_time
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_delay_time
{
    BLOCK transducer_block_1;
    INDEX 84;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_delay_time
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tolerance_band
{
    BLOCK transducer_block_1;
    INDEX 85;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tolerance_band
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tolerance_band
{
    BLOCK transducer_block_1;
    INDEX 85;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tolerance_band
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calib_warning
{
    BLOCK transducer_block_1;
    INDEX 86;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_self_calib_warning
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_binary_input
{
    BLOCK transducer_block_1;
    INDEX 87;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_binary_input
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_max_hub
{
    BLOCK transducer_block_1;
    INDEX 88;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_max_hub
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transducer_state
{
    BLOCK transducer_block_1;
    INDEX 90;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_transducer_state
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_charact_type
{
    BLOCK transducer_block_1;
    INDEX 91;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_charact_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_charact_type
{
    BLOCK transducer_block_1;
    INDEX 91;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_charact_type
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tol_overshoot
{
    BLOCK transducer_block_1;
    INDEX 92;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tol_overshoot
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tol_overshoot
{
    BLOCK transducer_block_1;
    INDEX 92;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tol_overshoot
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_attachment
{
    BLOCK transducer_block_1;
    INDEX 93;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_attachment
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_attachment
{
    BLOCK transducer_block_1;
    INDEX 93;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_attachment
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_version
{
    BLOCK transducer_block_1;
    INDEX 94;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_version
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_version
{
    BLOCK transducer_block_1;
    INDEX 94;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_version
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_mounting_position
{
    BLOCK transducer_block_1;
    INDEX 95;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mounting_position
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_mounting_position
{
    BLOCK transducer_block_1;
    INDEX 95;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_mounting_position
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/* Function Block                                                             */
/*----------------------------------------------------------------------------*/
COMMAND read_func1_blk
{
    BLOCK function_block_1;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_blk_reserve, func1_blk_object, func1_blk_parent_class, func1_blk_class,
            func1_blk_dd_reference, func1_blk_dd_rev, func1_blk_profile, func1_blk_profile_rev,
            func1_blk_execution_time, func1_blk_num_parameters, func1_blk_index_view_1,
            func1_blk_num_view_lists
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_st_rev
{
    BLOCK function_block_1;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_st_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_tag_desc
{
    BLOCK function_block_1;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_tag_desc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_tag_desc
{
    BLOCK function_block_1;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_tag_desc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_strategy
{
    BLOCK function_block_1;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_strategy
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_strategy
{
    BLOCK function_block_1;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_strategy
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_alert_key
{
    BLOCK function_block_1;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_alert_key
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_alert_key
{
    BLOCK function_block_1;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_alert_key
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_target_mode
{
    BLOCK function_block_1;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_target_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_target_mode
{
    BLOCK function_block_1;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_target_mode
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_mode
{
    BLOCK function_block_1;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func1_actual_mode, func1_permitted_mode, func1_normal_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_alarm
{
    BLOCK function_block_1;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_current_state_alarm_sum, func1_unacknowledged_state_alarm_sum,
            func1_unreported_state_alarm_sum, func1_disabled_state_alarm_sum
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_batch_information
{
    BLOCK function_block_1;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_batch_id,
            func1_batch_unit,
            func1_batch_operation,
            func1_batch_phase
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_batch_information
{
    BLOCK function_block_1;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_batch_id,
            func1_batch_unit,
            func1_batch_operation,
            func1_batch_phase
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_setpoint
{
    BLOCK function_block_1;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_setpoint_value,
            func1_setpoint_status           <0xFC>,
            func1_setpoint_status_limit     <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_setpoint
{
    BLOCK function_block_1;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_setpoint_value,
            func1_setpoint_status           <0xFC>,
            func1_setpoint_status_limit     <0x03>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_pv
{
    BLOCK function_block_1;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_pv_upper_range_value,
            func1_pv_lower_range_value,
            func1_pv_unit,
            func1_pv_decimal_point
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_pv
{
    BLOCK function_block_1;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_pv_upper_range_value,
            func1_pv_lower_range_value,
            func1_pv_unit,
            func1_pv_decimal_point
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_readback
{
    BLOCK function_block_1;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_readback_value,
            func1_readback_status           <0xFC>,
            func1_readback_status_limit     <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_rcas_in
{
    BLOCK function_block_1;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_rcas_in_value,
            func1_rcas_in_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_rcas_in
{
    BLOCK function_block_1;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_rcas_in_value,
            func1_rcas_in_status   <0xFC>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_in_channel
{
    BLOCK function_block_1;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_in_channel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_in_channel
{
    BLOCK function_block_1;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_in_channel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out_channel
{
    BLOCK function_block_1;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_out_channel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out_channel
{
    BLOCK function_block_1;
    INDEX 22;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_out_channel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_time
{
    BLOCK function_block_1;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_fsafe_time
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_time
{
    BLOCK function_block_1;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_fsafe_time
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_type
{
    BLOCK function_block_1;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_fsafe_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_type
{
    BLOCK function_block_1;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_fsafe_type
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_value
{
    BLOCK function_block_1;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_fsafe_value
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_value
{
    BLOCK function_block_1;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_fsafe_value
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_rcas_out
{
    BLOCK function_block_1;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_rcas_out_value,
            func1_rcas_out_status_quality   <0xFC>,
            func1_rcas_out_status_limit     <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_current_position
{
    BLOCK function_block_1;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_position_discrete_value,
            func1_position_discrete_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_setpoint_deviation
{
    BLOCK function_block_1;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_setpoint_deviation
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back
{
    BLOCK function_block_1;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_check_back
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back_mask
{
    BLOCK function_block_1;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_check_back_mask
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back_opt
{
    BLOCK function_block_1;
    INDEX 49;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_check_back_opt
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_check_back_opt
{
    BLOCK function_block_1;
    INDEX 49;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_check_back_opt
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_simulate
{
    BLOCK function_block_1;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_simulate_status_quality   <0xFC>,
            func1_simulate_status_limit     <0x03>,
            func1_simulate_value,
            func1_simulate_enabled
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_simulate
{
    BLOCK function_block_1;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_simulate_status_quality   <0xFC>,
            func1_simulate_status_limit     <0x03>,
            func1_simulate_value,
            func1_simulate_enabled
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_increase_close
{
    BLOCK function_block_1;
    INDEX 36;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_increase_close
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_increase_close
{
    BLOCK function_block_1;
    INDEX 36;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_increase_close
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out
{
    BLOCK function_block_1;
    INDEX 37;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_out_value,
            func1_out_status_quality    <0xFC>,
            func1_out_status_limit      <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out
{
    BLOCK function_block_1;
    INDEX 37;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_out_value,
            func1_out_status_quality    <0xFC>,
            func1_out_status_limit      <0x03>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out_scale
{
    BLOCK function_block_1;
    INDEX 38;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_out_upper_range_value, func1_out_lower_range_value,
            func1_out_unit, func1_out_decimal_point
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out_scale
{
    BLOCK function_block_1;
    INDEX 38;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_out_upper_range_value, func1_out_lower_range_value,
            func1_out_unit, func1_out_decimal_point
        }
        REPLY
        {
        }
    }
}
/*-- ENDE der DD -------------------------------------------------------------*/
