/*--------------------------------------------------------------*/
/*	Copyright (C)   SAMSON AG (1998). All Rights Reserved		*/
/*	Product:		SIEMENS SIMATIC PDM 						*/
/*	Device:			SAMSON PROFIBUS Positioner 3785             */
/*	Communication:	PROFIBUS PA/DPV1                            */
/*	Dictionary:		SIPADC01.dct								*/
/*	Description:	Device Description							*/
/*                                                  			*/
/*  $Revision:   1.3  $										    */
/*  $Date:   01 Oct 1999 19:49:52  $							*/
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 06.04.1999 Kmr/E42 Profibus PA Profil 2                      */
/*                    fr > K1.33 (mit Schreibschutz-Erkennung) */
/* 16.11.1999 Kmr/E42 <Ansicht - Verlaufskurve> implementiert   */
/*                    und unit relations aktiviert              */
/* 15.06.2000 Kmr/E42 Hilfe fr KP_Y2 korrigiert.               */
/*                    In METHOD support_antrieb wird jetzt bei  */
/*                    Umschaltung auf Schwenkantrieb der Anbau  */
/*                    auf NAMUR geschaltet.                     */
/*                    In phys_valve_type LONG_DELAY_TIME statt  */
/*                    SHORT_DELAY_TIME.                         */
/* 21.09.2000 Kmr/E42 Warnmeldung fr Warmstart implementiert.  */
/*                    Warntext fr Kaltstart gendert.          */
/*                    Warntext fr Nullp.-abgl./Init. gendert. */
/*                    Defaultwerte und Bereiche gendert:       */
/*                    Nennwinkel = 90                           */
/*                    Drehw.-ber. Ende = 90                     */
/*                    Nennwinkelbereich = 0...120               */
/*                    Gew. Laufzeiten = 0...75                  */
/* 12.04.2002 Kmr/E42 Methoden fuer Nullpunktabgleich und       */
/*                    Initialisierung vereinfacht.              */
/* 04.09.2002 Kmr/E42 Einige delays bei verschiedenen           */
/*                    Parametern eingefgt.                     */
/* 24.10.2003 Kmr/E42 mit SIMATIC Manager 5.2 (V5.2.0.0) (OEM)  */
/*                    mit PDM Version 5.2 SP1 (K5.2.1.0))       */
/*                    Methode fr Gertezustand in der LifeList */
/*                    (method_PDM_StandardDiagnosis) eingefgt. */
/*                    EB-Aufruf eingefgt.                      */
/* 29.10.2004 Kmr/E42 Parameter func1_setpoint_status_limit und */
/*                    func1_readback_status_limit eingefhrt.   */
/*                    (Status Limit der beiden Parameter)       */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/
MANUFACTURER	     66,   /* SAMSON */
DEVICE_TYPE		      2,
DEVICE_REVISION  0x0200,
DD_REVISION		      1

/* Antworten von func1_target_mode */
#define	BLOCK_MODE_RCAS				0x02
#define	BLOCK_MODE_AUTO				0x08
#define	BLOCK_MODE_MAN				0x10
#define	BLOCK_MODE_LOCAL_OVERRIDE	0x20
#define	BLOCK_MODE_OUT_OF_SERVICE	0x80

/* Herstellerspezifische Defines */
#define HUBANTRIEB 		 0
#define SCHWENKANTRIEB 	 1

#define INTEGRIERT		 0
#define NAMUR			 1

#define AUTO			 0
#define HAND			 1
#define SICHER			 2

#define NICHT_VORHANDEN	 0
#define VORHANDEN		 1
#define INDUKTIV		 1
#define SOFTWARE		 2

/* Codes fuer trans1_self_calibration_cmd */
#define NO_TEST              0
#define NULLP_CAL 		     1
#define INIT 			     2
#define TEST_STOERMELD 		 3
#define TEST_SWK_A 		     4
#define TEST_SWK_B 		     5
#define TEST_STELLMELD 		 6
#define WEGINT_RESET 		 7
#define MECH_NULLP		     8
#define M_NULLP_FORTSETZ	 9
#define RK_STOER_RESET		10
#define START_KENNLINIE		11
#define ENDE_KENNLINIE		12
#define INIT_ERW            20
#define INIT_IMP            21
#define ABGL_4mA		   250
#define ABGL_20mA		   251
#define ABGL_0mV		   252
#define ABGL_120mV		   253
#define KALTSTART 		   254
#define ABBRUCH 		   255

/********************************************************************************/
/* Define fr Statusmeldungen BAD, UNCERTAIN und GOOD nach Profil 3 */
/* (Nur fr maskierte Stati ! Wegen Limit-Bits um 2 Bits nach rechts verschoben) */
#define STATUS_BAD_UNCERTAIN_GOOD_MASK                  \
/* bad */                                               \
        {   0,  [bad_0]         },                      \
        {   1,  [bad_4]         },                      \
        {   2,  [bad_8]         },                      \
        {   3, [bad_12]         },                      \
        {   4, [bad_16]         },                      \
        {   5, [bad_20]         },                      \
        {   6, [bad_24]         },                      \
        {   7, [bad_28]         },                      \
/* uncertain */                                         \
        {   16, [uncertain_64]  },                      \
        {   17, [uncertain_68]  },                      \
        {   18, [uncertain_72]  },                      \
        {   19, [uncertain_76]  },                      \
        {   20, [uncertain_80]  },                      \
        {   21, [uncertain_84]  },                      \
        {   22, [uncertain_88]  },                      \
        {   23, [uncertain_92]  },                      \
        {   24, "Uncertain, Simulated value"            \
                "|de|Unsicher, Simulationswert"     },  \
        {   25, "Uncertain, Sensor calibration"         \
                "|de|Unsicher, Sensor-Kalibrierung" },  \
/* good */                                              \
        {   32, [good_128]      },                      \
        {   33, [good_132]      },                      \
        {   34, [good_136]      },                      \
        {   35, [good_140]      },                      \
        {   36, [good_144]      },                      \
        {   37, [good_148]      },                      \
        {   38, [good_152]      },                      \
        {   40, [good_160]      },                      \
        {   41, "Good, Maintenance required"            \
                 "|de|Gut, Wartung erforderlich" }

/********************************************************************************/
/* Define nur fr Statusmeldungen GOOD (CASCADE) nach Profil 3 */
/*  (zum Anhngen an STATUS_BAD_UNCERTAIN_GOOD)  */
#define STATUS_GOOD_CASCADE_MASK    \
                                 ,  \
/* good (cascade) */                \
        {   48,[good_192]      },   \
        {   49,[good_196]      },   \
        {   50,[good_200]      },   \
        {   51,[good_204]      },   \
        {   52,[good_208]      },   \
        {   53,[good_212]      },   \
        {   54,[good_216]      },   \
        {   55,[good_220]      },   \
        {   56,[good_224]      }

/********************************************************************************/
/* Fr Status Quality / Limit Verarbeitung */
#define STATUS_LIMIT                                \
        { 0x00, [status_limit_OK]               },  \
        { 0x01, [status_limit_UNDERFLOW]        },  \
        { 0x02, [status_limit_OVERFLOW]         },  \
        { 0x03, [status_limit_VALUE_CONSTANT]   }
/********************************************************************************/

/* Define fr Statusmeldungen BAD, UNCERTAIN und GOOD */
#define STATUS_BAD_UNCERTAIN_GOOD    \
/* bad */                            \
		{	0,	[bad_0]			},   \
		{	1,	[bad_1]			},   \
		{	2,	[bad_2]			},   \
		{	3,	[bad_3]			},   \
		{	4,	[bad_4]			},   \
		{	5,	[bad_5]			},   \
		{	6,	[bad_6]			},   \
		{	7,	[bad_7]			},   \
		{	8,	[bad_8]			},   \
		{	9,	[bad_9]			},   \
		{	10,	[bad_10]		},   \
		{	11,	[bad_11]		},   \
		{	12,	[bad_12]		},   \
		{	13,	[bad_13]		},   \
		{	14,	[bad_14]		},   \
		{	15,	[bad_15]		},   \
		{	16,	[bad_16]		},   \
		{	17,	[bad_17]		},   \
		{	18,	[bad_18]		},   \
		{	19,	[bad_19]		},   \
		{	20,	[bad_20]		},   \
		{	21,	[bad_21]		},   \
		{	22,	[bad_22]		},   \
		{	23,	[bad_23]		},   \
		{	24,	[bad_24]		},   \
		{	25,	[bad_25]		},   \
		{	26,	[bad_26]		},   \
		{	27,	[bad_27]		},   \
		{	28,	[bad_28]		},   \
		{	29,	[bad_29]		},   \
		{	30,	[bad_30]		},   \
		{	31,	[bad_31]		},   \
		{	32,	[bad_32]		},   \
		{	33,	[bad_33]		},   \
		{	34,	[bad_34]		},   \
		{	35,	[bad_35]		},   \
/* uncertain */                      \
		{	64,	[uncertain_64]	},   \
		{	65,	[uncertain_65]	},   \
		{	66,	[uncertain_66]	},   \
		{	67,	[uncertain_67]	},   \
		{	68,	[uncertain_68]	},   \
		{	69,	[uncertain_69]	},   \
		{	70,	[uncertain_70]	},   \
		{	71,	[uncertain_71]	},   \
		{	72,	[uncertain_72]	},   \
		{	73,	[uncertain_73]	},   \
		{	74,	[uncertain_74]	},   \
		{	75,	[uncertain_75]	},   \
		{	76,	[uncertain_76]	},   \
		{	77,	[uncertain_77]	},   \
		{	78,	[uncertain_78]	},   \
		{	79,	[uncertain_79]	},   \
		{	80,	[uncertain_80]	},   \
		{	81,	[uncertain_81]	},   \
		{	82,	[uncertain_82]	},   \
		{	83,	[uncertain_83]	},   \
		{	84,	[uncertain_84]	},   \
		{	85,	[uncertain_85]	},   \
		{	86,	[uncertain_86]	},   \
		{	87,	[uncertain_87]	},   \
		{	88,	[uncertain_88]	},   \
		{	89,	[uncertain_89]	},   \
		{	90,	[uncertain_90]	},   \
		{	91,	[uncertain_91]	},   \
		{	92,	[uncertain_92]	},   \
		{	93,	[uncertain_93]	},   \
		{	94,	[uncertain_94]	},   \
		{	95,	[uncertain_95]	},   \
/* good */                           \
		{	128,[good_128]		},   \
		{	129,[good_129]		},   \
		{	130,[good_130]		},   \
		{	131,[good_131]		},   \
		{	132,[good_132]		},   \
		{	133,[good_133]		},   \
		{	134,[good_134]		},   \
		{	135,[good_135]		},   \
		{	136,[good_136]		},   \
		{	137,[good_137]		},   \
		{	138,[good_138]		},   \
		{	139,[good_139]		},   \
		{	140,[good_140]		},   \
		{	141,[good_141]		},   \
		{	142,[good_142]		},   \
		{	143,[good_143]		},   \
		{	144,[good_144]		},   \
		{	145,[good_145]		},   \
		{	146,[good_146]		},   \
		{	147,[good_147]		},   \
		{	148,[good_148]		},   \
		{	149,[good_149]		},   \
		{	150,[good_150]		},   \
		{	151,[good_151]		},   \
		{	152,[good_152]		},   \
		{	153,[good_153]		},   \
		{	154,[good_154]		},   \
		{	155,[good_155]		},   \
		{	160,[good_160]		},   \
		{	161,[good_161]		},   \
		{	162,[good_162]		},   \
		{	163,[good_163]		}

/* Define nur fr Statusmeldungen GOOD (CASCADE) */
/*  (zum Anhngen an STATUS_BAD_UNCERTAIN_GOOD)  */
#define STATUS_GOOD_CASCADE          \
                                 ,   \
/* good (cascade) */                 \
		{	192,[good_192]		},   \
		{	193,[good_193]		},   \
		{	194,[good_194]		},   \
		{	195,[good_195]		},   \
		{	196,[good_196]		},   \
		{	197,[good_197]		},   \
		{	198,[good_198]		},   \
		{	199,[good_199]		},   \
		{	200,[good_200]		},   \
		{	201,[good_201]		},   \
		{	202,[good_202]		},   \
		{	203,[good_203]		},   \
		{	204,[good_204]		},   \
		{	205,[good_205]		},   \
		{	206,[good_206]		},   \
		{	207,[good_207]		},   \
		{	208,[good_208]		},   \
		{	209,[good_209]		},   \
		{	210,[good_210]		},   \
		{	211,[good_211]		},   \
		{	212,[good_212]		},   \
		{	213,[good_213]		},   \
		{	214,[good_214]		},   \
		{	215,[good_215]		},   \
		{	216,[good_216]		},   \
		{	217,[good_217]		},   \
		{	218,[good_218]		},   \
		{	219,[good_219]		},   \
		{	220,[good_220]		},   \
		{	221,[good_221]		},   \
		{	222,[good_222]		},   \
		{	223,[good_223]		},   \
		{	224,[good_224]		},   \
		{	225,[good_225]		},   \
		{	226,[good_226]		},   \
		{	227,[good_227]		}

/******************************************************************************/
/* fr Methode methodOpenDeviceManual: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME "e83821en.pdf"      \
                               "|de|e83821de.pdf"  \
                               "|fr|e83821fr.pdf"  \
                               "|it|e83821it.pdf"  \
                               "|es|e83821es.pdf"

/********************************************************************************/

/********************************************************************************/
/* Includes                                                                     */
/********************************************************************************/
#include "PA_Detect.inc"
#include "Diagnosis.inc"
/********************************************************************************/


VARIABLE	dummy_byte
{
	LABEL		"";
	CLASS		LOCAL;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

/******************************************************************************/
/*    Physical Block												          */
/******************************************************************************/
BLOCK physical_block
{
	TYPE	PHYSICAL;
	NUMBER	1;
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_reserve
{
	LABEL		[blk_reserved];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_object
{
	LABEL		[blk_block_object];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	1,	[blk_block_object_PHYSICAL]	}
	}
	HANDLING	READ;
	HELP		[blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_parent_class
{
	LABEL		[blk_parent_class];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[phys_blk_parent_class_ACTUATOR]	}
	}
	HANDLING	READ;
	HELP		[phys_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_class
{
	LABEL		[blk_class];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{ 250,	[not_used]	}
	}
	HANDLING	READ;
	HELP		[phys_blk_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	HANDLING	READ;
	HELP		[blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ;
	HELP		[blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_profile
{
	LABEL		[blk_profile];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	512,	"2.0"	}
	}
	HANDLING	READ;
	HELP		[blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_execution_time
{
	LABEL		[blk_execution_time];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(1);
	HANDLING	READ;
	HELP		[blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_highest_rel_offset
{
	LABEL		[blk_highest_rel_offset];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_highest_rel_offset_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_num_view_lists_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_st_rev
{
	LABEL		[st_rev];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_tag_desc
{
	LABEL		[tag_desc];
	CLASS		CONTAINED;
	TYPE		ASCII (32);
	HANDLING	READ & WRITE;
	HELP		[tag_desc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_strategy
{
	LABEL		[strategy];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ & WRITE;
	HELP		[strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_alert_key
{
	LABEL		[alert_key];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ & WRITE;
	HELP		[alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_target_mode
{
	LABEL		[target_mode];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{ 0x08,	[mode_AUTO]	}
	}
	HANDLING	READ & WRITE;
	HELP		[target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actual_mode
{
	LABEL		[actual_mode];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{ 0x08,	[mode_AUTO] }
	}
	HANDLING	READ;
	HELP		[actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_permitted_mode
{
	LABEL		[permitted_mode];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (1)
	{
		{ 0x08, [mode_AUTO] }
	}
	HANDLING	READ;
	HELP		[permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_normal_mode
{
	LABEL		[normal_mode];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{ 0x08, [mode_AUTO] }
	}
	HANDLING	READ;
	HELP		[normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_current_state_alarm_sum
{
	LABEL		[current_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_unacknowledged_state_alarm_sum
{
	LABEL		[unacknowledged_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_unreported_state_alarm_sum
{
	LABEL		[unreported_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_disabled_state_alarm_sum
{
	LABEL		[disabled_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[disabled_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_software_rev
{
	LABEL		[phys_software_revision];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
    	DEFAULT_VALUE	"-/-";
	}
	HANDLING	READ;
	HELP		[phys_software_revision_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_hardware_rev
{
	LABEL		[phys_hardware_revision];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
    	DEFAULT_VALUE	"-/-";
    }
	HANDLING	READ;
	HELP		[phys_hardware_revision_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_manufacturer_id
{
	LABEL		[phys_device_man_id];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
       DEFAULT_VALUE	66;
      { 1,		[Acromag]						},
      { 2,		[Allen_Bradley]					},
      { 3,		[Ametek]						},
      { 4,		[Analog_Devices]				},
      { 5,		[Bailey]						},
      { 6,		[Beckman]						},
      { 7,		[Bell_Microsensor]				},
      { 8,		[Bourns]						},
      { 9,		[Bristol_Babcock]				},
      { 10,		[Brooks_Instrument]				},
      { 11,		[Chessell]						},
      { 12,		[Combustion_Engineering]		},
      { 13,		[Daniel_Industries]				},
      { 14,		[Delta]							},
      { 15,		[Dieterich_Standard]			},
      { 16,		[Dohrmann]						},
      { 17,		[Endress_and_Hauser]			},
      { 18,		[Fischer_and_Porter]			},
      { 19,		[Fisher_Controls]				},
      { 20,		[Foxboro]						},
      { 21,		[Fuji]							},
      { 22,		[Hartmann_and_Braun]			},
      { 23,		[Honeywell]						},
      { 24,		[ITT_Barton]					},
      { 25,		[KayRay_Sensall]				},
      { 26,		[Kent]							},
      { 27,		[Leeds_and_Northrup]			},
      { 28,		[Leslie]						},
      { 29,		[M_System_Co]					},
      { 30,		[Measurex]						},
      { 31,		[Micro_Motion]					},
      { 32,		[Moore_Industries]				},
      { 33,		[Moore_Products]				},
      { 34,		[Ohkura_Electric]				},
      { 35,		[Paine]							},
      { 36,		[Rochester_Instrument_Systems]	},
      { 37,		[Ronan]							},
      { 38,		[Rosemount]						},
      { 39,		[Peek_Measurement]				},
      { 40,		[Schlumberger]					},
      { 41,		[Sensall]						},
      { 42,		[Siemens]						},
      { 43,		[Camille_Bauer]					},
      { 44,		[Toshiba]						},
      { 45,		[Transmation]					},
      { 46,		[Rosemount_Analytical]			},
      { 47,		[Valmet]						},
      { 48,		[Valtek]						},
      { 49,		[Varec]							},
      { 50,		[Viatran]						},
      { 51,		[Weed]							},
      { 52,		[Westinghouse]					},
      { 53,		[Xomox]							},
      { 54,		[Yamatake]						},
      { 55,		[Yokogawa]						},
      { 56,		[Nuovo_Pignone]					},
      { 57,		[Promac]						},
      { 58,		[Exac_Corporation]				},
      { 59,		[KDG_Mobrey]					},
      { 60,		[Acrom_Control_System]			},
      { 61,		[Princo]						},
      { 62,		[Smar]							},
      { 63,		[Eckardt]						},
      { 64,		[Measurement_Technology]		},
      { 65,		[Applied_System_Technologies]	},
      { 66,		[Samson]						},
      { 67,		[Sparling_Instruments]			},
      { 68,		[Fireye]						},
      { 69,		[Krohne]						},
      { 70,		[Betz_Equipment]				},
      { 71,		[Druck]							},
      { 72,		[SOR]							},
      { 73,		[Elcon_Instruments]				},
      { 74,		[EMCO]							},
      { 75,		[Termiflex]						},
      { 76,		[VAF_Instruments]				},
      { 77,		[Westlock_Controls]				},
      { 78,		[Drexelbrook]					},
      { 80,		[K_TEK]							},
      { 81,		[Flowdata]						},
      { 82,		[Draeger]						},
	  { 83,		[Raytek]						},
	  { 84,		[Meridian_Instruments]			},
	  { 85,		[BTG]							},
	  { 86,		[Magnetrol]						},
	  { 87,		[Neles_Jamesbury]				},
	  { 88,		[Milltronics]					},
	  { 89,		[HELIOS]						},
      { 90,		[Anderson_Instrument_Company]	},
      { 91,		[INOR]							},
      { 92,		[ROBERTSHAW]					},
      { 93,		[PEPPERL_FUCHS]					},
      { 94,		[ACCUTECH]						},
      { 95,		[Flow_Measurement]				},
      { 96,		[KAMSTRUP]						},
      { 97,		[Knick]							},
      { 98,		[VEGA]							},
      { 99,		[MTS_SYS_CORPS_SENSORS]			},
      { 100,	[Oval]							},
      { 101,	[Masoneilan_DRESSER]			},
      { 102,	[Besta]							},
      { 103,	[Ohmart]						},
      { 250,	[not_used]						},
      { 251,	[none]							},
      { 252,	[unknown]						},
      { 253,	[special]						}
	}
	HANDLING	READ;
	HELP		[phys_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_id
{
	LABEL		[phys_device_id];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	HANDLING	READ;
	HELP		[phys_device_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_serial_num
{
	LABEL		[phys_device_ser_num];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
	   DEFAULT_VALUE	"-/-";
	}
	HANDLING	READ;
	HELP		[phys_device_ser_num_help];
}
/*----------------------------------------------------------------------------*/
#define DIA_HW_ELECTR			0x01000000		/* 0x00000001 */
#define DIA_HW_MECH				0x02000000		/* 0x00000002 */
#define DIA_TEMP_MOTOR			0x04000000		/* 0x00000004 */
#define DIA_TEMP_ELECTR			0x08000000		/* 0x00000008 */
#define DIA_MEM_CHKSUM			0x10000000		/* 0x00000010 */
#define DIA_MEASUREMENT			0x20000000		/* 0x00000020 */
#define DIA_NOT_INIT			0x40000000		/* 0x00000040 */
#define DIA_INIT_ERR			0x80000000		/* 0x00000080 */
#define DIA_ZERO_ERR			0x00010000		/* 0x00000100 */
#define DIA_SUPPLY				0x00020000		/* 0x00000200 */
#define DIA_CONF_INVAL			0x00040000		/* 0x00000400 */
#define DIA_WARMSTART			0x00080000		/* 0x00000800 */
#define DIA_COLDSTART			0x00100000		/* 0x00001000 */
#define DIA_MAINTENANCE			0x00200000		/* 0x00002000 */
#define DIA_CHARACT				0x00400000		/* 0x00004000 */
#define EXTENSION_AVAILABLE		0x00000080		/* 0x80000000 */

VARIABLE phys_diagnosis
{
	LABEL		[phys_diagnosis];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (4)
	{
		{	0,						[dia_OK],					[dia_OK_help]					},
		{	DIA_HW_ELECTR,			[dia_HW_ELECTR],			[dia_HW_ELECTR_help]			},
		{	DIA_HW_MECH,			[dia_HW_MECH],				[dia_HW_MECH_help]				},
		{	DIA_TEMP_MOTOR,			[dia_TEMP_MOTOR],			[dia_TEMP_MOTOR_help]			},
		{	DIA_TEMP_ELECTR,		[dia_TEMP_ELECTR],			[dia_TEMP_ELECTR_help]			},
		{	DIA_MEM_CHKSUM,			[dia_MEM_CHKSUM],			[dia_MEM_CHKSUM_help]			},
		{	DIA_MEASUREMENT,		[dia_MEASUREMENT],			[dia_MEASUREMENT_help]			},
		{	DIA_NOT_INIT,			[dia_NOT_INIT],				[dia_NOT_INIT_help]				},
		{	DIA_INIT_ERR,			[dia_INIT_ERR],				[dia_INIT_ERR_help]				},
		{	DIA_ZERO_ERR,			[dia_ZERO_ERR],				[dia_ZERO_ERR_help]				},
		{	DIA_SUPPLY,				[dia_SUPPLY],				[dia_SUPPLY_help]				},
		{	DIA_CONF_INVAL,			[dia_CONF_INVAL],			[dia_CONF_INVAL_help]			},
		{	DIA_WARMSTART,			[dia_WARMSTART],			[dia_WARMSTART_help]			},
		{	DIA_COLDSTART,			[dia_COLDSTART],			[dia_COLDSTART_help]			},
		{	DIA_MAINTENANCE,		[dia_MAINTENANCE],			[dia_MAINTENANCE_help]			},
		{	DIA_CHARACT,			[dia_CHARACT],				[dia_CHARACT_help]				},
		{	EXTENSION_AVAILABLE,	[dia_EXTENSION_AVAILABLE],	[dia_EXTENSION_AVAILABLE_help]	}
	}
	HANDLING	READ;
	HELP		[phys_diagnosis_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_mask
{
	LABEL		[phys_diagnosis_mask];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (4)
	{
		{	DIA_HW_ELECTR,			[dia_HW_ELECTR],			[dia_HW_ELECTR_help]			},
		{	DIA_HW_MECH,			[dia_HW_MECH],				[dia_HW_MECH_help]				},
		{	DIA_TEMP_MOTOR,			[dia_TEMP_MOTOR],			[dia_TEMP_MOTOR_help]			},
		{	DIA_TEMP_ELECTR,		[dia_TEMP_ELECTR],			[dia_TEMP_ELECTR_help]			},
		{	DIA_MEM_CHKSUM,			[dia_MEM_CHKSUM],			[dia_MEM_CHKSUM_help]			},
		{	DIA_MEASUREMENT,		[dia_MEASUREMENT],			[dia_MEASUREMENT_help]			},
		{	DIA_NOT_INIT,			[dia_NOT_INIT],				[dia_NOT_INIT_help]				},
		{	DIA_INIT_ERR,			[dia_INIT_ERR],				[dia_INIT_ERR_help]				},
		{	DIA_ZERO_ERR,			[dia_ZERO_ERR],				[dia_ZERO_ERR_help]				},
		{	DIA_SUPPLY,				[dia_SUPPLY],				[dia_SUPPLY_help]				},
		{	DIA_CONF_INVAL,			[dia_CONF_INVAL],			[dia_CONF_INVAL_help]			},
		{	DIA_WARMSTART,			[dia_WARMSTART],			[dia_WARMSTART_help]			},
		{	DIA_COLDSTART,			[dia_COLDSTART],			[dia_COLDSTART_help]			},
		{	DIA_MAINTENANCE,		[dia_MAINTENANCE],			[dia_MAINTENANCE_help]			},
		{	DIA_CHARACT,			[dia_CHARACT],				[dia_CHARACT_help]				},
		{	EXTENSION_AVAILABLE,	[dia_EXTENSION_AVAILABLE],	[dia_EXTENSION_AVAILABLE_help]	}
	}
	HANDLING	READ;
	HELP		[phys_diagnosis_mask_help];
}
/*----------------------------------------------------------------------------*/
#if 0  /* kmr: nur bei 'BIT_ENUMERATED (6)' gltig: */
#define DIA_BINARY_INPUT        0x010000000000		/* 0x000000000001 */
#define DIA_START_PULS_1		0x020000000000		/* 0x000000000002 */
#define DIA_START_PULS_2		0x040000000000		/* 0x000000000004 */
#define DIA_START_PULS_3		0x080000000000		/* 0x000000000008 */
#define DIA_FORCED_VENTING		0x100000000000		/* 0x000000000010 */
#define DIA_FRICTION_DIFF		0x200000000000		/* 0x000000000020 */
#define DIA_NOT_TESTED			0x400000000000		/* 0x000000000040 */
#endif
/* kmr: bei 'BIT_ENUMERATED (1)' gltig: */
#define DIA_BINARY_INPUT        0x01
#define DIA_START_PULS_1		0x02
#define DIA_START_PULS_2		0x04
#define DIA_START_PULS_3		0x08
#define DIA_FORCED_VENTING		0x10
#define DIA_FRICTION_DIFF		0x20
#define DIA_NOT_TESTED			0x40

VARIABLE phys_diagnosis_extension /* optional */
{
	LABEL		[phys_diagnosis_extension];
	CLASS		CONTAINED & DYNAMIC;
/* kmr: laut Profil:
    TYPE		BIT_ENUMERATED (6)   */
	TYPE		BIT_ENUMERATED (1)
	{
		{	0,					[dia_OK], [dia_OK_help]                                },
		{	DIA_BINARY_INPUT,   "Binary input active"
		                        "|de|Binreingang aktiv"                               },
		{	DIA_START_PULS_1,	"Pulses range 1 (0%...20%) not valid"
		                        "|de|Stellimpulse Bereich 1 (0%...20%) nicht gltig"   },
		{	DIA_START_PULS_2,	"Pulses range 2  (20%...80%) not valid"
		                        "|de|Stellimpulse Bereich 2 (20%...80%) nicht gltig"  },
		{	DIA_START_PULS_3,	"Pulses range 3 (80%...100%) not valid"
		                        "|de|Stellimpulse Bereich 3 (80%...100%) nicht gltig" },
		{	DIA_FORCED_VENTING,	"Error in option Forced Venting"
		                        "|de|Fehler in Option Zwangsentlftung"                },
		{	DIA_FRICTION_DIFF,	"High difference in friction"
		                        "|de|Hohe Reibungsdifferenz"                           },
		{	DIA_NOT_TESTED,		"No successful end test"
		                        "|de|Kein erfolgreicher Fertigungstest"                }
	}
	HANDLING	READ;
	HELP		[phys_diagnosis_extension_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_diagnosis_extension_mask /* optional */
{
	LABEL		[phys_diagnosis_extension_mask];
	CLASS		CONTAINED;
/* kmr: laut Profil:
	TYPE		BIT_ENUMERATED (6);*/
	TYPE		ASCII (6);
	HANDLING	READ;
	HELP		[phys_diagnosis_extension_mask_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_certification /* optional */
{
	LABEL		[phys_device_certification];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
    	DEFAULT_VALUE	"-/-";
	}
	HANDLING	READ;
	HELP		[phys_device_certification_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_security_locking /* optional */
{
	LABEL		[phys_security_locking];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ & WRITE;
	HELP		[phys_security_locking_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_factory_reset /* optional */
{
	LABEL		[phys_factory_reset];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	0, "No action"
		       "|de|Keine Aktion"    		                                },
		{	1, "Reset application to default values"
		       "|de|Rcksetzen der Applikation auf Kaltstartwerte"          },
		{	2, "Reset device identification to default values"
		       "|de|Rcksetzen der Gerteidentifikation auf Kaltstartwerte" }
	}
	HANDLING	WRITE;
    POST_WRITE_ACTIONS
    {
        LONG_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		[phys_factory_reset_help];
}

/*----------------------------------------------------------------------------*/
/*    Physical Block: Actuator 										          */
/*----------------------------------------------------------------------------*/
VARIABLE phys_descriptor
{
	LABEL		[phys_descriptor];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
    	DEFAULT_VALUE	"SAMSON Typ 3785";
	}
	HANDLING	READ & WRITE;
	HELP		[phys_descriptor_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_message
{
	LABEL		[phys_message];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
    	DEFAULT_VALUE	"Simply the best !";
	}
	HANDLING	READ & WRITE;
	HELP		[phys_message_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_install_date
{
	LABEL		[phys_install_date];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
	   DEFAULT_VALUE	"01.01.1999";
	}
	HANDLING	READ & WRITE;
	HELP		[phys_install_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_valve_man
{
	LABEL		[phys_device_man_id];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
    	DEFAULT_VALUE	"SAMSON";
	}
	HANDLING	READ & WRITE;
	HELP		[phys_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actuator_man
{
	LABEL		[phys_device_man_id];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
    	DEFAULT_VALUE	"SAMSON";
	}
	HANDLING	READ & WRITE;
	HELP		[phys_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_valve_type
{
	LABEL		[phys_valve_type];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
    	DEFAULT_VALUE	0;
		{	0,	[phys_valve_type_LINEAR]		},
		{	1,	[phys_valve_type_PART_TURN]		}
	}
	HANDLING	READ & WRITE;
    POST_EDIT_ACTIONS
    {
        support_antrieb /* Methode */
    }
    POST_WRITE_ACTIONS
    {
        LONG_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		"Valve type: Describes the valve design."
	            "|de|Ventilart: Beschreibt die Ventilkonstruktion.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actuator_type
{
	LABEL		[phys_actuator_type];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
    	DEFAULT_VALUE	0;
		{	0,	[phys_actuator_type_ELECTRO_PNEUMATIC]	},
		{	1,	[phys_actuator_type_ELECTRIC]			},
		{	2,	[phys_actuator_type_ELECTRO_HYDRAULIC]	},
		{	3,	[other]									}
	}
	HANDLING	READ;
	HELP		"Actuator type: Identifies the actuator design."
	            " Read only parameter, determined by the actuator."
	            "|de|Antriebsart: Beschreibt die Antriebskonstruktion."
	            " Wert nur lesbar, wird vom Antrieb bestimmt.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actuator_action
{
	LABEL		[phys_actuator_action];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
    	DEFAULT_VALUE	0;
		{	0,	[phys_actuator_action_NOT_INIT]		},
		{	1,	[phys_actuator_action_OPEN]			},
		{	2,	[phys_actuator_action_CLOSE]		},
		{	3,	[phys_actuator_action_NONE]			}
	}
	HANDLING	READ;
	HELP		[phys_actuator_action_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_valve_serial_number
{
	LABEL		[phys_serial_num];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
   	    DEFAULT_VALUE	"-/-";
   	}
	HANDLING	READ & WRITE;
	HELP		[phys_valve_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actuator_serial_number
{
	LABEL		[phys_serial_num];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
   	    DEFAULT_VALUE	"-/-";
   	}
	HANDLING	READ & WRITE;
	HELP		[phys_actuator_serial_num_help];
}
/*----------------------------------------------------------------------------*/
/*
VARIABLE phys_additional_gear_ser_number
{
	LABEL		[phys_serial_num];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	HANDLING	READ & WRITE;
	HELP		[phys_additional_gear_serial_num_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE phys_additional_gear_man
{
	LABEL		[phys_device_man_id];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	HANDLING	READ & WRITE;
	HELP		[phys_device_man_id_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE phys_additional_gear_id
{
	LABEL		[phys_device_id];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	HANDLING	READ & WRITE;
	HELP		[phys_device_id_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE phys_additional_gear_install_date
{
	LABEL		[phys_install_date];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	HANDLING	READ & WRITE;
	HELP		[phys_additional_gear_install_date_help];
}*/

/*---------------------------------------------------------------------*/
/*    Herstellerspezifische Parameter               				   */
/*---------------------------------------------------------------------*/
VARIABLE phys_attachment_value      /* S/I = 4/110 (DS34) */
{
	LABEL		"Attachment"
	            "|de|Anbau";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Integrated"
		        "|de|Integriert" },
		{	1,	"NAMUR"          }
	}
	HANDLING	READ & WRITE;
    VALIDITY
        IF (phys_valve_type == HUBANTRIEB)
            { TRUE; }
        ELSE
            { FALSE; }
    HELP        "Attachment: Defines positioner attachment to the"
                " control valve."
                "|de|Anbau: Definiert den Anbau des Stellungsreglers"
                " an das Stellgert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_attachment_status    /* S/I = 4/110 (DS34) */
{
	LABEL		"Status attachment"
	            "|de|Status Anbau";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
        DEFAULT_VALUE	128;
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ;
    HELP        "Status attachment: Contains the following states of quality: Good, "
                "Uncertain, Bad."
  	            "|de|Status Anbau: Enthlt folgende Qualittszustandsmeldungen: "
  	            "Gut, Unsicher, Schlecht.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_actuator_version            /* S/I = 2/101 */
{
	LABEL		"Actuator version"
	            "|de|Bauart";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Single acting with spring return"
		        "|de|Einfach wirkend mit Federrckstellung"	 },
		{	1,	"Double acting without spring return"
		        "|de|Doppelt wirkend ohne Federrckstellung" }
	}
	HANDLING	READ & WRITE;
    HELP        "Actuator version: Actuator with or without spring loading."
	            "|de|Bauart: Antrieb mit oder ohne Federrckstellung.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_mounting_position            /* S/I = 2/102 */
{
	LABEL		"Mounting position"
	            "|de|Anbaulage";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	1;
		{	0,	"Arrow pointing away from the actuator"
		        "|de|Pfeil vom Antrieb weg"	},
		{	1,	"Arrow pointing toward the actuator"
		        "|de|Pfeil zum Antrieb hin"	}
	}
    VALIDITY
        IF (phys_valve_type == HUBANTRIEB)
            { TRUE; }
        ELSE
            { FALSE; }
	HANDLING	READ & WRITE;
    HELP        "Mounting position: An arrow is located on the cover plate of the"
                " positioner which is used for alignment on the actuator. This arrow"
                " must either point toward the actuator (direct attachment) or away"
                " from the actuator (NAMUR attachment). (Exception: Control valves for"
                " which the seat is solely closed by a retracting actuator stem. In"
                " this case, the arrow must point either away from the actuator"
                " (direct attachment) or toward the actuator (NAMUR attachment)."
                " Omit this parameter for rotary type (part turn) actuators."
                "|de|Anbaulage: Auf der Abdeckplatte des Stellungsreglers befindet"
                " sich ein Pfeil, der zur Ausrichtung auf den Antrieb dient. Bei"
                " Direktanbau muss dieser Pfeil zum Antrieb hin und bei NAMUR-Anbau"
                " vom Antrieb weg zeigen. (Ausnahme: Stellgerte, bei denen der Sitz"
                " ausschliesslich durch eine einfahrende Antriebsstange geschlossen"
                " wird. Hier muss der Pfeil bei Direktanbau vom Antrieb weg und bei"
                " NAMUR-Anbau zum Antrieb hin zeigen.) Bei Schwenkantrieben entfllt"
                " dieser Parameter.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_ident_limit_switches             /* S/I = 2/105 */
{
	LABEL		"Inductive limit switches"
	            "|de|Induktive Grenzkontakte";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Not implemented"
		        "|de|Nicht eingebaut"	},
		{   1,	"Implemented"
		        "|de|Eingebaut"	        }
	}
	HANDLING	READ & WRITE;
    HELP        "Inductive limit switches: Indicates which type of limit"
                " switch is installed."
                "|de|Induktive Grenzkontakte: Gibt an, welche Grenzkontaktoption"
                " eingebaut ist.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_ident_forced_venting           /* S/I = 2/103 */
{
	LABEL		"Forced venting"
	            "|de|Zwangsentlftung";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Not implemented"
		        "|de|Nicht eingebaut"	},
		{   1,	"Implemented"
		        "|de|Eingebaut"	        }
	}
	HANDLING	READ;
    HELP        "Forced venting: Indicates whether or not the optional forced venting"
                " (forced fail safe action) is installed. If installed, the absence"
                " of the input signal forces the valve to move in the appropriate"
                " fail safe position."
	            "|de|Zwangsentlftung: Gibt an, ob die Option Zwangsentlftung"
	            " eingebaut ist. Wenn die Option vorhanden ist, fhrt ein Wegfall"
	            " des Steuersignals zum Anfahren der Sicherheitsstellung.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_ident_binary_input            /* S/I = 2/104 */
{
	LABEL		"Binary input"
	            "|de|Binreingang";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Not evaluated"
		        "|de|Nicht ausgewertet"	},
		{	1,	"Actively open"
		        "|de|Aktiv offen"	    },
		{   2,	"Actively closed"
		        "|de|Aktiv geschlossen"	}
	}
	HANDLING	READ & WRITE;
	HELP		"Binary input: Describes, whether and how the binary switch"
	            " option is evaluated."
	            "|de|Binreingang: Beschreibt, ob und wie der Binreingang"
	            " ausgewertet wird.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_write_protect_switch          /* S/I = 2/109 */
{
	LABEL		"Write protection"
	            "|de|Schreibschutz";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Not write protected"
		        "|de|Nicht schreibgeschtzt"  },
		{   1,	"Write protected"
		        "|de|Schreibgeschtzt"	      }
	}
	HANDLING	READ;
	HELP		"Write protection: Switching state of the write protection"
	            " switch in the device."
	            "|de|Schreibschutz: Schaltzustand des Schreibschutzschalters"
	            " im Gert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_reset_cmd              /* S/I = 2/44 */
{
	LABEL		"Warm reset"
	            "|de|Warmstart";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	0,	"No action"
		        "|de|Keine Aktion"	},
		{   1,	"Warm start"
		        "|de|Warmstart"	    }
	}
	HANDLING	WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		"Warm reset: Command to reset the device (warm start)."
	            "|de|Warmstart: Auslsen eines Warmstarts.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_device_product_num              /* S/I = 2/106 */
{
	LABEL		"Product number"
	            "|de|Erzeugnis-Nummer";
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
   	    DEFAULT_VALUE	"3785-XXXXXXXX-00";
   	}
	HANDLING	READ;
    HELP        "Product number: Manufacturer's product number of the positioner."
                "|de|Erzeugnis-Nummer: Hersteller-Erzeugnisnummer des Stellungsreglers.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_text_input_1              /* S/I = 2/110 */
{
	LABEL		"Text field 1"
	            "|de|Textfeld 1";
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
   	    DEFAULT_VALUE	"-/-";
   	}
	HANDLING	READ & WRITE;
    HELP        "Text field 1: Space for 32 digits of information text."
                "|de|Textfeld 1: Raum fr 32 Zeichen Informationstext.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_text_input_2             /* S/I = 2/111 */
{
	LABEL		"Text field 2"
	            "|de|Textfeld 2";
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
   	    DEFAULT_VALUE	"-/-";
   	}
	HANDLING	READ & WRITE;
    HELP        "Text field 2: Space for 32 digits of information text."
                "|de|Textfeld 2: Raum fr 32 Zeichen Informationstext.";
}
/*----------------------------------------------------------------------------*/
VARIABLE phys_text_input_3             /* S/I = 2/112 */
{
	LABEL		"Text field 3"
	            "|de|Textfeld 3";
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
   	    DEFAULT_VALUE	"-/-";
   	}
	HANDLING	READ & WRITE;
    HELP        "Text field 3: Space for 32 digits of information text."
                "|de|Textfeld 3: Raum fr 32 Zeichen Informationstext.";
}

/******************************************************************************/
/*    Transducer Block: Actuator 									          */
/******************************************************************************/
BLOCK transducer_block_1
{
	TYPE	TRANSDUCER;
	NUMBER	1;
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_reserve
{
	LABEL		[blk_reserved];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(1);
	HANDLING	READ;
	HELP		[blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_object
{
	LABEL		[blk_block_object];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	3,	[blk_block_object_TRANSDUCER]	}
	}
	HANDLING	READ;
	HELP		[blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_parent_class
{
	LABEL		[blk_parent_class];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	5,	[trans_blk_parent_class_VALVE]	}
	}
	HANDLING	READ;
	HELP		[trans_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_class
{
	LABEL		[blk_class];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,		[trans_act_blk_class_ELECTRO_PNEU]	},
		{	250,	[not_used] 							},
		{	251,	[none]								},
		{	252,	[unknown]							},
		{	253,	[special]							}
	}
	HANDLING	READ;
	HELP		[trans_blk_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	HANDLING	READ;
	HELP		[blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ;
	HELP		[blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_profile
{
	LABEL		[blk_profile];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	512,	"2.0"	}
	}
	HANDLING	READ;
	HELP		[blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_execution_time
{
	LABEL		[blk_execution_time];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_highest_rel_offset
{
	LABEL		[blk_highest_rel_offset];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_highest_rel_offset_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_num_view_lists_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_st_rev
{
	LABEL		[st_rev];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tag_desc
{
	LABEL		[tag_desc];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
   	    DEFAULT_VALUE	"-/-";
   	}
	HANDLING	READ & WRITE;
	HELP		[tag_desc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_strategy
{
	LABEL		[strategy];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ & WRITE;
	HELP		[strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_alert_key
{
	LABEL		[alert_key];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ & WRITE;
	HELP		[alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_target_mode
{
	LABEL		[target_mode];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{ 0x08, [mode_AUTO] }
	}
	HANDLING	READ & WRITE;
	HELP		[target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_actual_mode
{
	LABEL		[actual_mode];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (1)
	{
		{ 0x08, [mode_AUTO] }
	}
	HANDLING	READ;
	HELP		[actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_permitted_mode
{
	LABEL		[permitted_mode];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (1)
	{
		{ 0x08, [mode_AUTO] }
	}
	HANDLING	READ;
	HELP		[permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_normal_mode
{
	LABEL		[normal_mode];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{ 0x08, [mode_AUTO] }
	}
	HANDLING	READ;
	HELP		[normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_current_state_alarm_sum
{
	LABEL		[current_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_unacknowledged_state_alarm_sum
{
	LABEL		[unacknowledged_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_unreported_state_alarm_sum
{
	LABEL		[unreported_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_disabled_state_alarm_sum
{
	LABEL		[disabled_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[disabled_state_alarm_sum_help];
}

/*----------------------------------------------------------------------------*/
/*    Transducer Block: Actuator ELECTRO PNEUMATIC					          */
/*----------------------------------------------------------------------------*/
VARIABLE trans1_act_stroke_time_dec
{
	LABEL		[trans_act_stroke_time_dec];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT "3.1f";
   	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ;
	HELP		[trans_act_stroke_time_dec_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_act_stroke_time_inc
{
	LABEL		[trans_act_stroke_time_inc];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT "3.1f";
   	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ;
	HELP		[trans_act_stroke_time_inc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_characteristic_value
{
    LABEL       "Characterization selection"
                "|de|Kennlinienauswahl";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	[linear]				 		         },
		{	1,	"Equal percentage"
		        "|de|Gleichprozentig"                    },
		{	2,	"Equal percentage reverse"
		        "|de|Gleichprozentig invers"             },
/* kmr: erst bei Profil 3:
		{	3,	[lin_type_TABLE]				         },*/
		{ 240,	"SAMSON Butterfly linear"
		        "|de|SAMSON Stellklappe linear"          },
		{ 241,	"SAMSON Butterfly equal percentage"
		        "|de|SAMSON Stellklappe gleichprozentig" },
		{ 242,	"VETEC Rotary linear"
		        "|de|VETEC Drehkegel linear"             },
		{ 243,	"VETEC Rotary equal percentage"
		        "|de|VETEC Drehkegel gleichprozentig"    }
	}
	HANDLING	READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		"Characterization Type: Characteristic selection for the creation "
	            "of assignments between the reference variable and valve"
	            " travel / angle range."
	            "|de|Kennlinien-Typ: Kennlinienauswahl zur Zuordnung von"
	            " Fhrungsgre und Hub- / Drehwinkelbereich des Ventils.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_characteristic_status
{
	LABEL		[value_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	128;
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ & WRITE;
	HELP		[value_status_help];
}
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_characteristic_curve_index
{
	LABEL		[lin_tab_entry];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ & WRITE;
	HELP		[lin_tab_entry_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_characteristic_curve_input_value
{
	LABEL		[lin_tab_x_value];
	CLASS		CONTAINED;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;
	HELP		[lin_tab_x_value_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_characteristic_curve_output_value
{
	LABEL		[lin_tab_y_value];
	CLASS		CONTAINED;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;
	HELP		[lin_tab_y_value_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_characteristic_curve_lin_op_code
{
	LABEL		[lin_tab_op_code];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	0,	[lin_tab_op_code_NOT_INIT]		},
		{	1,	[lin_tab_op_code_START]			},
		{	2,	[lin_tab_op_code_TRANS_ACTIVE]	},
		{	3,	[lin_tab_op_code_END]			}
	}
	HANDLING	READ & WRITE;
	HELP		[lin_tab_op_code_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_characteristic_def_max
{
	LABEL		[lin_tab_max_number];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[lin_tab_max_number_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_characteristic_def_min
{
	LABEL		[lin_tab_min_number];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[lin_tab_min_number_help];
}*/
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_lin_status
{
	LABEL		[lin_tab_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	0,	[lin_tab_status_NOT_INIT]				},
		{	1,	[lin_tab_status_GOOD]					},
		{	2,	[lin_tab_status_NOT_INC]				},
		{	3,	[lin_tab_status_NOT_DEC]				},
		{	4,	[lin_tab_status_NOT_ENOUGH_VALUES]		},
		{	5,	[lin_tab_status_TOO_MANY_VALUES]		},
		{	6,	[lin_tab_status_GRADIENT]				}
	}
	HANDLING	READ;
	HELP		[lin_tab_status_help];
}*/
/*----------------------------------------------------------------------------*/
VARIABLE trans1_deadband
{
	LABEL		[trans_act_deadband];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.5;
        DISPLAY_FORMAT "2.1f";
        MIN_VALUE  0.1;
        MAX_VALUE 10.0;
   	}
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		[trans_act_deadband_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_device_calib_date
{
	LABEL		[trans_act_device_calib_date];
	CLASS		CONTAINED;
	TYPE		ASCII (8)
	{
   	    DEFAULT_VALUE	"01.01.99";
   	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_device_calib_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_device_config_date
{
	LABEL		[trans_act_device_config_date];
	CLASS		CONTAINED;
	TYPE		ASCII (8)
	{
   	    DEFAULT_VALUE	"01.01.99";
   	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_device_config_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_local_operation_enable
{
	LABEL		[trans_act_local_operation];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	1;
		{	0,	[disabled]	},
		{	1,	[enabled]	}
	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_local_operation_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_rated_travel_value
{
	LABEL		[trans_act_rated_travel_value];
	CLASS		CONTAINED;
	TYPE        FLOAT
    {
   	    DEFAULT_VALUE	15.0;
        DISPLAY_FORMAT  "3.1f";
        MIN_VALUE        0.0;
        MAX_VALUE      255.9; /* wg. Hubantrieb bis 255.9 */
	}
	HANDLING	READ & WRITE;
	CONSTANT_UNIT
        IF (phys_valve_type == HUBANTRIEB)
            { [mm]; }
        ELSE
            { [degrees]; }
    POST_EDIT_ACTIONS
    {
        meld_hub_dreh_bereich   /* Methode */
    }
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		[trans_act_rated_travel_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_rated_travel_status
{
	LABEL		[value_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	128;
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ & WRITE;
	HELP		[value_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calibration_cmd
{
	LABEL		[trans_act_self_calibration_cmd];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	0,	"No test, standard control operation"
		        "|de|Kein Test, normaler Regelbetrieb"       },
		{	1,	"Zero calibration"
		        "|de|Nullpunktabgleich"		                 },
		{	2,	"Initialization"
		        "|de|Initialisierung"		                 },
		{	7,	"Reset total valve travel"
                "|de|Rcksetzen des absoluten Wegintegrals"	 },
		{  10,	"Reset 'Control loop fault'"
		        "|de|Rcksetzen von 'Regelkreis gestrt'"	 },
		{ 255,	"Abort process in action"
                "|de|Laufende Aktion abbrechen"	             }
	}
	HANDLING	READ & WRITE;
/*	WRITE_TIMEOUT	10000;*/
	HELP		[trans_act_self_calibration_cmd_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_reset_cmd
{
	LABEL		"Reset maintenance message"
	            "|de|Rcksetzen Wartungsmeldung";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	0,	"No reset, standard control operation"
		        "|de|Kein Rcksetzen, normaler Regelbetrieb"     },
		{	7,	"Reset total valve travel"
		        "|de|Rcksetzen des absoluten Wegintegrals"		 },
		{  10,	"Reset 'Control loop fault'"
		        "|de|Rcksetzen von 'Regelkreis gestrt'"		 }
	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_self_calibration_cmd_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calibration_status
{
	LABEL		[trans_act_self_calibration_status];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	"Undetermined"
		        "|de|Unbestimmt"  },
		{	1,	"Running"
		        "|de|Luft"  },
		{	2,	"Aborted"
		        "|de|Abgebrochen" },
		{	3,	"Range error"
		        "|de|Bereich fehlerhaft"  },
		{	4,	"Defective mechanics / pneumatics"
		        "|de|Fehler in Mechanik / Pneumatik" },
		{	5,	"gain error"
		        "|de|Verstrkungsfehler"  },
		{	6,	"Offset error"
		        "|de|Offsetfehler"  },
		{	7,	"Wrong calibration order"
		        "|de|Reihenfolge Abgleich vertauscht"  },
		{  11,	"Timeout"
		        "|de|Zeitfehler" },
		{  12,	"Proportional range restricted"
		        "|de|Proportionalbereich zu stark eingeschrnkt"  },
		{  13,	"Rated travel or transmission error"
		        "|de|Nennhub oder bersetzung falsch gewhlt"  },
		{  14,	"Mechanical error"
		        "|de|Mechanisches System klemmt (bei Initialisierung)"  },
		{  15,	"Pneumatical error"
		        "|de|Pneumatisches System undicht (bei Initialisierung)"  },
		{  16,	"Action aborted; no successful manufacturing test"
		        "|de|Aktion abgebrochen; kein erfolgreicher Fertigungstest"  },
		{  17,	"Initialization status: determination of mechanical stops"
		        "|de|Initialisierungsstatus: Ermittlung der mechanischen Anschlge" },
		{  18,	"Initialization status: determination of minimum pulses"
		        "|de|Initialisierungsstatus: Ermittlung der minimalen Stellimpulse"  },
		{  19,	"Initialization status: determination of minimum transit times"
		        "|de|Initialisierungsstatus: Ermittlung der minimalen Laufzeiten" },
		{  20,	"Initialization aborted due to activated forced venting option"
		        "|de|Initialisierung durch Aktivierung der Zwangsentlftung abgebrochen" },
		{  30,	"Zero error"
		        "|de|Nullpunktfehler" },
		{ 254,	"Successful"
		        "|de|Erfolgreich" },
		{ 255,	"No valid data from application"
		        "|de|Keine gltigen Daten von der Applikation"  }
	}
	HANDLING	READ;
	HELP		[trans_act_self_calibration_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_servo_gain
{
	LABEL		"Proportional action coeff. filling KP_Y1"
	            "|de|Proportionalittsfaktor Zuluft KP_Y1";
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.50;
        DISPLAY_FORMAT "2.2f";
        MIN_VALUE 0.01;
        MAX_VALUE 10.0;
   	}
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
	HANDLING	READ & WRITE;
    HELP        "Proportional action coeff. filling KP_Y1:"
                " Used to enter the proportional action "
                "coefficient (filling) for pressurizing (loading air to) the actuator. "
                "For optimizing steps of 0.1 are recommended."
                "|de|Proportionalittsfaktor Zuluft KP_Y1:"
                " Eingabe des Proportionalittsfaktors Zuluft. "
                "Bei Anpassung des Wertes werden 0.1 - Schritte empfohlen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_servo_rate
{
	LABEL		"Derivative action coeff. KD"
	            "|de|Verstrkungsfaktor KD";
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.12;
        DISPLAY_FORMAT "1.2f";
        MIN_VALUE 0.00;
        MAX_VALUE 1.00;
   	}
	HANDLING	READ & WRITE;
    HELP        "Derivative action coeff. KD: "
                "Derivative action coefficient of the differential element."
                " For optimizing steps of 0.02 are recommended."
                "|de|Verstrkungsfaktor KD: Verstrkungsfaktor des Differenziergliedes. "
                "Bei Anpassung des Wertes werden 0.02 - Schritte empfohlen. ";
}
/*----------------------------------------------------------------------------*/
/*
VARIABLE trans1_servo_reset
{
	LABEL		[trans_act_servo_reset];
	CLASS		CONTAINED;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;
	HELP		[trans_act_servo_reset_help];
}*/
/*----------------------------------------------------------------------------*/
VARIABLE trans1_setp_cutoff_dec
{
	LABEL		[trans_act_setp_cutoff_dec];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	1.0;
        DISPLAY_FORMAT "2.1f";
        MIN_VALUE -2.5;
        MAX_VALUE 99.0;
   	}
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "End position below: In case the setpoint falls below"
                " the entered value, the valve will"
                " move to a position which corresponds to a setpoint value of 0 %."
                " A value of -2,5 % will deactivate the function. Hysteresis 1 %."
	            "|de|Endlage bei kleiner: Unterschreitet die Fhrungsgre den eingegebenen"
	            " Wert, wird das Ventil in Richtung der Endlage, die 0 %"
                " der Fhrungsgre entspricht, gefahren. Hysterese 1 %."
                " Bei Wert = -2,5 % Funktion deaktiviert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_setp_cutoff_inc
{
	LABEL		[trans_act_setp_cutoff_inc];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	125.0;
        DISPLAY_FORMAT "2.1f";
        MIN_VALUE   0.0;
        MAX_VALUE 125.0;
   	}
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
    HELP        "End position above: In case the setpoint exceeds"
                " the entered value, the valve will"
                " move to a position which corresponds to a setpoint value of 100 %."
                " A value of 125 % will deactivate the function. Hysteresis 1 %."
	            "|de|Endlage bei grer: berschreitet die Fhrungsgre den eingegebenen"
	            " Wert, wird das Ventil in Richtung der Endlage, die 100 %"
                " der Fhrungsgre entspricht, gefahren. Hysterese 1 %."
                " Bei Wert = 125 % Funktion deaktiviert.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_total_valve_travel
{
	LABEL		[trans_act_total_valve_travel];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
        DISPLAY_FORMAT "8.0f";
    }
	HANDLING	READ;
	HELP		[trans_act_total_valve_travel_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_total_valve_travel_limit
{
	LABEL		[trans_act_total_valve_travel_limit];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	1000000.0;
        DISPLAY_FORMAT       "8.0f";
        MIN_VALUE             0.0;
        MAX_VALUE      16500000.0;
   	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_total_valve_travel_limit_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_lower_value
{
	LABEL		[trans_act_travel_limit_lower_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE     -20.0;
        MAX_VALUE      99.9;
   	}
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
	HELP		[trans_act_travel_limit_lower_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_lower_status
{
	LABEL		[trans_act_travel_limit_lower_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	128;
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_travel_limit_lower_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_upper_value
{
	LABEL		[trans_act_travel_limit_upper_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	100.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE     120.0;
   	}
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
	HELP		[trans_act_travel_limit_upper_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_upper_status
{
	LABEL		[trans_act_travel_limit_upper_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	128;
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_travel_limit_upper_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_rate_dec
{
	LABEL		[trans_act_travel_time_dec];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE      75.0;
   	}
   	POST_WRITE_ACTIONS
    	{
        	SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
	HELP		[trans_act_travel_time_dec_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_rate_inc
{
	LABEL		[trans_act_travel_time_inc];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE      75.0;
   	}
   	POST_WRITE_ACTIONS
    	{
        	SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
	HELP		[trans_act_travel_time_inc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_valve_maintenance_date
{
	LABEL		[trans_act_valve_maintenance_date];
	CLASS		CONTAINED;
	TYPE		ASCII (8)
	{
   	    DEFAULT_VALUE	"01.01.99";
   	}
	HANDLING	READ & WRITE;
	HELP		[trans_act_valve_maintenance_date_help];
}

/******************************************************************************/
/*    Herstellerspezifische Parameter                                         */
/******************************************************************************/
VARIABLE trans1_transducer_state       /* S/I = 4/110 */
{
	LABEL		"Transducer state"
	            "|de|Betriebszustand";
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	"See Actual Mode"
		        "|de|Siehe Aktueller Modus"		  },
		{	1,	"Forced venting active"
		        "|de|Zwangsentlftung aktiv"	  },
		{	2,	"Lower travel limit active"
		        "|de|Hubbegrenzung unten aktiv"	  },
		{	3,	"Upper travel limit active"
		        "|de|Hubbegrenzung oben aktiv"	  },
		{	4,	"End position active at < "
		        "|de|Endlage bei < aktiv"		  },
		{	5,	"End position active at > "
		        "|de|Endlage bei > aktiv"	      }
	}
	HANDLING	READ;
	HELP		"Transducer state: Currently valid state of the transducer block."
	            "|de|Betriebszustand: Zustand des Transducerblocks.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_transm_code_value        /* S/I = 4/100 (DS34) */
{
	LABEL		"Transmission code"
	            "|de|bersetzung Code";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	1;
        IF (phys_valve_type == HUBANTRIEB)
        {
    		{	1,	"D1" },
	       	{	2,	"D2" }
	    }
        ELSE
        {
    		{	3,	"S90"  },
    		{	4,	"S120" }
	    }
	}
    VALIDITY
    IF ( (phys_valve_type == HUBANTRIEB) && (phys_attachment_value == NAMUR) )
        { FALSE; }
    ELSE
        { TRUE; }
	HANDLING	READ & WRITE;
    HELP
        IF (phys_valve_type == HUBANTRIEB)
        {
            "Transmission code: Selecting the lever type for direct attachment."
            "|de|bersetzung Code: Festlegung der geometrischen Abmessungen"
            " des Hubabgriffs bei integriertem Anbau.";
        }
        ELSE
        {
            "Transmission code: Maximum angular travel (slewing angle) of the"
            " mounted cam plate."
            "|de|bersetzung Code: Maximaler Schwenkwinkel der eingebauten"
            " Kurvenscheibe.";
        }
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_transm_code_status    /* S/I = 4/100 (DS34) */
{
	LABEL		"Status transmission code"
	            "|de|Status bersetzung Code";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	128;
        STATUS_BAD_UNCERTAIN_GOOD
	}
    VALIDITY
        IF ( (phys_valve_type == HUBANTRIEB) && (phys_attachment_value == NAMUR) )
            { FALSE; }
        ELSE
            { TRUE; }
	HANDLING	READ & WRITE;
	HELP        "Status transmission code: Contains the following states of quality: Good, "
                "Uncertain, Bad."
  	            "|de|Status bersetzung Code: Enthlt folgende Qualittszustandsmeldungen: "
  	            "Gut, Unsicher, Schlecht.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_transm_length              /* S/I = 4/101 */
{
	LABEL		"Transmission length"
	            "|de|bersetzung Lnge";
	CLASS		CONTAINED;
	TYPE		FLOAT
    {
   	    DEFAULT_VALUE	42.0;
        DISPLAY_FORMAT "4.1f";
        MIN_VALUE       0.0;
        MAX_VALUE    1023.0;
    }
	CONSTANT_UNIT	[mm];
    VALIDITY
        IF ( (phys_valve_type == HUBANTRIEB) && (phys_attachment_value == NAMUR) )
            { TRUE; }
        ELSE
            { FALSE; }
	HANDLING	READ & WRITE;
    HELP        "Transmission length: Lever length. Distance between travel pick up and "
                "pivot of the pick up lever."
	            "|de|bersetzung Lnge: Hebellnge, Abstand zwischen Hubabgriff und"
	            " Drehpunkt des Abgriffhebels.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_transm_pin_pos               /* S/I = 4/102 */
{
	LABEL		"Transmission pin position"
	            "|de|bersetzung Stiftposition";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{ 0, "A " },
		{ 1, "B " }
	}
    VALIDITY
        IF ( (phys_valve_type == HUBANTRIEB) && (phys_attachment_value == NAMUR) )
            { TRUE; }
        ELSE
            { FALSE; }
	HANDLING	READ & WRITE;
    HELP        "Transmission pin position: Transmitter pin in position A or B"
                " (see also Mounting Instructions)."
                " Only for linear actuator with NAMUR attachment."
                "|de|bersetzung Stiftposition: Position des Stiftes am"
                " Hebel des Stellungsreglers. "
                "Siehe Markierung am Hebel. Nur bei Hubantrieb Anbauart NAMUR.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_init_method                 /* S/I = 4/103 */
{
	LABEL		"Initialization method"
	            "|de|Initialisierungsart";
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Maximum range"
		        "|de|Maximalbereich"	},
		{	1,	"Nominal range"
		        "|de|Nennbereich"	    }
	}
	HANDLING	READ & WRITE;
    POST_EDIT_ACTIONS
    {
        meld_init_art   /* Methode */
    }
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
    HELP        "Initialization method: Initialization related to nominal or"
                " maximum range."
                "|de|Initialisierungsart: Initialisierung bezogen auf Nenn- oder"
                " Maximalbereich.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calib_warning           /* S/I = 4/106 */
{
	LABEL		"Calibration alarm message"
	            "|de|Kalibrierung Warnmeldung";
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	"Undetermined"
		        "|de|Unbestimmt"	                              },
		{  13,	"Wrong selection of rated travel or transmission"
		        "|de|Nennhub oder bersetzung falsch gewhlt"	  },
		{  15,	"Air leakage of pneumatic system"
		        "|de|Pneumatisches System undicht"	              },
		{ 254,	"Successful"
		        "|de|Erfolgreich"	                              },
		{ 255,	"No valid data from application"
		        "|de|Keine gltigen Daten von der Applikation"	  }
	}
	HANDLING	READ;
	HELP		"Calibration alarm message: Additional alarm messages of the "
	            "initiated calibration procedure."
	            "|de|Kalibrierung Warnmeldung: Zustzliche Warnmeldungen der "
	            "gestarteten Kalibrierungssequenz.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_charact_type                 /* S/I = 4/112 */
{
	LABEL		"Characteristic type"
	            "|de|Kennlinientyp";
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
   	    DEFAULT_VALUE	"-/-";
	}
	HANDLING	READ & WRITE;
    HELP        "Characteristic type: Free form description of the user defined"
                " characteristics (max. 32 characters)."
                "|de|Kennlinientyp: Freier Text zur Beschreibung der"
                " benutzerdefinierten Kennlinie (max. 32 Zeichen).";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_max_hub                 /* S/I = 4/108 */
{
	LABEL		"Max. permissible travel/angle of rotation"
	            "|de|Max. mglicher Hub/Drehwinkel";
	CLASS		CONTAINED;
	TYPE		FLOAT
    {
   	    DEFAULT_VALUE	100.0;
        DISPLAY_FORMAT   "3.1f";
    }
	CONSTANT_UNIT	[Percent];
	HANDLING	READ;
    HELP        "Max. permissible travel/angle of rotation: poss. stroke/angle"
                " (% of nom. stroke/angle). Determined during initialization."
                "|de|Max. mglicher Hub/Drehwinkel: Max. erreichter Hub/Drehwinkel"
                " (% von Nennhub/Drehwinkel). Ermittelt whrend der Initialisierung.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tolerance_band             /* S/I = 4/105 */
{
	LABEL		"Tolerance band"
	            "|de|Toleranzband";
	CLASS		CONTAINED;
	TYPE		FLOAT
    {
   	    DEFAULT_VALUE	5.0;
        DISPLAY_FORMAT "2.1f";
        MIN_VALUE       0.1;
        MAX_VALUE      10.0;
    }
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
    HELP        "Tolerance band: Reset criteria for active control loop monitoring."
                " Entry of the specified maximum permissible control deviation."
                " See also delay time. Cold start value = Xtot"
                "|de|Toleranzband: Rcksetzkriterium fr laufende Regelkreisberwachung. "
	            "Eingabe der hierfr erlaubten Regelabweichung. Siehe auch "
	            "Nachlaufzeit. Kaltstartwert = Xtot";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_delay_time                /* S/I = 4/104 */
{
	LABEL		"Delay time"
	            "|de|Nachlaufzeit";
	CLASS		CONTAINED;
	TYPE		FLOAT
    {
   	    DEFAULT_VALUE	10.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE     240.0;
    }
	CONSTANT_UNIT	[sec];
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
	HANDLING	READ & WRITE;
    HELP        "Delay time: Reset criteria for active control loop monitoring. If the entered"
                " delay time is exceeded and the control deviation does not lie within"
                " the tolerance band entered, a control loop fault is reported."
                "|de|Nachlaufzeit: Rcksetzkriterium fr laufende Regelkreisberwachung. "
	            "Wenn die eingegebene Nachlaufzeit berschritten ist und die "
	            "Regelabweichung nicht innerhalb des eingegebenen Toleranzbandes "
	            "liegt, wird Regelkreisstrung gemeldet.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_kp_y2                 /* S/I = 4/111 */
{
	LABEL		"Proportional action coeff. venting KP_Y2"
	            "|de|Proportionalittsfaktor Abluft KP_Y2";
	CLASS		CONTAINED;
	TYPE		FLOAT
    {
   	    DEFAULT_VALUE	1.20;
        DISPLAY_FORMAT "2.2f";
        MIN_VALUE       0.01;
        MAX_VALUE      10.00;
    }
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
	HANDLING	READ & WRITE;
    HELP        "Proportional action coeff. venting KP_Y2:"
                " Used to enter the proportional action "
                "coefficient (venting) for exhausting (dumping air from) the"
                " actuator. For optimizing steps of 0.1 are recommended."
                "|de|Proportionalittsfaktor Abluft KP_Y2:"
                " Eingabe des Proportionalittsfaktors Abluft. "
                "Bei Anpassung des Wertes werden 0.1 - Schritte empfohlen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tol_overshoot          /* S/I = 4/113 */
{
	LABEL		"Tolerated overshoot"
	            "|de|Tolerierte berschwingweite";
	CLASS		CONTAINED;
	TYPE		FLOAT
    {
   	    DEFAULT_VALUE	0.5;
        DISPLAY_FORMAT "2.2f";
        MIN_VALUE       0.01;
        MAX_VALUE      10.00;
    }
	CONSTANT_UNIT	[Percent];
	HANDLING	READ & WRITE;
    HELP        "Tolerated overshoot: In Case the control difference e exceeds"
                " the tolerable over shoot, the impulse adaption will modify the"
                " minimum impulse adaption for the motion direction which caused the"
                " exceeding. In case the control difference e exceeds the dead zone"
                " xtot but remains in between the maximum overshoot, the impulse"
                " adaption will reduce the minimum impulses in both motion direction"
                " after two complete cycles in between the maximum overshoot."
                "|de|Tolerierte berschwingweite: berschreitet die Regeldifferenz e"
                " die berschwingweite, so verringert die Impulsanpassung die"
                " minimalen Impulse in der Bewegungsrichtung, welche die berschreitung"
                " verursacht hat. berschreitet die Regeldifferenz e die tote Zone"
                " xtot, bleibt aber innerhalb der berschwingweite, verringert die"
                " Impulsanpassung die minimalen Impulse in beide Bewegungsrichtungen"
                " erst nach 2 vollstndigen Schwingungen innerhalb der"
                " berschwingweite.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_binary_input             /* S/I = 4/107 */
{
	LABEL		"State binary input"
	            "|de|Zustand Binreingang";
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	"Not active"
		        "|de|Nicht aktiv"	    },
		{   1,	"Active"
		        "|de|Aktiv"	            },
		{ 254,	"Not evaluated"
		        "|de|Nicht ausgewertet"	}
	}
	HANDLING	READ;
	HELP		"State binary input: Switching state of binary switch."
	            "|de|Zustand Binreingang: Schaltzustand Binrschalter.";
}

/******************************************************************************/
/*    Function Block                                                          */
/******************************************************************************/
BLOCK function_block_1
{
	TYPE	FUNCTION;
	NUMBER	1;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_reserve
{
	LABEL		[blk_reserved];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_object
{
	LABEL		[blk_block_object];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
	HELP		[blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_parent_class
{
	LABEL		[blk_parent_class];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[func_blk_parent_class_OUTPUT]	}
	}
	HANDLING	READ;
	HELP		[func_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_class
{
	LABEL		[blk_class];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_class_AO]		}
	}
	HANDLING	READ;
	HELP		[func_blk_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	HANDLING	READ;
	HELP		[blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_profile
{
	LABEL		[blk_profile];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		{	512,	"2.0"	}
	}
	HANDLING	READ;
	HELP		[blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_execution_time
{
	LABEL		[blk_execution_time];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_highest_rel_offset
{
	LABEL		[blk_highest_rel_offset];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_highest_rel_offset_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
	HELP		[blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
	HELP		[blk_num_view_lists_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_st_rev
{
	LABEL		[st_rev];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ;
	HELP		[st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_tag_desc
{
	LABEL		[tag_desc];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
   	    DEFAULT_VALUE	"-/-";
	}
	HANDLING	READ & WRITE;
	HELP		[tag_desc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_strategy
{
	LABEL		[strategy];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ & WRITE;
	HELP		[strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_alert_key
{
	LABEL		[alert_key];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ & WRITE;
	HELP		[alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_target_mode
{
	LABEL		[target_mode];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
/*		{	0x02,	[mode_RCAS]				},*/
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ & WRITE;
	HELP		[target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_actual_mode
{
	LABEL		[actual_mode];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
	HELP		[actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_permitted_mode
{
	LABEL		[permitted_mode];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
	HELP		[permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_normal_mode
{
	LABEL		[normal_mode];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
	HELP		[normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_current_state_alarm_sum
{
	LABEL		[current_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_unacknowledged_state_alarm_sum
{
	LABEL		[unacknowledged_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_unreported_state_alarm_sum
{
	LABEL		[unreported_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_disabled_state_alarm_sum
{
	LABEL		[disabled_state_alarm_sum];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x0200,	[limit_state_HI_HI]		},
		{	0x0400,	[limit_state_HI]		},
		{	0x0800,	[limit_state_LO_LO]		},
		{	0x1000,	[limit_state_LO]		},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
	HELP		[disabled_state_alarm_sum_help];
}

/*----------------------------------------------------------------------------*/
/*    Function Block: Analog Output							                  */
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_value
{
	LABEL		[func_ao_readback_value];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
        DISPLAY_FORMAT "3.1f";
   	}
	HANDLING	READ;
	HELP		[func_ao_readback_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_status
{
/*	LABEL		[func_ao_readback_status];*/
    LABEL	"Status quality (Readback Value)"
	        "|de|Status Qualitt (Istwert)";
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD_MASK
	}
	HANDLING	READ;
	HELP		[func_ao_readback_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_status_limit
{
    LABEL "Status limit (Readback Value)"
          "|de|Status Limit (Istwert)";
    CLASS      CONTAINED & DYNAMIC;
    TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
	HANDLING	READ;
    HELP "Contains status messages about limit violations."
         "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_value
{
	LABEL		[func_ao_setpoint_value];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
        DISPLAY_FORMAT   "3.1f";
	}
	HANDLING	READ & WRITE;
	HELP		[func_ao_setpoint_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_status
{
/*	LABEL		[func_ao_setpoint_status];*/
    LABEL	"Status quality (Setpoint Value)"
	        "|de|Status Qualitt (Sollwert)";
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD_MASK
	}
	HANDLING	READ & WRITE;
	HELP		[func_ao_setpoint_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_status_limit
{
    LABEL "Status limit (Setpoint Value)"
          "|de|Status Limit (Sollwert)";
    CLASS      CONTAINED & DYNAMIC;
    TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    HANDLING    READ & WRITE;
    HELP "Contains status messages about limit violations."
         "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_upper_range_value
{
	LABEL		[func_pv_scale_upper_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
	HELP		[func_pv_scale_upper_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_lower_range_value
{
	LABEL		[func_pv_scale_lower_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	  0.0;
	}
	HANDLING	READ & WRITE;
	HELP		[func_pv_scale_lower_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_unit
{
	LABEL		[func_pv_scale_unit];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
/* Temperature */
   	    DEFAULT_VALUE	57;
		{ 32,  [degC],					[degC_help]			},
		{ 33,  [degF],					[degF_help]			},
		{ 34,  [degR],					[degR_help]			},
		{ 35,  [Kelvin],				[Kelvin_help]		},
/* Pressure */
		{ 1,   [InH2O],					[InH2O_help]			},
		{ 2,   [InHg],					[InHg_help]				},
		{ 3,   [FtH2O],					[FtH2O_help]			},
		{ 4,   [mmH2O],					[mmH2O_help]			},
		{ 5,   [mmHg],					[mmHg_help]				},
		{ 6,   [psi],					[psi_help]				},
		{ 7,   [bar],					[bar_help]				},
		{ 8,   [mbar],					[mbar_help]				},
		{ 9,   [g_SqCm],				[g_SqCm_help]			},
		{ 10,  [kg_SqCm],				[kg_SqCm_help]			},
		{ 11,  [PA],					[PA_help]				},
		{ 12,  [kPA],					[kPA_help]				},
		{ 13,  [torr],					[torr_help]				},
		{ 14,  [ATM],					[ATM_help]				},
		{ 237, [mega_pascals],			[mega_pascals_help]		},
		{ 238, [in_H2O_4_degC],			[in_H2O_4_degC_help]	},
		{ 239, [mm_H2O_4_degC],			[mm_H2O_4_degC_help]	},
/* Volumetric Flow */
		{ 15,  [CuFt_min],							[CuFt_min_help]							},
		{ 16,  [gal_min],							[gal_min_help]							},
		{ 17,  [l_min],								[l_min_help]							},
		{ 18,  [ImpGal_min],						[ImpGal_min_help]						},
		{ 19,  [CuMtr_hr],							[CuMtr_hr_help]							},
		{ 22,  [gal_s],								[gal_s_help]							},
		{ 23,  [MillionGal_day],					[MillionGal_day_help]					},
		{ 24,  [l_s],								[l_s_help]								},
		{ 25,  [MilL_day],							[MilL_day_help]							},
		{ 26,  [CuFt_s],							[CuFt_s_help]							},
		{ 27,  [CuFt_day],							[CuFt_day_help]							},
		{ 28,  [CuMtr_s],							[CuMtr_s_help]							},
		{ 29,  [CuMtr_day],							[CuMtr_day_help]						},
		{ 30,  [ImpGal_hr],							[ImpGal_hr_help]						},
		{ 31,  [ImpGal_day],						[ImpGal_day_help]						},
		{ 121, [normal_cubic_meter_per_hour],		[normal_cubic_meter_per_hour_help]		},
		{ 122, [normal_liter_per_hour],				[normal_liter_per_hour_help]			},
		{ 123, [standard_cubic_feet_per_minute],	[standard_cubic_feet_per_minute_help]	},
		{ 130, [CuFt_hr],							[CuFt_hr_help]							},
		{ 131, [CuMtr_min],							[CuMtr_min_help]						},
		{ 132, [bbl_s],								[bbl_s_help]							},
		{ 133, [bbl_min],							[bbl_min_help]							},
		{ 134, [bbl_hr],							[bbl_hr_help]							},
		{ 135, [bbl_day],							[bbl_day_help]							},
		{ 136, [gal_hr],							[gal_hr_help]							},
		{ 137, [ImpGal_s],							[ImpGal_s_help]							},
		{ 138, [l_hr],								[l_hr_help]								},
		{ 235, [gallons_per_day],					[gallons_per_day_help]					},
/* Velocity */
		{ 20,  [ft_s],					[ft_s_help]			},
		{ 21,  [mtr_s],					[mtr_s_help]		},
		{ 114, [in_s],					[in_s_help]			},
		{ 115, [in_min],				[in_min_help]		},
		{ 116, [ft_min],				[ft_min_help]		},
		{ 120, [mtr_hr],				[mtr_hr_help]		},
/* Volume */
		{ 40,  [gal],					[gal_help]					},
		{ 41,  [liter],					[liter_help]				},
		{ 42,  [ImpGal],				[ImpGal_help]				},
		{ 43,  [CuMtr],					[CuMtr_help]				},
		{ 46,  [bbl],					[bbl_help]					},
		{ 110, [bush],					[bush_help]					},
		{ 111, [CuYd],					[CuYd_help]					},
		{ 112, [CuFt],					[CuFt_help]					},
		{ 113, [CuIn],					[CuIn_help]					},
		{ 124, [bbl_liq],				[bbl_liq_help]				},
		{ 166, [normal_cubic_meter],	[normal_cubic_meter_help]	},
		{ 167, [normal_liter],			[normal_liter_help]			},
		{ 168, [standard_cubic_feet],	[standard_cubic_feet_help]	},
		{ 236, [hecto_liter],			[hecto_liter_help]			},
/* Length */
		{ 44,  [ft],					[ft_help]			},
		{ 45,  [meter],					[meter_help]		},
		{ 47,  [in],					[in_help]			},
		{ 48,  [cm],					[cm_help]			},
		{ 49,  [mm],					[mm_help]			},
/* Time */
		{ 50,  [min],					[min_help]			},
		{ 51,  [sec],					[sec_help]			},
		{ 52,  [hr],					[hr_help]			},
		{ 53,  [day],					[day_help]			},
/* Mass */
		{ 60,  [gram],					[gram_help]			},
		{ 61,  [kg],					[kg_help]			},
		{ 62,  [MetTon],				[MetTon_help]		},
		{ 63,  [lb],					[lb_help]			},
		{ 64,  [ShTon],					[ShTon_help]		},
		{ 65,  [LTon],					[LTon_help]			},
		{ 125, [ounce],					[ounce_help]		},
/* Mass Flow */
		{ 70,  [g_s],					[g_s_help]			},
		{ 71,  [g_min],					[g_min_help]		},
		{ 72,  [g_hr],					[g_hr_help]			},
		{ 73,  [kg_s],					[kg_s_help]			},
		{ 74,  [kg_min],				[kg_min_help]		},
		{ 75,  [kg_hr],					[kg_hr_help]		},
		{ 76,  [kg_day],				[kg_day_help]		},
		{ 77,  [MetTon_min],			[MetTon_min_help]	},
		{ 78,  [MetTon_hr],				[MetTon_hr_help]	},
		{ 79,  [MetTon_day],			[MetTon_day_help]	},
		{ 80,  [lb_s],					[lb_s_help]			},
		{ 81,  [lb_min],				[lb_min_help]		},
		{ 82,  [lb_hr],					[lb_hr_help]		},
		{ 83,  [lb_day],				[lb_day_help]		},
		{ 84,  [ShTon_min],				[ShTon_min_help]	},
		{ 85,  [ShTon_hr],				[ShTon_hr_help]		},
		{ 86,  [ShTon_day],				[ShTon_day_help]	},
		{ 87,  [LTon_hr],				[LTon_hr_help]		},
		{ 88,  [LTon_day],				[LTon_day_help]		},
/* Mass per Volume */
		{ 90,  [SGU],					[SGU_help]			},
		{ 91,  [g_CuCm],				[g_CuCm_help]		},
		{ 92,  [kg_CuMtr],				[kg_CuMtr_help]		},
		{ 93,  [lb_gal],				[lb_gal_help]		},
		{ 94,  [lb_CuFt],				[lb_CuFt_help]		},
		{ 95,  [g_ml],					[g_ml_help]			},
		{ 96,  [kg_l],					[kg_l_help]			},
		{ 97,  [g_l],					[g_l_help]			},
		{ 98,  [lb_CuIn],				[lb_CuIn_help]		},
		{ 99,  [ShTon_CuYd],			[ShTon_CuYd_help]	},
		{ 100, [degTwad],				[degTwad_help]		},
		{ 102, [degBaum_hv],			[degBaum_hv_help]	},
		{ 103, [degBaum_lt],			[degBaum_lt_help]	},
		{ 104, [degAPI],				[degAPI_help]		},
/* Viscosity */
		{ 54,  [centi_stokes],			[centi_stokes_help]	},
		{ 55,  [cpoise],				[cpoise_help]		},
/* Electromagnetic unit of Electric Potential */
		{ 36,  [mV],					[mV_help]			},
		{ 58,  [V],						[V_help]			},
/* Electrostatic unit of Current */
		{ 39,  [mA],					[mA_help]			},
/* Electromagnetic unit of Resistance */
		{ 37,  [Ohm],					[Ohm]				},
		{163,  [kOhm],					[kOhm]				},
/* Energy (includes Work) */
		{ 69,  [newton_meter],			[newton_meter_help]					},
		{ 89,  [deka_therm],			[deka_therm_help]					},
		{ 126, [foot_pound_force],		[foot_pound_force_help]				},
		{ 128, [kilo_watt_hour],		[kilo_watt_hour_help]				},
		{ 164, [mega_joule],			[mega_joule_help]					},
		{ 165, [british_thermal_unit],	[british_thermal_unit_help]			},
		{ 162, [mega_calorie],			[mega_calorie_help]					},
/* Power */
		{ 127, [kilo_watt],						[kilo_watt_help]						},
		{ 129, [horsepower],					[horsepower_help]						},
		{ 140, [mega_calorie_per_hour],			[mega_calorie_per_hour_help]			},
		{ 141, [mega_joule_per_hour],			[mega_joule_per_hour_help]				},
		{ 142, [british_thermal_unit_per_hour],	[british_thermal_unit_per_hour_help]	},
/* Miscellaneous */
		{ 38,  [Hz],					[Hz_help]					},
		{ 56,  [uMho],					[uMho_help]					},
		{ 57,  [Percent],				[Percent_help]				},
		{ 59,  [pH],					[pH_help]					},
		{ 66,  [mSiemen_cm],			[mSiemen_cm_help]			},
		{ 67,  [uSiemen_cm],			[uSiemen_cm_help]			},
		{ 68,  [newton],				[newton_help]				},
		{ 101, [degBrix],				[degBrix_help]				},
		{ 105, [Percent_sol_wt],		[Percent_sol_wt_help]		},
		{ 106, [Percent_sol_vol],		[Percent_sol_vol_help]		},
		{ 107, [degBall],				[degBall_help]				},
		{ 108, [proof_vol],				[proof_vol_help]			},
		{ 109, [proof_mass],			[proof_mass_help]			},
		{ 139, [parts_per_million],		[parts_per_million_help]	},
		{ 143, [degrees],				[degrees_help]				},
		{ 150, [percent_StmQual],		[percent_StmQual_help]		},
		{ 151, [Ftin16]												},
		{ 152, [CuFt_lb],				[CuFt_lb_help]				},
		{ 153, [pico_farads],			[pico_farads_help]			},
		{ 160, [Percent_plato],			[Percent_plato_help]		},
/* Generic */
		{ 250, [not_used]		},
		{ 251, [none]			},
		{ 252, [unknown]		},
		{ 253, [special]		}
	}
	HANDLING	READ & WRITE;
	HELP		[func_pv_scale_unit_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_decimal_point
{
	LABEL		[decimal_point];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	1;
		{	0,   "0 "		},
		{	1,   "1 "		},
		{	2,   "2 "		},
		{	3,   "3 "		},
		{	4,   "4 "		},
		{	5,   "5 "		},
		{	6,   "6 "		}
	}
	HANDLING	READ & WRITE;
	HELP		[decimal_point_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_in_value
{
	LABEL		[func_rcas_in_value];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;
	HELP		[func_rcas_in_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_in_status
{
	LABEL		[func_rcas_in_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD
    	STATUS_GOOD_CASCADE
	}
	HANDLING	READ & WRITE;
	HELP		[func_rcas_in_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_channel
{
	LABEL		[func_channel];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ & WRITE;
	HELP		[func_channel_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_time
{
	LABEL		[func_ao_fsafe_time];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	10.0;
        DISPLAY_FORMAT "4.0f";
        MIN_VALUE       0;
        MAX_VALUE    3600;
	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
	HELP		[func_ao_fsafe_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_type
{
	LABEL		[func_ao_fsafe_type];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	1;
		{	0,	[func_ao_fsafe_type_FAIL_SAFE_VALUE]		},
		{	1,	[func_ao_fsafe_type_STORING_LAST_SETPOINT]	},
		{	2,	[func_ao_fsafe_type_FAIL_SAFE_POSITION]		}
	}
	HANDLING	READ & WRITE;
	HELP		[func_ao_fsafe_type_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_value
{
	LABEL		[func_ao_fsafe_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
	HELP		[func_ao_fsafe_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_out_value
{
	LABEL		[func_rcas_out_value];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
	HELP		[func_rcas_out_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_out_status
{
	LABEL		[func_rcas_out_status];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD
    	STATUS_GOOD_CASCADE
	}
	HANDLING	READ;
	HELP		[func_rcas_out_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_position_discrete_value
{
	LABEL		[func_ao_position_discrete_value];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	[func_ao_position_discrete_status_NOT_INIT]			},
		{	1,	[func_ao_position_discrete_status_CLOSED]			},
		{	2,	[func_ao_position_discrete_status_OPENED]			},
		{	3,	[func_ao_position_discrete_status_INTERMEDIATE]		}
	}
	HANDLING	READ;
	HELP		[func_ao_position_discrete_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_position_discrete_status
{
	LABEL		[func_ao_position_discrete_status];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ;
	HELP		[func_ao_position_discrete_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_deviation
{
    LABEL       "Control deviation"
                "|de|Regeldifferenz";
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
        DISPLAY_FORMAT "4.1f";
   	}
	CONSTANT_UNIT	[Percent];
	HANDLING	READ;
	HELP		[func_ao_setpoint_deviation_help];
}
/*----------------------------------------------------------------------------*/
/* kmr: Bits richtig geordnet                 Bits:  */
#define CB_FAIL_SAFE		0x00010000		/*  0	 */
#define CB_REQ_LOC_OP		0x00020000		/*  1	 */
#define CB_LOCAL_OP			0x00040000		/*  2	 */
#define CB_OVERRIDE			0x00080000		/*  3	 */
#define CB_DISC_DIR			0x00100000		/*  4	 */
#define CB_TORQUE_D_OP		0x00200000		/*  5	 */
#define CB_TORQUE_D_CL		0x00400000		/*  6	 */
#define CB_TRAV_TIME		0x00800000		/*  7	 */
#define CB_ACT_OPEN			0x00000100		/*  8	 */
#define CB_ACT_CLOSE		0x00000200		/*  9	 */
#define CB_UPDATE_EVT		0x00000400		/* 10	 */
#define CB_SIMULATE			0x00000800		/* 11	 */
#define CB_DISTURBANCE		0x00001000		/* 12	 */
#define CB_CONTR_ERR		0x00002000		/* 13	 */
#define CB_CONTR_INACT		0x00004000		/* 14	 */
#define CB_SELFTEST			0x00008000		/* 15	 */
#define CB_TOT_VALVE_TRAV	0x00000001		/* 16	 */

VARIABLE func1_check_back
{
	LABEL		[func_check_back];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (3)
	{
		{	0,					[dia_OK],				[dia_OK_help]				},
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
/* kmr	{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},*/
		{	CB_OVERRIDE,		"Forced venting active"
		                        "|de|Zwangsentlftung aktiv", [cb_OVERRIDE_help]    },
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		"Configuration changed"
	                            "|de|Konfiguration verndert", [cb_UPDATE_EVT_help] },
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
	HELP		[func_check_back_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_check_back_mask
{
	LABEL		[func_check_back_mask];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (3)
	{
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		"Configuration changed"
	                            "|de|Konfiguration verndert", [cb_UPDATE_EVT_help] },
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
	HELP		[func_check_back_mask_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_value
{
	LABEL		[func_simulate_value];
	CLASS		CONTAINED;
	TYPE		FLOAT;
	HANDLING	READ & WRITE;
	HELP		[func_ao_simulate_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_status
{
	LABEL		[func_simulate_status];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD
	}
	HANDLING	READ & WRITE;
	HELP		[func_simulate_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_simulation_enabled
{
	LABEL		[func_simulation_enabled];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING	READ & WRITE;
	HELP		[func_simulation_enabled_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_increase_close
{
	LABEL		[func_ao_increase_close];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	0;
		{	0,	[func_ao_increase_close_RISING]		},
		{	1,	[func_ao_increase_close_FALLING]	}
	}
	HANDLING	READ & WRITE;
	HELP		"Moving direction: Determines the assignment of reference"
	            " variable of the travel / angle of rotation."
	            "|de|Bewegungsrichtung: Bestimmt die Zuordnung von Fhrungsgre"
	            " zum Hub / Drehwinkel.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_value
{
	LABEL		[func_out_value];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE     255.9;
   	}
    HANDLING
        IF (func1_target_mode == BLOCK_MODE_LOCAL_OVERRIDE)
    	   { READ & WRITE; }
		ELSE
	   	   { READ; }
	HELP		[func_ao_out_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_status
{
	LABEL		[func_out_status];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
        STATUS_BAD_UNCERTAIN_GOOD
	}
    HANDLING
        IF (func1_target_mode == BLOCK_MODE_LOCAL_OVERRIDE)
    	   { READ & WRITE; }
		ELSE
	   	   { READ; }
	HELP		[func_out_status_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_upper_range_value
{
	LABEL		[func_out_scale_upper_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	15.0;
        DISPLAY_FORMAT  "3.1f";
        MIN_VALUE        0.0;
        MAX_VALUE      255.9;
	}
	HANDLING	READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		[func_out_scale_upper_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_lower_range_value
{
	LABEL		[func_out_scale_lower_value];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
   	    DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT "3.1f";
        MIN_VALUE       0.0;
        MAX_VALUE     255.9;
	}
	HANDLING	READ & WRITE;
    POST_WRITE_ACTIONS
    {
        SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
/*	WRITE_TIMEOUT	10000;*/
	HELP		[func_out_scale_lower_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_unit
{
	LABEL		[func_out_scale_unit];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
   	    DEFAULT_VALUE	49;
   		{  49,      [mm],        [mm_help]	},
   		{ 143, [degrees],	[degrees_help]	},
   		{ 253, [degrees],	[degrees_help]	}
	}
    POST_WRITE_ACTIONS
    {
        VERY_SHORT_DELAY_TIME /* Methode: Verzgerung ohne Meldung */
    }
	HANDLING	READ & WRITE;
	HELP		[func_out_scale_unit_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_decimal_point
{
	LABEL		[decimal_point];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
   	    DEFAULT_VALUE	1;
		{	0,   "0 "		},
		{	1,   "1 "		},
		{	2,   "2 "		},
		{	3,   "3 "		},
		{	4,   "4 "		},
		{	5,   "5 "		},
		{	6,   "6 "		}
	}
	HANDLING	READ & WRITE;
	HELP		[decimal_point_help];
}
/*----------------------------------------------------------------------------*/

/******************************************************************************/
/*    Unit relations                                                          */
/******************************************************************************/
UNIT AO_PV_SCALE_UNIT
{
	func1_pv_unit:

	func1_pv_upper_range_value,
	func1_pv_lower_range_value,
	func1_readback_value,
	func1_setpoint_value,
	func1_rcas_in_value,
	func1_rcas_out_value,
	func1_fsafe_value,
	func1_simulate_value,
	func1_setpoint_deviation
}

UNIT AO_OUT_SCALE_UNIT
{
	func1_out_unit:

	func1_out_value,
	func1_out_upper_range_value,
	func1_out_lower_range_value,
	trans1_rated_travel_value
}

/******************************************************************************/
/*		Refresh relations											          */
/******************************************************************************/
#if 0  /* kmr: nicht implementiert */

REFRESH primary_value_conditions
{
	func1_pv_unit, func1_pv_decimal_point:
	func1_pv_upper_range_value,	func1_pv_lower_range_value
}

REFRESH out_value_conditions
{
	func1_out_unit, func1_out_decimal_point:
	func1_out_upper_range_value, func1_out_lower_range_value
}

REFRESH antr
{
  phys_valve_type :
  phys_attachment_value, phys_actuator_version, trans1_rated_travel_value, trans1_init_method
}

REFRESH anbau_geo
{
  phys_attachment_value :
  trans1_pin_pos, trans1_transm_length, trans1_transm_code_value, phys_mounting_position
}

REFRESH bau
{
  phys_actuator_version : phys_actuator_action
}

REFRESH initart
{
  trans1_init_method : trans1_setp_cutoff_dec, trans1_setp_cutoff_inc
}

REFRESH hub_1
{
  trans1_rated_travel_value : func1_out_scale
}

REFRESH rfr_init
{
  phys_diagnosis :
  phys_actuator_action, trans1_act_stroke_time_dec, trans1_act_stroke_time_inc, trans1_max_hub,
  trans1_self_calib_warning, func1_mode_blk
}
/*
REFRESH kennlinientext
{
  eing_kl : kennlinientyp
}
*/
#endif

/******************************************************************************/
/* Methods                                                                    */
/******************************************************************************/

/* Defines fr Diagnosis und checkback: */
#define CB_FAIL_SAFE_1                0x00010000   /* Bit  0 0x010000    */
#define CB_REQ_LOC_OP_1               0x00020000   /* Bit  1 0x020000    */
#define CB_LOCAL_OP_1                 0x00040000   /* Bit  2 0x040000    */
#define CB_OVERRIDE_1                 0x00080000   /* Bit  3 0x080000    */
#define CB_TRAV_TIME_1                0x00800000   /* Bit  7 0x800000    */
#define CB_UPDATE_EVT_1               0x00000400   /* Bit 10 0x000400    */
#define CB_SIMULATE_1                 0x00000800   /* Bit 11 0x000800    */
#define CB_CONTR_INACT_1              0x00004000   /* Bit 14 0x004000    */
#define CB_SELFTEST_1                 0x00008000   /* Bit 15 0x008000    */
#define CB_TOT_VALVE_TRAV_1           0x00000001   /* Bit 16 0x000001    */

#define DIA_HW_ELECTR_1               0x01000000   /* Bit  0 0x00000001  */
#define DIA_HW_MECH_1                 0x02000000   /* Bit  1 0x00000002  */
#define DIA_MEM_CHKSUM_1              0x10000000   /* Bit  4 0x00000010  */
#define DIA_MEASUREMENT_1             0x20000000   /* Bit  5 0x00000020  */
#define DIA_NOT_INIT_1                0x40000000   /* Bit  6 0x00000040  */
#define DIA_INIT_ERR_1                0x80000000   /* Bit  7 0x00000080  */
#define DIA_ZERO_ERR_1                0x00010000   /* Bit  8 0x00000100  */
#define DIA_CONF_INVAL_1              0x00040000   /* Bit 10 0x00000400  */
#define DIA_WARMSTART_1               0x00080000   /* Bit 11 0x00000800  */
#define DIA_COLDSTART_1               0x00100000   /* Bit 12 0x00001000  */
#define DIA_MAINTENANCE_1             0x00200000   /* Bit 13 0x00002000  */
#define DIA_CHARACT_1                 0x00400000   /* Bit 14 0x00004000  */
#define DIA_IDENT_NUMBER_VIOLATION_1  0x00800000   /* Bit 15 0x00008000  */

/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS  0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS               0xFFF7  /* Lsche GOOD */

/* mgliche Stati (PDM_Diag_Status_Diagnosis):
			PDM_Diag_Status_Diagnosis = PDM_DIAG_FAULT;
			PDM_Diag_Status_Diagnosis = PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Status_Diagnosis = PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Status_Diagnosis = PDM_DIAG_PROCESS_ERROR;
			PDM_Diag_Status_Diagnosis = PDM_DIAG_CONFIG_ERROR;
			PDM_Diag_Status_Diagnosis = PDM_DIAG_SIMULATION;
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD;
*/

/* fr PDM-LifeList / Diagnose */
METHOD  method_PDM_StandardDiagnosis
{
    LABEL       "method_PDM_StandardDiagnosis";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {
        long i_phys_diagnosis;   /* Diagnosis hat 4 Byte */
        long i_func1_check_back; /* Checkback hat 3 Byte */
        int  i_no_good, i_no_recommended; /* Merker zum Lschen anderer Stati */
        int  akt_BA; /* akt. Betriebsart */

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        ReadCommand (read_phys_diagnosis);   /* lese phys_diagnosis   (#13) */
        ReadCommand (read_func1_check_back); /* lese func1_check_back (#33) */
        i_phys_diagnosis   = lvar_value (phys_diagnosis);
        i_func1_check_back = lvar_value (func1_check_back);

        /* Vorbelegen: */
		PDM_Diag_Status_Diagnosis = 0;
		PDM_Diag_Rule_Message     = "";
		i_no_good = 0;
		i_no_recommended = 0;

        /* bei Hand PDM_DIAG_SIMULATION setzen */
        ReadCommand (read_func1_mode);  /* lese akt. Betriebsart */
        akt_BA = ivar_value (func1_actual_mode);

        /* wenn Hand aktiv: */
        if( akt_BA == BLOCK_MODE_MAN )
        {
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message += "Manual mode active;"
			                         "|049Betriebsart Hand aktiv;";
            i_no_good += 1; /* Merker setzen */
        }
        /* wenn alles 0: */
		else if( (i_phys_diagnosis == 0) && (i_func1_check_back == 0) )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message     = [dia_OK];
		}


		if( i_func1_check_back & CB_FAIL_SAFE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Fail safe action active;"
                                        "|de|Sicherheitsverhalten aktiv;";
		}
		if( i_func1_check_back & CB_OVERRIDE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Forced venting active;"
                                        "|de|Zwangsentlftung aktiv;";
		}
		if( i_func1_check_back & CB_UPDATE_EVT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += "Configuration changed;"
		                                 "|de|Konfiguration verndert;";
		}
		if( i_func1_check_back & CB_CONTR_INACT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += [cb_CONTR_INACT] + ";";
		}
		if( i_phys_diagnosis & DIA_WARMSTART_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += [dia_WARMSTART] + ";";
		}
		if( i_phys_diagnosis & DIA_COLDSTART_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
			PDM_Diag_Rule_Message     += [dia_COLDSTART] + ";";
		}
        /************/
		if( i_phys_diagnosis & DIA_CONF_INVAL_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_CONFIG_ERROR;
			PDM_Diag_Rule_Message     += [dia_CONF_INVAL] + ";";
            i_no_good += 1; /* Merker setzen */
		}
        /************/
		if( i_func1_check_back & CB_TOT_VALVE_TRAV_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [cb_TOT_VALVE_TRAV] + ";";
            i_no_good += 1; /* Merker setzen */
		}
 		if( (i_func1_check_back & CB_TRAV_TIME_1) )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [cb_TRAV_TIME] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_func1_check_back & CB_REQ_LOC_OP_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [cb_REQ_LOC_OP] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_CHARACT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_RECOMMENDED;
			PDM_Diag_Rule_Message     += [dia_CHARACT] + ";";
            i_no_good += 1; /* Merker setzen */
		}
        /************/
		if( i_phys_diagnosis & DIA_IDENT_NUMBER_VIOLATION_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message     += [dia_IDENT_VIOL] + ";";
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_MAINTENANCE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			/* PDM_Diag_Rule_Message     += [dia_MAINTENANCE]; doppelte Meldung */
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_ZERO_ERR_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message     += [dia_ZERO_ERR] + ";";
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_INIT_ERR_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_REQUIRED;
			PDM_Diag_Rule_Message     += [dia_INIT_ERR] + ";";
            i_no_good += 1; /* Merker setzen */
            i_no_recommended += 1; /* Merker setzen */
		}
        /************/
		if( i_phys_diagnosis & DIA_HW_ELECTR_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_HW_ELECTR] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_HW_MECH_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_HW_MECH] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_MEM_CHKSUM_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_MEM_CHKSUM] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_MEASUREMENT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_MEASUREMENT] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_phys_diagnosis & DIA_NOT_INIT_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_FAULT;
			PDM_Diag_Rule_Message     += [dia_NOT_INIT] + ";";
            i_no_good += 1; /* Merker setzen */
		}
        /************/
		if( i_func1_check_back & CB_SELFTEST_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message     += [cb_SELFTEST] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_func1_check_back & CB_SIMULATE_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message     += [cb_SIMULATE] + ";";
            i_no_good += 1; /* Merker setzen */
		}
		if( i_func1_check_back & CB_LOCAL_OP_1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_SIMULATION;
			PDM_Diag_Rule_Message     += [cb_LOCAL_OP] + ";";
            i_no_good += 1; /* Merker setzen */
		}

        /* wenn nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message     = [dia_OK];
		}

        /* wenn Status PDM_DIAG_GOOD gelscht werden soll: */
		if( i_no_good != 0 )
		{    /* nur PDM_DIAG_GOOD lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_GOOD_INVERS;
		}

        /* wenn Status PDM_DIAG_MAINT_RECOMMENDED gelscht werden soll: */
		if( i_no_recommended != 0 )
		{    /* nur PDM_DIAG_MAINT_RECOMMENDED lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_MAINT_RECOMMENDED_INVERS;
		}
    }
}
/*****************************************************************************/

/* fr Aufruf von Manual: */
METHOD methodOpenDeviceManual
{
	LABEL "SAMSON 3785 " + [menu_DeviceManual];
	ACCESS OFFLINE ;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME) ;
	}
    HELP "Mounting and operating instructions of the positioner."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers.";
}

/*****************************************************************************/
METHOD sie_set
{
	LABEL		[transfer];
	DEFINITION
	{
	}
	HELP		[transfer_help];
}
/*----------------------------------------------------------------------------*/
METHOD support_antrieb         /* Aktionen fr Hub-/Schwenkantriebumschaltung */
{
	LABEL " ";
	DEFINITION
	{
        int antr;

        antr = ivar_value (phys_valve_type);
        if (antr == HUBANTRIEB) /* wenn Umschaltung auf Hubantrieb */
        {
    		iassign (trans1_transm_code_value,   1); /* bersetzung Code = D1   */
    		fassign (trans1_rated_travel_value, 15); /* Nennhub/-winkel = 15 mm */
        }
        else                    /* wenn Umschaltung auf Schwenkantrieb */
        {
    		iassign (trans1_transm_code_value,   3); /* bersetzung Code = S90    */
    		fassign (trans1_rated_travel_value, 90); /* Nennhub/-winkel = 90 Grad */
    		iassign (phys_attachment_value,  NAMUR); /* Anbau = NAMUR             */
        }
	}
}
/*----------------------------------------------------------------------------*/
METHOD meld_hub_dreh_bereich        /* Anpassung Nennbereich / Arbeitsbereich */
{
    LABEL " ";
    DEFINITION
    {
	    float nennhub_dreh;
        float hub_dreh_ber_end;

        nennhub_dreh     = fvar_value (trans1_rated_travel_value);
	    hub_dreh_ber_end = fvar_value (func1_out_upper_range_value);

        if (nennhub_dreh < hub_dreh_ber_end) /* Bereich zu gross */
        {
            ACKNOWLEDGE("Travel range/angle will be adapted to rated travel/angle."
                        "|de|Der Hub-/Drehwinkelbereich wird an den"
                        " Nennhub/-winkel angepasst.");
        }
        if (nennhub_dreh > hub_dreh_ber_end) /* Nennhub/-winkel zu gross */
        {
            ACKNOWLEDGE("Travel range/angle should be adapted."
                        "|de|Der Hub-/Drehwinkelbereich sollte angepasst werden.");
        }
    }
}
/*----------------------------------------------------------------------------*/
METHOD meld_init_art                      /* nderung der Initialisierungsart */
{
    LABEL " ";
    DEFINITION
    {
        ACKNOWLEDGE("A change of the initialization method will"
                    " take effect only after a new initialization !"
                    "|de|Eine nderung der Initialisierungsart wird erst"
                    " nach einer erneuten Initialisierung wirksam !");
    }
}
/*----------------------------------------------------------------------------*/
METHOD abort_initialization            /* Abbruch der Initialisierungssequenz */
{
    LABEL "Abort process in action"
          "|de|Laufende Aktion abbrechen";
	DEFINITION
	{
        int  wrProt;

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        ReadCommand (read_phys_write_protect_switch); /* aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)  /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		iassign (trans1_self_calibration_cmd, ABBRUCH);   /* Abbruch starten */
		WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        ACKNOWLEDGE("Action aborted"
                    "|de|Aktion wurde abgebrochen");
	}
    HELP "Abort process in action: Aborts running calibration sequence."
	     "|de|Laufende Aktion abbrechen: Bricht laufende Kalibrierungssequenz ab.";
}
/*----------------------------------------------------------------------------*/
METHOD cal_zero_valve                                    /* Nullpunktabgleich */
{
    LABEL "Start zero adjustment"
          "|de|Nullpunktabgleich starten";
	DEFINITION
	{
        int  wrProt;

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        ACKNOWLEDGE("WARNING: Never start zero adjustment during a running process !\n"
                    "During zero adjustment the control valve departs from its current "
                    "position at full travel !\n\n"
                    "Status of zero adjustment: \nsee parameter 'Status (Selfcalibration)' "
                    "and 'Calibration Alarm Message'.\n\n"
                    "Start zero adjustment ?"
                    "|de|WARNUNG: Der Nullpunktabgleich darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Nullpunktabgleich fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status des Nullpunktabgleichs: \nsiehe Parameter 'Status (Selbstkalibrierung)' "
                    "und 'Kalibrierung Warnmeldung'.\n\n"
                    "Nullpunktabgleich starten ?");

        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)  /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

        add_abort_method(abort_initialization);
		iassign (trans1_self_calibration_cmd, NULLP_CAL); /* Nullpunktabgleich starten */
		WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
		DELAY(3,"Zero adjustment is running"
                "|de|Nullpunktabgleich luft");
	}
    HELP "Zero adjustment: Automatic zero point correction."
	     "|de|Nullpunkt abgleichen: Automatische Korrektur des Nullpunktes.";
}
/*----------------------------------------------------------------------------*/
/* Initialisierung (fr Profil 2; ohne erweiterte Initialisierung) ! */
METHOD init_valve
{
    LABEL "Start initialization"
          "|de|Initialisierung starten";
    DEFINITION
    {
        int   wrProt;

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

        ACKNOWLEDGE("WARNING: Never start initialization during a running process !\n"
                    "During initialization the control valve departs from its current"
                    "position at full travel !\n\n"
                    "Status of initialization: \nsee parameter 'Status (Selfcalibration)' "
                    "and 'Calibration Alarm Message'.\n\n"
                    "Start initialization ?"
                    "|de|WARNUNG: Die Initialisierung darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Initialisierung fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status der Initialisierung: \nsiehe Parameter 'Status (Selbstkalibrierung)' "
                    "und 'Kalibrierung Warnmeldung'.\n\n"
                    "Initialisierung starten ?");

        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)  /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

        add_abort_method(abort_initialization);
        iassign (trans1_self_calibration_cmd, INIT);  /* Initialisierung starten */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
	    DELAY(3,"Initialization is running"
	            "|de|Initialisierung luft");
    }
    HELP "Start initialization: Automatic start up."
         " \nRequires manual zero adjustment and valid"
	     " initialization parameters."
	     "|de|Initialisierung starten: Automatische Inbetriebnahme."
	     " \nVoraussetzung: mechanische"
	     " Nullpunktabgleich muss einmal durchgefhrt worden sein. Gltige"
	     " Initialisierungswerte mssen eingegeben sein.";
}
/*----------------------------------------------------------------------------*/
METHOD warmstart                                                 /* Warmstart */
{
	LABEL	"Warm start"
	        "|de|Warmstart";
    DEFINITION
    {
        int  wrProt;

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

        ACKNOWLEDGE("WARNING: Application data will be set to default values !\n"
                    "Never start warm start during a running process !\n"
                    "During warm start the control valve departs from its current "
                    "position at full travel !\nExecute ?"
                    "|de|WARNUNG: Der Warmstart darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Warmstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");
        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

    	DELAY(2,"Warm start is starting"
    	        "|de|Warmstart wird gestartet");
        lassign(phys_device_reset_cmd, 1);          /* Warmstart auslsen  */
        WriteCommand (write_phys_device_reset_cmd); /* ins Gert schreiben */
        DELAY(10,"Warm start is executed"
    	         "|de|Warmstart wird durchgefhrt");
    	ACKNOWLEDGE("Warm start was executing"
    	            "|de|Warmstart wurde ausgefhrt");
    }
	HELP "Warm start: Command to reset the device (warm start)."
	     "|de|Warmstart: Auslsen eines Warmstarts.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_appl                                /* Kaltstart Applikation */
{
    LABEL "Reset application to default values"
          "|de|Rcksetzen der Applikation auf Kaltstartwerte";
    DEFINITION
    {
        int  wrProt;

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

        ACKNOWLEDGE("WARNING: Application data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current "
                    "position at full travel !\nExecute ?"
                    "|de|WARNUNG: Applikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");
        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

    	DELAY(2,"Reset application is starting"
    	        "|de|Kaltstart Applikation wird gestartet");
        lassign (phys_factory_reset, 1);    /* Kaltstart Applikation auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        DELAY(15,"Running"
                 "|de|Luft");
        ACKNOWLEDGE("Reset application executed."
                    "|de|Rcksetzen der Applikation durchgefhrt.");
        ACKNOWLEDGE("New communication startup necessary to get"
                    " current device data."
                    "|de|Erneuter Verbindungsaufbau erforderlich,"
                    " um Gertedaten neu zu lesen.");
    }
    HELP "Reset application to default values"
         "|de|Rcksetzen der Applikation auf Kaltstartwerte";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_ident                      /* Kaltstart Gerteidentifikation */
{
    LABEL "Reset device identification to default values"
          "|de|Rcksetzen der Gerteidentifikation auf Kaltstartwerte";
    DEFINITION
    {
        int  wrProt;

	    IGNORE_ALL_COMM_STATUS();
	    IGNORE_ALL_DEVICE_STATUS();
	    IGNORE_ALL_RESPONSE_CODES();
	    IGNORE_COMM_ERROR();

        ACKNOWLEDGE("WARNING: Device identification data will be set to default values !\n"
                    "Execute ?"
                    "|de|WARNUNG: Gerteidentifikationsdaten werden zurckgesetzt !\n"
                    "Ausfhren ?");
        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

    	DELAY(2,"Reset device identification is starting"
    	        "|de|Kaltstart Gerteidentifikation wird gestartet");
        lassign (phys_factory_reset, 2);    /* Kaltstart Identifikation auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        DELAY(3,"Running"
                "|de|Luft");
        ACKNOWLEDGE("Reset device identification executed."
                    "|de|Rcksetzen der Gerteidentifikation durchgefhrt.");
        ACKNOWLEDGE("New communication startup is necessary to get"
                    " current device data."
                    "|de|Erneuter Verbindungsaufbau ist erforderlich,"
                    " um Gertedaten neu zu lesen.");
    }
    HELP "Reset device identification to default values"
         "|de|Rcksetzen der Gerteidentifikation auf Kaltstartwerte";
}
/*----------------------------------------------------------------------------*/
METHOD wegint_reset                                 /* Rcksetzen Wegintegral */
{
	LABEL "Reset total valve travel"
	      "|de|Rcksetzen Wegintegral";
	DEFINITION
	{
        int  wrProt;

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt.");
            process_abort();
        }

		iassign (trans1_self_calibration_cmd, WEGINT_RESET);
		WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
		DELAY(5,"Reset"
		        "|de|Wird rckgesetzt");
	}
    HELP "Reset total valve travel: reset total valve travel to zero."
         "|de|Rcksetzen Wegintegral: Rcksetzen des Wegintegrals auf Null.";
}
/*----------------------------------------------------------------------------*/
METHOD rk_stoer_reset                         /* Rcksetzen Regelkreisstrung */
{
	LABEL "Reset control loop error"
	      "|de|Rcksetzen Regelkreisstrung";
	DEFINITION
	{
        int  wrProt;

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        ReadCommand (read_phys_write_protect_switch); /* Schreibschutz aus Gert lesen */
        wrProt = ivar_value (phys_write_protect_switch);
        if (wrProt == 1)   /* wenn Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected."
                        "|de|Gert ist schreibgeschtzt");
            process_abort();
        }

		iassign (trans1_self_calibration_cmd, RK_STOER_RESET);
		WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
		DELAY(5,"Reset"
		        "|de|Wird rckgesetzt");
	}
    HELP "Reset control loop error"
         "|de|Rcksetzen der Regelkreisstrung";
}
/*----------------------------------------------------------------------------*/
METHOD VERY_SHORT_DELAY_TIME                              /* kurze Zeitverzgerung */
{
	LABEL "Very short time delay"
	      "|de|Sehr kurze Zeitverzgerung";
	DEFINITION
	{
		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        DELAY_TIME(2); /* Verzgerung in s ohne Meldung */
	}
}
/*----------------------------------------------------------------------------*/
METHOD SHORT_DELAY_TIME                              /* kurze Zeitverzgerung */
{
	LABEL "Short time delay"
	      "|de|Kurze Zeitverzgerung";
	DEFINITION
	{
		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        DELAY_TIME(8); /* Verzgerung in s ohne Meldung */
	}
}
/*----------------------------------------------------------------------------*/
METHOD LONG_DELAY_TIME                               /* lange Zeitverzgerung */
{
	LABEL "Long time delay"
	      "|de|Lange Zeitverzgerung";
	DEFINITION
	{
		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        DELAY_TIME(20); /* Verzgerung in s ohne Meldung */
	}
}

/******************************************************************************/
/*    MENU Bar (Menleiste)                                                   */
/******************************************************************************/
MENU Menu_Main_Specialist /* Hauptmen Spezialist */
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,             /* Datei    */
		Menu_S_Device,         /* Gert    */
		Menu_View,             /* Ansicht  */
		Menu_S_Options,        /* Extras   */
		Menu_Help              /* Hilfe    */
	}
}

MENU Menu_Main_Maintenance /* Hauptmen Instandhalter */
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,              /* Datei    */
		Menu_M_Device,          /* Gert    */
		Menu_View,              /* Ansicht  */
		Menu_M_Options,         /* Extras   */
		Menu_Help               /* Hilfe    */
	}
}

/*----------------------------------------------------------------------------*/
/*    Menu: File (Datei)											          */
/*----------------------------------------------------------------------------*/
MENU Menu_File /* Datei */
{
	LABEL		[menu_File];
	ITEMS
	{
		std_Save,            /* Speichern          */
		SEPARATOR,           /* ------------------ */
		std_Eigenschaften,   /* Eigenschaften      */
		SEPARATOR,           /* ------------------ */
		std_Print,           /* Drucken            */
		std_PrintPreview,    /* Seitenansicht      */
		std_PrintSetup,      /* Drucker einrichten */
		std_PageSetup,       /* Seite einrichten   */
		std_Schriftfelder,   /* Schriftfelder      */
		SEPARATOR,           /* ------------------ */
		std_Exit             /* Beenden            */
	}
}

METHOD std_Save
{
	LABEL		[menu_File_Save];
	DEFINITION
	{
	}
}

METHOD SEPARATOR
{
	LABEL		[menu_Separator];
	DEFINITION
	{
	}
}

METHOD std_Eigenschaften
{
	LABEL		[menu_File_Properties];
	DEFINITION
	{
	}
}

METHOD std_Print
{
	LABEL		[menu_File_Print];
	DEFINITION
	{
	}
}

METHOD std_PrintPreview
{
	LABEL		[menu_File_PrintPreview];
	DEFINITION
	{
	}
}

METHOD std_PrintSetup
{
	LABEL		[menu_File_PrintSetup];
	DEFINITION
	{
	}
}

METHOD std_PageSetup
{
	LABEL		[menu_File_PageSetup];
	DEFINITION
	{
	}
}

METHOD std_Schriftfelder
{
	LABEL		[menu_File_Labels];
	DEFINITION
	{
	}
}

METHOD std_Exit
{
	LABEL		[menu_File_Exit];
	DEFINITION
	{
	}
}

/*----------------------------------------------------------------------------*/
/*    Menu: Device (Gert)											          */
/*----------------------------------------------------------------------------*/
MENU Menu_S_Device /* Gert (Spezialist) */
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_LoadinDevice,                  /* Laden in Gert     */
		std_LoadinPC,                      /* Laden in PG/PC     */
		SEPARATOR,                         /* ------------------ */
		OnlineDialog_operation,            /* Betrieb            */
		OnlineDialog_reset,                /* Rcksetzen         */
		SEPARATOR,                         /* ------------------ */
		OnlineDialog_self_calibration      /* Selbstkalibrierung */
	}
}

MENU Menu_M_Device /* Gert (Instandhalter) */
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_LoadinDevice,
		std_LoadinPC
	}
}

METHOD std_LoadinDevice
{
	LABEL		[menu_Device_LoadinDevice];
	DEFINITION
	{
	}
}

METHOD std_LoadinPC
{
	LABEL		[menu_Device_LoadinPC];
	DEFINITION
	{
	}
}

/*----------------------------------------------------------------------------*/
/*    Menu: View													          */
/*----------------------------------------------------------------------------*/
MENU Menu_View /* Ansicht */
{
	LABEL		[menu_View];
	ITEMS
	{
		OnlineWindow_display,        /* Messwertanzeige     */
		OnlineWindow_yt,             /* Kurvenschreiber    */
		OnlineWindow_diagnosis,      /* Gertezustand      */
		SEPARATOR,                   /* ------------------ */
		std_Funktionsleiste,         /* Funktionsleiste    */
		std_Statuszeile,             /* Statuszeile        */
		SEPARATOR,                   /* ------------------ */
		std_Update                   /* Aktualisieren      */
	}
}

METHOD std_Funktionsleiste
{
	LABEL		[menu_View_Toolbar];
	DEFINITION
	{
	}
}

METHOD std_Statuszeile
{
	LABEL		[menu_View_Statusbar];
	DEFINITION
	{
	}
}

METHOD std_Update
{
	LABEL		[menu_View_Update];
	DEFINITION
	{
	}
}

/*----------------------------------------------------------------------------*/
/*    Menu: Options													          */
/*----------------------------------------------------------------------------*/
MENU Menu_S_Options /* Extras (Spezialist) */
{
	LABEL		[menu_Options];
	ITEMS
	{
		std_Einstellungen,                  /* Einstellungen          */
		std_Untereintraege                  /* Untereintrge anzeigen */
/*		SEPARATOR,    */                      /* ---------------------- */
/*		OfflineDialog_CommErrorHandling */    /* Fehlerbehandlung       */
	}
}

MENU Menu_M_Options /* Extras (Instandhalter) */
{
	LABEL		[menu_Options];
	ITEMS
	{
		std_Einstellungen,                  /* Einstellungen          */
		std_Untereintraege                  /* Untereintrge anzeigen */
	}
}

METHOD std_Einstellungen
{
	LABEL		[menu_Options_Properties];
	DEFINITION
	{
	}
}

METHOD std_Untereintraege
{
	LABEL		[menu_Options_Subitems];
	DEFINITION
	{
	}
}

/*----------------------------------------------------------------------------*/
/*    Menu: Help													          */
/*----------------------------------------------------------------------------*/
MENU Menu_Help /* Hilfe */
{
	LABEL		[menu_Help];
	ITEMS
	{
		std_Hilfethemen,            /* Hilfethemen            */
		std_HilfeKontext,           /* Hilfe zum Kontext      */
		SEPARATOR,                  /* ---------------------- */
		std_HilfeGeraet,            /* Hilfe zum Gert        */
		SEPARATOR,
		methodOpenDeviceManual,
		SEPARATOR,                  /* ---------------------- */
		std_HilfeEinfuehrung,       /* Einfhrung             */
		std_HilfeErsteSchritte,     /* Erste Schritte         */
		SEPARATOR,                  /* ---------------------- */
		std_Hilfebenutzen,          /* Hilfe benutzen         */
		std_Info                    /* Info                   */
	}
}

METHOD std_Hilfethemen
{
	LABEL		[menu_Help_Topics];
	DEFINITION
	{
	}
}

METHOD std_HilfeKontext
{
	LABEL		[menu_Help_Context];
	DEFINITION
	{
	}
}

METHOD std_HilfeGeraet
{
	LABEL		[menu_Help_Device];
	DEFINITION
	{
	}
}

METHOD std_HilfeEinfuehrung
{
	LABEL		[menu_Help_Introduction];
	DEFINITION
	{
	}
}

METHOD std_HilfeErsteSchritte
{
	LABEL		[menu_Help_First_Steps];
	DEFINITION
	{
	}
}

METHOD std_Hilfebenutzen
{
	LABEL		[menu_Help_Using];
	DEFINITION
	{
	}
}

METHOD std_Info
{
	LABEL		[menu_Help_Info];
	DEFINITION
	{
	}
}

/******************************************************************************/
/*  	Online-Windows                                                        */
/******************************************************************************/
/* Ansicht - Messwertanzeige **************************************************/
MENU OnlineWindow_display
{
	LABEL		[menu_dialog_display];
	ITEMS
	{
		Page_display_measure,
		Page_display_out,
		Page_display_state,
		Page_display_statistic
	}
}

MENU Page_display_measure
{
	LABEL		[menu_dialog_display_measure];
	ITEMS
	{
        Page_group_display_measure_x,
        Page_group_display_measure_w,
        Page_group_display_checkback
	}
}

MENU Page_group_display_measure_x
{
	LABEL		"";
	ITEMS
	{
    	Val_pv,           /* Grossanzeige */
		Bar_pv_display,   /* Bargraph    */
		func1_readback_status,
		func1_readback_status_limit,
		SEPARATOR,
		func1_setpoint_deviation,
		func1_position_discrete_value
	}
}

MENU Page_group_display_measure_w
{
	LABEL		"";
	ITEMS
	{
    	Val_sp,          /* Grossanzeige */
		Bar_sp_display,  /* Bargraph    */
		func1_setpoint_status			(READ_ONLY),
		func1_setpoint_status_limit     (READ_ONLY),
		SEPARATOR,
		func1_pv_lower_range_value		(READ_ONLY),
		func1_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Page_group_display_checkback
{
	LABEL		"";
	ITEMS
	{
		func1_check_back
	}
}

MENU Bar_pv_display /* Bargraph */
{
	LABEL		" ";
	ITEMS
	{
		func1_readback_value,
		func1_pv_lower_range_value		(READ_ONLY),
		func1_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Bar_sp_display /* Bargraph */
{
	LABEL		" ";
	ITEMS
	{
		func1_setpoint_value			(READ_ONLY),
		func1_pv_lower_range_value		(READ_ONLY),
		func1_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Val_pv /* Grossanzeige */
{
    LABEL     "Controlled variable X"
              "|de|Regelgre X";
	ITEMS
	{
		func1_readback_value
	}
}

MENU Val_sp /* Grossanzeige */
{
    LABEL     "Reference variable W"
              "|de|Fhrungsgre W";
	ITEMS
	{
		func1_setpoint_value
	}
}

MENU Page_display_out
{
	LABEL		[menu_dialog_display_output];
	ITEMS
	{
        Page_group_display_out
	}
}

MENU Page_group_display_out
{
	LABEL		"";
	ITEMS
	{
		Bar_out_display,    /* Bargraph    */
		func1_out_value					(READ_ONLY),
		func1_out_status				(READ_ONLY),
		func1_out_lower_range_value		(READ_ONLY),
		func1_out_upper_range_value		(READ_ONLY),
		func1_check_back
	}
}

MENU Bar_out_display /* Bargraph */
{
	LABEL		[func_out_value];
	ITEMS
	{
		func1_out_value					(READ_ONLY),
		func1_out_lower_range_value		(READ_ONLY),
		func1_out_upper_range_value		(READ_ONLY)
	}
}

MENU Page_display_state
{
	LABEL		"Status"
	            "|de|Status";
	ITEMS
	{
        Page_group_display_state
	}
}

MENU Page_group_display_state
{
	LABEL		"";
	ITEMS
	{
	   trans1_binary_input,
	   func1_check_back,
	   phys_diagnosis,
       phys_diagnosis_extension,
	   func1_actual_mode,
	   trans1_transducer_state
	}
}

MENU Page_display_statistic
{
	LABEL		[menu_dialog_display_statistic];
	ITEMS
	{
        Page_group_display_statistic
	}
}

MENU Page_group_display_statistic
{
	LABEL		"";
	ITEMS
	{
		trans1_total_valve_travel,
		trans1_total_valve_travel_limit	(READ_ONLY)
	}
}

/* Ansicht - y-t Diagram *****************************************************/
MENU OnlineWindow_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
			Page_process_yt
	}
}

MENU Page_process_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Val_yt,
		Val_yt_2,
		OCX_out_display_yt
	}
}

MENU Val_yt
{
	LABEL   "Controlled variable X"
			"|de|Regelgre X";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
			func1_readback_value (READ_ONLY)
	}
}

MENU Val_yt_2
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
			func1_setpoint_value (READ_ONLY)
	}
}

MENU OCX_out_display_yt								/* OCX-Control */
{
	LABEL		[menu_yt_diagram] ;
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		/* Name, unter dem das OCX in Windows registriert ist */
	ITEMS
	{
		OCX_ProfilNum_yt,							/* Profil-Nummer */
		OCX_out_display_1,							/* 1. Kurve */
		OCX_out_display_2,							/* 2. Kurve */
		OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
	}
}

MENU OCX_out_display_1								/* 1. Kurve im OCX-Control yt */
{
	LABEL   "Controlled variable X"
			"|de|Regelgre X";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		func1_readback_value            (READ_ONLY),
		func1_pv_lower_range_value		(READ_ONLY),
		func1_pv_upper_range_value		(READ_ONLY)
	}
}

MENU OCX_out_display_2								/* 1. Kurve im OCX-Control yt */
{
  LABEL     "Reference variable W"
            "|de|Fhrungsgre W";

	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		func1_setpoint_value            (READ_ONLY),
		func1_pv_lower_range_value		(READ_ONLY),
		func1_pv_upper_range_value		(READ_ONLY)
	}
}

VARIABLE OCX_ProfilNum_yt							/* Profil-Variable fr OCX yt */
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	0;							/* Profil 0 fr normale y-t-Darstellung */
	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}

/* Ansicht - Gertezustand ***************************************************/
MENU OnlineWindow_diagnosis
{
	LABEL		[menu_dialog_diagnosis];
	ITEMS
	{
		Page_diagnosis_general,
		Page_diagnosis_phys_block,
		Page_diagnosis_trans_block,
		Page_diagnosis_func_block
	}
}

MENU Page_diagnosis_general
{
	LABEL		[menu_dialog_general];
	ITEMS
	{
        Page_group_diagnosis_general
	}
}

MENU Page_group_diagnosis_general
{
	LABEL		"";
	ITEMS
	{
		phys_tag_desc			(READ_ONLY),
		phys_manufacturer_id,
		phys_device_id,
		phys_serial_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date		(READ_ONLY),
		phys_diagnosis
	}
}

MENU Page_diagnosis_phys_block
{
	LABEL		[blk_block_object_PHYSICAL];
	ITEMS
	{
        Page_group_diagnosis_phys_block
	}
}

MENU Page_group_diagnosis_phys_block
{
	LABEL		"";
	ITEMS
	{
		phys_blk_object,
		phys_blk_parent_class,
		phys_blk_class,
		phys_blk_dd_reference,
		phys_blk_dd_rev,
		phys_blk_profile,
		phys_blk_profile_rev,
		phys_st_rev,
		phys_actual_mode
	}
}

MENU Page_diagnosis_trans_block
{
	LABEL		[blk_block_object_TRANSDUCER];
	ITEMS
	{
        Page_group_diagnosis_trans_block
	}
}

MENU Page_group_diagnosis_trans_block
{
	LABEL		"";
	ITEMS
	{
		trans1_blk_object,
		trans1_blk_parent_class,
		trans1_blk_class,
		trans1_blk_dd_reference,
		trans1_blk_dd_rev,
		trans1_blk_profile,
		trans1_blk_profile_rev,
		trans1_st_rev,
		trans1_actual_mode
	}
}

MENU Page_diagnosis_func_block
{
	LABEL		[blk_block_object_FUNCTION];
	ITEMS
	{
        Page_group_diagnosis_func_block
	}
}

MENU Page_group_diagnosis_func_block
{
	LABEL		"";
	ITEMS
	{
		func1_blk_object,
		func1_blk_parent_class,
		func1_blk_class,
		func1_blk_dd_reference,
		func1_blk_dd_rev,
		func1_blk_profile,
		func1_blk_profile_rev,
		func1_st_rev,
		func1_actual_mode
	}
}

/******************************************************************************/
/*   	Online-Dialogs                                                        */
/******************************************************************************/
/* Gert - Betrieb ***********************************************************/
MENU OnlineDialog_operation
{
	LABEL		[menu_dialog_operation];
	ITEMS
	{
		Page_operation_AUTO,
/* kmr:		Page_operation_RCAS,*/
		Page_operation_LO,
		Page_simulation
	}
}

MENU Page_operation_AUTO
{
	LABEL		[mode_AUTO];
	ITEMS
	{
        Page_group_operation_AUTO
	}
}

MENU Page_group_operation_AUTO
{
	LABEL		"";
	ITEMS
	{
		func1_target_mode,
		func1_actual_mode,
		func1_setpoint_value,
		func1_setpoint_status,
		func1_setpoint_status_limit,
		func1_readback_value,
		func1_readback_status,
		func1_readback_status_limit,
		func1_setpoint_deviation,
		func1_check_back
	}
}

/* kmr:
MENU Page_operation_RCAS
{
	LABEL		[mode_RCAS];
	ITEMS
	{
		func1_target_mode,
		func1_actual_mode,
		func1_rcas_in_value		(READ_ONLY),
		func1_rcas_in_status	(READ_ONLY),
		func1_readback_value,
		func1_readback_status,
		func1_readback_status_limit,
		func1_setpoint_deviation,
		func1_check_back
	}
}
*/
MENU Page_operation_LO
{
	LABEL		[mode_LO];
	ITEMS
	{
        Page_group_operation_LO
	}
}

MENU Page_group_operation_LO
{
	LABEL		"";
	ITEMS
	{
		func1_target_mode,
		func1_actual_mode,
		func1_out_value,
		func1_out_status,
		func1_readback_value,
		func1_readback_status,
		func1_readback_status_limit,
		func1_setpoint_deviation,
		func1_check_back
	}
}

MENU Page_simulation
{
	LABEL		[menu_dialog_simulation];
	ITEMS
	{
        Page_group_operation_simulation
	}
}

MENU Page_group_operation_simulation
{
	LABEL		"";
	ITEMS
	{
		func1_simulation_enabled,
		func1_simulate_value,
		func1_simulate_status
	}
}

/* Gert - Rcksetzen ********************************************************/
MENU OnlineDialog_reset
{
	LABEL		[master_reset];
	ITEMS
	{
		Page_reset_maintenance,
		Page_reset_device,
		Page_reset_factory
	}
	HELP		[master_reset_help];
}

MENU Page_reset_maintenance
{
	LABEL		"Reset maintenance message"
	            "|de|Rcksetzen Wartungsmeldung";
	ITEMS
	{
        Page_group_reset_maintenance
	}
}

MENU Page_group_reset_maintenance
{
	LABEL		"";
	ITEMS
	{
		func1_check_back,
		phys_diagnosis,
		trans1_total_valve_travel,
        wegint_reset,
        rk_stoer_reset
	}
}

MENU Page_reset_device
{
	LABEL		[phys_device_reset_cmd];
	ITEMS
	{
        Page_group_reset_device
	}
}

MENU Page_group_reset_device
{
	LABEL		"";
	ITEMS
	{
		func1_check_back,
		phys_diagnosis,
		warmstart
	}
}

MENU Page_reset_factory
{
	LABEL		[phys_factory_reset];
	ITEMS
	{
        Page_group_reset_factory
	}
}

MENU Page_group_reset_factory
{
	LABEL		"";
	ITEMS
	{
		func1_check_back,
		phys_diagnosis,
        coldstart_appl,
        coldstart_ident
	}
}

/* Gert - Selbstkalibrierung ************************************************/
MENU OnlineDialog_self_calibration
{
	LABEL		[trans_act_self_calibration_cmd];
	ITEMS
	{
        Page_self_calibration
	}
	HELP		[trans_act_self_calibration_cmd_help];
}

MENU Page_self_calibration
{
	LABEL		[trans_act_self_calibration_cmd];
	ITEMS
	{
        Page_group_self_calibration
	}
}

MENU Page_group_self_calibration
{
	LABEL		"";
	ITEMS
	{
		trans1_self_calibration_status,
		trans1_self_calib_warning,
		func1_check_back,
		phys_diagnosis,
		abort_initialization, /* Methode */
        cal_zero_valve,       /* Methode */
        init_valve            /* Methode */
	}
}

/******************************************************************************/
/*    Table: Specialist (Parametertabelle fr Spezialistenebene)              */
/******************************************************************************/
MENU Table_Main_Specialist
{
	LABEL	"SAMSON Positioner Type 3785"
			"|de|SAMSON Stellungsregler Typ 3785";
	ITEMS
	{
		Tab_s_ident,
		Tab_s_input,
		Tab_s_charact,
		Tab_s_adjustment,
		Tab_s_interface,
		Tab_s_certificates
	}
}

/* Identifikation ************************************************************/
MENU Tab_s_ident
{
	LABEL		[menu_ident];

	ITEMS
	{
		Tab_s_ident_opunit,
		Tab_s_ident_device
	}
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_s_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		phys_tag_desc,
		phys_descriptor,
		phys_message,
		phys_text_input_1,
		phys_text_input_2,
		phys_text_input_3
	}
}

/* Identifikation - Gert ****************************************************/
MENU Tab_s_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		Tab_s_ident_device_positioner,
		Tab_s_ident_device_actuator,
		Tab_s_ident_device_valve,
		Tab_s_ident_device_gear
	}
}

/* Identifikation - Gert - Stellungsregler **********************************/
MENU Tab_s_ident_device_positioner
{
	LABEL		[menu_ident_device_positioner];
	ITEMS
	{
		phys_manufacturer_id,
		phys_serial_num,
		phys_device_product_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date,
		phys_st_rev
	}
}

/* Identifikation - Gert - Stellantrieb *************************************/
MENU Tab_s_ident_device_actuator
{
	LABEL		[menu_ident_device_actuator];
	ITEMS
	{
		phys_actuator_man,
		phys_actuator_type,
		phys_actuator_serial_number
	}
}

/* Identifikation - Gert - Stellglied ***************************************/
MENU Tab_s_ident_device_valve
{
	LABEL		[menu_ident_device_valve];
	ITEMS
	{
		phys_valve_man,
		phys_valve_serial_number,
		phys_valve_type            (READ_ONLY),
        trans1_rated_travel_value  (READ_ONLY)
	}
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_s_ident_device_gear
{
	LABEL		[menu_ident_device_addition];
	ITEMS
	{
		phys_ident_binary_input,
		phys_ident_limit_switches,
		phys_ident_forced_venting,
		phys_write_protect_switch
	}
}

/* Eingang - *****************************************************************/
MENU Tab_s_input
{
	LABEL		[menu_input];
	ITEMS
	{
		Tab_s_input_input,
		Tab_s_input_workrange,
		Tab_s_input_table
	}
}

/* Eingang - Eingangsgrsse ***************************************************/
MENU Tab_s_input_input
{
	LABEL		[menu_input_input];
	ITEMS
	{
		func1_increase_close,
		func1_pv_lower_range_value,
		func1_pv_upper_range_value,
		func1_pv_unit,
		trans1_setp_cutoff_dec,
		trans1_setp_cutoff_inc
	}
}

/* Eingang - Arbeitsbereich **************************************************/
MENU Tab_s_input_workrange
{
	LABEL		[menu_input_workrange];
	ITEMS
	{
		func1_out_lower_range_value,
		func1_out_upper_range_value,
		func1_out_unit,
		trans1_travel_limit_lower_value,
		trans1_travel_limit_upper_value
	}
}

/* Eingang - Kennlinie *******************************************************/
MENU Tab_s_input_table
{
	LABEL		[menu_input_table];
	ITEMS
	{
		trans1_characteristic_value
	}
}

/* Kennwerte - ***************************************************************/
MENU Tab_s_charact
{
	LABEL		[menu_charact];
	ITEMS
	{
		trans1_deadband,
		trans1_servo_gain,
		trans1_kp_y2,
		trans1_servo_rate,
		trans1_tol_overshoot,
		Tab_s_charact_powerloss,
		Tab_s_charact_traveltime,
		Tab_s_charact_error
	}
}

/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_s_charact_powerloss
{
	LABEL		[menu_charact_powerloss];
	ITEMS
	{
		phys_actuator_action,
		func1_fsafe_type,
		func1_fsafe_time,
		func1_fsafe_value
	}
}

/* Kennwerte - Stellzeit *****************************************************/
MENU Tab_s_charact_traveltime
{
	LABEL		[menu_charact_traveltime];
	ITEMS
	{
		trans1_act_stroke_time_dec,
		trans1_act_stroke_time_inc,
		trans1_travel_rate_dec,
		trans1_travel_rate_inc
	}
}

/* Kennwerte - Fehlerberwachung *********************************************/
MENU Tab_s_charact_error
{
	LABEL		"Error monitoring"
	            "|de|Fehlerberwachung";
	ITEMS
	{
		trans1_tolerance_band,
		trans1_delay_time,
		trans1_total_valve_travel,
		trans1_total_valve_travel_limit
	}
}

/* Inbetriebnahme ************************************************************/
MENU Tab_s_adjustment
{
	LABEL		"Adjustment"
	            "|de|Inbetriebnahme";
	ITEMS
	{
	   phys_valve_type,
	   phys_attachment_value,
	   phys_actuator_version,
       trans1_rated_travel_value,
	   trans1_transm_code_value,
	   trans1_transm_length,
	   trans1_transm_pin_pos,
	   trans1_init_method,
	   phys_mounting_position,
	   trans1_self_calib_warning,
	   phys_actuator_action,
	   trans1_act_stroke_time_dec,
	   trans1_act_stroke_time_inc,
	   trans1_max_hub
	}
}

/* Anzeige- und Bedienoberflche *********************************************/
MENU Tab_s_interface
{
	LABEL		[menu_interface];
	ITEMS
	{
		trans1_local_operation_enable,
		Tab_s_interface_maintenance,
		Tab_s_interface_simulate
	}
}

/* Anzeige- und Bedienoberflche - Wartung ***********************************/
MENU Tab_s_interface_maintenance
{
	LABEL		[menu_interface_maintenance];
	ITEMS
	{
		trans1_device_calib_date,
		trans1_device_config_date,
		trans1_valve_maintenance_date
	}
}

/* Anzeige- und Bedienoberflche - Simulation ********************************/
MENU Tab_s_interface_simulate
{
	LABEL		[menu_interface_simulate];
	ITEMS
	{
		func1_simulation_enabled	(READ_ONLY),
		func1_simulate_value		(READ_ONLY),
		func1_simulate_status		(READ_ONLY)
	}
}

/* Zertifikate und Zulassungen ***********************************************/
MENU Tab_s_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		phys_device_certification
	}
}

/*******************************************************************************/
/*     Table: Maintenance (Parametertabelle fr Instandhalterebene)            */
/*******************************************************************************/
MENU Table_Main_Maintenance
{
	LABEL	"SAMSON Positioner Type 3785"
			"|de|SAMSON Stellungsregler Typ 3785";
	ITEMS
	{
		Tab_m_ident,
		Tab_m_input,
		Tab_m_charact,
		Tab_m_certificates
	}
}

/* Identifikation ************************************************************/
MENU Tab_m_ident
{
	LABEL		[menu_ident];

	ITEMS
	{
		Tab_m_ident_opunit,
		Tab_m_ident_device
	}
}

/* Identifikation - Betriebseinheit ******************************************/
MENU Tab_m_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		phys_tag_desc,
		phys_descriptor,
		phys_message,
		phys_text_input_1,
		phys_text_input_2,
		phys_text_input_3
	}
}

/* Identifikation - Gert ****************************************************/
MENU Tab_m_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		Tab_m_ident_device_positioner,
		Tab_m_ident_device_actuator,
		Tab_m_ident_device_valve,
		Tab_m_ident_device_gear
	}
}

/* Identifikation - Gert - Stellungsregler **********************************/
MENU Tab_m_ident_device_positioner
{
	LABEL		[menu_ident_device_positioner];
	ITEMS
	{
		phys_manufacturer_id,
		phys_serial_num,
		phys_device_product_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date,
		phys_st_rev
	}
}

/* Identifikation - Gert - Stellantrieb *************************************/
MENU Tab_m_ident_device_actuator
{
	LABEL		[menu_ident_device_actuator];
	ITEMS
	{
		phys_actuator_man			(READ_ONLY),
		phys_actuator_type			(READ_ONLY),
		phys_actuator_serial_number
	}
}

/* Identifikation - Gert - Stellglied ***************************************/
MENU Tab_m_ident_device_valve
{
	LABEL		[menu_ident_device_valve];
	ITEMS
	{
		phys_valve_man            (READ_ONLY),
		phys_valve_serial_number,
		phys_valve_type           (READ_ONLY),
	    phys_attachment_value     (READ_ONLY),
	    phys_actuator_version     (READ_ONLY),
        trans1_rated_travel_value (READ_ONLY),
	    trans1_transm_code_value  (READ_ONLY),
	    trans1_transm_length      (READ_ONLY),
	    trans1_transm_pin_pos     (READ_ONLY),
	    phys_mounting_position    (READ_ONLY),
	    phys_actuator_action
	}
}

/* Identifikation - Gert - Zusatzkomponente *********************************/
MENU Tab_m_ident_device_gear
{
	LABEL		[menu_ident_device_addition];
	ITEMS
	{
		phys_ident_binary_input   (READ_ONLY),
		phys_ident_limit_switches (READ_ONLY),
		phys_ident_forced_venting,
		phys_write_protect_switch
	}
}

/* Eingang - *****************************************************************/
MENU Tab_m_input
{
	LABEL		[menu_input];
	ITEMS
	{
		Tab_m_input_input,
		Tab_m_input_workrange,
		Tab_m_input_table
	}
}

/* Eingang - Eingangsgrsse **************************************************/
MENU Tab_m_input_input
{
	LABEL		[menu_input_input];
	ITEMS
	{
		func1_increase_close,
		func1_pv_lower_range_value,
		func1_pv_upper_range_value,
		func1_pv_unit
	}
}

/* Eingang - Arbeitsbereich **************************************************/
MENU Tab_m_input_workrange
{
	LABEL		[menu_input_workrange];
	ITEMS
	{
		func1_out_lower_range_value,
		func1_out_upper_range_value,
		func1_out_unit,
		trans1_travel_limit_lower_value,
		trans1_travel_limit_upper_value
	}
}

/* Eingang - Kennlinie *******************************************************/
MENU Tab_m_input_table
{
	LABEL		[menu_input_table];
	ITEMS
	{
		trans1_characteristic_value
	}
}

/* Kennwerte *****************************************************************/
MENU Tab_m_charact
{
	LABEL		[menu_charact];
	ITEMS
	{
		Tab_m_charact_powerloss
	}
}

/* Kennwerte - Ausfallverhalten **********************************************/
MENU Tab_m_charact_powerloss
{
	LABEL		[menu_charact_powerloss];
	ITEMS
	{
		phys_actuator_action
	}
}

/* Zertifikate und Zulassungen ***********************************************/
MENU Tab_m_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		phys_device_certification
	}
}

/******************************************************************************/
/*   	Communication Error Handling                                          */
/******************************************************************************/
VARIABLE CommError_0000_009F
{
	LABEL		[comm_err_dp_error_reserved];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_error_reserved_help];
}

VARIABLE CommError_00A0_00A0
{
	LABEL		[comm_err_dp_read_error];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_read_error_help];
}

VARIABLE CommError_00A1_00A1
{
	LABEL		[comm_err_dp_write_error];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_write_error_help];
}

VARIABLE CommError_00A2_00A2
{
	LABEL		[comm_err_dp_module_failure];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_module_failure_help];
}

VARIABLE CommError_00A3_00A7
{
	LABEL		[comm_err_dp_application_reserved];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_application_reserved_help];
}

VARIABLE CommError_00A8_00A8
{
	LABEL		[comm_err_dp_version_conflict];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_version_conflict_help];
}

VARIABLE CommError_00A9_00A9
{
	LABEL		[comm_err_dp_feature_not_supported];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_feature_not_supported_help];
}

VARIABLE CommError_00AA_00AF
{
	LABEL		[comm_err_dp_application_user_specific];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_application_user_specific_help];
}

VARIABLE CommError_00B0_00B0
{
	LABEL		[comm_err_dp_invalid_index];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_invalid_index_help];
}

VARIABLE CommError_00B1_00B1
{
	LABEL		[comm_err_dp_write_length_error];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_write_length_error_help];
}

VARIABLE CommError_00B2_00B2
{
	LABEL		[comm_err_dp_invalid_slot];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_invalid_slot_help];
}

VARIABLE CommError_00B3_00B3
{
	LABEL		[comm_err_dp_type_conflict];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_type_conflict_help];
}

VARIABLE CommError_00B4_00B4
{
	LABEL		[comm_err_dp_invalid_area];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_invalid_area_help];
}

VARIABLE CommError_00B5_00B5
{
	LABEL		[comm_err_dp_state_conflict];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_state_conflict_help];
}

VARIABLE CommError_00B6_00B6
{
	LABEL		[comm_err_dp_access_denied];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_access_denied_help];
}

VARIABLE CommError_00B7_00B7
{
	LABEL		[comm_err_dp_invalid_range];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_invalid_range_help];
}

VARIABLE CommError_00B8_00B8
{
	LABEL		[comm_err_dp_invalid_parameter];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_invalid_parameter_help];
}

VARIABLE CommError_00B9_00B9
{
	LABEL		[comm_err_dp_invalid_type];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_invalid_type_help];
}

VARIABLE CommError_00BA_00BF
{
	LABEL		[comm_err_dp_access_user_specific];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_access_user_specific_help];
}

VARIABLE CommError_00C0_00C0
{
	LABEL		[comm_err_dp_read_constrain_conflict];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_read_constrain_conflict_help];
}

VARIABLE CommError_00C1_00C1
{
	LABEL		[comm_err_dp_write_constrain_conflict];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_write_constrain_conflict_help];
}

VARIABLE CommError_00C2_00C2
{
	LABEL		[comm_err_dp_resource_busy];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_resource_busy_help];
}

VARIABLE CommError_00C3_00C3
{
	LABEL		[comm_err_dp_resource_unavailable];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_resource_unavailable_help];
}

VARIABLE CommError_00C4_00C7
{
	LABEL		[comm_err_dp_resource_reserved];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_resource_reserved_help];
}

VARIABLE CommError_00C8_00CF
{
	LABEL		[comm_err_dp_recource_user_specific];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_recource_user_specific_help];
}

VARIABLE CommError_00D0_00FF
{
	LABEL		[comm_err_dp_user_specific];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [ignore]	},
		{ 1, [check]	}
	}
	HELP		[comm_err_dp_user_specific_help];
}

VARIABLE CommError_ShowIgnoredErrors
{
	LABEL		[comm_show_ignored_errors];
	CLASS		LOCAL;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{ 0, [comm_show_ignored_errors_NOT_SHOW]	},
		{ 1, [comm_show_ignored_errors_SHOW]		}
	}
	HELP		[comm_show_ignored_errors_help];
}

VARIABLE CommError_Delay_Read
{
	LABEL		[comm_delay_read];
	CLASS		LOCAL;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	CONSTANT_UNIT	[msec];
	HELP		[comm_delay_read_help];
}

VARIABLE CommError_Delay_Write
{
	LABEL		[comm_delay_write];
	CLASS		LOCAL;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	CONSTANT_UNIT	[msec];
	HELP		[comm_delay_write_help];
}

MENU Menu_CommError
{
	LABEL	" ";
	ITEMS
	{
		CommError_0000_009F,			/* DP Error Reserved							*/
		CommError_00A0_00A0,			/* Application: DP Read Error					*/
		CommError_00A1_00A1,			/* Application: DP Write Error					*/
		CommError_00A2_00A2,			/* Application: DP Module Failure				*/
		CommError_00A3_00A7,			/* Application: DP Application Reserved			*/
		CommError_00A8_00A8,			/* Application: DP Version Conflict				*/
		CommError_00A9_00A9,			/* Application: DP Feature Not Supported		*/
		CommError_00AA_00AF,			/* Application:	DP Application User Specific	*/
		CommError_00B0_00B0,			/* Access:		DP Invalid Index				*/
		CommError_00B1_00B1,			/* Access:		DP Write Length Error			*/
		CommError_00B2_00B2,			/* Access:		DP Invalid Slot					*/
		CommError_00B3_00B3,			/* Access:		DP Type Conflict				*/
		CommError_00B4_00B4,			/* Access:		DP Invalid Area					*/
		CommError_00B5_00B5,			/* Access:		DP State Conflict				*/
		CommError_00B6_00B6,			/* Access:		DP Access Denied				*/
		CommError_00B7_00B7,			/* Access:		DP Invalid Range				*/
		CommError_00B8_00B8,			/* Access:		DP Invalid Parameter			*/
		CommError_00B9_00B9,			/* Access:		DP Invalid Type					*/
		CommError_00BA_00BF,			/* Access:		DP Access User Specific			*/
		CommError_00C0_00C0,			/* Resource:	DP Read Constrain Conflict		*/
		CommError_00C1_00C1,			/* Resource:	DP Write Constrain Conflict		*/
		CommError_00C2_00C2,			/* Resource:	DP Resource Busy				*/
		CommError_00C3_00C3,			/* Resource:	DP Resource unavailable			*/
		CommError_00C4_00C7,			/* Resource:	DP Resource Reserved			*/
		CommError_00C8_00CF,			/* Resource:	DP Recource User Specific		*/
		CommError_00D0_00FF				/* DP User Specific								*/
	}
}

MENU Menu_CommError_Delay
{
	LABEL	" ";
	ITEMS
	{
		CommError_Delay_Read,
		CommError_Delay_Write
	}
}


MENU OfflineDialog_CommErrorHandling
{
	LABEL 	[menu_dialog_error_handling];
	ITEMS
	{
		Page_CommError_General	/*,
		Page_CommError_Application,
		Page_CommError_Access,
		Page_CommError_Resource,
		Page_CommError_Other    */
	}
}

MENU Page_CommError_General
{
	LABEL 	[menu_dialog_general];
	ITEMS
	{
		CommError_Delay_Read,
		CommError_Delay_Write,
/*		CommError_ShowIgnoredErrors,	*/
		CommError_DefaultHandling	/*,
		CommError_CheckAllErrors,
		CommError_IgnoreAllErrors   */
	}
}

MENU Page_CommError_Application
{
	LABEL 	[menu_dialog_error_handling_application];
	ITEMS
	{
		CommError_00A0_00A0,	/* Application: DP Read Error					*/
		CommError_00A1_00A1,	/* Application: DP Write Error					*/
		CommError_00A2_00A2,	/* Application: DP Module Failure				*/
		CommError_00A3_00A7,	/* Application: DP Application Reserved			*/
		CommError_00A8_00A8,	/* Application: DP Version Conflict				*/
		CommError_00A9_00A9,	/* Application: DP Feature Not Supported		*/
		CommError_00AA_00AF		/* Application:	DP Application User Specific	*/
	}
}

MENU Page_CommError_Access
{
	LABEL 	[menu_dialog_error_handling_access];
	ITEMS
	{
		CommError_00B0_00B0,	/* Access:		DP Invalid Index				*/
		CommError_00B1_00B1,	/* Access:		DP Write Length Error			*/
		CommError_00B2_00B2,	/* Access:		DP Invalid Slot					*/
		CommError_00B3_00B3,	/* Access:		DP Type Conflict				*/
		CommError_00B4_00B4,	/* Access:		DP Invalid Area					*/
		CommError_00B5_00B5,	/* Access:		DP State Conflict				*/
		CommError_00B6_00B6,	/* Access:		DP Access Denied				*/
		CommError_00B7_00B7,	/* Access:		DP Invalid Range				*/
		CommError_00B8_00B8,	/* Access:		DP Invalid Parameter			*/
		CommError_00B9_00B9,	/* Access:		DP Invalid Type					*/
		CommError_00BA_00BF		/* Access:		DP Access User Specific			*/
	}
}

MENU Page_CommError_Resource
{
	LABEL 	[menu_dialog_error_handling_resource];
	ITEMS
	{
		CommError_00C0_00C0,	/* Resource:	DP Read Constrain Conflict		*/
		CommError_00C1_00C1,	/* Resource:	DP Write Constrain Conflict		*/
		CommError_00C2_00C2,	/* Resource:	DP Resource Busy				*/
		CommError_00C3_00C3,	/* Resource:	DP Resource unavailable			*/
		CommError_00C4_00C7,	/* Resource:	DP Resource Reserved			*/
		CommError_00C8_00CF		/* Resource:	DP Recource User Specific		*/
	}
}

MENU Page_CommError_Other
{
	LABEL 	[menu_dialog_error_handling_other];
	ITEMS
	{
		CommError_0000_009F,
		CommError_00D0_00FF
	}
}

METHOD	CommError_IgnoreAllErrors
{
	LABEL 		[comm_ignore_all_errors];
	DEFINITION
	{
		iassign(CommError_0000_009F, 0);	/* DP Error Reserved							*/
		iassign(CommError_00A0_00A0, 0);	/* Application: DP Read Error					*/
		iassign(CommError_00A1_00A1, 0);	/* Application: DP Write Error					*/
		iassign(CommError_00A2_00A2, 0);	/* Application: DP Module Failure				*/
		iassign(CommError_00A3_00A7, 0);	/* Application: DP Application Reserved			*/
		iassign(CommError_00A8_00A8, 0);	/* Application: DP Version Conflict				*/
		iassign(CommError_00A9_00A9, 0);	/* Application: DP Feature Not Supported		*/
		iassign(CommError_00AA_00AF, 0);	/* Application:	DP Application User Specific	*/
		iassign(CommError_00B0_00B0, 0);	/* Access:		DP Invalid Index				*/
		iassign(CommError_00B1_00B1, 0);	/* Access:		DP Write Length Error			*/
		iassign(CommError_00B2_00B2, 0);	/* Access:		DP Invalid Slot					*/
		iassign(CommError_00B3_00B3, 0);	/* Access:		DP Type Conflict				*/
		iassign(CommError_00B4_00B4, 0);	/* Access:		DP Invalid Area					*/
		iassign(CommError_00B5_00B5, 0);	/* Access:		DP State Conflict				*/
		iassign(CommError_00B6_00B6, 0);	/* Access:		DP Access Denied				*/
		iassign(CommError_00B7_00B7, 0);	/* Access:		DP Invalid Range				*/
		iassign(CommError_00B8_00B8, 0);	/* Access:		DP Invalid Parameter			*/
		iassign(CommError_00B9_00B9, 0);	/* Access:		DP Invalid Type					*/
		iassign(CommError_00BA_00BF, 0);	/* Access:		DP Access User Specific			*/
		iassign(CommError_00C0_00C0, 0);	/* Resource:	DP Read Constrain Conflict		*/
		iassign(CommError_00C1_00C1, 0);	/* Resource:	DP Write Constrain Conflict		*/
		iassign(CommError_00C2_00C2, 0);	/* Resource:	DP Resource Busy				*/
		iassign(CommError_00C3_00C3, 0);	/* Resource:	DP Resource unavailable			*/
		iassign(CommError_00C4_00C7, 0);	/* Resource:	DP Resource Reserved			*/
		iassign(CommError_00C8_00CF, 0);	/* Resource:	DP Recource User Specific		*/
		iassign(CommError_00D0_00FF, 0);	/* DP User Specific								*/
	}
	HELP		[comm_ignore_all_errors_help];
}

METHOD	CommError_CheckAllErrors
{
	LABEL 		[comm_check_all_errors];
	DEFINITION
	{
		iassign(CommError_0000_009F, 1);	/* DP Error Reserved							*/
		iassign(CommError_00A0_00A0, 1);	/* Application: DP Read Error					*/
		iassign(CommError_00A1_00A1, 1);	/* Application: DP Write Error					*/
		iassign(CommError_00A2_00A2, 1);	/* Application: DP Module Failure				*/
		iassign(CommError_00A3_00A7, 1);	/* Application: DP Application Reserved			*/
		iassign(CommError_00A8_00A8, 1);	/* Application: DP Version Conflict				*/
		iassign(CommError_00A9_00A9, 1);	/* Application: DP Feature Not Supported		*/
		iassign(CommError_00AA_00AF, 1);	/* Application:	DP Application User Specific	*/
		iassign(CommError_00B0_00B0, 1);	/* Access:		DP Invalid Index				*/
		iassign(CommError_00B1_00B1, 1);	/* Access:		DP Write Length Error			*/
		iassign(CommError_00B2_00B2, 1);	/* Access:		DP Invalid Slot					*/
		iassign(CommError_00B3_00B3, 1);	/* Access:		DP Type Conflict				*/
		iassign(CommError_00B4_00B4, 1);	/* Access:		DP Invalid Area					*/
		iassign(CommError_00B5_00B5, 1);	/* Access:		DP State Conflict				*/
		iassign(CommError_00B6_00B6, 1);	/* Access:		DP Access Denied				*/
		iassign(CommError_00B7_00B7, 1);	/* Access:		DP Invalid Range				*/
		iassign(CommError_00B8_00B8, 1);	/* Access:		DP Invalid Parameter			*/
		iassign(CommError_00B9_00B9, 1);	/* Access:		DP Invalid Type					*/
		iassign(CommError_00BA_00BF, 1);	/* Access:		DP Access User Specific			*/
		iassign(CommError_00C0_00C0, 1);	/* Resource:	DP Read Constrain Conflict		*/
		iassign(CommError_00C1_00C1, 1);	/* Resource:	DP Write Constrain Conflict		*/
		iassign(CommError_00C2_00C2, 1);	/* Resource:	DP Resource Busy				*/
		iassign(CommError_00C3_00C3, 1);	/* Resource:	DP Resource unavailable			*/
		iassign(CommError_00C4_00C7, 1);	/* Resource:	DP Resource Reserved			*/
		iassign(CommError_00C8_00CF, 1);	/* Resource:	DP Recource User Specific		*/
		iassign(CommError_00D0_00FF, 1);	/* DP User Specific								*/
	}
	HELP		[comm_check_all_errors_help];
}

METHOD	CommError_DefaultHandling
{
	LABEL 		[comm_default_handling];
	DEFINITION
	{
		lassign(CommError_Delay_Read,  0);	/* Delay after Read Command						*/
		lassign(CommError_Delay_Write, 0);	/* Delay after Write Command				    */
		iassign(CommError_0000_009F, 1);	/* DP Error Reserved							*/
		iassign(CommError_00A0_00A0, 1);	/* Application: DP Read Error					*/
		iassign(CommError_00A1_00A1, 1);	/* Application: DP Write Error					*/
		iassign(CommError_00A2_00A2, 1);	/* Application: DP Module Failure				*/
		iassign(CommError_00A3_00A7, 1);	/* Application: DP Application Reserved			*/
		iassign(CommError_00A8_00A8, 1);	/* Application: DP Version Conflict				*/
		iassign(CommError_00A9_00A9, 1);	/* Application: DP Feature Not Supported		*/
		iassign(CommError_00AA_00AF, 1);	/* Application:	DP Application User Specific	*/
		iassign(CommError_00B0_00B0, 0);	/* Access:		DP Invalid Index				*/
		iassign(CommError_00B1_00B1, 1);	/* Access:		DP Write Length Error			*/
		iassign(CommError_00B2_00B2, 0);	/* Access:		DP Invalid Slot					*/
		iassign(CommError_00B3_00B3, 1);	/* Access:		DP Type Conflict				*/
		iassign(CommError_00B4_00B4, 1);	/* Access:		DP Invalid Area					*/
		iassign(CommError_00B5_00B5, 0);	/* Access:		DP State Conflict				*/
		iassign(CommError_00B6_00B6, 0);	/* Access:		DP Access Denied				*/
		iassign(CommError_00B7_00B7, 0);	/* Access:		DP Invalid Range				*/
		iassign(CommError_00B8_00B8, 0);	/* Access:		DP Invalid Parameter			*/
		iassign(CommError_00B9_00B9, 1);	/* Access:		DP Invalid Type					*/
		iassign(CommError_00BA_00BF, 0);	/* Access:		DP Access User Specific			*/
		iassign(CommError_00C0_00C0, 1);	/* Resource:	DP Read Constrain Conflict		*/
		iassign(CommError_00C1_00C1, 1);	/* Resource:	DP Write Constrain Conflict		*/
		iassign(CommError_00C2_00C2, 1);	/* Resource:	DP Resource Busy				*/
		iassign(CommError_00C3_00C3, 1);	/* Resource:	DP Resource unavailable			*/
		iassign(CommError_00C4_00C7, 1);	/* Resource:	DP Resource Reserved			*/
		iassign(CommError_00C8_00CF, 1);	/* Resource:	DP Recource User Specific		*/
		iassign(CommError_00D0_00FF, 1);	/* DP User Specific								*/
	}
	HELP		[comm_default_handling_help];
}

/*******************************************************************************/
/*     Commands                                                                */
/*******************************************************************************/
MENU upload_variables    /* Parameter die in das Gert geschrieben werden */
{
	LABEL		[menu_load_to_device];
	ITEMS
	{
	/* PHYSICAL BLOCK, STANDARD PARAMETER	*/
        phys_tag_desc,
	/* PHYSICAL BLOCK, ADDITIONAL PARAMETER	*/
        phys_descriptor,
        phys_message,
        phys_install_date,
		phys_valve_man,
		phys_actuator_man,
		phys_valve_type,                    /* 1. (Reihenfolge einhalten) */
		phys_attachment_value,              /* 2. */
	    IF ( (phys_valve_type == HUBANTRIEB) && (phys_attachment_value == NAMUR) )
        {
			trans1_transm_length,           /* 4. */
			trans1_transm_pin_pos,          /* 5. */
        }
    	ELSE
        {
			trans1_transm_code_value,       /* 3. */
        }
		trans1_rated_travel_value,          /* 6. */
		trans1_init_method,                 /* 7. */
	    IF (phys_valve_type == HUBANTRIEB)
        {
			phys_mounting_position,
        }
		phys_valve_serial_number,
		phys_actuator_serial_number,
/*		phys_additional_gear_ser_number,
		phys_additional_gear_man,
		phys_additional_gear_id,
		phys_additional_gear_install_date,*/
	/* TRANDSDUCER BLOCK, STANDARD PARAMETER	*/
	/* TRANDSDUCER BLOCK, ADDITIONAL PARAMETER	*/
		trans1_deadband,
		trans1_device_calib_date,
		trans1_device_config_date,
		trans1_local_operation_enable,
		trans1_servo_gain,
		trans1_kp_y2,
		trans1_servo_rate,
		trans1_characteristic_value,
		trans1_setp_cutoff_dec,
		trans1_setp_cutoff_inc,
		trans1_total_valve_travel,
		trans1_total_valve_travel_limit,
		trans1_travel_limit_lower_value,
		trans1_travel_limit_upper_value,
		trans1_travel_rate_dec,
		trans1_travel_rate_inc,
		trans1_valve_maintenance_date,
	/* FUNCTION BLOCK, STANDARD PARAMETER		*/
	/* FUNCTION BLOCK, ADDITIONAL PARAMETER		*/
		func1_pv_upper_range_value,
		func1_pv_lower_range_value,
		func1_pv_unit,
		func1_fsafe_time,
		func1_fsafe_type,
		func1_fsafe_value,
		func1_increase_close,
		func1_out_upper_range_value,
		func1_out_lower_range_value,
		func1_out_unit,
		trans1_delay_time,
		trans1_tolerance_band,
		trans1_tol_overshoot,
		phys_actuator_version,
		phys_ident_binary_input,
		phys_ident_limit_switches,
		phys_text_input_1,
		phys_text_input_2,
		phys_text_input_3
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_blk
{
	BLOCK physical_block;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_blk_reserve, phys_blk_object, phys_blk_parent_class, phys_blk_class,
			phys_blk_dd_reference, phys_blk_dd_rev, phys_blk_profile, phys_blk_profile_rev,
			phys_blk_execution_time, phys_blk_highest_rel_offset, phys_blk_index_view_1,
			phys_blk_num_view_lists
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_st_rev
{
	BLOCK physical_block;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_st_rev
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_tag_desc
{
	BLOCK physical_block;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_tag_desc
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_tag_desc
{
	BLOCK physical_block;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_tag_desc
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_strategy
{
	BLOCK physical_block;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_strategy
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_strategy
{
	BLOCK physical_block;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_strategy
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_alert_key
{
	BLOCK physical_block;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_alert_key
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_alert_key
{
	BLOCK physical_block;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_alert_key
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_target_mode
{
	BLOCK physical_block;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_target_mode
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_target_mode
{
	BLOCK physical_block;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
		 	phys_target_mode
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_mode
{
	BLOCK physical_block;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 phys_actual_mode, phys_permitted_mode, phys_normal_mode
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_alarm
{
	BLOCK physical_block;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_current_state_alarm_sum, phys_unacknowledged_state_alarm_sum,
			phys_unreported_state_alarm_sum, phys_disabled_state_alarm_sum
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_software_rev
{
	BLOCK physical_block;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_software_rev
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_hardware_rev
{
	BLOCK physical_block;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_hardware_rev
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_manufacturer_id
{
	BLOCK physical_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_manufacturer_id
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_id
{
	BLOCK physical_block;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_id
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_serial_num
{
	BLOCK physical_block;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_serial_num
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis
{
	BLOCK physical_block;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_extension
{
	BLOCK physical_block;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_extension,
			dummy_byte,
			dummy_byte,
			dummy_byte,
			dummy_byte,
			dummy_byte
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_mask
{
	BLOCK physical_block;
	INDEX 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_mask
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_diagnosis_extension_mask
{
	BLOCK physical_block;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_extension_mask
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_certification
{
	BLOCK physical_block;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_certification
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_certification
{
	BLOCK physical_block;
	INDEX 17;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_device_certification
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_security_locking
{
	BLOCK physical_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_security_locking
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_security_locking
{
	BLOCK physical_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_security_locking
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_factory_reset
{
	BLOCK physical_block;
	INDEX 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_factory_reset
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_descriptor
{
	BLOCK physical_block;
	INDEX 30;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_descriptor
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_descriptor
{
	BLOCK physical_block;
	INDEX 30;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_descriptor
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_message
{
	BLOCK physical_block;
	INDEX 31;
	OPERATION  READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_message
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_message
{
	BLOCK physical_block;
	INDEX 31;
	OPERATION  WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_message
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_install_date
{
	BLOCK physical_block;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_install_date
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_install_date
{
	BLOCK physical_block;
	INDEX 32;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_install_date
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_valve_man
{
	BLOCK physical_block;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_valve_man
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_valve_man
{
	BLOCK physical_block;
	INDEX 33;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_valve_man
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_actuator_man
{
	BLOCK physical_block;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_actuator_man
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_actuator_man
{
	BLOCK physical_block;
	INDEX 34;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_actuator_man
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_valve_type
{
	BLOCK physical_block;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_valve_type
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_valve_type
{
	BLOCK physical_block;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_valve_type
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_actuator_type
{
	BLOCK physical_block;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_actuator_type
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_actuator_action
{
	BLOCK physical_block;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_actuator_action
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_actuator_action
{
	BLOCK physical_block;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_actuator_action
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_valve_serial_number
{
	BLOCK physical_block;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_valve_serial_number
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_valve_serial_number
{
	BLOCK physical_block;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_valve_serial_number
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_actuator_serial_number
{
	BLOCK physical_block;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_actuator_serial_number
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_actuator_serial_number
{
	BLOCK physical_block;
	INDEX 39;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_actuator_serial_number
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_additional_gear_ser_number
{
	BLOCK physical_block;
	INDEX 40;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_additional_gear_ser_number
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_additional_gear_ser_number
{
	BLOCK physical_block;
	INDEX 40;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_additional_gear_ser_number
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_additional_gear_man
{
	BLOCK physical_block;
	INDEX 41;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_additional_gear_man
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_additional_gear_man
{
	BLOCK physical_block;
	INDEX 41;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_additional_gear_man
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_additional_gear_id
{
	BLOCK physical_block;
	INDEX 42;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_additional_gear_id
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_additional_gear_id
{
	BLOCK physical_block;
	INDEX 42;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_additional_gear_id
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_additional_gear_install_date
{
	BLOCK physical_block;
	INDEX 43;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_additional_gear_install_date
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_additional_gear_install_date
{
	BLOCK physical_block;
	INDEX 43;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_additional_gear_install_date
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_blk
{
	BLOCK transducer_block_1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_blk_reserve, trans1_blk_object, trans1_blk_parent_class, trans1_blk_class,
			trans1_blk_dd_reference, trans1_blk_dd_rev, trans1_blk_profile, trans1_blk_profile_rev,
			trans1_blk_execution_time, trans1_blk_highest_rel_offset, trans1_blk_index_view_1,
			trans1_blk_num_view_lists
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_st_rev
{
	BLOCK transducer_block_1;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_st_rev
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tag_desc
{
	BLOCK transducer_block_1;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tag_desc
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tag_desc
{
	BLOCK transducer_block_1;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_tag_desc
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_strategy
{
	BLOCK transducer_block_1;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_strategy
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_strategy
{
	BLOCK transducer_block_1;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_strategy
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_alert_key
{
	BLOCK transducer_block_1;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_alert_key
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_alert_key
{
	BLOCK transducer_block_1;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_alert_key
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_target_mode
{
	BLOCK transducer_block_1;
	INDEX 5;
	OPERATION  READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_target_mode
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_target_mode
{
	BLOCK transducer_block_1;
	INDEX 5;
	OPERATION  WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_target_mode
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_mode
{
	BLOCK transducer_block_1;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 trans1_actual_mode, trans1_permitted_mode, trans1_normal_mode
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_alarm
{
	BLOCK transducer_block_1;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_current_state_alarm_sum, trans1_unacknowledged_state_alarm_sum,
			trans1_unreported_state_alarm_sum, trans1_disabled_state_alarm_sum
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_act_stroke_time_dec
{
	BLOCK transducer_block_1;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_act_stroke_time_dec
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_act_stroke_time_inc
{
	BLOCK transducer_block_1;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_act_stroke_time_inc
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_characteristic_value
{
	BLOCK transducer_block_1;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_characteristic_value, trans1_characteristic_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_characteristic_value
{
	BLOCK transducer_block_1;
	INDEX 17;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_characteristic_value, trans1_characteristic_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_characteristic_curve
{
	BLOCK transducer_block_1;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_characteristic_curve_index, trans1_characteristic_curve_input_value,
			trans1_characteristic_curve_output_value, trans1_characteristic_curve_lin_op_code
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_characteristic_curve
{
	BLOCK transducer_block_1;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_characteristic_curve_index, trans1_characteristic_curve_input_value,
			trans1_characteristic_curve_output_value, trans1_characteristic_curve_lin_op_code
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_characteristic_def_max
{
	BLOCK transducer_block_1;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_characteristic_def_max
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_characteristic_def_min
{
	BLOCK transducer_block_1;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_characteristic_def_min
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_lin_status
{
	BLOCK transducer_block_1;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_lin_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_deadband
{
	BLOCK transducer_block_1;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_deadband
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_deadband
{
	BLOCK transducer_block_1;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_deadband
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_calib_date
{
	BLOCK transducer_block_1;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_device_calib_date
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_calib_date
{
	BLOCK transducer_block_1;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_device_calib_date
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_config_date
{
	BLOCK transducer_block_1;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_device_config_date
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_config_date
{
	BLOCK transducer_block_1;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_device_config_date
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_local_operation_enable
{
	BLOCK transducer_block_1;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_local_operation_enable
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_local_operation_enable
{
	BLOCK transducer_block_1;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_local_operation_enable
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_rated_travel
{
	BLOCK transducer_block_1;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_rated_travel_value, trans1_rated_travel_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_rated_travel
{
	BLOCK transducer_block_1;
	INDEX 32;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_rated_travel_value, trans1_rated_travel_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calibration_cmd
{
	BLOCK transducer_block_1;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_self_calibration_cmd
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_self_calibration_cmd
{
	BLOCK transducer_block_1;
	INDEX 33;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_self_calibration_cmd
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_reset_cmd
{
	BLOCK transducer_block_1;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_self_reset_cmd
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_self_reset_cmd
{
	BLOCK transducer_block_1;
	INDEX 33;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_self_reset_cmd
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calibration_status
{
	BLOCK transducer_block_1;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_self_calibration_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_gain
{
	BLOCK transducer_block_1;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_servo_gain
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_gain
{
	BLOCK transducer_block_1;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_servo_gain
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_rate
{
	BLOCK transducer_block_1;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_servo_rate
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_rate
{
	BLOCK transducer_block_1;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_servo_rate
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_reset
{
	BLOCK transducer_block_1;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_servo_reset
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_reset
{
	BLOCK transducer_block_1;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_servo_reset
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_setp_cutoff_dec
{
	BLOCK transducer_block_1;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_setp_cutoff_dec
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_setp_cutoff_dec
{
	BLOCK transducer_block_1;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_setp_cutoff_dec
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_setp_cutoff_inc
{
	BLOCK transducer_block_1;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_setp_cutoff_inc
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_setp_cutoff_inc
{
	BLOCK transducer_block_1;
	INDEX 39;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_setp_cutoff_inc
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_total_valve_travel
{
	BLOCK transducer_block_1;
	INDEX 45;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_total_valve_travel
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_total_valve_travel
{
	BLOCK transducer_block_1;
	INDEX 45;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_total_valve_travel
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_total_valve_travel_limit
{
	BLOCK transducer_block_1;
	INDEX 46;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_total_valve_travel_limit
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_total_valve_travel_limit
{
	BLOCK transducer_block_1;
	INDEX 46;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_total_valve_travel_limit
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_limit_low
{
	BLOCK transducer_block_1;
	INDEX 47;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_travel_limit_lower_value, trans1_travel_limit_lower_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_limit_low
{
	BLOCK transducer_block_1;
	INDEX 47;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_travel_limit_lower_value, trans1_travel_limit_lower_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_limit_upper
{
	BLOCK transducer_block_1;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_travel_limit_upper_value, trans1_travel_limit_upper_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_limit_upper
{
	BLOCK transducer_block_1;
	INDEX 48;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_travel_limit_upper_value, trans1_travel_limit_upper_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_rate_dec
{
	BLOCK transducer_block_1;
	INDEX 49;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_travel_rate_dec
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_rate_dec
{
	BLOCK transducer_block_1;
	INDEX 49;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_travel_rate_dec
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_rate_inc
{
	BLOCK transducer_block_1;
	INDEX 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_travel_rate_inc
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_rate_inc
{
	BLOCK transducer_block_1;
	INDEX 50;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_travel_rate_inc
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_maintenance_date
{
	BLOCK transducer_block_1;
	INDEX 51;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_valve_maintenance_date
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_maintenance_date
{
	BLOCK transducer_block_1;
	INDEX 51;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_valve_maintenance_date
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_blk
{
	BLOCK function_block_1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_blk_reserve, func1_blk_object, func1_blk_parent_class, func1_blk_class,
			func1_blk_dd_reference, func1_blk_dd_rev, func1_blk_profile, func1_blk_profile_rev,
			func1_blk_execution_time, func1_blk_highest_rel_offset, func1_blk_index_view_1,
			func1_blk_num_view_lists
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_st_rev
{
	BLOCK function_block_1;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_st_rev
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_tag_desc
{
	BLOCK function_block_1;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_tag_desc
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_tag_desc
{
	BLOCK function_block_1;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_tag_desc
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_strategy
{
	BLOCK function_block_1;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_strategy
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_strategy
{
	BLOCK function_block_1;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_strategy
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_alert_key
{
	BLOCK function_block_1;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_alert_key
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_alert_key
{
	BLOCK function_block_1;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_alert_key
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_target_mode
{
	BLOCK function_block_1;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_target_mode
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_target_mode
{
	BLOCK function_block_1;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_target_mode
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_mode
{
	BLOCK function_block_1;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func1_actual_mode, func1_permitted_mode, func1_normal_mode
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_alarm
{
	BLOCK function_block_1;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_current_state_alarm_sum, func1_unacknowledged_state_alarm_sum,
			func1_unreported_state_alarm_sum, func1_disabled_state_alarm_sum
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_readback
{
	BLOCK function_block_1;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
            func1_readback_value,
            func1_readback_status           <0xFC>,
            func1_readback_status_limit     <0x03>
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_setpoint
{
	BLOCK function_block_1;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_setpoint_value,
            func1_setpoint_status           <0xFC>,
            func1_setpoint_status_limit     <0x03>
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_setpoint
{
	BLOCK function_block_1;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_setpoint_value,
            func1_setpoint_status           <0xFC>,
            func1_setpoint_status_limit     <0x03>
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_pv
{
	BLOCK function_block_1;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_pv_upper_range_value, func1_pv_lower_range_value,
			func1_pv_unit, func1_pv_decimal_point
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_pv
{
	BLOCK function_block_1;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_pv_upper_range_value, func1_pv_lower_range_value,
			func1_pv_unit, func1_pv_decimal_point
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_rcas_in
{
	BLOCK function_block_1;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_rcas_in_value, func1_rcas_in_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_rcas_in
{
	BLOCK function_block_1;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_rcas_in_value, func1_rcas_in_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_channel
{
	BLOCK function_block_1;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_channel
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_channel
{
	BLOCK function_block_1;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_channel
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_time
{
	BLOCK function_block_1;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_fsafe_time
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_time
{
	BLOCK function_block_1;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_fsafe_time
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_type
{
	BLOCK function_block_1;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_fsafe_type
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_type
{
	BLOCK function_block_1;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_fsafe_type
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_value
{
	BLOCK function_block_1;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_fsafe_value
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_value
{
	BLOCK function_block_1;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_fsafe_value
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_rcas_out
{
	BLOCK function_block_1;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_rcas_out_value, func1_rcas_out_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_current_position
{
	BLOCK function_block_1;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_position_discrete_value, func1_position_discrete_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_setpoint_deviation
{
	BLOCK function_block_1;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_setpoint_deviation
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back
{
	BLOCK function_block_1;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_check_back
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back_mask
{
	BLOCK function_block_1;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_check_back_mask
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_simulate
{
	BLOCK function_block_1;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_simulate_status, func1_simulate_value, func1_simulation_enabled
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_simulate
{
	BLOCK function_block_1;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_simulate_status, func1_simulate_value, func1_simulation_enabled
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_increase_close
{
	BLOCK function_block_1;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_increase_close
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_increase_close
{
	BLOCK function_block_1;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_increase_close
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out
{
	BLOCK function_block_1;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_out_value, func1_out_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out
{
	BLOCK function_block_1;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_out_value, func1_out_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out_scale
{
	BLOCK function_block_1;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_out_upper_range_value, func1_out_lower_range_value,
			func1_out_unit, func1_out_decimal_point
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out_scale
{
	BLOCK function_block_1;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_out_upper_range_value, func1_out_lower_range_value,
			func1_out_unit, func1_out_decimal_point
		}
		REPLY
		{
		}
	}
}

/*----------------------------------------------------------------------------*/
/*    Herstellerspezifische Commands                				          */
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transducer_state
{
	BLOCK transducer_block_1;
	INDEX 110;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_transducer_state
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_attachment
{
	BLOCK physical_block;
	INDEX 100;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_attachment_value, phys_attachment_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_attachment
{
	BLOCK physical_block;
	INDEX 100;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_attachment_value, phys_attachment_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_actuator_version
{
	BLOCK physical_block;
	INDEX 101;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_actuator_version
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_actuator_version
{
	BLOCK physical_block;
	INDEX 101;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_actuator_version
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_code
{
	BLOCK transducer_block_1;
	INDEX 100;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_transm_code_value, trans1_transm_code_status
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_code
{
	BLOCK transducer_block_1;
	INDEX 100;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_transm_code_value, trans1_transm_code_status
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_length
{
	BLOCK transducer_block_1;
	INDEX 101;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_transm_length
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_length
{
	BLOCK transducer_block_1;
	INDEX 101;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_transm_length
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_pin_pos
{
	BLOCK transducer_block_1;
	INDEX 102;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_transm_pin_pos
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_pin_pos
{
	BLOCK transducer_block_1;
	INDEX 102;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_transm_pin_pos
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_init_method
{
	BLOCK transducer_block_1;
	INDEX 103;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_init_method
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_init_method
{
	BLOCK transducer_block_1;
	INDEX 103;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_init_method
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_mounting_position
{
	BLOCK physical_block;
	INDEX 102;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_mounting_position
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_mounting_position
{
	BLOCK physical_block;
	INDEX 102;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_mounting_position
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calib_warning
{
	BLOCK transducer_block_1;
	INDEX 106;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_self_calib_warning
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_limit_switches
{
	BLOCK physical_block;
	INDEX 105;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ident_limit_switches
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_limit_switches
{
	BLOCK physical_block;
	INDEX 105;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_ident_limit_switches
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_forced_venting
{
	BLOCK physical_block;
	INDEX 103;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ident_forced_venting
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_charact_type
{
	BLOCK transducer_block_1;
	INDEX 112;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_charact_type
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_charact_type
{
	BLOCK transducer_block_1;
	INDEX 112;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_charact_type
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_max_hub
{
	BLOCK transducer_block_1;
	INDEX 108;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_max_hub
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_ident_binary_input
{
	BLOCK physical_block;
	INDEX 104;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ident_binary_input
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_ident_binary_input
{
	BLOCK physical_block;
	INDEX 104;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_ident_binary_input
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tolerance_band
{
	BLOCK transducer_block_1;
	INDEX 105;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tolerance_band
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tolerance_band
{
	BLOCK transducer_block_1;
	INDEX 105;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_tolerance_band
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_delay_time
{
	BLOCK transducer_block_1;
	INDEX 104;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_delay_time
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_delay_time
{
	BLOCK transducer_block_1;
	INDEX 104;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_delay_time
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_kp_y2
{
	BLOCK transducer_block_1;
	INDEX 111;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_kp_y2
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_kp_y2
{
	BLOCK transducer_block_1;
	INDEX 111;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_kp_y2
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tol_overshoot
{
	BLOCK transducer_block_1;
	INDEX 113;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_tol_overshoot
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tol_overshoot
{
	BLOCK transducer_block_1;
	INDEX 113;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans1_tol_overshoot
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_binary_input
{
	BLOCK transducer_block_1;
	INDEX 107;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans1_binary_input
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_write_protect_switch
{
	BLOCK physical_block;
	INDEX 109;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_write_protect_switch
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_reset_cmd
{
	BLOCK physical_block;
	INDEX 44;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_reset_cmd
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_device_reset_cmd
{
	BLOCK physical_block;
	INDEX 44;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_device_reset_cmd
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_device_product_num
{
	BLOCK physical_block;
	INDEX 106;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_product_num
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_text_input_1
{
	BLOCK physical_block;
	INDEX 110;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_text_input_1
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_1
{
	BLOCK physical_block;
	INDEX 110;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_text_input_1
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_text_input_2
{
	BLOCK physical_block;
	INDEX 111;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_text_input_2
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_2
{
	BLOCK physical_block;
	INDEX 111;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_text_input_2
		}
		REPLY
		{
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND read_phys_text_input_3
{
	BLOCK physical_block;
	INDEX 112;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_text_input_3
		}
	}
}
/*----------------------------------------------------------------------------*/
COMMAND write_phys_text_input_3
{
	BLOCK physical_block;
	INDEX 112;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_text_input_3
		}
		REPLY
		{
		}
	}
}
/*-- ENDE --------------------------------------------------------------------*/
